define(["angular", "app", "jquery", "lang.wizard", "notify"], function(ng, app, $) {

	function MlWizard($scope, $rootScope, $resource, $q, $timeout, $route, lang, $location, $window, Notify) {

		$scope.min_domains = 1;
		$scope.max_domains = 5;
		$scope.min_ips = 1;
		$scope.max_ips = 5;
		$scope.domains = [];
		$scope.ips = [];
		$scope.cur_domains = $scope.min_domains;
		$scope.cur_ips = $scope.min_ips;

		$scope.wz_model = {
			current_idx: 0,
			completed_tasks: [],
			forms: {},
			planning: ['hmm_settings', 'training_sample_settings', 'hmm_evaluation_settings', 'anomaly_detection_settings', 'attack_validation_settings', 'trigger_action_settings'],
			domains_collection: [],
			ips_collection: [],
			validation: {
				hmm_evaluation_settings: function() {
					if (isNaN($scope.form_data.box_notch_count) || $scope.form_data.box_notch_count < 1 || $scope.form_data.box_notch_count > 3 || ($scope.form_data.box_notch_count % 1 != 0)) {
						alert(lang('err_box_notch_count'));
						return false;
					}
					return true;
				},
				anomaly_detection_settings: function() {
					if ($scope.form_data.anomaly_detection_method == 0) {
						if (isNaN($scope.form_data.tolerance_potential) || $scope.form_data.tolerance_potential < 0 || $scope.form_data.tolerance_potential > 1) {
							alert(lang('err_tolerance_potential'));
							return false;
						}
						if ($scope.form_data.tolerance_potential * 10 % 1 != 0) {
							alert(lang('err_float_accuracy_t_potential') + factorCeil($scope.form_data.tolerance_potential) + lang('err_float_accuracy_body') + factorFloor($scope.form_data.tolerance_potential) + lang('err_float_accuracy_tail'));
							return false;
						}
						if (isNaN($scope.form_data.tolerance_definitely) || $scope.form_data.tolerance_definitely < 0 || $scope.form_data.tolerance_definitely > 0.9) {
							alert(lang('err_tolerance_definitely'));
							return false;
						}
						if ($scope.form_data.tolerance_definitely * 10 % 1 != 0) {
							alert(lang('err_float_accuracy_t_definite') + factorCeil($scope.form_data.tolerance_definitely) + lang('err_float_accuracy_body') + factorFloor($scope.form_data.tolerance_definitely) + lang('err_float_accuracy_tail'));
							return false;
						}
					} else {
						if (isNaN($scope.form_data.quantile_potential) || $scope.form_data.quantile_potential < 0 || $scope.form_data.quantile_potential > 1) {
							alert(lang('err_quantile_potential'));
							return false;
						}
						if ($scope.form_data.quantile_potential * 10 % 1 != 0) {
							alert(lang('err_float_accuracy_q_potential') + factorCeil($scope.form_data.quantile_potential) + lang('err_float_accuracy_body') + factorFloor($scope.form_data.quantile_potential) + lang('err_float_accuracy_tail'));
							return false;
						}
						if (isNaN($scope.form_data.quantile_definitely) || $scope.form_data.quantile_definitely < 0 || $scope.form_data.quantile_definitely > 1) {
							alert(lang('err_quantile_definitely'));
							return false;
						}
						if ($scope.form_data.quantile_definitely * 10 % 1 != 0) {
							alert(lang('err_float_accuracy_q_definite') + factorCeil($scope.form_data.quantile_definitely) + lang('err_float_accuracy_body') + factorFloor($scope.form_data.quantile_definitely) + lang('err_float_accuracy_tail'));
							return false;
						}

						// For quantile, potential factor must be greater than definite factor
						if ($scope.form_data.quantile_potential <= $scope.form_data.quantile_definitely) {
							alert(lang('err_quantile'));
							//Notify.post(lang('err_quantile'), 'error');
							return false;
						}
					}
					return true;
				}
			}
		};

		$scope.form_data = {
			hmm_engine: 1,
			automatic_refresh_model: 1,
			box_notch_count: 2,
			anomaly_detection_method: 0,
			tolerance_potential: 0.3,
			tolerance_definitely: 0.1,
			quantile_potential: 0.3,
			quantile_definitely: 0.1,
			attack_validation: 1,
			attack_validation_hidden: 0,
			action_protential: 2,
			action_definitely: 6,
			action_page_method: 6,
			app_change_sensitivity: 1,
			allow_domain: [],
			allow_ip: []
		};

		var i;
		for (i = 0; i < $scope.max_domains; i++) {
			$scope.domains[i] = i;
		}
		for (i = 0; i < $scope.max_ips; i++) {
			$scope.ips[i] = i;
		}

		$scope.page_title = 'ml_wizard';
		$scope.$timeout = $timeout;
		$scope.$route = $route;
		$scope.hide_footer_button = true;
		$scope.name = 'name';

		ng.forEach(this.scope_fns, function(fn, key) {
			if (ng.equals(key, "go")) {
				$scope[key] = fn.bind($scope, $location, $window);
			} else {
				$scope[key] = fn.bind($scope);
			}
		});

		$scope.remove_input = remove_input;
		$scope.add_input = add_input;

		// policy id
		var policy_id = get_query('policy_id'),
			mkey = get_query('mkey')
		if (!policy_id || !mkey) {
			document.location.href = "/prot/policy/list";
		}
		$scope.form_data.policy_id = policy_id;
		$scope.wz_model.return_url = "/prot/policy/dlgframe?mkey=" + mkey;

		function remove_input($index, name) {
			for (i = $index + 1; i < $scope['max_' + name]; i++) {
				$scope.wz_model[name + '_collection'][i - 1] = $scope.wz_model[name + '_collection'][i];
			}
			$scope.wz_model[name + '_collection'][i - 1] = '';
			$scope['cur_' + name] -= 1;
		}

		function add_input(name) {
			$scope['cur_' + name] += 1;
		}

		function get_query(name) {
			var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
			var r = document.location.search.substr(1).match(reg);
			if (r != null) 
				return unescape(r[2]); 
			return null;
		}

		function factorFloor(factor) {
			return (factor - (factor % 0.1)).toFixed(1);
		}

		function factorCeil(factor) {
			return (factor - (factor % 0.1) + 0.1).toFixed(1);
		}
	}

	MlWizard.prototype = {
		scope_fns: {

			show_next: function() {
				if (this.wz_model.custom_next) {
					this.wz_model.custom_next();
				} else {
					if (this.has_validation()) {
						var validator = this.wz_model.validation[this.wz_model.planning[this.wz_model.current_idx]]();
						if (!validator) return;
					}
					if (this.wz_model.current_idx < (this.wz_model.planning.length - 1)) {
						this.wz_model.current_idx += 1;
						this.step_changed();
					}
				}
			},

			show_prev: function() {
				if (this.wz_model.current_idx > 0) {
					this.wz_model.current_idx -= 1;
					this.step_changed();
				}
			},
			
			has_next: function() {
				return this.wz_model.current_idx < this.wz_model.planning.length - 1 || this.wz_model.custom_next;
			},

			has_prev: function() {
				return this.wz_model.current_idx > 0;
			},

			has_validation: function() {
				return this.wz_model.validation[this.wz_model.planning[this.wz_model.current_idx]] ? true: false;
			},

			is_done: function() {
				return this.wz_model.completed_tasks.length > 0;
			},

			is_first: function() {
				return !(this.has_prev());
			},

			is_last: function() {
				return !(this.has_next());
			},

			step_label: function(idx) {
				return (idx < this.wz_model.current_idx || this.is_done()) ? "✔" : (idx + 1);
			},

			is_current_step_invalid: function() {
				var cur_step = this.wz_model.planning[this.wz_model.current_idx] || 'hmm_settings';
				return (cur_step == 'trigger_action_settings' && this.mainForm.trigger_action_settings_form.$invalid);
			},

			go: function($location, $window, url) {
				var that = this,
					GOTO_ROUTE_EXPR = /^\/ng\/#/,
					cur_url = window.location.pathname + window.location.hash;
				if (cur_url === url) {
					this.$evalAsync(function() {
						that.$route.reload();
					});
				} else {
					if (GOTO_ROUTE_EXPR.test(url)) {
						url = url.replace(GOTO_ROUTE_EXPR, '');
						$location.url(url);
					} else {
						$window.location.href = url;
					}
				}
			},

			dialog_done: function() {
				this.go(this.wz_model.return_url);
			},

			dialog_cancel: function() {
				this.dialog_done();
			},

			save: function() {
				this.$broadcast('wizard_saving', true);
			},

			step_changed: function() {
				var that = this;
				that.$timeout(function() {
					that.$broadcast('f_focus_first_input', true);
				}, 100);
			}
		}
	};

	app.controller('MlWizard', MlWizard);
});
