define(["angular", "angular-resource", "app", "util"], function(angular, $resource, app){
	'use strict';
　　
	var data = JSON.parse(getCookie("tabList"));
	
	function tabController($scope, $resource)
	{
		$scope.thirdTabs = data;
		$scope.curTab = data[0].path;
		$scope.url = data[0].path;
		
		$scope.activeTab = function(ths){
			var tabObj = ths.tab;
			$scope.curTab = tabObj.path;
			$scope.url = tabObj.path;
		};	
	}
	tabController.$inject = ['$scope', '$resource'];
	
	var fTopTab = function(){
		return {
			restrict: 'E',
			replace: false,
			scope: {
				url: "=ngSrc"
			},
			template: '<div class="container">' +
				'<div class="headTabBar">' +
				'<ul class="nav nav-tabs">' +
				'<li class="" ng-repeat="tab in thirdTabs" ng-class="{active: curTab === tab.path}">'+
				'<a class="x-tab-right" ng-click="activeTab(this)">'+
				'<em class="x-tab-left"><span class="x-tab-strip-inner">{{tab.name}}</span></em></a></li>' + 
				'<li><div style="position: absolute;display: none;right: 15px;" id="right_button"></div></li>'+
				'</ul>' +
				'</div>' +
				'<iframe class="mainContent" id="mainContent" ng-src="{{url}}" scrolling="auto" style="width:100%;" frameborder="0"></iframe>' +
				'</div>',
			link: function(scope, element, attributes){
			},
			controller: tabController
		};
	};
	app.directive("fTopTab", fTopTab);
});
