/* global define */

define(['ng/ftnt', 'ng/services/volatile_storage'], function(module) {
    'use strict';

    var GUEST_ADMIN_URI = '/p/user/guest/list/';

    function Prompt($location, $routeParams, $window, state, structure, volatileStorage) {
        this._$location = $location;
        this._$routeParams = $routeParams;
        this._$window = $window;
        this._state = state;
        this._structure = structure;
        this._volatileStorage = volatileStorage;

        /*
            Disallow setting redirect parameter to any of the following
            URLs / regexp pattern matches
        */
        this._redirBlacklist = [
            /^\/ng\/prompt\/reboot/
        ];
    }

    Prompt.prototype.setupQueue = function() {
        var CHECKS = {
            _fileSystem: '/prompt/file_system_check',
            _centrallyManaged: '/prompt/centrally_managed'
        };

        this._setup = true;
        this._index = -1;
        this._queue = [];

        Object.keys(CHECKS).forEach(function(key) {
            if (this[key]()) {
                this._queue.push(CHECKS[key]);
            }
        }.bind(this));

        this._volatileStorage.clear();
    };

    Prompt.prototype.next = function() {
        if (this._setup && this._index + 1 < this._queue.length) {
            this._$location.path(this._queue[++this._index]);
        } else {
            this._$location.url(this._structure.ngURI(this.getRedirectURL()));
        }
    };

    Prompt.prototype.getRedirectURL = function() {
        var url, isBlackListed;
        if (this._state.admin.guest_admin) {
            url = GUEST_ADMIN_URI;
        } else {
            url = this._$routeParams.redir || '/ng/';
            isBlackListed = this._redirBlacklist.some(function(regex) {
                return regex.test(url);
            });
            url = isBlackListed ? '/ng/' : url;
        }

        return url;
    };

    Prompt.prototype.logout = function() {
        this._$window.location.href = '/logout';
    };

    Prompt.prototype._fileSystem = function() {
        var state = this._state;
        return state.need_fs_check && state.admin.super_admin;
    };

    Prompt.prototype._centrallyManaged = function() {
        var state = this._state;
        return state.centrally_managed;
    };

    module.service('prompt', Prompt);
});
