define("text", ["module"], function(module) {
    "use strict";
    var text, fs, Cc, Ci, xpcIsWindows, progIds = ["Msxml2.XMLHTTP", "Microsoft.XMLHTTP", "Msxml2.XMLHTTP.4.0"], xmlRegExp = /^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im, bodyRegExp = /<body[^>]*>\s*([\s\S]+)\s*<\/body>/im, hasLocation = "undefined" != typeof location && location.href, defaultProtocol = hasLocation && location.protocol && location.protocol.replace(/\:/, ""), defaultHostName = hasLocation && location.hostname, defaultPort = hasLocation && (location.port || void 0), buildMap = {}, masterConfig = module.config && module.config() || {};
    return text = {
        version: "2.0.14",
        strip: function(content) {
            if (content) {
                content = content.replace(xmlRegExp, "");
                var matches = content.match(bodyRegExp);
                matches && (content = matches[1])
            } else
                content = "";
            return content
        },
        jsEscape: function(content) {
            return content.replace(/(['\\])/g, "\\$1").replace(/[\f]/g, "\\f").replace(/[\b]/g, "\\b").replace(/[\n]/g, "\\n").replace(/[\t]/g, "\\t").replace(/[\r]/g, "\\r").replace(/[\u2028]/g, "\\u2028").replace(/[\u2029]/g, "\\u2029")
        },
        createXhr: masterConfig.createXhr || function() {
            var xhr, i, progId;
            if ("undefined" != typeof XMLHttpRequest)
                return new XMLHttpRequest;
            if ("undefined" != typeof ActiveXObject)
                for (i = 0; 3 > i; i += 1) {
                    progId = progIds[i];
                    try {
                        xhr = new ActiveXObject(progId)
                    } catch (e) {}
                    if (xhr) {
                        progIds = [progId];
                        break
                    }
                }
            return xhr
        }
        ,
        parseName: function(name) {
            var modName, ext, temp, strip = !1, index = name.lastIndexOf("."), isRelative = 0 === name.indexOf("./") || 0 === name.indexOf("../");
            return -1 !== index && (!isRelative || index > 1) ? (modName = name.substring(0, index),
            ext = name.substring(index + 1)) : modName = name,
            temp = ext || modName,
            index = temp.indexOf("!"),
            -1 !== index && (strip = "strip" === temp.substring(index + 1),
            temp = temp.substring(0, index),
            ext ? ext = temp : modName = temp),
            {
                moduleName: modName,
                ext: ext,
                strip: strip
            }
        },
        xdRegExp: /^((\w+)\:)?\/\/([^\/\\]+)/,
        useXhr: function(url, protocol, hostname, port) {
            var uProtocol, uHostName, uPort, match = text.xdRegExp.exec(url);
            return match ? (uProtocol = match[2],
            uHostName = match[3],
            uHostName = uHostName.split(":"),
            uPort = uHostName[1],
            uHostName = uHostName[0],
            !(uProtocol && uProtocol !== protocol || uHostName && uHostName.toLowerCase() !== hostname.toLowerCase() || (uPort || uHostName) && uPort !== port)) : !0
        },
        finishLoad: function(name, strip, content, onLoad) {
            content = strip ? text.strip(content) : content,
            masterConfig.isBuild && (buildMap[name] = content),
            onLoad(content)
        },
        load: function(name, req, onLoad, config) {
            if (config && config.isBuild && !config.inlineText)
                return void onLoad();
            masterConfig.isBuild = config && config.isBuild;
            var parsed = text.parseName(name)
              , nonStripName = parsed.moduleName + (parsed.ext ? "." + parsed.ext : "")
              , url = req.toUrl(nonStripName)
              , useXhr = masterConfig.useXhr || text.useXhr;
            return 0 === url.indexOf("empty:") ? void onLoad() : void (!hasLocation || useXhr(url, defaultProtocol, defaultHostName, defaultPort) ? text.get(url, function(content) {
                text.finishLoad(name, parsed.strip, content, onLoad)
            }, function(err) {
                onLoad.error && onLoad.error(err)
            }) : req([nonStripName], function(content) {
                text.finishLoad(parsed.moduleName + "." + parsed.ext, parsed.strip, content, onLoad)
            }))
        },
        write: function(pluginName, moduleName, write, config) {
            if (buildMap.hasOwnProperty(moduleName)) {
                var content = text.jsEscape(buildMap[moduleName]);
                write.asModule(pluginName + "!" + moduleName, "define(function () { return '" + content + "';});\n")
            }
        },
        writeFile: function(pluginName, moduleName, req, write, config) {
            var parsed = text.parseName(moduleName)
              , extPart = parsed.ext ? "." + parsed.ext : ""
              , nonStripName = parsed.moduleName + extPart
              , fileName = req.toUrl(parsed.moduleName + extPart) + ".js";
            text.load(nonStripName, req, function(value) {
                var textWrite = function(contents) {
                    return write(fileName, contents)
                };
                textWrite.asModule = function(moduleName, contents) {
                    return write.asModule(moduleName, fileName, contents)
                }
                ,
                text.write(pluginName, nonStripName, textWrite, config)
            }, config)
        }
    },
    "node" === masterConfig.env || !masterConfig.env && "undefined" != typeof process && process.versions && process.versions.node && !process.versions["node-webkit"] && !process.versions["atom-shell"] ? (fs = require.nodeRequire("fs"),
    text.get = function(url, callback, errback) {
        try {
            var file = fs.readFileSync(url, "utf8");
            "\ufeff" === file[0] && (file = file.substring(1)),
            callback(file)
        } catch (e) {
            errback && errback(e)
        }
    }
    ) : "xhr" === masterConfig.env || !masterConfig.env && text.createXhr() ? text.get = function(url, callback, errback, headers) {
        var header, xhr = text.createXhr();
        if (xhr.open("GET", url, !0),
        headers)
            for (header in headers)
                headers.hasOwnProperty(header) && xhr.setRequestHeader(header.toLowerCase(), headers[header]);
        masterConfig.onXhr && masterConfig.onXhr(xhr, url),
        xhr.onreadystatechange = function(evt) {
            var status, err;
            4 === xhr.readyState && (status = xhr.status || 0,
            status > 399 && 600 > status ? (err = new Error(url + " HTTP status: " + status),
            err.xhr = xhr,
            errback && errback(err)) : callback(xhr.responseText),
            masterConfig.onXhrComplete && masterConfig.onXhrComplete(xhr, url))
        }
        ,
        xhr.send(null)
    }
    : "rhino" === masterConfig.env || !masterConfig.env && "undefined" != typeof Packages && "undefined" != typeof java ? text.get = function(url, callback) {
        var stringBuffer, line, encoding = "utf-8", file = new java.io.File(url), lineSeparator = java.lang.System.getProperty("line.separator"), input = new java.io.BufferedReader(new java.io.InputStreamReader(new java.io.FileInputStream(file),encoding)), content = "";
        try {
            for (stringBuffer = new java.lang.StringBuffer,
            line = input.readLine(),
            line && line.length() && 65279 === line.charAt(0) && (line = line.substring(1)),
            null !== line && stringBuffer.append(line); null !== (line = input.readLine()); )
                stringBuffer.append(lineSeparator),
                stringBuffer.append(line);
            content = String(stringBuffer.toString())
        } finally {
            input.close()
        }
        callback(content)
    }
    : ("xpconnect" === masterConfig.env || !masterConfig.env && "undefined" != typeof Components && Components.classes && Components.interfaces) && (Cc = Components.classes,
    Ci = Components.interfaces,
    Components.utils["import"]("resource://gre/modules/FileUtils.jsm"),
    xpcIsWindows = "@mozilla.org/windows-registry-key;1"in Cc,
    text.get = function(url, callback) {
        var inStream, convertStream, fileObj, readData = {};
        xpcIsWindows && (url = url.replace(/\//g, "\\")),
        fileObj = new FileUtils.File(url);
        try {
            inStream = Cc["@mozilla.org/network/file-input-stream;1"].createInstance(Ci.nsIFileInputStream),
            inStream.init(fileObj, 1, 0, !1),
            convertStream = Cc["@mozilla.org/intl/converter-input-stream;1"].createInstance(Ci.nsIConverterInputStream),
            convertStream.init(inStream, "utf-8", inStream.available(), Ci.nsIConverterInputStream.DEFAULT_REPLACEMENT_CHARACTER),
            convertStream.readString(inStream.available(), readData),
            convertStream.close(),
            inStream.close(),
            callback(readData.value)
        } catch (e) {
            throw new Error((fileObj && fileObj.path || "") + ": " + e)
        }
    }
    ),
    text
}),
define("fgt_lang", [], function() {
    "use strict";
    var STATE_URI = "/api/v2/monitor/web-ui/state"
      , update_config = function(lang, shim) {
        var module = "lang." + lang.name
          , config = {
            paths: {},
            shim: {}
        };
        return config.paths[module] = "lang/" + (lang.filename || lang.name),
        config.shim[module] = {
            exports: "fgt_lang"
        },
        shim && (config.shim[module].deps = shim.deps,
        config.shim[module].init = shim.init),
        require.config(config),
        module
    };
    return {
        load: function(name, request, on_load) {
            var module;
            return window.fgt_lang ? void on_load(window.fgt_lang) : void (window.application_language ? (module = update_config({
                name: window.application_language,
                filename: window.application_language_path
            }),
            require([module], on_load)) : require(["text!" + STATE_URI], function(text) {
                var data = JSON.parse(text)
                  , state = data.results || {};
                if (state.guest_language_code) {
                    var guest_lang = update_config({
                        name: state.guest_language_code,
                        filename: state.guest_language_path
                    }, {
                        init: function() {
                            return window.custom_dict = window.fgt_lang
                        }
                    });
                    module = update_config({
                        name: state.language_code
                    }, {
                        deps: [guest_lang]
                    })
                } else
                    module = update_config({
                        name: state.language_code
                    });
                require([module], on_load)
            }));
        }
    }
}),
function(define, requirejs) {
    "use strict";
    var DEFINITIONS = window.fweb_define && window.fweb_define.DEFINITIONS;
    if ("function" != typeof window.fweb_define || DEFINITIONS) {
        var DEFINED = Object.create(null)
          , LOADED_BY = Object.create(null)
          , REQUIREJS_CONTEXT = "function" == typeof define && define.amd
          , add_loaded_by = function(path, dependencies) {
            Array.isArray(dependencies) || (dependencies = [dependencies]),
            dependencies.forEach(function(dependency) {
                LOADED_BY[dependency] ? LOADED_BY[dependency].push(path) : LOADED_BY[dependency] = [path]
            })
        }
          , fweb_define_collect = function() {
            var COLLECT_DEFINED = {}
              , define_it = fweb_define_collect.define_it = function(name) {
                var def = DEFINITIONS[name];
                fweb_define(name, def.dependencies, def.export_path, def.definition)
            }
            ;
            for (var name in DEFINITIONS)
                name in COLLECT_DEFINED || name in DEFINED || (COLLECT_DEFINED[name] = !0,
                define_it(name));
            DEFINITIONS = null,
            fweb_define_collect.define_it = null
        }
          , fweb_define = window.fweb_define = function(name, dependencies, export_path, definition) {
            var objectKey, object, proxy = function() {
                var mod = definition.apply(null, arguments);
                return DEFINED[name] = mod || null,
                REQUIREJS_CONTEXT || add_loaded_by(name, dependencies),
                mod && object && objectKey && (object[objectKey] = mod),
                mod
            };
            if (export_path && export_path.split(".").forEach(function(key) {
                object = object && objectKey ? object[objectKey] = object[objectKey] || {} : window,
                objectKey = key
            }),
            void 0 !== DEFINED[name])
                throw new Error('fweb_define: "' + name + '" is already defined');
            if (export_path && object[objectKey])
                throw new Error('fweb_define: object "' + export_path + '" already exists');
            REQUIREJS_CONTEXT || (define = function(name, dependencies, definitionFn) {
                var args;
                dependencies && (args = dependencies.map(function(dep) {
                    var depObject = DEFINED[dep]
                      , define_it = fweb_define_collect && fweb_define_collect.define_it;
                    if (void 0 === depObject && ("function" == typeof define_it && (define_it(dep),
                    depObject = DEFINED[dep]),
                    void 0 === depObject))
                        throw new Error('fweb_define: "' + dep + '" is not defined(required by ' + name + ")");
                    return depObject
                })),
                definitionFn.apply(null, args)
            }
            ),
            define(name, dependencies || [], proxy)
        }
        ;
        DEFINITIONS && fweb_define_collect(fweb_define),
        window.fweb_require = function() {
            function inline_require(name, callback) {
                return !callback && "string" == typeof name && DEFINED[name]
            }
            function _require(deps, callback) {
                function defined(name) {
                    return DEFINED[name]
                }
                if ("string" == typeof deps && !callback)
                    return DEFINED[deps];
                if (!Array.isArray(deps) || "function" != typeof callback)
                    throw new Error("Invalid arguments to fweb_require");
                callback.apply(null, deps.map(defined))
            }
            var require = window.require;
            require && REQUIREJS_CONTEXT || (require = _require);
            var result = inline_require.apply(null, arguments);
            return result ? result : require !== _require && (result = require.apply(arguments)) ? result : require.apply(null, arguments)
        }
        ,
        fweb_define.DEFINED = DEFINED,
        fweb_define.LOADED_BY = LOADED_BY,
        REQUIREJS_CONTEXT && (requirejs.onResourceLoad = function(context, map, dep_maps) {
            var name = map.name || map.originalName;
            DEFINED[name] = context.defined[name] || null,
            dep_maps && dep_maps.forEach(function(map) {
                add_loaded_by(name, map.name || map.originalName)
            })
        }
        )
    }
}(window.define, window.requirejs),
function() {
    "use strict";
    requirejs.onError = function(error) {
        var uri, module;
        if (!error.xhr || 401 !== error.xhr.status)
            throw error;
        module = error.requireModules[0],
        fweb.log.error("Failed to require module" + (module ? ' "' + module + '"' : "") + ". Redirecting to login page."),
        uri = top.location.pathname + top.location.search + top.location.hash,
        top.location.href = "/login?redir=" + encodeURIComponent(uri)
    }
}(),
function() {
    "use strict";
    function exports_to_object(exports) {
        if (exports) {
            var i, object = window, names = exports.split(".");
            for (i = 0; i < names.length && (object = object[names[i]],
            object); i++)
                ;
            return object
        }
    }
    var root =  "/"
      , angular_app = "ng/angular_app"
      , fweb_core = "js/fweb_core_all"
      , fweb_extra = "js/fweb_extra_all"
      , paths = {
        angular: "ng/angular_lib",
        "ng/app": angular_app,
        "ng/system/app": "ng/system/app",
        "ng/ftnt": angular_app,
        "ng/services/loader": angular_app,
        "ng/services/cmdb": angular_app,
        "ng/services/lang": angular_app,
        "ng/services/interceptor": angular_app,
        "ng/services/ftnt": angular_app,
        "ng/services/persistent_storage": angular_app,
        "ng/services/volatile_storage": angular_app,
        "ng/services/injector": angular_app,
        "ng/services/reboot": angular_app,
        "ng/services/route": angular_app,
        "ng/services/state": angular_app,
        "ng/services/slide": angular_app,
        "ng/services/ensure_dcsrf": angular_app,
        "ng/services/vdom_state": angular_app,
        "ng/directives/head": angular_app,
        "ng/directives/ftnt": angular_app,
        "ng/directives/qlist": angular_app,
        "ng/directives/menu/templates": angular_app,
        "ng/directives/menu/menu": angular_app,
        "ng/filters/ftnt": angular_app,
        "ng/structure/controllers": angular_app,
        "ng/structure/directives/embedded_iframe": angular_app,
        "ng/structure/directives/navbar": angular_app,
        "ng/structure/services/admin_timeout": angular_app,
        "ng/structure/services/help": angular_app,
        "ng/structure/services/navbar": angular_app,
        "ng/structure/services/recursion": angular_app,
        "ng/structure/services/structure": angular_app,
        "ng/structure/services/shortcuts": angular_app,
        "ng/structure/templates": angular_app,
        //"ng/fortiview/scripts/main": angular_app,
        // "ng/fortiview/scripts/controllers/sandboxFileDetails": "ng/fortiview_all",
        // "ng/fortiview/scripts/controllers/root": "ng/fortiview_all",
        "login_disconnect/ng/app": "login_disconnect/ng/angular_login_disconnect_all",
        "sslvpn/ng/app": "sslvpn/ng/angular_sslvpn_app_all",
        jquery: fweb_core,
        "jquery.ui": fweb_core,
        "jquery.throttle-debounce": fweb_core,
        "jquery.util_core": fweb_core,
        "closure-ipaddress": fweb_core,
        flot: fweb_core,
        cmdb: fweb_core,
        fweb: fweb_core,
        "fweb.dialog": fweb_core,
        "fweb.features": fweb_core,
        "fweb.interface": fweb_core,
        "fweb.util/uri": fweb_core,
        "fweb.util/location": fweb_core,
        "fweb.util/core": fweb_core,
        "fweb.util/datetime": fweb_core,
        "fweb.util/patterns": fweb_core,
        "fweb.util/ip": fweb_core,
        "fweb.util/formatters": fweb_core,
        "fweb.util/dom": fweb_core,
        "fweb.util/events": fweb_core,
        "fweb.util/functional": fweb_core,
        "fweb.util/objects": fweb_core,
        "fweb.util/templates": fweb_core,
        "fweb.util/logs": fweb_core,
        "fweb.util/shim": fweb_core,
        "fweb.util/sort": fweb_core,
        "fweb.util/legacy": fweb_core,
        "fweb.util/address": fweb_core,
        "fweb.util/persist": fweb_core,
        "fweb.util/structure": fweb_core,
        "fweb.util/certificate": fweb_core,
        "fweb.util/firewallInterfaces": fweb_core,
        "fweb.util/interface": fweb_core,
        "fweb.util/policy": fweb_core,
        "fweb.util/address_search": fweb_core,
        "fweb.util/icon": fweb_core,
        "fweb.util/avatars": fweb_core,
        "fweb.util/cmdb": fweb_core,
        "fweb.util/slide": fweb_core,
        "fweb.util/shortcuts": fweb_core,
        ftnt_shared: fweb_core,
        select_setup: fweb_core,
        "fweb.cmdbClone": fweb_extra,
        "jquery.textarea": fweb_extra,
        "jquery.validate": fweb_extra,
        "jquery.ezmark": fweb_extra,
        "jquery.qtip": fweb_extra,
        "jquery.util": fweb_extra,
        "legacy.util": fweb_extra,
        csrf: fweb_extra,
        "jquery.maskedinput": fweb_extra,
        "jquery.support": fweb_extra,
        fgd_common: fweb_extra,
        byod_common: fweb_extra,
        "ng/directives/faceted_search/faceted_search": "ng/directives/faceted_search/faceted_search_all",
        "ng/firewall/policy/controllers": "ng/firewall/policy/all",
        "ng/firewall/policy/dialog/policy-dialog": "ng/firewall/policy/all",
        qed_list: "js/qed_list_all",
        forti_chart: "js/forti_chart",
        "ng/directives/d3_base": "ng/directives/d3_base",
        saveas: "js/FileSaver",
        country_codes: "js/country_codes",
        ftoken_utils: "module_js/user/ftoken_utils",
        widgets: "module_js/system/widget/widgets",
        ips_common: "module_js/utm/ips_common",
        "lang.en": "lang/en",
        "lang.big5": "lang/big5",
        "lang.euc-kr": "lang/euc-kr",
        "lang.fr": "lang/fr",
        "lang.GB2312": "lang/GB2312",
        "lang.pg": "lang/pg",
        "lang.sp": "lang/sp",
        "lang.x-sjis": "lang/x-sjis",
        "/ng/fortiview/scripts/controllers/source": "ng/fortiview/scripts/controllers/source"
    };
    for (var module in paths)
        paths[module] = root + paths[module];
    var shim = {
        qed_list: {
            deps: ["fweb", "csrf", "jquery.qtip", "jquery.util", "jquery.maskedinput", "jquery.validate", "jquery.support", "legacy.util", "fweb.util/policy", "fweb.util/interface"],
            exports: "jQuery.qlist"
        },
        widgets: {
            deps: ["jquery"],
            exports: "Widgets"
        },
        chart: {
            deps: ["jquery"],
            exports: "Chart"
        },
        "highcharts/highcharts": {
            exports: "Highcharts"
        },
        ips_common: {
            deps: ["fweb", "jquery.util", "cmdb"],
            exports: "ips_common"
        },
        ftoken_utils: {
            deps: ["jquery", "jquery.util", "legacy.util"],
            exports: "ftoken_send_code"
        },
        country_codes: {
            exports: "country_codes"
        },
        "module_js/firewall/policy_route_lookup": {
            deps: ["jquery.ui_dependencies", "jquery.validate.methods"],
            exports: "PolicyRouteLookup"
        },
        "js/faceplate": {
            deps: ["jquery", "jquery.qtip", "cmdb", "legacy.util"],
            exports: "jQuery.faceplate"
        },
        "module_js/replacement_message": {
            exports: "ReplacementMessage"
        },
    };
    requirejs.config({
        baseUrl: root,
        paths: paths,
        shim: shim,
        enforceDefine: !0,
        urlArgs: "q="+CONFIG_GUI_NO,
        config: {
            text: {
                onXhr: function(xhr) {
                    xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest")
                }
            }
        }
    });
    var defined = window.fweb_define && window.fweb_define.DEFINED;
    defined && (Object.keys(defined).forEach(function(key) {
        define(key, function() {
            return defined[key]
        })
    }),
    Object.keys(shim).forEach(function(key) {
        var object = exports_to_object(shim[key].exports);
        object && define(key, function() {
            return object
        })
    }))
}();
