/* globals define */
define([], function() {
    'use strict';

    function ScrollParent() {
    }

    ScrollParent.prototype = {
        elem: null,
        link: function(elem) {
            this.elem = elem;
        },
        scrollIntoView: function(elem) {
            var offset = elem.position(),
                scrollParent = this.elem,
                size = {
                    x: elem.height(), y: elem.height()
                },
                psize = {
                    x: scrollParent.width(), y: scrollParent.height()
                };
            offset.x = offset.left;
            offset.y = offset.top;
            var top = offset.x < 0 || offset.y < 0,
                needScroll = top || offset.x + size.x > psize.x ||
                    offset.y + size.y > psize.y;
            if (needScroll) {
                elem[0].scrollIntoView(top);
            }
        }
    };

    function fScrollParent() {
        return {
            scope: false,
            controller: ScrollParent,
            require: 'fScrollParent',
            link: function(scope, elem, attr, ctrl) {
                ctrl.link(elem);
            }
        };
    }

    function fScrollIntoView() {
        return {
            scope: false,
            require: '^fScrollParent',
            link: function(scope, elem, attr, scrollParent) {
                scope.$watch(attr.fScrollIntoView, function(doScroll) {
                    if (doScroll) {
                        scrollParent.scrollIntoView(elem);
                    }
                });
            }
        };
    }
    //hack? should deal with this situation properly! IE: register called multiple times because
    //we are trying to chain requires instead of using loader directly
    var provided = [];
    return function register(providers) {
        if (provided.indexOf(providers) === -1) {
            provided.push(providers);
            providers.$compile.directive('fScrollParent', fScrollParent);
            providers.$compile.directive('fScrollIntoView', fScrollIntoView);
        }
    };
});
