/* global define */
define(['angular', 'ng/services/injector', 'ng/services/chart/constants'],
function(angular, inject, CONSTANTS) {
    'use strict';

    /**
     * There are different objects in the CSF chart:
     * - FortiGate
     * - FortiSwitch
     * - FortiAP (future)
     * - BubbleCluster
     * - DeviceTypeGroup
     * BaseCsfChartObject is the base class of these objects.
     **/
    function BaseCsfChartObject(injector) {
        injector.injectMarked(this);
        this.upstream = {};
        this.offset = {};
    }
    BaseCsfChartObject.H_MARGIN = CONSTANTS.CHART_OBJECT.MARGIN.H;
    BaseCsfChartObject.V_MARGIN = CONSTANTS.CHART_OBJECT.MARGIN.V;
    BaseCsfChartObject.prototype = {
        /* The destination to which the object connects */
        upstream: {},
        /* The starting offset of the object in the chart */
        offset: {},
        setUpstream: inject.mark(function(csf_chart) {
            return function(upstream) {
                this.upstream = {};
                angular.extend(this.upstream, upstream);
                this.upstreamSrcIntfId = csf_chart.genUpstreamIntfId(this.upstream);
            };
        }),
        setOffset: function(offset) {
            this.offset = {};
            angular.extend(this.offset, offset);
        },
        getOffset: function() {
            return this.offset;
        }
    };

    return BaseCsfChartObject;
});
