/* global define */
define(['angular', 'ng/services/injector', 'ng/services/chart/constants',
        'ng/services/chart/base_csf_chart_object'],
function(angular, inject, CONSTANTS, BaseCsfChartObject) {
    'use strict';

    function BubbleCluster($injector, injector, pack) {
        injector.injectMarked(this);
        this.pack = pack;
        this.setUpstream(pack.upstream);
    }
    BubbleCluster.clusterMap = {}; // static
    BubbleCluster.bubbleMap = {}; // static

    BubbleCluster.prototype = Object.create(BaseCsfChartObject.prototype);

    angular.extend(BubbleCluster.prototype, {
        constructor: BubbleCluster,
        pack: null,
        setOffset: inject.mark(function(csf_chart) {
            return function(offset, divisionCenterX) {
                BaseCsfChartObject.prototype.setOffset.call(this);
                // also transform the pack
                var pack = this.pack;
                var oldX = pack.x;
                var oldY = pack.y;
                var newX = divisionCenterX;
                var newY = offset.y + pack.r;
                var distance = {
                    x: newX - oldX,
                    y: newY - oldY
                };
                csf_chart.layoutPackTransform(pack, 1, distance);

                // update the cluster radius to a bit bigger
                pack.r += CONSTANTS.PADDING.CLUSTER_VS_BUBBLE;

                // now update the minimal bounding box which contains all children
                // in this pack, and also update the maps for zooming purpose
                pack.children.forEach(function(d) {
                    var id = d.srcIntfId + d.name;
                    BubbleCluster.bubbleMap = BubbleCluster.bubbleMap || {};
                    BubbleCluster.bubbleMap[id] = d;

                    var topLeft,
                        bottomRight;
                    topLeft = {
                        x: d.x - d.r,
                        y: d.y - d.r
                    };
                    bottomRight = {
                        x: d.x + d.r,
                        y: d.y + d.r
                    };
                    pack.bBox = pack.bBox || {};
                    var curBBox = pack.bBox;
                    angular.extend(curBBox, {
                        x1: csf_chart.bound(Math.min, curBBox.x1, topLeft.x),
                        y1: csf_chart.bound(Math.min, curBBox.y1, topLeft.y),
                        x2: csf_chart.bound(Math.max, curBBox.x2, bottomRight.x),
                        y2: csf_chart.bound(Math.max, curBBox.y2, bottomRight.y)
                    });
                    BubbleCluster.clusterMap[pack.upstreamSrcIntfId] = curBBox;
                }.bind(this));
            };
        }),
        getClusterNode: function() {
            return this.pack;
        },
        getDeviceNodes: function() {
            return this.pack.children;
        },
        getHeight: function(scale) {
            var scaleFactor = typeof scale !== 'undefined' ? scale : 1;
            return this.pack.r * 2 * scaleFactor;
        }
    });

    return BubbleCluster;
});
