/* global define */

/**
 * Service used to handle cloud svg
 */
define(['angular', 'ng/services/injector', 'fweb'], function(angular, inject, fweb) {
    'use strict';

    var CLOUD_SCALE = 9;

    function CloudSvg(injector) {
        injector.injectMarked(this);
        this.$promise = this.getCloudSVG();
    }

    CloudSvg.prototype.getCloudSVG = inject.mark(function($http) {
        return function() {
            var that = this;
            function responseHandle(response) {
                var xml = response.data;
                var docElement = xml.documentElement;
                var importedNode = document.importNode(docElement, true);
                var attrs = docElement.attributes;
                angular.extend(that, {
                    SCALE: CLOUD_SCALE,
                    WIDTH: attrs.width.value * CLOUD_SCALE,
                    HEIGHT: attrs.height.value * CLOUD_SCALE,
                    path: importedNode.getElementsByTagName('path')[0]
                });
            }
            return $http.get(/*FWB_CHANGE'/' + fweb.CONFIG_GUI_NO + */'/images/vector/cloud.svg', {
                responseType: 'document'
            }).then(responseHandle);
        };
    });

    return function(providers) {
        providers.$provide.service('cloudSvg', CloudSvg);
    };
});
