/* global define */
define(['angular', 'ng/services/injector', 'ng/services/chart/base_csf_chart_object',
        'ng/services/chart/device_type'],
function(angular, inject, BaseCsfChartObject, DeviceType) {
    'use strict';

    function DeviceTypeGroup($injector, injector, children) {
        $injector.invoke(BaseCsfChartObject, this);
        injector.injectMarked(this);

        this.children = children;
        this.sortChildren();
    }

    DeviceTypeGroup.prototype = Object.create(BaseCsfChartObject.prototype);

    angular.extend(DeviceTypeGroup.prototype, {
        constructor: DeviceTypeGroup,
        children: [],
        addChild: function(child) {
            this.children.push(child);
            this.sortChildren();
        },
        sortChildren: inject.mark(function(csf_chart) {
            return function() {
                this.children.sort(csf_chart.sort.deviceType);
            };
        }),
        getHeight: function(scale) {
            var scaleFactor = typeof scale !== 'undefined' ? scale : 1;
            var len = (this.children || []).length;
            var rowH = DeviceType.ROW_HEIGHT * scaleFactor;
            return len * rowH;
        }
    });

    return DeviceTypeGroup;
});
