/* global define */
define(['angular', 'ng/services/injector', 'ng/services/chart/constants',
        'ng/services/chart/base_ftnt_object'],
function(angular, inject, CONSTANTS, BaseFtntObject) {
    'use strict';
    /* jshint maxparams: 13 */

    function FortiGate($injector, injector, sn, vdom, shownIntfs, build, hostname, vdomMode,
                       version, viaRouterNat, ipSeenByUpstream, unFilteredIntfData, isRoot) {
        $injector.invoke(BaseFtntObject, this, {
            injector: injector,
            sn: sn,
            vdom: vdom,
            shownIntfs: shownIntfs
        });
        injector.injectMarked(this);

        this.build = build;
        this.hostname = hostname;
        this.vdomMode = vdomMode;
        this.version = version;
        this.viaRouterNat = viaRouterNat || false;
        this.ipSeenByUpstream = ipSeenByUpstream;
        this.isRoot = isRoot;

        this.setIcon();

        // vdomIntfs alone is enough, the map is just for quick lookup
        this.vdomIntfs = [];
        this.vdomMacMap = {};
        this.vdomIntfMap = {};

        var _intfMap = unFilteredIntfData.intfs || {};
        Object.keys(_intfMap).forEach(function(name) {
            var intf = _intfMap[name];
            if (intf.vdom === vdom) {
                this.vdomIntfs.push(intf);
                this.vdomMacMap[intf.macaddr] = intf;
                this.vdomIntfMap[name] = intf;
            }
        }.bind(this));
    }

    FortiGate.prototype = Object.create(BaseFtntObject.prototype);
    angular.extend(FortiGate.prototype, {
        constructor: FortiGate,
        BASE_HEAD_HEIGHT: CONSTANTS.FGT.HEAD.HEIGHT,
        isRoot: false,
        build: '',
        hostname: '',
        ipSeenByUpstream: '',
        vdomMode: false,
        version: '',
        hasMac: function(mac) {
            return this.vdomMacMap.hasOwnProperty(mac);
        },
        getIpSeenByUpstream: function() {
            return this.ipSeenByUpstream;
        },
        getIntfByMac: function(mac) {
            return this.vdomMacMap[mac];
        },
        getIntfByName: function(name) {
            return this.vdomIntfMap[name];
        },
        addIntfByName: function(intfName) {
            var exists = this.shownIntfs.length && this.shownIntfs.some(function(d) {
                return d.name === intfName;
            });
            if (!exists) {
                // get detail information of that interface
                var intf = this.getIntfByName(intfName);
                // and add to the shownIntfs
                this.addIntf(intf);
            }
        },
        addIntf: inject.mark(function(csf_chart) {
            return function(intf) {
                var exists = this.shownIntfs.length && this.shownIntfs.some(function(d) {
                    return (d.vdom === intf.vdom && d.name === intf.name);
                });
                if (!exists) {
                    this.shownIntfs.push({
                        fortilink: intf.fortilink,
                        ipAddr: intf.ipAddr,
                        role: intf.role,
                        name: intf.name,
                        network: intf.network,
                        vdom: intf.vdom,
                        sn: this.sn,
                        id: csf_chart.genSnVdomIntfId(this.sn, intf.vdom, intf.name)
                    });
                }
            };
        }),
        /**
         * Remove device from endpoint device stats if that device is CSF FGT
         * Also if withAccessDevices, move CSF FGT behind FSW to FSW children
         */
        refineHierarchy: inject.mark(function(csf_chart) {
            return function(withAccessDevices, ftntMap) {
                var devices = this.endpointStats;
                var childrenCount = this.children.length;
                var deviceCount;
                var device;
                var vlanName;
                var vdom;
                var switchPort;
                var vlanIntfObj;
                var uniqueSnVdom;
                var fsw;

                // Update FGT which is behind FSW
                // Also update endpoint devices coming from FSW VLAN as endpoint
                // devices of FSW

                while (childrenCount--) {
                    var child = this.children[childrenCount];
                    if (!csf_chart.isFgt(child)) {
                        continue;
                    }
                    deviceCount = devices.length;
                    while (deviceCount--) {
                        device = devices[deviceCount];
                        if (child.hasMac(device.mac) ||
                            (child.getIpSeenByUpstream() === device.address)) {
                            // one fgt mac address appear in endpoint stats of
                            // parent fgt or
                            // ip address of CSF downstream appears in endpoint stats
                            // of parent fgt.
                            // Let check if it is behind switch
                            if (withAccessDevices && device.fortilink_switch_id) {
                                // let bring this fgt after fsw
                                vlanName = device.srcintf;
                                vlanIntfObj = this.getIntfByName(vlanName);
                                vdom = vlanIntfObj.vdom;
                                uniqueSnVdom = csf_chart.genUniqueSnVdom(
                                    device.fortilink_switch_id, vdom);
                                fsw = ftntMap[uniqueSnVdom];
                                if (fsw) {
                                    // exist such a switch
                                    switchPort = 'port' + device.fortilink_port_id;
                                    // this child CSF FGT must be updated so that
                                    // the upstream interface will come to vlanName
                                    child.setUpstream({
                                        sn: device.fortilink_switch_id,
                                        vdom: vdom,
                                        intf: switchPort
                                    });
                                    fsw.addIntf({
                                        // this should not be fortilink-port
                                        'fortilink-port': false,
                                        name: switchPort,
                                        vlan: vlanName,
                                        vdom: vdom,
                                        ipAddr: vlanIntfObj.ipAddr,
                                        network: vlanIntfObj.network
                                    });
                                    // take this fgt and push to fsw children instead
                                    fsw.addFtntChild(child);
                                    // then remove it from children of parent fgt
                                    this.children.splice(childrenCount, 1);
                                }
                            }
                            // if the mac address of downstream appear in endpoint
                            // stats of parent fgt, we should remove this endpoint
                            // stats b/c we have render it as a FGT.
                            // Otherwise, it could be the router/nat device via
                            // which downstream connects to upstream, we should not
                            // remove it from stats.
                            if (child.hasMac(device.mac)) {
                                // always remove it from endpoint stats regardless it
                                // is behind FSW or not
                                devices.splice(deviceCount, 1);
                            }
                        }
                    }
                }

                // now handle for FSW, note that children and devices may have been
                // updated as a result of above step
                if (withAccessDevices) {
                    var fswEndpoints = {};
                    deviceCount = devices.length;
                    while (deviceCount--) {
                        device = devices[deviceCount];
                        if (device.fortilink_switch_id) {
                            vlanName = device.srcintf;
                            switchPort = 'port' + device.fortilink_port_id;
                            vlanIntfObj = this.getIntfByName(vlanName);
                            vdom = vlanIntfObj.vdom;
                            uniqueSnVdom = csf_chart.genUniqueSnVdom(device.fortilink_switch_id,
                                                                     vdom);
                            // for FSW, switchPort must be added
                            fsw = ftntMap[uniqueSnVdom];
                            if (fsw) {
                                fsw.addIntf({
                                    // this should not be fortilink-port
                                    'fortilink-port': false,
                                    name: switchPort,
                                    vlan: vlanName,
                                    vdom: vlanIntfObj.vdom,
                                    ipAddr: vlanIntfObj.ipAddr,
                                    network: vlanIntfObj.network
                                });
                                // for device, it should be move FSW endpoints
                                fswEndpoints[uniqueSnVdom] = fswEndpoints[uniqueSnVdom] || [];
                                device.vlanSrcIntf = vlanName;
                                device.srcintf = switchPort;
                                fswEndpoints[uniqueSnVdom].push(device);
                                // then remove it from parent FGT
                                devices.splice(deviceCount, 1);
                            }
                        } else {
                            var intfObj = this.getIntfByName(device.srcintf);
                            if (intfObj && intfObj.fortilink === 'enable') {
                                // this is internal traffic from FSW to FGT
                                // because we already draw switch as a separate
                                // chart object, we should remove this endpoint
                                devices.splice(deviceCount, 1);
                            }
                        }
                    }

                    Object.keys(fswEndpoints).forEach(function(fswId) {
                        ftntMap[fswId].setEndpointStats(fswEndpoints[fswId]);
                    });
                }
            };
        }),
        setIcon: inject.mark(function(iconCode) {
            return function() {
                var codeObj = iconCode.getCode('ftnt-fortigate');
                angular.extend(this.icon, codeObj);
            };
        })
    });

    return FortiGate;
});
