/* global define */
define(['angular', 'ng/services/injector', 'ng/services/chart/constants',
        'ng/services/chart/base_ftnt_object'],
function(angular, inject, CONSTANTS, BaseFtntObject) {
    'use strict';

    function FortiSwitch($injector, injector, sn, name, vdom, shownIntfs) {
        $injector.invoke(BaseFtntObject, this, {
            injector: injector,
            sn: sn,
            vdom: vdom,
            shownIntfs: shownIntfs
        });
        injector.injectMarked(this);

        this.name = name;
        this.vdomIntfs = [];
        this.vdomMacMap = {};
        this.vdomIntfMap = {};
        this.setIcon();
    }

    FortiSwitch.prototype = Object.create(BaseFtntObject.prototype);

    angular.extend(FortiSwitch.prototype, {
        constructor: FortiSwitch,
        BASE_HEAD_HEIGHT: CONSTANTS.FSW.HEAD.HEIGHT,
        name: '',
        addIntf: inject.mark(function(csf_chart) {
            return function(intf) {
                var exists = this.shownIntfs.length && this.shownIntfs.some(function(d) {
                    return (d.vlan === intf.vlan && d.name === intf.name);
                });
                if (!exists) {
                    this.shownIntfs.push({
                        'fortilink-port': intf['fortilink-port'],
                        ipAddr: intf.ipAddr,
                        name: intf.name,
                        network: intf.network,
                        vdom: intf.vdom,
                        vlan: intf.vlan,
                        sn: this.sn,
                        id: csf_chart.genSnVdomIntfId(this.sn, intf.vdom, intf.name)
                    });
                }
            };
        }),
        setIcon: inject.mark(function(iconCode) {
            return function() {
                var codeObj = iconCode.getCode('ftnt-fortiswitch');
                angular.extend(this.icon, codeObj);
            };
        })
    });

    return FortiSwitch;
});
