define(['ml_module'], function(module){
	'use strict';

	/**
	* Extra injection functionality that $injector should have.
	* Hopefully someday we can contribute this back to the framework.
	*/
	Injector.$inject = ['$injector'];
	function Injector($injector) {

		/**
		* Bind services to a function. This is what we'd get if
		* $injector.invoke and Function.prototype.bind had a baby.
		* @deprecated Deprecated in favor of injectMarked facilities.
		* @param {Function} fn Function to bind arguments for
		* @param {Object} [context] Object that will become 'this'.
		* @param {Object} [locals] Locals to pass to $injector.invoke.
		*/
		this.bind = function(fn, context, locals) {
			$injector.annotate(fn);
			invoked.$inject = fn.$inject;
			var args = $injector.invoke(invoked, context, locals);
			return fn.bind.apply(fn, [context].concat(args));
		};

		/**
		* Partially bind injected services, allowing locals to be provided
		* as positional arguments (like a regular function)
		* @deprecated Deprecated in favor of injectMarked facilities.
		* @param {function} fn Function to bind arguments for
		* @param {Object} [context] Object that will become 'this'.
		* @param {String[]} [positional] Arguments that will /not/ be bound.
		*   Specify these as positional arguments when calling the partially
		*   applied result function. (these must follow all bound arguments)
		* @param {Object} [locals] Arguments that will be bound the same way as
		*   the locals argument of Injector.bind.
		* @returns {Function} partially applied function or bound method
		*   that takes positional arguments as 'locals'
		*/
		this.partial = function(fn, context, positional, locals) {
			$injector.annotate(fn);
			invoked.$inject = fn.$inject.filter(remove_positional);
			var args = $injector.invoke(invoked, context, locals);
			return fn.bind.apply(fn, [context].concat(args));

			function remove_positional(arg) {
				return positional.indexOf(arg) === -1;
			}
		};

		function invoked() {
			return Array.prototype.slice.call(arguments);
		}

		/**
		 * Iterates through all methods of context that are marked for injection and overrides the
		 * method with the injector invoked result. See "inject" on the returned require helper
		 * functions object below for marking an object method. If the returned object is a function
		 * it will also be bound to the context using Function#bind(context)
		 *
		 * @param {Object} context - Object to be scanned for marked functions
		 * @param {Object} [locals] - Locals to pass to $injector.invoke
		 * @return {undefined}
		 */
		this.injectMarked = function(context, locals) {
			var key, property;
			for (key in context) {
				property = context[key];
				if (angular.isFunction(property) && property.$injectMark) {
					var result = $injector.invoke(property, context, locals);
					context[key] = typeof result === 'function' ? result.bind(context) : result;
				}
			}
		};
	}
	module.service('injector', Injector);

	// Helper functions
	return {
		/**
		 * Marks a function to be later injected via the ng service "injector"'s "injectMarked"
		 * function
		 *
		 * @param {Function} fn - The function to be marked. Should return a function that will
		 * become the object method. Example:
		 *   SomeClass.prototype.someFunction = inject.mark(function($scope, $http) {
		 *      // The following function will become SomeClass.prototype.someFunction
		 *      return function(argument1, argument2) {
		 *          ...
		 *      };
		 *   });
		 * @return {Function} - The marked function
		 */
		mark: function(fn) {
			fn.$injectMark = true;
			return fn;
		}
	};
});
