/* global define */

define(['angular'], function(angular) {
    'use strict';

    var URL = '/p/system/features/status/';

    var features = function($q, $http) {
        var features = Object.create(null);
        var deferred = $q.defer();

        features.$promise = deferred.promise;

        features.$get = function() {
            $http.get(URL).then(function(results) {
                angular.extend(features, results.data);
                deferred.resolve(features);
            });
        };

        return features;
    };


    return function(providers) {
        providers.$provide.factory('features', features);
    };
});
