/* global define */

define(['angular'], function() {
    'use strict';

    return function(providers) {
        var infoResource;
        var logSettings;
        var promise;

        function calculateTimeOffset(data) {
            var now = Math.floor(Date.now() / 1000);
            var originTime = data.timeinfo.client_epoch;
            var originOffset = data.timeinfo.origin_offset;
            var delay = Math.floor((now - originTime) / 2);

            var offset = originOffset > 0 ? originOffset - delay : originOffset + delay;
            data.timeinfo.offset = Math.abs(offset) > data.timeinfo.min_offset ? offset : 0;
        }
        // loader.preLoadModules does not provide an injector
        if (providers.$injector) {
            providers.$injector.invoke(function($q, $resource, CMDB) {
                var now = Math.floor(Date.now() / 1000);
                // FWB_CHANGE infoResource = $resource('/p/system/widget/fortiview_json')
                infoResource = $resource('/fortiview/info/fortiview_json')// FWB_CHANGE
                    .get({time: now});
                // FWB_CHANGE logSettings = (new CMDB('log', 'setting')).fetch();
                // FWB_CHANGE promise = $q.all([infoResource.$promise.then(calculateTimeOffset),
                promise = $q.all([infoResource.$promise.then(calculateTimeOffset)]);
                    // FWB_CHANGE logSettings.$promise]);
            });
        }

        providers.$provide.factory('fortigateInfo', function() {
            return {
                info: infoResource,
                logSettings: logSettings
            };
        });

        return promise;
    };
});
