/*global define */

/**
 * Service used to retrieve code for an ftnt or fa svg icon.
 * The code can then be used directly in svg graph/chart
 */
define(['angular', 'byod_common'], function(angular, byod_common) {
    'use strict';

    var ICON_MAP = {
        device: byod_common.device_class_map
    };

    function IconCode($resource, $q, loader) {
        this.data = {};
        var resourceFiles = {
            ftnt: 'ftnt-icons',
            fa: 'fa-icons',
            aliases: 'aliases'
        };
        var promises = [];

        angular.forEach(resourceFiles, function(fileName, resource) {
            var resourceURL = loader.base_path('fonts/' + fileName + '.json');
            this.data[resource] = $resource(resourceURL).get();
            promises.push(this.data[resource].$promise);
        }, this);

        this.$promise = $q.all(promises);
    }

    IconCode.prototype.getCode = function(name) {
        function toUnicode(code) { return String.fromCharCode(parseInt(code, 16)); }
        var code = '',
            fontFamily = '',
            realName = this.data.aliases[name] ? this.data.aliases[name] : name;
        if (/^ftnt-/.test(realName)) {
            code = this.data.ftnt[realName];
            fontFamily = 'ftnt-icons';
        } else if (/^fa-/.test(realName)) {
            code = this.data.fa[realName];
            fontFamily = 'fa-icons';
        }
        return code ? {
            name: name,
            code: code,
            fontFamily: fontFamily,
            unicode: toUnicode(code)
        } : {};
    };

    IconCode.prototype.getDeviceIconCode = function(device) {
        var icon = ICON_MAP.device[device] || 'ftnt-device';
        return this.getCode(icon);
    };

    return function(providers) {
        providers.$provide.service('iconCode', IconCode);
    };
});
