define('ng/services/navbar', ['angular', 'ng/ftnt', 'ng/services/injector', 'ng/services/loader', 'fweb', 'ftnt_shared','ng/services/state'],
function(angular, module, inject, loader, fweb, ftnt_shared){
    'use strict';

//	var PLATFORM_URI = '/menuconf/navbar_platform.json';
	var PLATFORM_URI = '/menu_xlat/json';

	function Navbar($rootScope, $q, injector){
		injector.injectMarked(this);

		this.state = {
			vdom_mode: vdom_mode,
			current_vdom: current_vdom,
			vdom_admin: vdom_admin,
			hostname: hostname,
			vdoms: vdoms
		};

		this._initialDeferred = $q.defer();
		this.promise = this._initialDeferred.promise;

		this._searchIndex = 0;
		this._searchValue = '';
		this.leafNodes = [];
		this.leafNodeMappding = {};
		this.indexedSearchResult = null;
		this.active = '';
		this.activeEntry = null;
		this.expanded = [];
		this._platformStructure = [];
		this.tree = null;
	}

	Navbar.prototype.update = inject.mark(function($q) {
		return function(searchValue) {
			this._clearSearchIndexing();
			return (this.promise = $q.all([
				this._getPlatformStructure()
			]).then(function() {
				this._searchValue = searchValue ? searchValue.toLowerCase() : null;
				this._buildTree();
				this._initialDeferred.resolve();
			}.bind(this)));
		};
	});

	// not use NavbarFavorites here
	Navbar.prototype.getFirstValidEntry = inject.mark(function($q) {
		return function() {
			return this.promise.then(function(){
				var first = null;
				if(this.leafNodes.length)
				{
					first = this.leafNodes[0];
				}
				return first;
			}.bind(this));
		};
	});

	// FGT's implement is to update expanded/active/activeEntry vars, related to location's url
	// we can't use this logic
	// first step try passed in a 'active' param, set it as this's active and find it's node data as activeEntry
	Navbar.prototype.selectActiveEntry = inject.mark(
	function($q) {
		return function(active) {

			var that = this;
			var bestMatchEntry;
			if(!active)	active = '';

			// just try to find absolute match entry node
			var updateBestMatch = function(entry) {
				if(entry.name == active)
				{
					bestMatchEntry = entry;
				}
			}

			return this.promise.then(function() {
				this.leafNodes.forEach(updateBestMatch);

				if(bestMatchEntry)
				{
					this.activeEntry = bestMatchEntry;
					this.active = active;

					this.expanded = [];
					this.expanded.push(bestMatchEntry.outermostParent);
					if(this.expanded.indexOf(bestMatchEntry.parent) < 0)
						this.expanded.push(bestMatchEntry.parent);
					/*
					if(this.expanded != bestMatchEntry.outermostParent)
						this.expanded = bestMatchEntry.outermostParent;
					*/
				}
				// if not set active, set the first valid as active entry
				else
				{
					this.getFirstValidEntry().then(function(entry) {
						that.activeEntry = entry;
						that.active = entry.name;
						top.main.location = entry.uri;

						that.expanded = [];
						that.expanded.push(entry.outermostParent);
						if(that.expanded.indexOf(entry.parent) < 0)
							that.expanded.push(entry.parent);
						//that.expanded = entry.outermostParent;
					});
					/*
					this.activeEntry = undefined;
					this.active = undefined;
					return $q.reject();
					*/
				}
			}.bind(this));
		};
	});

	Navbar.prototype.isExpanded = function(name) {
//		return this.expanded === name || this._searchValue;
		return (this.expanded.indexOf(name) >= 0) || !!this._searchValue;		
	};

	Navbar.prototype.isSelected = function(entry) {
		return entry.uri && entry.name === this.active;
	};

	Navbar.prototype.find_leaf_menu = function(menu_id) {
		for(var i = 0; i < this.leafNodes.length; i++)
		{
			var entry = this.leafNodes[i];
			if(entry.name == menu_id)
				return entry;
		}

		return null;
	}

	Navbar.prototype.refresh_menu = function(menu_id) {
		var menu_entry = this.find_leaf_menu(menu_id);
		if(menu_entry)
		{
			top.main.location = menu_entry.uri;
			this.selectActiveEntry(menu_id);
		}
	}

	// in our module, don't do any operation for location, route, routeSeg, just update top.main.location
	Navbar.prototype.entryClicked = inject.mark(function($rootScope) {
		return function(entry, doNavigation) {
			var toExpand;
			var resetSlides = function() {
				//if (top === window) {
					top.Sliderin.closeAll(true);
					top.Sliderin.updateTarget();
				//}
			};
			if(entry && entry.uri)
			{
				top.main.location = entry.uri;
				// toggle class of nav
				var nav = top.document.getElementById('navbar');
				if(nav && nav.className)
					nav.className = "";

				this.active = entry.name;
				$rootScope.responsiveMenu = false;
				this._clearSearchIndexing();

				this.expanded = [];
				this.expanded.push(entry.outermostParent);
				if(entry.outermostParent != entry.parent)
					this.expanded.push(entry.parent);

				resetSlides();
			}
			else
			{
				toExpand = entry.name; //entry ? entry.name : '';

				var index = this.expanded.indexOf(toExpand);

				/*if(entry.level > 1)
				{
					if(index >= 0){
						this.expanded.splice(index, 1);
					}
					else
					{
						this.expanded.push(toExpand);
					}
				}
				else
				{
					if(index >= 0)
					{
						this.expanded = [];
					}
					else
					{
						this.expanded = [];
						this.expanded.push(entry.name);
						this.expanded.push(entry.items[0].name);
					}
				}*/
				if(index >= 0)
				{
					this.expanded.splice(index, this.expanded.length-index);
				}
				else
				{
					this.expanded.splice(entry.level-1, this.expanded.length-entry.level+1, entry.name);
				}
				/*
				if(toExpand === this.expanded)
					this.expanded = undefined;
				else
					this.expanded = toExpand;
				*/
			}
		};
	});

	Navbar.prototype.isPathAvailable = function(path) {
		return this.promise.then(function(){
			return true;
		}.bind(this));
	};

	Navbar.prototype.indexSearchResults = function() {
		this._searchIndex = 0;
		this.indexedSearchResult = this.leafNodes.length ? this.leafNodes[0] : null;
	};

	Navbar.prototype.previousSearchResult = function() {
		var length = this.leafNodes.length;
		if(length) {
			this._searchIndex--;
			if(this._searchIndex < 0)
				this._searchIndex = length - 1;

			this.indexedSearchIndex = this.leafNodes[this._searchIndex];
		}
	};

	Navbar.prototype.nextSearchResult = function() {
		var length = this.leafNodes.length;
		if(length)
		{
			this._searchIndex++;
			if(this._searchIndex > length)
				this._serachIndex = 0;

			this.indexedSearchIndex = this.leafNodes[this._searchIndex];
		}
	};

	Navbar.prototype._clearSearchIndexing = function() {
		this._searchIndex = null;
		this.indexedSearchIndex = null;
	};

	// get menu json data
	Navbar.prototype._getPlatformStructure = inject.mark(function($http) {
		var promise;
		return function() {
			if(!promise)
			{
				promise = $http.get(PLATFORM_URI).then(function(response) {
					this._platformStructure = response.data;
				}.bind(this));
			}
			return promise;
		};
	});

	// check a menu item whether need to be suppressed
	// FGT use a suppressed object and _getSuppressed() to handler this logic, not suitable for us
	// our filter logic is just for global/per vdom, so just use global vdom state and entry's perm attribute
	// the check logic need to adv
	// return false mean not filtered, return true, need to be filtered
	Navbar.prototype._isSuppressed = function(entry) {

		var ftp_security_menu = ['waf_ftp_profile','waf_ftp_command_rule', 'ftp_file_check'];
		var device_tracking_menu = ['system_device_tracking', 'waf_device_tracking'];
		var mobile_app_identification_menu = ['mobileapi'];
		//var auto_learn_menu = ['autolearn'];
		var visibility = top.mainnav.state.admin.visibility;
		var state_vdoms = top.mainnav.state.admin.vdoms;
		var isVisibility = function(current_vdom, name)
		{
			for(var i=0;i<visibility.length;i++)
			{
				if(state_vdoms[i] == current_vdom)
				{
					if(!visibility[i].ftp_security){
						for(var j = 0;j< ftp_security_menu.length;j++){
							if(entry.name === ftp_security_menu[j])
								return false;
						}
						
					}
					if(!visibility[i].device_tracking){						
						for(var j = 0;j< device_tracking_menu.length;j++){
							if(entry.name === device_tracking_menu[j])
								return false;
						}
					}
					if(!visibility[i].mobile_app_identification){						
						for(var j = 0;j< mobile_app_identification_menu.length;j++){
							if(entry.name === mobile_app_identification_menu[j])
								return false;
						}
					}					
					/*
					if(!visibility[i].auto_learn){
						for(var j = 0; j < auto_learn_menu.length; j++){
							if(entry.name == auto_learn_menu[j])
								return false;
						}
					}
					*/
				}
			}
			return true;
		}

		if(!isVisibility(this.state.current_vdom, entry.name))
			return true;

		// level 1, 2 menu item, not need to be filtered, level 3 menu item, if vdom disabled, also doesn't has this attr
		if(!entry.perm)	return false;

		var res = false;
		var perm = entry.perm;

		// if vdom mode is disabled, not filter any items
		if(!this.state.vdom_mode)
			return false;

		if(this.state.vdom_admin)
		{
			// filter the per-adom menu item
			if(this.state.current_vdom === '')
			{
				if(perm != 'global')
					res = true;
			}
			// filter the global scope menu item
			else
			{
				if(perm != 'vdom')
					res = true;
			}
		}
		else
		{
			if(perm == 'none')
				res = true;
		}
		return res;
	};

	// when navbar with search menu, check the node item whether to be filtered
	Navbar.prototype._isFilteredOut = function(entry, label) {
		var filteredOut = false;
		if(label && this._searchValue && entry.uri)
			filteredOut = label.toLowerCase().indexOf(this._searchValue) < 0;
		return filteredOut;
	};

	Navbar.prototype._buildTree = inject.mark(function($sce, lang) {
		return function() {
			var leafNodes = [];
			var leafNodeMapping = {};
			var possibleLeafNodeMapping = {};

			var getIcons = function(menu_name) {
				var icons = {
					'fortiview': 'fa-area-chart',
					'system': 'fa-cog',
					'user': 'fa-user',
					'loadbalance': 'ftnt-policy-objects',
					'server_objects': 'fa-server',
					'application_delivery': 'fa-arrows',
					'waf': 'fa-lock',
					'api_protection':'ftnt-traffic',
					'ftp_security': 'fa-folder',
					'dos_protection': 'fa-shield',
					'bot_mitigation': 'ftnt-custom',
					'ip_protection': 'ftnt-policy-objects',
					'tracking': 'fa-laptop',
					'machine_learning': 'fa-bars',
					'autolearn': 'fa-bars',
					'wvs': 'fa-search-plus',
					'log': 'fa-bar-chart',
					'monitor': 'fa-pie-chart'
				};

				if(icons[menu_name] == undefined)
					return '';
				else
					return icons[menu_name];
			}

			var build = function(entry, parentMenu, outermostParentMenu, level) {
				var result, node, childResult, i, items;
				var leafNode = !!(entry.name && entry.uri);
				var hasIncludedLeafNode = false;
				var label = entry.label;
				var htmlLabel = label;
				var suppressed = this._isSuppressed(entry);
				var filteredOut = this._isFilteredOut(entry, label);
				var shouldInclude = !suppressed && !filteredOut;

				outermostParentMenu = outermostParentMenu ? outermostParentMenu : entry.name;
				level = level ? level : 0;

				if(entry.items)
				{
					items = [];
					for(i = 0; i < entry.items.length; i++)
					{
						childResult = build(entry.items[i], entry.name, outermostParentMenu, level+1);
						if(childResult)
						{
							items.push(childResult);
							hasIncludedLeafNode = true;
						}
					}
				}

				if(this._searchValue && shouldInclude && leafNode)
				{
					htmlLabel = ftnt_shared.highlighter.highlightMatchesInHTML(
							label, this._searchValue, true);
					htmlLabel = $sce.trustAsHtml(htmlLabel);
				}

				node = {
					name: entry.name,
					icon: getIcons(entry.name),
					label: label,
					htmlLabel: htmlLabel,
					uri: entry.uri,
					parent: parentMenu,
					outermostParent: outermostParentMenu,
					items: items,
					suppressed: suppressed,
					filteredOut: filteredOut,
					level: level
				};

				if(leafNode)
					possibleLeafNodeMapping[node.name] = node;

				if(shouldInclude && (leafNode || hasIncludedLeafNode))
				{
					result = node;
					if(leafNode)
					{
						leafNodes.push(node);
						leafNodeMapping[node.name] = node;
					}
				}

				return result;

			}.bind(this);

			this.tree = build(this._platformStructure);
			this.leafNodes = leafNodes;
			this.leafNodeMapping = leafNodeMapping;
			this.possibleLeafNodeMapping = possibleLeafNodeMapping;
		};
	});

	function NavbarDependencies($cacheFactory, $rootScope, injector, state) {
		injector.injectMarked(this);
	}

	module.service('navbar', Navbar);
	module.service('navbarDependencies', NavbarDependencies);
});
