/*global define*/
define(['module', 'angular', 'notify', 'fweb'],
function(module, ng, notify, fweb) {
    'use strict';

    var START_TIME_OFFSET = 60 * 60, // seconds
        SNAPSHOT_UPDATE_INTERVAL = 10 * 1000; // ms

    // index_offset and file_path is params for realtime threatmap data request
    var index_offset = 0, file_path = '', NONE_RESULT_UPDATE_INTERVAL = 1000;
    // start and page is the params for last hour threatmap data request, start is not useful anymore, the start time range get from background process
    var start = ((new Date()).getTime() / 1000) - START_TIME_OFFSET;
    var page = 1;
    var MAX_CACHE_COUNT = 200;

    function ThreatMapController($scope, $interval, $timeout, $http, CMDB, lang, state, loader, fortiviewSearchState, $window) {
        var threats = [],
            processedThreats = {},
            currentThreatIndex = 0,
            playbackTimeout = null,
            destroyed = false;
        $scope.threatmap = {};
        $scope.device = {latitude: 0, longitude: 0};

        $window.onunload = function() {
            $.ajax({
                type: 'GET',
                async: false,
                url: "/ng/fortiview/clear"
            });
        }

	fortiviewSearchState.clear_filters();
	fortiviewSearchState.clear_timeframe_filter();
	fortiviewSearchState.timeframeOptions = ['realtime', 'hour'];
	fortiviewSearchState.state.timeframe = 'realtime';

	$scope.realtime = fortiviewSearchState.state.timeframe === 'realtime';
	$scope.searchState = fortiviewSearchState;

        $scope.device.draggable = true;//FWB_CHANGE
        /*FWB_CHANGE if (state.adminHasReadPermission(state.ACCESS_GROUP.SYSTEM)) {
            // system global requires global admin, but these attributes have been whitelisted
            var sysGlobal = new CMDB('system', 'global', {
                format: {
                    'gui-device-latitude': true,
                    'gui-device-longitude': true
                }
            }).fetch();
            sysGlobal.$promise.then(function() {
                var latitude = parseFloat(sysGlobal['gui-device-latitude']);
                var longitude = parseFloat(sysGlobal['gui-device-longitude']);
                latitude = isNaN(latitude) ? 0 : latitude;
                longitude = isNaN(longitude) ? 0 : longitude;
                $scope.device = {latitude: latitude, longitude: longitude};

                // Only global admins with sysgrp write permissions can change device location
                if (!state.adminHasWritePermission(state.ACCESS_GROUP.SYSTEM) ||
                    !state.admin.global_admin) {
                    return;
                }

                $scope.device.draggable = true;
                $scope.$watch('[device.latitude, device.longitude]', function(value) {
                    if (value[0] === latitude && value[1] === longitude) {
                        return;
                    }
                    sysGlobal['gui-device-latitude'] = value[0].toString();
                    sysGlobal['gui-device-longitude'] = value[1].toString();
                    sysGlobal.$save().$promise.then(function() {
                        notify.post(lang('changes_saved').toString(), 'success');
                    });
                });
            });
        } else {
            fweb.log('Admin does not have permission to sysgrp read permission');
        }*/

	$scope.$watch('searchState.state', function(state, old) {
		if(state !== old)
		{
			$scope.realtime = fortiviewSearchState.state.timeframe === 'realtime';

			threats = [];
			processedThreats = {};
			currentThreatIndex = 0;
			destroyed = false;
			playbackTimeout = null;

			index_offset = 0; 
			file_path = '';
			page = 1;
		}
	}.bind(this), true);

        function snapshotUpdate() {
            if (destroyed) {
                return false;
            }

	    var params = {
		'index_offset': index_offset,
		'file_path': file_path,
		'start': start,
		'page': page,
		'type': fortiviewSearchState.state.timeframe === 'realtime' ? 0 : 1,
		'count': $scope.realtime ?  MAX_CACHE_COUNT - threats.length : 10000
	    };

            //FWB_CHANGE $http.get('/api/v2/monitor/fortiview/statistics', {
            $http.get('/fortiview/security/threat_json', {
		params: params
		/*
                params: {
                    snapshot: true,
                    report_by: 'threat',
                    ip_version: 'ipboth',
                    start: ((new Date()).getTime() / 1000) - START_TIME_OFFSET
                }
		*/
            }).then(function(results) {
		if($scope.realtime && threats.length < MAX_CACHE_COUNT)
	    	{
			index_offset = results.data.results.index_offset || index_offset;
			file_path = results.data.results.file_path || file_path;
		}
		start = (results.data.results.completed < 100.0) ? start : ((new Date()).getTime() / 1000) - START_TIME_OFFSET;
		page = (results.data.results.completed < 100.0) ? ++page : 1;

                var threatData = results.data.results.details/*.reverse()*/;
                threatData.forEach(function(result) {

		    if( $scope.realtime && threats.length >= MAX_CACHE_COUNT)
			return;

		    var threatid = result.msg_id + result.time;
                //    var threatid = result.threat + result.type + result.sessionid + result.time;
                    if (!processedThreats[threatid]) {
                        processedThreats[threatid] = true;
                        result.threatid = threatid;
                        threats.push(result);
                    }
                });

		$scope.realtime = fortiviewSearchState.state.timeframe === 'realtime';

                if (!playbackTimeout) {
                    playbackTimeout = playback();
                }

                // Schedule next update in realtime:1/last hour:10 seconds.
                $timeout(snapshotUpdate,  !$scope.realtime ? SNAPSHOT_UPDATE_INTERVAL : NONE_RESULT_UPDATE_INTERVAL);
            });
        }

        // Threat playback
        function playback() {
            if (destroyed) {
                return false;
            }
            var timeout;
            if (!threats[currentThreatIndex + 1]) {
                // wait for update snapshot data to start playback again.
                $scope.realtime = /*true*/fortiviewSearchState.state.timeframe === 'realtime';
                playbackTimeout = null;
            } else {
                // Playback events in the current 5 minute snapshot.
                // Find the time to the next event and use it to schedule next threat playback
                var timeToNextEvent = (threats[currentThreatIndex + 1].time -
                                       threats[currentThreatIndex].time); // s
                var delay = Math.max(timeToNextEvent * 10, 100);
                timeout = $timeout(playback, delay);
            }

//	    console.log('curindex:' + currentThreatIndex + ', index_offset: ' + index_offset + ', attack data len:' + $scope.threatmap.attackData.length + ', threat len: ' + threats.length);

            if (currentThreatIndex < threats.length) {
                $scope.threatmap.attackData.push(threats[currentThreatIndex]);
                $scope.threatmap.processThreats();
                currentThreatIndex++;

		if($scope.realtime && currentThreatIndex == MAX_CACHE_COUNT)
		{
			threats = [];
			processedThreats = {};
			currentThreatIndex = 0;
			playbackTimeout = null;

//			console.log("clear cache ");
		}
            }

            return timeout;
        }
        $timeout(snapshotUpdate, 2000);
        $scope.$on('$destroy', function() {
            destroyed = true;
        });
    }

    return function(providers, loader) {
        providers.$controller.register('ThreatMapController', ThreatMapController);
	return loader.initModules(['/ng/services/fortigateInfo', 
			'/ng/fortiview/scripts/services/searchState', 
			'/ng/fortiview/scripts/directives/timeframe_options'], 
			module);
    };
});
