(function(require) {
    'use strict';

    require.config({
        WaitSeconds: 0,
        baseUrl: '/ng/wizard',
        paths: {
            'lang.wizard': '/fgt_lang.js?type=0&paths=waf/signature/lang/:wizard',
            'jquery': '/js/jquery-1.11.2',
            'notify': '/js/api_notify',
            'angular' : '../libs/angular',
            'angular-resource' : '../libs/angular-resource',
            'angular-route' : '../libs/angular-route',
            'lang' : '../lang'
        },
        shim: {
            'lang.wizard': {exports: 'fgt_lang'},
            'jquery': {exports : 'jQuery'},
            'angular': {exports : 'angular'},
            'angular-route': {deps: ['angular']},
            'angular-resource' : {deps: ['angular']},
            'notify' : {deps: ['jquery']}
        }
    });


    require(['lang','jquery', 'angular',"angular-route", "angular-resource", 'controllers', 'wizard'], function(lang, jQuery, angular){
        require(['app'], function(app){
             var $html = angular.element(document.documentElement);
                angular.element(document).ready(function() {
                    angular.bootstrap($html, [app.name]);
                });

        });
    });

})(require);
