define(["angular", "app", "jquery", "lang.wizard", "notify"], function(ng, app, $)
{
function SigWizard($scope, $rootScope, $resource, $q, $timeout, $route, lang, $location, $window, Notify)
{
	 //test data
	 /*var data =  {'avail_steps':["database", "web_server", "signature_add"],
	 			  'database': [{"name":"Oracle", 
                                "id": "101",
                                "checked": false},
                                {"name":"MySQL", 
                                "id": "102",
                                "checked": false},
                                {"name":"DB2", 
                                "id": "103",
                                "checked":false}
	 						  ],
	 			  'web_server': [{"name":"IIS", 
                                "id": "201",
                                "checked": false},
                                {"name":"Apache", 
                                "id": "202",
                                "checked": false},
                                {"name":"Apache Tomcat", 
                                "id": "203",
                                "checked": false}
	 					  	],
	 		    };
     */

	 $scope.wz_model = {'planning': [], 'current_idx': 0, 'completed_tasks': [], 'forms': {}}
     //$scope.wz_tpl = data;
     
     $scope.wz_tpl = $resource('/waf/signature_wizard').get({},function(data) {
        if(data.status != 1){
            switch (data.msg_id){
                case -30:
                    top.location.href = "/login";
                    break;
                case -37:
                    document.location.href = "/noaccess?redir=/waf/signature_group/list";
                    break;
                default :
                    document.location.href = "/error?msg=" + data.msg_id;
                    break;
            }
        }
     });
     
     var on_data_loaded = function(){
        if(!ng.isUndefined($scope.wz_tpl.avail_steps))
            $scope.wz_model.planning = $scope.wz_tpl.avail_steps;

     };

     $scope.sig_wz = {};
    
     $scope.page_title = 'creation_wizard';
    
     $scope.wz_model.return_url = "/waf/signature_group/list";

     $scope.$timeout = $timeout;
	 $scope.$route = $route;
	 $scope.hide_footer_button = true;
	 $scope.name = 'name';

     ng.forEach(this.scope_fns, function(fn, key) {
        if(ng.equals(key, "go")){
            $scope[key] = fn.bind($scope, $location, $window);
        }
        else{
            $scope[key] = fn.bind($scope);
        }
	 });

     var on_error = function(){
        Notify.post(lang('load_failed'), 'error');
     };

     $q.all([$scope.wz_tpl.$promise]).then(
                on_data_loaded, on_error);

}

SigWizard.prototype = {
        scope_fns: {
            // this === $scope
            show_next: function() {
                if (this.wz_model.custom_next) {
                    this.wz_model.custom_next();
                } else {
                    if (this.wz_model.current_idx
                        < (this.wz_model.planning.length - 1)
                    ) {
                        this.wz_model.current_idx += 1;
                        this.step_changed();
                    }
                }
            },
            show_prev: function() {
                if (this.wz_model.current_idx > 0) {
                    this.wz_model.current_idx -= 1;
                    this.step_changed();
                }
            },
            has_next: function() {
                return this.wz_model.current_idx <
                    this.wz_model.planning.length - 1 ||
                    this.wz_model.custom_next;
            },
            has_prev: function() {
                return this.wz_model.current_idx > 0;
            },
            is_done: function() {
                return this.wz_model.completed_tasks.length > 0;
            },
            is_first: function() {
                return !(this.has_prev());
            },
            is_last: function() {
                return !(this.has_next());
            },
            step_label: function(idx) {
                return (idx < this.wz_model.current_idx ||
                        this.is_done()) ? "✔" : (idx + 1);
            },
            is_current_step_invalid: function() {
                var cur_step = this.wz_model
                    .planning[this.wz_model.current_idx] || 'database';
                return (cur_step == 'signature_add' && this.mainForm.signature_add_form.sig_name.$invalid );
            },
            dialog_done: function() {
                this.go(this.wz_model.return_url);
            },
            go: function($location, $window, url) {
                var _this = this,
                    GOTO_ROUTE_EXPR = /^\/ng\/#/,
                    cur_url = window.location.pathname + window.location.hash;
                if (cur_url === url) {
                    this.$evalAsync(function() {
                        _this.$route.reload();
                    });
                } else {
                    if (GOTO_ROUTE_EXPR.test(url)) {
                        url = url.replace(GOTO_ROUTE_EXPR, '');
                        $location.url(url);
                    } else {
                        $window.location.href = url;
                    }
                    //ie10 dies when you use window.location!
                    //do this outside the $digest or templates will use wrong
                    //cache_path!
                    //this.$evalAsync(function() {
                    //});
                }
            },
            dialog_cancel: function() {
                this.dialog_done();
            },
            save: function() {
                this.$broadcast('wizard_saving', true);
                //this.save();
            },
            step_changed: function() {
                var _this = this;
                _this.$timeout(function() {
                    _this.$broadcast('f_focus_first_input', true);
                }, 100);
            }
        }
    };

    app.controller('SigWizard', SigWizard);
});