define(["angular", "app", "jquery"], function(ng, app, $){
	app.directive('ensureUnique', function($http, $timeout, $resource) {
  	return {
    	require: 'ngModel',
    	link: function(scope, ele, attrs, c) {
      		var last_timeout;

      		var res = $resource('/waf/signature_group/namelist').get();

      		scope.$watch(attrs.ngModel, function(newval, oldval, cscope) {

	      		var DEBOUNCE = 0;
	      		var wait = 0;

	      		cscope.duplicate = false;

	      		var skip_check = Object.keys(c.$error).some(
	                            function(name) {
	                                return (name !== 'unique' &&
	                                        c.$error[name]);
	                            }
	                     		);

	            if (last_timeout) {
	                wait = DEBOUNCE;
	                $timeout.cancel(last_timeout);
	                last_timeout = null;
	            }
	            if (!skip_check) {
	                last_timeout = $timeout(check, wait);
	            }
	      		function check(){
	      			var valid = true;
	      			var data = {
	      				'name': newval
	      			};

		      		if(ng.isArray(res.data) == true){
			      		ng.forEach(res.data, function(obj){
			      			if(ng.equals(obj.name, newval))
			      			{
			      				valid = false;
			      			}
			      		});
			      	}

	      			c.$setValidity('unique', valid);

		        }
		      });
      		}
    	}
    });
});