define(["angular", "app", "jquery", "lang.wizard", "notify", "directives"], function(ng, app, $){

function WizardList($scope, $rootScope, $timeout, $route, lang, $http, Notify)
{
    $scope.duplicate = false;
    $scope.toogle = function(cb)
    {
        cb.checked = !cb.checked;
    }

    $scope.$on('wizard_saving', function(eo, flag) {
            $scope.save_data();
    });

    $scope.$name_length_warning = function()
    {
        if($scope.signature_add_form.sig_name.$inValid)
        {
            return lang('err_name');
        }
        else if($scope.signature_add_form.sig_name.$error.maxlength == true)
        {
            return lang('err_length');
        }
        else if($scope.signature_add_form.sig_name.$error.unique == true || $scope.duplicate == true)
        {
            return lang('err_duplicate');
        }
        else
        {
            return false;
        }
    };

    $scope.save_data = function(){
        var data_web_server = [];
        var data_database = [];
	var data_web_app = [];
	var data_script_lang = [];

        var nameObj = {};
        var require = {};
        var redir_url = "";
        
        if(ng.isArray($scope.wz_tpl.database) && ng.isArray($scope.wz_tpl.web_server)){

            ng.forEach($scope.wz_tpl.database, function(obj, index){
                if(ng.isUndefined(obj.checked))
                {
                    obj.checked = false;
                }
                data_database.push(obj);
            });

            ng.forEach($scope.wz_tpl.web_server, function(obj, index){
                if(ng.isUndefined(obj.checked))
                {
                    obj.checked = false;
                }
                data_web_server.push(obj);
            });
            
	    ng.forEach($scope.wz_tpl.web_app, function(obj, index){
                if(ng.isUndefined(obj.checked))
                {
                    obj.checked = false;
                }
                data_web_app.push(obj);
            });
	    
	    ng.forEach($scope.wz_tpl.script_lang, function(obj, index){
                if(ng.isUndefined(obj.checked))
                {
                    obj.checked = false;
                }
                data_script_lang.push(obj);
            });
        }
        //nameObj.sig_name = $scope.sig_wz.name;

	require.web_server = data_web_server;
	require.database = data_database;
	require.web_app = data_web_app;
	require.script_lang = data_script_lang;

	require.sig_name = $scope.sig_wz.name;

        var postCfg = {
                headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'},
                transformRequest: function(data) {
                    var post = {'ng_post' : JSON.stringify(data)}
                    return $.param(post);
                }
            };

        $http.post("/waf/signature_wizard/add", require, postCfg).success(
            function(data, status, headers, config){
                if(data.status == 1){
                    redir_url = "/waf/signature_group/dlg?mkey="+data.mkey;
                    $scope.go(redir_url);
                }
                else{
                    switch (data.msg_id){
                        case -30:
                            top.location.href = "/login";
                            break;
                        case -37:
                            document.location.href = "/noaccess?redir=/waf/signature_group/list";
                            break;
                        case -5:
                            $scope.duplicate = true;
                            break;
                        default :
                            document.location.href = "/error?msg=" + data.msg_id;
                            break;
                    }
                }
        }).error(
            function(data, status){
                var error_msg = "Bad HTTP Response : " + status; 
                Notify.post(error_msg, 'error');
        });

    };
}

   app.controller('WizardList', WizardList);
});
