/* globals define */
/* device_manage.js *//* globals wvs_ng, FOSGUI */
define(['angular', 'directives/faceted_search', 'wvs_integration/facets', 'directives/context_menu',
	'fweb.util/persist', 'qed_list', 
	'services/facets_log', 'services/persistent_storage'
],
function(angular, faceted_search, wvs_facets, context_menu, f_persist) {
	'use strict';
	var module = angular.module('ftnt');

	module.config(function(loaderProvider) {
		loaderProvider.initModules([faceted_search, wvs_facets, context_menu]);
	})
	module.controller('WVSViewerSearch', WVSViewerSearch);

	function WVSViewerSearch($scope, WVSFacets, $q, persistentStorage, facets, facetedSearchUtil, $window, $http, $document) {
		var PERSIST_KEY = 'WVSViewerSearch', qlistConfig = null;
		$scope.refresh = function() {
			wvs_ng.showLoading();
			wvs_ng.onload(facets.makeQlistFilters($scope.facetedSearch.model));
		};
		$scope.wvs_click_import = function() {
			wvs_integration_onclick_import();
		};
		$scope.wvs_click_delete = function() {
			wvs_integration_delete_elems();
		};
		$scope.wvs_click_mitigate = function() {
			wvs_integration_onclick_miti();
		}
		$scope.wvs_click_cancel = function() {
			wvs_integration_onclick_cancel();
		}
		$scope.selectArray = [{
			value: '3'
		}, {
			value: '5'
		}, {
			value: '7'
		}];
		$scope.aggregate = $scope.selectArray[0].value;
		$scope.change_aggregate = function(value){
			wvs_ng.aggregate = value;
			update_aggregate_value();
		};

		$scope.is_rw_admin = is_rw_admin;

		// use $evalAsync because jquery promises can sometimes execute syncronously,
		//and we'd have a double apply
		wvs_ng.columns.then(function(columns) {
			$scope.$evalAsync(function() {
				var disabled_columns = wvs_ng
				.get_filter_disable_columns(columns.columns),
				model;
				var urlFilter = $window.location.search.replace(/^\?/, '')
				.split('&').filter(startsWithFilter).map(doReplaceFilter)[0];
				try {
					model = persistentStorage.get(PERSIST_KEY);
				} catch (ex) {}

				columns = columns.columns.filter(columnFilterNotDisabled);

				$scope.facetedSearch = {
					facets: WVSFacets.forLogType(columns, highlight),
					model: model || {},
					options: {
						entries: entriesGetter,
						source: 'history',
						complex: true,
						filterMerge: {max: 1}
					}
				};

				if (urlFilter) {
					urlFilter = JSON.parse(decodeURIComponent(urlFilter));
					var urlModel = facets.fromQlistFilters(urlFilter, 'history');
					angular.extend(model, urlModel);
				}
				$scope.facetsBySource = $scope.facetedSearch.facets.reduce(bySourceHistory, {});

				$scope.facetedSearch.model = facetedSearchUtil
					.jsonForModel($scope.facetedSearch.model);

				function columnFilterNotDisabled(column) {
					return disabled_columns.indexOf(column.selector) === -1;
				}
				function bySourceHistory(index, facet) {
					index[facet.selectors.history] = facet;
					return index;
				}

				function startsWithFilter(str) { return /^filter=/.test(str) }
				function doReplaceFilter(str) { return str.replace(/^filter=/, '') }
			});
		});

		$scope.addContextFilter = function(valueOption) {
			var model = $scope.facetedSearch.model[$scope.context.facet.id];
			if (model === undefined) {
				model = $scope.facetedSearch.model[$scope.context.facet.id] = [];
			}
			model.push(valueOption.key);
			$scope.context = {};
		};

		function refreshQlist(model) {
			wvs_ng.showLoading();
			wvs_ng.ready.then(function() {
				wvs_ng.onload(facets.makeQlistFilters(model || $scope.facetedSearch.model));
			});
		}

		$scope.$watch('facetedSearch.model', function(value, oldValue) {
			//columns may not be loaded yet
			if(value === undefined)
				return;
			if (oldValue && oldValue !== value) {
				persistentStorage.put(PERSIST_KEY, value);
				refreshQlist(value);
			} else {
				wvs_ng.search_ready.resolve(facets.makeQlistFilters(value));
			}
			//search_ready resolve should create wvs_ng.ready promise
			if (wvs_ng.ready) {
				wvs_ng.ready.then(function(entries, $qlist) {
					$scope.facetedSearch.facets.forEach(function(facet) {
						facet.getValues(entries, 'history');
					});
				//rebind everything because dm nukes the qlist data.
				var filterEvt = 'filter_applied.WVSViewerSearch remove_filters.WVSViewerSearch';
				var contextEvt = 'contextmenu.WVSViewerSearch';
				qlistConfig = $qlist.qlist('config');
				$qlist.off(filterEvt).on(filterEvt, function(evt, filters) {
					$scope.$apply(function() {
						//if the remove_filters event is triggered
						//the filters argument is undefined;
						$scope.facetedSearch.model =
						facets.fromQlistFilters(filters || [], 'history');
					});
				});

				$qlist.off(contextEvt).on(contextEvt, function(evt) {
					var $elem = angular.element(evt.target).closest('td');
					var mkey = $elem.closest('[mkey]').attr('mkey');
					var selector = $elem.length && $elem[0].className;

					$scope.$apply(wvs_ng.ready.then.bind(wvs_ng.ready, function(source) {
						$scope.context = {
							origin: {x: evt.pageX, y: evt.pageY},
							row: source.filter(findRow)[0],
							selector: selector,
							facet: $scope.facetsBySource[selector]
						};
						var value = $scope.context.row && $scope.context.row[selector];
						$scope.context.filters = $scope.context.facet &&
						$scope.context.facet.contextFilters(value);

					}));
					evt.preventDefault();
					function findRow(row) {
						return row['#'] === Number(mkey);
					}
				});
			});
		}}, true);

		function entriesGetter() {
			return $q.when(wvs_ng.ready);
		}

		function highlight() {
			/* jshint validthis: true *//* this is a SearchFacet */
			var chosen = false,
			    scm = FOSGUI.WVSFormatter.smartColumnMap,
			    selector = this.selectors.history;
			if (qlistConfig && qlistConfig.chosen_columns) {
				chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
				if (!chosen && scm && (selector in scm)) {
					selector = scm[selector];
					chosen = qlistConfig.chosen_columns.indexOf(selector) > -1;
				}
			}
			return chosen;
		}
	}
});
