/* globals define */
/* jshint maxparams: 8 */
define(['angular', 'services/facets_log', 'qlist.sort', 'services/loader', 'services/injector'],
function(angular, facets) {
	'use strict';

	function WVSFacets(injector) {
		var partialBind = {
			'forLogType': ['columns', 'highlight']
		};
		for (var fn in partialBind) {
			this[fn] = injector.partial(this[fn], this, partialBind[fn]);
		}
	}

	WVSFacets.prototype = {
		facets: null,
		forLogType: function(SearchFacet, facets, $sce, $sanitize, $q, columns,highlight) {
			var result = facets.facetDefs.filter(forLogType).map(makeFacet),
			selectors = result.map(pluckSelector);
			columns = (columns || []).filter(selectorNotIn(selectors)).map(addColumnExtras);
			var extraFacets = facets.genericFacets(columns, highlight);
			facets.extraFacets(extraFacets);
			return result.concat(extraFacets);

			function forLogType(facetDef) {
				return false;
			}
			function makeFacet(facetDef) {
				return new SearchFacet(angular.extend({highlight: highlight}, facetDef));
			}
			function pluckSelector(facet) { return facet.selectors.history }
			function selectorNotIn(selectors) {
				return function(column) { return selectors.indexOf(column.selector) === -1 };
			}

			function addColumnExtras(column) {
				return column;
			}
		}
	};

	return function(providers) {
		facets(providers);
		providers.$provide.service('WVSFacets', WVSFacets);
	};
});
