(function() {

var layout = null;
var layout_center = null;
var g_tv = null;
var g_tabview = null;
var s_tabview = null;
var g_dt = null;
var g_contextMenu = null;
var g_dt_selected_row = null;
var filters_dt = null;
var filters_selected_row = null;
var global_status;
var group_status;
var g_page = null;
var g_type = "";
var curNode = null;
var g_brow = 0;
var g_mainID = '0';
var g_subID = '0';
var g_userID = 2;
var mkey = 0;
var g_wait;
var load_wait = "Loading please wait...";
var sig_id = 0;
var treeNode = null;
var is_default = 0;
var is_rw_admin = 0;
var selected_id = -1;
var is_insert = false;
var qlist_sub = null;
var lang_global = {
	dictionary    : 'Dictionaries',
	status        : 'Status',
	desc          : 'Description',
	sig	      : 'Signature',
	sig_id        : 'Signature ID',
	match_sample  : 'Match Sample',
	sample        : 'Sample',
	sig_setting   : 'Signature Setting',
	enable        : 'Enable',
	disable       : 'Disable',
	action        : 'Action',
	alert         : 'Alert',
	alert_deny    : 'Alert & Deny',
	redirect      : 'Redirect',
	erase_no_alert: 'Erase, no alert',
	send_403_forbidden: 'Send 403 Forbidden',
	alert_erase   : 'Erase & Alert',
	period_block  : 'Period Block',
	severity      : 'Severity',
	high          : 'High',
	medium        : 'Medium',
	low           : 'Low',
	block_period  : 'Block Period',
	block_period_unit: '(1~3600)(Seconds)',
	period_val_lim: 'is an invalid value.\nPeriod must be in 1~3600.',
	trigger_policy: 'Trigger Action',
	select        : 'Please Select',
	id            : 'ID',
	host_status   : 'Host Status',
	host          : 'Host',
	type	      : 'Type',
	simple	      : 'Simple String',
	regex	      : 'Regular Expression',
	request_file  : 'Request File',
	disable_in_global: 'Disable in Global',
	disable_in_group: 'Disable in Group',
	add           : 'Add',
	'delete'      : 'Delete',
	apply         : 'Apply',
	alert_only    : 'Alert Only',
	search	      : 'Search',
	disabled      : 'Disabled',
	filters	      : 'Filters',
	err_request_file : 'The request URL must start with \"/\".',
	err_host      : 'Please select a host.',
	err_regex     : 'You must input a valid regular expression.',
	err_value     : 'You must set the value field.',
	err_name      : 'You must set the name field.',
	err_client_ip : 'You must input the Clinet IP.',
	moveup        : 'Move Up',
	movedown      : 'Move Down',
	str_match     : 'String Match',
	reg_match     : 'Regular Expression Match',
	eq	      : 'Equal',
	ne	      : 'Not Equal',
	include	      : 'Include',
	exclude	      : 'Exclude',
	method	      : 'HTTP Method',
	client_ip     : 'Client IP',
	uri	      : 'URI',
	full_url      : 'Full URL',
	parameter     : 'Parameter',
	cookie	      : 'Cookie',
	operation     : 'Operation',
	elem_type     : 'Element Type',
	create	      : 'Create',
	insert	      : 'Insert',
	cancel	      : 'Cancel',
	edit	      : 'Edit',
	name	      : 'Name',
	value	      : 'Value',
	value_check   : 'Check Value of Specified Element',
	concat	      : 'Concatenat',
	clear	      : 'Clear',
	search_desc   : 'Search Description',
	filter_by     : 'Filter by',
	cve_number    : 'CVE Number',
	exception     : 'Signatures With Exception',
	fpm_status    : 'False Positive Mitigation',
	fpm_disable   : 'False Positive Mitigation Support',
	fpm_dis_filter: 'False Positive Mitigation Disabled',
	match_seq     : 'Match Sequence',
	move	      : 'Move',
	err_sig_id    : 'You must input a valid Signature ID.',
	tip_http_include        : 'FortiWeb does not perform a signature scan for requests that include the specified HTTP methods.<hr/>',
	tip_http_exclude        : 'FortiWeb only performs signature scans for requests that include the specified HTTP methods.<hr/>',
	tip_client_ip_equal     : 'FortiWeb does not perform a signature scan for requests with a client IP address that matches the value of Client IP.<hr/>',
	tip_client_ip_not_equal : 'FortiWeb only performs a signature scan for requests with a client IP address that matches the value of Client IP.<hr/>',
	http1_tip     : 'Applicable for HTTP 1.X',
	http2_tip     : 'Applicable for HTTP 2',
	http1_2_tip	  : 'Applicable for HTTP 1.X/HTTP 2',
	sql_ast		: 'SQL AST(abstract syntax tree) Changes',
	client_ip_tip   : '(e.g. 1.2.3.4, 2001::1, 1.2.3.4-1.2.3.40, 2001::1-2001::100)',
	deny_no_log   : 'Deny(no log)',
	Info          : 'Informative'
};

var main_class_actions = {
	2  : 'alert',
	6  : 'alert_deny',
	4  : 'deny_no_log',
	3  : 'redirect',
//	10 : 'send_403_forbidden',
	7  : 'alert_erase',
	11 : 'period_block',
	12 : 'erase_no_alert',
	13 : 'send_http_response'
};
var main_class_action_080000000 = [2,7,12,3,13];
var main_class_action_100000000 = [2,6,4,7,11,13];
var main_class_action_other = [2,6,4,11,3,13];

var severity = {
	1 : 'high',
	2 : 'medium',
	3 : 'low',
	4 : 'Info'
};

var method_options = [
	{val:1, text:"GET"},
	{val:2, text:"POST"},
	{val:4, text:"HEAD"},
	{val:8, text:"OPTIONS"},
	{val:16, text:"TRACE"},
	{val:32, text:"CONNECT"},
	{val:64, text:"DELETE"},
	{val:128, text:"PUT"},
	{val:256, text:"PATCH"},
	{val:2147483648, text:"OTHERS"}
];

var oper_actions = {
	1: 'str_match',
	2: 'reg_match',
	3: 'eq',
	4: 'ne',
	5: 'include',
	6: 'exclude'
};

var method_oper = [5,6];
var ip_oper = [3,4];
var other_oper = [1,2];

var default_excp = {
	match_target: 4,
	operation: 2,
	method: 0,
	ip: "",
	name: "",
	value: "",
	value_check: 0,
	concat: 1
};

var colors = ['', '#d4fbff', '#faffa5', '#ffca5c', '#f32e2b'];
var bcolors = ['', '#7bcade', '#d2ba00', '#e2a82e', '#d50000'];
//var scores = ['level_info', 'level_low', 'level_medium', 'level_high', 'level_critical'];
var scores = ['level_off', 'level_low', 'level_medium', 'level_high', 'level_critical'];

function process_slide(elem, val, act) {
    var jthis = $j(elem);
    jthis.children('div').css({
        'background': colors[val],
        'border-color': bcolors[val]
    });
    var title = lang_global[scores[val]];
    /*
    var title_score = parseInt(val) + 1;
    if(title_score == 1)
    	title = title + "("+title_score+" "+lang_global["point"]+")";
    else
    	title = title + "("+title_score+" "+lang_global["points"]+")";
    */
    var level_val = 0;
    if(act == 0) set_score(val);
    jthis.children('a').attr('title', title);
    $j('span.slider-label-text').html(title);
    $j('span.slider-level-disable-text', jthis).toggle(val == 0);
}

function get_score_field(elem) {
    var jthis = $j(elem);
    var score_id = jthis.attr('id').replace('-slider', '-score');
    return $j('#' + score_id);
}

function setup_sliders() {
    $j('div.level-slider').slider({
        range: 'min',
        max: 4,
        slide: function(event, ui) {
            var val = ui.value;
            process_slide(this, val, 0);
            var score_field = get_score_field(this);
            score_field.val(val);
        }
    }).each(function(n ,i) {
        var jthis = $j(this);
        var score_field = get_score_field(this);
        var val = score_field.val();
        jthis.slider("option", "value", val);        
        process_slide(this, val, 1);
    });
    // if(YAHOO.util.Dom.get('override').checked)
    // 	$j('div.level-slider').slider('disable');
    // else
    //  $j('div.level-slider').slider('enable');
    if(is_default)
        $j('div.level-slider').slider('disable');
    else
        $j('div.level-slider').slider('enable');
}

function Init()
{
	if (top && top.document.getElementById('online_help')) {
		top.document.getElementById('online_help').href = "javascript:openManual('serverProtectionException_add')";
	} else {
		if (window.opener) {
			if (window.opener.top && window.opener.top.document.getElementById('online_help'))
				window.opener.top.document.getElementById('online_help').href = "javascript:openManual('serverProtectionException_add')";
		}
	}

	var ua = navigator.appName.toLowerCase();
	if(ua.indexOf("microsoft") != -1)
		g_brow = 1;
	else
		g_brow = 2;

	layout = new YAHOO.widget.Layout({
            units: [
                { position: 'left', width: 200, resize: true, body: 'treeDiv', gutter: '5px', collapse: true, collapseSize: 20, scroll: true, animate: true, minWidth:200, maxWidth:300, header: lang_global["dictionary"]},
                { position: 'center',  width: 400, resize: true, body: 'detailDiv', gutter: '5px 5px 5px 1px', collapse:false, collapseSize: 20, scroll:true, animate: true, minWidth: 300, maxWidth: 600}
		]
        });

	layout.on('render', function() {
		var el = layout.getUnitByPosition('center').get('wrap');
		layout_center = new YAHOO.widget.Layout(el, {
			parent: layout,
			units: [
				{ position: 'center', body: 'tableDiv', gutter: '0px', scroll: true }
			]
		});
		layout_center.render();
	});

	layout.on('resize', 
		function() 
		{ 
			if (g_dt) 
			{
				var w = this.getSizes().center.w; 
				if(g_brow != 1)
					w -= 84;
				g_dt.set('width', w + 'px'); 
				g_dt.setColumnWidth(g_dt.getColumn('status'), 82);
				g_dt.setColumnWidth(g_dt.getColumn('id'), 95);
				g_dt.setColumnWidth(g_dt.getColumn('desc'), w-95-82);
				g_dt._syncColWidths(); 
			}

			/*
			if(filters_dt)
			{
				var w = this.getSizes().right.w;
				if(g_brow != 1)
					w -= 130;
				var val_width = ((w-270)>100) ? (w-270):100;
				filters_dt.setColumnWidth(filters_dt.getColumn('id'), 40);
				filters_dt.setColumnWidth(filters_dt.getColumn('match_target'), 70);
				filters_dt.setColumnWidth(filters_dt.getColumn('concat'), 60);
				filters_dt.setColumnWidth(filters_dt.getColumn('value'), val_width);
				filters_dt.setColumnWidth(filters_dt.getColumn('action'), 100);
				filters_dt._syncColWidths();
			}
			*/
		}, 
	layout, true); 

	layout.render();

	g_wait = new YAHOO.widget.Panel("wait",
		{
			width: "240px",
			fixedcenter: true,
//			close: false,
			draggable: false,
			zindex: 4,
			modal: true,
			visible: true
		}
	);

	g_wait.setHeader(load_wait);
	g_wait.setBody("<img src='/theme/images/loading.gif' />");
	g_wait.render(document.body);

	g_wait.show();


	var sUrl = "/signature/signature_lang.js?_="+(new Date()).toString();

        var callback = {
                success: function(oResponse) {
                        eval(oResponse.responseText);
//			lang_global = lang;
			lang_global = $j.extend(lang_global, lang);			

			var center = layout.getUnitByPosition("left");
			center.set("header", lang_global["dictionary"]);
			//YAHOO.util.Dom.get("returnBtn").value = lang_global["back_to_summary"]?lang_global["back_to_summary"]:"Return";
                },
                failure: function(oResponse) {},
                timeout: 70000
        };

        YAHOO.util.Connect.asyncRequest('GET', sUrl, callback);

	//add click to return button
	mkey = get_url_param("mkey");
	/*YAHOO.util.Event.addListener("returnBtn", "click", function(){
		document.location.href = "/waf/signature_group/dlg?mkey=" + mkey;
	});*/

	InitTree();
}

function InitSearch(){
	if(g_dt){
		g_contextMenu.destroy();
		g_contextMenu = null;

		g_dt.destroy();
		g_dt = null;

		layout.getUnitByPosition("right").close();
		var center = layout.getUnitByPosition("center");
		center.set("gutter", "5px 5px 5px 1px");

		layout_center.getUnitByPosition("bottom").close();
        }

        var center = layout_center.getUnitByPosition("center");
        center.set("header", g_type);

	var DataTable_innerHTML = '<div class="modform">'+
		lang_global["sig_id"]+': &nbsp;'+
		'<input id="search" type="text" style="height:22px"> &nbsp;'+
		'<input type="button" class="button" value="'+lang_global["search"]+'" id="search_btn">'+
		'</div>'+
		'<div id="DataSearch" width="100%" height="100%"></div>';

	YAHOO.util.Dom.get("DataTable").innerHTML = DataTable_innerHTML;

	YAHOO.util.Event.addListener("search_btn", "click", search_sig);
}

function InitFilter() {
	if(g_dt)
	{
		g_contextMenu.destroy();
		g_contextMenu = null;

		g_dt.destroy();
		g_dt = null;

		layout.getUnitByPosition("right").close();
		var center = layout.getUnitByPosition("center");
		center.set("gutter", "5px 5px 5px 1px");

		layout_center.getUnitByPosition("bottom").close();
	}

	var center = layout_center.getUnitByPosition("center");
	center.set("header", lang_global["filters"]);

	var DataTable_innerHTML = '<div class="modform">' +
		lang_global["filter_by"] + ': &nbsp;&nbsp;' +
		'<select id="filter_type">' +
		'<option>' + lang_global['disabled'] + '</option>' +
		'<option>' + lang_global['fpm_dis_filter'] + '</option>' +
		'<option>' + lang_global['alert_only'] + '</option>' +
		'<option>' + lang_global['cve_number'] + '</option>' +
		'<option>' + lang_global['exception'] + '</option>' +
		'</select>' +
		'&nbsp;&nbsp;&nbsp;&nbsp;'+
		'<span id="cve_field">' +
		'CVE - <input id="cve1" maxlength="4" size="10" value="" /> - <input id="cve2" maxlength="10" size="10" value="" />' +
		'</span>' +
		'&nbsp;&nbsp;&nbsp;&nbsp;'+
		'<input type="button" class="button" value="' +lang_global['apply'] +'" id="filter_btn" >' +
		'</div>'+
		'<div id="DataSearch" width="100%" height="100%"></div>';

	YAHOO.util.Dom.get("DataTable").innerHTML = DataTable_innerHTML;

	YAHOO.util.Event.addListener("filter_btn", "click", filter_sig);
	YAHOO.util.Event.addListener("filter_type", "change", update_filter_type);
	update_filter_type();
}

function update_filter_type()
{
	var filter = YAHOO.util.Dom.get("filter_type").selectedIndex;
	var cve_field = YAHOO.util.Dom.get("cve_field");

	if(filter == 3)
		cve_field.style.display = '';
	else
		cve_field.style.display = 'none';
}

function filter_sig() {
	var filter = YAHOO.util.Dom.get("filter_type").selectedIndex;

	// disabled filter
	if(filter == 0)
	{
		InitTable(1);
	}
	// fpm disabled
	else if(filter == 1)
	{
		InitTable(3);
	}
	// alert only
	else if(filter == 2)
	{
		InitTable(2);
	}
	// cve filter
	else if(filter == 3)
	{
		var sUrl = "/signature/cve_search";
		var cve1 = YAHOO.util.Dom.get('cve1').value;
		var cve2 = YAHOO.util.Dom.get('cve2').value;
		var sData = "mkey="+mkey+"&session_id="+lang_global["session_id"]+"&cve1="+cve1+"&cve2="+cve2;

		var callback = {
			success: function(oResponse) {
				g_wait.hide();
				var results = eval("("+ oResponse.responseText + ")");

				if(results.status==1){
					add_search_data(results.datas);
				}else{
					error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
				}
			},
			failure: function(oResponse) {
				g_wait.hide();
			},
			timeout: 70000
		};

		g_wait.show();
		YAHOO.util.Connect.asyncRequest('POST', sUrl, callback, sData);
	}
	// exception
	else if(filter == 4)
	{
		InitTable(4);
	}
}

function check_search_sig_id(obj)
{
	var reg = /^[0-9]{9}$/;
	if(reg.test(obj) == true)
	{
		return true;
	}
	return false;
}

function search_sig(){
	var search_value = YAHOO.util.Dom.get("search").value;
	if(search_value==""){
		return;
	}

	var sUrl = "/signature/signature";
	var sData = "mkey="+mkey+"&sig_id="+YAHOO.util.Dom.get("search").value+"&session_id="+lang_global["session_id"];

	var callback = {

		success: function(oResponse) {
			g_wait.hide();
                        var results = eval("(" + oResponse.responseText + ")");
                        if(results.status==1){
				add_search_data(results.datas);
			}else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},

		failure: function(oResponse) {
			g_wait.hide();
			//alert("Loading Configuration timeout.");
		},

		timeout: 70000
	};

	if(check_search_sig_id(search_value) == true)
	{
		g_wait.show();
		YAHOO.util.Connect.asyncRequest('POST', sUrl, callback, sData);
	}
	else 
	{
		alert(lang_global['err_sig_id']);
		return;
	}
}

function add_search_data(data){
	if(g_dt){
		g_contextMenu.destroy();
		g_contextMenu = null;

		g_dt.destroy();
		g_dt = null;
        }else{
		var center = layout.getUnitByPosition("center");
		center.set("gutter", "5px 1px 5px 1px");

		layout.addUnit({ position: 'right', body: 'tabDiv', width: 330, resize: true, gutter: '5px', collapse: true, scroll:true, minWidth: 260, maxWidth: 500});
		layout_center.addUnit({position: 'bottom', header:lang_global["match_sample"], height: 220, resize: true, body: 'sampleDiv', gutter: '5px 0px 0px 0px', collapse: true, collapseSize: 20, scroll: true, minHeight:100, maxHeight:380});
        }

	clearTabs();
	//YAHOO.util.Dom.get("match_sample").innerHTML = "";

	var ds = new YAHOO.util.DataSource();
	ds.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;
//      ds.responseType = YAHOO.util.DataSource.TYPE_JSON;

	ds.responseSchema = {
		fields: ["id", "status", "desc", "global_status", "group_status"]
	};

	var s = layout.getSizes();
	var w = s.center.w;
	if(g_brow != 1)
		w -= 84;

	var myColumnDefs =
	[
		{key:"id", label:"<div align='left'><b>"+lang_global["sig_id"]+"</b></div>",  formatter: YAHOO.widget.DataTable.formatText, width: 95},
		{key:"status", label:"<div align='left'><b>"+lang_global["status"]+"</b></div>", sortable:false, /*formatter: YAHOO.widget.DataTable.formatText,*/ width: 82},
		{key:"desc", label:"<div align='left'><b>"+lang_global["desc"]+"</b></div>", formatter:YAHOO.widget.DataTable.formatText, sortable:false, width: w-95-82},
		{key:"global_status"},
		{key:"group_status"}
	];

	var oConfig = {
		MSG_ERROR: "",
		paginator: g_page,
		width: w
	};

	g_dt = new YAHOO.widget.DataTable("DataSearch", myColumnDefs, ds, oConfig);

	var columnsets = g_dt.getColumnSet();
	g_dt.hideColumn(columnsets.getColumn("global_status"));
	g_dt.hideColumn(columnsets.getColumn("group_status"));


	g_dt.subscribe("rowClickEvent", g_dt_SelectRow);

	g_contextMenu = new YAHOO.widget.ContextMenu("mytablemenu",
				{
					trigger: "DataTable",
					lazyload: true
				});

	g_contextMenu.subscribe("beforeShow", onTableBeforeShow);

	for(var i=0, len=data.length; i<len; i++){
		if(data[i].status!=1){
			data[i].status = "<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"];
		}else if(data[i].has_filter==1){
			data[i].status = "<img src='/images/menubar/signature_exception.png'> "+lang_global["enable"];
		}else{
			data[i].status = "<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"];
		}
		//data[i].status = data[i].status==1?("<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"]):("<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"]);
		g_dt.addRow(data[i]);

		g_mainID = data[i].main_class_id;
		g_subID  = data[i].sub_class_id;
	}
	//var record = g_dt.getRecord(0);
	if(data.length > 0)
		g_dt_SelectRow(0);

	/*var center = layout.getUnitByPosition("center");
        center.set("gutter", "5px 1px 5px 1px");

	layout.addUnit({ position: 'right', body: 'tabDiv', width: 330, resize: true, gutter: '5px', collapse: true, scroll:true, minWidth: 260, maxWidth: 400});
	layout_center.addUnit({position: 'bottom', header:lang_global["match_sample"], height: 220, resize: true, body: 'sampleDiv', gutter: '5px 0px 0px 0px', collapse: true, collapseSize: 20, scroll: true, minHeight:100, maxHeight:380});*/

	/*YAHOO.util.Dom.get("DataSearch").innerHTML = "22222222 3333333333333 44444444444444 5555555555555555 55 66 66 66 66 66 66 66 66 66 66 66 66 7 77 77 77 77 77 77 77 77 77 88 88 88 88 88 88 88 99 99 99 99 99 99 0 00 00 00 00 00 00 00 00 00 11 11 11 11 11 11 11 11";
	alert("11111111");*/
}

function TypeSetting(node){
	if(g_dt){
		g_contextMenu.destroy();
		g_contextMenu = null;

		g_dt.destroy();
		g_dt = null;

		layout.getUnitByPosition("right").close();
		var center = layout.getUnitByPosition("center");
		center.set("gutter", "5px 5px 5px 1px");

		layout_center.getUnitByPosition("bottom").close();
	}


	var center = layout_center.getUnitByPosition("center");
        center.set("header",  node.label);

	var DataTable_innerHTML = '<table class="container" cellpadding="0" cellspacing="0">'+
		'<tr><td>'+
		'<form method="post" name="main_class_frm" id="main_class_frm" onsubmit="return false;">'+
		'<table class="dlg" align="center" cellpadding="0" cellspacing="0" style="width:100%;">'+
		'<tr><td class="body">'+
		'<table class="body" cellpadding="0" cellspacing="0">';

	if(g_mainID=='030000000' || g_mainID=='040000000'){
		DataTable_innerHTML += '<tr>'+
			'<td width="40%"></td><td width="15%"><b>'+lang_global["fpm_status"]+'</b></td>'+
			'<td><input type="checkbox" id="fpm_status" name="fpm_status" class="toggle-switch"><label for="fpm_status"></label>'+
			'</td></tr>';
	}

	DataTable_innerHTML += '<tr>'+
		'<td width="40%"></td><td width="15%"><b>'+lang_global["action"]+'</b></td>'+
		'<td><select id="main_class_action" name="main_class_action"></select>'+
		'</td></tr>'+
		'<tr>'+
		'<td></td><td><b>'+lang_global["period_block"]+'</b></td><td><input type=text id="block_period" name="block_period" size="12" maxlength="20" value=""> '+lang_global["block_period_unit"]+'</td>'+
		'</tr>'+
		'<tr>'+
		'<td></td><td><b>'+lang_global["severity"]+'</b></td><td><select id="severity" name="severity"></select>'+
		'</td></tr>'+
		'<tr>'+
		'<td></td><td><b>'+lang_global["trigger_policy"]+'</b></td>'+
		'<td>'+
		'<select id="trigger_policy" name="trigger_policy">'+
		'<option value="">'+lang_global["select"]+'</option>'+
		'</select>'+
		'</td></tr>'+
		'</table>'+
		'</td></tr>'+
		'<tr><td>'+
		'<table class="footer" cellpadding="0" cellspacing="0">'+
		'<tr><td>'+
		'<input type="submit" class="button" id="main_class_update" name="main_class_update" value="'+lang_global["apply"]+'">'+
		'</td></tr>'+
		'</table>'+
		'</td></tr>'+
		'</table>'+
		'</form>'+
		'</td>'+
		'</tr>'+
		'</table>';

	var callback = {
                success: function(oResponse) {
                        //g_wait.hide();
                        var results = eval("(" + oResponse.responseText + ")");
                        if(results.status==1){
				YAHOO.util.Dom.get("DataTable").innerHTML = DataTable_innerHTML;

				var varItem;
				var main_class_action_dom = YAHOO.util.Dom.get("main_class_action");
				if(g_mainID=='080000000'){
					for(var i=0,len=main_class_action_080000000.length; i<len; i++){
						varItem = new Option(lang_global[main_class_actions[main_class_action_080000000[i]]], main_class_action_080000000[i]);
						main_class_action_dom.options.add(varItem);
						if(results.action == main_class_action_080000000[i]){
							main_class_action_dom.options[main_class_action_dom.options.length-1].selected=true;
						}
					}
				}else if(g_mainID=='100000000'){
					for(var i=0,len=main_class_action_100000000.length; i<len; i++){
						varItem = new Option(lang_global[main_class_actions[main_class_action_100000000[i]]], main_class_action_100000000[i]);
						main_class_action_dom.options.add(varItem);
						if(results.action == main_class_action_100000000[i]){
							main_class_action_dom.options[main_class_action_dom.options.length-1].selected=true;
						}
					}
				}else{
					for(var i=0,len=main_class_action_other.length; i<len; i++){
						varItem = new Option(lang_global[main_class_actions[main_class_action_other[i]]], main_class_action_other[i]);
						main_class_action_dom.options.add(varItem);
						if(results.action == main_class_action_other[i]){
							main_class_action_dom.options[main_class_action_dom.options.length-1].selected=true;
						}
					}
				}

				if(g_mainID=='030000000' || g_mainID=='040000000'){
					var fpm_status_dom = YAHOO.util.Dom.get("fpm_status");
					if(results.fpm_status == 1){
						fpm_status_dom.checked = true;
					}
				}

				var severity_dom = YAHOO.util.Dom.get("severity");
				for(var k in severity){
                                        varItem = new Option(lang_global[severity[k]], k);
                                        severity_dom.options.add(varItem);
                                        if(results.severity == k){
                                                severity_dom.options[severity_dom.options.length-1].selected=true;
                                        }
                                }

				var trigger_policy_dom = YAHOO.util.Dom.get("trigger_policy");
				var trigger_policies   = results.trigger_policys;
				for(var j = 0; j < trigger_policies.length; j++){
					varItem = new Option(trigger_policies[j].name, trigger_policies[j].value);
					trigger_policy_dom.options.add(varItem);
					if(results.trigger == trigger_policies[j].value){
						trigger_policy_dom.options[trigger_policy_dom.options.length-1].selected=true;
					}
				}

				update_block_period();
				YAHOO.util.Dom.get("block_period").value = results.block_period;
				YAHOO.util.Event.addListener("main_class_update", "click", main_class_update);
				YAHOO.util.Event.addListener("main_class_action", "change", update_block_period);
				DisableForm(document.main_class_frm, is_default);
                        }else{
                                error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
                        }
                },

                failure: function(oResponse) {
                        //g_wait.hide();
                },

                timeout: 70000
        };

	YAHOO.util.Connect.asyncRequest('POST', "/signature/get_main_class", callback, "mkey="+mkey+"&main_class_id="+node.data.main_id+"&session_id="+lang_global["session_id"]);
}

function update_block_period(){
	var block_period = YAHOO.util.Dom.get("block_period");
	if(YAHOO.util.Dom.get("main_class_action").value == '11'){
		block_period.removeAttribute("disabled");
	}else{
		block_period.setAttribute("disabled","disabled");
	}
}

function DisableForm(xForm,xHow){
	if(xForm && xHow==1){
		var objElems = xForm.elements;
		for(var i=0;i<objElems.length;i++){
			objElems[i].disabled = true;
		}
	}
}

function main_class_update(){
	var severity          = YAHOO.util.Dom.get("severity");
	var main_class_action = YAHOO.util.Dom.get("main_class_action");
	var trigger_policy    = YAHOO.util.Dom.get("trigger_policy");
	var block_period      = YAHOO.util.Dom.get("block_period");

	if(block_period.disabled==false && checknumber(block_period,1,3600,lang_global["period_val_lim"],lang_global["period_val_lim"])==false)
		return;

	var callback = {
		success: function(oResponse) {
			g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status==1){
                                var main_class_action_dom = YAHOO.util.Dom.get("main_class_action");
                                for(var i=0,len=main_class_action_dom.options.length; i<len; i++){
                                        if(results.action == main_class_action_dom.options[i].value){
                                                main_class_action_dom.options[i].selected=true;
                                        }
                                }
				update_block_period();

                                var trigger_policy_dom = YAHOO.util.Dom.get("trigger_policy");
                                for(var j=0,len=trigger_policy_dom.options.length; j<len; j++){
                                        if(results.trigger == trigger_policy_dom.options[j].value){
                                                trigger_policy_dom.options[j].selected=true;
                                        }
                                }

				var severity_dom = YAHOO.util.Dom.get("severity");
                                for(var i=0,len=severity_dom.options.length; i<len; i++){
                                        if(results.severity == severity_dom.options[i].value){
                                                severity_dom.options[i].selected=true;
                                        }
                                }

                                YAHOO.util.Dom.get("block_period").value = results.block_period;
			}else{
                                error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},

		failure: function(oResponse) {
			g_wait.hide();
		},

		timeout: 70000
	};

	g_wait.show();
	var post_param = "mkey="+mkey+"&main_class_id="+g_mainID+"&action="+main_class_action.value+"&block_period="+block_period.value+"&severity="+severity.value+"&trigger_policy="+trigger_policy.value+"&session_id="+lang_global["session_id"];
	if(g_mainID=='030000000' || g_mainID=='040000000'){
		var fpm_status = YAHOO.util.Dom.get("fpm_status");
		var fpm_status_value = fpm_status.checked ? 1 : 0;
		post_param += "&fpm_status=" + fpm_status_value;
	}
	YAHOO.util.Connect.asyncRequest('POST', "/signature/set_main_class", callback, post_param);
}

function InitTable(type)
{
	if(g_dt)
	{
		g_contextMenu.destroy();
		g_contextMenu = null;

		g_dt.destroy();
		g_dt = null;
	}else{
		var center = layout.getUnitByPosition("center");
		center.set("gutter", "5px 1px 5px 1px");
		layout.addUnit({ position: 'right', body: 'tabDiv', width: 500, resize: true, gutter: '5px', collapse: true, scroll:true, minWidth: 400, maxWidth: 600});
		layout_center.addUnit({position: 'bottom', header:lang_global["match_sample"], height: 220, resize: true, body: 'sampleDiv', gutter: '5px 0px 0px 0px', collapse: true, collapseSize: 20, scroll: true, minHeight:100, maxHeight:380});
	}

	clearTabs();
	//YAHOO.util.Dom.get("match_sample").innerHTML = "";

	var center = layout_center.getUnitByPosition("center");
        center.set("header",  g_type);

	var SearchBox_innerHTML = '<span>&nbsp;&nbsp;'+lang_global["search_desc"]+'</span>&nbsp;&nbsp;&nbsp;'+
				  '<input type=text size=42 id="search_desc" name="search_desc" value="">&nbsp;&nbsp;&nbsp;'+
				  '<a id="set_search_desc" style="vertical-align:middle;"><img style="vertical-align:middle;" src="/images/Search.gif" title="'+lang_global["search"]+'"></a>&nbsp;&nbsp;'+
				  '<a id="clear_search_desc" style="vertical-align:middle;"><img style="vertical-align:middle;" src="/images/ClearSearch.gif" title="'+lang_global["clear"]+'"></a>';

	var searchBox = YAHOO.util.Dom.get("SearchBox");
	
	if(type == 0)
	{
		searchBox.innerHTML = SearchBox_innerHTML;
	}
				
	YAHOO.util.Event.addListener("set_search_desc", "click", set_search_desc);
	YAHOO.util.Event.addListener("clear_search_desc", "click", clear_search_desc);

	var ds = new YAHOO.util.DataSource();
	ds.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;
//	ds.responseType = YAHOO.util.DataSource.TYPE_JSON;

	ds.responseSchema =
        {
		fields: ["id", "status", "desc", "global_status", "group_status"]
	};

	var s = layout.getSizes();
	var w = s.center.w;
	if(g_brow != 1)
		w -= 84;

	var myColumnDefs =
	[
        	{key:"id", label:"<div align='left'><b>"+lang_global["sig_id"]+"</b></div>",  formatter: YAHOO.widget.DataTable.formatText, width: 95},
                {key:"status", label:"<div align='left'><b>"+lang_global["status"]+"</b></div>", sortable:false, /*formatter: YAHOO.widget.DataTable.formatText,*/ width: 82},
                {key:"desc", label:"<div align='left'><b>"+lang_global["desc"]+"</b></div>", formatter:YAHOO.widget.DataTable.formatText, sortable:false, width: w-95-82},
		{key:"global_status"},
		{key:"group_status"}
        ];

	var oConfig =
        {
		MSG_ERROR: "",
		paginator: g_page,
		width: w
        };

	g_dt = new YAHOO.widget.DataTable(type == 0?"DataTable":"DataSearch", myColumnDefs, ds, oConfig);

	var columnsets = g_dt.getColumnSet();
	g_dt.hideColumn(columnsets.getColumn("global_status"));
	g_dt.hideColumn(columnsets.getColumn("group_status"));


	g_dt.subscribe("rowClickEvent", g_dt_SelectRow);

	g_contextMenu = new YAHOO.widget.ContextMenu("mytablemenu",
				{
					trigger: "DataTable",
					lazyload: true
				});

	g_contextMenu.subscribe("beforeShow", onTableBeforeShow);

	AddTableData(type);
}

function onTableBeforeShow(p_sType, p_aArgs)
{
	var target = this.contextEventTarget;

	var row = g_dt.getTrEl(target);

	g_dt_SelectRow(row.sectionRowIndex);

	var items;

	if(g_dt)
	{
		global_status = (row.children[3].innerHTML.indexOf("1")>=0)? 1: 0;
		group_status  = (row.children[4].innerHTML.indexOf("1")>=0)? 1: 0;

		if(is_default==1){
			items = [
				{text:lang_global["enable"], disabled: true},
				{text:lang_global["disable_in_global"], disabled: true},
				{text:lang_global["disable_in_group"], disabled: true}
			];
		}else if(global_status == 1 && group_status == 1){
			items = [
				{text:lang_global["enable"], disabled: true},
				{text:lang_global["disable_in_global"], onclick: {fn: global_status_disable}},
				{text:lang_global["disable_in_group"], onclick: {fn: group_status_disable}}
			];
		}else if((row.children[3].innerHTML.indexOf("0")>=0) || (row.children[4].innerHTML.indexOf("0")>=0)){
			items = [
                                {text:lang_global["enable"], onclick: {fn: g_dt_enable}},
                                {text:lang_global["disable_in_global"], disabled: true},
                                {text:lang_global["disable_in_group"], disabled: true}
                        ];
		}

		this.clearContent();
		this.addItems(items);
		this.render();
	}
}

function g_dt_enable(){
	filter_UpdateStatus(1, 1);
}

function global_status_disable(){
	filter_UpdateStatus(0, group_status);
}

function group_status_disable(){
	filter_UpdateStatus(global_status, 0);
}

function g_dt_SelectRow(e){
	if(typeof(e)=="number"){
		var row=g_dt.getTrEl(e);
	}else{
		var line=e.target;
                var row=g_dt.getTrEl(line);
	}

	if(g_dt_selected_row == row){
		return;
	}
	g_dt_selected_row = row;

	var record=g_dt.getRecord(row);
	g_dt._oAnchorRecord=record;
	g_dt.unselectAllRows();
	g_dt.selectRow(record);

	var recordSet = g_dt.getRecordSet();
	var index = recordSet.getRecordIndex(record);

	var desc = record.getData("desc");
	var id = record.getData("id");

	InitTabview(id, desc);
	// if(record.getData('has_score') == 0) {
	// 	YAHOO.util.Dom.setStyle('sigScoreDiv','display','none');
	// }else{
	 	YAHOO.util.Dom.setStyle('sigScoreDiv','display','');
	// }
}

function clearTabs()
{
	if(!g_tabview)
		return;

	var tabList = g_tabview.get("tabs");
	var len = tabList.length;

	for(var i = 0; i < len; i++)
	{
		var tab = tabList[0];
		g_tabview.removeTab(tab);
	}
}

function clearSamTabs()
{
	if(!s_tabview)
		return;

	var tabList = s_tabview.get("tabs");
	var len = tabList.length;

	for(var i = 0; i < len; i++)
	{
		var tab = tabList[0];
		s_tabview.removeTab(tab);
	}
}

function validate_name()
{
	newObj = new me_object(YAHOO.util.Dom.get('new_name').value);
	addNewObj = change_name;
	popup("/waf/pcre_expression/validate?redir=/success&mkey=0","me_dlg_popup", 550, 400);
}

function validate_value()
{
	newObj = new me_object(YAHOO.util.Dom.get('new_value').value);
	addNewObj = change_value;
	popup("/waf/pcre_expression/validate?redir=/success&mkey=0","me_dlg_popup", 550, 400);
}

function me_object(name)
{
	this.name = name;
}

function change_name()
{
	YAHOO.util.Dom.get('new_name').value = newObj.name;
}

function change_value()
{
	YAHOO.util.Dom.get('new_value').value = newObj.name;
}

// filters qlist
function sub_setup_qlist(q, prefix)
{
	q.prefix = prefix;
	q.id = prefix + "_list";
	q.hdr_cb = prefix + "_qlist_hdr_cb";

	q.init();

	var menubar_id = "qlist_yui_menubar_" + prefix;
	var menu_container_id = "qlist_yui_menubar_container_" + prefix;
	var menubar_container = document.getElementById(menu_container_id);

	var oMB = qmenu_create_menubar(menubar_id, q, is_default? 0:2);
	oMB.render(menubar_container);
	q.setup_listitem_event_handlers();
	q.init_menubutton_state();
	q.build_context_menu();
}

function sub_click_create(q)
{
	is_insert = false;
	fill_exception(default_excp);
	update_exception(true);
}

function sub_click_edit(q)
{
	var obj = {};

	var aElems = qlist_sub.get_checked_rows();
	if(aElems.length != 1)	return;

	var o = aElems[0];

	var elems = ['id', 'match_target', 'operation', 'value', 'concat', 'method', 'name', 'value_check', 'ip'];
	for(var i = 0; i < elems.length; i++)
		obj[elems[i]] = o.getAttribute(elems[i]);

	is_insert = false;
	if(obj.value_check == "false")
		obj.value_check = false;
	else if(obj.value_check == "true")
		obj.value_check = true;
	fill_exception(obj);
	update_exception(true);
}

function sub_click_delete(q)
{
	if (!confirm(lang_global['del_confirm']))
		return;

	var str_id = '';

	var aElems = qlist_sub.get_checked_rows();
	if(aElems.length <= 0)	return;

	for(var i = 0; i < aElems.length; i++)
	{
		var id = aElems[i].getAttribute('id');
		str_id += '&id=' + id;
	}

	var sUrl = "/signature/sig_del_filter";

	var callback = {

		success: function(oResponse) {
			g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status==1){
				buildFilterTable(results.filters);
				YAHOO.util.Dom.get("concat_div").innerHTML = results.concat?results.concat:"";
			}else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},

		failure: function(oResponse) {
			g_wait.hide();
		},

		timeout: 70000
	};

	g_wait.show();
	YAHOO.util.Connect.asyncRequest('POST', sUrl, callback, "mkey="+mkey+str_id+"&sig_id="+sig_id+"&session_id="+lang_global["session_id"]);
}

function sub_click_insert(q)
{
	var aElems = qlist_sub.get_checked_rows();
	if(aElems.length != 1)  return;

	selected_id = aElems[0].getAttribute('id');

	is_insert = true;
	fill_exception(default_excp);
	update_exception(true);
}

function sub_click_view(q)
{
}

function sub_handler_selection_change(q)
{
	qlist_handle_selection_change(q);
	var aElems = q.get_checked_rows();

	qmenu_enable_button($('#mi_create'), true, q);
	if(aElems.length > 0)
		qmenu_enable_button($('#mi_del'), true, q);
	else
		qmenu_enable_button($('#mi_del'), false, q);

	if(aElems.length != 1)
	{
		qmenu_enable_button($('#mi_edit'), false, q);
		qmenu_enable_button($('#mi_insert'), false, q);
		qmenu_enable_button($('#mi_view'), false, q);
	}
	else
	{
		qmenu_enable_button($('#mi_edit'), true, q);
		qmenu_enable_button($('#mi_insert'), true, q);
		qmenu_enable_button($('#mi_view'), true, q);
	}
}

function sub_menu(aItems)
{
	var Item;

	if(is_rw_admin)
	{
		Item = Page.createMenuItem({id: 'mi_create', spriteClass: "tool_new", ctxt: true, text: lang_global['create'], click: {fn: sub_click_create}});
		aItems.push(Item);

		Item = Page.createMenuItem({id: 'mi_edit', spriteClass: "tool_edit", ctxt: true, text: lang_global['edit'], click: {fn: sub_click_edit}});
		aItems.push(Item);

		Item = Page.createMenuItem({id: 'mi_del', spriteClass: "tool_delete", ctxt: true, text: lang_global['delete'], click: {fn: sub_click_delete}});
		aItems.push(Item);

		Item = Page.createMenuItem({id: 'mi_insert', spriteClass: "tool_insert", ctxt: true, text: lang_global['insert'], click: {fn: sub_click_insert}});
		aItems.push(Item);
	}
	else
	{
		Item = Page.createMenuItem({id: 'mi_view', spriteClass: 'tool_view', ctxt: true, text: lang_global['view'], click: {fn: sub_click_view}});
		aItems.push(Item);
	}
}

function move_except(id, flag)
{
	if(!id || !flag)  return;

	var len = qlist_sub.jc_qlist_rows.length;
	var dstIndex = -1, srcIndex = -1;

	for(var i = 0; i < len; i++)
	{
		var r = qlist_sub.jc_qlist_rows[i];
		if(r.getAttribute('id') == id)
		{
			srcIndex = i;
			if(flag == 2)
				dstIndex = i - 1;
			else if(flag == 3)
				dstIndex = i + 1;
			break;
		}
	}

	if(srcIndex < 0)        return;
	if(dstIndex >= len || dstIndex < 0)
		return;

	var new_id = qlist_sub.jc_qlist_rows[dstIndex].getAttribute('id');

	var sUrl = '/signature/exception_move';

	g_wait.show();
	YAHOO.util.Connect.asyncRequest('POST', sUrl, filter_callback, 'mkey='+mkey+"&sig_id="+sig_id+'&session_id='+lang_global["session_id"]+'&order='+flag+'&old_id='+id+'&new_id='+new_id + '&time='+(new Date()).toString());
}

function buildFilterTable(data)
{
	if(data == undefined)	return;

	var tab = document.getElementById("sub_list");
	if(!tab)	return;

	var tbody = null;
	for(var i = 0; i < tab.childNodes.length; i++)
	{
		if(tab.childNodes[i].nodeName.toUpperCase() == 'TBODY')
			tbody = tab.childNodes[i];
	}

	if(!tbody)	return;

	// if have rows, remove all first
	var i = 0;
	for(i = tbody.childNodes.length-1; i >= 0; i--)
	{
		tbody.removeChild(tbody.childNodes[i]);
	}

	var j = 0;
	for(i = 0; i < data.length; i++)
	{
		// add concat 'or' row
		if(i != 0 && data[i].concat == 2)
		{
			var tr = document.createElement("tr");
			var td = document.createElement("td");

			tr.className = (j%2 == 0) ? "odd" : "";

			td.colSpan = 3;
			td.innerHTML = 'OR';
			tr.appendChild(td);

			td = document.createElement("td");
			td.colSpan = 2;
			tr.appendChild(td);

			tbody.appendChild(tr);
			j++;
		}

		var tr = document.createElement("tr");
		tr.className = "qlist_row ";
		if(j%2==0)
			tr.className = "qlist_row odd";

		// checkbox
		var td = document.createElement("td");
		td.innerHTML = "<input type='checkbox' class='qlist_cb' />";
		tr.appendChild(td);

		// id
		td = document.createElement("td");
		td.innerHTML = data[i].id;
		tr.appendChild(td);

		// concat
		/*
		td = document.createElement("td");
		var concat = data[i].concat;
		switch(concat)
		{
			case 1:
				td.innerHTML = "And";
				break;
			case 2:
				td.innerHTML = "Or";
				break;
			default:
				break;
		}
		tr.appendChild(td);
		*/

		//element type
		td = document.createElement("td");
		var type = data[i].match_target;
		var str = '';
		switch(type)
		{
			case 1:
				str = lang_global['method'];
				break;
			case 2:
				str = lang_global['client_ip'];
				break;
			case 3:
				str = lang_global['host'];
				break;
			case 4:
				str = lang_global['uri'];
				break;
			case 5:
				str = lang_global['full_url'];
				break;
			case 6:
				str = lang_global['parameter'];
				break;
			case 7:
				str = lang_global['cookie'];
				break;
			case 8:
				str = lang_global['http_header'];
				break;
			default:
				break;
		}
		td.innerHTML = str;
		tr.appendChild(td);

		// value
		td = document.createElement("td");
		if(type != 2)
		{
			if(data[i].value_check == false && (type == 6 || type == 7))
				td.innerHTML = '';
			else if(type == 1)
			{
				var method_val = data[i].method;
				var method_str = '';
				for(var k = 0; k < method_options.length; k++)
				{
					if(method_val & method_options[k].val)
					{
						if(method_str != '')
							method_str += ',';

						method_str += method_options[k].text;
					}
				}
				td.innerHTML = method_str;
			}
			else
				td.appendChild(document.createTextNode(data[i].value));
				//td.innerHTML = data[i].td_value;
		}
		else
			td.innerHTML = data[i].ip;
		tr.appendChild(td);

		// action
		td = document.createElement("td");
		td.innerHTML = '<f-icon class="fa-status-up" title="' + lang_global["moveup"] + '" id="filter_mou'+data[i].id+'" nid='+ data[i].id+'></f-icon>&nbsp;';
		td.innerHTML += '<f-icon class="fa-status-down" title="' + lang_global["movedown"] + '" id="filter_mod'+data[i].id+'" nid='+data[i].id+'></f-icon>';
		tr.appendChild(td);

		tr.setAttribute("q_ref", "0");
		tr.setAttribute("can_delete", "1");
		tr.setAttribute("id", data[i].id);
		tr.setAttribute("match_target", data[i].match_target);
		tr.setAttribute("operation", data[i].operation);
		tr.setAttribute("value", data[i].value);
		tr.setAttribute("concat", data[i].concat);
		tr.setAttribute("method", data[i].method);
		tr.setAttribute("name", data[i].name);
		tr.setAttribute("value_check", data[i].value_check);
		tr.setAttribute("ip", data[i].ip);

		tr.ondblclick = function() {
			sub_click_edit();
		}

		tbody.appendChild(tr);
		j++;

		if(is_default != 1)
		{
			YAHOO.util.Event.addListener('filter_mou'+data[i].id, 'click', function(){
				var nid = this.getAttribute('nid');
				move_except(nid, 2);
			});

			YAHOO.util.Event.addListener('filter_mod'+data[i].id, 'click', function(){
				var nid = this.getAttribute('nid');
				move_except(nid, 3);
			});
		}
	}

	qlist_sub = new Object();
	cloneObject(qlist_obj, qlist_sub);
	qlist_sub.create_edit = false;
	qlist_sub.create_new = false;
	qlist_sub.create_del = false;
	qlist_sub.customize_menu_fn = sub_menu;
	qlist_sub.handle_selection_change_fn = sub_handler_selection_change;
	sub_setup_qlist(qlist_sub, "sub");
}
// end

function InitTabview(id, desc)
{
	var right = layout.getUnitByPosition("right");
        right.set("header", lang_global["sig_id"]+": " + id);

	if(!g_tabview)
	{
		g_tabview = new YAHOO.widget.TabView("tabDiv");
	}

	clearTabs();

	var img_sigs = ['120010001', '120010002', '120010003', '120010004', '120010005', '120020001', '120020002', '120020003','120020004', '120020005', '120030001', '120030002', '120030003', '120030004', '120030005', '120030006'];

	function id_in_array(id)
	{
		var ret = false;
		img_sigs.forEach(function(key) {
			if(id == key)
			ret = true;
		});
		return ret;
	}

	/* added by lk, for SQL injection (syntax bassed detection) signatures, display images, other signatures still display desc, also modify "Found in" field rows attr */
	function AddDescOrImg(id, desc)
	{
		var html = "";

		if(id_in_array(id))
		{
			var img_path = '/signature/png/' + id + '.png';
			html =
				"<tr><td colspan=\"2\" style=\"height: 3px;\"></td></tr>" +
				"<tr>"+
				"<td colspan=\"2\">"+
				"<img src='"+ img_path +"' />"+
				"</td></tr>";
		}
		else
		{
			html = "<tr>"+
				"<td colspan=\"2\"><textarea style=\"width: 100%; padding-right: 5px\" name=\"pattern_area\" readonly=\"true\" rows=\"10\" cols=\"30\">"+
				desc +
				"</textarea>"+
				"</td></tr>";
		}

		return html;
	}

	var rows = id_in_array(id) ? '3' : '10';

	g_tabview.addTab(
	new YAHOO.widget.Tab(
	{
		label: lang_global["sig"],
		content:
			"<div id=\"tab1\" width=\"100%\" height=\"100%\">"+
			"<div height=\"10px\">&nbsp;</div>"+
			"<table width=\"95%\" align=\"center\" class=\"dlg add\">" + 
			"<tbody><tr>"+
			"<td width=\"40%\">"+lang_global["sig_id"]+":" + 
			"</td><td width=\"60%\">" +
			id + 
			"</td></tr>"+
			"<tr><td colspan='3' height='8'></td></tr>"+
			"<td colspan=\"2\" id=\"td_protocol\">" + 
			"</td></tr>"+
			"<tr><td colspan='3' height='8'></td></tr>"+
			"<tr id=\"tr_fpm_disable\"><td width=\"40%\">" + lang_global["fpm_disable"]+":"+"</td>"+
			"<td width=\"60%\">"+
			"<input type=\"checkbox\" id=\"fpm_disable\"  class=\"toggle-switch\"><label for=\"fpm_disable\"></label>"+
			"</td></tr>"+
			"<tr><td colspan='3' height='8'></td></tr>"+
			"<tr><td width=\"40%\">" + lang_global["alert_only"]+":"+"</td>"+
			"<td width=\"60%\">"+
			"<input type=\"checkbox\" id=\"alert_only\"  class=\"toggle-switch\"><label for=\"alert_only\"></label>"+
			"</td></tr>"+
			"<tr><td id=\"attack_reference_title\">"+lang_global["attack_reference"]+":</td></tr>"+
			"<tr><td colspan=\"2\" id=\"attack_reference\"></td></tr>"+
			"<tr>"+
			"<tr><td colspan='3' height='8'></td></tr>"+
			"<td colspan='2'>"+(id_in_array(id)?lang_global["sql_ast"]:lang_global["desc"])+":"+
			"</td></tr>"+
			AddDescOrImg(id, desc) +
/*
			"<tr>"+
			"<td colspan=\"2\"><textarea style=\"width: 100%; padding-right: 5px\" name=\"pattern_area\" readonly=\"true\" rows=\"10\" cols=\"30\">"+
			desc + 
			"</textarea>"+
			"</td></tr>"+
*/
			"<tr><td colspan='3' height='12'></td></tr>"+
			"<tr><td>"+lang_global["meet_target"]+":</td></tr>"+
			"<tr><td colspan=\"2\"><textarea style=\"width: 100%; padding-right: 5px\" name=\"meet_target\" id=\"meet_target\" readonly=\"true\" rows=\""+rows+"\" cols=\"30\">"+
			"</textarea></td></tr>"+
			"</tbody></table>"+
			"</div>"
	}
	)			
	);

	YAHOO.util.Event.addListener("fpm_disable", "change", update_fpm_disable);
	YAHOO.util.Event.addListener("alert_only", "change", update_alert_only);

	g_tabview.addTab(
        new YAHOO.widget.Tab(
        {
                label: lang_global["sig_setting"],
                content:

		"<div id=\"tab3\">"+
		"<div height=\"20px\">&nbsp;</div>"+
		"<div id=\"filterDiv\">"+
		"<div>"+
		lang_global['match_seq']+ ":&nbsp;&nbsp;" +
		"<span id=\"concat_div\"></span>"+
		"</div>"+
		"<div style=\"height: 20px;\"></div>"+
		//"<div><input type=\"button\" class=\"button\" value=\""+lang_global['create']+"\" id=\"btn_create\" />&nbsp;&nbsp;"+
		//"<input type=\"button\" class=\"button\" value=\""+lang_global["insert"]+"\" id=\"btn_insert\" disabled />"+
		//"</div><div style=\"height: 20px;\"></div>"+
		"<div id=\"filters\"></div>"+
		"<div>" +
		"<div id='qlist_hdrbar' class='qlist_hdrbar'>"+
		"	<div id='qlist_yui_menubar_container_sub' style='overflow:hidden'></div>"+
		"	<table id='hrdtc' class=\"container\" cellpadding=\"0\" cellspacing=\"0\">"+
		"		<tr><td colspan=\"2\">"+
		"			<table id=\"qlist_hdrrow_sub\" class=\"list\" align=\"center\" cellspacing=\"1\" cellpadding=\"0\" float=\"0\">"+
		"			</table>"+
		"		</td></tr>"+
		"	</table>"+
		"</div>"+
		"<table id=\"sub_list\" class=\"container list\" cellspacing=\"1\" cellpadding=\"0\" align=\"center\">"+
		"<thead><tr class=\"heading\">"+
		"<th width=\"5%\"><input id=\"sub_qlist_hdr_cb\" class=\"qlist_cb_hdr\" type=\"checkbox\" /></th>"+
		"<th width=\"5%\"><b>"+ lang_global['id']+ "</b></th>"+
		//"<th width=\"20%\"><b>"+ lang_global['concat']+ "</b></th>"+
		"<th width=\"20%\"><b>"+ lang_global['elem_type']+ "</b></th>"+
		"<th width=\"50%\"><b>"+ lang_global['value']+ "</b></th>"+
		"<th width=\"10%\"><b>"+ lang_global['move']+ "</b></th>"+
		"</tr><thead>"+
		"<tbody></tbody>"+
		"</table>"+
		"</div>"+
		"</div>"+
		/*
		"<div id=\"oper_div\" class=\"\" style=\"width: 99%; position: absolute; bottom: 0; left: 0px; right: 0px; zoom: 1; background: url(/build/assets/skins/sam/sprite.png) ; repeat-x 0 -1400px; border: solid 1px #808080; height: 21px;\">"+
		"<h2 id=\"excp_title\" style=\"text-align:left; font-weight:bold;padding:3px;\">Edit Exception</h2>"+
		"<div id=\"collapse_div\" style=\"cursor: pointer; height: 13px; position: absolute; right: 2px; top: 2px; width: 17px; border: 1px solid #808080; background: url('/build/assets/skins/sam/layout_sprite.png') no-repeat scroll -20px -260px; display: none;\"></div>"+
		"<div id=\"expand_div\" style=\"cursor: pointer; height: 13px; position: absolute; right: 2px; top: 2px; width: 17px; border: 1px solid #808080; background: url('/build/assets/skins/sam/layout_sprite.png') no-repeat scroll -20px -180px;\"></div>"+
		"</div>"+
		*/
		"<div id=\"exceptionDiv\" style=\"display: none;\">"+
		"<table width=\"95%\" align=\"center\"  class=\"dlg add1\">"+
		"<tbody>"+
		"<tr><td colspan=2 height=\"30px\"></td></tr>"+
		"<tr><td width=\"40%\">ID</td><td id=\"filter_id\">Auto</td></tr>"+
		"<tr><td width=\"40%\">"+lang_global["elem_type"]+"</td><td><select id=\"new_match_target\" style=\"width: 180px\">"+
		"<option value=\"1\">"+lang_global["method"]+"</option>"+
		"<option value=\"2\">"+lang_global["client_ip"]+"</option>"+
		"<option value=\"3\">"+lang_global["host"]+"</option>"+
		"<option value=\"4\">"+lang_global["uri"]+"</option>"+
		"<option value=\"5\">"+lang_global["full_url"]+"</option>"+
		"<option value=\"6\">"+lang_global["parameter"]+"</option>"+
		"<option value=\"7\">"+lang_global["cookie"]+"</option>"+
		"<option value=\"8\">"+lang_global["http_header"]+"</option>"+
		"</select>"+
		"</td></tr>"+
		"<tr><td width=\"40%\">"+lang_global["operation"]+"</td><td><select id=\"new_operation\" style=\"width: 180px; font-size: 11px;\">"+
		"<option value=\"1\">"+lang_global["str_match"]+"</option>"+
		"<option value=\"2\">"+lang_global["reg_match"]+"</option>"+
		"<option value=\"3\">"+lang_global["eq"]+"</option>"+
		"<option value=\"4\">"+lang_global["ne"]+"</option>"+
		"<option value=\"5\">"+lang_global["include"]+"</option>"+
		"<option value=\"6\">"+lang_global["exclude"]+"</option>"+
		"</select></td></tr>"+
		"<tr id=\"tr_m1\"><td width=\"40%\">"+lang_global["method"]+"</td><td>"+
		"<table width=\"240\"><tr>"+
		"<td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_GET\" />GET&nbsp;&nbsp;</td><td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_POST\" />POST&nbsp;&nbsp;</td><td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_HEAD\" />HEAD</td>"+
		"</tr></table>"+
		"</td></tr>"+
		"<tr id=\"tr_m2\"><td width=\"40%\">"+""+"</td><td>"+
		"<table width=\"240\"><tr>"+
		"<td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_OPTIONS\" />OPTIONS&nbsp;&nbsp;</td><td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_TRACE\" />TRACE&nbsp;&nbsp;</td><td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_CONNECT\" />CONNECT</td>"+
		"</tr></table>"+
		"</td></tr>"+
		"<tr id=\"tr_m3\"><td width=\"40%\">"+""+"</td><td>"+
		"<table width=\"240\"><tr>"+
		"<td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_DELETE\" />DELETE&nbsp;&nbsp;</td><td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_PUT\" />PUT&nbsp;&nbsp;</td><td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_PATCH\" />PATCH&nbsp;&nbsp;</td>"+
		"</tr></table>"+
		"</td></tr>"+
		"<tr id=\"tr_m4\"><td width=\"40%\">"+""+"</td><td>"+
		"<table width=\"240\"><tr>"+
		"<td style=\"width: 33%\"><input type=\"checkbox\" id=\"method_OTHERS\" />OTHERS</td>"+
		"</tr></table>"+
		"</td></tr>"+
		"<tr id=\"tr_ip\"><td width=\"40%\">"+lang_global["client_ip"]+"</td><td><input id=\"new_ip\" value=\"\" />"+
		"</td></tr>"+
		"<tr id=\"tr_ip_tip\" style=\"font-style: italic;\"><td>&nbsp;</td><td>" + lang_global["client_ip_tip"] + "</td></tr>"+ 
		"<tr id=\"tr_name\"><td width=\"40%\">"+lang_global["name"]+"</td><td style=\"white-space:nowrap;\"><input id=\"new_name\" maxlength=\"2048\" value=\"\" />"+
		"&nbsp;&nbsp;<a id=\"valid_name\"><f-icon class=\"ftnt-expand-arrow\" style=\"cursor: pointer;\"></f-icon></a>"+
		"</td></tr>"+
		"<tr id=\"tr_check_value\"><td width=\"40%\">"+lang_global["value_check"]+"</td><td><input type=\"checkbox\" id=\"new_value_check\" class=\"toggle-switch\"/><label for=\"new_value_check\"></label>"+
		"</td></tr>"+
		"<tr id=\"tr_value\"><td width=\"40%\">"+lang_global["value"]+"</td><td style=\"white-space:nowrap;\"><input id=\"new_value\" maxlength=\"2048\" value=\"\" />"+
		"&nbsp;&nbsp;<a id=\"valid_value\"><f-icon class=\"ftnt-expand-arrow\" style=\"cursor: pointer;\"></f-icon></a>"+
		"</td></tr>"+
		"<tr id=\"tr_tip\" style=\"font-style:italic;\"><td colspan=\"2\" id=\"tip_msg\">"+
		"</td></tr>"+
		"<tr><td width=\"40%\">"+lang_global["concat"]+"</td><td class=\"radio-group\">"+
		"<input type=\"radio\" name=\"new_concat\" id=\"new_concat_1\" value=\"1\" /> "+"<label for=\"new_concat_1\">And</label>"+
		"<input type=\"radio\" name=\"new_concat\" id=\"new_concat_2\" value=\"2\" /> "+"<label for=\"new_concat_2\">Or</label>"+"&nbsp;&nbsp;"+
//		"<input type=\"radio\" name=\"new_concat\" value=\"3\" /> "+"Super Or"+
		"</td></tr>"+
		"<tr><td colspan=2 height=\"50px\"></td></tr>"+
		"<tr><td colspan=2 align=\"center\">"+
		"<table class=\"footer\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td>"+
		(is_default ? "<input type=\"submit\" class=\"button\" value=\""+lang_global["cancel"]+"\" id=\"btn_cancel\" />":
		 "<input type=\"submit\" class=\"button\" value=\""+lang_global["apply"]+"\" id=\"btn_apply\" style=\"width: 100px\" />&nbsp;&nbsp;<input type=\"button\" class=\"button\" value=\""+lang_global["cancel"]+"\" id=\"btn_cancel\" style=\"width:100px\" />")+
		"</td></tr></table>"+
		"</td></tr>"+
		"</tbody></table>"+
		"</div>"+
		"</div>"
	}
	));

	YAHOO.util.Event.on('collapse_div', 'click', function(){
		update_exception(false);
	});

	YAHOO.util.Event.on('expand_div', 'click', function() {
		update_exception(true);
	});

	update_exception(false);

	YAHOO.util.Event.addListener("delete_filter", "click", filter_DeleteRow);
	YAHOO.util.Event.addListener("new_filter", "click", filter_AddRow);
	YAHOO.util.Event.addListener("btn_cancel", "click", function() {
		update_exception(false);
	});
	YAHOO.util.Event.addListener("new_value_check", "click", function() {
		update_value_check(YAHOO.util.Dom.get("new_value_check"));
	});

	YAHOO.util.Event.addListener("valid_name", "click", validate_name);
	YAHOO.util.Event.addListener("valid_value", "click", validate_value);

	YAHOO.util.Event.addListener("new_match_target", "change", function(){
		update_exception_type(YAHOO.util.Dom.get("new_match_target"), YAHOO.util.Dom.get("new_operation").value);
	});
	YAHOO.util.Event.addListener("new_operation", "change", function(){
		update_operation();
	});

	YAHOO.util.Event.addListener("btn_apply", "click", function(){
		apply_exception();
	});
	
	/* for score */	
		g_tabview.addTab(
	new YAHOO.widget.Tab(
	{
		id:"sigScoreDiv",
		label: lang_global["sig_score_tab"],
		content:
			"<div id=\"tabScore\" width=\"100%\" height=\"100%\">"+
			"<div height=\"10px\">&nbsp;</div>"+
			"<table width=\"95%\" align=\"center\" class=\"dlg add\">" + 
			"<tbody>"+
			"<tr><td colspan='2' height='8'></td></tr>"+			
			"<tr><td width='100px'>"+lang_global["sig_score"]+":</td><td>"+
			"<div class=\"content\">"+
			"  <div class=\"field\">"+
			"    <div id=\"sig-slider\" class=\"level-slider\" data-default-level=\"0\" default_score=\"0\" style=\"margin-top:8px\">"+
			"      <span class=\"slider-level-disable-text\" style=\"display:none\">OFF</span>"+
			"    </div>"+
			"    <div  style=\"white-space:nowrap;\">"+			
			"      <span class=\"slider-label-text\" style=\"width: 200px;margin-top:6px\"></span>"+
			"      <input name=\"sig-score\" id=\"sig-score\" value=\"0\" type=\"hidden\"/>"+
			"    </div>"+
			"  </div>"+
			"</div>"+
			"</td></tr>"+
			// "<tr><td colspan='2' height='8'></td></tr>"+			
			// "<tr id=\"tr_override\"><td>" + lang_global["override"]+"</td>"+
			// "<td>&nbsp;&nbsp;&nbsp;<input type=\"checkbox\" id=\"override\" />&nbsp;&nbsp;" + lang_global["override_tip"]+"</td>"+
			// "</tr>"+		
			"<tr><td colspan='2' height='8'></td></tr>"+
			"<tr><td colspan=2>"+
			"<input type=\"button\" class=\"button\" value=\""+lang_global["restore"]+"\" id=\"btn_restore\" style=\"width: 150px\" />"+
			"</td></tr>"+	
			"</tbody></table>"+
			"</div>"
	}
	)			
	);
	//YAHOO.util.Event.addListener("override", "change", set_override);
	YAHOO.util.Event.addListener("btn_restore", "click", restore_score);	

	if(is_default==1){
		YAHOO.util.Dom.get("alert_only").disabled = true;
		//YAHOO.util.Dom.get("override").disabled = true;
		YAHOO.util.Dom.get("btn_restore").disabled = true;
	}

	g_tabview.set("activeIndex", 0);

	/*this for sample tab*/
	if(!s_tabview)
	{
		s_tabview = new YAHOO.widget.TabView("match_sample");
	}

	clearSamTabs();

	s_tabview.addTab(
		new YAHOO.widget.Tab(
		{
			id:"samTab1",
			label: "HTTP1.X",
			content:
				"<div id=\"match_sample1\" width=\"100%\" height=\"100%\">"+
				"</div>"
		}
		)
	);	
	s_tabview.addTab(
		new YAHOO.widget.Tab(
		{
			id:"samTab2",
			label: "HTTP2",
			content:
				"<div id=\"match_sample2\" width=\"100%\" height=\"100%\">"+
				"</div>"
		}
		)			
	);	

	s_tabview.set("activeIndex", 0);

	get_signature_detail(id);
}

function update_exception(is_expand)
{
	YAHOO.util.Dom.setStyle('filterDiv', 'display', is_expand?'none':'');
	YAHOO.util.Dom.setStyle('exceptionDiv', 'display', is_expand?'':'none');

}

function getRadios(name)
{
	var elts = document.getElementsByTagName("input");
	var count = 0;
	var elements = [];
	for(var i = 0; i < elts.length; i++){
		if(elts[i].getAttribute("name") == name){
			elements[count++] = elts[i];
		}
	}
	return elements; 
}

function apply_exception()
{
	var new_match_target = YAHOO.util.Dom.get("new_match_target");
	var new_operation = YAHOO.util.Dom.get("new_operation");
	var new_ip = YAHOO.util.Dom.get("new_ip");
	var new_name = YAHOO.util.Dom.get("new_name");
	var new_value_check = YAHOO.util.Dom.get("new_value_check");
	var new_value = YAHOO.util.Dom.get("new_value");
	var new_id = YAHOO.util.Dom.get("filter_id");
	var id_val = new_id.innerHTML == 'Auto' ? 0 : new_id.innerHTML;
	var new_concat = getRadios("new_concat");

	var method_val = 0;
	for(var i = 0; i < method_options.length; i++)
	{
		var item = YAHOO.util.Dom.get('method_'+method_options[i].text);
		if(item.checked)
			method_val += method_options[i].val;
	}

	var concat_val = 0;
	for(var i = 0; i < new_concat.length; i++)
	{
		if(new_concat[i].checked == true)
		{
			concat_val = new_concat[i].value;
			break;
		}
	}

	// check before submit
	if(new_match_target.value == 2)
	{
		if(new_ip.value == '')
		{
			alert(lang_global["err_client_ip"]);
			return false;
		}
	}
	else if(new_match_target.value == 6 || new_match_target.value == 7 || new_match_target.value == 8)
	{
		if(new_name.value == '')
		{
			alert(lang_global["err_name"]);
			return false;
		}

		if(new_value_check.checked == true)
		{
			if(new_value.value == '')
			{
				alert(lang_global["err_value"]);
				return false;
			}
		}
	}
	else if(new_match_target.value == 3 || new_match_target.value == 4 || new_match_target.value == 5)
	{
		if(new_value.value == '')
		{
			alert(lang_global["err_value"]);
			return false;
		}
		else
		{
			if(new_operation.value == 1 && new_value.value[0] != '/' && (new_match_target.value == 4 || new_match_target.value == 5))
			{
				alert(lang_global["err_request_file"]);
				return false;
			}
		}
	}

	var sUrl = "/signature/sig_add_filter";

	var callback = {

		success: function(oResponse) {
			g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status==1){
				buildFilterTable(results.filters);
				update_status_of_g_dt_selected_row(1);

				YAHOO.util.Dom.get("concat_div").innerHTML = results.concat?results.concat:"";

				update_exception(false);
				//YAHOO.util.Dom.get('btn_insert').disabled = true;
				selected_id = -1;
				//filters_selected_row = null;
			}else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},

		failure: function(oResponse) {
			g_wait.hide();
		},

		timeout: 70000
	};

	var ext_str = (is_insert) ? "&insert=1&oid="+selected_id : "";

	g_wait.show();
	YAHOO.util.Connect.asyncRequest('POST', sUrl, callback, "mkey="+mkey+"&sig_id="+sig_id+"&session_id="+lang_global["session_id"]+"&id="+id_val+"&method="+method_val+"&match_target="+new_match_target.value+"&operation="+new_operation.value+"&ip="+new_ip.value+"&name="+encodeURIComponent(new_name.value)+"&value="+encodeURIComponent(new_value.value)+"&value_check="+(new_value_check.checked?1:0)+"&concat="+concat_val+ext_str);
}

function fill_exception(excp)
{
	if(excp == undefined)
		return;

	var filter_id = YAHOO.util.Dom.get("filter_id");
	var new_match_target = YAHOO.util.Dom.get("new_match_target");
	var new_operation = YAHOO.util.Dom.get("new_operation");
	var new_ip = YAHOO.util.Dom.get("new_ip");
	var new_name = YAHOO.util.Dom.get("new_name");
	var new_value_check = YAHOO.util.Dom.get("new_value_check");
	var new_value = YAHOO.util.Dom.get("new_value");
	var new_concat = getRadios("new_concat");

	filter_id.innerHTML = excp.id ? excp.id : "Auto";
	new_ip.value = excp.ip;
	new_name.value = excp.name;
	new_value_check.checked = excp.value_check ? true : false;
	new_value.value = excp.value;
	new_match_target.value = excp.match_target;
	new_operation.value = excp.operation;

	for(var i = 0; i < new_concat.length; i++)
	{
		if(new_concat[i].value == excp.concat)
			new_concat[i].checked = true;
	}

	for(var i = 0; i < method_options.length; i++)
	{
		var m = YAHOO.util.Dom.get("method_"+method_options[i].text);
		m.checked = false;
		if(excp.method & method_options[i].val)
			m.checked = true;
	}

	update_exception_type(new_match_target, excp.operation);
}

function update_value_check(obj)
{
	if(obj == undefined)	return;

	if(obj.checked)
		YAHOO.util.Dom.get('tr_value').style.display = '';
	else
		YAHOO.util.Dom.get('tr_value').style.display = 'none';
}

function update_exception_type(obj, operation)
{
	if(obj == undefined)    return;

	var val = obj.value;

	YAHOO.util.Dom.get('tr_ip').style.display = 'none';
	YAHOO.util.Dom.get('tr_ip_tip').style.display = 'none';
	YAHOO.util.Dom.get('tr_m1').style.display = 'none';
	YAHOO.util.Dom.get('tr_m2').style.display = 'none';
	YAHOO.util.Dom.get('tr_m3').style.display = 'none';
	YAHOO.util.Dom.get('tr_m4').style.display = 'none';
	YAHOO.util.Dom.get('tr_value').style.display = 'none';
	YAHOO.util.Dom.get('tr_name').style.display = 'none';
	YAHOO.util.Dom.get('tr_check_value').style.display = 'none';
	YAHOO.util.Dom.get('tr_tip').style.display = 'none';
	YAHOO.util.Dom.get('tip_msg').innerHTML = '';

	if(val == 1)
	{
		YAHOO.util.Dom.get('tr_m1').style.display = '';
		YAHOO.util.Dom.get('tr_m2').style.display = '';
		YAHOO.util.Dom.get('tr_m3').style.display = '';
		YAHOO.util.Dom.get('tr_m4').style.display = '';
		YAHOO.util.Dom.get('tr_tip').style.display = '';
		if(operation == 5)
		{
			YAHOO.util.Dom.get('tip_msg').innerHTML = lang_global['tip_http_include'];
		}
		else if(operation == 6)
		{
			YAHOO.util.Dom.get('tip_msg').innerHTML = lang_global['tip_http_exclude'];
		}
	}
	else if(val == 2)
	{
		YAHOO.util.Dom.get('tr_ip').style.display = '';
		YAHOO.util.Dom.get('tr_ip_tip').style.display = '';
		YAHOO.util.Dom.get('tr_tip').style.display = '';
		if(operation == 3)
		{
			YAHOO.util.Dom.get('tip_msg').innerHTML = lang_global['tip_client_ip_equal'];
		}
		else if(operation == 4)
		{
			YAHOO.util.Dom.get('tip_msg').innerHTML = lang_global['tip_client_ip_not_equal'];
		}
	}
	else if(val == 6 || val == 7 || val == 8)
	{
		YAHOO.util.Dom.get('tr_name').style.display = '';
		YAHOO.util.Dom.get('tr_check_value').style.display = '';
		YAHOO.util.Dom.get('tr_value').style.display = '';
		update_value_check(YAHOO.util.Dom.get('new_value_check'));
	}
	else if(val == 3 || val == 4 || val == 5)
	{
		YAHOO.util.Dom.get('tr_value').style.display = '';
	}

	var oper_select = YAHOO.util.Dom.get("new_operation");
	oper_select.length = 0;
	if(val == 1)
	{
		for(var i = 0; i < method_oper.length; i++)
		{
			var item = new Option(lang_global[oper_actions[method_oper[i]]], method_oper[i]);
			oper_select.options.add(item);
			if(operation == oper_select.options[i].value)
				oper_select.options[i].selected = true;
		}
	}
	else if(val == 2)
	{
		for(var i = 0; i < ip_oper.length; i++)
		{
			var item = new Option(lang_global[oper_actions[ip_oper[i]]], ip_oper[i]);
			oper_select.options.add(item);
			if(operation == oper_select.options[i].value)
				oper_select.options[i].selected = true;
		}
	}
	else
	{
		for(var i = 0; i < other_oper.length; i++)
		{
			var item = new Option(lang_global[oper_actions[other_oper[i]]], other_oper[i]);
			oper_select.options.add(item);
			if(operation == oper_select.options[i].value)
				oper_select.options[i].selected = true;
		}
	}

	update_operation();
}

function update_operation()
{
	var oper_var = YAHOO.util.Dom.get("new_operation").value;
	var elem_type = YAHOO.util.Dom.get("new_match_target").value;
	YAHOO.util.Dom.get('tr_tip').style.display = 'none';
	YAHOO.util.Dom.get("tip_msg").innerHTML = '';

	if(oper_var == 2)
	{
		YAHOO.util.Dom.get('valid_name').style.display = '';
		YAHOO.util.Dom.get('valid_value').style.display = '';
	}
	else
	{
		YAHOO.util.Dom.get('valid_name').style.display = 'none';
		YAHOO.util.Dom.get('valid_value').style.display = 'none';
	}

	if(elem_type == 2)
	{
		YAHOO.util.Dom.get('tr_tip').style.display = '';
		if(oper_var == 3)
			YAHOO.util.Dom.get('tip_msg').innerHTML = lang_global['tip_client_ip_equal'];
		else if(oper_var == 4)
			YAHOO.util.Dom.get('tip_msg').innerHTML = lang_global['tip_client_ip_not_equal'];
	}
	else if(elem_type == 1)
	{
		YAHOO.util.Dom.get('tr_tip').style.display = '';
		if(oper_var == 5)
			YAHOO.util.Dom.get('tip_msg').innerHTML = lang_global['tip_http_include'];
		else if(oper_var == 6)
			YAHOO.util.Dom.get('tip_msg').innerHTML = lang_global['tip_http_exclude'];
	}
}

/*
function update_host_status(){
	var new_host = YAHOO.util.Dom.get("new_host");
	if (YAHOO.util.Dom.get("new_host_status").checked){
		new_host.disabled=false;
	}else{
		new_host.disabled=true;
		new_host.value = "";
	}
}
*/

function update_fpm_disable()
{
	var sUrl = "/signature/set_fpm_disable";
	var fpm_disable = YAHOO.util.Dom.get("fpm_disable");
	//not checked means fpm disable, should be appended to fpm_disable_list
	var status = fpm_disable.checked ? 0 : 1;

	var callback = {
		success: function(oResponse){
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status == 1){
				var fpm_disable = YAHOO.util.Dom.get('fpm_disable');
				fpm_disable.checked = (results.fpm_disable == 0);
			}
			else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},
		failure: function(oResponse){
		},
		timeout: 70000
	};

	YAHOO.util.Connect.asyncRequest("POST", sUrl, callback, "mkey=" + mkey + "&status=" + status + "&signature_id=" + sig_id+"&session_id="+lang_global["session_id"]);
}

function update_alert_only()
{
	var sUrl = "/signature/set_sig_alert_only";
	var alert_only = YAHOO.util.Dom.get("alert_only");
	var status = alert_only.checked ? 1 : 0;

	var callback = {
		success: function(oResponse){
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status == 1){
				var alert_only = YAHOO.util.Dom.get('alert_only');
				alert_only.checked = (results.alert_only == 1);
			}
			else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},
		failure: function(oResponse){
		},
		timeout: 70000
	};

	YAHOO.util.Connect.asyncRequest("POST", sUrl, callback, "mkey=" + mkey + "&status=" + status + "&signature_id=" + sig_id+"&session_id="+lang_global["session_id"]);
}

/*
function set_override()
{
	var sUrl = "/signature/set_override";
	var override = YAHOO.util.Dom.get("override");
	var status = override.checked ? 1 : 0;

	var callback = {
		success: function(oResponse){
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status == 1){
				var override = YAHOO.util.Dom.get('override');
				var restore = YAHOO.util.Dom.get('btn_restore');
				restore.disabled = override.checked ? true : false;				
				$j('#sig-slider').attr('data-default-level', 4);
				YAHOO.util.Dom.get('sig-score').value = 4;
				setup_sliders();

			}
			else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},
		failure: function(oResponse){
		},
		timeout: 7000
	};

	YAHOO.util.Connect.asyncRequest("POST", sUrl, callback, "mkey=" + mkey + "&status=" + status + "&signature_id=" + sig_id+"&session_id="+lang_global["session_id"]);
}
*/

function set_score(val)
{
	var default_score = YAHOO.util.Dom.getAttribute("sig-slider", "default_score");
	//if(YAHOO.util.Dom.get("override").checked){
        //return;
	//} 
	if(val > 4 || val < 0 || is_default == 1) return;
	

	if(val== default_score || (default_score == 8340 && val == 4))
	{
		YAHOO.util.Dom.get("btn_restore").disabled = true;
		//return;
	}else{
		YAHOO.util.Dom.get("btn_restore").disabled = false;
	}
	var sUrl = "/signature/set_sig_score";
	

	var callback = {
		success: function(oResponse){
			var results = eval("(" + oResponse.responseText + ")");
			if(results.sig_score >= 0 && results.sig_score < 6){
				var sig_score = YAHOO.util.Dom.get('sig-score');
				sig_score.value = results.sig_score -1;
			}
			else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},
		failure: function(oResponse){
		},
		timeout: 70000
	};

	YAHOO.util.Connect.asyncRequest("POST", sUrl, callback, "mkey=" + mkey + "&sig_score=" + parseInt(val) + "&signature_id=" + sig_id+"&session_id="+lang_global["session_id"]);
}

function restore_score()
{
	var sUrl = "/signature/restore_sig_score";

	var callback = {
		success: function(oResponse){
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status == 1){
				var restore = YAHOO.util.Dom.get('btn_restore');
				restore.disabled = true;
				var default_score = $j('#sig-slider').attr('default_score');
				if(default_score == 8340){
					$j('#sig-slider').attr('data-default-level', 4);					
					YAHOO.util.Dom.get('sig-score').value = 4;	
					// var override = YAHOO.util.Dom.get('override');
					// override.checked = true;
				}else{
					$j('#sig-slider').attr('data-default-level', default_score);					
					YAHOO.util.Dom.get('sig-score').value = default_score;						
				}	
				setup_sliders();		
			}
			else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},
		failure: function(oResponse){
		},
		timeout: 70000
	};

	YAHOO.util.Connect.asyncRequest("POST", sUrl, callback, "mkey=" + mkey + "&signature_id=" + sig_id+"&session_id="+lang_global["session_id"]);
}

function get_signature_detail(id)
{
	sig_id = id;

	//g_wait.show();

	var sUrl = "/signature/sig_detail?sig_id="+id+"&mkey="+mkey+"&main_class_id="+g_mainID+"&sub_class_id="+g_subID+"&time="+new Date();

	var callback = {

		success: function(oResponse) {
			//g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
            if(results.status==1){
				var i, len;

				var sample = results.sample;
				sample     = sample.replace(/&lt;#/g,'<font color="#FF0000">');
				sample     = sample.replace(/#&gt;/g,'</font>');
				sample     = sample.replace(/\r\n/g,'<br>');
				sample     = sample.replace(/\r/g,'<br>');
				sample     = sample.replace(/\n/g,'<br>');
				var sample2 = results.sample2;
				sample2     = sample2.replace(/\[header frame\]/g,'');	
				sample2     = sample2.replace(/\[body frame\]/g,'<br>');				
				sample2     = sample2.replace(/&lt;#/g,'<font color="#FF0000">');
				sample2     = sample2.replace(/#&gt;/g,'</font>');
				sample2     = sample2.replace(/\r\n/g,'<br>');
				sample2     = sample2.replace(/\r/g,'<br>');
				sample2     = sample2.replace(/\n/g,'<br>');				
				//document.getElementById("match_sample").innerHTML = sample;				

				layout_center.getUnitByPosition("bottom").expand();

				if(results.protocol === 1){
					YAHOO.util.Dom.get("td_protocol").innerHTML = lang_global["http1_tip"];
					document.getElementById("match_sample1").innerHTML = sample;
					YAHOO.util.Dom.setStyle('samTab2','display','none');
				}else if(results.protocol === 2){
					YAHOO.util.Dom.get("td_protocol").innerHTML = lang_global["http2_tip"];
					document.getElementById("match_sample2").innerHTML = sample2;
					YAHOO.util.Dom.setStyle('samTab1','display','none');
					var s_tabview = new YAHOO.widget.TabView("match_sample");
					s_tabview.set("activeIndex", 1);

				}else if(results.protocol === 3){
					YAHOO.util.Dom.get("td_protocol").innerHTML = lang_global["http1_2_tip"];
					document.getElementById("match_sample1").innerHTML = sample;
					document.getElementById("match_sample2").innerHTML = sample2;
				}

				YAHOO.util.Dom.get("meet_target").value = results.meet_target.replace(/\|/g,'\r\n');
				YAHOO.util.Dom.get("concat_div").innerHTML = results.concat?results.concat:"";

				if(results.attack_reference==''){
					YAHOO.util.Dom.setStyle("attack_reference_title", "display", "none");
				}else{
					var attack_reference_array = results.attack_reference.split('\n');
					var tmp_array = new Array();
					re = /^(.*?)&lt;#(.*?)::(.*?)#&gt;$/i;
					for(i=0,len=attack_reference_array.length; i<len; i++){
						tmp_array = re.exec(attack_reference_array[i]);
						if(tmp_array)
						{
							if(tmp_array.length==4){
								YAHOO.util.Dom.get("attack_reference").innerHTML += "<div><a href='"+tmp_array[3]+"' target='_blank'>"+tmp_array[2]+"</a></div>";
							}
						}
					}
				}

				if(results.fpm_mitigation && results.fpm_mitigation==1){
					var fpm_disable = YAHOO.util.Dom.get('fpm_disable');
					fpm_disable.checked = (results.fpm_disable == 0);
				}else{
					YAHOO.util.Dom.setStyle("tr_fpm_disable", "display", "none");
				}

				var alert_only = YAHOO.util.Dom.get('alert_only');
				alert_only.checked = (results.alert_only == 1);
				
				if(results.score == -1){     
					if(results.default_score == 8340)
					{
						$j('#sig-slider').attr('data-default-level', 4); 
						$j('#sig-slider').attr('default_score', 8340);
						YAHOO.util.Dom.get('sig-score').value = 4;        	
						// var override = YAHOO.util.Dom.get('override');
						// if(results.override == 1){
						// 	override.checked = true;
						// 	YAHOO.util.Dom.get("btn_restore").disabled = true;

						// }else{
						// 	override.checked = false;
						// 	YAHOO.util.Dom.get("btn_restore").disabled = false;
						// }
					}else{
						$j('#sig-slider').attr('data-default-level', results.default_score);	
						$j('#sig-slider').attr('default_score', results.default_score);	
						YAHOO.util.Dom.get('sig-score').value = results.default_score;
						//YAHOO.util.Dom.setStyle("tr_override", "display", "none");                 	
					}
				}else{
					$j('#sig-slider').attr('data-default-level', results.score);
					$j('#sig-slider').attr('default_score', results.default_score);		
					YAHOO.util.Dom.get('sig-score').value = results.score;
					// if(results.default_score == 8340){
					// 	var override = YAHOO.util.Dom.get('override');
					// 	if(results.override == 1){
					// 		override.checked = true;
					// 		YAHOO.util.Dom.get("btn_restore").disabled = true;

					// 	}else{
					// 		override.checked = false;
					// 	 	YAHOO.util.Dom.get("btn_restore").disabled = false;
					// 	}
					// }else{						
					// 	YAHOO.util.Dom.setStyle("tr_override", "display", "none");							
					// }		
				}

				setup_sliders();
				// if(results.default_score == results.score)
				if(-1 == results.score
					|| results.default_score == results.score
					|| (results.default_score == 8340 && results.score == 4))
				{
					YAHOO.util.Dom.get("btn_restore").disabled = true;
				}

				/*
				var filters_data = results.filters;
                                for(i=0, len=filters_data.length; i<len; i++){
					filters_dt.addRow(filters_data[i]);
                                }
				*/
				buildFilterTable(results.filters);
                                //filter_SelectRow();

                        }else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},

		failure: function(oResponse) {
			//g_wait.hide();
		},

		timeout: 70000
	};

	YAHOO.util.Connect.asyncRequest('GET', sUrl, callback);	
}

var filter_callback = {
	success: function(oResponse)
	{
		setTimeout(function(){g_wait.hide();}, 1000);
		var results = eval("(" + oResponse.responseText + ")");
		if(results.status)
		{
//			filters_dt.deleteRows(0, filters_dt.getRecordSet().getLength());
			var filter_data = results.filters;

			buildFilterTable(results.filters);

			YAHOO.util.Dom.get("concat_div").innerHTML = results.concat?results.concat:"";

		}
		else
		{
			alert(results.error);
		}
	},

	failure: function()
	{
		setTimeout(function(){g_wait.hide();}, 1000);
	},

	timeout: 50000
};

function filter_SelectRow(e){
	if(typeof(e)=="undefined"){
		filters_selected_row = filters_dt.getTrEl(0);
	}else{
		var t = e.target;
		filters_selected_row = filters_dt.getTrEl(t);
	}

	var record = filters_dt.getRecord(filters_selected_row);
	if(record)
		selected_id = record.getData("id");
	filters_dt._oAnchorRecord=record;
	filters_dt.unselectAllRows();
	filters_dt.selectRow(record);
//	if(!is_default)
//		YAHOO.util.Dom.get("btn_insert").disabled = false;;
}

function filter_DeleteRow(){
	if(filters_selected_row==null){
		return;
	}

	var record = filters_dt.getRecord(filters_selected_row);

	var sUrl = "/signature/sig_del_filter";

        var callback = {

                success: function(oResponse) {
                        g_wait.hide();
                        var results = eval("(" + oResponse.responseText + ")");
                        if(results.status==1){
				filters_dt.deleteRow(filters_selected_row);
				filters_selected_row = null;
				var column = filters_dt.getRecordSet();
				if(column._records.length==0){
					update_status_of_g_dt_selected_row(0);
				}
                        }else{
                                error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
                        }
                },

                failure: function(oResponse) {
                        g_wait.hide();
                },

                timeout: 70000
        };

        g_wait.show();
        YAHOO.util.Connect.asyncRequest('POST', sUrl, callback, "mkey="+mkey+"&id="+record.getData("id")+"&sig_id="+sig_id+"&session_id="+lang_global["session_id"]);
}

function filter_AddRow(){
	var new_host_status  = YAHOO.util.Dom.get("new_host_status");
	var new_host         = YAHOO.util.Dom.get("new_host");
	var new_type0         = YAHOO.util.Dom.get("new_type0");
	var new_type1         = YAHOO.util.Dom.get("new_type1");
	var new_type         = 0;
	var new_request_file = YAHOO.util.Dom.get("new_request_file");

	if(new_type0.checked == true && new_request_file.value.charAt(0)!='/'){
		alert(lang_global["err_request_file"]);
		return;
	}

//	if(new_type1.checked == true && new_request_file.value.trim() ==''){
	trimSpace(new_request_file);
	if(new_type1.checked == true && new_request_file.value == ''){
		alert(lang_global["err_regex"]);
		return;
	}

	if(new_host_status.checked && new_host.value==''){
		alert(lang_global["err_host"]);
		return;
	}

	if(new_type0.checked == true)
	{
		new_type = 0;
	}else{
		new_type = 1;
	}

	var sUrl = "/signature/sig_add_filter";

        var callback = {

                success: function(oResponse) {
                        g_wait.hide();
                        var results = eval("(" + oResponse.responseText + ")");
                        if(results.status==1){
				filters_dt.addRow({"id":results.id, "host_status":(results.host_status==1?lang_global["enable"]:lang_global["disable"]), "host":results.host,"type":(results.type==0?lang_global["simple"]:lang_global["regex"]), "request_file":results.request_file});
				/*
				new_host_status.checked = false;
				new_request_file.value = "";
				//new_type.value = 0;
				update_host_status();
				*/
				update_status_of_g_dt_selected_row(1);
                        }else{
				alert(results.err_msg);
                        }
                },

                failure: function(oResponse) {
                        g_wait.hide();
                },

                timeout: 70000
        };

        g_wait.show();
        YAHOO.util.Connect.asyncRequest('POST', sUrl, callback, "mkey="+mkey+"&sig_id="+sig_id+"&host="+new_host.value+"&type="+new_type+"&request_file="+encodeURIComponent(new_request_file.value)+"&host_status="+(new_host_status.checked?1:0)+"&session_id="+lang_global["session_id"]);
}

function filter_UpdateStatus(global_status, group_status){
	var sUrl = "/signature/set_sig_status";

	var callback = {
                success: function(oResponse) {
                        g_wait.hide();
                        var results = eval("(" + oResponse.responseText + ")");
                        if(results.status==1){
				/*var g_dt_status = "";  // = "<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"];
				if(results.global_status==1 && results.group_status ==1){
					if(results.has_filter==1){
						g_dt_status = "<img src='/images/menubar/signature_exception.png'> "+lang_global["enable"];
					}else{
						g_dt_status = "<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"];
					}
				}else{
					g_dt_status = "<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"];
				}*/


				var row = g_dt.getTrEl(g_dt_selected_row);
				//row.children[1].innerHTML = "<div class='yui-dt-liner'>"+g_dt_status+"</div>";
				row.children[3].innerHTML = "<div class='yui-dt-liner'>"+results.global_status+"</div>";
				row.children[4].innerHTML = "<div class='yui-dt-liner'>"+results.group_status+"</div>";

				update_status_of_g_dt_selected_row(results.has_filter);
                        }else{
                                error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
                        }
                },

                failure: function(oResponse) {
                        g_wait.hide();
                },

                timeout: 70000
        };

        g_wait.show();
        YAHOO.util.Connect.asyncRequest('POST', sUrl, callback, "mkey="+mkey+"&sig_id="+sig_id+"&global_status="+global_status+"&group_status="+group_status+"&session_id="+lang_global["session_id"]);
}

function update_status_of_g_dt_selected_row(has_filter){
	var row = g_dt.getTrEl(g_dt_selected_row);
	global_status = (row.children[3].innerHTML.indexOf("1")>=0)? 1: 0;
	group_status  = (row.children[4].innerHTML.indexOf("1")>=0)? 1: 0;

	var g_dt_status = "";
	if(global_status==1 && group_status ==1){
		if(has_filter==1){
			g_dt_status = "<img src='/images/menubar/signature_exception.png'> "+lang_global["enable"];
		}else{
			g_dt_status = "<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"];
		}
	}else{
		g_dt_status = "<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"];
	}
	row.children[1].innerHTML = "<div class='yui-dt-liner'>"+g_dt_status+"</div>";
}

function AddTableData(type){
	var sUrl = "";

	if(type == 0)
		sUrl = "/signature/signatures?mkey="+mkey+"&main_class_id="+g_mainID+"&sub_class_id="+g_subID;
	//disabled signatures
	else if(type == 1)
		sUrl = "/signature/dis_signatures?mkey="+mkey;
	//alert only signatures
	else if(type == 2)
		sUrl = "/signature/alert_signatures?mkey="+mkey;
	//fpm disabled signatures
	else if(type == 3)
		sUrl = "/signature/fpm_signatures?mkey="+mkey;
	//exception signatures
	else if(type == 4)
		sUrl = "/signature/with_exception?mkey="+mkey;

	var callback = {
            
		success: function(oResponse) {
			g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status==1){
                                var data = results.datas;

				for(var i=0, len=data.length; i<len; i++){
					if(data[i].status!=1){
						data[i].status = "<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"];
					}else if(data[i].has_filter==1){
						data[i].status = "<img src='/images/menubar/signature_exception.png'> "+lang_global["enable"];
					}else{
						data[i].status = "<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"];
					}
					//data[i].status = data[i].status==1?("<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"]):("<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"]);
                                	g_dt.addRow(data[i]);
                        	}
				//var record = g_dt.getRecord(0);
				if(data.length > 0)
					g_dt_SelectRow(0);
			}else{
                                error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
                        }
		},

		failure: function(oResponse) {
			g_wait.hide();
			alert("Loading Configuration timeout.");
		},

		timeout: 70000
	};

	g_wait.show(); 
	YAHOO.util.Connect.asyncRequest('GET', sUrl, callback,"&session_id="+lang_global["session_id"]);
}

function drawtable(type)
{
	var search_desc = YAHOO.util.Dom.get("search_desc");
	if(g_dt)
	{
		g_contextMenu.destroy();
		g_contextMenu = null;
		
		g_dt.destroy();
		g_dt = null;
	}else{
		var center = layout.getUnitByPosition("center");
		center.set("gutter", "5px 1px 5px 1px");
		layout.addUnit({ position: 'right', body: 'tabDiv', width: 500, resize: true, gutter: '5px', collapse: true, scroll:true, minWidth: 400, maxWidth: 600});
		layout_center.addUnit({position: 'bottom', header:lang_global["match_sample"], height: 220, resize: true, body: 'sampleDiv', gutter: '5px 0px 0px 0px', collapse: true, collapseSize: 20, scroll: true, minHeight:100, maxHeight:380});
	}

	var center = layout_center.getUnitByPosition("center");
        center.set("header",  g_type);

	var SearchBox_innerHTML = '<span>&nbsp;&nbsp;'+lang_global["search_desc"]+'</span>&nbsp;&nbsp;&nbsp;'+
				  '<input type=text size=42 id="search_desc" name="search_desc" value="'+(search_desc.value.trim()).replace(new RegExp(/(")/g),'&quot;')+'">&nbsp;&nbsp;&nbsp;'+
				  '<a id="set_search_desc" style="vertical-align:middle;"><img style="vertical-align:middle;" src="/images/Search.gif" title="'+lang_global["search"]+'"></a>&nbsp;&nbsp;'+
				  '<a id="clear_search_desc" style="vertical-align:middle;"><img style="vertical-align:middle;" src="/images/ClearSearch.gif" title="'+lang_global["clear"]+'"></a>';

	var searchBox = YAHOO.util.Dom.get("SearchBox");
	
	if(type == 0)
	{
		searchBox.innerHTML = SearchBox_innerHTML;
		YAHOO.util.Event.addListener("set_search_desc", "click", set_search_desc);
		YAHOO.util.Event.addListener("clear_search_desc", "click", clear_search_desc);

	}
				
	var ds = new YAHOO.util.DataSource();
	ds.responseType = YAHOO.util.DataSource.TYPE_JSARRAY;
//	ds.responseType = YAHOO.util.DataSource.TYPE_JSON;

	ds.responseSchema =
        {
		fields: ["id", "status", "desc", "global_status", "group_status"]
	};

	var s = layout.getSizes();
	var w = s.center.w;
	if(g_brow != 1)
		w -= 84;
	
	var myColumnDefs =
	[
        	{key:"id", label:"<div align='left'><b>"+lang_global["sig_id"]+"</b></div>",  formatter: YAHOO.widget.DataTable.formatText, width: 95},
                {key:"status", label:"<div align='left'><b>"+lang_global["status"]+"</b></div>", sortable:false, /*formatter: YAHOO.widget.DataTable.formatText,*/ width: 82},
                {key:"desc", label:"<div align='left'><b>"+lang_global["desc"]+"</b></div>", formatter:YAHOO.widget.DataTable.formatText, sortable:false, width: w-95-82},
		{key:"global_status"},
		{key:"group_status"}
        ];

	var oConfig =
        {
		MSG_ERROR: "",
		paginator: g_page,
		width: w
        };

	g_dt = new YAHOO.widget.DataTable("DataTable", myColumnDefs, ds, oConfig);

	var columnsets = g_dt.getColumnSet();
	g_dt.hideColumn(columnsets.getColumn("global_status"));
	g_dt.hideColumn(columnsets.getColumn("group_status"));

	g_dt.subscribe("rowClickEvent", g_dt_SelectRow);

	g_contextMenu = new YAHOO.widget.ContextMenu("mytablemenu",
				{
					trigger: "DataTable",
					lazyload: true
				});

	g_contextMenu.subscribe("beforeShow", onTableBeforeShow);

}
function set_search_desc(){
	var search_desc = YAHOO.util.Dom.get("search_desc");
	
	var callback = {
		success: function(oResponse) {
			g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status==1){

				drawtable(0);
                                var data = results.datas;
				for(var i=0, len=data.length; i<len; i++){
					if(data[i].status!=1){
						data[i].status = "<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"];
					}else if(data[i].has_filter==1){
						data[i].status = "<img src='/images/menubar/signature_exception.png'> "+lang_global["enable"];
					}else{
						data[i].status = "<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"];
					}
					//data[i].status = data[i].status==1?("<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"]):("<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"]);
                                	g_dt.addRow(data[i]);
                        	}
				//var record = g_dt.getRecord(0);
				g_dt_SelectRow(0);
			}else{
                                error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
                        }
		},

		failure: function(oResponse) {
			g_wait.hide();
			alert("Loading Configuration timeout.");
		},

		timeout: 70000
	};
	g_wait.show();
	YAHOO.util.Connect.asyncRequest('POST', "/signature/description", callback, "mkey="+mkey+"&main_id="+g_mainID+"&sub_id="+g_subID+"&description="+search_desc.value.trim()+"&session_id="+lang_global["session_id"]);
}

function clear_search_desc(){
	var search_desc = YAHOO.util.Dom.get("search_desc");
	search_desc.value = "";

	var callback = {
            
		success: function(oResponse) {
			g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status==1){
                                var data = results.datas;
				drawtable();
				for(var i=0, len=data.length; i<len; i++){
					if(data[i].status!=1){
						data[i].status = "<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"];
					}else if(data[i].has_filter==1){
						data[i].status = "<img src='/images/menubar/signature_exception.png'> "+lang_global["enable"];
					}else{
						data[i].status = "<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"];
					}
					//data[i].status = data[i].status==1?("<img src='/images/menubar/signature_enable.png'> "+lang_global["enable"]):("<img src='/images/menubar/signature_disable.png'> "+lang_global["disable"]);
                                	g_dt.addRow(data[i]);
                        	}
				//var record = g_dt.getRecord(0);
				g_dt_SelectRow(0);
			}else{
                                error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
                        }
		},

		failure: function(oResponse) {
			g_wait.hide();
			alert("Loading Configuration timeout.");
		},

		timeout: 70000
	};
	g_wait.show();
	YAHOO.util.Connect.asyncRequest('POST', "/signature/signatures", callback, "mkey="+mkey+"&main_class_id="+g_mainID+"&sub_class_id="+g_subID+"&session_id="+lang_global["session_id"]);
}

function ClearTable()
{
	var rows = g_dt.rows.length;

	for(var i = rows-1; i > 0; i--)
		g_dt.deleteRow(i);
}

function InitTree()
{
	g_tv = new YAHOO.widget.TreeView("treeDiv");
	var root = g_tv.getRoot();

	var sUrl = "/signature/type?mkey="+ mkey +"&time="+new Date();

       	var callback = {
		success: function(oResponse) {
			g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status==1){
				is_default = results.is_default;
				is_rw_admin = is_default ? 0 : 2;

				var data = results.datas;
				for(var i=0, j=data.length; i<j; i++){
                                	var item = new YAHOO.widget.TextNode({type: "Text", label: data[i].text, data: {main_id: data[i].main_id, sub_id: "000000000", status:data[i].status, type:data[i].type}}, root, false);
					if(data[i].status==1){
						item.labelStyle = "icon-app";
					}else{
						item.labelStyle = "icon-app-disable";
					}

                                	if(data[i].children && data[i].children.length>0){
                                        	for(var m=0, n=data[i].children.length; m<n; m++){
                                                	//var sub_item = new YAHOO.widget.TextNode(data[i].children[m].text, item, false);
							//sub_item.labelStyle = "icon-app";
							var sub_item = new YAHOO.widget.TextNode({type: "Text", label: data[i].children[m].text, data: {main_id: data[i].children[m].main_id, sub_id: data[i].children[m].sub_id, status:data[i].children[m].status, type:data[i].children[m].type}, labelStyle: "icon-app"}, item, false);
							if(data[i].children[m].status==0){
								sub_item.labelStyle = "icon-app-disable";
							}
                                        	}
                                	}
                        	}
				var search_node = new YAHOO.widget.TextNode({type: "Text", label: lang_global["search"]}, root, false);
				search_node.labelStyle = "icon-search";

				//search filter
				var filter_node = new YAHOO.widget.TextNode({type: "Text", label: lang_global["filters"]}, root, false);
				filter_node.labelStyle = "icon-filter";
				//var dis_node = new YAHOO.widget.TextNode({type: "Text", label: lang_global["disabled"]}, filter_node, false);
				//var alert_node = new YAHOO.widget.TextNode({type: "Text", label: lang_global["alert_only"]}, filter_node, false);

                        	g_tv.subscribe("labelClick", treeClickHandler);
                        	g_tv.draw();

				var g_contextMenu = new YAHOO.widget.ContextMenu("treeDivMenu",
							{
								trigger: "treeDiv",
								lazyload: true
							});

				g_contextMenu.subscribe("beforeShow", onTreeBeforeShow);

			}else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},

		failure: function(oResponse) {
			g_wait.hide();
			alert("Loading Configuration timeout.");
		},

		timeout: 30000
	};

        YAHOO.util.Connect.asyncRequest('GET', sUrl, callback);

	//document.getElementById("match_sample").innerHTML = "";
}

function onTreeBeforeShow(p_sType, p_aArgs)
{
	var target   = this.contextEventTarget;
	var textNode = target;
	var items;

	if(g_tv && textNode && (textNode.innerHTML==lang_global["search"] || textNode.innerHTML==lang_global["filters"] ||
	textNode.innerHTML==lang_global["disabled"] || textNode.innerHTML==lang_global["alert_only"] || textNode.innerHTML.indexOf('span') !=-1 )
			)
	{
		this.clearContent();
		this.render();
	}
	else if(g_tv && textNode && textNode.innerHTML!=lang_global["search"] && textNode.innerHTML!=lang_global["filters"] &&
		textNode.innerHTML!=lang_global["disabled"] && textNode.innerHTML!=lang_global["alert_only"])
	{
		treeNode = g_tv.getNodeByElement(textNode);

		if(is_default==1){
			items = [
				{text:lang_global["enable"], disabled: true},
				{text:lang_global["disable"], disabled: true}
			];
		}else if(treeNode.data.status==1){
			items = [
				{text:lang_global["enable"], disabled: true},
				{text:lang_global["disable"], onclick: {fn: DisableTreeNode}}
			];
		}else{
			items = [
				{text:lang_global["enable"], onclick: {fn: EnableTreeNode}},
				{text:lang_global["disable"], disabled: true}
			];
		}

		this.clearContent();
		this.addItems(items);
		this.render();
	}

	/*
	if(g_tv && textNode && (textNode.innerHTML==lang_global["search"] || textNode.innerHTML==lang_global["filters"] ||
	textNode.innerHTML==lang_global["disabled"] || textNode.innerHTML==lang_global["alert_only"] || textNode.innerHTML.indexOf('span') !=-1))
	{
		this.clearContent();
		this.render();
	}
	*/
}

function DisableTreeNode()
{
	UpdateTreeNodeStatus(0);
}

function EnableTreeNode()
{
	UpdateTreeNodeStatus(1);
}

function UpdateTreeNodeStatus(status)
{
	var sUrl = "/signature/set_class_status";

	var callback = {
		success: function(oResponse) {
			g_wait.hide();
			var results = eval("(" + oResponse.responseText + ")");
			if(results.status==1){
				if(results.class_status==1){
					treeNode.labelStyle = "icon-app";
				}else{
					treeNode.labelStyle = "icon-app-disable";
				}
				treeNode.data.status = results.class_status;

				if(treeNode.data.type==2 && results.sub_id=="000000000"){
					treeNode.parent.labelStyle       = treeNode.labelStyle;
					treeNode.parent.data.status      = treeNode.data.status;

					if(results.class_status==0){
						treeNode.parent.collapse();
					}
				}else if(treeNode.data.type==1){
					if(treeNode.children.length==1 && treeNode.children[0].data.sub_id=="000000000"){
						treeNode.children[0].labelStyle  = treeNode.labelStyle;
						treeNode.children[0].data.status = treeNode.data.status;
					}

					if(results.class_status==0){
						treeNode.collapse();
					}
				}
				g_tv.draw();
			}else{
				error_handler(results.msg_id, "/signature/signature.html?mkey="+mkey);
			}
		},

		failure: function(oResponse) {
			g_wait.hide();
		},

		timeout: 70000
	};

	g_wait.show();
	var type = (treeNode.data.sub_id=="000000000")? 1: treeNode.data.type;
	YAHOO.util.Connect.asyncRequest('POST', sUrl, callback, "mkey="+mkey+"&type="+type+"&status="+status+"&main_classid="+treeNode.data.main_id+"&sub_classid="+treeNode.data.sub_id+"&session_id="+lang_global["session_id"]);
}

function treeClickHandler(node)
{
	var label = node.label;
	
	var searchBox = YAHOO.util.Dom.get("SearchBox");
	searchBox.innerHTML = "";

	//g_subID = 0;
	g_type = node.label;

	if(node)
		curNode = node;

	if(node.data){
		if(node.data.main_id)
			g_mainID = node.data.main_id;

		if(node.data.sub_id)
			g_subID = node.data.sub_id;
	}

	if(node.label == lang_global["filters"])
	{
		InitFilter();
	}
	else if(node.label == lang_global["disabled"]){
		InitTable(1);
	}
	else if(node.label == lang_global["alert_only"]){
		InitTable(2);
	}
	else if(node.label==lang_global["search"]){
		InitSearch();
	}else if(node.children.length == 0){
		InitTable(0);
	}else{
		TypeSetting(node);
	}

	node.focus();
}

function get_url_param(para){
	var search_str=window.location.search;
        var para_arr=new Array();
	var tmp_arr2;
	var first_char=search_str.substr(0,1);
	if(first_char=='?')
		search_str=search_str.substr(1);
	var tmp_arr1=search_str.split("&");
	for(var i=0;i<tmp_arr1.length;i++){
		tmp_arr2=tmp_arr1[i].split('=');
		para_arr[tmp_arr2[0]]=tmp_arr2[1];
	}
	if(typeof(para)=="undefined")
		return para_arr;
	else
		return para_arr[para];
}

function error_handler(msg_id, url){
	switch (msg_id){
		case 0:
			document.location.href = url;
			break;
		case -30:
			top.location.href = "/login";
			break;
		case -37:
			document.location.href = "/noaccess?redir=" + url;
			break;
		default :
			document.location.href = "/error?msg=" + msg_id;
			break;
	}
}

YAHOO.util.Event.onDOMReady(Init);

})();
