//继承Legend，增加最小宽度和固定legend显示功能
Ext.define('Ext.chart.MyPieChartLegend', {   
	extend: 'Ext.chart.Legend',
	minWidth:0,    
	minHeight:0,
	getBBox:function () {//legend设置最小宽度
		var me = this;
		if (me.width < me.minWidth)
			me.width = me.minWidth;
		if (me.height < me.minHeight)
			me.height = me.minHeight;
		return {
			x:Math.round(me.x) - me.boxStrokeWidth / 2,
			y:Math.round(me.y) - me.boxStrokeWidth / 2,
			width:me.width,
			height:me.height
			};
	},

	createItems : function() {//设置固定的legend显示
		var B = this, n = B.chart, t = n.surface, q = B.items, m = B.padding, C = B.itemSpacing, j = 2, w = 0, s = 0, e = 0, A = 0, b = B.isVertical, d = Math, c = d.floor, D = d.max, h = 0, u = 0, v = q
? q.length
: 0, l, k, g, z, a, p, r;
		if (v) {
			for (; u < v; u++) {
			q[u].destroy()
			}
		}

		q.length = [];
		n.series.each(function(y, x) {
			if (y.showInLegend) {
				Ext.each([].concat(y.legendSet), function(E, i) {
					z = Ext.create("Ext.chart.MyPieChartLegendItem", {
						legend : this,
						series : y,
						surface : n.surface,
						legendIndex : i ,
						slicesIndex : y.legendSet[i].linkSlicesKey
					});

					a = z.getBBox();
					r = a.width;
					p = a.height;
					if (x + i === 0) {
						g = b ? m + p / 2 : m
					} else {
						g = C / (b ? 2 : 1)
					}
					z.x = c(b ? m : e + g);
					z.y = c(b ? A + g : m + p / 2);
					e += r + g;
					A += p + g;
					w = D(w, r);
					s = D(s, p);
					q.push(z)
				}, this)
			}
		}, B);

		B.width = c((b ? w : e) + m * 2);
		if (b && q.length === 1) {
			j = 1
		}

		B.height = c((b ? A - j * g : s) + (m * 2));
		B.itemHeight = s
	}
});


Ext.define('Ext.chart.MyPieChartLegendItem', {   
	extend: 'Ext.chart.LegendItem',
	createLegend : function(t) {

		var u = this, i = t.slicesIndex, l = u.series, a = l.type, m = u.legendIndex, d = u.legend, q = u.surface, r = d.x
		+ u.x, n = d.y + u.y, c, k = u.zIndex, b, j, s, e, p = false, h = Ext
		.apply(l.seriesStyle, l.style);

		function g(v) {
			var w = l[v];
			return (Ext.isArray(w) ? w[m].text||w[m] : w)
		}


		function mycolor(v) {
			var w = l[v];
			return (Ext.isArray(w) ? w[m].color||"#ccc" : "#ccc")
		}

		j = u.add("label", q.add({
			type : "text",
			x : 20,
			y : 0,
			zIndex : k || 0,
			font : d.labelFont,
			text : g("legendSet")|| g("title")|| g("yField")
		}));

		if (a === "line" || a === "scatter") {
			if (a === "line") {
				u.add("line", q.add({
					type : "path",
					path : "M0.5,0.5L16.5,0.5",
					zIndex : k,
					"stroke-width" : l.lineWidth,
					"stroke-linejoin" : "round",
					"stroke-dasharray" : l.dash,
					stroke : h.stroke || "#000",
					style : {
						cursor : "pointer"
					}
				}))
			}

			if (l.showMarkers || a === "scatter") {
				b = Ext.apply(l.markerStyle, l.markerConfig || {});
				u.add("marker", Ext.chart.Shape[b.type](q, {
					fill : b.fill,
					x : 8.5,
					y : 0.5,
					zIndex : k,
					radius : b.radius || b.size,
					style : {
						cursor : "pointer"
					}
				}))
			}
		} else {
			u.add("box", q.add({
				type : "rect",
				zIndex : k,
				x : 0,
				y : 0,
				width : 12,
				height : 12,
				fill : mycolor("legendSet"),
				style : {
					cursor : "pointer"
				}
			}))
		}

		u.setAttributes({
			hidden : false
		}, true);

		c = u.getBBox();

		s = u.add("mask", q.add({
			type : "rect",
			x : c.x,
			y : c.y,
			width : c.width || 20,
			height : c.height || 20,
			zIndex : (k || 0) + 1000,
			fill : "#f00",
			opacity : 0,
			style : {
				cursor : "pointer"
			}
		}));

		if(i!=999){//某一个legend有相关的slice

			u.on("mouseover", function() {
				j.setStyle({
					"font-weight" : "bold"
					});
				s.setStyle({
					cursor : "pointer"
				});

				l._index = i;
				l.highlightItem()
			}, u);

			u.on("mouseout", function() {
				j.setStyle({
					"font-weight" : "normal"
				});
	
				l._index = i;
				l.unHighlightItem()
			}, u);

			if (!l.visibleInLegend(i)) {
				p = true;
				j.setAttributes({
					opacity : 0.5
				}, true)
			}

			u.on("mousedown", function() {
				if (!p) {
					l.hideAll();
				j.setAttributes({
					opacity : 0.5
				}, true)
				} else {
					l.showAll();
					j.setAttributes({
						opacity : 1
					}, true)
				}
	
				p = !p
			}, u);
		}

		u.updatePosition({
			x : 0,
			y : 0
		})
	}
});
