Ext.onReady(
function()
{
Ext.require['*'];

Ext.Loader.setConfig({enabled:true});

var colors = [
'rgb(28, 42, 55)',
'rgb(222, 32, 47)',
'rgb(76, 107, 125)',
'rgb(156, 95, 102)',
'rgb(148, 174, 10)',
'rgb(17, 95, 166)',
'rgb(166, 17, 32)',
'rgb(255, 136, 9)',
'rgb(255, 209, 62)',
'rgb(166, 17, 135)',
'rgb(36, 173, 154)',
'rgb(124, 116, 116)',
'rgb(166, 97, 17)'
];

var columnStore = Ext.create('Ext.data.JsonStore', {
                        fields: ['time', 'Bad Robot', 'Known Search Engines', 'Other']
//                        data: columnData.slice(0, 24)
});


var pieStore = Ext.create('Ext.data.JsonStore', {
	fields: ['type', 'count']
//	data: pieData.slice(0,3)
});

var timeData =[
	{label: lang_str.last_24_hours, value: '1'},
	{label: lang_str.last_7_days, value: '2'},
	{label: lang_str.last_month, value: '3'}
];

var timeStore = Ext.create('Ext.data.JsonStore', {
	fields: ['label', 'value'],
	data: timeData.slice(0,3)
});


var searchStore = Ext.create('Ext.data.JsonStore', {
	fields: ['type', 'count']
//	data: searchData.slice(0, 13)
}
);

Ext.define('Ext.chart.theme.Fancy', {
        extend: 'Ext.chart.theme.Base',
        
        constructor: function(config) {
            this.callParent([Ext.apply({
                colors: colors
            }, config)]);
        }
    });

//these two array is used for rewrite ext class
var legendset = [
	{text: "Other", color: "#1c2a37", linkSlicesKey: 999},
	{text: "Bad Robot", color: "#de202f", linkSlicesKey: 999},
	{text: "Known Search Engines", color: "#4c6b7d", linkSlicesKey: 999}
];

var colorset = [
	"#1c2a37", "#de202f", "#4c6b7d"
];

var viewport = Ext.create('Ext.Viewport',
{
	layout: {
            type: 'border'
        },
        items: [
	//center
        {
            region: 'center',
            layout: 'border',
            border: false,
	    width: '100%',
	    height: '55%',
            items: [

		//center for center
		{
                			region: 'center',
                                        xtype: 'chart',
					padding: 0,
					minWidth: 500,
					minHeight: 300,
					style: {backgroundColor: '#fff'},
                                        animate: 'true',
                                        shadow: 'true',
                                        width: '100%',
                                        id: 'colchart',
					theme: 'Fancy',
//					height: 350,
                                        store: columnStore,
                                        legend: {
                                                position: 'bottom'
                                        },
                                        axes: [
                                                {
                                                        type: 'Numeric',
                                                        position: 'left',
                                                        fields: [ 'Other', 'Bad Robot', 'Known Search Engines'],
                                                        title: lang_str.left_title,
							minimum: 0,
//                                                        grid: true,
							majorTickSteps: 1,
                                                        label: {
                                                                renderer: function(v)
                                                                {
									if(v < 10 && v != 0)
									{
										if(v*10%10 != 0)
											return String(v.toFixed(1));
										else
		                                                                        return String(v.toFixed(0));
									}
									else
										return String(v);
                                                                }
                                                        }

                                                },
                                                {
                                                        type: 'Category',
                                                        position: 'bottom',
                                                        fields: ['time'],
                                                        title: "",
							label: {
								rotate: {degrees: 270}
							}
                                                }
                                        ],
					series: [
                                                {
                                                        type: 'column',
                                                        axis: 'left',
                                                        gutter: 200,
                                                        yField: ['Other', 'Bad Robot', 'Known Search Engines'],
                                                        xField: 'time',
                                                        stacked: true,
                                                        tips: {
                                                                trackMouse: true,
								anchor: 'right',
                                                                width: 70,
                                                                height: 28,
                                                                renderer: function(storeItem, item) {
/*
									var regular = storeItem.get('Regular');
									var bad = storeItem.get('Bad Robot');
									var known = storeItem.get('Known Engines');
									var field = item.storeField;
									this.setTitle(
									"Regular: " + String(regular) + '<br>' +
									"Bad Robot: " + String(bad) + '<br>' + 
									"Known Engines: " + String(known) 
									);
*/
									this.setTitle(String(item.value[1]));
                                                                }
                                                        }
                                                }
                                        ]
            },


	    {
		region: 'north',
		xtype: 'container',
		items:[
			//header
			Ext.create('Ext.Component', {
	                height: 20,
        	        style: {backgroundColor: '#4b5362'},
                	autoEl: {
	                    tag: 'div',
        	            html:'<div style="text-align: center; vertical-align: text-bottom; color: #fff"><b>' + lang_str.top_title + '</b></div>'
                	}
            		}),

			//selector component
			{
                                        xtype: "container",
                                        style: {
                                                backgroundColor: '#23abcd',
                                                align: 'center'
                                        },
                                        layout: {
                                                type: 'hbox',
                                        },
                                        items: [

						{
							xtype: 'container',
							flex: 15
						},

						//time selector
                                                {
                                                        xtype: 'combo',
                                                        flex: 10,
                                                        fieldLabel: lang_str.time_select,
                                                        id: 'time_combo',
                                                        labelAlign: 'right',
							queryMode: 'local',
                                                        displayField: 'label',
                                                        valueField: 'value',
                                                        editable: false,
							value: '1',
                                                        store: timeStore,

							listeners: 
							{
								scope: this,

								select: function(f, record, eOpts)
								{
									var r = record[0];
									var val = r.get('value');

									getData();
								}
							}
                                                },

						//policy selector
						{
							xtype: 'combo',
							flex: 10,
							fieldLabel: lang_str.policy,
							id: 'policy_combo',
							labelAlign: 'right',
		                                        emptyText : lang_str.select,
                		                        queryParam : 'comboFilterString',
		                                        displayField: 'label',
                		                        valueField: 'label',
                                		        editable: false,
		                                        store: Ext.create('Ext.data.Store',
                	                                {
                        	                                autoLoad: false,
                                	                        fields: ['label'],
                                        	                proxy:
                                                	        {
                                                        	        type: 'ajax',
                                                                	url: '/system/status/policy-list',
	                                                                reader:
        	                                                        {
                	                                                        type: 'json',
                        	                                                root: ''
                                	                                }
                                        	                }
                                                	}
                                        		),

							listeners:
                                        		{
		                                                scope: this,
                		                                load: function(store, records, successful, operation, eOpts)
                                		                {
                                                		},

		                                                beforequery: function(qe)
		                                                {
                		                                        qe.combo.clearValue();
                                		                        delete qe.combo.lastQuery;
		                                                },
	
        	                        	                select: function(f, record, eOpts)
                	        	                        {
                        	                	                var r = record[0];
		                                                        var policy = r.get('label');

									getData();
                                                		}
                                        		}
						},

						{
							xtype: 'container',
							flex: 1
						}
                                        ]
		        }
			//end of selector component
		]
	    }
	]
	},

	//south
        {
            region: 'south',
	    height: '45%',
            minHeight: 300,
            layout: {
                type: 'border',
                padding: 0
            },
            items: [
		{
			                region: 'center',
                			minWidth: 300,
					minHeight: 300,
					flex: 1,
					xtype: 'chart',
                                        width: '100%',
					height: '100%',
					style: {backgroundColor: '#fff'},
                                        store: pieStore,
                                        insetPadding: 40,
//                                        theme: 'Fancy',
                                        id: 'piechart',
                                        shadow: true,
                                        animate: true,
//                                        legend: {position: 'right'},
					//use rewrite Ext class
					legend: Ext.create('Ext.chart.MyPieChartLegend',{
				              		position: "right",
						       	minWidth: 105
				            }),

                                        series: [
                                        {
                                                type: 'pie',
                                                field: 'count',
						//these two attribute is used for rewrite Legend/LegendItem class
						legendSet: legendset,
						colorSet: colorset,
                                                showInLegend: true,
                                                tips: {
                                                        trackMouse: true,
                                                        width: 200,
                                                        height: 28,
                                                        renderer: function(storeItem, item) {
                                                                var total = 0;
                                                                var chart = Ext.getCmp('piechart');
                                                                if(chart == undefined)  return;
                                                                var pieStore = chart.store;
								var allzero = true;
                                                                pieStore.each(function(rec) {
									if(rec.get('count') != Number.MIN_VALUE)
										allzero = false;

                                                                        total += rec.get('count');
                                                                });

								var count = storeItem.get('count');
								if(!allzero)
	                                                                this.setTitle(storeItem.get('type') + ': ' + Math.round(storeItem.get('count') / total * 100) + '%');
								else
									this.setTitle(storeItem.get('type') + ': ' + '0%');
                                                        }
                                                },
						label: {
                                                        field: 'type',
//                                                      display: 'rotate',
                                                        contrast: true,
                                                        font: '18px Arial'
                                                }
                                        }
                                        ]
            }, 

	
	    {
	                region: 'east',
	                flex: 1,
	                minWidth: 300,
			layout: {
				type: 'border',
				padding: 0
			},
			items:[
				{
					region: 'north',
					xtype: 'container',
					items:[
						Ext.create('Ext.Component', {
				                        height: 20,
				                        style: {backgroundColor: '#4b5362'},
				                        autoEl: {
				                            tag: 'div',
				                            html:'<div style="text-align: center; vertical-align: text-bottom; color: #fff"><b>' + lang_str.top10 + '</b></div>'
				                        }
			                        })
					]
				},

				//begin with chart
				{
					region: 'center',
					xtype: 'chart',
                                        width: '100%',
                                        height: '100%',
					minWidth: 300,
					minHeight: 300,
                                        style: {backgroundColor: '#fff'},
                                        store: searchStore,
                                        insetPadding: 40,
                                        theme: 'Fancy',
                                        id: 'searchchart',
                                        shadow: true,
                                        animate: true,
                                        legend: {position: 'right'},
                                        series: [
                                        {
                                                type: 'pie',
                                                field: 'count',
                                                showInLegend: true,
                                                tips: {
                                                        trackMouse: true,
                                                        minWidth: 150,
                                                        maxWidth: 240,
                                                        height: 40,
							renderer: function(storeItem, item) {
                                                                var total = 0;
                                                                var chart = Ext.getCmp('searchchart');
                                                                if(chart == undefined)  return;
								var allzero = true;
                                                                var pieStore = chart.store;
                                                                searchStore.each(function(rec) {
									if(rec.get('count') != Number.MIN_VALUE)
										allzero = false;
                                                                        total += rec.get('count');
                                                                });
								if(!allzero)
	                                                                this.setTitle(storeItem.get('type') + ': ' + Math.round(storeItem.get('count') / total * 100) + '%');
								else
									this.setTitle(storeItem.get('type') + ': ' + '0%');
                                                        }
                                                },
                                                label: {
                                                        field: 'type',
                                                        contrast: true,
                                                        font: '18px Arial'
                                                }
                                        }
                                        ]
					//end of chart
				}
			]
            } 
            ]
        }]
}
);

		//first query the policies here
		var combo = Ext.getCmp('policy_combo');
		if(!combo)	return;
                combo.store.load(
                        {
                                callback: function(records, operation, success)
                                {
                                        var recs = [];
                                        for(var i = 0; i < records.length; i++)
                                        {
                                                recs.push(records[i].data);
                                        }
                                        this.loadData(recs);

                                        if(records.length > 0)
                                        {
                                                var data = [];
                                                data.push(records[0]);
						combo.setValue(recs[0].label);
                                                combo.fireEvent('select', combo, data);
                                        }
                                }
                        }
                );

		function getData()
		{
			var time = Ext.getCmp('time_combo');
			var policy = Ext.getCmp('policy_combo');
	
			if(!time || !policy)	return;

			if(policy.getValue() == null)	return;

			//not important, but can't be null for ajax proxy, fields can defined as any fields
			Ext.define("user", {
				extend: 'Ext.data.Model',
				fields: ['label']
			});

			//ajax request for column chart
			var proxy_col = new Ext.data.proxy.Ajax({
				model: 'user', 
				url: '/bot_analysis/column?type=' + time.getValue() + '&policy=' + policy.getValue(),
				reader: {type: 'json'}
			});

			var op_col = new Ext.data.Operation({
				action: 'read'
			});

			proxy_col.doRequest(op_col, callback_col);

			function callback_col(o)
			{
				var col = Ext.getCmp('colchart');
				if(!col)	return;

				if(o.response)
				{
					//parse json string to an object or array
					var res = eval("(" + o.response.responseText + ")");

					if(res.status != undefined)
					{
						if(res.status == 'ok')
						{
							var data = res.data;
							var ndata = [];
							col.store.loadData(ndata);
							if(data != undefined)
								col.store.loadData(data);
						}
						else if(res.status == 'error')
							alert(res.error);
					}
				}
			}

			//ajax request for pie charts
			var proxy_pie = new Ext.data.proxy.Ajax({
				model: 'user',
				url: '/bot_analysis/pie?type=' + String(Number(time.getValue()) + 3) + '&policy=' + policy.getValue(),
				reader: {type: 'json'}
			});

			var op_pie = new Ext.data.Operation({
				action: 'read'
			});

			proxy_pie.doRequest(op_pie, callback_pie);

			function callback_pie(o)
			{
				var pie = Ext.getCmp('piechart');
				var search = Ext.getCmp('searchchart');

				if(!pie || !search)	return;

				if(o.response)
				{
					var res = eval("(" + o.response.responseText + ")");
					if(res.status != undefined)
					{
						if(res.status == 'ok')
						{
							var common = res.data.common;
							var engine = res.data.engine;

							if(common != undefined)
							{
								var m = [];
								colorset = [];
								for(var k = 0; k < legendset.length; k++)
								{
									legendset[k].linkSlicesKey = 999;
								}

								for(var i = 0; i < common.length; i++)
								{
									//if have 0 data, skip
									if(common[i].count == 0)
			//							continue;
										common[i].count = Number.MIN_VALUE;

									for(var j = 0; j < legendset.length; j++)
									{
										//redefined the color and index for pie series data source
										if(common[i].type == legendset[j].text)
										{
											colorset.push(legendset[j].color);
											legendset[j].linkSlicesKey = i;
										}
									}
									m.push(common[i]);
								}
//								pie.store.loadData(common);

								//set the new attribute for pir series
								pie.series.items[0].colorSet = colorset;
								pie.series.items[0].legendSet = legendset;
								pie.store.loadData(m);
							}

							if(engine != undefined)
							{
								for(var i = 0; i < engine.length; i++)
								{
									if(engine[i].count == 0)
										engine[i].count = Number.MIN_VALUE;
								}
								search.store.loadData(engine);
							}
						}
						else if(res.status == 'error')
							alert(res.error);
					}
				}
			}
		}

}
);
