/*
    ----------------------------------------
    JavaScript Information
	----------------------------------------
	Project - Two Line Static Header Table
*/

//Function Builds Static Header and Scrollable Div called with document onload
function MakeStaticHeader(xDataGridName,xScrollHeight){

    //Code Creates Divs in order to make scrollable body and Static Header
  
    //Grab the Table object
      var theTable = document.getElementById(xDataGridName);

    //Create a holder div so div header can be added correctly before table
      var myHolderDiv = document.createElement("div");
      myHolderDiv.setAttribute('id','tableHolder_'+ xDataGridName)

    //Create the Header Div, setting id and adding to Holder
      var myHeaderDiv = document.createElement("div");
      myHeaderDiv.setAttribute('id','divHeader_' + xDataGridName)
      myHolderDiv.appendChild(myHeaderDiv);

    //Insert the Holder and Header divs
      theTable.parentNode.insertBefore(myHolderDiv,theTable);

    //Append the Child
      myHolderDiv.appendChild(theTable)
    
    //More messy code with IE
      if(document.all){
        theName = "hold2_" + xDataGridName;
      }
      else{
        theName = xDataGridName;
      }
  
    //Create Body Div for scrollable body (IE creates a holder, mozilla creates the scroller)
      var theBodyDiv = document.createElement("div");
      theBodyDiv.setAttribute('id','divBody_' + theName)
      theBodyDiv.setAttribute('style','OVERFLOW-Y: scroll; OVERFLOW-X: auto; OVERFLOW: auto; HEIGHT: ' + xScrollHeight + ';')
      theTable.parentNode.insertBefore(theBodyDiv,theTable);
      theBodyDiv.appendChild(theTable);

    //Since IE can not apply the style to the new Child above, we need to make it messy! (IE is making this hard!)
      //Converts the holder to a scroller
        if(document.all){
          var theMessDiv = document.getElementById('divBody_' + theName);
          startDiv1 = '<div id="divBody_'+ xDataGridName +'" style="OVERFLOW-Y: scroll; OVERFLOW-X: auto; OVERFLOW: auto; HEIGHT: '+ xScrollHeight +';">';
          endDiv1 = '</div>';
          theMessDiv.innerHTML = startDiv1 + theMessDiv.innerHTML + endDiv1; 
        }


  //The following Code Builds the header

    //Grab border widths (have to check for different ways to define it!)
      var borderWidth = parseInt(document.getElementById(xDataGridName).style.borderwidth);
      if(!borderWidth)borderWidth = parseInt(document.getElementById(xDataGridName).border);
      if(!borderWidth)borderWidth = parseInt(0);

	//Grab the table Headers (if exsists)
	  var theThs = document.getElementById(xDataGridName).getElementsByTagName("th");
	  var hasThs = parseInt(theThs.length);
	  var hasHeadCells = false;
	  
	//See if the Table Headers exist  
	  if(hasThs>0){
	    hasHeadCells = true;
	  }

    //Grab the table rows
	  var theTrs = document.getElementById(xDataGridName).getElementsByTagName("tr");

    //Find the number of columns
      var theTrsTds = theTrs[1].getElementsByTagName("td");
	  var numberOfColumns = parseInt(theTrsTds.length);
		  		  
    //Grab all of the table cells
      var theTds = document.getElementById(xDataGridName).getElementsByTagName("td");

    //Determine the widths of the columns of DataGrid1
      var totalWidth = 0;
      var theWidths = new Array()
      for(i=0;i<numberOfColumns;i++){
		if(hasHeadCells){
		  theWidths[i] = theThs[i].offsetWidth;
		}
		else{
          theWidths[i] = theTds[i].offsetWidth;
        }
		theTds[i+numberOfColumns].style.width = theWidths[i]; 
        totalWidth += parseInt(theWidths[i]);
      }
		  
    //Set the width of the div so the scroll bar is on the edge of the table
      document.getElementById("divBody_" + xDataGridName).style.width = (totalWidth + 20 + (3 * (numberOfColumns - 1)) + borderWidth);
          
    //Grab the content for the headers
      theHeaderCode = theTrs[0].innerHTML;
	  
    //This is for IE only since it does not support getComputedStyle which is alot easier!
      var theStyle = "";
      if(document.getElementById("divBody_" + xDataGridName).currentStyle){
  
        //Grab the innerHTML and locate the style
          theX = document.getElementById("divBody_" + xDataGridName).innerHTML;
          theX = theX.split("style");
 
        //Verify that there is a style tag in the table tag
        if(theX[0].indexOf(xDataGridName) >= 0 && theX[1].indexOf("<TBODY>") >=0){
          //split aprt to get the style
            theQ = theX[1].split('"');
          //set the style string
            theStyle= "style='" + theQ[1] + "'";			  
        }
      }

    //Create the table code and set it on the document
      var str_tb_class, str_tr_class;
      var tbclass, trclass;
      if (document.all)
      {
           tbclass = theTable.getAttribute('className');
           trclass = theTrs[0].getAttribute('className');
      }
      else
      {
           tbclass = theTable.getAttribute('class');
           trclass = theTrs[0].getAttribute('class');
      }
      if (tbclass) str_tb_class = " class="+tbclass;
      if (trclass) str_tr_class = " class="+trclass;
      tbCode = "<table id='theAddon_"+ xDataGridName +"' "+ theStyle + str_tb_class + ">" + "<tr" + str_tr_class + ">" + theHeaderCode + "</tr></table>";
      document.getElementById("divHeader_" + xDataGridName).innerHTML = tbCode;
//alert(tbCode);
		  
    //Apply the CSS Class and the Widths to the header Elements
	  if(hasThs > 0){lookFor = "th";}
	  else{lookFor = "td";}
      theNewTD = document.getElementById("divHeader_" + xDataGridName).getElementsByTagName(lookFor);
      for(i=0;i<theNewTD.length;i++){
        theNewTD[i].style.width = theWidths[i];
      }

    //Apply CSS to the static table
      theOrgTable = document.getElementById(xDataGridName);
      theNewTable = document.getElementById("theAddon_" + xDataGridName);
	  for(x=0;x<theOrgTable.attributes.length;x++){
	    if(theOrgTable.attributes[x].nodeValue && theOrgTable.attributes[x].nodeName.toLowerCase() != "id"){
	      theNewTable.setAttribute(theOrgTable.attributes[x].nodeName,theOrgTable.attributes[x].nodeValue);
	    }
	  }

    //Hide the orginal header row
	    theTrs[0].style.display = "none";  		  
//alert(theTrs[0].style.display);
//alert(theTrs[0].innerHTML);

    //Make mozilla browsers see the applied styles
      makeSame(theOrgTable,theNewTable)
        
}

//Function to make Mozilla have the same inline styles
function makeSame(elem_1, elem_2){
  if (window.getComputedStyle){
    elem_1x=window.getComputedStyle(elem_1, "");
    elem_2x=window.getComputedStyle(elem_2, "");
    elem_2x = elem_1x;
  }
}

