function check(obj)
{
    obj.checked = true; 
}

function uncheck(obj)
{
    obj.checked = false;
}

function enable(obj)
{
    obj.disabled = false;
}

function disable(obj)
{
    obj.disabled = true;
}

function show(obj)
{
    obj.style.display="";
}

function hide(obj)
{
    obj.style.display="none";
}

function display(obj, isYes)
{
    if (isYes) show(obj);
    else hide(obj);
}

function isChecked(obj)
{
    return (obj.checked == true);
}

function isUnchecked(obj)
{
    return (obj.checked == false);
}

function isEnabled(obj)
{
    return (obj.disabled == false);
}

function setProperty(obj, property, value) {
	var evalStr = "obj." + property + "=" + value + ";";
	eval(evalStr);
}

function setPropertyById(id, property, value) {
	var obj;

	if (obj = document.getElementById(id)) {
		setProperty(obj, property, value);
	}
}

function changeStyle(obj, property, value) {
	setProperty(obj, "style." + property, value);
}

function changeStyleById(id, property, value) {
	var obj;

	if (obj = document.getElementById(id)) {
		changeStyle(obj, property, value);
	}
}

function changeStyleByIds(idArray, property, value) {
	var i;

	for (i = 0; i < idArray.length; i++) {
		changeStyleById(idArray[i], property, value);
	}
}

function setPropertyByIds(idArray, property, value) {
	var i;

	for (i = 0; i < idArray.length; i++) {
		setPropertyById(idArray[i], property, value);
	}
}

function getElementsByNameRegex(rootObj, elementNames, re) {
    var i, j;
    var objElementArray;
    var coll = new Array();

    for (i = 0; i < elementNames.length; i++) {
	objElementArray = rootObj.getElementsByTagName(elementNames[i]);
	for (j = 0; j < objElementArray.length; j++) {
	    if (re.test(objElementArray[j].name)) {
		coll.push(objElementArray[j]);
	    }
	}
    }
    return coll;
}

function getCheckedState(objArray) {
    var i;
    var state = true;

    for (i = 0; i < objArray.length; i++) {
	if (objArray[i].type == "checkbox") {
	    state = objArray[i].checked;
	    break;
	}
    }

    for (; i < objArray.length; i++) {
	if (state != objArray[i].checked) {
	    return -1;
	}
    }
    return state;
}

function setCheckall(id, re) {
    var state = getCheckedState(getElementsByNameRegex(document, ['input'], re));

    if (state < 0) state = false

    document.getElementById(id).checked = state;
}

function setPropertyByName(rootObj, elementNames, nameExp, property, value) {
	var i, j;
	var re = new RegExp(nameExp);
	var objElementArray;

	for (i = 0; i < elementNames.length; i++) {
		objElementArray = rootObj.getElementsByTagName(elementNames[i]);
		for (j = 0; j < objElementArray.length; j++) {
			if (re.test(objElementArray[j].name) && (!objElementArray[j].disabled || property == "disabled")) {
				setProperty(objElementArray[j], property, value);
			}
		}
	}
}

function hideElementsById(idArray, hide, hideChildren) {
	var rootObj;
	var hideText = hide ? "'none'" : "''";

	for (var i = 0; i < idArray.length; i++) {
		rootObj = document.getElementById(idArray[i]);
		if (rootObj) changeStyle(rootObj, "display", hideText);
		if (rootObj == null) continue;

		if (hideChildren) {
			for (var j = 0; j < rootObj.childNodes.length; j++) {
				try {
					changeStyle(rootObj.childNodes.item(j), "display", hideText);
				} catch (e) {
					continue;
				}
			}
		}
	}
}

function hideSliderElementsById(idArray, hide, hideChildren) {
	var rootObj;
	var hideText = hide ? "'none'" : "''";

	if(top.Sliderin._active.length == 0) return;
	for (var i = 0; i < idArray.length; i++) {
		rootObj = top.Sliderin._active[top.Sliderin._active.length-1]._$body.find('#'+idArray[i])[0];//document.getElementById(idArray[i]);
		if (rootObj) changeStyle(rootObj, "display", hideText);
		if (rootObj == null) continue;

		if (hideChildren) {
			for (var j = 0; j < rootObj.childNodes.length; j++) {
				try {
					changeStyle(rootObj.childNodes.item(j), "display", hideText);
				} catch (e) {
					continue;
				}
			}
		}
	}
}
function disableElementsById(idArray, disabled) {
	setPropertyByIds(idArray, "disabled", disabled);
}

function disableElementsByName(rootObj, elementNames, nameExp, disabled) {
	setPropertyByName(rootObj, elementNames, nameExp, "disabled", disabled);
}

function checkInputByName(rootObj, nameExp, checked) {
	setPropertyByName(rootObj, ['input'], nameExp, "checked", checked);
}

function hideSection(controlObj, idArray) {
	var hidden = !(document.getElementById(idArray[0]).style.display == 'none');

	hideElementsById(idArray, hidden);

	if (hidden) {
		controlObj.src = "/theme/images/twistie_collapsed.gif";
	} else {
		controlObj.src = "/theme/images/twistie_expanded.gif";
	}
}

function hideSection2(controlObj, idArray) {

	var hidden = !(document.getElementById(idArray[0]).style.display == 'none');

	hideElementsById(idArray, hidden);

	if (hidden) {
		$j(controlObj).removeClass("active"); 
	} else {
		$j(controlObj).addClass("active");
	}
}

function hideSectionIcon(controlObj, idArray) {

	var hidden = (controlObj.className == 'fa-minus-square');

	hideElementsById(idArray, hidden);

	if (hidden) {
		$j(controlObj).removeClass("fa-minus-square"); 
		$j(controlObj).addClass("fa-plus-square");
	} else {
		$j(controlObj).removeClass("fa-plus-square"); 
		$j(controlObj).addClass("fa-minus-square");
	}
}
function hideSliderIcon(controlObj, idArray) {

	var hidden = (controlObj.className == 'fa-minus-square');

	hideSliderElementsById(idArray, hidden);

	if (hidden) {
		$j(controlObj).removeClass("fa-minus-square"); 
		$j(controlObj).addClass("fa-plus-square");
	} else {
		$j(controlObj).removeClass("fa-plus-square"); 
		$j(controlObj).addClass("fa-minus-square");
	}
}
function implodeField(field, separator, onlySelected) {
	var i;
	var str = "";
	for (i = 0; i < field.length; i ++) {
		if (onlySelected) {
			if (field[i].selected) {
				if (str.length > 0) {
					str += separator;
				}
				str += field[i].value;
			}
		} else {
			if (str.length > 0) {
				str += separator;
			}
			str += field[i].value;
		}
	}
	return str;
}

function refreshFields(nameExp, elementNamesArray, refreshInterval) {
	var refreshFrameString = "refreshFrame";

	if (window.location.toString().indexOf(refreshFrameString, window.location.toString().length - refreshFrameString.length) > 0) {
		var i, j;
		var re = new RegExp(nameExp);
		var objElementArray;
		var refreshField;

		for (i = 0; i < elementNamesArray.length; i ++) {
			objElementArray = document.getElementsByTagName(elementNamesArray[i]);
			for (j = 0; j < objElementArray.length; j ++) {
				if (re.test(objElementArray[j].id)) {
					refreshField = parent.document.getElementById(objElementArray[j].id);
					if (refreshField) {
						refreshField.innerHTML = objElementArray[j].innerHTML;
						refreshField.setAttribute('style', objElementArray[j].getAttribute('style'));
						refreshField.style.cssText = objElementArray[j].style.cssText;
					}
				}
			}
		}

		if (refreshInterval) {
			window.setTimeout("window.location = window.location;", refreshInterval * 1000);
		}

	} else {
		var subFrame = document.createElement('iframe');

		subFrame.setAttribute('src', window.location.toString() + ((window.location.toString().split('?').length > 1) ? '&' : '?') + refreshFrameString);
		subFrame.setAttribute('name', 'refreshFrame');
		subFrame.setAttribute('height', '0');
		subFrame.setAttribute('width', '0');
		subFrame.setAttribute('frameborder', '0');
		document.body.appendChild(subFrame);
	}
}

function display_vdom_in_footer(title, vd_name)
{
	if (!top.footer) return;

	var vdom_sep = top.footer.document.getElementById('vdom_sep');
	var vdom_title = top.footer.document.getElementById('vdom_title');
	var vdom_val = top.footer.document.getElementById('vdom_val');

	if (vdom_sep && (vdom_sep.innerHTML == ""))
		vdom_sep.innerHTML = "<img src='theme/images/footer_separator.gif'>&nbsp;";

	if (vdom_title && (vdom_title.innerHTML == ""))
		vdom_title.innerHTML = title + ": ";

	if (vdom_val) {
		vdom_val.innerHTML = vd_name.toString();
	}
}

function clear_vdom_in_footer()
{
	if (!top.footer) return;

    var vdom_sep = top.footer.document.getElementById('vdom_sep');
    var vdom_title = top.footer.document.getElementById('vdom_title');
    var vdom_val = top.footer.document.getElementById('vdom_val');

    if (vdom_sep)
        vdom_sep.innerHTML = "";
    if (vdom_title)
        vdom_title.innerHTML= "";
    if (vdom_val)
        vdom_val.innerHTML= "";
}

// <select> field functions ---------------------------------------------------------------

function removeOptions(field) {
    var removedOptions = document.createElement("select");
    var i;
    var j = 0;
    
    for (i = 0; i < field.options.length; i++) {
	if (field.options[i].selected) {
	    removedOptions.options[j] = new Option();
	    removedOptions.options[j].text = field.options[i].text;
			removedOptions.options[j].value = field.options[i].value;
			removedOptions.options[j].selected = true;

			field.options[i] = null;
			i--;
			j++;
		}
	}

	return removedOptions;
}

function moveOptionField(fromField, toField) {
	var insertIndex = toField.options.length;
	var selectedOptions;
	var insertNumber = 0;
	var i;

	// find insertion point in destination field
	for (i = 0; i < toField.options.length; i ++) {
		if (toField.options[i].selected) {
				insertIndex = i + 1;
				toField.options[i].selected = false;
		}
	}

	// remove options from fromField
	selectedOptions = removeOptions(fromField);

	// add empty options by increasing length
	toField.options.length += selectedOptions.options.length;

	// shift old entries down
	for (i = (toField.options.length - 1); i >= (insertIndex + selectedOptions.options.length); i --) {
		toField.options[i].text = toField.options[i - selectedOptions.options.length].text;
		toField.options[i].value = toField.options[i - selectedOptions.options.length].value;
	}

	// insert new entries
	for (i = 0; i < selectedOptions.options.length; i ++, insertIndex ++) {
		toField.options[insertIndex].text = selectedOptions.options[i].text;
		toField.options[insertIndex].value = selectedOptions.options[i].value;
		toField.options[insertIndex].selected = true;
	}
}

function moveOptionUp(selectField) {
	var i;
	var oOption = new Option();
	var length = selectField.options.length;
	
	if (length == 0 || selectField.options[0].selected) {
		return 0;
	}
	
	for (i = 1; i < length; i ++) {
		if (selectField.options[i].selected) {
			oOption.text = selectField.options[i - 1].text;
			oOption.value = selectField.options[i - 1].value;

			selectField.options[i - 1].text = selectField.options[i].text;
			selectField.options[i - 1].value = selectField.options[i].value;
			selectField.options[i - 1].selected = true;

			selectField.options[i].text = oOption.text;
			selectField.options[i].value = oOption.value;
			selectField.options[i].selected = false;
		}
	}
}

function moveOptionDown(selectField) {
	var i;
	var oOption = new Option();
	var length = selectField.options.length;

	if (length == 0 || selectField.options[length - 1].selected) {
		return 0;
	}
	
	for (i = length - 1; i >= 0; i --) {
		if (selectField.options[i].selected) {
			oOption.text = selectField.options[i + 1].text;
			oOption.value = selectField.options[i + 1].value;

			selectField.options[i + 1].text = selectField.options[i].text;
			selectField.options[i + 1].value = selectField.options[i].value;
			selectField.options[i + 1].selected = true;

			selectField.options[i].text = oOption.text;
			selectField.options[i].value = oOption.value;
			selectField.options[i].selected = false;
		}
	}
}

function selectOptions(selectObj, optionArray, compareFn, selectValue, scroll) {
	var numberSelected = 0;
	var objOption = null;

	for (var i = 0; i < selectObj.length; i ++) {
		for (var j = 0; j < optionArray.length; j++) {
			if (compareFn(selectObj[i], optionArray[j]) == 0) {
				selectObj[i].selected = selectValue;
				numberSelected++;
				objOption = selectObj[i];
				break;
			}
		}
	}
	if (scroll && objOption) objOption.scrollIntoView();
	return numberSelected;
}

function moveOptions(fromObj, toObj, sort) {
	var optionArray = new Array();
	
	optionArray = optionsToArray(fromObj, 1, 1);
	insertOptions(toObj, optionArray, toObj.selectedIndex + 1);
	toObj.selectedIndex = -1;
	selectOptions(toObj, optionArray, compareObjTextString, true, false);

	if (sort == true) {
		sortOptions(toObj, compareObjTextString);
	}

	return optionArray;
}

function insertOptions(selectObj, optionArray, index) {
	var resultArray;
	resultArray = optionsToArray(selectObj, 2, 1);
	arrayToOptions(selectObj, resultArray.splice(0, index).concat(optionArray).concat(resultArray));
}

function optionsToArray(selectObj, mode, remove, startIndex, endIndex) {
	var optionArray = new Array();
	var i = startIndex ? startIndex : 0;
	endIndex = endIndex ? endIndex : selectObj.length;

	while (i < endIndex) {
		switch (mode) {
		case 0 : // not selected
			if (!selectObj[i].selected) {
				optionArray[optionArray.length] = selectObj[i];
				if (remove) {
					selectObj.removeChild(selectObj[i]);
					endIndex--;
					break;
				}
			}
			i++;
			break; 
		case 1 : // selected
			if (selectObj[i].selected) {
				optionArray[optionArray.length] = selectObj[i];
				if (remove == 1) {
					selectObj.removeChild(selectObj[i]);
					endIndex--;
					break;
				}
			}
			i++;
			break;
		case 2 :
		default : // all
			optionArray[optionArray.length] = selectObj[i];
			if (remove == 1) {
				selectObj.removeChild(selectObj[i]);
				endIndex--;
				break;
			}
			i++;
		}
	}
	return optionArray;
}

function arrayToMembers(arr)
{
    // join on # so that comma separated strings still work
    return optionToString(arr).join('#');
}

function arrayToOptions(selectObj, optionArray) {
	for (var i = 0; i < optionArray.length; i++) {
		selectObj.options[selectObj.options.length] = new Option(optionArray[i].text, optionArray[i].value, optionArray[i].selected);
		selectObj.options[selectObj.options.length - 1].selected = optionArray[i].selected;
	}
}

function stringToOption(stringArray) {
	var optionArray = new Array();
	for (var i = 0; i < stringArray.length; i++) {
		optionArray[i] = new Option(stringArray[i], stringArray[i], false);
		optionArray[i].selected = false;
	}
	return optionArray;
}

function optionToString(optionArray) {
	for (var i = 0; i < optionArray.length; i++) {
		optionArray[i] = optionArray[i].value;
	}
	return optionArray;
}

function optionTextToString(optionArray) {
	for (var i = 0; i < optionArray.length; i++) {
		optionArray[i] = optionArray[i].text;
	}
	return optionArray;
}

function sortOptions(selectObj, compareFn) {
	var optionArray = optionsToArray(selectObj, 2, 1);
	optionArray.sort(compareFn);
	arrayToOptions(selectObj, optionArray);
}

function compareObjTextString(a, b) {
	if (a.text < b.text) return -1;
	if (a.text > b.text) return 1;
	return 0;
}

function compareObjValueString(a, b) {
	if (a.value < b.value) return -1;
	if (a.value > b.value) return 1;
	return 0;
}

function compareObjValueInt(a, b) {
	if (parseInt(a.value) < parseInt(b.value)) return -1;
	if (parseInt(a.value) > parseInt(b.value)) return 1;
	return 0;
}


// array functions ----------------------------------------------------------------

function uniquefyArray(array1) {
	var array2 = new Array();
	var found = 0;
	
	for (var i = 0; i < array1.length; i++) {
		found = 0;
		for (var j = 0; j < array2.length; j++) {
			if (array1[i] == array2[j]) {
				found = 1;
				break;
			}
		}
		if (!found) {
			array2[array2.length] = array1[i];
		}
	}
	return array2;
}

function removeFromArray(array1, array2) {
	var array3 = new Array();
	var found = 0;
	
	for (var i = 0; i < array1.length; i++) {
		found = 0;
		for (var j = 0; j < array2.length; j++) {
			if (array1[i] == array2[j]) {
				found = 1;
				break;
			}
		}
		if (!found) {
			array3[array3.length] = array1[i];
		}
	}
	return array3;
}

function matchArray(array1, array2) {
	var array3 = new Array();

	for (var i = 0; i < array1.length; i++) {
		for (var j = 0; j < array2.length; j++) {
			if (array1[i] == array2[j]) {
				array3[array3.length] = array1[i];
			}
		}
	}
	return array3;
}

// quicksort objects ---------------------------------------------------------------------

function removeTextNodes(node) {
	for (var i = 0; i < node.childNodes.length; i ++) {
		if (node.childNodes.item(i).nodeType == 3) {
			node.removeChild(node.childNodes.item(i));
		}
	}
}

function swapChildNodes(node, childNode1, childNode2) {
	var temp;
	
	if (childNode1 == childNode2) return;

	temp = childNode1.cloneNode(true);
	node.replaceChild(temp, childNode1);
	node.replaceChild(childNode1, childNode2);
	node.replaceChild(childNode2, temp);
}

function appendChildNodes(node, sourceNode) {
	var newSourceNode = sourceNode.cloneNode(true);
	var childNodes = newSourceNode.childNodes;
	var length = childNodes.length;

	while (childNodes.length > 0) {
		node.appendChild(childNodes.item(0));
	}
}

function removeChildNodes(node) {
	var childNodes = node.childNodes;
	var length = childNodes.length;

	while (childNodes.length > 0) {
		node.removeChild(childNodes.item(0));
	}
}

function replaceChildNodes(node, sourceNode) {
	var newSourceNode = sourceNode.cloneNode(true);
	
	removeChildNodes(node);
	appendChildNodes(node, newSourceNode);

	removeTextNodes(node);
	quicksortChildNodes(node, 0, node.childNodes.length - 1, "value");
}

function quicksortChildNodes(node, left, right, attributeName)	{
	var i, j;
	var pivot, temp;
	var childNodes = node.childNodes;
		
	if (left < right) {
		swapChildNodes(node, childNodes.item(parseInt((left + right) / 2)), childNodes.item(right));
		pivot = childNodes.item(right).getAttribute(attributeName);

		i = left - 1;
		j = right;

		for (;;) {
			while (childNodes.item(++ i).getAttribute(attributeName) < pivot);
			while (j > 0 && childNodes.item(-- j).getAttribute(attributeName) > pivot);

			if (i < j) {
				swapChildNodes(node, childNodes.item(i), childNodes.item(j));
			} else {
				break;
			}
		}
		swapChildNodes(node, childNodes.item(i), childNodes.item(right));

		quicksortChildNodes(node, left, i - 1, attributeName);
		quicksortChildNodes(node, i + 1, right, attributeName);
	}
}

// end quicksort routines -------------------------------------------------------------------

function linearSearchChildNodes(node, attributeName, attributeValue, caseSensitive) {
	var childNodes = node.childNodes;

	if (!caseSensitive) {
		attributeValue = attributeValue.toLowerCase();
		
		for (var i = 0; i < childNodes.length; i ++) {
			if (childNodes.item(i).nodeType == 1) {
				if (childNodes.item(i).getAttribute(attributeName).toLowerCase() == attributeValue) {
					return childNodes.item(i);
				}
			}
		}
	} else {
		for (var i = 0; i < childNodes.length; i ++) {
 			if (childNodes.item(i).nodeType == 1) {
				if (childNodes.item(i).getAttribute(attributeName) == attributeValue) {
					return childNodes.item(i);
				}
			}
		}
	}
	return null;
}

var RegExpCommon = new function RegExpCommon() {
	// E-mail address (ie. username@host)
	this.EMAIL_ADDRESS = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/; 

	// Host (ie. 1.2.3.4)
	this.IP_HOST = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;

	// Mask (ie. 255.255.255.0)
	this.IP_MASK = /^(((255|254|252|248|240|224|192|128|0)\.0\.0\.0)|(255\.(255|254|252|248|240|224|192|128)\.0\.0)|(255\.255\.(255|254|252|248|240|224|192|128)\.0)|(255\.255\.255\.(255|254|252|248|240|224|192|128|0)))$/;

	// Range (IP_HOST-IP_HOST)
	this.IP_RANGE = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(-(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|-((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|\/(3[0-2]|[1-2][0-9]|[0-9]))?$/;

	// MAC address (ie. xx:xx:xx:xx:xx:xx)
	this.MAC_ADDRESS = /^[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}$/;

	// IP subnet (ie. 172.16.79.19/24 or 172.16.79.19/255.255.255.0)
	this.IP_SUBNET = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/((((254|252|248|240|224|192|128|0)\.0\.0\.0)|(255\.(254|252|248|240|224|192|128|0)\.0\.0)|(255\.255\.(254|252|248|240|224|192|128|0)\.0)|(255\.255\.255\.(255|254|252|248|240|224|192|128|0))|(3[0-2]|2[0-9]|1[0-9]|[0-9])))$/;

	// integer (0-9)
	this.INTEGER = /^[-]?[0-9]+$/;

	// name (no invalid characters)
	this.NAME = /^[^<>#()"']+$/;

	// cross scripting characters 
	this.XSS = /^[^<>()#'"]*$/;

	// integer range
	this.RANGE_INT = /^[0-9]*-[0-9]+$|^([0-9]+-?)$/;

	// time
	this.TIME = /^(([0-1]?[0-9]|[2][0-3]):([0-5]?[0-9]):([0-5]?[0-9]))?$/;

	// date
	this.DATE = /^([0-9]{4}-([0]?[0-9]|[1][0-2])-([0-2]?[0-9]|3[0-1]))?$/;
}


function matchFieldExp(str, regExpTestArray) {
    for (var i = 0; i < regExpTestArray.length; i++) {
	if (regExpTestArray[i].test(str)) {
	    return i;
	}
    }
    return -1;
}

function checkFieldExp(field, regExpTestArray, errorMessage) {
	if (matchFieldExp(field.value.toString(), regExpTestArray) < 0) {
		alert(errorMessage);
		field.focus();
		field.select();
		return false;
	}

	return true;
}

function getRadioValue(radioObj) {
	var i;

	for (i = 0; i < radioObj.length; i ++) {
		if (radioObj[i].checked) {
			if (radioObj[i].value) {
				return radioObj[i].value;
			} else {
				return i;
			}
		}
	}
	return null;
}

function setRadioValue(radioObj, val) {
	var i;

	for (i = 0; i < radioObj.length; i ++) {
		if (radioObj[i].value == val) {
			radioObj[i].checked = true;	
			break;		
		}
	}
	return null;
}

function insertOption(selectField, oOption, compareFn, selectOption) {

	// selectField - <select> field to insert option
	// oOption - <option> field to insert
	// comparFn - comparative function to find index to insert at
	// selectOption - select option upon insertion

	var i;
	if (compareFn) {
		for (var i = 0; i < selectField.length; i ++) {
			if (compareFn(oOption, selectField.options[i]) < 0) {
				for (var j = selectField.length; j > i; j --) {
					selectField.options[j] = new Option(selectField.options[j - 1].text,
						selectField.options[j - 1].value,
						selectField.options[j - 1].defaultSelected,
						selectField.options[j - 1].selected);
				}
				break;
			}
		}
	} else {
		i = selectField.length;
	}
	selectField.options[i] = oOption;
	if (selectOption) {
		selectField[i].selected = true;
	}
}

// popup_generic_i - generic popup function
function popup_generic_i(link, windowName, width, height, attrs)
{
	// document.body.offsetWidth is the window width on IE and
	// window.innerWidth is the window width on Mozilla
	var x = ((window.innerWidth ? window.innerWidth : document.body.offsetWidth) - width)/2;
	var y = ((window.innerHeight ? window.innerHeight : document.body.offsetHeight) - height)/2;
	
	if(x < 0) x = 0;
	if(y < 0) y = 0;
	
	var popupWindow = window.open(link, windowName, attrs + ',width=' + width + ',height=' + height + ',top=' + y + ',left=' + x + ',screenX=' + x + ',screenY=' + y);
	
	if(!popupWindow)
		return null;
	popupWindow.resizeTo(width, height);
	popupWindow.moveTo(x, y);
	popupWindow.focus();

	return popupWindow;
}

function popup_resizable(link, windowName, width, height)
{
	return popup_generic_i(link, windowName, width, height, 'dependent=yes,scrollbars=yes,resizable=1');
}

function popup(link, windowName, width, height)
{
	return popup_generic_i(link, windowName, width, height, 'dependent=yes,scrollbars=yes,resizable=no');
}

// popup_nonscrollable - variant of popup_resizable without scrollbars (used by the JS console).
function popup_nonscrollable(link, windowName, width, height) 
{
	return popup_generic_i(link, windowName, width, height, 'dependent=yes,scrollbars=no,resizable=1');
}


function callFunctionArray(functionArray) {
	for (var i = 0; functionArray[i]; i ++) {
		functionArray[i]();
	}
}

function obj_del(msg, url, obj) {
        var row_obj = obj.parentNode.parentNode;
        var class_old = ''; 

        if (row_obj && row_obj.tagName == 'TR' && row_obj.set_class)
        {
            row_obj.onmouseout= null;
            class_old = row_obj.className;
            row_obj.set_class('over');
        }
	if (confirm(msg)){
		document.location = url;
	}
	else 
        {
            if (row_obj && row_obj.tagName == 'TR' && row_obj.set_class)
            {
                row_obj.onmouseout= tt_mout;
                row_obj.set_class(class_old);
            }
            return;
        }
}

function clear_all(msg, url) {
	if (confirm(msg)){
		document.location = url;
	}
	return;
}

// Tri-state checkbox functions ----------------------------------------------------------------------
function setCheckboxValue(obj, value) {
	obj.value = value;

	switch (value) {
	case 0 : obj.className = "checkbox_off"; break;
	case 1 : obj.className = "checkbox_on"; break;
	default : obj.className = "checkbox_tri"; break;
	}
}

function doCheck(obj) {
	var value;
	var isTristate;
	var old_value;

	if (obj.type == "checkbox") {
		value = obj.checked ? 1 : 0;
	} else {
		value = parseInt(obj.value);
		if (value != 0 && value != 1) {
			old_value = value;
			value = 2;
		}

		isTristate = ((value == 2) || (obj.getAttribute("tristate") ? true : false));

		// save child values
		if (value == 2) {
			obj.setAttribute("childValues", getValuesByName("^" + obj.name + "_", true).toString());
			obj.setAttribute("tristate", old_value);
		}

		value = (value + 1) % (isTristate ? 3 : 2);

		if (value == 2) {
			value = parseInt(obj.getAttribute("tristate"));
		}

		setCheckboxValue(obj, value);
	}

	switch (value) {
	case 0 : checkByName("^" + obj.name + "_", [0]); break;
	case 1 : checkByName("^" + obj.name + "_", [1]); break;
	default : checkByName("^" + obj.name + "_", obj.getAttribute("childValues").split(",")); break;
	}

	var re = obj.name.substring(0, obj.name.lastIndexOf("_"));

	if (re.length > 0) {
		checkByName("^" + re + "$", [evalTristate(getValuesByName("^" + obj.name.substring(0, obj.name.lastIndexOf("_") + 1), true))]);
	}
}

function getValuesByName(nameExp, includeAll) {
	var i;
	var re = new RegExp(nameExp);
	var objElementArray = document.getElementsByTagName("input");
	var values = new Array();

	for (i = 0; i < objElementArray.length; i++) {
		if (re.test(objElementArray[i].name)) {
			if (objElementArray[i].type == "checkbox") {
                if (!includeAll && !objElementArray[i].checked) continue;

                if (includeAll && !objElementArray[i].checked) {
                    values[values.length] = 0;
                    continue;
                }

				if (objElementArray[i].value == "on") {
                    values[values.length] = 1;
                }
                else {
                    values[values.length] = objElementArray[i].value;
                }
			} else {
				values[values.length] = objElementArray[i].value;
			}
		}
	}
	return values;
}

function evalTristate(values) {
	var zero, one, two = false;
	var csv = values.toString();

	if (csv.indexOf("0") > -1) zero = true;
	if (csv.indexOf("1") > -1) one = true;
	if (csv.indexOf("2") > -1) two = true;
	
	if (two || (zero && one)) return 2;
	if (zero) return 0;
	return 1;
}

function checkByName(nameExp, values) {
	var i, j;
	var re = new RegExp(nameExp);
	var objElementArray = document.getElementsByTagName("input");

	for (i = 0, j = 0; i < objElementArray.length; i++) {
		if (re.test(objElementArray[i].name)) {
			if (objElementArray[i].type == "checkbox") {
				setProperty(objElementArray[i], "checked", (values[j] == 1) ? true : false);
				objElementArray[i].value = values[j];
			} else {
				setCheckboxValue(objElementArray[i], parseInt(values[j]));
			}
			if (values[j + 1]) j++;
		}
	}
}

// end of tri-state checkbox functions --------------------------------------------------------------------

function serializeArray(inputArray) {
	var arrayString = "";

	if (!inputArray) return arrayString;

	for (var i = 0; i < inputArray.length; i++) {
		if (typeof(inputArray[i]) == "object") {
			arrayString += escape(serializeArray(inputArray[i])) + "&";
		} else {
			arrayString += escape(inputArray[i]) + "&";
		}
	}
	return arrayString;
}

function deserializeArray(arrayString) {
	var stringArray = arrayString.split("&");
	var elementString;

	stringArray.length -= 1;
	for (var i = 0; i < (stringArray.length); i++) {
		elementString = unescape(stringArray[i]);		

		if (elementString.indexOf("&") < 0) {
			stringArray[i] = unescape(elementString);
			if (elementString.indexOf("=") >= 0) {
				var fieldArray = elementString.split("=");
				stringArray[fieldArray[0]] = fieldArray[1];
			}
		} else {
			stringArray[i] = deserializeArray(elementString);
		}
	}
	return stringArray;
}

function clog_flg(flg_ip)
{
   var ip = "https://" + flg_ip;
   window.open(ip, "flg");
   window.close();
}

function clog_link()
{
    if (window.opener)
        window.opener.top.main.location = '/log/setting/dlg';
    window.close();
}

function appendFormField(thisForm, name, value) {
	var obj;

	obj = document.createElement("input");
	obj.type = "hidden";
	obj.name = name;
	obj.value = value;
	thisForm.appendChild(obj);
}

function get_xmlhttp() {
	var xmlhttp = null;

	try {
		xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
	} catch(e) {
		try {
			xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
		} catch(oc) {
			xmlhttp = null;
		}
	}

	if (!xmlhttp && typeof XMLHttpRequest != "undefined") {
		xmlhttp = new XMLHttpRequest();
	}

	return xmlhttp;
}

function send_request(str_url, str_body) {
	var xmlhttp = get_xmlhttp();
	var str_method = ((str_body == "") ? "GET" : "POST");

	xmlhttp.open(str_method, str_url, false);
	xmlhttp.send(str_body);

	return xmlhttp.responseText;
}

// send_simple_async_request - send an asynchronous XMLHttpRequest and don't wait for
// a response (useful for disconnection or keepalive messages).
function send_simple_async_request(str_url, str_body)
{
	var xmlhttp = get_xmlhttp();
	var str_method = ((str_body == "") ? "GET" : "POST");

	// True means to use an asynchronous connection. This is better than using synchronous
	// requests (since blocking connections may hang the browser if they fail).
	xmlhttp.open(str_method, str_url, true);

	// It is a good idea to thwart browser caching, since it is quite probable that we are 
	// sending the exact same message string every time.
	// (Probably not all of the below are needed, but at least one of them does something. :-))
	xmlhttp.setRequestHeader("Pragma", "no-cache");
	xmlhttp.setRequestHeader("Cache-Control", "no-store, no-cache, must-revalidate");
	xmlhttp.setRequestHeader("If-Modified-Since", 0);

	xmlhttp.send(str_body);
}

function getObjectsByProperty(rootObj, elementNames, property, propertyExp)
{
	var re = new RegExp(propertyExp);
	var objElementArray;
	var objArray = new Array();

	for (var i = 0; i < elementNames.length; i++) {
		objElementArray = rootObj.getElementsByTagName(elementNames[i]);
		for (var j = 0; j < objElementArray.length; j++) {
			if (re.test(getObjectProperty(objElementArray[j], property))) {
				objArray[objArray.length] = objElementArray[j];
			}
		}
	}
	return objArray;
}

function setObjectPropertyArray(objArray, property, value)
{
	for (var i = 0; i < objArray.length; i++) {
		setProperty(objArray[i], property, value);
	}
	return objArray;
}

function getObjectProperty(obj, property)
{
	var evalStr = "obj." + property;
	return	eval(evalStr);
}

function setObjectProperty(obj, property, value)
{
	var evalStr = "obj." + property + "=" + value + ";";
	eval(evalStr);
}

function getObjectPropertyArray(objArray, property)
{
	var propertyArray = new Array();

	for (var i = 0; i < objArray.length; i++) {
		propertyArray[propertyArray.length] = getObjectProperty(objArray[i], property);
	}
	return propertyArray;
}

// the following 2 functions will not work for entries containing '&'
function serializeArray(inputArray) {
	var arrayString = "";

	if (!inputArray) return arrayString;

	for (var i = 0; i < inputArray.length; i++) {
		if (typeof(inputArray[i]) == "object") {
			arrayString += escape(serializeArray(inputArray[i])) + "&";
		} else {
			arrayString += escape(inputArray[i]) + "&";
		}
	}
	return arrayString;
}

function deserializeArray(arrayString) {
	var stringArray = arrayString.split("&");
	var elementString;

	stringArray.length -= 1;
	for (var i = 0; i < (stringArray.length); i++) {
		elementString = unescape(stringArray[i]);		

		if (elementString.indexOf("&") < 0) {
			stringArray[i] = unescape(elementString);
			if (elementString.indexOf("=") >= 0) {
				var fieldArray = elementString.split("=");
				stringArray[fieldArray[0]] = fieldArray[1];
			}
		} else {
			stringArray[i] = deserializeArray(elementString);
		}
	}
	return stringArray;
}

function setCookie(key, value)
{
	var pathname = location.pathname.substring(0, location.pathname.lastIndexOf('/')) + '/';

	// set expiry date to 1 year from now.
	var expireDate = new Date();
	expireDate.setTime(expireDate.getTime() + (365 * 24 * 3600 * 1000));
	document.cookie = key + "=" + escape(value) + "; expires=" + expireDate.toGMTString() + "; path=" + pathname; + ";";
}


function getCookie(key)
{
	// cookies are separated by semicolons
	var aCookie = document.cookie.split("; ");
	for (var i = 0; i < aCookie.length; i++) {
		// a name/value pair (a crumb) is separated by an equal sign
		var aCrumb = aCookie[i].split("=");
		if (key == aCrumb[0]) 
		return unescape(aCrumb[1]);
	}

	// a cookie with the requested name does not exist
	return null;
}

function nodeToArray(parentNode, remove) {
	var nodeArray = new Array();
	var i = 0;

	while (i < parentNode.childNodes.length) {
		nodeArray[nodeArray.length] = parentNode.childNodes[i];
		if (remove) {
			parentNode.removeChild(parentNode.childNodes[i]);
			continue;
		}
		i++;
	}
	return nodeArray;
}

function arrayToNode(parentNode, nodeArray) {
	for (var i = 0; i < nodeArray.length; i++) {
		parentNode.appendChild(nodeArray[i]);

	}
	return parentNode;
}

function swapArrayElements(thisArray, index1, index2) {
	var temp;

	temp = thisArray[index1];
	thisArray[index1] = thisArray[index2];
	thisArray[index2] = temp;

	return thisArray;
}

function moveNode(nodeObj, distance) {
	var parentNode = nodeObj.parentNode;
	var nodeArray = nodeToArray(parentNode, true);

	var index1 = findInArray(nodeArray, nodeObj);
	var index2 = index1 + distance;

	if (index2 > nodeArray.length - 1) {
		index2 = nodeArray.length - 1;
	}

	if (index2 < 0) {
		index2 = 0;
	}

	nodeArray = swapArrayElements(nodeArray, index1, index2);
	arrayToNode(parentNode, nodeArray);
	
	return nodeArray;
}

function arrangeNodesByAttribute(nodeArray, attributeArray, attributeName) {
	var tempNode;

	for (var i = 0; i < attributeArray.length; i++) {
		for (var j = i; j < nodeArray.length; j++) {
			if (nodeArray[j].nodeType != 1) continue;

			if (nodeArray[j].getAttribute(attributeName) == attributeArray[i]) {
				swapArrayElements(nodeArray, j, i);
				break;
			}
		}
	}
	return nodeArray;
}

function findInArray(thisArray, elementToFind) {
	var index = -1;

	for (var i = 0; i < thisArray.length; i++) {
		if (thisArray[i] == elementToFind) {
			index = i;
			break;
		}
	}
	return index;
}

function nodeToString(nodeArray, attributeName) {
	for (var i = 0; i < nodeArray.length; i++) {
		nodeArray[i] = nodeArray[i].getAttribute(attributeName);
	}
	return nodeArray;
}

// table row functions

function getRows(parentNode, cookieName) {
	var cookieString = getCookie(cookieName);

	if (!cookieString) {
		cookieString = "";
	}

	var idArray = deserializeArray(cookieString);

	removeTextNodes(parentNode);	

	var nodeArray = nodeToArray(parentNode, true);
	nodeArray = arrangeNodesByAttribute(nodeArray, idArray, 'id');
	arrayToNode(parentNode, nodeArray);
}

function setRows(parentNode, cookieName) {
	var nodeArray = nodeToArray(parentNode, false);

	nodeArray = nodeToString(nodeArray, 'id');

	setCookie(cookieName, serializeArray(nodeArray));
}

function moveRow(id, distance) {
	var rowNode = document.getElementById(id);

	moveNode(rowNode, distance);
}

function cat_members(obj_sel, obj_mem)
{
	var len = obj_sel.length;
	var i;
	var members = '';

	if (len >0) {
		members = obj_sel.options[0].text;
		for (i = 1; i < len; i++) {
			members = members + '#' + obj_sel.options[i].text;
		}
		obj_mem.value = members;
	}
}

function validateFieldRange(fieldObj, minValue, maxValue, errorMessage) {
	var v = fieldObj.value;
	var fieldValue = toNumber(v, 0, v.length);

	if ((fieldValue != -1) && (fieldValue >= minValue && fieldValue <= maxValue)) {
		return true;
	}

	alert(errorMessage);
	fieldObj.focus();
	fieldObj.select();
	return false;
}

// filter functions

function FilterDisplay(fieldName, filterType, enable, negate, contains, value) {
	this.fieldName = fieldName;
	this.filterType = filterType;
	this.enable = enable;
	this.contains = contains;
	this.negate = negate;
	this.value = value;
	this.toArray = function toArray() {
		var filterArray = new Array(this.fieldName, this.enable, this.negate, this.contains, this.value);
		return filterArray;
	}
}

function getFilterDisplay(filterArray, fieldName) {
	for (var i = 0; i < filterArray.length; i++) {
		if (filterArray[i][0] == fieldName) {
			return new FilterDisplay(fieldName, filterArray[i][1], filterArray[i][2], filterArray[i][3], filterArray[i][4]);
		}
	}
	return new FilterDisplay(fieldName, 1, 0, 0, null);
}

function setFilterDisplay(filterCookieArray, filter) {
	if (!filter) return filterCookieArray;
	if (!filterCookieArray) {
		filterCookieArray = [];
	}
	for (var i = 0; i < filterCookieArray.length; i++) {
		if (filterCookieArray[i][0] == filter.fieldName) {
			filterCookieArray[i] = filter.toArray();
			return filterCookieArray;
		}
	}
	filterCookieArray[filterCookieArray.length] = filter.toArray();
	return filterCookieArray;
}

function removeFilterDisplay(filterCookieArray, fieldName) {
	if (!filterCookieArray) {
		filterCookieArray = [];
	}
	for (var i = 0; i < filterCookieArray.length; i++) {
		if (filterCookieArray[i][0] == fieldName) {
			filterCookieArray.splice(i, 1);
			break;
		}
	}
	return filterCookieArray;
}

function goto_fa()
{
    top.mainnav.refreshmenu('log', 'logconfig', 'logsetting');
}

function goto_fmg()
{
    top.mainnav.refreshmenu('system', 'admin', 'central_mgmt');
}

function addEvent(obj, type, fn)
{
    if (obj.addEventListener)
	obj.addEventListener( type, fn, false );
    else if (obj.attachEvent) {
	obj["e" + type + fn] = fn;
	obj[type + fn] = function() { 
	    obj["e" + type + fn]( window.event );
	}
	obj.attachEvent( "on" + type, obj[type + fn] );
    }
}

function removeEvent(obj, type, fn)
{
    if (obj.removeEventListener)
	obj.removeEventListener( type, fn, false );
    else if (obj.detachEvent) {
	obj.detachEvent( "on" + type, obj[type  +fn] );
	obj[type + fn] = null;
	obj["e" + type + fn] = null;
    }
}

function buttonHideAllDropdown(e) {
	var remove = 1;
	var obj = e.target ? e.target : e.srcElement;
	var ul_obj = null;

	try {
            if (obj.className == "options_button") {
                ul_obj = obj.parentNode.parentNode.parentNode.parentNode.getElementsByTagName('ul')[0];
            }
            else {
                ul_obj = null;
            }
	}
	catch (e) {
	    ul_obj = null;
	}

	var coll = document.getElementsByTagName("ul");

	for (var i = 0; i < coll.length; i++) {
		if (coll[i] == ul_obj) {
			if (ul_obj.style.display == '') remove = 0;			
		}
		else if (coll[i].className == "dropdown") {
			coll[i].style.display = 'none';
		}
	}
	if (remove) removeEvent(document, 'click', buttonHideAllDropdown);
}

function buttonToggleDropdown(obj) {
	try {
	    var ul_obj = obj.getElementsByTagName('ul')[0];
	}
	catch (e) {
	    return;
	}

	if (ul_obj.style.display == '') {
		ul_obj.style.display = 'none';
	}
	else {
		ul_obj.style.display = '';
		addEvent(document, 'click', buttonHideAllDropdown);
	}
}

function getCheckedValues(re) {
    var i;
    var objElementArray;
    var coll = new Array();

    objElementArray = document.getElementsByTagName("input");
    for (i = 0; i < objElementArray.length; i++) {
	if (re.test(objElementArray[i].name)) {
	    if (objElementArray[i].checked) {
		coll.push(objElementArray[i].value);
	    }
	}
    }
    return coll;
}

function obj_multi_del(url, id, type, msg, re) {
    var mkeyArray = getCheckedValues(re);
    if (mkeyArray.length <= 0) {
	return;
    }
    else {
	if (confirm(msg)) {
	    url += "?id=" + id + "&type=" + type + "&mkey=" + mkeyArray.join("&mkey=");
	    document.location = url;
	}
    }
}

function appendOption(o, text, val, sel) 
{
	var option;
	option = document.createElement('option');
	option.innerHTML = escapeHTML(text);
	option.value = val;
	option.selected = sel;
	o.appendChild(option);
}

function escapeHTML(s)
{
	var i, c;
	var rs = "";
	if (s.indexOf('&') == -1) return s;

	for(i=0; i<s.length;i++)
	{
		c = s.charAt(i);
		if (c == '&') rs += '&amp;';
		else rs += c;
	}
	return rs;
}

function xnode2Array(d, s)
{
	d.length = 0;
	for(var i=0; i<s.length; i++)
	{
		d.push(s[i].firstChild.nodeValue);
	}
}

function xnode2String(s)
{
	var str = '';
	for(var i=0; i<s.length; i++)
	{
		if (s[i].firstChild) str += s[i].firstChild.nodeValue;
	}
	return str;
}

function isArrayMember(t, arr)
{
	var i;

	for(i=0; i<arr.length; i++)
	{
		if (t == arr[i]) return true;
	}
	return false;
}
// ========== REQUEST ====================================================================================================

var Request = new Object();

Request.send = function(url, method, callback, data, urlencoded) {
	var req;
	if (window.XMLHttpRequest) {
		req = new XMLHttpRequest();
	} else if (window.ActiveXObject) {
		req = new ActiveXObject("Microsoft.XMLHTTP");
	}
	var readychange = function() {
		if (req.readyState == 4) {// only if req shows "loaded"
			if (req.status == 200) {// only if "OK"
				if (method=="POST") {
					if (callback) {
						callback(req);
						delete callback;
					}
				} else {
					if (callback) {
						callback(req,data);
						delete callback;
					}
				}
			} else if (typeof req == "undefined" || typeof req.status == "undefined") {
				if (callback) delete callback;
			} else if (req.status == 404) { //page not found 
				alert('Request URL was not found.');
				if (callback) {
					callback(req);
					delete callback;
				}
			}
/*
		} else {
alert(req.readyState +'---'+req.status);
			switch(req.status) {
					// windows error codes
					case 12002: // server timeout
					case 12029: case 12030: case 12031: // dropped connection
					case 12152: // connection closed by server
					case 13030:
						alert("There was a network problem. Please reload the page.");
						break;
					case 500: case 503:
						alert("There was an internal server error. Please try later.");
						break;
					default:
						alert("There was a problem loading data:" + "\nstatus: " + req.status+ "/" + req.statusText + "\n" + url);
			}
				if (callback) delete callback;
*/
		}
	};

	function do_request() {
		if (method=="POST") {
			req.open("POST", url, true);
			if (urlencoded) req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
			req.onreadystatechange = readychange;
			req.send(data);
		} else {
			req.open("GET", url, true);
			req.onreadystatechange = readychange;
			req.send(null);
		}
	};
	do_request();
	return req;
}

Request.sendRawPOST = function(url, data, callback) {
	Request.send(url, "POST", callback, data, false);
}
Request.sendPOST = function(url, data, callback) {
	Request.send(url, "POST", callback, data, true);
}
Request.sendGET = function(url, callback, args) {
	return Request.send(url, "GET", callback, args);
}

/* String buffer class - for optimized large HTML string generation on IE6. */
function StringBuffer()
{ 
   this.buffer = []; 
} 
 
StringBuffer.prototype.append = function append(string)
{ 
   this.buffer.push(string); 
   return this; 
}; 
 
StringBuffer.prototype.toString = function toString()
{
   return this.buffer.join(""); 
}; 


function convertMaskDot2Num(mask) {
    var bitmask = 0;
    var mask_array;

    if (matchFieldExp(mask, [RegExpCommon.IP_MASK]) < 0) {
        return -1;
    }
	
    mask_array = mask.split(".");
	
    for (var i = 0; i < mask_array.length; i++) {
		
        for (; mask_array[i] > 0; mask_array[i] >>>= 1) {
            if (mask_array[i] & 0x1) bitmask++;
        }
    }

    return bitmask;
}

// get_last_child_of_type - generic DOM traversal function, such as would be
// used to append new rows to a table.
function get_last_child_of_type(obj, type)
{
	var i;
	
	try
	{
		var len = obj.childNodes.length;
	}
	catch (e)
	{
//alert("get_last_child_of_type failed for obj = " + obj + ", type = " + type);
		return null;
	}
	
	for (i = len-1; i >= 0; i--)
	{
		if (obj.childNodes[i].nodeName == type)
		{
			return obj.childNodes[i];
		}
	}
	
	return null;
}

function scrollTableHeader(headerID, containerID)
{
    var containerDiv = document.getElementById(containerID);
    var headerTable  = document.getElementById(headerID);

    if (containerDiv && headerTable)
    {
        headerTable.style.left = -1 * containerDiv.scrollLeft;
    }
}

function matchTables(headerID, contentID, containerID, headerContainerID)
{
    var contentTable  = document.getElementById(contentID);
    var headerTable   = document.getElementById(headerID);
    var containerDiv  = document.getElementById(containerID);
    var headerDiv     = headerContainerID ? document.getElementById(headerContainerID) : null;

    if (contentTable && headerTable && containerDiv)
    {
        var tableHeader   = contentTable.getElementsByTagName('thead');
        var tableBody     = contentTable.getElementsByTagName('tbody');
        var tableHeadings = null;
        var tableRows     = null;
        var tableCells    = null;
        var headingsCount = null;

        /* Ensure sections exist before grabbing elements */
        if (tableHeader.length)
        {
            tableHeader   = tableHeader[0]
            tableHeadings = tableHeader.getElementsByTagName('th');
            headingsCount = tableHeadings.length;
        }

        if (tableBody.length)
            tableRows = tableBody[0].getElementsByTagName('tr');

        /* Working with an invalid sized table */
        if (!tableHeadings || !headingsCount || !tableRows)
            return;

        /* Check for first row that contains the matching number of cells */
        for (var j=0; j<tableRows.length; j++)
        {
            tableCells = tableRows[j].cells; //getElementsByTagName('td');
            if (tableCells.length == headingsCount)
                break; 
        }

        /* If there are no columns, or no columns with the correct # of cells, fall back to old method */
        if (!tableCells || tableCells.length != headingsCount) {
            containerDiv.style.height = 'auto';
            return;
        }

        /* Fix content and heading cells width so that the header matches the content when moved */
        for (var i=0; i<tableHeadings.length; i++)
        {
            tableHeadings[i].width = tableHeadings[i].offsetWidth;
            tableCells[i].width = tableCells[i].offsetWidth-4;
        }

        /* Adjust width of containers to allow for new sizes */
        headerTable.style.width     = contentTable.offsetWidth + 'px';
        contentTable.style.width    = contentTable.offsetWidth + 'px';
        containerDiv.style.overflow = 'auto';

        /* Re-size to screen width, factor in 20px for scroll bar */
        if ((contentTable.offsetWidth + 20) > document.body.clientWidth)
            containerDiv.style.width = (document.body.clientWidth - 20) + 'px';
        else
            containerDiv.style.width = contentTable.offsetWidth + 20 + 'px';

        /* Resize to screen height */
        if ((contentTable.offsetHeight) > document.body.clientHeight)
            containerDiv.style.height = (document.body.clientHeight - 40) + 'px';
        else
            containerDiv.style.height = (contentTable.offsetHeight + 10) + 'px';

        /* Make header Div match and set scrollable */
        if (headerDiv)
        {
            containerDiv.onscroll = function() { scrollTableHeader(headerID, containerID); };
            headerDiv.style.width = containerDiv.style.width;
            headerTable.style.position = 'relative';
            headerDiv.style.overflow = 'hidden';
        }

        /* Clone & move table header from content table to separate table */
        var clonedHeader = tableHeader.cloneNode(true);
        headerTable.appendChild(clonedHeader);
        headerTable.style.margin = '0';
        headerTable.style.padding = '0';
        contentTable.removeChild(tableHeader);
    }
}

// can use with "style.display, /^none$/" to determine if a object is visible (use 'style.visibility, hidden' as well)
function getParentProperty(obj, property, re) {
	var value;
	var objArray = new Array();
	
	while (obj && obj.style) {
		value = eval("obj." + property);

		if (re.test(value)) {
			objArray.push(obj);
		}
		obj = obj.parentNode;
	}
	return objArray;
}


function List(id, form, size) {
    this.id = id;
    this.list = new Array();
    this.max_size = size;
    this.form = form;
    this.fields = new Array();
    this.checkDuplicate = true;

    this.find = function (key) {
        for (var i = 0; i < this.list.length; i++) {
            if (key == this.list[i][0]) return i;
        }
        return -1;
    };

    this.addEntry = function (valueArray) {
        if (this.list.length >= this.max_size) throw new Error("err_max_size");
        if (this.checkDuplicate && this.find(valueArray[0]) >= 0) throw new Error("err_duplicate");

        var newArray = valueArray.toString().split(",");

        this.list.push(newArray);

        var tr = this.createListEntry(this.list.length - 1);
        document.getElementById(this.id).tBodies.item(0).appendChild(tr);
        return true;
    };

    this.editEntry = function (index, valueArray) {
        if ((index < 0) && (this.list.length >= this.max_size)) throw new Error("err_max_size");
        if (this.find(valueArray[0]) >= 0 && this.find(valueArray[0]) != index) throw new Error("err_duplicate");

        var newArray = valueArray.toString().split(",");

        if (index < 0) {
            this.list.push(newArray);
            var tr = this.createListEntry(this.list.length - 1);
            document.getElementById(this.id).tBodies.item(0).appendChild(tr);
        }
        else {
            this.list[index] = newArray;
            this.displayList();

        }
        return true;
    };

    this.deleteEntry = function (index) {
        this.list.splice(index, 1);
        this.displayList();
    };

    this.setToForm = function () {
        var currentField = eval("this.form." + this.id + "_" + this.fields[0]);
        var currentFieldLength = currentField.length ? currentField.length : 1;

        for (var i = 0; i < this.list.length; i++) {
            if (i < currentFieldLength) {
                for (var j = 0; j < this.fields.length; j++) {
                    currentField = eval("this.form." + this.id + "_" + this.fields[j])[i];
                    currentField.value = this.list[i][j];
                }
            }
            else {
                for (var j = 0; j < this.fields.length; j++) {
                    appendFormField(this.form, this.id + "_" + this.fields[j], this.list[i][j]);
                }
            }
        }
    };

    this.toForm = function () {
        for (var i = 0; i < this.list.length; i++) {
            for (var j = 0; j < this.fields.length; j++) {
                appendFormField(this.form, this.id + "_" + this.fields[j], this.list[i][j]);
            }
        }
    };

    this.displayList = function () {
        var tbl, tbody, tr, i;
        tbl = document.getElementById(this.id);
        tbody = tbl.tBodies.item(0);
        tbl.removeChild(tbody);
        tbody = document.createElement("TBODY");
        tbl.insertBefore(tbody, null);
        for (var i = 0; i < this.list.length; i++) {
            tr = this.createListEntry(i);
            tbody.insertBefore(tr, null);
        }
    }
}

List.prototype.createListEntry = function (index) {
        var tr, td, text, a, img, access_text;
        tr = document.createElement("TR");
        td = document.createElement("TD");
        text = document.createTextNode(index + 1);
        tr.insertBefore(td, null);
        td.insertBefore(text, null);
        for (var i = 0; i < this.list[index].length; i++) {
            td = document.createElement("TD");
            text = document.createTextNode(this.list[index][i]);
            tr.insertBefore(td, null);
            td.insertBefore(text, null);
        }
        td = document.createElement("TD");
        a = document.createElement("A");
        a.href = "javascript: deleteEntry(" + index + ");";
        img = document.createElement("IMG");
        img.setAttribute("src", "/images/delete.gif");
        tr.insertBefore(td, null);
        td.insertBefore(a, null);
        a.insertBefore(img, null);
        return tr;
    }


function setPaging(lineCurrent, lineTotal, linesPerPage, url, name, source, target) {
    var lineNew = 0;
    if (linesPerPage <= 0) linesPerPage = Math.pow(2,32) - 1;
    var pageTotal = Math.ceil(lineTotal/linesPerPage);
    var pageCurrent = Math.ceil(lineCurrent/linesPerPage);
    var obj;

	if (pageTotal <=0 ) pageTotal = 1;
    this.gotoUrl = function () {
        target.location.replace(this.getAttribute("url"));
    };

    this.gotoPage = function (event) {
        if (!event) event = window.event;

        // parent.action refer to the top frame in log access page
        if (!event) event = parent.action.window.event;		

        var key = event.which ? event.which : event.keyCode;

        if (key == 13) {
            var pageNum = parseInt(this.value);
            if (isNaN(pageNum) || pageNum < 1 || pageNum > pageTotal) {
                alert(this.getAttribute("err_page_current"));
            } else {
                lineNew = (pageNum - 1) * linesPerPage + 1;
                target.location.replace(setQueryValue(url, name, lineNew));
            }
            return false;
        }
    }

    if (!url) url = target.location.toString();

    // first
    obj = source.getElementById("page_first");
    if (obj) {
        if (pageCurrent <= 1) {
            obj.className = "list_button_disabled";
            obj.onclick = null;
        } else {
            lineNew = 1;
            obj.className = "list_button";
            obj.setAttribute("url", setQueryValue(url, name, lineNew));
            obj.onclick = this.gotoUrl;
        }
    }

    // previous
    obj = source.getElementById("page_prev");
    if (obj) {
        if (pageCurrent <= 1) {
            obj.className = "list_button_disabled";
            obj.onclick = null;
        } else {
            lineNew = ((pageCurrent - 2) * linesPerPage + 1);
            obj.className = "list_button";
            obj.setAttribute("url", setQueryValue(url, name, lineNew));
            obj.onclick = this.gotoUrl;
        }
    }

    // current
    obj = source.getElementById("page_current");
    if (obj) {
        obj.value = pageCurrent;
        obj.disabled = !(pageTotal > 1);
        obj.onkeypress = this.gotoPage;
    }

    // total
    obj = source.getElementById("page_total");
    if (obj) obj.innerHTML = pageTotal;

    // next
    obj = source.getElementById("page_next");
    if (obj) {
        if (pageCurrent >= pageTotal) {
            obj.className = "list_button_disabled";
            obj.onclick = null;
        } else {
            lineNew = (pageCurrent * linesPerPage + 1);
            obj.className = "list_button";
            obj.setAttribute("url", setQueryValue(url, name, lineNew));
            obj.onclick = this.gotoUrl;
        }
    }

    // last
    obj = source.getElementById("page_last");
    if (obj) {
        if (pageCurrent >= pageTotal) {
            obj.className = "list_button_disabled";
            obj.onclick = null;
        } else {
            lineNew = ((pageTotal - 1) * linesPerPage + 1);
            obj.className = "list_button";
            obj.setAttribute("url", setQueryValue(url, name, lineNew));
            obj.onclick = this.gotoUrl;
        }
    }
}

function setQueryValue(url, name, value) {
    var re = new RegExp("(&|\\?)(" + name + ")[^&]*"); 

    var newUrl = (value == null) ? url.replace(re, "$1") : url.replace(re, "$1$2=" + value);
    if (newUrl == url) newUrl = url + ((url.indexOf("?") < 0) ? "?" : "&") + name + "=" + value;

    return newUrl;
}

function setQueryValues(url, names, values) {
    var re;
    var newUrl;

    for (var i = 0; i < names.length; i++) {
        re = new RegExp("(&|\\?)(" + names[i] + ")[^&]*"); 

        newUrl = (values == null) ? url.replace(re, "$1") : url.replace(re, "$1$2=" + values[i]);
        if (newUrl == url) newUrl = url + ((url.indexOf("?") < 0) ? "?" : "&") + names[i] + "=" + values[i];

        url = newUrl;
    }
    return newUrl;
}

function removeQueryValue(url, name) {
    var re = new RegExp("(&|\\?)(" + name + ")[^&]*(&|$)");

    var newUrl = url.replace(re, "$1");

    return newUrl;
}

function resetFieldValue(el)
{
    if (el && el.style.color != '' )
    {
        el.value = '';
        el.style.color = '';
    }
}

function showFieldHelper(el)
{
    if (el && !el.value.length) {
        el.style.color = '#C0C0C0';
        el.value = el.title;
    }
}

function delete_all_selected(del_all_msg, separator, use_index, result_id, form_index, re)
{
    var count=0;
    var obj, objArray;
    var checked_lines = "";

    if (!result_id)  result_id = "checked_lines";
    if (!form_index) form_index = 0;
    if (!re)         re = /^line_checkbox/;

    objArray = getElementsByNameRegex(document, ['input'], re);

    for (i = objArray.length-1; i >= 0; i--) {
        obj = objArray[i];
        if (isChecked(obj) && isEnabled(obj)) {
            if (count != 0)
                checked_lines = checked_lines + separator;

            checked_lines = checked_lines + (use_index ? i : obj.value);
            count = count + 1;
        }
    }

    if (count != 0) {
        document.getElementById(result_id).value = checked_lines;
        if (!del_all_msg || (confirm(del_all_msg) == true))
            document.forms[form_index].submit();
    }
}

function handle_all_selected(handle_all_msg, separator, use_index, result_id, cmd, form_index, re)
{
    var count=0;
    var obj, objArray;
    var checked_lines = "";

    if (!result_id)  result_id = "checked_lines";
    if (!form_index) form_index = 0;
    if (!re)         re = /^line_checkbox/;
    if (!separator)  separator = ",";

    objArray = getElementsByNameRegex(document, ['input'], re);

    for (i = objArray.length-1; i >= 0; i--) {
        obj = objArray[i];
        if (isChecked(obj) && isEnabled(obj)) {
            if (count != 0)
                checked_lines = checked_lines + separator;

            checked_lines = checked_lines + (use_index ? i : obj.value);
            count = count + 1;
        }
    }

    if (count != 0) {
        var form = document.forms[form_index];
        var em = document.getElementById(result_id);
        if (em)
            em.value = checked_lines;
        else
            appendFormField(form, result_id, checked_lines);
		var cm = document.getElementById('command');
        if (cm)
            cm.value = cmd;
        else
            appendFormField(form, 'command', cmd);
        if (!handle_all_msg || (confirm(handle_all_msg) == true))
            form.submit();
    }
}

function getCheckedCount(re)
{
    var objArray;
    var count = 0;

    if (!re) re = /^line_checkbox/;

    objArray = getElementsByNameRegex(document, ['input'], re);

    for (var i=0; i<objArray.length; i++) {
        if (isChecked(objArray[i]) && isEnabled(objArray[i]))
            count++;
    }

    return count;
}

function check_all()
{
    var chk, checked_value;
    var obj, objArray;

    chk = document.getElementById('checkallbox');
    checked_value = isChecked(chk);

    objArray = document.getElementsByTagName("input");

    for (i = 0; i < objArray.length; i++) {
        obj = objArray[i];
        if (obj.type == "checkbox" && obj.name.indexOf("line_checkbox") >= 0 && isEnabled(obj)) {
            obj.checked = checked_value;
        }
    }
}

function line_checkbox_clicked()
{
    var chk, checked_value = true;
    var obj, objArray;

    objArray = document.getElementsByTagName("input");

    for (i = 0; i < objArray.length; i++) {
        obj = objArray[i];
        if (obj.type == "checkbox" && obj.name.indexOf("line_checkbox") >= 0) {
            if (isUnchecked(obj) && isEnabled(obj)) {
                checked_value = false;
                break;
            }
        }
    }

    chk = document.getElementById('checkallbox');
    chk.checked = checked_value;
}

function update_iframe_height(iframe_name, win_obj)
{
    var height = 0;
    var wnd = win_obj ? win_obj : window;

    var iframe = wnd.document.getElementById(iframe_name);

    if (iframe)
    {
        var doc = iframe.contentWindow || iframe.contentDocument;

        if (doc.document)
            doc = doc.document;

        if (doc && doc.body)
        {
            if (doc.body.scrollHeight)
                height = doc.body.scrollHeight;
            else if (doc.body.offsetHeight)
                height = doc.body.offsetHeight;
        }

        if (height > 0)
        {
            iframe.style.height = height + 'px';
        }
    }
}

function update_widget_frame(prefix, base_url, interval)
{
    var img = document.getElementById(prefix + '_img');
    var map = document.getElementById(prefix + '_map');
    var width = null;
  
    if (parent && parent.document)
    {
        var tbl = parent.document.getElementById(prefix);
        if (tbl && tbl.parentNode && tbl.parentNode.parentNode)
        {
            width = tbl.parentNode.parentNode.offsetWidth - 6;
        }
    }

    if (img)
    {
        var img_url = base_url + '?image';

        img_url += '&nocache=' + Math.random();

        if (width) img_url += '&width=' + width;

        img.onload = function() { update_iframe_height(prefix + '_iframe', window.parent); };
        img.src = img_url;
    }
  
    if (map)
    {
        var map_url = base_url + '?mapArea';

        map_url += '&nocache=' + Math.random();

        if (width) map_url += '&width=' + width;

        map.innerHTML = send_request(map_url, '');
    }

    if (interval > 0) setTimeout("update_widget_frame('" + prefix + "', '" + base_url + "', " + interval + ");", interval * 1000);
}

function adjustMultiSelect(id, minWidth, minHeight)
{
    var sb = document.getElementById(id);
    if (sb)
    {
        var outerDiv = sb.parentNode;
        var mainDiv = outerDiv.parentNode;

        s.size = sb.options.length >= 10 ? sb.options.length : 10;
        sb.style.width = '';
        sb.style.width = sb.offsetWidth < minWidth ? minWidth : sb.offsetWidth;
        sb.style.height = '';
        sb.style.height = sb.offsetHeight < minHeight ? minHeight : sb.offsetHeight;

        outerDiv.style.width = sb.offsetWidth - 18;
        outerDiv.style.overflow = 'hidden';

        mainDiv.style.width = minWidth;
        mainDiv.style.overflow = 'auto';
        mainDiv.style.height = minHeight;
    }	
}

function getCSSRule(css, selector) {
    var rules = css.rules ? css.rules : css.cssRules;

    if (rules == null) return null;

    for (var i = 0; i < rules.length; i++) {
        if (rules[0].selectorText == selector) {
            return rules[0];
        }
    }

    return null;
}

function setCSSRuleStyle(rule, property, value) {
	var evalStr = "rule.style." + property + "= '" + value + "'";

	eval(evalStr);
}

function setCSSStyle(css, selector, property, value) {
	var rule = getCSSRule(css, selector);

	if (rule != null) {
		setCSSRuleStyle(rule, property, value);
	}
}

//update URL of a second level menu
//I didn't put it in navbar.js because navbar.js will get run when page loaded.
function refresh_menu_url(id, url)
{
	var o = top.mainnav.document.getElementById(id);
	o.setAttribute('subnav_url', url); 
}

function doSort(sort_field_array, sort_cookie_name) {
    if (!sort_cookie_name) {
        sort_cookie_name = "sort_cookie";
    }

    setCookie(sort_cookie_name, sort_field_array.join(",")); 

    document.location.reload();
}

function getCheckedValue(radioObj) {
	if(!radioObj)
		return "";
	var radioLength = radioObj.length;
	if(radioLength == undefined)
		if(radioObj.checked)
			return radioObj.value;
		else
			return "";
	for(var i = 0; i < radioLength; i++) {
		if(radioObj[i].checked) {
			return radioObj[i].value;
		}
	}
	return "";
}


// nb_refresh_menu - Reload the menu tree (pulling in any updates). This function
// will retain the current menu selection unless "menu_id" is specified.
function nb_refresh_menu(menu_id)
{
	if(menu_id){menu_id=nb_find_vdom_menu_id(menu_id);}
	else{menu_id=get_menu_id_from_l3_node(last_clicked_l3_node);}
	var url=top.mainnav.location.href;
	url=update_url_component(url,"default_tab",menu_id);
	top.setTimeout(function(){
		if(!top.mainnav.navbar_menu_tree){top.mainnav.location.reload();}
	},3000);
	top.mainnav.location=url;
}
function nb_find_vdom_menu_id(menu_id) {
	function make_vdom_qualif(menu_id, vdom) {
		return vdom ? vdom + "::" + menu_id : menu_id;
	}

	function qualify_tab(menu_id) {
		if (top.mainnav.nb_runtime_state.global_view_menu && top.mainnav.nb_runtime_state.current_vdom) {
			return make_vdom_qualif(menu_id, top.mainnav.nb_runtime_state.current_vdom);
		}
		return menu_id;
	}
	var qf = parse_vdom(menu_id);
	if (qf.vdom == "__global__") {
		menu_id = qf.page;
	} else if (!qf.vdom) {
		menu_id = qualify_tab(menu_id);
	}
	return menu_id;
}
function parse_vdom(menu_id) {
	var ix = -1;
	if (0 <= (ix = menu_id.indexOf("::"))) {
		return {
			vdom: menu_id.substring(0, ix),
			id: menu_id.substring(ix + 2)
		};
	}
	return {
		vdom: '',
		id: menu_id
	};
}
function close_modal(){ 
	if (window.opener) {
		window.close(); 
	} else {			
		parent.window.wij_end_modal_dialog();
	}
}

function WSI_SelectAll(action, obj){
	var inputElememts = top.Sliderin._active[top.Sliderin._active.length-1]._$body.find('.slider-content input');
	var i = 0;
	if(action){
		if(inputElememts == undefined || inputElememts.length == 0) return;
		if(obj.checked){
			for(i=0; i<inputElememts.length; i++)
			{
				if(!inputElememts[i].disabled)
					inputElememts[i].checked = true;
			}
		}
		else{
			for(i=0; i<inputElememts.length; i++)
			{
				if(!inputElememts[i].disabled)
					inputElememts[i].checked = false;
			}
		}
	}
	else{
		var unchecked = false;
		for(i=1; i<inputElememts.length; i++)
		{
			if(!inputElememts[i].checked && !inputElememts[i].disabled)
			{
				unchecked = true;
			}
		}
		$j("#select_all")[0].checked = unchecked ? false : true;
	}
}

/**
 *	menu_id: refresh menu id
 *	html_id: html element highlight
 *
 **/
function html_element_highlight(menu_id, html_id) {
	if(!menu_id) return;
	var loc = window.location,
		origin = loc.origin || (loc.protocol + '//' + loc.host);
	var message = {
		messageType: 'refreshState',
		refreshMenuId: menu_id
	};
	top.mainnav.postMessage(message, origin);

	if(!html_id) return;
	
	var ele_id = "#" + html_id;
	$j(ele_id).addClass('highlight_element');
	setTimeout(function() {
		$j(ele_id).removeClass('highlight_element')
	}, 3000);

}

var newObj = null;
var addNewObj = null;
var findSelectIndex = null;

function createObj(name) {
	this.name = name;
}
function addCreateObj() {
	var com = document.getElementById(newObj.id);
	if(typeof(top.slider_opener) != 'undefined' && top.Sliderin._active.length > 1){
		com = top.Sliderin._active[top.Sliderin._active.length-2]._$content.find('#'+newObj.id)[0];
	}
	insertOption(com, new Option(newObj.name, newObj.ngid), findSelectIndex, true);
	if(newObj.id == "server_pool"){
		com.options[com.options.length-1].setAttribute('mkey', newObj.mkey);
		com.options[com.options.length-1].setAttribute('prot', newObj.prot ? newObj.prot : 0);
		if(newObj.prot == 3){
			$j("#server_pool_detail .ftnt-view").removeAttr('onclick').attr("onclick","javascript:showDetailSliderin('server_pool', '/prot/server_pool/tcp_dlg', 1000);");
		}
	}else{
		com.options[com.options.length-1].setAttribute('mkey', newObj.mkey);
	}
}

function openSlider(url, width) {
	var slider = null;
	var params = {
		url: url
	};
	if(width && width > 0) params.width = width;
	slider = new top.Sliderin(params);
	slider.open();
}
function checkCreateObj(field, url, width) {
	if(field.value.indexOf('__create_') === -1)
		return;

	// for http content routing create new tcp server pool
	if(field.value == "__create_tcp_pool") {
		url = "/prot/server_pool/tcp_dlg?redir=/addnew_success";
	}
	if (field.value == "__create_svc") {
		findSelectIndex = secondSeparatorCmp;
	} else if (field.value == "__create_https_svc") {
		findSelectIndex = secondSeparatorCmp;
	}
	field.selectedIndex = 0;
	newObj = new createObj();
	newObj.id = field.id;
	addNewObj = addCreateObj;

	var vdom = document.getElementsByName("vdom")[0];
	if(vdom){
		vdom_v = vdom.value;
		if(url.indexOf("?") !== -1)
			url += '&vdom=' + vdom_v;
		else
			url += '?vdom=' + vdom_v;
	}
	openSlider(url, width);
}
