
//preload directories: id/name, full path
//var preload_dirs = ["backup"];
//var preload_realdirs = ["/var/wad/backup.work"];

var currentIconMode = 1; //leaf mode
var lastClickedNode = null;
URL_GetTree = "/wad/file_explorer/gettree";
URL_FileList = "/wad/file_explorer/filelist";

	function buildTree() { 
		//create a new tree: 
		tree = new YAHOO.widget.TreeView("treeDiv1");

		//get root node for tree: 
		var root = tree.getRoot(); 


		//add child nodes for tree
		for (var i=0, j=preload_dirs.length; i<j; i++) { 
			var tempNode = new YAHOO.widget.TextNode(preload_dirs[i], root, false); 
				tempNode.setDynamicLoad(loadNodeData, currentIconMode); //turn dynamic loading on
				tempNode.onLabelClick = loadFileList; 
				if (0 == i) {
					tempNode.expand();
					lastClickedNode = tempNode;
				}

		} 

		//render tree with these toplevel nodes; all descendants of these nodes 
		//will be generated as needed by the dynamic loader. 
		tree.draw(); 
		setClass(lastClickedNode);
	} 

function setClass(node) {
	//set to highlight class
	var o = node.getLabelEl();
	o.className = "ygtvlabel_hl"; 
}

function unsetClass(node) {
	//set back to normal class
	var o = node.getLabelEl();
	o.className = "ygtvlabel"; 
}

function loadFileList(node) {
	var path;

	path = composeFullPath(node);
	if (path == '') return;
	var realpath = getRealPath(path);
	window.parent.frames.filelist.location = URL_FileList + "?path="+encodeURIComponent(realpath) + "&id=" + siteid; 

	if (lastClickedNode != null) unsetClass(lastClickedNode); 
	setClass(node);
	lastClickedNode = node;
}

function openDir(id){
	var pNode = lastClickedNode;
	var f = null;
	for(var i=0; i<pNode.children.length; i++) {
		var c = pNode.children[i];
		if (c.label.replace(Trl_cnt_set, '') == id) {
			f = c;
			break;
		}
	}
	if (f == null) return;

	f.onLabelClick(f);
	while(f){
		f.expand();
		f = f.parent;
		if(f.isRoot()) break;
	}
}

function openParentDir(){
	var pNode = lastClickedNode;
	var f = pNode.parent;
	
	if (f == null) return;
	if(f.isRoot()) return;
	f.onLabelClick(f);
	while(f){
		f.expand();
		f = f.parent;
		if(f.isRoot()) break;
	}
}

// Regex to remove trailing file counts: ie: "Archive (10)" -> "Archive".
var Trl_cnt_set = /\s\(\d+\)$/;

function composeFullPath(node) {
	var s ='';
	var n = node;

	if ((n == null) || (n.label == null)) return s;
	//if (n.parent.isRoot()) return "/"; 

	while(n) {
		// Trl_cnt_set is used to remove the directory size when
		// generating the request with the full path.
		s = '/' + n.label.replace(Trl_cnt_set, '') + s;
		n = n.parent;
		//if (n.parent.isRoot()) break;
		if (n.isRoot()) break;
	}
	return s;

}
function getRealPath(alias) {
	var s ='';
	var n = alias;

	if (n == null) return s;
	//if (n.parent.isRoot()) return "/"; 
	
	s = preload_realdirs[0] + n.substr(preload_dirs[0].length+1);
	//document.write(preload_dirs[0] +'  ::' + preload_dirs[0].length);
	//document.write(preload_realdirs[0]);
	return s;

}
function loadNodeData(node, fnLoadComplete)  { 

	function attachNodes(response) {
		var arr_dirs = [];
		var rootNode = response.responseXML.documentElement;
//alert(response.responseText);
		var dirs = rootNode.getElementsByTagName("dir");
		for(var i = 0; i<dirs.length; i++)
		{
			var l = dirs.item(i).firstChild.nodeValue;

			// Append directory size to label if it exists.
			var size = dirs.item(i).getAttribute("size");
			if (size)
			{
				l += " (" + size + ")";
			}

			var t = new YAHOO.widget.TextNode(l, node, false); 
			t.setDynamicLoad(loadNodeData, currentIconMode); 
			t.onLabelClick = loadFileList; 
		}
		node.dynamicLoadComplete = true;
		fnLoadComplete();
	}

	var path = composeFullPath(node);
	if (path == '') return;

	var realpath = getRealPath(path);

	var pars = "node=" + encodeURIComponent(realpath);
	pars += "&nocache=" + Math.random(); //prevent cached request

	var myAjax = new Ajax.Request(
			URL_GetTree, 
			{
				method: 'get', 
				parameters: pars, 
				onComplete: attachNodes 
			});
} 

