/* 'js/jquery.validate.js', */
/*!
 * jQuery Validation Plugin v1.12.0
 *
 * http://jqueryvalidation.org/
 *
 * Copyright (c) 2014 Jörn Zaefferer
 * Released under the MIT license
 */
(function($) {

$.extend($.fn, {
      // http://jqueryvalidation.org/validate/
      validate: function( options ) {

            // if nothing is selected, return nothing; can't chain anyway
            if ( !this.length ) {
                  if ( options && options.debug && window.console ) {
                        console.warn( "Nothing selected, can't validate, returning nothing." );
                  }
                  return;
            }

            // check if a validator for this form was already created
            var validator = $.data( this[0], "validator" );
            if ( validator ) {
                  return validator;
            }

            // Add novalidate tag if HTML5.
            this.attr( "novalidate", "novalidate" );

            validator = new $.validator( options, this[0] );
            $.data( this[0], "validator", validator );

            if ( validator.settings.onsubmit ) {

                  this.validateDelegate( ":submit", "click", function( event ) {
                        if ( validator.settings.submitHandler ) {
                              validator.submitButton = event.target;
                        }
                        // allow suppressing validation by adding a cancel class to the submit button
                        if ( $(event.target).hasClass("cancel") ) {
                              validator.cancelSubmit = true;
                        }

                        // allow suppressing validation by adding the html5 formnovalidate attribute to the submit button
                        if ( $(event.target).attr("formnovalidate") !== undefined ) {
                              validator.cancelSubmit = true;
                        }
                  });

                  // validate the form on submit
                  this.submit( function( event ) {
                        if ( validator.settings.debug ) {
                              // prevent form submit to be able to see console output
                              event.preventDefault();
                        }
                        function handle() {
                              var hidden;
                              if ( validator.settings.submitHandler ) {
                                    if ( validator.submitButton ) {
                                          // insert a hidden input as a replacement for the missing submit button
                                          hidden = $("<input type='hidden'/>").attr("name", validator.submitButton.name).val( $(validator.submitButton).val() ).appendTo(validator.currentForm);
                                    }
                                    validator.settings.submitHandler.call( validator, validator.currentForm, event );
                                    if ( validator.submitButton ) {
                                          // and clean up afterwards; thanks to no-block-scope, hidden can be referenced
                                          hidden.remove();
                                    }
                                    return false;
                              }
                              return true;
                        }

                        // prevent submit for invalid forms or custom submit handlers
                        if ( validator.cancelSubmit ) {
                              validator.cancelSubmit = false;
                              return handle();
                        }
                        if ( validator.form() ) {
                              if ( validator.pendingRequest ) {
                                    validator.formSubmitted = true;
                                    return false;
                              }
                              return handle();
                        } else {
                              validator.focusInvalid();
                              return false;
                        }
                  });
            }

            return validator;
      },
      // http://jqueryvalidation.org/valid/
      valid: function() {
            var valid, validator;

            if ( $(this[0]).is("form")) {
                  valid = this.validate().form();
            } else {
                  valid = true;
                  validator = $(this[0].form).validate();
                  this.each(function() {
                        valid = validator.element(this) && valid;
                  });
            }
            return valid;
      },
      // attributes: space separated list of attributes to retrieve and remove
      removeAttrs: function( attributes ) {
            var result = {},
                  $element = this;
            $.each(attributes.split(/\s/), function( index, value ) {
                  result[value] = $element.attr(value);
                  $element.removeAttr(value);
            });
            return result;
      },
      // http://jqueryvalidation.org/rules/
      rules: function( command, argument ) {
            var element = this[0],
                  settings, staticRules, existingRules, data, param, filtered;

            if ( command ) {
                  settings = $.data(element.form, "validator").settings;
                  staticRules = settings.rules;
                  existingRules = $.validator.staticRules(element);
                  switch (command) {
                  case "add":
                        $.extend(existingRules, $.validator.normalizeRule(argument));
                        // remove messages from rules, but allow them to be set separately
                        delete existingRules.messages;
                        staticRules[element.name] = existingRules;
                        if ( argument.messages ) {
                              settings.messages[element.name] = $.extend( settings.messages[element.name], argument.messages );
                        }
                        break;
                  case "remove":
                        if ( !argument ) {
                              delete staticRules[element.name];
                              return existingRules;
                        }
                        filtered = {};
                        $.each(argument.split(/\s/), function( index, method ) {
                              filtered[method] = existingRules[method];
                              delete existingRules[method];
                              if ( method === "required" ) {
                                    $(element).removeAttr("aria-required");
                              }
                        });
                        return filtered;
                  }
            }

            data = $.validator.normalizeRules(
            $.extend(
                  {},
                  $.validator.classRules(element),
                  $.validator.attributeRules(element),
                  $.validator.dataRules(element),
                  $.validator.staticRules(element)
            ), element);

            // make sure required is at front
            if ( data.required ) {
                  param = data.required;
                  delete data.required;
                  data = $.extend({ required: param }, data );
                  $(element).attr( "aria-required", "true" );
            }

            // make sure remote is at back
            if ( data.remote ) {
                  param = data.remote;
                  delete data.remote;
                  data = $.extend( data, { remote: param });
            }

            return data;
      }
});

// Custom selectors
$.extend($.expr[":"], {
      // http://jqueryvalidation.org/blank-selector/
      blank: function( a ) { return !$.trim("" + $(a).val()); },
      // http://jqueryvalidation.org/filled-selector/
      filled: function( a ) { return !!$.trim("" + $(a).val()); },
      // http://jqueryvalidation.org/unchecked-selector/
      unchecked: function( a ) { return !$(a).prop("checked"); }
});

// constructor for validator
$.validator = function( options, form ) {
      this.settings = $.extend( true, {}, $.validator.defaults, options );
      this.currentForm = form;
      this.init();
};

// http://jqueryvalidation.org/jQuery.validator.format/
$.validator.format = function( source, params ) {
      if ( arguments.length === 1 ) {
            return function() {
                  var args = $.makeArray(arguments);
                  args.unshift(source);
                  return $.validator.format.apply( this, args );
            };
      }
      if ( arguments.length > 2 && params.constructor !== Array  ) {
            params = $.makeArray(arguments).slice(1);
      }
      if ( params.constructor !== Array ) {
            params = [ params ];
      }
      $.each(params, function( i, n ) {
            source = source.replace( new RegExp("\\{" + i + "\\}", "g"), function() {
                  return n;
            });
      });
      return source;
};

$.extend($.validator, {

      defaults: {
            messages: {},
            groups: {},
            rules: {},
            errorClass: "error",
            validClass: "valid",
            errorElement: "label",
            focusInvalid: true,
            errorContainer: $([]),
            errorLabelContainer: $([]),
            onsubmit: true,
            ignore: ":hidden",
            ignoreTitle: false,
            onfocusin: function( element ) {
                  this.lastActive = element;

                  // hide error label and remove error class on focus if enabled
                  if ( this.settings.focusCleanup && !this.blockFocusCleanup ) {
                        if ( this.settings.unhighlight ) {
                              this.settings.unhighlight.call( this, element, this.settings.errorClass, this.settings.validClass );
                        }
                        this.addWrapper(this.errorsFor(element)).hide();
                  }
            },
            onfocusout: function( element ) {
                  if ( !this.checkable(element) && (element.name in this.submitted || !this.optional(element)) ) {
                        this.element(element);
                  }
            },
            onkeyup: function( element, event ) {
                  if ( event.which === 9 && this.elementValue(element) === "" ) {
                        return;
                  } else if ( element.name in this.submitted || element === this.lastElement ) {
                        this.element(element);
                  }
            },
            onclick: function( element ) {
                  // click on selects, radiobuttons and checkboxes
                  if ( element.name in this.submitted ) {
                        this.element(element);

                  // or option elements, check parent select in that case
                  } else if ( element.parentNode.name in this.submitted ) {
                        this.element(element.parentNode);
                  }
            },
            highlight: function( element, errorClass, validClass ) {
                  if ( element.type === "radio" ) {
                        this.findByName(element.name).addClass(errorClass).removeClass(validClass);
                  } else {
                        $(element).addClass(errorClass).removeClass(validClass);
                  }
            },
            unhighlight: function( element, errorClass, validClass ) {
                  if ( element.type === "radio" ) {
                        this.findByName(element.name).removeClass(errorClass).addClass(validClass);
                  } else {
                        $(element).removeClass(errorClass).addClass(validClass);
                  }
            }
      },

      // http://jqueryvalidation.org/jQuery.validator.setDefaults/
      setDefaults: function( settings ) {
            $.extend( $.validator.defaults, settings );
      },

      messages: {
            required: "This field is required.",
            remote: "Please fix this field.",
            email: "Please enter a valid email address.",
            url: "Please enter a valid URL.",
            date: "Please enter a valid date.",
            dateISO: "Please enter a valid date (ISO).",
            number: "Please enter a valid number.",
            digits: "Please enter only digits.",
            creditcard: "Please enter a valid credit card number.",
            equalTo: "Please enter the same value again.",
            maxlength: $.validator.format("Please enter no more than {0} characters."),
            minlength: $.validator.format("Please enter at least {0} characters."),
            rangelength: $.validator.format("Please enter a value between {0} and {1} characters long."),
            range: $.validator.format("Please enter a value between {0} and {1}."),
            max: $.validator.format("Please enter a value less than or equal to {0}."),
            min: $.validator.format("Please enter a value greater than or equal to {0}.")
      },

      autoCreateRanges: false,

      prototype: {

            init: function() {
                  this.labelContainer = $(this.settings.errorLabelContainer);
                  this.errorContext = this.labelContainer.length && this.labelContainer || $(this.currentForm);
                  this.containers = $(this.settings.errorContainer).add( this.settings.errorLabelContainer );
                  this.submitted = {};
                  this.valueCache = {};
                  this.pendingRequest = 0;
                  this.pending = {};
                  this.invalid = {};
                  this.reset();

                  var groups = (this.groups = {}),
                        rules;
                  $.each(this.settings.groups, function( key, value ) {
                        if ( typeof value === "string" ) {
                              value = value.split(/\s/);
                        }
                        $.each(value, function( index, name ) {
                              groups[name] = key;
                        });
                  });
                  rules = this.settings.rules;
                  $.each(rules, function( key, value ) {
                        rules[key] = $.validator.normalizeRule(value);
                  });

                  function delegate(event) {
                        var validator = $.data(this[0].form, "validator"),
                              eventType = "on" + event.type.replace(/^validate/, ""),
                              settings = validator.settings;
                        if ( settings[eventType] && !this.is( settings.ignore ) ) {
                              settings[eventType].call(validator, this[0], event);
                        }
                  }
                  $(this.currentForm)
                        .validateDelegate(":text, [type='password'], [type='file'], select, textarea, " +
                              "[type='number'], [type='search'] ,[type='tel'], [type='url'], " +
                              "[type='email'], [type='datetime'], [type='date'], [type='month'], " +
                              "[type='week'], [type='time'], [type='datetime-local'], " +
                              "[type='range'], [type='color'] ",
                              "focusin focusout keyup", delegate)
                        .validateDelegate("[type='radio'], [type='checkbox'], select, option", "click", delegate);

                  if ( this.settings.invalidHandler ) {
                        $(this.currentForm).bind("invalid-form.validate", this.settings.invalidHandler);
                  }

                  // Add aria-required to any Static/Data/Class required fields before first validation
                  // Screen readers require this attribute to be present before the initial submission http://www.w3.org/TR/WCAG-TECHS/ARIA2.html
                  $(this.currentForm).find("[required], [data-rule-required], .required").attr("aria-required", "true");
            },

            // http://jqueryvalidation.org/Validator.form/
            form: function() {
                  this.checkForm();
                  $.extend(this.submitted, this.errorMap);
                  this.invalid = $.extend({}, this.errorMap);
                  if ( !this.valid() ) {
                        $(this.currentForm).triggerHandler("invalid-form", [ this ]);
                  }
                  this.showErrors();
                  return this.valid();
            },

            checkForm: function() {
                  this.prepareForm();
                  for ( var i = 0, elements = (this.currentElements = this.elements()); elements[i]; i++ ) {
                        this.check( elements[i] );
                  }
                  return this.valid();
            },

            // http://jqueryvalidation.org/Validator.element/
            element: function( element ) {
                  var cleanElement = this.clean( element ),
                        checkElement = this.validationTargetFor( cleanElement ),
                        result = true;

                  this.lastElement = checkElement;

                  if ( checkElement === undefined ) {
                        delete this.invalid[ cleanElement.name ];
                  } else {
                        this.prepareElement( checkElement );
                        this.currentElements = $( checkElement );

                        result = this.check( checkElement ) !== false;
                        if (result) {
                              delete this.invalid[checkElement.name];
                        } else {
                              this.invalid[checkElement.name] = true;
                        }
                  }
                  // Add aria-invalid status for screen readers
                  $( element ).attr( "aria-invalid", !result );

                  if ( !this.numberOfInvalids() ) {
                        // Hide error containers on last error
                        this.toHide = this.toHide.add( this.containers );
                  }
                  this.showErrors();
                  return result;
            },

            // http://jqueryvalidation.org/Validator.showErrors/
            showErrors: function( errors ) {
                  if ( errors ) {
                        // add items to error list and map
                        $.extend( this.errorMap, errors );
                        this.errorList = [];
                        for ( var name in errors ) {
                              this.errorList.push({
                                    message: errors[name],
                                    element: this.findByName(name)[0]
                              });
                        }
                        // remove items from success list
                        this.successList = $.grep( this.successList, function( element ) {
                              return !(element.name in errors);
                        });
                  }
                  if ( this.settings.showErrors ) {
                        this.settings.showErrors.call( this, this.errorMap, this.errorList );
                  } else {
                        this.defaultShowErrors();
                  }
            },

            // http://jqueryvalidation.org/Validator.resetForm/
            resetForm: function() {
                  if ( $.fn.resetForm ) {
                        $(this.currentForm).resetForm();
                  }
                  this.submitted = {};
                  this.lastElement = null;
                  this.prepareForm();
                  this.hideErrors();
                  this.elements()
                              .removeClass( this.settings.errorClass )
                              .removeData( "previousValue" )
                              .removeAttr( "aria-invalid" );
            },

            numberOfInvalids: function() {
                  return this.objectLength(this.invalid);
            },

            objectLength: function( obj ) {
                  /* jshint unused: false */
                  var count = 0,
                        i;
                  for ( i in obj ) {
                        count++;
                  }
                  return count;
            },

            hideErrors: function() {
                  this.addWrapper( this.toHide ).hide();
            },

            valid: function() {
                  return this.size() === 0;
            },

            size: function() {
                  return this.errorList.length;
            },

            focusInvalid: function() {
                  if ( this.settings.focusInvalid ) {
                        try {
                              $(this.findLastActive() || this.errorList.length && this.errorList[0].element || [])
                              .filter(":visible")
                              .focus()
                              // manually trigger focusin event; without it, focusin handler isn't called, findLastActive won't have anything to find
                              .trigger("focusin");
                        } catch(e) {
                              // ignore IE throwing errors when focusing hidden elements
                        }
                  }
            },

            findLastActive: function() {
                  var lastActive = this.lastActive;
                  return lastActive && $.grep(this.errorList, function( n ) {
                        return n.element.name === lastActive.name;
                  }).length === 1 && lastActive;
            },

            elements: function() {
                  var validator = this,
                        rulesCache = {};

                  // select all valid inputs inside the form (no submit or reset buttons)
                  return $(this.currentForm)
                  .find("input, select, textarea")
                  .not(":submit, :reset, :image, [disabled]")
                  .not( this.settings.ignore )
                  .filter(function() {
                        if ( !this.name && validator.settings.debug && window.console ) {
                              console.error( "%o has no name assigned", this);
                        }

                        // select only the first element for each name, and only those with rules specified
                        if ( this.name in rulesCache || !validator.objectLength($(this).rules()) ) {
                              return false;
                        }

                        rulesCache[this.name] = true;
                        return true;
                  });
            },

            clean: function( selector ) {
                  return $(selector)[0];
            },

            errors: function() {
                  var errorClass = this.settings.errorClass.split(" ").join(".");
                  return $(this.settings.errorElement + "." + errorClass, this.errorContext);
            },

            reset: function() {
                  this.successList = [];
                  this.errorList = [];
                  this.errorMap = {};
                  this.toShow = $([]);
                  this.toHide = $([]);
                  this.currentElements = $([]);
            },

            prepareForm: function() {
                  this.reset();
                  this.toHide = this.errors().add( this.containers );
            },

            prepareElement: function( element ) {
                  this.reset();
                  this.toHide = this.errorsFor(element);
            },

            elementValue: function( element ) {
                  var val,
                        $element = $(element),
                        type = $element.attr("type");

                  if ( type === "radio" || type === "checkbox" ) {
                        return $("input[name='" + $element.attr("name") + "']:checked").val();
                  }

                  val = $element.val();
                  if ( typeof val === "string" ) {
                        return val.replace(/\r/g, "");
                  }
                  return val;
            },

            check: function( element ) {
                  element = this.validationTargetFor( this.clean( element ) );

                  var rules = $(element).rules(),
                        rulesCount = $.map( rules, function(n, i) {
                              return i;
                        }).length,
                        dependencyMismatch = false,
                        val = this.elementValue(element),
                        result, method, rule;

                  for (method in rules ) {
                        rule = { method: method, parameters: rules[method] };
                        try {

                              result = $.validator.methods[method].call( this, val, element, rule.parameters );

                              // if a method indicates that the field is optional and therefore valid,
                              // don't mark it as valid when there are no other rules
                              if ( result === "dependency-mismatch" && rulesCount === 1 ) {
                                    dependencyMismatch = true;
                                    continue;
                              }
                              dependencyMismatch = false;

                              if ( result === "pending" ) {
                                    this.toHide = this.toHide.not( this.errorsFor(element) );
                                    return;
                              }

                              if ( !result ) {
                                    this.formatAndAdd( element, rule );
                                    return false;
                              }
                        } catch(e) {
                              if ( this.settings.debug && window.console ) {
                                    console.log( "Exception occurred when checking element " + element.id + ", check the '" + rule.method + "' method.", e );
                              }
                              throw e;
                        }
                  }
                  if ( dependencyMismatch ) {
                        return;
                  }
                  if ( this.objectLength(rules) ) {
                        this.successList.push(element);
                  }
                  return true;
            },

            // return the custom message for the given element and validation method
            // specified in the element's HTML5 data attribute
            // return the generic message if present and no method specific message is present
            customDataMessage: function( element, method ) {
                  return $( element ).data( "msg" + method[ 0 ].toUpperCase() +
                        method.substring( 1 ).toLowerCase() ) || $( element ).data("msg");
            },

            // return the custom message for the given element name and validation method
            customMessage: function( name, method ) {
                  var m = this.settings.messages[name];
                  return m && (m.constructor === String ? m : m[method]);
            },

            // return the first defined argument, allowing empty strings
            findDefined: function() {
                  for (var i = 0; i < arguments.length; i++) {
                        if ( arguments[i] !== undefined ) {
                              return arguments[i];
                        }
                  }
                  return undefined;
            },

            defaultMessage: function( element, method ) {
                  return this.findDefined(
                        this.customMessage( element.name, method ),
                        this.customDataMessage( element, method ),
                        // title is never undefined, so handle empty string as undefined
                        !this.settings.ignoreTitle && element.title || undefined,
                        $.validator.messages[method],
                        "<strong>Warning: No message defined for " + element.name + "</strong>"
                  );
            },

            formatAndAdd: function( element, rule ) {
                  var message = this.defaultMessage( element, rule.method ),
                        theregex = /\$?\{(\d+)\}/g;
                  if ( typeof message === "function" ) {
                        message = message.call(this, rule.parameters, element);
                  } else if (theregex.test(message)) {
                        message = $.validator.format(message.replace(theregex, "{$1}"), rule.parameters);
                  }
                  this.errorList.push({
                        message: message,
                        element: element,
                        method: rule.method
                  });

                  this.errorMap[element.name] = message;
                  this.submitted[element.name] = message;
            },

            addWrapper: function( toToggle ) {
                  if ( this.settings.wrapper ) {
                        toToggle = toToggle.add( toToggle.parent( this.settings.wrapper ) );
                  }
                  return toToggle;
            },

            defaultShowErrors: function() {
                  var i, elements, error;
                  for ( i = 0; this.errorList[i]; i++ ) {
                        error = this.errorList[i];
                        if ( this.settings.highlight ) {
                              this.settings.highlight.call( this, error.element, this.settings.errorClass, this.settings.validClass );
                        }
                        this.showLabel( error.element, error.message );
                  }
                  if ( this.errorList.length ) {
                        this.toShow = this.toShow.add( this.containers );
                  }
                  if ( this.settings.success ) {
                        for ( i = 0; this.successList[i]; i++ ) {
                              this.showLabel( this.successList[i] );
                        }
                  }
                  if ( this.settings.unhighlight ) {
                        for ( i = 0, elements = this.validElements(); elements[i]; i++ ) {
                              this.settings.unhighlight.call( this, elements[i], this.settings.errorClass, this.settings.validClass );
                        }
                  }
                  this.toHide = this.toHide.not( this.toShow );
                  this.hideErrors();
                  this.addWrapper( this.toShow ).show();
            },

            validElements: function() {
                  return this.currentElements.not(this.invalidElements());
            },

            invalidElements: function() {
                  return $(this.errorList).map(function() {
                        return this.element;
                  });
            },

            showLabel: function( element, message ) {
                  var label = this.errorsFor( element );
                  if ( label.length ) {
                        // refresh error/success class
                        label.removeClass( this.settings.validClass ).addClass( this.settings.errorClass );
                        // replace message on existing label
                        label.html(message);
                  } else {
                        // create label
                        label = $("<" + this.settings.errorElement + ">")
                              .attr("for", this.idOrName(element))
                              .addClass(this.settings.errorClass)
                              .html(message || "");
                        if ( this.settings.wrapper ) {
                              // make sure the element is visible, even in IE
                              // actually showing the wrapped element is handled elsewhere
                              label = label.hide().show().wrap("<" + this.settings.wrapper + "/>").parent();
                        }
                        if ( !this.labelContainer.append(label).length ) {
                              if ( this.settings.errorPlacement ) {
                                    this.settings.errorPlacement(label, $(element) );
                              } else {
                                    label.insertAfter(element);
                              }
                        }
                  }
                  if ( !message && this.settings.success ) {
                        label.text("");
                        if ( typeof this.settings.success === "string" ) {
                              label.addClass( this.settings.success );
                        } else {
                              this.settings.success( label, element );
                        }
                  }
                  this.toShow = this.toShow.add(label);
            },

            errorsFor: function( element ) {
                  var name = this.idOrName(element);
                  return this.errors().filter(function() {
                        return $(this).attr("for") === name;
                  });
            },

            idOrName: function( element ) {
                  return this.groups[element.name] || (this.checkable(element) ? element.name : element.id || element.name);
            },

            validationTargetFor: function( element ) {
                  // if radio/checkbox, validate first element in group instead
                  if ( this.checkable(element) ) {
                        element = this.findByName( element.name ).not(this.settings.ignore)[0];
                  }
                  return element;
            },

            checkable: function( element ) {
                  return (/radio|checkbox/i).test(element.type);
            },

            findByName: function( name ) {
                  return $(this.currentForm).find("[name='" + name + "']");
            },

            getLength: function( value, element ) {
                  switch ( element.nodeName.toLowerCase() ) {
                  case "select":
                        return $("option:selected", element).length;
                  case "input":
                        if ( this.checkable( element) ) {
                              return this.findByName(element.name).filter(":checked").length;
                        }
                  }
                  return value.length;
            },

            depend: function( param, element ) {
                  return this.dependTypes[typeof param] ? this.dependTypes[typeof param](param, element) : true;
            },

            dependTypes: {
                  "boolean": function( param ) {
                        return param;
                  },
                  "string": function( param, element ) {
                        return !!$(param, element.form).length;
                  },
                  "function": function( param, element ) {
                        return param(element);
                  }
            },

            optional: function( element ) {
                  var val = this.elementValue(element);
                  return !$.validator.methods.required.call(this, val, element) && "dependency-mismatch";
            },

            startRequest: function( element ) {
                  if ( !this.pending[element.name] ) {
                        this.pendingRequest++;
                        this.pending[element.name] = true;
                  }
            },

            stopRequest: function( element, valid ) {
                  this.pendingRequest--;
                  // sometimes synchronization fails, make sure pendingRequest is never < 0
                  if ( this.pendingRequest < 0 ) {
                        this.pendingRequest = 0;
                  }
                  delete this.pending[element.name];
                  if ( valid && this.pendingRequest === 0 && this.formSubmitted && this.form() ) {
                        $(this.currentForm).submit();
                        this.formSubmitted = false;
                  } else if (!valid && this.pendingRequest === 0 && this.formSubmitted) {
                        $(this.currentForm).triggerHandler("invalid-form", [ this ]);
                        this.formSubmitted = false;
                  }
            },

            previousValue: function( element ) {
                  return $.data(element, "previousValue") || $.data(element, "previousValue", {
                        old: null,
                        valid: true,
                        message: this.defaultMessage( element, "remote" )
                  });
            }

      },

      classRuleSettings: {
            required: { required: true },
            email: { email: true },
            url: { url: true },
            date: { date: true },
            dateISO: { dateISO: true },
            number: { number: true },
            digits: { digits: true },
            creditcard: { creditcard: true }
      },

      addClassRules: function( className, rules ) {
            if ( className.constructor === String ) {
                  this.classRuleSettings[className] = rules;
            } else {
                  $.extend(this.classRuleSettings, className);
            }
      },

      classRules: function( element ) {
            var rules = {},
                  classes = $(element).attr("class");

            if ( classes ) {
                  $.each(classes.split(" "), function() {
                        if ( this in $.validator.classRuleSettings ) {
                              $.extend(rules, $.validator.classRuleSettings[this]);
                        }
                  });
            }
            return rules;
      },

      attributeRules: function( element ) {
            var rules = {},
                  $element = $(element),
                  type = element.getAttribute("type"),
                  method, value;

            for (method in $.validator.methods) {

                  // support for <input required> in both html5 and older browsers
                  if ( method === "required" ) {
                        value = element.getAttribute(method);
                        // Some browsers return an empty string for the required attribute
                        // and non-HTML5 browsers might have required="" markup
                        if ( value === "" ) {
                              value = true;
                        }
                        // force non-HTML5 browsers to return bool
                        value = !!value;
                  } else {
                        value = $element.attr(method);
                  }

                  // convert the value to a number for number inputs, and for text for backwards compability
                  // allows type="date" and others to be compared as strings
                  if ( /min|max/.test( method ) && ( type === null || /number|range|text/.test( type ) ) ) {
                        value = Number(value);
                  }

                  if ( value || value === 0 ) {
                        rules[method] = value;
                  } else if ( type === method && type !== "range" ) {
                        // exception: the jquery validate 'range' method
                        // does not test for the html5 'range' type
                        rules[method] = true;
                  }
            }

            // maxlength may be returned as -1, 2147483647 (IE) and 524288 (safari) for text inputs
            if ( rules.maxlength && /-1|2147483647|524288/.test(rules.maxlength) ) {
                  delete rules.maxlength;
            }

            return rules;
      },

      dataRules: function( element ) {
            var method, value,
                  rules = {}, $element = $( element );
            for ( method in $.validator.methods ) {
                  value = $element.data( "rule" + method[ 0 ].toUpperCase() + method.substring( 1 ).toLowerCase() );
                  if ( value !== undefined ) {
                        rules[ method ] = value;
                  }
            }
            return rules;
      },

      staticRules: function( element ) {
            var rules = {},
                  validator = $.data(element.form, "validator");

            if ( validator.settings.rules ) {
                  rules = $.validator.normalizeRule(validator.settings.rules[element.name]) || {};
            }
            return rules;
      },

      normalizeRules: function( rules, element ) {
            // handle dependency check
            $.each(rules, function( prop, val ) {
                  // ignore rule when param is explicitly false, eg. required:false
                  if ( val === false ) {
                        delete rules[prop];
                        return;
                  }
                  if ( val.param || val.depends ) {
                        var keepRule = true;
                        switch (typeof val.depends) {
                        case "string":
                              keepRule = !!$(val.depends, element.form).length;
                              break;
                        case "function":
                              keepRule = val.depends.call(element, element);
                              break;
                        }
                        if ( keepRule ) {
                              rules[prop] = val.param !== undefined ? val.param : true;
                        } else {
                              delete rules[prop];
                        }
                  }
            });

            // evaluate parameters
            $.each(rules, function( rule, parameter ) {
                  rules[rule] = $.isFunction(parameter) ? parameter(element) : parameter;
            });

            // clean number parameters
            $.each([ "minlength", "maxlength" ], function() {
                  if ( rules[this] ) {
                        rules[this] = Number(rules[this]);
                  }
            });
            $.each([ "rangelength", "range" ], function() {
                  var parts;
                  if ( rules[this] ) {
                        if ( $.isArray(rules[this]) ) {
                              rules[this] = [ Number(rules[this][0]), Number(rules[this][1]) ];
                        } else if ( typeof rules[this] === "string" ) {
                              parts = rules[this].split(/[\s,]+/);
                              rules[this] = [ Number(parts[0]), Number(parts[1]) ];
                        }
                  }
            });

            if ( $.validator.autoCreateRanges ) {
                  // auto-create ranges
                  if ( rules.min && rules.max ) {
                        rules.range = [ rules.min, rules.max ];
                        delete rules.min;
                        delete rules.max;
                  }
                  if ( rules.minlength && rules.maxlength ) {
                        rules.rangelength = [ rules.minlength, rules.maxlength ];
                        delete rules.minlength;
                        delete rules.maxlength;
                  }
            }

            return rules;
      },

      // Converts a simple string to a {string: true} rule, e.g., "required" to {required:true}
      normalizeRule: function( data ) {
            if ( typeof data === "string" ) {
                  var transformed = {};
                  $.each(data.split(/\s/), function() {
                        transformed[this] = true;
                  });
                  data = transformed;
            }
            return data;
      },

      // http://jqueryvalidation.org/jQuery.validator.addMethod/
      addMethod: function( name, method, message ) {
            $.validator.methods[name] = method;
            $.validator.messages[name] = message !== undefined ? message : $.validator.messages[name];
            if ( method.length < 3 ) {
                  $.validator.addClassRules(name, $.validator.normalizeRule(name));
            }
      },

      methods: {

            // http://jqueryvalidation.org/required-method/
            required: function( value, element, param ) {
                  // check if dependency is met
                  if ( !this.depend(param, element) ) {
                        return "dependency-mismatch";
                  }
                  if ( element.nodeName.toLowerCase() === "select" ) {
                        // could be an array for select-multiple or a string, both are fine this way
                        var val = $(element).val();
                        return val && val.length > 0;
                  }
                  if ( this.checkable(element) ) {
                        return this.getLength(value, element) > 0;
                  }
                  return $.trim(value).length > 0;
            },

            // http://jqueryvalidation.org/email-method/
            email: function( value, element ) {
                  // From http://www.whatwg.org/specs/web-apps/current-work/multipage/states-of-the-type-attribute.html#e-mail-state-%28type=email%29
                  // Retrieved 2014-01-14
                  // If you have a problem with this implementation, report a bug against the above spec
                  // Or use custom methods to implement your own email validation
                  return this.optional(element) || /^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/.test(value);
            },

            // http://jqueryvalidation.org/url-method/
            url: function( value, element ) {
                  // contributed by Scott Gonzalez: http://projects.scottsplayground.com/iri/
                  return this.optional(element) || /^(https?|s?ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(value);
            },

            // http://jqueryvalidation.org/date-method/
            date: function( value, element ) {
                  return this.optional(element) || !/Invalid|NaN/.test(new Date(value).toString());
            },

            // http://jqueryvalidation.org/dateISO-method/
            dateISO: function( value, element ) {
                  return this.optional(element) || /^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/.test(value);
            },

            // http://jqueryvalidation.org/number-method/
            number: function( value, element ) {
                  return this.optional(element) || /^-?(?:\d+|\d{1,3}(?:,\d{3})+)?(?:\.\d+)?$/.test(value);
            },

            // http://jqueryvalidation.org/digits-method/
            digits: function( value, element ) {
                  return this.optional(element) || /^\d+$/.test(value);
            },

            // http://jqueryvalidation.org/creditcard-method/
            // based on http://en.wikipedia.org/wiki/Luhn/
            creditcard: function( value, element ) {
                  if ( this.optional(element) ) {
                        return "dependency-mismatch";
                  }
                  // accept only spaces, digits and dashes
                  if ( /[^0-9 \-]+/.test(value) ) {
                        return false;
                  }
                  var nCheck = 0,
                        nDigit = 0,
                        bEven = false,
                        n, cDigit;

                  value = value.replace(/\D/g, "");

                  // Basing min and max length on
                  // http://developer.ean.com/general_info/Valid_Credit_Card_Types
                  if ( value.length < 13 || value.length > 19 ) {
                        return false;
                  }

                  for ( n = value.length - 1; n >= 0; n--) {
                        cDigit = value.charAt(n);
                        nDigit = parseInt(cDigit, 10);
                        if ( bEven ) {
                              if ( (nDigit *= 2) > 9 ) {
                                    nDigit -= 9;
                              }
                        }
                        nCheck += nDigit;
                        bEven = !bEven;
                  }

                  return (nCheck % 10) === 0;
            },

            // http://jqueryvalidation.org/minlength-method/
            minlength: function( value, element, param ) {
                  var length = $.isArray( value ) ? value.length : this.getLength($.trim(value), element);
                  return this.optional(element) || length >= param;
            },

            // http://jqueryvalidation.org/maxlength-method/
            maxlength: function( value, element, param ) {
                  var length = $.isArray( value ) ? value.length : this.getLength($.trim(value), element);
                  return this.optional(element) || length <= param;
            },

            // http://jqueryvalidation.org/rangelength-method/
            rangelength: function( value, element, param ) {
                  var length = $.isArray( value ) ? value.length : this.getLength($.trim(value), element);
                  return this.optional(element) || ( length >= param[0] && length <= param[1] );
            },

            // http://jqueryvalidation.org/min-method/
            min: function( value, element, param ) {
                  return this.optional(element) || value >= param;
            },

            // http://jqueryvalidation.org/max-method/
            max: function( value, element, param ) {
                  return this.optional(element) || value <= param;
            },

            // http://jqueryvalidation.org/range-method/
            range: function( value, element, param ) {
                  return this.optional(element) || ( value >= param[0] && value <= param[1] );
            },

            // http://jqueryvalidation.org/equalTo-method/
            equalTo: function( value, element, param ) {
                  // bind to the blur event of the target in order to revalidate whenever the target field is updated
                  // TODO find a way to bind the event just once, avoiding the unbind-rebind overhead
                  var target = $(param);
                  if ( this.settings.onfocusout ) {
                        target.unbind(".validate-equalTo").bind("blur.validate-equalTo", function() {
                              $(element).valid();
                        });
                  }
                  return value === target.val();
            },

            // http://jqueryvalidation.org/remote-method/
            remote: function( value, element, param ) {
                  if ( this.optional(element) ) {
                        return "dependency-mismatch";
                  }

                  var previous = this.previousValue(element),
                        validator, data;

                  if (!this.settings.messages[element.name] ) {
                        this.settings.messages[element.name] = {};
                  }
                  previous.originalMessage = this.settings.messages[element.name].remote;
                  this.settings.messages[element.name].remote = previous.message;

                  param = typeof param === "string" && { url: param } || param;

                  if ( previous.old === value ) {
                        return previous.valid;
                  }

                  previous.old = value;
                  validator = this;
                  this.startRequest(element);
                  data = {};
                  data[element.name] = value;
                  $.ajax($.extend(true, {
                        url: param,
                        mode: "abort",
                        port: "validate" + element.name,
                        dataType: "json",
                        data: data,
                        context: validator.currentForm,
                        success: function( response ) {
                              var valid = response === true || response === "true",
                                    errors, message, submitted;

                              validator.settings.messages[element.name].remote = previous.originalMessage;
                              if ( valid ) {
                                    submitted = validator.formSubmitted;
                                    validator.prepareElement(element);
                                    validator.formSubmitted = submitted;
                                    validator.successList.push(element);
                                    delete validator.invalid[element.name];
                                    validator.showErrors();
                              } else {
                                    errors = {};
                                    message = response || validator.defaultMessage( element, "remote" );
                                    errors[element.name] = previous.message = $.isFunction(message) ? message(value) : message;
                                    validator.invalid[element.name] = true;
                                    validator.showErrors(errors);
                              }
                              previous.valid = valid;
                              validator.stopRequest(element, valid);
                        }
                  }, param));
                  return "pending";
            }

      }

});

$.format = function deprecated() {
      throw "$.format has been deprecated. Please use $.validator.format instead.";
};

}(jQuery));

// ajax mode: abort
// usage: $.ajax({ mode: "abort"[, port: "uniqueport"]});
// if mode:"abort" is used, the previous request on that port (port can be undefined) is aborted via XMLHttpRequest.abort()
(function($) {
      var pendingRequests = {},
            ajax;
      // Use a prefilter if available (1.5+)
      if ( $.ajaxPrefilter ) {
            $.ajaxPrefilter(function( settings, _, xhr ) {
                  var port = settings.port;
                  if ( settings.mode === "abort" ) {
                        if ( pendingRequests[port] ) {
                              pendingRequests[port].abort();
                        }
                        pendingRequests[port] = xhr;
                  }
            });
      } else {
            // Proxy ajax
            ajax = $.ajax;
            $.ajax = function( settings ) {
                  var mode = ( "mode" in settings ? settings : $.ajaxSettings ).mode,
                        port = ( "port" in settings ? settings : $.ajaxSettings ).port;
                  if ( mode === "abort" ) {
                        if ( pendingRequests[port] ) {
                              pendingRequests[port].abort();
                        }
                        pendingRequests[port] = ajax.apply(this, arguments);
                        return pendingRequests[port];
                  }
                  return ajax.apply(this, arguments);
            };
      }
}(jQuery));

// provides delegate(type: String, delegate: Selector, handler: Callback) plugin for easier event delegation
// handler is only called when $(event.target).is(delegate), in the scope of the jquery-object for event.target
(function($) {
      $.extend($.fn, {
            validateDelegate: function( delegate, type, handler ) {
                  return this.bind(type, function( event ) {
                        var target = $(event.target);
                        if ( target.is(delegate) ) {
                              return handler.apply(target, arguments);
                        }
                  });
            }
      });
}(jQuery));

/*            'js/jquery.ezmark.js', */
/**
 * ezMark - A Simple Checkbox and Radio button Styling plugin.
 * This plugin allows you to use a custom Image for Checkbox or Radio button. Its very simple, small and easy to use.
 *
 * Modified by Ben Barbour - Aug 15, 2012
 *
 * Copyright (c) Abdullah Rubiyath <http://www.itsalif.info/>.
 * Released under MIT License
 *
 * Files with this plugin:
 * - jquery.ezmark.js
 * - ezmark.css
 *
 * <usage>
 * At first, include both the css and js file at the top
 *
 * Then, simply use:
 *  $('selector').ezMark([options]);
 *
 * [options] accepts following JSON properties:
 *  checkboxCls - custom Checkbox Class
 *  checkedCls  - checkbox Checked State's Class
 *  radioCls    - custom radiobutton Class
 *  selectedCls - radiobutton's Selected State's Class
 *
 * </usage>
 *
 * View Documention/Demo here:
 * http://www.itsalif.info/content/ezmark-jquery-checkbox-radiobutton-plugin
 *
 * @author Abdullah Rubiyath
 * @version 1.0
 * @date June 27, 2010
 */

(function($) {
  $.fn.ezMark = function(options) {
    options = options || {};
    var defaultOpt = {
        checkboxCls     : options.checkboxCls || 'ez-checkbox' , radioCls : options.radioCls || 'ez-radio',
        checkedCls      : options.checkedCls  || 'ez-checked'  , selectedCls : options.selectedCls || 'ez-selected',
        hideCls         : 'ez-hide'
    };

    var $ezMarks = $();
    $.propHooks.checked = {
        set: function (el, value) {
            if ($ezMarks.filter(el).length !== 0) {
                el.checked = value;
                $(el).trigger('change');
            }
        }
    };
    return this.each(function() {
        var $this = $(this);
        $ezMarks = $ezMarks.add(this);
        var wrapTag = $this.attr('type') == 'checkbox' ? '<div class="'+defaultOpt.checkboxCls+'">' : '<div class="'+defaultOpt.radioCls+'">';
        // for checkbox
        if ($this.attr('type') == 'checkbox') {
            $this.addClass(defaultOpt.hideCls).wrap(wrapTag).change(function() {
                var $chk = $(this);
                if ($chk.is(':checked')) {
                    $chk.parent().addClass(defaultOpt.checkedCls);
                }
                else {
                    $chk.parent().removeClass(defaultOpt.checkedCls);
                }
                $this.blur();
            }).change();
        }
        else if( $this.attr('type') == 'radio') {
            $this.addClass(defaultOpt.hideCls).wrap(wrapTag).change(function() {
                // radio button may contain groups! - so check for group
                $('input[name="'+$(this).attr('name')+'"]').each(function() {
                    var $rdo = $(this);
                    if($rdo.is(':checked')) {
                        $rdo.parent().addClass(defaultOpt.selectedCls);
                    } else {
                        $rdo.parent().removeClass(defaultOpt.selectedCls);
                    }
                });
                $this.blur();
            }).change();
        }
    });
  }
})(jQuery);

/*            BUILD_DIR + '/js/jquery.qtip.js',*/
/*
 * qTip2 - Pretty powerful tooltips - v2.2.0
 * http://qtip2.com
 *
 * Copyright (c) 2013 Craig Michael Thompson
 * Released under the MIT, GPL licenses
 * http://jquery.org/license
 *
 * Date: Mon Dec 16 2013 04:04 EST-0500
 * Plugins: viewport
 * Styles: None
 */
/*global window: false, jQuery: false, console: false, define: false */

/* Cache window, document, undefined */
(function( window, document, undefined ) {

// Uses AMD or browser globals to create a jQuery plugin.
(function( factory ) {
      "use strict";
      if(typeof define === 'function' && define.amd) {
            define(['jquery'], factory);
      }
      else if(jQuery && !jQuery.fn.qtip) {
            factory(jQuery);
      }
}
(function($) {
      "use strict"; // Enable ECMAScript "strict" operation for this function. See more: http://ejohn.org/blog/ecmascript-5-strict-mode-json-and-more/

;// Munge the primitives - Paul Irish tip
var TRUE = true,
FALSE = false,
NULL = null,

// Common variables
X = 'x', Y = 'y',
WIDTH = 'width',
HEIGHT = 'height',

// Positioning sides
TOP = 'top',
LEFT = 'left',
BOTTOM = 'bottom',
RIGHT = 'right',
CENTER = 'center',

// Position adjustment types
FLIP = 'flip',
FLIPINVERT = 'flipinvert',
SHIFT = 'shift',

// Shortcut vars
QTIP, PROTOTYPE, CORNER, CHECKS,
PLUGINS = {},
NAMESPACE = 'qtip',
ATTR_HAS = 'data-hasqtip',
ATTR_ID = 'data-qtip-id',
WIDGET = ['ui-widget', 'ui-tooltip'],
SELECTOR = '.'+NAMESPACE,
INACTIVE_EVENTS = 'click dblclick mousedown mouseup mousemove mouseleave mouseenter'.split(' '),

CLASS_FIXED = NAMESPACE+'-fixed',
CLASS_DEFAULT = NAMESPACE + '-default',
CLASS_FOCUS = NAMESPACE + '-focus',
CLASS_HOVER = NAMESPACE + '-hover',
CLASS_DISABLED = NAMESPACE+'-disabled',

replaceSuffix = '_replacedByqTip',
oldtitle = 'oldtitle',
trackingBound,

// Browser detection
BROWSER = {
      /*
       * IE version detection
       *
       * Adapted from: http://ajaxian.com/archives/attack-of-the-ie-conditional-comment
       * Credit to James Padolsey for the original implemntation!
       */
      ie: (function(){
            var v = 3, div = document.createElement('div');
            while ((div.innerHTML = '<!--[if gt IE '+(++v)+']><i></i><![endif]-->')) {
                  if(!div.getElementsByTagName('i')[0]) { break; }
            }
            return v > 4 ? v : NaN;
      }()),
 
      /*
       * iOS version detection
       */
      iOS: parseFloat( 
            ('' + (/CPU.*OS ([0-9_]{1,5})|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent) || [0,''])[1])
            .replace('undefined', '3_2').replace('_', '.').replace('_', '')
      ) || FALSE
};

;function QTip(target, options, id, attr) {
      // Elements and ID
      this.id = id;
      this.target = target;
      this.tooltip = NULL;
      this.elements = { target: target };

      // Internal constructs
      this._id = NAMESPACE + '-' + id;
      this.timers = { img: {} };
      this.options = options;
      this.plugins = {};

      // Cache object
      this.cache = {
            event: {},
            target: $(),
            disabled: FALSE,
            attr: attr,
            onTooltip: FALSE,
            lastClass: ''
      };

      // Set the initial flags
      this.rendered = this.destroyed = this.disabled = this.waiting = 
            this.hiddenDuringWait = this.positioning = this.triggering = FALSE;
}
PROTOTYPE = QTip.prototype;

PROTOTYPE._when = function(deferreds) {
      return $.when.apply($, deferreds);
};

PROTOTYPE.render = function(show) {
      if(this.rendered || this.destroyed) { return this; } // If tooltip has already been rendered, exit

      var self = this,
            options = this.options,
            cache = this.cache,
            elements = this.elements,
            text = options.content.text,
            title = options.content.title,
            button = options.content.button,
            posOptions = options.position,
            namespace = '.'+this._id+' ',
            deferreds = [],
            tooltip;

      // Add ARIA attributes to target
      $.attr(this.target[0], 'aria-describedby', this._id);

      // Create tooltip element
      this.tooltip = elements.tooltip = tooltip = $('<div/>', {
            'id': this._id,
            'class': [ NAMESPACE, CLASS_DEFAULT, options.style.classes, NAMESPACE + '-pos-' + options.position.my.abbrev() ].join(' '),
            'width': options.style.width || '',
            'height': options.style.height || '',
            'tracking': posOptions.target === 'mouse' && posOptions.adjust.mouse,

            /* ARIA specific attributes */
            'role': 'alert',
            'aria-live': 'polite',
            'aria-atomic': FALSE,
            'aria-describedby': this._id + '-content',
            'aria-hidden': TRUE
      })
      .toggleClass(CLASS_DISABLED, this.disabled)
      .attr(ATTR_ID, this.id)
      .data(NAMESPACE, this)
      .appendTo(posOptions.container)
      .append(
            // Create content element
            elements.content = $('<div />', {
                  'class': NAMESPACE + '-content',
                  'id': this._id + '-content',
                  'aria-atomic': TRUE
            })
      );

      // Set rendered flag and prevent redundant reposition calls for now
      this.rendered = -1;
      this.positioning = TRUE;

      // Create title...
      if(title) {
            this._createTitle();

            // Update title only if its not a callback (called in toggle if so)
            if(!$.isFunction(title)) {
                  deferreds.push( this._updateTitle(title, FALSE) );
            }
      }

      // Create button
      if(button) { this._createButton(); }

      // Set proper rendered flag and update content if not a callback function (called in toggle)
      if(!$.isFunction(text)) {
            deferreds.push( this._updateContent(text, FALSE) );
      }
      this.rendered = TRUE;

      // Setup widget classes
      this._setWidget();

      // Initialize 'render' plugins
      $.each(PLUGINS, function(name) {
            var instance;
            if(this.initialize === 'render' && (instance = this(self))) {
                  self.plugins[name] = instance;
            }
      });

      // Unassign initial events and assign proper events
      this._unassignEvents();
      this._assignEvents();

      // When deferreds have completed
      this._when(deferreds).then(function() {
            // tooltiprender event
            self._trigger('render');

            // Reset flags
            self.positioning = FALSE;

            // Show tooltip if not hidden during wait period
            if(!self.hiddenDuringWait && (options.show.ready || show)) {
                  self.toggle(TRUE, cache.event, FALSE);
            }
            self.hiddenDuringWait = FALSE;
      });

      // Expose API
      QTIP.api[this.id] = this;

      return this;
};

PROTOTYPE.destroy = function(immediate) {
      // Set flag the signify destroy is taking place to plugins
      // and ensure it only gets destroyed once!
      if(this.destroyed) { return this.target; }

      function process() {
            if(this.destroyed) { return; }
            this.destroyed = TRUE;
            
            var target = this.target,
                  title = target.attr(oldtitle);

            // Destroy tooltip if rendered
            if(this.rendered) {
                  this.tooltip.stop(1,0).find('*').remove().end().remove();
            }

            // Destroy all plugins
            $.each(this.plugins, function(name) {
                  this.destroy && this.destroy();
            });

            // Clear timers and remove bound events
            clearTimeout(this.timers.show);
            clearTimeout(this.timers.hide);
            this._unassignEvents();

            // Remove api object and ARIA attributes
            target.removeData(NAMESPACE)
                  .removeAttr(ATTR_ID)
                  .removeAttr(ATTR_HAS)
                  .removeAttr('aria-describedby');

            // Reset old title attribute if removed
            if(this.options.suppress && title) {
                  target.attr('title', title).removeAttr(oldtitle);
            }

            // Remove qTip events associated with this API
            this._unbind(target);

            // Remove ID from used id objects, and delete object references
            // for better garbage collection and leak protection
            this.options = this.elements = this.cache = this.timers = 
                  this.plugins = this.mouse = NULL;

            // Delete epoxsed API object
            delete QTIP.api[this.id];
      }

      // If an immediate destory is needed
      if((immediate !== TRUE || this.triggering === 'hide') && this.rendered) {
            this.tooltip.one('tooltiphidden', $.proxy(process, this));
            !this.triggering && this.hide();
      }

      // If we're not in the process of hiding... process
      else { process.call(this); }

      return this.target;
};

;function invalidOpt(a) {
      return a === NULL || $.type(a) !== 'object';
}

function invalidContent(c) {
      return !( $.isFunction(c) || (c && c.attr) || c.length || ($.type(c) === 'object' && (c.jquery || c.then) ));
}

// Option object sanitizer
function sanitizeOptions(opts) {
      var content, text, ajax, once;

      if(invalidOpt(opts)) { return FALSE; }

      if(invalidOpt(opts.metadata)) {
            opts.metadata = { type: opts.metadata };
      }

      if('content' in opts) {
            content = opts.content;

            if(invalidOpt(content) || content.jquery || content.done) {
                  content = opts.content = {
                        text: (text = invalidContent(content) ? FALSE : content)
                  };
            }
            else { text = content.text; }

            // DEPRECATED - Old content.ajax plugin functionality
            // Converts it into the proper Deferred syntax
            if('ajax' in content) {
                  ajax = content.ajax;
                  once = ajax && ajax.once !== FALSE;
                  delete content.ajax;

                  content.text = function(event, api) {
                        var loading = text || $(this).attr(api.options.content.attr) || 'Loading...',

                        deferred = $.ajax(
                              $.extend({}, ajax, { context: api })
                        )
                        .then(ajax.success, NULL, ajax.error)
                        .then(function(content) {
                              if(content && once) { api.set('content.text', content); }
                              return content;
                        },
                        function(xhr, status, error) {
                              if(api.destroyed || xhr.status === 0) { return; }
                              api.set('content.text', status + ': ' + error);
                        });

                        return !once ? (api.set('content.text', loading), deferred) : loading;
                  };
            }

            if('title' in content) {
                  if(!invalidOpt(content.title)) {
                        content.button = content.title.button;
                        content.title = content.title.text;
                  }

                  if(invalidContent(content.title || FALSE)) {
                        content.title = FALSE;
                  }
            }
      }

      if('position' in opts && invalidOpt(opts.position)) {
            opts.position = { my: opts.position, at: opts.position };
      }

      if('show' in opts && invalidOpt(opts.show)) {
            opts.show = opts.show.jquery ? { target: opts.show } : 
                  opts.show === TRUE ? { ready: TRUE } : { event: opts.show };
      }

      if('hide' in opts && invalidOpt(opts.hide)) {
            opts.hide = opts.hide.jquery ? { target: opts.hide } : { event: opts.hide };
      }

      if('style' in opts && invalidOpt(opts.style)) {
            opts.style = { classes: opts.style };
      }

      // Sanitize plugin options
      $.each(PLUGINS, function() {
            this.sanitize && this.sanitize(opts);
      });

      return opts;
}

// Setup builtin .set() option checks
CHECKS = PROTOTYPE.checks = {
      builtin: {
            // Core checks
            '^id$': function(obj, o, v, prev) {
                  var id = v === TRUE ? QTIP.nextid : v,
                        new_id = NAMESPACE + '-' + id;

                  if(id !== FALSE && id.length > 0 && !$('#'+new_id).length) {
                        this._id = new_id;

                        if(this.rendered) {
                              this.tooltip[0].id = this._id;
                              this.elements.content[0].id = this._id + '-content';
                              this.elements.title[0].id = this._id + '-title';
                        }
                  }
                  else { obj[o] = prev; }
            },
            '^prerender': function(obj, o, v) {
                  v && !this.rendered && this.render(this.options.show.ready);
            },

            // Content checks
            '^content.text$': function(obj, o, v) {
                  this._updateContent(v);
            },
            '^content.attr$': function(obj, o, v, prev) {
                  if(this.options.content.text === this.target.attr(prev)) {
                        this._updateContent( this.target.attr(v) );
                  }
            },
            '^content.title$': function(obj, o, v) {
                  // Remove title if content is null
                  if(!v) { return this._removeTitle(); }

                  // If title isn't already created, create it now and update
                  v && !this.elements.title && this._createTitle();
                  this._updateTitle(v);
            },
            '^content.button$': function(obj, o, v) {
                  this._updateButton(v);
            },
            '^content.title.(text|button)$': function(obj, o, v) {
                  this.set('content.'+o, v); // Backwards title.text/button compat
            }, 

            // Position checks
            '^position.(my|at)$': function(obj, o, v){
                  'string' === typeof v && (obj[o] = new CORNER(v, o === 'at'));
            },
            '^position.container$': function(obj, o, v){
                  this.rendered && this.tooltip.appendTo(v);
            },

            // Show checks
            '^show.ready$': function(obj, o, v) {
                  v && (!this.rendered && this.render(TRUE) || this.toggle(TRUE));
            },

            // Style checks
            '^style.classes$': function(obj, o, v, p) {
                  this.rendered && this.tooltip.removeClass(p).addClass(v);
            },
            '^style.(width|height)': function(obj, o, v) {
                  this.rendered && this.tooltip.css(o, v);
            },
            '^style.widget|content.title': function() {
                  this.rendered && this._setWidget();
            },
            '^style.def': function(obj, o, v) {
                  this.rendered && this.tooltip.toggleClass(CLASS_DEFAULT, !!v);
            },

            // Events check
            '^events.(render|show|move|hide|focus|blur)$': function(obj, o, v) {
                  this.rendered && this.tooltip[($.isFunction(v) ? '' : 'un') + 'bind']('tooltip'+o, v);
            },

            // Properties which require event reassignment
            '^(show|hide|position).(event|target|fixed|inactive|leave|distance|viewport|adjust)': function() {
                  if(!this.rendered) { return; }

                  // Set tracking flag
                  var posOptions = this.options.position;
                  this.tooltip.attr('tracking', posOptions.target === 'mouse' && posOptions.adjust.mouse);

                  // Reassign events
                  this._unassignEvents();
                  this._assignEvents();
            }
      }
};

// Dot notation converter
function convertNotation(options, notation) {
      var i = 0, obj, option = options,

      // Split notation into array
      levels = notation.split('.');

      // Loop through
      while( option = option[ levels[i++] ] ) {
            if(i < levels.length) { obj = option; }
      }

      return [obj || options, levels.pop()];
}

PROTOTYPE.get = function(notation) {
      if(this.destroyed) { return this; }

      var o = convertNotation(this.options, notation.toLowerCase()),
            result = o[0][ o[1] ];

      return result.precedance ? result.string() : result;
};

function setCallback(notation, args) {
      var category, rule, match;

      for(category in this.checks) {
            for(rule in this.checks[category]) {
                  if(match = (new RegExp(rule, 'i')).exec(notation)) {
                        args.push(match);

                        if(category === 'builtin' || this.plugins[category]) {
                              this.checks[category][rule].apply(
                                    this.plugins[category] || this, args
                              );
                        }
                  }
            }
      }
}

var rmove = /^position\.(my|at|adjust|target|container|viewport)|style|content|show\.ready/i,
      rrender = /^prerender|show\.ready/i;

PROTOTYPE.set = function(option, value) {
      if(this.destroyed) { return this; }

      var rendered = this.rendered,
            reposition = FALSE,
            options = this.options,
            checks = this.checks,
            name;

      // Convert singular option/value pair into object form
      if('string' === typeof option) {
            name = option; option = {}; option[name] = value;
      }
      else { option = $.extend({}, option); }

      // Set all of the defined options to their new values
      $.each(option, function(notation, value) {
            if(rendered && rrender.test(notation)) {
                  delete option[notation]; return;
            }

            // Set new obj value
            var obj = convertNotation(options, notation.toLowerCase()), previous;
            previous = obj[0][ obj[1] ];
            obj[0][ obj[1] ] = value && value.nodeType ? $(value) : value;

            // Also check if we need to reposition
            reposition = rmove.test(notation) || reposition;

            // Set the new params for the callback
            option[notation] = [obj[0], obj[1], value, previous];
      });

      // Re-sanitize options
      sanitizeOptions(options);

      /*
       * Execute any valid callbacks for the set options
       * Also set positioning flag so we don't get loads of redundant repositioning calls.
       */
      this.positioning = TRUE;
      $.each(option, $.proxy(setCallback, this));
      this.positioning = FALSE;

      // Update position if needed
      if(this.rendered && this.tooltip[0].offsetWidth > 0 && reposition) {
            this.reposition( options.position.target === 'mouse' ? NULL : this.cache.event );
      }

      return this;
};

;PROTOTYPE._update = function(content, element, reposition) {
      var self = this,
            cache = this.cache;

      // Make sure tooltip is rendered and content is defined. If not return
      if(!this.rendered || !content) { return FALSE; }

      // Use function to parse content
      if($.isFunction(content)) {
            content = content.call(this.elements.target, cache.event, this) || '';
      }

      // Handle deferred content
      if($.isFunction(content.then)) {
            cache.waiting = TRUE;
            return content.then(function(c) {
                  cache.waiting = FALSE;
                  return self._update(c, element);
            }, NULL, function(e) {
                  return self._update(e, element);
            });
      }

      // If content is null... return false
      if(content === FALSE || (!content && content !== '')) { return FALSE; }

      // Append new content if its a DOM array and show it if hidden
      if(content.jquery && content.length > 0) {
            element.empty().append(
                  content.css({ display: 'block', visibility: 'visible' })
            );
      }

      // Content is a regular string, insert the new content
      else { element.html(content); }

      // Wait for content to be loaded, and reposition
      return this._waitForContent(element).then(function(images) {
            if(images.images && images.images.length && self.rendered && self.tooltip[0].offsetWidth > 0) {
                  self.reposition(cache.event, !images.length);
            }
      });
};

PROTOTYPE._waitForContent = function(element) {
      var cache = this.cache;
      
      // Set flag
      cache.waiting = TRUE;

      // If imagesLoaded is included, ensure images have loaded and return promise
      return ( $.fn.imagesLoaded ? element.imagesLoaded() : $.Deferred().resolve([]) )
            .done(function() { cache.waiting = FALSE; })
            .promise();
};

PROTOTYPE._updateContent = function(content, reposition) {
      this._update(content, this.elements.content, reposition);
};

PROTOTYPE._updateTitle = function(content, reposition) {
      if(this._update(content, this.elements.title, reposition) === FALSE) {
            this._removeTitle(FALSE);
      }
};

PROTOTYPE._createTitle = function()
{
      var elements = this.elements,
            id = this._id+'-title';

      // Destroy previous title element, if present
      if(elements.titlebar) { this._removeTitle(); }

      // Create title bar and title elements
      elements.titlebar = $('<div />', {
            'class': NAMESPACE + '-titlebar ' + (this.options.style.widget ? createWidgetClass('header') : '')
      })
      .append(
            elements.title = $('<div />', {
                  'id': id,
                  'class': NAMESPACE + '-title',
                  'aria-atomic': TRUE
            })
      )
      .insertBefore(elements.content)

      // Button-specific events
      .delegate('.qtip-close', 'mousedown keydown mouseup keyup mouseout', function(event) {
            $(this).toggleClass('ui-state-active ui-state-focus', event.type.substr(-4) === 'down');
      })
      .delegate('.qtip-close', 'mouseover mouseout', function(event){
            $(this).toggleClass('ui-state-hover', event.type === 'mouseover');
      });

      // Create button if enabled
      if(this.options.content.button) { this._createButton(); }
};

PROTOTYPE._removeTitle = function(reposition)
{
      var elements = this.elements;

      if(elements.title) {
            elements.titlebar.remove();
            elements.titlebar = elements.title = elements.button = NULL;

            // Reposition if enabled
            if(reposition !== FALSE) { this.reposition(); }
      }
};

;PROTOTYPE.reposition = function(event, effect) {
      if(!this.rendered || this.positioning || this.destroyed) { return this; }

      // Set positioning flag
      this.positioning = TRUE;

      var cache = this.cache,
            tooltip = this.tooltip,
            posOptions = this.options.position,
            target = posOptions.target,
            my = posOptions.my,
            at = posOptions.at,
            viewport = posOptions.viewport,
            container = posOptions.container,
            adjust = posOptions.adjust,
            method = adjust.method.split(' '),
            tooltipWidth = tooltip.outerWidth(FALSE),
            tooltipHeight = tooltip.outerHeight(FALSE),
            targetWidth = 0,
            targetHeight = 0,
            type = tooltip.css('position'),
            position = { left: 0, top: 0 },
            visible = tooltip[0].offsetWidth > 0,
            isScroll = event && event.type === 'scroll',
            win = $(window),
            doc = container[0].ownerDocument,
            mouse = this.mouse,
            pluginCalculations, offset;

      // Check if absolute position was passed
      if($.isArray(target) && target.length === 2) {
            // Force left top and set position
            at = { x: LEFT, y: TOP };
            position = { left: target[0], top: target[1] };
      }

      // Check if mouse was the target
      else if(target === 'mouse') {
            // Force left top to allow flipping
            at = { x: LEFT, y: TOP };

            // Use the cached mouse coordinates if available, or passed event has no coordinates
            if(mouse && mouse.pageX && (adjust.mouse || !event || !event.pageX) ) {
                  event = mouse;
            }
            
            // If the passed event has no coordinates (such as a scroll event)
            else if(!event || !event.pageX) {
                  // Use the mouse origin that caused the show event, if distance hiding is enabled
                  if((!adjust.mouse || this.options.show.distance) && cache.origin && cache.origin.pageX) {
                        event =  cache.origin;
                  }

                  // Use cached event for resize/scroll events
                  else if(!event || (event && (event.type === 'resize' || event.type === 'scroll'))) {
                        event = cache.event;
                  }
            }

            // Calculate body and container offset and take them into account below
            if(type !== 'static') { position = container.offset(); }
            if(doc.body.offsetWidth !== (window.innerWidth || doc.documentElement.clientWidth)) {
                  offset = $(document.body).offset();
            }

            // Use event coordinates for position
            position = {
                  left: event.pageX - position.left + (offset && offset.left || 0),
                  top: event.pageY - position.top + (offset && offset.top || 0)
            };

            // Scroll events are a pain, some browsers
            if(adjust.mouse && isScroll && mouse) {
                  position.left -= (mouse.scrollX || 0) - win.scrollLeft();
                  position.top -= (mouse.scrollY || 0) - win.scrollTop();
            }
      }

      // Target wasn't mouse or absolute...
      else {
            // Check if event targetting is being used
            if(target === 'event') {
                  if(event && event.target && event.type !== 'scroll' && event.type !== 'resize') {
                        cache.target = $(event.target);
                  }
                  else if(!event.target) {
                        cache.target = this.elements.target;
                  }
            }
            else if(target !== 'event'){
                  cache.target = $(target.jquery ? target : this.elements.target);
            }
            target = cache.target;

            // Parse the target into a jQuery object and make sure there's an element present
            target = $(target).eq(0);
            if(target.length === 0) { return this; }

            // Check if window or document is the target
            else if(target[0] === document || target[0] === window) {
                  targetWidth = BROWSER.iOS ? window.innerWidth : target.width();
                  targetHeight = BROWSER.iOS ? window.innerHeight : target.height();

                  if(target[0] === window) {
                        position = {
                              top: (viewport || target).scrollTop(),
                              left: (viewport || target).scrollLeft()
                        };
                  }
            }

            // Check if the target is an <AREA> element
            else if(PLUGINS.imagemap && target.is('area')) {
                  pluginCalculations = PLUGINS.imagemap(this, target, at, PLUGINS.viewport ? method : FALSE);
            }

            // Check if the target is an SVG element
            else if(PLUGINS.svg && target && target[0].ownerSVGElement) {
                  pluginCalculations = PLUGINS.svg(this, target, at, PLUGINS.viewport ? method : FALSE);
            }

            // Otherwise use regular jQuery methods
            else {
                  targetWidth = target.outerWidth(FALSE);
                  targetHeight = target.outerHeight(FALSE);
                  position = target.offset();
            }

            // Parse returned plugin values into proper variables
            if(pluginCalculations) {
                  targetWidth = pluginCalculations.width;
                  targetHeight = pluginCalculations.height;
                  offset = pluginCalculations.offset;
                  position = pluginCalculations.position;
            }

            // Adjust position to take into account offset parents
            position = this.reposition.offset(target, position, container);

            // Adjust for position.fixed tooltips (and also iOS scroll bug in v3.2-4.0 & v4.3-4.3.2)
            if((BROWSER.iOS > 3.1 && BROWSER.iOS < 4.1) || 
                  (BROWSER.iOS >= 4.3 && BROWSER.iOS < 4.33) || 
                  (!BROWSER.iOS && type === 'fixed')
            ){
                  position.left -= win.scrollLeft();
                  position.top -= win.scrollTop();
            }

            // Adjust position relative to target
            if(!pluginCalculations || (pluginCalculations && pluginCalculations.adjustable !== FALSE)) {
                  position.left += at.x === RIGHT ? targetWidth : at.x === CENTER ? targetWidth / 2 : 0;
                  position.top += at.y === BOTTOM ? targetHeight : at.y === CENTER ? targetHeight / 2 : 0;
            }
      }

      // Adjust position relative to tooltip
      position.left += adjust.x + (my.x === RIGHT ? -tooltipWidth : my.x === CENTER ? -tooltipWidth / 2 : 0);
      position.top += adjust.y + (my.y === BOTTOM ? -tooltipHeight : my.y === CENTER ? -tooltipHeight / 2 : 0);

      // Use viewport adjustment plugin if enabled
      if(PLUGINS.viewport) {
            position.adjusted = PLUGINS.viewport(
                  this, position, posOptions, targetWidth, targetHeight, tooltipWidth, tooltipHeight
            );

            // Apply offsets supplied by positioning plugin (if used)
            if(offset && position.adjusted.left) { position.left += offset.left; }
            if(offset && position.adjusted.top) {  position.top += offset.top; }
      }

      // Viewport adjustment is disabled, set values to zero
      else { position.adjusted = { left: 0, top: 0 }; }

      // tooltipmove event
      if(!this._trigger('move', [position, viewport.elem || viewport], event)) { return this; }
      delete position.adjusted;

      // If effect is disabled, target it mouse, no animation is defined or positioning gives NaN out, set CSS directly
      if(effect === FALSE || !visible || isNaN(position.left) || isNaN(position.top) || target === 'mouse' || !$.isFunction(posOptions.effect)) {
            tooltip.css(position);
      }

      // Use custom function if provided
      else if($.isFunction(posOptions.effect)) {
            posOptions.effect.call(tooltip, this, $.extend({}, position));
            tooltip.queue(function(next) {
                  // Reset attributes to avoid cross-browser rendering bugs
                  $(this).css({ opacity: '', height: '' });
                  if(BROWSER.ie) { this.style.removeAttribute('filter'); }

                  next();
            });
      }

      // Set positioning flag
      this.positioning = FALSE;

      return this;
};

// Custom (more correct for qTip!) offset calculator
PROTOTYPE.reposition.offset = function(elem, pos, container) {
      if(!container[0]) { return pos; }

      var ownerDocument = $(elem[0].ownerDocument),
            quirks = !!BROWSER.ie && document.compatMode !== 'CSS1Compat',
            parent = container[0],
            scrolled, position, parentOffset, overflow;

      function scroll(e, i) {
            pos.left += i * e.scrollLeft();
            pos.top += i * e.scrollTop();
      }

      // Compensate for non-static containers offset
      do {
            if((position = $.css(parent, 'position')) !== 'static') {
                  if(position === 'fixed') {
                        parentOffset = parent.getBoundingClientRect();
                        scroll(ownerDocument, -1);
                  }
                  else {
                        parentOffset = $(parent).position();
                        parentOffset.left += (parseFloat($.css(parent, 'borderLeftWidth')) || 0);
                        parentOffset.top += (parseFloat($.css(parent, 'borderTopWidth')) || 0);
                  }

                  pos.left -= parentOffset.left + (parseFloat($.css(parent, 'marginLeft')) || 0);
                  pos.top -= parentOffset.top + (parseFloat($.css(parent, 'marginTop')) || 0);

                  // If this is the first parent element with an overflow of "scroll" or "auto", store it
                  if(!scrolled && (overflow = $.css(parent, 'overflow')) !== 'hidden' && overflow !== 'visible') { scrolled = $(parent); }
            }
      }
      while((parent = parent.offsetParent));

      // Compensate for containers scroll if it also has an offsetParent (or in IE quirks mode)
      if(scrolled && (scrolled[0] !== ownerDocument[0] || quirks)) {
            scroll(scrolled, 1);
      }

      return pos;
};

// Corner class
var C = (CORNER = PROTOTYPE.reposition.Corner = function(corner, forceY) {
      corner = ('' + corner).replace(/([A-Z])/, ' $1').replace(/middle/gi, CENTER).toLowerCase();
      this.x = (corner.match(/left|right/i) || corner.match(/center/) || ['inherit'])[0].toLowerCase();
      this.y = (corner.match(/top|bottom|center/i) || ['inherit'])[0].toLowerCase();
      this.forceY = !!forceY;

      var f = corner.charAt(0);
      this.precedance = (f === 't' || f === 'b' ? Y : X);
}).prototype;

C.invert = function(z, center) {
      this[z] = this[z] === LEFT ? RIGHT : this[z] === RIGHT ? LEFT : center || this[z];  
};

C.string = function() {
      var x = this.x, y = this.y;
      return x === y ? x : this.precedance === Y || (this.forceY && y !== 'center') ? y+' '+x : x+' '+y;
};

C.abbrev = function() {
      var result = this.string().split(' ');
      return result[0].charAt(0) + (result[1] && result[1].charAt(0) || '');
};

C.clone = function() {
      return new CORNER( this.string(), this.forceY );
};;
PROTOTYPE.toggle = function(state, event) {
      var cache = this.cache,
            options = this.options,
            tooltip = this.tooltip;

      // Try to prevent flickering when tooltip overlaps show element
      if(event) {
            if((/over|enter/).test(event.type) && (/out|leave/).test(cache.event.type) &&
                  options.show.target.add(event.target).length === options.show.target.length &&
                  tooltip.has(event.relatedTarget).length) {
                  return this;
            }

            // Cache event
            cache.event = cloneEvent(event);
      }
            
      // If we're currently waiting and we've just hidden... stop it
      this.waiting && !state && (this.hiddenDuringWait = TRUE);

      // Render the tooltip if showing and it isn't already
      if(!this.rendered) { return state ? this.render(1) : this; }
      else if(this.destroyed || this.disabled) { return this; }

      var type = state ? 'show' : 'hide',
            opts = this.options[type],
            otherOpts = this.options[ !state ? 'show' : 'hide' ],
            posOptions = this.options.position,
            contentOptions = this.options.content,
            width = this.tooltip.css('width'),
            visible = this.tooltip.is(':visible'),
            animate = state || opts.target.length === 1,
            sameTarget = !event || opts.target.length < 2 || cache.target[0] === event.target,
            identicalState, allow, showEvent, delay, after;

      // Detect state if valid one isn't provided
      if((typeof state).search('boolean|number')) { state = !visible; }

      // Check if the tooltip is in an identical state to the new would-be state
      identicalState = !tooltip.is(':animated') && visible === state && sameTarget;

      // Fire tooltip(show/hide) event and check if destroyed
      allow = !identicalState ? !!this._trigger(type, [90]) : NULL;

      // Check to make sure the tooltip wasn't destroyed in the callback
      if(this.destroyed) { return this; }

      // If the user didn't stop the method prematurely and we're showing the tooltip, focus it
      if(allow !== FALSE && state) { this.focus(event); }

      // If the state hasn't changed or the user stopped it, return early
      if(!allow || identicalState) { return this; }

      // Set ARIA hidden attribute
      $.attr(tooltip[0], 'aria-hidden', !!!state);

      // Execute state specific properties
      if(state) {
            // Store show origin coordinates
            cache.origin = cloneEvent(this.mouse);

            // Update tooltip content & title if it's a dynamic function
            if($.isFunction(contentOptions.text)) { this._updateContent(contentOptions.text, FALSE); }
            if($.isFunction(contentOptions.title)) { this._updateTitle(contentOptions.title, FALSE); }

            // Cache mousemove events for positioning purposes (if not already tracking)
            if(!trackingBound && posOptions.target === 'mouse' && posOptions.adjust.mouse) {
                  $(document).bind('mousemove.'+NAMESPACE, this._storeMouse);
                  trackingBound = TRUE;
            }

            // Update the tooltip position (set width first to prevent viewport/max-width issues)
            if(!width) { tooltip.css('width', tooltip.outerWidth(FALSE)); }
            this.reposition(event, arguments[2]);
            if(!width) { tooltip.css('width', ''); }

            // Hide other tooltips if tooltip is solo
            if(!!opts.solo) {
                  (typeof opts.solo === 'string' ? $(opts.solo) : $(SELECTOR, opts.solo))
                        .not(tooltip).not(opts.target).qtip('hide', $.Event('tooltipsolo'));
            }
      }
      else {
            // Clear show timer if we're hiding
            clearTimeout(this.timers.show);

            // Remove cached origin on hide
            delete cache.origin;

            // Remove mouse tracking event if not needed (all tracking qTips are hidden)
            if(trackingBound && !$(SELECTOR+'[tracking="true"]:visible', opts.solo).not(tooltip).length) {
                  $(document).unbind('mousemove.'+NAMESPACE);
                  trackingBound = FALSE;
            }

            // Blur the tooltip
            this.blur(event);
      }

      // Define post-animation, state specific properties
      after = $.proxy(function() {
            if(state) {
                  // Prevent antialias from disappearing in IE by removing filter
                  if(BROWSER.ie) { tooltip[0].style.removeAttribute('filter'); }

                  // Remove overflow setting to prevent tip bugs
                  tooltip.css('overflow', '');

                  // Autofocus elements if enabled
                  if('string' === typeof opts.autofocus) {
                        $(this.options.show.autofocus, tooltip).focus();
                  }

                  // If set, hide tooltip when inactive for delay period
                  this.options.show.target.trigger('qtip-'+this.id+'-inactive');
            }
            else {
                  // Reset CSS states
                  tooltip.css({
                        display: '',
                        visibility: '',
                        opacity: '',
                        left: '',
                        top: ''
                  });
            }

            // tooltipvisible/tooltiphidden events
            this._trigger(state ? 'visible' : 'hidden');
      }, this);

      // If no effect type is supplied, use a simple toggle
      if(opts.effect === FALSE || animate === FALSE) {
            tooltip[ type ]();
            after();
      }

      // Use custom function if provided
      else if($.isFunction(opts.effect)) {
            tooltip.stop(1, 1);
            opts.effect.call(tooltip, this);
            tooltip.queue('fx', function(n) {
                  after(); n();
            });
      }

      // Use basic fade function by default
      else { tooltip.fadeTo(90, state ? 1 : 0, after); }

      // If inactive hide method is set, active it
      if(state) { opts.target.trigger('qtip-'+this.id+'-inactive'); }

      return this;
};

PROTOTYPE.show = function(event) { return this.toggle(TRUE, event); };

PROTOTYPE.hide = function(event) { return this.toggle(FALSE, event); };

;PROTOTYPE.focus = function(event) {
      if(!this.rendered || this.destroyed) { return this; }

      var qtips = $(SELECTOR),
            tooltip = this.tooltip,
            curIndex = parseInt(tooltip[0].style.zIndex, 10),
            newIndex = QTIP.zindex + qtips.length,
            focusedElem;

      // Only update the z-index if it has changed and tooltip is not already focused
      if(!tooltip.hasClass(CLASS_FOCUS)) {
            // tooltipfocus event
            if(this._trigger('focus', [newIndex], event)) {
                  // Only update z-index's if they've changed
                  if(curIndex !== newIndex) {
                        // Reduce our z-index's and keep them properly ordered
                        qtips.each(function() {
                              if(this.style.zIndex > curIndex) {
                                    this.style.zIndex = this.style.zIndex - 1;
                              }
                        });

                        // Fire blur event for focused tooltip
                        qtips.filter('.' + CLASS_FOCUS).qtip('blur', event);
                  }

                  // Set the new z-index
                  tooltip.addClass(CLASS_FOCUS)[0].style.zIndex = newIndex;
            }
      }

      return this;
};

PROTOTYPE.blur = function(event) {
      if(!this.rendered || this.destroyed) { return this; }

      // Set focused status to FALSE
      this.tooltip.removeClass(CLASS_FOCUS);

      // tooltipblur event
      this._trigger('blur', [ this.tooltip.css('zIndex') ], event);

      return this;
};

;PROTOTYPE.disable = function(state) {
      if(this.destroyed) { return this; }

      // If 'toggle' is passed, toggle the current state
      if(state === 'toggle') {
            state = !(this.rendered ? this.tooltip.hasClass(CLASS_DISABLED) : this.disabled);
      }

      // Disable if no state passed
      else if('boolean' !== typeof state) {
            state = TRUE;
      }

      if(this.rendered) {
            this.tooltip.toggleClass(CLASS_DISABLED, state)
                  .attr('aria-disabled', state);
      }

      this.disabled = !!state;

      return this;
};

PROTOTYPE.enable = function() { return this.disable(FALSE); };

;PROTOTYPE._createButton = function()
{
      var self = this,
            elements = this.elements,
            tooltip = elements.tooltip,
            button = this.options.content.button,
            isString = typeof button === 'string',
            close = isString ? button : 'Close tooltip';

      if(elements.button) { elements.button.remove(); }

      // Use custom button if one was supplied by user, else use default
      if(button.jquery) {
            elements.button = button;
      }
      else {
            elements.button = $('<a />', {
                  'class': 'qtip-close ' + (this.options.style.widget ? '' : NAMESPACE+'-icon'),
                  'title': close,
                  'aria-label': close
            })
            .prepend(
                  $('<span />', {
                        'class': 'ui-icon ui-icon-close',
                        'html': '&times;'
                  })
            );
      }

      // Create button and setup attributes
      elements.button.appendTo(elements.titlebar || tooltip)
            .attr('role', 'button')
            .click(function(event) {
                  if(!tooltip.hasClass(CLASS_DISABLED)) { self.hide(event); }
                  return FALSE;
            });
};

PROTOTYPE._updateButton = function(button)
{
      // Make sure tooltip is rendered and if not, return
      if(!this.rendered) { return FALSE; }

      var elem = this.elements.button;
      if(button) { this._createButton(); }
      else { elem.remove(); }
};

;// Widget class creator
function createWidgetClass(cls) {
      return WIDGET.concat('').join(cls ? '-'+cls+' ' : ' ');
}

// Widget class setter method
PROTOTYPE._setWidget = function()
{
      var on = this.options.style.widget,
            elements = this.elements,
            tooltip = elements.tooltip,
            disabled = tooltip.hasClass(CLASS_DISABLED);

      tooltip.removeClass(CLASS_DISABLED);
      CLASS_DISABLED = on ? 'ui-state-disabled' : 'qtip-disabled';
      tooltip.toggleClass(CLASS_DISABLED, disabled);

      tooltip.toggleClass('ui-helper-reset '+createWidgetClass(), on).toggleClass(CLASS_DEFAULT, this.options.style.def && !on);
      
      if(elements.content) {
            elements.content.toggleClass( createWidgetClass('content'), on);
      }
      if(elements.titlebar) {
            elements.titlebar.toggleClass( createWidgetClass('header'), on);
      }
      if(elements.button) {
            elements.button.toggleClass(NAMESPACE+'-icon', !on);
      }
};;function cloneEvent(event) {
      return event && {
            type: event.type,
            pageX: event.pageX,
            pageY: event.pageY,
            target: event.target,
            relatedTarget: event.relatedTarget,
            scrollX: event.scrollX || window.pageXOffset || document.body.scrollLeft || document.documentElement.scrollLeft,
            scrollY: event.scrollY || window.pageYOffset || document.body.scrollTop || document.documentElement.scrollTop
      } || {};
}

function delay(callback, duration) {
      // If tooltip has displayed, start hide timer
      if(duration > 0) {
            return setTimeout(
                  $.proxy(callback, this), duration
            );
      }
      else{ callback.call(this); }
}

function showMethod(event) {
      if(this.tooltip.hasClass(CLASS_DISABLED)) { return FALSE; }

      // Clear hide timers
      clearTimeout(this.timers.show);
      clearTimeout(this.timers.hide);

      // Start show timer
      this.timers.show = delay.call(this,
            function() { this.toggle(TRUE, event); },
            this.options.show.delay
      );
}

function hideMethod(event) {
      if(this.tooltip.hasClass(CLASS_DISABLED)) { return FALSE; }

      // Check if new target was actually the tooltip element
      var relatedTarget = $(event.relatedTarget),
            ontoTooltip = relatedTarget.closest(SELECTOR)[0] === this.tooltip[0],
            ontoTarget = relatedTarget[0] === this.options.show.target[0];

      // Clear timers and stop animation queue
      clearTimeout(this.timers.show);
      clearTimeout(this.timers.hide);

      // Prevent hiding if tooltip is fixed and event target is the tooltip.
      // Or if mouse positioning is enabled and cursor momentarily overlaps
      if(this !== relatedTarget[0] && 
            (this.options.position.target === 'mouse' && ontoTooltip) || 
            (this.options.hide.fixed && (
                  (/mouse(out|leave|move)/).test(event.type) && (ontoTooltip || ontoTarget))
            ))
      {
            try {
                  event.preventDefault();
                  event.stopImmediatePropagation();
            } catch(e) {}

            return;
      }

      // If tooltip has displayed, start hide timer
      this.timers.hide = delay.call(this,
            function() { this.toggle(FALSE, event); },
            this.options.hide.delay,
            this
      );
}

function inactiveMethod(event) {
      if(this.tooltip.hasClass(CLASS_DISABLED) || !this.options.hide.inactive) { return FALSE; }

      // Clear timer
      clearTimeout(this.timers.inactive);

      this.timers.inactive = delay.call(this,
            function(){ this.hide(event); },
            this.options.hide.inactive
      );
}

function repositionMethod(event) {
      if(this.rendered && this.tooltip[0].offsetWidth > 0) { this.reposition(event); }
}

// Store mouse coordinates
PROTOTYPE._storeMouse = function(event) {
      (this.mouse = cloneEvent(event)).type = 'mousemove';
};

// Bind events
PROTOTYPE._bind = function(targets, events, method, suffix, context) {
      var ns = '.' + this._id + (suffix ? '-'+suffix : '');
      events.length && $(targets).bind(
            (events.split ? events : events.join(ns + ' ')) + ns,
            $.proxy(method, context || this)
      );
};
PROTOTYPE._unbind = function(targets, suffix) {
      $(targets).unbind('.' + this._id + (suffix ? '-'+suffix : ''));
};

// Apply common event handlers using delegate (avoids excessive .bind calls!)
var ns = '.'+NAMESPACE;
function delegate(selector, events, method) {   
      $(document.body).delegate(selector,
            (events.split ? events : events.join(ns + ' ')) + ns,
            function() {
                  var api = QTIP.api[ $.attr(this, ATTR_ID) ];
                  api && !api.disabled && method.apply(api, arguments);
            }
      );
}

$(function() {
      delegate(SELECTOR, ['mouseenter', 'mouseleave'], function(event) {
            var state = event.type === 'mouseenter',
                  tooltip = $(event.currentTarget),
                  target = $(event.relatedTarget || event.target),
                  options = this.options;

            // On mouseenter...
            if(state) {
                  // Focus the tooltip on mouseenter (z-index stacking)
                  this.focus(event);

                  // Clear hide timer on tooltip hover to prevent it from closing
                  tooltip.hasClass(CLASS_FIXED) && !tooltip.hasClass(CLASS_DISABLED) && clearTimeout(this.timers.hide);
            }

            // On mouseleave...
            else {
                  // Hide when we leave the tooltip and not onto the show target (if a hide event is set)
                  if(options.position.target === 'mouse' && options.hide.event && 
                        options.show.target && !target.closest(options.show.target[0]).length) {
                        this.hide(event);
                  }
            }

            // Add hover class
            tooltip.toggleClass(CLASS_HOVER, state);
      });

      // Define events which reset the 'inactive' event handler
      delegate('['+ATTR_ID+']', INACTIVE_EVENTS, inactiveMethod);
});

// Event trigger
PROTOTYPE._trigger = function(type, args, event) {
      var callback = $.Event('tooltip'+type);
      callback.originalEvent = (event && $.extend({}, event)) || this.cache.event || NULL;

      this.triggering = type;
      this.tooltip.trigger(callback, [this].concat(args || []));
      this.triggering = FALSE;

      return !callback.isDefaultPrevented();
};

PROTOTYPE._bindEvents = function(showEvents, hideEvents, showTarget, hideTarget, showMethod, hideMethod) {
      // If hide and show targets are the same...
      if(hideTarget.add(showTarget).length === hideTarget.length) {
            var toggleEvents = [];

            // Filter identical show/hide events
            hideEvents = $.map(hideEvents, function(type) {
                  var showIndex = $.inArray(type, showEvents);

                  // Both events are identical, remove from both hide and show events
                  // and append to toggleEvents
                  if(showIndex > -1) {
                        toggleEvents.push( showEvents.splice( showIndex, 1 )[0] );
                        return;
                  }

                  return type;
            });

            // Toggle events are special case of identical show/hide events, which happen in sequence
            toggleEvents.length && this._bind(showTarget, toggleEvents, function(event) {
                  var state = this.rendered ? this.tooltip[0].offsetWidth > 0 : false;
                  (state ? hideMethod : showMethod).call(this, event);
            });
      }

      // Apply show/hide/toggle events
      this._bind(showTarget, showEvents, showMethod);
      this._bind(hideTarget, hideEvents, hideMethod);
};

PROTOTYPE._assignInitialEvents = function(event) {
      var options = this.options,
            showTarget = options.show.target,
            hideTarget = options.hide.target,
            showEvents = options.show.event ? $.trim('' + options.show.event).split(' ') : [],
            hideEvents = options.hide.event ? $.trim('' + options.hide.event).split(' ') : [];

      /*
       * Make sure hoverIntent functions properly by using mouseleave as a hide event if
       * mouseenter/mouseout is used for show.event, even if it isn't in the users options.
       */
      if(/mouse(over|enter)/i.test(options.show.event) && !/mouse(out|leave)/i.test(options.hide.event)) {
            hideEvents.push('mouseleave');
      }

      /*
       * Also make sure initial mouse targetting works correctly by caching mousemove coords
       * on show targets before the tooltip has rendered. Also set onTarget when triggered to
       * keep mouse tracking working.
       */
      this._bind(showTarget, 'mousemove', function(event) {
            this._storeMouse(event);
            this.cache.onTarget = TRUE;
      });

      // Define hoverIntent function
      function hoverIntent(event) {
            // Only continue if tooltip isn't disabled
            if(this.disabled || this.destroyed) { return FALSE; }

            // Cache the event data
            this.cache.event = cloneEvent(event);
            this.cache.target = event ? $(event.target) : [undefined];

            // Start the event sequence
            clearTimeout(this.timers.show);
            this.timers.show = delay.call(this,
                  function() { this.render(typeof event === 'object' || options.show.ready); },
                  options.show.delay
            );
      }

      // Filter and bind events
      this._bindEvents(showEvents, hideEvents, showTarget, hideTarget, hoverIntent, function() {
            clearTimeout(this.timers.show);
      });

      // Prerendering is enabled, create tooltip now
      if(options.show.ready || options.prerender) { hoverIntent.call(this, event); }
};

// Event assignment method
PROTOTYPE._assignEvents = function() {
      var self = this,
            options = this.options,
            posOptions = options.position,

            tooltip = this.tooltip,
            showTarget = options.show.target,
            hideTarget = options.hide.target,
            containerTarget = posOptions.container,
            viewportTarget = posOptions.viewport,
            documentTarget = $(document),
            bodyTarget = $(document.body),
            windowTarget = $(window),

            showEvents = options.show.event ? $.trim('' + options.show.event).split(' ') : [],
            hideEvents = options.hide.event ? $.trim('' + options.hide.event).split(' ') : [];


      // Assign passed event callbacks
      $.each(options.events, function(name, callback) {
            self._bind(tooltip, name === 'toggle' ? ['tooltipshow','tooltiphide'] : ['tooltip'+name], callback, null, tooltip);
      });

      // Hide tooltips when leaving current window/frame (but not select/option elements)
      if(/mouse(out|leave)/i.test(options.hide.event) && options.hide.leave === 'window') {
            this._bind(documentTarget, ['mouseout', 'blur'], function(event) {
                  if(!/select|option/.test(event.target.nodeName) && !event.relatedTarget) {
                        this.hide(event);
                  }
            });
      }

      // Enable hide.fixed by adding appropriate class
      if(options.hide.fixed) {
            hideTarget = hideTarget.add( tooltip.addClass(CLASS_FIXED) );
      }

      /*
       * Make sure hoverIntent functions properly by using mouseleave to clear show timer if
       * mouseenter/mouseout is used for show.event, even if it isn't in the users options.
       */
      else if(/mouse(over|enter)/i.test(options.show.event)) {
            this._bind(hideTarget, 'mouseleave', function() {
                  clearTimeout(this.timers.show);
            });
      }

      // Hide tooltip on document mousedown if unfocus events are enabled
      if(('' + options.hide.event).indexOf('unfocus') > -1) {
            this._bind(containerTarget.closest('html'), ['mousedown', 'touchstart'], function(event) {
                  var elem = $(event.target),
                        enabled = this.rendered && !this.tooltip.hasClass(CLASS_DISABLED) && this.tooltip[0].offsetWidth > 0,
                        isAncestor = elem.parents(SELECTOR).filter(this.tooltip[0]).length > 0;

                  if(elem[0] !== this.target[0] && elem[0] !== this.tooltip[0] && !isAncestor &&
                        !this.target.has(elem[0]).length && enabled
                  ) {
                        this.hide(event);
                  }
            });
      }

      // Check if the tooltip hides when inactive
      if('number' === typeof options.hide.inactive) {
            // Bind inactive method to show target(s) as a custom event
            this._bind(showTarget, 'qtip-'+this.id+'-inactive', inactiveMethod);

            // Define events which reset the 'inactive' event handler
            this._bind(hideTarget.add(tooltip), QTIP.inactiveEvents, inactiveMethod, '-inactive');
      }

      // Filter and bind events
      this._bindEvents(showEvents, hideEvents, showTarget, hideTarget, showMethod, hideMethod);

      // Mouse movement bindings
      this._bind(showTarget.add(tooltip), 'mousemove', function(event) {
            // Check if the tooltip hides when mouse is moved a certain distance
            if('number' === typeof options.hide.distance) {
                  var origin = this.cache.origin || {},
                        limit = this.options.hide.distance,
                        abs = Math.abs;

                  // Check if the movement has gone beyond the limit, and hide it if so
                  if(abs(event.pageX - origin.pageX) >= limit || abs(event.pageY - origin.pageY) >= limit) {
                        this.hide(event);
                  }
            }

            // Cache mousemove coords on show targets
            this._storeMouse(event);
      });

      // Mouse positioning events
      if(posOptions.target === 'mouse') {
            // If mouse adjustment is on...
            if(posOptions.adjust.mouse) {
                  // Apply a mouseleave event so we don't get problems with overlapping
                  if(options.hide.event) {
                        // Track if we're on the target or not
                        this._bind(showTarget, ['mouseenter', 'mouseleave'], function(event) {
                              this.cache.onTarget = event.type === 'mouseenter';
                        });
                  }

                  // Update tooltip position on mousemove
                  this._bind(documentTarget, 'mousemove', function(event) {
                        // Update the tooltip position only if the tooltip is visible and adjustment is enabled
                        if(this.rendered && this.cache.onTarget && !this.tooltip.hasClass(CLASS_DISABLED) && this.tooltip[0].offsetWidth > 0) {
                              this.reposition(event);
                        }
                  });
            }
      }

      // Adjust positions of the tooltip on window resize if enabled
      if(posOptions.adjust.resize || viewportTarget.length) {
            this._bind( $.event.special.resize ? viewportTarget : windowTarget, 'resize', repositionMethod );
      }

      // Adjust tooltip position on scroll of the window or viewport element if present
      if(posOptions.adjust.scroll) {
            this._bind( windowTarget.add(posOptions.container), 'scroll', repositionMethod );
      }
};

// Un-assignment method
PROTOTYPE._unassignEvents = function() {
      var targets = [
            this.options.show.target[0],
            this.options.hide.target[0],
            this.rendered && this.tooltip[0],
            this.options.position.container[0],
            this.options.position.viewport[0],
            this.options.position.container.closest('html')[0], // unfocus
            window,
            document
      ];

      this._unbind($([]).pushStack( $.grep(targets, function(i) {
            return typeof i === 'object';
      })));
};

;// Initialization method
function init(elem, id, opts) {
      var obj, posOptions, attr, config, title,

      // Setup element references
      docBody = $(document.body),

      // Use document body instead of document element if needed
      newTarget = elem[0] === document ? docBody : elem,

      // Grab metadata from element if plugin is present
      metadata = (elem.metadata) ? elem.metadata(opts.metadata) : NULL,

      // If metadata type if HTML5, grab 'name' from the object instead, or use the regular data object otherwise
      metadata5 = opts.metadata.type === 'html5' && metadata ? metadata[opts.metadata.name] : NULL,

      // Grab data from metadata.name (or data-qtipopts as fallback) using .data() method,
      html5 = elem.data(opts.metadata.name || 'qtipopts');

      // If we don't get an object returned attempt to parse it manualyl without parseJSON
      try { html5 = typeof html5 === 'string' ? $.parseJSON(html5) : html5; } catch(e) {}

      // Merge in and sanitize metadata
      config = $.extend(TRUE, {}, QTIP.defaults, opts,
            typeof html5 === 'object' ? sanitizeOptions(html5) : NULL,
            sanitizeOptions(metadata5 || metadata));

      // Re-grab our positioning options now we've merged our metadata and set id to passed value
      posOptions = config.position;
      config.id = id;

      // Setup missing content if none is detected
      if('boolean' === typeof config.content.text) {
            attr = elem.attr(config.content.attr);

            // Grab from supplied attribute if available
            if(config.content.attr !== FALSE && attr) { config.content.text = attr; }

            // No valid content was found, abort render
            else { return FALSE; }
      }

      // Setup target options
      if(!posOptions.container.length) { posOptions.container = docBody; }
      if(posOptions.target === FALSE) { posOptions.target = newTarget; }
      if(config.show.target === FALSE) { config.show.target = newTarget; }
      if(config.show.solo === TRUE) { config.show.solo = posOptions.container.closest('body'); }
      if(config.hide.target === FALSE) { config.hide.target = newTarget; }
      if(config.position.viewport === TRUE) { config.position.viewport = posOptions.container; }

      // Ensure we only use a single container
      posOptions.container = posOptions.container.eq(0);

      // Convert position corner values into x and y strings
      posOptions.at = new CORNER(posOptions.at, TRUE);
      posOptions.my = new CORNER(posOptions.my);

      // Destroy previous tooltip if overwrite is enabled, or skip element if not
      if(elem.data(NAMESPACE)) {
            if(config.overwrite) {
                  elem.qtip('destroy', true);
            }
            else if(config.overwrite === FALSE) {
                  return FALSE;
            }
      }

      // Add has-qtip attribute
      elem.attr(ATTR_HAS, id);

      // Remove title attribute and store it if present
      if(config.suppress && (title = elem.attr('title'))) {
            // Final attr call fixes event delegatiom and IE default tooltip showing problem
            elem.removeAttr('title').attr(oldtitle, title).attr('title', '');
      }

      // Initialize the tooltip and add API reference
      obj = new QTip(elem, config, id, !!attr);
      elem.data(NAMESPACE, obj);

      // Catch remove/removeqtip events on target element to destroy redundant tooltip
      elem.one('remove.qtip-'+id+' removeqtip.qtip-'+id, function() { 
            var api; if((api = $(this).data(NAMESPACE))) { api.destroy(true); }
      });

      return obj;
}

// jQuery $.fn extension method
QTIP = $.fn.qtip = function(options, notation, newValue)
{
      var command = ('' + options).toLowerCase(), // Parse command
            returned = NULL,
            args = $.makeArray(arguments).slice(1),
            event = args[args.length - 1],
            opts = this[0] ? $.data(this[0], NAMESPACE) : NULL;

      // Check for API request
      if((!arguments.length && opts) || command === 'api') {
            return opts;
      }

      // Execute API command if present
      else if('string' === typeof options) {
            this.each(function() {
                  var api = $.data(this, NAMESPACE);
                  if(!api) { return TRUE; }

                  // Cache the event if possible
                  if(event && event.timeStamp) { api.cache.event = event; }

                  // Check for specific API commands
                  if(notation && (command === 'option' || command === 'options')) {
                        if(newValue !== undefined || $.isPlainObject(notation)) {
                              api.set(notation, newValue);
                        }
                        else {
                              returned = api.get(notation);
                              return FALSE;
                        }
                  }

                  // Execute API command
                  else if(api[command]) {
                        api[command].apply(api, args);
                  }
            });

            return returned !== NULL ? returned : this;
      }

      // No API commands. validate provided options and setup qTips
      else if('object' === typeof options || !arguments.length) {
            // Sanitize options first
            opts = sanitizeOptions($.extend(TRUE, {}, options));

            return this.each(function(i) {
                  var api, id;

                  // Find next available ID, or use custom ID if provided
                  id = $.isArray(opts.id) ? opts.id[i] : opts.id;
                  id = !id || id === FALSE || id.length < 1 || QTIP.api[id] ? QTIP.nextid++ : id;

                  // Initialize the qTip and re-grab newly sanitized options
                  api = init($(this), id, opts);
                  if(api === FALSE) { return TRUE; }
                  else { QTIP.api[id] = api; }

                  // Initialize plugins
                  $.each(PLUGINS, function() {
                        if(this.initialize === 'initialize') { this(api); }
                  });

                  // Assign initial pre-render events
                  api._assignInitialEvents(event);
            });
      }
};

// Expose class
$.qtip = QTip;

// Populated in render method
QTIP.api = {};
;$.each({
      /* Allow other plugins to successfully retrieve the title of an element with a qTip applied */
      attr: function(attr, val) {
            if(this.length) {
                  var self = this[0],
                        title = 'title',
                        api = $.data(self, 'qtip');

                  if(attr === title && api && 'object' === typeof api && api.options.suppress) {
                        if(arguments.length < 2) {
                              return $.attr(self, oldtitle);
                        }

                        // If qTip is rendered and title was originally used as content, update it
                        if(api && api.options.content.attr === title && api.cache.attr) {
                              api.set('content.text', val);
                        }

                        // Use the regular attr method to set, then cache the result
                        return this.attr(oldtitle, val);
                  }
            }

            return $.fn['attr'+replaceSuffix].apply(this, arguments);
      },

      /* Allow clone to correctly retrieve cached title attributes */
      clone: function(keepData) {
            var titles = $([]), title = 'title',

            // Clone our element using the real clone method
            elems = $.fn['clone'+replaceSuffix].apply(this, arguments);

            // Grab all elements with an oldtitle set, and change it to regular title attribute, if keepData is false
            if(!keepData) {
                  elems.filter('['+oldtitle+']').attr('title', function() {
                        return $.attr(this, oldtitle);
                  })
                  .removeAttr(oldtitle);
            }

            return elems;
      }
}, function(name, func) {
      if(!func || $.fn[name+replaceSuffix]) { return TRUE; }

      var old = $.fn[name+replaceSuffix] = $.fn[name];
      $.fn[name] = function() {
            return func.apply(this, arguments) || old.apply(this, arguments);
      };
});

/* Fire off 'removeqtip' handler in $.cleanData if jQuery UI not present (it already does similar).
 * This snippet is taken directly from jQuery UI source code found here:
 *     http://code.jquery.com/ui/jquery-ui-git.js
 */
if(!$.ui) {
      $['cleanData'+replaceSuffix] = $.cleanData;
      $.cleanData = function( elems ) {
            for(var i = 0, elem; (elem = $( elems[i] )).length; i++) {
                  if(elem.attr(ATTR_HAS)) {
                        try { elem.triggerHandler('removeqtip'); } 
                        catch( e ) {}
                  }
            }
            $['cleanData'+replaceSuffix].apply(this, arguments);
      };
}

;// qTip version
QTIP.version = '2.2.0';

// Base ID for all qTips
QTIP.nextid = 0;

// Inactive events array
QTIP.inactiveEvents = INACTIVE_EVENTS;

// Base z-index for all qTips
QTIP.zindex = 15000;

// Define configuration defaults
QTIP.defaults = {
      prerender: FALSE,
      id: FALSE,
      overwrite: TRUE,
      suppress: TRUE,
      content: {
            text: TRUE,
            attr: 'title',
            title: FALSE,
            button: FALSE
      },
      position: {
            my: 'top left',
            at: 'bottom right',
            target: FALSE,
            container: FALSE,
            viewport: FALSE,
            adjust: {
                  x: 0, y: 0,
                  mouse: TRUE,
                  scroll: TRUE,
                  resize: TRUE,
                  method: 'flipinvert flipinvert'
            },
            effect: function(api, pos, viewport) {
                  $(this).animate(pos, {
                        duration: 200,
                        queue: FALSE
                  });
            }
      },
      show: {
            target: FALSE,
            event: 'mouseenter',
            effect: TRUE,
            delay: 90,
            solo: FALSE,
            ready: FALSE,
            autofocus: FALSE
      },
      hide: {
            target: FALSE,
            event: 'mouseleave',
            effect: TRUE,
            delay: 0,
            fixed: FALSE,
            inactive: FALSE,
            leave: 'window',
            distance: FALSE
      },
      style: {
            classes: '',
            widget: FALSE,
            width: FALSE,
            height: FALSE,
            def: TRUE
      },
      events: {
            render: NULL,
            move: NULL,
            show: NULL,
            hide: NULL,
            toggle: NULL,
            visible: NULL,
            hidden: NULL,
            focus: NULL,
            blur: NULL
      }
};

;PLUGINS.viewport = function(api, position, posOptions, targetWidth, targetHeight, elemWidth, elemHeight)
{
      var target = posOptions.target,
            tooltip = api.elements.tooltip,
            my = posOptions.my,
            at = posOptions.at,
            adjust = posOptions.adjust,
            method = adjust.method.split(' '),
            methodX = method[0],
            methodY = method[1] || method[0],
            viewport = posOptions.viewport,
            container = posOptions.container,
            cache = api.cache,
            adjusted = { left: 0, top: 0 },
            fixed, newMy, newClass, containerOffset, containerStatic,
            viewportWidth, viewportHeight, viewportScroll, viewportOffset;

      // If viewport is not a jQuery element, or it's the window/document, or no adjustment method is used... return
      if(!viewport.jquery || target[0] === window || target[0] === document.body || adjust.method === 'none') {
            return adjusted;
      }

      // Cach container details
      containerOffset = container.offset() || adjusted;
      containerStatic = container.css('position') === 'static';

      // Cache our viewport details
      fixed = tooltip.css('position') === 'fixed';
      viewportWidth = viewport[0] === window ? viewport.width() : viewport.outerWidth(FALSE);
      viewportHeight = viewport[0] === window ? viewport.height() : viewport.outerHeight(FALSE);
      viewportScroll = { left: fixed ? 0 : viewport.scrollLeft(), top: fixed ? 0 : viewport.scrollTop() };
      viewportOffset = viewport.offset() || adjusted;

      // Generic calculation method
      function calculate(side, otherSide, type, adjust, side1, side2, lengthName, targetLength, elemLength) {
            var initialPos = position[side1],
                  mySide = my[side],
                  atSide = at[side],
                  isShift = type === SHIFT,
                  myLength = mySide === side1 ? elemLength : mySide === side2 ? -elemLength : -elemLength / 2,
                  atLength = atSide === side1 ? targetLength : atSide === side2 ? -targetLength : -targetLength / 2,
                  sideOffset = viewportScroll[side1] + viewportOffset[side1] - (containerStatic ? 0 : containerOffset[side1]),
                  overflow1 = sideOffset - initialPos,
                  overflow2 = initialPos + elemLength - (lengthName === WIDTH ? viewportWidth : viewportHeight) - sideOffset,
                  offset = myLength - (my.precedance === side || mySide === my[otherSide] ? atLength : 0) - (atSide === CENTER ? targetLength / 2 : 0);

            // shift
            if(isShift) {
                  offset = (mySide === side1 ? 1 : -1) * myLength;

                  // Adjust position but keep it within viewport dimensions
                  position[side1] += overflow1 > 0 ? overflow1 : overflow2 > 0 ? -overflow2 : 0;
                  position[side1] = Math.max(
                        -containerOffset[side1] + viewportOffset[side1],
                        initialPos - offset,
                        Math.min(
                              Math.max(
                                    -containerOffset[side1] + viewportOffset[side1] + (lengthName === WIDTH ? viewportWidth : viewportHeight),
                                    initialPos + offset
                              ),
                              position[side1],

                              // Make sure we don't adjust complete off the element when using 'center'
                              mySide === 'center' ? initialPos - myLength : 1E9
                        )
                  );

            }

            // flip/flipinvert
            else {
                  // Update adjustment amount depending on if using flipinvert or flip
                  adjust *= (type === FLIPINVERT ? 2 : 0);

                  // Check for overflow on the left/top
                  if(overflow1 > 0 && (mySide !== side1 || overflow2 > 0)) {
                        position[side1] -= offset + adjust;
                        newMy.invert(side, side1);
                  }

                  // Check for overflow on the bottom/right
                  else if(overflow2 > 0 && (mySide !== side2 || overflow1 > 0)  ) {
                        position[side1] -= (mySide === CENTER ? -offset : offset) + adjust;
                        newMy.invert(side, side2);
                  }

                  // Make sure we haven't made things worse with the adjustment and reset if so
                  if(position[side1] < viewportScroll && -position[side1] > overflow2) {
                        position[side1] = initialPos; newMy = my.clone();
                  }
            }

            return position[side1] - initialPos;
      }

      // Set newMy if using flip or flipinvert methods
      if(methodX !== 'shift' || methodY !== 'shift') { newMy = my.clone(); }

      // Adjust position based onviewport and adjustment options
      adjusted = {
            left: methodX !== 'none' ? calculate( X, Y, methodX, adjust.x, LEFT, RIGHT, WIDTH, targetWidth, elemWidth ) : 0,
            top: methodY !== 'none' ? calculate( Y, X, methodY, adjust.y, TOP, BOTTOM, HEIGHT, targetHeight, elemHeight ) : 0
      };

      // Set tooltip position class if it's changed
      if(newMy && cache.lastClass !== (newClass = NAMESPACE + '-pos-' + newMy.abbrev())) {
            tooltip.removeClass(api.cache.lastClass).addClass( (api.cache.lastClass = newClass) );
      }

      return adjusted;
};
;}));
}( window, document ));



/*            'js/jquery.ba-resize.js',*/
/*!
 * jQuery resize event - v1.1 - 3/14/2010
 * http://benalman.com/projects/jquery-resize-plugin/
 *
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */

// Script: jQuery resize event
//
// *Version: 1.1, Last updated: 3/14/2010*
//
// Project Home - http://benalman.com/projects/jquery-resize-plugin/
// GitHub       - http://github.com/cowboy/jquery-resize/
// Source       - http://github.com/cowboy/jquery-resize/raw/master/jquery.ba-resize.js
// (Minified)   - http://github.com/cowboy/jquery-resize/raw/master/jquery.ba-resize.min.js (1.0kb)
//
// About: License
//
// Copyright (c) 2010 "Cowboy" Ben Alman,
// Dual licensed under the MIT and GPL licenses.
// http://benalman.com/about/license/
//
// About: Examples
//
// This working example, complete with fully commented code, illustrates a few
// ways in which this plugin can be used.
//
// resize event - http://benalman.com/code/projects/jquery-resize/examples/resize/
//
// About: Support and Testing
//
// Information about what version or versions of jQuery this plugin has been
// tested with, what browsers it has been tested in, and where the unit tests
// reside (so you can test it yourself).
//
// jQuery Versions - 1.3.2, 1.4.1, 1.4.2
// Browsers Tested - Internet Explorer 6-8, Firefox 2-3.6, Safari 3-4, Chrome, Opera 9.6-10.1.
// Unit Tests      - http://benalman.com/code/projects/jquery-resize/unit/
//
// About: Release History
//
// 1.1 - (3/14/2010) Fixed a minor bug that was causing the event to trigger
//       immediately after bind in some circumstances. Also changed $.fn.data
//       to $.data to improve performance.
// 1.0 - (2/10/2010) Initial release

(function($,window,undefined){
  '$:nomunge'; // Used by YUI compressor.

  // A jQuery object containing all non-window elements to which the resize
  // event is bound.
  var elems = $([]),

    // Extend $.resize if it already exists, otherwise create it.
    jq_resize = $.resize = $.extend( $.resize, {} ),

    timeout_id,

    // Reused strings.
    str_setTimeout = 'setTimeout',
    str_resize = 'resize',
    str_data = str_resize + '-special-event',
    str_delay = 'delay',
    str_throttle = 'throttleWindow';

  // Property: jQuery.resize.delay
  //
  // The numeric interval (in milliseconds) at which the resize event polling
  // loop executes. Defaults to 250.

  jq_resize[ str_delay ] = 250;

  // Property: jQuery.resize.throttleWindow
  //
  // Throttle the native window object resize event to fire no more than once
  // every <jQuery.resize.delay> milliseconds. Defaults to true.
  //
  // Because the window object has its own resize event, it doesn't need to be
  // provided by this plugin, and its execution can be left entirely up to the
  // browser. However, since certain browsers fire the resize event continuously
  // while others do not, enabling this will throttle the window resize event,
  // making event behavior consistent across all elements in all browsers.
  //
  // While setting this property to false will disable window object resize
  // event throttling, please note that this property must be changed before any
  // window object resize event callbacks are bound.

  jq_resize[ str_throttle ] = true;

  // Event: resize event
  //
  // Fired when an element's width or height changes. Because browsers only
  // provide this event for the window element, for other elements a polling
  // loop is initialized, running every <jQuery.resize.delay> milliseconds
  // to see if elements' dimensions have changed. You may bind with either
  // .resize( fn ) or .bind( "resize", fn ), and unbind with .unbind( "resize" ).
  //
  // Usage:
  //
  // > jQuery('selector').bind( 'resize', function(e) {
  // >   // element's width or height has changed!
  // >   ...
  // > });
  //
  // Additional Notes:
  //
  // * The polling loop is not created until at least one callback is actually
  //   bound to the 'resize' event, and this single polling loop is shared
  //   across all elements.
  //
  // Double firing issue in jQuery 1.3.2:
  //
  // While this plugin works in jQuery 1.3.2, if an element's event callbacks
  // are manually triggered via .trigger( 'resize' ) or .resize() those
  // callbacks may double-fire, due to limitations in the jQuery 1.3.2 special
  // events system. This is not an issue when using jQuery 1.4+.
  //
  // > // While this works in jQuery 1.4+
  // > $(elem).css({ width: new_w, height: new_h }).resize();
  // >
  // > // In jQuery 1.3.2, you need to do this:
  // > var elem = $(elem);
  // > elem.css({ width: new_w, height: new_h });
  // > elem.data( 'resize-special-event', { width: elem.width(), height: elem.height() } );
  // > elem.resize();

  $.event.special[ str_resize ] = {

    // Called only when the first 'resize' event callback is bound per element.
    setup: function() {
      // Since window has its own native 'resize' event, return false so that
      // jQuery will bind the event using DOM methods. Since only 'window'
      // objects have a .setTimeout method, this should be a sufficient test.
      // Unless, of course, we're throttling the 'resize' event for window.
      if ( !jq_resize[ str_throttle ] && this[ str_setTimeout ] ) { return false; }

      var elem = $(this);

      // Add this element to the list of internal elements to monitor.
      elems = elems.add( elem );

      // Initialize data store on the element.
      $.data( this, str_data, { w: elem.width(), h: elem.height() } );

      // If this is the first element added, start the polling loop.
      if ( elems.length === 1 ) {
        loopy();
      }
    },

    // Called only when the last 'resize' event callback is unbound per element.
    teardown: function() {
      // Since window has its own native 'resize' event, return false so that
      // jQuery will unbind the event using DOM methods. Since only 'window'
      // objects have a .setTimeout method, this should be a sufficient test.
      // Unless, of course, we're throttling the 'resize' event for window.
      if ( !jq_resize[ str_throttle ] && this[ str_setTimeout ] ) { return false; }

      var elem = $(this);

      // Remove this element from the list of internal elements to monitor.
      elems = elems.not( elem );

      // Remove any data stored on the element.
      elem.removeData( str_data );

      // If this is the last element removed, stop the polling loop.
      if ( !elems.length ) {
        clearTimeout( timeout_id );
      }
    },

    // Called every time a 'resize' event callback is bound per element (new in
    // jQuery 1.4).
    add: function( handleObj ) {
      // Since window has its own native 'resize' event, return false so that
      // jQuery doesn't modify the event object. Unless, of course, we're
      // throttling the 'resize' event for window.
      if ( !jq_resize[ str_throttle ] && this[ str_setTimeout ] ) { return false; }

      var old_handler;

      // The new_handler function is executed every time the event is triggered.
      // This is used to update the internal element data store with the width
      // and height when the event is triggered manually, to avoid double-firing
      // of the event callback. See the "Double firing issue in jQuery 1.3.2"
      // comments above for more information.

      function new_handler( e, w, h ) {
        var elem = $(this),
          data = $.data( this, str_data );

        // If called from the polling loop, w and h will be passed in as
        // arguments. If called manually, via .trigger( 'resize' ) or .resize(),
        // those values will need to be computed.
        data.w = w !== undefined ? w : elem.width();
        data.h = h !== undefined ? h : elem.height();

        old_handler.apply( this, arguments );
      };

      // This may seem a little complicated, but it normalizes the special event
      // .add method between jQuery 1.4/1.4.1 and 1.4.2+
      if ( $.isFunction( handleObj ) ) {
        // 1.4, 1.4.1
        old_handler = handleObj;
        return new_handler;
      } else {
        // 1.4.2+
        old_handler = handleObj.handler;
        handleObj.handler = new_handler;
      }
    }

  };

  function loopy() {

    // Start the polling loop, asynchronously.
    timeout_id = window[ str_setTimeout ](function(){

      // Iterate over all elements to which the 'resize' event is bound.
      elems.each(function(){
        var elem = $(this),
          width = elem.width(),
          height = elem.height(),
          data = $.data( this, str_data );

        // if data not exists, then elem might has been removed.
        if (!data) {
            elems.splice($.inArray(this, elems), 1);
            return;
        }

        // If element size has changed since the last time, update the element
        // data store and trigger the 'resize' event.
        if ( width !== data.w || height !== data.h ) {
          elem.trigger( str_resize, [ data.w = width, data.h = height ] );
        }

      });

      // Loop.
      loopy();

    }, jq_resize[ str_delay ] );
  }

  // Allow binding directly to the browser's window's resize event,
  // without disabling throttling
  $.event.special[ 'windowResize' ] = {

    add: function( handleObj ) {
      var elem = this, elemData = jQuery._data( elem );
      if ( elem.addEventListener ) {
        elem.addEventListener( "resize", handleObj.handler, false );

      } else if ( elem.attachEvent ) {
        elem.attachEvent( "onresize", handleObj.handler );
      }
    }
  };

})(jQuery,this);

/*            'js/jquery.form.js',*/
/*!
 * jQuery Form Plugin
 * version: 3.18 (28-SEP-2012)
 * @requires jQuery v1.5 or later
 *
 * Examples and documentation at: http://malsup.com/jquery/form/
 * Project repository: https://github.com/malsup/form
 * Dual licensed under the MIT and GPL licenses:
 *    http://malsup.github.com/mit-license.txt
 *    http://malsup.github.com/gpl-license-v2.txt
 */
/*global ActiveXObject alert */
;(function($) {
"use strict";

/*
    Usage Note:
    -----------
    Do not use both ajaxSubmit and ajaxForm on the same form.  These
    functions are mutually exclusive.  Use ajaxSubmit if you want
    to bind your own submit handler to the form.  For example,

    $(document).ready(function() {
        $('#myForm').on('submit', function(e) {
            e.preventDefault(); // <-- important
            $(this).ajaxSubmit({
                target: '#output'
            });
        });
    });

    Use ajaxForm when you want the plugin to manage all the event binding
    for you.  For example,

    $(document).ready(function() {
        $('#myForm').ajaxForm({
            target: '#output'
        });
    });
    
    You can also use ajaxForm with delegation (requires jQuery v1.7+), so the
    form does not have to exist when you invoke ajaxForm:

    $('#myForm').ajaxForm({
        delegation: true,
        target: '#output'
    });
    
    When using ajaxForm, the ajaxSubmit function will be invoked for you
    at the appropriate time.
*/

/**
 * Feature detection
 */
var feature = {};
feature.fileapi = $("<input type='file'/>").get(0).files !== undefined;
feature.formdata = window.FormData !== undefined;

/**
 * ajaxSubmit() provides a mechanism for immediately submitting
 * an HTML form using AJAX.
 */
$.fn.ajaxSubmit = function(options) {
    /*jshint scripturl:true */

    // fast fail if nothing selected (http://dev.jquery.com/ticket/2752)
    if (!this.length) {
        log('ajaxSubmit: skipping submit process - no element selected');
        return this;
    }
    
    var method, action, url, $form = this;

    if (typeof options == 'function') {
        options = { success: options };
    }

    method = this.attr('method');
    action = this.attr('action');
    url = (typeof action === 'string') ? $.trim(action) : '';
    url = url || window.location.href || '';
    if (url) {
        // clean url (don't include hash vaue)
        url = (url.match(/^([^#]+)/)||[])[1];
    }

    options = $.extend(true, {
        url:  url,
        success: $.ajaxSettings.success,
        type: method || 'GET',
        iframeSrc: /^https/i.test(window.location.href || '') ? 'javascript:false' : 'about:blank'
    }, options);

    // hook for manipulating the form data before it is extracted;
    // convenient for use with rich editors like tinyMCE or FCKEditor
    var veto = {};
    this.trigger('form-pre-serialize', [this, options, veto]);
    if (veto.veto) {
        log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');
        return this;
    }

    // provide opportunity to alter form data before it is serialized
    if (options.beforeSerialize && options.beforeSerialize(this, options) === false) {
        log('ajaxSubmit: submit aborted via beforeSerialize callback');
        return this;
    }

    var traditional = options.traditional;
    if ( traditional === undefined ) {
        traditional = $.ajaxSettings.traditional;
    }
    
    var elements = [];
    var qx, a = this.formToArray(options.semantic, elements);
    if (options.data) {
        options.extraData = options.data;
        qx = $.param(options.data, traditional);
    }

    // give pre-submit callback an opportunity to abort the submit
    if (options.beforeSubmit && options.beforeSubmit(a, this, options) === false) {
        log('ajaxSubmit: submit aborted via beforeSubmit callback');
        return this;
    }

    // fire vetoable 'validate' event
    this.trigger('form-submit-validate', [a, this, options, veto]);
    if (veto.veto) {
        log('ajaxSubmit: submit vetoed via form-submit-validate trigger');
        return this;
    }

    var q = $.param(a, traditional);
    if (qx) {
        q = ( q ? (q + '&' + qx) : qx );
    }    
    if (options.type.toUpperCase() == 'GET') {
        options.url += (options.url.indexOf('?') >= 0 ? '&' : '?') + q;
        options.data = null;  // data is null for 'get'
    }
    else {
        options.data = q; // data is the query string for 'post'
    }

    var callbacks = [];
    if (options.resetForm) {
        callbacks.push(function() { $form.resetForm(); });
    }
    if (options.clearForm) {
        callbacks.push(function() { $form.clearForm(options.includeHidden); });
    }

    // perform a load on the target only if dataType is not provided
    if (!options.dataType && options.target) {
        var oldSuccess = options.success || function(){};
        callbacks.push(function(data) {
            var fn = options.replaceTarget ? 'replaceWith' : 'html';
            $(options.target)[fn](data).each(oldSuccess, arguments);
        });
    }
    else if (options.success) {
        callbacks.push(options.success);
    }

    options.success = function(data, status, xhr) { // jQuery 1.4+ passes xhr as 3rd arg
        var context = options.context || this ;    // jQuery 1.4+ supports scope context 
        for (var i=0, max=callbacks.length; i < max; i++) {
            callbacks[i].apply(context, [data, status, xhr || $form, $form]);
        }
    };

    // are there files to upload?
    var fileInputs = $('input:file:enabled[value]', this); // [value] (issue #113)
    var hasFileInputs = fileInputs.length > 0;
    var mp = 'multipart/form-data';
    var multipart = ($form.attr('enctype') == mp || $form.attr('encoding') == mp);

    var fileAPI = feature.fileapi && feature.formdata;
    log("fileAPI :" + fileAPI);
    var shouldUseFrame = (hasFileInputs || multipart) && !fileAPI;

    var jqxhr;

    // options.iframe allows user to force iframe mode
    // 06-NOV-09: now defaulting to iframe mode if file input is detected
    if (options.iframe !== false && (options.iframe || shouldUseFrame)) {
        // hack to fix Safari hang (thanks to Tim Molendijk for this)
        // see:  http://groups.google.com/group/jquery-dev/browse_thread/thread/36395b7ab510dd5d
        if (options.closeKeepAlive) {
            $.get(options.closeKeepAlive, function() {
                jqxhr = fileUploadIframe(a);
            });
        }
        else {
            jqxhr = fileUploadIframe(a);
        }
    }
    else if ((hasFileInputs || multipart) && fileAPI) {
        jqxhr = fileUploadXhr(a);
    }
    else {
        jqxhr = $.ajax(options);
    }

    $form.removeData('jqxhr').data('jqxhr', jqxhr);

    // clear element array
    for (var k=0; k < elements.length; k++)
        elements[k] = null;

    // fire 'notify' event
    this.trigger('form-submit-notify', [this, options]);
    return this;

    // utility fn for deep serialization
    function deepSerialize(extraData){
        var serialized = $.param(extraData).split('&');
        var len = serialized.length;
        var result = {};
        var i, part;
        for (i=0; i < len; i++) {
            part = serialized[i].split('=');
            result[decodeURIComponent(part[0])] = decodeURIComponent(part[1]);
        }
        return result;
    }

     // XMLHttpRequest Level 2 file uploads (big hat tip to francois2metz)
    function fileUploadXhr(a) {
        var formdata = new FormData();

        for (var i=0; i < a.length; i++) {
            formdata.append(a[i].name, a[i].value);
        }

        if (options.extraData) {
            var serializedData = deepSerialize(options.extraData);
            for (var p in serializedData)
                if (serializedData.hasOwnProperty(p))
                    formdata.append(p, serializedData[p]);
        }

        options.data = null;

        var s = $.extend(true, {}, $.ajaxSettings, options, {
            contentType: false,
            processData: false,
            cache: false,
            type: method || 'POST'
        });
        
        if (options.uploadProgress) {
            // workaround because jqXHR does not expose upload property
            s.xhr = function() {
                var xhr = jQuery.ajaxSettings.xhr();
                if (xhr.upload) {
                    xhr.upload.onprogress = function(event) {
                        var percent = 0;
                        var position = event.loaded || event.position; /*event.position is deprecated*/
                        var total = event.total;
                        if (event.lengthComputable) {
                            percent = Math.ceil(position / total * 100);
                        }
                        options.uploadProgress(event, position, total, percent);
                    };
                }
                return xhr;
            };
        }

        s.data = null;
            var beforeSend = s.beforeSend;
            s.beforeSend = function(xhr, o) {
                o.data = formdata;
                if(beforeSend)
                    beforeSend.call(this, xhr, o);
        };
        return $.ajax(s);
    }

    // private function for handling file uploads (hat tip to YAHOO!)
    function fileUploadIframe(a) {
        var form = $form[0], el, i, s, g, id, $io, io, xhr, sub, n, timedOut, timeoutHandle;
        var useProp = !!$.fn.prop;
        var deferred = $.Deferred();

        if ($(':input[name=submit],:input[id=submit]', form).length) {
            // if there is an input with a name or id of 'submit' then we won't be
            // able to invoke the submit fn on the form (at least not x-browser)
            alert('Error: Form elements must not have name or id of "submit".');
            deferred.reject();
            return deferred;
        }
        
        if (a) {
            // ensure that every serialized input is still enabled
            for (i=0; i < elements.length; i++) {
                el = $(elements[i]);
                if ( useProp )
                    el.prop('disabled', false);
                else
                    el.removeAttr('disabled');
            }
        }

        s = $.extend(true, {}, $.ajaxSettings, options);
        s.context = s.context || s;
        id = 'jqFormIO' + (new Date().getTime());
        if (s.iframeTarget) {
            $io = $(s.iframeTarget);
            n = $io.attr('name');
            if (!n)
                 $io.attr('name', id);
            else
                id = n;
        }
        else {
            $io = $('<iframe name="' + id + '" src="'+ s.iframeSrc +'" />');
            $io.css({ position: 'absolute', top: '-1000px', left: '-1000px' });
        }
        io = $io[0];


        xhr = { // mock object
            aborted: 0,
            responseText: null,
            responseXML: null,
            status: 0,
            statusText: 'n/a',
            getAllResponseHeaders: function() {},
            getResponseHeader: function() {},
            setRequestHeader: function() {},
            abort: function(status) {
                var e = (status === 'timeout' ? 'timeout' : 'aborted');
                log('aborting upload... ' + e);
                this.aborted = 1;
                // #214
                if (io.contentWindow.document.execCommand) {
                    try { // #214
                        io.contentWindow.document.execCommand('Stop');
                    } catch(ignore) {}
                }
                $io.attr('src', s.iframeSrc); // abort op in progress
                xhr.error = e;
                if (s.error)
                    s.error.call(s.context, xhr, e, status);
                if (g)
                    $.event.trigger("ajaxError", [xhr, s, e]);
                if (s.complete)
                    s.complete.call(s.context, xhr, e);
            }
        };

        g = s.global;
        // trigger ajax global events so that activity/block indicators work like normal
        if (g && 0 === $.active++) {
            $.event.trigger("ajaxStart");
        }
        if (g) {
            $.event.trigger("ajaxSend", [xhr, s]);
        }

        if (s.beforeSend && s.beforeSend.call(s.context, xhr, s) === false) {
            if (s.global) {
                $.active--;
            }
            deferred.reject();
            return deferred;
        }
        if (xhr.aborted) {
            deferred.reject();
            return deferred;
        }

        // add submitting element to data if we know it
        sub = form.clk;
        if (sub) {
            n = sub.name;
            if (n && !sub.disabled) {
                s.extraData = s.extraData || {};
                s.extraData[n] = sub.value;
                if (sub.type == "image") {
                    s.extraData[n+'.x'] = form.clk_x;
                    s.extraData[n+'.y'] = form.clk_y;
                }
            }
        }
        
        var CLIENT_TIMEOUT_ABORT = 1;
        var SERVER_ABORT = 2;

        function getDoc(frame) {
            var doc = frame.contentWindow ? frame.contentWindow.document : frame.contentDocument ? frame.contentDocument : frame.document;
            return doc;
        }
        
        // Rails CSRF hack (thanks to Yvan Barthelemy)
        var csrf_token = $('meta[name=csrf-token]').attr('content');
        var csrf_param = $('meta[name=csrf-param]').attr('content');
        if (csrf_param && csrf_token) {
            s.extraData = s.extraData || {};
            s.extraData[csrf_param] = csrf_token;
        }

        // take a breath so that pending repaints get some cpu time before the upload starts
        function doSubmit() {
            // make sure form attrs are set
            var t = $form.attr('target'), a = $form.attr('action');

            // update form attrs in IE friendly way
            form.setAttribute('target',id);
            if (!method) {
                form.setAttribute('method', 'POST');
            }
            if (a != s.url) {
                form.setAttribute('action', s.url);
            }

            // ie borks in some cases when setting encoding
            if (! s.skipEncodingOverride && (!method || /post/i.test(method))) {
                $form.attr({
                    encoding: 'multipart/form-data',
                    enctype:  'multipart/form-data'
                });
            }

            // support timout
            if (s.timeout) {
                timeoutHandle = setTimeout(function() { timedOut = true; cb(CLIENT_TIMEOUT_ABORT); }, s.timeout);
            }
            
            // look for server aborts
            function checkState() {
                try {
                    var state = getDoc(io).readyState;
                    log('state = ' + state);
                    if (state && state.toLowerCase() == 'uninitialized')
                        setTimeout(checkState,50);
                }
                catch(e) {
                    log('Server abort: ' , e, ' (', e.name, ')');
                    cb(SERVER_ABORT);
                    if (timeoutHandle)
                        clearTimeout(timeoutHandle);
                    timeoutHandle = undefined;
                }
            }

            // add "extra" data to form if provided in options
            var extraInputs = [];
            try {
                if (s.extraData) {
                    for (var n in s.extraData) {
                        if (s.extraData.hasOwnProperty(n)) {
                           // if using the $.param format that allows for multiple values with the same name
                           if($.isPlainObject(s.extraData[n]) && s.extraData[n].hasOwnProperty('name') && s.extraData[n].hasOwnProperty('value')) {
                               extraInputs.push(
                               $('<input type="hidden" name="'+s.extraData[n].name+'">').attr('value',s.extraData[n].value)
                                   .appendTo(form)[0]);
                           } else {
                               extraInputs.push(
                               $('<input type="hidden" name="'+n+'">').attr('value',s.extraData[n])
                                   .appendTo(form)[0]);
                           }
                        }
                    }
                }

                if (!s.iframeTarget) {
                    // add iframe to doc and submit the form
                    $io.appendTo('body');
                    if (io.attachEvent)
                        io.attachEvent('onload', cb);
                    else
                        io.addEventListener('load', cb, false);
                }
                setTimeout(checkState,15);
                form.submit();
            }
            finally {
                // reset attrs and remove "extra" input elements
                form.setAttribute('action',a);
                if(t) {
                    form.setAttribute('target', t);
                } else {
                    $form.removeAttr('target');
                }
                $(extraInputs).remove();
            }
        }

        if (s.forceSync) {
            doSubmit();
        }
        else {
            setTimeout(doSubmit, 10); // this lets dom updates render
        }

        var data, doc, domCheckCount = 50, callbackProcessed;

        function cb(e) {
            if (xhr.aborted || callbackProcessed) {
                return;
            }
            try {
                doc = getDoc(io);
            }
            catch(ex) {
                log('cannot access response document: ', ex);
                e = SERVER_ABORT;
            }
            if (e === CLIENT_TIMEOUT_ABORT && xhr) {
                xhr.abort('timeout');
                deferred.reject(xhr, 'timeout');
                return;
            }
            else if (e == SERVER_ABORT && xhr) {
                xhr.abort('server abort');
                deferred.reject(xhr, 'error', 'server abort');
                return;
            }

            if (!doc || doc.location.href == s.iframeSrc) {
                // response not received yet
                if (!timedOut)
                    return;
            }
            if (io.detachEvent)
                io.detachEvent('onload', cb);
            else    
                io.removeEventListener('load', cb, false);

            var status = 'success', errMsg;
            try {
                if (timedOut) {
                    throw 'timeout';
                }

                var isXml = s.dataType == 'xml' || doc.XMLDocument || $.isXMLDoc(doc);
                log('isXml='+isXml);
                if (!isXml && window.opera && (doc.body === null || !doc.body.innerHTML)) {
                    if (--domCheckCount) {
                        // in some browsers (Opera) the iframe DOM is not always traversable when
                        // the onload callback fires, so we loop a bit to accommodate
                        log('requeing onLoad callback, DOM not available');
                        setTimeout(cb, 250);
                        return;
                    }
                    // let this fall through because server response could be an empty document
                    //log('Could not access iframe DOM after mutiple tries.');
                    //throw 'DOMException: not available';
                }

                //log('response detected');
                var docRoot = doc.body ? doc.body : doc.documentElement;
                xhr.responseText = docRoot ? docRoot.innerHTML : null;
                xhr.responseXML = doc.XMLDocument ? doc.XMLDocument : doc;
                if (isXml)
                    s.dataType = 'xml';
                xhr.getResponseHeader = function(header){
                    var headers = {'content-type': s.dataType};
                    return headers[header];
                };
                // support for XHR 'status' & 'statusText' emulation :
                if (docRoot) {
                    xhr.status = Number( docRoot.getAttribute('status') ) || xhr.status;
                    xhr.statusText = docRoot.getAttribute('statusText') || xhr.statusText;
                }

                var dt = (s.dataType || '').toLowerCase();
                var scr = /(json|script|text)/.test(dt);
                if (scr || s.textarea) {
                    // see if user embedded response in textarea
                    var ta = doc.getElementsByTagName('textarea')[0];
                    if (ta) {
                        xhr.responseText = ta.value;
                        // support for XHR 'status' & 'statusText' emulation :
                        xhr.status = Number( ta.getAttribute('status') ) || xhr.status;
                        xhr.statusText = ta.getAttribute('statusText') || xhr.statusText;
                    }
                    else if (scr) {
                        // account for browsers injecting pre around json response
                        var pre = doc.getElementsByTagName('pre')[0];
                        var b = doc.getElementsByTagName('body')[0];
                        if (pre) {
                            xhr.responseText = pre.textContent ? pre.textContent : pre.innerText;
                        }
                        else if (b) {
                            xhr.responseText = b.textContent ? b.textContent : b.innerText;
                        }
                    }
                }
                else if (dt == 'xml' && !xhr.responseXML && xhr.responseText) {
                    xhr.responseXML = toXml(xhr.responseText);
                }

                try {
                    data = httpData(xhr, dt, s);
                }
                catch (e) {
                    status = 'parsererror';
                    xhr.error = errMsg = (e || status);
                }
            }
            catch (e) {
                log('error caught: ',e);
                status = 'error';
                xhr.error = errMsg = (e || status);
            }

            if (xhr.aborted) {
                log('upload aborted');
                status = null;
            }

            if (xhr.status) { // we've set xhr.status
                status = (xhr.status >= 200 && xhr.status < 300 || xhr.status === 304) ? 'success' : 'error';
            }

            // ordering of these callbacks/triggers is odd, but that's how $.ajax does it
            if (status === 'success') {
                if (s.success)
                    s.success.call(s.context, data, 'success', xhr);
                deferred.resolve(xhr.responseText, 'success', xhr);
                if (g)
                    $.event.trigger("ajaxSuccess", [xhr, s]);
            }
            else if (status) {
                if (errMsg === undefined)
                    errMsg = xhr.statusText;
                if (s.error)
                    s.error.call(s.context, xhr, status, errMsg);
                deferred.reject(xhr, 'error', errMsg);
                if (g)
                    $.event.trigger("ajaxError", [xhr, s, errMsg]);
            }

            if (g)
                $.event.trigger("ajaxComplete", [xhr, s]);

            if (g && ! --$.active) {
                $.event.trigger("ajaxStop");
            }

            if (s.complete)
                s.complete.call(s.context, xhr, status);

            callbackProcessed = true;
            if (s.timeout)
                clearTimeout(timeoutHandle);

            // clean up
            setTimeout(function() {
                if (!s.iframeTarget)
                    $io.remove();
                xhr.responseXML = null;
            }, 100);
        }

        var toXml = $.parseXML || function(s, doc) { // use parseXML if available (jQuery 1.5+)
            if (window.ActiveXObject) {
                doc = new ActiveXObject('Microsoft.XMLDOM');
                doc.async = 'false';
                doc.loadXML(s);
            }
            else {
                doc = (new DOMParser()).parseFromString(s, 'text/xml');
            }
            return (doc && doc.documentElement && doc.documentElement.nodeName != 'parsererror') ? doc : null;
        };
        var parseJSON = $.parseJSON || function(s) {
            /*jslint evil:true */
            return window['eval']('(' + s + ')');
        };

        var httpData = function( xhr, type, s ) { // mostly lifted from jq1.4.4

            var ct = xhr.getResponseHeader('content-type') || '',
                xml = type === 'xml' || !type && ct.indexOf('xml') >= 0,
                data = xml ? xhr.responseXML : xhr.responseText;

            if (xml && data.documentElement.nodeName === 'parsererror') {
                if ($.error)
                    $.error('parsererror');
            }
            if (s && s.dataFilter) {
                data = s.dataFilter(data, type);
            }
            if (typeof data === 'string') {
                if (type === 'json' || !type && ct.indexOf('json') >= 0) {
                    data = parseJSON(data);
                } else if (type === "script" || !type && ct.indexOf("javascript") >= 0) {
                    $.globalEval(data);
                }
            }
            return data;
        };

        return deferred;
    }
};

/**
 * ajaxForm() provides a mechanism for fully automating form submission.
 *
 * The advantages of using this method instead of ajaxSubmit() are:
 *
 * 1: This method will include coordinates for <input type="image" /> elements (if the element
 *    is used to submit the form).
 * 2. This method will include the submit element's name/value data (for the element that was
 *    used to submit the form).
 * 3. This method binds the submit() method to the form for you.
 *
 * The options argument for ajaxForm works exactly as it does for ajaxSubmit.  ajaxForm merely
 * passes the options argument along after properly binding events for submit elements and
 * the form itself.
 */
$.fn.ajaxForm = function(options) {
    options = options || {};
    options.delegation = options.delegation && $.isFunction($.fn.on);
    
    // in jQuery 1.3+ we can fix mistakes with the ready state
    if (!options.delegation && this.length === 0) {
        var o = { s: this.selector, c: this.context };
        if (!$.isReady && o.s) {
            log('DOM not ready, queuing ajaxForm');
            $(function() {
                $(o.s,o.c).ajaxForm(options);
            });
            return this;
        }
        // is your DOM ready?  http://docs.jquery.com/Tutorials:Introducing_$(document).ready()
        log('terminating; zero elements found by selector' + ($.isReady ? '' : ' (DOM not ready)'));
        return this;
    }

    if ( options.delegation ) {
        $(document)
            .off('submit.form-plugin', this.selector, doAjaxSubmit)
            .off('click.form-plugin', this.selector, captureSubmittingElement)
            .on('submit.form-plugin', this.selector, options, doAjaxSubmit)
            .on('click.form-plugin', this.selector, options, captureSubmittingElement);
        return this;
    }

    return this.ajaxFormUnbind()
        .bind('submit.form-plugin', options, doAjaxSubmit)
        .bind('click.form-plugin', options, captureSubmittingElement);
};

// private event handlers    
function doAjaxSubmit(e) {
    /*jshint validthis:true */
    var options = e.data;
    if (!e.isDefaultPrevented()) { // if event has been canceled, don't proceed
        e.preventDefault();
        $(this).ajaxSubmit(options);
    }
}
    
function captureSubmittingElement(e) {
    /*jshint validthis:true */
    var target = e.target;
    var $el = $(target);
    if (!($el.is(":submit,input:image"))) {
        // is this a child element of the submit el?  (ex: a span within a button)
        var t = $el.closest(':submit');
        if (t.length === 0) {
            return;
        }
        target = t[0];
    }
    var form = this;
    form.clk = target;
    if (target.type == 'image') {
        if (e.offsetX !== undefined) {
            form.clk_x = e.offsetX;
            form.clk_y = e.offsetY;
        } else if (typeof $.fn.offset == 'function') {
            var offset = $el.offset();
            form.clk_x = e.pageX - offset.left;
            form.clk_y = e.pageY - offset.top;
        } else {
            form.clk_x = e.pageX - target.offsetLeft;
            form.clk_y = e.pageY - target.offsetTop;
        }
    }
    // clear form vars
    setTimeout(function() { form.clk = form.clk_x = form.clk_y = null; }, 100);
}


// ajaxFormUnbind unbinds the event handlers that were bound by ajaxForm
$.fn.ajaxFormUnbind = function() {
    return this.unbind('submit.form-plugin click.form-plugin');
};

/**
 * formToArray() gathers form element data into an array of objects that can
 * be passed to any of the following ajax functions: $.get, $.post, or load.
 * Each object in the array has both a 'name' and 'value' property.  An example of
 * an array for a simple login form might be:
 *
 * [ { name: 'username', value: 'jresig' }, { name: 'password', value: 'secret' } ]
 *
 * It is this array that is passed to pre-submit callback functions provided to the
 * ajaxSubmit() and ajaxForm() methods.
 */
$.fn.formToArray = function(semantic, elements) {
    var a = [];
    if (this.length === 0) {
        return a;
    }

    var form = this[0];
    var els = semantic ? form.getElementsByTagName('*') : form.elements;
    if (!els) {
        return a;
    }

    var i,j,n,v,el,max,jmax;
    for(i=0, max=els.length; i < max; i++) {
        el = els[i];
        n = el.name;
        if (!n) {
            continue;
        }

        if (semantic && form.clk && el.type == "image") {
            // handle image inputs on the fly when semantic == true
            if(!el.disabled && form.clk == el) {
                a.push({name: n, value: $(el).val(), type: el.type });
                a.push({name: n+'.x', value: form.clk_x}, {name: n+'.y', value: form.clk_y});
            }
            continue;
        }

        v = $.fieldValue(el, true);
        if (v && v.constructor == Array) {
            if (elements) 
                elements.push(el);
            for(j=0, jmax=v.length; j < jmax; j++) {
                a.push({name: n, value: v[j]});
            }
        }
        else if (feature.fileapi && el.type == 'file' && !el.disabled) {
            if (elements) 
                elements.push(el);
            var files = el.files;
            if (files.length) {
                for (j=0; j < files.length; j++) {
                    a.push({name: n, value: files[j], type: el.type});
                }
            }
            else {
                // #180
                a.push({ name: n, value: '', type: el.type });
            }
        }
        else if (v !== null && typeof v != 'undefined') {
            if (elements) 
                elements.push(el);
            a.push({name: n, value: v, type: el.type, required: el.required});
        }
    }

    if (!semantic && form.clk) {
        // input type=='image' are not found in elements array! handle it here
        var $input = $(form.clk), input = $input[0];
        n = input.name;
        if (n && !input.disabled && input.type == 'image') {
            a.push({name: n, value: $input.val()});
            a.push({name: n+'.x', value: form.clk_x}, {name: n+'.y', value: form.clk_y});
        }
    }
    return a;
};

/**
 * Serializes form data into a 'submittable' string. This method will return a string
 * in the format: name1=value1&amp;name2=value2
 */
$.fn.formSerialize = function(semantic) {
    //hand off to jQuery.param for proper encoding
    return $.param(this.formToArray(semantic));
};

/**
 * Serializes all field elements in the jQuery object into a query string.
 * This method will return a string in the format: name1=value1&amp;name2=value2
 */
$.fn.fieldSerialize = function(successful) {
    var a = [];
    this.each(function() {
        var n = this.name;
        if (!n) {
            return;
        }
        var v = $.fieldValue(this, successful);
        if (v && v.constructor == Array) {
            for (var i=0,max=v.length; i < max; i++) {
                a.push({name: n, value: v[i]});
            }
        }
        else if (v !== null && typeof v != 'undefined') {
            a.push({name: this.name, value: v});
        }
    });
    //hand off to jQuery.param for proper encoding
    return $.param(a);
};

/**
 * Returns the value(s) of the element in the matched set.  For example, consider the following form:
 *
 *  <form><fieldset>
 *      <input name="A" type="text" />
 *      <input name="A" type="text" />
 *      <input name="B" type="checkbox" value="B1" />
 *      <input name="B" type="checkbox" value="B2"/>
 *      <input name="C" type="radio" value="C1" />
 *      <input name="C" type="radio" value="C2" />
 *  </fieldset></form>
 *
 *  var v = $(':text').fieldValue();
 *  // if no values are entered into the text inputs
 *  v == ['','']
 *  // if values entered into the text inputs are 'foo' and 'bar'
 *  v == ['foo','bar']
 *
 *  var v = $(':checkbox').fieldValue();
 *  // if neither checkbox is checked
 *  v === undefined
 *  // if both checkboxes are checked
 *  v == ['B1', 'B2']
 *
 *  var v = $(':radio').fieldValue();
 *  // if neither radio is checked
 *  v === undefined
 *  // if first radio is checked
 *  v == ['C1']
 *
 * The successful argument controls whether or not the field element must be 'successful'
 * (per http://www.w3.org/TR/html4/interact/forms.html#successful-controls).
 * The default value of the successful argument is true.  If this value is false the value(s)
 * for each element is returned.
 *
 * Note: This method *always* returns an array.  If no valid value can be determined the
 *    array will be empty, otherwise it will contain one or more values.
 */
$.fn.fieldValue = function(successful) {
    for (var val=[], i=0, max=this.length; i < max; i++) {
        var el = this[i];
        var v = $.fieldValue(el, successful);
        if (v === null || typeof v == 'undefined' || (v.constructor == Array && !v.length)) {
            continue;
        }
        if (v.constructor == Array)
            $.merge(val, v);
        else
            val.push(v);
    }
    return val;
};

/**
 * Returns the value of the field element.
 */
$.fieldValue = function(el, successful) {
    var n = el.name, t = el.type, tag = el.tagName.toLowerCase();
    if (successful === undefined) {
        successful = true;
    }

    if (successful && (!n || el.disabled || t == 'reset' || t == 'button' ||
        (t == 'checkbox' || t == 'radio') && !el.checked ||
        (t == 'submit' || t == 'image') && el.form && el.form.clk != el ||
        tag == 'select' && el.selectedIndex == -1)) {
            return null;
    }

    if (tag == 'select') {
        var index = el.selectedIndex;
        if (index < 0) {
            return null;
        }
        var a = [], ops = el.options;
        var one = (t == 'select-one');
        var max = (one ? index+1 : ops.length);
        for(var i=(one ? index : 0); i < max; i++) {
            var op = ops[i];
            if (op.selected) {
                var v = op.value;
                if (!v) { // extra pain for IE...
                    v = (op.attributes && op.attributes['value'] && !(op.attributes['value'].specified)) ? op.text : op.value;
                }
                if (one) {
                    return v;
                }
                a.push(v);
            }
        }
        return a;
    }
    return $(el).val();
};

/**
 * Clears the form data.  Takes the following actions on the form's input fields:
 *  - input text fields will have their 'value' property set to the empty string
 *  - select elements will have their 'selectedIndex' property set to -1
 *  - checkbox and radio inputs will have their 'checked' property set to false
 *  - inputs of type submit, button, reset, and hidden will *not* be effected
 *  - button elements will *not* be effected
 */
$.fn.clearForm = function(includeHidden) {
    return this.each(function() {
        $('input,select,textarea', this).clearFields(includeHidden);
    });
};

/**
 * Clears the selected form elements.
 */
$.fn.clearFields = $.fn.clearInputs = function(includeHidden) {
    var re = /^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i; // 'hidden' is not in this list
    return this.each(function() {
        var t = this.type, tag = this.tagName.toLowerCase();
        if (re.test(t) || tag == 'textarea') {
            this.value = '';
        }
        else if (t == 'checkbox' || t == 'radio') {
            this.checked = false;
        }
        else if (tag == 'select') {
            this.selectedIndex = -1;
        }
        else if (includeHidden) {
            // includeHidden can be the value true, or it can be a selector string
            // indicating a special test; for example:
            //  $('#myForm').clearForm('.special:hidden')
            // the above would clean hidden inputs that have the class of 'special'
            if ( (includeHidden === true && /hidden/.test(t)) ||
                 (typeof includeHidden == 'string' && $(this).is(includeHidden)) )
                this.value = '';
        }
    });
};

/**
 * Resets the form data.  Causes all form elements to be reset to their original value.
 */
$.fn.resetForm = function() {
    return this.each(function() {
        // guard against an input with the name of 'reset'
        // note that IE reports the reset function as an 'object'
        if (typeof this.reset == 'function' || (typeof this.reset == 'object' && !this.reset.nodeType)) {
            this.reset();
        }
    });
};

/**
 * Enables or disables any matching elements.
 */
$.fn.enable = function(b) {
    if (b === undefined) {
        b = true;
    }
    return this.each(function() {
        this.disabled = !b;
    });
};

/**
 * Checks/unchecks any matching checkboxes or radio buttons and
 * selects/deselects and matching option elements.
 */
$.fn.selected = function(select) {
    if (select === undefined) {
        select = true;
    }
    return this.each(function() {
        var t = this.type;
        if (t == 'checkbox' || t == 'radio') {
            this.checked = select;
        }
        else if (this.tagName.toLowerCase() == 'option') {
            var $sel = $(this).parent('select');
            if (select && $sel[0] && $sel[0].type == 'select-one') {
                // deselect all other options
                $sel.find('option').selected(false);
            }
            this.selected = select;
        }
    });
};

// expose debug var
$.fn.ajaxSubmit.debug = false;

// helper fn for console logging
function log() {
    if (!$.fn.ajaxSubmit.debug) 
        return;
    var msg = '[jquery.form] ' + Array.prototype.join.call(arguments,'');
    if (window.console && window.console.log) {
        window.console.log(msg);
    }
    else if (window.opera && window.opera.postError) {
        window.opera.postError(msg);
    }
}

})(jQuery);

/*            'js/jquery_util.js',*/
/******************************
 jquery_util.js
 Init by J. Liu, Oct 2009
 Protection Profile Reorganization
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

/*global qed_strtbl,setQueryValue,fweb,escape,
fgt_lang,new_lang:true,$j:true*/

/* Resolve conflicts add $ for 552 js */
if (typeof jQuery != "undefined") $j = jQuery.noConflict();

var mixed_state_opacity = 0.3;

$j.fn.reverse = [].reverse;

$j.fn.check = function(checked)
{
    if (typeof checked == 'undefined') checked = true;
    return this.each(function()
    {
        if (typeof this.checked != 'undefined') this.checked = checked;
    });
};

$j.fn.uncheck = function()
{
    return this.check(false);
};

$j.fn.enable = function(enabled)
{
    if (typeof enabled == 'undefined') enabled = true;
    return this.each(function()
    {
        if (typeof this.disabled != 'undefined') this.disabled = !enabled;
        // update multiList state if this under multilist control
        if ($j(this).parent('.multiList-container:visible').length) {
            $j(this).multiList();
        }
    });
};

$j.fn.disable = function()
{
    return this.enable(false);
};

// sort element plugin, e.g. $j('tr', table).sortElements(cmp_callback)
$j.fn.sortElements = (function(){

    var sort = [].sort;

    return function(comparator) {

        return sort.call(this, comparator)
            .each(function() {
                this.parentNode.appendChild(this); });
    };

})();

// convert URL into a name/value pair array
$j.deserializeArray = function(url)
{
    var pairs = [];
    var pair_in_str, pairs_in_str;
    var i, len;

    if (typeof url === 'undefined' || url === "") return null;

    pairs_in_str = url.split("&");
    len = pairs_in_str.length;
    for (i = 0; i < len; i++)
    {
        if (pairs_in_str[i].length === 0) continue;
        pair_in_str = pairs_in_str[i].split("=");
        // suppose the URL is in escaped format
        pairs.push({"key": pair_in_str[0], "value": (pair_in_str.length >=2 ? decodeURIComponent(pair_in_str[1]) : "")});
    }
    return pairs;
};

// compose form elements (in string format) from name/value pairs
$j.deserialize = function(pairs, start, len)
{
    if (typeof pairs === 'undefined') return "";
    if (typeof start === 'undefined') start = 0;
    if (typeof len === 'undefined') len = pairs.length;
    var elts = [];
    var end = start + len;

    for (; start < end; start++)
    {
        var input = $j("<input />").attr({
            "type": "hidden",
            "name": pairs[start].key,
            "value": pairs[start].value
        });
        elts.push(input);
    }
    return elts;
};

// submit the url by form post request
$j.submitPOST = function(url)
{
    if (typeof url === 'undefined' || url === "") return false;

    //url = setQueryValue(url, 'CSRF_TOKEN', fweb.get_csrf_token());

    // "?" is a valid character in URL component, so don't use 'split' to parse URL here
    var comp_start = url.indexOf("?");
    var action = "";
    var comps = "";
    if (comp_start >=0)
    {
        action = url.substring(0, comp_start);
        comps = url.substring(comp_start + 1);
    }
    else
    {
        action = url;
    }

    var frag = document.createDocumentFragment();
    var form = $j("<form id='__post_submit'  method='post' action='" + action + "'></form>");
    // jQuery appendTo doesn't work with fragment
    frag.appendChild(form[0]);
    if (comps !== "")
    {
        // the elmts could be very big, which could cause trouble during composing string inside deserialize
        // so handle them in group
        var elmts = $j.deserializeArray(comps);
        var len = elmts.length;
        for (var start = 0; start < len; start += 1000)
        {
            var elts = $j.deserialize(elmts, start, len - start > 1000 ? 1000 : len - start);
            form.append(elts);
        }
    }
    // jQuery append doesn't work with fragment
    document.body.appendChild(frag);
    form.submit();
    return true;
};

$j.waitModalPrompt = function(wait_confirm, wait_msg)
{
    if (window.confirm(wait_confirm ? wait_confirm : qed_strtbl.wait_confirm))
    {
        var msg = "<div style='padding:25px;'><img src='/images/loading.gif'><span style=\"font-size:14px\"> " +
            (wait_msg ? wait_msg : qed_strtbl.wait_msg) + "</span></div>";
        return fweb.dialog(msg);
    }
    else
    {
        return false;
    }
};

// update image with specific size which can fit into it's container
$j.fn.updateImage = function(url)
{
    // absolute position so that image won't effect its parent
    $j(this).css("position", "absolute")
    .each(function() {
        var img = $j(this);

        var w = img.parent().width();
        var h = img.parent().height();

        var src = url || img.attr("url") || img.attr("src");
        src = setQueryValue(src, "w", w);
        src = setQueryValue(src, "h", h);
        src = setQueryValue(src, "q", Math.random());

        img.attr("src", src);

        var refresh = img.attr("refresh");
        if (refresh) {
            clearTimeout(img.data("timer"));
            img.data("timer", setTimeout(function() {
                img.updateImage();
            }, refresh * 1000));
        }
    });
};

$j.internationalizeLanguageEntries = function() {
    $j(document).internationalizeLanguageEntries();
};

$j.fn.internationalizeLanguageEntries = function() {
    var get_lang_entry = $j.getInfo;
    var attr_name = "lang_key";

    return this.each(function (e/*, i*/) {
        $j("[" + attr_name + "]", e).each( function() {
            var $obj = $j(this);
            var lang_key = $obj.attr(attr_name);
            var lang_val = get_lang_entry(lang_key);

            if (!lang_val) {
                lang_val = "#" + lang_key;
            }

            if ($obj.is(":input")) {
                $obj.val(lang_val);
            } else {
                $obj.html(lang_val);
            }
        });

        $j("[help_lang_key]", e).each( function() {
            var $obj = $j(this);
            var help_lang_val = get_lang_entry($obj.attr("help_lang_key"));
            $obj.attr("title", help_lang_val);
        });
    });
};

// simple, naive pre or post-order traversal of the DOM tree
$j.fn.walk = function(visit, post_order) {
    if(this.length === 0) { return; }
    this.each(function(i) {
        if (!post_order) {
            if (visit.call(this, i, this) === false) { return false; }
        }
        $j(this).children().walk(visit, post_order);
        if (post_order) { return visit.call(this, i, this); }
    });
};

// simple, in-order traversal of all text nodes in the tree
$j.fn.walkTextNodes = function(visit) {
    var parent = this, breakvar;
    this.each(function(i) {
        if (this.nodeType === 3 /*Node.TEXT_NODE*/) { breakvar = visit.call(this, i, parent, this); }
        else { breakvar = $j(this).contents().walkTextNodes(visit); }
        return breakvar;
    });
    return breakvar;
};

// similar to above function, but returns raw strings and combines
// sequential text nodes
$j.fn.walkTextChunks = function(visit) {
    var breakvar, currentText = '';
    this.each(function() {
        if (this.nodeType === 3 /*Node.TEXT_NODE*/) { currentText += this.nodeValue; }
        else {
            if (currentText !== '') {
                breakvar = visit(currentText);
                currentText = '';
                if (breakvar === false) { return false; }
            }
            breakvar = $j(this).contents().walkTextChunks(visit);
        }
        return breakvar;
    });
    if (breakvar === false) { return false; }
    return visit(currentText);
};


// js fix for element unable 100% height, element's parent's height must specified
// or use autoHeight on parent first
// related: elements set of which size change will effect on this element
$j.fn.autoHeight = function(related)
{
    var jo = jQuery(this);
    // skip if self not visible
    if (!jo.length || !jo.is(":visible")) return jo;

    // margin/border/padding not included
    var d = 0, n = 0;

    function init_vars() {
        d=jo.outerHeight(true) - jo.height();

        n=0;
        // summarize other siblings' total height
        jo.siblings(":visible").each(function() {
            // ignore those float/fix position elements
            if (jQuery(this).position().top < n) n = jQuery(this).position().top;
            // add up sibling's height
            n += jQuery(this).outerHeight(true);
        });
    }

    function resizeHeight()
    {
        init_vars();
        jo.show().height("");
        // component's height = parent's height - other's height - self's border/margin/padding
        var h = jo.parent().height() - d - n;
        if (h > 0)
        {
            // disable parent's y-scrolling prevent scroll bar show
            jo.parent().css("overflow-y", "hidden");
            jo.height(h);
        }
        else
        {
            jo.hide();
        }
    }

    init_vars();

    jQuery(related || window).resize(resizeHeight);

    resizeHeight();

    return jo;
};

// check if the first array is a subset of the second
// optional trim_first is used to trim elements before check
$j.isSubset = function(first_arr, second_arr, trim_first) {
    for (var i = 0; i < first_arr.length; ++i) {
        var elem = first_arr[i];
        if (trim_first) {
            elem = $j.trim(elem);
        }
        if ($j.inArray(elem, second_arr) != -1) {
            return true;
        }
    }
    return false;
};

// Pad a number to fixed width digits, default 2 digits.
$j.pad = function(number, width)
{
    var sn = number.toString();
    while (sn.length < (width || 2)) sn = '0' + sn;
    return sn;
};

$j.sortCompareText = function(a, b)
{
    return a.toLowerCase() > b.toLowerCase() || -(a != b);
};

$j.makeObject = function(array, getKey)
{
    var object = array && {};
    $j(array).each(function(i, val) {
        object[(getKey || function() { return this; })
            .call(this, i, val)] = this;
    });
    return object;
};

$j.prompt = function (msg, val, callback, title) {
    title = title || $j.getInfo('prompt_title');
    var dfd = new $j.Deferred();
    dfd.done(callback);
    var dialog = $j(['<div><p><label for="prompt_input">', msg, '</label></p>',
        '<p><input id="prompt_input" type="text" value="', val, '"></p></div>']
        .join(''));
    dialog.keyup(function(e) {
        if (e.keyCode == 13) {
            $j('.ui-dialog').find('button:first').trigger('click');
        }
    });
    dialog.dialog({'modal': true, 'title': title,
        'draggable': false, 'resizable': false,
        'buttons': [
            {text: $j.getInfo('ok'), click: function() {
                $j(this).dialog("close");
                dfd.resolve($j('#prompt_input').val());
                dialog.remove();
            }},
            {text: $j.getInfo('cancel'), click: function() {
                $j(this).dialog("close");
                dialog.remove();
            }}
        ]
    });
    return dfd.promise();
};

$j.alert = function (msg, spec) {
    spec = spec || {};
    var btn_txt = spec.btn_txt || $j.getInfo('ok');
    var icon = spec.icon || 'alert';
    var dialog = $j([
        '<div><p><span class="ui-icon ui-icon-' + icon + ' left-icon"></span>',
        msg,
        '</p></div>'].join('')
    ).css({
        "overflow": 'auto',
        "max-height": spec["max-height"],
        "max-width": spec["max-width"]
    });
    dialog.keyup(function(e) {
        if (e.keyCode == 13) {
            btns[$j.getInfo('ok')].call(dialog);
        }
    });
    var btns = {};
    btns[btn_txt] = function() {
        dlg_close();
    };
    fweb.dialog(dialog, $j.extend({
        'modal': true,
        'width': 'auto',
        'draggable': false,
        'resizable': false,
        'buttons': btns
    }, spec));
};

/**
 * Show a confirmation dialog
 *
 * @param {object|string} params - Configurations parameters. If a string is provided, it will
 *   simply be used as the message.
 * @param {string} params.message - The confirmation message.
 * @param {string} [params.title="Confirm"] - The dialog title.
 * @param {string} [params.css_class="warning_message"] - The CSS class that should be applied to
 *   the message container.
 * @param {string} [params.ok_text="OK"] - Confirm button label.
 * @param {string} [params.cancel_text="Cancel"] - cancel button label.
 * @param {string} [params.dialog_options] - jQuery dialog options to override.
 * @param {function} [callback] - A callback function to execute when the promise is resolved.
 * @return {jQuery promise}
 */
$j.confirm = function(params, callback) {
    var is_params = typeof params === 'object';
    var message = is_params ? params.message : params;
    var title = is_params && params.title ? params.title : $j.getInfo('confirm_title');
    var css_class = is_params && params.css_class ? params.css_class : 'warning_message';
    var ok_text = is_params && params.ok_text ? params.ok_text : $j.getInfo('ok');
    var cancel_text = is_params && params.cancel_text ? params.cancel_text : $j.getInfo('cancel');
    var dialog_options = is_params && params.dialog_options ? params.dialog_options : {};
    var deferred = $j.Deferred();

    var content = $j('<div style="margin-top: .5em;" class="' + css_class + '">' +
        message + '</div>');
    content.keyup(function(e) {
        if (e.keyCode == 13) {
            $j('.ui-dialog').find('button:first').trigger('click');
        }
    });
    var dialog = fweb.dialog(content, $j.extend({
        modal: true,
        title: title,
        draggable: false,
        resizable: false,
        buttons: [
            {
                text: ok_text,
                click: function() {
                    deferred.resolve();
                    dialog.close();
                }
            },
            {
                text: cancel_text,
                click: function() {
                    deferred.reject();
                    dialog.close();
                }
            }
        ]
    }, dialog_options));

    deferred.done(callback);
    return deferred.promise();
};

$j.modal = function (html, spec) {
    spec = spec || {};
    var dialog = $j(html);
    var btns = {};
    dialog.keyup(function(e) {
        if (e.keyCode == 13) {
            btns[$j.getInfo('ok')].call(dialog);
        }
    });
    btns[$j.getInfo('ok')] = function() {
        if (typeof spec.callback == "function") {
            spec.callback(dialog);
        }
        dlg_close();
    };
    if (!('skip_cancel' in spec)) {
        btns[$j.getInfo('cancel')] = function() {
            dlg_close();
        };
    }
    var dialog_options = $j.extend({
        'modal': true,
        'width': 'auto',
        'buttons': btns
    }, spec);
    fweb.dialog(dialog, dialog_options);
};

// $j.format_date_diff - Return a formatted date description
// of how long ago a particular event happened, ie:
//
//   * 1:30:53
//   * 10-31 12:51
//   * 2012-10-31
//
// Requires $j.getInfo() and Global language table to be loaded.
//
// Parameters:
//   - date_old: Date() object in the past. Calculations based on this object.
//   - date_now: Optional Date() object to subtract date_old from. If omitted,
//               current Date will be used.
$j.format_date_diff = function (date_old, date_now) {
    // Use current time if no Date object provided.
    if (!date_now) date_now = new Date();

    var result = "";

    if (date_old.toDateString() == date_now.toDateString()) {
        result = [$j.pad(date_old.getHours()),
                  $j.pad(date_old.getMinutes()),
                  $j.pad(date_old.getSeconds())].join(':');
    } else if (date_old.getYear() == date_now.getYear()) {
        result = $j.pad((date_old.getMonth() + 1)) + "-" +
                 $j.pad(date_old.getDate()) + " " +
                 $j.pad(date_old.getHours()) + ":" +
                 $j.pad(date_old.getMinutes());
    } else {
        result = [date_old.getYear() + 1900,
                  $j.pad(date_old.getMonth() + 1),
                  $j.pad(date_old.getDate())].join('-');
    }

    return result;
};

// $j.format_date_friendly - Return a user friendly date description
// of how old a particular event is, ie:
//
//   * 6 seconds ago
//   * Yesterday
//   * Thursday
//
// Requires $j.getInfo() and Global language table to be loaded.
//
// Parameters:
//   - date_old: Date() object in the past. Calculations based on this object.
//   - date_now: Optional Date() object to subtract date_old from. If omitted,
//               current Date will be used.
$j.format_date_friendly = function (date_old, date_now) {
    if (date_now == null) { date_now = new Date(); }
    var diff = Math.floor((date_now - date_old + 1)/1000),
        result = diff < 0 ? date_old.toLocaleString() : date_old.toLocaleDateString();
        weekdays = [$j.getInfo('sun'), $j.getInfo('mon'), $j.getInfo('tues'),
                    $j.getInfo('wed'), $j.getInfo('thur'), $j.getInfo('fri'),
                    $j.getInfo('sat')];

    if (diff < 0) {
        // date_old newer than date_now
    } else if (diff < 2) {
        result = $j.getInfo('second_ago');
    } else if (diff < 60) {
        result = String(diff) + ' ' + $j.getInfo('seconds_ago');
    } else if (diff < 120) {
        result = $j.getInfo('minute_ago');
    } else if (diff < 3600) {
        result = String(Math.floor(diff/60)) + ' ' +
            $j.getInfo('minutes_ago');
    } else if (diff < 7200) {
        result = $j.getInfo('hour_ago');
    } else if (diff < 18000) {
        result = String(Math.floor(diff/3600)) + ' ' +
            $j.getInfo('hours_ago');
    } else if (diff < 172800 && (date_old.getDay() + 1) % 7 == date_now.getDay()) {
        result = $j.getInfo('yesterday');
    } else if (diff < 604800) {
        result = weekdays[date_old.getDay()];
    }

    return result;
};

/*            'js/fweb_extra.amdefine.js',*/
if(typeof define === 'function' && define.amd) {
    define('fweb_extra', ['fweb'], function(fweb) {
        fweb.fgd_common = fgd_common;
        fweb.byod_common = byod_common;
        return fweb;
    });
}

/*            'js/fweb.formset.js',*/
/* dynamic formset support - requires a specifically crafted section of html

Example:

<div class="js-formset">
    <table>
        <thead><tr>
            <th>{%lang 'field-name'%}</th><th>{%lang 'value'%}</th>
        </tr></thead>
        <tbody class="js-formset-container">
            <!-- you could include non-template entries here, straight from
            the server. -->

            <!-- this part's the template, it's pretty important -->
            <tr id="formdata-%NUM%" class="js-formset-template">
                <td class="input">
                    <input type="text" name="formdata-%NUM%-name">
                </td>
                <td class="input">
                    <input type="text" name="formdata-%NUM%-value">
                    <input class='js-formset-remove-button'
                        type="button" value="{% lang 'remove' %}">
                </td>
            </tr>

        </tbody>
    </table>
    <input class="js-formset-add-button" type="button" value="{% lang 'add' %}">
</div>

Usage:
fweb.formset()

To populate the formset with preexisting data from js, use the 'initial_length'
option and the 'load_new' callback. To populate the formset in the template,
make sure you set the 'initial_index' option (if you need to do that, delete
support will be needed -- add your own delete handlers or improve this plugin)

In that case, the usage is
fweb.formset({
    initial_length: source.length,
    load_new: function(index, $item) { ... }
});

Remarks:
 - I've prefixed the css classes with js- as a naming convention that should
   eventually get into a style guide (to make a clear distinction between css
   classes for style and behaviour)

*/
;(function(fweb, $) {

var default_opts = {
    numerical_placeholder: '%NUM%', // used in a regex; TODO: maybe allow regexes
    selector: '.js-formset',
    sel_container: '.js-formset-container',
    sel_template: '.js-formset-template',
    sel_add_button: '.js-formset-add-button',
    sel_remove_button: '.js-formset-remove-button',
    sel_focus_field: '.js-formset-focus-field',
    // generic callback, generally used for setting initial data from js
    load_new: $.noop, // function(index, $item)
    initial_index: 0,
    initial_length: 1
};

function formset(opts){
    var selector = opts != null && opts.selector != null ? opts.selector : default_opts.selector;
    $(selector).each(function(){formset_initialize(this, opts);});
}

formset.initialize = formset_initialize;
function formset_initialize(_this, opts) {
    var $this = $(_this),
        $tmpl,
        data = $this.data('fweb-formset');

    if (data != null) {
        // the formset has already been initalized, just reset it with the new options
        // the template selector should not have changed, abort if it has
        if (opts != null && opts.sel_template != null &&
                opts.sel_template !== data.opts.sel_template) {
            throw new Error('assert: template should not change'); }
        $.extend(data.opts, opts);
        formset_reset($this);
        return;
    }

    // perform first-time setup
    $this.data('fweb-formset', data = {});
    data.opts = opts = $.extend({}, default_opts, opts);
    $tmpl = $this.find(opts.sel_template);
    // convert the template into a string so it's easy to do a replace
    // this will also remove the template from the DOM
    data.htmpl = $('<div>').append($tmpl).html();

    formset_reset($this);
}

formset.reset = formset_reset;
function formset_reset(el_or_selector) {
    var $this = $(el_or_selector),
        data = $this.data('fweb-formset'),
        opts = data.opts,
        $container = $this.find(opts.sel_container),
        $add = $this.find(opts.sel_add_button),
        max_index = opts.initial_index + opts.initial_length;

    // clear old data and DOM elements
    $add.off('click.formset');
    $container.find(opts.sel_template).remove();
    data.next_index = opts.initial_index;

    // add new data and DOM elements
    while (data.next_index < max_index) { formset_append(); }
    $add.on('click.formset', formset_append);

    function formset_append(){
        // adds a new formset item to the container by creating a new dom
        // element to the container, and hooks up the delete handler
        var index = data.next_index,
            $item = $(data.htmpl.replace(
                new RegExp(opts.numerical_placeholder, 'g'), index)),
            $remove = $item.find(opts.sel_remove_button);

        // generic callback -- used for preloading data
        opts.load_new(index, $item);

        // TODO: for generic removal support, this would need to be moved out
        //       of the closure somehow
        $remove.on('click.formset', function() {
            $item.remove();
            $this.trigger('formset_removed', $item);
        });

        $item.appendTo($container);

        $this.find(opts.sel_focus_field).focus();

        $this.trigger('formset_added', $item);
        data.next_index++;
    }
}

// TODO: a proper loading system would be nice for fweb to make this kind of
//       boilerplate unessesary (like require.js or qlist plugin dependancies)
if (fweb.extend == null) { fweb.extend = $.extend; }
fweb.extend({
    formset: formset
});

})(window.fweb = window.fweb || {}, jQuery);

/*            'js/fweb.cmdb.js',*/
/* global window, jQuery, CMDB, dlg_close */

(function(fweb, $, undefined) {
    'use strict';

    // Clone a CMDB object by either path & name or type, along with an mkey.
    // Creates a dialog to prompt the user for the desired clone name returning a
    // promise that is resolved upon a succesful clone, or rejected if the window
    // is closed
    //
    // A resolved promise will contain the new mkey as an argument, a rejected
    // promise is empty
    fweb.cmdbClone = function(args) {
        var name, message, $prompt;
        var dfd = $.Deferred();
        var params = {
            mkey: '',
            nkey: '',
            path: '',
            name: '',
            qType: '',
            //Max length of the nkey name
            maxLength: 35
        };
        $.extend(params, args);

        name = ($.getInfo('clone_of') + ' ' + params.mkey).slice(0, params.maxLength);
        message = params.message || $.getInfo('clone_msg');

        $prompt = $('<div>' + message + '<br></div>')
            .append('<input id="clone-name" type="text" style="width:300px; margin: .5em;"' +
                    'value="' + name + '" + maxlength="' + params.maxLength + '" />')
            .append('<div class="error" style="display: none"></div>');

        fweb.dialog($prompt, {
            title: params.title || $.getInfo('clone') + ' "' + params.mkey + '"',
            buttons: [
                {
                    text: $.getInfo('ok'),
                    click: function() {
                        var that = this;
                        var nkey = $('#clone-name', this).val();

                        CMDB.clone(params.path, params.name, params.mkey, null,
                            {type: params.qType, nkey: nkey})
                        .done(function(data) {
                            if (data.error) {
                                $('.error', that).html($.getInfo('error') +
                                    ': ' + $.getInfo(data.error)).show();
                            } else {
                                dlg_close();
                                dfd.resolve(nkey);
                            }
                        }).fail(function() {
                            $('.error', that).html($.getInfo('error')).show();
                        });
                    }
                },
                {
                    text: $.getInfo('cancel'),
                    click: function() {
                        dlg_close();
                        dfd.reject();
                    }
                }
            ]
        });
        return dfd.promise();
    };

}(window.fweb = window.fweb || {}, jQuery));

/*            'js/jquery.validate.methods.js',*/
/*
 * jQuery Validation Extra Methods
 * init: Joseph Tary, July 2011
 */

// TODO: use http://docs.jquery.com/Plugins/Validation/Reference#Refactoring_rules
//       to simplify some rule declarations

/*global RegExpCommon,ipStrToNum,JSONRPC,CMDB,fweb*/
// Note: this is called on $.ready, so that the translations are ready
jQuery(function($) {
    // ensure that newlines in textareas are preserved correctly, for comment length
    // see "Note" on http://api.jquery.com/val/#entry-longdesc
    $.valHooks.textarea = {
        get: function( elem ) {
            return elem.value.replace( /\r?\n/g, "\r\n" );
        }
    };

    if ($.validator) {
            /*remove we get lang in common aps_new_qlist_html*/
        //$.addLang([{path:'lang/',sec:'com_info'}]);
        //$.addLang([{path:'lang/',sec:'global'}]);

        $.extend($.validator.messages, {
            required: $.getInfo("validate_msg_required"),
            remote: $.getInfo("validate_msg_remote"),
            email: $.getInfo("validate_msg_email"),
            url: $.getInfo("validate_msg_url"),
            date: $.getInfo("validate_msg_date"),
            dateISO: $.getInfo("validate_msg_dateISO"),
            number: $.getInfo("validate_msg_number"),
            digits: $.getInfo("validate_msg_digits"),
            creditcard: $.getInfo("validate_msg_creditcard"),
            equalTo: $.getInfo("validate_msg_equalTo"),
            maxlength: $.validator.format($.getInfo("validate_msg_maxlength")),
            minlength: $.validator.format($.getInfo("validate_msg_minlength")),
            rangelength: $.validator.format($.getInfo("validate_msg_rangelength")),
            range: $.validator.format($.getInfo("validate_msg_range")),
            max: $.validator.format($.getInfo("validate_msg_max")),
            min: $.validator.format($.getInfo("validate_msg_min"))
        });

        $.validator.submitFlagSubmitHandler = function(form) {
            if (form.submitFlag) { return; }
            form.submitFlag = true;
            form.submit();
        };

        $.validator.setDefaults({
            ignore: ":hidden:not('.multiList-container:visible>*')",
            errorPlacement: function(error, element) {
                if (element.hasClass('ui-spinner-input')) {
                    error.insertAfter(element.parent());
                } else {
                    error.insertAfter(element);
                }
            }
        });

        $.validator.addMethod("time", function(value, element) {
            return this.optional(element) || /^(([0-1]?[0-9])|([2][0-3])):([0-5]?[0-9])(:([0-5]?[0-9]))?$/i.test(value);
        }, $.getInfo("-134"));

        $.validator.addMethod("datetimenosec", function(value, element) {
            return this.optional(element) || /^[0-9]{4}-(1[0-2]|0[1-9])-([0-2][0-9]|3[0-1]) ([0-1][0-9]|2[0-4]):([0-5][0-9])$/.test(value);
        }, "YYYY-MM-DD HH:MM");

        $.validator.addMethod('emails', function(value, element) {
            if (this.optional(element)) return true;
            var emails = value.indexOf(",") > 0 ? value.split(",") : value.split(";");
            for (var email, i = 0; email = emails[i]; i++) {
                if (!jQuery.validator.methods['email'].call(this, email, element))
                    return false;
            }
            return true;
        }, $.validator.messages["email"]);

        $.validator.addMethod('MacAddressChecker', function(value) {
            return RegExpCommon.MAC_ADDRESS.test(value);
        }, $.getInfo("-33"));

        /**
         * @param  {object} params  An object of keyword arguments. Available params are:
         *                          "is_unicast_ip": boolean - when set to true,
         *                          the method will validate the first octet of the ip.
         *                          If it is greater than 223, it is an invalid unicast ip address.
         */
        $.validator.addMethod('IP4Checker', function(value, element, params) {
            if (this.optional(element)) return true;

            if (!RegExpCommon.IP_HOST.test(value)) return false;

            if ($j.isPlainObject(params)) {
                if (params['is_unicast_ip']) {
                    var octets = value.split('.');
                    if (octets.length && octets[0] > 223) {
                        return false;
                    }
                }
            }
            return true;
        }, $.getInfo("-8"));

        /* Explicitly add class rules for IP4Checker. jQuery validate will not automatically
           add class rules when the validation callback has a 'params' parameter. */
        $.validator.addClassRules('IP4Checker', {'IP4Checker': true});

        $.validator.addMethod('Hostname', function(value, element) {
            return this.optional(element) || RegExpCommon.IP_HOST.test(value) || RegExpCommon.FQDN.test(value);
        }, $.getInfo("-257"));

        $.validator.addMethod('domain_name', function(value, element) {
            return this.optional(element) || RegExpCommon.DOMAIN_NAME.test(value);
        }, $.getInfo("-7529"));

        $.validator.addMethod('IP6Checker', function(value, element) {
            return this.optional(element) || RegExpCommon.IP6_HOST.test(value);
        }, $.getInfo("-255"));

        $.validator.addMethod('IP4NetmaskChecker', function(value) {
            if (!value) return true;

            return RegExpCommon.IP_MASK.test(value);
        }, $.getInfo("-9"));

        $.validator.addMethod('IP4SubnetChecker', function(value, element) {
            if (this.optional(element)) return true;

            return RegExpCommon.IP_SUBNET.test(value);
        }, $.getInfo("-9"));

        $.validator.addMethod('IP4VipSrcFilter', function(value, element) {
            var ADDR0 = /^0\.0\.0\.0$/;
            var RANGE0 = /^0\.0\.0\.0\-(0|0\.0\.0\.0)$/;
            var SUBNET0 = /^0\.0\.0\.0\/(32|0\.0\.0\.0)$/;

            if (this.optional(element)) {
                return true;
            }

            if (RegExpCommon.IP_HOST.test(value)) {
                return !ADDR0.test(value);
            }

            if (RegExpCommon.IP_SUBNET.test(value)) {
                return !SUBNET0.test(value);
            }

            if (RegExpCommon.IP_RANGE.test(value)) {
                return !RANGE0.test(value);
            }

            return false;
        }, $.getInfo('err_vip_src_filter'));

        $.validator.addMethod('IP6VipSrcFilter', function(value, element) {
            if (this.optional(element)) {
                return true;
            }

            return RegExpCommon.IP6_HOST.test(value) ||
                   RegExpCommon.IP6_SUBNET.test(value) ||
                   $.validator.methods.IP6RangeChecker.call(this, value, element);

        }, $.getInfo('err_vip_src_filter'));

        $.validator.addMethod('IP4ListChecker',
                                function(value, element) {
            // ip list with trailing commas are treated invalid here.
            // TO DO: return more informative error messages
            if (this.optional(element)) {
                return true;
            }

            var ips = value.split(/[,]+/),
                len = ips.length;
            if (!len) {
                return false;
            }

            var ip_set = {}; // used for checking duplicates
            var ip = '';
            for (var i = 0; i < len; i++) {
                ip = $.trim(ips[i]);
                if (ip in ip_set) {
                    return false;
                } else {
                    ip_set[ip] = '';
                }
                if (!(RegExpCommon.IP_SUBNET.test(ip) ||
                    RegExpCommon.IP_HOST.test(ip) ||
                    RegExpCommon.IP_WILDCARD.test(ip) ||
                    RegExpCommon.IP_RANGE.test(ip) ||
                    RegExpCommon.IP_RANGE2.test(ip))) {
                    return false;
                }
            }

            return true;
        }, $.getInfo('err_ip_mask_list'));

        function IP4NetChecker(value, element, opts) {
            if (this.optional(element)) { return true; }
            value = $.trim(value);
            opts = $.extend({any: 1, multiple: 0}, opts);
            if (!RegExpCommon.IP_SUBNET.test(value)) { return false; }

            var ipmask = fweb.util.IpMask.parse(value);
            var ip = ipmask.numbered();

            // check if single ip allowed
            if (opts.multiple && ipmask.netmask[3] >= 255) {
                return false;
            }
            // To match CLI validation (see cli/commands.c), ensure the address either IS:
            //  0.0.0.0 (to be able to clear the address)
            //  a single-point address (31- or 32-bit netmask on an unreserved addresses)
            // or ISN'T:
            //  a reserved address
            //  the network address (host ID 0)
            //  the broadcast address (all bits 1)
            return (ip === 0 && opts.any ||         // 0.0.0.0 if allowed
                    (ipmask.addr[0] > 0 &&          // 0.x.x.x not allowed - reserved addresses
                     ipmask.addr[0] !== 127 &&      // 127.x.x.x not allowed - loopback addresses
                     ipmask.addr[0] < 224) ||       // 224.x.x.x and above are reserved addresses
                    (ipmask.netmask[3] >= 254 ||    // single-point address
                     (ip !== ipmask.numbered(fweb.util.IpMask.NETWORK) &&
                      ip !== ipmask.numbered(fweb.util.IpMask.BROADCAST))));
        }

        $.validator.addMethod('IP4IntfChecker', function (value, element) {
            return IP4NetChecker.call(this, value, element);
        }, $.getInfo('-9'));

        // list of [IP4NetChecker], each must contains more than 1 ip, 0.0.0.0 is not allowed.
        $.validator.addMethod('IP4NetList', function(value, element) {
            var addr, addresses = value.split(/[, ]/);
            for (var i = 0; addr = addresses[i]; i++) {
                if (!IP4NetChecker.call(this, addr, element, {any: 0, multiple: 1})) {
                    return false;
                }
            }
            return true;
        }, $.getInfo('-9'));

        $.validator.addMethod('IP4Subnetwork', function(value, element) {
            if (this.optional(element)) return true;
            if (!RegExpCommon.IP_SUBNET.test(value)) return false;
            var ipmask = fweb.util.IpMask.parse(element.value);
            var prefix = ipmask.numbered(fweb.util.IpMask.NETWORK);
            var ip = fweb.util.IpMask.toNumber(ipmask.addr);
            // expression only valid when entering network prefix
            return ip == prefix;
        }, function(params, element) {
            // return validate error message accordingly
            if (!RegExpCommon.IP_SUBNET.test(element.value)) {
                return $j.getInfo('ip_subnet');
            }
            var ipmask = fweb.util.IpMask.parse(element.value);
            var prefix = ipmask.numbered(fweb.util.IpMask.NETWORK);
            return $j.getInfo("err_subnet") + ' ' + fweb.util.IpMask.toDotted(prefix).join('.') + '/' + ipmask.netmask.join('.');
        });

        $.validator.addMethod('IP6SubnetChecker', function(value, element) {
            if (this.optional(element)) return true;

            return RegExpCommon.IP6_SUBNET.test(value);
        }, $.getInfo("-255"));

        $.validator.addMethod('IP4ConflictChecker', function(value) {
            if (!parent || !parent.wizard) {
                return true;
            }

            if (value == "0.0.0.0") {
                return true;
            }

            var value_mask = $("input[name='netmask']").val();
            if (!value_mask) {
                value_mask = "255.255.255.255";
            }

            value_ip = ipStrToNum(value);
            value_mask = ipStrToNum(value_mask);

            var history = parent.wizard.state.history;
            var data;
            var data_ip, data_mask, value_ip;

            for (var i = 0; i < history.length; i++) {
                data = history[i].data;

                if (!data.ip || !data.netmask || (data.ip == "0.0.0.0") || (data.mode != "static")) {
                    continue;
                }

                data_ip = ipStrToNum(data.ip);
                data_mask = ipStrToNum(data.netmask);

                if (((data_ip & data_mask) == (value_ip & data_mask)) ||
                        ((data_ip & value_mask) == (value_ip & value_mask))) {
                    return false;
                }
            }

            return true;
        }, $.getInfo("err_ip_conflict"));

        var isIP4Range = function(start_ip, end_ip, netmask){
            start_ip = ipStrToNum(start_ip);
            end_ip = ipStrToNum(end_ip);
            netmask = ipStrToNum(netmask);

            if (!start_ip || !end_ip) {
                return false;
            }

            // Check the value within the ip range. the start ip must be less
            // than the end ip after converting into numbers.
            if (((start_ip & netmask) != (end_ip & netmask)) || (start_ip > end_ip)) {
                return false;
            }

            return true;
        };

        $.validator.addMethod('IP4RangeChecker', function(value, element, params) {
            var ip4range_fields = params || ["start-ip", "end-ip", "netmask"];

            var start_ip = ip4range_fields[0];
            var end_ip = ip4range_fields[1];
            var netmask = ip4range_fields[2];

            if (!start_ip || !end_ip) {
                return false;
            }

            start_ip = $("input[name='" + start_ip + "']").val();
            end_ip = $("input[name='" + end_ip + "']").val();
            netmask = $("input[name='" + netmask + "']").val() || "0.0.0.0";

            if (!start_ip || !end_ip) {
                return false;
            }

            return isIP4Range(start_ip, end_ip, netmask);
        }, $.getInfo("err_ip_range"));

        $.validator.addMethod('IP6RangeChecker', function(value, element, params) {
            if (this.optional(element)) return true;

            var ip6range = value.replace(/ /g, '');
            ip6range = ip6range.split('-');
            if (ip6range.length < 2) return false;

            var start_ip = ip6range[0];
            var end_ip = ip6range[1];

            if (!($.validator.methods.IP6Checker.call(this, start_ip, element)) ||
                !($.validator.methods.IP6Checker.call(this, end_ip, element))) {
                return false;
            }

            var start_ip_num = new goog.net.Ipv6Address(start_ip).toInteger();
            var end_ip_num = new goog.net.Ipv6Address(end_ip).toInteger();

            if (start_ip_num.greaterThanOrEqual(end_ip_num)) return false;

            return true;

        }, $.getInfo("err_ip_range"));

        /* IP4PoolRange - accepts address ranges parsable by
         * migbase/sysapi/base/ipaddrmaskparser.c#parse_from_input
         * TODO: also check that start isn't smaller than end
         * for IP_RANGE and IP_RANGE2 (requires parsing) */
        $.validator.addMethod('IP4PoolRange', function(value) {
            return (RegExpCommon.IP_RANGE.test(value) ||
                    RegExpCommon.IP_RANGE2.test(value) ||
                    RegExpCommon.IP_SUBNET.test(value) ||
                    RegExpCommon.IP_HOST.test(value) ||
                    RegExpCommon.IP_WILDCARD.test(value));
        }, $.getInfo("err_ip_range"));

        $.validator.addMethod('XSSChecker', function(value) {
            return RegExpCommon.XSS.test(value);
        }, $.getInfo("err_xss"));

        $.validator.addMethod('IdentifierChecker', function(value) {
            return RegExpCommon.NAME_NODOLLAR.test(value);
        }, $.getInfo('err_char'));

        $.validator.addMethod('nameRequired',
            $.validator.methods.required, $.getInfo('err_name'));
        $.validator.addClassRules('js-valid-name',
            { IdentifierChecker: true, nameRequired: true });

        // $.validator.registerWarning('minlength');
        $.validator.addMethod('minlengthWarning',
            function() { return $.validator.methods.minlength.apply(this, arguments) || 'warning';  },
            $.getInfo('err_pwd3'));
        $.validator.addClassRules('js-valid-password',
            { required: true, minlengthWarning: 6 });

        $.validator.addMethod('CommentChecker', function(value, element) {
            return jQuery.validator.methods.maxlength.call(this, value, element, 63);
        }, $.getInfo('err_comment'));

        $.validator.addMethod('PortChecker', function(value, element) {
            if (!value) {
                return this.optional(element);
            }

            if (!RegExpCommon.INTEGER.test(value)) {
                return false;
            }

            if (value < 1 || value > 65535) {
                return false;
            }

            return true;
        }, $.getInfo("-252"));

        // PortlistChecker support ports input like: "10, 20, 100-200"
        $.validator.addMethod('PortlistChecker', function(value, element) {
            if (typeof value !== "string") {
                return false;
            }

            if (!value) {
                return this.optional(element);
            }

            var portlist = value.split(/[,\-]/);

            if (portlist && portlist.length) {
                for (var i = 0; i < portlist.length; i++) {
                    var port = portlist[i].replace(/^\s+|\s+$/g, '');
                    if (!($.validator.methods.PortChecker.call(this, port))) {
                        return false;
                    }
                }
            }
            return true;
        }, $.getInfo("-252"));

        $.validator.addMethod('WeightChecker', function(value) {
            if (!RegExpCommon.INTEGER.test(value)) {
                return false;
            }

            if (value < 0 || value > 255) {
                return false;
            }

            return true;
        }, $.getInfo("err_weight"));

        $.validator.addMethod('SpilloverThresholdChecker', function(value) {
            if (!RegExpCommon.INTEGER.test(value)) {
                return false;
            }

            if (value < 0 || value > 2097000) {
                return false;
            }

            return true;
        }, $.getInfo("err_range") + " " + 0 + "-" + 2097000);

        $.validator.addMethod('PasswordChecker', function(value) {
            return JSONRPC.Wizard.Setup.password_check({"password": value});
        }, $.getInfo("err_password"));

        $.validator.addMethod('DuplicateValueChecker', function(value, element, requests) {
            var ret = true;

            try {
                $.each(requests, function(idx, request) {
                    var path = request["path"];
                    var name = request["name"];
                    var key = request["key"];
                    var exempt = request["exempt"];
                    var dependency = request["dependency"];
                    var vdom = request["vdom"];

                    var exempt_vals = {}, dependency_vals = {};
                    $.each(exempt || {}, function(key) {
                        exempt_vals[key] = $(exempt[key]).val();
                    });
                    $.each(dependency || {}, function(key) {
                        dependency_vals[key] = $(dependency[key]).val();
                    });

                    var filter = {
                        "key": key,
                        "pattern": value,
                        "vdom": vdom
                    };
                    CMDB.fetch(path, name, filter, function(response) {
                        var results = response.results;

                        for (var i = 0; i < results.length; i++) {
                            var dependency_conflict = false;
                            $.each(dependency_vals, function(key) {
                                if (results[i][key] === dependency_vals[key]) {
                                    dependency_conflict = true;
                                }
                            });
                            var is_conflict = !dependency || dependency_conflict,
                                same_vdom = !(vdom && results[i].vdom && vdom !== results[i].vdom);
                            $.each(exempt_vals, function(key) {
                                var is_exempt = results[i][key] === exempt_vals[key];
                                if (!is_exempt && is_conflict && same_vdom) {
                                    throw response;
                                }
                            });
                        }
                    }, false);
                });
            } catch (err) {
                ret = false;
            }

            return ret;
        }, $.getInfo("err_duplicate_value"));

        $.validator.addMethod('DuplicateEntryChecker', function(value, element, requests) {
            var defaults = {
                "mkeySelector" : "#mkey"
            };
            var ret = true;
            var params = {};

            $.extend(requests, defaults);

            if (value == $(requests.mkeySelector).val()) {
                return true;
            }

            for (var i = 0; i < requests.length; i++) {
                requests[i].mkey = value;
            }

            params.batch = requests;

            JSONRPC.Batch.send(params, {async: false, on_success: function (response) {
                var result;

                try {
                    for (var i = 0; i < response.length; i++) {
                        result = response[i].result;

                        if (result) {
                            throw result;
                        }
                    }
                }
                catch (err) {
                    ret = false;
                }
            }});

            return ret;
        }, $.getInfo("-15"));

        // this regex isn't perfect, but it's better than relying on eval.
        var rangeRegex = /\[ *['"]?([^'",]*)['"]? *, *['"]?([^'",]*)['"]? *\]/;
        // the validation plugin has inherent support for ranges, but is buggy
        // with certain versions of jQuery, including the current one (1.3.2)
        $.validator.addMethod("RangeChecker", function (value, element, range) {
            if (typeof range == "undefined") {
                if (element.getAttribute("range")) {
                    var execResult = rangeRegex.exec(element.getAttribute("range"));
                    var min, max;

                    min = parseInt(execResult[1], 10);
                    max = parseInt(execResult[2], 10);

                    if (!isNaN(min) && !isNaN(max)) {
                        range = [ min, max ];
                    }
                }
            }

            if (!range || !range.length || range.length < 2) {
                range = [ 0, Math.pow(2, 32) - 1 ];
            }

            $.validator.messages["RangeChecker"] = $.getInfo("err_range") + " " + range[0] + "-" + range[1];

            return (RegExpCommon.INTEGER.test(value) && value >= range[0] && value <= range[1]);
        }, $.validator.messages["RangeChecker"]);

        $.validator.addMethod('PwdEqChecker', function(value, element) {
            var pwd_fields = element.getAttribute("password");

            if (pwd_fields) {
                pwd_fields = JSON.parse(pwd_fields);
            }

            if (!pwd_fields) {
                pwd_fields = ["password", "password2"];
            }

            var pwd = pwd_fields[0],
                pwd2 = pwd_fields[1];

            if (!pwd || !pwd2) {
                return false;
            }

            var $pwd = $("input[name='" + pwd + "']"),
                $pwd2 = $("input[name='" + pwd2 + "']");

            if (($pwd.length === 0) && ($pwd2.length === 0)) {
                return true;
            }

            if ($pwd.val() == $pwd2.val()) {
                return true;
            }

            return false;
        }, $.getInfo("err_pwd_match"));

        // simpler version of the above method
        // used as a attribute/data method rather than a class method
        // param is a selector to the primary password field (rooted at the form)
        // If the parameter is empty or undefined, it will try to look for a input element
        // with the same name, but without a trailing 2 (eg. `password2` will match `password`)
        var confirm_password_method = function(value, element, param) {
            var $el = $(element),
                $form = $el.closest('form'),
                $password, autoparam, _ref;
            if ($.type(param) !== 'string' || param.length <= 0) {
                param = 'input[type=password]';
                autoparam = (_ref = /^(.+)2$/.exec($el.attr('name'))) != null ?
                    ('input[name="' + _ref[1] + '"]') : null;
            }
            if (autoparam != null && $form.length > 0) {
                $password = $form.find(autoparam);
            }
            if ($password == null || $password.length <= 0) {
                $password = ($form.length > 0 ? $form.find(param) : $(param)).not($el).first();
            }
            // proxy to equalTo for listening to password changes
            return $.validator.methods.equalTo.call(this, value, $el, $password);
        };
        $.validator.addMethod('confirm-password', confirm_password_method, $.getInfo("err_pwd_match"));
        $.validator.addMethod('confirm-password-name', function(value, element, param) {
            return confirm_password_method.call(this, value, element, 'input[name="' + param + '"]');
        }, $.getInfo("err_pwd_match"));

        // host_mask - Validate multiple IP/masks separated by comma.
        $.validator.addMethod("host_mask_list", function(value, element) {
            if (this.optional(element)) {
                return true;
            }

            var hosts = value.split(",");
            for (var i=0; i<hosts.length; i++) {
                var host = $.trim(hosts[i]);
                if (!RegExpCommon.IP_SUBNET.test(host) &&
                    !RegExpCommon.IP_HOST.test(host) &&
                    !RegExpCommon.IP_RANGE.test(host)) {
                    return false;
                }
            }
            return true;
        }, "192.168.1.0/24, 172.16.1.1-172.16.1.20");

        /* ip_fqdn - Validate to accept the following:
         *   172.16.1.1
         *   aaa.com
         *   172.16.1.[1-20]
         *   172.16.1.1-172.16.1.20
         *   172.16.6.1/24, 172.16.6.2/255.255.255.0, 172.16.6.3
         *   aaa.com, bbb.com, ccc.com
         */
        $.validator.addMethod("ip_fqdn", function(value, element) {
            if (this.optional(element)) {
                return true;
            }

            // see if we have a range like this 172.16.1.1-172.16.1.20
            var ret = RegExpCommon.IP_RANGE.test(value);
            if (ret) {
                return ret;
            }

            // see if we have a range like this 172.16.1.[1-20]
            ret = RegExpCommon.IP_RANGE2.test(value);
            if (ret) {
                return ret;
            }

            // see if we have any comma separator list
            var hosts = value.split(/[\s,]+/);
            // ip and fqdn can not co-exist: ie, reject 172.16.1.1,aaa.com
            var ip_exist = false;
            var fqdn_exist = false;
            for (var i=0; i<hosts.length; i++) {
                var host = $.trim(hosts[i]);
                var is_ip_subnet = RegExpCommon.IP_SUBNET.test(host);
                var is_ip_host = RegExpCommon.IP_HOST.test(host);
                var is_fqdn = RegExpCommon.FQDN.test(host);
                if (!is_ip_subnet && !is_ip_host && !is_fqdn) {
                    return false;
                }
                if (is_ip_subnet || is_ip_host) {
                    ip_exist = true;
                }
                if (is_fqdn && !ip_exist) {
                    fqdn_exist = true;
                }
                if (ip_exist && fqdn_exist) {
                    return false;
                }
            }

            return true;
        }, $.getInfo("err_ip_fqdn"));

        /* multicast_addr - Validate to accept the following:
         *   [224-239].xxx.xxx.xxx
         *   [224-239].xxx.xxx.xxx-[224-239].xxx.xxx.xxx
         *   If explicit type option given, will just validate:
         *     + range address
         *     + or single address
         *   If allow0 option is given, also accept:
         *     0.0.0.0 (for DNAT in multicast policy)
         */
        $.validator.addMethod("multicast_addr", function(value, element, param) {
            if (this.optional(element)) {
                return true;
            }

            if (typeof param == "undefined") {
                param = {};
            }

            var ADDR0 = /^0\.0\.0\.0$/;
            var ADDR_RANGE0 = /^0\.0\.0\.0-0\.0\.0\.0$/;
            var allow0 = param['allow0'] === true;
            var single = param['single'] === true;
            var range = param['range'] === true;

            if (single) {
                if (allow0 && ADDR0.test(value)) {
                    return true;
                }
                return RegExpCommon.MULTICAST_IP_HOST.test(value);
            }

            if (range) {
                if (allow0 && ADDR_RANGE0.test(value)) {
                    return true;
                }
                return RegExpCommon.MULTICAST_IP_RANGE.test(value);
            }

            // here neither single nor range is given
            if (allow0) {
                return (
                    RegExpCommon.MULTICAST_IP_HOST.test(value)
                    || RegExpCommon.MULTICAST_IP_RANGE.test(value)
                    || ADDR0.test(value)
                    || ADDR_RANGE0.test(value)
                );
            }

            // here no extra param at all
            return (
                RegExpCommon.MULTICAST_IP_HOST.test(value)
                || RegExpCommon.MULTICAST_IP_RANGE.test(value)
            );
        }, $.getInfo("err_multicast_addr"));

        /* ipv4_range - Validate to accept the following:
         *   1.1.1.1
         *   1.1.1.[1-20]
         *   1.1.1.1-1.1.1.4
         */
        $.validator.addMethod("ipv4_range", function(value, element, params) {
            // Accept 0.0.0.0 and 0.0.0.0-0.0.0.0 unless exclude0 is given

            if (this.optional(element)) {
                return true;
            }

            var default_range_check = RegExpCommon.IP_RANGE.test(value)
                                     || RegExpCommon.IP_RANGE2.test(value)
                                     || RegExpCommon.IP_HOST.test(value);

            var is_in_range = true;
            if(typeof value === 'string') {
                var ips = value.split('-');
                ips.push("0.0.0.0");
                if (ips.length > 2) {
                    is_in_range = isIP4Range(ips[0], ips[1], ips[2]);
                }
            }
            return (
                default_range_check && is_in_range
            );
        }, $.getInfo("err_ip_range"));

        // number_list - Validate number lists in the format of
        // 80,8000,443.
        // Allow customizing separator, ie, space instead of comma
        // Min/max constraint for each number is checked if required
        $.validator.addMethod("number_list", function(value, element, param) {
            if (this.optional(element)) {
                return true;
            }

            if (typeof param == "undefined") {
                param = {};
            }

            var separator = ",";
            if (typeof param['separator'] !== "undefined") {
                separator = param['separator'];
            }
            var values = value.split(separator);

            // Return error if too many comma separate values are specified.
            if (typeof param['max_values'] !== "undefined" &&
                values.length > param['max_values']) {
                return false;
            }

            var min_required = typeof param['min'] !== "undefined";
            var max_required = typeof param['max'] !== "undefined";
            for (var i=0; i<values.length; i++) {
                var val = $.trim(values[i]);
                if (!/^\d+$/.test(val)) {
                    return false;
                }
                if ((min_required && val < param['min'])
                        || (max_required && val > param['max'])) {
                    return false;
                }
            }

            return true;
        }, $.getInfo('custom')); // this validation now becomes too general to
                                 // have a specific message

        // number_range_list - Validate number lists in the format of
        // 80,8000-8100,443.
        // Min/max constraint for each number is checked if required
        $.validator.addMethod("number_range_list", function(value, element, param) {
            if (this.optional(element)) {
                return true;
            }

            if (typeof param == "undefined") {
                param = {};
            }

            var total_values = 0;
            var ranges = value.split(",");

            var min_required = param['min'] != null;
            var max_required = param['max'] != null;

            var custom_error_message = function() {
                if (min_required && max_required) {
                    $.validator.messages["number_range_list"] = param['min'] + "-" + param['max'];
                }
                return false;
            };

            // Return error if too many or too little comma separate values
            // are specified. ie: One and only one range is required
            if (
                (param['max_values'] !== undefined
                 && ranges.length > param['max_values'])
                || (param['min_values'] !== undefined
                    && ranges.length < param['min_values'])
            ) {
                return custom_error_message();
            }

            for (var i=0; i<ranges.length; i++) {
                var r = $.trim(ranges[i]);
                if (!/^\d+(-\d+)?$/.test(r)) {
                    return custom_error_message();
                }
                var v = r.split('-');
                total_values += 1;
                var v0 = parseInt(v[0], 10);
                if ((min_required && v0 < param['min'])
                        || (max_required && v0 > param['max'])) {
                    return custom_error_message();
                }
                if (v.length == 2) {
                    var v1 = parseInt(v[1], 10);
                    if ((min_required && v1 < param['min'])
                            || (max_required && v1 > param['max'])) {
                        return custom_error_message();
                    }
                    if (v1 < v0) {
                        return custom_error_message();
                    }
                    total_values += v1 - v0;
                }
            }

            // Return error if too many total values are specified.
            if (typeof param['max_total'] != "undefined" &&
                total_values > param['max_total']) {
                return custom_error_message();
            }

            return true;
        }, $.getInfo("custom")); // this validation now becomes too general to
                                 // have a specific message

        $.validator.addMethod('hex-number', function(value, element) {
            return this.optional(element) || /\b(0x)?[0-9a-fA-F]+\b$/.test(value);
        }, $.getInfo("err_hex_number"));

        $.validator.addMethod('integer', function(value) {
            return RegExpCommon.INTEGER.test(value);
        }, $j.getInfo('integer'));

        $.validator.addMethod('XML', function(value, element){
            var isXml;
            if (this.optional(element)) {
                return true;
            }
            try {
                isXml = $.parseXML(value);
            } catch(e) {
                isXml = false;
            }
            return isXml !== false;
        }, $.getInfo('err_invalid_xml'));

        $.validator.addMethod("require_from_group", function(value, element, options) {
            var selector = options[1];
            var validOrNot = $(selector, element.form).filter(function() {
                return $(this).val();
            }).length >= options[0];

            if(!$(element).data('being_validated')) {
                var fields = $(selector, element.form);
                fields.data('being_validated', true);
                fields.valid();
                fields.data('being_validated', false);
            }
            return validOrNot;
        }, $.getInfo('err_require_from_group'));

        $.validator.addMethod("skip_or_fill_minimum", function(value, element, options) {
            var numberRequired = options[0];
            var selector = options[1];
            var numberFilled = $(selector, element.form).filter(function() {
                return $(this).val();
            }).length;
            var valid = numberFilled >= numberRequired || numberFilled === 0;

            if(!$(element).data('being_validated')) {
                var fields = $(selector, element.form);
                fields.data('being_validated', true);
                fields.valid();
                fields.data('being_validated', false);
            }
            return valid;
        }, $.getInfo('err_skip_or_fill_minimum'));

        $.validator.addMethod("match_mask", function(value, element) {
            var tests = $(element).data('maskedinput_tests') || [];
            for (var i = 0; i < tests.length; ++i) {
                if (tests[i] && !tests[i].test(value.charAt(i)))
                    return false;
            }
            return true;
        }, $.getInfo("err_match_mask"));

        $.validator.addMethod("intf_diff", function(value, element, options) {
            var src = options[0];
            var dst = options[1];
            var src_val = $j(src).val();
            var dst_val = $j(dst).val();
            if (src_val === '' || dst_val === '') {
                return true;
            }
            if (src_val === 'any' && dst_val === 'any') {
                return true;
            }
            return src_val !== dst_val ;
        }, $.getInfo('err_intf_diff'));

        //copy/paste from jQuery.validator.methods['url']
        //altered so that the scheme portion (http:// etc) is optional
        $.validator.addMethod('url_noscheme', function(value, element) {
            return this.optional(element) || /^((https?|s?ftp):\/\/)?(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(value);
        }, $.validator.messages['url']);

        //copy and paste from jQuery.validator.methods['url'].
        //altered so that ftp or sftp protocols are not allowed, and the scheme portion is optional.
        //ipv4 and ipv6 host are allowed, ipv6 host must be held within [ and ].
        //localhost is allowed.
        $.validator.addMethod('SimpleUrlChecker', function(value, element) {
            return value === 'localhost' || RegExpCommon.IP_HOST.test(value) ||
                   (RegExpCommon.IP6_HOST.test(value.slice(1, -1)) && value.charAt(0) === '[' && value.charAt(value.length - 1) === ']') ||
                   /^((https?):\/\/)?(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(value);
        },  $.getInfo('err_urlfilter_url'));

        $.validator.addMethod('regex', function(value, element) {
            try {
                return this.optional(element) || new RegExp(value);
            } catch (ex) {
                return false;
            }
        }, function(params, element) {
            try {
                new RegExp($(element).val());
            } catch (ex) {
                var result = ex.message;
                if (!/expr/i.test(result)) {
                    $.loadedScript = [];
                    result = $.getInfo('-653').replace(/\.$/, '') +
                        ': ' + result;
                }
                return result;
            }
        });

        $.validator.addMethod('regex_match', function(value, element, regexp) {
            try {
                var re = new RegExp(regexp);
                return this.optional(element) || re.test(value);
            } catch (ex) {
                return false;
            }
        }, $.getInfo('-50')); // CFG_ER_BAD_FORMAT

        $.validator.addMethod("required_one", function(value, element, options) {
            var opt1 = $j(options[0]).val();
            var jopt2 = $j(options[1]);
            var opt2 = jopt2.val();
            var opt1_selected = opt1 !== '' && opt1 !== 'none';
            var opt2_selected = opt2 !== '' && opt2 !== 'none' &&
                               (jopt2.is(':visible') ||
                                jopt2.closest('.multiList-container').is(':visible'));
            return (opt1_selected || opt2_selected);
        }, $.getInfo('err_auth_method_required'));

        // used to create a new method based on an existing method, where
        // the arguments are 'baked' in. Mainly useful for having dependancies
        // for different arguments
        $.validator.bakeMethod = function(method, param, name, message) {
            if (name == null) { name = '' + method + param; }
            $.validator.addMethod(name, function(value, element) {
                return $.validator.methods[method].call(this, value, element, param);
            }, (message != null) ? (message) : function(parameters, element) {
                return $.validator.defaultMessage.call(this, element, method);
            });
        };

        $.validator.addMethod("smsphoneLengthChecker", function(value, element, options) {
            var country_code = $j(options[0]).text();
            var country_code_custom = $j(options[1]).val();
            var phone_num = $j(options[2]).val();
            var max_length = 15;

            var phone = country_code.replace('+','') + country_code_custom + phone_num;

            return !(phone.length > max_length);
        }, $.getInfo('sms_phone_length'));
    }
});

/*            'js/CheckIP.js',*/
// utility functions to verify the field entry.
function alertWinIP(IP, errmsg) {
    //window.alert(IP+"  is not a valid IP address.");
    window.alert(IP + " " + errmsg);
}

function isInt(numStr) {
    var i, c;
    for (i = 0; i < numStr.length; i++) {
        c = numStr.charAt(i);
        if (c < '0' || c > '9') {
            return false;
        }
    }
    return true;
}

function isIP(ip_str) {
    var ipArray = ip_str.split("."), octetInt;

    if (ipArray.length == 4) {
        for (var i = 0; i < 4; i++) {
            if (isInt(ipArray[i])) {
                octetInt = parseInt(ipArray[i], 10);
                if (octetInt < 0 || octetInt > 255) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (ipArray[0] == "0") {
            return false;
        }
    } else {
        return false;
    }
    return true;
}

function ipStrToNum(ip_str) {
    var ipValue = 0;
    var ipArray = ip_str.split(".");
    for (var i = 0; i < 4; i++) {
        ipValue = ipValue << 8;
        ipValue += parseInt(ipArray[i], 10);
    }
    return ipValue;
}

function verifyIP(cntrl, errmsg) {

    var val = [];
    var i = 0, index = 0, longIPVal = 0, k;
    var ip_str = cntrl.value;

    while (index < ip_str.lastIndexOf(".")) {
        k = index;
        index = ip_str.indexOf(".", index);
        val[i] = parseInt(ip_str.substring(k, index), 10);

        if (val[i] < 0 || val[i] > 255) break;
        i++;
        index++;
    }
    if (val[0] == 127) {
        i = 0;
    }
    if (i == 3) {
        if (ip_str.length > index) {
            val[i] = parseInt(ip_str.substring(index, ip_str.length), 10);
            if (val[i] < 0 || val[i] > 255) i = 2;
            else {
                val[0] = val[0] * Math.pow(2, 24);
                val[1] = val[1] * Math.pow(2, 16);
                val[2] = val[2] * Math.pow(2, 8);
                longIPVal = val[0] + val[1] + val[2] + val[3];
                return(longIPVal);
            }

        } else i = 2;
    }


    if (i != 3) {
        alertWinIP(cntrl.value, errmsg);
        //cntrl.value = cntrl.defaultValue;
        cntrl.select();
        return 999999;
    }
    return true;

}

function stringToNumber(str) {
    return parseInt(str, 10);
}

function verifyIPAndMask(cntrl, errmsg) {
    var i;
    var ip_mask_str = cntrl.value;
    var tokens = ip_mask_str.split(".");
    var parts, first, second;

    if (tokens.length < 4) {
        alertWinIP(cntrl.value, errmsg);
        return false;
    }

    for (i = 0; i < 3; i++) { // check the x.x.x... prefix
        if ((stringToNumber(tokens[i]) < 0) || (stringToNumber(tokens[i]) > 255)) {
            alertWinIP(cntrl.value, errmsg);
            return false;
        }
    }

    if (tokens.length == 4) {
        if ((stringToNumber(tokens[3]) >= 0) &&
                (stringToNumber(tokens[i]) <= 255)) { //x.x.x.x
            return true;
        }

        if (tokens[3].indexOf("*") === 0) { //x.x.x.*
            return true;
        }

        parts = tokens[3].split("/");
        if (parts.length == 2) { //x.x.x.x/x
            if ((stringToNumber(parts[0]) < 0) || (stringToNumber(parts[0]) > 255)) {
                alertWinIP(cntrl.value, errmsg);
                return false;
            }
            if ((stringToNumber(parts[1]) < 0) || (stringToNumber(parts[1]) > 32)) {
                alertWinIP(cntrl.value, errmsg);
                return false;
            }
            return true;
        }

        parts = tokens[3].split("-");
        if (parts.length == 2) { //x.x.x.[x-x]
            first = stringToNumber(parts[0].substring(1, parts[0].length));
            second = stringToNumber(parts[1].substring(0, parts[1].length - 1));
            if (
                    (parts[0].indexOf("[") === 0) &&
                    (first >= 0) &&
                    (first <= 255) &&
                    (parts[1].indexOf("]") == parts[1].length - 1) &&
                    (second >= 0) &&
                    (second <= 255) &&
                    (first <= second)) {
                return true;
            }
        }
    }

    if (tokens.length == 7) {
        for (i = 0; i < 7; i++) {
            if (i != 3) {
                if ((stringToNumber(tokens[i]) < 0) || (stringToNumber(tokens[i]) > 255)) {
                    alertWinIP(cntrl.value, errmsg);
                    return false;
                }
            }
        }

        parts = tokens[3].split("/");
        if (parts.length == 2) { //x.x.x.x/x.x.x.x
            if ((stringToNumber(parts[0]) < 0) || (stringToNumber(parts[0]) > 255)) {
                alertWinIP(cntrl.value, errmsg);
                return false;
            }
            if ((stringToNumber(parts[1]) < 0) || (stringToNumber(parts[1]) > 255)) {
                alertWinIP(cntrl.value, errmsg);
                return false;
            }
            return true;
        }
        parts = tokens[3].split("-");
        if (parts.length == 2) { //x.x.x.x-x.x.x.x
            first = stringToNumber(parts[0].substring(0, parts[0].length));
            second = stringToNumber(parts[1].substring(0, parts[1].length));
            if ((first >= 0) &&
                    (first <= 255) &&
                    (second >= 0) &&
                    (second <= 255)) {
                return true;
            }
        }
    }

    alertWinIP(cntrl.value, errmsg);
    return false;
}

/*            'js/Util.js',*/
/* Uncomment for debugging. */
/*var clogger = {
    enabled : true,
    debug : function(msg)
    {
        if (this.enabled)
        {
            if (window.console)
                window.console.log(msg);
        }
    }
};*/

/*global confirm,escape,alert,
qlist_realign_floating_header,qlist_realign_floating_footer,
escape,unescape,logdisplay_opts,
filter_columns,self*/
/*jshint supernew:true, scripturl:true*/

// cloneObject - rudimentary cloning function.
// (TODO: Possibly this is duplicating some other generic function
// already in the codebase.)
function cloneObject(src, dst)
{
    for (var attr in src)
    {
        dst[attr] = src[attr];
    }

    return dst;
}


function check(obj)
{
    obj.checked = true;
}

function uncheck(obj)
{
    obj.checked = false;
}

function enable(obj)
{
    obj.disabled = false;
}

function disable(obj)
{
    obj.disabled = true;
}

function show(obj)
{
    obj.style.display="";
}

function hide(obj)
{
    obj.style.display="none";
}

function display(obj, isYes)
{
    if (isYes) show(obj);
    else hide(obj);
}


function isUnchecked(obj)
{
    return !obj.checked;
}

function isEnabled(obj)
{
    return !obj.disabled;
}
/* this function redefined at util/util.js  bug 0385049
function setProperty(obj, property, value) {
    obj[property] = value;
}
*/
function setPropertyById(id, property, value) {
    var obj;

    if (obj = document.getElementById(id)) {
        setProperty(obj, property, value);
    }
}

function setPropertyByIds(idArray, property, value) {
    var i;

    for (i = 0; i < idArray.length; i++) {
        setPropertyById(idArray[i], property, value);
    }
}

function getElementsByNameRegex(rootObj, elementNames, re) {
    var i, j;
    var objElementArray;
    var coll = [];

    for (i = 0; i < elementNames.length; i++) {
    objElementArray = rootObj.getElementsByTagName(elementNames[i]);
    for (j = 0; j < objElementArray.length; j++) {
        if (objElementArray[j].name) {
            if (re.test(objElementArray[j].name)) {
                coll.push(objElementArray[j]);
            }
        } else if (objElementArray[j].id) {
            if (re.test(objElementArray[j].id)) {
                coll.push(objElementArray[j]);
            }
        }
    }
    }
    return coll;
}

function setPropertyByName(rootObj, elementNames, nameExp, property, value) {
    var i, j;
    var re = new RegExp(nameExp);
    var objElementArray;

    for (i = 0; i < elementNames.length; i++) {
        objElementArray = rootObj.getElementsByTagName(elementNames[i]);
        for (j = 0; j < objElementArray.length; j++) {
            if (re.test(objElementArray[j].name) && (!objElementArray[j].disabled || property == "disabled")) {
                setProperty(objElementArray[j], property, value);
            }
        }
    }
}

function disableElementsById(idArray, disabled) {
    setPropertyByIds(idArray, "disabled", disabled);
}

function disableElementsByName(rootObj, elementNames, nameExp, disabled) {
    setPropertyByName(rootObj, elementNames, nameExp, "disabled", disabled);
}

function checkInputByName(rootObj, nameExp, checked) {
    setPropertyByName(rootObj, ['input'], nameExp, "checked", checked);
}

function hideSection(controlObj, idArray) {
    var $idArray = $j();
    for (var i = 0; i < idArray.length; ++i) {
        $idArray = $idArray.add($j('#' + idArray[i]));
    }
    var hidden = !$idArray.first().is(':visible');
    $idArray.toggle(hidden);
    $j(controlObj).attr('src', "/theme/images/twistie_" + (hidden ? "expanded" : "collapsed") + ".gif");
}

// returns the new expanded state of the icon
function change_button_icon(object)
{
    var css = object;
    var strCss = css.getAttribute('class');
    if (strCss == "compact-visual-toggle")
    {
        css.setAttribute('class' , 'compact-visual-toggle active' )
        return true;
    }
    else
    {
        css.setAttribute('class' , 'compact-visual-toggle' )
        return false;
    }

}

// old twistie code:
// change_icon - flip between the expanded/collapsed icons
// returns the new expanded state of the icon
function change_icon(object)
{
    //image = ie4?object.firstChild.firstChild:object.firstChild.nextSibling.firstChild.nextSibling;
    var image = object;
    var strArr = image.src.split("/");
    var imgsrc = strArr[strArr.length-1];
    if (imgsrc == "twistie_collapsed.gif")
    {
        image.src = "/theme/images/twistie_expanded.gif";
        return true;
    }
    else
    {
        image.src = "/theme/images/twistie_collapsed.gif";
        return false;
    }
}

// DEPRECATED: only for use by old C pages
// qlist_toggle_section - expand or collapse a table section by setting each row to show or hidden.
// This is a replacement for the tree_control() function below.
// Note: This function requires jQuery.
function qlist_toggle_section(img, classNames) {
    // Using the image name to determine the current state is a bit ugly, but effective.
    //var bExpanded = change_icon(img);
    var bExpanded = change_button_icon(img);
    if (typeof classNames === "undefined") classNames = ".qlist_row";

    var aTrs = $j(img).closest("tr");
    if (!aTrs.length) return;

    // Flip the display state of each item.
    var cur_row = aTrs.next("tr");

    // Iterate the subsequent table rows until we hit an entry that may
    // be a section boundary (because it is of a different class).
    while (cur_row && cur_row.is(classNames))
    {
        cur_row = cur_row.toggle( bExpanded ).next("tr");
    }

    return bExpanded;
}

// DEPRECATED: only for use by old C pages
// tree_control - expand or collapse a table section by setting each row to show or hidden.
function tree_control(obj) {
    return qlist_toggle_section(obj, ".odd, .category, .disabled");
}

function implodeField(field, separator, onlySelected) {
    // return $j.map(field, function(item) {
    //     if(!onlySelected || item.selected) {
    //         return item.value;
    //     }}).join(separator);
      var i;
      var str = "";
      for (i = 0; i < field.length; i ++) {
            if (onlySelected) {
                  if (field[i].selected) {
                        if (str.length > 0) {
                              str += separator;
                        }
                        str += field[i].value;
                  }
            } else {
                  if (str.length > 0) {
                        str += separator;
                  }
                  str += field[i].value;
            }
      }
      return str;
}

function refreshFields(nameExp, elementNamesArray, refreshInterval) {
    var refreshFrameString = "refreshFrame";

    if (window.location.toString().indexOf(refreshFrameString,
            window.location.toString().length - refreshFrameString.length) > 0) {
        var i, j;
        var re = new RegExp(nameExp);
        var objElementArray;
        var refreshField;

        for (i = 0; i < elementNamesArray.length; i ++) {
            objElementArray = document.getElementsByTagName(elementNamesArray[i]);
            for (j = 0; j < objElementArray.length; j ++) {
                if (re.test(objElementArray[j].id)) {
                    refreshField = parent.document.getElementById(objElementArray[j].id);
                    if (refreshField) {
                        refreshField.innerHTML = objElementArray[j].innerHTML;
                        refreshField.setAttribute('style', objElementArray[j].getAttribute('style'));
                        refreshField.style.cssText = objElementArray[j].style.cssText;
                    }
                }
            }
        }

        if (refreshInterval) {
            window.setTimeout(function(){window.location = window.location;}, refreshInterval * 1000);
        }

    } else {
        var subFrame = document.createElement('iframe');

        subFrame.setAttribute('src', window.location.toString() +
            ((window.location.toString().split('?').length > 1) ? '&' : '?') + refreshFrameString);
        subFrame.setAttribute('name', 'refreshFrame');
        subFrame.setAttribute('height', '0');
        subFrame.setAttribute('width', '0');
        subFrame.setAttribute('frameborder', '0');
        document.body.appendChild(subFrame);
    }
}


// <select> field functions ---------------------------------------------------------------

function removeOptions(field) {
    var removedOptions = document.createElement("select");
    var i;
    var j = 0;

    for (i = 0; i < field.options.length; i++) {
    if (field.options[i].selected) {
        removedOptions.options[j] = new Option();
        removedOptions.options[j].text = field.options[i].text;
            removedOptions.options[j].value = field.options[i].value;
            removedOptions.options[j].selected = true;

            field.options[i] = null;
            i--;
            j++;
        }
    }

    return removedOptions;
}

function moveOptionField(fromField, toField) {
    var insertIndex = toField.options.length;
    var selectedOptions;
    var i;

    // find insertion point in destination field
    for (i = 0; i < toField.options.length; i ++) {
        if (toField.options[i].selected) {
                insertIndex = i + 1;
                toField.options[i].selected = false;
        }
    }

    // remove options from fromField
    selectedOptions = removeOptions(fromField);

    // add empty options by increasing length
    toField.options.length += selectedOptions.options.length;

    // shift old entries down
    for (i = (toField.options.length - 1); i >= (insertIndex + selectedOptions.options.length); i --) {
        toField.options[i].text = toField.options[i - selectedOptions.options.length].text;
        toField.options[i].value = toField.options[i - selectedOptions.options.length].value;
    }

    // insert new entries
    for (i = 0; i < selectedOptions.options.length; i ++, insertIndex ++) {
        toField.options[insertIndex].text = selectedOptions.options[i].text;
        toField.options[insertIndex].value = selectedOptions.options[i].value;
        toField.options[insertIndex].selected = true;
    }
}

function moveOptionUp(selectField) {
    var i;
    var oOption = new Option();
    var length = selectField.options.length;

    if (length === 0 || selectField.options[0].selected) {
        return 0;
    }

    for (i = 1; i < length; i ++) {
        if (selectField.options[i].selected) {
            oOption.text = selectField.options[i - 1].text;
            oOption.value = selectField.options[i - 1].value;

            selectField.options[i - 1].text = selectField.options[i].text;
            selectField.options[i - 1].value = selectField.options[i].value;
            selectField.options[i - 1].selected = true;

            selectField.options[i].text = oOption.text;
            selectField.options[i].value = oOption.value;
            selectField.options[i].selected = false;
        }
    }
}

function moveOptionDown(selectField) {
    var i;
    var oOption = new Option();
    var length = selectField.options.length;

    if (length === 0 || selectField.options[length - 1].selected) {
        return 0;
    }

    for (i = length - 1; i >= 0; i --) {
        if (selectField.options[i].selected) {
            oOption.text = selectField.options[i + 1].text;
            oOption.value = selectField.options[i + 1].value;

            selectField.options[i + 1].text = selectField.options[i].text;
            selectField.options[i + 1].value = selectField.options[i].value;
            selectField.options[i + 1].selected = true;

            selectField.options[i].text = oOption.text;
            selectField.options[i].value = oOption.value;
            selectField.options[i].selected = false;
        }
    }
}

function selectOptions(selectObj, optionArray, compareFn, selectValue, scroll) {
    var numberSelected = 0;
    var objOption = null;

    for (var i = 0; i < selectObj.length; i ++) {
        for (var j = 0; j < optionArray.length; j++) {
            if (compareFn(selectObj[i], optionArray[j]) === 0) {
                selectObj[i].selected = selectValue;
                numberSelected++;
                objOption = selectObj[i];
                break;
            }
        }
    }
    if (scroll && objOption) objOption.scrollIntoView();
    return numberSelected;
}

function moveOptions(fromObj, toObj, sort) {
    var optionArray = [];

    optionArray = optionsToArray(fromObj, 1, 1);
    insertOptions(toObj, optionArray, toObj.selectedIndex + 1);
    toObj.selectedIndex = -1;
    selectOptions(toObj, optionArray, compareObjTextString, true, false);

    if (sort) {
        sortOptions(toObj, compareObjTextString);
    }

    return optionArray;
}

function fastMoveOptions(fromObj, toObj, sort) {

     var i = 0, j = 0;
     var endIndexFrom =  fromObj.length;
     var endIndexTo = toObj.length;
     var option;
    var IE = false;

    toObj.selectedIndex = -1;

     while(i < endIndexFrom){
          if(fromObj.options[i].selected)
          {
               option = fromObj.options[i];
               fromObj.remove(i);
               if(sort)
               {
                    while(j < endIndexTo )
                    {
                         if(option.text <= toObj.options[j].text)
                              break;
                         j++;
                    }
                    try{
                    if(IE)
                        toObj.add(option, j);
                    else
                        toObj.add(option, toObj.options[j]);
                    }
                    catch(ex)  // IE
                    {
                    IE = true;
                         toObj.add(option, j);
                    }
                    toObj.options[j].selected = true;
                j++;
               }
               else
               {
                    try{
                    if(IE)
                        toObj.add(option);
                    else
                        toObj.add(option, null);
                    }
                    catch(ex)  // IE
                    {
                    IE = true;
                         toObj.add(option);
                    }
                    toObj.options[toObj.length].selected = true;
               }
               endIndexFrom--;
               endIndexTo++;
          }
        else
            i++;
     }
}

function insertOptions(selectObj, optionArray, index) {
    var resultArray;
    resultArray = optionsToArray(selectObj, 2, 1);
    arrayToOptions(selectObj, resultArray.splice(0, index).concat(optionArray).concat(resultArray));
}


/* TODO: too much redundant code in the optionsToArray function. Here is a
simpler (but untested) version:

function optionsToArray(selectObj, mode, remove, startIndex, endIndex)
{
    var optionArray = new Array();
    var i = startIndex ? startIndex : 0;
    endIndex = endIndex ? endIndex : selectObj.length;

    // loop over a subset of the select objects array.
    // Mode 0 means only unselected items.
    // Mode 1 means only selected items.
    // Mode 2 (default) means all items.
    for (; i<endIndex; i++)
    {
        if (mode == 0 && selectObj[i].selected)
            continue;

        if (mode == 1 && !selectObj[i].selected)
            continue;

        optionArray[optionArray.length] = selectObj[i];

        if (remove)
        {
            selectObj.removeChild(selectObj[i]);
            // Compensate for the change in item index.
            i--;
            endIndex--;
        }
    }

    return optionArray;
}
*/


function optionsToArray(selectObj, mode, remove, startIndex, endIndex) {
    var optionArray = [];
    var i = startIndex ? startIndex : 0;
    endIndex = endIndex ? endIndex : selectObj.length;

    while (i < endIndex) {
        switch (mode) {
        case 0 : // not selected
            if (!selectObj[i].selected) {
                optionArray[optionArray.length] = selectObj[i];
                if (remove) {
                    selectObj.removeChild(selectObj[i]);
                    endIndex--;
                    break;
                }
            }
            i++;
            break;
        case 1 : // selected
            if (selectObj[i].selected) {
                optionArray[optionArray.length] = selectObj[i];
                if (remove == 1) {
                    selectObj.removeChild(selectObj[i]);
                    endIndex--;
                    break;
                }
            }
            i++;
            break;
        // case 2 :
        default : // all
            optionArray[optionArray.length] = selectObj[i];
            if (remove == 1) {
                selectObj.removeChild(selectObj[i]);
                endIndex--;
                break;
            }
            i++;
        }
    }
    return optionArray;
}

function arrayToMembers(arr)
{
    // join on # so that comma separated strings still work
    return optionToString(arr).join('#');
}

function arrayToOptions(selectObj, optionArray, text, value) {
    if (!text) text = "text";
    if (!value) value = "value";

    for (var i = 0; i < optionArray.length; i++) {
        selectObj.options[selectObj.options.length] =
            new Option(optionArray[i][text], optionArray[i][value], optionArray[i].selected);
        selectObj.options[selectObj.options.length - 1].selected = optionArray[i].selected;
    }
}

function stringToOption(stringArray) {
    var optionArray = [];
    for (var i = 0; i < stringArray.length; i++) {
        optionArray[i] = new Option(stringArray[i], stringArray[i], false);
        optionArray[i].selected = false;
    }
    return optionArray;
}

function optionToString(optionArray) {
    for (var i = 0; i < optionArray.length; i++) {
        optionArray[i] = optionArray[i].value;
    }
    return optionArray;
}

function optionTextToString(optionArray) {
    for (var i = 0; i < optionArray.length; i++) {
        optionArray[i] = optionArray[i].text;
    }
    return optionArray;
}

function sortOptions(selectObj, compareFn) {
    var optionArray = optionsToArray(selectObj, 2, 1);
    optionArray.sort(compareFn);
    arrayToOptions(selectObj, optionArray);
}

function compareObjTextString(a, b) {
    if (a.text < b.text) return -1;
    if (a.text > b.text) return 1;
    return 0;
}

function compareObjValueString(a, b) {
    if (a.value < b.value) return -1;
    if (a.value > b.value) return 1;
    return 0;
}


// Array functions ----------------------------------------------------------------

function uniquefyArray(array1) {
    var array2 = [];
    var found = 0;

    for (var i = 0; i < array1.length; i++) {
        found = 0;
        for (var j = 0; j < array2.length; j++) {
            if (array1[i] == array2[j]) {
                found = 1;
                break;
            }
        }
        if (!found) {
            array2[array2.length] = array1[i];
        }
    }
    return array2;
}

function matchArray(array1, array2) {
    var array3 = [];

    for (var i = 0; i < array1.length; i++) {
        for (var j = 0; j < array2.length; j++) {
            if (array1[i] == array2[j]) {
                array3[array3.length] = array1[i];
            }
        }
    }
    return array3;
}

// quicksort objects ---------------------------------------------------------------------

function removeTextNodes(node) {
    for (var i = 0; i < node.childNodes.length; i ++) {
        if (node.childNodes.item(i).nodeType == 3) {
            node.removeChild(node.childNodes.item(i));
        }
    }
}

function swapChildNodes(node, childNode1, childNode2) {
    var temp;

    if (childNode1 == childNode2) return;

    temp = childNode1.cloneNode(true);
    node.replaceChild(temp, childNode1);
    node.replaceChild(childNode1, childNode2);
    node.replaceChild(childNode2, temp);
}

function quicksortChildNodes(node, left, right, attributeName) {
    var i, j;
    var pivot;
    var childNodes = node.childNodes;

    if (left < right) {
        swapChildNodes(node, childNodes.item(Math.floor((left + right) / 2)), childNodes.item(right));
        pivot = childNodes.item(right).getAttribute(attributeName);

        i = left - 1;
        j = right;

        for (;;) {
            while (childNodes.item(++ i).getAttribute(attributeName) < pivot);
            while (j > 0 && childNodes.item(-- j).getAttribute(attributeName) > pivot);

            if (i < j) {
                swapChildNodes(node, childNodes.item(i), childNodes.item(j));
            } else {
                break;
            }
        }
        swapChildNodes(node, childNodes.item(i), childNodes.item(right));

        quicksortChildNodes(node, left, i - 1, attributeName);
        quicksortChildNodes(node, i + 1, right, attributeName);
    }
}

// end quicksort routines -------------------------------------------------------------------

//NOTE: Slowly migrating regexes used in new fweb_core_all (angular) to js/fweb.util.js
//as fweb.util.commonRegExp.*
var RegExpCommon = new function RegExpCommon() {
    // E-mail address (ie. username@host)
    this.EMAIL_ADDRESS = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;

    // Host (ie. 1.2.3.4)
    this.IP_HOST = fweb.util.commonRegExp.IP_HOST;

    // Mask (ie. 255.255.255.0)
    this.IP_MASK = fweb.util.commonRegExp.IP_MASK;

    // Range (IP_HOST-IP_HOST)
    this.IP_RANGE = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(-(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|-((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|\/(3[0-2]|[1-2][0-9]|[0-9]))?$/;

    // Range with spaces (IP_HOST - IP_HOST)
    this.IP_RANGE_SPACES = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])(-(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|\s+-\s+((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])|\/(3[0-2]|[1-2][0-9]|[0-9]))?$/;

    // Range2 (ie, 1.2.3.[1-10])
    this.IP_RANGE2 = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}\[(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])-(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\]/;

    // Range with a wildcard (ie. 1.2.3.*)
    this.IP_WILDCARD = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}\*$/;

    // MAC address (ie. xx:xx:xx:xx:xx:xx)
    this.MAC_ADDRESS = /^[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}$/;

    // IP subnet (ie. 172.16.79.19/24 or 172.16.79.19/255.255.255.0 or 172.16.1.1)
    this.IP_SUBNET = fweb.util.commonRegExp.IP_SUBNET;

    // subnet only (/ and subnet part are strictly required ie., only accept 172.16.79.19/24 or 172.16.79.19/255.255.255.0)
    this.SUBNET = fweb.util.commonRegExp.SUBNET;

    this.IP6_HOST = fweb.util.commonRegExp.IP6_HOST;

    this.IP6_SUBNET = fweb.util.commonRegExp.IP6_SUBNET;

    // Multicast Host (ie. 224.0.0.0 to 239.255.255.255) http://en.wikipedia.org/wiki/Multicast_address
    this.MULTICAST_IP_HOST = /^(2(2[4-9]|3[0-9]))\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;

    // Range (MULTICAST_IP_HOST-MULTICAST_IP_HOST)
    this.MULTICAST_IP_RANGE = /^(2(2[4-9]|3[0-9]))\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])-(2(2[4-9]|3[0-9]))\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;

    // integer (0-9)
    this.INTEGER = /^-?[0-9]+$/;

    // hex integer (0-F/0-f)
    this.HEX_INTEGER = /^[0-9A-Fa-f]+$/;

    // name (no invalid characters)
    this.NAME = /^[^<>#()"']+$/;
    // this allows empty characters
    // TODO: split up the 'err_name' error message in jquery.validate.methods
    //       and split up IdentifierChecker
    this.NAME_NODOLLAR = /^[^<>#()"'$][^<>#()"']*$|^$/;
    // name (no invalid characters)
    this.NAME = /^[^<>#()"']+$/;

    // cross scripting characters
    this.XSS = fweb.util.commonRegExp.XSS;

    // integer range
    this.RANGE_INT = /^[0-9]*-[0-9]+$|^([0-9]+-?)$/;

    // time
    this.TIME = /^(([0-1]?[0-9]|[2][0-3]):([0-5]?[0-9]):([0-5]?[0-9]))?$/;

    // date
    this.DATE = /^([0-9]{4}-([0]?[0-9]|[1][0-2])-([0-2]?[0-9]|3[0-1]))?$/;

    // md5 signature
    this.MD5 = /^[0-9a-fA-F]{32}$/;

    // globally unique identifier (GUID)
    this.GUID = /^(([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})|(\s*\*\s*)|\s*)$/;

    // fully qualified domain name
    this.FQDN = /^([a-zA-Z0-9\-]{1,63}\.?)+$/;

    // domain name: at least 2 labels
    this.DOMAIN_NAME = fweb.util.commonRegExp.DOMAIN_NAME;
};

function matchFieldExp(str, regExpTestArray) {
    for (var i = 0; i < regExpTestArray.length; i++) {
    if (regExpTestArray[i].test(str)) {
        return i;
    }
    }
    return -1;
}

function alert_focus(input, msg)
{
    window.alert(msg);
    if (input.focus) input.focus();
    if (input.select) input.select();
    return false;
}

// TODO: remove usage of this function (and the above 2) along with Check_Input
//       replace with jQuery validate
function checkFieldExp(field, regExpTestArray, errorMessage) {
    if (matchFieldExp(field.value.toString(), regExpTestArray) < 0) {
        window.alert(errorMessage);
        field.focus();
        field.select();
        return false;
    }

    return true;
}

function getRadioValue(radioObj) {
    var i;

    if (!radioObj.length) {
        if (radioObj.checked) {
            return radioObj.value;
        }
    }

    for (i = 0; i < radioObj.length; i ++) {
        if (radioObj[i].checked) {
            if (radioObj[i].value) {
                return radioObj[i].value;
            } else {
                return i;
            }
        }
    }
    return null;
}

function initForm() {
    $j("textarea[expand]").textarea();
    try {
        $j(":input:visible:enabled:first").focus();
    } catch(e) {
        // wij_display_modal_dlg uses a timeout to show the actual content
        // it confuses IE8, and it begin complaing
        // ignoring its whining, because we'll use jQuery.dialog eventually
    }
}

function insertOption(selectField, oOption, compareFn, selectOption) {

    // selectField - <select> field to insert option
    // oOption - <option> field to insert
    // comparFn - comparative function to find index to insert at
    // selectOption - select option upon insertion

    var i;
    if (compareFn) {
        for (i = 0; i < selectField.length; i ++) {
            if (compareFn(oOption, selectField.options[i]) < 0) {
                for (var j = selectField.length; j > i; j --) {
                    selectField.options[j] = new Option(
                        selectField.options[j - 1].text,
                        selectField.options[j - 1].value,
                        selectField.options[j - 1].defaultSelected,
                        selectField.options[j - 1].selected);
                }
                break;
            }
        }
    } else {
        i = selectField.length;
    }
    selectField.options[i] = oOption;
    if (selectOption) {
        selectField[i].selected = true;
    }
}

// popup_generic_i - generic popup function
// TODO: need to make sure we always infer the appropriate alignment_parent.
function popup_generic_i(link, windowName, width, height, attrs, alignment_parent)
{
    // Make sure we align the window to the full frameset by default
    // and not to one particular frame or iframe.
    if (!alignment_parent)
    {
        if (window.parent)
            alignment_parent = window.parent.top;
        else
            alignment_parent = window.top;
    }

    // document.body.offsetWidth is the window width on IE and
    // window.innerWidth is the window width on Mozilla
    var x = ((window.innerWidth ? window.innerWidth : document.body.offsetWidth) - width)/2;
    var y = ((window.innerHeight ? window.innerHeight : document.body.offsetHeight) - height)/2;

    // This new calculation for window centering works better in HTML standards mode.
    // alignment_parent is the window used to center the popup (but it is not necessary the actual
    // parent of the window).
    if (alignment_parent)
    {
        var wd_o = (alignment_parent.innerWidth ? alignment_parent.innerWidth :
                    alignment_parent.document.body.offsetWidth);
        var ht_o = (alignment_parent.innerHeight ? alignment_parent.innerHeight :
                    alignment_parent.document.body.offsetHeight);

        x = (wd_o - width)/2;
        y = (ht_o - height)/2;

        var root = alignment_parent.document.documentElement;

        // I suspect that IE doesn't let us take the width & height of a frameset element,
        // so use the offsetHeight instead.
        var wd = root.clientWidth ? root.clientWidth : root.offsetWidth;
        var ht = root.clientHeight ? root.clientHeight : root.offsetHeight;
        x = (wd - width)/2;
        y = (ht - height)/2 + 50; // fudge for window titlebars, etc.
    }

    if(x < 0) x = 0;
    if(y < 0) y = 0;

    var popupWindow = window.open(link, windowName, attrs + ',width=' + width + ',height=' + height + ',top=' + y + ',left=' + x + ',screenX=' + x + ',screenY=' + y);

    if(!popupWindow)
        return null;
    popupWindow.resizeTo(width, height);
    popupWindow.moveTo(x, y);
    popupWindow.focus();

    return popupWindow;
}

function popup_resizable(link, windowName, width, height)
{
    return popup_generic_i(link, windowName, width, height, 'dependent=yes,scrollbars=yes,resizable=1');
}

function popup(link, windowName, width, height)
{
    return popup_generic_i(link, windowName, width, height, 'dependent=yes,scrollbars=yes,resizable=no');
}

// popup_nonscrollable - variant of popup_resizable without scrollbars (used by the JS console).
function popup_nonscrollable(link, windowName, width, height)
{
    return popup_generic_i(link, windowName, width, height, 'dependent=yes,scrollbars=no,resizable=1');
}

// popup_autosizing - popup an auto-sizing window. (NOTE: Auto-sizing not implemented here)
function popup_autosizing(link, windowName, width, height, alignment_parent)
{
    return popup_generic_i(link, windowName, width, height, 'dependent=yes,scrollbars=yes,resizable=no', alignment_parent);
}



function callFunctionArray(functionArray) {
    for (var i = 0; functionArray[i]; i ++) {
        functionArray[i]();
    }
}
/*global tt_mout*/
function obj_del(msg, url, obj) {
    var row_obj = obj.parentNode.parentNode;
    var class_old = '';

    if (row_obj && row_obj.tagName == 'TR' && row_obj.set_class) {
        row_obj.onmouseout= null;
        class_old = row_obj.className;
        row_obj.set_class('over');
    }
    if (confirm(msg)) {
        $j.submitPOST(url);
    }
    else {
        if (row_obj && row_obj.tagName == 'TR' && row_obj.set_class) {
            row_obj.onmouseout= tt_mout;
            row_obj.set_class(class_old);
        }
        return;
    }
}

// DEPRECATED: only for use by old C pages (FortiOS Carrier)
function obj_del_child(msg, path, name, mkey, child, child_key) {
    if (confirm(msg)) {
        CMDB.delete_child(path, name, mkey, child, child_key, function() {
            window.location.reload();
        });
    }
}

function clear_all(msg, url) {
    if (window.confirm(msg)){
        document.location = url;
    }
    return;
}

// serializeArray - convert a (possibly nested) array to a URL component.
// NOTE: this updated version is aimed at a performance improvement on IE6.
function serializeArray(inputArray)
{
    if (!inputArray) return "";

    var arr = [];

    for (var i = 0; i < inputArray.length; i++)
    {
        var entry = inputArray[i];

        if (typeof(entry) == "object" && entry.length)
        {
            arr.push(encodeURIComponent(serializeArray(entry)));
        }
        else
        {
            arr.push(encodeURIComponent(entry));
        }
    }

    return arr.join("&") + "&";
}


function deserializeArray(arrayString) {
    var stringArray = arrayString.split("&");
    var elementString;

    stringArray.length -= 1;
    for (var i = 0; i < (stringArray.length); i++) {
        elementString = decodeURIComponent(stringArray[i]);

        if (elementString.indexOf("&") < 0) {
                  stringArray[i] = elementString;
            if (elementString.indexOf("=") >= 0) {
                var fieldArray = elementString.split("=");
                stringArray[fieldArray[0]] = fieldArray[1];
            }
        } else {
            stringArray[i] = deserializeArray(elementString);
        }
    }
    return stringArray;
}

function dlg_close(url) {
/*
    var dlg_list = $j.merge([], fweb.dialog(), top.fweb.dialog());
        url = url || $j("#redir").val();

    if (dlg_list.length > 0) {
        dlg_list[dlg_list.length-1].close(null, {redir: url});
    } else if (window.opener) {
        window.complete();
    } else if (typeof url !== "undefined") {
        window.location.href = url;
    } else {
        history.back();
    }
*/
	var em;
	if ((em = document.getElementById("redir"))) {
		url = em.value;
	}
	if (window.opener) {
		if (window.opener.callback_handlers && window.opener.callback_handlers.should_call) {
			callFunctionArray(window.opener.callback_handlers);
		}
		window.close();
	} else if (parent && parent.wij_in_modal_op && parent.wij_in_modal_op()) {
		parent.wij_end_modal_dialog();
	} else if (window.wij_in_modal_op && window.wij_in_modal_op()) {
		wij_end_modal_dialog();
	} else if (url) {
		document.location = url;
	} else {
		history.go(-1);
	}
}

function appendFormField(thisForm, name, value) {
    var obj;

    obj = document.createElement("input");
    obj.type = "hidden";
    obj.name = name;
    obj.value = value;
    thisForm.appendChild(obj);
}

function get_xmlhttp() {
    var xmlhttp = null;

    try {
        xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch(e) {
        try {
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch(oc) {
            xmlhttp = null;
        }
    }

    if (!xmlhttp && typeof XMLHttpRequest != "undefined") {
        xmlhttp = new XMLHttpRequest();
    }

    return xmlhttp;
}

function send_request(str_url, str_body) {
    var xmlhttp = get_xmlhttp();
    var str_method = ((str_body === "") ? "GET" : "POST");

    xmlhttp.open(str_method, str_url, false);
    xmlhttp.send(str_body);

    return xmlhttp.responseText;
}

// send_simple_async_request - send an asynchronous XMLHttpRequest and don't wait for
// a response (useful for disconnection or keepalive messages).
function send_simple_async_request(str_url, str_body)
{
    var xmlhttp = get_xmlhttp();
    var str_method = ((str_body === "") ? "GET" : "POST");

    // True means to use an asynchronous connection. This is better than using synchronous
    // requests (since blocking connections may hang the browser if they fail).
    xmlhttp.open(str_method, str_url, true);

    // It is a good idea to thwart browser caching, since it is quite probable that we are
    // sending the exact same message string every time.
    // (Probably not all of the below are needed, but at least one of them does something. :-))
    xmlhttp.setRequestHeader("Pragma", "no-cache");
    xmlhttp.setRequestHeader("Cache-Control", "no-store, no-cache, must-revalidate");
    xmlhttp.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
    xmlhttp.setRequestHeader("X-CSRFTOKEN", fweb.get_csrf_token());

    xmlhttp.send(str_body);
}

function getObjectsByProperty(rootObj, elementNames, property, propertyExp)
{
    var re = new RegExp(propertyExp);
    var objElementArray;
    var objArray = [];

    for (var i = 0; i < elementNames.length; i++) {
        objElementArray = rootObj.getElementsByTagName(elementNames[i]);
        for (var j = 0; j < objElementArray.length; j++) {
            if (re.test(objElementArray[j][property])) {
                objArray[objArray.length] = objElementArray[j];
            }
        }
    }
    return objArray;
}

//temporarily make aliases in the global namespace.
var setCookie = fweb.util.persist.setCookie;
var getCookie = fweb.util.persist.getCookie;
var hasCookie = fweb.util.persist.hasCookie;
var removeCookie = fweb.util.persist.removeCookie;

function nodeToArray(parentNode, remove) {
    var nodeArray = [];
    var i = 0;

    while (i < parentNode.childNodes.length) {
        nodeArray[nodeArray.length] = parentNode.childNodes[i];
        if (remove) {
            parentNode.removeChild(parentNode.childNodes[i]);
            continue;
        }
        i++;
    }
    return nodeArray;
}

function arrayToNode(parentNode, nodeArray) {
    for (var i = 0; i < nodeArray.length; i++) {
        parentNode.appendChild(nodeArray[i]);

    }
    return parentNode;
}

function swapArrayElements(thisArray, index1, index2) {
    var temp;

    temp = thisArray[index1];
    thisArray[index1] = thisArray[index2];
    thisArray[index2] = temp;

    return thisArray;
}

function moveNode(nodeObj, distance) {
    var parentNode = nodeObj.parentNode;
    var nodeArray = nodeToArray(parentNode, true);

    var index1 = findInArray(nodeArray, nodeObj);
    var index2 = index1 + distance;

    if (index2 > nodeArray.length - 1) {
        index2 = nodeArray.length - 1;
    }

    if (index2 < 0) {
        index2 = 0;
    }

    nodeArray = swapArrayElements(nodeArray, index1, index2);
    arrayToNode(parentNode, nodeArray);

    return nodeArray;
}

function arrangeNodesByAttribute(nodeArray, attributeArray, attributeName) {
    for (var i = 0; i < attributeArray.length; i++) {
        for (var j = i; j < nodeArray.length; j++) {
            if (nodeArray[j].nodeType != 1) continue;

            if (nodeArray[j].getAttribute(attributeName) == attributeArray[i]) {
                swapArrayElements(nodeArray, j, i);
                break;
            }
        }
    }
    return nodeArray;
}

function findInArray(thisArray, elementToFind) {
    var index = -1;

    for (var i = 0; i < thisArray.length; i++) {
        if (thisArray[i] == elementToFind) {
            index = i;
            break;
        }
    }
    return index;
}

function nodeToString(nodeArray, attributeName) {
    for (var i = 0; i < nodeArray.length; i++) {
        nodeArray[i] = nodeArray[i].getAttribute(attributeName);
    }
    return nodeArray;
}

// table row functions

function getRows(parentNode, cookieName) {
    var cookieString = getCookie(cookieName);

    if (!cookieString) {
        cookieString = "";
    }

    var idArray = deserializeArray(cookieString);

    removeTextNodes(parentNode);

    var nodeArray = nodeToArray(parentNode, true);
    nodeArray = arrangeNodesByAttribute(nodeArray, idArray, 'id');
    arrayToNode(parentNode, nodeArray);
}

function setRows(parentNode, cookieName) {
    var nodeArray = nodeToArray(parentNode, false);

    nodeArray = nodeToString(nodeArray, 'id');

    setCookie(cookieName, serializeArray(nodeArray));
}

function moveRow(id, distance) {
    var rowNode = document.getElementById(id);

    moveNode(rowNode, distance);
}

function cat_members(obj_sel, obj_mem)
{
    var len = obj_sel.length;
    var i;
    var members = '';

    if (len >0) {
        members = obj_sel.options[0].text;
        for (i = 1; i < len; i++) {
            members = members + '#' + obj_sel.options[i].text;
        }
        obj_mem.value = members;
    }
}

// TODO: replace this function with jQuery validate
function validateFieldRange(fieldObj, minValue, maxValue, errorMessage) {
    var v = fieldObj.value;
    var fieldValue = parseInt(v, 10);

    if ((fieldValue != -1) && (fieldValue >= minValue && fieldValue <= maxValue)) {
        return true;
    }

    alert(errorMessage);
    fieldObj.focus();
    fieldObj.select();
    return false;
}

// filter functions

function setFilterDisplay(filterCookieArray, filter) {
    if (!filter) return filterCookieArray;
    if (!filterCookieArray) {
        filterCookieArray = [];
    }
    for (var i = 0; i < filterCookieArray.length; i++) {
        if (filterCookieArray[i][0] == filter.fieldName) {
            filterCookieArray[i] = filter.toArray();
            return filterCookieArray;
        }
    }
    filterCookieArray[filterCookieArray.length] = filter.toArray();
    return filterCookieArray;
}

function removeFilterDisplay(filterCookieArray, fieldName) {
    if (!filterCookieArray) {
        filterCookieArray = [];
    }
    for (var i = 0; i < filterCookieArray.length; i++) {
        if (filterCookieArray[i][0] == fieldName) {
            filterCookieArray.splice(i, 1);
            break;
        }
    }
    return filterCookieArray;
}

function addEvent(obj, type, fn)
{
    if (obj.addEventListener)
    obj.addEventListener( type, fn, false );
    else if (obj.attachEvent) {
    obj["e" + type + fn] = fn;
    obj[type + fn] = function() {
        obj["e" + type + fn]( window.event );
    };
    obj.attachEvent( "on" + type, obj[type + fn] );
    }
}

function removeEvent(obj, type, fn)
{
    if (obj.removeEventListener)
    obj.removeEventListener( type, fn, false );
    else if (obj.detachEvent) {
    obj.detachEvent( "on" + type, obj[type  +fn] );
    obj[type + fn] = null;
    obj["e" + type + fn] = null;
    }
}

function buttonHideAllDropdown(e) {
    var remove = 1;
    var obj = e.target ? e.target : e.srcElement;
    var ul_obj = null;

    try {
            if (obj.className == "options_button") {
                ul_obj = obj.parentNode.parentNode.parentNode.parentNode.getElementsByTagName('ul')[0];
            }
            else {
                ul_obj = null;
            }
    }
    catch (err) {
        ul_obj = null;
    }

    var coll = document.getElementsByTagName("ul");

    for (var i = 0; i < coll.length; i++) {
        if (coll[i] == ul_obj) {
            if (ul_obj.style.display === '') remove = 0;
        }
        else if (coll[i].className == "dropdown") {
            coll[i].style.display = 'none';
        }
    }
    if (remove) removeEvent(document, 'click', buttonHideAllDropdown);
}

function getCheckedValues(re) {
    var i;
    var objElementArray;
    var coll = [];

    objElementArray = document.getElementsByTagName("input");
    for (i = 0; i < objElementArray.length; i++) {
    if (re.test(objElementArray[i].name)) {
        if (objElementArray[i].checked) {
        coll.push(objElementArray[i].value);
        }
    }
    }
    return coll;
}

var escapeHTML;
(function() {
    var entityMap = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            '\'': '&apos;',
            '\\': '&bsol;'
        },
        regEx = /[&<>"'\\]/g;

    function entityHTML(s) { return entityMap[s]; }

    escapeHTML = function(html) {
        if (!regEx.test(html)) { return html; }
        return html.replace(regEx, entityHTML);
    };
})();


function xnode2String(s)
{
    var str = '';
    if (!s) return '';
    for(var i=0; i<s.length; i++)
    {
        if (s[i].firstChild) str += s[i].firstChild.nodeValue;
    }
    return str;
}

// ========== REQUEST ====================================================================================================

var Request = {};

Request.send = function(url, method, callback, data, urlencoded) {
    var req = get_xmlhttp();
    var readychange = function() {
        if (req.readyState == 4) {// only if req shows "loaded"
            if (req.status == 200) {// only if "OK"
                if (method=="POST") {
                    if (callback) {
                        callback(req);
                        callback = null;
                    }
                } else {
                    if (callback) {
                        callback(req,data);
                        callback = null;
                    }
                }
            } else if (typeof req == "undefined" || typeof req.status == "undefined") {
                if (callback) callback = null;
            } else if (req.status == 404) { //page not found
                alert('Request URL was not found.');
                if (callback) {
                    callback(req);
                    callback = null;
                }
            }
        }
    };

    function do_request() {
        if (method=="POST") {
            req.open("POST", url, true);
            if (urlencoded) req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            req.setRequestHeader("X-CSRFTOKEN", fweb.get_csrf_token());
            req.onreadystatechange = readychange;
            req.send(data);
        } else {
            req.open("GET", url, true);
            req.onreadystatechange = readychange;
            req.send(null);
        }
    }
    do_request();
    return req;
};

Request.sendRawPOST = function(url, data, callback) {
    Request.send(url, "POST", callback, data, false);
};
Request.sendPOST = function(url, data, callback) {
    Request.send(url, "POST", callback, data, true);
};
Request.sendGET = function(url, callback, args) {
    return Request.send(url, "GET", callback, args);
};


// ========== Inactivity timer ===========

function setInactiveCountDown(secs)
{
    var twind = null;

    if (window.opener)
        twind = window.opener.top.window;
    else
        twind = top.window;

    if (twind.inactiveOpenerTimer != null) {
        twind.clearTimeout(twind.inactiveOpenerTimer);
        twind.inactiveOpenerTimer = null;
    }

    if (twind.inactiveTimer != null ) {
        twind.clearTimeout(twind.inactiveTimer);
        twind.inactiveTimer = null;
    }

    saved_inactivity_timeout_val = secs;
    inactivity_timer_expired = false;

    if (window.opener)
        twind.inactiveOpenerTimer = twind.setTimeout("inactiveCountDown()", secs*1000);
    else
        twind.inactiveTimer = twind.setTimeout("inactiveCountDown()", secs*1000);
}


function resetInactiveCountDown()
{
    setInactiveCountDown(saved_inactivity_timeout_val);
}

// get_last_child_of_type - generic DOM traversal function, such as would be
// used to append new rows to a table.
function get_last_child_of_type(obj, type)
{
    // TODO: replace with $j(obj).children(type + ':last-of-type')
    var i, len;

    try
    {
        len = obj.childNodes.length;
    }
    catch (e)
    {
        return null;
    }

    for (i = len-1; i >= 0; i--)
    {
        if (obj.childNodes[i].nodeName == type)
        {
            return obj.childNodes[i];
        }
    }

    return null;
}


// tbl_realign_columns - align header columns to content table when they
// are implemented within separate tables (e.g. for scrolling).
// Note: we may need to call this to readjust the column widths when
// resizing the window.
function tbl_realign_columns(tbl_hdr, tbl)
{
    // Find all cells in the table that has the same number of
    // columns as the header (this is necessary because some tables
    // have spacer rows, etc).
    var tblElems = [];
    var hdrElems = [];

    // get all cells from header table
    function get_hdr_elems()
    {
        $j("tr.heading", tbl_hdr).each(
            function(i) {
                hdrElems = $j(hdrElems).add(this.cells);
                tblElems = $j(tblElems).add(tbl.rows[i].cells);
            });
        return hdrElems.length;
    }

    if (!get_hdr_elems() || tblElems.length != hdrElems.length)
        return;

    // make two table same width
    $j(tbl_hdr).width($j(tbl).width())
        .css("min-width", ($j("#main_window")[0] || $j("body")[0]).clientWidth);

    // Now sync the alignment all of cells to the table header.
    $j(hdrElems).each(function(i) {
        //var w = tblElems[i].offsetWidth;
        // to adapt new style of list, 2016-12-6
        var w = tblElems[i].clientWidth;
        $j("div:first", this).width(w);
        $j(this).width($j(this).attr("defWidth") ? "" : w);
    });
}

// relocate_tbl_hdr - Move the <thead> element into its own table
// Note: this is similar to matchTables, but that function assumes
// that the table content is located within an auto-sizing div, whereas
// with this function it is more likely to be directly in the
// document body.
function relocate_tbl_hdr(contentTable, headerTable)
{
    var rows = 1;

    // There are 2 cases:
    // 1. a <thead> block containing multiple <th> nodes.
    // 2. a <tr class="heading"> containing multiple <td>'s.
    function locate_table_header()
    {
        var hdr = contentTable && contentTable.rows[0];
        $j(hdr.cells).each(function() {
            var r = $j(this).attr("rowspan");
            if (r > rows) rows = r;
        });
        return hdr;
    }

    if (!locate_table_header())
        return;

    // make fixed header table has same style as content table
    $j(headerTable).addClass($j(contentTable).attr("class"));
    $j(headerTable).attr("cellspacing", $j(contentTable).attr("cellspacing"));
    // padding must be 0 inside table cells to get good align
    $j(headerTable).attr("cellpadding", 0);
    $j(contentTable).attr("cellpadding", 0);

    // clone content tabls's header to fixed header table
    for (var i = 0; i < rows; i++) {
        $j(contentTable.rows[i]).clone().appendTo(headerTable)
        /* Fix heading cells width so that the fix header table matches the content */
        .children().each(function() {
            $j(this).html("<div class=tbh_spacer height=1 width=1>" + $j(this).html() + "</div>"); });
    }

    // Now realign the first row of the data table to match the columns
    // in the cloned header.
    tbl_realign_columns(headerTable, contentTable);

    // realign header to content when resize/scroll
    $j(window).resize(function() {
        tbl_realign_columns(headerTable, contentTable); });
    $j(document).click(function() {
        tbl_realign_columns(headerTable, contentTable); });
    $j(window).scroll(function() {
        $j("#hrdtc").css("left", -$j(this).scrollLeft()); });
}

/*
 * realign content table columns size match with floating header's
 * will consume much more process than tbl_realign_columns()
 */
function tbl_realign_tbl_columns(tbl_hdr, tbl)
{
    // Find all cells in the table that has the same number of
    // columns as the header (this is necessary because some tables
    // have spacer rows, etc).
    var tblElems = [];
    var hdrElems = [];

    // get all cells from header table
    function get_hdr_elems()
    {
        $j("tr.heading", tbl_hdr).each(
            function(i) {
                hdrElems = $j(hdrElems).add(this.cells);
                tblElems = $j(tblElems).add(tbl.rows[i].cells);
            });
        return hdrElems.length;
    }

    if (!get_hdr_elems() || tblElems.length != hdrElems.length)
        return;

    // Now sync the alignment all of cells to the table header.
    $j(hdrElems).each(function(i) {
        var w = this.offsetWidth;
        // make all header's div same as cell width
        $j("div:first", this).width(w);

        // align content table cell as header cell
        if ($j(this).attr("defWidth")) {
            // use defWidth for scroll bar, or auto without scroll bar
            var minw = parseInt($j(this).attr("defWidth"), 10);
            $j(tblElems[i]).width(w <= minw ? minw : "");
        }
        else {
            $j(tblElems[i]).width(w);
        }
    });

    // make two table same width
    $j(tbl_hdr).width($j(tbl).width());
}

function relocate_tbl_hdr2(contentTable, headerTable)
{
    var lastCell;
    var widths = [];

    // how many header rows and fixed width of each column.
    function locate_table_header()
    {
        var cell;
        var hdr = $j("thead", contentTable);

        $j("th,td", hdr).each(function() {
            cell = $j(this);
            lastCell = cell;
            widths.push([cell, cell.width()]);
        });

        // keep record of last cell's width
        $j(lastCell).attr("defWidth", $j(lastCell).width())
            .css("min-width", "30px");

        // performance improved when many columns
        $j(widths).each(function() {
                if (this[1] < 2) return;
                this[0].width(this[1]);
            });

        return hdr;
    }

    if (!locate_table_header())
        return;

    // use fixed table layout
    $j(contentTable)
        .addClass("oneline")
        .css("table-layout", "fixed");

    // copy content table style to header table
    $j(headerTable)
        .addClass($j(contentTable).attr("class"))
        .css("table-layout", $j(contentTable).css("table-layout"))
        .attr("cellspacing", $j(contentTable).attr("cellspacing"))
        .attr("cellpadding", $j(contentTable).attr("cellpadding"));

    // make two table same width
    $j(headerTable).width($j(contentTable).width())
        .css("min-width", ($j("#main_window")[0] || $j("body")[0]).clientWidth);

    // clone content table's header to fixed header table
    $j("thead", contentTable).clone().appendTo(headerTable);

    $j("th,td", $j("thead", headerTable))
        .each(function(i) {
                // skip non-visible cell
                if (widths[i][1] < 2) return;
                var that = this;
                $j(this).wrapInner($j("<div class=tbh_spacer></div>"));

                $j("div:first", this)
                    .width(widths[i][1])
                    .resizable({
                        minWidth: 30, maxWidth: 600,
                        handles: 'e', alsoResize: this,
                        // before start, we have to make the last visible column width to auto
                        start: function(event, ui) {
                            $j(headerTable).width("");
                            $j(lastCell).width("");
                        },
                        resize: function(e, ui) {
                            /* disable realtime resizing due to performance issue */
                            //tbl_realign_tbl_columns(headerTable, contentTable);
                        },
                        // on stop, realign headerTable, contentTable
                        stop: function(event, ui) {
                            // ui layout will change the height of cell
                            $j(this).height("");
                            $j(that).height("");

                            if (that == lastCell) {
                                // last cell resizing
                                $j(lastCell).attr("defWidth", $j(lastCell).width());
                            }

                            tbl_realign_tbl_columns(headerTable, contentTable);
                            tbl_save_column_widths(headerTable);

                            // IE: re-align scroll status
                            $j("#hrdtc").css("margin-left", "-"+$j("#main_window").scrollLeft()+"px");

                            qlist_realign_floating_header();
                            qlist_realign_floating_footer();
                        }
                    });
                lastCell = this;
            });

    $j(window).scroll(function() {
        $j("#hrdtc").css("left", -$j(this).scrollLeft()); });
    $j(window).resize(function() {
        tbl_realign_columns(headerTable, contentTable); });
}

function tbl_save_column_widths(table) {
    var cx, fx;
    var cell;
    var label;
    var id;
    var column_info = [];
    var log_id = logdisplay_opts.type; //? how is logdisplay_opts set?

    for (cx=0; cx<table.rows[0].cells.length; cx++) {
        cell = table.rows[0].cells[cx];
        label = $j.trim($j(cell).text());
        id = "";

        for (fx=0; fx<filter_columns.length; fx++) {
            if (filter_columns[fx][1] == label) {
                id = filter_columns[fx][0];
                break;
            }
        }

        if (id) {
            column_info.push({"name" : id, "value" : $j(cell).width()});
        }
    }

    setCookie("log/display/size" + log_id, $j.param(column_info));
}

// can use with "style.display, /^none$/" to determine if a object is visible (use 'style.visibility, hidden' as well)
function getParentProperty(obj, property, re) {
    var value;
    var objArray = [];

    while (obj && obj.style) {
        value = obj[property];

        if (re.test(value)) {
            objArray.push(obj);
        }
        obj = obj.parentNode;
    }
    return objArray;
}


function List(id, form, size) {
    this.id = id;
    this.list = [];
    this.max_size = size;
    this.form = form;
    this.fields = [];
    this.checkDuplicate = true;

    this.find = function (key) {
        for (var i = 0; i < this.list.length; i++) {
            if (key == this.list[i][0]) return i;
        }
        return -1;
    };

    this.addEntry = function (valueArray) {
        if (this.list.length >= this.max_size) throw new Error("err_max_size");
        if (this.checkDuplicate && this.find(valueArray[0]) >= 0) throw new Error("err_duplicate");

        var newArray = valueArray.toString().split(",");

        this.list.push(newArray);

        var tr = this.createListEntry(this.list.length - 1);
        document.getElementById(this.id).tBodies.item(0).appendChild(tr);
        return true;
    };

    this.editEntry = function (index, valueArray) {
        if ((index < 0) && (this.list.length >= this.max_size)) throw new Error("err_max_size");
        if (this.find(valueArray[0]) >= 0 && this.find(valueArray[0]) != index) throw new Error("err_duplicate");

        var newArray = valueArray.toString().split(",");

        if (index < 0) {
            this.list.push(newArray);
            var tr = this.createListEntry(this.list.length - 1);
            document.getElementById(this.id).tBodies.item(0).appendChild(tr);
        }
        else {
            this.list[index] = newArray;
            this.displayList();

        }
        return true;
    };

    this.deleteEntry = function (index) {
        this.list.splice(index, 1);
        this.displayList();
    };

    this.setToForm = function () {
        var currentField = this.form[this.id + "_" + this.fields[0]];
        var currentFieldLength = currentField.length ? currentField.length : 1;

        for (var i = 0; i < this.list.length; i++) {
            var j;
            if (i < currentFieldLength) {
                for (j = 0; j < this.fields.length; j++) {
                    currentField = this.form[this.id + "_" + this.fields[j]][i];
                    currentField.value = this.list[i][j];
                }
            }
            else {
                for (j = 0; j < this.fields.length; j++) {
                    appendFormField(this.form, this.id + "_" + this.fields[j], this.list[i][j]);
                }
            }
        }
    };

    this.toForm = function () {
        for (var i = 0; i < this.list.length; i++) {
            for (var j = 0; j < this.fields.length; j++) {
                appendFormField(this.form, this.id + "_" + this.fields[j], this.list[i][j]);
            }
        }
    };

    this.displayList = function () {
        var tbl, tbody, tr, i;
        tbl = document.getElementById(this.id);
        tbody = tbl.tBodies.item(0);
        tbl.removeChild(tbody);
        tbody = document.createElement("TBODY");
        tbl.insertBefore(tbody, null);
        for (i = 0; i < this.list.length; i++) {
            tr = this.createListEntry(i);
            tbody.insertBefore(tr, null);
        }
    };
}

List.prototype.createListEntry = function (index) {
        var tr, td, text, a, img;
        tr = document.createElement("TR");
        td = document.createElement("TD");
        text = document.createTextNode(index + 1);
        tr.insertBefore(td, null);
        td.insertBefore(text, null);
        for (var i = 0; i < this.list[index].length; i++) {
            td = document.createElement("TD");
            text = document.createTextNode(this.list[index][i]);
            tr.insertBefore(td, null);
            td.insertBefore(text, null);
        }
        td = document.createElement("TD");
        a = document.createElement("A");
        a.href = "javascript: deleteEntry(" + (+index) + ");";
        img = document.createElement("IMG");
        img.setAttribute("src", "/images/delete.gif");
        tr.insertBefore(td, null);
        td.insertBefore(a, null);
        a.insertBefore(img, null);
        return tr;
    };


function setPaging(lineCurrent, lineTotal, linesPerPage, url, name, source, target) {
    var lineNew = 0;
    if (linesPerPage <= 0) linesPerPage = Math.pow(2,32) - 1;
    var pageTotal = Math.ceil(lineTotal/linesPerPage);
    var pageCurrent = Math.ceil(lineCurrent/linesPerPage);
    var obj;

    if (pageTotal <=0 ) pageTotal = 1;
    this.gotoUrl = function () {
        target.location.replace(this.getAttribute("url"));
    };

    this.gotoPage = function (event) {
        if (!event) event = window.event;

        // parent.action refer to the top frame in log access page
        if (!event) event = parent.action.window.event;

        var key = event.which ? event.which : event.keyCode;

        if (key == 13) {
            var pageNum = parseInt(this.value, 10);
            if (isNaN(pageNum) || pageNum < 1 || pageNum > pageTotal) {
                alert(this.getAttribute("err_page_current"));
            } else {
                lineNew = (pageNum - 1) * linesPerPage + 1;
                target.location.replace(setQueryValue(url, name, lineNew));
            }
            return false;
        }
    };

    if (!source) source = document;
    if (!target) target = document;
    if (!url) url = target.location.toString();

    // first
    obj = source.getElementById("page_first");
    if (obj) {
        if (pageCurrent <= 1) {
            obj.className = "list_button_disabled";
            obj.onclick = null;
        } else {
            lineNew = 1;
            obj.className = "list_button";
            obj.setAttribute("url", setQueryValue(url, name, lineNew));
            obj.onclick = this.gotoUrl;
        }
    }

    // previous
    obj = source.getElementById("page_prev");
    if (obj) {
        if (pageCurrent <= 1) {
            obj.className = "list_button_disabled";
            obj.onclick = null;
        } else {
            lineNew = ((pageCurrent - 2) * linesPerPage + 1);
            obj.className = "list_button";
            obj.setAttribute("url", setQueryValue(url, name, lineNew));
            obj.onclick = this.gotoUrl;
        }
    }

    // current
    obj = source.getElementById("page_current");
    if (obj) {
        obj.value = pageCurrent;
        obj.disabled = (pageTotal <= 1);
        obj.onkeypress = this.gotoPage;
    }

    // total
    obj = source.getElementById("page_total");
    if (obj) obj.innerHTML = pageTotal;

    // next
    obj = source.getElementById("page_next");
    if (obj) {
        if (pageCurrent >= pageTotal) {
            obj.className = "list_button_disabled";
            obj.onclick = null;
        } else {
            lineNew = (pageCurrent * linesPerPage + 1);
            obj.className = "list_button";
            obj.setAttribute("url", setQueryValue(url, name, lineNew));
            obj.onclick = this.gotoUrl;
        }
    }

    // last
    obj = source.getElementById("page_last");
    if (obj) {
        if (pageCurrent >= pageTotal) {
            obj.className = "list_button_disabled";
            obj.onclick = null;
        } else {
            lineNew = ((pageTotal - 1) * linesPerPage + 1);
            obj.className = "list_button";
            obj.setAttribute("url", setQueryValue(url, name, lineNew));
            obj.onclick = this.gotoUrl;
        }
    }
}

function getQueryValue(url, name)
{
  name = name.replace(/[\[]/,"\\[").replace(/[\]]/,"\\]");
  var regexS = "[\\?&]"+name+"=([^&#]*)";
  var regex = new RegExp(regexS);
  var results = regex.exec(url);
  if (results == null)
    return "";
  else
    return decodeURIComponent(results[1].replace(/\+/g, " "));
}

function getParams(params) {
    var href = location.href, key;
    for (key in params) {
        if (params.hasOwnProperty(key)) {
            var val = getQueryValue(href, key);
            if (val) {
                params[key] = val;
            }
        }
    }
    return params;
}

function setQueryValue(url, name, value) {
    var re = new RegExp("([?|&])" + name + "=.*?(&|$)");

    var str = (value == null) ? "" : name + "=" + encodeURIComponent(value);
    var done = 0;
    var newUrl = (url || "").replace(re, function ($m, $1, $2) {
            done = 1;
            return str ? $1+str+$2 : ($1 == '?' ? $1 : $2);
        });
    if (done) {
        // remove '?' if no query after
        if (newUrl.indexOf('?') == newUrl.length-1) newUrl = newUrl.substr(0, newUrl.length-1);
    } else {
        // append new query
        if (str) newUrl += (newUrl.indexOf("?") < 0 ? "?" : "&") + str;
    }

    return newUrl;
}

function setQueryValues(url, names, values) {
    var re;
    var newUrl;

    for (var i = 0; i < names.length; i++) {
        re = new RegExp("(&|\\?)(" + names[i] + ")[^&]*");

        newUrl = (values == null) ? url.replace(re, "$1") : url.replace(re, "$1$2=" + encodeURIComponent(values[i]));
        if (newUrl == url) {
            newUrl = url + ((url.indexOf("?") < 0) ? "?" : "&") + names[i] + "=" + encodeURIComponent(values[i]);
        }

        url = newUrl;
    }
    return newUrl;
}

function removeQueryValue(url, name) {
    var re = new RegExp("(&|\\?)(" + name + ")[^&]*(&|$)");

    var newUrl = url.replace(re, "$1");

    return newUrl;
}

function resetFieldValue(el)
{
    if (el && el.style.color !== '' )
    {
        el.value = '';
        el.style.color = '';
    }
}

function delete_all_selected(del_all_msg, separator, use_index, result_id, form_index, re)
{
    var count=0, i;
    var obj, objArray;
    var checked_lines = "";

    if (!result_id)  result_id = "checked_lines";
    if (!form_index) form_index = 0;
    if (!re)         re = /^line_checkbox/;

    objArray = getElementsByNameRegex(document, ['input'], re);

    for (i = objArray.length-1; i >= 0; i--) {
        obj = objArray[i];
        if (obj.checked && !obj.disabled) {
            if (count !== 0)
                checked_lines = checked_lines + separator;

            checked_lines = checked_lines + (use_index ? i : obj.value);
            count = count + 1;
        }
    }

    if (count !== 0) {
        document.getElementById(result_id).value = checked_lines;
        if (!del_all_msg || confirm(del_all_msg))
            document.forms[form_index].submit();
    }
}

function get_iframe_object(iframe_name, wnd)
{
    var iframe = wnd.document.getElementById(iframe_name);

    // The detached windows have their own resize handlers and can be
    // more flexible. So, if we are viewing from a popup window we can
    // ignore the request to adjust the height.
    var loc_str = String(wnd.document.location);
    if (wnd.opener || window.opener || loc_str.indexOf("detach") != -1)
    {
        return;
    }

    // In IE occasionally wnd.document does not have what we were looking
    // for, depending on where the refresh call came from. In this case,
    // we can check the current window instead of the parent.
    if (!iframe)
    {
        iframe = document.getElementById(iframe_name);
    }

    return iframe;
}

function get_iframe_body(iframe)
{
    var doc = iframe.contentWindow || iframe.contentDocument;

    if (doc.document)
        doc = doc.document;

    if (doc && doc.body)
    {
        return doc.body;
    }

    return null;
}

function get_iframe_height(iframe)
{
    var body = get_iframe_body(iframe);

    if (!body) return;

    // get body's real height with 'auto'
    body.style.height = 'auto';

    return $j(body).outerHeight();
}

function update_iframe_height(iframe_id, win_obj, clear_height, min_height)
{
    // Maximum % of visible screen height that can be used.
    var auto_size_height_ratio = 0.8;
    var wnd = win_obj ? win_obj : window;
    var iframe = get_iframe_object(iframe_id, wnd);

    if (!iframe) {
        return;
    }

    // This causes flicker if used too frequently
    if (clear_height)
    {
        iframe.style.height = '5px';
    }

    var height = get_iframe_height(iframe);

    // jQuery should be available on all pages.
    if (typeof wnd.jQuery != "undefined")
    {
        // Ensure that the auto-size calculations doesn't create a window
        // that is too big for the screen.
        var max_height = Math.floor( wnd.jQuery(wnd).height() * auto_size_height_ratio );
        if (height > max_height)
        {
            height = max_height;
        }
    }

    // Allow a minimum height to be specific for auto-sizing iframes.
    if (typeof min_height === "number")
    {
        height = Math.max(height, min_height);
    }

    if (height > 0)
    {
        // TODO: Auto-calculate the 3px padding that is inserted here.
        iframe.style.height = (height + 3) + 'px';
    }
}

function doSort(sort_field_array, sort_cookie_name) {
    if (!sort_cookie_name) {
        sort_cookie_name = "sort_cookie";
    }

    setCookie(sort_cookie_name, sort_field_array.join(","));

    document.location.reload();
}

// is_left_button_event - determines whether a mouse event (e.g. onmousedown) was triggered
// by a left mouse button click.
function is_left_button_event(ev)
{
    // Some browsers apparently don't support this attribute, so ignore them for now.
    if (!ev.button)
        return true;

    // ev.button is a bit mask of the left, middle, and right buttons.
    // TODO: Isn't this wrong? left button should be 0...
    if (ev.button & 0x01)
        return true;

    return false;
}


/******************************
 Functions for URL building/parsing
******************************/

// update_url_component - add or modify the value of one attribute in a URL.
function update_url_component(url, attr, val)
{
    // append_url_fragment - add the new attribute at the end of the string.
    function append_url_fragment()
    {
        // Add the new attribute-value pair.
        var idx = url.indexOf("?");
        var sep_char = (idx < 0 ? "?" : "&");
        url += sep_char + attr + "=" + val;
        return url;
    }

    // replace_url_fragment - replace the existing attribute-value declaration
    // in the string.
    function replace_url_fragment(idx)
    {
        var end_idx = url.indexOf("&", idx + attr.length);
        var new_url = url.substring(0, idx + 1) + attr + "=" + val;
        if (end_idx > 0)
            new_url += url.substring(end_idx);
        return new_url;
    }

    // First look for the attribute as the first URI component.
    var srch_str = "?" + attr + "=";
    var idx = url.indexOf(srch_str);

    if (idx >= 0)
    {
        return replace_url_fragment(idx);
    }

    // Next look for the attribute as a non-initial URI component.
    // Note: These two stages could probably be combined using / regular expressions,
    // but the JS syntax for how to do it is beyond me...
    srch_str = "&" + attr + "=";
    idx = url.indexOf(srch_str);

    if (idx >= 0)
    {
        return replace_url_fragment(idx);
    }

    // If no existing attribute is found then add a new one.
    return append_url_fragment();
}


// extract_url_parameter - extract a specific attribute-value from the URI.
function extract_url_parameter(url, name)
{
    var search_str = name + '=';
    var len = search_str.length;

    var idx = url.indexOf(search_str);
    if (idx > 0)
    {
        idx += len;
        var idx2 = url.indexOf("&", idx);
        if (idx2 > 0)
        {
            return url.substring(idx, idx2);
        }
        else
        {
            return url.substring(idx);
        }
    }

    return null;
}

// get_full_url - Firefox doesn't let you set the location by relative path from a
// child window. You must specify the fully qualified URL or else it throws an exception.
function get_full_url(url_path)
{
    var loc = window.location;
    var url = "" + loc.protocol + "//" + loc.host + url_path;
    return url;
}

// refresh_page_absolute - Reload the current page using the fully qualified URL
// derived from the relative path.
function refresh_page_absolute(url_path)
{
    window.location.href = get_full_url(url_path);
}

// getInternetExplorerVersion - reference code from MSDN
// Returns the version of Internet Explorer or a -1 (indicating the use of another browser).
function getInternetExplorerVersion()
{
  var rv = -1; // Return value assumes failure.
  if (navigator.appName == 'Microsoft Internet Explorer')
  {
    var ua = navigator.userAgent;
    var re  = new RegExp("MSIE ([0-9]{1,}[.0-9]{0,})");
    if (re.exec(ua) != null)
      rv = parseFloat( RegExp.$1 );
  }
  return rv;
}

(function(version) {
    /*
    add a class to the html tag so that css selectors can be built
    for special versions of ie (buggy buggy!)
    NOTE: server and client useragent strings can differ!
    client (navigator.userAgent) shows the version being used
    server (request.http_user_agent) shows the actual browser
    may depend on X-UA-Compatible meta tag
    */
    if (version > -1) {
        document.documentElement.className += ' ie' + version;
    }
})(getInternetExplorerVersion());

// nb_enter_vdom - refresh the navbar frame to reflect the vdom menu.
function nb_enter_vdom(vdname)
{
    // This is an improvement on the old code which refreshes the entire frameset
    // to enter VDOM mode. The time to load is significantly reduced.
    var frm = top.frames.mainnav;

    if (frm.nb_runtime_state.global_view_menu) {
        var vdomtree = frm.navbar_menu_tree.child_nodes[1];
        $j.each(vdomtree.child_nodes, function() {
            if (this.menu_id == vdname) {
                //enter this menu
                var menu_id = frm.locate_first_l3_menu_id(this);
                frm.navigate_to_tab(menu_id, frm.navbar_menu_tree);
                return false;
            }
        });
    } else {
        var url = frm.location.href;
        url = update_url_component(url, 'vdom', vdname);

        url = update_url_component(url, "default_tab", "");

        frm.location.href = url;
    }
}

// ack_alert_msg - Acknowledge an alert console message by index.
function ack_alert_msg(idx, id)
{
    var AckURL = "/system/status/status?ack_alert=" + idx;

    var callback = function() {
        var dashboard = window.dashboard;

        if (dashboard)
        {
            dashboard.refreshModule( id );
        }

        var wnd = fweb.opener();

        // Refresh the popup alert console when an alert is acknowledged.
        if (wnd.dashboard && wnd != window)
        {
            // Refresh the dashboard alert console simultaneously so that
            // the display matches when the popup console is closed.
            wnd.dashboard.refreshModule( id );

            window.location.href = window.location.href;
        }
    };

    Request.sendPOST(AckURL, null, callback);

    return false;
}

/*
 * Formats a number to include size units ("x B", "y KB", etc)
 * - num : number to format
 * - base: specifies which index in the unit list the number starts in (0 is bytes)
 * - precision: number of significant digits to display (not used for the "Bytes" case).
 *
 * Ported from fortiweb/modules/aps_util.c (fgt_ulong_to_units)
 */
function ConvertVolumeToUnits(num, base, precision)
{
    var strs = [ "", "K", "M", "G", "T" ];
    return ConvertToUnits(strs, num, base, precision);
}

function convertNumberToUnits(num, base, precision)
{
    if (isNaN(num)) {
        return 'N/A';
    }
    return ConvertVolumeToUnits(num, base, precision) + "B";
}

/* ConvertBpsToUnits - Similar to convertNumberToUnits, but returns the value
 * in Bps/KBps/MBps, etc */
function ConvertBpsToUnits(num, base, precision)
{
    if (isNaN(num)) {
        return 'N/A';
    }
    return ConvertVolumeToUnits(num, base, precision) + "Bps";
}

/* ConvertBitsToUnits - Returns the value in bps/Kbps/Mbps, etc */
function ConvertBitsToUnits(num, base, precision)
{
    if (isNaN(num)) {
        return 'N/A';
    }
    return ConvertVolumeToUnits(num, base, precision) + "bps";
}

/* ConvertToUnits - Wrapped by above function calls */
function ConvertToUnits(strs, num, base, precision)
{
    var next;
    if (isNaN(num)) {
        return 'N/A';
    }

    if (base === undefined) { base = 0; }

    // Default to 2 significant digits.
    if (precision === undefined) { precision = 2; }

    if (typeof(num) != "number") { num = parseInt(num, 10); }

    var max_base = strs.length - 1;
    for (var j = 0; base < max_base; base++, j++) {
        next = num / 1000;
        if (next < 1) {
            return num.toFixed(j ? precision : 0) + " " + strs[ base ];
        }

        num = next;
    }

    return num.toFixed(j ? precision : 0) + " " + strs[ max_base ];
}

function ConvertToGroups(num)
{
    if (isNaN(num)) {
        return 'N/A';
    }

    var s = num.toString();
    var rgx = /(\d+)(\d{3})/;

    while (rgx.test(s)) {
        s = s.replace(rgx, '$1' + ',' + '$2');
    }

    return s;
}

function uncache_url(url) {
    var d = new Date();
    var time = d.getTime();

    return url + ((url.indexOf("?") < 0) ? "?" : "&") + "time=" + time;
}
// same as above, but for use with jQuery.param
function uncache_param(param) {
    param.time = (new Date()).getTime();
    return param;
}

// the below 3 functions are used by
// fortiweb/modules/sysconfadmindlg.c
// fortiweb/modules/sysconfsnmp_v3dlg.c
function addObj(oName, aName, idx) {
    jQuery('#' + oName + (idx + 1)).show();
    jQuery('#' + aName + idx).hide();
    jQuery('#' + aName + (idx + 1)).show();
}

function delObj(oName, aName, idx) {
    jQuery('#' + oName + idx).hide();
    jQuery('#' + aName + (idx - 1)).show();
    jQuery('#' + aName + idx).hide();
}

function loadAction(oName, aName, max) {
    var i, o;
    for (i = max; i >= 0; i--) {
        o = $j('#' + oName + i);
        if (o.length > 0 && o.is(':visible')) {
            $j('#' + aName + i).show();
            break;
        }
    }
}

String.prototype.getBytes = function() {
    return encodeURIComponent(this).replace(/%../g, 'x').length;
};

String.prototype.getBytesCRLF = function(is_not_escaped_html) {
    var str = this.replace(/\n/g, 'xx');
    if (is_not_escaped_html) {
        // return str.length;
        // Fix bug 0529190 (Unicode string length calculation error)
        return encodeURIComponent(str).replace(/%../g, 'x').length;
    }
    return str.replace(/%../g, 'x').length;
};


// Column Settings
function setDefaultColumns(shows)
{
    var chosen = $j('select[name=chosen]');
    var available = $j('select[name=available]');
    $j("option", chosen).appendTo(available);
    chosen.empty();

    for (var i = 0; i < shows.length; ++i) {
        $j('option[value="' + shows[i] + '"]', available).appendTo(chosen);
    }

    $j("option", available).sortElements(compareObjTextString);
}

function setColumns(ck_name)
{
    var csv = implodeField(document.forms[0].chosen, ',', 0);

    if (parent.document.forms[0] && parent.document.forms[0].columns_csv)
        parent.document.forms[0].columns_csv.value = csv;

    setCookie(ck_name, csv);

    window.parent.dlg_close();
}

// Utility function for masking contents of a dialog. Used primarly
// for modal dialogs in the policy configuration page.
function maskDlg(exclude_selectors) {
    $j(":input").each(function(q, x) {
            x.disabled = true;
        });

    if (exclude_selectors && "length" in exclude_selectors) {
        for (var i=0; i<exclude_selectors.length; i++) {
            $j(exclude_selectors[i]).each(function(q, x) {
                    x.disabled = false;
                });
        }
    }
}

function truncate_string(str, len) {
    var truncate_length = len || 32;
    var end = "…";
    var trunc_str = str;
    if (str && str.length > truncate_length) {
        trunc_str = str.substr(0, truncate_length - end.length) + end;
    }
    return trunc_str;
}

function truncate_comment(comment, len) {
    if (typeof comment !== 'undefined') {
        var esc_comment = escapeHTML(comment);
        var trunc_comment = truncate_string(comment, len);
        return trunc_comment === comment ? esc_comment :
            '<div title="' + esc_comment + '">' + escapeHTML(trunc_comment) + '</div>';
    }
    return "";
}

function formatDateTime(d, showTime, useEnglishLabel) {
    if (d == null) { d = new Date(); }
    var show_year = !(d.getFullYear() === (new Date()).getFullYear()),
        pad = function(n) {
            return n<10 ? '0'+n : n;
        };
    var months_en_labels = {
        'jan': 'Jan',
        'feb': 'Feb',
        'mar': 'Mar',
        'apr': 'Apr',
        'may': 'May',
        'jun': 'Jun',
        'july': 'July',
        'aug': 'Aug',
        'sept': 'Sept',
        'oct': 'Oct',
        'nov': 'Nov',
        'dec': 'Dec'
    };

    var months = $j.map([
        "jan", "feb", "mar", "apr", "may", "jun",
        "july", "aug", "sept", "oct", "nov", "dec"
    ], function(key) {
        var value = $j.getInfo(key);
        if (!useEnglishLabel) {
            return value;
        } else {
            // Use English translation as labels for FortiChart image,
            // since FortiChart library will NEVER use Unicode symbols.
            // Although FortiChart library supports Unicode,
            // due to image size limits, we can't have Unicode fonts installed
            // in FOS to print Unicode symbols.
            return months_en_labels[key];
        }
    });

    var result = (months[d.getMonth()] + " " 
                  + pad(d.getDate())
                  + (show_year ? ", " + d.getFullYear() : ""));
    if (typeof showTime === 'undefined' || showTime) {
        result += (", " 
                   + pad( d.getHours()%12 || 12) + ":"
                   + pad(d.getMinutes()) + " "
                   + (d.getHours() < 12 ? $j.getInfo("am") : $j.getInfo("pm")));
    }
    return result;
}

var util = {
    //TODO: move to fweb.util.patterns
    //copied from migbase/sysapi/antispam/regexp/pcreposix.c
    wildcard2Regex: function(value) {
        var replace = util.wildcard2Regex._replace;
        if (!replace) {
            replace = util.wildcard2Regex._replace = {
                '?': '.',
                '*': '.*'
            };
            $j.each('\\^$.[]|(){}+/'.split(''), function(i, v) {
                replace[v] = '\\' + v;
            });
        }

        value = value.replace(/[?*\\^$.[]|(){}+]/g, function(m) {
            return replace[m] || m;
        });
        return value;
    }
};

/*
 * classList.js: Cross-browser full element.classList implementation.
 * 2011-06-15
 *
 * By Eli Grey, http://eligrey.com
 * Public Domain.
 * NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.
 *
 * Note: This shim does not work in Internet Explorer versions less than 8.
 */

/*global self, document, DOMException */

/*! @source http://purl.eligrey.com/github/classList.js/blob/master/classList.js*/

if (typeof document !== "undefined" && !("classList" in document.createElement("a"))) {
    (function(view) {
        "use strict";
        if ((view.HTMLElement && view.Element) == null) {
            // bail out
            return;
        }

        var classListProp = "classList",
            protoProp = "prototype",
            elemCtrProto = (view.HTMLElement || view.Element)[protoProp],
            objCtr = Object,
            strTrim = String[protoProp].trim || function() {
                return this.replace(/^\s+|\s+$/g, "");
        },
            arrIndexOf = Array[protoProp].indexOf || function(item) {
                var i = 0,
                    len = this.length;
                for (; i < len; i++) {
                    if (i in this && this[i] === item) {
                        return i;
                    }
                }
                return -1;
        },
            DOMEx = function(type, message) {
                this.name = type;
                this.code = DOMException[type];
                this.message = message;
            }, checkTokenAndGetIndex = function(classList, token) {
                if (token === "") {
                    throw new DOMEx(
                        "SYNTAX_ERR", "An invalid or illegal string was specified");
                }
                if (/\s/.test(token)) {
                    throw new DOMEx(
                        "INVALID_CHARACTER_ERR", "String contains an invalid character");
                }
                return arrIndexOf.call(classList, token);
            }, ClassList = function(elem) {
                var
                trimmedClasses = strTrim.call(elem.className),
                    classes = trimmedClasses ? trimmedClasses.split(/\s+/) : [],
                    i = 0,
                    len = classes.length;
                for (; i < len; i++) {
                    this.push(classes[i]);
                }
                this._updateClassName = function() {
                    elem.className = this.toString();
                };
            }, classListProto = ClassList[protoProp] = [],
            classListGetter = function() {
                return new ClassList(this);
            };
        // Most DOMException implementations don't allow calling DOMException's toString()
        // on non-DOMExceptions. Error's toString() is sufficient here.
        DOMEx[protoProp] = Error[protoProp];
        classListProto.item = function(i) {
            return this[i] || null;
        };
        classListProto.contains = function(token) {
            token += "";
            return checkTokenAndGetIndex(this, token) !== -1;
        };
        classListProto.add = function(token) {
            token += "";
            if (checkTokenAndGetIndex(this, token) === -1) {
                this.push(token);
                this._updateClassName();
            }
        };
        classListProto.remove = function(token) {
            token += "";
            var index = checkTokenAndGetIndex(this, token);
            if (index !== -1) {
                this.splice(index, 1);
                this._updateClassName();
            }
        };
        classListProto.toggle = function(token) {
            token += "";
            if (checkTokenAndGetIndex(this, token) === -1) {
                this.add(token);
            } else {
                this.remove(token);
            }
        };
        classListProto.toString = function() {
            return this.join(" ");
        };

        if (objCtr.defineProperty) {
            var classListPropDesc = {
                get: classListGetter,
                enumerable: true,
                configurable: true
            };
            try {
                objCtr.defineProperty(elemCtrProto, classListProp, classListPropDesc);
            } catch (ex) { // IE 8 doesn't support enumerable:true
                if (ex.number === -0x7FF5EC54) {
                    classListPropDesc.enumerable = false;
                    objCtr.defineProperty(elemCtrProto, classListProp, classListPropDesc);
                }
            }
        } else if (objCtr[protoProp].__defineGetter__) {
            elemCtrProto.__defineGetter__(classListProp, classListGetter);
        }

    }(self));
}

var getLocalDate = fweb.util.datetime.getLocalDate;

/*            'js/overlib_mini.js',*/
//\/////
//\  overLIB 4.21 - You may not remove or change this notice.
//\  Copyright Erik Bosrup 1998-2004. All rights reserved.
//\
//\  Contributors are listed on the homepage.
//\  This file might be old, always check for the latest version at:
//\  http://www.bosrup.com/web/overlib/
//\
//\  Please read the license agreement (available through the link above)
//\  before using overLIB. Direct any licensing questions to erik@bosrup.com.
//\
//\  Do not sell this as your own work or remove this copyright notice. 
//\  For full details on copying or changing this script please read the
//\  license agreement at the link above. Please give credit on sites that
//\  use overLIB and submit changes of the script so other people can use
//\  them as well.
//\/////
//\  THIS IS A VERY MODIFIED VERSION. DO NOT EDIT OR PUBLISH. GET THE ORIGINAL!
var FREPLACE=0,over=null,cClick,runHook;(function(){var olLoaded=0,pmStart=10000000,pmUpper=10001000,pmCount=pmStart+1,pmt='',pms=new Array(),olInfo=new Info('4.21',1),FBEFORE=1,FAFTER=2,FALTERNATE=3,FCHAIN=4,olHideForm=0,olHautoFlag=0,olVautoFlag=0,hookPts=new Array(),postParse=new Array(),cmdLine=new Array(),runTime=new Array();
registerCommands('donothing,inarray,caparray,sticky,background,noclose,caption,left,right,center,offsetx,offsety,fgcolor,bgcolor,textcolor,capcolor,closecolor,width,border,cellpad,status,autostatus,autostatuscap,height,closetext,snapx,snapy,fixx,fixy,relx,rely,fgbackground,bgbackground,padx,pady,fullhtml,above,below,capicon,textfont,captionfont,closefont,textsize,captionsize,closesize,timeout,function,delay,hauto,vauto,closeclick,wrap,followmouse,mouseoff,closetitle,cssoff,compatmode,cssclass,fgclass,bgclass,textfontclass,captionfontclass,closefontclass');
if(typeof ol_fgcolor=='undefined')var ol_fgcolor="#FFFFFF";if(typeof ol_bgcolor=='undefined')var ol_bgcolor="#000000";if(typeof ol_textcolor=='undefined')var ol_textcolor="#000000";if(typeof ol_capcolor=='undefined')var ol_capcolor="#FFFFFF";if(typeof ol_closecolor=='undefined')var ol_closecolor="#9999FF";if(typeof ol_textfont=='undefined')var ol_textfont="Verdana,Arial,Helvetica";if(typeof ol_captionfont=='undefined')var ol_captionfont="Verdana,Arial,Helvetica";if(typeof ol_closefont=='undefined')var ol_closefont="Verdana,Arial,Helvetica";if(typeof ol_textsize=='undefined')var ol_textsize="1";if(typeof ol_captionsize=='undefined')var ol_captionsize="1";if(typeof ol_closesize=='undefined')var ol_closesize="1";if(typeof ol_width=='undefined')var ol_width="200";if(typeof ol_border=='undefined')var ol_border="1";if(typeof ol_cellpad=='undefined')var ol_cellpad=5;if(typeof ol_offsetx=='undefined')var ol_offsetx=10;if(typeof ol_offsety=='undefined')var ol_offsety=10;if(typeof ol_text=='undefined')var ol_text="Default Text";if(typeof ol_cap=='undefined')var ol_cap="";if(typeof ol_sticky=='undefined')var ol_sticky=0;if(typeof ol_background=='undefined')var ol_background="";if(typeof ol_close=='undefined')var ol_close="Close";if(typeof ol_hpos=='undefined')var ol_hpos=RIGHT;if(typeof ol_status=='undefined')var ol_status="";if(typeof ol_autostatus=='undefined')var ol_autostatus=0;if(typeof ol_height=='undefined')var ol_height=-1;if(typeof ol_snapx=='undefined')var ol_snapx=0;if(typeof ol_snapy=='undefined')var ol_snapy=0;if(typeof ol_fixx=='undefined')var ol_fixx=-1;if(typeof ol_fixy=='undefined')var ol_fixy=-1;if(typeof ol_relx=='undefined')var ol_relx=null;if(typeof ol_rely=='undefined')var ol_rely=null;if(typeof ol_fgbackground=='undefined')var ol_fgbackground="";if(typeof ol_bgbackground=='undefined')var ol_bgbackground="";if(typeof ol_padxl=='undefined')var ol_padxl=1;if(typeof ol_padxr=='undefined')var ol_padxr=1;if(typeof ol_padyt=='undefined')var ol_padyt=1;if(typeof ol_padyb=='undefined')var ol_padyb=1;if(typeof ol_fullhtml=='undefined')var ol_fullhtml=0;if(typeof ol_vpos=='undefined')var ol_vpos=BELOW;if(typeof ol_aboveheight=='undefined')var ol_aboveheight=0;if(typeof ol_capicon=='undefined')var ol_capicon="";if(typeof ol_frame=='undefined')var ol_frame=self;if(typeof ol_timeout=='undefined')var ol_timeout=0;if(typeof ol_function=='undefined')var ol_function=null;if(typeof ol_delay=='undefined')var ol_delay=0;if(typeof ol_hauto=='undefined')var ol_hauto=0;if(typeof ol_vauto=='undefined')var ol_vauto=0;if(typeof ol_closeclick=='undefined')var ol_closeclick=0;if(typeof ol_wrap=='undefined')var ol_wrap=0;if(typeof ol_followmouse=='undefined')var ol_followmouse=1;if(typeof ol_mouseoff=='undefined')var ol_mouseoff=0;if(typeof ol_closetitle=='undefined')var ol_closetitle='Close';if(typeof ol_compatmode=='undefined')var ol_compatmode=0;if(typeof ol_css=='undefined')var ol_css=CSSOFF;if(typeof ol_fgclass=='undefined')var ol_fgclass="";if(typeof ol_bgclass=='undefined')var ol_bgclass="";if(typeof ol_textfontclass=='undefined')var ol_textfontclass="";if(typeof ol_captionfontclass=='undefined')var ol_captionfontclass="";if(typeof ol_closefontclass=='undefined')var ol_closefontclass="";
if(typeof ol_texts=='undefined')var ol_texts=new Array("Text 0","Text 1");if(typeof ol_caps=='undefined')var ol_caps=new Array("Caption 0","Caption 1");
var o3_text="",o3_cap="",o3_sticky=0,o3_background="",o3_close="Close",o3_hpos=RIGHT,o3_offsetx=2,o3_offsety=2,o3_fgcolor="",o3_bgcolor="",o3_textcolor="",o3_capcolor="",o3_closecolor="",o3_width=100,o3_border=1,o3_cellpad=2,o3_status="",o3_autostatus=0,o3_height=-1,o3_snapx=0,o3_snapy=0,o3_fixx=-1,o3_fixy=-1,o3_relx=null,o3_rely=null,o3_fgbackground="",o3_bgbackground="",o3_padxl=0,o3_padxr=0,o3_padyt=0,o3_padyb=0,o3_fullhtml=0,o3_vpos=BELOW,o3_aboveheight=0,o3_capicon="",o3_textfont="Verdana,Arial,Helvetica",o3_captionfont="Verdana,Arial,Helvetica",o3_closefont="Verdana,Arial,Helvetica",o3_textsize="1",o3_captionsize="1",o3_closesize="1",o3_frame=self,o3_timeout=0,o3_timerid=0,o3_allowmove=0,o3_function=null,o3_delay=0,o3_delayid=0,o3_hauto=0,o3_vauto=0,o3_closeclick=0,o3_wrap=0,o3_followmouse=1,o3_mouseoff=0,o3_closetitle='',o3_compatmode=0,o3_css=CSSOFF,o3_fgclass="",o3_bgclass="",o3_textfontclass="",o3_captionfontclass="",o3_closefontclass="";
var o3_x=0,o3_y=0,o3_showingsticky=0,o3_removecounter=0;
var fnRef,hoveringSwitch=false,olHideDelay;
var isMac=(navigator.userAgent.indexOf("Mac")!=-1),olOp=(navigator.userAgent.toLowerCase().indexOf('opera')>-1&&document.createTextNode),olNs4=(navigator.appName=='Netscape'&&parseInt(navigator.appVersion)==4),olNs6=(document.getElementById)?true:false,olKq=(olNs6&&/konqueror/i.test(navigator.userAgent)),olIe4=(document.all)?true:false,olIe5=false,olIe55=false,docRoot='document.body';
if(olNs4){var oW=window.innerWidth;var oH=window.innerHeight;window.onresize=function(){if(oW!=window.innerWidth||oH!=window.innerHeight)location.reload();}}
if(olIe4){var agent=navigator.userAgent;if(/MSIE/.test(agent)){var versNum=parseFloat(agent.match(/MSIE[ ](\d+\.\d+)\.*/i)[1]);if(versNum>=5){olIe5=true;olIe55=(versNum>=5.5&&!olOp)?true:false;if(olNs6)olNs6=false;}}
if(olNs6)olIe4=false;}
if(document.compatMode&&document.compatMode=='CSS1Compat'){docRoot=((olIe4&&!olOp)?'document.documentElement':docRoot);}
if(window.addEventListener)window.addEventListener("load",OLonLoad_handler,false);else if(window.attachEvent)window.attachEvent("onload",OLonLoad_handler);
var capExtent;
function overlib(){if(!olLoaded||isExclusive(overlib.arguments))return true;if(olCheckMouseCapture)olMouseCapture();if(over){over=(typeof over.id!='string')?o3_frame.document.all['overDiv']:over;cClick();}
olHideDelay=0;o3_text=ol_text;o3_cap=ol_cap;o3_sticky=ol_sticky;o3_background=ol_background;o3_close=ol_close;o3_hpos=ol_hpos;o3_offsetx=ol_offsetx;o3_offsety=ol_offsety;o3_fgcolor=ol_fgcolor;o3_bgcolor=ol_bgcolor;o3_textcolor=ol_textcolor;o3_capcolor=ol_capcolor;o3_closecolor=ol_closecolor;o3_width=ol_width;o3_border=ol_border;o3_cellpad=ol_cellpad;o3_status=ol_status;o3_autostatus=ol_autostatus;o3_height=ol_height;o3_snapx=ol_snapx;o3_snapy=ol_snapy;o3_fixx=ol_fixx;o3_fixy=ol_fixy;o3_relx=ol_relx;o3_rely=ol_rely;o3_fgbackground=ol_fgbackground;o3_bgbackground=ol_bgbackground;o3_padxl=ol_padxl;o3_padxr=ol_padxr;o3_padyt=ol_padyt;o3_padyb=ol_padyb;o3_fullhtml=ol_fullhtml;o3_vpos=ol_vpos;o3_aboveheight=ol_aboveheight;o3_capicon=ol_capicon;o3_textfont=ol_textfont;o3_captionfont=ol_captionfont;o3_closefont=ol_closefont;o3_textsize=ol_textsize;o3_captionsize=ol_captionsize;o3_closesize=ol_closesize;o3_timeout=ol_timeout;o3_function=ol_function;o3_delay=ol_delay;o3_hauto=ol_hauto;o3_vauto=ol_vauto;o3_closeclick=ol_closeclick;o3_wrap=ol_wrap;o3_followmouse=ol_followmouse;o3_mouseoff=ol_mouseoff;o3_closetitle=ol_closetitle;o3_css=ol_css;o3_compatmode=ol_compatmode;o3_fgclass=ol_fgclass;o3_bgclass=ol_bgclass;o3_textfontclass=ol_textfontclass;o3_captionfontclass=ol_captionfontclass;o3_closefontclass=ol_closefontclass;
setRunTimeVariables();
fnRef='';
o3_frame=ol_frame;
if(!(over=createDivContainer()))return false;
parseTokens('o3_',overlib.arguments);if(!postParseChecks())return false;
if(o3_delay==0){return runHook("olMain",FREPLACE);}else{o3_delayid=setTimeout("runHook('olMain',FREPLACE)",o3_delay);return false;}}
function nd(time){if(olLoaded&&!isExclusive()){hideDelay(time);
if(o3_removecounter>=1){o3_showingsticky=0 };
if(o3_showingsticky==0){o3_allowmove=0;if(over!=null&&o3_timerid==0)runHook("hideObject",FREPLACE,over);}else{o3_removecounter++;}}
return true;}
cClick=function(){if(olLoaded){runHook("hideObject",FREPLACE,over);o3_showingsticky=0;}
return false;}
function overlib_pagedefaults(){parseTokens('ol_',overlib_pagedefaults.arguments);}
function olMain(){var layerhtml,styleType;runHook("olMain",FBEFORE);
if(o3_background!=""||o3_fullhtml){
layerhtml=runHook('ol_content_background',FALTERNATE,o3_css,o3_text,o3_background,o3_fullhtml);}else{
styleType=(pms[o3_css-1-pmStart]=="cssoff"||pms[o3_css-1-pmStart]=="cssclass");
if(o3_fgbackground!="")o3_fgbackground="background=\""+o3_fgbackground+"\"";if(o3_bgbackground!="")o3_bgbackground=(styleType?"background=\""+o3_bgbackground+"\"":o3_bgbackground);
if(o3_fgcolor!="")o3_fgcolor=(styleType?"bgcolor=\""+o3_fgcolor+"\"":o3_fgcolor);if(o3_bgcolor!="")o3_bgcolor=(styleType?"bgcolor=\""+o3_bgcolor+"\"":o3_bgcolor);
if(o3_height>0)o3_height=(styleType?"height=\""+o3_height+"\"":o3_height);else o3_height="";
if(o3_cap==""){
layerhtml=runHook('ol_content_simple',FALTERNATE,o3_css,o3_text);}else{
if(o3_sticky){
layerhtml=runHook('ol_content_caption',FALTERNATE,o3_css,o3_text,o3_cap,o3_close);}else{
layerhtml=runHook('ol_content_caption',FALTERNATE,o3_css,o3_text,o3_cap,"");}}}
if(o3_sticky){if(o3_timerid>0){clearTimeout(o3_timerid);o3_timerid=0;}
o3_showingsticky=1;o3_removecounter=0;}
if(!runHook("createPopup",FREPLACE,layerhtml))return false;
if(o3_autostatus>0){o3_status=o3_text;if(o3_autostatus>1)o3_status=o3_cap;}
o3_allowmove=0;
if(o3_timeout>0){if(o3_timerid>0)clearTimeout(o3_timerid);o3_timerid=setTimeout("cClick()",o3_timeout);}
runHook("disp",FREPLACE,o3_status);runHook("olMain",FAFTER);
return(olOp&&event&&event.type=='mouseover'&&!o3_status)?'':(o3_status!='');}
function ol_content_simple(text){var cpIsMultiple=/,/.test(o3_cellpad);var txt='<table width="'+o3_width+'" border="0" cellpadding="'+o3_border+'" cellspacing="0" '+(o3_bgclass?'class="'+o3_bgclass+'"':o3_bgcolor+' '+o3_height)+'><tr><td><table width="100%" border="0" '+((olNs4||!cpIsMultiple)?'cellpadding="'+o3_cellpad+'" ':'')+'cellspacing="0" '+(o3_fgclass?'class="'+o3_fgclass+'"':o3_fgcolor+' '+o3_fgbackground+' '+o3_height)+'><tr><td valign="TOP"'+(o3_textfontclass?' class="'+o3_textfontclass+'">':((!olNs4&&cpIsMultiple)?' style="'+setCellPadStr(o3_cellpad)+'">':'>'))+(o3_textfontclass?'':wrapStr(0,o3_textsize,'text'))+text+(o3_textfontclass?'':wrapStr(1,o3_textsize))+'</td></tr></table></td></tr></table>';
set_background("");return txt;}
function ol_content_caption(text,title,close){var nameId,txt,cpIsMultiple=/,/.test(o3_cellpad);var closing,closeevent;
closing="";closeevent="onmouseover";if(o3_closeclick==1)closeevent=(o3_closetitle?"title='"+o3_closetitle+"'":"")+" onclick";if(o3_capicon!=""){nameId=' hspace=\"5\"'+' align=\"middle\" alt=\"\"';if(typeof o3_dragimg!='undefined'&&o3_dragimg)nameId=' hspace=\"5\"'+' name=\"'+o3_dragimg+'\" id=\"'+o3_dragimg+'\" align=\"middle\" alt=\"Drag Enabled\" title=\"Drag Enabled\"';o3_capicon='<img src=\"'+o3_capicon+'\"'+nameId+' />';}
if(close!="")
closing='<td '+(!o3_compatmode&&o3_closefontclass?'class="'+o3_closefontclass:'align="RIGHT')+'"><a href="javascript:return '+fnRef+'cClick();"'+((o3_compatmode&&o3_closefontclass)?' class="'+o3_closefontclass+'" ':' ')+closeevent+'="return '+fnRef+'cClick();">'+(o3_closefontclass?'':wrapStr(0,o3_closesize,'close'))+close+(o3_closefontclass?'':wrapStr(1,o3_closesize,'close'))+'</a></td>';txt='<table width="'+o3_width+'" border="0" cellpadding="'+o3_border+'" cellspacing="0" '+(o3_bgclass?'class="'+o3_bgclass+'"':o3_bgcolor+' '+o3_bgbackground+' '+o3_height)+'><tr><td><table width="100%" border="0" cellpadding="2" cellspacing="0"><tr><td'+(o3_captionfontclass?' class="'+o3_captionfontclass+'">':'>')+(o3_captionfontclass?'':'<b>'+wrapStr(0,o3_captionsize,'caption'))+o3_capicon+title+(o3_captionfontclass?'':wrapStr(1,o3_captionsize)+'</b>')+'</td>'+closing+'</tr></table><table width="100%" border="0" '+((olNs4||!cpIsMultiple)?'cellpadding="'+o3_cellpad+'" ':'')+'cellspacing="0" '+(o3_fgclass?'class="'+o3_fgclass+'"':o3_fgcolor+' '+o3_fgbackground+' '+o3_height)+'><tr><td valign="TOP"'+(o3_textfontclass?' class="'+o3_textfontclass+'">' :((!olNs4&&cpIsMultiple)?' style="'+setCellPadStr(o3_cellpad)+'">':'>'))+(o3_textfontclass?'':wrapStr(0,o3_textsize,'text'))+text+(o3_textfontclass?'':wrapStr(1,o3_textsize))+'</td></tr></table></td></tr></table>';
set_background("");return txt;}
function ol_content_background(text,picture,hasfullhtml){if(hasfullhtml){txt=text;}else{txt='<table width="'+o3_width+'" border="0" cellpadding="0" cellspacing="0" height="'+o3_height+'"><tr><td colspan="3" height="'+o3_padyt+'"></td></tr><tr><td width="'+o3_padxl+'"></td><td valign="TOP" width="'+(o3_width-o3_padxl-o3_padxr)+(o3_textfontclass?'" class="'+o3_textfontclass:'')+'">'+(o3_textfontclass?'':wrapStr(0,o3_textsize,'text'))+text+(o3_textfontclass?'':wrapStr(1,o3_textsize))+'</td><td width="'+o3_padxr+'"></td></tr><tr><td colspan="3" height="'+o3_padyb+'"></td></tr></table>';}
set_background(picture);return txt;}
function set_background(pic){if(pic==""){if(olNs4){over.background.src=null;}else if(over.style){over.style.backgroundImage="none";}
}else{if(olNs4){over.background.src=pic;}else if(over.style){over.style.width=o3_width+'px';over.style.backgroundImage="url("+pic+")";}}}
var olShowId=-1;
function disp(statustext){runHook("disp",FBEFORE);
if(o3_allowmove==0){runHook("placeLayer",FREPLACE);(olNs6&&olShowId<0)?olShowId=setTimeout("runHook('showObject',FREPLACE,over)",1):runHook("showObject",FREPLACE,over);o3_allowmove=(o3_sticky||o3_followmouse==0)?0:1;}
runHook("disp",FAFTER);
if(statustext!="")self.status=statustext;}
function createPopup(lyrContent){runHook("createPopup",FBEFORE);
if(o3_wrap){var wd,ww,theObj=(olNs4?over:over.style);theObj.top=theObj.left=((olIe4&&!olOp)?0:-10000)+(!olNs4?'px':0);layerWrite(lyrContent);wd=(olNs4?over.clip.width:over.offsetWidth);if(wd>(ww=windowWidth())){lyrContent=lyrContent.replace(/\&nbsp;/g,' ');o3_width=ww;o3_wrap=0;}}
layerWrite(lyrContent);
if(o3_wrap)o3_width=(olNs4?over.clip.width:over.offsetWidth);
runHook("createPopup",FAFTER,lyrContent);
return true;}
function placeLayer(){var placeX,placeY,widthFix=0;
if(o3_frame.innerWidth)widthFix=18;iwidth=windowWidth();
winoffset=(olIe4)?eval('o3_frame.'+docRoot+'.scrollLeft'):o3_frame.pageXOffset;
placeX=runHook('horizontalPlacement',FCHAIN,iwidth,winoffset,widthFix);
if(o3_frame.innerHeight){iheight=o3_frame.innerHeight;}else if(eval('o3_frame.'+docRoot)&&eval("typeof o3_frame."+docRoot+".clientHeight=='number'")&&eval('o3_frame.'+docRoot+'.clientHeight')){iheight=eval('o3_frame.'+docRoot+'.clientHeight');}
scrolloffset=(olIe4)?eval('o3_frame.'+docRoot+'.scrollTop'):o3_frame.pageYOffset;placeY=runHook('verticalPlacement',FCHAIN,iheight,scrolloffset);
repositionTo(over,placeX,placeY);}
function olMouseMove(e){var e=(e)?e:event;
if(e.pageX){o3_x=e.pageX;o3_y=e.pageY;}else if(e.clientX){o3_x=eval('e.clientX+o3_frame.'+docRoot+'.scrollLeft');o3_y=eval('e.clientY+o3_frame.'+docRoot+'.scrollTop');}
if(o3_allowmove==1)runHook("placeLayer",FREPLACE);
if(hoveringSwitch&&!olNs4&&runHook("cursorOff",FREPLACE)){(olHideDelay?hideDelay(olHideDelay):cClick());hoveringSwitch=!hoveringSwitch;}}
function no_overlib(){return ver3fix;}
function olMouseCapture(){capExtent=document;var fN,str='',l,k,f,wMv,sS,mseHandler=olMouseMove;var re=/function[ ]*(\w*)\(/;
wMv=(!olIe4&&window.onmousemove);if(document.onmousemove||wMv){if(wMv)capExtent=window;f=capExtent.onmousemove.toString();fN=f.match(re);if(fN==null){str=f+'(e);';}else if(fN[1]=='anonymous'||fN[1]=='olMouseMove'||(wMv&&fN[1]=='onmousemove')){if(!olOp&&wMv){l=f.indexOf('{')+1;k=f.lastIndexOf('}');sS=f.substring(l,k);if((l=sS.indexOf('('))!=-1){sS=sS.substring(0,l).replace(/^\s+/,'').replace(/\s+$/,'');if(eval("typeof "+sS+"=='undefined'"))window.onmousemove=null;else str=sS+'(e);';}}
if(!str){olCheckMouseCapture=false;return;}
}else{if(fN[1])str=fN[1]+'(e);';else{l=f.indexOf('{')+1;k=f.lastIndexOf('}');str=f.substring(l,k)+'\n';}}
str+='olMouseMove(e);';mseHandler=new Function('e',str);}
capExtent.onmousemove=mseHandler;if(olNs4)capExtent.captureEvents(Event.MOUSEMOVE);}
function parseTokens(pf,ar){
var v,i,mode=-1,par=(pf!='ol_'),fnMark=(par&&!ar.length?1:0);
for(i=0;i<ar.length;i++){if(mode<0){
if(typeof ar[i]=='number'&&ar[i]>pmStart&&ar[i]<pmUpper){fnMark=(par?1:0);i--;}else{switch(pf){case 'ol_':
ol_text=ar[i].toString();break;default:
o3_text=ar[i].toString();}}
mode=0;}else{
if(ar[i]>=pmCount||ar[i]==DONOTHING){continue;}
if(ar[i]==INARRAY){fnMark=0;eval(pf+'text=ol_texts['+ar[++i]+'].toString()');continue;}
if(ar[i]==CAPARRAY){eval(pf+'cap=ol_caps['+ar[++i]+'].toString()');continue;}
if(ar[i]==STICKY){if(pf!='ol_')eval(pf+'sticky=1');continue;}
if(ar[i]==BACKGROUND){eval(pf+'background="'+ar[++i]+'"');continue;}
if(ar[i]==NOCLOSE){if(pf!='ol_')opt_NOCLOSE();continue;}
if(ar[i]==CAPTION){eval(pf+"cap='"+escSglQuote(ar[++i])+"'");continue;}
if(ar[i]==CENTER||ar[i]==LEFT||ar[i]==RIGHT){eval(pf+'hpos='+ar[i]);if(pf!='ol_')olHautoFlag=1;continue;}
if(ar[i]==OFFSETX){eval(pf+'offsetx='+ar[++i]);continue;}
if(ar[i]==OFFSETY){eval(pf+'offsety='+ar[++i]);continue;}
if(ar[i]==FGCOLOR){eval(pf+'fgcolor="'+ar[++i]+'"');continue;}
if(ar[i]==BGCOLOR){eval(pf+'bgcolor="'+ar[++i]+'"');continue;}
if(ar[i]==TEXTCOLOR){eval(pf+'textcolor="'+ar[++i]+'"');continue;}
if(ar[i]==CAPCOLOR){eval(pf+'capcolor="'+ar[++i]+'"');continue;}
if(ar[i]==CLOSECOLOR){eval(pf+'closecolor="'+ar[++i]+'"');continue;}
if(ar[i]==WIDTH){eval(pf+'width='+ar[++i]);continue;}
if(ar[i]==BORDER){eval(pf+'border='+ar[++i]);continue;}
if(ar[i]==CELLPAD){i=opt_MULTIPLEARGS(++i,ar,(pf+'cellpad'));continue;}
if(ar[i]==STATUS){eval(pf+"status='"+escSglQuote(ar[++i])+"'");continue;}
if(ar[i]==AUTOSTATUS){eval(pf+'autostatus=('+pf+'autostatus==1)?0:1');continue;}
if(ar[i]==AUTOSTATUSCAP){eval(pf+'autostatus=('+pf+'autostatus==2)?0:2');continue;}
if(ar[i]==HEIGHT){eval(pf+'height='+pf+'aboveheight='+ar[++i]);continue;}
if(ar[i]==CLOSETEXT){eval(pf+"close='"+escSglQuote(ar[++i])+"'");continue;}
if(ar[i]==SNAPX){eval(pf+'snapx='+ar[++i]);continue;}
if(ar[i]==SNAPY){eval(pf+'snapy='+ar[++i]);continue;}
if(ar[i]==FIXX){eval(pf+'fixx='+ar[++i]);continue;}
if(ar[i]==FIXY){eval(pf+'fixy='+ar[++i]);continue;}
if(ar[i]==RELX){eval(pf+'relx='+ar[++i]);continue;}
if(ar[i]==RELY){eval(pf+'rely='+ar[++i]);continue;}
if(ar[i]==FGBACKGROUND){eval(pf+'fgbackground="'+ar[++i]+'"');continue;}
if(ar[i]==BGBACKGROUND){eval(pf+'bgbackground="'+ar[++i]+'"');continue;}
if(ar[i]==PADX){eval(pf+'padxl='+ar[++i]);eval(pf+'padxr='+ar[++i]);continue;}
if(ar[i]==PADY){eval(pf+'padyt='+ar[++i]);eval(pf+'padyb='+ar[++i]);continue;}
if(ar[i]==FULLHTML){if(pf!='ol_')eval(pf+'fullhtml=1');continue;}
if(ar[i]==BELOW||ar[i]==ABOVE){eval(pf+'vpos='+ar[i]);if(pf!='ol_')olVautoFlag=1;continue;}
if(ar[i]==CAPICON){eval(pf+'capicon="'+ar[++i]+'"');continue;}
if(ar[i]==TEXTFONT){eval(pf+"textfont='"+escSglQuote(ar[++i])+"'");continue;}
if(ar[i]==CAPTIONFONT){eval(pf+"captionfont='"+escSglQuote(ar[++i])+"'");continue;}
if(ar[i]==CLOSEFONT){eval(pf+"closefont='"+escSglQuote(ar[++i])+"'");continue;}
if(ar[i]==TEXTSIZE){eval(pf+'textsize="'+ar[++i]+'"');continue;}
if(ar[i]==CAPTIONSIZE){eval(pf+'captionsize="'+ar[++i]+'"');continue;}
if(ar[i]==CLOSESIZE){eval(pf+'closesize="'+ar[++i]+'"');continue;}
if(ar[i]==TIMEOUT){eval(pf+'timeout='+ar[++i]);continue;}
if(ar[i]==FUNCTION){if(pf=='ol_'){if(typeof ar[i+1]!='number'){v=ar[++i];ol_function=(typeof v=='function'?v:null);}}else{fnMark=0;v=null;if(typeof ar[i+1]!='number')v=ar[++i]; opt_FUNCTION(v);} continue;}
if(ar[i]==DELAY){eval(pf+'delay='+ar[++i]);continue;}
if(ar[i]==HAUTO){eval(pf+'hauto=('+pf+'hauto==0)?1:0');continue;}
if(ar[i]==VAUTO){eval(pf+'vauto=('+pf+'vauto==0)?1:0');continue;}
if(ar[i]==CLOSECLICK){eval(pf+'closeclick=('+pf+'closeclick==0)?1:0');continue;}
if(ar[i]==WRAP){eval(pf+'wrap=('+pf+'wrap==0)?1:0');continue;}
if(ar[i]==FOLLOWMOUSE){eval(pf+'followmouse=('+pf+'followmouse==1)?0:1');continue;}
if(ar[i]==MOUSEOFF){eval(pf+'mouseoff=('+pf+'mouseoff==0)?1:0');v=ar[i+1];if(pf!='ol_'&&eval(pf+'mouseoff')&&typeof v=='number'&&(v<pmStart||v>pmUpper))olHideDelay=ar[++i];continue;}
if(ar[i]==CLOSETITLE){eval(pf+"closetitle='"+escSglQuote(ar[++i])+"'");continue;}
if(ar[i]==CSSOFF||ar[i]==CSSCLASS){eval(pf+'css='+ar[i]);continue;}
if(ar[i]==COMPATMODE){eval(pf+'compatmode=('+pf+'compatmode==0)?1:0');continue;}
if(ar[i]==FGCLASS){eval(pf+'fgclass="'+ar[++i]+'"');continue;}
if(ar[i]==BGCLASS){eval(pf+'bgclass="'+ar[++i]+'"');continue;}
if(ar[i]==TEXTFONTCLASS){eval(pf+'textfontclass="'+ar[++i]+'"');continue;}
if(ar[i]==CAPTIONFONTCLASS){eval(pf+'captionfontclass="'+ar[++i]+'"');continue;}
if(ar[i]==CLOSEFONTCLASS){eval(pf+'closefontclass="'+ar[++i]+'"');continue;}
i=parseCmdLine(pf,i,ar);}}
if(fnMark&&o3_function)o3_text=o3_function();
if((pf=='o3_')&&o3_wrap){o3_width=0;
var tReg=/<.*\n*>/ig;if(!tReg.test(o3_text))o3_text=o3_text.replace(/[ ]+/g,'&nbsp;');if(!tReg.test(o3_cap))o3_cap=o3_cap.replace(/[ ]+/g,'&nbsp;');}
if((pf=='o3_')&&o3_sticky){if(!o3_close&&(o3_frame!=ol_frame))o3_close=ol_close;if(o3_mouseoff&&(o3_frame==ol_frame))opt_NOCLOSE(' ');}}
function layerWrite(txt){txt+="\n";if(olNs4){var lyr=o3_frame.document.layers['overDiv'].document
lyr.write(txt)
lyr.close()
}else if(typeof over.innerHTML!='undefined'){if(olIe5&&isMac)over.innerHTML='';over.innerHTML=txt;}else{range=o3_frame.document.createRange();range.setStartAfter(over);domfrag=range.createContextualFragment(txt);
while(over.hasChildNodes()){over.removeChild(over.lastChild);}
over.appendChild(domfrag);}}
function showObject(obj){runHook("showObject",FBEFORE);
var theObj=(olNs4?obj:obj.style);theObj.visibility='visible';
runHook("showObject",FAFTER);}
function hideObject(obj){runHook("hideObject",FBEFORE);
var theObj=(olNs4?obj:obj.style);if(olNs6&&olShowId>0){clearTimeout(olShowId);olShowId=0;}
theObj.visibility='hidden';theObj.top=theObj.left=((olIe4&&!olOp)?0:-10000)+(!olNs4?'px':0);
if(o3_timerid>0)clearTimeout(o3_timerid);if(o3_delayid>0)clearTimeout(o3_delayid);
o3_timerid=0;o3_delayid=0;self.status="";
if(obj.onmouseout||obj.onmouseover){if(olNs4)obj.releaseEvents(Event.MOUSEOUT||Event.MOUSEOVER);obj.onmouseout=obj.onmouseover=null;}
runHook("hideObject",FAFTER);}
function repositionTo(obj,xL,yL){var theObj=(olNs4?obj:obj.style);theObj.left=xL+(!olNs4?'px':0);theObj.top=yL+(!olNs4?'px':0);}
function cursorOff(){var left=parseInt(over.style.left);var top=parseInt(over.style.top);var right=left+(over.offsetWidth>=parseInt(o3_width)?over.offsetWidth:parseInt(o3_width));var bottom=top+(over.offsetHeight>=o3_aboveheight?over.offsetHeight:o3_aboveheight);
if(o3_x<left||o3_x>right||o3_y<top||o3_y>bottom)return true;
return false;}
function opt_FUNCTION(callme){o3_text=(callme?(typeof callme=='string'?(/.+\(.*\)/.test(callme)?eval(callme):callme):callme()):(o3_function?o3_function():'No Function'));
return 0;}
function opt_NOCLOSE(unused){if(!unused)o3_close="";
if(olNs4){over.captureEvents(Event.MOUSEOUT||Event.MOUSEOVER);over.onmouseover=function(){if(o3_timerid>0){clearTimeout(o3_timerid);o3_timerid=0;} }
over.onmouseout=function(e){if(olHideDelay)hideDelay(olHideDelay);else cClick(e);}
}else{over.onmouseover=function(){hoveringSwitch=true;if(o3_timerid>0){clearTimeout(o3_timerid);o3_timerid=0;} }}
return 0;}
function opt_MULTIPLEARGS(i,args,parameter){var k=i,re,pV,str='';
for(k=i;k<args.length;k++){if(typeof args[k]=='number'&&args[k]>pmStart)break;str+=args[k]+',';}
if(str)str=str.substring(0,--str.length);
k--;pV=(olNs4&&/cellpad/i.test(parameter))?str.split(',')[0]:str;eval(parameter+'="'+pV+'"');
return k;}
function nbspCleanup(){if(o3_wrap){o3_text=o3_text.replace(/\&nbsp;/g,' ');o3_cap=o3_cap.replace(/\&nbsp;/g,' ');}}
function escSglQuote(str){return str.toString().replace(/'/g,"\\'");}
function OLonLoad_handler(e){var re=/\w+\(.*\)[;\s]+/g,olre=/overlib\(|nd\(|cClick\(/,fn,l,i;
if(!olLoaded)olLoaded=1;
if(window.removeEventListener&&e.eventPhase==3)window.removeEventListener("load",OLonLoad_handler,false);else if(window.detachEvent){window.detachEvent("onload",OLonLoad_handler);var fN=document.body.getAttribute('onload');if(fN){fN=fN.toString().match(re);if(fN&&fN.length){for(i=0;i<fN.length;i++){if(/anonymous/.test(fN[i]))continue;while((l=fN[i].search(/\)[;\s]+/))!=-1){fn=fN[i].substring(0,l+1);fN[i]=fN[i].substring(l+2);if(olre.test(fn))eval(fn);}}}}}}
function wrapStr(endWrap,fontSizeStr,whichString){var fontStr,fontColor,isClose=((whichString=='close')?1:0),hasDims=/[%\-a-z]+$/.test(fontSizeStr);fontSizeStr=(olNs4)?(!hasDims?fontSizeStr:'1'):fontSizeStr;if(endWrap)return(hasDims&&!olNs4)?(isClose?'</span>':'</div>'):'</font>';else{fontStr='o3_'+whichString+'font';fontColor='o3_'+((whichString=='caption')? 'cap':whichString)+'color';return(hasDims&&!olNs4)?(isClose?'<span style="font-family: '+quoteMultiNameFonts(eval(fontStr))+';color: '+eval(fontColor)+';font-size: '+fontSizeStr+';">':'<div style="font-family: '+quoteMultiNameFonts(eval(fontStr))+';color: '+eval(fontColor)+';font-size: '+fontSizeStr+';">'):'<font face="'+eval(fontStr)+'" color="'+eval(fontColor)+'" size="'+(parseInt(fontSizeStr)>7?'7':fontSizeStr)+'">';}}
function quoteMultiNameFonts(theFont){var v,pM=theFont.split(',');for(var i=0;i<pM.length;i++){v=pM[i];v=v.replace(/^\s+/,'').replace(/\s+$/,'');if(/\s/.test(v)&&!/['"]/.test(v)){v="\'"+v+"\'";pM[i]=v;}}
return pM.join();}
function isExclusive(args){return false;}
function setCellPadStr(parameter){var Str='',j=0,ary=new Array(),top,bottom,left,right;
Str+='padding: ';ary=parameter.replace(/\s+/g,'').split(',');
switch(ary.length){case 2:
top=bottom=ary[j];left=right=ary[++j];break;case 3:
top=ary[j];left=right=ary[++j];bottom=ary[++j];break;case 4:
top=ary[j];right=ary[++j];bottom=ary[++j];left=ary[++j];break;}
Str+=((ary.length==1)?ary[0]+'px;':top+'px '+right+'px '+bottom+'px '+left+'px;');
return Str;}
function hideDelay(time){if(time&&!o3_delay){if(o3_timerid>0)clearTimeout(o3_timerid);
o3_timerid=setTimeout("cClick()",(o3_timeout=time));}}
function horizontalPlacement(browserWidth,horizontalScrollAmount,widthFix){var placeX,iwidth=browserWidth,winoffset=horizontalScrollAmount;var parsedWidth=parseInt(o3_width);
if(o3_fixx>-1||o3_relx!=null){
placeX=(o3_relx!=null?( o3_relx<0?winoffset+o3_relx+iwidth-parsedWidth-widthFix:winoffset+o3_relx):o3_fixx);}else{
if(o3_hauto==1){if((o3_x-winoffset)>(iwidth/2)){o3_hpos=LEFT;}else{o3_hpos=RIGHT;}}
if(o3_hpos==CENTER){placeX=o3_x+o3_offsetx-(parsedWidth/2);
if(placeX<winoffset)placeX=winoffset;}
if(o3_hpos==RIGHT){placeX=o3_x+o3_offsetx;
if((placeX+parsedWidth)>(winoffset+iwidth-widthFix)){placeX=iwidth+winoffset-parsedWidth-widthFix;if(placeX<0)placeX=0;}}
if(o3_hpos==LEFT){placeX=o3_x-o3_offsetx-parsedWidth;if(placeX<winoffset)placeX=winoffset;}
if(o3_snapx>1){var snapping=placeX % o3_snapx;
if(o3_hpos==LEFT){placeX=placeX-(o3_snapx+snapping);}else{
placeX=placeX+(o3_snapx-snapping);}
if(placeX<winoffset)placeX=winoffset;}}
return placeX;}
function verticalPlacement(browserHeight,verticalScrollAmount){var placeY,iheight=browserHeight,scrolloffset=verticalScrollAmount;var parsedHeight=(o3_aboveheight?parseInt(o3_aboveheight):(olNs4?over.clip.height:over.offsetHeight));
if(o3_fixy>-1||o3_rely!=null){
placeY=(o3_rely!=null?(o3_rely<0?scrolloffset+o3_rely+iheight-parsedHeight:scrolloffset+o3_rely):o3_fixy);}else{
if(o3_vauto==1){if((o3_y-scrolloffset)>(iheight/2)&&o3_vpos==BELOW&&(o3_y+parsedHeight+o3_offsety-(scrolloffset+iheight)>0)){o3_vpos=ABOVE;}else if(o3_vpos==ABOVE&&(o3_y-(parsedHeight+o3_offsety)-scrolloffset<0)){o3_vpos=BELOW;}}
if(o3_vpos==ABOVE){if(o3_aboveheight==0)o3_aboveheight=parsedHeight;
placeY=o3_y-(o3_aboveheight+o3_offsety);if(placeY<scrolloffset)placeY=scrolloffset;}else{
placeY=o3_y+o3_offsety;}
if(o3_snapy>1){var snapping=placeY % o3_snapy;
if(o3_aboveheight>0&&o3_vpos==ABOVE){placeY=placeY-(o3_snapy+snapping);}else{placeY=placeY+(o3_snapy-snapping);}
if(placeY<scrolloffset)placeY=scrolloffset;}}
return placeY;}
function checkPositionFlags(){if(olHautoFlag)olHautoFlag=o3_hauto=0;if(olVautoFlag)olVautoFlag=o3_vauto=0;return true;}
function windowWidth(){var w;if(o3_frame.innerWidth)w=o3_frame.innerWidth;else if(eval('o3_frame.'+docRoot)&&eval("typeof o3_frame."+docRoot+".clientWidth=='number'")&&eval('o3_frame.'+docRoot+'.clientWidth'))
w=eval('o3_frame.'+docRoot+'.clientWidth');return w;}
function createDivContainer(id,frm,zValue){id=(id||'overDiv'),frm=(frm||o3_frame),zValue=(zValue||1000);var objRef,divContainer=layerReference(id);
if(divContainer==null){if(olNs4){divContainer=frm.document.layers[id]=new Layer(window.innerWidth,frm);objRef=divContainer;}else{var body=(olIe4?frm.document.all.tags('BODY')[0]:frm.document.getElementsByTagName("BODY")[0]);if(olIe4&&!document.getElementById){body.insertAdjacentHTML("beforeEnd",'<div id="'+id+'"></div>');divContainer=layerReference(id);}else{divContainer=frm.document.createElement("DIV");divContainer.id=id;body.appendChild(divContainer);}
objRef=divContainer.style;}
objRef.position='absolute';objRef.visibility='hidden';objRef.zIndex=zValue;if(olIe4&&!olOp)objRef.left=objRef.top='0px';else objRef.left=objRef.top=-10000+(!olNs4?'px':0);}
return divContainer;}
function layerReference(id){return(olNs4?o3_frame.document.layers[id]:(document.all?o3_frame.document.all[id]:o3_frame.document.getElementById(id)));}
function isFunction(fnRef){var rtn=true;
if(typeof fnRef=='object'){for(var i=0;i<fnRef.length;i++){if(typeof fnRef[i]=='function')continue;rtn=false;break;}
}else if(typeof fnRef!='function'){rtn=false;}
return rtn;}
function argToString(array,strtInd,argName){var jS=strtInd,aS='',ar=array;argName=(argName?argName:'ar');
if(ar.length>jS){for(var k=jS;k<ar.length;k++)aS+=argName+'['+k+'], ';aS=aS.substring(0,aS.length-2);}
return aS;}
function reOrder(hookPt,fnRef,order){var newPt=new Array(),match,i,j;
if(!order||typeof order=='undefined'||typeof order=='number')return hookPt;
if(typeof order=='function'){if(typeof fnRef=='object'){newPt=newPt.concat(fnRef);}else{newPt[newPt.length++]=fnRef;}
for(i=0;i<hookPt.length;i++){match=false;if(typeof fnRef=='function'&&hookPt[i]==fnRef){continue;}else{for(j=0;j<fnRef.length;j++)if(hookPt[i]==fnRef[j]){match=true;break;}}
if(!match)newPt[newPt.length++]=hookPt[i];}
newPt[newPt.length++]=order;
}else if(typeof order=='object'){if(typeof fnRef=='object'){newPt=newPt.concat(fnRef);}else{newPt[newPt.length++]=fnRef;}
for(j=0;j<hookPt.length;j++){match=false;if(typeof fnRef=='function'&&hookPt[j]==fnRef){continue;}else{for(i=0;i<fnRef.length;i++)if(hookPt[j]==fnRef[i]){match=true;break;}}
if(!match)newPt[newPt.length++]=hookPt[j];}
for(i=0;i<newPt.length;i++)hookPt[i]=newPt[i];newPt.length=0;
for(j=0;j<hookPt.length;j++){match=false;for(i=0;i<order.length;i++){if(hookPt[j]==order[i]){match=true;break;}}
if(!match)newPt[newPt.length++]=hookPt[j];}
newPt=newPt.concat(order);}
hookPt=newPt;
return hookPt;}
function setRunTimeVariables(){if(typeof runTime!='undefined'&&runTime.length){for(var k=0;k<runTime.length;k++){runTime[k]();}}}
function parseCmdLine(pf,i,args){if(typeof cmdLine!='undefined'&&cmdLine.length){for(var k=0;k<cmdLine.length;k++){var j=cmdLine[k](pf,i,args);if(j >-1){i=j;break;}}}
return i;}
function postParseChecks(pf,args){if(typeof postParse!='undefined'&&postParse.length){for(var k=0;k<postParse.length;k++){if(postParse[k](pf,args))continue;return false;}}
return true;}
function registerCommands(cmdStr){if(typeof cmdStr!='string')return;
var pM=cmdStr.split(',');pms=pms.concat(pM);
for(var i=0;i< pM.length;i++){eval(pM[i].toUpperCase()+'='+pmCount++);}}
function registerNoParameterCommands(cmdStr){if(!cmdStr&&typeof cmdStr!='string')return;pmt=(!pmt)?cmdStr:pmt+','+cmdStr;}
function registerHook(fnHookTo,fnRef,hookType,optPm){var hookPt,last=typeof optPm;
if(fnHookTo=='plgIn'||fnHookTo=='postParse')return;if(typeof hookPts[fnHookTo]=='undefined')hookPts[fnHookTo]=new FunctionReference();
hookPt=hookPts[fnHookTo];
if(hookType!=null){if(hookType==FREPLACE){hookPt.ovload=fnRef;if(fnHookTo.indexOf('ol_content_')>-1)hookPt.alt[pms[CSSOFF-1-pmStart]]=fnRef;
}else if(hookType==FBEFORE||hookType==FAFTER){var hookPt=(hookType==1?hookPt.before:hookPt.after);
if(typeof fnRef=='object'){hookPt=hookPt.concat(fnRef);}else{hookPt[hookPt.length++]=fnRef;}
if(optPm)hookPt=reOrder(hookPt,fnRef,optPm);
}else if(hookType==FALTERNATE){if(last=='number')hookPt.alt[pms[optPm-1-pmStart]]=fnRef;}else if(hookType==FCHAIN){hookPt=hookPt.chain;if(typeof fnRef=='object')hookPt=hookPt.concat(fnRef);else hookPt[hookPt.length++]=fnRef;}
return;}}
function registerRunTimeFunction(fn){if(isFunction(fn)){if(typeof fn=='object'){runTime=runTime.concat(fn);}else{runTime[runTime.length++]=fn;}}}
function registerCmdLineFunction(fn){if(isFunction(fn)){if(typeof fn=='object'){cmdLine=cmdLine.concat(fn);}else{cmdLine[cmdLine.length++]=fn;}}}
function registerPostParseFunction(fn){if(isFunction(fn)){if(typeof fn=='object'){postParse=postParse.concat(fn);}else{postParse[postParse.length++]=fn;}}}
runHook=function(fnHookTo,hookType){var l=hookPts[fnHookTo],k,rtnVal=null,optPm,arS,ar=runHook.arguments;
if(hookType==FREPLACE){arS=argToString(ar,2);
if(typeof l=='undefined'||!(l=l.ovload))rtnVal=eval(fnHookTo+'('+arS+')');else rtnVal=eval('l('+arS+')');
}else if(hookType==FBEFORE||hookType==FAFTER){if(typeof l!='undefined'){l=(hookType==1?l.before:l.after);
if(l.length){arS=argToString(ar,2);for(var k=0;k<l.length;k++)eval('l[k]('+arS+')');}}
}else if(hookType==FALTERNATE){optPm=ar[2];arS=argToString(ar,3);
if(typeof l=='undefined'||(l=l.alt[pms[optPm-1-pmStart]])=='undefined'){rtnVal=eval(fnHookTo+'('+arS+')');}else{rtnVal=eval('l('+arS+')');}
}else if(hookType==FCHAIN){arS=argToString(ar,2);l=l.chain;
for(k=l.length;k>0;k--)if((rtnVal=eval('l[k-1]('+arS+')'))!=void(0))break;}
return rtnVal;}
function FunctionReference(){this.ovload=null;this.before=new Array();this.after=new Array();this.alt=new Array();this.chain=new Array();}
function Info(version,prerelease){this.version=version;this.prerelease=prerelease;
this.simpleversion=Math.round(this.version*100);this.major=parseInt(this.simpleversion/100);this.minor=parseInt(this.simpleversion/10)-this.major * 10;this.revision=parseInt(this.simpleversion)-this.major * 100-this.minor * 10;this.meets=meets;}
function meets(reqdVersion){return(!reqdVersion)?false:this.simpleversion>=Math.round(100*parseFloat(reqdVersion));}
registerHook("ol_content_simple",ol_content_simple,FALTERNATE,CSSOFF);registerHook("ol_content_caption",ol_content_caption,FALTERNATE,CSSOFF);registerHook("ol_content_background",ol_content_background,FALTERNATE,CSSOFF);registerHook("ol_content_simple",ol_content_simple,FALTERNATE,CSSCLASS);registerHook("ol_content_caption",ol_content_caption,FALTERNATE,CSSCLASS);registerHook("ol_content_background",ol_content_background,FALTERNATE,CSSCLASS);registerPostParseFunction(checkPositionFlags);registerHook("hideObject",nbspCleanup,FAFTER);registerHook("horizontalPlacement",horizontalPlacement,FCHAIN);registerHook("verticalPlacement",verticalPlacement,FCHAIN);if(olNs4||(olIe5&&isMac)||olKq)olLoaded=1;registerNoParameterCommands('sticky,autostatus,autostatuscap,fullhtml,hauto,vauto,closeclick,wrap,followmouse,mouseoff,compatmode');
var olCheckMouseCapture=true;if((olNs4||olNs6||olIe4)){olMouseCapture();}else{overlib=no_overlib;nd=no_overlib;ver3fix=true;}window.overlib=overlib;window.nd=nd;})();

/*            'js/not_prototype.js',*/
// not_prototype.js - a stop-gap measure to provide some parts of prototype.js
;(function() {

// TODO: replace with jQuery's niceities
var PrototypeFormElementSerializers = {
  input: function(element) {
    switch (element.type.toLowerCase()) {
      case 'checkbox':
      case 'radio':
        return PrototypeFormElementSerializers.inputSelector(element);
      default:
        return PrototypeFormElementSerializers.textarea(element);
    }
  },

  inputSelector: function(element) {
    return element.checked ? element.value : null;
  },

  textarea: function(element) {
    return element.value;
  },

  select: function(element) {
    return this[element.type == 'select-one' ?
      'selectOne' : 'selectMany'](element);
  },

  selectOne: function(element) {
    var index = element.selectedIndex;
    return index >= 0 ? this.optionValue(element.options[index]) : null;
  },

  selectMany: function(element) {
    var values, length = element.length, i;
    if (!length) return null;

    for (i = 0, values = []; i < length; i++) {
      var opt = element.options[i];
      if (opt.selected) values.push(this.optionValue(opt));
    }
    return values;
  },

  optionValue: function(opt) {
    // extend element because hasAttribute may not be native
    // return Element.extend(opt).hasAttribute('value') ? opt.value : opt.text;
    // assume hasAttribute is available
    return opt.hasAttribute('value') ? opt.value : opt.text;
  }
};

var NotPrototype = {
    Browser: {
        IE:     !!(window.attachEvent && !window.opera),
        WebKit: navigator.userAgent.indexOf('AppleWebKit/') > -1
    },
    Form: {
        getElements: function(form) {
            return jQuery.map(form.getElementsByTagName('*'), function(child) {
                if (PrototypeFormElementSerializers[child.tagName.toLowerCase()]) {
                    return child;
                }
            });
        },
        getValue: function(element) {
            var method = element.tagName.toLowerCase();
            return PrototypeFormElementSerializers[method](element);
        }
    },
    Event: {
        stop: function(event) {
            if (event.preventDefault) {
                event.preventDefault();
                event.stopPropagation();
            } else {
                event.returnValue = false;
                event.cancelBubble = true;
            }
        }
    },
    Position: {
        cumulativeOffset: function(element) {
            var valueT = 0, valueL = 0;
            do {
                valueT += element.offsetTop  || 0;
                valueL += element.offsetLeft || 0;
                element = element.offsetParent;
            } while (element);
            return [valueL, valueT];
        },
        positionedOffset: function(element) {
            var valueT = 0, valueL = 0;
            do {
                valueT += element.offsetTop  || 0;
                valueL += element.offsetLeft || 0;
                element = element.offsetParent;
                if (element) {
                    if (element.tagName.toLowerCase() == 'body') break;
                    var p = jQuery(element).css('position');
                    if (p == 'relative' || p == 'absolute') break;
                }
            } while (element);
            return [valueL, valueT];
        },
        page: function(forElement) {
            var valueT = 0, valueL = 0;

            var element = forElement;
            do {
                valueT += element.offsetTop  || 0;
                valueL += element.offsetLeft || 0;

                // Safari fix
                if (element.offsetParent == document.body)
                    if (jQuery(element).css('position') == 'absolute') break;

            } while (element = element.offsetParent);

            element = forElement;
            do {
                if (!window.opera || element.tagName.toLowerCase() == 'body') {
                    valueT -= element.scrollTop  || 0;
                    valueL -= element.scrollLeft || 0;
                }
            } while (element = element.parentNode);

            return [valueL, valueT];
        },
        absolutize: function(element) {
            var $element = jQuery(element);
            if ($element.css('position') == 'absolute') return;

            var position = $element.position();
            var top     = position.top;
            var left    = position.left;
            var width   = element.clientWidth;
            var height  = element.clientHeight;

            $element.data('absolutize_original', {
                left   : left - parseFloat($element.css('left')  || 0),
                top    : top  - parseFloat($element.css('top') || 0),
                width  : $element.css('width'),
                height : $element.css('height')
            })
            .css({
                top: top + 'px',
                left: left + 'px',
                width: width + 'px',
                height: height + 'px',
                position: 'absolute'});
        }
    },
    String: {
        toQueryParams: function(string, separator) {
            var match = string.trim().match(/([^?#]*)(#.*)?$/);
            if (!match) return {};

            return match[1].split(separator || '&').reduce(function(hash, pair) {
              if ((pair = pair.split('='))[0]) {
                var key = decodeURIComponent(pair.shift());
                var value = pair.length > 1 ? pair.join('=') : pair[0];
                if (value != null) value = decodeURIComponent(value);

                if (key in hash) {
                  if (hash[key].constructor != Array) hash[key] = [hash[key]];
                  hash[key].push(value);
                }
                else hash[key] = value;
              }
              return hash;
            }, {});
        }
    }
};

// Safari returns margins on body which is incorrect if the child is absolutely
// positioned.  For performance reasons, redefine Position.cumulativeOffset for
// KHTML/WebKit only.
if (NotPrototype.Browser.WebKit) {
    NotPrototype.Position.cumulativeOffset = function(element) {
        var valueT = 0, valueL = 0;
        do {
          valueT += element.offsetTop  || 0;
          valueL += element.offsetLeft || 0;
          if (element.offsetParent == document.body)
            if (Element.getStyle(element, 'position') == 'absolute') break;

          element = element.offsetParent;
        } while (element);

        return [valueL, valueT];
    };
}

// custom shim in case support for this is ever removed
if (!this.Option) {
    this.Option = function(text, value, defaultSelected, selected) {
        var opt = document.createElement('option');
        opt.textContent = text;
        opt.value = value;
        opt.defaultSelected = defaultSelected;
        opt.selected = selected;
        return opt;
    };
}

this.NotPrototype = NotPrototype;
}).call(this);

/*            'js/jquery.support.js',*/
/* globals jQuery */
(function($) {
    'use strict';

    var detector = document.createElement('div');

    var has_style_support = function(property, value) {
      if(getInternetExplorerVersion() != -1 && getInternetExplorerVersion() < 10) return true;
        detector.style[property] = value;
        return detector.style[property] === value;
    };

    var support = {
        flexbox: has_style_support('display', 'flex') ||
            has_style_support('display', '-webkit-flex'),
        transitionEvent: 'TransitionEvent' in window
    };
    for (var i in support) {
        if (!(i in $.support)) {
            $.support[i] = support[i];
        }
    }
    if (!support.flexbox) {
        //allow css styling to radically change when flexbox isn't available
        document.documentElement.className += ' no-flexbox';
    }
})(jQuery);

/*            'js/json2.js',*/
/*
    http://www.JSON.org/json2.js
    2010-08-25

    Public Domain.

    NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.

    See http://www.JSON.org/js.html


    This code should be minified before deployment.
    See http://javascript.crockford.com/jsmin.html

    USE YOUR OWN COPY. IT IS EXTREMELY UNWISE TO LOAD CODE FROM SERVERS YOU DO
    NOT CONTROL.


    This file creates a global JSON object containing two methods: stringify
    and parse.

        JSON.stringify(value, replacer, space)
            value       any JavaScript value, usually an object or array.

            replacer    an optional parameter that determines how object
                        values are stringified for objects. It can be a
                        function or an array of strings.

            space       an optional parameter that specifies the indentation
                        of nested structures. If it is omitted, the text will
                        be packed without extra whitespace. If it is a number,
                        it will specify the number of spaces to indent at each
                        level. If it is a string (such as '\t' or '&nbsp;'),
                        it contains the characters used to indent at each level.

            This method produces a JSON text from a JavaScript value.

            When an object value is found, if the object contains a toJSON
            method, its toJSON method will be called and the result will be
            stringified. A toJSON method does not serialize: it returns the
            value represented by the name/value pair that should be serialized,
            or undefined if nothing should be serialized. The toJSON method
            will be passed the key associated with the value, and this will be
            bound to the value

            For example, this would serialize Dates as ISO strings.

                Date.prototype.toJSON = function (key) {
                    function f(n) {
                        // Format integers to have at least two digits.
                        return n < 10 ? '0' + n : n;
                    }

                    return this.getUTCFullYear()   + '-' +
                         f(this.getUTCMonth() + 1) + '-' +
                         f(this.getUTCDate())      + 'T' +
                         f(this.getUTCHours())     + ':' +
                         f(this.getUTCMinutes())   + ':' +
                         f(this.getUTCSeconds())   + 'Z';
                };

            You can provide an optional replacer method. It will be passed the
            key and value of each member, with this bound to the containing
            object. The value that is returned from your method will be
            serialized. If your method returns undefined, then the member will
            be excluded from the serialization.

            If the replacer parameter is an array of strings, then it will be
            used to select the members to be serialized. It filters the results
            such that only members with keys listed in the replacer array are
            stringified.

            Values that do not have JSON representations, such as undefined or
            functions, will not be serialized. Such values in objects will be
            dropped; in arrays they will be replaced with null. You can use
            a replacer function to replace those with JSON values.
            JSON.stringify(undefined) returns undefined.

            The optional space parameter produces a stringification of the
            value that is filled with line breaks and indentation to make it
            easier to read.

            If the space parameter is a non-empty string, then that string will
            be used for indentation. If the space parameter is a number, then
            the indentation will be that many spaces.

            Example:

            text = JSON.stringify(['e', {pluribus: 'unum'}]);
            // text is '["e",{"pluribus":"unum"}]'


            text = JSON.stringify(['e', {pluribus: 'unum'}], null, '\t');
            // text is '[\n\t"e",\n\t{\n\t\t"pluribus": "unum"\n\t}\n]'

            text = JSON.stringify([new Date()], function (key, value) {
                return this[key] instanceof Date ?
                    'Date(' + this[key] + ')' : value;
            });
            // text is '["Date(---current time---)"]'


        JSON.parse(text, reviver)
            This method parses a JSON text to produce an object or array.
            It can throw a SyntaxError exception.

            The optional reviver parameter is a function that can filter and
            transform the results. It receives each of the keys and values,
            and its return value is used instead of the original value.
            If it returns what it received, then the structure is not modified.
            If it returns undefined then the member is deleted.

            Example:

            // Parse the text. Values that look like ISO date strings will
            // be converted to Date objects.

            myData = JSON.parse(text, function (key, value) {
                var a;
                if (typeof value === 'string') {
                    a =
/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}(?:\.\d*)?)Z$/.exec(value);
                    if (a) {
                        return new Date(Date.UTC(+a[1], +a[2] - 1, +a[3], +a[4],
                            +a[5], +a[6]));
                    }
                }
                return value;
            });

            myData = JSON.parse('["Date(09/09/2001)"]', function (key, value) {
                var d;
                if (typeof value === 'string' &&
                        value.slice(0, 5) === 'Date(' &&
                        value.slice(-1) === ')') {
                    d = new Date(value.slice(5, -1));
                    if (d) {
                        return d;
                    }
                }
                return value;
            });


    This is a reference implementation. You are free to copy, modify, or
    redistribute.
*/

/*jslint evil: true, strict: false */

/*members "", "\b", "\t", "\n", "\f", "\r", "\"", JSON, "\\", apply,
    call, charCodeAt, getUTCDate, getUTCFullYear, getUTCHours,
    getUTCMinutes, getUTCMonth, getUTCSeconds, hasOwnProperty, join,
    lastIndex, length, parse, prototype, push, replace, slice, stringify,
    test, toJSON, toString, valueOf
*/


// Create a JSON object only if one does not already exist. We create the
// methods in a closure to avoid creating global variables.

if (!this.JSON) {
    this.JSON = {};
}

(function () {

    function f(n) {
        // Format integers to have at least two digits.
        return n < 10 ? '0' + n : n;
    }

    if (typeof Date.prototype.toJSON !== 'function') {

        Date.prototype.toJSON = function (key) {

            return isFinite(this.valueOf()) ?
                   this.getUTCFullYear()   + '-' +
                 f(this.getUTCMonth() + 1) + '-' +
                 f(this.getUTCDate())      + 'T' +
                 f(this.getUTCHours())     + ':' +
                 f(this.getUTCMinutes())   + ':' +
                 f(this.getUTCSeconds())   + 'Z' : null;
        };

        String.prototype.toJSON =
        Number.prototype.toJSON =
        Boolean.prototype.toJSON = function (key) {
            return this.valueOf();
        };
    }

    var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        gap,
        indent,
        meta = {    // table of character substitutions
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"' : '\\"',
            '\\': '\\\\'
        },
        rep;


    function quote(string) {

// If the string contains no control characters, no quote characters, and no
// backslash characters, then we can safely slap some quotes around it.
// Otherwise we must also replace the offending characters with safe escape
// sequences.

        escapable.lastIndex = 0;
        return escapable.test(string) ?
            '"' + string.replace(escapable, function (a) {
                var c = meta[a];
                return typeof c === 'string' ? c :
                    '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
            }) + '"' :
            '"' + string + '"';
    }


    function str(key, holder) {

// Produce a string from holder[key].

        var i,          // The loop counter.
            k,          // The member key.
            v,          // The member value.
            length,
            mind = gap,
            partial,
            value = holder[key];

// If the value has a toJSON method, call it to obtain a replacement value.

        if (value && typeof value === 'object' &&
                typeof value.toJSON === 'function') {
            value = value.toJSON(key);
        }

// If we were called with a replacer function, then call the replacer to
// obtain a replacement value.

        if (typeof rep === 'function') {
            value = rep.call(holder, key, value);
        }

// What happens next depends on the value's type.

        switch (typeof value) {
        case 'string':
            return quote(value);

        case 'number':

// JSON numbers must be finite. Encode non-finite numbers as null.

            return isFinite(value) ? String(value) : 'null';

        case 'boolean':
        case 'null':

// If the value is a boolean or null, convert it to a string. Note:
// typeof null does not produce 'null'. The case is included here in
// the remote chance that this gets fixed someday.

            return String(value);

// If the type is 'object', we might be dealing with an object or an array or
// null.

        case 'object':

// Due to a specification blunder in ECMAScript, typeof null is 'object',
// so watch out for that case.

            if (!value) {
                return 'null';
            }

// Make an array to hold the partial results of stringifying this object value.

            gap += indent;
            partial = [];

// Is the value an array?

            if (Object.prototype.toString.apply(value) === '[object Array]') {

// The value is an array. Stringify every element. Use null as a placeholder
// for non-JSON values.

                length = value.length;
                for (i = 0; i < length; i += 1) {
                    partial[i] = str(i, value) || 'null';
                }

// Join all of the elements together, separated with commas, and wrap them in
// brackets.

                v = partial.length === 0 ? '[]' :
                    gap ? '[\n' + gap +
                            partial.join(',\n' + gap) + '\n' +
                                mind + ']' :
                          '[' + partial.join(',') + ']';
                gap = mind;
                return v;
            }

// If the replacer is an array, use it to select the members to be stringified.

            if (rep && typeof rep === 'object') {
                length = rep.length;
                for (i = 0; i < length; i += 1) {
                    k = rep[i];
                    if (typeof k === 'string') {
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            } else {

// Otherwise, iterate through all of the keys in the object.

                for (k in value) {
                    if (Object.hasOwnProperty.call(value, k)) {
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            }

// Join all of the member texts together, separated with commas,
// and wrap them in braces.

            v = partial.length === 0 ? '{}' :
                gap ? '{\n' + gap + partial.join(',\n' + gap) + '\n' +
                        mind + '}' : '{' + partial.join(',') + '}';
            gap = mind;
            return v;
        }
    }

// If the JSON object does not yet have a stringify method, give it one.

    if (typeof JSON.stringify !== 'function') {
        JSON.stringify = function (value, replacer, space) {

// The stringify method takes a value and an optional replacer, and an optional
// space parameter, and returns a JSON text. The replacer can be a function
// that can replace values, or an array of strings that will select the keys.
// A default replacer method can be provided. Use of the space parameter can
// produce text that is more easily readable.

            var i;
            gap = '';
            indent = '';

// If the space parameter is a number, make an indent string containing that
// many spaces.

            if (typeof space === 'number') {
                for (i = 0; i < space; i += 1) {
                    indent += ' ';
                }

// If the space parameter is a string, it will be used as the indent string.

            } else if (typeof space === 'string') {
                indent = space;
            }

// If there is a replacer, it must be a function or an array.
// Otherwise, throw an error.

            rep = replacer;
            if (replacer && typeof replacer !== 'function' &&
                    (typeof replacer !== 'object' ||
                     typeof replacer.length !== 'number')) {
                throw new Error('JSON.stringify');
            }

// Make a fake root object containing our value under the key of ''.
// Return the result of stringifying the value.

            return str('', {'': value});
        };
    }


// If the JSON object does not yet have a parse method, give it one.

    if (typeof JSON.parse !== 'function') {
        JSON.parse = function (text, reviver) {

// The parse method takes a text and an optional reviver function, and returns
// a JavaScript value if the text is a valid JSON text.

            var j;

            function walk(holder, key) {

// The walk method is used to recursively walk the resulting structure so
// that modifications can be made.

                var k, v, value = holder[key];
                if (value && typeof value === 'object') {
                    for (k in value) {
                        if (Object.hasOwnProperty.call(value, k)) {
                            v = walk(value, k);
                            if (v !== undefined) {
                                value[k] = v;
                            } else {
                                delete value[k];
                            }
                        }
                    }
                }
                return reviver.call(holder, key, value);
            }


// Parsing happens in four stages. In the first stage, we replace certain
// Unicode characters with escape sequences. JavaScript handles many characters
// incorrectly, either silently deleting them, or treating them as line endings.

            text = String(text);
            cx.lastIndex = 0;
            if (cx.test(text)) {
                text = text.replace(cx, function (a) {
                    return '\\u' +
                        ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                });
            }

// In the second stage, we run the text against regular expressions that look
// for non-JSON patterns. We are especially concerned with '()' and 'new'
// because they can cause invocation, and '=' because it can cause mutation.
// But just to be safe, we want to reject all unexpected forms.

// We split the second stage into 4 regexp operations in order to work around
// crippling inefficiencies in IE's and Safari's regexp engines. First we
// replace the JSON backslash pairs with '@' (a non-JSON character). Second, we
// replace all simple value tokens with ']' characters. Third, we delete all
// open brackets that follow a colon or comma or that begin the text. Finally,
// we look to see that the remaining characters are only whitespace or ']' or
// ',' or ':' or '{' or '}'. If that is so, then the text is safe for eval.

            if (/^[\],:{}\s]*$/
.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
.replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
.replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {

// In the third stage we use the eval function to compile the text into a
// JavaScript structure. The '{' operator is subject to a syntactic ambiguity
// in JavaScript: it can begin a block or an object literal. We wrap the text
// in parens to eliminate the ambiguity.

                j = eval('(' + text + ')');

// In the optional fourth stage, we recursively walk the new structure, passing
// each name/value pair to a reviver function for possible transformation.

                return typeof reviver === 'function' ?
                    walk({'': j}, '') : j;
            }

// If the text is not JSON parseable, then a SyntaxError is thrown.

            throw new SyntaxError('JSON.parse');
        };
    }
}());

/*            'js/savetree_cookie.js',*/
// java script to save tree state

var _fgtCookieName = null;
var _fgtCookieValue = null;

function BeginSetCookie(prefix, cookieName) {
  //var prefix = "SAVETREE";
  
  _fgtCookieName = prefix + "/" + cookieName;

  _fgtCookieValue = new String( );
}

function AddCookieValue(value) {
  var escValue = new String( );
  var i;

  for (var i = 0; i < value.length; i++) {
    var oneChar = value.substring(i, i + 1);

    if (oneChar == " " || oneChar == '\\')
      escValue += '\\';

      escValue += oneChar;
  }

  _fgtCookieValue += escValue + " ";
}

function EndSetCookie( ) {
  pathname = location.pathname;
  pathname = pathname.substring(0, pathname.lastIndexOf('/')) +'/';

  // set expiry date to 1 year from now.
  var expireDate = new Date( );
  expireDate.setTime(expireDate.getTime() + (365 * 24 * 3600 * 1000));

  document.cookie = _fgtCookieName + "=" + escape(_fgtCookieValue) +
    "; expires=" + expireDate.toGMTString( ) +
    "; path=" + pathname;
}

function getCookieVal (offset) {
   var endstr = document.cookie.indexOf (";", offset);
   if (endstr == -1)
      endstr = document.cookie.length;
   return unescape(document.cookie.substring(offset, endstr));
}

function GetCookie (name) {
  var arg = "FortiGate" + name + "=";
  var alen = arg.length;
  var clen = document.cookie.length;
  var i = 0;
  while (i < clen) {
    var j = i + alen;
    if (document.cookie.substring(i, j) == arg)
      return getCookieVal (j);
    i = document.cookie.indexOf(" ", i) + 1;
    if (i == 0)
      break;
  }

  return null;
}

/*
alert("here");
var pathname = location.pathname;
//document.write("<p>pathname=" + pathname + "</p>");
var cookieStr = GetCookie(pathname);

if (cookieStr == null) {
  alert("cookie " + pathname + " is not found. A new cookie will be created");

  BeginSetCookie( );

  //AddCookieValue("12 3");
  //AddCookieValue("45\\ 6");
  //AddCookieValue("789");

  EndSetCookie( );
}

//document.write("<p>cookieStr=" + cookieStr + "</p>");
*/
function save_tree_state(prefix, cname)
{
    BeginSetCookie(prefix, cname);

    $j("[name=tree] img:first-child").each( function() {
        var img_obj = this;
        var txt_obj = this.nextSibling.nextSibling;

        if (txt_obj && img_obj.src.match(/twistie_expanded.gif$/))
        {
            AddCookieValue( txt_obj.innerHTML );
        }
    });

    EndSetCookie();
}


// -- End Hiding Here -->

/*            'js/wij_modal_core.js',*/
/******************************
 wij_modal_core.js - Inline modal dialog support
 Init by A. Krywaniuk, Mar 2008
 addContent class adapted from Faz/dashboard.js
 GUI widgetization project
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

//EXPORT_SYMBOL propagate_modal_mask

// This isn't really a symbol, but a hack to prevent the obfuscator from
// obfuscating the class ".layout-content", since it treats those as two
// separate variables.
//EXPORT_SYMBOL content
//EXPORT_SYMBOL version

// Some custom properties that can be overridden externally.
//EXPORT_SYMBOL close_button
//EXPORT_SYMBOL callback_handlers
//EXPORT_SYMBOL bg_color
//EXPORT_SYMBOL escape_to_exit

/*globals addEvent,clogger,getInternetExplorerVersion,update_iframe_height,wij_align_and_show_modal_dlg*/

var IE = window.ActiveXObject;
var FF = navigator.userAgent.indexOf("Gecko") > 0;

// IE6 - whether the browser is IE6 (or older... not that we support that).
var IE6 = (IE && getInternetExplorerVersion() < 7.0);


// IE6 doesn't support the "position:fixed" tag. It is possible to emulate this
// effect with no jitter using a technique described at:
// http://www.webmasterworld.com/css/3592524.htm. However, it may not be worth
// our while to jump through hoops for better visual effects on an old browser.
var have_position_fixed = (!IE6);


// propagate_modal_mask - whether to propagate the modal mask to the top
// and navbar frames. The jQuery layout manager plugin on the top frame makes
// heavy use of z-index settings which are difficult to mask properly in
// older browsers.
// TODO: Update the HTML structure of the index frame so that the mask
// propagation works cross-browser.
var propagate_modal_mask = true;


// Supported modal operation types.
var modal_op_dialog = 1;
var modal_op_rename = 2;
var modal_op_menu = 3;
var modal_op_auxiliary = 4;


// InlineModal - inline modal dialog manager class.
var InlineModal = {
    in_modal_op : false,
    op_type : 0,
    maskdiv_callbacks_init : false,
    mask_div : null,
    dlg_div : null,
    end_contextmenu_cb : null,
    scroll_contextmenu_cb : null,
    end_rename_cb : null,
    aux_target_wnd : null,

    in_rename_op : function() { return (this.in_modal_op && this.op_type == modal_op_rename); }
};

// wij_modal_show_timer - semaphore timer variable for wij_align_and_show_modal_dlg
var wij_modal_show_timer = null;

if (!mlogger) {
      var mlogger = {
            debug : function (msg) {}
      };
}

function wij_in_modal_op()
{
    return (InlineModal.in_modal_op && InlineModal.op_type == modal_op_dialog);
}

/******************************
  Mask div sizing & alignment
******************************/

// handle_maskdiv_click - event handler for mouse click on the mask div.
function handle_maskdiv_click()
{
    var oModal = InlineModal;
    if (!oModal.in_modal_op)
        return false;

    if (oModal.op_type == modal_op_rename)
    {
        wij_end_modal_rename(true);
    }
    else if (oModal.op_type == modal_op_menu)
    {
        wij_end_contextmenu_mask();
    }
    else if (oModal.op_type == modal_op_auxiliary)
    {
        oModal.aux_target_wnd.handle_maskdiv_click();
    }
}


// wij_align_modal_dlg - align the inline modal dialog in the main window.
function wij_align_modal_dlg()
{
mlogger.debug("wij_align_modal_dlg");

    if (!InlineModal.in_modal_op)
    {
mlogger.debug("wij_align_modal_dlg - skip alignment");
        return;
    }

    var dlg_div = InlineModal.dlg_div;
    var root = document.documentElement;

    var w_dlg = dlg_div.offsetWidth || dlg_div.firstChild && dlg_div.firstChild.offsetWidth || 400;
    var h_dlg = dlg_div.offsetHeight || dlg_div.firstChild && dlg_div.firstChild.offsetHeight || 300;

    var w_pg = root.clientWidth;
    var h_pg = root.clientHeight;

    // Display the document slightly above center (for better visual effect).
    var h_off = (h_pg - h_dlg - 100) / 2;
    if (h_off < 0) h_off = 0;

    var l = (w_pg - w_dlg) / 2;
    var t = h_off;

mlogger.debug("w_pg=" + w_pg + ", w_dlg=" + w_dlg + ", l=" + l);
mlogger.debug("h_pg=" + h_pg + ", h_dlg=" + h_dlg + ", t=" + t);

    dlg_div.style.left = l + "px";
    dlg_div.style.top  = t + "px";
}


// wij_adjust_mask_size - mask div re-size according to browser resize.
function wij_adjust_mask_size()
{
    var mask_div = InlineModal.mask_div;

    var root = document.documentElement;
    var bd = document.body;

    var w_pg = root.clientWidth;
    var h_pg = root.clientHeight;

    var w_bd = bd.offsetWidth;
    var h_bd = bd.offsetHeight;

    var h_sc = bd.scrollHeight;

    // use scrollHeight and hide overflow, by Nan Mou
    var h = Math.max(h_pg, h_bd, h_sc);

    mask_div.style.height = h + "px";
    bd.style.overflow = 'hidden';

    return;

    // // TODO: currently obsolete code...
    // var root = document.getElementById("wij_layout_container");

    // // I'm not sure why we think we can just measure the first element in the
    // // body. This logic comes from the original Faz code.
    // if (!root)
    //     root = bd.firstDescendant(); // note that this is a function from
                                        // prototype - would have to be recreated
                                        // $j(bd).children(':first').get(0);


    // // The width adjustment for the mask is only needed on IE.
    // if (IE)
    // {
    //     var root_wd = root.offsetWidth; // + 20;
    //     var body_wd = bd.clientWidth;

    //     var w = Math.max(root_wd, body_wd);
    //     mask_div.style.width = w + "px";
    // }


    // /* Height adjustment */

    // // On IE, the body height is a fairly useless measurement. If the window
    // // is bigger than the document then the body height will be the same as the
    // // window size. But if the document is larger than the window then the
    // // scroll height seems to be what we want.

    // if (IE)
    // {
    //     var bdy_ht = bd.scrollHeight;
    // }
    // else
    // {
    //     // TODO: we could consider caching the top-margin measurement, since it
    //     // is a constant.
    //     var bdy_ht = bd.offsetHeight + parseInt($j(bd).css("marginTop"));
    // }

    // var root_ht = root.offsetHeight + 20;
    // var wnd_ht = bd.clientHeight;

    // //clogger.debug("bdy_ht=" + bdy_ht + ", root_ht=" + root_ht + ", wnd_ht=" + wnd_ht);

    // var h = Math.max(bdy_ht, root_ht);
    // if (h > wnd_ht)
    // {
    //     mask_div.style.height = h + "px";
    // }
    // else
    // {
    //     mask_div.style.height = "100%";
    // }
}


// wij_modal_onscroll - called when the window is scrolled.
function wij_modal_onscroll()
{
    // This callback is used to recenter fixed positioned dialogs. It is not necessary
    // to do anything if the browser can natively support the position:fixed CSS
    // style (which is true of all modern browsers except IE6).
    if (have_position_fixed)
        return;

    var oModal = InlineModal;
    if (!oModal.in_modal_op)
        return;

    // Recenter the dialog in the window.
    if (oModal.op_type == modal_op_dialog)
    {
        var dv_dialog = oModal.dlg_div;
        dv_dialog.style.visibility = "hidden";

        if (wij_modal_show_timer) clearTimeout(wij_modal_show_timer);
        wij_modal_show_timer = setTimeout(wij_align_and_show_modal_dlg, 50);
    }
    else if (oModal.op_type == modal_op_menu)
    {
        if (oModal.scroll_contextmenu_cb)
            oModal.scroll_contextmenu_cb();
    }
}


// wij_modal_onresize - called when the window is resized.
function wij_modal_onresize()
{
     var oModal = InlineModal;
    if (!oModal.in_modal_op)
        return;

    wij_adjust_mask_size();

    if (oModal.op_type == modal_op_dialog)
    {
        wij_align_modal_dlg();
    }
}


// setup_maskdiv_callbacks - setup the callbacks so the masking div is
// automatically adjusted to the size of the window.
function setup_maskdiv_callbacks()
{
    if (InlineModal.maskdiv_callbacks_init) return;

    addEvent(window, "resize", wij_modal_onresize);
    addEvent(window, "scroll", wij_modal_onscroll);
    if (IE) addEvent(document.body.firstChild, 'resize', wij_modal_onresize);

    InlineModal.maskdiv_callbacks_init = true;
}



/******************************
  Modal dialog API
******************************/

// setup_mask_div - get the mask div, or create a new one if it doesn't exist.
function setup_mask_div()
{
    var mask_div = InlineModal.mask_div;
    if (mask_div)
        return mask_div;

    // If the mask div doesn't exist then create it. Create it inside a temp div so that
    // we can specify the whole object as HTML.
    var tmp_div = document.createElement("DIV");
    tmp_div.innerHTML = '<div id="maskDiv" style="display: none; background-color: black; position: absolute; left: 0; top: 0; z-index: 10000; height: 100%; width: 100%; -moz-opacity: 0.5; opacity: 0.5; filter: alpha(opacity=50);"  onclick="handle_maskdiv_click()" onmousedown="return false" onmousemove="return false"  onmouseup="return false" ondblclick="return false" onselectstart="return false" oncontextmenu="return false"></div>' ;

    mask_div = tmp_div.childNodes[0];
    $j(mask_div).appendTo('body');

    InlineModal.mask_div = mask_div;
    return mask_div;
}


// display_mask_div - make the mask div visible.
function display_mask_div(opacity)
{
    var mask_div = InlineModal.mask_div;
    $j(mask_div).css("opacity", opacity);

    // Show the mask div right away, since there is nothing to load from the server.
    mask_div.style.visibility = "hidden";
    mask_div.style.display = "";
    wij_adjust_mask_size();
    mask_div.style.visibility = "visible";

    setup_maskdiv_callbacks();

    // Extend the mask to the top frame.
    if (propagate_modal_mask && (top != window) && top.display_auxiliary_mask)
    {
        var wnd = window.parent;
        if (wnd && wnd.wij_in_modal_op && wnd.wij_in_modal_op())
        {
            return;
        }

        var panels_adjusted = 0;

        // The main content frame needs to be brought forward or
        // else the top frame auxiliary mask will cover everything,
        // including the modal dialog you are trying to display.
        top.$j(".layout-center").css("z-index", "");
        top.$j(".layout-main").each( function() {
            var elem = $j(this);
            elem.data("zIndex", elem.css("z-index"));
            elem.css("z-index", 10100);

            panels_adjusted++;
        });

        // Only display the top auxiliary mask if at least one panel
        // has had it's z-index adjusted. If not, the mask will cover
        // the full window.
        if (panels_adjusted > 0)
        {
            // change at 2016-12 to adapt flat GUI
            //top.display_auxiliary_mask(window, opacity);
        }
    }
}


// display_auxiliary_mask - when one frame is displaying a modal mask, also extend
// the mask to the other two frames (navbar, subnav, and main).
function display_auxiliary_mask(target_wnd, opacity)
{
    var oModal = InlineModal;

    // Ignore the auxiliary mask request for the frame that is displaying
    // the primary mask.
    if (oModal.in_modal_op || (target_wnd == window))
        return;

    oModal.in_modal_op = true;
    oModal.op_type = modal_op_auxiliary;
    oModal.aux_target_wnd = target_wnd;

    var mask_div = setup_mask_div();
    // Set the auxiliary mask to match the tint of the primary one.
    $j(mask_div).css("opacity", opacity);

    // Show the mask div right away, since there is nothing to load from the server.
    mask_div.style.visibility = "hidden";
    mask_div.style.display = "";
    wij_adjust_mask_size();
    mask_div.style.visibility = "visible";

    setup_maskdiv_callbacks();
}


// hide_mask_div - make the mask div invisible.
function hide_mask_div()
{
    var mask_div = InlineModal.mask_div;
    mask_div.style.display = "none";

    // Extend the mask to the top frame.
    if (propagate_modal_mask && (top != window) && top.hide_auxiliary_mask)
    {
        var wnd = window.parent;
        if (wnd && wnd.wij_in_modal_op && wnd.wij_in_modal_op())
        {
            return;
        }

        top.$j(".layout-center").css("z-index", 1);
        top.$j(".layout-main").each( function() {
            var elem = $j(this);
            elem.css("z-index", elem.data("zIndex"));
        });

        // change at 2016-12 to adapt flat GUI
        //top.hide_auxiliary_mask(window);
    }

    // if overflow is hidden, show it, by Nan Mou
    if (document.body.style.overflow && document.body.style.overflow == 'hidden')
      document.body.style.overflow = '';
}


// hide_auxiliary_mask - make the mask div invisible.
function hide_auxiliary_mask(target_wnd)
{
    // Ignore the auxiliary mask request for the frame that is displaying
    // the primary mask.
    if (target_wnd == window)
        return;

    var mask_div = InlineModal.mask_div;
    mask_div.style.display = "none";

    var oModal = InlineModal;
    if (oModal.in_modal_op && oModal.op_type == modal_op_auxiliary)
    {
        oModal.in_modal_op = false;
        oModal.op_type = 0;
    }
}


// setup_modal_dlg - get the inline dialog div, or create a new one if it doesn't exist.
function setup_modal_dlg()
{
    var dv_modal = InlineModal.dlg_div;
    if (dv_modal)
        return dv_modal;

    var tmp_div = document.createElement("DIV");
//    tmp_div.innerHTML = '<div id="moduleList" style="position: absolute; display: none; visibility: hidden; '
    tmp_div.innerHTML = '<div id="modal_div" style="position:absolute; overflow:hidden; display:none; visibility:hidden; background-color: white; left: -1000; top: -1000; z-index: 10001"></div>';

    dv_modal = tmp_div.childNodes[0];

    $j(dv_modal).appendTo('body');

    InlineModal.dlg_div = dv_modal;
    return dv_modal;
}


// aModalIframe_tpl - template for containing iframe-based modal dialogs.
var aModalIframe_tpl = [
    '<iframe id="',
    '', // [1] = id
    '" name="',
    '', // [3] = id

    '" frameBorder=0 scrolling="auto" src="',
    '', // [5] = url
    // It is necessary to specify "overflow:hidden" or else IE6 will leave
    // room for scrollbars (appears as a thick white right/bottom margin).
//    '" style="overflow:hidden; width:',
    '" style="overflow:auto; width:',
    '', // [7] = width
    '; height:',
    '', // [9] = height
    '; border: 1px solid ',
    '', // [11] = border_color
    '" />'
];

// wij_set_modal_options - Set modal dialog options
// from a user defined object. To override an option, the property
// must exist in the InlineModal definition.
function wij_set_modal_options(opts)
{
    var oModal = InlineModal;

    // Parameter defaults - these will be reset every time
    // a modal dialog is displayed.
    oModal.height = "auto";
    oModal.width = 300; //"auto";
    oModal.close_button = true;
    oModal.callback_handlers = true;
    oModal.bg_color = "#ddd";
    oModal.escape_to_exit = true;

    if (typeof(opts) != "object") return;

    for (var prop in opts)
    {
        if (prop in oModal)
        {
            oModal[prop] = opts[prop];
        }
    }
}

// next_modaldlg_seqno - serial number generator for inline modal dialogs.
var next_modaldlg_seqno = 1;

/******************************
  Renaming API
******************************/

// crack_kbd_event - keypress helper (copied from the JS console).
function crack_kbd_event(evt)
{
    if (evt.which)
    {
        // FF - standard case (e.g. alpha-numeric keys)
        return evt.which;
    }
    else if (evt.keyCode)
    {
        // IE - standard case (all keys)
        // FF - a few special keys (esc, tab)
        return evt.keyCode;
    }

    clogger.debug("crack_kbd_event - No key code in keypress!");
    return 0;
}


// on_rename_keypress - keypress handler during rename operations.
function on_rename_keypress(ev)
{
    if (!ev) ev = window.event;
    var key_code = crack_kbd_event(ev);

    if (key_code == 13) // CR
    {
        wij_end_modal_rename(true);
    }
    else if (key_code == 27) // ESC
    {
        wij_end_modal_rename(false);
    }

    return true;
}


// on_rename_blur - onblur handler during rename operations.
function on_rename_blur(ev)
{
    wij_end_modal_rename(true);
}


// wij_display_rename_dlg - request to begin renaming a menu item.
function wij_display_rename_dlg(dv_main, edit_ctrl, cb_fn)
{
clogger.debug("wij_display_rename_dlg");
    var oModal = InlineModal;
    oModal.in_modal_op = true;
    oModal.op_type = modal_op_rename;
    oModal.end_rename_cb = cb_fn;

    var dv_dialog = setup_modal_dlg();
    var mask_div = setup_mask_div();

    var root = document.documentElement;

    dv_dialog.innerHTML = "";
    dv_dialog.appendChild(dv_main);

    // The edit box is absolutely positioned within the window, so create a
    // full-frame transparent div.
    dv_dialog.style.position = "absolute";
    dv_dialog.style.left = 0;
    dv_dialog.style.top = 0;
    // Don't use 100% height/width here, since that will fail if there are
    // scrollbars.
    dv_dialog.style.width = root.offsetWidth + "px";
    dv_dialog.style.height = root.offsetHeight + "px";
    dv_dialog.style.backgroundColor = "";
    dv_dialog.style.display = "";
    dv_dialog.style.visibility = "visible";

    // Use a slightly lighter mask_div for rename operations.
    display_mask_div(0.3);

    // Set some event handlers for the edit control.
    // NOTE: the onblur handler makes it difficult to inspect the rename dialog with
    // firebug, so you may want to disable it while debugging.
    edit_ctrl.onkeypress = on_rename_keypress;
    edit_ctrl.onblur = on_rename_blur;
    edit_ctrl.focus();
}


// wij_end_modal_rename - finish the rename operation
function wij_end_modal_rename(bCommit)
{
    var oModal = InlineModal;
    var dv_dialog = oModal.dlg_div;

    // First Call the registered callback.
    clogger.debug("wij_end_modal_rename - invoking callback");
    var edit_ctrl = $j(dv_dialog).children(':first').get(0);
    oModal.end_rename_cb(edit_ctrl, bCommit);

    // Now cleanup the dialog display.
    oModal.in_modal_op = false;
    oModal.op_type = 0;
    dv_dialog.innerHTML = "";
    dv_dialog.style.display = "none";
    hide_mask_div();
}


/******************************
  Context Menu API
******************************/

// wij_display_contextmenu_mask - called to display the page mask during
// a modal context menu operation.
//function wij_display_contextmenu_mask(cb_end, cb_scroll)
function wij_display_contextmenu_mask(cb_end, oMenu)
{
    var oModal = InlineModal;
    oModal.in_modal_op = true;
    oModal.op_type = modal_op_menu;

    oModal.end_contextmenu_cb = cb_end;

    // For context menus that are rendered inside a different frame, we don't want
    // them to scroll with the page. Thus set the positioning style to fixed (or add
    // a scroll callback for older browsers (IE6) that don't support that attribute).
    if (oMenu.ignore_y_coord)
    {
        if (have_position_fixed)
        {
            oMenu.element.style.position = "fixed";
            oModal.scroll_contextmenu_cb = null;
        }
        else
        {
            var mk_cb_scroll = function(oMenu) { return function() { reposition_top_aligned_menu(oMenu); } };
            var cb_scroll = (oMenu.ignore_y_coord) ? mk_cb_scroll(oMenu) : null;
            oModal.scroll_contextmenu_cb = cb_scroll;
        }
    }
    else
    {
        oMenu.element.style.position = "absolute";
        oModal.scroll_contextmenu_cb = null;
    }

    // Use a very light mask_div for menu operations.
    var mask_div = setup_mask_div();
    display_mask_div(0.15);
}


// reposition_top_aligned_menu (IE6 only) - realign a menu div that is fixed to the
// top of a div (e.g. in response to a scrolling event).
function reposition_top_aligned_menu(oMenu)
{
    // Use the documentElement instead of the body for calculating scroll offsets in IE6.
    var bd = oMenu.output_document.documentElement;
    var scroll_pos = bd.scrollTop;
    var dv_menu = oMenu.element;
    dv_menu.style.top = scroll_pos + "px";
}


// in_wij_end_contextmenu_mask_cb - semaphore variable for anti-recursion.
var in_wij_end_contextmenu_mask_cb = false;

// wij_end_contextmenu_mask - hide the mask div when ending the menu operation.
function wij_end_contextmenu_mask()
{
    if (in_wij_end_contextmenu_mask_cb)
        return;

    var oModal = InlineModal;

    // The callback function may also call wij_end_contextmenu_mask, so
    // we need to protect against recursion here.
    in_wij_end_contextmenu_mask_cb = true;
    oModal.end_contextmenu_cb();
    in_wij_end_contextmenu_mask_cb = false;

    // Now cleanup the dialog display.
    oModal.in_modal_op = false;
    oModal.op_type = 0;

    hide_mask_div();
}


/******************************
  Generic menu API
******************************/

// Generic menu - simple popup elements w/ no support for auxiliary pages or
// integration w/ the context menu class.
// NOTE: This is currently used by the wij_colorpicker module.

// wij_display_genericmenu_mask - called to display the page mask during
// a modal context menu operation.
//function wij_display_contextmenu_mask(cb_end, cb_scroll)
function wij_display_genericmenu_mask(cb_end, elem)
{
    var oModal = InlineModal;
    oModal.in_modal_op = true;
    oModal.op_type = modal_op_menu;

    // Reusing the callback types from the existing context menu operations.
    oModal.scroll_contextmenu_cb = null;
    oModal.end_contextmenu_cb = cb_end;

    elem.style.position = "absolute";

    // propagate_modal_mask is used for menus in the bottom 3 frames. Currently
    // this menu is only used by popups, so we need to disable the mask propagation.
    // NOTE: this is modifying a global variable, so we need to refactor if we
    // want to make it possible to mix & match.
    propagate_modal_mask = false;

    // Use a very light mask_div for menu operations.
    var mask_div = setup_mask_div();
    display_mask_div(0.15);
}

// wij_auto_resize_iframe - Auto-resize the modal dialog iframe.
function wij_auto_resize_iframe()
{
mlogger.debug("wij_auto_resize_iframe");

    if (!InlineModal.in_modal_op)
    {
mlogger.debug("wij_auto_resize_iframe - skip alignment");
        return;
    }

    // TODO: Margins & padding
    // TODO: Min & max height??
    $j("iframe", InlineModal.dlg_div).each( function() {

        // Temporarily disable scrolling to calculate correct dimensions.
        this.scrolling = "no";

        // Auto-width not currently supported.
/*
        if (InlineModal.width == "auto")
        {
            update_iframe_width(this.id);
        }
*/

        if (InlineModal.height == "auto")
        {
            update_iframe_height(this.id);
        }

        this.scrolling = "auto";
    });

    // Reposition dialog after height adjustment.
    wij_align_modal_dlg();
}

function wij_add_close_button()
{
mlogger.debug("wij_add_close_button");

    var wnd = window.parent;
    var doc_width = $j(document).width();

    // There are a couple of styles of markup used in the various
    // dialogs. Some different code is used to display the close
    // button for each.

    // This should be deprecated eventually.
    $j("table.header tr td").append('<img id="wij_modal_close_btn_abs" src="/images/x_small.gif">');
    $j("#wij_modal_close_btn_abs").each( function() {
            var img = $j(this);

            // TODO: Calculate this width on image load.
            var img_w = 15; //img.width();

            img.css({
                "top": 4,
                "left": doc_width - img_w - 4,
                "position": "absolute",
                "cursor": "pointer" }
            );
        })
        .click( function() {
            wnd.dlg_close();
        })
    ;

    // The new dialog standard has a single H1 tag to show the title - this is where
    // we want the "close" button positioned.
    $j("h1").append('<img id="wij_modal_close_btn_fixed" src="/images/x_small.gif">');
    $j("#wij_modal_close_btn_fixed")
        .css({
            "right": 4,
            "top": 4,
            "position": "fixed",
            "cursor": "pointer" }
        )
        .click( function() {
            wnd.dlg_close();
        })
    ;
}

/*            'js/create_new.js',*/
/******************************
 create_new.js - Create new helper scripts.
 Init by J. Thompson Nov 2009
 Profile Re-org project.
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// global functions
/*global removeOptions,insertOption,refresh_addr,
         get_fw_obj,load_simple_list,setQueryValue*/

// global variables
/*global src_addr,dst_addr,fwpolicy_opts,svr,wp_svr*/

// global classes and consts
/*global FirewallPolicy,SEPARATOR*/

// This can be used to add "create new" and "inline edit" support to pages which
// support those features.

// The variables below are representing the corresponding enumerators in utm_profile.h file.
// Please update the values of the variables if the enum type in that file gets changed.
var PROFILE_NOACT=-1;
var PROFILE_DEL=0;
var PROFILE_EDIT=1;
var PROFILE_VIEW=2;
var PROFILE_NEW=3;
var PROFILE_CLONE=4;

var DEFAULT_PROFILE = "default";
var ALL_DEFAULT_PROFILE = "all_default";
var UTM_PROFILE_VIEW_LIST = "view_list";
var DEFAULT_SSL_SSH_PROFILE  = 'certificate-inspection';

function get_select(icon) {
    var select = $j(icon).siblings("select")[0] || $j(icon).siblings(".multiList-container").children("select");
    return $j(select);
}

function get_icon(select, icon_selector) {
    var icon = $j(select).siblings(icon_selector)[0] || $j(select).parent().siblings(icon_selector);
    return $j(icon);
}

$j(document).ready( function() {
    // "create-new" classed select boxes support the "Create New" helper.
    $j("select.create-new").change( function() {
        cn_on_select_change(this);
        // TODO: It would be better to add the "Create New"
        // shortcut element dynamically in here.
    });

    // Remove "create new" options when already in a modal dialog.
    // TODO: Revisit this and see if we can present multi-leveled modal
    // dialogs in a better way.
    if (parent && parent.wij_in_modal_op && parent.wij_in_modal_op())
    {
        $j("select.create-new > option[value^=__create]").remove();

        // Skip "inline-edit" support too.
        return;
    }

    // "inline-edit" classed select boxes show an edit icon when an existing
    // entry can be edited.
    $j("select.inline-edit:not(.qlist_col_field)")
        // TODO: Doesn't work for some section headings.
        .change( function() {
            get_icon(this, "img.inline-edit").toggle(!$j(this).is(":disabled") && (''+this.value) !== '');
        })

        .after("&nbsp;<img class='inline-edit' src='/images/edit.gif' />")

        // Filter for the new "edit" image alias.
        .siblings("img.inline-edit")

        // Force pointer cursor.
        .css({"cursor": "pointer", "vertical-align": "middle"})

        // Hide inline-edit icon for entries that are disabled
        // or do not have a valid entry selected.
        .each( function() {
            var sel = get_select(this);
            if ($j(sel).is(":disabled") || !$j(sel).val()) {
                $j(this).hide();
            }
        })

        .click(function() {
            var sel = get_select(this);
            $j(sel).each( function() {
                cn_on_select_change(this, PROFILE_EDIT);
            });
        })
    ;

    // "inline-view" classed select boxes show an view icon when an existing
    // entry can be viewed.
    $j("select.inline-view")
        // TODO: Doesn't work for some section headings.
        .change( function() {
            get_icon(this, "img.inline-view").toggle(!$j(this).is(":disabled") && (''+this.value) !== "");
        })

        .after("&nbsp;<img class='inline-view' src='/images/act_view.gif' />")

        // Filter for the new "edit" image alias.
        .siblings("img.inline-view")

        // Force pointer cursor.
        .css({"cursor": "pointer", "vertical-align": "middle"})

        // Hide inline-edit icon for entries that are disabled
        // or do not have a valid entry selected.
        .each( function() {
            var sel = get_select(this);
            if ($j(sel).is(":disabled") || !$j(sel).val()) {
                $j(this).hide();
            }
        })

        .click(function() {
            var sel = get_select(this);
            $j(sel).each( function() {
                cn_on_select_change(this, PROFILE_VIEW);
            });
        })
    ;

    //show an create new icon
    $j("select.utm-inline-add")
        .after("&nbsp;<img class='utm-inline-add' src='/images/act_add.gif' />")
    ;

    // "utm-inline-view" classed select boxes show an view icon when an existing
    // entry is selected
    $j("select.utm-inline-view")
        .change( function() {
            get_icon(this, "img.utm-inline-view").toggle(!$j(this).is(":disabled") && (''+this.value) !== "");
        })
        .after("&nbsp;<img class='utm-inline-view' src='/images/act_view.gif' />")
    ;

    $j("img.utm-inline-view")
        .each( function() {
            $j(this).attr("title", get_tips(PROFILE_VIEW));
        })
        .css("cursor", "pointer")
        .click(function() { cn_on_select_change(get_select(this)[0], PROFILE_VIEW); } )
    ;

    $j("img.utm-inline-add")
        .each( function() {
            $j(this).attr("title", get_tips(PROFILE_NEW));
        })
        .css("cursor", "pointer")
        .click(function() { cn_on_select_change(get_select(this)[0], PROFILE_NEW); } )
    ;

    $j("a.multiple-select")
        .click( function() {
            cn_multiple_select_click( this.name );
        })

        .css("cursor", "pointer")

        .prepend("<img src='/images/multiple.gif' /> ")
    ;
});

var cn_new_object = null;
var cn_new_object_helper = null;
var cn_find_selected_index = null;
var cn_select_object = null;

// cn_on_select_change - Called when a select which supports "create-new" or
// "inline-edit" is changed.
//    field (Object): the select element which has been updated
//    edit (boolean): true if it was an inline-edit which triggered this action.
//    edit  (string): mkey which to be created.
function cn_on_select_change(field, edit)
{
    function createObj(name)
    {
        this.name = name;
    }

    function addressgroupSeparatorCmp(obj1, obj2)
    {
        if (obj2.value == "__address_group__" && obj2.index !== 0) return -1;
        else return 1;
    }

    function addressSeparatorCmp(obj1, obj2)
    {
        if (obj2.value == "__address__" && obj2.index !== 0) return -1;
        else return 1;
    }

    function secondSeparatorCmp(obj1, obj2)
    {
        if (!obj2.value && obj2.index !== 0) return -1;
        else return 1;
    }

    function schedOneTimeSeparatorCmp(obj1, obj2)
    {
        if (obj2.value == "__sched_onetime__" && obj2.index !== 0) return -1;
        else return 1;
    }

    function schedGroupSeparatorCmp(obj1, obj2)
    {
        if (obj2.value == "__sched_group__" && obj2.index !== 0) return -1;
        else return 1;
    }

    var object_helper_map = {
        // Source address.
        "src": {
            mlist_helper: {
                add_object: cn_add_mlist_addr,
                open_helper: cn_open_helper_addr
            },
            create_helpers: {
                "__create_addr": {
                    find_index: addressgroupSeparatorCmp,
                    add_object: cn_add_src_addr,
                    open_helper: cn_open_helper_addr
                }
            }
        },

        // Destination Address
        "dst": {
            mlist_helper: {
                add_object: cn_add_mlist_addr,
                open_helper: cn_open_helper_addr
            },
            create_helpers: {
                "__create_addr": {
                    find_index: addressgroupSeparatorCmp,
                    add_object: cn_add_dst_addr,
                    open_helper: cn_open_helper_addr
                }
            }
        },

        "src6": {
            mlist_helper: {
                add_object: cn_add_mlist_addr,
                open_helper: cn_open_helper_addr6
            }
        },

        // Destination Address
        "dst6": {
            mlist_helper: {
                add_object: cn_add_mlist_addr,
                open_helper: cn_open_helper_addr6
            }
        },

        "dst46": {
            mlist_helper: {
                add_object: cn_add_mlist_addr,
                open_helper: cn_open_helper_addr46
            }
        },

        // Firewall schedule.
        "sch": {
            mlist_helper: {
                add_object: cn_add_recur_schedule,
                open_helper: function(mkey) {
                    var _mkey = (mkey) ? mkey + '/' : '';
                    fweb.dialog(fweb.iframe("/p/firewall/object/schedule/edit/" + _mkey +
                                            "?redir=/success"));
                }
            },
            create_helpers: {
                "__create_sched_recurring": {
                    find_index: schedOneTimeSeparatorCmp,
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/firewall/object/schedule/edit/?type=recurring&redir=/success"));
                    }
                },
                "__create_sched_onetime": {
                    find_index: schedGroupSeparatorCmp,
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/firewall/object/schedule/edit/?type=onetime&redir=/success"));
                    }
                }
            }
        },

        // Firewall Service.
        "svc": {
            mlist_helper: {
                add_object: cn_add_mlist_service,
                open_helper: function(mkey) {
                    var _mkey = (mkey) ? mkey + '/' : '';
                    fweb.dialog(fweb.iframe("/p/firewall/object/service/edit/"+_mkey+"?redir=/success"));
                }
            },
            create_helpers: {
                "__create_service_custom": {
                    find_index: secondSeparatorCmp,
                    add_object: cn_add_custom_service,
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/firewall/object/service/edit/?redir=/success"));
                    }
                }
            }
        },

        // Dynamic IP Pool.
        "poolname": {
            mlist_helper: {
                add_object: cn_add_mlist_value,
                open_helper: function(mkey) {
                    fweb.dialog(fweb.iframe("/p/firewall/object/ippool/edit/"+mkey+"?redir=/success"));
                }
            }
        },

        // Dynamic IP Pool.
        "poolname6": {
            mlist_helper: {
                add_object: cn_add_mlist_value,
                open_helper: function(mkey) {
                    fweb.dialog(fweb.iframe("/p/firewall/object/ippool/edit/"+mkey+"?type=ippool6&redir=/success"));
                }
            }
        },

        // Webproxy forwarding server
        "webproxy-forward-server": {
            mlist_helper: {
                add_object: cn_add_mlist_value,
                open_helper: function(mkey) {
                    fweb.dialog(fweb.iframe("/wanopt/config/forwardsvrdlg?redir=/success&mkey="+mkey));
                }
            }
        },

        // Web-proxy service
        "wp_svc": {
            mlist_helper: {
                add_object: cn_add_mlist_service,
                open_helper: function(mkey) {
                    var _mkey = (mkey) ? mkey + '/' : '';
                    fweb.dialog(fweb.iframe("/p/firewall/object/service/edit/"+_mkey+"?type=explicit&redir=/success"));
                }
            },
            create_helpers: {
                "__create_service_custom": {
                    find_index: secondSeparatorCmp,
                    add_object: cn_add_custom_service,
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/firewall/object/service/edit/?type=explicit&redir=/success"));
                    }
                }
            }
        },

        // Traffic Shaper.
        "shaper": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    var _mkey = (mkey) ? mkey + '/' : '';
                    var url = "/p/firewall/object/shaper/edit/";
                    fweb.dialog(fweb.iframe(url + _mkey + "?type=traffic-shaper&redir=/success" + act));
                }
            },
            create_helpers: {
                "__create_shaping_shaping": {
                    add_object: cn_add_traffic_shaper,
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/firewall/object/shaper/edit/?type=traffic-shaper&redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/firewall/object/shaper/edit/" + field.value + "?type=traffic-shaper&redir=/success"));
            }
        },

        // Reverse Traffic Shaper.
        "reverse_shaper": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    var _mkey = (mkey) ? mkey + '/' : '';
                    var url = "/p/firewall/object/shaper/edit/";
                    fweb.dialog(fweb.iframe(url + _mkey + "?type=traffic-shaper&redir=/success" + act));
                }
            },
            create_helpers: {
                "__create_shaping_shaping": {
                    add_object: cn_add_traffic_shaper_rev,
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/firewall/object/shaper/edit/?type=traffic-shaper&redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/firewall/object/shaper/edit/" + field.value + "?type=traffic-shaper&redir=/success"));
            }
        },

        // Per-IP Traffic Shaper.
        "per_ip_shaper": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    var _mkey = (mkey) ? mkey + '/' : '';
                    var url = "/p/firewall/object/shaper/edit/";
                    fweb.dialog(fweb.iframe(url + _mkey + "?type=per-ip-shaper&redir=/success" + act));
                }
            },
            create_helpers: {
                "__create_shaping_perIP": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/firewall/object/shaper/edit/?type=per-ip-shaper&redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/firewall/object/shaper/edit/" + field.value + "?type=per-ip-shaper&redir=/success"));
            }
        },

        // Endpoint Control Profile.
        "endpoint-profile": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    fweb.dialog(fweb.iframe("/p/utm/endpoint/profile/edit/" + (mkey.value || mkey) + "/?redir=/success&"));
                }
            },
            create_helpers: {
                "__create_endpoint_control_profile": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/utm/endpoint/profile/edit/?redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/utm/endpoint/profile/edit/" + field.value + "/?redir=/success"));
            }
        },

        // Profile Group.
        "utm_group": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    fweb.dialog(fweb.iframe("/utm/profile_grp/dlg?redir=/success&mkey=" + (mkey.value || mkey)));
                }
            },
            create_helpers: {
                "__create_utm_group": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/utm/profile_grp/dlg?redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/utm/profile_grp/dlg?redir=/success&mkey=" + field.value));
            }
        },

        // Protocol Options Profile
        "utm_proto": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe("/p/firewall/proxy_options/edit/" + (mkey.value || mkey) + "?redir=/success" + act));
                }
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/firewall/proxy_options/edit/" + field.value + "?redir=/success&paction="+PROFILE_VIEW));
            },

            new_helper: function() {
                fweb.dialog(fweb.iframe("/p/firewall/proxy_options/?redir=/success&paction="+PROFILE_NEW));
            }
        },

        "utm_deep": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe(("/p/firewall/deep_inspection/edit/" + (mkey.value || mkey) + "?redir=/success" + act)));
                }
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe(("/p/firewall/deep_inspection/edit/" + field.value + "?redir=/success&paction="+PROFILE_VIEW)));
            },

            new_helper: function() {
                fweb.dialog(fweb.iframe(("/p/firewall/deep_inspection/?redir=/success&paction="+PROFILE_NEW)));
            }
        },

        // Wanopt Profile.
        "wanopt_profile": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe("/p/wanopt/profile/edit/" + (mkey.value || mkey) + "?redir=/success" + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/p/wanopt/profile/?redir=/success&paction=" + PROFILE_NEW));
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/wanopt/profile/edit/" + field.value + "?redir=/success&paction=" + PROFILE_VIEW));
            }
        },

        // AntiVirus Profile.
        "utm_av": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe("/p/utm/antivirus/profile/edit/" + (mkey.value || mkey) + "?redir=/success" + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/p/utm/antivirus/profile?redir=/success&paction=" + PROFILE_NEW));
            },

            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/utm/antivirus/profile/edit/" + field.value + "?redir=/success&paction=" + PROFILE_VIEW));
            }
        },

        // Voip Profile.
        "utm_voip": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    var _mkey = (mkey) ? mkey + '/' : '';
                    fweb.dialog(fweb.iframe("/p/utm/voip/profile/edit/" + _mkey + "?redir=/success" + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/p/utm/voip/profile/?redir=/success&paction=" + PROFILE_NEW));
            },

            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/utm/voip/profile/edit/" + field.value + "?redir=/success&paction=" + PROFILE_VIEW));
            }
        },

        // ICAP Profile.
        "utm_icap": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe("/icap/profile/dlg?redir=/success&mkey=" + (mkey.value || mkey) + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/icap/profile/dlg?redir=/success&paction=" + PROFILE_NEW));
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/icap/profile/dlg?redir=/success&paction="+PROFILE_VIEW+"&mkey=" + field.value));
            }
        },

        // ICAP server
        "icap_req_svr": {
            create_helpers: {
                "__create_icap_svr": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/icap/server/dlg?redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/icap/server/dlg?redir=/success&mkey=" + field.value));
            }
        },

        // ICAP server
        "icap_resp_svr": {
            create_helpers: {
                "__create_icap_svr": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/icap/server/dlg?redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/icap/server/dlg?redir=/success&mkey=" + field.value));
            }
        },

        // IPS Sensor.
        utm_ips: {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var is_new = typeof(edit) === 'string',
                        act = '&paction=' + (!is_new ? edit : PROFILE_NEW),
                        url = '/p/utm/ips/sensor/edit/' +
                            (is_new ? '' : (mkey.value || mkey) + '/') +
                            '?mode=modal&redir=/success' + act;
                    if (is_new) {
                        fweb.dialog(fweb.iframe(url));
                    } else {
                        var opener_dim = fweb.util.opener_dimension(0.85),
                            pref = {
                                height: opener_dim.height,
                                width: Math.max(650, opener_dim.width)
                            };
                        fweb.dialog(fweb.iframe(url, pref));
                    }
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe('/p/utm/ips/sensor/edit/?paction=' + PROFILE_NEW + '&mode=modal&redir=/success'));//paction=3 means there is no select field, add and delete icons display
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe('/p/utm/ips/sensor/edit/default/' + field.value + '/?mode=modal&redir=/success&paction=' + ROFILE_VIEW));
            }
        },

        // Web Filter Profile.
        "utm_wf": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var is_new = typeof(edit) == "string";
                    var act = "&paction=" + (!is_new ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe("/p/utm/wf/profile/edit/" + (is_new ? '' : (mkey.value || mkey) + '/' ) +
                                            "?redir=/success" + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/p/utm/wf/profile/?redir=/success&paction="+PROFILE_NEW));
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/utm/wf/profile/edit/" + field.value + "/?redir=/success&paction="+PROFILE_VIEW));
            }
        },

        // AntiSpam Profile
        "utm_as": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    var _mkey = (mkey) ? mkey + '/' : '';
                    fweb.dialog(fweb.iframe("/p/utm/email/profile/edit/" + _mkey + "?redir=/success" + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/p/utm/email/profile/?redir=/success&paction=" + PROFILE_NEW));
            },

            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/utm/email/profile/edit/" + field.value + "?redir=/success&paction=" + PROFILE_VIEW));
            }
        },

        // DLP Sensor.
        "utm_dlp": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe("/p/utm/dlp/sensor/edit/" + (mkey.value || mkey) + "?redir=/success" + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/p/utm/dlp/sensor/edit?no_icons&redir=/success&paction="+PROFILE_NEW));
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/p/utm/dlp/sensor/edit/" + field.value + "?redir=/success&paction="+PROFILE_VIEW));
            }
        },

        // Application Control Profile
        utm_app: {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var is_new = typeof(edit) === 'string';
                    var act = '&paction=' + (!is_new ? edit : PROFILE_NEW);
                    var url = '/p/utm/appctrl/sensor/edit/' + (is_new ? '' : (mkey.value || mkey) + '/' );
                    url += '?mode=modal&redir=/success' + act;

                    var dlg_id = 'fweb_dialog_utm_app',
                        dlg_pref = {id: dlg_id};

                    fweb.util.multilist_update_dialog_factory(url, {}, dlg_pref);
                }
            },
            new_helper: function() {
                var url = '/p/utm/appctrl/sensor/edit/?mode=modal&redir=/success&paction=' + PROFILE_NEW;
                var dlg_id = 'fweb_dialog_utm_app',
                    dlg_pref = {id: dlg_id};
                fweb.util.multilist_update_dialog_factory(url, {}, dlg_pref);
            },
            view_helper: function(field) {
                var url = '/p/utm/appctrl/sensor/edit/' + field.value +
                          '/?mode=modal&redir=/success&paction=' + PROFILE_VIEW;
                var dlg_id = 'fweb_dialog_utm_app',
                    dlg_pref = {id: dlg_id};
                fweb.util.multilist_update_dialog_factory(url, {}, dlg_pref);
            }
        },

        // MMS Profile.
        "utm_mms": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe("/firewall/mmsprofile/dlg?redir=/success&mkey=" + (mkey.value || mkey) + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/mmsprofile/dlg?new&redir=/success&paction=" + PROFILE_NEW));
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/firewall/mmsprofile/dlg?redir=/success&paction=" + PROFILE_VIEW + "&mkey=" + field.value));
            }
        },

        // Replacement Message Group.
        "utm_rmsg_group": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = "&paction=" + (typeof(edit) != "string" ? edit : PROFILE_NEW);
                    fweb.dialog(fweb.iframe("/virus/message/groupdlg?redir=/success&mkey=" + (mkey.value || mkey) + act));
                }
            },
            new_helper: function() {
                fweb.dialog(fweb.iframe("/virus/message/groupdlg?redir=/success&paction=" + PROFILE_NEW));
            },
            view_helper: function(field) {
                fweb.dialog(fweb.iframe("/virus/message/table?redir=/success&paction=" + PROFILE_VIEW + "&mkey=" + field.value));
            }
        },

        // Admin Access Profile.
        "acc_profile": {
            create_helpers: {
                "__create_acc_profile": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/system/accprofile/edit/?redir=/success"));
                    }
                }
            }
        },

        // LDAP Server.
        "sl_ldap": {
            create_helpers: {
                "__create": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/user/ldap/edit/?redir=/success"));
                    }
                }
            }
        },

        // RADIUS Server.
        "sl_radius": {
            create_helpers: {
                "__create": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/user/radius/edit/?redir=/success"));
                    }
                }
            }
        },

        // RADIUS Server.
        "wl_radius": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function (mkey) {
                    fweb.dialog(fweb.iframe("/p/user/radius/edit/" + (mkey.value || mkey) + "?redir=/success"));
                }
            },
            new_helper: function () {
                fweb.dialog(fweb.iframe("/p/user/radius/edit/?redir=/success"));
            },
            view_helper: function (field) {
                fweb.dialog(fweb.iframe("/p/user/radius/edit/" + (field.value) + "?redir=/success"));
            }
        },

        // TACPLUS Server
        "sl_tacplus": {
            create_helpers: {
                "__create": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/user/tacplus/edit/?redir=/success"));
                    }
                }
            }
        },

        // WANOPT Peer.
        "wanopt_peer": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    fweb.dialog(fweb.iframe("/p/wanopt/peer/edit/" + mkey + "?redir=/success"));
                }
            }
        },

        // WANOPT Authgrp.
        "wanopt_auth_grp": {
            create_helpers: {
                "__create": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/wanopt/authgrp/edit/?redir=/success"));
                    }
                }
            }
        },

        // Web proxy forwarding server.
        "webproxy_server": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    fweb.dialog(fweb.iframe("/wanopt/config/forwardsvrdlg?redir=/success&mkey=" + (mkey.value || mkey)));
                }
            },
            create_helpers: {
                "__create": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/wanopt/config/forwardsvrdlg?redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/wanopt/config/forwardsvrdlg?redir=/success&mkey=" + field.value));
            }
        },

        // DOS Sensor.
        "dos_name": {
            mlist_helper: {
                add_object: cn_add_mlist_select,
                open_helper: function(mkey) {
                    var act = typeof(edit) != "string" ? edit : PROFILE_NEW;
                    fweb.dialog(
                        fweb.iframe(
                            act == PROFILE_NEW ?
                            "/dos/sensor/list?new=1&redir=/success&mkey=" + (mkey.value || mkey):
                            "/dos/sensor/dlg?redir=/success&mkey=" + (mkey.value || mkey)
                        )
                    );
                }
            },
            create_helpers: {
                "__create": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/dos/sensor/list?new=1&redir=/success"));
                    }
                }
            },
            edit_helper: function(field) {
                fweb.dialog(fweb.iframe("/dos/sensor/dlg?redir=/success&mkey=" + field.value));
            }
        },

        // User Group
        "authusrgrp": {
            mlist_helper: {
                add_object: cn_add_mlist_value,
                open_helper: function(mkey) {
                    var _mkey = (mkey) ? mkey + '/' : '';
                    fweb.dialog(fweb.iframe("/p/user/group/edit/" + _mkey + "?redir=/success"));
                }
            },
            create_helpers: {
                "__create_authusrgrp": {
                    open_helper: function() {
                        fweb.dialog(fweb.iframe("/p/user/group/edit/?redir=/success"));
                    }
                }
            }
        },

        firewall_grp: {
            mlist_helper: {
                add_object: cn_add_mlist_value,
                open_helper: function(mkey) {
                    var _mkey = (mkey) ? mkey + '/' : '',
                        url = '/p/user/group/edit/' + _mkey + '?type=firewall&redir=/success';
                    fweb.dialog(fweb.iframe(url));
                }
            }
        },

        // User
        authusr: {
            mlist_helper: {
                add_object: cn_add_mlist_users_groups,
                open_helper: function(mkey) {
                    // An attempt to avoid dialog leaking.
                    var dlg_id = 'fweb_dialog_authusr',
                        dlg_pref = {id: dlg_id};
                    var _url = (mkey) ? '/user/local/dlg?mkey=' + mkey + '&redir=/success':
                                        '/p/user/usr_grp_wizard/?redir=/success&mode=modal';
                    fweb.util.multilist_update_dialog_factory(_url, {}, dlg_pref);
                }
            }
        },

        // Guest Group
        "guest_grp": {
            mlist_helper: {
                add_object: cn_add_mlist_value,
                open_helper: function(mkey) {
                    var _mkey = (mkey) ? mkey + '/' : '';
                    fweb.dialog(fweb.iframe("/p/user/group/edit/" + _mkey + "?redir=/success&guest_grp=true"));
                }
            }
        }
    };

    // Locate helper object in map.
    var obj = object_helper_map[field.id] || object_helper_map[field.name];

    if (typeof obj == "object")
    {
        cn_select_object = field;

        var helper = obj.mlist_helper;

        if (helper && !$j(field).is(":visible"))
        {
            // multiList control
            var mkey = typeof(edit) == "string" ? edit : field.value;
            cn_new_object = new createObj(mkey);
            cn_new_object_helper = helper.add_object || cn_add_mlist_select;
            helper.open_helper.call(field, mkey);
            return;
        }

        if (edit >= PROFILE_VIEW)
        {
            if (edit == PROFILE_VIEW) //view
            {
               helper = obj.view_helper(field);
            }
            else if (edit == PROFILE_NEW)//new
            {
                helper = obj.new_helper();
                cn_new_object = new createObj();
                cn_new_object_helper = cn_default_add_object;
                cn_find_selected_index = null;
            }
            return;
        }

        helper = obj.create_helpers && obj.create_helpers[field.value];

        if (typeof helper == "object" && helper.open_helper)
        {
            field.selectedIndex = 0;
            cn_new_object = new createObj();
            cn_new_object_helper = cn_default_add_object;
            cn_find_selected_index = null;

            if (helper.add_object)
            {
                cn_new_object_helper = helper.add_object;
            }

            if (helper.find_index)
            {
                cn_find_selected_index = helper.find_index;
            }

            helper.open_helper();
            return;
        }

        if (edit && obj.edit_helper)
        {
            helper = obj.edit_helper(field);
            cn_new_object = new createObj();
            cn_new_object_helper = cn_default_edit_object;

            return;
        }
    }
}

// cn_multiple_select_click - Handle click events for the "multiple" button placed
// beside some select boxes. This function contains a map of field names -> helper
// functions, which will open the "multi select" dialog.
function cn_multiple_select_click(field_name)
{
    var multiple_helper_map = {
        // Source address.
        "m_src": {
            open_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/policy/multi_addr?t=1"));
            }
        },

        "m_src_dos": {
            open_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/policy/multi_addr?t=1&dos=1"));
            }
        },

        // Destination Address
        "m_dst": {
            open_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/policy/multi_addr?t=2"));
            }
        },

        "m_dst_dos": {
            open_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/policy/multi_addr?t=2&dos=1"));
            }
        },

        // Firewall Service.
        "m_svr": {
            open_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/policy/multi_addr?t=3"));
            }
        },

        "m_svr_dos": {
            open_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/policy/multi_addr?t=3&dos=1"));
            }
        },

        // IP Pool
        "m_ippool": {
            open_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/policy/multi_addr?t=4"));
            }
        },

        // IP Pool
        "m_wp_svr": {
            open_helper: function() {
                fweb.dialog(fweb.iframe("/firewall/policy/multi_addr?t=5"));
            }
        }

    };

    // Locate helper object in map.
    var obj = multiple_helper_map[field_name];

    if (typeof obj == "object" && obj.open_helper)
    {
        obj.open_helper();
    }
}


function cn_default_edit_object()
{
    removeOptions(cn_select_object);
    cn_default_add_object();
}

// cn_add_new_object - Process callback after adding new entry, and force an onchange()
// event on the "select" that was originally modified.
function cn_add_new_object()
{
    if (cn_new_object_helper)
    {
        cn_new_object_helper();
        cn_new_object_helper = null;
    }

    if (cn_select_object)
    {
        // This updates the "inline-edit" capabilities if applicable.
        $j(cn_select_object).change();
    }
}

function cn_default_add_object()
{
    insertOption(cn_select_object, new Option(cn_new_object.name, cn_new_object.name), cn_find_selected_index, true);
}

function cn_update_parent_object(obj)
{
    var wnd = window.opener || fweb.opener();
    if (wnd && wnd.cn_new_object)
    {
        if (typeof(obj) == "string")
        {
            wnd.cn_new_object.name = obj;
        }
        else
        {
            wnd.cn_new_object = $j.extend({}, obj);
        }
    }
}

function cn_add_src_addr()
{
    var fzone = $j('#fzone').val();
    var tzone = $j('#tzone').val();

    insertOption(document.forms[0].src, new Option(cn_new_object.name, cn_new_object.name), cn_find_selected_index, true);
    src_addr.push(cn_new_object.name);
    src_addr.sort();

    // ipv6: an address is not bound to any specific interface. So always add it to destination address, and vice versa
    if (cn_new_object.any_intf || (fzone.value == tzone.value) || (fwpolicy_opts && fwpolicy_opts.ipv6)) {
        insertOption(document.forms[0].dst, new Option(cn_new_object.name, cn_new_object.name), cn_find_selected_index, false);
        dst_addr.push(cn_new_object.name);
        dst_addr.sort();
    }
}

function cn_add_dst_addr()
{
    var fzone = $j('#fzone').val();
    var tzone = $j('#tzone').val();

    insertOption(document.forms[0].dst, new Option(cn_new_object.name, cn_new_object.name), cn_find_selected_index, true);
    dst_addr.push(cn_new_object.name);
    dst_addr.sort();

    // ipv6: an address is not bound to any specific interface. So always add it to source address, and vice versa
    if (cn_new_object.any_intf || (fzone.value == tzone.value) || (fwpolicy_opts && fwpolicy_opts.ipv6)) {
        insertOption(document.forms[0].src, new Option(cn_new_object.name, cn_new_object.name), cn_find_selected_index, false);
        src_addr.push(cn_new_object.name);
        src_addr.sort();
    }
}

function cn_add_mlist_addr()
{
    var vals = $j("[name=" + cn_select_object.name + ']').val().split("#");
    vals.push(cn_new_object.name);
    cn_select_object.value = vals.join('#');
    refresh_addr();
}

// TODO: Remove pathological coupling with policy pages
function cn_add_recur_schedule() {
    var val = cn_new_object.name;
    if (val) {
        cn_select_object.value = val;
        var obj = get_fw_obj('sch');
        obj.list.push(val);
        obj.mapping[val] = {cls: cn_new_object.cls, text: val};
        load_simple_list($j(cn_select_object), obj.list, obj.mapping,
            { create: { enable: !FirewallPolicy.in_modal } });
    }
}

function cn_add_mlist_nat()
{
    var is_src = cn_select_object.name == 'src_nat';
    var vals = cn_select_object.value.split('#');
    vals.push(cn_new_object.name);
    cn_select_object.value = vals.join('#');

    refresh_addr(is_src ? "src" : "dst");
}

function cn_add_mlist_service() {
    var sel_obj = cn_select_object;
    var vals = sel_obj.value ? sel_obj.value.split(SEPARATOR) : [];
    var val = cn_new_object.name;
    vals.push(val);
    sel_obj.value = vals.join(SEPARATOR);
    if ($j.isFunction(sel_obj.config.afterInsert)) {
        sel_obj.config.afterInsert.call(sel_obj, val);
    }
    var obj = get_fw_obj('svc');
    if (!cn_new_object.cls) {
        // if object tagging/coloring isn't enable, cls is not set. Set it now
        cn_new_object.cls = 'icon_fw srv_custom_0';
    }
    if (!cn_new_object.cat) {
        // if no category is chosen, init it here
        cn_new_object.cat = 'Uncategorized';
    }

    // find the right place to insert this new service, note that categories
    // are not in order, while services in each category are in alphabet order
    var index = (function(list, mapping, item) {
        var i = 0;
        while (i < list.length
               && mapping[list[i]].cat !== item.cat) {
            i++;
        }
        while (i < list.length
               && mapping[list[i]].cat == item.cat
               && list[i] < item.name) {
            i++;
        }
        return i;
    })(obj.list, obj.mapping, cn_new_object);

    if (index < obj.list.length) {
        obj.list.splice(index, 0, val);
    } else {
        obj.list.splice(0, 0, val);
    }

    // update mapping
    obj.mapping[val] = {cls: cn_new_object.cls, text: val,
                        cat: cn_new_object.cat};

    $j(sel_obj).multiList({ "source": obj.list });
}

function cn_add_mlist_users_groups() {
    'use strict';
    var sel_obj = cn_select_object,
        mlist_config = sel_obj.config || {},
        cfg_sep = mlist_config.separator || SEPARATOR;

    var new_obj = cn_new_object;
    var use_existing = new_obj.use_existing,
        extra_vals = new_obj.mkeys || [],
        wizard_type = new_obj.type,
        cls_type = new_obj.cls_type,
        cls = new_obj.cls,
        cat = cls_type === 'authusrgrp' ? 'field_groups' : 'user_' + wizard_type,
        prefix = cls_type === 'authusrgrp' ? 'authusrgrp<>' : 'authusr<>';

    if (extra_vals && extra_vals.length > 0) {
        var jsel_obj = $j(sel_obj);
        var cur_vals = sel_obj.value ? sel_obj.value.split(cfg_sep) : [];
        var new_extra_vals = [],
            len = extra_vals.length,
            i;
        for (i = 0; i < len; i++) {
            var prefixed_val = prefix + extra_vals[i];
            if (cur_vals.indexOf(prefixed_val) === -1) {
                new_extra_vals.push(prefixed_val);
            }
        }
        var new_vals = cur_vals.concat(new_extra_vals);
        sel_obj.value = new_vals.join(cfg_sep);

        if (use_existing) {
            // we've done, the existing user/group is already there and we've
            // set them to the sel_obj, don't need to update list/mapping
            return;
        }

        var custom_obj_getter = jsel_obj.data('mlist_obj_getter');
        var obj_getter = $j.isFunction(custom_obj_getter) ? custom_obj_getter : $j.noop;
        var obj = obj_getter(sel_obj.id) || obj_getter(sel_obj.name);

        var cmp = function (a, b) {
            if (a > b) return 1;
            if (a < b) return -1;
            return 0;
        };

        if (obj) {
            var val,
                val_key,
                list = obj.list,
                mapping = obj.mapping;
            for (i = 0; i < len; i++) {
                val = extra_vals[i],
                val_key = prefix + val;
                list.push(val_key);
                mapping[val_key] = {
                    text: val,
                    cls_type: cls_type,
                    type: wizard_type,
                    cls: cls,
                    category: cat
                };
            }
            list.sort(function(a, b) {
                var amap = mapping[a], bmap = mapping[b];
                if (amap.cls_type !== bmap.cls_type) {
                    // 'group' vs 'user' type, group wins
                    return cmp(b, a);
                }

                // same 'group' type
                if (amap.cls_type === 'authusrgrp') {
                    return cmp(a, b);
                }

                // same 'user' type
                var atype = amap.type, btype = bmap.type;
                if (atype !== btype) {
                    // different user subtype
                    return cmp(atype, btype);
                }
                // same user subtype
                return cmp(a, b);
            });
            var prefix_regex = /^[a-z]+<>/;
            jsel_obj.multiList({
                source: list,
                display: function(v) {
                    var cls = "", cat;
                    var text = v ? v.replace(prefix_regex, '') : $j.getInfo('click_add');

                    if (v in mapping) {
                        var map = mapping[v];
                        cls = map.cls;
                        cat = map.category;
                        var map_text = escapeHTML(map.text);
                        text = map_text ? map_text : text;
                        if (cat && cat.length > 0 && cat[0] == '_') {
                            cat = false;
                        }
                    }
                    return {"label": '<span class="' + cls + '"/>' + text, "category": $j.getInfo(cat)};
                }
            });
        }
    }
}

function cn_add_mlist_value(category) {
    var sel_obj = cn_select_object;
    var vals = sel_obj.value ? sel_obj.value.split(SEPARATOR) : [];
    var val = cn_new_object.name;
    vals.push(val);
    var mlist_config = sel_obj.config || {};
    var is_single = mlist_config['max'] === 1 ||
                    mlist_config['selector_type'] === 'single';
    sel_obj.value = is_single ? val : vals.join(SEPARATOR);

    // Old code uses get_fw_obj to get the multilist list/mapping object, here
    // is the 1st attempt to remove that policy page pathological coupling.
    var custom_obj_getter = $j(sel_obj).data('mlist_obj_getter');
    var obj_getter = $j.isFunction(custom_obj_getter) ? custom_obj_getter :
                     ($j.isFunction(get_fw_obj) ? get_fw_obj : $j.noop);
    var obj = obj_getter(sel_obj.id) || obj_getter(sel_obj.name);

    if (obj) {
        obj.list.push(val);
        if (cn_new_object.cls) {
            obj.mapping[val] = {cls: cn_new_object.cls, text: val, cat: $j.getInfo(category)};
        }
        $j(sel_obj).multiList({ "source": obj.list });
    }
}

function cn_add_mlist_select()
{
    var val = cn_new_object.name;
    var select = $j(cn_select_object);
    select.append($j('<option value="' + val + '">' + val + '</option>'));

    // Don't mess with the existing width of the list.
    select.val(val).multiList({ width: select.get(0).config.width });
}

function cn_add_custom_service()
{
    insertOption(cn_select_object, new Option(cn_new_object.name, cn_new_object.name), cn_find_selected_index, true);
    svr.push(cn_new_object.name);
}

function cn_add_traffic_shaper()
{
    insertOption(document.forms[0].shaper, new Option(cn_new_object.name, cn_new_object.name), null, true);
    insertOption(document.forms[0].reverse_shaper, new Option(cn_new_object.name, cn_new_object.name), null, false);
}

function cn_add_traffic_shaper_rev()
{
    insertOption(document.forms[0].shaper, new Option(cn_new_object.name, cn_new_object.name), null, false);
    insertOption(document.forms[0].reverse_shaper, new Option(cn_new_object.name, cn_new_object.name), null, true);
}

//for the tips of icons on policy pages and UTM profiles
function get_tips(id)
{
    if (id == PROFILE_VIEW)
        return window.view_tips || $j.getInfo("view");

    else if (id == PROFILE_NEW)
        return window.new_tips || $j.getInfo("createnew");

    else if (id == PROFILE_DEL)
        return window.delete_tips || $j.getInfo("delete");

    else if (id == PROFILE_CLONE)
        return window.clone_tips || $j.getInfo("clone");

    // View list in each UTM profile page
    else if (id == UTM_PROFILE_VIEW_LIST)
        return window.vlist_tips || $j.getInfo("view_list");

    return "";
}

function cn_open_helper_address(addr_field, mkey, ipv6)
{
    var srcaddr_selector = ipv6 ? "srcaddr6" : "srcaddr";
    var zone = addr_field == srcaddr_selector ? $j("#fzone").val() : $j("#tzone").val();
    var uri = "/p/firewall/object/address/edit/";
    if (mkey) {
        uri += mkey + "/";
    }
    uri = setQueryValue(uri, "redir", "/success");
    if (zone) {
        uri = setQueryValue(uri, "intf", zone);
    }
    if (ipv6) {
        // ipv6 address
        uri = setQueryValue(uri, "addr_cat", "addr_ipv6");
    } else if (fwpolicy_opts && fwpolicy_opts.multicast == 1 && addr_field == "dstaddr" ) {
        // multicast address
        uri = setQueryValue(uri, "addr_cat", "multicast");
    } else {
        // ipv4 address
        uri = setQueryValue(uri, "addr_cat", "addr");
    }
    fweb.dialog(fweb.iframe(uri));
}

function cn_open_helper_addr(mkey)
{
    cn_open_helper_address(this.name, mkey, false);
}

function cn_open_helper_addr6(mkey)
{
    cn_open_helper_address(this.name, mkey, true);
}

function cn_open_helper_addr46(mkey)
{
    var uri = "/p/firewall/object/virtualip/edit/";
    if (mkey) {
        uri += mkey + "/";
    }
    uri = setQueryValue(uri, "redir", "/success");
    uri = setQueryValue(uri, "type", "vip46");
    fweb.dialog(fweb.iframe(uri, {width: 690, height: 300}));
}

/*            'js/popup.js',*/
//popup.js
//new_win() is created to control only one pop-up opened for FortiOS webUI.
function new_win(url, id, width, height) {
      close_popup();
      set_popup_RefID(window.open(url, id, 'scrollbars,resizable,width='+width+',height='+height)); 
        return;
}

function set_popup_RefID(id) {
      if (id) {
            new NewPopup();
            NewPopup.ref_id = id;
            NewPopup.ref_id.focus();
      }
        return;
}

function close_popup() {
      if (NewPopup.ref_id && !NewPopup.ref_id.closed) {
            NewPopup.ref_id.close();
            NewPopup.ref_id = 0;
      }
        return;
}

function NewPopup() {}

/*            'js/jsonrpc.js',*/
var JSONRPC = (function ($) {
      var id = 0;
      var url = "/json";

      function jsonrpc_on_success(response, textStatus) {
            alert('jsonrpc success: \n\n' + JSON.stringify(response));
      }

      function jsonrpc_on_error(response, textStatus) {
            alert('jsonrpc error: \n\n' + JSON.stringify(response));
      }

      function jsonrpc_send(request, args) {
            if (!request) {
                  return;
            }

            if (typeof request.id === "undefined") {
                  request.id = id++;
            }

            if (!args) {
                  args = {};
            }

            if (!args.on_error) {
                  args.on_error = jsonrpc_on_error;
            }

            if (!args.on_success) {
                  args.on_success = jsonrpc_on_success;
            }

            $.ajax({
                  "url": url,
                  "cache": false,
                  "dataType": "json",
                  "type": "POST",
                  "data": {
                        "json": JSON.stringify(request)
                  },
                  "async": typeof(args.async) == "boolean" ? args.async : true,
                  "success": function __jsonrpc_on_success(response, textStatus) {
                        if (!response) {
                              return;
                        }
                        if (response.error) {
                              args.on_error(response.error, textStatus);
                        }
                        else if (response.result) {
                              args.on_success(response.result, textStatus);
                        }
                        else if (response instanceof Array) {
                              args.on_success(response, textStatus);
                        }
                        else {
                              // error
                        }
                  },

                  "error": function (XMLHttpRequest, textStatus, errorThrown) {
                        var response = {
                              "id": null,
                              "error": {
                                    "code": -32000,
                                    "message": "Connection error",
                                    "data": {
                                          "XMLHttpRequest": XMLHttpRequest,
                                          "textStatus": textStatus,
                                          "errorThrown": errorThrown
                                    }
                              }
                        };

                        args.on_error(response.error, textStatus);
                  }
            });
      }

      return {
            "send": jsonrpc_send
      };

})(jQuery);

// other methods
JSONRPC.Batch = (function ($) {
      var Request = {
            "method": "batch",
            "params": {
                  "batch": []
            }
      };

      function jsonrpc_batch_send(params, args) {
            if (!params) {
                  return;
            }

            if (!args) {
                  args = {};
            }

            var request = $.extend(true, {}, JSONRPC.Batch.Request);
            request.params = $.extend(true, {}, params);

            JSONRPC.send(request, args);
      }

      return {
            "Request": Request,

            "send": jsonrpc_batch_send
      };

})(jQuery);

/*           'js/jsonrpc_cmdb.js',*/
/*global jQuery:false, alert:false, JSONRPC:true, Hash:true */
JSONRPC.CMDB = (function ($) {
      "use strict";
      var Request = {
            "method": "cmdb",
            "params": {}
      };

      // defaults
      var Method = {

            "Select": {
                  "method": "select",
                  "filters": [{
                        "key": "name", // default masterkey (on omission)
                        "type": "string" // default string
                  }],

                  // recursive structure
                  "params": {
                        "method": "get" // move, edit, delete, get - default = get (list)
                  }
            },

            "Get": {
                  "method": "get"  // no mkey -> get default values
            },

            "Append": {
                  "method": "append",
                  "overwrite": true
            },

            "Insert": {
                  "method": "insert",
                  "type": "index",
                  "location": 0
            },

            "Move": {
                  "method": "move",
                  "type": "index",
                  "from": 1,
                  "to": 2
            },

            "Edit": {
                  "method": "edit"
            },

            "Delete": {
                  "method": "delete"
            },

            "Clear": {
                  "method": "clear"
            }
      };

      function jsonrpc_cmdb_select(params, args) {
            send("Select", params, args);
      }

      function jsonrpc_cmdb_get(params, args) {
            send("Get", params, args);
      }

      function jsonrpc_cmdb_append(params, args) {
            send("Append", params, args);
      }

      function jsonrpc_cmdb_insert(params, args) {
            send("Insert", params, args);
      }

      function jsonrpc_cmdb_move(params, args) {
            send("Move", params, args);
      }

      function jsonrpc_cmdb_edit(params, args) {
            send("Edit", params, args);
      }

      function jsonrpc_cmdb_delete(params, args) {
            send("Delete", params, args);
      }

      function jsonrpc_cmdb_clear(params, args) {
            send("Clear", params, args);
      }

      function send(method, params, args) {
            var default_args = {
                  "on_error" : jsonrpc_cmdb_on_error,
                  "on_success" : jsonrpc_cmdb_on_success
            };

            if (!params) {
                  return;
            }

            args = $.extend({}, default_args, args);

            // use batch if array
            if ($.isArray(params)) {
                  var batch_params = { "batch": [] };

                  for (var i = 0; i < params.length; i++) {
                        batch_params.batch.push(JSONRPC.CMDB.create(method, params[i]));
                  }

                  JSONRPC.Batch.send(batch_params, args);
                  return;
            }

            // clone objects
            params = $.extend(true, {}, params);
            var request = $.extend(true, {}, Request);
            request.params = $.extend(true, {}, Method[method], params);

            JSONRPC.send(request, args);
      }

      function create(method, params, args) {
            var default_args = {};

            if (!params) {
                  return;
            }
            params = $.extend(true, {}, params);

            args = $.extend({}, default_args, args);

            var request = $.extend(true, {}, JSONRPC.CMDB.Request);
            request.params = $.extend(true, {}, JSONRPC.CMDB.Method[method], params);
            request.id = request.params.path + "." + request.params.name; // DEBUG

            return request;
      }

      function jsonrpc_cmdb_on_error(error) {
            alert('cmdb error: \n\n' + JSON.stringify(error));
      }

      function jsonrpc_cmdb_on_success(result) {
            alert('cmdb success: \n\n' + JSON.stringify(result));
      }

      return {
            "Request": Request,
            "Method": Method,

            "send": send,
            "create": create,

            "select": jsonrpc_cmdb_select,
            "get": jsonrpc_cmdb_get,
            "append": jsonrpc_cmdb_append,
            "insert": jsonrpc_cmdb_insert,
            "move": jsonrpc_cmdb_move,
            "edit": jsonrpc_cmdb_edit,
            "delete": jsonrpc_cmdb_delete,
            "clear": jsonrpc_cmdb_clear
      };

})(jQuery);

var CMDB = (function ($) {
      "use strict";
      var error_handler = {
                  error_callback: $.noop,
                  duplicate_callbacks: false
            },
            // for safety, default to false
            // TODO: remove this option when old code is fixed
            enable_promise_failure = false;

      // setup_error_handler - Setup a handler for errors
      //
      // error_callback - Function to handle errors (receives three arguments:
      //                  The jqXHR (in jQuery 1.4.x, XMLHttpRequest) object,
      //                  a string describing the type of error that occurred
      //                  and an optional exception object, if one occurred.)
      // duplicate_callbacks - Use the same callback for errors and success
      function setup_error_handler(error_callback, duplicate_callbacks) {
            if ($.isFunction(error_callback)) {
                  error_handler.error_callback = error_callback;
            }
            if (duplicate_callbacks) {
                  error_handler.duplicate_callbacks = true;
            }
      }

      // use with dfd.then(error_filter)
      // rejects cmdb responses that have error codes
      function error_filter(response, status) {
            var result = $.Deferred();
            if (enable_promise_failure && ('error' in response)) {
                  return result.rejectWith(this, arguments).promise();
            }
            return result.resolveWith(this, arguments).promise();
      }

      // Pass true to enable rejection of promises when the result is a cmdb error.
      // TODO: replace old code that uses 'success' and has no failure
      // TODO: Apparently some old code may rely on CMDB.* silently failing, fix that.
      function set_enable_promise_failure(value) {
            enable_promise_failure = value;
      }

      // api_cmdb_fetch - Fetch a CMDB table/object in JSON format.
      //
      // Parameters:
      //   cmdb_path => CMDB node path (ie: "log").
      //   cmdb_name => CMDB node name (ie: "device").
      //   preferences => Object containing additional preferences.
        //              filter results by {key: cmdb_attr, pattern: cmdb_value},
        //              cmdb_find_by_masterkey will be used if cmdb_attr is master key.
      //   callback => Function to handle JSON result (receives two arguments,
      //               'data' and 'textStatus').
      //   async => whether the request works in an asynchronous way.
      //
      // Don't rely on `CMDB.fetch('system', 'global')`. You will run into
      //   permissions errors.
      function api_cmdb_fetch(cmdb_path, cmdb_name, preferences, callback, async) {
            var parameters = {
                  "action": "select",
                  "path": cmdb_path,
                  "name": cmdb_name
            };

            $.extend(parameters, preferences);

            var jqxhr = $.ajax({
                  "url": "/api/cmdb",
                  "type": "GET",
                  "dataType": "json",
                  "data": {
                        "request": JSON.stringify(parameters)
                  },
                  // some time sync mode is need for building up data in callback which could be used right afterwards
                  "async": typeof(async) === "boolean" ? async : true
            });

            var dfd = new $.Deferred();
            dfd.done(callback);
            jqxhr.then(error_filter).then(function (data, textStatus, jqXHR) {
                if (!data || !data.results) {
                    if (error_handler.duplicate_callbacks) {
                        return dfd.resolve(null, textStatus);
                    }
                    dfd.reject(data, textStatus, jqXHR, parameters);
                    return error_handler.error_callback(jqXHR, textStatus, 'Not Found', parameters);
                }
                dfd.resolve(data, textStatus);
            });

            jqxhr.error(function(jqXHR, textStatus, errorThrown) {
                dfd.reject(errorThrown, textStatus, jqXHR, parameters);
                return error_handler.error_callback(jqXHR, textStatus, errorThrown, parameters);
            });

            return dfd.promise();
      }

      // api_cmdb_fetch_default - Fetch default vales for given CMDB table entry/object in JSON format.
      //
      // Parameters:
      //   cmdb_path => CMDB node path (ie: "log").
      //   cmdb_name => CMDB node name (ie: "device").
      //   callback => Function to handle JSON result (accepts two parameters,
      //               'data' and 'textStatus').
      //   async => whether the request works in an asynchronous way.
      function api_cmdb_fetch_default(cmdb_path, cmdb_name, callback, async) {
            return api_cmdb_fetch(cmdb_path, cmdb_name, {
                  "action": "fetch_default"
            }, callback, async);
      }

      // api_cmdb_fetch_list - Fetch an array of CMDB values by key. (Ie: to get a list
      // of objects by name). Useful for auto-completion.
      //
      // Parameters:
      //   cmdb_path => CMDB node path (ie: "log").
      //   cmdb_name => CMDB node name (ie: "device").
      //   cmdb_key => Key to return values for (ie: "name").
      //   callback => Function to process result (accepts a single array as a parameter).
      function api_cmdb_fetch_list(cmdb_path, cmdb_name, cmdb_key, callback) {
            var list_dfd = new $.Deferred();
            list_dfd.done(callback);
            if (typeof cmdb_key === 'undefined') {
                // the most common case
                cmdb_key = 'name';
            }
            // granular to cmdb_key attr
            var perfs = {format: {}};
            perfs.format[cmdb_key] = '';
            var dfd = api_cmdb_fetch(cmdb_path, cmdb_name, prefs);
            dfd.then(function(data) {
                var option_list = $.map(data.results, function(v) {
                    return v[cmdb_key];
                });
                list_dfd.resolve(option_list);
            }, list_dfd.reject);
            return list_dfd.promise();
      }

    // Supports updating multiple mkeys with one cmdb_object if mkey is an array
    // or multiple mkeys with multiple cmdb_objects if mkey and cmdb_object are arrays
      function __api_cmdb_edit_object(action, cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
            var parameters = {
                  "action": action,
                  "path": cmdb_path,
                  "name": cmdb_name,
                  "mkey": mkey ? mkey : "",
                  "json": cmdb_object
            };

            $.extend(parameters, preferences);
            var jqxhr = $.ajax({
                url: "/api/cmdb",
                type: "POST",
                dataType: "json",
                data: { "request": JSON.stringify(parameters) }
            });
            var dfd = new $.Deferred();
            dfd.done(callback);
            jqxhr.success(function (data) {
                if (data) {
                    dfd.resolve(data);
                }
            });
            jqxhr.error(function(jqXHR, textStatus, errorThrown) {
                dfd.reject(jqXHR, textStatus, errorThrown, parameters);
                return error_handler.error_callback(jqXHR, textStatus, errorThrown, parameters);
            });
            return dfd.then(error_filter).promise();
      }

      function api_cmdb_edit_object(cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
            return __api_cmdb_edit_object("edit", cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences);
      }

      function api_cmdb_append_object(cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
            return __api_cmdb_edit_object("append", cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences);
      }

        function api_cmdb_clone_object(cmdb_path, cmdb_name, mkey, callback, preferences) {
            return __api_cmdb_edit_object("clone", cmdb_path, cmdb_name, mkey, {}, callback, preferences);
        }

    function api_cmdb_move_object(cmdb_path, cmdb_name, mkey, callback, preferences) {
        var parameters = {
            "action": "move",
            "path": cmdb_path,
            "name": cmdb_name,
            "mkey": mkey
            //(before|after): mkey2
        };

        $.extend(parameters, preferences);

        return $.ajax({
            "url": "/api/cmdb",
            "type": "POST",
            "dataType": "json",
            "data": { "request": JSON.stringify(parameters) },
            success: function (data) {
                if (data && typeof(callback) == "function") {
                    callback(data);
                }
            },
            error: error_handler.error_callback
        }).then(error_filter);
    }

    function api_cmdb_move_child(cmdb_path, cmdb_name, mkey, child, child_key, callback, preferences) {
        var parameters = {
            "child": child,
            "child-key": child_key
            //(before|after): child_mkey2
        };
        $.extend(parameters, preferences);
        return api_cmdb_move_object(cmdb_path, cmdb_name, mkey, callback, parameters);
    }

    function api_cmdb_delete(cmdb_path, cmdb_name, mkey, callback, preferences) {
        var parameters = {
            "action": "delete",
            "path": cmdb_path,
            "name": cmdb_name,
            "mkey": mkey
        };

        $.extend(parameters, preferences);

        return $.ajax({
            "url": "/api/cmdb",
            "type": "POST",
            "dataType": "json",
            "data": { "request": JSON.stringify(parameters) },
            "success": function (data) {
                if (data && $.isFunction(callback)) {
                    callback(data);
                }
            },
            "error": error_handler.error_callback
        }).then(error_filter);
    }

    function api_cmdb_delete_child(cmdb_path, cmdb_name, mkey, child, child_key, callback, preferences) {
        var parameters = {
            "child": child,
            "child-key": child_key
        };
        $.extend(parameters, preferences);
        return api_cmdb_delete(cmdb_path, cmdb_name, mkey, callback, parameters);
    }

      function api_cmdb_schema(cmdb_path, cmdb_name, preferences, callback, async) {
            var parameters = {
                  "action": "schema",
                  "path": cmdb_path,
                  "name": cmdb_name
            };

            $.extend(parameters, preferences);

            return $.ajax({
                  "url": "/api/cmdb",
                  "dataType": "json",
                  "data": {
                        "request": JSON.stringify(parameters)
                  },
                  // some time sync mode is need for building up data in callback which could be used right afterwards
                  "async": typeof(async) == "boolean" ? async : true,
                  "success": function (data, textStatus, jqXHR) {
                        if (!data || !data.results) {
                              if (error_handler.duplicate_callbacks && $.isFunction(callback)) {
                                    return callback(null, textStatus);
                              }
                              return error_handler.error_callback(jqXHR, textStatus, 'Not Found');
                        }

                        if ($.isFunction(callback)) {
                              callback(data, textStatus);
                        }
                  },
                  'error': error_handler.error_callback
            }).then(error_filter);
    }

    return {
        "fetch": api_cmdb_fetch,
        "fetch_default": api_cmdb_fetch_default,
        "fetch_list": api_cmdb_fetch_list,
        "edit": api_cmdb_edit_object,
        "append": api_cmdb_append_object,
        "clone": api_cmdb_clone_object,
        "move": api_cmdb_move_object,
        "move_child": api_cmdb_move_child,
        "schema": api_cmdb_schema,
        "delete": api_cmdb_delete,
        "delete_child": api_cmdb_delete_child,
        "setup_error_handler": setup_error_handler,
        "enable_promise_failure": set_enable_promise_failure
    };

})(jQuery);

/*            'js/jquery.twistieBox.js',*/
/*
  jquery.twistieBox.js - jQuery collapsable area plugin code. 
  init June 2010 by J. Tary

  Copyright Fortinet Inc
*/

(function($) {
    $.fn.twistiebox = function (params) {
        var settings = {
            // html that will be used to create the expand twistie
            "expandHTML" : "<a href=\"#\" style=\"font-family:monospace\">[+]</a>", 
            // html that will be used to create the collapse twistie
            "collapseHTML" : "<a href=\"#\" style=\"font-family:monospace\">[-]</a>", 
            "headingClass" : "twistiebox-header",
            "bodyClass" : "twistiebox-body"
        };

        settings = $.extend(settings, params);

        $.each(this, function() {
            function setupTwistBox(obj) {
                var ctrlExpand = $(settings.expandHTML).click(handleExpand);
                var ctrlCollapse = $(settings.collapseHTML).click(handleCollapse);
                var twistieHead;
                var twistieBody;

                twistieBody = $("." + settings.bodyClass, obj);
                if ($(twistieBody).length < 1) {
                    twistieBody = $("<div class=\"" + settings.bodyClass + "\"></div>").html($(obj).html());
                    $(obj).html(twistieBody);
                }

                twistieHead = $("." + settings.headingClass, obj);

                if ($(twistieHead).length < 1) {
                    twistieHead = $("<div class=\"" + settings.headingClass + "\"></div>").prependTo($(obj));
                }

                $(ctrlExpand).prependTo(twistieHead);
                $(ctrlCollapse).prependTo(twistieHead);

                setCollapseState($(obj).hasClass("open"));

                function handleExpand() {
                    setCollapseState(true);
                    return false;
                }

                function handleCollapse() {
                    setCollapseState(false);
                    return false;
                }

                function setCollapseState(state) {
                    $(ctrlExpand).toggle(!state);
                    $(ctrlCollapse).toggle(state);
                    $(twistieBody).toggle(state);
                }
            }

            setupTwistBox(this);
        });

        return this;
    };
 })(jQuery);

/*            'js/jquery.layout.js',*/
/**
 * @preserve
 * jquery.layout 1.3.0 - Release Candidate 30.79
 * $Date: 2013-01-12 08:00:00 (Sat, 12 Jan 2013) $
 * $Rev: 303007 $
 *
 * Copyright (c) 2013 Kevin Dalman (http://allpro.net)
 * Based on work by Fabrizio Balliano (http://www.fabrizioballiano.net)
 *
 * Dual licensed under the GPL (http://www.gnu.org/licenses/gpl.html)
 * and MIT (http://www.opensource.org/licenses/mit-license.php) licenses.
 *
 * SEE: http://layout.jquery-dev.net/LICENSE.txt
 *
 * Changelog: http://layout.jquery-dev.net/changelog.cfm#1.3.0.rc30.79
 *
 * Docs: http://layout.jquery-dev.net/documentation.html
 * Tips: http://layout.jquery-dev.net/tips.html
 * Help: http://groups.google.com/group/jquery-ui-layout
 */

/* JavaDoc Info: http://code.google.com/closure/compiler/docs/js-for-compiler.html
 * {!Object}      non-nullable type (never NULL)
 * {?string}      nullable type (sometimes NULL) - default for {Object}
 * {number=}      optional parameter
 * {*}                  ALL types
 */
/*    TODO for jQ 2.0 
 *    change .andSelf() to .addBack()
 *    $.fn.disableSelection won't work
 */

// NOTE: For best readability, view with a fixed-width font and tabs equal to 4-chars

;(function ($) {

// alias Math methods - used a lot!
var   min         = Math.min
,     max         = Math.max
,     round = Math.floor

,     isStr =  function (v) { return $.type(v) === "string"; }

      /**
      * @param {!Object}                  Instance
      * @param {Array.<string>}     a_fn
      */
,     runPluginCallbacks = function (Instance, a_fn) {
            if ($.isArray(a_fn))
                  for (var i=0, c=a_fn.length; i<c; i++) {
                        var fn = a_fn[i];
                        try {
                              if (isStr(fn)) // 'name' of a function
                                    fn = eval(fn);
                              if ($.isFunction(fn))
                                    g(fn)( Instance );
                        } catch (ex) {}
                  }
            function g (f) { return f; }; // compiler hack
      }
;

/*
 *    GENERIC $.layout METHODS - used by all layouts
 */
$.layout = {

      version:    "1.3.rc30.79"
,     revision:   0.033007 // 1.3.0 final = 1.0300 - major(n+).minor(nn)+patch(nn+)

      // $.layout.browser REPLACES $.browser
,     browser:    {} // set below

      // *PREDEFINED* EFFECTS & DEFAULTS 
      // MUST list effect here - OR MUST set an fxSettings option (can be an empty hash: {})
,     effects: {

      //    Pane Open/Close Animations
            slide: {
                  all:  { duration:  "fast"     } // eg: duration: 1000, easing: "easeOutBounce"
            ,     north:      { direction: "up" }
            ,     south:      { direction: "down"     }
            ,     east: { direction: "right"}
            ,     west: { direction: "left"     }
            }
      ,     drop: {
                  all:  { duration:  "slow"     }
            ,     north:      { direction: "up" }
            ,     south:      { direction: "down"     }
            ,     east: { direction: "right"}
            ,     west: { direction: "left"     }
            }
      ,     scale: {
                  all:  { duration: "fast"      }
            }
      //    these are not recommended, but can be used
      ,     blind:            {}
      ,     clip:       {}
      ,     explode:    {}
      ,     fade:       {}
      ,     fold:       {}
      ,     puff:       {}

      //    Pane Resize Animations
      ,     size: {
                  all:  { easing:   "swing"     }
            }
      }

      // INTERNAL CONFIG DATA - DO NOT CHANGE THIS!
,     config: {
            optionRootKeys:   "effects,panes,north,south,west,east,center".split(",")
      ,     allPanes:         "north,south,west,east,center".split(",")
      ,     borderPanes:      "north,south,west,east".split(",")
      ,     oppositeEdge: {
                  north:      "south"
            ,     south:      "north"
            ,     east:       "west"
            ,     west:       "east"
            }
      //    offscreen data
      ,     offscreenCSS:     { left: "-99999px", right: "auto" } // used by hide/close if useOffscreenClose=true
      ,     offscreenReset:   "offscreenReset" // key used for data
      //    CSS used in multiple places
      ,     hidden:           { visibility: "hidden" }
      ,     visible:    { visibility: "visible" }
      //    layout element settings
      ,     resizers: {
                  cssReq: {
                        position:   "absolute"
                  ,     padding:    0
                  ,     margin:     0
                  ,     fontSize:   "1px"
                  ,     textAlign:  "left"      // to counter-act "center" alignment!
                  ,     overflow:   "hidden" // prevent toggler-button from overflowing
                  //    SEE $.layout.defaults.zIndexes.resizer_normal
                  }
            ,     cssDemo: { // DEMO CSS - applied if: options.PANE.applyDemoStyles=true
                        background: "#DDD"
                  ,     border:           "none"
                  }
            }
      ,     togglers: {
                  cssReq: {
                        position:   "absolute"
                  ,     display:    "block"
                  ,     padding:    0
                  ,     margin:     0
                  ,     overflow:   "hidden"
                  ,     textAlign:  "center"
                  ,     fontSize:   "1px"
                  ,     cursor:     "pointer"
                  ,     zIndex:     1
                  }
            ,     cssDemo: { // DEMO CSS - applied if: options.PANE.applyDemoStyles=true
                        background: "#AAA"
                  }
            }
      ,     content: {
                  cssReq: {
                        position:   "relative" /* contain floated or positioned elements */
                  }
            ,     cssDemo: { // DEMO CSS - applied if: options.PANE.applyDemoStyles=true
                        overflow:   "auto"
                  ,     padding:    "10px"
                  }
            ,     cssDemoPane: { // DEMO CSS - REMOVE scrolling from 'pane' when it has a content-div
                        overflow:   "hidden"
                  ,     padding:    0
                  }
            }
      ,     panes: { // defaults for ALL panes - overridden by 'per-pane settings' below
                  cssReq: {
                        position:   "absolute"
                  ,     margin:           0
                  //    $.layout.defaults.zIndexes.pane_normal
                  }
            ,     cssDemo: { // DEMO CSS - applied if: options.PANE.applyDemoStyles=true
                        padding:    "10px"
                  ,     background: "#FFF"
                  ,     border:           "1px solid #BBB"
                  ,     overflow:   "auto"
                  }
            }
      ,     north: {
                  side:             "top"
            ,     sizeType:         "Height"
            ,     dir:              "horz"
            ,     cssReq: {
                        top:        0
                  ,     bottom:     "auto"
                  ,     left:             0
                  ,     right:            0
                  ,     width:            "auto"
                  //    height:     DYNAMIC
                  }
            }
      ,     south: {
                  side:             "bottom"
            ,     sizeType:         "Height"
            ,     dir:              "horz"
            ,     cssReq: {
                        top:        "auto"
                  ,     bottom:     0
                  ,     left:             0
                  ,     right:            0
                  ,     width:            "auto"
                  //    height:     DYNAMIC
                  }
            }
      ,     east: {
                  side:             "right"
            ,     sizeType:         "Width"
            ,     dir:              "vert"
            ,     cssReq: {
                        left:             "auto"
                  ,     right:            0
                  ,     top:        "auto" // DYNAMIC
                  ,     bottom:     "auto" // DYNAMIC
                  ,     height:     "auto"
                  //    width:            DYNAMIC
                  }
            }
      ,     west: {
                  side:             "left"
            ,     sizeType:         "Width"
            ,     dir:              "vert"
            ,     cssReq: {
                        left:             0
                  ,     right:            "auto"
                  ,     top:        "auto" // DYNAMIC
                  ,     bottom:     "auto" // DYNAMIC
                  ,     height:     "auto"
                  //    width:            DYNAMIC
                  }
            }
      ,     center: {
                  dir:              "center"
            ,     cssReq: {
                        left:             "auto" // DYNAMIC
                  ,     right:            "auto" // DYNAMIC
                  ,     top:        "auto" // DYNAMIC
                  ,     bottom:     "auto" // DYNAMIC
                  ,     height:     "auto"
                  ,     width:            "auto"
                  }
            }
      }

      // CALLBACK FUNCTION NAMESPACE - used to store reusable callback functions
,     callbacks: {}

,     getParentPaneElem: function (el) {
            // must pass either a container or pane element
            var $el = $(el)
            ,     layout = $el.data("layout") || $el.data("parentLayout");
            if (layout) {
                  var $cont = layout.container;
                  // see if this container is directly-nested inside an outer-pane
                  if ($cont.data("layoutPane")) return $cont;
                  var $pane = $cont.closest("."+ $.layout.defaults.panes.paneClass);
                  // if a pane was found, return it
                  if ($pane.data("layoutPane")) return $pane;
            }
            return null;
      }

,     getParentPaneInstance: function (el) {
            // must pass either a container or pane element
            var $pane = $.layout.getParentPaneElem(el);
            return $pane ? $pane.data("layoutPane") : null;
      }

,     getParentLayoutInstance: function (el) {
            // must pass either a container or pane element
            var $pane = $.layout.getParentPaneElem(el);
            return $pane ? $pane.data("parentLayout") : null;
      }

,     getEventObject: function (evt) {
            return typeof evt === "object" && evt.stopPropagation ? evt : null;
      }
,     parsePaneName: function (evt_or_pane) {
            var evt = $.layout.getEventObject( evt_or_pane )
            ,     pane = evt_or_pane;
            if (evt) {
                  // ALWAYS stop propagation of events triggered in Layout!
                  evt.stopPropagation();
                  pane = $(this).data("layoutEdge");
            }
            if (pane && !/^(west|east|north|south|center)$/.test(pane)) {
                  $.layout.msg('LAYOUT ERROR - Invalid pane-name: "'+ pane +'"');
                  pane = "error";
            }
            return pane;
      }


      // LAYOUT-PLUGIN REGISTRATION
      // more plugins can added beyond this default list
,     plugins: {
            draggable:        !!$.fn.draggable // resizing
      ,     effects: {
                  core:       !!$.effects       // animimations (specific effects tested by initOptions)
            ,     slide:            $.effects && ($.effects.slide || ($.effects.effect && $.effects.effect.slide)) // default effect
            }
      }

//    arrays of plugin or other methods to be triggered for events in *each layout* - will be passed 'Instance'
,     onCreate:   []    // runs when layout is just starting to be created - right after options are set
,     onLoad:           []    // runs after layout container and global events init, but before initPanes is called
,     onReady:    []    // runs after initialization *completes* - ie, after initPanes completes successfully
,     onDestroy:  []    // runs after layout is destroyed
,     onUnload:   []    // runs after layout is destroyed OR when page unloads
,     afterOpen:  []    // runs after setAsOpen() completes
,     afterClose: []    // runs after setAsClosed() completes

      /*
      *     GENERIC UTILITY METHODS
      */

      // calculate and return the scrollbar width, as an integer
,     scrollbarWidth:         function () { return window.scrollbarWidth  || $.layout.getScrollbarSize('width'); }
,     scrollbarHeight:  function () { return window.scrollbarHeight || $.layout.getScrollbarSize('height'); }
,     getScrollbarSize: function (dim) {
            var $c      = $('<div style="position: absolute; top: -10000px; left: -10000px; width: 100px; height: 100px; overflow: scroll;"></div>').appendTo("body");
            var d = { width: $c.css("width") - $c[0].clientWidth, height: $c.height() - $c[0].clientHeight };
            $c.remove();
            window.scrollbarWidth   = d.width;
            window.scrollbarHeight  = d.height;
            return dim.match(/^(width|height)$/) ? d[dim] : d;
      }


      /**
      * Returns hash container 'display' and 'visibility'
      *
      * @see      $.swap() - swaps CSS, runs callback, resets CSS
      * @param  {!Object}           $E                      jQuery element
      * @param  {boolean=}    [force=false]     Run even if display != none
      * @return {!Object}                                   Returns current style props, if applicable
      */
,     showInvisibly: function ($E, force) {
            if ($E && $E.length && (force || $E.css("display") === "none")) { // only if not *already hidden*
                  var s = $E[0].style
                        // save ONLY the 'style' props because that is what we must restore
                  ,     CSS = { display: s.display || '', visibility: s.visibility || '' };
                  // show element 'invisibly' so can be measured
                  $E.css({ display: "block", visibility: "hidden" });
                  return CSS;
            }
            return {};
      }

      /**
      * Returns data for setting size of an element (container or a pane).
      *
      * @see  _create(), onWindowResize() for container, plus others for pane
      * @return JSON  Returns a hash of all dimensions: top, bottom, left, right, outerWidth, innerHeight, etc
      */
,     getElementDimensions: function ($E, inset) {
            var
            //    dimensions hash - start with current data IF passed
                  d     = { css: {}, inset: {} }
            ,     x     = d.css                 // CSS hash
            ,     i     = { bottom: 0 }   // TEMP insets (bottom = complier hack)
            ,     N     = $.layout.cssNum
            ,     off, b, p, ei           // TEMP border, padding
            ;
            if (!$E.is(":visible")) return d; // TODO: Testing?

            off = $E.offset();
            d.offsetLeft = off.left;
            d.offsetTop  = off.top;

            if (!inset) inset = {}; // simplify logic below

            $.each("Left,Right,Top,Bottom".split(","), function (idx, e) { // e = edge
                  b = x["border" + e] = $.layout.borderWidth($E, e);
                  p = x["padding"+ e] = $.layout.cssNum($E, "padding"+e);
                  ei = e.toLowerCase();
                  d.inset[ei] = inset[ei] >= 0 ? inset[ei] : p; // any missing insetX value = paddingX
                  i[ei] = d.inset[ei] + b; // total offset of content from outer side
            });

            x.width           = $E.width();
            x.height    = $E.height();
            x.top       = N($E,"top",true);
            x.bottom    = N($E,"bottom",true);
            x.left            = N($E,"left",true);
            x.right           = N($E,"right",true);

            d.outerWidth      = $E.outerWidth();
            d.outerHeight     = $E.outerHeight();
            // calc the TRUE inner-dimensions, even in quirks-mode!
            d.innerWidth      = max(0, d.outerWidth  - i.left - i.right);
            d.innerHeight     = max(0, d.outerHeight - i.top  - i.bottom);
            // layoutWidth/Height is used in calcs for manual resizing
            // layoutW/H only differs from innerW/H when in quirks-mode - then is like outerW/H
            d.layoutWidth     = $E.innerWidth();
            d.layoutHeight    = $E.innerHeight();

            //if ($E.prop('tagName') === 'BODY') { debugData( d, $E.prop('tagName') ); } // DEBUG

            //d.visible = $E.is(":visible");// && x.width > 0 && x.height > 0;

            return d;
      }

,     getElementStyles: function ($E, list) {
            var
                  CSS   = {}
            ,     style = $E[0].style
            ,     props = list.split(",")
            ,     sides = "Top,Bottom,Left,Right".split(",")
            ,     attrs = "Color,Style,Width".split(",")
            ,     p, s, a, i, j, k
            ;
            for (i=0; i < props.length; i++) {
                  p = props[i];
                  if (p.match(/(border|padding|margin)$/))
                        for (j=0; j < 4; j++) {
                              s = sides[j];
                              if (p === "border")
                                    for (k=0; k < 3; k++) {
                                          a = attrs[k];
                                          CSS[p+s+a] = style[p+s+a];
                                    }
                              else
                                    CSS[p+s] = style[p+s];
                        }
                  else
                        CSS[p] = style[p];
            };
            return CSS
      }

      /**
      * Return the innerWidth for the current browser/doctype
      *
      * @see  initPanes(), sizeMidPanes(), initHandles(), sizeHandles()
      * @param  {Array.<Object>}    $E  Must pass a jQuery object - first element is processed
      * @param  {number=}                 outerWidth (optional) Can pass a width, allowing calculations BEFORE element is resized
      * @return {number}                  Returns the innerWidth of the elem by subtracting padding and borders
      */
,     cssWidth: function ($E, outerWidth) {
            // a 'calculated' outerHeight can be passed so borders and/or padding are removed if needed
            if (outerWidth <= 0) return 0;

            var bs      = !$.layout.browser.boxModel ? "border-box" : $.support.boxSizing ? $E.css("boxSizing") : "content-box"
            ,     b     = $.layout.borderWidth
            ,     n     = $.layout.cssNum
            ,     W     = outerWidth
            ;
            // strip border and/or padding from outerWidth to get CSS Width
            if (bs !== "border-box")
                  W -= (b($E, "Left") + b($E, "Right"));
            if (bs === "content-box")
                  W -= (n($E, "paddingLeft") + n($E, "paddingRight"));
            return max(0,W);
      }

      /**
      * Return the innerHeight for the current browser/doctype
      *
      * @see  initPanes(), sizeMidPanes(), initHandles(), sizeHandles()
      * @param  {Array.<Object>}    $E  Must pass a jQuery object - first element is processed
      * @param  {number=}                 outerHeight  (optional) Can pass a width, allowing calculations BEFORE element is resized
      * @return {number}                  Returns the innerHeight of the elem by subtracting padding and borders
      */
,     cssHeight: function ($E, outerHeight) {
            // a 'calculated' outerHeight can be passed so borders and/or padding are removed if needed
            if (outerHeight <= 0) return 0;

            var bs      = !$.layout.browser.boxModel ? "border-box" : $.support.boxSizing ? $E.css("boxSizing") : "content-box"
            ,     b     = $.layout.borderWidth
            ,     n     = $.layout.cssNum
            ,     H     = outerHeight
            ;
            // strip border and/or padding from outerHeight to get CSS Height
            if (bs !== "border-box")
                  H -= (b($E, "Top") + b($E, "Bottom"));
            if (bs === "content-box")
                  H -= (n($E, "paddingTop") + n($E, "paddingBottom"));
            return max(0,H);
      }

      /**
      * Returns the 'current CSS numeric value' for a CSS property - 0 if property does not exist
      *
      * @see  Called by many methods
      * @param {Array.<Object>}     $E                            Must pass a jQuery object - first element is processed
      * @param {string}             prop                    The name of the CSS property, eg: top, width, etc.
      * @param {boolean=}                 [allowAuto=false] true = return 'auto' if that is value; false = return 0
      * @return {(string|number)}                                 Usually used to get an integer value for position (top, left) or size (height, width)
      */
,     cssNum: function ($E, prop, allowAuto) {
            if (!$E.jquery) $E = $($E);
            var CSS = $.layout.showInvisibly($E)
            ,     p     = $.css($E[0], prop, true)
            ,     v     = allowAuto && p=="auto" ? p : Math.round(parseFloat(p) || 0);
            $E.css( CSS ); // RESET
            return v;
      }

,     borderWidth: function (el, side) {
            if (el.jquery) el = el[0];
            var b = "border"+ side.substr(0,1).toUpperCase() + side.substr(1); // left => Left
            return $.css(el, b+"Style", true) === "none" ? 0 : Math.round(parseFloat($.css(el, b+"Width", true)) || 0);
      }

      /**
      * Mouse-tracking utility - FUTURE REFERENCE
      *
      * init: if (!window.mouse) {
      *                 window.mouse = { x: 0, y: 0 };
      *                 $(document).mousemove( $.layout.trackMouse );
      *           }
      *
      * @param {Object}       evt
      *
,     trackMouse: function (evt) {
            window.mouse = { x: evt.clientX, y: evt.clientY };
      }
      */

      /**
      * SUBROUTINE for preventPrematureSlideClose option
      *
      * @param {Object}       evt
      * @param {Object=}            el
      */
,     isMouseOverElem: function (evt, el) {
            var
                  $E    = $(el || this)
            ,     d     = $E.offset()
            ,     T     = d.top
            ,     L     = d.left
            ,     R     = L + $E.outerWidth()
            ,     B     = T + $E.outerHeight()
            ,     x     = evt.pageX // evt.clientX ?
            ,     y     = evt.pageY // evt.clientY ?
            ;
            // if X & Y are < 0, probably means is over an open SELECT
            return ($.layout.browser.msie && x < 0 && y < 0) || ((x >= L && x <= R) && (y >= T && y <= B));
      }

      /**
      * Message/Logging Utility
      *
      * @example $.layout.msg("My message");                      // log text
      * @example $.layout.msg("My message", true);          // alert text
      * @example $.layout.msg({ foo: "bar" }, "Title");     // log hash-data, with custom title
      * @example $.layout.msg({ foo: "bar" }, true, "Title", { sort: false }); -OR-
      * @example $.layout.msg({ foo: "bar" }, "Title", { sort: false, display: true }); // alert hash-data
      *
      * @param {(Object|string)}                info              String message OR Hash/Array
      * @param {(Boolean|string|Object)=} [popup=false]     True means alert-box - can be skipped
      * @param {(Object|string)=}               [debugTitle=""]   Title for Hash data - can be skipped
      * @param {Object=}                              [debugOpts]       Extra options for debug output
      */
,     msg: function (info, popup, debugTitle, debugOpts) {
            if ($.isPlainObject(info) && window.debugData) {
                  if (typeof popup === "string") {
                        debugOpts   = debugTitle;
                        debugTitle  = popup;
                  }
                  else if (typeof debugTitle === "object") {
                        debugOpts   = debugTitle;
                        debugTitle  = null;
                  }
                  var t = debugTitle || "log( <object> )"
                  ,     o = $.extend({ sort: false, returnHTML: false, display: false }, debugOpts);
                  if (popup === true || o.display)
                        debugData( info, t, o );
                  else if (window.console)
                        console.log(debugData( info, t, o ));
            }
            else if (popup)
                  alert(info);
            else if (window.console)
                  console.log(info);
            else {
                  var id      = "#layoutLogger"
                  ,     $l = $(id);
                  if (!$l.length)
                        $l = createLog();
                  $l.children("ul").append('<li style="padding: 4px 10px; margin: 0; border-top: 1px solid #CCC;">'+ info.replace(/\</g,"&lt;").replace(/\>/g,"&gt;") +'</li>');
            }

            function createLog () {
                  var pos = $.support.fixedPosition ? 'fixed' : 'absolute'
                  ,     $e = $('<div id="layoutLogger" style="position: '+ pos +'; top: 5px; z-index: 999999; max-width: 25%; overflow: hidden; border: 1px solid #000; border-radius: 5px; background: #FBFBFB; box-shadow: 0 2px 10px rgba(0,0,0,0.3);">'
                        +     '<div style="font-size: 13px; font-weight: bold; padding: 5px 10px; background: #F6F6F6; border-radius: 5px 5px 0 0; cursor: move;">'
                        +     '<span style="float: right; padding-left: 7px; cursor: pointer;" title="Remove Console" onclick="$(this).closest(\'#layoutLogger\').remove()">X</span>Layout console.log</div>'
                        +     '<ul style="font-size: 13px; font-weight: none; list-style: none; margin: 0; padding: 0 0 2px;"></ul>'
                        + '</div>'
                        ).appendTo("body");
                  $e.css('left', $(window).width() - $e.outerWidth() - 5)
                  if ($.ui.draggable) $e.draggable({ handle: ':first-child' });
                  return $e;
            };
      }

};


/*
 *    $.layout.browser REPLACES removed $.browser, with extra data
 *    Parsing code here adapted from jQuery 1.8 $.browse
 */
var u = navigator.userAgent.toLowerCase()
,     m = /(chrome)[ \/]([\w.]+)/.exec( u )
      ||    /(webkit)[ \/]([\w.]+)/.exec( u )
      ||    /(opera)(?:.*version|)[ \/]([\w.]+)/.exec( u )
      ||    /(msie) ([\w.]+)/.exec( u )
      ||    u.indexOf("compatible") < 0 && /(mozilla)(?:.*? rv:([\w.]+)|)/.exec( u )
      ||    []
,     b = m[1] || ""
,     v = m[2] || 0
,     ie = b === "msie"
;
$.layout.browser = {
      version:    v
,     safari:           b === "webkit"    // webkit (NOT chrome) = safari
,     webkit:           b === "chrome"    // chrome = webkit
,     msie:       ie
,     isIE6:            ie && v == 6
      // ONLY IE reverts to old box-model - update for older jQ onReady
,     boxModel:   !ie || $.support.boxModel !== false
};
if (b) $.layout.browser[b] = true; // set CURRENT browser
/*    OLD versions of jQuery only set $.support.boxModel after page is loaded
 *    so if this is IE, use support.boxModel to test for quirks-mode (ONLY IE changes boxModel) */
if (ie) $(function(){ $.layout.browser.boxModel = $.support.boxModel; });


// DEFAULT OPTIONS
$.layout.defaults = {
/*
 *    LAYOUT & LAYOUT-CONTAINER OPTIONS
 *    - none of these options are applicable to individual panes
 */
      name:                               ""                // Not required, but useful for buttons and used for the state-cookie
,     containerClass:                     "ui-layout-container" // layout-container element
,     inset:                                    null        // custom container-inset values (override padding)
,     scrollToBookmarkOnLoad:       true        // after creating a layout, scroll to bookmark in URL (.../page.htm#myBookmark)
,     resizeWithWindow:             true        // bind thisLayout.resizeAll() to the window.resize event
,     resizeWithWindowDelay:        200               // delay calling resizeAll because makes window resizing very jerky
,     resizeWithWindowMaxDelay:     0                 // 0 = none - force resize every XX ms while window is being resized
,     maskPanesEarly:                     false       // true = create pane-masks on resizer.mouseDown instead of waiting for resizer.dragstart
,     onresizeall_start:                  null        // CALLBACK when resizeAll() STARTS - NOT pane-specific
,     onresizeall_end:              null        // CALLBACK when resizeAll() ENDS   - NOT pane-specific
,     onload_start:                       null        // CALLBACK when Layout inits - after options initialized, but before elements
,     onload_end:                         null        // CALLBACK when Layout inits - after EVERYTHING has been initialized
,     onunload_start:                     null        // CALLBACK when Layout is destroyed OR onWindowUnload
,     onunload_end:                       null        // CALLBACK when Layout is destroyed OR onWindowUnload
,     initPanes:                          true        // false = DO NOT initialize the panes onLoad - will init later
,     showErrorMessages:                  true        // enables fatal error messages to warn developers of common errors
,     showDebugMessages:                  false       // display console-and-alert debug msgs - IF this Layout version _has_ debugging code!
//    Changing this zIndex value will cause other zIndex values to automatically change
,     zIndex:                                   null        // the PANE zIndex - resizers and masks will be +1
//    DO NOT CHANGE the zIndex values below unless you clearly understand their relationships
,     zIndexes: {                                           // set _default_ z-index values here...
            pane_normal:                  0                 // normal z-index for panes
      ,     content_mask:                 1                 // applied to overlays used to mask content INSIDE panes during resizing
      ,     resizer_normal:               2                 // normal z-index for resizer-bars
      ,     pane_sliding:                 100               // applied to *BOTH* the pane and its resizer when a pane is 'slid open'
      ,     pane_animate:                 1000        // applied to the pane when being animated - not applied to the resizer
      ,     resizer_drag:                 10000       // applied to the CLONED resizer-bar when being 'dragged'
      }
,     errors: {
            pane:                         "pane"            // description of "layout pane element" - used only in error messages
      ,     selector:                     "selector"  // description of "jQuery-selector" - used only in error messages
      ,     addButtonError:               "Error Adding Button\nInvalid "
      ,     containerMissing:       "UI Layout Initialization Error\nThe specified layout-container does not exist."
      ,     centerPaneMissing:            "UI Layout Initialization Error\nThe center-pane element does not exist.\nThe center-pane is a required element."
      ,     noContainerHeight:            "UI Layout Initialization Warning\nThe layout-container \"CONTAINER\" has no height.\nTherefore the layout is 0-height and hence 'invisible'!"
      ,     callbackError:                "UI Layout Callback Error\nThe EVENT callback is not a valid function."
      }
/*
 *    PANE DEFAULT SETTINGS
 *    - settings under the 'panes' key become the default settings for *all panes*
 *    - ALL pane-options can also be set specifically for each panes, which will override these 'default values'
 */
,     panes: { // default options for 'all panes' - will be overridden by 'per-pane settings'
            applyDemoStyles:        false       // NOTE: renamed from applyDefaultStyles for clarity
      ,     closable:                     true        // pane can open & close
      ,     resizable:                    true        // when open, pane can be resized 
      ,     slidable:                     true        // when closed, pane can 'slide open' over other panes - closes on mouse-out
      ,     initClosed:                   false       // true = init pane as 'closed'
      ,     initHidden:                   false             // true = init pane as 'hidden' - no resizer-bar/spacing
      //    SELECTORS
      //,   paneSelector:                 ""                // MUST be pane-specific - jQuery selector for pane
      ,     contentSelector:        ".ui-layout-content" // INNER div/element to auto-size so only it scrolls, not the entire pane!
      ,     contentIgnoreSelector:  ".ui-layout-ignore"     // element(s) to 'ignore' when measuring 'content'
      ,     findNestedContent:            false       // true = $P.find(contentSelector), false = $P.children(contentSelector)
      //    GENERIC ROOT-CLASSES - for auto-generated classNames
      ,     paneClass:                    "ui-layout-pane"  // Layout Pane
      ,     resizerClass:                 "ui-layout-resizer"     // Resizer Bar
      ,     togglerClass:                 "ui-layout-toggler"     // Toggler Button
      ,     buttonClass:                  "ui-layout-button"      // CUSTOM Buttons - eg: '[ui-layout-button]-toggle/-open/-close/-pin'
      //    ELEMENT SIZE & SPACING
      //,   size:                         100               // MUST be pane-specific -initial size of pane
      ,     minSize:                      0                 // when manually resizing a pane
      ,     maxSize:                      0                 // ditto, 0 = no limit
      ,     spacing_open:                 6                 // space between pane and adjacent panes - when pane is 'open'
      ,     spacing_closed:               6                 // ditto - when pane is 'closed'
      ,     togglerLength_open:           50                // Length = WIDTH of toggler button on north/south sides - HEIGHT on east/west sides
      ,     togglerLength_closed:   50                // 100% OR -1 means 'full height/width of resizer bar' - 0 means 'hidden'
      ,     togglerAlign_open:            "center"    // top/left, bottom/right, center, OR...
      ,     togglerAlign_closed:    "center"    // 1 => nn = offset from top/left, -1 => -nn == offset from bottom/right
      ,     togglerContent_open:    ""                // text or HTML to put INSIDE the toggler
      ,     togglerContent_closed:  ""                // ditto
      //    RESIZING OPTIONS
      ,     resizerDblClickToggle:  true        // 
      ,     autoResize:                   true        // IF size is 'auto' or a percentage, then recalc 'pixel size' whenever the layout resizes
      ,     autoReopen:                   true        // IF a pane was auto-closed due to noRoom, reopen it when there is room? False = leave it closed
      ,     resizerDragOpacity:           1                 // option for ui.draggable
      //,   resizerCursor:                ""                // MUST be pane-specific - cursor when over resizer-bar
      ,     maskContents:                 false       // true = add DIV-mask over-or-inside this pane so can 'drag' over IFRAMES
      ,     maskObjects:                  false       // true = add IFRAME-mask over-or-inside this pane to cover objects/applets - content-mask will overlay this mask
      ,     maskZindex:                   null        // will override zIndexes.content_mask if specified - not applicable to iframe-panes
      ,     resizingGrid:                 false       // grid size that the resizers will snap-to during resizing, eg: [20,20]
      ,     livePaneResizing:       false       // true = LIVE Resizing as resizer is dragged
      ,     liveContentResizing:    false       // true = re-measure header/footer heights as resizer is dragged
      ,     liveResizingTolerance:  1                 // how many px change before pane resizes, to control performance
      //    SLIDING OPTIONS
      ,     sliderCursor:                 "pointer"   // cursor when resizer-bar will trigger 'sliding'
      ,     slideTrigger_open:            "click"           // click, dblclick, mouseenter
      ,     slideTrigger_close:           "mouseleave"// click, mouseleave
      ,     slideDelay_open:        300               // applies only for mouseenter event - 0 = instant open
      ,     slideDelay_close:       300               // applies only for mouseleave event (300ms is the minimum!)
      ,     hideTogglerOnSlide:           false       // when pane is slid-open, should the toggler show?
      ,     preventQuickSlideClose: $.layout.browser.webkit // Chrome triggers slideClosed as it is opening
      ,     preventPrematureSlideClose: false   // handle incorrect mouseleave trigger, like when over a SELECT-list in IE
      //    PANE-SPECIFIC TIPS & MESSAGES
      ,     tips: {
                  Open:                   "Open"            // eg: "Open Pane"
            ,     Close:                        "Close"
            ,     Resize:                       "Resize"
            ,     Slide:                        "Slide Open"
            ,     Pin:                    "Pin"
            ,     Unpin:                        "Un-Pin"
            ,     noRoomToOpen:           "Not enough room to show this panel."     // alert if user tries to open a pane that cannot
            ,     minSizeWarning:         "Panel has reached its minimum size"      // displays in browser statusbar
            ,     maxSizeWarning:         "Panel has reached its maximum size"      // ditto
            }
      //    HOT-KEYS & MISC
      ,     showOverflowOnHover:    false       // will bind allowOverflow() utility to pane.onMouseOver
      ,     enableCursorHotkey:           true        // enabled 'cursor' hotkeys
      //,   customHotkey:                 ""                // MUST be pane-specific - EITHER a charCode OR a character
      ,     customHotkeyModifier:   "SHIFT"           // either 'SHIFT', 'CTRL' or 'CTRL+SHIFT' - NOT 'ALT'
      //    PANE ANIMATION
      //    NOTE: fxSss_open, fxSss_close & fxSss_size options (eg: fxName_open) are auto-generated if not passed
      ,     fxName:                             "slide"     // ('none' or blank), slide, drop, scale -- only relevant to 'open' & 'close', NOT 'size'
      ,     fxSpeed:                      null        // slow, normal, fast, 200, nnn - if passed, will OVERRIDE fxSettings.duration
      ,     fxSettings:                   {}                // can be passed, eg: { easing: "easeOutBounce", duration: 1500 }
      ,     fxOpacityFix:                 true        // tries to fix opacity in IE to restore anti-aliasing after animation
      ,     animatePaneSizing:            false       // true = animate resizing after dragging resizer-bar OR sizePane() is called
      /*  NOTE: Action-specific FX options are auto-generated from the options above if not specifically set:
            fxName_open:                  "slide"           // 'Open' pane animation
            fnName_close:                 "slide"           // 'Close' pane animation
            fxName_size:                  "slide"           // 'Size' pane animation - when animatePaneSizing = true
            fxSpeed_open:                 null
            fxSpeed_close:                null
            fxSpeed_size:                 null
            fxSettings_open:        {}
            fxSettings_close:       {}
            fxSettings_size:        {}
      */
      //    CHILD/NESTED LAYOUTS
      ,     children:                     null        // Layout-options for nested/child layout - even {} is valid as options
      ,     containerSelector:            ''                // if child is NOT 'directly nested', a selector to find it/them (can have more than one child layout!)
      ,     initChildren:                 true        // true = child layout will be created as soon as _this_ layout completes initialization
      ,     destroyChildren:        true        // true = destroy child-layout if this pane is destroyed
      ,     resizeChildren:               true        // true = trigger child-layout.resizeAll() when this pane is resized
      //    EVENT TRIGGERING
      ,     triggerEventsOnLoad:    false       // true = trigger onopen OR onclose callbacks when layout initializes
      ,     triggerEventsDuringLiveResize: true // true = trigger onresize callback REPEATEDLY if livePaneResizing==true
      //    PANE CALLBACKS
      ,     onshow_start:                 null        // CALLBACK when pane STARTS to Show      - BEFORE onopen/onhide_start
      ,     onshow_end:                   null        // CALLBACK when pane ENDS being Shown    - AFTER  onopen/onhide_end
      ,     onhide_start:                 null        // CALLBACK when pane STARTS to Close     - BEFORE onclose_start
      ,     onhide_end:                   null        // CALLBACK when pane ENDS being Closed   - AFTER  onclose_end
      ,     onopen_start:                 null        // CALLBACK when pane STARTS to Open
      ,     onopen_end:                   null        // CALLBACK when pane ENDS being Opened
      ,     onclose_start:                null        // CALLBACK when pane STARTS to Close
      ,     onclose_end:                  null        // CALLBACK when pane ENDS being Closed
      ,     onresize_start:               null        // CALLBACK when pane STARTS being Resized ***FOR ANY REASON***
      ,     onresize_end:                 null        // CALLBACK when pane ENDS being Resized ***FOR ANY REASON***
      ,     onsizecontent_start:    null        // CALLBACK when sizing of content-element STARTS
      ,     onsizecontent_end:            null        // CALLBACK when sizing of content-element ENDS
      ,     onswap_start:                 null        // CALLBACK when pane STARTS to Swap
      ,     onswap_end:                   null        // CALLBACK when pane ENDS being Swapped
      ,     ondrag_start:                 null        // CALLBACK when pane STARTS being ***MANUALLY*** Resized
      ,     ondrag_end:                   null        // CALLBACK when pane ENDS being ***MANUALLY*** Resized
      }
/*
 *    PANE-SPECIFIC SETTINGS
 *    - options listed below MUST be specified per-pane - they CANNOT be set under 'panes'
 *    - all options under the 'panes' key can also be set specifically for any pane
 *    - most options under the 'panes' key apply only to 'border-panes' - NOT the the center-pane
 */
,     north: {
            paneSelector:                 ".ui-layout-north"
      ,     size:                         "auto"            // eg: "auto", "30%", .30, 200
      ,     resizerCursor:                "n-resize"  // custom = url(myCursor.cur)
      ,     customHotkey:                 ""                // EITHER a charCode (43) OR a character ("o")
      }
,     south: {
            paneSelector:                 ".ui-layout-south"
      ,     size:                         "auto"
      ,     resizerCursor:                "s-resize"
      ,     customHotkey:                 ""
      }
,     east: {
            paneSelector:                 ".ui-layout-east"
      ,     size:                         200
      ,     resizerCursor:                "e-resize"
      ,     customHotkey:                 ""
      }
,     west: {
            paneSelector:                 ".ui-layout-west"
      ,     size:                         200
      ,     resizerCursor:                "w-resize"
      ,     customHotkey:                 ""
      }
,     center: {
            paneSelector:                 ".ui-layout-center"
      ,     minWidth:                     0
      ,     minHeight:                    0
      }
};

$.layout.optionsMap = {
      // layout/global options - NOT pane-options
      layout: ("name,instanceKey,stateManagement,effects,inset,zIndexes,errors,"
      +     "zIndex,scrollToBookmarkOnLoad,showErrorMessages,maskPanesEarly,"
      +     "outset,resizeWithWindow,resizeWithWindowDelay,resizeWithWindowMaxDelay,"
      +     "onresizeall,onresizeall_start,onresizeall_end,onload,onload_start,onload_end,onunload,onunload_start,onunload_end").split(",")
//    borderPanes: [ ALL options that are NOT specified as 'layout' ]
      // default.panes options that apply to the center-pane (most options apply _only_ to border-panes)
,     center: ("paneClass,contentSelector,contentIgnoreSelector,findNestedContent,applyDemoStyles,triggerEventsOnLoad,"
      +     "showOverflowOnHover,maskContents,maskObjects,liveContentResizing,"
      +     "containerSelector,children,initChildren,resizeChildren,destroyChildren,"
      +     "onresize,onresize_start,onresize_end,onsizecontent,onsizecontent_start,onsizecontent_end").split(",")
      // options that MUST be specifically set 'per-pane' - CANNOT set in the panes (defaults) key
,     noDefault: ("paneSelector,resizerCursor,customHotkey").split(",")
};

/**
 * Processes options passed in converts flat-format data into subkey (JSON) format
 * In flat-format, subkeys are _currently_ separated with 2 underscores, like north__optName
 * Plugins may also call this method so they can transform their own data
 *
 * @param  {!Object}    hash              Data/options passed by user - may be a single level or nested levels
 * @param  {boolean=}   [addKeys=false]   Should the primary layout.options keys be added if they do not exist?
 * @return {Object}                                   Returns hash of minWidth & minHeight
 */
$.layout.transformData = function (hash, addKeys) {
      var   json = addKeys ? { panes: {}, center: {} } : {} // init return object
      ,     branch, optKey, keys, key, val, i, c;

      if (typeof hash !== "object") return json; // no options passed

      // convert all 'flat-keys' to 'sub-key' format
      for (optKey in hash) {
            branch      = json;
            val         = hash[ optKey ];
            keys  = optKey.split("__"); // eg: west__size or north__fxSettings__duration
            c           = keys.length - 1;
            // convert underscore-delimited to subkeys
            for (i=0; i <= c; i++) {
                  key = keys[i];
                  if (i === c) {    // last key = value
                        if ($.isPlainObject( val ))
                              branch[key] = $.layout.transformData( val ); // RECURSE
                        else
                              branch[key] = val;
                  }
                  else {
                        if (!branch[key])
                              branch[key] = {}; // create the subkey
                        // recurse to sub-key for next loop - if not done
                        branch = branch[key];
                  }
            }
      }
      return json;
};

// INTERNAL CONFIG DATA - DO NOT CHANGE THIS!
$.layout.backwardCompatibility = {
      // data used by renameOldOptions()
      map: {
      //    OLD Option Name:              NEW Option Name
            applyDefaultStyles:                 "applyDemoStyles"
      //    CHILD/NESTED LAYOUTS
      ,     childOptions:                       "children"
      ,     initChildLayout:              "initChildren"
      ,     destroyChildLayout:                 "destroyChildren"
      ,     resizeChildLayout:                  "resizeChildren"
      ,     resizeNestedLayout:                 "resizeChildren"
      //    MISC Options
      ,     resizeWhileDragging:          "livePaneResizing"
      ,     resizeContentWhileDragging:   "liveContentResizing"
      ,     triggerEventsWhileDragging:   "triggerEventsDuringLiveResize"
      ,     maskIframesOnResize:          "maskContents"
      //    STATE MANAGEMENT
      ,     useStateCookie:                     "stateManagement.enabled"
      ,     "cookie.autoLoad":                  "stateManagement.autoLoad"
      ,     "cookie.autoSave":                  "stateManagement.autoSave"
      ,     "cookie.keys":                      "stateManagement.stateKeys"
      ,     "cookie.name":                      "stateManagement.cookie.name"
      ,     "cookie.domain":              "stateManagement.cookie.domain"
      ,     "cookie.path":                      "stateManagement.cookie.path"
      ,     "cookie.expires":             "stateManagement.cookie.expires"
      ,     "cookie.secure":              "stateManagement.cookie.secure"
      //    OLD Language options
      ,     noRoomToOpenTip:              "tips.noRoomToOpen"
      ,     togglerTip_open:              "tips.Close"      // open   = Close
      ,     togglerTip_closed:                  "tips.Open"       // closed = Open
      ,     resizerTip:                         "tips.Resize"
      ,     sliderTip:                          "tips.Slide"
      }

/**
* @param {Object} opts
*/
,     renameOptions: function (opts) {
            var map = $.layout.backwardCompatibility.map
            ,     oldData, newData, value
            ;
            for (var itemPath in map) {
                  oldData     = getBranch( itemPath );
                  value = oldData.branch[ oldData.key ];
                  if (value !== undefined) {
                        newData = getBranch( map[itemPath], true );
                        newData.branch[ newData.key ] = value;
                        delete oldData.branch[ oldData.key ];
                  }
            }

            /**
            * @param {string} path
            * @param {boolean=}     [create=false]    Create path if does not exist
            */
            function getBranch (path, create) {
                  var a = path.split(".") // split keys into array
                  ,     c = a.length - 1
                  ,     D = { branch: opts, key: a[c] } // init branch at top & set key (last item)
                  ,     i = 0, k, undef;
                  for (; i<c; i++) { // skip the last key (data)
                        k = a[i];
                        if (D.branch[ k ] == undefined) { // child-key does not exist
                              if (create) {
                                    D.branch = D.branch[ k ] = {}; // create child-branch
                              }
                              else // can't go any farther
                                    D.branch = {}; // branch is undefined
                        }
                        else
                              D.branch = D.branch[ k ]; // get child-branch
                  }
                  return D;
            };
      }

/**
* @param {Object} opts
*/
,     renameAllOptions: function (opts) {
            var ren = $.layout.backwardCompatibility.renameOptions;
            // rename root (layout) options
            ren( opts );
            // rename 'defaults' to 'panes'
            if (opts.defaults) {
                  if (typeof opts.panes !== "object")
                        opts.panes = {};
                  $.extend(true, opts.panes, opts.defaults);
                  delete opts.defaults;
            }
            // rename options in the the options.panes key
            if (opts.panes) ren( opts.panes );
            // rename options inside *each pane key*, eg: options.west
            $.each($.layout.config.allPanes, function (i, pane) {
                  if (opts[pane]) ren( opts[pane] );
            });   
            return opts;
      }
};




/*    ============================================================
 *    BEGIN WIDGET: $( selector ).layout( {options} );
 *    ============================================================
 */
$.fn.layout = function (opts) {
      var

      // local aliases to global data
      browser     = $.layout.browser
,     _c          = $.layout.config

      // local aliases to utlity methods
,     cssW  = $.layout.cssWidth
,     cssH  = $.layout.cssHeight
,     elDims      = $.layout.getElementDimensions
,     styles      = $.layout.getElementStyles
,     evtObj      = $.layout.getEventObject
,     evtPane     = $.layout.parsePaneName

/**
 * options - populated by initOptions()
 */
,     options = $.extend(true, {}, $.layout.defaults)
,     effects     = options.effects = $.extend(true, {}, $.layout.effects)

/**
 * layout-state object
 */
,     state = {
            // generate unique ID to use for event.namespace so can unbind only events added by 'this layout'
            id:                     "layout"+ $.now() // code uses alias: sID
      ,     initialized:      false
      ,     paneResizing:     false
      ,     panesSliding:     {}
      ,     container:  {     // list all keys referenced in code to avoid compiler error msgs
                  innerWidth:       0
            ,     innerHeight:      0
            ,     outerWidth:       0
            ,     outerHeight:      0
            ,     layoutWidth:      0
            ,     layoutHeight:     0
            }
      ,     north:            { childIdx: 0 }
      ,     south:            { childIdx: 0 }
      ,     east:       { childIdx: 0 }
      ,     west:       { childIdx: 0 }
      ,     center:           { childIdx: 0 }
      }

/**
 * parent/child-layout pointers
 */
//,   hasParentLayout   = false     - exists ONLY inside Instance so can be set externally
,     children = {
            north:            null
      ,     south:            null
      ,     east:       null
      ,     west:       null
      ,     center:           null
      }

/*
 * ###########################
 *  INTERNAL HELPER FUNCTIONS
 * ###########################
 */

      /**
      * Manages all internal timers
      */
,     timer = {
            data: {}
      ,     set:  function (s, fn, ms) { timer.clear(s); timer.data[s] = setTimeout(fn, ms); }
      ,     clear:      function (s) { var t=timer.data; if (t[s]) {clearTimeout(t[s]); delete t[s];} }
      }

      /**
      * Alert or console.log a message - IF option is enabled.
      *
      * @param {(string|!Object)}   msg                     Message (or debug-data) to display
      * @param {boolean=}                 [popup=false]     True by default, means 'alert', false means use console.log
      * @param {boolean=}                 [debug=false]     True means is a widget debugging message
      */
,     _log = function (msg, popup, debug) {
            var o = options;
            if ((o.showErrorMessages && !debug) || (debug && o.showDebugMessages))
                  $.layout.msg( o.name +' / '+ msg, (popup !== false) );
            return false;
      }

      /**
      * Executes a Callback function after a trigger event, like resize, open or close
      *
      * @param {string}                   evtName                             Name of the layout callback, eg "onresize_start"
      * @param {(string|boolean)=}  [pane=""]                     This is passed only so we can pass the 'pane object' to the callback
      * @param {(string|boolean)=}  [skipBoundEvents=false] True = do not run events bound to the elements - only the callbacks set in options
      */
,     _runCallbacks = function (evtName, pane, skipBoundEvents) {
            var   hasPane     = pane && isStr(pane)
            ,     s           = hasPane ? state[pane] : state
            ,     o           = hasPane ? options[pane] : options
            ,     lName = options.name
                  // names like onopen and onopen_end separate are interchangeable in options...
            ,     lng         = evtName + (evtName.match(/_/) ? "" : "_end")
            ,     shrt  = lng.match(/_end$/) ? lng.substr(0, lng.length - 4) : ""
            ,     fn          = o[lng] || o[shrt]
            ,     retVal      = "NC" // NC = No Callback
            ,     args  = []
            ,     $P
            ;
            if ( !hasPane && $.type(pane) === 'boolean' ) {
                  skipBoundEvents = pane; // allow pane param to be skipped for Layout callback
                  pane = "";
            }

            // first trigger the callback set in the options
            if (fn) {
                  try {
                        // convert function name (string) to function object
                        if (isStr( fn )) {
                              if (fn.match(/,/)) {
                                    // function name cannot contain a comma, 
                                    // so must be a function name AND a parameter to pass
                                    args = fn.split(",")
                                    ,     fn = eval(args[0]);
                              }
                              else // just the name of an external function?
                                    fn = eval(fn);
                        }
                        // execute the callback, if exists
                        if ($.isFunction( fn )) {
                              if (args.length)
                                    retVal = g(fn)(args[1]); // pass the argument parsed from 'list'
                              else if ( hasPane )
                                    // pass data: pane-name, pane-element, pane-state, pane-options, and layout-name
                                    retVal = g(fn)( pane, $Ps[pane], s, o, lName );
                              else // must be a layout/container callback - pass suitable info
                                    retVal = g(fn)( Instance, s, o, lName );
                        }
                  }
                  catch (ex) {
                        _log( options.errors.callbackError.replace(/EVENT/, $.trim((pane || "") +" "+ lng)), false );
                        if ($.type(ex) === 'string' && string.length)
                              _log('Exception:  '+ ex, false );
                  }
            }

            // trigger additional events bound directly to the pane
            if (!skipBoundEvents && retVal !== false) {
                  if ( hasPane ) { // PANE events can be bound to each pane-elements
                        $P    = $Ps[pane];
                        o     = options[pane];
                        s     = state[pane];
                        $P.triggerHandler('layoutpane'+ lng, [ pane, $P, s, o, lName ]);
                        if (shrt)
                              $P.triggerHandler('layoutpane'+ shrt, [ pane, $P, s, o, lName ]);
                  }
                  else { // LAYOUT events can be bound to the container-element
                        $N.triggerHandler('layout'+ lng, [ Instance, s, o, lName ]);
                        if (shrt)
                              $N.triggerHandler('layout'+ shrt, [ Instance, s, o, lName ]);
                  }
            }

            // ALWAYS resizeChildren after an onresize_end event - even during initialization
            // IGNORE onsizecontent_end event because causes child-layouts to resize TWICE
            if (hasPane && evtName === "onresize_end") // BAD: || evtName === "onsizecontent_end"
                  resizeChildren(pane+"", true); // compiler hack -force string

            return retVal;

            function g (f) { return f; }; // compiler hack
      }


      /**
      * cure iframe display issues in IE & other browsers
      */
,     _fixIframe = function (pane) {
            if (browser.mozilla) return; // skip FireFox - it auto-refreshes iframes onShow
            var $P = $Ps[pane];
            // if the 'pane' is an iframe, do it
            if (state[pane].tagName === "IFRAME")
                  $P.css(_c.hidden).css(_c.visible); 
            else // ditto for any iframes INSIDE the pane
                  $P.find('IFRAME').css(_c.hidden).css(_c.visible);
      }

      /**
      * @param  {string}            pane        Can accept ONLY a 'pane' (east, west, etc)
      * @param  {number=}           outerSize   (optional) Can pass a width, allowing calculations BEFORE element is resized
      * @return {number}            Returns the innerHeight/Width of el by subtracting padding and borders
      */
,     cssSize = function (pane, outerSize) {
            var fn = _c[pane].dir=="horz" ? cssH : cssW;
            return fn($Ps[pane], outerSize);
      }

      /**
      * @param  {string}            pane        Can accept ONLY a 'pane' (east, west, etc)
      * @return {Object}            Returns hash of minWidth & minHeight
      */
,     cssMinDims = function (pane) {
            // minWidth/Height means CSS width/height = 1px
            var   $P    = $Ps[pane]
            ,     dir   = _c[pane].dir
            ,     d     = {
                        minWidth:   1001 - cssW($P, 1000)
                  ,     minHeight:  1001 - cssH($P, 1000)
                  }
            ;
            if (dir === "horz") d.minSize = d.minHeight;
            if (dir === "vert") d.minSize = d.minWidth;
            return d;
      }

      // TODO: see if these methods can be made more useful...
      // TODO: *maybe* return cssW/H from these so caller can use this info

      /**
      * @param {(string|!Object)}         el
      * @param {number=}                        outerWidth
      * @param {boolean=}                       [autoHide=false]
      */
,     setOuterWidth = function (el, outerWidth, autoHide) {
            var $E = el, w;
            if (isStr(el)) $E = $Ps[el]; // west
            else if (!el.jquery) $E = $(el);
            w = cssW($E, outerWidth);
            $E.css({ width: w });
            if (w > 0) {
                  if (autoHide && $E.data('autoHidden') && $E.innerHeight() > 0) {
                        $E.show().data('autoHidden', false);
                        if (!browser.mozilla) // FireFox refreshes iframes - IE does not
                              // make hidden, then visible to 'refresh' display after animation
                              $E.css(_c.hidden).css(_c.visible);
                  }
            }
            else if (autoHide && !$E.data('autoHidden'))
                  $E.hide().data('autoHidden', true);
      }

      /**
      * @param {(string|!Object)}         el
      * @param {number=}                        outerHeight
      * @param {boolean=}                       [autoHide=false]
      */
,     setOuterHeight = function (el, outerHeight, autoHide) {
            var $E = el, h;
            if (isStr(el)) $E = $Ps[el]; // west
            else if (!el.jquery) $E = $(el);
            h = cssH($E, outerHeight);
            $E.css({ height: h, visibility: "visible" }); // may have been 'hidden' by sizeContent
            if (h > 0 && $E.innerWidth() > 0) {
                  if (autoHide && $E.data('autoHidden')) {
                        $E.show().data('autoHidden', false);
                        if (!browser.mozilla) // FireFox refreshes iframes - IE does not
                              $E.css(_c.hidden).css(_c.visible);
                  }
            }
            else if (autoHide && !$E.data('autoHidden'))
                  $E.hide().data('autoHidden', true);
      }


      /**
      * Converts any 'size' params to a pixel/integer size, if not already
      * If 'auto' or a decimal/percentage is passed as 'size', a pixel-size is calculated
      *
      /**
      * @param  {string}                        pane
      * @param  {(string|number)=}  size
      * @param  {string=}                       [dir]
      * @return {number}
      */
,     _parseSize = function (pane, size, dir) {
            if (!dir) dir = _c[pane].dir;

            if (isStr(size) && size.match(/%/))
                  size = (size === '100%') ? -1 : parseInt(size, 10) / 100; // convert % to decimal

            if (size === 0)
                  return 0;
            else if (size >= 1)
                  return parseInt(size, 10);

            var o = options, avail = 0;
            if (dir=="horz") // north or south or center.minHeight
                  avail = sC.innerHeight - ($Ps.north ? o.north.spacing_open : 0) - ($Ps.south ? o.south.spacing_open : 0);
            else if (dir=="vert") // east or west or center.minWidth
                  avail = sC.innerWidth - ($Ps.west ? o.west.spacing_open : 0) - ($Ps.east ? o.east.spacing_open : 0);

            if (size === -1) // -1 == 100%
                  return avail;
            else if (size > 0) // percentage, eg: .25
                  return round(avail * size);
            else if (pane=="center")
                  return 0;
            else { // size < 0 || size=='auto' || size==Missing || size==Invalid
                  // auto-size the pane
                  var   dim   = (dir === "horz" ? "height" : "width")
                  ,     $P    = $Ps[pane]
                  ,     $C    = dim === 'height' ? $Cs[pane] : false
                  ,     vis   = $.layout.showInvisibly($P) // show pane invisibly if hidden
                  ,     szP   = $P.css(dim) // SAVE current pane size
                  ,     szC   = $C ? $C.css(dim) : 0 // SAVE current content size
                  ;
                  $P.css(dim, "auto");
                  if ($C) $C.css(dim, "auto");
                  size = (dim === "height") ? $P.outerHeight() : $P.outerWidth(); // MEASURE
                  $P.css(dim, szP).css(vis); // RESET size & visibility
                  if ($C) $C.css(dim, szC);
                  return size;
            }
      }

      /**
      * Calculates current 'size' (outer-width or outer-height) of a border-pane - optionally with 'pane-spacing' added
      *
      * @param  {(string|!Object)}  pane
      * @param  {boolean=}                [inclSpace=false]
      * @return {number}                        Returns EITHER Width for east/west panes OR Height for north/south panes
      */
,     getPaneSize = function (pane, inclSpace) {
            var 
                  $P    = $Ps[pane]
            ,     o     = options[pane]
            ,     s     = state[pane]
            ,     oSp   = (inclSpace ? o.spacing_open : 0)
            ,     cSp   = (inclSpace ? o.spacing_closed : 0)
            ;
            if (!$P || s.isHidden)
                  return 0;
            else if (s.isClosed || (s.isSliding && inclSpace))
                  return cSp;
            else if (_c[pane].dir === "horz")
                  return $P.outerHeight() + oSp;
            else // dir === "vert"
                  return $P.outerWidth() + oSp;
      }

      /**
      * Calculate min/max pane dimensions and limits for resizing
      *
      * @param  {string}            pane
      * @param  {boolean=}    [slide=false]
      */
,     setSizeLimits = function (pane, slide) {
            if (!isInitialized()) return;
            var 
                  o                       = options[pane]
            ,     s                       = state[pane]
            ,     c                       = _c[pane]
            ,     dir                     = c.dir
            ,     type              = c.sizeType.toLowerCase()
            ,     isSliding         = (slide != undefined ? slide : s.isSliding) // only open() passes 'slide' param
            ,     $P                      = $Ps[pane]
            ,     paneSpacing       = o.spacing_open
            //    measure the pane on the *opposite side* from this pane
            ,     altPane                 = _c.oppositeEdge[pane]
            ,     altS              = state[altPane]
            ,     $altP             = $Ps[altPane]
            ,     altPaneSize       = (!$altP || altS.isVisible===false || altS.isSliding ? 0 : (dir=="horz" ? $altP.outerHeight() : $altP.outerWidth()))
            ,     altPaneSpacing    = ((!$altP || altS.isHidden ? 0 : options[altPane][ altS.isClosed !== false ? "spacing_closed" : "spacing_open" ]) || 0)
            //    limitSize prevents this pane from 'overlapping' opposite pane
            ,     containerSize     = (dir=="horz" ? sC.innerHeight : sC.innerWidth)
            ,     minCenterDims     = cssMinDims("center")
            ,     minCenterSize     = dir=="horz" ? max(options.center.minHeight, minCenterDims.minHeight) : max(options.center.minWidth, minCenterDims.minWidth)
            //    if pane is 'sliding', then ignore center and alt-pane sizes - because 'overlays' them
            ,     limitSize         = (containerSize - paneSpacing - (isSliding ? 0 : (_parseSize("center", minCenterSize, dir) + altPaneSize + altPaneSpacing)))
            ,     minSize                 = s.minSize = max( _parseSize(pane, o.minSize), cssMinDims(pane).minSize )
            ,     maxSize                 = s.maxSize = min( (o.maxSize ? _parseSize(pane, o.maxSize) : 100000), limitSize )
            ,     r                       = s.resizerPosition = {} // used to set resizing limits
            ,     top                     = sC.inset.top
            ,     left              = sC.inset.left
            ,     W                       = sC.innerWidth
            ,     H                       = sC.innerHeight
            ,     rW                      = o.spacing_open // subtract resizer-width to get top/left position for south/east
            ;
            switch (pane) {
                  case "north":     r.min = top + minSize;
                                          r.max = top + maxSize;
                                          break;
                  case "west":      r.min = left + minSize;
                                          r.max = left + maxSize;
                                          break;
                  case "south":     r.min = top + H - maxSize - rW;
                                          r.max = top + H - minSize - rW;
                                          break;
                  case "east":      r.min = left + W - maxSize - rW;
                                          r.max = left + W - minSize - rW;
                                          break;
            };
      }

      /**
      * Returns data for setting the size/position of center pane. Also used to set Height for east/west panes
      *
      * @return JSON  Returns a hash of all dimensions: top, bottom, left, right, (outer) width and (outer) height
      */
,     calcNewCenterPaneDims = function () {
            var d = {
                  top:  getPaneSize("north", true) // true = include 'spacing' value for pane
            ,     bottom:     getPaneSize("south", true)
            ,     left: getPaneSize("west", true)
            ,     right:      getPaneSize("east", true)
            ,     width:      0
            ,     height:     0
            };

            // NOTE: sC = state.container
            // calc center-pane outer dimensions
            d.width           = sC.innerWidth - d.left - d.right;  // outerWidth
            d.height    = sC.innerHeight - d.bottom - d.top; // outerHeight
            // add the 'container border/padding' to get final positions relative to the container
            d.top       += sC.inset.top;
            d.bottom    += sC.inset.bottom;
            d.left            += sC.inset.left;
            d.right           += sC.inset.right;

            return d;
      }


      /**
      * @param {!Object}            el
      * @param {boolean=}           [allStates=false]
      */
,     getHoverClasses = function (el, allStates) {
            var
                  $El         = $(el)
            ,     type  = $El.data("layoutRole")
            ,     pane  = $El.data("layoutEdge")
            ,     o           = options[pane]
            ,     root  = o[type +"Class"]
            ,     _pane = "-"+ pane // eg: "-west"
            ,     _open = "-open"
            ,     _closed     = "-closed"
            ,     _slide      = "-sliding"
            ,     _hover      = "-hover " // NOTE the trailing space
            ,     _state      = $El.hasClass(root+_closed) ? _closed : _open
            ,     _alt  = _state === _closed ? _open : _closed
            ,     classes = (root+_hover) + (root+_pane+_hover) + (root+_state+_hover) + (root+_pane+_state+_hover)
            ;
            if (allStates) // when 'removing' classes, also remove alternate-state classes
                  classes += (root+_alt+_hover) + (root+_pane+_alt+_hover);

            if (type=="resizer" && $El.hasClass(root+_slide))
                  classes += (root+_slide+_hover) + (root+_pane+_slide+_hover);

            return $.trim(classes);
      }
,     addHover    = function (evt, el) {
            var $E = $(el || this);
            if (evt && $E.data("layoutRole") === "toggler")
                  evt.stopPropagation(); // prevent triggering 'slide' on Resizer-bar
            $E.addClass( getHoverClasses($E) );
      }
,     removeHover = function (evt, el) {
            var $E = $(el || this);
            $E.removeClass( getHoverClasses($E, true) );
      }

,     onResizerEnter    = function (evt) { // ALSO called by toggler.mouseenter
            var pane    = $(this).data("layoutEdge")
            ,     s           = state[pane]
            ;
            // ignore closed-panes and mouse moving back & forth over resizer!
            // also ignore if ANY pane is currently resizing
            if ( s.isClosed || s.isResizing || state.paneResizing ) return;

            if ($.fn.disableSelection)
                  $("body").disableSelection();
            if (options.maskPanesEarly)
                  showMasks( pane, { resizing: true });
      }
,     onResizerLeave    = function (evt, el) {
            var   e           = el || this // el is only passed when called by the timer
            ,     pane  = $(e).data("layoutEdge")
            ,     name  = pane +"ResizerLeave"
            ;
            timer.clear(pane+"_openSlider"); // cancel slideOpen timer, if set
            timer.clear(name); // cancel enableSelection timer - may re/set below
            // this method calls itself on a timer because it needs to allow
            // enough time for dragging to kick-in and set the isResizing flag
            // dragging has a 100ms delay set, so this delay must be >100
            if (!el) // 1st call - mouseleave event
                  timer.set(name, function(){ onResizerLeave(evt, e); }, 200);
            // if user is resizing, then dragStop will enableSelection(), so can skip it here
            else if ( !state.paneResizing ) { // 2nd call - by timer
                  if ($.fn.enableSelection)
                        $("body").enableSelection();
                  if (options.maskPanesEarly)
                        hideMasks();
            }
      }

/*
 * ###########################
 *   INITIALIZATION METHODS
 * ###########################
 */

      /**
      * Initialize the layout - called automatically whenever an instance of layout is created
      *
      * @see  none - triggered onInit
      * @return  mixed  true = fully initialized | false = panes not initialized (yet) | 'cancel' = abort
      */
,     _create = function () {
            // initialize config/options
            initOptions();
            var o = options
            ,     s = state;

            // TEMP state so isInitialized returns true during init process
            s.creatingLayout = true;

            // init plugins for this layout, if there are any (eg: stateManagement)
            runPluginCallbacks( Instance, $.layout.onCreate );

            // options & state have been initialized, so now run beforeLoad callback
            // onload will CANCEL layout creation if it returns false
            if (false === _runCallbacks("onload_start"))
                  return 'cancel';

            // initialize the container element
            _initContainer();

            // bind hotkey function - keyDown - if required
            initHotkeys();

            // bind window.onunload
            $(window).bind("unload."+ sID, unload);

            // init plugins for this layout, if there are any (eg: customButtons)
            runPluginCallbacks( Instance, $.layout.onLoad );

            // if layout elements are hidden, then layout WILL NOT complete initialization!
            // initLayoutElements will set initialized=true and run the onload callback IF successful
            if (o.initPanes) _initLayoutElements();

            delete s.creatingLayout;

            return state.initialized;
      }

      /**
      * Initialize the layout IF not already
      *
      * @see  All methods in Instance run this test
      * @return  boolean      true = layoutElements have been initialized | false = panes are not initialized (yet)
      */
,     isInitialized = function () {
            if (state.initialized || state.creatingLayout) return true; // already initialized
            else return _initLayoutElements();  // try to init panes NOW
      }

      /**
      * Initialize the layout - called automatically whenever an instance of layout is created
      *
      * @see  _create() & isInitialized
      * @param {boolean=}           [retry=false]     // indicates this is a 2nd try
      * @return  An object pointer to the instance created
      */
,     _initLayoutElements = function (retry) {
            // initialize config/options
            var o = options;
            // CANNOT init panes inside a hidden container!
            if (!$N.is(":visible")) {
                  // handle Chrome bug where popup window 'has no height'
                  // if layout is BODY element, try again in 50ms
                  // SEE: http://layout.jquery-dev.net/samples/test_popup_window.html
                  if ( !retry && browser.webkit && $N[0].tagName === "BODY" )
                        setTimeout(function(){ _initLayoutElements(true); }, 50);
                  return false;
            }

            // a center pane is required, so make sure it exists
            if (!getPane("center").length) {
                  return _log( o.errors.centerPaneMissing );
            }

            // TEMP state so isInitialized returns true during init process
            state.creatingLayout = true;

            // update Container dims
            $.extend(sC, elDims( $N, o.inset )); // passing inset means DO NOT include insetX values

            // initialize all layout elements
            initPanes();      // size & position panes - calls initHandles() - which calls initResizable()

            if (o.scrollToBookmarkOnLoad) {
                  var l = self.location;
                  if (l.hash) l.replace( l.hash ); // scrollTo Bookmark
            }

            // check to see if this layout 'nested' inside a pane
            if (Instance.hasParentLayout)
                  o.resizeWithWindow = false;
            // bind resizeAll() for 'this layout instance' to window.resize event
            else if (o.resizeWithWindow)
                  $(window).bind("resize."+ sID, windowResize);

            delete state.creatingLayout;
            state.initialized = true;

            // init plugins for this layout, if there are any
            runPluginCallbacks( Instance, $.layout.onReady );

            // now run the onload callback, if exists
            _runCallbacks("onload_end");

            return true; // elements initialized successfully
      }

      /**
      * Initialize nested layouts for a specific pane - can optionally pass layout-options
      *
      * @param {(string|Object)}    evt_or_pane The pane being opened, ie: north, south, east, or west
      * @param {Object=}                  [opts]            Layout-options - if passed, will OVERRRIDE options[pane].children
      * @return  An object pointer to the layout instance created - or null
      */
,     createChildren = function (evt_or_pane, opts) {
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $P    = $Ps[pane]
            ;
            if (!$P) return;
            var   $C    = $Cs[pane]
            ,     s     = state[pane]
            ,     o     = options[pane]
            ,     sm    = options.stateManagement || {}
            ,     cos = opts ? (o.children = opts) : o.children
            ;
            if ( $.isPlainObject( cos ) )
                  cos = [ cos ]; // convert a hash to a 1-elem array
            else if (!cos || !$.isArray( cos ))
                  return;

            $.each( cos, function (idx, co) {
                  if ( !$.isPlainObject( co ) ) return;

                  // determine which element is supposed to be the 'child container'
                  // if pane has a 'containerSelector' OR a 'content-div', use those instead of the pane
                  var $containers = co.containerSelector ? $P.find( co.containerSelector ) : ($C || $P);

                  $containers.each(function(){
                        var $cont   = $(this)
                        ,     child = $cont.data("layout") //     see if a child-layout ALREADY exists on this element
                        ;
                        // if no layout exists, but children are set, try to create the layout now
                        if (!child) {
                              // TODO: see about moving this to the stateManagement plugin, as a method
                              // set a unique child-instance key for this layout, if not already set
                              setInstanceKey({ container: $cont, options: co }, s );
                              // If THIS layout has a hash in stateManagement.autoLoad,
                              // then see if it also contains state-data for this child-layout
                              // If so, copy the stateData to child.options.stateManagement.autoLoad
                              if ( sm.includeChildren && state.stateData[pane] ) {
                                    //    THIS layout's state was cached when its state was loaded
                                    var   paneChildren = state.stateData[pane].children || {}
                                    ,     childState  = paneChildren[ co.instanceKey ]
                                    ,     co_sm       = co.stateManagement || (co.stateManagement = { autoLoad: true })
                                    ;
                                    // COPY the stateData into the autoLoad key
                                    if ( co_sm.autoLoad === true && childState ) {
                                          co_sm.autoSave                = false; // disable autoSave because saving handled by parent-layout
                                          co_sm.includeChildren   = true;  // cascade option - FOR NOW
                                          co_sm.autoLoad = $.extend(true, {}, childState); // COPY the state-hash
                                    }
                              }

                              // create the layout
                              child = $cont.layout( co );

                              // if successful, update data
                              if (child) {
                                    // add the child and update all layout-pointers
                                    // MAY have already been done by child-layout calling parent.refreshChildren()
                                    refreshChildren( pane, child );
                              }
                        }
                  });
            });
      }

,     setInstanceKey = function (child, parentPaneState) {
            // create a named key for use in state and instance branches
            var   $c    = child.container
            ,     o     = child.options
            ,     sm    = o.stateManagement
            ,     key   = o.instanceKey || $c.data("layoutInstanceKey")
            ;
            if (!key) key = (sm && sm.cookie ? sm.cookie.name : '') || o.name; // look for a name/key
            if (!key) key = "layout"+ (++parentPaneState.childIdx);     // if no name/key found, generate one
            else key = key.replace(/[^\w-]/gi, '_').replace(/_{2,}/g, '_');    // ensure is valid as a hash key
            o.instanceKey = key;
            $c.data("layoutInstanceKey", key); // useful if layout is destroyed and then recreated
            return key;
      }

      /**
      * @param {string}       pane        The pane being opened, ie: north, south, east, or west
      * @param {Object=}            newChild    New child-layout Instance to add to this pane
      */
,     refreshChildren = function (pane, newChild) {
            var   $P    = $Ps[pane]
            ,     pC    = children[pane]
            ,     s     = state[pane]
            ,     o
            ;
            // check for destroy()ed layouts and update the child pointers & arrays
            if ($.isPlainObject( pC )) {
                  $.each( pC, function (key, child) {
                        if (child.destroyed) delete pC[key]
                  });
                  // if no more children, remove the children hash
                  if ($.isEmptyObject( pC ))
                        pC = children[pane] = null; // clear children hash
            }

            // see if there is a directly-nested layout inside this pane
            // if there is, then there can be only ONE child-layout, so check that...
            if (!newChild && !pC) {
                  newChild = $P.data("layout");
            }

            // if a newChild instance was passed, add it to children[pane]
            if (newChild) {
                  // update child.state
                  newChild.hasParentLayout = true; // set parent-flag in child
                  // instanceKey is a key-name used in both state and children
                  o = newChild.options;
                  // set a unique child-instance key for this layout, if not already set
                  setInstanceKey( newChild, s );
                  // add pointer to pane.children hash
                  if (!pC) pC = children[pane] = {}; // create an empty children hash
                  pC[ o.instanceKey ] = newChild.container.data("layout"); // add childLayout instance
            }

            // ALWAYS refresh the pane.children alias, even if null
            Instance[pane].children = children[pane];

            // if newChild was NOT passed - see if there is a child layout NOW
            if (!newChild) {
                  createChildren(pane); // MAY create a child and re-call this method
            }
      }

,     windowResize = function () {
            var   o = options
            ,     delay = Number(o.resizeWithWindowDelay);
            if (delay < 10) delay = 100; // MUST have a delay!
            // resizing uses a delay-loop because the resize event fires repeatly - except in FF, but delay anyway
            timer.clear("winResize"); // if already running
            timer.set("winResize", function(){
                  timer.clear("winResize");
                  timer.clear("winResizeRepeater");
                  var dims = elDims( $N, o.inset );
                  // only trigger resizeAll() if container has changed size
                  if (dims.innerWidth !== sC.innerWidth || dims.innerHeight !== sC.innerHeight)
                        resizeAll();
            }, delay);
            // ALSO set fixed-delay timer, if not already running
            if (!timer.data["winResizeRepeater"]) setWindowResizeRepeater();
      }

,     setWindowResizeRepeater = function () {
            var delay = Number(options.resizeWithWindowMaxDelay);
            if (delay > 0)
                  timer.set("winResizeRepeater", function(){ setWindowResizeRepeater(); resizeAll(); }, delay);
      }

,     unload = function () {
            var o = options;

            _runCallbacks("onunload_start");

            // trigger plugin callabacks for this layout (eg: stateManagement)
            runPluginCallbacks( Instance, $.layout.onUnload );

            _runCallbacks("onunload_end");
      }

      /**
      * Validate and initialize container CSS and events
      *
      * @see  _create()
      */
,     _initContainer = function () {
            var
                  N           = $N[0]     
            ,     $H          = $("html")
            ,     tag         = sC.tagName = N.tagName
            ,     id          = sC.id = N.id
            ,     cls         = sC.className = N.className
            ,     o           = options
            ,     name  = o.name
            ,     props = "position,margin,padding,border"
            ,     css         = "layoutCSS"
            ,     CSS         = {}
            ,     hid         = "hidden" // used A LOT!
            //    see if this container is a 'pane' inside an outer-layout
            ,     parent      = $N.data("parentLayout")     // parent-layout Instance
            ,     pane  = $N.data("layoutEdge")       // pane-name in parent-layout
            ,     isChild     = parent && pane
            ,     num         = $.layout.cssNum
            ,     $parent, n
            ;
            // sC = state.container
            sC.selector = $N.selector.split(".slice")[0];
            sC.ref            = (o.name ? o.name +' layout / ' : '') + tag + (id ? "#"+id : cls ? '.['+cls+']' : ''); // used in messages
            sC.isBody   = (tag === "BODY");

            // try to find a parent-layout
            if (!isChild && !sC.isBody) {
                  $parent = $N.closest("."+ $.layout.defaults.panes.paneClass);
                  parent      = $parent.data("parentLayout");
                  pane  = $parent.data("layoutEdge");
                  isChild     = parent && pane;
            }

            $N    .data({
                        layout: Instance
                  ,     layoutContainer: sID // FLAG to indicate this is a layout-container - contains unique internal ID
                  })
                  .addClass(o.containerClass)
            ;
            var layoutMethods = {
                  destroy:    ''
            ,     initPanes:  ''
            ,     resizeAll:  'resizeAll'
            ,     resize:           'resizeAll'
            };
            // loop hash and bind all methods - include layoutID namespacing
            for (name in layoutMethods) {
                  $N.bind("layout"+ name.toLowerCase() +"."+ sID, Instance[ layoutMethods[name] || name ]);
            }

            // if this container is another layout's 'pane', then set child/parent pointers
            if (isChild) {
                  // update parent flag
                  Instance.hasParentLayout = true;
                  // set pointers to THIS child-layout (Instance) in parent-layout
                  parent.refreshChildren( pane, Instance );
            }

            // SAVE original container CSS for use in destroy()
            if (!$N.data(css)) {
                  // handle props like overflow different for BODY & HTML - has 'system default' values
                  if (sC.isBody) {
                        // SAVE <BODY> CSS
                        $N.data(css, $.extend( styles($N, props), {
                              height:           $N.css("height")
                        ,     overflow:   $N.css("overflow")
                        ,     overflowX:  $N.css("overflowX")
                        ,     overflowY:  $N.css("overflowY")
                        }));
                        // ALSO SAVE <HTML> CSS
                        $H.data(css, $.extend( styles($H, 'padding'), {
                              height:           "auto" // FF would return a fixed px-size!
                        ,     overflow:   $H.css("overflow")
                        ,     overflowX:  $H.css("overflowX")
                        ,     overflowY:  $H.css("overflowY")
                        }));
                  }
                  else // handle props normally for non-body elements
                        $N.data(css, styles($N, props+",top,bottom,left,right,width,height,overflow,overflowX,overflowY") );
            }

            try {
                  // common container CSS
                  CSS = {
                        overflow:   hid
                  ,     overflowX:  hid
                  ,     overflowY:  hid
                  };
                  $N.css( CSS );

                  if (o.inset && !$.isPlainObject(o.inset)) {
                        // can specify a single number for equal outset all-around
                        n = parseInt(o.inset, 10) || 0
                        o.inset = {
                              top:  n
                        ,     bottom:     n
                        ,     left: n
                        ,     right:      n
                        };
                  }

                  // format html & body if this is a full page layout
                  if (sC.isBody) {
                        // if HTML has padding, use this as an outer-spacing around BODY
                        if (!o.outset) {
                              // use padding from parent-elem (HTML) as outset
                              o.outset = {
                                    top:  num($H, "paddingTop")
                              ,     bottom:     num($H, "paddingBottom")
                              ,     left: num($H, "paddingLeft")
                              ,     right:      num($H, "paddingRight")
                              };
                        }
                        else if (!$.isPlainObject(o.outset)) {
                              // can specify a single number for equal outset all-around
                              n = parseInt(o.outset, 10) || 0
                              o.outset = {
                                    top:  n
                              ,     bottom:     n
                              ,     left: n
                              ,     right:      n
                              };
                        }
                        // HTML
                        $H.css( CSS ).css({
                              height:           "100%"
                        ,     border:           "none"      // no border or padding allowed when using height = 100%
                        ,     padding:    0           // ditto
                        ,     margin:           0
                        });
                        // BODY
                        if (browser.isIE6) {
                              // IE6 CANNOT use the trick of setting absolute positioning on all 4 sides - must have 'height'
                              $N.css({
                                    width:            "100%"
                              ,     height:           "100%"
                              ,     border:           "none"      // no border or padding allowed when using height = 100%
                              ,     padding:    0           // ditto
                              ,     margin:           0
                              ,     position:   "relative"
                              });
                              // convert body padding to an inset option - the border cannot be measured in IE6!
                              if (!o.inset) o.inset = elDims( $N ).inset;
                        }
                        else { // use absolute positioning for BODY to allow borders & padding without overflow
                              $N.css({
                                    width:            "auto"
                              ,     height:           "auto"
                              ,     margin:           0
                              ,     position:   "absolute"  // allows for border and padding on BODY
                              });
                              // apply edge-positioning created above
                              $N.css( o.outset );
                        }
                        // set current layout-container dimensions
                        $.extend(sC, elDims( $N, o.inset )); // passing inset means DO NOT include insetX values
                  }
                  else {
                        // container MUST have 'position'
                        var   p = $N.css("position");
                        if (!p || !p.match(/(fixed|absolute|relative)/))
                              $N.css("position","relative");

                        // set current layout-container dimensions
                        if ( $N.is(":visible") ) {
                              $.extend(sC, elDims( $N, o.inset )); // passing inset means DO NOT change insetX (padding) values
                              if (sC.innerHeight < 1) // container has no 'height' - warn developer
                                    _log( o.errors.noContainerHeight.replace(/CONTAINER/, sC.ref) );
                        }
                  }

                  // if container has min-width/height, then enable scrollbar(s)
                  if ( num($N, "minWidth")  ) $N.parent().css("overflowX","auto");
                  if ( num($N, "minHeight") ) $N.parent().css("overflowY","auto");

            } catch (ex) {}
      }

      /**
      * Bind layout hotkeys - if options enabled
      *
      * @see  _create() and addPane()
      * @param {string=}      [panes=""]  The edge(s) to process
      */
,     initHotkeys = function (panes) {
            panes = panes ? panes.split(",") : _c.borderPanes;
            // bind keyDown to capture hotkeys, if option enabled for ANY pane
            $.each(panes, function (i, pane) {
                  var o = options[pane];
                  if (o.enableCursorHotkey || o.customHotkey) {
                        $(document).bind("keydown."+ sID, keyDown); // only need to bind this ONCE
                        return false; // BREAK - binding was done
                  }
            });
      }

      /**
      * Build final OPTIONS data
      *
      * @see  _create()
      */
,     initOptions = function () {
            var data, d, pane, key, val, i, c, o;

            // reprocess user's layout-options to have correct options sub-key structure
            opts = $.layout.transformData( opts, true ); // panes = default subkey

            // auto-rename old options for backward compatibility
            opts = $.layout.backwardCompatibility.renameAllOptions( opts );

            // if user-options has 'panes' key (pane-defaults), clean it...
            if (!$.isEmptyObject(opts.panes)) {
                  // REMOVE any pane-defaults that MUST be set per-pane
                  data = $.layout.optionsMap.noDefault;
                  for (i=0, c=data.length; i<c; i++) {
                        key = data[i];
                        delete opts.panes[key]; // OK if does not exist
                  }
                  // REMOVE any layout-options specified under opts.panes
                  data = $.layout.optionsMap.layout;
                  for (i=0, c=data.length; i<c; i++) {
                        key = data[i];
                        delete opts.panes[key]; // OK if does not exist
                  }
            }

            // MOVE any NON-layout-options from opts-root to opts.panes
            data = $.layout.optionsMap.layout;
            var rootKeys = $.layout.config.optionRootKeys;
            for (key in opts) {
                  val = opts[key];
                  if ($.inArray(key, rootKeys) < 0 && $.inArray(key, data) < 0) {
                        if (!opts.panes[key])
                              opts.panes[key] = $.isPlainObject(val) ? $.extend(true, {}, val) : val;
                        delete opts[key]
                  }
            }

            // START by updating ALL options from opts
            $.extend(true, options, opts);

            // CREATE final options (and config) for EACH pane
            $.each(_c.allPanes, function (i, pane) {

                  // apply 'pane-defaults' to CONFIG.[PANE]
                  _c[pane] = $.extend(true, {}, _c.panes, _c[pane]);

                  d = options.panes;
                  o = options[pane];

                  // center-pane uses SOME keys in defaults.panes branch
                  if (pane === 'center') {
                        // ONLY copy keys from opts.panes listed in: $.layout.optionsMap.center
                        data = $.layout.optionsMap.center;        // list of 'center-pane keys'
                        for (i=0, c=data.length; i<c; i++) {      // loop the list...
                              key = data[i];
                              // only need to use pane-default if pane-specific value not set
                              if (!opts.center[key] && (opts.panes[key] || !o[key]))
                                    o[key] = d[key]; // pane-default
                        }
                  }
                  else {
                        // border-panes use ALL keys in defaults.panes branch
                        o = options[pane] = $.extend(true, {}, d, o); // re-apply pane-specific opts AFTER pane-defaults
                        createFxOptions( pane );
                        // ensure all border-pane-specific base-classes exist
                        if (!o.resizerClass)    o.resizerClass    = "ui-layout-resizer";
                        if (!o.togglerClass)    o.togglerClass    = "ui-layout-toggler";
                  }
                  // ensure we have base pane-class (ALL panes)
                  if (!o.paneClass) o.paneClass = "ui-layout-pane";
            });

            // update options.zIndexes if a zIndex-option specified
            var zo      = opts.zIndex
            ,     z     = options.zIndexes;
            if (zo > 0) {
                  z.pane_normal           = zo;
                  z.content_mask          = max(zo+1, z.content_mask);  // MIN = +1
                  z.resizer_normal  = max(zo+2, z.resizer_normal);      // MIN = +2
            }

            // DELETE 'panes' key now that we are done - values were copied to EACH pane
            delete options.panes;


            function createFxOptions ( pane ) {
                  var   o = options[pane]
                  ,     d = options.panes;
                  // ensure fxSettings key to avoid errors
                  if (!o.fxSettings) o.fxSettings = {};
                  if (!d.fxSettings) d.fxSettings = {};

                  $.each(["_open","_close","_size"], function (i,n) { 
                        var
                              sName       = "fxName"+ n
                        ,     sSpeed            = "fxSpeed"+ n
                        ,     sSettings   = "fxSettings"+ n
                              // recalculate fxName according to specificity rules
                        ,     fxName = o[sName] =
                                    o[sName]    // options.west.fxName_open
                              ||    d[sName]    // options.panes.fxName_open
                              ||    o.fxName    // options.west.fxName
                              ||    d.fxName    // options.panes.fxName
                              ||    "none"            // MEANS $.layout.defaults.panes.fxName == "" || false || null || 0
                        ,     fxExists    = $.effects && ($.effects[fxName] || ($.effects.effect && $.effects.effect[fxName]))
                        ;
                        // validate fxName to ensure is valid effect - MUST have effect-config data in options.effects
                        if (fxName === "none" || !options.effects[fxName] || !fxExists)
                              fxName = o[sName] = "none"; // effect not loaded OR unrecognized fxName

                        // set vars for effects subkeys to simplify logic
                        var   fx          = options.effects[fxName] || {}     // effects.slide
                        ,     fx_all      = fx.all    || null                       // effects.slide.all
                        ,     fx_pane     = fx[pane]  || null                       // effects.slide.west
                        ;
                        // create fxSpeed[_open|_close|_size]
                        o[sSpeed] =
                              o[sSpeed]                     // options.west.fxSpeed_open
                        ||    d[sSpeed]                     // options.west.fxSpeed_open
                        ||    o.fxSpeed                     // options.west.fxSpeed
                        ||    d.fxSpeed                     // options.panes.fxSpeed
                        ||    null                          // DEFAULT - let fxSetting.duration control speed
                        ;
                        // create fxSettings[_open|_close|_size]
                        o[sSettings] = $.extend(
                              true
                        ,     {}
                        ,     fx_all                              // effects.slide.all
                        ,     fx_pane                             // effects.slide.west
                        ,     d.fxSettings                  // options.panes.fxSettings
                        ,     o.fxSettings                  // options.west.fxSettings
                        ,     d[sSettings]                  // options.panes.fxSettings_open
                        ,     o[sSettings]                  // options.west.fxSettings_open
                        );
                  });

                  // DONE creating action-specific-settings for this pane,
                  // so DELETE generic options - are no longer meaningful
                  delete o.fxName;
                  delete o.fxSpeed;
                  delete o.fxSettings;
            }
      }

      /**
      * Initialize module objects, styling, size and position for all panes
      *
      * @see  _initElements()
      * @param {string} pane        The pane to process
      */
,     getPane = function (pane) {
            var sel = options[pane].paneSelector
            if (sel.substr(0,1)==="#") // ID selector
                  // NOTE: elements selected 'by ID' DO NOT have to be 'children'
                  return $N.find(sel).eq(0);
            else { // class or other selector
                  var $P = $N.children(sel).eq(0);
                  // look for the pane nested inside a 'form' element
                  return $P.length ? $P : $N.children("form:first").children(sel).eq(0);
            }
      }

      /**
      * @param {Object=}            evt
      */
,     initPanes = function (evt) {
            // stopPropagation if called by trigger("layoutinitpanes") - use evtPane utility 
            evtPane(evt);

            // NOTE: do north & south FIRST so we can measure their height - do center LAST
            $.each(_c.allPanes, function (idx, pane) {
                  addPane( pane, true );
            });

            // init the pane-handles NOW in case we have to hide or close the pane below
            initHandles();

            // now that all panes have been initialized and initially-sized,
            // make sure there is really enough space available for each pane
            $.each(_c.borderPanes, function (i, pane) {
                  if ($Ps[pane] && state[pane].isVisible) { // pane is OPEN
                        setSizeLimits(pane);
                        makePaneFit(pane); // pane may be Closed, Hidden or Resized by makePaneFit()
                  }
            });
            // size center-pane AGAIN in case we 'closed' a border-pane in loop above
            sizeMidPanes("center");

            //    Chrome/Webkit sometimes fires callbacks BEFORE it completes resizing!
            //    Before RC30.3, there was a 10ms delay here, but that caused layout 
            //    to load asynchrously, which is BAD, so try skipping delay for now

            // process pane contents and callbacks, and init/resize child-layout if exists
            $.each(_c.allPanes, function (idx, pane) {
                  afterInitPane(pane);
            });
      }

      /**
      * Add a pane to the layout - subroutine of initPanes()
      *
      * @see  initPanes()
      * @param {string} pane              The pane to process
      * @param {boolean=}     [force=false]     Size content after init
      */
,     addPane = function (pane, force) {
            if (!force && !isInitialized()) return;
            var
                  o           = options[pane]
            ,     s           = state[pane]
            ,     c           = _c[pane]
            ,     dir         = c.dir
            ,     fx          = s.fx
            ,     spacing     = o.spacing_open || 0
            ,     isCenter = (pane === "center")
            ,     CSS         = {}
            ,     $P          = $Ps[pane]
            ,     size, minSize, maxSize, child
            ;
            // if pane-pointer already exists, remove the old one first
            if ($P)
                  removePane( pane, false, true, false );
            else
                  $Cs[pane] = false; // init

            $P = $Ps[pane] = getPane(pane);
            if (!$P.length) {
                  $Ps[pane] = false; // logic
                  return;
            }

            // SAVE original Pane CSS
            if (!$P.data("layoutCSS")) {
                  var props = "position,top,left,bottom,right,width,height,overflow,zIndex,display,backgroundColor,padding,margin,border";
                  $P.data("layoutCSS", styles($P, props));
            }

            // create alias for pane data in Instance - initHandles will add more
            Instance[pane] = {
                  name:       pane
            ,     pane:       $Ps[pane]
            ,     content:    $Cs[pane]
            ,     options:    options[pane]
            ,     state:            state[pane]
            ,     children:   children[pane]
            };

            // add classes, attributes & events
            $P    .data({
                        parentLayout:     Instance          // pointer to Layout Instance
                  ,     layoutPane:       Instance[pane]    // NEW pointer to pane-alias-object
                  ,     layoutEdge:       pane
                  ,     layoutRole:       "pane"
                  })
                  .css(c.cssReq).css("zIndex", options.zIndexes.pane_normal)
                  .css(o.applyDemoStyles ? c.cssDemo : {}) // demo styles
                  .addClass( o.paneClass +" "+ o.paneClass+"-"+pane ) // default = "ui-layout-pane ui-layout-pane-west" - may be a dupe of 'paneSelector'
                  .bind("mouseenter."+ sID, addHover )
                  .bind("mouseleave."+ sID, removeHover )
                  ;
            var paneMethods = {
                        hide:                   ''
                  ,     show:                   ''
                  ,     toggle:                       ''
                  ,     close:                        ''
                  ,     open:                   ''
                  ,     slideOpen:              ''
                  ,     slideClose:             ''
                  ,     slideToggle:            ''
                  ,     size:                   'sizePane'
                  ,     sizePane:               'sizePane'
                  ,     sizeContent:            ''
                  ,     sizeHandles:            ''
                  ,     enableClosable:         ''
                  ,     disableClosable:  ''
                  ,     enableSlideable:  ''
                  ,     disableSlideable: ''
                  ,     enableResizable:  ''
                  ,     disableResizable: ''
                  ,     swapPanes:              'swapPanes'
                  ,     swap:                   'swapPanes'
                  ,     move:                   'swapPanes'
                  ,     removePane:             'removePane'
                  ,     remove:                       'removePane'
                  ,     createChildren:         ''
                  ,     resizeChildren:         ''
                  ,     resizeAll:              'resizeAll'
                  ,     resizeLayout:           'resizeAll'
                  }
            ,     name;
            // loop hash and bind all methods - include layoutID namespacing
            for (name in paneMethods) {
                  $P.bind("layoutpane"+ name.toLowerCase() +"."+ sID, Instance[ paneMethods[name] || name ]);
            }

            // see if this pane has a 'scrolling-content element'
            initContent(pane, false); // false = do NOT sizeContent() - called later

            if (!isCenter) {
                  // call _parseSize AFTER applying pane classes & styles - but before making visible (if hidden)
                  // if o.size is auto or not valid, then MEASURE the pane and use that as its 'size'
                  size  = s.size = _parseSize(pane, o.size);
                  minSize     = _parseSize(pane,o.minSize) || 1;
                  maxSize     = _parseSize(pane,o.maxSize) || 100000;
                  if (size > 0) size = max(min(size, maxSize), minSize);
                  s.autoResize = o.autoResize; // used with percentage sizes

                  // state for border-panes
                  s.isClosed  = false; // true = pane is closed
                  s.isSliding = false; // true = pane is currently open by 'sliding' over adjacent panes
                  s.isResizing= false; // true = pane is in process of being resized
                  s.isHidden  = false; // true = pane is hidden - no spacing, resizer or toggler is visible!

                  // array for 'pin buttons' whose classNames are auto-updated on pane-open/-close
                  if (!s.pins) s.pins = [];
            }
            //    states common to ALL panes
            s.tagName   = $P[0].tagName;
            s.edge            = pane;           // useful if pane is (or about to be) 'swapped' - easy find out where it is (or is going)
            s.noRoom    = false;    // true = pane 'automatically' hidden due to insufficient room - will unhide automatically
            s.isVisible = true;           // false = pane is invisible - closed OR hidden - simplify logic

            // init pane positioning
            setPanePosition( pane );

            // if pane is not visible, 
            if (dir === "horz") // north or south pane
                  CSS.height = cssH($P, size);
            else if (dir === "vert") // east or west pane
                  CSS.width = cssW($P, size);
            //else if (isCenter) {}

            $P.css(CSS); // apply size -- top, bottom & height will be set by sizeMidPanes
            if (dir != "horz") sizeMidPanes(pane, true); // true = skipCallback

            // if manually adding a pane AFTER layout initialization, then...
            if (state.initialized) {
                  initHandles( pane );
                  initHotkeys( pane );
            }

            // close or hide the pane if specified in settings
            if (o.initClosed && o.closable && !o.initHidden)
                  close(pane, true, true); // true, true = force, noAnimation
            else if (o.initHidden || o.initClosed)
                  hide(pane); // will be completely invisible - no resizer or spacing
            else if (!s.noRoom)
                  // make the pane visible - in case was initially hidden
                  $P.css("display","block");
            // ELSE setAsOpen() - called later by initHandles()

            // RESET visibility now - pane will appear IF display:block
            $P.css("visibility","visible");

            // check option for auto-handling of pop-ups & drop-downs
            if (o.showOverflowOnHover)
                  $P.hover( allowOverflow, resetOverflow );

            // if manually adding a pane AFTER layout initialization, then...
            if (state.initialized) {
                  afterInitPane( pane );
            }
      }

,     afterInitPane = function (pane) {
            var   $P    = $Ps[pane]
            ,     s     = state[pane]
            ,     o     = options[pane]
            ;
            if (!$P) return;

            // see if there is a directly-nested layout inside this pane
            if ($P.data("layout"))
                  refreshChildren( pane, $P.data("layout") );

            // process pane contents and callbacks, and init/resize child-layout if exists
            if (s.isVisible) { // pane is OPEN
                  if (state.initialized) // this pane was added AFTER layout was created
                        resizeAll(); // will also sizeContent
                  else
                        sizeContent(pane);

                  if (o.triggerEventsOnLoad)
                        _runCallbacks("onresize_end", pane);
                  else // automatic if onresize called, otherwise call it specifically
                        // resize child - IF inner-layout already exists (created before this layout)
                        resizeChildren(pane, true); // a previously existing childLayout
            }

            // init childLayouts - even if pane is not visible
            if (o.initChildren && o.children)
                  createChildren(pane);
      }

      /**
      * @param {string=}      panes       The pane(s) to process
      */
,     setPanePosition = function (panes) {
            panes = panes ? panes.split(",") : _c.borderPanes;

            // create toggler DIVs for each pane, and set object pointers for them, eg: $R.north = north toggler DIV
            $.each(panes, function (i, pane) {
                  var $P      = $Ps[pane]
                  ,     $R    = $Rs[pane]
                  ,     o     = options[pane]
                  ,     s     = state[pane]
                  ,     side =  _c[pane].side
                  ,     CSS   = {}
                  ;
                  if (!$P) return; // pane does not exist - skip

                  // set css-position to account for container borders & padding
                  switch (pane) {
                        case "north":     CSS.top     = sC.inset.top;
                                                CSS.left    = sC.inset.left;
                                                CSS.right   = sC.inset.right;
                                                break;
                        case "south":     CSS.bottom  = sC.inset.bottom;
                                                CSS.left    = sC.inset.left;
                                                CSS.right   = sC.inset.right;
                                                break;
                        case "west":      CSS.left    = sC.inset.left; // top, bottom & height set by sizeMidPanes()
                                                break;
                        case "east":      CSS.right   = sC.inset.right; // ditto
                                                break;
                        case "center":    // top, left, width & height set by sizeMidPanes()
                  }
                  // apply position
                  $P.css(CSS); 

                  // update resizer position
                  if ($R && s.isClosed)
                        $R.css(side, sC.inset[side]);
                  else if ($R && !s.isHidden)
                        $R.css(side, sC.inset[side] + getPaneSize(pane));
            });
      }

      /**
      * Initialize module objects, styling, size and position for all resize bars and toggler buttons
      *
      * @see  _create()
      * @param {string=}      [panes=""]  The edge(s) to process
      */
,     initHandles = function (panes) {
            panes = panes ? panes.split(",") : _c.borderPanes;

            // create toggler DIVs for each pane, and set object pointers for them, eg: $R.north = north toggler DIV
            $.each(panes, function (i, pane) {
                  var $P            = $Ps[pane];
                  $Rs[pane]   = false; // INIT
                  $Ts[pane]   = false;
                  if (!$P) return; // pane does not exist - skip

                  var   o           = options[pane]
                  ,     s           = state[pane]
                  ,     c           = _c[pane]
                  ,     paneId      = o.paneSelector.substr(0,1) === "#" ? o.paneSelector.substr(1) : ""
                  ,     rClass      = o.resizerClass
                  ,     tClass      = o.togglerClass
                  ,     spacing     = (s.isVisible ? o.spacing_open : o.spacing_closed)
                  ,     _pane = "-"+ pane // used for classNames
                  ,     _state      = (s.isVisible ? "-open" : "-closed") // used for classNames
                  ,     I           = Instance[pane]
                        // INIT RESIZER BAR
                  ,     $R          = I.resizer = $Rs[pane] = $("<div></div>")
                        // INIT TOGGLER BUTTON
                  ,     $T          = I.toggler = (o.closable ? $Ts[pane] = $("<div></div>") : false)
                  ;

                  //if (s.isVisible && o.resizable) ... handled by initResizable
                  if (!s.isVisible && o.slidable)
                        $R.attr("title", o.tips.Slide).css("cursor", o.sliderCursor);

                  $R    // if paneSelector is an ID, then create a matching ID for the resizer, eg: "#paneLeft" => "paneLeft-resizer"
                        .attr("id", paneId ? paneId +"-resizer" : "" )
                        .data({
                              parentLayout:     Instance
                        ,     layoutPane:       Instance[pane]    // NEW pointer to pane-alias-object
                        ,     layoutEdge:       pane
                        ,     layoutRole:       "resizer"
                        })
                        .css(_c.resizers.cssReq).css("zIndex", options.zIndexes.resizer_normal)
                        .css(o.applyDemoStyles ? _c.resizers.cssDemo : {}) // add demo styles
                        .addClass(rClass +" "+ rClass+_pane)
                        .hover(addHover, removeHover) // ALWAYS add hover-classes, even if resizing is not enabled - handle with CSS instead
                        .hover(onResizerEnter, onResizerLeave) // ALWAYS NEED resizer.mouseleave to balance toggler.mouseenter
                        .appendTo($N) // append DIV to container
                  ;
                  if (o.resizerDblClickToggle)
                        $R.bind("dblclick."+ sID, toggle );

                  if ($T) {
                        $T    // if paneSelector is an ID, then create a matching ID for the resizer, eg: "#paneLeft" => "#paneLeft-toggler"
                              .attr("id", paneId ? paneId +"-toggler" : "" )
                              .data({
                                    parentLayout:     Instance
                              ,     layoutPane:       Instance[pane]    // NEW pointer to pane-alias-object
                              ,     layoutEdge:       pane
                              ,     layoutRole:       "toggler"
                              })
                              .css(_c.togglers.cssReq) // add base/required styles
                              .css(o.applyDemoStyles ? _c.togglers.cssDemo : {}) // add demo styles
                              .addClass(tClass +" "+ tClass+_pane)
                              .hover(addHover, removeHover) // ALWAYS add hover-classes, even if toggling is not enabled - handle with CSS instead
                              .bind("mouseenter", onResizerEnter) // NEED toggler.mouseenter because mouseenter MAY NOT fire on resizer
                              .appendTo($R) // append SPAN to resizer DIV
                        ;
                        // ADD INNER-SPANS TO TOGGLER
                        if (o.togglerContent_open) // ui-layout-open
                              $("<span>"+ o.togglerContent_open +"</span>")
                                    .data({
                                          layoutEdge:       pane
                                    ,     layoutRole:       "togglerContent"
                                    })
                                    .data("layoutRole", "togglerContent")
                                    .data("layoutEdge", pane)
                                    .addClass("content content-open")
                                    .css("display","none")
                                    .appendTo( $T )
                                    //.hover( addHover, removeHover ) // use ui-layout-toggler-west-hover .content-open instead!
                              ;
                        if (o.togglerContent_closed) // ui-layout-closed
                              $("<span>"+ o.togglerContent_closed +"</span>")
                                    .data({
                                          layoutEdge:       pane
                                    ,     layoutRole:       "togglerContent"
                                    })
                                    .addClass("content content-closed")
                                    .css("display","none")
                                    .appendTo( $T )
                                    //.hover( addHover, removeHover ) // use ui-layout-toggler-west-hover .content-closed instead!
                              ;
                        // ADD TOGGLER.click/.hover
                        enableClosable(pane);
                  }

                  // add Draggable events
                  initResizable(pane);

                  // ADD CLASSNAMES & SLIDE-BINDINGS - eg: class="resizer resizer-west resizer-open"
                  if (s.isVisible)
                        setAsOpen(pane);  // onOpen will be called, but NOT onResize
                  else {
                        setAsClosed(pane);      // onClose will be called
                        bindStartSlidingEvents(pane, true); // will enable events IF option is set
                  }

            });

            // SET ALL HANDLE DIMENSIONS
            sizeHandles();
      }


      /**
      * Initialize scrolling ui-layout-content div - if exists
      *
      * @see  initPane() - or externally after an Ajax injection
      * @param {string} pane              The pane to process
      * @param {boolean=}     [resize=true]     Size content after init
      */
,     initContent = function (pane, resize) {
            if (!isInitialized()) return;
            var 
                  o     = options[pane]
            ,     sel   = o.contentSelector
            ,     I     = Instance[pane]
            ,     $P    = $Ps[pane]
            ,     $C
            ;
            if (sel) $C = I.content = $Cs[pane] = (o.findNestedContent)
                  ? $P.find(sel).eq(0) // match 1-element only
                  : $P.children(sel).eq(0)
            ;
            if ($C && $C.length) {
                  $C.data("layoutRole", "content");
                  // SAVE original Content CSS
                  if (!$C.data("layoutCSS"))
                        $C.data("layoutCSS", styles($C, "height"));
                  $C.css( _c.content.cssReq );
                  if (o.applyDemoStyles) {
                        $C.css( _c.content.cssDemo ); // add padding & overflow: auto to content-div
                        $P.css( _c.content.cssDemoPane ); // REMOVE padding/scrolling from pane
                  }
                  // ensure no vertical scrollbar on pane - will mess up measurements
                  if ($P.css("overflowX").match(/(scroll|auto)/)) {
                        $P.css("overflow", "hidden");
                  }
                  state[pane].content = {}; // init content state
                  if (resize !== false) sizeContent(pane);
                  // sizeContent() is called AFTER init of all elements
            }
            else
                  I.content = $Cs[pane] = false;
      }


      /**
      * Add resize-bars to all panes that specify it in options
      * -dependancy: $.fn.resizable - will skip if not found
      *
      * @see  _create()
      * @param {string=}      [panes=""]  The edge(s) to process
      */
,     initResizable = function (panes) {
            var   draggingAvailable = $.layout.plugins.draggable
            ,     side // set in start()
            ;
            panes = panes ? panes.split(",") : _c.borderPanes;

            $.each(panes, function (idx, pane) {
                  var o = options[pane];
                  if (!draggingAvailable || !$Ps[pane] || !o.resizable) {
                        o.resizable = false;
                        return true; // skip to next
                  }

                  var s       = state[pane]
                  ,     z           = options.zIndexes
                  ,     c           = _c[pane]
                  ,     side  = c.dir=="horz" ? "top" : "left"
                  ,     $P          = $Ps[pane]
                  ,     $R          = $Rs[pane]
                  ,     base  = o.resizerClass
                  ,     lastPos     = 0 // used when live-resizing
                  ,     r, live // set in start because may change
                  //    'drag' classes are applied to the ORIGINAL resizer-bar while dragging is in process
                  ,     resizerClass            = base+"-drag"                      // resizer-drag
                  ,     resizerPaneClass  = base+"-"+pane+"-drag"       // resizer-north-drag
                  //    'helper' class is applied to the CLONED resizer-bar while it is being dragged
                  ,     helperClass             = base+"-dragging"                  // resizer-dragging
                  ,     helperPaneClass         = base+"-"+pane+"-dragging" // resizer-north-dragging
                  ,     helperLimitClass  = base+"-dragging-limit"      // resizer-drag
                  ,     helperPaneLimitClass = base+"-"+pane+"-dragging-limit"      // resizer-north-drag
                  ,     helperClassesSet  = false                             // logic var
                  ;

                  if (!s.isClosed)
                        $R.attr("title", o.tips.Resize)
                          .css("cursor", o.resizerCursor); // n-resize, s-resize, etc

                  $R.draggable({
                        containment:      $N[0] // limit resizing to layout container
                  ,     axis:             (c.dir=="horz" ? "y" : "x") // limit resizing to horz or vert axis
                  ,     delay:                  0
                  ,     distance:         1
                  ,     grid:             o.resizingGrid
                  //    basic format for helper - style it using class: .ui-draggable-dragging
                  ,     helper:                 "clone"
                  ,     opacity:          o.resizerDragOpacity
                  ,     addClasses:       false // avoid ui-state-disabled class when disabled
                  //,   iframeFix:        o.draggableIframeFix // TODO: consider using when bug is fixed
                  ,     zIndex:                 z.resizer_drag

                  ,     start: function (e, ui) {
                              // REFRESH options & state pointers in case we used swapPanes
                              o = options[pane];
                              s = state[pane];
                              // re-read options
                              live = o.livePaneResizing;

                              // ondrag_start callback - will CANCEL hide if returns false
                              // TODO: dragging CANNOT be cancelled like this, so see if there is a way?
                              if (false === _runCallbacks("ondrag_start", pane)) return false;

                              s.isResizing            = true; // prevent pane from closing while resizing
                              state.paneResizing      = pane; // easy to see if ANY pane is resizing
                              timer.clear(pane+"_closeSlider"); // just in case already triggered

                              // SET RESIZER LIMITS - used in drag()
                              setSizeLimits(pane); // update pane/resizer state
                              r = s.resizerPosition;
                              lastPos = ui.position[ side ]

                              $R.addClass( resizerClass +" "+ resizerPaneClass ); // add drag classes
                              helperClassesSet = false; // reset logic var - see drag()

                              // DISABLE TEXT SELECTION (probably already done by resizer.mouseOver)
                              $('body').disableSelection(); 

                              // MASK PANES CONTAINING IFRAMES, APPLETS OR OTHER TROUBLESOME ELEMENTS
                              showMasks( pane, { resizing: true });
                        }

                  ,     drag: function (e, ui) {
                              if (!helperClassesSet) { // can only add classes after clone has been added to the DOM
                                    //$(".ui-draggable-dragging")
                                    ui.helper
                                          .addClass( helperClass +" "+ helperPaneClass ) // add helper classes
                                          .css({ right: "auto", bottom: "auto" })   // fix dir="rtl" issue
                                          .children().css("visibility","hidden")    // hide toggler inside dragged resizer-bar
                                    ;
                                    helperClassesSet = true;
                                    // draggable bug!? RE-SET zIndex to prevent E/W resize-bar showing through N/S pane!
                                    if (s.isSliding) $Ps[pane].css("zIndex", z.pane_sliding);
                              }
                              // CONTAIN RESIZER-BAR TO RESIZING LIMITS
                              var limit = 0;
                              if (ui.position[side] < r.min) {
                                    ui.position[side] = r.min;
                                    limit = -1;
                              }
                              else if (ui.position[side] > r.max) {
                                    ui.position[side] = r.max;
                                    limit = 1;
                              }
                              // ADD/REMOVE dragging-limit CLASS
                              if (limit) {
                                    ui.helper.addClass( helperLimitClass +" "+ helperPaneLimitClass ); // at dragging-limit
                                    window.defaultStatus = (limit>0 && pane.match(/(north|west)/)) || (limit<0 && pane.match(/(south|east)/)) ? o.tips.maxSizeWarning : o.tips.minSizeWarning;
                              }
                              else {
                                    ui.helper.removeClass( helperLimitClass +" "+ helperPaneLimitClass ); // not at dragging-limit
                                    window.defaultStatus = "";
                              }
                              // DYNAMICALLY RESIZE PANES IF OPTION ENABLED
                              // won't trigger unless resizer has actually moved!
                              if (live && Math.abs(ui.position[side] - lastPos) >= o.liveResizingTolerance) {
                                    lastPos = ui.position[side];
                                    resizePanes(e, ui, pane)
                              }
                        }

                  ,     stop: function (e, ui) {
                              $('body').enableSelection(); // RE-ENABLE TEXT SELECTION
                              window.defaultStatus = ""; // clear 'resizing limit' message from statusbar
                              $R.removeClass( resizerClass +" "+ resizerPaneClass ); // remove drag classes from Resizer
                              s.isResizing            = false;
                              state.paneResizing      = false; // easy to see if ANY pane is resizing
                              resizePanes(e, ui, pane, true); // true = resizingDone
                        }

                  });
            });

            /**
            * resizePanes
            *
            * Sub-routine called from stop() - and drag() if livePaneResizing
            *
            * @param {!Object}            evt
            * @param {!Object}            ui
            * @param {string}       pane
            * @param {boolean=}           [resizingDone=false]
            */
            var resizePanes = function (evt, ui, pane, resizingDone) {
                  var   dragPos     = ui.position
                  ,     c           = _c[pane]
                  ,     o           = options[pane]
                  ,     s           = state[pane]
                  ,     resizerPos
                  ;
                  switch (pane) {
                        case "north":     resizerPos = dragPos.top; break;
                        case "west":      resizerPos = dragPos.left; break;
                        case "south":     resizerPos = sC.layoutHeight - dragPos.top  - o.spacing_open; break;
                        case "east":      resizerPos = sC.layoutWidth  - dragPos.left - o.spacing_open; break;
                  };
                  // remove container margin from resizer position to get the pane size
                  var newSize = resizerPos - sC.inset[c.side];

                  // Disable OR Resize Mask(s) created in drag.start
                  if (!resizingDone) {
                        // ensure we meet liveResizingTolerance criteria
                        if (Math.abs(newSize - s.size) < o.liveResizingTolerance)
                              return; // SKIP resize this time
                        // resize the pane
                        manualSizePane(pane, newSize, false, true); // true = noAnimation
                        sizeMasks(); // resize all visible masks
                  }
                  else { // resizingDone
                        // ondrag_end callback
                        if (false !== _runCallbacks("ondrag_end", pane))
                              manualSizePane(pane, newSize, false, true); // true = noAnimation
                        hideMasks(true); // true = force hiding all masks even if one is 'sliding'
                        if (s.isSliding) // RE-SHOW 'object-masks' so objects won't show through sliding pane
                              showMasks( pane, { resizing: true });
                  }
            };
      }

      /**
      *     sizeMask
      *
      *     Needed to overlay a DIV over an IFRAME-pane because mask CANNOT be *inside* the pane
      *     Called when mask created, and during livePaneResizing
      */
,     sizeMask = function () {
            var $M            = $(this)
            ,     pane  = $M.data("layoutMask") // eg: "west"
            ,     s           = state[pane]
            ;
            // only masks over an IFRAME-pane need manual resizing
            if (s.tagName == "IFRAME" && s.isVisible) // no need to mask closed/hidden panes
                  $M.css({
                        top:  s.offsetTop
                  ,     left: s.offsetLeft
                  ,     width:      s.outerWidth
                  ,     height:     s.outerHeight
                  });
            /* ALT Method...
            var $P = $Ps[pane];
            $M.css( $P.position() ).css({ width: $P[0].offsetWidth, height: $P[0].offsetHeight });
            */
      }
,     sizeMasks = function () {
            $Ms.each( sizeMask ); // resize all 'visible' masks
      }

      /**
      * @param {string} pane        The pane being resized, animated or isSliding
      * @param {Object=}      [args]            (optional) Options: which masks to apply, and to which panes
      */
,     showMasks = function (pane, args) {
            var   c           = _c[pane]
            ,     panes =  ["center"]
            ,     z           = options.zIndexes
            ,     a           = $.extend({
                                    objectsOnly:      false
                              ,     animation:        false
                              ,     resizing:         true
                              ,     sliding:          state[pane].isSliding
                              },    args )
            ,     o, s
            ;
            if (a.resizing)
                  panes.push( pane );
            if (a.sliding)
                  panes.push( _c.oppositeEdge[pane] ); // ADD the oppositeEdge-pane

            if (c.dir === "horz") {
                  panes.push("west");
                  panes.push("east");
            }

            $.each(panes, function(i,p){
                  s = state[p];
                  o = options[p];
                  if (s.isVisible && ( o.maskObjects || (!a.objectsOnly && o.maskContents) )) {
                        getMasks(p).each(function(){
                              sizeMask.call(this);
                              this.style.zIndex = s.isSliding ? z.pane_sliding+1 : z.pane_normal+1
                              this.style.display = "block";
                        });
                  }
            });
      }

      /**
      * @param {boolean=}     force       Hide masks even if a pane is sliding
      */
,     hideMasks = function (force) {
            // ensure no pane is resizing - could be a timing issue
            if (force || !state.paneResizing) {
                  $Ms.hide(); // hide ALL masks
            }
            // if ANY pane is sliding, then DO NOT remove masks from panes with maskObjects enabled
            else if (!force && !$.isEmptyObject( state.panesSliding )) {
                  var   i = $Ms.length - 1
                  ,     p, $M;
                  for (; i >= 0; i--) {
                        $M    = $Ms.eq(i);
                        p     = $M.data("layoutMask");
                        if (!options[p].maskObjects) {
                              $M.hide();
                        }
                  }
            }
      }

      /**
      * @param {string} pane
      */
,     getMasks = function (pane) {
            var $Masks  = $([])
            ,     $M, i = 0, c = $Ms.length
            ;
            for (; i<c; i++) {
                  $M = $Ms.eq(i);
                  if ($M.data("layoutMask") === pane)
                        $Masks = $Masks.add( $M );
            }
            if ($Masks.length)
                  return $Masks;
            else
                  return createMasks(pane);
      }

      /**
      * createMasks
      *
      * Generates both DIV (ALWAYS used) and IFRAME (optional) elements as masks
      * An IFRAME mask is created *under* the DIV when maskObjects=true, because a DIV cannot mask an applet
      *
      * @param {string} pane
      */
,     createMasks = function (pane) {
            var
                  $P          = $Ps[pane]
            ,     s           = state[pane]
            ,     o           = options[pane]
            ,     z           = options.zIndexes
            //,   objMask     = o.maskObjects && s.tagName != "IFRAME" // check for option
            ,     $Masks      = $([])
            ,     isIframe, el, $M, css, i
            ;
            if (!o.maskContents && !o.maskObjects) return $Masks;
            // if o.maskObjects=true, then loop TWICE to create BOTH kinds of mask, else only create a DIV
            for (i=0; i < (o.maskObjects ? 2 : 1); i++) {
                  isIframe = o.maskObjects && i==0;
                  el = document.createElement( isIframe ? "iframe" : "div" );
                  $M = $(el).data("layoutMask", pane); // add data to relate mask to pane
                  el.className = "ui-layout-mask ui-layout-mask-"+ pane; // for user styling
                  css = el.style;
                  // styles common to both DIVs and IFRAMES
                  css.display       = "block";
                  css.position      = "absolute";
                  css.background    = "#FFF";
                  if (isIframe) { // IFRAME-only props
                        el.frameborder = 0;
                        el.src            = "about:blank";
                        //el.allowTransparency = true; - for IE, but breaks masking ability!
                        css.opacity = 0;
                        css.filter  = "Alpha(Opacity='0')";
                        css.border  = 0;
                  }
                  // if pane is an IFRAME, then must mask the pane itself
                  if (s.tagName == "IFRAME") {
                        // NOTE sizing done by a subroutine so can be called during live-resizing
                        css.zIndex  = z.pane_normal+1; // 1-higher than pane
                        $N.append( el ); // append to LAYOUT CONTAINER
                  }
                  // otherwise put masks *inside the pane* to mask its contents
                  else {
                        $M.addClass("ui-layout-mask-inside-pane");
                        css.zIndex  = o.maskZindex || z.content_mask; // usually 1, but customizable
                        css.top           = 0;
                        css.left    = 0;
                        css.width   = "100%";
                        css.height  = "100%";
                        $P.append( el ); // append INSIDE pane element
                  }
                  // add to return object
                  $Masks = $Masks.add( el );
                  // add Mask to cached array so can be resized & reused
                  $Ms = $Ms.add( el );
            }
            return $Masks;
      }


      /**
      * Destroy this layout and reset all elements
      *
      * @param {boolean=}     [destroyChildren=false]       Destory Child-Layouts first?
      */
,     destroy = function (evt_or_destroyChildren, destroyChildren) {
            // UNBIND layout events and remove global object
            $(window).unbind("."+ sID);         // resize & unload
            $(document).unbind("."+ sID); // keyDown (hotkeys)

            if (typeof evt_or_destroyChildren === "object")
                  // stopPropagation if called by trigger("layoutdestroy") - use evtPane utility 
                  evtPane(evt_or_destroyChildren);
            else // no event, so transfer 1st param to destroyChildren param
                  destroyChildren = evt_or_destroyChildren;

            // need to look for parent layout BEFORE we remove the container data, else skips a level
            //var parentPane = Instance.hasParentLayout ? $.layout.getParentPaneInstance( $N ) : null;

            // reset layout-container
            $N    .clearQueue()
                  .removeData("layout")
                  .removeData("layoutContainer")
                  .removeClass(options.containerClass)
                  .unbind("."+ sID) // remove ALL Layout events
            ;

            // remove all mask elements that have been created
            $Ms.remove();

            // loop all panes to remove layout classes, attributes and bindings
            $.each(_c.allPanes, function (i, pane) {
                  removePane( pane, false, true, destroyChildren ); // true = skipResize
            });

            // do NOT reset container CSS if is a 'pane' (or 'content') in an outer-layout - ie, THIS layout is 'nested'
            var css = "layoutCSS";
            if ($N.data(css) && !$N.data("layoutRole")) // RESET CSS
                  $N.css( $N.data(css) ).removeData(css);

            // for full-page layouts, also reset the <HTML> CSS
            if (sC.tagName === "BODY" && ($N = $("html")).data(css)) // RESET <HTML> CSS
                  $N.css( $N.data(css) ).removeData(css);

            // trigger plugins for this layout, if there are any
            runPluginCallbacks( Instance, $.layout.onDestroy );

            // trigger state-management and onunload callback
            unload();

            // clear the Instance of everything except for container & options (so could recreate)
            // RE-CREATE: myLayout = myLayout.container.layout( myLayout.options );
            for (var n in Instance)
                  if (!n.match(/^(container|options)$/)) delete Instance[ n ];
            // add a 'destroyed' flag to make it easy to check
            Instance.destroyed = true;

            // if this is a child layout, CLEAR the child-pointer in the parent
            /* for now the pointer REMAINS, but with only container, options and destroyed keys
            if (parentPane) {
                  var layout  = parentPane.pane.data("parentLayout")
                  ,     key         = layout.options.instanceKey || 'error';
                  // THIS SYNTAX MAY BE WRONG!
                  parentPane.children[key] = layout.children[ parentPane.name ].children[key] = null;
            }
            */

            return Instance; // for coding convenience
      }

      /**
      * Remove a pane from the layout - subroutine of destroy()
      *
      * @see  destroy()
      * @param {(string|Object)}    evt_or_pane             The pane to process
      * @param {boolean=}                 [remove=false]          Remove the DOM element?
      * @param {boolean=}                 [skipResize=false]      Skip calling resizeAll()?
      * @param {boolean=}                 [destroyChild=true]     Destroy Child-layouts? If not passed, obeys options setting
      */
,     removePane = function (evt_or_pane, remove, skipResize, destroyChild) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $P    = $Ps[pane]
            ,     $C    = $Cs[pane]
            ,     $R    = $Rs[pane]
            ,     $T    = $Ts[pane]
            ;
            // NOTE: elements can still exist even after remove()
            //          so check for missing data(), which is cleared by removed()
            if ($P && $.isEmptyObject( $P.data() )) $P = false;
            if ($C && $.isEmptyObject( $C.data() )) $C = false;
            if ($R && $.isEmptyObject( $R.data() )) $R = false;
            if ($T && $.isEmptyObject( $T.data() )) $T = false;

            if ($P) $P.stop(true, true);

            var   o     = options[pane]
            ,     s     = state[pane]
            ,     d     = "layout"
            ,     css   = "layoutCSS"
            ,     pC    = children[pane]
            ,     hasChildren = $.isPlainObject( pC ) && !$.isEmptyObject( pC )
            ,     destroy           = destroyChild !== undefined ? destroyChild : o.destroyChildren
            ;
            // FIRST destroy the child-layout(s)
            if (hasChildren && destroy) {
                  $.each( pC, function (key, child) {
                        if (!child.destroyed)
                              child.destroy(true);// tell child-layout to destroy ALL its child-layouts too
                        if (child.destroyed)    // destroy was successful
                              delete pC[key];
                  });
                  // if no more children, remove the children hash
                  if ($.isEmptyObject( pC )) {
                        pC = children[pane] = null; // clear children hash
                        hasChildren = false;
                  }
            }

            // Note: can't 'remove' a pane element with non-destroyed children
            if ($P && remove && !hasChildren)
                  $P.remove(); // remove the pane-element and everything inside it
            else if ($P && $P[0]) {
                  //    create list of ALL pane-classes that need to be removed
                  var   root  = o.paneClass // default="ui-layout-pane"
                  ,     pRoot = root +"-"+ pane // eg: "ui-layout-pane-west"
                  ,     _open = "-open"
                  ,     _sliding= "-sliding"
                  ,     _closed     = "-closed"
                  ,     classes     = [   root, root+_open, root+_closed, root+_sliding,        // generic classes
                                          pRoot, pRoot+_open, pRoot+_closed, pRoot+_sliding ]   // pane-specific classes
                  ;
                  $.merge(classes, getHoverClasses($P, true)); // ADD hover-classes
                  // remove all Layout classes from pane-element
                  $P    .removeClass( classes.join(" ") ) // remove ALL pane-classes
                        .removeData("parentLayout")
                        .removeData("layoutPane")
                        .removeData("layoutRole")
                        .removeData("layoutEdge")
                        .removeData("autoHidden")     // in case set
                        .unbind("."+ sID) // remove ALL Layout events
                        // TODO: remove these extra unbind commands when jQuery is fixed
                        //.unbind("mouseenter"+ sID)
                        //.unbind("mouseleave"+ sID)
                  ;
                  // do NOT reset CSS if this pane/content is STILL the container of a nested layout!
                  // the nested layout will reset its 'container' CSS when/if it is destroyed
                  if (hasChildren && $C) {
                        // a content-div may not have a specific width, so give it one to contain the Layout
                        $C.width( $C.width() );
                        $.each( pC, function (key, child) {
                              child.resizeAll(); // resize the Layout
                        });
                  }
                  else if ($C)
                        $C.css( $C.data(css) ).removeData(css).removeData("layoutRole");
                  // remove pane AFTER content in case there was a nested layout
                  if (!$P.data(d))
                        $P.css( $P.data(css) ).removeData(css);
            }

            // REMOVE pane resizer and toggler elements
            if ($T) $T.remove();
            if ($R) $R.remove();

            // CLEAR all pointers and state data
            Instance[pane] = $Ps[pane] = $Cs[pane] = $Rs[pane] = $Ts[pane] = false;
            s = { removed: true };

            if (!skipResize)
                  resizeAll();
      }


/*
 * ###########################
 *       ACTION METHODS
 * ###########################
 */

      /**
      * @param {string} pane
      */
,     _hidePane = function (pane) {
            var $P      = $Ps[pane]
            ,     o     = options[pane]
            ,     s     = $P[0].style
            ;
            if (o.useOffscreenClose) {
                  if (!$P.data(_c.offscreenReset))
                        $P.data(_c.offscreenReset, { left: s.left, right: s.right });
                  $P.css( _c.offscreenCSS );
            }
            else
                  $P.hide().removeData(_c.offscreenReset);
      }

      /**
      * @param {string} pane
      */
,     _showPane = function (pane) {
            var $P      = $Ps[pane]
            ,     o     = options[pane]
            ,     off   = _c.offscreenCSS
            ,     old   = $P.data(_c.offscreenReset)
            ,     s     = $P[0].style
            ;
            $P    .show() // ALWAYS show, just in case
                  .removeData(_c.offscreenReset);
            if (o.useOffscreenClose && old) {
                  if (s.left == off.left)
                        s.left = old.left;
                  if (s.right == off.right)
                        s.right = old.right;
            }
      }


      /**
      * Completely 'hides' a pane, including its spacing - as if it does not exist
      * The pane is not actually 'removed' from the source, so can use 'show' to un-hide it
      *
      * @param {(string|Object)}    evt_or_pane             The pane being hidden, ie: north, south, east, or west
      * @param {boolean=}                 [noAnimation=false]     
      */
,     hide = function (evt_or_pane, noAnimation) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     o     = options[pane]
            ,     s     = state[pane]
            ,     $P    = $Ps[pane]
            ,     $R    = $Rs[pane]
            ;
            if (!$P || s.isHidden) return; // pane does not exist OR is already hidden

            // onhide_start callback - will CANCEL hide if returns false
            if (state.initialized && false === _runCallbacks("onhide_start", pane)) return;

            s.isSliding = false; // just in case
            delete state.panesSliding[pane];

            // now hide the elements
            if ($R) $R.hide(); // hide resizer-bar
            if (!state.initialized || s.isClosed) {
                  s.isClosed = true; // to trigger open-animation on show()
                  s.isHidden  = true;
                  s.isVisible = false;
                  if (!state.initialized)
                        _hidePane(pane); // no animation when loading page
                  sizeMidPanes(_c[pane].dir === "horz" ? "" : "center");
                  if (state.initialized || o.triggerEventsOnLoad)
                        _runCallbacks("onhide_end", pane);
            }
            else {
                  s.isHiding = true; // used by onclose
                  close(pane, false, noAnimation); // adjust all panes to fit
            }
      }

      /**
      * Show a hidden pane - show as 'closed' by default unless openPane = true
      *
      * @param {(string|Object)}    evt_or_pane             The pane being opened, ie: north, south, east, or west
      * @param {boolean=}                 [openPane=false]
      * @param {boolean=}                 [noAnimation=false]
      * @param {boolean=}                 [noAlert=false]
      */
,     show = function (evt_or_pane, openPane, noAnimation, noAlert) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     o     = options[pane]
            ,     s     = state[pane]
            ,     $P    = $Ps[pane]
            ,     $R    = $Rs[pane]
            ;
            if (!$P || !s.isHidden) return; // pane does not exist OR is not hidden

            // onshow_start callback - will CANCEL show if returns false
            if (false === _runCallbacks("onshow_start", pane)) return;

            s.isShowing = true; // used by onopen/onclose
            //s.isHidden  = false; - will be set by open/close - if not cancelled
            s.isSliding = false; // just in case
            delete state.panesSliding[pane];

            // now show the elements
            //if ($R) $R.show(); - will be shown by open/close
            if (openPane === false)
                  close(pane, true); // true = force
            else
                  open(pane, false, noAnimation, noAlert); // adjust all panes to fit
      }


      /**
      * Toggles a pane open/closed by calling either open or close
      *
      * @param {(string|Object)}    evt_or_pane       The pane being toggled, ie: north, south, east, or west
      * @param {boolean=}                 [slide=false]
      */
,     toggle = function (evt_or_pane, slide) {
            if (!isInitialized()) return;
            var   evt         = evtObj(evt_or_pane)
            ,     pane  = evtPane.call(this, evt_or_pane)
            ,     s           = state[pane]
            ;
            if (evt) // called from to $R.dblclick OR triggerPaneEvent
                  evt.stopImmediatePropagation();
            if (s.isHidden)
                  show(pane); // will call 'open' after unhiding it
            else if (s.isClosed)
                  open(pane, !!slide);
            else
                  close(pane);
      }


      /**
      * Utility method used during init or other auto-processes
      *
      * @param {string} pane   The pane being closed
      * @param {boolean=}     [setHandles=false]
      */
,     _closePane = function (pane, setHandles) {
            var
                  $P    = $Ps[pane]
            ,     s     = state[pane]
            ;
            _hidePane(pane);
            s.isClosed = true;
            s.isVisible = false;
            if (setHandles) setAsClosed(pane);
      }

      /**
      * Close the specified pane (animation optional), and resize all other panes as needed
      *
      * @param {(string|Object)}    evt_or_pane             The pane being closed, ie: north, south, east, or west
      * @param {boolean=}                 [force=false]
      * @param {boolean=}                 [noAnimation=false]
      * @param {boolean=}                 [skipCallback=false]
      */
,     close = function (evt_or_pane, force, noAnimation, skipCallback) {
            var   pane = evtPane.call(this, evt_or_pane);
            // if pane has been initialized, but NOT the complete layout, close pane instantly
            if (!state.initialized && $Ps[pane]) {
                  _closePane(pane, true); // INIT pane as closed
                  return;
            }
            if (!isInitialized()) return;

            var
                  $P    = $Ps[pane]
            ,     $R    = $Rs[pane]
            ,     $T    = $Ts[pane]
            ,     o     = options[pane]
            ,     s     = state[pane]
            ,     c     = _c[pane]
            ,     doFX, isShowing, isHiding, wasSliding;

            // QUEUE in case another action/animation is in progress
            $N.queue(function( queueNext ){

                  if ( !$P
                  ||    (!o.closable && !s.isShowing && !s.isHiding)    // invalid request // (!o.resizable && !o.closable) ???
                  ||    (!force && s.isClosed && !s.isShowing)                // already closed
                  ) return queueNext();

                  // onclose_start callback - will CANCEL hide if returns false
                  // SKIP if just 'showing' a hidden pane as 'closed'
                  var abort = !s.isShowing && false === _runCallbacks("onclose_start", pane);

                  // transfer logic vars to temp vars
                  isShowing   = s.isShowing;
                  isHiding    = s.isHiding;
                  wasSliding  = s.isSliding;
                  // now clear the logic vars (REQUIRED before aborting)
                  delete s.isShowing;
                  delete s.isHiding;

                  if (abort) return queueNext();

                  doFX        = !noAnimation && !s.isClosed && (o.fxName_close != "none");
                  s.isMoving  = true;
                  s.isClosed  = true;
                  s.isVisible = false;
                  // update isHidden BEFORE sizing panes
                  if (isHiding) s.isHidden = true;
                  else if (isShowing) s.isHidden = false;

                  if (s.isSliding) // pane is being closed, so UNBIND trigger events
                        bindStopSlidingEvents(pane, false); // will set isSliding=false
                  else // resize panes adjacent to this one
                        sizeMidPanes(_c[pane].dir === "horz" ? "" : "center", false); // false = NOT skipCallback

                  // if this pane has a resizer bar, move it NOW - before animation
                  setAsClosed(pane);

                  // CLOSE THE PANE
                  if (doFX) { // animate the close
                        lockPaneForFX(pane, true);    // need to set left/top so animation will work
                        $P.hide( o.fxName_close, o.fxSettings_close, o.fxSpeed_close, function () {
                              lockPaneForFX(pane, false); // undo
                              if (s.isClosed) close_2();
                              queueNext();
                        });
                  }
                  else { // hide the pane without animation
                        _hidePane(pane);
                        close_2();
                        queueNext();
                  };
            });

            // SUBROUTINE
            function close_2 () {
                  s.isMoving  = false;
                  bindStartSlidingEvents(pane, true); // will enable if o.slidable = true

                  // if opposite-pane was autoClosed, see if it can be autoOpened now
                  var altPane = _c.oppositeEdge[pane];
                  if (state[ altPane ].noRoom) {
                        setSizeLimits( altPane );
                        makePaneFit( altPane );
                  }

                  if (!skipCallback && (state.initialized || o.triggerEventsOnLoad)) {
                        // onclose callback - UNLESS just 'showing' a hidden pane as 'closed'
                        if (!isShowing)   _runCallbacks("onclose_end", pane);
                        // onhide OR onshow callback
                        if (isShowing)    _runCallbacks("onshow_end", pane);
                        if (isHiding)     _runCallbacks("onhide_end", pane);
                  }
            }
      }

      /**
      * @param {string} pane  The pane just closed, ie: north, south, east, or west
      */
,     setAsClosed = function (pane) {
            if (!$Rs[pane]) return; // handles not initialized yet!
            var
                  $P          = $Ps[pane]
            ,     $R          = $Rs[pane]
            ,     $T          = $Ts[pane]
            ,     o           = options[pane]
            ,     s           = state[pane]
            ,     side  = _c[pane].side
            ,     rClass      = o.resizerClass
            ,     tClass      = o.togglerClass
            ,     _pane = "-"+ pane // used for classNames
            ,     _open = "-open"
            ,     _sliding= "-sliding"
            ,     _closed     = "-closed"
            ;
            $R
                  .css(side, sC.inset[side]) // move the resizer
                  .removeClass( rClass+_open +" "+ rClass+_pane+_open )
                  .removeClass( rClass+_sliding +" "+ rClass+_pane+_sliding )
                  .addClass( rClass+_closed +" "+ rClass+_pane+_closed )
            ;
            // DISABLE 'resizing' when closed - do this BEFORE bindStartSlidingEvents?
            if (o.resizable && $.layout.plugins.draggable)
                  $R
                        .draggable("disable")
                        .removeClass("ui-state-disabled") // do NOT apply disabled styling - not suitable here
                        .css("cursor", "default")
                        .attr("title","")
                  ;

            // if pane has a toggler button, adjust that too
            if ($T) {
                  $T
                        .removeClass( tClass+_open +" "+ tClass+_pane+_open )
                        .addClass( tClass+_closed +" "+ tClass+_pane+_closed )
                        .attr("title", o.tips.Open) // may be blank
                  ;
                  // toggler-content - if exists
                  $T.children(".content-open").hide();
                  $T.children(".content-closed").css("display","block");
            }

            // sync any 'pin buttons'
            syncPinBtns(pane, false);

            if (state.initialized) {
                  // resize 'length' and position togglers for adjacent panes
                  sizeHandles();
            }
      }

      /**
      * Open the specified pane (animation optional), and resize all other panes as needed
      *
      * @param {(string|Object)}    evt_or_pane             The pane being opened, ie: north, south, east, or west
      * @param {boolean=}                 [slide=false]
      * @param {boolean=}                 [noAnimation=false]
      * @param {boolean=}                 [noAlert=false]
      */
,     open = function (evt_or_pane, slide, noAnimation, noAlert) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $P    = $Ps[pane]
            ,     $R    = $Rs[pane]
            ,     $T    = $Ts[pane]
            ,     o     = options[pane]
            ,     s     = state[pane]
            ,     c     = _c[pane]
            ,     doFX, isShowing
            ;
            // QUEUE in case another action/animation is in progress
            $N.queue(function( queueNext ){

                  if ( !$P
                  ||    (!o.resizable && !o.closable && !s.isShowing)   // invalid request
                  ||    (s.isVisible && !s.isSliding)                         // already open
                  ) return queueNext();

                  // pane can ALSO be unhidden by just calling show(), so handle this scenario
                  if (s.isHidden && !s.isShowing) {
                        queueNext(); // call before show() because it needs the queue free
                        show(pane, true);
                        return;
                  }

                  if (s.autoResize && s.size != o.size) // resize pane to original size set in options
                        sizePane(pane, o.size, true, true, true); // true=skipCallback/noAnimation/forceResize
                  else
                        // make sure there is enough space available to open the pane
                        setSizeLimits(pane, slide);

                  // onopen_start callback - will CANCEL open if returns false
                  var cbReturn = _runCallbacks("onopen_start", pane);

                  if (cbReturn === "abort")
                        return queueNext();

                  // update pane-state again in case options were changed in onopen_start
                  if (cbReturn !== "NC") // NC = "No Callback"
                        setSizeLimits(pane, slide);

                  if (s.minSize > s.maxSize) { // INSUFFICIENT ROOM FOR PANE TO OPEN!
                        syncPinBtns(pane, false); // make sure pin-buttons are reset
                        if (!noAlert && o.tips.noRoomToOpen)
                              alert(o.tips.noRoomToOpen);
                        return queueNext(); // ABORT
                  }

                  if (slide) // START Sliding - will set isSliding=true
                        bindStopSlidingEvents(pane, true); // BIND trigger events to close sliding-pane
                  else if (s.isSliding) // PIN PANE (stop sliding) - open pane 'normally' instead
                        bindStopSlidingEvents(pane, false); // UNBIND trigger events - will set isSliding=false
                  else if (o.slidable)
                        bindStartSlidingEvents(pane, false); // UNBIND trigger events

                  s.noRoom = false; // will be reset by makePaneFit if 'noRoom'
                  makePaneFit(pane);

                  // transfer logic var to temp var
                  isShowing = s.isShowing;
                  // now clear the logic var
                  delete s.isShowing;

                  doFX        = !noAnimation && s.isClosed && (o.fxName_open != "none");
                  s.isMoving  = true;
                  s.isVisible = true;
                  s.isClosed  = false;
                  // update isHidden BEFORE sizing panes - WHY??? Old?
                  if (isShowing) s.isHidden = false;

                  if (doFX) { // ANIMATE
                        // mask adjacent panes with objects
                        lockPaneForFX(pane, true);    // need to set left/top so animation will work
                              $P.show( o.fxName_open, o.fxSettings_open, o.fxSpeed_open, function() {
                              lockPaneForFX(pane, false); // undo
                              if (s.isVisible) open_2(); // continue
                              queueNext();
                        });
                  }
                  else { // no animation
                        _showPane(pane);// just show pane and...
                        open_2();         // continue
                        queueNext();
                  };
            });

            // SUBROUTINE
            function open_2 () {
                  s.isMoving  = false;

                  // cure iframe display issues
                  _fixIframe(pane);

                  // NOTE: if isSliding, then other panes are NOT 'resized'
                  if (!s.isSliding) { // resize all panes adjacent to this one
                        sizeMidPanes(_c[pane].dir=="vert" ? "center" : "", false); // false = NOT skipCallback
                  }

                  // set classes, position handles and execute callbacks...
                  setAsOpen(pane);
            };
      
      }

      /**
      * @param {string} pane        The pane just opened, ie: north, south, east, or west
      * @param {boolean=}     [skipCallback=false]
      */
,     setAsOpen = function (pane, skipCallback) {
            var 
                  $P          = $Ps[pane]
            ,     $R          = $Rs[pane]
            ,     $T          = $Ts[pane]
            ,     o           = options[pane]
            ,     s           = state[pane]
            ,     side  = _c[pane].side
            ,     rClass      = o.resizerClass
            ,     tClass      = o.togglerClass
            ,     _pane = "-"+ pane // used for classNames
            ,     _open = "-open"
            ,     _closed     = "-closed"
            ,     _sliding= "-sliding"
            ;
            $R
                  .css(side, sC.inset[side] + getPaneSize(pane)) // move the resizer
                  .removeClass( rClass+_closed +" "+ rClass+_pane+_closed )
                  .addClass( rClass+_open +" "+ rClass+_pane+_open )
            ;
            if (s.isSliding)
                  $R.addClass( rClass+_sliding +" "+ rClass+_pane+_sliding )
            else // in case 'was sliding'
                  $R.removeClass( rClass+_sliding +" "+ rClass+_pane+_sliding )

            removeHover( 0, $R ); // remove hover classes
            if (o.resizable && $.layout.plugins.draggable)
                  $R    .draggable("enable")
                        .css("cursor", o.resizerCursor)
                        .attr("title", o.tips.Resize);
            else if (!s.isSliding)
                  $R.css("cursor", "default"); // n-resize, s-resize, etc

            // if pane also has a toggler button, adjust that too
            if ($T) {
                  $T    .removeClass( tClass+_closed +" "+ tClass+_pane+_closed )
                        .addClass( tClass+_open +" "+ tClass+_pane+_open )
                        .attr("title", o.tips.Close); // may be blank
                  removeHover( 0, $T ); // remove hover classes
                  // toggler-content - if exists
                  $T.children(".content-closed").hide();
                  $T.children(".content-open").css("display","block");
            }

            // sync any 'pin buttons'
            syncPinBtns(pane, !s.isSliding);

            // update pane-state dimensions - BEFORE resizing content
            $.extend(s, elDims($P));

            if (state.initialized) {
                  // resize resizer & toggler sizes for all panes
                  sizeHandles();
                  // resize content every time pane opens - to be sure
                  sizeContent(pane, true); // true = remeasure headers/footers, even if 'pane.isMoving'
            }

            if (!skipCallback && (state.initialized || o.triggerEventsOnLoad) && $P.is(":visible")) {
                  // onopen callback
                  _runCallbacks("onopen_end", pane);
                  // onshow callback - TODO: should this be here?
                  if (s.isShowing) _runCallbacks("onshow_end", pane);

                  // ALSO call onresize because layout-size *may* have changed while pane was closed
                  if (state.initialized)
                        _runCallbacks("onresize_end", pane);
            }

            // TODO: Somehow sizePane("north") is being called after this point???
      }


      /**
      * slideOpen / slideClose / slideToggle
      *
      * Pass-though methods for sliding
      */
,     slideOpen = function (evt_or_pane) {
            if (!isInitialized()) return;
            var   evt         = evtObj(evt_or_pane)
            ,     pane  = evtPane.call(this, evt_or_pane)
            ,     s           = state[pane]
            ,     delay = options[pane].slideDelay_open
            ;
            // prevent event from triggering on NEW resizer binding created below
            if (evt) evt.stopImmediatePropagation();

            if (s.isClosed && evt && evt.type === "mouseenter" && delay > 0)
                  // trigger = mouseenter - use a delay
                  timer.set(pane+"_openSlider", open_NOW, delay);
            else
                  open_NOW(); // will unbind events if is already open

            /**
            * SUBROUTINE for timed open
            */
            function open_NOW () {
                  if (!s.isClosed) // skip if no longer closed!
                        bindStopSlidingEvents(pane, true); // BIND trigger events to close sliding-pane
                  else if (!s.isMoving)
                        open(pane, true); // true = slide - open() will handle binding
            };
      }

,     slideClose = function (evt_or_pane) {
            if (!isInitialized()) return;
            var   evt         = evtObj(evt_or_pane)
            ,     pane  = evtPane.call(this, evt_or_pane)
            ,     o           = options[pane]
            ,     s           = state[pane]
            ,     delay = s.isMoving ? 1000 : 300 // MINIMUM delay - option may override
            ;
            if (s.isClosed || s.isResizing)
                  return; // skip if already closed OR in process of resizing
            else if (o.slideTrigger_close === "click")
                  close_NOW(); // close immediately onClick
            else if (o.preventQuickSlideClose && s.isMoving)
                  return; // handle Chrome quick-close on slide-open
            else if (o.preventPrematureSlideClose && evt && $.layout.isMouseOverElem(evt, $Ps[pane]))
                  return; // handle incorrect mouseleave trigger, like when over a SELECT-list in IE
            else if (evt) // trigger = mouseleave - use a delay
                  // 1 sec delay if 'opening', else .3 sec
                  timer.set(pane+"_closeSlider", close_NOW, max(o.slideDelay_close, delay));
            else // called programically
                  close_NOW();

            /**
            * SUBROUTINE for timed close
            */
            function close_NOW () {
                  if (s.isClosed) // skip 'close' if already closed!
                        bindStopSlidingEvents(pane, false); // UNBIND trigger events - TODO: is this needed here?
                  else if (!s.isMoving)
                        close(pane); // close will handle unbinding
            };
      }

      /**
      * @param {(string|Object)}    evt_or_pane       The pane being opened, ie: north, south, east, or west
      */
,     slideToggle = function (evt_or_pane) {
            var pane = evtPane.call(this, evt_or_pane);
            toggle(pane, true);
      }


      /**
      * Must set left/top on East/South panes so animation will work properly
      *
      * @param {string} pane  The pane to lock, 'east' or 'south' - any other is ignored!
      * @param {boolean}      doLock  true = set left/top, false = remove
      */
,     lockPaneForFX = function (pane, doLock) {
            var $P      = $Ps[pane]
            ,     s     = state[pane]
            ,     o     = options[pane]
            ,     z     = options.zIndexes
            ;
            if (doLock) {
                  showMasks( pane, { animation: true, objectsOnly: true });
                  $P.css({ zIndex: z.pane_animate }); // overlay all elements during animation
                  if (pane=="south")
                        $P.css({ top: sC.inset.top + sC.innerHeight - $P.outerHeight() });
                  else if (pane=="east")
                        $P.css({ left: sC.inset.left + sC.innerWidth - $P.outerWidth() });
            }
            else { // animation DONE - RESET CSS
                  hideMasks();
                  $P.css({ zIndex: (s.isSliding ? z.pane_sliding : z.pane_normal) });
                  if (pane=="south")
                        $P.css({ top: "auto" });
                  // if pane is positioned 'off-screen', then DO NOT screw with it!
                  else if (pane=="east" && !$P.css("left").match(/\-99999/))
                        $P.css({ left: "auto" });
                  // fix anti-aliasing in IE - only needed for animations that change opacity
                  if (browser.msie && o.fxOpacityFix && o.fxName_open != "slide" && $P.css("filter") && $P.css("opacity") == 1)
                        $P[0].style.removeAttribute('filter');
            }
      }


      /**
      * Toggle sliding functionality of a specific pane on/off by adding removing 'slide open' trigger
      *
      * @see  open(), close()
      * @param {string} pane  The pane to enable/disable, 'north', 'south', etc.
      * @param {boolean}      enable      Enable or Disable sliding?
      */
,     bindStartSlidingEvents = function (pane, enable) {
            var o       = options[pane]
            ,     $P          = $Ps[pane]
            ,     $R          = $Rs[pane]
            ,     evtName     = o.slideTrigger_open.toLowerCase()
            ;
            if (!$R || (enable && !o.slidable)) return;

            // make sure we have a valid event
            if (evtName.match(/mouseover/))
                  evtName = o.slideTrigger_open = "mouseenter";
            else if (!evtName.match(/(click|dblclick|mouseenter)/)) 
                  evtName = o.slideTrigger_open = "click";

            // must remove double-click-toggle when using dblclick-slide
            if (o.resizerDblClickToggle && evtName.match(/click/)) {
                  $R[enable ? "unbind" : "bind"]('dblclick.'+ sID, toggle)
            }

            $R
                  // add or remove event
                  [enable ? "bind" : "unbind"](evtName +'.'+ sID, slideOpen)
                  // set the appropriate cursor & title/tip
                  .css("cursor", enable ? o.sliderCursor : "default")
                  .attr("title", enable ? o.tips.Slide : "")
            ;
      }

      /**
      * Add or remove 'mouseleave' events to 'slide close' when pane is 'sliding' open or closed
      * Also increases zIndex when pane is sliding open
      * See bindStartSlidingEvents for code to control 'slide open'
      *
      * @see  slideOpen(), slideClose()
      * @param {string} pane  The pane to process, 'north', 'south', etc.
      * @param {boolean}      enable      Enable or Disable events?
      */
,     bindStopSlidingEvents = function (pane, enable) {
            var   o           = options[pane]
            ,     s           = state[pane]
            ,     c           = _c[pane]
            ,     z           = options.zIndexes
            ,     evtName     = o.slideTrigger_close.toLowerCase()
            ,     action      = (enable ? "bind" : "unbind")
            ,     $P          = $Ps[pane]
            ,     $R          = $Rs[pane]
            ;
            timer.clear(pane+"_closeSlider"); // just in case

            if (enable) {
                  s.isSliding = true;
                  state.panesSliding[pane] = true;
                  // remove 'slideOpen' event from resizer
                  // ALSO will raise the zIndex of the pane & resizer
                  bindStartSlidingEvents(pane, false);
            }
            else {
                  s.isSliding = false;
                  delete state.panesSliding[pane];
            }

            // RE/SET zIndex - increases when pane is sliding-open, resets to normal when not
            $P.css("zIndex", enable ? z.pane_sliding : z.pane_normal);
            $R.css("zIndex", enable ? z.pane_sliding+2 : z.resizer_normal); // NOTE: mask = pane_sliding+1

            // make sure we have a valid event
            if (!evtName.match(/(click|mouseleave)/))
                  evtName = o.slideTrigger_close = "mouseleave"; // also catches 'mouseout'

            // add/remove slide triggers
            $R[action](evtName, slideClose); // base event on resize
            // need extra events for mouseleave
            if (evtName === "mouseleave") {
                  // also close on pane.mouseleave
                  $P[action]("mouseleave."+ sID, slideClose);
                  // cancel timer when mouse moves between 'pane' and 'resizer'
                  $R[action]("mouseenter."+ sID, cancelMouseOut);
                  $P[action]("mouseenter."+ sID, cancelMouseOut);
            }

            if (!enable)
                  timer.clear(pane+"_closeSlider");
            else if (evtName === "click" && !o.resizable) {
                  // IF pane is not resizable (which already has a cursor and tip) 
                  // then set the a cursor & title/tip on resizer when sliding
                  $R.css("cursor", enable ? o.sliderCursor : "default");
                  $R.attr("title", enable ? o.tips.Close : ""); // use Toggler-tip, eg: "Close Pane"
            }

            // SUBROUTINE for mouseleave timer clearing
            function cancelMouseOut (evt) {
                  timer.clear(pane+"_closeSlider");
                  evt.stopPropagation();
            }
      }


      /**
      * Hides/closes a pane if there is insufficient room - reverses this when there is room again
      * MUST have already called setSizeLimits() before calling this method
      *
      * @param {string} pane                          The pane being resized
      * @param {boolean=}     [isOpening=false]       Called from onOpen?
      * @param {boolean=}     [skipCallback=false]    Should the onresize callback be run?
      * @param {boolean=}     [force=false]
      */
,     makePaneFit = function (pane, isOpening, skipCallback, force) {
            var   o     = options[pane]
            ,     s     = state[pane]
            ,     c     = _c[pane]
            ,     $P    = $Ps[pane]
            ,     $R    = $Rs[pane]
            ,     isSidePane  = c.dir==="vert"
            ,     hasRoom           = false
            ;
            // special handling for center & east/west panes
            if (pane === "center" || (isSidePane && s.noVerticalRoom)) {
                  // see if there is enough room to display the pane
                  // ERROR: hasRoom = s.minHeight <= s.maxHeight && (isSidePane || s.minWidth <= s.maxWidth);
                  hasRoom = (s.maxHeight >= 0);
                  if (hasRoom && s.noRoom) { // previously hidden due to noRoom, so show now
                        _showPane(pane);
                        if ($R) $R.show();
                        s.isVisible = true;
                        s.noRoom = false;
                        if (isSidePane) s.noVerticalRoom = false;
                        _fixIframe(pane);
                  }
                  else if (!hasRoom && !s.noRoom) { // not currently hidden, so hide now
                        _hidePane(pane);
                        if ($R) $R.hide();
                        s.isVisible = false;
                        s.noRoom = true;
                  }
            }

            // see if there is enough room to fit the border-pane
            if (pane === "center") {
                  // ignore center in this block
            }
            else if (s.minSize <= s.maxSize) { // pane CAN fit
                  hasRoom = true;
                  if (s.size > s.maxSize) // pane is too big - shrink it
                        sizePane(pane, s.maxSize, skipCallback, true, force); // true = noAnimation
                  else if (s.size < s.minSize) // pane is too small - enlarge it
                        sizePane(pane, s.minSize, skipCallback, true, force); // true = noAnimation
                  // need s.isVisible because new pseudoClose method keeps pane visible, but off-screen
                  else if ($R && s.isVisible && $P.is(":visible")) {
                        // make sure resizer-bar is positioned correctly
                        // handles situation where nested layout was 'hidden' when initialized
                        var   pos = s.size + sC.inset[c.side];
                        if ($.layout.cssNum( $R, c.side ) != pos) $R.css( c.side, pos );
                  }

                  // if was previously hidden due to noRoom, then RESET because NOW there is room
                  if (s.noRoom) {
                        // s.noRoom state will be set by open or show
                        if (s.wasOpen && o.closable) {
                              if (o.autoReopen)
                                    open(pane, false, true, true); // true = noAnimation, true = noAlert
                              else // leave the pane closed, so just update state
                                    s.noRoom = false;
                        }
                        else
                              show(pane, s.wasOpen, true, true); // true = noAnimation, true = noAlert
                  }
            }
            else { // !hasRoom - pane CANNOT fit
                  if (!s.noRoom) { // pane not set as noRoom yet, so hide or close it now...
                        s.noRoom = true; // update state
                        s.wasOpen = !s.isClosed && !s.isSliding;
                        if (s.isClosed){} // SKIP
                        else if (o.closable) // 'close' if possible
                              close(pane, true, true); // true = force, true = noAnimation
                        else // 'hide' pane if cannot just be closed
                              hide(pane, true); // true = noAnimation
                  }
            }
      }


      /**
      * manualSizePane is an exposed flow-through method allowing extra code when pane is 'manually resized'
      *
      * @param {(string|Object)}    evt_or_pane                   The pane being resized
      * @param {number}             size                          The *desired* new size for this pane - will be validated
      * @param {boolean=}                 [skipCallback=false]    Should the onresize callback be run?
      * @param {boolean=}                 [noAnimation=false]
      * @param {boolean=}                 [force=false]                 Force resizing even if does not seem necessary
      */
,     manualSizePane = function (evt_or_pane, size, skipCallback, noAnimation, force) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     o     = options[pane]
            ,     s     = state[pane]
            //    if resizing callbacks have been delayed and resizing is now DONE, force resizing to complete...
            ,     forceResize = force || (o.livePaneResizing && !s.isResizing)
            ;
            // ANY call to manualSizePane disables autoResize - ie, percentage sizing
            s.autoResize = false;
            // flow-through...
            sizePane(pane, size, skipCallback, noAnimation, forceResize); // will animate resize if option enabled
      }

      /**
      * sizePane is called only by internal methods whenever a pane needs to be resized
      *
      * @param {(string|Object)}    evt_or_pane                   The pane being resized
      * @param {number}             size                          The *desired* new size for this pane - will be validated
      * @param {boolean=}                 [skipCallback=false]    Should the onresize callback be run?
      * @param {boolean=}                 [noAnimation=false]
      * @param {boolean=}                 [force=false]                 Force resizing even if does not seem necessary
      */
,     sizePane = function (evt_or_pane, size, skipCallback, noAnimation, force) {
            if (!isInitialized()) return;
            var   pane  = evtPane.call(this, evt_or_pane) // probably NEVER called from event?
            ,     o           = options[pane]
            ,     s           = state[pane]
            ,     $P          = $Ps[pane]
            ,     $R          = $Rs[pane]
            ,     side  = _c[pane].side
            ,     dimName     = _c[pane].sizeType.toLowerCase()
            ,     skipResizeWhileDragging = s.isResizing && !o.triggerEventsDuringLiveResize
            ,     doFX  = noAnimation !== true && o.animatePaneSizing
            ,     oldSize, newSize
            ;
            // QUEUE in case another action/animation is in progress
            $N.queue(function( queueNext ){
                  // calculate 'current' min/max sizes
                  setSizeLimits(pane); // update pane-state
                  oldSize = s.size;
                  size = _parseSize(pane, size); // handle percentages & auto
                  size = max(size, _parseSize(pane, o.minSize));
                  size = min(size, s.maxSize);
                  if (size < s.minSize) { // not enough room for pane!
                        queueNext(); // call before makePaneFit() because it needs the queue free
                        makePaneFit(pane, false, skipCallback);   // will hide or close pane
                        return;
                  }

                  // IF newSize is same as oldSize, then nothing to do - abort
                  if (!force && size === oldSize)
                        return queueNext();

                  s.newSize = size;

                  // onresize_start callback CANNOT cancel resizing because this would break the layout!
                  if (!skipCallback && state.initialized && s.isVisible)
                        _runCallbacks("onresize_start", pane);

                  // resize the pane, and make sure its visible
                  newSize = cssSize(pane, size);

                  if (doFX && $P.is(":visible")) { // ANIMATE
                        var fx            = $.layout.effects.size[pane] || $.layout.effects.size.all
                        ,     easing      = o.fxSettings_size.easing || fx.easing
                        ,     z           = options.zIndexes
                        ,     props = {};
                        props[ dimName ] = newSize +'px';
                        s.isMoving = true;
                        // overlay all elements during animation
                        $P.css({ zIndex: z.pane_animate })
                          .show().animate( props, o.fxSpeed_size, easing, function(){
                              // reset zIndex after animation
                              $P.css({ zIndex: (s.isSliding ? z.pane_sliding : z.pane_normal) });
                              s.isMoving = false;
                              delete s.newSize;
                              sizePane_2(); // continue
                              queueNext();
                        });
                  }
                  else { // no animation
                        $P.css( dimName, newSize );   // resize pane
                        delete s.newSize;
                        // if pane is visible, then 
                        if ($P.is(":visible"))
                              sizePane_2(); // continue
                        else {
                              // pane is NOT VISIBLE, so just update state data...
                              // when pane is *next opened*, it will have the new size
                              s.size = size;                      // update state.size
                              $.extend(s, elDims($P));      // update state dimensions
                        }
                        queueNext();
                  };

            });

            // SUBROUTINE
            function sizePane_2 () {
                  /*    Panes are sometimes not sized precisely in some browsers!?
                   *    This code will resize the pane up to 3 times to nudge the pane to the correct size
                   */
                  var   actual      = dimName==='width' ? $P.outerWidth() : $P.outerHeight()
                  ,     tries = [{
                                          pane:       pane
                                    ,     count:            1
                                    ,     target:           size
                                    ,     actual:           actual
                                    ,     correct:    (size === actual)
                                    ,     attempt:    size
                                    ,     cssSize:    newSize
                                    }]
                  ,     lastTry = tries[0]
                  ,     thisTry     = {}
                  ,     msg         = 'Inaccurate size after resizing the '+ pane +'-pane.'
                  ;
                  while ( !lastTry.correct ) {
                        thisTry = { pane: pane, count: lastTry.count+1, target: size };

                        if (lastTry.actual > size)
                              thisTry.attempt = max(0, lastTry.attempt - (lastTry.actual - size));
                        else // lastTry.actual < size
                              thisTry.attempt = max(0, lastTry.attempt + (size - lastTry.actual));

                        thisTry.cssSize = cssSize(pane, thisTry.attempt);
                        $P.css( dimName, thisTry.cssSize );

                        thisTry.actual    = dimName=='width' ? $P.outerWidth() : $P.outerHeight();
                        thisTry.correct   = (size === thisTry.actual);

                        // log attempts and alert the user of this *non-fatal error* (if showDebugMessages)
                        if ( tries.length === 1) {
                              _log(msg, false, true);
                              _log(lastTry, false, true);
                        }
                        _log(thisTry, false, true);
                        // after 4 tries, is as close as its gonna get!
                        if (tries.length > 3) break;

                        tries.push( thisTry );
                        lastTry = tries[ tries.length - 1 ];
                  }
                  // END TESTING CODE

                  // update pane-state dimensions
                  s.size      = size;
                  $.extend(s, elDims($P));

                  if (s.isVisible && $P.is(":visible")) {
                        // reposition the resizer-bar
                        if ($R) $R.css( side, size + sC.inset[side] );
                        // resize the content-div
                        sizeContent(pane);
                  }

                  if (!skipCallback && !skipResizeWhileDragging && state.initialized && s.isVisible)
                        _runCallbacks("onresize_end", pane);

                  // resize all the adjacent panes, and adjust their toggler buttons
                  // when skipCallback passed, it means the controlling method will handle 'other panes'
                  if (!skipCallback) {
                        // also no callback if live-resize is in progress and NOT triggerEventsDuringLiveResize
                        if (!s.isSliding) sizeMidPanes(_c[pane].dir=="horz" ? "" : "center", skipResizeWhileDragging, force);
                        sizeHandles();
                  }

                  // if opposite-pane was autoClosed, see if it can be autoOpened now
                  var altPane = _c.oppositeEdge[pane];
                  if (size < oldSize && state[ altPane ].noRoom) {
                        setSizeLimits( altPane );
                        makePaneFit( altPane, false, skipCallback );
                  }

                  // DEBUG - ALERT user/developer so they know there was a sizing problem
                  if (tries.length > 1)
                        _log(msg +'\nSee the Error Console for details.', true, true);
            }
      }

      /**
      * @see  initPanes(), sizePane(),    resizeAll(), open(), close(), hide()
      * @param {(Array.<string>|string)}  panes                         The pane(s) being resized, comma-delmited string
      * @param {boolean=}                             [skipCallback=false]    Should the onresize callback be run?
      * @param {boolean=}                             [force=false]
      */
,     sizeMidPanes = function (panes, skipCallback, force) {
            panes = (panes ? panes : "east,west,center").split(",");

            $.each(panes, function (i, pane) {
                  if (!$Ps[pane]) return; // NO PANE - skip
                  var 
                        o           = options[pane]
                  ,     s           = state[pane]
                  ,     $P          = $Ps[pane]
                  ,     $R          = $Rs[pane]
                  ,     isCenter= (pane=="center")
                  ,     hasRoom     = true
                  ,     CSS         = {}
                  //    if pane is not visible, show it invisibly NOW rather than for *each call* in this script
                  ,     visCSS      = $.layout.showInvisibly($P)

                  ,     newCenter   = calcNewCenterPaneDims()
                  ;

                  // update pane-state dimensions
                  $.extend(s, elDims($P));

                  if (pane === "center") {
                        if (!force && s.isVisible && newCenter.width === s.outerWidth && newCenter.height === s.outerHeight) {
                              $P.css(visCSS);
                              return true; // SKIP - pane already the correct size
                        }
                        // set state for makePaneFit() logic
                        $.extend(s, cssMinDims(pane), {
                              maxWidth:   newCenter.width
                        ,     maxHeight:  newCenter.height
                        });
                        CSS = newCenter;
                        s.newWidth  = CSS.width;
                        s.newHeight = CSS.height;
                        // convert OUTER width/height to CSS width/height 
                        CSS.width   = cssW($P, CSS.width);
                        // NEW - allow pane to extend 'below' visible area rather than hide it
                        CSS.height  = cssH($P, CSS.height);
                        hasRoom           = CSS.width >= 0 && CSS.height >= 0; // height >= 0 = ALWAYS TRUE NOW

                        // during layout init, try to shrink east/west panes to make room for center
                        if (!state.initialized && o.minWidth > newCenter.width) {
                              var
                                    reqPx = o.minWidth - s.outerWidth
                              ,     minE  = options.east.minSize || 0
                              ,     minW  = options.west.minSize || 0
                              ,     sizeE = state.east.size
                              ,     sizeW = state.west.size
                              ,     newE  = sizeE
                              ,     newW  = sizeW
                              ;
                              if (reqPx > 0 && state.east.isVisible && sizeE > minE) {
                                    newE = max( sizeE-minE, sizeE-reqPx );
                                    reqPx -= sizeE-newE;
                              }
                              if (reqPx > 0 && state.west.isVisible && sizeW > minW) {
                                    newW = max( sizeW-minW, sizeW-reqPx );
                                    reqPx -= sizeW-newW;
                              }
                              // IF we found enough extra space, then resize the border panes as calculated
                              if (reqPx === 0) {
                                    if (sizeE && sizeE != minE)
                                          sizePane('east', newE, true, true, force); // true = skipCallback/noAnimation - initPanes will handle when done
                                    if (sizeW && sizeW != minW)
                                          sizePane('west', newW, true, true, force); // true = skipCallback/noAnimation
                                    // now start over!
                                    sizeMidPanes('center', skipCallback, force);
                                    $P.css(visCSS);
                                    return; // abort this loop
                              }
                        }
                  }
                  else { // for east and west, set only the height, which is same as center height
                        // set state.min/maxWidth/Height for makePaneFit() logic
                        if (s.isVisible && !s.noVerticalRoom)
                              $.extend(s, elDims($P), cssMinDims(pane))
                        if (!force && !s.noVerticalRoom && newCenter.height === s.outerHeight) {
                              $P.css(visCSS);
                              return true; // SKIP - pane already the correct size
                        }
                        // east/west have same top, bottom & height as center
                        CSS.top           = newCenter.top;
                        CSS.bottom  = newCenter.bottom;
                        s.newSize   = newCenter.height
                        // NEW - allow pane to extend 'below' visible area rather than hide it
                        CSS.height  = cssH($P, newCenter.height);
                        s.maxHeight = CSS.height;
                        hasRoom           = (s.maxHeight >= 0); // ALWAYS TRUE NOW
                        if (!hasRoom) s.noVerticalRoom = true; // makePaneFit() logic
                  }

                  if (hasRoom) {
                        // resizeAll passes skipCallback because it triggers callbacks after ALL panes are resized
                        if (!skipCallback && state.initialized)
                              _runCallbacks("onresize_start", pane);

                        $P.css(CSS); // apply the CSS to pane
                        if (pane !== "center")
                              sizeHandles(pane); // also update resizer length
                        if (s.noRoom && !s.isClosed && !s.isHidden)
                              makePaneFit(pane); // will re-open/show auto-closed/hidden pane
                        if (s.isVisible) {
                              $.extend(s, elDims($P)); // update pane dimensions
                              if (state.initialized) sizeContent(pane); // also resize the contents, if exists
                        }
                  }
                  else if (!s.noRoom && s.isVisible) // no room for pane
                        makePaneFit(pane); // will hide or close pane

                  // reset visibility, if necessary
                  $P.css(visCSS);

                  delete s.newSize;
                  delete s.newWidth;
                  delete s.newHeight;

                  if (!s.isVisible)
                        return true; // DONE - next pane

                  /*
                  * Extra CSS for IE6 or IE7 in Quirks-mode - add 'width' to NORTH/SOUTH panes
                  * Normally these panes have only 'left' & 'right' positions so pane auto-sizes
                  * ALSO required when pane is an IFRAME because will NOT default to 'full width'
                  *     TODO: Can I use width:100% for a north/south iframe?
                  *     TODO: Sounds like a job for $P.outerWidth( sC.innerWidth ) SETTER METHOD
                  */
                  if (pane === "center") { // finished processing midPanes
                        var fix = browser.isIE6 || !browser.boxModel;
                        if ($Ps.north && (fix || state.north.tagName=="IFRAME")) 
                              $Ps.north.css("width", cssW($Ps.north, sC.innerWidth));
                        if ($Ps.south && (fix || state.south.tagName=="IFRAME"))
                              $Ps.south.css("width", cssW($Ps.south, sC.innerWidth));
                  }

                  // resizeAll passes skipCallback because it triggers callbacks after ALL panes are resized
                  if (!skipCallback && state.initialized)
                        _runCallbacks("onresize_end", pane);
            });
      }


      /**
      * @see  window.onresize(), callbacks or custom code
      * @param {(Object|boolean)=}  evt_or_refresh    If 'true', then also reset pane-positioning
      */
,     resizeAll = function (evt_or_refresh) {
            var   oldW  = sC.innerWidth
            ,     oldH  = sC.innerHeight
            ;
            // stopPropagation if called by trigger("layoutdestroy") - use evtPane utility 
            evtPane(evt_or_refresh);

            // cannot size layout when 'container' is hidden or collapsed
            if (!$N.is(":visible")) return;

            if (!state.initialized) {
                  _initLayoutElements();
                  return; // no need to resize since we just initialized!
            }

            if (evt_or_refresh === true && $.isPlainObject(options.outset)) {
                  // update container CSS in case outset option has changed
                  $N.css( options.outset );
            }
            // UPDATE container dimensions
            $.extend(sC, elDims( $N, options.inset ));
            if (!sC.outerHeight) return;

            // if 'true' passed, refresh pane & handle positioning too
            if (evt_or_refresh === true) {
                  setPanePosition();
            }

            // onresizeall_start will CANCEL resizing if returns false
            // state.container has already been set, so user can access this info for calcuations
            if (false === _runCallbacks("onresizeall_start")) return false;

            var   // see if container is now 'smaller' than before
                  shrunkH     = (sC.innerHeight < oldH)
            ,     shrunkW     = (sC.innerWidth < oldW)
            ,     $P, o, s
            ;
            // NOTE special order for sizing: S-N-E-W
            $.each(["south","north","east","west"], function (i, pane) {
                  if (!$Ps[pane]) return; // no pane - SKIP
                  o = options[pane];
                  s = state[pane];
                  if (s.autoResize && s.size != o.size) // resize pane to original size set in options
                        sizePane(pane, o.size, true, true, true); // true=skipCallback/noAnimation/forceResize
                  else {
                        setSizeLimits(pane);
                        makePaneFit(pane, false, true, true); // true=skipCallback/forceResize
                  }
            });

            sizeMidPanes("", true, true); // true=skipCallback/forceResize
            sizeHandles(); // reposition the toggler elements

            // trigger all individual pane callbacks AFTER layout has finished resizing
            $.each(_c.allPanes, function (i, pane) {
                  $P = $Ps[pane];
                  if (!$P) return; // SKIP
                  if (state[pane].isVisible) // undefined for non-existent panes
                        _runCallbacks("onresize_end", pane); // callback - if exists
            });

            _runCallbacks("onresizeall_end");
            //_triggerLayoutEvent(pane, 'resizeall');
      }

      /**
      * Whenever a pane resizes or opens that has a nested layout, trigger resizeAll
      *
      * @param {(string|Object)}    evt_or_pane       The pane just resized or opened
      */
,     resizeChildren = function (evt_or_pane, skipRefresh) {
            var   pane = evtPane.call(this, evt_or_pane);

            if (!options[pane].resizeChildren) return;

            // ensure the pane-children are up-to-date
            if (!skipRefresh) refreshChildren( pane );
            var pC = children[pane];
            if ($.isPlainObject( pC )) {
                  // resize one or more children
                  $.each( pC, function (key, child) {
                        if (!child.destroyed) child.resizeAll();
                  });
            }
      }

      /**
      * IF pane has a content-div, then resize all elements inside pane to fit pane-height
      *
      * @param {(string|Object)}    evt_or_panes            The pane(s) being resized
      * @param {boolean=}                 [remeasure=false] Should the content (header/footer) be remeasured?
      */
,     sizeContent = function (evt_or_panes, remeasure) {
            if (!isInitialized()) return;

            var panes = evtPane.call(this, evt_or_panes);
            panes = panes ? panes.split(",") : _c.allPanes;

            $.each(panes, function (idx, pane) {
                  var
                        $P    = $Ps[pane]
                  ,     $C    = $Cs[pane]
                  ,     o     = options[pane]
                  ,     s     = state[pane]
                  ,     m     = s.content // m = measurements
                  ;
                  if (!$P || !$C || !$P.is(":visible")) return true; // NOT VISIBLE - skip

                  // if content-element was REMOVED, update OR remove the pointer
                  if (!$C.length) {
                        initContent(pane, false);     // false = do NOT sizeContent() - already there!
                        if (!$C) return;              // no replacement element found - pointer have been removed
                  }

                  // onsizecontent_start will CANCEL resizing if returns false
                  if (false === _runCallbacks("onsizecontent_start", pane)) return;

                  // skip re-measuring offsets if live-resizing
                  if ((!s.isMoving && !s.isResizing) || o.liveContentResizing || remeasure || m.top == undefined) {
                        _measure();
                        // if any footers are below pane-bottom, they may not measure correctly,
                        // so allow pane overflow and re-measure
                        if (m.hiddenFooters > 0 && $P.css("overflow") === "hidden") {
                              $P.css("overflow", "visible");
                              _measure(); // remeasure while overflowing
                              $P.css("overflow", "hidden");
                        }
                  }
                  // NOTE: spaceAbove/Below *includes* the pane paddingTop/Bottom, but not pane.borders
                  var newH = s.innerHeight - (m.spaceAbove - s.css.paddingTop) - (m.spaceBelow - s.css.paddingBottom);

                  if (!$C.is(":visible") || m.height != newH) {
                        // size the Content element to fit new pane-size - will autoHide if not enough room
                        setOuterHeight($C, newH, true); // true=autoHide
                        m.height = newH; // save new height
                  };

                  if (state.initialized)
                        _runCallbacks("onsizecontent_end", pane);

                  function _below ($E) {
                        return max(s.css.paddingBottom, (parseInt($E.css("marginBottom"), 10) || 0));
                  };

                  function _measure () {
                        var
                              ignore      = options[pane].contentIgnoreSelector
                        ,     $Fs         = $C.nextAll().not(".ui-layout-mask").not(ignore || ":lt(0)") // not :lt(0) = ALL
                        ,     $Fs_vis     = $Fs.filter(':visible')
                        ,     $F          = $Fs_vis.filter(':last')
                        ;
                        m = {
                              top:              $C[0].offsetTop
                        ,     height:                 $C.outerHeight()
                        ,     numFooters:       $Fs.length
                        ,     hiddenFooters:    $Fs.length - $Fs_vis.length
                        ,     spaceBelow:       0 // correct if no content footer ($E)
                        }
                              m.spaceAbove      = m.top; // just for state - not used in calc
                              m.bottom          = m.top + m.height;
                        if ($F.length)
                              //spaceBelow = (LastFooter.top + LastFooter.height) [footerBottom] - Content.bottom + max(LastFooter.marginBottom, pane.paddingBotom)
                              m.spaceBelow = ($F[0].offsetTop + $F.outerHeight()) - m.bottom + _below($F);
                        else // no footer - check marginBottom on Content element itself
                              m.spaceBelow = _below($C);
                  };
            });
      }


      /**
      * Called every time a pane is opened, closed, or resized to slide the togglers to 'center' and adjust their length if necessary
      *
      * @see  initHandles(), open(), close(), resizeAll()
      * @param {(string|Object)=}         evt_or_panes      The pane(s) being resized
      */
,     sizeHandles = function (evt_or_panes) {
            var panes = evtPane.call(this, evt_or_panes)
            panes = panes ? panes.split(",") : _c.borderPanes;

            $.each(panes, function (i, pane) {
                  var 
                        o     = options[pane]
                  ,     s     = state[pane]
                  ,     $P    = $Ps[pane]
                  ,     $R    = $Rs[pane]
                  ,     $T    = $Ts[pane]
                  ,     $TC
                  ;
                  if (!$P || !$R) return;

                  var
                        dir               = _c[pane].dir
                  ,     _state            = (s.isClosed ? "_closed" : "_open")
                  ,     spacing           = o["spacing"+ _state]
                  ,     togAlign    = o["togglerAlign"+ _state]
                  ,     togLen            = o["togglerLength"+ _state]
                  ,     paneLen
                  ,     left
                  ,     offset
                  ,     CSS = {}
                  ;

                  if (spacing === 0) {
                        $R.hide();
                        return;
                  }
                  else if (!s.noRoom && !s.isHidden) // skip if resizer was hidden for any reason
                        $R.show(); // in case was previously hidden

                  // Resizer Bar is ALWAYS same width/height of pane it is attached to
                  if (dir === "horz") { // north/south
                        //paneLen = $P.outerWidth(); // s.outerWidth || 
                        paneLen = sC.innerWidth; // handle offscreen-panes
                        s.resizerLength = paneLen;
                        left = $.layout.cssNum($P, "left")
                        $R.css({
                              width:      cssW($R, paneLen) // account for borders & padding
                        ,     height:     cssH($R, spacing) // ditto
                        ,     left: left > -9999 ? left : sC.inset.left // handle offscreen-panes
                        });
                  }
                  else { // east/west
                        paneLen = $P.outerHeight(); // s.outerHeight || 
                        s.resizerLength = paneLen;
                        $R.css({
                              height:     cssH($R, paneLen) // account for borders & padding
                        ,     width:      cssW($R, spacing) // ditto
                        ,     top:  sC.inset.top + getPaneSize("north", true) // TODO: what if no North pane?
                        //,   top:  $.layout.cssNum($Ps["center"], "top")
                        });
                  }

                  // remove hover classes
                  removeHover( o, $R );

                  if ($T) {
                        if (togLen === 0 || (s.isSliding && o.hideTogglerOnSlide)) {
                              $T.hide(); // always HIDE the toggler when 'sliding'
                              return;
                        }
                        else
                              $T.show(); // in case was previously hidden

                        if (!(togLen > 0) || togLen === "100%" || togLen > paneLen) {
                              togLen = paneLen;
                              offset = 0;
                        }
                        else { // calculate 'offset' based on options.PANE.togglerAlign_open/closed
                              if (isStr(togAlign)) {
                                    switch (togAlign) {
                                          case "top":
                                          case "left":      offset = 0;
                                                                  break;
                                          case "bottom":
                                          case "right":     offset = paneLen - togLen;
                                                                  break;
                                          case "middle":
                                          case "center":
                                          default:          offset = round((paneLen - togLen) / 2); // 'default' catches typos
                                    }
                              }
                              else { // togAlign = number
                                    var x = parseInt(togAlign, 10); //
                                    if (togAlign >= 0) offset = x;
                                    else offset = paneLen - togLen + x; // NOTE: x is negative!
                              }
                        }

                        if (dir === "horz") { // north/south
                              var width = cssW($T, togLen);
                              $T.css({
                                    width:      width  // account for borders & padding
                              ,     height:     cssH($T, spacing) // ditto
                              ,     left: offset // TODO: VERIFY that toggler  positions correctly for ALL values
                              ,     top:  0
                              });
                              // CENTER the toggler content SPAN
                              $T.children(".content").each(function(){
                                    $TC = $(this);
                                    $TC.css("marginLeft", round((width-$TC.outerWidth())/2)); // could be negative
                              });
                        }
                        else { // east/west
                              var height = cssH($T, togLen);
                              $T.css({
                                    height:     height // account for borders & padding
                              ,     width:      cssW($T, spacing) // ditto
                              ,     top:  offset // POSITION the toggler
                              ,     left: 0
                              });
                              // CENTER the toggler content SPAN
                              $T.children(".content").each(function(){
                                    $TC = $(this);
                                    $TC.css("marginTop", round((height-$TC.outerHeight())/2)); // could be negative
                              });
                        }

                        // remove ALL hover classes
                        removeHover( 0, $T );
                  }

                  // DONE measuring and sizing this resizer/toggler, so can be 'hidden' now
                  if (!state.initialized && (o.initHidden || s.isHidden)) {
                        $R.hide();
                        if ($T) $T.hide();
                  }
            });
      }


      /**
      * @param {(string|Object)}    evt_or_pane
      */
,     enableClosable = function (evt_or_pane) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $T    = $Ts[pane]
            ,     o     = options[pane]
            ;
            if (!$T) return;
            o.closable = true;
            $T    .bind("click."+ sID, function(evt){ evt.stopPropagation(); toggle(pane); })
                  .css("visibility", "visible")
                  .attr("title", state[pane].isClosed ? o.tips.Open : o.tips.Close) // may be blank
                  .show();
      }
      /**
      * @param {(string|Object)}    evt_or_pane
      * @param {boolean=}                 [hide=false]
      */
,     disableClosable = function (evt_or_pane, hide) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $T    = $Ts[pane]
            ;
            if (!$T) return;
            options[pane].closable = false;
            // is closable is disable, then pane MUST be open!
            if (state[pane].isClosed) open(pane, false, true);
            $T    .unbind("."+ sID)
                  .css("visibility", hide ? "hidden" : "visible") // instead of hide(), which creates logic issues
                  .css("cursor", "default")
                  .attr("title", "");
      }


      /**
      * @param {(string|Object)}    evt_or_pane
      */
,     enableSlidable = function (evt_or_pane) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $R    = $Rs[pane]
            ;
            if (!$R || !$R.data('draggable')) return;
            options[pane].slidable = true; 
            if (state[pane].isClosed)
                  bindStartSlidingEvents(pane, true);
      }
      /**
      * @param {(string|Object)}    evt_or_pane
      */
,     disableSlidable = function (evt_or_pane) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $R    = $Rs[pane]
            ;
            if (!$R) return;
            options[pane].slidable = false; 
            if (state[pane].isSliding)
                  close(pane, false, true);
            else {
                  bindStartSlidingEvents(pane, false);
                  $R    .css("cursor", "default")
                        .attr("title", "");
                  removeHover(null, $R[0]); // in case currently hovered
            }
      }


      /**
      * @param {(string|Object)}    evt_or_pane
      */
,     enableResizable = function (evt_or_pane) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $R    = $Rs[pane]
            ,     o     = options[pane]
            ;
            if (!$R || !$R.data('draggable')) return;
            o.resizable = true; 
            $R.draggable("enable");
            if (!state[pane].isClosed)
                  $R    .css("cursor", o.resizerCursor)
                        .attr("title", o.tips.Resize);
      }
      /**
      * @param {(string|Object)}    evt_or_pane
      */
,     disableResizable = function (evt_or_pane) {
            if (!isInitialized()) return;
            var   pane = evtPane.call(this, evt_or_pane)
            ,     $R    = $Rs[pane]
            ;
            if (!$R || !$R.data('draggable')) return;
            options[pane].resizable = false; 
            $R    .draggable("disable")
                  .css("cursor", "default")
                  .attr("title", "");
            removeHover(null, $R[0]); // in case currently hovered
      }


      /**
      * Move a pane from source-side (eg, west) to target-side (eg, east)
      * If pane exists on target-side, move that to source-side, ie, 'swap' the panes
      *
      * @param {(string|Object)}    evt_or_pane1      The pane/edge being swapped
      * @param {string}             pane2             ditto
      */
,     swapPanes = function (evt_or_pane1, pane2) {
            if (!isInitialized()) return;
            var pane1 = evtPane.call(this, evt_or_pane1);
            // change state.edge NOW so callbacks can know where pane is headed...
            state[pane1].edge = pane2;
            state[pane2].edge = pane1;
            // run these even if NOT state.initialized
            if (false === _runCallbacks("onswap_start", pane1)
             ||   false === _runCallbacks("onswap_start", pane2)
            ) {
                  state[pane1].edge = pane1; // reset
                  state[pane2].edge = pane2;
                  return;
            }

            var
                  oPane1      = copy( pane1 )
            ,     oPane2      = copy( pane2 )
            ,     sizes = {}
            ;
            sizes[pane1] = oPane1 ? oPane1.state.size : 0;
            sizes[pane2] = oPane2 ? oPane2.state.size : 0;

            // clear pointers & state
            $Ps[pane1] = false; 
            $Ps[pane2] = false;
            state[pane1] = {};
            state[pane2] = {};
            
            // ALWAYS remove the resizer & toggler elements
            if ($Ts[pane1]) $Ts[pane1].remove();
            if ($Ts[pane2]) $Ts[pane2].remove();
            if ($Rs[pane1]) $Rs[pane1].remove();
            if ($Rs[pane2]) $Rs[pane2].remove();
            $Rs[pane1] = $Rs[pane2] = $Ts[pane1] = $Ts[pane2] = false;

            // transfer element pointers and data to NEW Layout keys
            move( oPane1, pane2 );
            move( oPane2, pane1 );

            // cleanup objects
            oPane1 = oPane2 = sizes = null;

            // make panes 'visible' again
            if ($Ps[pane1]) $Ps[pane1].css(_c.visible);
            if ($Ps[pane2]) $Ps[pane2].css(_c.visible);

            // fix any size discrepancies caused by swap
            resizeAll();

            // run these even if NOT state.initialized
            _runCallbacks("onswap_end", pane1);
            _runCallbacks("onswap_end", pane2);

            return;

            function copy (n) { // n = pane
                  var
                        $P    = $Ps[n]
                  ,     $C    = $Cs[n]
                  ;
                  return !$P ? false : {
                        pane:       n
                  ,     P:                $P ? $P[0] : false
                  ,     C:                $C ? $C[0] : false
                  ,     state:            $.extend(true, {}, state[n])
                  ,     options:    $.extend(true, {}, options[n])
                  }
            };

            function move (oPane, pane) {
                  if (!oPane) return;
                  var
                        P           = oPane.P
                  ,     C           = oPane.C
                  ,     oldPane = oPane.pane
                  ,     c           = _c[pane]
                  //    save pane-options that should be retained
                  ,     s           = $.extend(true, {}, state[pane])
                  ,     o           = options[pane]
                  //    RETAIN side-specific FX Settings - more below
                  ,     fx          = { resizerCursor: o.resizerCursor }
                  ,     re, size, pos
                  ;
                  $.each("fxName,fxSpeed,fxSettings".split(","), function (i, k) {
                        fx[k +"_open"]  = o[k +"_open"];
                        fx[k +"_close"] = o[k +"_close"];
                        fx[k +"_size"]  = o[k +"_size"];
                  });

                  // update object pointers and attributes
                  $Ps[pane] = $(P)
                        .data({
                              layoutPane:       Instance[pane]    // NEW pointer to pane-alias-object
                        ,     layoutEdge:       pane
                        })
                        .css(_c.hidden)
                        .css(c.cssReq)
                  ;
                  $Cs[pane] = C ? $(C) : false;

                  // set options and state
                  options[pane]     = $.extend(true, {}, oPane.options, fx);
                  state[pane]       = $.extend(true, {}, oPane.state);

                  // change classNames on the pane, eg: ui-layout-pane-east ==> ui-layout-pane-west
                  re = new RegExp(o.paneClass +"-"+ oldPane, "g");
                  P.className = P.className.replace(re, o.paneClass +"-"+ pane);

                  // ALWAYS regenerate the resizer & toggler elements
                  initHandles(pane); // create the required resizer & toggler

                  // if moving to different orientation, then keep 'target' pane size
                  if (c.dir != _c[oldPane].dir) {
                        size = sizes[pane] || 0;
                        setSizeLimits(pane); // update pane-state
                        size = max(size, state[pane].minSize);
                        // use manualSizePane to disable autoResize - not useful after panes are swapped
                        manualSizePane(pane, size, true, true); // true/true = skipCallback/noAnimation
                  }
                  else // move the resizer here
                        $Rs[pane].css(c.side, sC.inset[c.side] + (state[pane].isVisible ? getPaneSize(pane) : 0));


                  // ADD CLASSNAMES & SLIDE-BINDINGS
                  if (oPane.state.isVisible && !s.isVisible)
                        setAsOpen(pane, true); // true = skipCallback
                  else {
                        setAsClosed(pane);
                        bindStartSlidingEvents(pane, true); // will enable events IF option is set
                  }

                  // DESTROY the object
                  oPane = null;
            };
      }


      /**
      * INTERNAL method to sync pin-buttons when pane is opened or closed
      * Unpinned means the pane is 'sliding' - ie, over-top of the adjacent panes
      *
      * @see  open(), setAsOpen(), setAsClosed()
      * @param {string} pane   These are the params returned to callbacks by layout()
      * @param {boolean}      doPin  True means set the pin 'down', False means 'up'
      */
,     syncPinBtns = function (pane, doPin) {
            if ($.layout.plugins.buttons)
                  $.each(state[pane].pins, function (i, selector) {
                        $.layout.buttons.setPinState(Instance, $(selector), pane, doPin);
                  });
      }

;     // END var DECLARATIONS

      /**
      * Capture keys when enableCursorHotkey - toggle pane if hotkey pressed
      *
      * @see  document.keydown()
      */
      function keyDown (evt) {
            if (!evt) return true;
            var code = evt.keyCode;
            if (code < 33) return true; // ignore special keys: ENTER, TAB, etc

            var
                  PANE = {
                        38: "north" // Up Cursor      - $.ui.keyCode.UP
                  ,     40: "south" // Down Cursor    - $.ui.keyCode.DOWN
                  ,     37: "west"  // Left Cursor    - $.ui.keyCode.LEFT
                  ,     39: "east"  // Right Cursor   - $.ui.keyCode.RIGHT
                  }
            ,     ALT         = evt.altKey // no worky!
            ,     SHIFT = evt.shiftKey
            ,     CTRL  = evt.ctrlKey
            ,     CURSOR      = (CTRL && code >= 37 && code <= 40)
            ,     o, k, m, pane
            ;

            if (CURSOR && options[PANE[code]].enableCursorHotkey) // valid cursor-hotkey
                  pane = PANE[code];
            else if (CTRL || SHIFT) // check to see if this matches a custom-hotkey
                  $.each(_c.borderPanes, function (i, p) { // loop each pane to check its hotkey
                        o = options[p];
                        k = o.customHotkey;
                        m = o.customHotkeyModifier; // if missing or invalid, treated as "CTRL+SHIFT"
                        if ((SHIFT && m=="SHIFT") || (CTRL && m=="CTRL") || (CTRL && SHIFT)) { // Modifier matches
                              if (k && code === (isNaN(k) || k <= 9 ? k.toUpperCase().charCodeAt(0) : k)) { // Key matches
                                    pane = p;
                                    return false; // BREAK
                              }
                        }
                  });

            // validate pane
            if (!pane || !$Ps[pane] || !options[pane].closable || state[pane].isHidden)
                  return true;

            toggle(pane);

            evt.stopPropagation();
            evt.returnValue = false; // CANCEL key
            return false;
      };


/*
 * ######################################
 *    UTILITY METHODS
 *    called externally or by initButtons
 * ######################################
 */

      /**
      * Change/reset a pane overflow setting & zIndex to allow popups/drop-downs to work
      *
      * @param {Object=}   [el]     (optional) Can also be 'bound' to a click, mouseOver, or other event
      */
      function allowOverflow (el) {
            if (!isInitialized()) return;
            if (this && this.tagName) el = this; // BOUND to element
            var $P;
            if (isStr(el))
                  $P = $Ps[el];
            else if ($(el).data("layoutRole"))
                  $P = $(el);
            else
                  $(el).parents().each(function(){
                        if ($(this).data("layoutRole")) {
                              $P = $(this);
                              return false; // BREAK
                        }
                  });
            if (!$P || !$P.length) return; // INVALID

            var
                  pane  = $P.data("layoutEdge")
            ,     s           = state[pane]
            ;

            // if pane is already raised, then reset it before doing it again!
            // this would happen if allowOverflow is attached to BOTH the pane and an element 
            if (s.cssSaved)
                  resetOverflow(pane); // reset previous CSS before continuing

            // if pane is raised by sliding or resizing, or its closed, then abort
            if (s.isSliding || s.isResizing || s.isClosed) {
                  s.cssSaved = false;
                  return;
            }

            var
                  newCSS      = { zIndex: (options.zIndexes.resizer_normal + 1) }
            ,     curCSS      = {}
            ,     of          = $P.css("overflow")
            ,     ofX         = $P.css("overflowX")
            ,     ofY         = $P.css("overflowY")
            ;
            // determine which, if any, overflow settings need to be changed
            if (of != "visible") {
                  curCSS.overflow = of;
                  newCSS.overflow = "visible";
            }
            if (ofX && !ofX.match(/(visible|auto)/)) {
                  curCSS.overflowX = ofX;
                  newCSS.overflowX = "visible";
            }
            if (ofY && !ofY.match(/(visible|auto)/)) {
                  curCSS.overflowY = ofX;
                  newCSS.overflowY = "visible";
            }

            // save the current overflow settings - even if blank!
            s.cssSaved = curCSS;

            // apply new CSS to raise zIndex and, if necessary, make overflow 'visible'
            $P.css( newCSS );

            // make sure the zIndex of all other panes is normal
            $.each(_c.allPanes, function(i, p) {
                  if (p != pane) resetOverflow(p);
            });

      };
      /**
      * @param {Object=}   [el]     (optional) Can also be 'bound' to a click, mouseOver, or other event
      */
      function resetOverflow (el) {
            if (!isInitialized()) return;
            if (this && this.tagName) el = this; // BOUND to element
            var $P;
            if (isStr(el))
                  $P = $Ps[el];
            else if ($(el).data("layoutRole"))
                  $P = $(el);
            else
                  $(el).parents().each(function(){
                        if ($(this).data("layoutRole")) {
                              $P = $(this);
                              return false; // BREAK
                        }
                  });
            if (!$P || !$P.length) return; // INVALID

            var
                  pane  = $P.data("layoutEdge")
            ,     s           = state[pane]
            ,     CSS         = s.cssSaved || {}
            ;
            // reset the zIndex
            if (!s.isSliding && !s.isResizing)
                  $P.css("zIndex", options.zIndexes.pane_normal);

            // reset Overflow - if necessary
            $P.css( CSS );

            // clear var
            s.cssSaved = false;
      };

/*
 * #####################
 * CREATE/RETURN LAYOUT
 * #####################
 */

      // validate that container exists
      var $N = $(this).eq(0); // FIRST matching Container element
      if (!$N.length) {
            return _log( options.errors.containerMissing );
      };

      // Users retrieve Instance of a layout with: $N.layout() OR $N.data("layout")
      // return the Instance-pointer if layout has already been initialized
      if ($N.data("layoutContainer") && $N.data("layout"))
            return $N.data("layout"); // cached pointer

      // init global vars
      var 
            $Ps   = {}  // Panes x5       - set in initPanes()
      ,     $Cs   = {}  // Content x5     - set in initPanes()
      ,     $Rs   = {}  // Resizers x4    - set in initHandles()
      ,     $Ts   = {}  // Togglers x4    - set in initHandles()
      ,     $Ms   = $([])     // Masks - up to 2 masks per pane (IFRAME + DIV)
      //    aliases for code brevity
      ,     sC    = state.container // alias for easy access to 'container dimensions'
      ,     sID   = state.id // alias for unique layout ID/namespace - eg: "layout435"
      ;

      // create Instance object to expose data & option Properties, and primary action Methods
      var Instance = {
      //    layout data
            options:                options                 // property - options hash
      ,     state:                        state             // property - dimensions hash
      //    object pointers
      ,     container:              $N                      // property - object pointers for layout container
      ,     panes:                        $Ps                     // property - object pointers for ALL Panes: panes.north, panes.center
      ,     contents:               $Cs                     // property - object pointers for ALL Content: contents.north, contents.center
      ,     resizers:               $Rs                     // property - object pointers for ALL Resizers, eg: resizers.north
      ,     togglers:               $Ts                     // property - object pointers for ALL Togglers, eg: togglers.north
      //    border-pane open/close
      ,     hide:                   hide              // method - ditto
      ,     show:                   show              // method - ditto
      ,     toggle:                       toggle                  // method - pass a 'pane' ("north", "west", etc)
      ,     open:                   open              // method - ditto
      ,     close:                        close             // method - ditto
      ,     slideOpen:              slideOpen         // method - ditto
      ,     slideClose:             slideClose        // method - ditto
      ,     slideToggle:            slideToggle       // method - ditto
      //    pane actions
      ,     setSizeLimits:          setSizeLimits     // method - pass a 'pane' - update state min/max data
      ,     _sizePane:              sizePane          // method -intended for user by plugins only!
      ,     sizePane:               manualSizePane    // method - pass a 'pane' AND an 'outer-size' in pixels or percent, or 'auto'
      ,     sizeContent:            sizeContent       // method - pass a 'pane'
      ,     swapPanes:              swapPanes         // method - pass TWO 'panes' - will swap them
      ,     showMasks:              showMasks         // method - pass a 'pane' OR list of panes - default = all panes with mask option set
      ,     hideMasks:              hideMasks         // method - ditto'
      //    pane element methods
      ,     initContent:            initContent       // method - ditto
      ,     addPane:                addPane                 // method - pass a 'pane'
      ,     removePane:             removePane        // method - pass a 'pane' to remove from layout, add 'true' to delete the pane-elem
      ,     createChildren:         createChildren    // method - pass a 'pane' and (optional) layout-options (OVERRIDES options[pane].children
      ,     refreshChildren:  refreshChildren   // method - pass a 'pane' and a layout-instance
      //    special pane option setting
      ,     enableClosable:         enableClosable    // method - pass a 'pane'
      ,     disableClosable:  disableClosable   // method - ditto
      ,     enableSlidable:         enableSlidable    // method - ditto
      ,     disableSlidable:  disableSlidable   // method - ditto
      ,     enableResizable:  enableResizable   // method - ditto
      ,     disableResizable: disableResizable// method - ditto
      //    utility methods for panes
      ,     allowOverflow:          allowOverflow     // utility - pass calling element (this)
      ,     resetOverflow:          resetOverflow     // utility - ditto
      //    layout control
      ,     destroy:                destroy                 // method - no parameters
      ,     initPanes:              isInitialized     // method - no parameters
      ,     resizeAll:              resizeAll         // method - no parameters
      //    callback triggering
      ,     runCallbacks:           _runCallbacks     // method - pass evtName & pane (if a pane-event), eg: trigger("onopen", "west")
      //    alias collections of options, state and children - created in addPane and extended elsewhere
      ,     hasParentLayout:  false             // set by initContainer()
      ,     children:               children          // pointers to child-layouts, eg: Instance.children.west.layoutName
      ,     north:                        false             // alias group: { name: pane, pane: $Ps[pane], options: options[pane], state: state[pane], children: children[pane] }
      ,     south:                        false             // ditto
      ,     west:                   false             // ditto
      ,     east:                   false             // ditto
      ,     center:                       false             // ditto
      };

      // create the border layout NOW
      if (_create() === 'cancel') // onload_start callback returned false to CANCEL layout creation
            return null;
      else // true OR false -- if layout-elements did NOT init (hidden or do not exist), can auto-init later
            return Instance; // return the Instance object

}


})( jQuery );
// END Layout - keep internal vars internal!



// START Plugins - shared wrapper, no global vars
(function ($) {


/**
 * jquery.layout.state 1.0
 * $Date: 2011-07-16 08:00:00 (Sat, 16 July 2011) $
 *
 * Copyright (c) 2012 
 *   Kevin Dalman (http://allpro.net)
 *
 * Dual licensed under the GPL (http://www.gnu.org/licenses/gpl.html)
 * and MIT (http://www.opensource.org/licenses/mit-license.php) licenses.
 *
 * @requires: UI Layout 1.3.0.rc30.1 or higher
 * @requires: $.ui.cookie (above)
 *
 * @see: http://groups.google.com/group/jquery-ui-layout
 */
/*
 *    State-management options stored in options.stateManagement, which includes a .cookie hash
 *    Default options saves ALL KEYS for ALL PANES, ie: pane.size, pane.isClosed, pane.isHidden
 *
 *    // STATE/COOKIE OPTIONS
 *    @example $(el).layout({
                        stateManagement: {
                              enabled:    true
                        ,     stateKeys:  "east.size,west.size,east.isClosed,west.isClosed"
                        ,     cookie:           { name: "appLayout", path: "/" }
                        }
                  })
 *    @example $(el).layout({ stateManagement__enabled: true }) // enable auto-state-management using cookies
 *    @example $(el).layout({ stateManagement__cookie: { name: "appLayout", path: "/" } })
 *    @example $(el).layout({ stateManagement__cookie__name: "appLayout", stateManagement__cookie__path: "/" })
 *
 *    // STATE/COOKIE METHODS
 *    @example myLayout.saveCookie( "west.isClosed,north.size,south.isHidden", {expires: 7} );
 *    @example myLayout.loadCookie();
 *    @example myLayout.deleteCookie();
 *    @example var JSON = myLayout.readState(); // CURRENT Layout State
 *    @example var JSON = myLayout.readCookie();      // SAVED Layout State (from cookie)
 *    @example var JSON = myLayout.state.stateData;   // LAST LOADED Layout State (cookie saved in layout.state hash)
 *
 *    CUSTOM STATE-MANAGEMENT (eg, saved in a database)
 *    @example var JSON = myLayout.readState( "west.isClosed,north.size,south.isHidden" );
 *    @example myLayout.loadState( JSON );
 */

/**
 *    UI COOKIE UTILITY
 *
 *    A $.cookie OR $.ui.cookie namespace *should be standard*, but until then...
 *    This creates $.ui.cookie so Layout does not need the cookie.jquery.js plugin
 *    NOTE: This utility is REQUIRED by the layout.state plugin
 *
 *    Cookie methods in Layout are created as part of State Management 
 */
if (!$.ui) $.ui = {};
$.ui.cookie = {

      // cookieEnabled is not in DOM specs, but DOES works in all browsers,including IE6
      acceptsCookies: !!navigator.cookieEnabled

,     read: function (name) {
            var   c           = document.cookie
            ,     cs          = c ? c.split(';') : []
            ,     pair  // loop var
            ;
            for (var i=0, n=cs.length; i < n; i++) {
                  pair = $.trim(cs[i]).split('='); // name=value pair
                  if (pair[0] == name) // found the layout cookie
                        return decodeURIComponent(pair[1]);
            }
            return null;
      }

,     write: function (name, val, cookieOpts) {
            var   params      = ""
            ,     date  = ""
            ,     clear = false
            ,     o           = cookieOpts || {}
            ,     x           = o.expires  || null
            ,     t           = $.type(x)
            ;
            if (t === "date")
                  date = x;
            else if (t === "string" && x > 0) {
                  x = parseInt(x,10);
                  t = "number";
            }
            if (t === "number") {
                  date = new Date();
                  if (x > 0)
                        date.setDate(date.getDate() + x);
                  else {
                        date.setFullYear(1970);
                        clear = true;
                  }
            }
            if (date)         params += ";expires="+ date.toUTCString();
            if (o.path)       params += ";path="+ o.path;
            if (o.domain)     params += ";domain="+ o.domain;
            if (o.secure)     params += ";secure";
            document.cookie = name +"="+ (clear ? "" : encodeURIComponent( val )) + params; // write or clear cookie
      }

,     clear: function (name) {
            $.ui.cookie.write(name, "", {expires: -1});
      }

};
// if cookie.jquery.js is not loaded, create an alias to replicate it
// this may be useful to other plugins or code dependent on that plugin
if (!$.cookie) $.cookie = function (k, v, o) {
      var C = $.ui.cookie;
      if (v === null)
            C.clear(k);
      else if (v === undefined)
            return C.read(k);
      else
            C.write(k, v, o);
};


// tell Layout that the state plugin is available
$.layout.plugins.stateManagement = true;

//    Add State-Management options to layout.defaults
$.layout.config.optionRootKeys.push("stateManagement");
$.layout.defaults.stateManagement = {
      enabled:          false // true = enable state-management, even if not using cookies
,     autoSave:         true  // Save a state-cookie when page exits?
,     autoLoad:         true  // Load the state-cookie when Layout inits?
,     animateLoad:      true  // animate panes when loading state into an active layout
,     includeChildren: true   // recurse into child layouts to include their state as well
      // List state-data to save - must be pane-specific
,     stateKeys:  "north.size,south.size,east.size,west.size,"+
                        "north.isClosed,south.isClosed,east.isClosed,west.isClosed,"+
                        "north.isHidden,south.isHidden,east.isHidden,west.isHidden"
,     cookie: {
            name: ""    // If not specified, will use Layout.name, else just "Layout"
      ,     domain:     ""    // blank = current domain
      ,     path: ""    // blank = current page, "/" = entire website
      ,     expires: "" // 'days' to keep cookie - leave blank for 'session cookie'
      ,     secure:     false
      }
};
// Set stateManagement as a layout-option, NOT a pane-option
$.layout.optionsMap.layout.push("stateManagement");

/*
 *    State Management methods
 */
$.layout.state = {

      /**
       * Get the current layout state and save it to a cookie
       *
       * myLayout.saveCookie( keys, cookieOpts )
       *
       * @param {Object}                  inst
       * @param {(string|Array)=}   keys
       * @param {Object=}                 cookieOpts
       */
      saveCookie: function (inst, keys, cookieOpts) {
            var o = inst.options
            ,     sm    = o.stateManagement
            ,     oC    = $.extend(true, {}, sm.cookie, cookieOpts || null)
            ,     data = inst.state.stateData = inst.readState( keys || sm.stateKeys ) // read current panes-state
            ;
            $.ui.cookie.write( oC.name || o.name || "Layout", $.layout.state.encodeJSON(data), oC );
            return $.extend(true, {}, data); // return COPY of state.stateData data
      }

      /**
       * Remove the state cookie
       *
       * @param {Object}      inst
       */
,     deleteCookie: function (inst) {
            var o = inst.options;
            $.ui.cookie.clear( o.stateManagement.cookie.name || o.name || "Layout" );
      }

      /**
       * Read & return data from the cookie - as JSON
       *
       * @param {Object}      inst
       */
,     readCookie: function (inst) {
            var o = inst.options;
            var c = $.ui.cookie.read( o.stateManagement.cookie.name || o.name || "Layout" );
            // convert cookie string back to a hash and return it
            return c ? $.layout.state.decodeJSON(c) : {};
      }

      /**
       * Get data from the cookie and USE IT to loadState
       *
       * @param {Object}      inst
       */
,     loadCookie: function (inst) {
            var c = $.layout.state.readCookie(inst); // READ the cookie
            if (c) {
                  inst.state.stateData = $.extend(true, {}, c); // SET state.stateData
                  inst.loadState(c); // LOAD the retrieved state
            }
            return c;
      }

      /**
       * Update layout options from the cookie, if one exists
       *
       * @param {Object}            inst
       * @param {Object=}           stateData
       * @param {boolean=}    animate
       */
,     loadState: function (inst, data, opts) {
            if (!$.isPlainObject( data ) || $.isEmptyObject( data )) return;

            // normalize data & cache in the state object
            data = inst.state.stateData = $.layout.transformData( data ); // panes = default subkey

            // add missing/default state-restore options
            var smo = inst.options.stateManagement;
            opts = $.extend({
                  animateLoad:            false //smo.animateLoad
            ,     includeChildren:  smo.includeChildren
            }, opts );

            if (!inst.state.initialized) {
                  /*
                   *    layout NOT initialized, so just update its options
                   */
                  // MUST remove pane.children keys before applying to options
                  // use a copy so we don't remove keys from original data
                  var o = $.extend(true, {}, data);
                  //delete o.center; // center has no state-data - only children
                  $.each($.layout.config.allPanes, function (idx, pane) {
                        if (o[pane]) delete o[pane].children;              
                   });
                  // update CURRENT layout-options with saved state data
                  $.extend(true, inst.options, o);
            }
            else {
                  /*
                   *    layout already initialized, so modify layout's configuration
                   */
                  var noAnimate = !opts.animateLoad
                  ,     o, c, h, state, open
                  ;
                  $.each($.layout.config.borderPanes, function (idx, pane) {
                        o = data[ pane ];
                        if (!$.isPlainObject( o )) return; // no key, skip pane

                        s     = o.size;
                        c     = o.initClosed;
                        h     = o.initHidden;
                        ar    = o.autoResize
                        state = inst.state[pane];
                        open  = state.isVisible;

                        // reset autoResize
                        if (ar)
                              state.autoResize = ar;
                        // resize BEFORE opening
                        if (!open)
                              inst._sizePane(pane, s, false, false, false); // false=skipCallback/noAnimation/forceResize
                        // open/close as necessary - DO NOT CHANGE THIS ORDER!
                        if (h === true)               inst.hide(pane, noAnimate);
                        else if (c === true)    inst.close(pane, false, noAnimate);
                        else if (c === false)   inst.open (pane, false, noAnimate);
                        else if (h === false)   inst.show (pane, false, noAnimate);
                        // resize AFTER any other actions
                        if (open)
                              inst._sizePane(pane, s, false, false, noAnimate); // animate resize if option passed
                  });

                  /*
                   *    RECURSE INTO CHILD-LAYOUTS
                   */
                  if (opts.includeChildren) {
                        var paneStateChildren, childState;
                        $.each(inst.children, function (pane, paneChildren) {
                              paneStateChildren = data[pane] ? data[pane].children : 0;
                              if (paneStateChildren && paneChildren) {
                                    $.each(paneChildren, function (stateKey, child) {
                                          childState = paneStateChildren[stateKey];
                                          if (child && childState)
                                                child.loadState( childState );
                                    });
                              }
                        });
                  }
            }
      }

      /**
       * Get the *current layout state* and return it as a hash
       *
       * @param {Object=}           inst  // Layout instance to get state for
       * @param {object=}           [opts]      // State-Managements override options
       */
,     readState: function (inst, opts) {
            // backward compatility
            if ($.type(opts) === 'string') opts = { keys: opts };
            if (!opts) opts = {};
            var   sm          = inst.options.stateManagement
            ,     ic          = opts.includeChildren
            ,     recurse     = ic !== undefined ? ic : sm.includeChildren
            ,     keys  = opts.stateKeys || sm.stateKeys
            ,     alt         = { isClosed: 'initClosed', isHidden: 'initHidden' }
            ,     state = inst.state
            ,     panes = $.layout.config.allPanes
            ,     data  = {}
            ,     pair, pane, key, val
            ,     ps, pC, child, array, count, branch
            ;
            if ($.isArray(keys)) keys = keys.join(",");
            // convert keys to an array and change delimiters from '__' to '.'
            keys = keys.replace(/__/g, ".").split(',');
            // loop keys and create a data hash
            for (var i=0, n=keys.length; i < n; i++) {
                  pair = keys[i].split(".");
                  pane = pair[0];
                  key  = pair[1];
                  if ($.inArray(pane, panes) < 0) continue; // bad pane!
                  val = state[ pane ][ key ];
                  if (val == undefined) continue;
                  if (key=="isClosed" && state[pane]["isSliding"])
                        val = true; // if sliding, then *really* isClosed
                  ( data[pane] || (data[pane]={}) )[ alt[key] ? alt[key] : key ] = val;
            }

            // recurse into the child-layouts for each pane
            if (recurse) {
                  $.each(panes, function (idx, pane) {
                        pC = inst.children[pane];
                        ps = state.stateData[pane];
                        if ($.isPlainObject( pC ) && !$.isEmptyObject( pC )) {
                              // ensure a key exists for this 'pane', eg: branch = data.center
                              branch = data[pane] || (data[pane] = {});
                              if (!branch.children) branch.children = {};
                              $.each( pC, function (key, child) {
                                    // ONLY read state from an initialize layout
                                    if ( child.state.initialized )
                                          branch.children[ key ] = $.layout.state.readState( child );
                                    // if we have PREVIOUS (onLoad) state for this child-layout, KEEP IT!
                                    else if ( ps && ps.children && ps.children[ key ] ) {
                                          branch.children[ key ] = $.extend(true, {}, ps.children[ key ] );
                                    }
                              });
                        }
                  });
            }

            return data;
      }

      /**
       *    Stringify a JSON hash so can save in a cookie or db-field
       */
,     encodeJSON: function (JSON) {
            return parse(JSON);
            function parse (h) {
                  var D=[], i=0, k, v, t // k = key, v = value
                  ,     a = $.isArray(h)
                  ;
                  for (k in h) {
                        v = h[k];
                        t = typeof v;
                        if (t == 'string')            // STRING - add quotes
                              v = '"'+ v +'"';
                        else if (t == 'object') // SUB-KEY - recurse into it
                              v = parse(v);
                        D[i++] = (!a ? '"'+ k +'":' : '') + v;
                  }
                  return (a ? '[' : '{') + D.join(',') + (a ? ']' : '}');
            };
      }

      /**
       *    Convert stringified JSON back to a hash object
       *    @see        $.parseJSON(), adding in jQuery 1.4.1
       */
,     decodeJSON: function (str) {
            try { return $.parseJSON ? $.parseJSON(str) : window["eval"]("("+ str +")") || {}; }
            catch (e) { return {}; }
      }


,     _create: function (inst) {
            var _ = $.layout.state
            ,     o     = inst.options
            ,     sm    = o.stateManagement
            ;
            //    ADD State-Management plugin methods to inst
             $.extend( inst, {
            //    readCookie - update options from cookie - returns hash of cookie data
                  readCookie:       function () { return _.readCookie(inst); }
            //    deleteCookie
            ,     deleteCookie:     function () { _.deleteCookie(inst); }
            //    saveCookie - optionally pass keys-list and cookie-options (hash)
            ,     saveCookie:       function (keys, cookieOpts) { return _.saveCookie(inst, keys, cookieOpts); }
            //    loadCookie - readCookie and use to loadState() - returns hash of cookie data
            ,     loadCookie:       function () { return _.loadCookie(inst); }
            //    loadState - pass a hash of state to use to update options
            ,     loadState:        function (stateData, opts) { _.loadState(inst, stateData, opts); }
            //    readState - returns hash of current layout-state
            ,     readState:        function (keys) { return _.readState(inst, keys); }
            //    add JSON utility methods too...
            ,     encodeJSON:       _.encodeJSON
            ,     decodeJSON:       _.decodeJSON
            });

            // init state.stateData key, even if plugin is initially disabled
            inst.state.stateData = {};

            // autoLoad MUST BE one of: data-array, data-hash, callback-function, or TRUE
            if ( !sm.autoLoad ) return;

            //    When state-data exists in the autoLoad key USE IT,
            //    even if stateManagement.enabled == false
            if ($.isPlainObject( sm.autoLoad )) {
                  if (!$.isEmptyObject( sm.autoLoad )) {
                        inst.loadState( sm.autoLoad );
                  }
            }
            else if ( sm.enabled ) {
                  // update the options from cookie or callback
                  // if options is a function, call it to get stateData
                  if ($.isFunction( sm.autoLoad )) {
                        var d = {};
                        try {
                              d = sm.autoLoad( inst, inst.state, inst.options, inst.options.name || '' ); // try to get data from fn
                        } catch (e) {}
                        if (d && $.isPlainObject( d ) && !$.isEmptyObject( d ))
                              inst.loadState(d);
                  }
                  else // any other truthy value will trigger loadCookie
                        inst.loadCookie();
            }
      }

,     _unload: function (inst) {
            var sm = inst.options.stateManagement;
            if (sm.enabled && sm.autoSave) {
                  // if options is a function, call it to save the stateData
                  if ($.isFunction( sm.autoSave )) {
                        try {
                              sm.autoSave( inst, inst.state, inst.options, inst.options.name || '' ); // try to get data from fn
                        } catch (e) {}
                  }
                  else // any truthy value will trigger saveCookie
                        inst.saveCookie();
            }
      }

};

// add state initialization method to Layout's onCreate array of functions
$.layout.onCreate.push( $.layout.state._create );
$.layout.onUnload.push( $.layout.state._unload );




/**
 * jquery.layout.buttons 1.0
 * $Date: 2011-07-16 08:00:00 (Sat, 16 July 2011) $
 *
 * Copyright (c) 2012 
 *   Kevin Dalman (http://allpro.net)
 *
 * Dual licensed under the GPL (http://www.gnu.org/licenses/gpl.html)
 * and MIT (http://www.opensource.org/licenses/mit-license.php) licenses.
 *
 * @requires: UI Layout 1.3.0.rc30.1 or higher
 *
 * @see: http://groups.google.com/group/jquery-ui-layout
 *
 * Docs: [ to come ]
 * Tips: [ to come ]
 */

// tell Layout that the state plugin is available
$.layout.plugins.buttons = true;

//    Add buttons options to layout.defaults
$.layout.defaults.autoBindCustomButtons = false;
// Specify autoBindCustomButtons as a layout-option, NOT a pane-option
$.layout.optionsMap.layout.push("autoBindCustomButtons");

/*
 *    Button methods
 */
$.layout.buttons = {

      /**
      * Searches for .ui-layout-button-xxx elements and auto-binds them as layout-buttons
      *
      * @see  _create()
      *
      * @param  {Object}            inst  Layout Instance object
      */
      init: function (inst) {
            var pre           = "ui-layout-button-"
            ,     layout      = inst.options.name || ""
            ,     name;
            $.each("toggle,open,close,pin,toggle-slide,open-slide".split(","), function (i, action) {
                  $.each($.layout.config.borderPanes, function (ii, pane) {
                        $("."+pre+action+"-"+pane).each(function(){
                              // if button was previously 'bound', data.layoutName was set, but is blank if layout has no 'name'
                              name = $(this).data("layoutName") || $(this).attr("layoutName");
                              if (name == undefined || name === layout)
                                    inst.bindButton(this, action, pane);
                        });
                  });
            });
      }

      /**
      * Helper function to validate params received by addButton utilities
      *
      * Two classes are added to the element, based on the buttonClass...
      * The type of button is appended to create the 2nd className:
      *  - ui-layout-button-pin           // action btnClass
      *  - ui-layout-button-pin-west      // action btnClass + pane
      *  - ui-layout-button-toggle
      *  - ui-layout-button-open
      *  - ui-layout-button-close
      *
      * @param {Object}             inst        Layout Instance object
      * @param {(string|!Object)}   selector    jQuery selector (or element) for button, eg: ".ui-layout-north .toggle-button"
      * @param {string}             pane        Name of the pane the button is for: 'north', 'south', etc.
      *
      * @return {Array.<Object>}    If both params valid, the element matching 'selector' in a jQuery wrapper - otherwise returns null
      */
,     get: function (inst, selector, pane, action) {
            var $E      = $(selector)
            ,     o     = inst.options
            ,     err   = o.errors.addButtonError
            ;
            if (!$E.length) { // element not found
                  $.layout.msg(err +" "+ o.errors.selector +": "+ selector, true);
            }
            else if ($.inArray(pane, $.layout.config.borderPanes) < 0) { // invalid 'pane' sepecified
                  $.layout.msg(err +" "+ o.errors.pane +": "+ pane, true);
                  $E = $("");  // NO BUTTON
            }
            else { // VALID
                  var btn = o[pane].buttonClass +"-"+ action;
                  $E    .addClass( btn +" "+ btn +"-"+ pane )
                        .data("layoutName", o.name); // add layout identifier - even if blank!
            }
            return $E;
      }


      /**
      * NEW syntax for binding layout-buttons - will eventually replace addToggle, addOpen, etc.
      *
      * @param {Object}             inst        Layout Instance object
      * @param {(string|!Object)}   selector    jQuery selector (or element) for button, eg: ".ui-layout-north .toggle-button"
      * @param {string}             action
      * @param {string}             pane
      */
,     bind: function (inst, selector, action, pane) {
            var _ = $.layout.buttons;
            switch (action.toLowerCase()) {
                  case "toggle":                _.addToggle (inst, selector, pane); break;      
                  case "open":                  _.addOpen   (inst, selector, pane); break;
                  case "close":                 _.addClose  (inst, selector, pane); break;
                  case "pin":                   _.addPin    (inst, selector, pane); break;
                  case "toggle-slide":    _.addToggle (inst, selector, pane, true); break;      
                  case "open-slide":            _.addOpen   (inst, selector, pane, true); break;
            }
            return inst;
      }

      /**
      * Add a custom Toggler button for a pane
      *
      * @param {Object}             inst        Layout Instance object
      * @param {(string|!Object)}   selector    jQuery selector (or element) for button, eg: ".ui-layout-north .toggle-button"
      * @param {string}                   pane        Name of the pane the button is for: 'north', 'south', etc.
      * @param {boolean=}                 slide             true = slide-open, false = pin-open
      */
,     addToggle: function (inst, selector, pane, slide) {
            $.layout.buttons.get(inst, selector, pane, "toggle")
                  .click(function(evt){
                        inst.toggle(pane, !!slide);
                        evt.stopPropagation();
                  });
            return inst;
      }

      /**
      * Add a custom Open button for a pane
      *
      * @param {Object}             inst        Layout Instance object
      * @param {(string|!Object)}   selector    jQuery selector (or element) for button, eg: ".ui-layout-north .toggle-button"
      * @param {string}             pane        Name of the pane the button is for: 'north', 'south', etc.
      * @param {boolean=}                 slide             true = slide-open, false = pin-open
      */
,     addOpen: function (inst, selector, pane, slide) {
            $.layout.buttons.get(inst, selector, pane, "open")
                  .attr("title", inst.options[pane].tips.Open)
                  .click(function (evt) {
                        inst.open(pane, !!slide);
                        evt.stopPropagation();
                  });
            return inst;
      }

      /**
      * Add a custom Close button for a pane
      *
      * @param {Object}             inst        Layout Instance object
      * @param {(string|!Object)}   selector    jQuery selector (or element) for button, eg: ".ui-layout-north .toggle-button"
      * @param {string}             pane        Name of the pane the button is for: 'north', 'south', etc.
      */
,     addClose: function (inst, selector, pane) {
            $.layout.buttons.get(inst, selector, pane, "close")
                  .attr("title", inst.options[pane].tips.Close)
                  .click(function (evt) {
                        inst.close(pane);
                        evt.stopPropagation();
                  });
            return inst;
      }

      /**
      * Add a custom Pin button for a pane
      *
      * Four classes are added to the element, based on the paneClass for the associated pane...
      * Assuming the default paneClass and the pin is 'up', these classes are added for a west-pane pin:
      *  - ui-layout-pane-pin
      *  - ui-layout-pane-west-pin
      *  - ui-layout-pane-pin-up
      *  - ui-layout-pane-west-pin-up
      *
      * @param {Object}             inst        Layout Instance object
      * @param {(string|!Object)}   selector    jQuery selector (or element) for button, eg: ".ui-layout-north .toggle-button"
      * @param {string}             pane        Name of the pane the pin is for: 'north', 'south', etc.
      */
,     addPin: function (inst, selector, pane) {
            var   _     = $.layout.buttons
            ,     $E    = _.get(inst, selector, pane, "pin");
            if ($E.length) {
                  var s = inst.state[pane];
                  $E.click(function (evt) {
                        _.setPinState(inst, $(this), pane, (s.isSliding || s.isClosed));
                        if (s.isSliding || s.isClosed) inst.open( pane ); // change from sliding to open
                        else inst.close( pane ); // slide-closed
                        evt.stopPropagation();
                  });
                  // add up/down pin attributes and classes
                  _.setPinState(inst, $E, pane, (!s.isClosed && !s.isSliding));
                  // add this pin to the pane data so we can 'sync it' automatically
                  // PANE.pins key is an array so we can store multiple pins for each pane
                  s.pins.push( selector ); // just save the selector string
            }
            return inst;
      }

      /**
      * Change the class of the pin button to make it look 'up' or 'down'
      *
      * @see  addPin(), syncPins()
      *
      * @param {Object}             inst  Layout Instance object
      * @param {Array.<Object>}     $Pin  The pin-span element in a jQuery wrapper
      * @param {string}             pane  These are the params returned to callbacks by layout()
      * @param {boolean}                  doPin true = set the pin 'down', false = set it 'up'
      */
,     setPinState: function (inst, $Pin, pane, doPin) {
            var updown = $Pin.attr("pin");
            if (updown && doPin === (updown=="down")) return; // already in correct state
            var
                  o           = inst.options[pane]
            ,     pin         = o.buttonClass +"-pin"
            ,     side  = pin +"-"+ pane
            ,     UP          = pin +"-up "+    side +"-up"
            ,     DN          = pin +"-down "+side +"-down"
            ;
            $Pin
                  .attr("pin", doPin ? "down" : "up") // logic
                  .attr("title", doPin ? o.tips.Unpin : o.tips.Pin)
                  .removeClass( doPin ? UP : DN ) 
                  .addClass( doPin ? DN : UP ) 
            ;
      }

      /**
      * INTERNAL function to sync 'pin buttons' when pane is opened or closed
      * Unpinned means the pane is 'sliding' - ie, over-top of the adjacent panes
      *
      * @see  open(), close()
      *
      * @param {Object}             inst  Layout Instance object
      * @param {string} pane  These are the params returned to callbacks by layout()
      * @param {boolean}      doPin True means set the pin 'down', False means 'up'
      */
,     syncPinBtns: function (inst, pane, doPin) {
            // REAL METHOD IS _INSIDE_ LAYOUT - THIS IS HERE JUST FOR REFERENCE
            $.each(inst.state[pane].pins, function (i, selector) {
                  $.layout.buttons.setPinState(inst, $(selector), pane, doPin);
            });
      }


,     _load: function (inst) {
            var   _     = $.layout.buttons;
            // ADD Button methods to Layout Instance
            // Note: sel = jQuery Selector string
            $.extend( inst, {
                  bindButton:       function (sel, action, pane) { return _.bind(inst, sel, action, pane); }
            //    DEPRECATED METHODS
            ,     addToggleBtn:     function (sel, pane, slide) { return _.addToggle(inst, sel, pane, slide); }
            ,     addOpenBtn:       function (sel, pane, slide) { return _.addOpen(inst, sel, pane, slide); }
            ,     addCloseBtn:      function (sel, pane) { return _.addClose(inst, sel, pane); }
            ,     addPinBtn:        function (sel, pane) { return _.addPin(inst, sel, pane); }
            });

            // init state array to hold pin-buttons
            for (var i=0; i<4; i++) {
                  var pane = $.layout.config.borderPanes[i];
                  inst.state[pane].pins = [];
            }

            // auto-init buttons onLoad if option is enabled
            if ( inst.options.autoBindCustomButtons )
                  _.init(inst);
      }

,     _unload: function (inst) {
            // TODO: unbind all buttons???
      }

};

// add initialization method to Layout's onLoad array of functions
$.layout.onLoad.push(  $.layout.buttons._load );
//$.layout.onUnload.push( $.layout.buttons._unload );



/**
 * jquery.layout.browserZoom 1.0
 * $Date: 2011-12-29 08:00:00 (Thu, 29 Dec 2011) $
 *
 * Copyright (c) 2012 
 *   Kevin Dalman (http://allpro.net)
 *
 * Dual licensed under the GPL (http://www.gnu.org/licenses/gpl.html)
 * and MIT (http://www.opensource.org/licenses/mit-license.php) licenses.
 *
 * @requires: UI Layout 1.3.0.rc30.1 or higher
 *
 * @see: http://groups.google.com/group/jquery-ui-layout
 *
 * TODO: Extend logic to handle other problematic zooming in browsers
 * TODO: Add hotkey/mousewheel bindings to _instantly_ respond to these zoom event
 */

// tell Layout that the plugin is available
$.layout.plugins.browserZoom = true;

$.layout.defaults.browserZoomCheckInterval = 1000;
$.layout.optionsMap.layout.push("browserZoomCheckInterval");

/*
 *    browserZoom methods
 */
$.layout.browserZoom = {

      _init: function (inst) {
            // abort if browser does not need this check
            if ($.layout.browserZoom.ratio() !== false)
                  $.layout.browserZoom._setTimer(inst);
      }

,     _setTimer: function (inst) {
            // abort if layout destroyed or browser does not need this check
            if (inst.destroyed) return;
            var o = inst.options
            ,     s     = inst.state
            //    don't need check if inst has parentLayout, but check occassionally in case parent destroyed!
            //    MINIMUM 100ms interval, for performance
            ,     ms    = inst.hasParentLayout ?  5000 : Math.max( o.browserZoomCheckInterval, 100 )
            ;
            // set the timer
            setTimeout(function(){
                  if (inst.destroyed || !o.resizeWithWindow) return;
                  var d = $.layout.browserZoom.ratio();
                  if (d !== s.browserZoom) {
                        s.browserZoom = d;
                        inst.resizeAll();
                  }
                  // set a NEW timeout
                  $.layout.browserZoom._setTimer(inst);
            }
            ,     ms );
      }

,     ratio: function () {
            var w = window
            ,     s     = screen
            ,     d     = document
            ,     dE    = d.documentElement || d.body
            ,     b     = $.layout.browser
            ,     v     = b.version
            ,     r, sW, cW
            ;
            // we can ignore all browsers that fire window.resize event onZoom
            if ((b.msie && v > 8)
            ||    !b.msie
            ) return false; // don't need to track zoom

            if (s.deviceXDPI && s.systemXDPI) // syntax compiler hack
                  return calc(s.deviceXDPI, s.systemXDPI);
            // everything below is just for future reference!
            if (b.webkit && (r = d.body.getBoundingClientRect))
                  return calc((r.left - r.right), d.body.offsetWidth);
            if (b.webkit && (sW = w.outerWidth))
                  return calc(sW, w.innerWidth);
            if ((sW = s.width) && (cW = dE.clientWidth))
                  return calc(sW, cW);
            return false; // no match, so cannot - or don't need to - track zoom

            function calc (x,y) { return (parseInt(x,10) / parseInt(y,10) * 100).toFixed(); }
      }

};
// add initialization method to Layout's onLoad array of functions
$.layout.onReady.push( $.layout.browserZoom._init );


})( jQuery );

/*            'js/jquery.collapsible.js',*/
/*
  jquery.collapsible.js - jQuery collapsible form element plugin code. 
  init Nov 2010 by J. Thompson 
  Wireless Controller Improvements project
  Copyright Fortinet Inc
*/

(function($) {

$.fn.collapsible = function(settings) {
    function csUpdateLabel( inputElem, inputLabel )
    {
        var labelText = "";

        if ($("option:selected", inputElem).length)
        {
            labelText = $("option:selected", inputElem).html();
        }
        else
        {
            labelText = inputElem.val();
        }

        inputLabel.text( labelText );
    }

    var config = $.extend({}, $.fn.collapsible.defaults, settings);

    return this.each( function() {
        var inputElem = $(this)
            .addClass("ui-collapsible-elem")
            .hide()
        ;
      
        var inputLabel = $("<label></label>")
            .addClass("ui-collapsible-elem-label")
            .insertBefore(inputElem)
        ;
  
        var changeButton = $("<a></a>")
            .addClass("ui-collapsible-elem-change")
            .attr("href", "#")
            .html(config.changeText)
            .insertAfter(inputElem)
        ;

        var applyButton = $("<a></a>")
            .hide()
            .addClass("ui-collapsible-elem-apply")
            .attr("href", "#")
            .html(config.applyText)
            .insertAfter(changeButton)
        ;

        changeButton.click( function() {
            inputLabel.hide();
            inputElem.show();
            changeButton.hide();
            applyButton.fadeIn("slow");
            return false;
        });
        
        applyButton.click( function() {
            csUpdateLabel( inputElem, inputLabel );
      
            inputLabel.show();
            inputElem.hide();
            applyButton.hide();
            changeButton.fadeIn("slow");
            return false;
        });

        csUpdateLabel( inputElem, inputLabel );
    });
};

$.fn.collapsible.defaults = {
    "applyText" : "[Apply]",
    "changeText" : "[Change]",
    "readOnly" : false
};

})(jQuery);


/*            'js/jquery.ui_dependencies.js',*/
/* globals jQuery */
(function($) {
    'use strict';
    /*monitor SIMPLE visual dependencies added in markup instead of js
    eg: checking a box shows a div etc
    NOTE: dependencies only 'match' if selector's matched inputs are visible
        use class="dependency_ignore_visibility" to override this behavior
        <input type="hidden"> uses parent visibility for this test

    SCOPE can be limited by using class="dependency_scope".
        Use data-dependency-ignore-scope="1" to break out of one scope
        use 2 to break out of 2 scopes, etc

    triggers 'dependency_change' events that can be bound using $().on
    NOTE: bind to the .depends element, NOT the input(s) that trigger it

    sample:
    <input id="a-checkbox" type="checkbox"/>
    <input id="b-checkbox" type="checkbox"/>
    <input id="c-checkbox" type="checkbox"/>

    show if a-checkbox is checked (works with radio too)
    <div class="depends" data-show-if-checked="#a-checkbox"></div>
    show if a or b checkbox is checked
    <div class="depends" data-show-if-checked="#a-checkbox , #b-checkbox"></div>
    show if a and b checkbox is checked
    can't use & in xhtml and + is alread a selector, so $ == 'and'
    <div class="depends" data-show-if-checked="#a-checkbox $ #b-checkbox"></div>

    don't show if a-checkbox is checked
    <div class="depends" data-show-if-checked="! #a-checkbox"></div>

    normal and/or operator precedence, but no support for grouping with ()
        (yet?)
    show if (a-checkbox && b-checkbox) || c-checkbox is checked
    <div class="depends"
        data-show-if-checked="#a-checkbox $ #b-checkbox,#c-checkbox">
    </div>

    also: show-if-value (can use regex for value!)

    <input id="text" type="text"/>
    <select id="select"><option value="a">a</option>
                        <option value="b">b</option>
                        ...
    </select>

    show if text.value == 'xyz'
    <div class="depends" data-show-if-value="xyz #text"></div>
    show if select.value != 'abc'
    <div class="depends" data-show-if-value="! abc #select"></div>
    show if select value in ['a','b']
    <div class="depends" data-show-if-value="a,b #select"></div>
    show if select.value not in ['a','b'] (no spaces alowed between values)
    <div class="depends" data-show-if-value="! a,b #select"></div>
    show if text.value != ''
    <div class="depends" data-show-if-value="/.+/ #text"></div>

    show-if-attr: checks for an attr=value match. Useful for <select> elems.
    Instead of checking attrs on <select>, checks attrs on selected <option>
    <select id="#sel"><option class="abc"/><option class="def"></select>
    <div class="depends" data-show-if-attr="class=abc #sel"></div>
    NOTE: *-if-class, *-if-data uses the same behavior for
        select/option elements.

    show-if-data: same thing but with a data-attribute
    <select id="#sel"><option data-something="1"/><option data-something="2"/>
        <option data-something="3"/>
    </select>
    <div class="depends" data-show-if-data="! something=2,3 #sel"></div>

    also: class-if-checked, class-if-value
    same rules as before, but also specify a css class that gets toggled instead
        (no negation (yet))

        enable-if-checked, enable-if-value
    same rules, but affects disabled= attribute

    toggle class orange when a-checkbox checked
    <div class="depends" data-class-if-checked="orange #a-checkbox"></div>
    toggle class green when select.value in ['a','c']
    <div class="depends" data-class-if-value="green a,c #select"></div>

    ALSO: the odd ones out, name-if-changed, class-if-changed:
        sets the name/class of the input when the value is changed
            (for the first time)
        name-if-changed:
            change the name when value is changed,
            useful for avoiding submission of unchanged fields
        class-if-changed:
            validation uses classes, so handy for skipping validation on
            unchanged inputs
    <input class="depends" data-name-if-changed="xyz" value="abc"/>
    after change:
    <input class="depends" data-name-if-changed="xyz" name="xyz" value="def"/>

    NOTE: this is getting complex enough that it should have a testsuite
    */
    $.extend({'ui_dependencies': ui_dependencies});
    $.fn.ui_dependencies = ui_dependencies;
    $.fn.nice_toggle = nice_toggle;

    //toggle that doesn't stomp on 'display' css property
    function nice_toggle(show, duration) {
        /* jshint validthis: true */
        if (duration) {
            if (show) {
                return this.slideDown(duration);
            } else {
                return this.slideUp(duration);
            }
        } else {
            return this.css('display', show ? '' : 'none');
        }
    }

    function ui_dependencies() {
        /* jshint bitwise:false, validthis: true*/
        var VALUE_BIT = 1, CLASS_BIT = 2, CHECK_BIT = 4, SHOW_BIT = 8,
            NAME_BIT = 0x10, CHANGED_BIT = 0x20,
            DATA_BIT = 0x40, ATTR_BIT = 0x80,
            ENABLE_BIT = 0x100, HAS_CLASS_BIT = 0x200, TO_CHECK_BIT = 0x400,
            DEP_SIC = SHOW_BIT | CHECK_BIT,
            DEP_SIV = SHOW_BIT | VALUE_BIT,
            DEP_SID = SHOW_BIT | DATA_BIT | VALUE_BIT,
            DEP_SIA = SHOW_BIT | ATTR_BIT | VALUE_BIT,
            DEP_SICL = SHOW_BIT | HAS_CLASS_BIT | VALUE_BIT,
            DEP_CIC = CLASS_BIT | CHECK_BIT,
            DEP_CIV = CLASS_BIT | VALUE_BIT,
            DEP_CID = CLASS_BIT | DATA_BIT | VALUE_BIT,
            DEP_CIA = CLASS_BIT | ATTR_BIT | VALUE_BIT,
            DEP_CICL = CLASS_BIT | HAS_CLASS_BIT | VALUE_BIT,
            DEP_EIC = ENABLE_BIT | CHECK_BIT,
            DEP_EIV = ENABLE_BIT | VALUE_BIT,
            DEP_EID = ENABLE_BIT | DATA_BIT | VALUE_BIT,
            DEP_EIA = ENABLE_BIT | ATTR_BIT | VALUE_BIT,
            DEP_EICL = ENABLE_BIT | HAS_CLASS_BIT | VALUE_BIT,
            DEP_NIC = NAME_BIT | CHECK_BIT,
            DEP_TCIC = TO_CHECK_BIT | CHECK_BIT,
            //these don't actually support selectors, (yet?)
            //and always bind to themselves instead
            DEP_CICH = CLASS_BIT | CHANGED_BIT,
            DEP_NICH = NAME_BIT | CHANGED_BIT,

            CHANGE_EVENT = 'dependency_change',
            DATA_KEY = 'ui_dependencies',
            CHANGE_BIND_EVENT = 'change.dependencies',
            TRIGGER_CLASS = 'dependency_trigger',
            TRIGGER_SELECTOR = '.' + TRIGGER_CLASS,
            DEPEND_SELECTOR = '.depends',

            depData = {
                'show-if-value': DEP_SIV,
                'show-if-checked': DEP_SIC,
                'show-if-data': DEP_SID,
                'show-if-attr': DEP_SIA,
                'show-if-class': DEP_SICL,
                'class-if-value': DEP_CIV,
                'class-if-checked': DEP_CIC,
                'class-if-data': DEP_CID,
                'class-if-class': DEP_CICL,
                'name-if-changed': DEP_NICH,
                'class-if-changed': DEP_CICH,
                'class-if-attr': DEP_CIA,
                'enable-if-checked': DEP_EIC,
                'enable-if-value': DEP_EIV,
                'enable-if-data': DEP_EID,
                'enable-if-attr': DEP_EIA,
                'enable-if-class': DEP_EICL,
                'name-if-checked': DEP_NIC,
                'check-if-checked': DEP_TCIC
            };

        function makeValues(values) {
            return (/^\/.*\/$/).test(values) ?
                new RegExp(values.substr(1, values.length - 2)) :
                values.split(',');
        }

        //TODO: find a way to add in 'and' matching as well as combine
        // different types of dependencies on a single element
        function is_match($inputs, values, negate, dataAttr, attr, has_class) {

            function get_attr_elem($input) {
                if (String($input.get(0).tagName).toLowerCase() === 'select') {
                    return $input.find('option:selected');
                } else {
                    //not sure how this would be used since the attr
                    //would need to be set before changed() is called
                    return $input;
                }
            }
            //and matching
            if (!$inputs.jquery) {

                return $inputs.every(function($inputs) {
                    return is_match($inputs, values, negate, dataAttr,
                                    attr, has_class);
                });
            }
            var match = $inputs.filter(function(i, input) {
                var result, $input = $(input);
                if (typeof(values) === 'undefined') {
                    result = input.checked;
                } else if (has_class) {
                    result = values.some(function(value) {
                        return get_attr_elem($input).hasClass(value);
                    });
                } else {
                    var value;
                    if (dataAttr) {
                        value = String(get_attr_elem($input)
                                                .data(dataAttr));
                    } else if (attr) {
                        value = String(get_attr_elem($input).attr(attr));
                    } else {
                        value = input.value;
                    }
                    result = values instanceof RegExp ?
                        values.test(value) :
                        $.inArray(value, values) > -1;
                }

                /*may have to escalate the dependency_ignore_visibility
                check may have to show closest() with that class
                then restore. This simple check is good for now */
                return result && ($input.is(':visible') ||
                    $input.parent('.multiList-container').is(':visible') ||
                    ($input.is('input[type=hidden]') &&
                        $input.parent().is(':visible')) ||
                        $input.closest('.dependency_ignore_visibility')
                        .length > 0);
            }).length > 0;
            return negate ? !match : match;
        }

        function and_radio_options($radio) {
            return $radio.map(function(i, radio) {
                var s = '[type=radio][name="' + radio.name + '"]';
                return radio.type === 'radio' ?
                    $(s).get() :
                    radio;
            });
        }

        function fixOptions($options, match) {
            /* jshint validthis: true */
            function wrapped() {
                return String(this.parentNode.tagName)
                    .toLowerCase() === 'span';
            }
            //options in ie can't be hidden. wrap all hidden
            //options in a spans and hide the span
            //disable them also for good measure
            if (match) {
                $options.removeAttr('disabled')
                    .filter(wrapped).unwrap();
            } else {
                $options.attr('disabled', 'disabled')
                    .not(wrapped)
                    .wrap('<span>').parent().hide();
            }
            $options = $options.filter(':selected:disabled');
            if (!match && $options.length) {
                $.unique($options.parent()).each(function() {
                    var $select = $(this);
                    this.selectedIndex = $select.find('option')
                                            .not(':disabled')
                                            .first().index();
                    $select.change();
                });
            }
        }

        function Dependency(depType, $elem, selector, duration) {
            function selector_tok(tokenExpr, otherExpr) {
                tokenExpr = tokenExpr || firstToken;
                otherExpr = otherExpr || otherTokens;
                var result = selector.replace(otherExpr, '');
                selector = selector.replace(tokenExpr, '');
                return result;
            }
            var _this = this;
            this.$elem = $elem;
            this.$scope = this.get_scope();
            this.depType = depType;
            this.duration = duration;
            if (this.depType === DEP_NICH) {
                this.addTo($elem.not('[name]'));
            } else {
                this.selector = selector;
                var firstToken = /^[^\s]*\s/,
                    otherTokens = /\s.*$/,
                    attrNameToken = /^[^=]*=/,
                    attrNameOther = /=.*$/;
                this.negate = selector.replace(otherTokens, '') === '!';
                if (this.negate) {
                    selector = selector.replace(firstToken, '');
                }
                if (CLASS_BIT & this.depType) {
                    this.toggleClass = selector_tok();
                }
                if (ATTR_BIT & this.depType) {
                    this.attr = selector_tok(attrNameToken, attrNameOther);
                }
                if (DATA_BIT & this.depType) {
                    this.dataAttr = selector_tok(attrNameToken, attrNameOther);
                }
                if (VALUE_BIT & this.depType) {
                    this.values = makeValues(selector_tok());
                }
                if (NAME_BIT & this.depType) {
                    this.name = selector_tok();
                }
                var trigger_change = false;
                this.and_inputs = selector.split('$').map(function(selector) {
                    return _this.$scope.find(selector);
                });
                $.each(this.and_inputs, function(i, $inputs) {
                    if ($inputs.length) {
                        $inputs.each(function(i, input) {
                            _this.changed(input);
                        });
                        if (CHECK_BIT & _this.depType) {
                            $inputs = and_radio_options($inputs);
                        }
                        _this.addTo($inputs);
                        trigger_change = true;
                    }
                });
                if (trigger_change) {
                    this.$elem.trigger(CHANGE_EVENT, [this, null]);
                }
            }
        }
        /*
            Dependency properties:
            $elem, depType, $scope
            if depType is
                !CHANGED_BIT:
                    and_inputs, negate, selector
                CLASS_BIT:
                    toggleClass,
                VALUE_BIT, DATA_BIT:
                    values
                DATA_BIT:
                    dataAttr
                ATTR_BIT:
                    attr
                NAME_BIT: (&& !CHANGED_BIT)
                    name
        */

        //prevent some dependencies from being triggered artificially
        Dependency._triggering = 0;

        Dependency.on_change = function(eo) {
            var input = this,
                changed = 0,
                deps = $(this).data(DATA_KEY);
            if (!deps) {
                $.error('No dependencies found!');
            }
            changed = deps.reduce(function(list, dep) {
                if (dep.changed(input, eo)) {
                    list.push(dep);
                }
                return list;
            }, []);
            if (Dependency._triggering === 0) {
                var i, len = changed.length;
                for (i = 0; i < len; ++i) {
                    changed[i].$elem.trigger(CHANGE_EVENT,
                                             [changed[i], eo]);
                }
            }
        };

        Dependency.prototype.get_scope = function() {
            var $scopes = this.$elem.parents('.dependency_scope'),
                ignore = +(this.$elem.data('dependency-ignore-scope') || 0),
                $result = $context;
            if ($scopes.length && $scopes.length > ignore) {
                $result = $scopes.eq(ignore);
            }
            return $result;
        };

        Dependency.prototype.changed = function(input, eo) {
            var $input, match, $options, result = 0;
            if (this.depType & CHANGED_BIT) {
                if ((eo && (eo.currentTarget === input) &&
                        (!Dependency._triggering))) {
                    $input = $(input);
                    if (this.depType & NAME_BIT) {
                        input.name = $input.data('name-if-changed');
                        $input.removeAttr('name-if-changed');
                    }
                    if (this.depType & CLASS_BIT) {
                        $input.addClass($input.data('class-if-changed'));
                        $input.removeAttr('class-if-changed');
                    }
                    this.removeFrom($input);
                }
            } else {
                match = is_match(this.and_inputs, this.values, this.negate,
                                 this.dataAttr, this.attr,
                                 HAS_CLASS_BIT & this.depType);
                if (CLASS_BIT & this.depType) {
                    this.$elem.toggleClass(this.toggleClass, match);
                    ++result;
                } else if (SHOW_BIT & this.depType) {
                    this.$elem.nice_toggle(match, this.duration);
                    ++result;
                    $options = this.$elem.filter('option');
                    if ($options.length) {
                        fixOptions($options, match);
                    }
                } else if (ENABLE_BIT & this.depType) {
                    this.$elem.enable(match);
                    ++result;
                } else if (NAME_BIT & this.depType) {
                    this.$elem.prop('name', match ? this.name : null);
                    ++result;
                } else if (TO_CHECK_BIT & this.depType) {
                    if (!this.$elem.is(':checked')) {
                        this.$elem.check(match);
                        ++result;
                    }
                }
                //prevent total browser/tab lockup if there is a cycle.
                //only trigger if the match value actually changed!
                if (eo && !this._triggering && match !== this._lastMatch) {
                    /*don't trigger CHANGED_BIT deps when re-evaluating
                    contained dependencies since they weren't really changed
                    could be nested, so use increment/decrement instead of bool
                    */
                    ++Dependency._triggering;
                    //avoid feedback loops when triggering
                    this._triggering = true;
                    try {
                        this.$elem.find(TRIGGER_SELECTOR).change();
                    } catch (ie8) {
                        throw ie8;
                    } finally {
                        this._triggering = false;
                        --Dependency._triggering;
                    }
                }
                this._lastMatch = match;
            }
            return Dependency._triggering ? 0 : result;
        };

        Dependency.prototype.addTo = function($inputs) {
            var dep = this;
            $inputs.each(function(i, input) {
                var $input = $(input);
                $input
                    .off(CHANGE_BIND_EVENT)
                    .on(CHANGE_BIND_EVENT, Dependency.on_change);
                var deps = $input.data(DATA_KEY) || [];
                deps.push(dep);
                $input.addClass(TRIGGER_CLASS)
                    .data(DATA_KEY, deps);
            });
        };

        Dependency.prototype.removeFrom = function($inputs) {
            var deps = $inputs.data(DATA_KEY) || [];
            deps = $(deps).filter(function(i, dep) {
                return dep !== this;
            });
            $inputs.data(DATA_KEY, deps.length ? deps : null);
            if (deps.length === 0) {
                $inputs.off(CHANGE_BIND_EVENT)
                    .removeClass(TRIGGER_CLASS);

            }
        };

        var $context = this === $ ? $(document) : this,
            $depends = $context.find(DEPEND_SELECTOR)
                .add($context.filter(DEPEND_SELECTOR));
        $depends.each(function(i, elem) {
            var $elem = $(elem),
                selector,
                duration;

            duration = $elem.data('duration');
            $.each(depData, function(key, depType) {
                selector = $elem.data(key);
                if (selector) {
                    new Dependency(depType, $elem, selector, duration);
                }
            });
        });
        return this;
    }
})(jQuery);

/*            'js/jquery.maskedinput.js',*/
/*
      Masked Input plugin for jQuery
      Copyright (c) 2007-2013 Josh Bush (digitalbush.com)
      Licensed under the MIT license (http://digitalbush.com/projects/masked-input-plugin/#license)
      Version: 1.3.1
*/
(function($) {
      function getPasteEvent() {
    var el = document.createElement('input'),
        name = 'onpaste';
    el.setAttribute(name, '');
    return (typeof el[name] === 'function')?'paste':'input';             
}

var pasteEventName = getPasteEvent() + ".mask",
      ua = navigator.userAgent,
      iPhone = /iphone/i.test(ua),
      android=/android/i.test(ua),
      caretTimeoutId;

$.mask = {
      //Predefined character definitions
      definitions: {
            '9': "[0-9]",
            'a': "[A-Za-z]",
            '*': "[A-Za-z0-9]"
      },
      dataName: "rawMaskFn",
      placeholder: '_'
};

$.fn.extend({
      //Helper Function for Caret positioning
      caret: function(begin, end) {
            var range;

            if (this.length === 0 || this.is(":hidden")) {
                  return;
            }

            if (typeof begin == 'number') {
                  end = (typeof end === 'number') ? end : begin;
                  return this.each(function() {
                        if (this.setSelectionRange) {
                              this.setSelectionRange(begin, end);
                        } else if (this.createTextRange) {
                              range = this.createTextRange();
                              range.collapse(true);
                              range.moveEnd('character', end);
                              range.moveStart('character', begin);
                              range.select();
                        }
                  });
            } else {
                  if (this[0].setSelectionRange) {
                        begin = this[0].selectionStart;
                        end = this[0].selectionEnd;
                  } else if (document.selection && document.selection.createRange) {
                        range = document.selection.createRange();
                        begin = 0 - range.duplicate().moveStart('character', -100000);
                        end = begin + range.text.length;
                  }
                  return { begin: begin, end: end };
            }
      },
      unmask: function() {
            return this.trigger("unmask");
      },
      mask: function(mask, settings) {
            var input,
                  defs,
                  tests,
                  partialPosition,
                  firstNonMaskPos,
                  len;

            if (!mask && this.length > 0) {
                  input = $(this[0]);
                  return input.data($.mask.dataName)();
            }
            settings = $.extend({
                  placeholder: $.mask.placeholder, // Load default placeholder
                  completed: null
            }, settings);


            defs = $.mask.definitions;
            tests = [];
            partialPosition = len = mask.length;
            firstNonMaskPos = null;

            $.each(mask.split(""), function(i, c) {
                  if (c == '?') {
                        len--;
                        partialPosition = i;
                  } else if (defs[c]) {
                        tests.push(new RegExp(defs[c]));
                        if (firstNonMaskPos === null) {
                              firstNonMaskPos = tests.length - 1;
                        }
                  } else {
                        tests.push(null);
                  }
            });

            return this.trigger("unmask").each(function() {
                  var input = $(this),
                        buffer = $.map(
                        mask.split(""),
                        function(c, i) {
                              if (c != '?') {
                                    return defs[c] ? settings.placeholder : c;
                              }
                        }),
                        focusText = input.val();

                  function seekNext(pos) {
                        while (++pos < len && !tests[pos]);
                        return pos;
                  }

                  function seekPrev(pos) {
                        while (--pos >= 0 && !tests[pos]);
                        return pos;
                  }

                  function shiftL(begin,end) {
                        var i,
                              j;

                        if (begin<0) {
                              return;
                        }

                        for (i = begin, j = seekNext(end); i < len; i++) {
                              if (tests[i]) {
                                    if (j < len && tests[i].test(buffer[j])) {
                                          buffer[i] = buffer[j];
                                          buffer[j] = settings.placeholder;
                                    } else {
                                          break;
                                    }

                                    j = seekNext(j);
                              }
                        }
                        writeBuffer();
                        input.caret(Math.max(firstNonMaskPos, begin));
                  }

                  function shiftR(pos) {
                        var i,
                              c,
                              j,
                              t;

                        for (i = pos, c = settings.placeholder; i < len; i++) {
                              if (tests[i]) {
                                    j = seekNext(i);
                                    t = buffer[i];
                                    buffer[i] = c;
                                    if (j < len && tests[j].test(t)) {
                                          c = t;
                                    } else {
                                          break;
                                    }
                              }
                        }
                  }

                  function keydownEvent(e) {
                        var k = e.which,
                              pos,
                              begin,
                              end;

                        //backspace, delete, and escape get special treatment
                        if (k === 8 || k === 46 || (iPhone && k === 127)) {
                              pos = input.caret();
                              begin = pos.begin;
                              end = pos.end;

                              if (end - begin === 0) {
                                    begin=k!==46?seekPrev(begin):(end=seekNext(begin-1));
                                    end=k===46?seekNext(end):end;
                              }
                              clearBuffer(begin, end);
                              shiftL(begin, end - 1);

                              e.preventDefault();
                        } else if (k == 27) {//escape
                              input.val(focusText);
                              input.caret(0, checkVal());
                              e.preventDefault();
                        }
                  }

                  function keypressEvent(e) {
                        var k = e.which,
                              pos = input.caret(),
                              p,
                              c,
                              next;

                        if (e.ctrlKey || e.altKey || e.metaKey || k < 32) {//Ignore
                              return;
                        } else if (k) {
                              if (pos.end - pos.begin !== 0){
                                    clearBuffer(pos.begin, pos.end);
                                    shiftL(pos.begin, pos.end-1);
                              }

                              p = seekNext(pos.begin - 1);
                              if (p < len) {
                                    c = String.fromCharCode(k);
                                    if (tests[p].test(c)) {
                                          shiftR(p);

                                          buffer[p] = c;
                                          writeBuffer();
                                          next = seekNext(p);

                                          if(android){
                                                setTimeout($.proxy($.fn.caret,input,next),0);
                                          }else{
                                                input.caret(next);
                                          }

                                          if (settings.completed && next >= len) {
                                                settings.completed.call(input);
                                          }
                                    }
                              }
                              e.preventDefault();
                        }
                  }

                  function clearBuffer(start, end) {
                        var i;
                        for (i = start; i < end && i < len; i++) {
                              if (tests[i]) {
                                    buffer[i] = settings.placeholder;
                              }
                        }
                  }

                  function writeBuffer() { input.val(buffer.join('')); }

                  function checkVal(allow) {
                        //try to place characters where they belong
                        var test = input.val(),
                              lastMatch = -1,
                              i,
                              c;

                        for (i = 0, pos = 0; i < len; i++) {
                              if (tests[i]) {
                                    buffer[i] = settings.placeholder;
                                    while (pos++ < test.length) {
                                          c = test.charAt(pos - 1);
                                          if (tests[i].test(c)) {
                                                buffer[i] = c;
                                                lastMatch = i;
                                                break;
                                          }
                                    }
                                    if (pos > test.length) {
                                          break;
                                    }
                              } else if (buffer[i] === test.charAt(pos) && i !== partialPosition) {
                                    pos++;
                                    lastMatch = i;
                              }
                        }
                        if (allow) {
                              writeBuffer();
                        } else if (lastMatch + 1 < partialPosition) {
                              input.val("");
                              clearBuffer(0, len);
                        } else {
                              writeBuffer();
                              input.val(input.val().substring(0, lastMatch + 1));
                        }
                        return (partialPosition ? i : firstNonMaskPos);
                  }

                  input.data($.mask.dataName,function(){
                        return $.map(buffer, function(c, i) {
                              return tests[i]&&c!=settings.placeholder ? c : null;
                        }).join('');
                  });

                  if (!input.attr("readonly"))
                        input
                        .one("unmask", function() {
                              input
                                    .unbind(".mask")
                                    .removeData($.mask.dataName);
                        })
                        .bind("focus.mask", function() {
                              clearTimeout(caretTimeoutId);
                              var pos,
                                    moveCaret;

                              focusText = input.val();
                              pos = checkVal();
                              
                              caretTimeoutId = setTimeout(function(){
                                    writeBuffer();
                                    if (pos == mask.length) {
                                          input.caret(0, pos);
                                    } else {
                                          input.caret(pos);
                                    }
                              }, 10);
                        })
                        .bind("blur.mask", function() {
                              checkVal();
                              if (input.val() != focusText)
                                    input.change();
                        })
                        .bind("keydown.mask", keydownEvent)
                        .bind("keypress.mask", keypressEvent)
                        .bind(pasteEventName, function() {
                              setTimeout(function() { 
                                    var pos=checkVal(true);
                                    input.caret(pos); 
                                    if (settings.completed && pos == input.val().length)
                                          settings.completed.call(input);
                              }, 0);
                        });
                  checkVal(); //Perform initial check for existing values
            });
      }
});


})(jQuery);

/*            'js/fortiguard_common.js',*/
var fgd_common = {
    default_selector: '#qlistqlist a, #qlist a',

    getidtable: {
        //table of methods used to determine the id of the link being clicked
        fromclass : function (jthis) {
            var classes = jthis.attr('class').split(' ');
            for (var i = 0; i < classes.length; ++i) {
                var _class = classes[i];
                var match = _class.match(/id_(\d+)/);
                if (match) {
                    return match[1];
                }
            }
            return -1;
        },

        fromlink : function (jthis) {
            return jthis.attr('href').replace('http://www.fortinet.com/ids/VID', '');
        }
    },

    // _query_fortiflow_database - Send API query to FortiFlow to determine
    // application IDs/names from addresss/dst port/protocol combinations.
    // Returns a Deferred.
    _query_fortiflow_database: function(unknown_apps) {
        //coffee: hash = (@_gen_app_hash_key(app) for app in unknown_apps).join('##')
        var hash = ((function() {
          var app, _i, _len, _results;
          _results = [];
          for (_i = 0, _len = unknown_apps.length; _i < _len; _i++) {
            app = unknown_apps[_i];
            _results.push(this._gen_app_hash_key(app));
          }
          return _results;
        }).call(this)).join('##');
        var cached_query = this._request_cache[hash];
        // TODO: see if batched queries can be re-used and mixed
        // jQuery.each(unknown_apps, function(i, app) {
        //     var hash = fgd_common._gen_app_hash_key(app);
        //     if (cached_query == null) {
        //         cached_query = this._request_cache[hash];
        //     } else if (cached_query !== this._request_cache[hash]) {
        //         cached_query = null; return false;
        //     }
        // });
        if (cached_query == null) {
            cached_query = $j.getJSON("/api/monitor", {
                "path": "utm",
                "name": "app-lookup",
                "json": JSON.stringify({
                    "hosts": unknown_apps
                })
            });
            this._request_cache[hash] = cached_query;
        }
        return cached_query;
    },
    _request_cache: {},

    // _gen_app_hash_key: Generate a unique key for each set of
    // address / destination port and protocol used for a FortiFlow query.
    _gen_app_hash_key: function(app) {
        return [app['address'], app['dst_port'], app['protocol']].join('#');
    },

    // gen_app_html -- Generate common HTML for a single application with icon.
    gen_app_html: function(app_id, app_name, host_info, extra_class, title) {
        if (!extra_class) {
            extra_class = "";
        }
        if (!title) {
            title = "";
        }

        return '<span class="fgd-app tooltip id_' + app_id + ' ' + extra_class +
                '" data-address="' + host_info['address'] + '" ' +
                'data-dport="' + host_info['dst_port'] + '" ' +
                'data-protocol="' + host_info['protocol'] + '" ' +
                '><span class="app_icon app' + app_id + '" ' +
                '></span><label class="app_label" title="' + title + '">' +
                app_name + '</label></span>';
    },

    // gen_wf_html -- Generate common HTML for a single web-filter category
    gen_wf_html: function(cat_id, cat_name) {
        return '<span class="tooltip wf_category id_' + cat_id + '" ' +
               '><span class="wf_icon wf' + cat_id + '" ' +
               '></span><label class="wf_label" title="' + cat_name + '">' +
               cat_name + '</label></span>';
    },

    // gen_wf_html_no_icon -- Generate common HTML for a single web-filter category
    //             -- without icon
    gen_wf_html_no_icon: function(cat_id, cat_name) {
        return '<span class="tooltip wf_category id_' + cat_id + '">' +
               '<label class="wf_label" title="' + cat_name + '">' +
               cat_name + '</label></span>';
    },

    // gen_app_cat_html -- Generate common HTML for a single appctrl category
    gen_app_cat_html: function(cat_name) {
        return '<span class="tooltip ac_category dont-use-id" data-cat="' + cat_name +
               '"><label class="ac_label" title="' + cat_name + '">' +
               cat_name + '</label></span>';
    },

    // _update_unknown_apps - Updates unknown apps with known application
    // IDs based on results from a FortiFlow query.
    _update_unknown_apps: function(data, app_cache) {
        var r = data.results;
        for (var i=0; i<r.length; i++) {
            var host = r[i], c_app;
            if (!host || !host['apps']) {
                continue;
            }

            var key = fgd_common._gen_app_hash_key(host);
            if (!(c_app = app_cache[key])) {
                continue;
            }

            var html = '';
            for (var j=0; j<host['apps'].length; j++) {
                var app = host['apps'][j];

                if (j > 0) {
                    html += ', ';
                }

                // FortiFlow may return more meaningful application names for specific
                // hosts, for example "Google DNS" instead of "DNS".
                var app_name = app['app_name'];
                var title = '';
                if (app['name_id'] !== 0) {
                    var short_app = truncate_string(app['name']);

                    title = app_name + ' (' + app['name'] + ')';
                    app_name += ' (' + short_app + ')';
                }

                html += fgd_common.gen_app_html(app['app_id'], app_name, host, 'app_queried', title);
            }

            c_app.replaceWith(html)
                .data("app-fortiflow-done", true)
                .data('app-tooltip-done', null);
        }
    },

    // _setup_tooltips -- initializes tooltips for various FortiGuard signatures
    // based on class names or link URL. The following services are supported:-
    //
    //   * application control signatures
    //   * IPS signatures
    //   * WebFilter categories
    //   * application control categories
    // class name 'dont-use-id": no need to use id, ignore id checking and handling
    _setup_tooltips: function (selector, idmethod, query_fortiflow, adjust) {
        $j.addStyle("/css/jquery.qtip.css");
        if (typeof(selector) == 'undefined') {
            selector = fgd_common.default_selector;
        }

        // Providing a function as a selector allows for the result set
        // to be easily requeried in the case of loading application tooltips
        // amongst iframes.
        var elements = selector;
        if (typeof selector == 'function') {
            elements = selector();
        }

        if (typeof(adjust) == 'undefined') {
            adjust = {};
        }

        var unknown_apps = [];
        var app_cache = {};
        var othis = this;

        $j(elements).click(function(e) {e.preventDefault();});
        $j(elements).each(function() {
            var jthis = $j(this);
            //Don't re-apply the tooltip
            if (jthis.data('app-tooltip-done'))
                return true;

            jthis.data('app-tooltip-done', true);
            var text = jthis.text();
            var id = -1;

            if (text.length < 1) {
                return;
            }

            if(!jthis.hasClass('dont-use-id')) {
                if (!othis.getidtable[idmethod]) {
                    //default method
                    idmethod = 'fromlink';
                }

                if ((id = (othis.getidtable[idmethod])(jthis)) < 0) {
                    return;
                }

                // Add "unknown" apps to a list for future FortiFlow query.
                if (+id === 0) {

                    // Don't re-query unknown applications w/ FortiFlow.
                    if (jthis.data("app-fortiflow-done")) {
                        return;
                    }

                    var address = jthis.data('address');
                    var dport = jthis.data('dport');
                    var protocol = jthis.data('protocol');

                    if (address && dport && protocol) {
                        var app = {
                            'address': address,
                            'dst_port': dport,
                            'protocol': protocol
                        };

                        var key = fgd_common._gen_app_hash_key(app);

                        if (key in app_cache) {
                            app_cache[key] = app_cache[key].add(jthis);
                        } else {
                            unknown_apps.push(app);
                            app_cache[key] = jthis;
                        }
                    }

                    return;
                }
            }

            // Modern browsers block mixed use of secure (HTTPS) and insecure (HTTP)
            // content. The connection to fortiguard.com must use the same protocol as the
            // connection to the FGT or else the browser will reject the request.
            // document.location.protocol will be either "http:" or "https:".
            var src = document.location.protocol + '//www.fortiguard.com/';
            var _width = 300, _height = 200;

            // WebFilter categories use a different URL from IPS/application control
            // signatures. The default size of the dialog is also larger.
            if (jthis.hasClass('wf_category')) {
                /* Skip local categories & classifications (see MAX_FTGD_NUM_CAT) */
                if (id >= 107) {
                    return;
                }

                src += 'wf/' + id + '.html';
                _width = 400;
                _height = 225;
            } else if (jthis.hasClass('ac_category')) {
                src += 'ac/' + jthis.data('cat').replace(/\//gi, '.') + '.html';
                _width = 390;
                _height = 185;
            } else {
                src += 'fos/' + id;
            }

            if ($j('a', jthis).length === 0) {
                jthis.wrapInner('<a href="' + src + '" onclick="return false;"/>');
            }

            $j('a', jthis).qtip({
                content: {
                    text: '<iframe width="' + (_width + 30) + '" height="' + _height +
                        '" frameBorder="0"' + ' src="' + src + '"/>',
                    title: {
                        text: '<div style="width: ' + _width + 'px; overflow: hidden; ' +
                            'text-overflow: ellipsis;">' + text + '</div>',
                        button: true
                    }
                },
                hide: {
                    event: 'unfocus'
                },
                show: {
                    event: 'click',
                    solo: true
                },
                style: {
                    widget: true,
                    classes: 'ui-tooltip-plain ui-tooltip-shadow'
                },
                position: {
                    my: 'top center',
                    at: 'bottom left',
                    adjust: adjust,
                    viewport: $j(window)
                }
            });
        });

        if (unknown_apps.length && query_fortiflow) {
            fgd_common._query_fortiflow_database(unknown_apps).done(function(data) {
                fgd_common._update_unknown_apps(data, app_cache);
                fgd_common._setup_tooltips(selector, idmethod, query_fortiflow, adjust);
            });
        }
    },

    // _setup_tooltips_iframe - Wrapper for setup_tooltips to
    // be called from within an iframe, allowing the qtip window to show outside
    // of the frame nicely.
    _setup_tooltips_iframe: function(selector, idmethod, query_fortiflow) {
        if (!window.frameElement) {
            return;
        }

        if (typeof(selector) == 'undefined') {
            selector = fgd_common.default_selector;
        }

        var $iframe = window.parent.$j(window.frameElement);


        if (selector.nodeType && selector.nodeType == 1) {
            window.parent.fgd_common._setup_tooltips(selector,
                                                         idmethod);
        } else {
            // Provide an offset.
            var adjust = {
                'x': $iframe.offset().left,
                'y': $iframe.offset().top
            };
            window.parent.fgd_common._setup_tooltips(function() {
                var $contents = $iframe;
                try {
                    //if the user loads a different src before ajax finishes
                    //this will throw
                    $contents = $iframe.$contents();
                } catch (ex) {
                }
                return $contents.find(selector);
            }, idmethod, query_fortiflow, adjust);
        }
    },

    // setup_device_tooltips: Wrapper which automatically determines
    // whether or not to use the standard or iframe tooltip function.
    setup_tooltips: function(selector, idmethod, query_fortiflow, forceIframe) {
        if ((window.parent == top || window.parent == window) &&
                !forceIframe) {
            return fgd_common._setup_tooltips(selector, idmethod, query_fortiflow);
        }
        return fgd_common._setup_tooltips_iframe(selector, idmethod, query_fortiflow);
    }
};

/*            'js/byod_common.js',*/
/*
  byod_common.js - Common functionality for the BYOD feature, providing
                   support for showing BYOD devices throughout the GUI.
  init July 2012 by J. Thompson

  Copyright Fortinet Inc.
*/
/*global escapeHTML, fweb, jQuery*/
var byod_common = (function($) {
    'use strict';

    return {
        default_selector: '.byod_details',

        gen_icon: function(className, value, title, icon_sprite)
        {
            var html = ('<span class="' + (icon_sprite || 'icon_sprite') +
                        ' ' + className + '"');
            if (title) {
                html += ' title="' + title + '"';
            }
            html += '/>';
            if (value) {
                html += '&nbsp;' + value;
            }

            return html;
        },

        // gen_fw_icon - Generate HTML for a user device icon.
        //   - className: additional CSS classes to apply
        //   - value: text to show immediately following the icon
        //   - title: optional tooltip
        gen_fw_icon: function(className, value, title)
        {
            return this.gen_icon(className, value, title, 'icon_fw');
        },

        gen_fw_device_icon: function(mac, device, alias) {
            if (!device) {
                device = 'unknown';
            }

            var className = this.gen_fw_device_class(device);
            alias = alias ? escapeHTML(alias) : mac;

            var html = ('<span class="byod_details" data-mac-address="' +
                         mac + '">');
            html += this.gen_fw_icon(className, alias, device);
            return html + '</span>';
        },

        gen_fw_device_sort_fn: function(mac_key, alias_key) {
            var alias_fn = $.isFunction(alias_key) ?
                    alias_key : function(x) { return x[alias_key]; };
            var fn = function(a, b, default_sort_fn) {
                var a_alias = alias_fn(a),
                    b_alias = alias_fn(b);
                if (!a_alias && !b_alias) {
                    return default_sort_fn(a[mac_key], b[mac_key]);
                }
                return default_sort_fn(a_alias, b_alias);
            };
            fn.kind = 'comp_row';
            return fn;
        },

        device_type_map: {
            // device category mappings
            'android-phone': 'android',
            'android-tablet': 'android',
            'blackberry-phone': 'blackberry',
            'blackberry-playbook': 'blackberry',
            'fortinet-device': 'fortinet',
            'gaming-console': 'gaming',
            'ip-phone': 'ip_phone',
            'linux-pc': 'linux',
            'mac': 'apple',
            'ipad': 'apple',
            'iphone': 'apple',
            'media-streaming': 'media',
            'other-network-device': 'other',
            'printer': 'printer',
            'router-nat-device': 'router',
            'windows-pc': 'windows',
            'windows-phone': 'windows',
            'windows-tablet': 'windows',

            // vpn tunnel type mappings
            'dialup-cisco': 'cisco',
            'dialup-android': 'android',
            'dialup-ios': 'apple',
            'dialup-forticlient': 'fortinet',
            'static-cisco': 'cisco',
            'static-fortigate': 'fortinet'
        },

        get_device_type: function(device) {
            var device_type = this.device_type_map[device];

            if (device_type != null) {
                return device_type;
            }

            return 'other';
        },

        gen_fw_device_class: function(device) {
            return 'device_' + this.get_device_type(device);
        },

        // _setup_device_tooltips - Add generic tooltips to any BYOD device
        // object (using the optional selector field).
        _setup_device_tooltips: function(target, adjust, solo) {
            $.addStyle('/css/jquery.qtip.css');

            if (typeof target === 'undefined') {
                target = byod_common.default_selector;
            }

            if (typeof(adjust) === 'undefined') {
                adjust = {};
            }

            var $target = $(target);
            $target.each(function() {
                var jthis = $(this);
                var mac_address = jthis.data('macAddress');
                if (!mac_address || mac_address === 'undefined') {
                    return;
                }
                var src = '/p/user/device_details/' + mac_address + '/';

                jthis.qtip({
                    content: {
                        text: ('<iframe width="330" height="150" ' +
                               'frameBorder="0" src="' + src + '"/>'),
                        title: {
                            // TODO: Localize the title.
                            text: 'Device Details',
                            button: true
                        }
                    },
                    position: {
                        my: 'top left',
                        at: 'bottom left',
                        adjust: adjust,
                        viewport: $(window)
                    },
                    hide: {
                        event: 'unfocus'
                    },
                    show: {
                        delay: 500,
                        // TODO: solo could be better defined as the following
                        // solo: $.type(target) === 'string' ?
                        //       target : byod_common.default_selector;
                        solo: (solo === undefined) ? true : solo
                    },
                    style: {
                        widget: true,
                        classes: 'ui-tooltip-plain ui-tooltip-shadow'
                    }
                });
            });
        },

        // _setup_device_tooltips_iframe - Wrapper for setup_device_tooltips to
        // be called from within an iframe, allowing the qtip window to show
        // outside of the frame nicely.
        _setup_device_tooltips_iframe: function(selector) {
            if (!window.frameElement) {
                return;
            }

            if (!window.parent.jQuery) {
                return;
            }

            if (typeof(selector) === 'undefined') {
                selector = byod_common.default_selector;
            }

            var $iframe = window.parent.$j(window.frameElement);
            var contents = $iframe.contents().find(selector);

            // Provide an offset.
            var adjust = {
                'x': $iframe.offset().left,
                'y': $iframe.offset().top
            };

            window.parent.byod_common._setup_device_tooltips(contents, adjust);
        },

        // setup_device_tooltips: Wrapper which automatically determines
        // whether or not to use the standard or iframe tooltip function.
        setup_device_tooltips: function(selector) {
            if (window.parent === top || window.parent === window) {
                return byod_common._setup_device_tooltips(selector);
            }
            return byod_common._setup_device_tooltips_iframe(selector);
        },

        isDevice: {
            Windows: function() {
                return (/Windows NT/i).test(navigator.userAgent);
            },

            Mac: function() {
                return (/Mac/i).test(navigator.userAgent);
            },

            iOS: function() {
                return (/iPhone|iPad|iPod/i).test(navigator.userAgent);
            },

            Android: function() {
                return (/Android/i).test(navigator.userAgent);
            },

            WindowsPhone: function() {
                return (/Windows Phone/i).test(navigator.userAgent);
            },

            Mobile: function() {
                return this.iOS() || this.Android() || this.WindowsPhone();
            }
        }
    };
})(jQuery);

/*            'js/csrf.js'*/
/* global fweb, getCookie */

(function($) {
    'use strict';

    $.ajaxSetup({
        beforeSend: function(jqxhr, settings) {
            /*
            var url, token;
            if (settings.type !== 'GET') {
                url = /^\//.test(settings.url) ? settings.url : window.location.pathname;

                // Use CSRF token from C apache modules or Python?
                token = /^\/p\//.test(url) ? getCookie('csrftoken') : fweb.get_csrf_token();
                jqxhr.setRequestHeader('X-CSRFTOKEN', token);
            }
            */
        }
    });
}(jQuery));
