/******************************
 Ajax Login
 Init by A. Krywaniuk, Mar 2006
 Copyright Fortinet, inc.
 All rights reserved
 ******************************/

// EXPORT_SYMBOL str_table
// EXPORT_SYMBOL try_login
// EXPORT_SYMBOL key_pressdown

var my_xmlhttp = null;
var buf_request_in_progress = false;


var elm_username = document.getElementById("username");
var elm_secretkey = document.getElementById("secretkey");

var elm_twofactor = document.getElementById("auth_two_factor");
var elm_authtoken = document.getElementById("auth_token");

var elm_tokenmsg = document.getElementById("token_msg");
var elm_tokencode = document.getElementById("token_code");

var elm_button = document.getElementById("login_button");


// Ajax requests are always encoded in UTF-8. So, I assume, are the responses.
// We can't easily return a string from the server, so better to cache them
// all here. (This table will be overriden by the C code when the page is generated.)
function login_string_table_t()
{
	this.login_failed = "Authentication failure";
	this.lockout_msg = "User lockout";
	this.server_unreachable = "Server unreachable";
}

var str_table = fgt_lang;//new login_string_table_t();

//Copy from Util.js ,then we can remove Util.js from login.html and 
//check the access permision when user access Util.js.  
function get_xmlhttp() {
	var xmlhttp = null;

    if (typeof XMLHttpRequest != "undefined") {
                xmlhttp = new XMLHttpRequest();
        } else try {
		xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
	} catch(e) {
		try {
			xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
		} catch(oc) {
			xmlhttp = null;
		}
	}

	return xmlhttp;
}

// login_send_request - send the login request as an Ajax message.
function login_send_request(str_url, str_body) 
{ 
	my_xmlhttp = get_xmlhttp();
	my_xmlhttp.onreadystatechange = handle_buffer_statechange;
	
	my_xmlhttp.open("POST", str_url, true);
	my_xmlhttp.setRequestHeader("Pragma", "no-cache");
	my_xmlhttp.setRequestHeader("Cache-Control", "no-store, no-cache, must-revalidate");
	my_xmlhttp.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
	my_xmlhttp.send(str_body);
}

// handle_buffer_statechange - onreadystatechange callback for the Ajax request.
function handle_buffer_statechange(ev)
{
	if (my_xmlhttp.readyState == 4) // 4 == complete
	{
		handle_buffer_ready();
	}
}


// try_login - begin the login process.
function try_login()
{
	if (buf_request_in_progress)
	{
		throw("Avoid sending conflicting request\n");
		return;
	}

	buf_request_in_progress = true;

	var xstr = "ajax=1&username=" + encodeURIComponent(elm_username.value) + "&secretkey=" + encodeURIComponent(elm_secretkey.value);
	
	if (elm_twofactor && elm_authtoken)
	{
		xstr += "&auth_two_factor=1&auth_token=" + encodeURIComponent(elm_authtoken.value);
	}
        
	if (elm_tokencode && (elm_tokencode.disabled == false))
	{
		xstr += "&token_code=" + encodeURIComponent(elm_tokencode.value);
	}

	clear_error_status_line();
	disable_input();
	
	try
	{
		login_send_request("/logincheck", xstr);
	}
	catch (e)
	{
		buf_request_in_progress = false;
		update_error_status_line(str_table.server_unreachable);
		reenable_input();
		
		my_xmlhttp.abort();
		delete my_xmlhttp;
		my_xmlhttp = null;
	}
}

var request_changepwd_in_progress = false;
function try_change_pwd()
{
	
	var elm_mkey = document.getElementById("mkey"); 
	var elm_newpwd1 = document.getElementById("newpwd1");
	var elm_newpwd2 = document.getElementById("newpwd2");
	var elm_confirm = document.getElementById("confirm");
	var elm_ssid = document.getElementById("session_id");
	var elm_error = document.getElementById("error");
	var elm_force_cur_user = document.getElementById("force_cur_user");
	if(request_changepwd_in_progress)
	{
		throw("Avoid sending conflicting request\n");
		return;
	}
	request_changepwd_in_progress = true;

	var xstr = "ajax=1&mkey=" + encodeURIComponent(elm_mkey.value) + "&newpwd1=" + encodeURIComponent(elm_newpwd1.value) + "&newpwd2=" + encodeURIComponent(elm_newpwd2.value) + "&confirm=" + elm_confirm.value + "&error=" + elm_error.value + "&session_id=" + elm_ssid.value + "&force_cur_user=" + elm_force_cur_user.value;

	clear_error_status_line();
	//disable_input();

	try
	{
		login_send_request("/loginchangepwd", xstr);
	}
	catch (e)
	{
		request_changepwd_in_progress = false;
		update_error_status_line(str_table.server_unreachable);
		//reenable_input();

		my_xmlhttp.abort();
		delete my_xmlhttp;
		my_xmlhttp = null;
	}
}


// Display a message in red above the username.
// Flash the colour between black and red to draw the user's attention (in particular when
// the error message is the same as the one from the previous request).
function update_error_status_line(msg)
{
    var elem = document.getElementById("err_msg_txt");
    var txt = document.createTextNode(msg);
    var warning_elem = document.getElementById("warning_msg");

    if(warning_elem !== undefined && warning_elem !== null)
    {
	    warning_elem.style.display = 'none';
    }
    elem.innerHTML = '';
    elem.appendChild(txt);
}

function clear_error_status_line()
{
    document.getElementById("err_msg_txt").innerHTML = '';
}


// handle_buffer_ready - function to handle the Ajax response. The first
// character of the response is the status code (0 is failure, 1 is success,
// and 2 is a special case for the 1 minute lockout). If success, the
// remainder of the string contains a JS function to redirect to the main page.
function handle_buffer_ready()
{
	// Check & reset semaphore.
	if (!buf_request_in_progress && !request_changepwd_in_progress)
		return;

	buf_request_in_progress = false;
	request_changepwd_in_progress = false;

	var retval = my_xmlhttp.responseText;
	
	my_xmlhttp = null;
	
	if (retval.length == 0)
	{
		update_error_status_line(str_table.server_unreachable);
		reenable_input();
		return;
	}

	var rv = retval.charAt(0); 
	var rv2 = retval.substring(1); 
	
	if (rv == "1")
	{
		// Originally the rv was a document containing JS.
		// Now it's just JS.
		eval(rv2);
	}
	else if (rv == "2") 
	{
		// rv = 2 is for 1 minute lockout
		locktime = locktime ? locktime : 60;

		update_error_status_line(flt_lang[rv2]);
		
		// Leave form fields during lockout period.
		setTimeout("reenable_input();", locktime * 1000);
	}
	else if (rv == "3") 
	{
		//2-factor auth needed: tokencode
		if(rv2 && str_table[rv2])
			update_error_status_line(str_table[rv2]);
		else
			update_error_status_line(str_table.login_failed);

		//showToken(true, parseInt(rv2[0]), retval.substring(2));
		if(elm_username !== null)
			elm_username.disabled = false;
		if(elm_secretkey !== null)
			elm_secretkey.disabled = false;
		if(elm_button !== null)
			elm_button.disabled = false;
		//elm_tokencode.focus();
		
	}
	else
	{
		update_error_status_line(str_table.login_failed);
		clear_input();
		reenable_input();
		showToken(false);
	}
}

function disable_input()
{
	//var two_factor_auth = (!!document.getElementById("auth_two_factor"));

	//if (!two_factor_auth) elm_username.value = "";
	if(!elm_username || !elm_secretkey || !elm_button)
		return;
	elm_username.disabled = true;
	//elm_secretkey.value = "";
	elm_secretkey.disabled = true;
	elm_button.disabled = true;
}

function reenable_input()
{
	var two_factor_auth = (!!document.getElementById("auth_two_factor"));

	if(!elm_username || !elm_secretkey || !elm_button)
		return;
	elm_username.disabled = false;
	elm_secretkey.disabled = false;
	elm_button.disabled = false;

	// Blur and set the focus on username
	elm_username.blur();
        
	if (two_factor_auth) 
		elm_secretkey.focus();
	else
		elm_username.focus();
}

// login_get_cmd_kbd_event and login_crack_kbd_event are the copies of 
// get_cmd_kbd_event and crack_kbd_event from jsconsole.js
// login_get_cmd_kbd_event - same as get_cons_kbd_event, but uses different document object
function login_get_cmd_kbd_event(evt_p)
{
	if (evt_p)
		return evt_p;
	evt = window.event;
	if (evt) 
		return evt;
	return null;
}

// login_crack_kbd_event - Returns the keypress code associated with the event.
function login_crack_kbd_event(evt)
{
	if (evt.which)
		return evt.which;
	else if (evt.keyCode)
		return evt.keyCode;
	else if (evt.charCode)
		return evt.charCode;
	return 0;
}

function key_pressdown(evt_p)
{
	try
	{
		var evt = login_get_cmd_kbd_event(evt_p);
		if(evt == null) return;
		var key_code = login_crack_kbd_event(evt);
		if(key_code == 0) return;
		// CR: Click login button
		if (key_code == 13)
		{
			elm_button.click();
			return false;
		}
	}
	catch (e)
	{
	}

	return true;
}

function update_token_msg(msg)
{
	while(elm_tokenmsg.childNodes.length)
	{
		elm_tokenmsg.removeChild(elm_tokenmsg.childNodes[0]);
	}

	var txt = document.createTextNode(msg);
	elm_tokenmsg.appendChild(txt);
	
	setTimeout("var elem = document.getElementById(\"token_msg\");", 100);
}

function showToken(show, token_type, token_info)
{
	var l = document.getElementById("label_token");
	var d = 'none'; //hide by default

	if (show) d = '';
	if (l) l.style.display = d;
	if (elm_tokenmsg) {
		elm_tokenmsg.style.display = d;
		if (show) {
			switch (token_type) {
			case 1:
				elm_tokenmsg.style.display = 'none';
				break;
			case 2:
				update_token_msg(str_table.mail_token_msg + ' <' + token_info + '> ' + str_table.token_msg_rest);
				break;
			case 3:
				update_token_msg(str_table.sms_token_msg + ' <' + token_info + '> ' + str_table.token_msg_rest);
				break;
			}
		}
	}
	if (elm_tokencode) elm_tokencode.style.display = d;
	if (elm_tokencode) elm_tokencode.disabled = show ? false : true;
	
	if(elm_button)
		elm_button.disabled = false;
}

function clear_input()
{
	var two_factor_auth = (!!document.getElementById("auth_two_factor"));

	if (!two_factor_auth) {
		if(elm_username)
			elm_username.value = "";
	}
	if(elm_secretkey)
		elm_secretkey.value = "";
	if (elm_tokencode) elm_tokencode.value = "";
}


