/**
 * http://www.openjs.com/scripts/events/keyboard_shortcuts/
 * Version : 2.01.B
 * By Binny V A
 * License : BSD
 */
var shortcut = {
    'all_shortcuts':{},//All the shortcuts are stored in this array
    'add': function(shortcut_combination,callback,opt) {
        //Provide a set of default options
        var default_options = {
            'type':'keydown',
            'propagate':false,
            'disable_in_input':false,
            'target':document,
            'keycode':false
        }
        if(!opt) opt = default_options;
        else {
            for(var dfo in default_options) {
                if(typeof opt[dfo] == 'undefined') opt[dfo] = default_options[dfo];
            }
        }

        var ele = opt.target;
        if(typeof opt.target == 'string') ele = document.getElementById(opt.target);
        var ths = this;
        shortcut_combination = shortcut_combination.toLowerCase();

        //The function to be called at keypress
        var func = function(e) {
            e = e || window.event;
            
            if(opt['disable_in_input']) { //Don't enable shortcut keys in Input, Textarea fields
                var element;
                if(e.target) element=e.target;
                else if(e.srcElement) element=e.srcElement;
                if(element.nodeType==3) element=element.parentNode;

                if(element.tagName == 'INPUT' || element.tagName == 'TEXTAREA') return;
            }
    
            //Find Which key is pressed
            if (e.keyCode) code = e.keyCode;
            else if (e.which) code = e.which;
            var character = String.fromCharCode(code).toLowerCase();
            
            if(code == 188) character=","; //If the user presses , when the type is onkeydown
            if(code == 190) character="."; //If the user presses , when the type is onkeydown

            var keys = shortcut_combination.split("+");
            //Key Pressed - counts the number of valid keypresses - if it is same as the number of keys, the shortcut function is invoked
            var kp = 0;
            
            //Work around for stupid Shift key bug created by using lowercase - as a result the shift+num combination was broken
            var shift_nums = {
                "`":"~",
                "1":"!",
                "2":"@",
                "3":"#",
                "4":"$",
                "5":"%",
                "6":"^",
                "7":"&",
                "8":"*",
                "9":"(",
                "0":")",
                "-":"_",
                "=":"+",
                ";":":",
                "'":"\"",
                ",":"<",
                ".":">",
                "/":"?",
                "\\":"|"
            }
            //Special Keys - and their codes
            var special_keys = {
                'esc':27,
                'escape':27,
                'tab':9,
                'space':32,
                'return':13,
                'enter':13,
                'backspace':8,
    
                'scrolllock':145,
                'scroll_lock':145,
                'scroll':145,
                'capslock':20,
                'caps_lock':20,
                'caps':20,
                'numlock':144,
                'num_lock':144,
                'num':144,
                
                'pause':19,
                'break':19,
                
                'insert':45,
                'home':36,
                'delete':46,
                'end':35,
                
                'pageup':33,
                'page_up':33,
                'pu':33,
    
                'pagedown':34,
                'page_down':34,
                'pd':34,
    
                'left':37,
                'up':38,
                'right':39,
                'down':40,
    
                'f1':112,
                'f2':113,
                'f3':114,
                'f4':115,
                'f5':116,
                'f6':117,
                'f7':118,
                'f8':119,
                'f9':120,
                'f10':121,
                'f11':122,
                'f12':123
            }
    
            var modifiers = { 
                shift: { wanted:false, pressed:false},
                ctrl : { wanted:false, pressed:false},
                alt  : { wanted:false, pressed:false},
                meta : { wanted:false, pressed:false}   //Meta is Mac specific
            };
                        
            if(e.ctrlKey)   modifiers.ctrl.pressed = true;
            if(e.shiftKey)  modifiers.shift.pressed = true;
            if(e.altKey)    modifiers.alt.pressed = true;
            if(e.metaKey)   modifiers.meta.pressed = true;
                        
            for(var i=0; k=keys[i],i<keys.length; i++) {
                //Modifiers
                if(k == 'ctrl' || k == 'control') {
                    kp++;
                    modifiers.ctrl.wanted = true;

                } else if(k == 'shift') {
                    kp++;
                    modifiers.shift.wanted = true;

                } else if(k == 'alt') {
                    kp++;
                    modifiers.alt.wanted = true;
                } else if(k == 'meta') {
                    kp++;
                    modifiers.meta.wanted = true;
                } else if(k.length > 1) { //If it is a special key
                    if(special_keys[k] == code) kp++;
                    
                } else if(opt['keycode']) {
                    if(opt['keycode'] == code) kp++;

                } else { //The special keys did not match
                    if(character == k) kp++;
                    else {
                        if(shift_nums[character] && e.shiftKey) { //Stupid Shift key bug created by using lowercase
                            character = shift_nums[character]; 
                            if(character == k) kp++;
                        }
                    }
                }
            }
            
            if(kp == keys.length && 
                        modifiers.ctrl.pressed == modifiers.ctrl.wanted &&
                        modifiers.shift.pressed == modifiers.shift.wanted &&
                        modifiers.alt.pressed == modifiers.alt.wanted &&
                        modifiers.meta.pressed == modifiers.meta.wanted) {
                callback(e);
    
                if(!opt['propagate']) { //Stop the event
                    //e.cancelBubble is supported by IE - this will kill the bubbling process.
                    e.cancelBubble = true;
                    e.returnValue = false;
    
                    //e.stopPropagation works in Firefox.
                    if (e.stopPropagation) {
                        e.stopPropagation();
                        e.preventDefault();
                    }
                    return false;
                }
            }
        }
        this.all_shortcuts[shortcut_combination] = {
            'callback':func, 
            'target':ele, 
            'event': opt['type']
        };
        //Attach the function with the event
        if(ele.addEventListener) ele.addEventListener(opt['type'], func, false);
        else if(ele.attachEvent) ele.attachEvent('on'+opt['type'], func);
        else ele['on'+opt['type']] = func;
    },

    //Remove the shortcut - just specify the shortcut and I will remove the binding
    'remove':function(shortcut_combination) {
        shortcut_combination = shortcut_combination.toLowerCase();
        var binding = this.all_shortcuts[shortcut_combination];
        delete(this.all_shortcuts[shortcut_combination])
        if(!binding) return;
        var type = binding['event'];
        var ele = binding['target'];
        var callback = binding['callback'];

        if(ele.detachEvent) ele.detachEvent('on'+type, callback);
        else if(ele.removeEventListener) ele.removeEventListener(type, callback, false);
        else ele['on'+type] = false;
    }
}
/*
  qed_menu.js - YUI menu bar wrapper class
  init Nov 2009 by A. Krywaniuk (adapted from FortiManager pagecomm.js)
  GUI redesign project
  Copyright Fortinet Ltd
*/


// TODO: this code was ported as raw code from the FortiManager and not
// properly adapted to FortiOS.

/*global qed_strtbl*/


//Page common NameSpace
var Page = {};
var PC = {};
PC.MenuActs = {};
PC.CtxtMenus = {};
PC.MenuBarInstances = {};


//******** all menu actions here *************

PC.MenuActs.toggleMenuItems = function(menuobj, en, dis){

    if (menuobj === null || typeof menuobj === 'undefined') {
        return;
    }
    
    var ii = 0;
    if (en) {
        for (ii = 0; ii < en.length; ii++) {
            menuobj.setMenuItemDisabled(en[ii], false);
        }
    }
    
    if (dis) {
        for (ii = 0; ii < dis.length; ii++) {
            menuobj.setMenuItemDisabled(dis[ii], true);
        }
    }
};

PC.MenuActs.toggleMenuBarItems = function () {

    var cData = Page.SelectionBuf().get();

    var itemsToEnable = [];
    var itemsToDisable = [];
    if(cData.length <= 0){
        itemsToDisable = ["mi_del", "mi_edit", "mi_clone", "mi_insert", "mi_mv"];
    }
    else if (cData.length === 1){
        itemsToEnable = ["mi_del", "mi_edit", "mi_clone", "mi_insert", "mi_mv"];
    }
    else {
        itemsToEnable = ["mi_del", "mi_clone"];
        itemsToDisable = ["mi_edit", "mi_insert", "mi_mv"];
    }

    PC.MenuActs.toggleMenuItems(PC.MenuBarInstance, itemsToEnable, itemsToDisable);
    
};

PC.MenuActs.toggleContextMenuItems = function () {

    var cData = Page.Clipboard().get();//which have data only, cut/copy action happens
    var bData = Page.SelectionBuf().get();

    var itemsToEnable = [];
    var itemsToDisable = [];
    
    if(bData.length <= 0){
        //if selection buffer has no data
        itemsToDisable = ["ctx_del", "ctx_edit", "ctx_cut", "ctx_copy", "ctx_view", "ctx_instb", "ctx_insta", "ctx_clone"];
    }
    else if (bData.length === 1){
        //if selection buffer has only one data selected
        itemsToEnable = ["ctx_del", "ctx_edit", "ctx_cut", "ctx_copy", "ctx_view", "ctx_instb", "ctx_insta", "ctx_clone"];
    }
    else {
        //if selection buffer has more than one data selected
        itemsToEnable = ["ctx_del", "ctx_clone"];
        itemsToDisable = ["ctx_edit", "ctx_cut", "ctx_copy", "ctx_view", "ctx_instb", "ctx_insta"];
    }

    //paste action is enabled only when ClipBoard has data
    if (bData.length ===1 && cData.length > 0){
        itemsToEnable.push("ctx_paste");
    }
    else {
        itemsToDisable.push("ctx_paste");
    }

    PC.MenuActs.toggleMenuItems(PC.CntxMenuInstance, itemsToEnable, itemsToDisable);
    
};



/****************************************************
 * Menu Class to generate menuBar and ContextMenu
 * this class inherits from YAHOO.widget.MenuBar
 * this is created by Functional Inheritance pattern
 * type: menu bar / context menu
 * container_id: attach menu to where
 * cfg: (optional)
 * Menu icon is embedded into text attribute.
 * icon's name: 
 *    when menu is enabled *.gif
 *    when menu is disabled *_dis.gif
 *****************************************************/
Page.MENU_T_BAR = 1;
Page.MENU_T_CNTX = 2;
Page.Menu = function (type, container_id, cfg)
{
    // this is an instance of new YAHOO.widget.MenuBar
    var that = null;
    if(type === Page.MENU_T_BAR){
        that = new YAHOO.widget.MenuBar(container_id, cfg);
    }
    else {
        that = new YAHOO.widget.ContextMenu(container_id, cfg ? cfg : {
                                        trigger: document,
                                        lazyload: true
                                    } );
    }
    
    // ******** additional methods for YUI MenuBar  ************ 
    
    // this method is to get first level menu item by item id;
    // id: an index of the item 
    //     id attribute of the item 
    var getItemById = function (id) {
        var i, item;
        
        if(typeof id === 'number'){
            return that.getItem(id);
        }
        
        var allItems = that.getItems();
        if (allItems) {
            var ItemNum = allItems.length;
            for (i = 0; i < ItemNum; i++){
                item = allItems[i];
                if (item && item.id && item.id === id) {
                    return item;
                }
            }
            // Go through the submenu items
            var allSubmenus = that.getSubmenus();
            var submenuNum = allSubmenus ? allSubmenus.length : 0;

            for (i = 0; i < submenuNum; i++){
                var allSubItems = allSubmenus[i].getItems();
                if (allSubItems) {
                    var itemNum = allSubItems.length;
                    for (var j = 0; j < itemNum; j++) {
                        item = allSubItems[j];
                        if (item && item.id && item.id === id) {
                            return item;
                        }
                    }
                }
            }
        }
        return null;
    };
    that.getItemById = getItemById;
    
    // get first level menu item property by item id
    // id: an index of the item 
    //     id attribute of the item 
    var getMenuItemProperty = function (id, prop){
        var aItem = getItemById(id);
        if(aItem){
            return aItem.cfg.getProperty(prop);
        }
    
        return null;
    };
    that.getMenuItemProperty = getMenuItemProperty;
    
    // set first level menu item property by item id
    // id: an index of the item 
    //     id attribute of the item 
    var setMenuItemProperty = function (id, prop, value){
        var aItem = getItemById(id);
        if(aItem){
            aItem.cfg.setProperty(prop, value);
        }
    
        return that;
    };
    that.setMenuItemProperty = setMenuItemProperty;
    
    // this method is to disable/enable first level menu item by item id;
    // id: an index of the item 
    //     id attribute of the item 
    var setMenuItemDisabled = function (id, disabled){
        var aItem = getItemById(id);
        if(aItem === null || typeof aItem === 'undefined'){
            return that;
        }
        
        //Change icon opacity
        if (disabled)
            $j("a.yuimenubaritemlabel", aItem).addClass("opacity_disable");
        else
            $j("a.yuimenubaritemlabel", aItem).removeClass("opacity_disable");

        //set disabled attribute of the menu item
        aItem.cfg.setProperty("disabled", disabled);
        
        return that;
    };
    that.setMenuItemDisabled = setMenuItemDisabled;
    
    return that;
};


/************ Menu item class. ************************
 * It is based on YUI menuItem input
 * p_click: 
 *  { 
 *      fn: Function (Required),    // The handler to call when the event fires. 
 *      obj: Object (Optional),     // An object to pass back to the handler. 
 *      scope: Object (Optional)    // The object to use for the scope of the handler. (By default the scope is the YAHOO.widget.MenuItem instance) 
 *  } 
 * p_keyboard:
 *  {
 *      shift (boolean), alt (boolean), ctrl (boolean), keys
 *  }
 * 
 *******************************************************/
Page.MenuItem = function(p_id, p_text, p_click, p_url, p_classname, p_helptext, p_keyboard, p_title, p_ctxt, p_single_only)
{
    var that = this;
    
    this.id = p_id;
    this.text = (p_text ? p_text : "&nbsp;");
    this.url = (p_url ? p_url : "#");
    this.classname = p_classname;
    this.helptext = p_helptext;
    this.onclick = p_click;
    this.keylistener = p_keyboard;
    this.title = p_title;
    this.ctxt = p_ctxt;
    this.single_only = p_single_only;

    this.addSubMenu = function(sub_id, subitems){
        that.submenu = {
            id: sub_id,
            itemdata: subitems
        };
        return that;
    };
    
    return this;
};




// new function for create Menu item
// cfg: {id:"idstr", img:"image name in images/menubar/", 
//      text:"label text", click:"click event", 
//      classname:"css class name",
//      ctxt:"status in context menu (default: enabled)"
//      single_only:"only support single entry (default: false)"
Page.createMenuItem = function(cfg)
{
    if(cfg === null && typeof cfg === 'undefined' ) return {};
    
    if (!cfg.text) cfg.text = "&nbsp";
    if (!cfg.imgdir) cfg.imgdir = "/images/menubar";
    
    var label;
    if (!cfg.spriteClass) {
        label = (cfg.img ? "<img id='img_" + cfg.id + "' src='" + cfg.imgdir + "/" + cfg.img +"'> " : "") + "<span id='text_" + cfg.id + "'>" + cfg.text + "</span>";
    }
    else {
        label = "<span class='tool_sprite " + cfg.spriteClass + "'>&nbsp;<span id='text_" + cfg.id + "'>" + cfg.text + "</span></span>";
    }

    var enable_in_ctxt = true;
    if (cfg.ctxt != null)
        enable_in_ctxt = cfg.ctxt;
    var single_only = false;
    if (cfg.single_only != null)
        single_only = cfg.single_only;

    var that = new Page.MenuItem(cfg.id, label, cfg.click, cfg.url, cfg.classname, "", cfg.keyboard, cfg.text, enable_in_ctxt, single_only);
    that.spriteClass = cfg.spriteClass;

    return that;
    
};


// qmenu_enable_button - enable/disable a menubar button.
// NOTE: q is mandatory for pages w/ multiple menubars.
function qmenu_enable_button(btn, bEnable, q)
{
    var button = $j(btn);
    var i, len;
    if (!button[0]) return;

    var button_id = button.attr("id");

    // With YUI, we need to disable the internal representation of the button, not the
    // HTML element.
    var oMB = q ? q.MenuBarInstance : PC.MenuBarInstance;
    var aItem = oMB.getItemById(button_id);

    if (aItem) {
        aItem.cfg.setProperty("disabled", !bEnable);
    }

    // Also disable any images attached to the button.
    // (This time using the HTML element.)
    if (!bEnable)
        $j("a.yuimenubaritemlabel", button).addClass("opacity_disable");
    else
        $j("a.yuimenubaritemlabel", button).removeClass("opacity_disable");

    // Disable the corresponding context menu item
    if (q) {
        qmenu_toggle_context_item(q, button_id, bEnable);
    }
}


function qmenu_toggle_context_item(q, id, enabled) {
    var i;
    for (i = 0; i < q.ctxt_menu_items.length; i++) {
        if (q.ctxt_menu_items[i].id == id) {
            q.ctxt_menu_items[i].disabled = !enabled;
            break;
        }
    }

    if ($j.isFunction(q.enable_qlist_context_item)) {
        q.enable_qlist_context_item(id, enabled);
    }
}

function qmenu_display_button(btn, bShow)
{
    var button_id = $j(btn).attr("id");
    if (button_id) {
        $j("#" + button_id + ", ." + button_id).toggle(bShow);
    }
}

function qmenu_label_button(btn, text)
{
    var button_id = $j(btn).attr("id");
    if (button_id) {
        $j("." + button_id + ">.yuimenuitemlabel").text(text);
    }
}

// qmenu_create_menubar - create the menubar at the head of the qlist.
function qmenu_create_menubar(parent_elem_id, q, rw_perm)
{
    var allItems = [];
    var item;
    q.ctxt_menu_items = [];

    // Override the default button ids if we are using a prefix.
    var prefix = q.prefix;
    if (prefix)
    {
        q.cr_new_btn_id = "mi_new_" + prefix;
        q.edit_btn_id = "mi_edit_" + prefix;
        q.del_btn_id = "mi_del_" + prefix;
        q.clone_btn_id = "mi_clone_" + prefix;
    }

    // Generate the MenuBar according to the given configuration.
    if (q.create_new && rw_perm) {
        var mNEW = Page.createMenuItem({id:q.cr_new_btn_id, spriteClass:"tool_new", ctxt:false, text:qed_strtbl.createnew, click:{fn: q.createnew_handler} });
        allItems.push(mNEW);
    }
    if (q.create_edit) {
        var mEDIT;
        if (rw_perm)
            mEDIT = Page.createMenuItem({id:q.edit_btn_id, spriteClass:"tool_edit", single_only:true, text:qed_strtbl.edit, click:{fn: q.edit_handler} });
        else
            mEDIT = Page.createMenuItem({id:q.edit_btn_id, spriteClass:"tool_search", single_only:true, text:qed_strtbl.view, click:{fn: q.edit_handler} });
        allItems.push(mEDIT);
    }
    if (q.create_del && rw_perm) {
        var mDEL = Page.createMenuItem({id:q.del_btn_id, spriteClass:"tool_delete", text:qed_strtbl.del, click:{fn: q.delete_handler} });
        allItems.push(mDEL);
    }

    // Allow pages to customize the menubar before it is rendered.
    if (q.customize_menu_fn)
    {
        q.customize_menu_fn(allItems);
    }

    // Destroy the existing instance of this menubar if it already exists
    if (PC.MenuBarInstances[parent_elem_id]) {
        PC.MenuBarInstances[parent_elem_id].destroy();
    }
    // Instantiate a MenuBar, passing in the id of the element to be created
    q.MenuBarInstance = Page.Menu(Page.MENU_T_BAR, parent_elem_id, { autosubmenudisplay: false });
    q.MenuBarInstance.addItems(allItems);

    for (var i = 0; i < allItems.length; i++) {
        item = allItems[i];
        if (item.ctxt) {
            q.ctxt_menu_items.push(
                    {
                        id:item.id,
                        text:item.title,
                        classname: (item.id ? item.id + " " : "") + (item.spriteClass ? "tool_sprite " + item.spriteClass : (item.classname || "")),
                        single_only:item.single_only,
                        click:item.onclick
                    }
                );
        }
        // For any submenu items
        if (item.submenu) {
            for (var j = 0; j < item.submenu.itemdata.length; j++) {
                var subitem = item.submenu.itemdata[j];
                if (subitem.ctxt) {
                    q.ctxt_menu_items.push(
                            {
                                id:subitem.id,
                                text:subitem.title,
                                classname: (subitem.id ? subitem.id + " " : "") + (subitem.spriteClass ? "tool_sprite " + subitem.spriteClass : (subitem.classname || "")),
                                submenu: subitem.submenu,
                                single_only:subitem.single_only,
                                click:subitem.onclick
                            }
                        );
                }
            }
        }
    }
    if (q.create_clone && rw_perm) {
        q.ctxt_menu_items.splice(1, 0, {
            id: q.clone_btn_id,
            text: qed_strtbl.clone,
            classname: q.clone_btn_id + " tool_sprite tool_clone",
            single_only: true,
            click: {fn: q.clone_handler}
        });
    }
    // Cache the most recently created menubar in PC.MenuBarInstance for backwards compatibility.
    PC.MenuBarInstance = PC.MenuBarInstances[parent_elem_id] = q.MenuBarInstance;

    // Render the MenuBar instance
    return q.MenuBarInstance;
}


/*****************************************************************************/
/*               Right Click Menu                                            */
/*****************************************************************************/
function add_new_menu_items(oMenu, aItems, click_fn)
{
    var nItems = aItems.length;
    var i, item;

    // Add items to the main menu
    for (i=0; i<nItems && (item = aItems[i], true); i++)
    {
        var oMenuItem = new YAHOO.widget.ContextMenuItem(item.text,
                {
                    classname: item.classname,
                    // new id must assign to clone submenu
                    submenu: item.submenu ? {id: "ctx_" + item.submenu.id, itemdata: item.submenu.itemdata} : undefined,
                    lazyload: true,
                    url: item.url
                });

        // Add a "click" event handler to each EditMenuItem instance
        if (click_fn)
            oMenuItem.subscribe("click", click_fn);

        oMenu.addItem(oMenuItem);
    }
}

// __disable_all_menu_items - grey out all the menu items
function __disable_all_menu_items(oMenu)
{
    var Groups = oMenu.getItemGroups();
    var aGroup = Groups[Groups.length-1];

    for (var i = 0; aGroup && i < aGroup.length; i++) {
        aGroup[i].cfg.setProperty("disabled", true);
    }
}

// enable_menu_items - decide what menu items to activate
function enable_menu_items(oMenu, checkedRows, aMenulist)
{
    var $cur_sel_row = $j(oMenu.contextEventTarget).closest('tr');
    var is_category_row = $cur_sel_row.hasClass('qlist_category');
    var is_category_collapse = $cur_sel_row.parent().nextUntil('.category').is(':hidden');
    var is_section_row = $cur_sel_row.hasClass('qlist_section');
    var is_section_collapse, expand_index, collapse_index = null;

    if (is_section_row) {
        $j.each($cur_sel_row.nextUntil('.qlist_section'), function(index, elem) {
            is_section_collapse = $j(elem).hasClass('hidden');
        });
    }

    $j.each(aMenulist, function(index, elem) {
        var classname = elem.classname;
        if(classname.indexOf("expand_qlistpolicy") !== -1 || classname.indexOf("expand_qlistglobalpolicy") !== -1) { expand_index = index; }
        if(classname.indexOf("collapse_qlistpolicy") !== -1 || classname.indexOf("collapse_qlistglobalpolicy") !== -1) { collapse_index = index; }
        if(classname.indexOf("expand_qlistexplicit-proxy-policy") !== -1 || classname.indexOf("expand_qlistglobalexplicit-proxy-policy") !== -1) { expand_index = index; }
        if(classname.indexOf("collapse_qlistexplicit-proxy-policy") !== -1 || classname.indexOf("collapse_qlistglobalexplicit-proxy-policy") !== -1) { collapse_index = index; }
    });

    if ((!checkedRows || checkedRows.length === 0) && !is_category_row) { return; }

    var Groups = oMenu.getItemGroups();
    var aGroup = Groups[Groups.length-1];
    var multiple = (checkedRows.length > 1);
    for (var i = 0; i < aMenulist.length; i++) {
        // When multiple table entries are selected, exclude the menu items
        // which only support singe entry
        var menuItem = aMenulist[i];
        if (menuItem.single_only) {
            //Disable the menuItem if it doesn't support multiple,
            //but don't re-enable it if it was already disabled.
            menuItem.disabled = multiple || menuItem.disabled;
        }
        if (menuItem.disabled)
            continue;

        if (aGroup && i < aGroup.length) {
            if (expand_index != null && collapse_index != null) {
                if (is_category_row && is_category_collapse) {
                    aGroup[expand_index].cfg.setProperty("disabled", false);
                    aGroup[collapse_index].cfg.setProperty("disabled", true);
                } else {
                    aGroup[expand_index].cfg.setProperty("disabled", true);
                    aGroup[collapse_index].cfg.setProperty("disabled", false);
                }

                if (is_section_row && is_section_collapse !== null) {
                    if(is_section_collapse === true) {
                        aGroup[expand_index].cfg.setProperty("disabled", false);
                        aGroup[collapse_index].cfg.setProperty("disabled", true);
                    } else {
                        aGroup[expand_index].cfg.setProperty("disabled", true);
                        aGroup[collapse_index].cfg.setProperty("disabled", false);
                    }
                }
            }

            if (!(is_category_row && (menuItem.classname.indexOf("tool_edit") !== -1
                || menuItem.classname.indexOf("tool_delete") !== -1
                || menuItem.classname.indexOf("tool_clone") !== -1
                || menuItem.classname.indexOf("tool_insert") !== -1
                || menuItem.classname.indexOf("tool_clear") !== -1))) {
                 aGroup[i].cfg.setProperty("disabled", false);
            }
        }
    }
}

// resolve_rightclick_target - determine the contextual target of this context
//                             menu
function resolve_rightclick_target(target)
{
    var elem = target;
    while (elem) {
        if (elem.tagName == "TABLE") {
            elem = null;
            break;
        }
        if (elem.tagName == "TR")
            break;

        elem = elem.parentNode;
    }
    return elem;
}

// qMenuClick - callback function when a menu item is clicked
function qMenuClick(p_sType, p_aArguments)
{
    // No matter what else we do, make sure to close the menu panel.
    var oMenu = this.parent;
    var menuIndex = this.index;
    var elem = oMenu.resolved_target;

    oMenu.hide();
    if (elem) {
        var click = oMenu.cur_ctxt_menu_items[menuIndex].click;
        click.fn.call(click);
    }
}

// qMenuMoveGeneric - callback function when context menu is displayed
function qMenuMoveGeneric(p_sType, p_aArgs, q)
{
    var oMenu = q.ctxt_menu;
    var elem = resolve_rightclick_target(oMenu.contextEventTarget);

    if ($j.isFunction(q.enable_qlist_context_item)) {
        oMenu.preventContextDefault = true;
    }

    if (oMenu.preventContextDefault !== true) {
        __disable_all_menu_items(oMenu);
    }

    if (elem) {
        oMenu.resolved_target = elem;
        oMenu.cur_ctxt_menu_items = q.ctxt_menu_items;
        q.cur_elem = elem;
        if (q.is_row_selected(elem)) {
            // Don't do anything to support multi-selection
        } else {
            // Only select the entry clicked on
            q.clear_selection();
            // q.select_row will handle all the select steps
            q.select_row(elem);
        }

        if (oMenu.preventContextDefault !== true) {
            enable_menu_items(oMenu, q.get_mixed_checked_rows(), q.ctxt_menu_items);
        }

        if ($j.isFunction(oMenu.afterBeforeShow)) {
            oMenu.afterBeforeShow(oMenu, q.get_mixed_checked_rows());
        }
    } else {
        q.cur_elem = null;
    }
}

// init_menu_generic - common code for menu initialization.
function __init_qmenu_generic(argv)
{
    var id = argv.id;
    var tb_id = argv.tb_id;
    var q = argv.q;

    if (PC.CtxtMenus[id]) {
        PC.CtxtMenus[id].destroy();
        PC.CtxtMenus[id] = null;
        $j('#' + tb_id).trigger('qmenu_ctxt_menu_destroyed');
    }

    // Create the bg menu
    var oMenu = new YAHOO.widget.ContextMenu(id, { trigger: tb_id, lazyload: true} );

    // Add the full list of possible menu items. The set of items that are
    // actually displayed will be pruned at run-time based on the context.
    add_new_menu_items(oMenu, q.ctxt_menu_items, qMenuClick);

    //  Add a "move" event handler to the context menu 
    oMenu.subscribe("beforeShow", qMenuMoveGeneric, q);

    oMenu.render($j('#' + tb_id).parent()[0]);
    oMenu.qlist_obj = q;
    q.ctxt_menu = oMenu;
    PC.CtxtMenus[id] = oMenu;

    $j('#' + tb_id).trigger('qmenu_ctxt_menu_initialized');
}

function init_qmenu_generic(id, tb_id, q)
{
  YAHOO.util.Event.onContentReady(tb_id, __init_qmenu_generic, {"id": id, "tb_id": tb_id, "q" : q});
}
/*
  qed_list.js - multi-function list/table class
  init Nov 2009 by A. Krywaniuk
  GUI redesign project
  Copyright Fortinet Inc
*/

/* Notes:

  The list supports the following features:
  - multi-selection of elements (ctrl & shift keys)
  - select element by clicking it
  - integration with the menubar for enabling/disabling buttons
  - track which elements are allowed to be deleted

*/

/*global qmenu_enable_button,qmenu_toggle_context_item,g_redir_url,alert,confirm,
wij_display_modal_dlg,wij_in_modal_op,wij_end_modal_dialog,is_rw_admin,
init_qmenu_generic,g_cmdb_table_id,setCookie,getCookie,shortcut,
fweb,dlg_close*/
/*jshint scripturl:true*/

// qed_strtbl - local string table for qlist functionality
var qed_strtbl = {
    createnew: "Create New",
    del: "Delete",
    edit: "Edit",
    view: "View",
    move: "Move",
    enable: "Enable",
    disable: "Disable",
    clear: "Remove All Entries",
    insert: "Insert",
    none_sel: "No items selected",
    del_confirm: "Are you sure you want to delete the element(s)?",
    cant_del_all : "Warning: some selected elements can't be deleted.",
    cant_multi_edit : "Can only edit one element at a time",
    wait_confirm: "This action may take a long time to complete. Would you like to continue?",
    wait_msg: "Please wait while your changes are applied...",
    clone : "Clone",
    ref : "Ref. Count",
    tags : "Tags",
    add_tags : "Add Tags",
    remove_tags : "Remove Tags",
    dummy: ""
};

function qlist_get_row_attr(row, attr_name)
{
    var info = $j(row).data("cmdbInfo");

    if (info && attr_name in info) {
        return info[attr_name];
    }

    return $j(row).attr(attr_name);
}

function qlist_mouse_dblclick_row(q, obj, ev)
{
    if (q.dblclick_fn)
    {
        q.dblclick_fn(q, obj);
    }
    else if (q.create_edit)
    {
        var editable = q.can_edit_fn(q, obj);
        if (editable) q.edit_elem_fn(q, obj, ev);
    }
}

function set_selected(jrow, selected) {
    jrow.toggleClass('selected', selected);
    jrow.find('input.qlist_cb').prop('checked', selected);
}

// qlist_click_row - default event handler for the mouseup action on a table row.
// Toggle the selection when the mouse is released over a TR element in the list.
function qlist_mouse_click_row(q, obj, ev)
{
    var jobj = $j(obj);
    // handle_shift_select - handle a range selection when the shift
    // key is depressed.
    function handle_shift_select()
    {
        if (!q.last_sel_row)
            return false;

        var last_sel_idx = -1;
        var cur_sel_idx = -1;

        var aElems = q.get_all_rows();

        // Locate the current & previous selections in the list in
        // order to establish a range.
        cur_sel_idx = aElems.index(obj);
        last_sel_idx = aElems.index(q.last_sel_row);

        if (last_sel_idx === -1 || cur_sel_idx === -1) return false;

        // The new range replaces the current selection unless the
        // ctrl-key is also pressed.
        if (!ev.ctrlKey)
        {
            q.clear_selection();
        }

        var elem1 = Math.min(last_sel_idx, cur_sel_idx);
        var elem2 = Math.max(last_sel_idx, cur_sel_idx);
        var rows = q.get_all_rows();
        for (var i=elem1; i <= elem2; i++) {
            if (!$j(rows[i]).hasClass('unselectable')) {
                set_selected($j(rows[i]), true);
            }
        }

        return true;
    }

    // handle_noshift_select - handle a selection operation
    // when the shift key is not depressed.
    function handle_noshift_select()
    {
        var is_section = function (row) {
            return $j(row).hasClass('qlist_section')
        };

        if (ev.ctrlKey)
        {
            // If the clicked obj is a section row, or the last clicked obj
            // is a section row, always clear all the existing selection and
            // treat this like a new single select because we can not select a
            // mix
            var sections_enabled = q.categories.editable || q.editable_sections;
            if (sections_enabled && (is_section(obj) || is_section(q.last_sel_row))) {
                q.clear_selection();
                set_selected(jobj, true);
            } else {
                set_selected(jobj, !jobj.hasClass('selected'));
            }
        }
        else
        {
            q.clear_selection();
            set_selected(jobj, true);
        }

        q.last_sel_row = obj;
    }

    // handle click event other than qlist checkbox
    if (!$j(ev.target).is(".qlist_cb")) {
        // Support range selection (shift), toggle 1 element (ctrl),
        // or replace the current selection (none)
        if (ev.shiftKey) {
            if (!handle_shift_select()) {
                // Fall through to the regular select if we can't
                // do a range selection.
                handle_noshift_select();
            }
        } else {
            handle_noshift_select();
        }
    }

    var aElems = q.get_mixed_checked_rows();
    q.handle_selection_change_fn(q, aElems);
}


// qlist_handle_selection_change - update button states when the selection changes.
function qlist_handle_selection_change(q, rows)
{
    var aElems = rows || q.get_mixed_checked_rows();

    var enable_delete = false;
    var enable_edit = false;
    var enable_clone = false;

    var len = aElems.length;
    for (var i=0; i<len; i++)
    {
        // Enable delete button if at least one element can be deleted.
        if (!enable_delete)
        {
            enable_delete = q.can_delete_fn(q, aElems[i]);
        }

    }

    if (len === 1) {
        enable_clone = aElems[0].className.indexOf('qlist_section') < 0;

        // enable edit if the single selected object can be edited
        enable_edit = q.can_edit_fn(q, aElems[0]);
    }

    qmenu_enable_button($j('#' + q.edit_btn_id), enable_edit, q);
    qmenu_enable_button($j('#' + q.del_btn_id), enable_delete, q);
    qmenu_toggle_context_item(q, q.clone_btn_id, enable_clone);
}

// qlist_onclick_toggleall - handle "Toggle All" header checkbox.
function qlist_onclick_toggleall(q, obj)
{
    obj.blur();
    q.toggle_all(obj.checked);
}

// qlist_accel_toggleall - handle the "Toggle All" accelerator key.
function qlist_accel_toggleall(q)
{
    // As opposed to the click event, with the accelerator key we
    // need to toggle the checkbox by ourselves.
    q.toggle_all(!q.get_hdr_checked());
}

function qlist_create_elem(q)
{
    var cr_new_url = q.cr_new_url;
    cr_new_url = qlist_url_append_redir(cr_new_url);

    if (q.popup) {
    	var qlistSubSlide;    	
		qlistSubSlide = new top.Sliderin({ 
			title: '',  
			url: cr_new_url,  
			width: q.sliderwidth
		}); 
		qlistSubSlide.open();    	
        //var ready = fweb.dialog(fweb.iframe(cr_new_url));

        //if ($j.isFunction(q.popup)) {
        //    ready.done(q.popup);
        //}
    } else {
        window.location.href = cr_new_url;
    }

    return false;
}

// qlist_onclick_createnew - default handler for "Create New" button.
function qlist_onclick_createnew(q)
{
    q.create_elem_fn(q);
}


function qlist_url_append_arg(url, name, value)
{
    var has_args = (url.indexOf("?") > -1);
    var separator = has_args ? "&" : "?";

    return (url + separator + name + "=" + value);
}

function qlist_url_append_redir(url)
{
    if (typeof g_redir_url != "undefined" && g_redir_url.length)
    {
        return qlist_url_append_arg(url, "redir", g_redir_url);
    }

    return url;
}

// qlist_delete_elems - default implementation of delete elements.
// This will navigate to a deletion page.

function qlist_delete_elems(q, aElems) {
    var url = q.cr_del_url;
    var id_arr = [],
        use_arr = false;
    var len = aElems.length;
    url = qlist_url_append_arg(url, "session_id", session_id);
    
    if(typeof vdom != "undefined")
	    url = qlist_url_append_arg(url, "vdom", vdom);
  
    if(typeof del_type != "undefined")
        url = qlist_url_append_arg(url, "type", del_type);

    for (var i = 0; i < len; i++) {
        /*modify for new qlist in 5.5.5*/
        //var id = aElems[i].getAttribute("q_type") || q.cmdb_table_id || 0;
        var id = (q.cmdb_table_id>0 ? q.cmdb_table_id : 0) || aElems[i].getAttribute("q_type") || 0;
        id_arr.push(id);
        if (id != id_arr[0]) use_arr = true;
        var attr = encodeURIComponent(qlist_get_row_attr(aElems[i], "mkey"));
        url = qlist_url_append_arg(url, "mkey", attr);
    }
    url += "&id=" + (use_arr ? id_arr.join("&id=") : id_arr[0]);
    url = qlist_url_append_redir(url);
    $j.submitPOST(url);
}
/*
function qlist_delete_elems(q, aElems)
{
    var id_map = {};
    var len = aElems.length;

    for (var i=0; i<len; i++)
    {
        var id = aElems[i].getAttribute("del_type") ||
                 aElems[i].getAttribute("q_type") ||
                 q.cmdb_table_id || 0;

        if (!id_map[id]) {
            id_map[id] = [];
        }

        // Skip objects with the same master key and table id. This prevents an attempted
        // duplicate deletion in some cases.
        var attr = qlist_get_row_attr(aElems[i], "mkey");
        if (id_map[id].indexOf(attr) == -1) {
            id_map[id].push(attr);
        }
    }

    function _on_delete_complete() {
        var i, error;
        // Put resolved params in a list if we are handling only one promise
        var data = typeof arguments[1] == 'string' ? [arguments] : arguments;

        for (i = 0; i < data.length; i++ ) {
            error = data[i][0].error;
            if (error) break;
        }

        if (error) {
            Notify.post($j.getInfo(error), "error");
        } else {
            window.location.reload();
        }
    }

    var _promises = [];
    for (var type in id_map) {
        var promise = CMDB["delete"](null, null, id_map[type], null, {'type': type});
        _promises.push(promise);
    }

    $j.when.apply($j, _promises).done(_on_delete_complete);
}
*/

// qlist_onclick_delete - default handler for the delete button.
// Handle a multi-element deletion based on the current selection.
function qlist_onclick_delete(q, obj)
{
    if (obj && obj.disabled) return;

    var aElems = q.get_mixed_checked_rows();
    var undeletable_exists = false;
    var confirm_msg = qed_strtbl.del_confirm;

    // Note: this case should be disabled by JS.
    if (aElems.length === 0)
    {
        alert(qed_strtbl.none_sel);
        return;
    }

    // Prune any undeletable elements.
    var len = aElems.length;
    for (var i=len-1; i>=0; i--)
    {

        if (!q.can_delete_fn(q, aElems[i]))
        {
            undeletable_exists = true;
            aElems.splice(i,1);
        }
    }
    if (undeletable_exists)
    {
        confirm_msg += '<br/><br/>' + qed_strtbl.cant_del_all;
    }

    if (!confirm(qed_strtbl.del_confirm)) {
        return;
    }
    //$j.confirm(confirm_msg).done(function() {

        // if a lot (>=50) of elements are going to be deleted,
        //  prompt the user if they want to continue
        var modal_dlg = null;
        /* Fix bug: 0447478 */
        // if (aElems.length >= q.batch_op_prompt_limit && !(modal_dlg = $j.waitModalPrompt()))
        // {
        //     return;
        // }
        // Invoke the delete elements callback.
        q.avoid_duplicated_warning = true;
        q.delete_elems_fn(q, aElems);

        if (modal_dlg) {
            modal_dlg.close();
        }
    //});
}

function qlist_clone_elem(q, obj) {
    if (obj && obj.disabled) return;

    var elems = q.get_mixed_checked_rows();
    var mkey = qlist_get_row_attr(elems[0], 'mkey');
    var q_type = qlist_get_row_attr(elems[0], 'q_type');

    fweb.cmdbClone({mkey: mkey, qType: q_type}).done(function() {
        window.location.href = window.location.href;
    });
}


// qlist_edit_elem_by_mkey - default handler for the edit button.
// Launch the edit dialog for the selected element.
// TODO: do we need to escape the URL?
function qlist_edit_elem_by_mkey(q, elem)
{
    // Generally the edit URL is just the create new URL with the mkey
    // tacked on.
    var attr = qlist_get_row_attr(elem, "mkey");

    if (attr) {
        attr = encodeURIComponent(attr);
        var url = q.cr_edit_url;
        url = qlist_url_append_arg(url, "mkey", attr);
        url = qlist_url_append_redir(url);
	    if (q.popup) {
	    	var qlistSubSlide;    	
			qlistSubSlide = new top.Sliderin({ 
				title: '',  
				url: url,  
				width: q.sliderwidth
			}); 
			qlistSubSlide.open();    	
	        //var ready = fweb.dialog(fweb.iframe(cr_new_url));

	        //if ($j.isFunction(q.popup)) {
	        //    ready.done(q.popup);
	        //}
	    } else {        
        //if (q.popup)
        //    url = "javascript:fweb.dialog(fweb.iframe('" + url + "'));";
        	window.location.href = url;
        }
    }
}


// qlist_onclick_edit - default handler for the edit button
function qlist_onclick_edit(q, obj)
{
    if (obj && obj.disabled) return;

    var aElems = q.get_mixed_checked_rows();

    if (aElems.length === 0)
    {
        alert(qed_strtbl.none_sel);
        return;
    }

    // Note: this case should be disabled by JS.
    if (aElems.length > 1)
    {
        alert(qed_strtbl.cant_multi_edit);
        return;
    }

    q.edit_elem_fn(q, aElems[0]);
}

// qlist_click_checkbox - onclick handler for the row checkbox.
function qlist_click_checkbox(q, obj)
{
    q.handle_selection_change_fn(q);

    // The default browser behaviour already does what we want, but it
    // looks bad if we keep the selection on this element.
    obj.blur();
    return true;
}

// first try 'can_delete'(which could involve more checking logic in Apache module side), then 'q_ref' + is_rw_admin
// 'q_ref' + is_rw_admin is the preferred approach, and 'can_delete' is supposed to be eliminated eventually
function qlist_can_delete_elem(q, elem)
{
    var can_delete = false;
    var j_elem = $j(elem);
    var attr = j_elem.attr("can_delete");
    var is_referenced, is_static;

    if (attr !== undefined)
    {
        can_delete = parseInt(attr, 10) ? true : false;
    }
    else if (is_rw_admin)
    {
        is_referenced = !!Number(j_elem.attr('q_ref'));
        is_static = j_elem.attr('q_static') == 'true';
        can_delete  = !is_referenced && !is_static;
    }
    return can_delete;
}

// basic can delete, checks if can_edit attribute is present and set to false
function qlist_can_edit_elem(q, elem)
{
    var can_edit = true;

    var j_elem = $j(elem);
    var attr = j_elem.attr("can_edit");

    if (attr !== undefined) {
        can_edit = parseInt(attr, 10) ? true : false;
    }

    return can_edit;
}

// qlist_obj - the template qlist configuration object
var qlist_obj = {

    // Mandatory override parameters:
    // (each table instance must set these parameters to the appropriate values)
    // TODO: Many of these have bad names ("cr_" is short for "create").
    cr_new_url : "/error",
    cr_edit_url : "/error",
    cr_del_url : "/delete", // DEPRECATED: replaced by generic deletion.
    cmdb_table_id : -1, // used by generic delete module
    popup : false,

    // Optional override parameters:
    // (these can be overriden for pages which require specialized handling)
    id : "qlist", // DOM id of the data table
    // prefix - unique id to distinguish between multiple qlist instances (Note:
    // not always used as a prefix - sometimes it's a suffix or even in the middle)
    prefix: null,
    hdr_cb : "qlist_hdr_cb", // "toggle all" checkbox in the header
    // TODO: these variables have bad names. Rename them.
    create_new: true, // create New button?
    create_edit: true, // create Edit button?
    create_del: true, // create Delete button?
    create_clone: false, // create Clone context menu option?
    disable_context_menu : false, // disable right-click menu
    batch_op_prompt_limit : 50, // when operation involves lots of entries, a prompt message will be shown
    disable_text_selection : false, // disable selection of text within a list

    //DEPRECATED -- using editable_sections moving forward. Section row generation moved into
    // jquery.qlist.js
    categories: {
        sorted: false, // enables/disables sorting the categories alphabetically
        collapsible: true, // categories can be collapsed/expanded by default
        editable: false, // enable/disable if we would like to edit the category
        q_type: null // cmdb table id of category
    },

    // Treat sections as editable
    editable_sections: false,

    // Default button names (will be overridden if using prefix):
    cr_new_btn_id : "mi_new",
    edit_btn_id : "mi_edit",
    del_btn_id : "mi_del",
    clone_btn_id : "mi_clone",

    // Whether create reference column:
    enable_ref_col : true,
    // Whether the reference column has been pre-built by apache module to avoid performace issue of adding dynamically
    prebuilt_ref_col : false,

    // Optional override callbacks:
    createnew_handler : null,
    delete_handler : null,
    edit_handler : null,
    clone_handler: null,
    create_elem_fn : qlist_create_elem,
    delete_elems_fn : qlist_delete_elems,
    edit_elem_fn : qlist_edit_elem_by_mkey,
    clone_elem_fn: qlist_clone_elem,
    dblclick_fn : null,
    customize_menu_fn : null,
    handle_selection_change_fn : qlist_handle_selection_change,
    context_menu_init : init_qmenu_generic,

    can_delete_fn : qlist_can_delete_elem,
    can_edit_fn : qlist_can_edit_elem,

    // Run-time variables:
    qlist_last_sel_row : null,
    MenuBarInstance : null,
    ctxt_menu : null,
    ctxt_menu_items : [],

    // jquery cache for performance improvement:
    jc_enable : true,
    jc_qlist_rows : null,
    jc_qlist_cbs : null,

    // tree containers
    items: {},
    id_map: {},

    // init - initialize the callbacks
    init : function()
    {
        // Setup the closures for the default event handler functions.
        function mk_createnew_cb(q) { return function() { qlist_onclick_createnew(q);}; }
        function mk_delete_cb(q) { return function(arg1) { qlist_onclick_delete(q, arg1);}; }
        function mk_edit_cb(q) { return function(arg1) { qlist_onclick_edit(q, arg1);}; }
        function mk_clone_cb(q) { return function(arg1) { qlist_clone_elem(q, arg1);}; }

        if (!this.createnew_handler) this.createnew_handler = mk_createnew_cb(this);
        if (!this.delete_handler) this.delete_handler = mk_delete_cb(this);
        if (!this.edit_handler) this.edit_handler = mk_edit_cb(this);
        if (!this.clone_handler) this.clone_handler = mk_clone_cb(this);
        if (this.jc_enable) this.jc_update();

        this.categorize_table();
    },

    jc_update : function()
    {
        this.jc_qlist_rows = $j('tr.qlist_row:not(.qlist_skip_row)',
            '#' + this.id);
        this.jc_qlist_cbs = this.jc_qlist_rows.find('input:checkbox.qlist_cb');
    },

    /* This is used by C pages. TODO: Remove once all pages are converted
     * to Python */
    // append_ref_col should be called before header relocation
    append_ref_col : function()
    {
        if (!this.enable_ref_col) return;

        var have_ref_col = false;
        var j_qlist = $j("#" + this.id);

        if (this.prebuilt_ref_col)
        {
            have_ref_col = true;
        }
        else
        {
            // TODO: update with cached jquery after branch br_4-2_gui_performance is merged
            // The header row
            // There are 2 cases:
            // 1. a <thead> block containing multiple <th> nodes.
            // 2. a <tr class="heading"> containing multiple <td>'s.
            var j_header = $j(" > thead > tr.heading", j_qlist);
            if (j_header.length === 0)
            {
                j_header = $j(" > tbody > tr.heading", j_qlist);
            }

            if (j_header != null && j_header.length > 0)
            {
                have_ref_col = true;
                var last_cell = $j(" > :last", j_header[0]);
                var ref_cell = $j("<th/>").attr("rowspan", j_header.length);

                last_cell.after(ref_cell);
                ref_cell.html(qed_strtbl.ref);
                ref_cell.attr('fixed', '')
                        .addClass('ref-col')
                        .data('selector', 'ref-col');
                ref_cell.removeAttr('lang_key');

                // content rows
                $j("tr.qlist_row", j_qlist).each(function()
                {
                    var j_this = $j(this);
                    last_cell = $j(this.cells[this.cells.length-1]);
                    ref_cell = $j('<' + last_cell.prop('tagName') + '>');
                    last_cell.after(ref_cell);
                    var ref = j_this.attr("q_ref");
                    if (ref == null)
                    {
                       ref = 0;
                    }
                    else
                    {
                       ref = parseInt(ref, 10);
                    }
                    //update the link
                    ref_cell.html("<a class='qlist_ref' href='#'>" + ref + "</a>");
                });
            }
        }

        if (have_ref_col)
        {
            // TODO: move this event-hooking up into setup_listitem_event_handlers after  branch br_4-2_gui_performance is merged
            j_qlist.delegate("a.qlist_ref", "click", function() {
                var q_tr = $j(this).closest("tr.qlist_row");

                // sometime internal mkey and it's display are different, like table_id/mkey
                var mkey_display;

                // for mkey first try 'table_id', used by pages like file filter, web url filter, then try 'mkey'
                var mkey = q_tr.attr("table_id");
                if (mkey == null)
                {
                    mkey = q_tr.attr("mkey");
                }
                else
                {
                    mkey_display = q_tr.attr("mkey");
                }

                if (mkey != null)
                {
                    // first try overridden CMDB object type for each entry, then try the global one
                    var q_type = q_tr.attr("q_type");
                    if (q_type == null)
                    {
                        q_type = g_cmdb_table_id;
                    }

                    var q_type_extra = q_tr.attr("q_type_extra");
                    if (typeof q_type_extra !== 'undefined') {
                        q_type = [q_type].concat(q_type_extra.split(','));
                    }

                    var url = "/objusagedlg?" + $j.param({'type': q_type, 'mkey': mkey}, true);
                    if (mkey_display != null)
                    {
                        url += $j.param({'mkey_display': mkey_display}, true);
                    }
                    // use static different static height to fit into cases with different rows
                    fweb.dialog(fweb.iframe(url, {resizeEvent: 'update.fweb'}));
                }
                return false;
            });
        }
    },

    init_menubutton_state : function()
    {
        this.handle_selection_change_fn(this);
    },

    categorize_table: function () {
        var columns = this.find_columns();
        if (columns.length > 0) {
            var colspan = $j('#' + this.id + ' tbody > tr:first td').length;
            var body = this.load_data(columns, colspan);
            this.recreate_table(body, colspan, columns);
        }
    },

    find_columns: function() {
        var columns = [], re = /n(\d)+/, i, len;
        var first_row = $j(['#', this.id, ' thead > tr'].join('')).first();
        var children = first_row.children('th');
        for (i = 0, len = children.length; i < len; ++i) {
            var j_this = $j(children[i]);
            if (j_this.hasClass('category')) {
                var classes = j_this.attr('class').split(' ');
                for (var j = 0, cls_len = classes.length; j < cls_len; ++j) {
                    var matches = re.exec(classes[j]);
                    if (matches) {
                        columns[Number(matches[1])] = i + 1;
                    }
                }
            }
        }
        return columns;
    },

    hide_columns: function(columns, body) {
        var table = $j('#' + this.id), cols_copy = columns.slice(0);
        cols_copy.sort(function(a, b) { return b - a; /*reverse sort*/ });
        for (var i = 0, col_len = cols_copy.length; i < col_len; ++i) {
            var num_sfx = [':nth-child(', cols_copy[i], ')'].join('');
            body.find('td' + num_sfx).hide();
            table.find('th' + num_sfx).hide();
        }
    },

    load_data: function(columns, colspan) {
        var counter = 1, obj_counter = 1, j_id = '#' + this.id;
        var body = $j(j_id + ' tbody:first').detach();
        $j(j_id).append('<tr><td class="loading" colspan="'
                        + colspan + '">' + $j.getInfo('loading')
                        + '</td></tr>');
        this.items = {};
        this.id_map = {};
        var loading_td = body.find('tr td.loading');
        if (loading_td.length) {
            loading_td.parent('tr').remove();
        } else {
            body.find('> tr').hide();
        }
        this.hide_columns(columns, body);
        var that = this;
        body.find('> tr').each(function() {
            var index = [];
            for (var i = 0, col_len = columns.length; i < col_len; ++i) {
                var column = $j(this.children[columns[i] - 1]);
                var text = column.text();
                index.push(text);
                var id = that.id_map[text];
                if (!id) {
                    that.id_map[text] = '_' + counter++;
                }
            }
            var item = that.items[index];
            this.setAttribute('id', 'row_' + obj_counter++);
            if (item) {
                item.push(this);
            } else {
                that.items[index]=[this];
            }
        });
        return body;
    },

    add_child: function(parent, child) {
        var data = parent.data(), prev_child = data.child;
        if (prev_child) {
            data.child = [prev_child, child].join(',');
        } else {
            data.child = child;
        }
    },

    _get_all_child: function(children, show_class) {
        var result = [];
        if (children) {
            var objs = children.split(',');
            for (var i = 0, objs_len = objs.length; i < objs_len; ++i) {
                var id_elem = document.getElementById(objs[i]);
                var obj_id = $j(id_elem);
                result.push(id_elem);
                var data = obj_id.data('child');
                if (data) {
                    if (show_class == null || obj_id.hasClass(show_class)) {
                        result = result.concat(this._get_all_child(data, show_class));
                    }
                }
            }
        }
        return result;
    },

    get_all_child: function(elem, show_class) {
        return $j(this._get_all_child(elem.data('child'), show_class));
    },

    get_tree_state_cookie_name: function() {
        return 'qlist-expanded' + document.location.pathname;
    },

    store_tree_state: function() {
        var ids = [];
        $j('#' + this.id).find('.expanded').each(function() {
            ids.push(this.getAttribute('id'));
        });
        setCookie(this.get_tree_state_cookie_name(), ids.join(','));
    },

    on_click_handler: function(elem) {
        elem.toggleClass('expanded').toggleClass('collapsed');
        if (elem.hasClass('expanded')) {
            this.get_all_child(elem, 'expanded').show();
        } else {
            this.get_all_child(elem, null).hide();
        }
        this.store_tree_state();
    },

    get_keys_for_items: function() {
        var keys = [];

        for (var key in this.items) {
            if (this.items.hasOwnProperty(key)) {
                keys.push(key);
            }
        }

        return keys;
    },

    restore_tree_state: function() {
        var ids_cookie = getCookie(this.get_tree_state_cookie_name());
        if (ids_cookie) {
            var ids = ids_cookie.split(',');
            for (var i = 0, ids_len = ids.length; i < ids_len; ++i) {
                var elem = $j('#' + ids[i]);
                elem.show();
                elem.addClass('expanded').removeClass('collapsed');
                this.get_all_child(elem, 'expanded').show();
            }
        }
    },

    recreate_table: function(body, colspan, columns) {
        if (columns == null) { columns = []; }
        var counter = 1;
        var keys = this.get_keys_for_items();

        if (this.categories.sorted) {
            keys.sort();
        }

        keys.reverse();

        var created = {};
        // initialize these outside the loop
        var init_class = ' expanded';
        var init_display_style = '"';
        var init_icon_class = ' class="noncollapsible"';
        var twistie_padding = 3; // not magic, derived from old code
        if (this.categories.collapsible) {
            init_class = ' collapsed';
            init_display_style = '" style="display:none;"';
            init_icon_class = '';
            twistie_padding = 18; // from old code basing twistie icon width
        }
        var cat_q_type_attr = '';
        var cat_mkey_attr = '';
        var cat_q_ref = '';

        if (this.categories.editable) {
            cat_q_type_attr = '" q_type="' + this.categories.q_type + '"';
            // q_ref >= 1 b/c categories gotten from item list, this is to
            // disable 'delete' menu item. Might set the exact value by
            // passing a full list of categories
            cat_q_ref = '" q_ref="1"';
        }

        for (var j = 0, keys_len = keys.length; j < keys_len; ++j) {
            var id = '', prev_id = '', i, ind_len;
            // Old code uses comma to separate multiple category levels.
            // However, our title can be like 'VOIP, Messaging and ...'. So let
            // use # then. Must verify any page using multi categorized levels
            // Background info: the old code tries to use raw arrays as keys for
            // the 'this.items' object, and these are coerced using Array.toString, 
            // which is where the comma separation originates (see load_data for
            // an example of this (bad) behaviour)
            var index = keys[j].split('#');
            var rows = this.items[index];
            for (i = 0, ind_len = index.length; i < ind_len; ++i) {
                var cat_name = index[i];
                id += this.id_map[cat_name];
                var cat_cell = $j(rows[0]).children().eq(columns[i] - 1);
                var formatted_cat_name = cat_cell.html();
                if (created[id] == null) {
                    var td = ['<td colspan="'+ colspan + '" style="',
                              'padding-left:', 10 * i + twistie_padding,
                              'px !important;', 'background-position:',
                              10 * i, 'px;"', init_icon_class,
                              '>', formatted_cat_name, '</td>'].join('');
                    //create element
                    if (this.categories.editable) {
                         cat_mkey_attr = '" mkey="' + cat_name + '"';
                    } else {
                         // // reset b/c it might be changed from prev loop
                         cat_mkey_attr = '';
                    }
                    if (prev_id) {
                        var prev = created[prev_id];
                        prev.after([
                            '<tr class="qlist_other_category', init_class,
                            init_display_style, ' id="', id, cat_q_type_attr,
                            cat_mkey_attr, cat_q_ref, '" >', td, '</tr>'
                        ].join(''));
                        this.add_child(prev, id);
                    } else {
                        //first level
                        body.prepend([
                            '<tr class="qlist_section', init_class,
                            '" id="', id, cat_q_type_attr, cat_mkey_attr,
                            cat_q_ref, '" >', td, '</tr>'
                        ].join(''));
                    }
                    var new_elem = body.find('#' + id);
                    created[id] = new_elem;
                    var that = this;
                    if (this.categories.collapsible) {
                        new_elem.click(function() {
                            that.on_click_handler($j(this));
                        });
                    }
                }
                prev_id = id;
            }
            var elem = created[id], last = elem, rows_len;
            for (i = 0, rows_len = rows.length; i < rows_len; ++i) {
                var obj = $j(rows[i]), has_odd_class = obj.hasClass('odd');
                if (i % 2) {
                    if (!has_odd_class) {
                        obj.addClass('odd');
                    }
                } else {
                    if (has_odd_class) {
                        obj.removeClass('odd');
                    }
                }
                last.after(obj);
                this.add_child(elem, obj.attr('id'));
                if (!this.categories.collapsible) {
                    obj.show();
                }
                last = obj;
            }
        }

        var j_id = '#' + this.id;
        $j(j_id + " tbody").remove();
        body.appendTo($j(j_id));
        this.restore_tree_state();
    },

    // append_context_menu_item - besides the actions in menu bar, create a new
    //                            right-click menu action
    append_context_menu_item : function(id_t, text_t, single_flag, click_fn)
    {
        this.ctxt_menu_items.push( {id:id_t, text:text_t, single_only:single_flag, click:{fn: click_fn} } );
    },

    // build_context_menu - initialize and right-click menu
    build_context_menu : function()
    {
        if (!this.disable_context_menu)
            this.context_menu_init("tbmenu_" + this.id, this.id, this);
    },

    // setup_listitem_event_handlers - setup the custom event handlers for each row
    // in the list.
    setup_listitem_event_handlers : function()
    {
        var qlist_obj_this = this;
        var j_qlist = $j("#" + this.id);
        var selector = "tr.qlist_row:not(.unselectable)";

        if (this.categories.editable || this.editable_sections) {
            selector += ",tr.qlist_section";
        }

        j_qlist.off('click').on('click', selector, function(ev) {
            // ignore right-click, let context menu handle it
            if (ev.which !== 3 && ev.target) {
                qlist_mouse_click_row(qlist_obj_this, this, ev);
            }
        }).off('dblclick').on('dblclick', selector, function(ev) {
            qlist_mouse_dblclick_row(qlist_obj_this, this, ev);
        });

        // Also handle the click on the header checkbox.

        $j("#" + this.hdr_cb).click(function()
        {
            qlist_onclick_toggleall(qlist_obj_this, this);
        });

        // When only checkbox is checked, also update the 'selected' class
        // of the parent row accordingly
        j_qlist.on('click', 'input:checkbox.qlist_cb', function() {
            var jcb = $j(this);
            var is_checked = jcb.is(':checked');
            var jrow = jcb.closest('tr.qlist_row');
            set_selected(jrow, is_checked);
            qlist_obj_this.last_sel_row = jrow;
        });

        // Add Ctrl-A accelerator key as a synonym of the "toggle all" checkbox.
        // TODO: any jquery replacement for this shortcut key feature ?
        function mk_toggleall_accel_cb(q) { return function() { qlist_accel_toggleall(q);}; }
        shortcut.add("Ctrl+A", mk_toggleall_accel_cb(this));

        var tbl = $j('#' + this.id);
        if (this.disable_text_selection)
        {
            if (!this.options.css_layout) {
                tbl.attr("unselectable", "on").css("MozUserSelect", "none");
            } else {
                tbl.addClass('unselectable');
            }
        }

        // Prevent wierd text selection events within the table.
        tbl.click(function (ev) {
            if (ev.ctrlKey || ev.shiftKey) clearTextSelection(ev);
        }).dblclick(clearTextSelection);

        function clearTextSelection(ev)
        {
            var sel = window.getSelection ? window.getSelection() : document.selection;
            if (sel) {
                if (sel.removeAllRanges) {
                    sel.removeAllRanges();
                } else if (sel.empty) {
                    sel.empty();
                }
            }
        }
    },

    // get_all_rows - get a (cached ) list of all rows in the table.
    get_all_rows : function()
    {
        if (!this.jc_enable)
        {
            var selector = "#" + this.id + " tr.qlist_row";
            return $j(selector);
        }

        if (this.jc_qlist_rows === null)
        {
            this.jc_update();
        }
        return this.jc_qlist_rows;
    },

    // get_all_cbs - get a (cached) list of all checkboxes in the table.
    get_all_cbs : function()
    {
        if (!this.jc_enable)
        {
            var selector = "#" + this.id + " tr.qlist_row";
            return $j(selector+" input:checkbox.qlist_cb");
        }

        if (this.jc_qlist_cbs === null)
        {
            this.jc_update();
        }
        return this.jc_qlist_cbs;
    },

    is_section_row : function(row)
    {
        return $j(row).hasClass("qlist_section");
    },

    // get_checked_rows - returns the set of all rows in the qlist that are currently checked.
    get_checked_rows : function()
    {
        return $j('#' + this.id + ' tr.qlist_row.selected');
    },

    get_mixed_checked_rows : function()
    {
        return $j('#' + this.id + ' tr.qlist_row.selected,tr.qlist_section.selected');
    },

    get_hdr_checked : function()
    {
        return $j("#" + this.hdr_cb).is(":checked");
    },

    // is_row_selected - determines whether a row is selected (based on its checkbox element).
    is_row_selected : function(row)
    {
        return $j(row).hasClass('selected');
    },

    // select_row - manually selects the row
    select_row : function(row)
    {
        $j(row).trigger("click");
    },

    // qlist_clear_selection - clear the current selection of the qlist.
    clear_selection : function()
    {
        // Clear the header checkbox.
        $j("#" + this.hdr_cb).uncheck();

        // Clear the checkbox for each row in the table.
        this.get_all_cbs().prop('checked', false);

        this.get_mixed_checked_rows().removeClass('selected');
    },

    // toggle_all - set all rows in the list to the same state.
    toggle_all : function(bEnable)
    {
        // Set the header checkbox.
        $j("#" + this.hdr_cb).check(bEnable);

        // Set the checkbox for each row in the table.
        this.get_all_cbs().prop('checked', bEnable);

        this.get_all_rows().toggleClass('selected', bEnable);

        this.handle_selection_change_fn(this);
    }
};
/*global wij_in_modal_op,qlist_obj,g_cmdb_table_id,dlg_close,qmenu_create_menubar,
is_rw_admin,relocate_tbl_hdr,relocate_tbl_hdr2,addEvent,Page,escapeHTML,qmenu_enable_button*/

// qlist_realign_floating_header - resize the spacer div in the main body
// to match the floating header.
// (Call this function after taking any action that may affect the header size)
function qlist_realign_floating_header()
{
    var spacer = $j("qlist_hdr_vspacer");
    var hdrbar = $j("#qlist_hdrbar")[0];

    if (spacer[0]) {
        var new_height = $j(hdrbar).outerHeight(true) - $j("#qlist_hdrrow").outerHeight(true);
        spacer.height(new_height-spacer.outerHeight(true)+spacer.height());
    }
}

// qlist_realign_floating_footer - resize the spacer div in the main body
// to match the floating footer.
function qlist_realign_floating_footer()
{
    var spacer = $j("#qlist_ftr_vspacer");
    var container = $j("#main_window")[0];
    var ftrbar_tbl = $j("#qlist_ftrbar");

    if (typeof(container) == "undefined") {
        container = ftrbar_tbl.parentNode;
    }

    if (ftrbar_tbl && container) {
        ftrbar_tbl.css("bottom", ($j(container).innerHeight() - container.clientHeight) + "px");
    }
    if (spacer) {
        spacer.height($j("#qlist_ftrbar").outerHeight());
    }
}

// qlist_setup - onload handler
function qlist_setup(id, new_url, edit_url, enable_ref_col)
{
    $j(window).unload(function()
    {
        // unload any modal dialog, like the one showing waiting message during form post submitting
        if (wij_in_modal_op && wij_in_modal_op())
        {
            dlg_close();
        }
    });

    // Setup the qlist parameters
    // g_cmdb_table_id is specified in C file.
    qlist_obj.cmdb_table_id = typeof(g_cmdb_table_id) == "undefined" ? -1 : g_cmdb_table_id;
    qlist_obj.cr_new_url = new_url;
    qlist_obj.cr_edit_url = edit_url;
    if (enable_ref_col != null)
    {
        qlist_obj.enable_ref_col = enable_ref_col;
    }
    if (id)
        qlist_obj.id = id;

    qlist_obj.init();

    // TODO: it would be nice to render the menubar as initially hidden, then
    // show it after the headerbar has stabilized. However, YUI doesn't seem
    // to be capable of doing that without flicker.
    var menubar_container = $j("#qlist_yui_menubar_container")[0];
    var oMB = qmenu_create_menubar("qlist_yui_menubar", qlist_obj, is_rw_admin);
    oMB.render(menubar_container);

    /* Note: enable_ref_col flag in this qlist util is no longer overridden by
     * config.options.ref_column, also append_ref_col function is no longer
     * called in qlist plugin.
     * Now append_ref_col function is only used in qlist util by C pages. For
     * the new Python pages, with ref_column flag configured as true, ref
     * column will be generated by appending q_ref to the columns setting
     * and using special q_ref format function.
     * TODO: Remove this once all C pages are converted to Python.
     */
    qlist_obj.append_ref_col();

    var qlist_hdrrow = $j("#qlist_hdrrow")[0];
    var qlist_float = qlist_hdrrow ? qlist_hdrrow.getAttribute("float") : "0";

    // Move the data table header into the floating header div.
    if (qlist_float == "1")
    {
        relocate_tbl_hdr($j('#' + qlist_obj.id)[0], qlist_hdrrow);
    }
    // fixed header + resizable column
    else if (qlist_float == "2")
    {
        relocate_tbl_hdr2($j('#' + qlist_obj.id)[0], qlist_hdrrow);
    }

    // Resize the spacer div in the main body after rendering the menubar
    // and relocating the table header there. (We also need to account for the
    // possibility that resizing the window will change the header bar
    // height by causing the content to wrap.)
    if (qlist_float != "0")
    {
        qlist_realign_floating_header();
        addEvent(window, "resize", qlist_realign_floating_header);
    }

    // Setup event handlers for the data table.
    qlist_obj.setup_listitem_event_handlers();

    // Set the initial state of the button bar buttons.
    qlist_obj.init_menubutton_state();

    //qlist_obj.append_context_menu_item("mi_test", "Test", false, function() {alert('test');});
    //qlist_obj.append_context_menu_item("mi_test2", "Test2", true, function() {alert('test2');});
    qlist_obj.build_context_menu();

    // This makes the keyboard accelerators work without having to click the window.
    window.focus();
}

// TODO: remove unused functions as they are cleaned up
/*#!/bin/bash
echo 'qlist_del_url
qlist_create_new
qlist_create_edit
qlist_create_del
movePaging
qlist_add_header_extra
convert_crnew_button_to_droplist
fixup_createnew_droplist_alignment'|while read f; do echo $f; git grep '\b'"$f"'\b'|grep -v 'migadmin/module_js/qlist_utils.js'|wc -l; done
*/

// TODO: these functions have bad names. It sounds like they are "action" functions
// rather than "setter" functions.
function qlist_del_url(url)
{
    qlist_obj.cr_del_url = url;
}

function qlist_create_new(flag)
{
    qlist_obj.create_new = flag ? true : false;
}

function qlist_create_edit(flag)
{
    qlist_obj.create_edit = flag ? true : false;
}

function qlist_create_del(flag)
{
    qlist_obj.create_del = flag ? true : false;
}

// movePaging - Move the paging controls into the footer.
function movePaging(paging_row)
{
    // Move the <tr> element into the footer table.
    var j_paging_row = $j(paging_row);
    $j('#ftrtc').append(j_paging_row);

    // Make the row visible. We set it initially hidden so as to avoid
    // flicker during the page rendering.
    j_paging_row.show() .css("visibility","visible");

    qlist_realign_floating_footer();
}

function qlist_add_header_extra(h_extra, hdrbar_div)
{
    if (h_extra && hdrbar_div) {
        h_extra.parentNode.removeChild(h_extra);
        hdrbar_div.appendChild(h_extra);
        h_extra.style.visibility = "visible";
        // Realign the header since the size may change
        setTimeout(qlist_realign_floating_header, 1);
    }
}

// convert_button_to_droplist - insert a droplist triangle icon right after
// a button.
// Arguments:
//   droplistid -- menu ID for the droplist menu icon
//   menuid -- droplist submenu ID
//   parentid -- menu ID this droplist belongs to (usually the left icon)
//   aSubmenuItems -- submenu array
//   force_drop_down -- whether or not force drop down on click parent menu
function convert_button_to_droplist(droplistid, menuid, parentid, aItems, aSubmenuItems, force_drop_down, menu_config)
{
    // Use the default droplist id "mi_barnew".
    var mDroplist = Page.createMenuItem({id:droplistid, ctxt:false, spriteClass:menu_config.class, text: menu_config.label});
    mDroplist.addSubMenu(menuid, aSubmenuItems);

    // Add a drop list after the create new button.
    var len = aItems.length;
    for (var i = 0; i < len; i++) {
        var item = aItems[i];
        if(item.id == parentid) {
            if (force_drop_down) {
                item.onclick.fn = function(q) {
                    setTimeout(function() {
                        $j("#" + droplistid).trigger('click');
                    }, 10);
                };
            }
            //aItems.splice(i+1, 0, mDroplist);
            aItems.splice(i, 1, mDroplist);
            break;
        }
    }
}

function convert_crnew_button_to_droplist(aItems, aSubmenuItems)
{
    convert_button_to_droplist("mi_barnew", "bar_new", "mi_new", aItems, aSubmenuItems);
}


// fixup_droplist_alignment - several pages use a menu
// droplist rather than a simple menu button. This is composed of a
// button (with the default action) followed by a
// triangle to trigger the droplist. Since YUI treats the triangle
// just like a regular menu item, we need to tweak the alignment a bit.
function fixup_droplist_alignment(li_droplist)
{
    // On some pages the drop list is only present under certain configurations
    // (e.g. vdom mode, IPv6 mode, etc). If we don't find it then do nothing.
    if (!li_droplist)
        return;

    // Reduce the padding around the triangle icon.
    var aLabels = li_droplist.getElementsByTagName("a");
    var a_triangle = aLabels[0];
    a_triangle.style.padding = "0";
    a_triangle.style.paddingTop = "3px";
    a_triangle.style.paddingBottom = "3px";

    // Reduce the gap between the Create New menu and the triangle.
    //var li_new = li_droplist.previousSibling;
    var li_new = li_droplist;
    aLabels = li_new.getElementsByTagName("a");
    var a_new = aLabels[0];
    a_new.style.paddingRight = "2px";
}

function fixup_createnew_droplist_alignment()
{
    fixup_droplist_alignment($j("#mi_barnew")[0]);
}

/**
* @class Set of handlers for handling inline editing etc.
* @constructor
* This is a generic implementation of the system/dhcp_server.js method.
* @param {Object[]} ctxt array of objects to be updated on edit.
* @param {Object} [config] Configuration object.
* @param {String} [config.key] name of the property which stores the
*    mkey/id/primary key.
*/
function QListInlineHandlers(ctxt, config) {
    'use strict';

    function dep_func(v, k) {
        return 'data-' + escapeHTML(k) + '="' + escapeHTML(v) + '" ';
    }
    /**
    * Update the context object after an edit succeeds
    * @param {qlist} qlist qlist object.
    * @param {jQuery} row jquery row being edited.
    * @param {JQuery.Event} eo event object (usually doubleclick)
    */
    function inline_edit(qlist, row, eo) {
        var BLUR_DELAY = 10;
        function cancel_edit(eo) {
            if ((eo.type == 'blur') ||
                (eo.type == 'keydown' &&
                 eo.keyCode == $j.ui.keyCode.ENTER) ||
                (eo.type == 'click' && $row.is('.editing'))
            ) {
                var modified = [],
                    entry = $(ctxt).filter(function() {
                        return this[handlers.key] == id;
                    }).get(0);
                $inputs.each(function() {

                    var $this = $(this),
                        col = $this.data('name'),
                        className = '',
                        value = $this.val();
                    if (entry[col] != value) {
                        entry[col] = value;
                    }

                    var isSelectTag = String(this.tagName).toLowerCase() == 'select';
                    if (isSelectTag) {
                        var selectedOption = $this.find('option[value="' +
                                                         escapeHTML(value) + '"]');
                        value = selectedOption.text();
                        className = selectedOption.data('class');
                    }
                    className = className ? ' ' + className : '';
                    var $colStaticTexts = $staticTexts.filter('[data-name="' + col + '"]');
                    $colStaticTexts.text(value);
                    if (isSelectTag) {
                        // class of inline-display won't change while that of
                        // select will change base on the selected option.
                        // remove all classes from previous option
                        $colStaticTexts.removeClass()
                        // add back relevant classes
                            .addClass('inline-display depends ' + col + className);
                    }
                    $this.closest('.inline-edit:not(input, select)')
                        .attr('data-value-' + col, entry[col]);
                    modified.push([ctxt, entry, col, $row,
                                   $this.closest('td')]);
                });
                $row.toggleClass('editing', false);

                //call modified handlers at the end in case they rebuild qlist
                //todo: call only when a column has actually been modified
                //call once for the row?
                $.each(modified, function(i, m) {
                    handlers.modified.apply(handlers, [o.EDIT].concat(m));
                });
                if (handlers.submitted) {
                    handlers._validate();
                    handlers.updateMenus(qlist);
                }
                return false;
            }
        }
        function event_namespace_gen(evts, namespace) {
            return evts.map(function(evt) {
                return evt + namespace;
            }).join(' ');
        }
        if (handlers.config.read_only) {
            return;
        }
        var $row = $(row),
            $inputs = $row.find('input.inline-edit,select.inline-edit'),
            $staticTexts = $row.find('.inline-display'),
            $target = eo ? $(eo.target) : $inputs.first(),
            id = $row.data(handlers._data_key),
            prefix = handlers.config.qlist_config.prefix;
        $inputs.each(function(i, e) {
            var tmp_name = prefix + '-' + id + '-' +
                e.getAttribute('data-name');
            e.name = e.name || tmp_name;
            e.id = e.id || tmp_name;
        });
        $row.toggleClass('editing', true),
        $inputs = $inputs.filter('input, select');
        $inputs.unbind('blur keydown focus click');
        if (!$target.is('td, tr')) {
            $target = $target.parents('td').first();
        }
        $target = $target.find('input.inline-edit, select.inline-edit').first();
        if (!$target.length) {
            $target = $inputs.first();
        }
        setTimeout(function() {
            //timeout needed for webkit to focus properly
            $inputs.ui_dependencies().select();
            $target.focus();
        }, BLUR_DELAY);
        var ns = '.qlist_inline_editing',
            evts = ['click', 'mousedown', 'mouseup', 'focus'],
            evts_ns = event_namespace_gen(evts, ns);

        $inputs.on(evts_ns, function(eo) {
            // stop bubbling to qlist that causes FF to block clicks (0207171)
            eo.stopPropagation();
        });

        $inputs.on('keydown', function(eo) {
            if (eo.which === 13) {
                cancel_edit.call(eo.target, eo);
                eo.preventDefault();
            }
        });

        var $html = $('html'),
            html_click_ns = 'click' + ns;
        $html.off(html_click_ns)
        .on(html_click_ns, function(eo) {
            var $exempt = $(eo.target).closest('tr.editing, .qtip, .ui-dialog, .ui-widget-overlay');
            if (!$exempt.length) {
                var input = $inputs.first().get();
                cancel_edit.call(input, eo);
                $html.off(html_click_ns);
                $inputs.off(ns);
            } else {
                eo.stopPropagation();
            }
        });
    }

    /**
    * delete a row. Calls modified(DELETE, ctxt, rows[], undefined, $rows)
    * @param {qlist} qlist qlist object.
    * @param {jQuery} $rows list of rows being deleted.
    */
    function inline_delete(qlist, $rows) {
        var ids = $rows.map(function(i, row) {
                return $(row).data(handlers._data_key);
            }).toArray(),
            removed = [];
        ctxt.replaceAll($(ctxt).not(function(i, row) {
            var remove = $.inArray(row[handlers.key], ids) > -1;
            if (remove) {
                removed.push(row);
            }
            return remove;
        }).toArray());
        $rows.remove();
        handlers.modified(o.DELETE, ctxt, removed, undefined, $rows);
        handlers.updateMenus(qlist);
    }

    /**
    * create a new row. New entry will have unused negative number for key.
    * Calls modified(CREATE, ctxt, row, undefined, $tr)
    * @param {qlist} qlist qlist object.
    */
    function inline_create(qlist) {
        function newid() {
            var id = -1, i = 0, l = ctxt.length;
            for (i = 0; i < l; ++i) {
                id = Math.min(id, ctxt[i][handlers.key] - 1);
            }
            return id;
        }
        var defaults = $.isFunction(handlers.defaults) ?
                           (handlers.defaults)() : handlers.defaults;
        var row = $.extend(true, {}, defaults);
        if (row[handlers.key] === undefined) {
            row[handlers.key] = newid();
        }
        ctxt.push(row);
        var $tr = qlist.append_row(row);
        qlist.select_row($tr);
        qlist.edit_handler(qlist);
        handlers.modified(o.CREATE, ctxt, row, undefined, $tr);
        handlers.updateMenus(qlist);
    }

    /**
    * drag drop reorder. calls Modified(MOVE, ctxt, row, undefined, $tr)
    * @param {Number} to index of to element.
    * @param {Number} from index of from element.
    * @this {jQuery(HTMLTRElement)} qlist assigns the $tr as 'this'
    */
    function ondrop_reorder(to, from) {
        var entry = ctxt[from];
        ctxt.splice(from, 1);
        ctxt.splice(to, 0, entry);
        handlers.modified(o.MOVE, ctxt, entry, undefined, this);
    }

    /**
    * format a column for an input editor
    * @param {String} selector name of column to format.
    * @param {Object} entry Object that contains column to format.
    * @param {String} type Type of input to create (input's type attribute).
    * @param {String} validate Validation class to use.
    * @return {String} formatted column.
    */
    function input_format(selector, entry, type, validate, dependencies) {
        type = type || 'text';
        var deps_data = $.map(dependencies || {}, dep_func).join('');
        return '<span class="inline-display ' + selector +
            (dependencies ? ' depends' : '') + '" ' +
            deps_data +
            'data-name="' + selector + '">' +
            escapeHTML(entry[selector]) +
            '</span>' +
            '<input ' +
            'class="inline-edit qlist_col_field' +
            (dependencies ? ' depends' : '') +
            (validate ? ' ' + validate : '') + '" ' +
            deps_data +
            'type="' + type + '" ' +
            'data-name="' + selector + '" ' +
            'value="' + escapeHTML(entry[selector]) + '"/>';
    }

    /**
    * format a column for a select dropdown editor
    * @param {String} selector Name of column to format.
    * @param {Object} entry Object that contains the column to format.
    * @param {Object | Object[]} options value/text array or map to create
    *        option nodes.
    * @param {String} validate Validation class to use.
    * @return {String} formatted column.
    *
    * Notes, for options argument, 3 types are supported:
    * 1. An array of option values: ['opt1_val', 'opt2_val'], option text will
    * be generated using $.getInfo()
    *
    * 2. A mapping object: {'opt1_val': 'Opt1 Text', 'opt2_val': 'Opt2 Text'}
    *
    * 3. An advanced mapping object (useful for ui dependencies, styling):
    * {
    *   'opt1_value': {text: 'Opt1 Text', data: {prop1:'val1',...}, class: ''},
    *   'opt2_value': {text: 'Opt2 Text', data: {prop2:'val2',...}, class: ''},
    *   ...
    * }
    */
    function select_format(selector, entry, options, validate, dependencies) {
        if ($.isArray(options)) {
            // type 1, turn it into type 2
            var arr = options;
            options = {};
            $.each(arr, function(i, o) {
                options[o] = $.getInfo(o);
            });
        }
        var esc_selector = escapeHTML(selector),
            selected_val = entry[selector],
            selected_opt = options[selected_val],
            selected_text = $.isPlainObject(selected_opt) ? (selected_opt['text'] || $.getInfo(selected_val)) : selected_opt;
	if(selected_text == fgt_lang['select'] && selected_val == '0')
		                selected_text = '';
        var selected_class = $.isPlainObject(selected_opt) ? selected_opt['class'] : '';

        return '<span class="inline-display ' + esc_selector + ' ' +
               (selected_class ? selected_class : '') +
               '" data-name="' + esc_selector + '">' +
                escapeHTML(selected_text || '') +
            '</span>' +
            '<select ' +
            'class="inline-edit qlist_col_field' +
            (dependencies ? ' depends' : '') +
            (validate ? ' ' + validate : '') + '" ' +
            $.map(dependencies || {}, dep_func).join('') +
            'data-name="' + esc_selector + '">' +
            $.map(options, function(v, k) {
                var opt_val = escapeHTML(k),
                    opt_text,
                    prop,
                    data = '';
                if ($.isPlainObject(v)) {
                    // type 3
                    opt_text = v['text'] || $.getInfo(k);
                    var data_obj = v['data'] || {};
                    for (prop in data_obj) {
                        if (data_obj.hasOwnProperty(prop)) {
                            data += ' data-' + escapeHTML(prop) +
                                    '="' + escapeHTML(data_obj[prop]) + '"';
                        }
                    }
                    if (v['class']) {
                        data += ' data-class="' + escapeHTML(v['class']) + '"';
                    }
                } else {
                    // type 2
                    opt_text = v;
                }
                opt_text = escapeHTML(opt_text);

                return '<option value="' + opt_val + '" ' +
                    (k == selected_val ? 'selected' : '') +
                    data +
                    '>' + opt_text +
                    '</option>';
            }).join('') + '</select>';
    }
    var $ = jQuery,
        config_defaults = {key: 'id', max_rows: null};
    config = $.extend(config_defaults, config);
    var o = QListInlineHandlers.operations,
        handlers = this,
        $store;
        if (ctxt.jquery && ctxt.length) {
            $store = ctxt;
            ctxt = JSON.parse(ctxt.val());
        }
        $.each(ctxt, function(i, e) {
            if (!(config.key in e)) {
                e[config.key] = i;
            }
        });
        /**
        * @this {Array}
        * replace contents of the array with a new array
        * @param {Object[]} contents Array containing new rows.
        */
        ctxt.replaceAll = function(contents) {
            var args = [0, this.length].concat(contents);
            Array.prototype.splice.apply(this, args);
        };
    $.extend(this, {
        config: config,
        key: config.key,
        _data_key: 'row-handler-' + config.key,
        ctxt: ctxt,
        $store: $store,
        submitted: false,
        inline_edit: inline_edit,
        inline_delete: inline_delete,
        inline_create: inline_create,
        ondrop_reorder: ondrop_reorder,
        input_format: input_format,
        select_format: select_format
    });
}
(function($) {
    QListInlineHandlers.operations = {
        MOVE: 'move', CREATE: 'create', DELETE: 'delete', EDIT: 'edit'
    };
    $j.extend(QListInlineHandlers.prototype, {
        /**
        * Callback executed when table has changed.
        * NOTE: should probably have an operation argument. Currently not used
        * @param {String} operation one of QListInlineHandlers.operations.
        * @param {Object[]} ctxt context that was changed (array of entries).
        * @param {Object} [entry] entry that was changed (optional).
        * @param {String} [selector] name of column that was changed (optional).
        * @param {jQuery(HTMLTRElement)} [$tr] dom row that was modified.
        * @param {jQuery(HTMLTDElement)} [$td] dom tableDiv that was modified.
        */
        modified: function(operation, ctxt, entry, selector) {},
        /**
        * set the default values for a new entry/row
        * @param {Object} defaults entry that contains the default values.
        *    Will be cloned.
        */
        set_defaults: function(defaults) {
            this.defaults = defaults;
        },
        /**
        * Automatically flesh out the config with handlers.
        * Requires prefix to be set!
        * Added configuration options:
        * - config.columns.validate {String} $.validator class
        * - config.columns.options {String[]|Object} options
        *   Creates a select dropdown editor if supplied.
        * -   either: array of options (will use $.getInfo)
        * -   or object map of keys/values for
        *     <option value="{{key}}">{{value}}</option>
        * -   or advanced options object with extra data
        * - config.columns.inline_type {String} specify an input type
        * Adds:
        * - config.menu_items
        * -   edit {handler} inline_edit
        * -   delete {handler} inline_delete
        * - config.format_fn[column_name] {handler} (if none exists)
        * - config.source {Object[]} assigned to ctxt
        * - config.reordering.onDrop {handler} when reordering.enable is set
        * @param {qlist.config} config configuration to be modified.
        * @return {qlist.config} modified config to be passed to $.qlist().
        */
        attach: function(config) {
            var h, l, s, col, load;
            //catch crash (YUI silently swallows exceptions!)
            function cc(fn) {
                return function() {
                    try {
                        fn.apply(this, arguments);
                    } catch (ex) {
                        try {
                            console.error(ex, ex.stack);
                        } catch (ex2) {}
                        alert(ex.message);
                    }
                }
            }
            config.menu_items = $.extend(config.menu_items || {}, {
                create_new: {handler: cc(this.inline_create)},
                edit: {handler: cc(this.inline_edit)},
                'delete': {handler: cc(this.inline_delete)}
            });
            config.row_attr = config.row_attr || [];
            config.row_attr.push({'name': 'data-' + this._data_key,
                                 'selector': this.key});
            if (config.columns) {
                config.format_fn = config.format_fn || {};
                h = this;
                l = config.columns.length;
                for (var i = 0; i < l; ++i) {
                    col = config.columns[i],
                    s = col.selector;
                    if (!config.format_fn[s]) {
                        if (col.options) {
                            config.format_fn[s] = function(td, col, e) {
                                td.addClass('inline');
                                return h.select_format(col.selector,
                                                       e, col.options,
                                                       col.validate,
                                                       col.deps);
                            };
                        } else {
                            config.format_fn[s] = function(td, col, e) {
                                td.addClass('inline');
                                return h.input_format(col.selector,
                                                      e, col.inline_type,
                                                      col.validate,
                                                      col.deps);
                            };
                        }
                    }
                }
            }
            if (!config.source) {
                config.source = this.ctxt;
            }
            config.callbacks = config.callbacks || {};
            load = config.callbacks.load,
            h = this;
            config.callbacks.load = function(qlist) {
                if ($j.isFunction(load)) {
                    load.call(this, qlist);
                }
                h.updateMenus(qlist);
            };
            if (config.reordering && config.reordering.enable &&
                    !config.reordering.onDrop) {
                config.reordering.onDrop = this.ondrop_reorder;
            }
            this.config.qlist_config = config;
            return config;
        },
        /**
        * Validate and update the supplied form's input via serialization.
        * NOTE: requires $(form).validate({'onsubmit': false})
        * and manual $(form).valid() validation on submit()
        * @param {HTMLFormElement} form Form that needs updating.
        * @param {String} name Name of the input to update.
        * @return {Boolean} true if validation passed, false otherwise.
        */
        update_form: function() {
            var form = this.$store.closest('form').get(0);
            this.submitted = true;
            this.$store.val(JSON.stringify(this.ctxt));
            return this._validate(form);
        },
        _tableSelector: function() {
            var prefix = this.config.qlist_config.prefix || 'qlist';
            return '#' + prefix + '-qlist';
        },
        _validate: function(form) {
            var validator,
                valid = true,
                h = this,
                columns = h.config.qlist_config.columns,
                ts = this._tableSelector();
            form = form || $(ts).closest('form').get(0);
            validator = $(form).validate();
            $.each(this.ctxt, function(i, entry) {
                var $row = $(ts + ' ' +
                        '[data-row-handler-id="' + entry[h.key] + '"]');
                $row.toggleClass('editing', true);

                $.each(columns, function(i, col) {
                    if (col.validate) {
                        var $elems = $row.find('.' + col.selector +
                                              ' .inline-edit');
                        $elems.each(function() {
                            var $elem = $(this);
                            valid = validator.element($elem) && valid;
                            if (valid) {
                                $elem.prop('name', null);
                            }
                        });
                    }
                });
                $row.toggleClass('editing', false);
            });
            return valid;
        },
        updateMenus: function(qlist) {
            var prefix = this.config.qlist_config.prefix,
                $newButton = $j('#mi_new_' + prefix),
                $editButton = $j('#mi_edit_' + prefix),
                max_rows = this.config.max_rows;
            if (max_rows && $.isFunction(max_rows)) { max_rows = max_rows(); }
            var can_create = (max_rows == null ||
                              this.ctxt.length < max_rows) &&
                             !this.config.read_only;

            qmenu_enable_button($newButton, can_create, qlist);
            $editButton.toggle(!this.config.read_only);
        }
    });
})(jQuery);
/*
Copyright (c) 2011, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.com/yui/license.html
version: 2.9.0
*/
if(typeof YAHOO=="undefined"||!YAHOO){var YAHOO={};}YAHOO.namespace=function(){var b=arguments,g=null,e,c,f;for(e=0;e<b.length;e=e+1){f=(""+b[e]).split(".");g=YAHOO;for(c=(f[0]=="YAHOO")?1:0;c<f.length;c=c+1){g[f[c]]=g[f[c]]||{};g=g[f[c]];}}return g;};YAHOO.log=function(d,a,c){var b=YAHOO.widget.Logger;if(b&&b.log){return b.log(d,a,c);}else{return false;}};YAHOO.register=function(a,f,e){var k=YAHOO.env.modules,c,j,h,g,d;if(!k[a]){k[a]={versions:[],builds:[]};}c=k[a];j=e.version;h=e.build;g=YAHOO.env.listeners;c.name=a;c.version=j;c.build=h;c.versions.push(j);c.builds.push(h);c.mainClass=f;for(d=0;d<g.length;d=d+1){g[d](c);}if(f){f.VERSION=j;f.BUILD=h;}else{YAHOO.log("mainClass is undefined for module "+a,"warn");}};YAHOO.env=YAHOO.env||{modules:[],listeners:[]};YAHOO.env.getVersion=function(a){return YAHOO.env.modules[a]||null;};YAHOO.env.parseUA=function(d){var e=function(i){var j=0;return parseFloat(i.replace(/\./g,function(){return(j++==1)?"":".";}));},h=navigator,g={ie:0,opera:0,gecko:0,webkit:0,chrome:0,mobile:null,air:0,ipad:0,iphone:0,ipod:0,ios:null,android:0,webos:0,caja:h&&h.cajaVersion,secure:false,os:null},c=d||(navigator&&navigator.userAgent),f=window&&window.location,b=f&&f.href,a;g.secure=b&&(b.toLowerCase().indexOf("https")===0);if(c){if((/windows|win32/i).test(c)){g.os="windows";}else{if((/macintosh/i).test(c)){g.os="macintosh";}else{if((/rhino/i).test(c)){g.os="rhino";}}}if((/KHTML/).test(c)){g.webkit=1;}a=c.match(/AppleWebKit\/([^\s]*)/);if(a&&a[1]){g.webkit=e(a[1]);if(/ Mobile\//.test(c)){g.mobile="Apple";a=c.match(/OS ([^\s]*)/);if(a&&a[1]){a=e(a[1].replace("_","."));}g.ios=a;g.ipad=g.ipod=g.iphone=0;a=c.match(/iPad|iPod|iPhone/);if(a&&a[0]){g[a[0].toLowerCase()]=g.ios;}}else{a=c.match(/NokiaN[^\/]*|Android \d\.\d|webOS\/\d\.\d/);if(a){g.mobile=a[0];}if(/webOS/.test(c)){g.mobile="WebOS";a=c.match(/webOS\/([^\s]*);/);if(a&&a[1]){g.webos=e(a[1]);}}if(/ Android/.test(c)){g.mobile="Android";a=c.match(/Android ([^\s]*);/);if(a&&a[1]){g.android=e(a[1]);}}}a=c.match(/Chrome\/([^\s]*)/);if(a&&a[1]){g.chrome=e(a[1]);}else{a=c.match(/AdobeAIR\/([^\s]*)/);if(a){g.air=a[0];}}}if(!g.webkit){a=c.match(/Opera[\s\/]([^\s]*)/);if(a&&a[1]){g.opera=e(a[1]);a=c.match(/Version\/([^\s]*)/);if(a&&a[1]){g.opera=e(a[1]);}a=c.match(/Opera Mini[^;]*/);if(a){g.mobile=a[0];}}else{a=c.match(/MSIE\s([^;]*)/);if(a&&a[1]){g.ie=e(a[1]);}else{a=c.match(/Gecko\/([^\s]*)/);if(a){g.gecko=1;a=c.match(/rv:([^\s\)]*)/);if(a&&a[1]){g.gecko=e(a[1]);}}}}}}return g;};YAHOO.env.ua=YAHOO.env.parseUA();(function(){YAHOO.namespace("util","widget","example");if("undefined"!==typeof YAHOO_config){var b=YAHOO_config.listener,a=YAHOO.env.listeners,d=true,c;if(b){for(c=0;c<a.length;c++){if(a[c]==b){d=false;break;}}if(d){a.push(b);}}}})();YAHOO.lang=YAHOO.lang||{};(function(){var f=YAHOO.lang,a=Object.prototype,c="[object Array]",h="[object Function]",i="[object Object]",b=[],g={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","/":"&#x2F;","`":"&#x60;"},d=["toString","valueOf"],e={isArray:function(j){return a.toString.apply(j)===c;},isBoolean:function(j){return typeof j==="boolean";},isFunction:function(j){return(typeof j==="function")||a.toString.apply(j)===h;},isNull:function(j){return j===null;},isNumber:function(j){return typeof j==="number"&&isFinite(j);},isObject:function(j){return(j&&(typeof j==="object"||f.isFunction(j)))||false;},isString:function(j){return typeof j==="string";},isUndefined:function(j){return typeof j==="undefined";},_IEEnumFix:(YAHOO.env.ua.ie)?function(l,k){var j,n,m;for(j=0;j<d.length;j=j+1){n=d[j];m=k[n];if(f.isFunction(m)&&m!=a[n]){l[n]=m;}}}:function(){},escapeHTML:function(j){return j.replace(/[&<>"'\/`]/g,function(k){return g[k];});},extend:function(m,n,l){if(!n||!m){throw new Error("extend failed, please check that "+"all dependencies are included.");}var k=function(){},j;k.prototype=n.prototype;m.prototype=new k();m.prototype.constructor=m;m.superclass=n.prototype;if(n.prototype.constructor==a.constructor){n.prototype.constructor=n;}if(l){for(j in l){if(f.hasOwnProperty(l,j)){m.prototype[j]=l[j];}}f._IEEnumFix(m.prototype,l);}},augmentObject:function(n,m){if(!m||!n){throw new Error("Absorb failed, verify dependencies.");}var j=arguments,l,o,k=j[2];if(k&&k!==true){for(l=2;l<j.length;l=l+1){n[j[l]]=m[j[l]];}}else{for(o in m){if(k||!(o in n)){n[o]=m[o];}}f._IEEnumFix(n,m);}return n;},augmentProto:function(m,l){if(!l||!m){throw new Error("Augment failed, verify dependencies.");}var j=[m.prototype,l.prototype],k;for(k=2;k<arguments.length;k=k+1){j.push(arguments[k]);}f.augmentObject.apply(this,j);return m;},dump:function(j,p){var l,n,r=[],t="{...}",k="f(){...}",q=", ",m=" => ";if(!f.isObject(j)){return j+"";}else{if(j instanceof Date||("nodeType" in j&&"tagName" in j)){return j;}else{if(f.isFunction(j)){return k;}}}p=(f.isNumber(p))?p:3;if(f.isArray(j)){r.push("[");for(l=0,n=j.length;l<n;l=l+1){if(f.isObject(j[l])){r.push((p>0)?f.dump(j[l],p-1):t);}else{r.push(j[l]);}r.push(q);}if(r.length>1){r.pop();}r.push("]");}else{r.push("{");for(l in j){if(f.hasOwnProperty(j,l)){r.push(l+m);if(f.isObject(j[l])){r.push((p>0)?f.dump(j[l],p-1):t);}else{r.push(j[l]);}r.push(q);}}if(r.length>1){r.pop();}r.push("}");}return r.join("");},substitute:function(x,y,E,l){var D,C,B,G,t,u,F=[],p,z=x.length,A="dump",r=" ",q="{",m="}",n,w;for(;;){D=x.lastIndexOf(q,z);if(D<0){break;}C=x.indexOf(m,D);if(D+1>C){break;}p=x.substring(D+1,C);G=p;u=null;B=G.indexOf(r);if(B>-1){u=G.substring(B+1);G=G.substring(0,B);}t=y[G];if(E){t=E(G,t,u);}if(f.isObject(t)){if(f.isArray(t)){t=f.dump(t,parseInt(u,10));}else{u=u||"";n=u.indexOf(A);if(n>-1){u=u.substring(4);}w=t.toString();if(w===i||n>-1){t=f.dump(t,parseInt(u,10));}else{t=w;}}}else{if(!f.isString(t)&&!f.isNumber(t)){t="~-"+F.length+"-~";F[F.length]=p;}}x=x.substring(0,D)+t+x.substring(C+1);if(l===false){z=D-1;}}for(D=F.length-1;D>=0;D=D-1){x=x.replace(new RegExp("~-"+D+"-~"),"{"+F[D]+"}","g");}return x;},trim:function(j){try{return j.replace(/^\s+|\s+$/g,"");}catch(k){return j;
}},merge:function(){var n={},k=arguments,j=k.length,m;for(m=0;m<j;m=m+1){f.augmentObject(n,k[m],true);}return n;},later:function(t,k,u,n,p){t=t||0;k=k||{};var l=u,s=n,q,j;if(f.isString(u)){l=k[u];}if(!l){throw new TypeError("method undefined");}if(!f.isUndefined(n)&&!f.isArray(s)){s=[n];}q=function(){l.apply(k,s||b);};j=(p)?setInterval(q,t):setTimeout(q,t);return{interval:p,cancel:function(){if(this.interval){clearInterval(j);}else{clearTimeout(j);}}};},isValue:function(j){return(f.isObject(j)||f.isString(j)||f.isNumber(j)||f.isBoolean(j));}};f.hasOwnProperty=(a.hasOwnProperty)?function(j,k){return j&&j.hasOwnProperty&&j.hasOwnProperty(k);}:function(j,k){return !f.isUndefined(j[k])&&j.constructor.prototype[k]!==j[k];};e.augmentObject(f,e,true);YAHOO.util.Lang=f;f.augment=f.augmentProto;YAHOO.augment=f.augmentProto;YAHOO.extend=f.extend;})();YAHOO.register("yahoo",YAHOO,{version:"2.9.0",build:"2800"});(function(){YAHOO.env._id_counter=YAHOO.env._id_counter||0;var e=YAHOO.util,k=YAHOO.lang,L=YAHOO.env.ua,a=YAHOO.lang.trim,B={},F={},m=/^t(?:able|d|h)$/i,w=/color$/i,j=window.document,v=j.documentElement,C="ownerDocument",M="defaultView",U="documentElement",S="compatMode",z="offsetLeft",o="offsetTop",T="offsetParent",x="parentNode",K="nodeType",c="tagName",n="scrollLeft",H="scrollTop",p="getBoundingClientRect",V="getComputedStyle",y="currentStyle",l="CSS1Compat",A="BackCompat",E="class",f="className",i="",b=" ",R="(?:^|\\s)",J="(?= |$)",t="g",O="position",D="fixed",u="relative",I="left",N="top",Q="medium",P="borderLeftWidth",q="borderTopWidth",d=L.opera,h=L.webkit,g=L.gecko,s=L.ie;e.Dom={CUSTOM_ATTRIBUTES:(!v.hasAttribute)?{"for":"htmlFor","class":f}:{"htmlFor":"for","className":E},DOT_ATTRIBUTES:{checked:true},get:function(aa){var ac,X,ab,Z,W,G,Y=null;if(aa){if(typeof aa=="string"||typeof aa=="number"){ac=aa+"";aa=j.getElementById(aa);G=(aa)?aa.attributes:null;if(aa&&G&&G.id&&G.id.value===ac){return aa;}else{if(aa&&j.all){aa=null;X=j.all[ac];if(X&&X.length){for(Z=0,W=X.length;Z<W;++Z){if(X[Z].id===ac){return X[Z];}}}}}}else{if(e.Element&&aa instanceof e.Element){aa=aa.get("element");}else{if(!aa.nodeType&&"length" in aa){ab=[];for(Z=0,W=aa.length;Z<W;++Z){ab[ab.length]=e.Dom.get(aa[Z]);}aa=ab;}}}Y=aa;}return Y;},getComputedStyle:function(G,W){if(window[V]){return G[C][M][V](G,null)[W];}else{if(G[y]){return e.Dom.IE_ComputedStyle.get(G,W);}}},getStyle:function(G,W){return e.Dom.batch(G,e.Dom._getStyle,W);},_getStyle:function(){if(window[V]){return function(G,Y){Y=(Y==="float")?Y="cssFloat":e.Dom._toCamel(Y);var X=G.style[Y],W;if(!X){W=G[C][M][V](G,null);if(W){X=W[Y];}}return X;};}else{if(v[y]){return function(G,Y){var X;switch(Y){case"opacity":X=100;try{X=G.filters["DXImageTransform.Microsoft.Alpha"].opacity;}catch(Z){try{X=G.filters("alpha").opacity;}catch(W){}}return X/100;case"float":Y="styleFloat";default:Y=e.Dom._toCamel(Y);X=G[y]?G[y][Y]:null;return(G.style[Y]||X);}};}}}(),setStyle:function(G,W,X){e.Dom.batch(G,e.Dom._setStyle,{prop:W,val:X});},_setStyle:function(){if(!window.getComputedStyle&&j.documentElement.currentStyle){return function(W,G){var X=e.Dom._toCamel(G.prop),Y=G.val;if(W){switch(X){case"opacity":if(Y===""||Y===null||Y===1){W.style.removeAttribute("filter");}else{if(k.isString(W.style.filter)){W.style.filter="alpha(opacity="+Y*100+")";if(!W[y]||!W[y].hasLayout){W.style.zoom=1;}}}break;case"float":X="styleFloat";default:W.style[X]=Y;}}else{}};}else{return function(W,G){var X=e.Dom._toCamel(G.prop),Y=G.val;if(W){if(X=="float"){X="cssFloat";}W.style[X]=Y;}else{}};}}(),getXY:function(G){return e.Dom.batch(G,e.Dom._getXY);},_canPosition:function(G){return(e.Dom._getStyle(G,"display")!=="none"&&e.Dom._inDoc(G));},_getXY:function(W){var X,G,Z,ab,Y,aa,ac=Math.round,ad=false;if(e.Dom._canPosition(W)){Z=W[p]();ab=W[C];X=e.Dom.getDocumentScrollLeft(ab);G=e.Dom.getDocumentScrollTop(ab);ad=[Z[I],Z[N]];if(Y||aa){ad[0]-=aa;ad[1]-=Y;}if((G||X)){ad[0]+=X;ad[1]+=G;}ad[0]=ac(ad[0]);ad[1]=ac(ad[1]);}else{}return ad;},getX:function(G){var W=function(X){return e.Dom.getXY(X)[0];};return e.Dom.batch(G,W,e.Dom,true);},getY:function(G){var W=function(X){return e.Dom.getXY(X)[1];};return e.Dom.batch(G,W,e.Dom,true);},setXY:function(G,X,W){e.Dom.batch(G,e.Dom._setXY,{pos:X,noRetry:W});},_setXY:function(G,Z){var aa=e.Dom._getStyle(G,O),Y=e.Dom.setStyle,ad=Z.pos,W=Z.noRetry,ab=[parseInt(e.Dom.getComputedStyle(G,I),10),parseInt(e.Dom.getComputedStyle(G,N),10)],ac,X;ac=e.Dom._getXY(G);if(!ad||ac===false){return false;}if(aa=="static"){aa=u;Y(G,O,aa);}if(isNaN(ab[0])){ab[0]=(aa==u)?0:G[z];}if(isNaN(ab[1])){ab[1]=(aa==u)?0:G[o];}if(ad[0]!==null){Y(G,I,ad[0]-ac[0]+ab[0]+"px");}if(ad[1]!==null){Y(G,N,ad[1]-ac[1]+ab[1]+"px");}if(!W){X=e.Dom._getXY(G);if((ad[0]!==null&&X[0]!=ad[0])||(ad[1]!==null&&X[1]!=ad[1])){e.Dom._setXY(G,{pos:ad,noRetry:true});}}},setX:function(W,G){e.Dom.setXY(W,[G,null]);},setY:function(G,W){e.Dom.setXY(G,[null,W]);},getRegion:function(G){var W=function(X){var Y=false;if(e.Dom._canPosition(X)){Y=e.Region.getRegion(X);}else{}return Y;};return e.Dom.batch(G,W,e.Dom,true);},getClientWidth:function(){return e.Dom.getViewportWidth();},getClientHeight:function(){return e.Dom.getViewportHeight();},getElementsByClassName:function(ab,af,ac,ae,X,ad){af=af||"*";ac=(ac)?e.Dom.get(ac):null||j;if(!ac){return[];}var W=[],G=ac.getElementsByTagName(af),Z=e.Dom.hasClass;for(var Y=0,aa=G.length;Y<aa;++Y){if(Z(G[Y],ab)){W[W.length]=G[Y];}}if(ae){e.Dom.batch(W,ae,X,ad);}return W;},hasClass:function(W,G){return e.Dom.batch(W,e.Dom._hasClass,G);},_hasClass:function(X,W){var G=false,Y;if(X&&W){Y=e.Dom._getAttribute(X,f)||i;if(Y){Y=Y.replace(/\s+/g,b);}if(W.exec){G=W.test(Y);}else{G=W&&(b+Y+b).indexOf(b+W+b)>-1;}}else{}return G;},addClass:function(W,G){return e.Dom.batch(W,e.Dom._addClass,G);},_addClass:function(X,W){var G=false,Y;if(X&&W){Y=e.Dom._getAttribute(X,f)||i;if(!e.Dom._hasClass(X,W)){e.Dom.setAttribute(X,f,a(Y+b+W));G=true;}}else{}return G;},removeClass:function(W,G){return e.Dom.batch(W,e.Dom._removeClass,G);},_removeClass:function(Y,X){var W=false,aa,Z,G;if(Y&&X){aa=e.Dom._getAttribute(Y,f)||i;e.Dom.setAttribute(Y,f,aa.replace(e.Dom._getClassRegex(X),i));Z=e.Dom._getAttribute(Y,f);if(aa!==Z){e.Dom.setAttribute(Y,f,a(Z));W=true;if(e.Dom._getAttribute(Y,f)===""){G=(Y.hasAttribute&&Y.hasAttribute(E))?E:f;Y.removeAttribute(G);}}}else{}return W;},replaceClass:function(X,W,G){return e.Dom.batch(X,e.Dom._replaceClass,{from:W,to:G});},_replaceClass:function(Y,X){var W,ab,aa,G=false,Z;if(Y&&X){ab=X.from;aa=X.to;if(!aa){G=false;}else{if(!ab){G=e.Dom._addClass(Y,X.to);}else{if(ab!==aa){Z=e.Dom._getAttribute(Y,f)||i;W=(b+Z.replace(e.Dom._getClassRegex(ab),b+aa).replace(/\s+/g,b)).split(e.Dom._getClassRegex(aa));W.splice(1,0,b+aa);e.Dom.setAttribute(Y,f,a(W.join(i)));G=true;}}}}else{}return G;},generateId:function(G,X){X=X||"yui-gen";var W=function(Y){if(Y&&Y.id){return Y.id;}var Z=X+YAHOO.env._id_counter++;
if(Y){if(Y[C]&&Y[C].getElementById(Z)){return e.Dom.generateId(Y,Z+X);}Y.id=Z;}return Z;};return e.Dom.batch(G,W,e.Dom,true)||W.apply(e.Dom,arguments);},isAncestor:function(W,X){W=e.Dom.get(W);X=e.Dom.get(X);var G=false;if((W&&X)&&(W[K]&&X[K])){if(W.contains&&W!==X){G=W.contains(X);}else{if(W.compareDocumentPosition){G=!!(W.compareDocumentPosition(X)&16);}}}else{}return G;},inDocument:function(G,W){return e.Dom._inDoc(e.Dom.get(G),W);},_inDoc:function(W,X){var G=false;if(W&&W[c]){X=X||W[C];G=e.Dom.isAncestor(X[U],W);}else{}return G;},getElementsBy:function(W,af,ab,ad,X,ac,ae){af=af||"*";ab=(ab)?e.Dom.get(ab):null||j;var aa=(ae)?null:[],G;if(ab){G=ab.getElementsByTagName(af);for(var Y=0,Z=G.length;Y<Z;++Y){if(W(G[Y])){if(ae){aa=G[Y];break;}else{aa[aa.length]=G[Y];}}}if(ad){e.Dom.batch(aa,ad,X,ac);}}return aa;},getElementBy:function(X,G,W){return e.Dom.getElementsBy(X,G,W,null,null,null,true);},batch:function(X,ab,aa,Z){var Y=[],W=(Z)?aa:null;X=(X&&(X[c]||X.item))?X:e.Dom.get(X);if(X&&ab){if(X[c]||X.length===undefined){return ab.call(W,X,aa);}for(var G=0;G<X.length;++G){Y[Y.length]=ab.call(W||X[G],X[G],aa);}}else{return false;}return Y;},getDocumentHeight:function(){var W=(j[S]!=l||h)?j.body.scrollHeight:v.scrollHeight,G=Math.max(W,e.Dom.getViewportHeight());return G;},getDocumentWidth:function(){var W=(j[S]!=l||h)?j.body.scrollWidth:v.scrollWidth,G=Math.max(W,e.Dom.getViewportWidth());return G;},getViewportHeight:function(){var G=self.innerHeight,W=j[S];if((W||s)&&!d){G=(W==l)?v.clientHeight:j.body.clientHeight;}return G;},getViewportWidth:function(){var G=self.innerWidth,W=j[S];if(W||s){G=(W==l)?v.clientWidth:j.body.clientWidth;}return G;},getAncestorBy:function(G,W){while((G=G[x])){if(e.Dom._testElement(G,W)){return G;}}return null;},getAncestorByClassName:function(W,G){W=e.Dom.get(W);if(!W){return null;}var X=function(Y){return e.Dom.hasClass(Y,G);};return e.Dom.getAncestorBy(W,X);},getAncestorByTagName:function(W,G){W=e.Dom.get(W);if(!W){return null;}var X=function(Y){return Y[c]&&Y[c].toUpperCase()==G.toUpperCase();};return e.Dom.getAncestorBy(W,X);},getPreviousSiblingBy:function(G,W){while(G){G=G.previousSibling;if(e.Dom._testElement(G,W)){return G;}}return null;},getPreviousSibling:function(G){G=e.Dom.get(G);if(!G){return null;}return e.Dom.getPreviousSiblingBy(G);},getNextSiblingBy:function(G,W){while(G){G=G.nextSibling;if(e.Dom._testElement(G,W)){return G;}}return null;},getNextSibling:function(G){G=e.Dom.get(G);if(!G){return null;}return e.Dom.getNextSiblingBy(G);},getFirstChildBy:function(G,X){var W=(e.Dom._testElement(G.firstChild,X))?G.firstChild:null;return W||e.Dom.getNextSiblingBy(G.firstChild,X);},getFirstChild:function(G,W){G=e.Dom.get(G);if(!G){return null;}return e.Dom.getFirstChildBy(G);},getLastChildBy:function(G,X){if(!G){return null;}var W=(e.Dom._testElement(G.lastChild,X))?G.lastChild:null;return W||e.Dom.getPreviousSiblingBy(G.lastChild,X);},getLastChild:function(G){G=e.Dom.get(G);return e.Dom.getLastChildBy(G);},getChildrenBy:function(W,Y){var X=e.Dom.getFirstChildBy(W,Y),G=X?[X]:[];e.Dom.getNextSiblingBy(X,function(Z){if(!Y||Y(Z)){G[G.length]=Z;}return false;});return G;},getChildren:function(G){G=e.Dom.get(G);if(!G){}return e.Dom.getChildrenBy(G);},getDocumentScrollLeft:function(G){G=G||j;return Math.max(G[U].scrollLeft,G.body.scrollLeft);},getDocumentScrollTop:function(G){G=G||j;return Math.max(G[U].scrollTop,G.body.scrollTop);},insertBefore:function(W,G){W=e.Dom.get(W);G=e.Dom.get(G);if(!W||!G||!G[x]){return null;}return G[x].insertBefore(W,G);},insertAfter:function(W,G){W=e.Dom.get(W);G=e.Dom.get(G);if(!W||!G||!G[x]){return null;}if(G.nextSibling){return G[x].insertBefore(W,G.nextSibling);}else{return G[x].appendChild(W);}},getClientRegion:function(){var X=e.Dom.getDocumentScrollTop(),W=e.Dom.getDocumentScrollLeft(),Y=e.Dom.getViewportWidth()+W,G=e.Dom.getViewportHeight()+X;return new e.Region(X,Y,G,W);},setAttribute:function(W,G,X){e.Dom.batch(W,e.Dom._setAttribute,{attr:G,val:X});},_setAttribute:function(X,W){var G=e.Dom._toCamel(W.attr),Y=W.val;if(X&&X.setAttribute){if(e.Dom.DOT_ATTRIBUTES[G]&&X.tagName&&X.tagName!="BUTTON"){X[G]=Y;}else{G=e.Dom.CUSTOM_ATTRIBUTES[G]||G;X.setAttribute(G,Y);}}else{}},getAttribute:function(W,G){return e.Dom.batch(W,e.Dom._getAttribute,G);},_getAttribute:function(W,G){var X;G=e.Dom.CUSTOM_ATTRIBUTES[G]||G;if(e.Dom.DOT_ATTRIBUTES[G]){X=W[G];}else{if(W&&"getAttribute" in W){if(/^(?:href|src)$/.test(G)){X=W.getAttribute(G,2);}else{X=W.getAttribute(G);}}else{}}return X;},_toCamel:function(W){var X=B;function G(Y,Z){return Z.toUpperCase();}return X[W]||(X[W]=W.indexOf("-")===-1?W:W.replace(/-([a-z])/gi,G));},_getClassRegex:function(W){var G;if(W!==undefined){if(W.exec){G=W;}else{G=F[W];if(!G){W=W.replace(e.Dom._patterns.CLASS_RE_TOKENS,"\\$1");W=W.replace(/\s+/g,b);G=F[W]=new RegExp(R+W+J,t);}}}return G;},_patterns:{ROOT_TAG:/^body|html$/i,CLASS_RE_TOKENS:/([\.\(\)\^\$\*\+\?\|\[\]\{\}\\])/g},_testElement:function(G,W){return G&&G[K]==1&&(!W||W(G));},_calcBorders:function(X,Y){var W=parseInt(e.Dom[V](X,q),10)||0,G=parseInt(e.Dom[V](X,P),10)||0;if(g){if(m.test(X[c])){W=0;G=0;}}Y[0]+=G;Y[1]+=W;return Y;}};var r=e.Dom[V];if(L.opera){e.Dom[V]=function(W,G){var X=r(W,G);if(w.test(G)){X=e.Dom.Color.toRGB(X);}return X;};}if(L.webkit){e.Dom[V]=function(W,G){var X=r(W,G);if(X==="rgba(0, 0, 0, 0)"){X="transparent";}return X;};}if(L.ie&&L.ie>=8){e.Dom.DOT_ATTRIBUTES.type=true;}})();YAHOO.util.Region=function(d,e,a,c){this.top=d;this.y=d;this[1]=d;this.right=e;this.bottom=a;this.left=c;this.x=c;this[0]=c;this.width=this.right-this.left;this.height=this.bottom-this.top;};YAHOO.util.Region.prototype.contains=function(a){return(a.left>=this.left&&a.right<=this.right&&a.top>=this.top&&a.bottom<=this.bottom);};YAHOO.util.Region.prototype.getArea=function(){return((this.bottom-this.top)*(this.right-this.left));};YAHOO.util.Region.prototype.intersect=function(f){var d=Math.max(this.top,f.top),e=Math.min(this.right,f.right),a=Math.min(this.bottom,f.bottom),c=Math.max(this.left,f.left);
if(a>=d&&e>=c){return new YAHOO.util.Region(d,e,a,c);}else{return null;}};YAHOO.util.Region.prototype.union=function(f){var d=Math.min(this.top,f.top),e=Math.max(this.right,f.right),a=Math.max(this.bottom,f.bottom),c=Math.min(this.left,f.left);return new YAHOO.util.Region(d,e,a,c);};YAHOO.util.Region.prototype.toString=function(){return("Region {"+"top: "+this.top+", right: "+this.right+", bottom: "+this.bottom+", left: "+this.left+", height: "+this.height+", width: "+this.width+"}");};YAHOO.util.Region.getRegion=function(e){var g=YAHOO.util.Dom.getXY(e),d=g[1],f=g[0]+e.offsetWidth,a=g[1]+e.offsetHeight,c=g[0];return new YAHOO.util.Region(d,f,a,c);};YAHOO.util.Point=function(a,b){if(YAHOO.lang.isArray(a)){b=a[1];a=a[0];}YAHOO.util.Point.superclass.constructor.call(this,b,a,b,a);};YAHOO.extend(YAHOO.util.Point,YAHOO.util.Region);(function(){var b=YAHOO.util,a="clientTop",f="clientLeft",j="parentNode",k="right",w="hasLayout",i="px",u="opacity",l="auto",d="borderLeftWidth",g="borderTopWidth",p="borderRightWidth",v="borderBottomWidth",s="visible",q="transparent",n="height",e="width",h="style",t="currentStyle",r=/^width|height$/,o=/^(\d[.\d]*)+(em|ex|px|gd|rem|vw|vh|vm|ch|mm|cm|in|pt|pc|deg|rad|ms|s|hz|khz|%){1}?/i,m={get:function(x,z){var y="",A=x[t][z];if(z===u){y=b.Dom.getStyle(x,u);}else{if(!A||(A.indexOf&&A.indexOf(i)>-1)){y=A;}else{if(b.Dom.IE_COMPUTED[z]){y=b.Dom.IE_COMPUTED[z](x,z);}else{if(o.test(A)){y=b.Dom.IE.ComputedStyle.getPixel(x,z);}else{y=A;}}}}return y;},getOffset:function(z,E){var B=z[t][E],x=E.charAt(0).toUpperCase()+E.substr(1),C="offset"+x,y="pixel"+x,A="",D;if(B==l){D=z[C];if(D===undefined){A=0;}A=D;if(r.test(E)){z[h][E]=D;if(z[C]>D){A=D-(z[C]-D);}z[h][E]=l;}}else{if(!z[h][y]&&!z[h][E]){z[h][E]=B;}A=z[h][y];}return A+i;},getBorderWidth:function(x,z){var y=null;if(!x[t][w]){x[h].zoom=1;}switch(z){case g:y=x[a];break;case v:y=x.offsetHeight-x.clientHeight-x[a];break;case d:y=x[f];break;case p:y=x.offsetWidth-x.clientWidth-x[f];break;}return y+i;},getPixel:function(y,x){var A=null,B=y[t][k],z=y[t][x];y[h][k]=z;A=y[h].pixelRight;y[h][k]=B;return A+i;},getMargin:function(y,x){var z;if(y[t][x]==l){z=0+i;}else{z=b.Dom.IE.ComputedStyle.getPixel(y,x);}return z;},getVisibility:function(y,x){var z;while((z=y[t])&&z[x]=="inherit"){y=y[j];}return(z)?z[x]:s;},getColor:function(y,x){return b.Dom.Color.toRGB(y[t][x])||q;},getBorderColor:function(y,x){var z=y[t],A=z[x]||z.color;return b.Dom.Color.toRGB(b.Dom.Color.toHex(A));}},c={};c.top=c.right=c.bottom=c.left=c[e]=c[n]=m.getOffset;c.color=m.getColor;c[g]=c[p]=c[v]=c[d]=m.getBorderWidth;c.marginTop=c.marginRight=c.marginBottom=c.marginLeft=m.getMargin;c.visibility=m.getVisibility;c.borderColor=c.borderTopColor=c.borderRightColor=c.borderBottomColor=c.borderLeftColor=m.getBorderColor;b.Dom.IE_COMPUTED=c;b.Dom.IE_ComputedStyle=m;})();(function(){var c="toString",a=parseInt,b=RegExp,d=YAHOO.util;d.Dom.Color={KEYWORDS:{black:"000",silver:"c0c0c0",gray:"808080",white:"fff",maroon:"800000",red:"f00",purple:"800080",fuchsia:"f0f",green:"008000",lime:"0f0",olive:"808000",yellow:"ff0",navy:"000080",blue:"00f",teal:"008080",aqua:"0ff"},re_RGB:/^rgb\(([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\)$/i,re_hex:/^#?([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$/i,re_hex3:/([0-9A-F])/gi,toRGB:function(e){if(!d.Dom.Color.re_RGB.test(e)){e=d.Dom.Color.toHex(e);}if(d.Dom.Color.re_hex.exec(e)){e="rgb("+[a(b.$1,16),a(b.$2,16),a(b.$3,16)].join(", ")+")";}return e;},toHex:function(f){f=d.Dom.Color.KEYWORDS[f]||f;if(d.Dom.Color.re_RGB.exec(f)){f=[Number(b.$1).toString(16),Number(b.$2).toString(16),Number(b.$3).toString(16)];for(var e=0;e<f.length;e++){if(f[e].length<2){f[e]="0"+f[e];}}f=f.join("");}if(f.length<6){f=f.replace(d.Dom.Color.re_hex3,"$1$1");}if(f!=="transparent"&&f.indexOf("#")<0){f="#"+f;}return f.toUpperCase();}};}());YAHOO.register("dom",YAHOO.util.Dom,{version:"2.9.0",build:"2800"});YAHOO.util.CustomEvent=function(d,c,b,a,e){this.type=d;this.scope=c||window;this.silent=b;this.fireOnce=e;this.fired=false;this.firedWith=null;this.signature=a||YAHOO.util.CustomEvent.LIST;this.subscribers=[];if(!this.silent){}var f="_YUICEOnSubscribe";if(d!==f){this.subscribeEvent=new YAHOO.util.CustomEvent(f,this,true);}this.lastError=null;};YAHOO.util.CustomEvent.LIST=0;YAHOO.util.CustomEvent.FLAT=1;YAHOO.util.CustomEvent.prototype={subscribe:function(b,c,d){if(!b){throw new Error("Invalid callback for subscriber to '"+this.type+"'");}if(this.subscribeEvent){this.subscribeEvent.fire(b,c,d);}var a=new YAHOO.util.Subscriber(b,c,d);if(this.fireOnce&&this.fired){this.notify(a,this.firedWith);}else{this.subscribers.push(a);}},unsubscribe:function(d,f){if(!d){return this.unsubscribeAll();}var e=false;for(var b=0,a=this.subscribers.length;b<a;++b){var c=this.subscribers[b];if(c&&c.contains(d,f)){this._delete(b);e=true;}}return e;},fire:function(){this.lastError=null;var h=[],a=this.subscribers.length;var d=[].slice.call(arguments,0),c=true,f,b=false;if(this.fireOnce){if(this.fired){return true;}else{this.firedWith=d;}}this.fired=true;if(!a&&this.silent){return true;}if(!this.silent){}var e=this.subscribers.slice();for(f=0;f<a;++f){var g=e[f];if(!g||!g.fn){b=true;}else{c=this.notify(g,d);if(false===c){if(!this.silent){}break;}}}return(c!==false);},notify:function(g,c){var b,i=null,f=g.getScope(this.scope),a=YAHOO.util.Event.throwErrors;if(!this.silent){}if(this.signature==YAHOO.util.CustomEvent.FLAT){if(c.length>0){i=c[0];}try{b=g.fn.call(f,i,g.obj);}catch(h){this.lastError=h;if(a){throw h;}}}else{try{b=g.fn.call(f,this.type,c,g.obj);}catch(d){this.lastError=d;if(a){throw d;}}}return b;},unsubscribeAll:function(){var a=this.subscribers.length,b;for(b=a-1;b>-1;b--){this._delete(b);}this.subscribers=[];return a;},_delete:function(a){var b=this.subscribers[a];if(b){delete b.fn;delete b.obj;}this.subscribers.splice(a,1);},toString:function(){return"CustomEvent: "+"'"+this.type+"', "+"context: "+this.scope;}};YAHOO.util.Subscriber=function(a,b,c){this.fn=a;this.obj=YAHOO.lang.isUndefined(b)?null:b;this.overrideContext=c;};YAHOO.util.Subscriber.prototype.getScope=function(a){if(this.overrideContext){if(this.overrideContext===true){return this.obj;}else{return this.overrideContext;}}return a;};YAHOO.util.Subscriber.prototype.contains=function(a,b){if(b){return(this.fn==a&&this.obj==b);}else{return(this.fn==a);}};YAHOO.util.Subscriber.prototype.toString=function(){return"Subscriber { obj: "+this.obj+", overrideContext: "+(this.overrideContext||"no")+" }";};if(!YAHOO.util.Event){YAHOO.util.Event=function(){var g=false,h=[],j=[],a=0,e=[],b=0,c={63232:38,63233:40,63234:37,63235:39,63276:33,63277:34,25:9},d=YAHOO.env.ua.ie,f="focusin",i="focusout";return{POLL_RETRYS:500,POLL_INTERVAL:40,EL:0,TYPE:1,FN:2,WFN:3,UNLOAD_OBJ:3,ADJ_SCOPE:4,OBJ:5,OVERRIDE:6,CAPTURE:7,lastError:null,isSafari:YAHOO.env.ua.webkit,webkit:YAHOO.env.ua.webkit,isIE:d,_interval:null,_dri:null,_specialTypes:{focusin:(d?"focusin":"focus"),focusout:(d?"focusout":"blur")},DOMReady:false,throwErrors:false,startInterval:function(){if(!this._interval){this._interval=YAHOO.lang.later(this.POLL_INTERVAL,this,this._tryPreloadAttach,null,true);}},onAvailable:function(q,m,o,p,n){var k=(YAHOO.lang.isString(q))?[q]:q;for(var l=0;l<k.length;l=l+1){e.push({id:k[l],fn:m,obj:o,overrideContext:p,checkReady:n});}a=this.POLL_RETRYS;this.startInterval();},onContentReady:function(n,k,l,m){this.onAvailable(n,k,l,m,true);},onDOMReady:function(){this.DOMReadyEvent.subscribe.apply(this.DOMReadyEvent,arguments);},_addListener:function(m,k,v,p,t,y){if(!v||!v.call){return false;}if(this._isValidCollection(m)){var w=true;for(var q=0,s=m.length;q<s;++q){w=this.on(m[q],k,v,p,t)&&w;}return w;}else{if(YAHOO.lang.isString(m)){var o=this.getEl(m);if(o){m=o;}else{this.onAvailable(m,function(){YAHOO.util.Event._addListener(m,k,v,p,t,y);});return true;}}}if(!m){return false;}if("unload"==k&&p!==this){j[j.length]=[m,k,v,p,t];return true;}var l=m;if(t){if(t===true){l=p;}else{l=t;}}var n=function(z){return v.call(l,YAHOO.util.Event.getEvent(z,m),p);};var x=[m,k,v,n,l,p,t,y];var r=h.length;h[r]=x;try{this._simpleAdd(m,k,n,y);}catch(u){this.lastError=u;this.removeListener(m,k,v);return false;}return true;},_getType:function(k){return this._specialTypes[k]||k;},addListener:function(m,p,l,n,o){var k=((p==f||p==i)&&!YAHOO.env.ua.ie)?true:false;return this._addListener(m,this._getType(p),l,n,o,k);},addFocusListener:function(l,k,m,n){return this.on(l,f,k,m,n);},removeFocusListener:function(l,k){return this.removeListener(l,f,k);},addBlurListener:function(l,k,m,n){return this.on(l,i,k,m,n);},removeBlurListener:function(l,k){return this.removeListener(l,i,k);},removeListener:function(l,k,r){var m,p,u;k=this._getType(k);if(typeof l=="string"){l=this.getEl(l);}else{if(this._isValidCollection(l)){var s=true;for(m=l.length-1;m>-1;m--){s=(this.removeListener(l[m],k,r)&&s);}return s;}}if(!r||!r.call){return this.purgeElement(l,false,k);}if("unload"==k){for(m=j.length-1;m>-1;m--){u=j[m];if(u&&u[0]==l&&u[1]==k&&u[2]==r){j.splice(m,1);return true;}}return false;}var n=null;var o=arguments[3];if("undefined"===typeof o){o=this._getCacheIndex(h,l,k,r);}if(o>=0){n=h[o];}if(!l||!n){return false;}var t=n[this.CAPTURE]===true?true:false;try{this._simpleRemove(l,k,n[this.WFN],t);}catch(q){this.lastError=q;return false;}delete h[o][this.WFN];delete h[o][this.FN];h.splice(o,1);return true;},getTarget:function(m,l){var k=m.target||m.srcElement;return this.resolveTextNode(k);},resolveTextNode:function(l){try{if(l&&3==l.nodeType){return l.parentNode;}}catch(k){return null;}return l;},getPageX:function(l){var k=l.pageX;if(!k&&0!==k){k=l.clientX||0;if(this.isIE){k+=this._getScrollLeft();}}return k;},getPageY:function(k){var l=k.pageY;if(!l&&0!==l){l=k.clientY||0;if(this.isIE){l+=this._getScrollTop();}}return l;},getXY:function(k){return[this.getPageX(k),this.getPageY(k)];},getRelatedTarget:function(l){var k=l.relatedTarget;
if(!k){if(l.type=="mouseout"){k=l.toElement;}else{if(l.type=="mouseover"){k=l.fromElement;}}}return this.resolveTextNode(k);},getTime:function(m){if(!m.time){var l=new Date().getTime();try{m.time=l;}catch(k){this.lastError=k;return l;}}return m.time;},stopEvent:function(k){this.stopPropagation(k);this.preventDefault(k);},stopPropagation:function(k){if(k.stopPropagation){k.stopPropagation();}else{k.cancelBubble=true;}},preventDefault:function(k){if(k.preventDefault){k.preventDefault();}else{k.returnValue=false;}},getEvent:function(m,k){var l=m||window.event;if(!l){var n=this.getEvent.caller;while(n){l=n.arguments[0];if(l&&Event==l.constructor){break;}n=n.caller;}}return l;},getCharCode:function(l){var k=l.keyCode||l.charCode||0;if(YAHOO.env.ua.webkit&&(k in c)){k=c[k];}return k;},_getCacheIndex:function(n,q,r,p){for(var o=0,m=n.length;o<m;o=o+1){var k=n[o];if(k&&k[this.FN]==p&&k[this.EL]==q&&k[this.TYPE]==r){return o;}}return -1;},generateId:function(k){var l=k.id;if(!l){l="yuievtautoid-"+b;++b;k.id=l;}return l;},_isValidCollection:function(l){try{return(l&&typeof l!=="string"&&l.length&&!l.tagName&&!l.alert&&typeof l[0]!=="undefined");}catch(k){return false;}},elCache:{},getEl:function(k){return(typeof k==="string")?document.getElementById(k):k;},clearCache:function(){},DOMReadyEvent:new YAHOO.util.CustomEvent("DOMReady",YAHOO,0,0,1),_load:function(l){if(!g){g=true;var k=YAHOO.util.Event;k._ready();k._tryPreloadAttach();}},_ready:function(l){var k=YAHOO.util.Event;if(!k.DOMReady){k.DOMReady=true;k.DOMReadyEvent.fire();k._simpleRemove(document,"DOMContentLoaded",k._ready);}},_tryPreloadAttach:function(){if(e.length===0){a=0;if(this._interval){this._interval.cancel();this._interval=null;}return;}if(this.locked){return;}if(this.isIE){if(!this.DOMReady){this.startInterval();return;}}this.locked=true;var q=!g;if(!q){q=(a>0&&e.length>0);}var p=[];var r=function(t,u){var s=t;if(u.overrideContext){if(u.overrideContext===true){s=u.obj;}else{s=u.overrideContext;}}u.fn.call(s,u.obj);};var l,k,o,n,m=[];for(l=0,k=e.length;l<k;l=l+1){o=e[l];if(o){n=this.getEl(o.id);if(n){if(o.checkReady){if(g||n.nextSibling||!q){m.push(o);e[l]=null;}}else{r(n,o);e[l]=null;}}else{p.push(o);}}}for(l=0,k=m.length;l<k;l=l+1){o=m[l];r(this.getEl(o.id),o);}a--;if(q){for(l=e.length-1;l>-1;l--){o=e[l];if(!o||!o.id){e.splice(l,1);}}this.startInterval();}else{if(this._interval){this._interval.cancel();this._interval=null;}}this.locked=false;},purgeElement:function(p,q,s){var n=(YAHOO.lang.isString(p))?this.getEl(p):p;var r=this.getListeners(n,s),o,k;if(r){for(o=r.length-1;o>-1;o--){var m=r[o];this.removeListener(n,m.type,m.fn);}}if(q&&n&&n.childNodes){for(o=0,k=n.childNodes.length;o<k;++o){this.purgeElement(n.childNodes[o],q,s);}}},getListeners:function(n,k){var q=[],m;if(!k){m=[h,j];}else{if(k==="unload"){m=[j];}else{k=this._getType(k);m=[h];}}var s=(YAHOO.lang.isString(n))?this.getEl(n):n;for(var p=0;p<m.length;p=p+1){var u=m[p];if(u){for(var r=0,t=u.length;r<t;++r){var o=u[r];if(o&&o[this.EL]===s&&(!k||k===o[this.TYPE])){q.push({type:o[this.TYPE],fn:o[this.FN],obj:o[this.OBJ],adjust:o[this.OVERRIDE],scope:o[this.ADJ_SCOPE],index:r});}}}}return(q.length)?q:null;},_unload:function(s){var m=YAHOO.util.Event,p,o,n,r,q,t=j.slice(),k;for(p=0,r=j.length;p<r;++p){n=t[p];if(n){try{k=window;if(n[m.ADJ_SCOPE]){if(n[m.ADJ_SCOPE]===true){k=n[m.UNLOAD_OBJ];}else{k=n[m.ADJ_SCOPE];}}n[m.FN].call(k,m.getEvent(s,n[m.EL]),n[m.UNLOAD_OBJ]);}catch(w){}t[p]=null;}}n=null;k=null;j=null;if(h){for(o=h.length-1;o>-1;o--){n=h[o];if(n){try{m.removeListener(n[m.EL],n[m.TYPE],n[m.FN],o);}catch(v){}}}n=null;}try{m._simpleRemove(window,"unload",m._unload);m._simpleRemove(window,"load",m._load);}catch(u){}},_getScrollLeft:function(){return this._getScroll()[1];},_getScrollTop:function(){return this._getScroll()[0];},_getScroll:function(){var k=document.documentElement,l=document.body;if(k&&(k.scrollTop||k.scrollLeft)){return[k.scrollTop,k.scrollLeft];}else{if(l){return[l.scrollTop,l.scrollLeft];}else{return[0,0];}}},regCE:function(){},_simpleAdd:function(){if(window.addEventListener){return function(m,n,l,k){m.addEventListener(n,l,(k));};}else{if(window.attachEvent){return function(m,n,l,k){m.attachEvent("on"+n,l);};}else{return function(){};}}}(),_simpleRemove:function(){if(window.removeEventListener){return function(m,n,l,k){m.removeEventListener(n,l,(k));};}else{if(window.detachEvent){return function(l,m,k){l.detachEvent("on"+m,k);};}else{return function(){};}}}()};}();(function(){var a=YAHOO.util.Event;a.on=a.addListener;a.onFocus=a.addFocusListener;a.onBlur=a.addBlurListener;
/*! DOMReady: based on work by: Dean Edwards/John Resig/Matthias Miller/Diego Perini */
if(a.isIE){if(self!==self.top){document.onreadystatechange=function(){if(document.readyState=="complete"){document.onreadystatechange=null;a._ready();}};}else{YAHOO.util.Event.onDOMReady(YAHOO.util.Event._tryPreloadAttach,YAHOO.util.Event,true);var b=document.createElement("p");a._dri=setInterval(function(){try{b.doScroll("left");clearInterval(a._dri);a._dri=null;a._ready();b=null;}catch(c){}},a.POLL_INTERVAL);}}else{if(a.webkit&&a.webkit<525){a._dri=setInterval(function(){var c=document.readyState;if("loaded"==c||"complete"==c){clearInterval(a._dri);a._dri=null;a._ready();}},a.POLL_INTERVAL);}else{a._simpleAdd(document,"DOMContentLoaded",a._ready);}}a._simpleAdd(window,"load",a._load);a._simpleAdd(window,"unload",a._unload);a._tryPreloadAttach();})();}YAHOO.util.EventProvider=function(){};YAHOO.util.EventProvider.prototype={__yui_events:null,__yui_subscribers:null,subscribe:function(a,c,f,e){this.__yui_events=this.__yui_events||{};var d=this.__yui_events[a];if(d){d.subscribe(c,f,e);}else{this.__yui_subscribers=this.__yui_subscribers||{};var b=this.__yui_subscribers;if(!b[a]){b[a]=[];}b[a].push({fn:c,obj:f,overrideContext:e});}},unsubscribe:function(c,e,g){this.__yui_events=this.__yui_events||{};var a=this.__yui_events;if(c){var f=a[c];if(f){return f.unsubscribe(e,g);}}else{var b=true;for(var d in a){if(YAHOO.lang.hasOwnProperty(a,d)){b=b&&a[d].unsubscribe(e,g);
}}return b;}return false;},unsubscribeAll:function(a){return this.unsubscribe(a);},createEvent:function(b,g){this.__yui_events=this.__yui_events||{};var e=g||{},d=this.__yui_events,f;if(d[b]){}else{f=new YAHOO.util.CustomEvent(b,e.scope||this,e.silent,YAHOO.util.CustomEvent.FLAT,e.fireOnce);d[b]=f;if(e.onSubscribeCallback){f.subscribeEvent.subscribe(e.onSubscribeCallback);}this.__yui_subscribers=this.__yui_subscribers||{};var a=this.__yui_subscribers[b];if(a){for(var c=0;c<a.length;++c){f.subscribe(a[c].fn,a[c].obj,a[c].overrideContext);}}}return d[b];},fireEvent:function(b){this.__yui_events=this.__yui_events||{};var d=this.__yui_events[b];if(!d){return null;}var a=[];for(var c=1;c<arguments.length;++c){a.push(arguments[c]);}return d.fire.apply(d,a);},hasEvent:function(a){if(this.__yui_events){if(this.__yui_events[a]){return true;}}return false;}};(function(){var a=YAHOO.util.Event,c=YAHOO.lang;YAHOO.util.KeyListener=function(d,i,e,f){if(!d){}else{if(!i){}else{if(!e){}}}if(!f){f=YAHOO.util.KeyListener.KEYDOWN;}var g=new YAHOO.util.CustomEvent("keyPressed");this.enabledEvent=new YAHOO.util.CustomEvent("enabled");this.disabledEvent=new YAHOO.util.CustomEvent("disabled");if(c.isString(d)){d=document.getElementById(d);}if(c.isFunction(e)){g.subscribe(e);}else{g.subscribe(e.fn,e.scope,e.correctScope);}function h(o,n){if(!i.shift){i.shift=false;}if(!i.alt){i.alt=false;}if(!i.ctrl){i.ctrl=false;}if(o.shiftKey==i.shift&&o.altKey==i.alt&&o.ctrlKey==i.ctrl){var j,m=i.keys,l;if(YAHOO.lang.isArray(m)){for(var k=0;k<m.length;k++){j=m[k];l=a.getCharCode(o);if(j==l){g.fire(l,o);break;}}}else{l=a.getCharCode(o);if(m==l){g.fire(l,o);}}}}this.enable=function(){if(!this.enabled){a.on(d,f,h);this.enabledEvent.fire(i);}this.enabled=true;};this.disable=function(){if(this.enabled){a.removeListener(d,f,h);this.disabledEvent.fire(i);}this.enabled=false;};this.toString=function(){return"KeyListener ["+i.keys+"] "+d.tagName+(d.id?"["+d.id+"]":"");};};var b=YAHOO.util.KeyListener;b.KEYDOWN="keydown";b.KEYUP="keyup";b.KEY={ALT:18,BACK_SPACE:8,CAPS_LOCK:20,CONTROL:17,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,LEFT:37,META:224,NUM_LOCK:144,PAGE_DOWN:34,PAGE_UP:33,PAUSE:19,PRINTSCREEN:44,RIGHT:39,SCROLL_LOCK:145,SHIFT:16,SPACE:32,TAB:9,UP:38};})();YAHOO.register("event",YAHOO.util.Event,{version:"2.9.0",build:"2800"});YAHOO.register("yahoo-dom-event", YAHOO, {version: "2.9.0", build: "2800"});
/*
Copyright (c) 2011, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.com/yui/license.html
version: 2.9.0
*/
(function(){YAHOO.util.Config=function(d){if(d){this.init(d);}};var b=YAHOO.lang,c=YAHOO.util.CustomEvent,a=YAHOO.util.Config;a.CONFIG_CHANGED_EVENT="configChanged";a.BOOLEAN_TYPE="boolean";a.prototype={owner:null,queueInProgress:false,config:null,initialConfig:null,eventQueue:null,configChangedEvent:null,init:function(d){this.owner=d;this.configChangedEvent=this.createEvent(a.CONFIG_CHANGED_EVENT);this.configChangedEvent.signature=c.LIST;this.queueInProgress=false;this.config={};this.initialConfig={};this.eventQueue=[];},checkBoolean:function(d){return(typeof d==a.BOOLEAN_TYPE);},checkNumber:function(d){return(!isNaN(d));},fireEvent:function(d,f){var e=this.config[d];if(e&&e.event){e.event.fire(f);}},addProperty:function(e,d){e=e.toLowerCase();this.config[e]=d;d.event=this.createEvent(e,{scope:this.owner});d.event.signature=c.LIST;d.key=e;if(d.handler){d.event.subscribe(d.handler,this.owner);}this.setProperty(e,d.value,true);if(!d.suppressEvent){this.queueProperty(e,d.value);}},getConfig:function(){var d={},f=this.config,g,e;for(g in f){if(b.hasOwnProperty(f,g)){e=f[g];if(e&&e.event){d[g]=e.value;}}}return d;},getProperty:function(d){var e=this.config[d.toLowerCase()];if(e&&e.event){return e.value;}else{return undefined;}},resetProperty:function(d){d=d.toLowerCase();var e=this.config[d];if(e&&e.event){if(d in this.initialConfig){this.setProperty(d,this.initialConfig[d]);return true;}}else{return false;}},setProperty:function(e,g,d){var f;e=e.toLowerCase();if(this.queueInProgress&&!d){this.queueProperty(e,g);return true;}else{f=this.config[e];if(f&&f.event){if(f.validator&&!f.validator(g)){return false;}else{f.value=g;if(!d){this.fireEvent(e,g);this.configChangedEvent.fire([e,g]);}return true;}}else{return false;}}},queueProperty:function(v,r){v=v.toLowerCase();var u=this.config[v],l=false,k,g,h,j,p,t,f,n,o,d,m,w,e;if(u&&u.event){if(!b.isUndefined(r)&&u.validator&&!u.validator(r)){return false;}else{if(!b.isUndefined(r)){u.value=r;}else{r=u.value;}l=false;k=this.eventQueue.length;for(m=0;m<k;m++){g=this.eventQueue[m];if(g){h=g[0];j=g[1];if(h==v){this.eventQueue[m]=null;this.eventQueue.push([v,(!b.isUndefined(r)?r:j)]);l=true;break;}}}if(!l&&!b.isUndefined(r)){this.eventQueue.push([v,r]);}}if(u.supercedes){p=u.supercedes.length;for(w=0;w<p;w++){t=u.supercedes[w];f=this.eventQueue.length;for(e=0;e<f;e++){n=this.eventQueue[e];if(n){o=n[0];d=n[1];if(o==t.toLowerCase()){this.eventQueue.push([o,d]);this.eventQueue[e]=null;break;}}}}}return true;}else{return false;}},refireEvent:function(d){d=d.toLowerCase();var e=this.config[d];if(e&&e.event&&!b.isUndefined(e.value)){if(this.queueInProgress){this.queueProperty(d);}else{this.fireEvent(d,e.value);}}},applyConfig:function(d,g){var f,e;if(g){e={};for(f in d){if(b.hasOwnProperty(d,f)){e[f.toLowerCase()]=d[f];}}this.initialConfig=e;}for(f in d){if(b.hasOwnProperty(d,f)){this.queueProperty(f,d[f]);}}},refresh:function(){var d;for(d in this.config){if(b.hasOwnProperty(this.config,d)){this.refireEvent(d);}}},fireQueue:function(){var e,h,d,g,f;this.queueInProgress=true;for(e=0;e<this.eventQueue.length;e++){h=this.eventQueue[e];if(h){d=h[0];g=h[1];f=this.config[d];f.value=g;this.eventQueue[e]=null;this.fireEvent(d,g);}}this.queueInProgress=false;this.eventQueue=[];},subscribeToConfigEvent:function(d,e,g,h){var f=this.config[d.toLowerCase()];if(f&&f.event){if(!a.alreadySubscribed(f.event,e,g)){f.event.subscribe(e,g,h);}return true;}else{return false;}},unsubscribeFromConfigEvent:function(d,e,g){var f=this.config[d.toLowerCase()];if(f&&f.event){return f.event.unsubscribe(e,g);}else{return false;}},toString:function(){var d="Config";if(this.owner){d+=" ["+this.owner.toString()+"]";}return d;},outputEventQueue:function(){var d="",g,e,f=this.eventQueue.length;for(e=0;e<f;e++){g=this.eventQueue[e];if(g){d+=g[0]+"="+g[1]+", ";}}return d;},destroy:function(){var e=this.config,d,f;for(d in e){if(b.hasOwnProperty(e,d)){f=e[d];f.event.unsubscribeAll();f.event=null;}}this.configChangedEvent.unsubscribeAll();this.configChangedEvent=null;this.owner=null;this.config=null;this.initialConfig=null;this.eventQueue=null;}};a.alreadySubscribed=function(e,h,j){var f=e.subscribers.length,d,g;if(f>0){g=f-1;do{d=e.subscribers[g];if(d&&d.obj==j&&d.fn==h){return true;}}while(g--);}return false;};YAHOO.lang.augmentProto(a,YAHOO.util.EventProvider);}());(function(){YAHOO.widget.Module=function(r,q){if(r){this.init(r,q);}else{}};var f=YAHOO.util.Dom,d=YAHOO.util.Config,n=YAHOO.util.Event,m=YAHOO.util.CustomEvent,g=YAHOO.widget.Module,i=YAHOO.env.ua,h,p,o,e,a={"BEFORE_INIT":"beforeInit","INIT":"init","APPEND":"append","BEFORE_RENDER":"beforeRender","RENDER":"render","CHANGE_HEADER":"changeHeader","CHANGE_BODY":"changeBody","CHANGE_FOOTER":"changeFooter","CHANGE_CONTENT":"changeContent","DESTROY":"destroy","BEFORE_SHOW":"beforeShow","SHOW":"show","BEFORE_HIDE":"beforeHide","HIDE":"hide"},j={"VISIBLE":{key:"visible",value:true,validator:YAHOO.lang.isBoolean},"EFFECT":{key:"effect",suppressEvent:true,supercedes:["visible"]},"MONITOR_RESIZE":{key:"monitorresize",value:true},"APPEND_TO_DOCUMENT_BODY":{key:"appendtodocumentbody",value:false}};g.IMG_ROOT=null;g.IMG_ROOT_SSL=null;g.CSS_MODULE="yui-module";g.CSS_HEADER="hd";g.CSS_BODY="bd";g.CSS_FOOTER="ft";g.RESIZE_MONITOR_SECURE_URL="javascript:false;";g.RESIZE_MONITOR_BUFFER=1;g.textResizeEvent=new m("textResize");g.forceDocumentRedraw=function(){var q=document.documentElement;if(q){q.className+=" ";q.className=YAHOO.lang.trim(q.className);}};function l(){if(!h){h=document.createElement("div");h.innerHTML=('<div class="'+g.CSS_HEADER+'"></div>'+'<div class="'+g.CSS_BODY+'"></div><div class="'+g.CSS_FOOTER+'"></div>');p=h.firstChild;o=p.nextSibling;e=o.nextSibling;}return h;}function k(){if(!p){l();}return(p.cloneNode(false));}function b(){if(!o){l();}return(o.cloneNode(false));}function c(){if(!e){l();}return(e.cloneNode(false));}g.prototype={constructor:g,element:null,header:null,body:null,footer:null,id:null,imageRoot:g.IMG_ROOT,initEvents:function(){var q=m.LIST;
this.beforeInitEvent=this.createEvent(a.BEFORE_INIT);this.beforeInitEvent.signature=q;this.initEvent=this.createEvent(a.INIT);this.initEvent.signature=q;this.appendEvent=this.createEvent(a.APPEND);this.appendEvent.signature=q;this.beforeRenderEvent=this.createEvent(a.BEFORE_RENDER);this.beforeRenderEvent.signature=q;this.renderEvent=this.createEvent(a.RENDER);this.renderEvent.signature=q;this.changeHeaderEvent=this.createEvent(a.CHANGE_HEADER);this.changeHeaderEvent.signature=q;this.changeBodyEvent=this.createEvent(a.CHANGE_BODY);this.changeBodyEvent.signature=q;this.changeFooterEvent=this.createEvent(a.CHANGE_FOOTER);this.changeFooterEvent.signature=q;this.changeContentEvent=this.createEvent(a.CHANGE_CONTENT);this.changeContentEvent.signature=q;this.destroyEvent=this.createEvent(a.DESTROY);this.destroyEvent.signature=q;this.beforeShowEvent=this.createEvent(a.BEFORE_SHOW);this.beforeShowEvent.signature=q;this.showEvent=this.createEvent(a.SHOW);this.showEvent.signature=q;this.beforeHideEvent=this.createEvent(a.BEFORE_HIDE);this.beforeHideEvent.signature=q;this.hideEvent=this.createEvent(a.HIDE);this.hideEvent.signature=q;},platform:function(){var q=navigator.userAgent.toLowerCase();if(q.indexOf("windows")!=-1||q.indexOf("win32")!=-1){return"windows";}else{if(q.indexOf("macintosh")!=-1){return"mac";}else{return false;}}}(),browser:function(){var q=navigator.userAgent.toLowerCase();if(q.indexOf("opera")!=-1){return"opera";}else{if(q.indexOf("msie 7")!=-1){return"ie7";}else{if(q.indexOf("msie")!=-1){return"ie";}else{if(q.indexOf("safari")!=-1){return"safari";}else{if(q.indexOf("gecko")!=-1){return"gecko";}else{return false;}}}}}}(),isSecure:function(){if(window.location.href.toLowerCase().indexOf("https")===0){return true;}else{return false;}}(),initDefaultConfig:function(){this.cfg.addProperty(j.VISIBLE.key,{handler:this.configVisible,value:j.VISIBLE.value,validator:j.VISIBLE.validator});this.cfg.addProperty(j.EFFECT.key,{handler:this.configEffect,suppressEvent:j.EFFECT.suppressEvent,supercedes:j.EFFECT.supercedes});this.cfg.addProperty(j.MONITOR_RESIZE.key,{handler:this.configMonitorResize,value:j.MONITOR_RESIZE.value});this.cfg.addProperty(j.APPEND_TO_DOCUMENT_BODY.key,{value:j.APPEND_TO_DOCUMENT_BODY.value});},init:function(v,u){var s,w;this.initEvents();this.beforeInitEvent.fire(g);this.cfg=new d(this);if(this.isSecure){this.imageRoot=g.IMG_ROOT_SSL;}if(typeof v=="string"){s=v;v=document.getElementById(v);if(!v){v=(l()).cloneNode(false);v.id=s;}}this.id=f.generateId(v);this.element=v;w=this.element.firstChild;if(w){var r=false,q=false,t=false;do{if(1==w.nodeType){if(!r&&f.hasClass(w,g.CSS_HEADER)){this.header=w;r=true;}else{if(!q&&f.hasClass(w,g.CSS_BODY)){this.body=w;q=true;}else{if(!t&&f.hasClass(w,g.CSS_FOOTER)){this.footer=w;t=true;}}}}}while((w=w.nextSibling));}this.initDefaultConfig();f.addClass(this.element,g.CSS_MODULE);if(u){this.cfg.applyConfig(u,true);}if(!d.alreadySubscribed(this.renderEvent,this.cfg.fireQueue,this.cfg)){this.renderEvent.subscribe(this.cfg.fireQueue,this.cfg,true);}this.initEvent.fire(g);},initResizeMonitor:function(){var r=(i.gecko&&this.platform=="windows");if(r){var q=this;setTimeout(function(){q._initResizeMonitor();},0);}else{this._initResizeMonitor();}},_initResizeMonitor:function(){var q,s,u;function w(){g.textResizeEvent.fire();}if(!i.opera){s=f.get("_yuiResizeMonitor");var v=this._supportsCWResize();if(!s){s=document.createElement("iframe");if(this.isSecure&&g.RESIZE_MONITOR_SECURE_URL&&i.ie){s.src=g.RESIZE_MONITOR_SECURE_URL;}if(!v){u=["<html><head><script ",'type="text/javascript">',"window.onresize=function(){window.parent.","YAHOO.widget.Module.textResizeEvent.","fire();};<","/script></head>","<body></body></html>"].join("");s.src="data:text/html;charset=utf-8,"+encodeURIComponent(u);}s.id="_yuiResizeMonitor";s.title="Text Resize Monitor";s.tabIndex=-1;s.setAttribute("role","presentation");s.style.position="absolute";s.style.visibility="hidden";var r=document.body,t=r.firstChild;if(t){r.insertBefore(s,t);}else{r.appendChild(s);}s.style.backgroundColor="transparent";s.style.borderWidth="0";s.style.width="2em";s.style.height="2em";s.style.left="0";s.style.top=(-1*(s.offsetHeight+g.RESIZE_MONITOR_BUFFER))+"px";s.style.visibility="visible";if(i.webkit){q=s.contentWindow.document;q.open();q.close();}}if(s&&s.contentWindow){g.textResizeEvent.subscribe(this.onDomResize,this,true);if(!g.textResizeInitialized){if(v){if(!n.on(s.contentWindow,"resize",w)){n.on(s,"resize",w);}}g.textResizeInitialized=true;}this.resizeMonitor=s;}}},_supportsCWResize:function(){var q=true;if(i.gecko&&i.gecko<=1.8){q=false;}return q;},onDomResize:function(s,r){var q=-1*(this.resizeMonitor.offsetHeight+g.RESIZE_MONITOR_BUFFER);this.resizeMonitor.style.top=q+"px";this.resizeMonitor.style.left="0";},setHeader:function(r){var q=this.header||(this.header=k());if(r.nodeName){q.innerHTML="";q.appendChild(r);}else{q.innerHTML=r;}if(this._rendered){this._renderHeader();}this.changeHeaderEvent.fire(r);this.changeContentEvent.fire();},appendToHeader:function(r){var q=this.header||(this.header=k());q.appendChild(r);this.changeHeaderEvent.fire(r);this.changeContentEvent.fire();},setBody:function(r){var q=this.body||(this.body=b());if(r.nodeName){q.innerHTML="";q.appendChild(r);}else{q.innerHTML=r;}if(this._rendered){this._renderBody();}this.changeBodyEvent.fire(r);this.changeContentEvent.fire();},appendToBody:function(r){var q=this.body||(this.body=b());q.appendChild(r);this.changeBodyEvent.fire(r);this.changeContentEvent.fire();},setFooter:function(r){var q=this.footer||(this.footer=c());if(r.nodeName){q.innerHTML="";q.appendChild(r);}else{q.innerHTML=r;}if(this._rendered){this._renderFooter();}this.changeFooterEvent.fire(r);this.changeContentEvent.fire();},appendToFooter:function(r){var q=this.footer||(this.footer=c());q.appendChild(r);this.changeFooterEvent.fire(r);this.changeContentEvent.fire();},render:function(s,q){var t=this;function r(u){if(typeof u=="string"){u=document.getElementById(u);
}if(u){t._addToParent(u,t.element);t.appendEvent.fire();}}this.beforeRenderEvent.fire();if(!q){q=this.element;}if(s){r(s);}else{if(!f.inDocument(this.element)){return false;}}this._renderHeader(q);this._renderBody(q);this._renderFooter(q);this._rendered=true;this.renderEvent.fire();return true;},_renderHeader:function(q){q=q||this.element;if(this.header&&!f.inDocument(this.header)){var r=q.firstChild;if(r){q.insertBefore(this.header,r);}else{q.appendChild(this.header);}}},_renderBody:function(q){q=q||this.element;if(this.body&&!f.inDocument(this.body)){if(this.footer&&f.isAncestor(q,this.footer)){q.insertBefore(this.body,this.footer);}else{q.appendChild(this.body);}}},_renderFooter:function(q){q=q||this.element;if(this.footer&&!f.inDocument(this.footer)){q.appendChild(this.footer);}},destroy:function(q){var r,s=!(q);if(this.element){n.purgeElement(this.element,s);r=this.element.parentNode;}if(r){r.removeChild(this.element);}this.element=null;this.header=null;this.body=null;this.footer=null;g.textResizeEvent.unsubscribe(this.onDomResize,this);this.cfg.destroy();this.cfg=null;this.destroyEvent.fire();},show:function(){this.cfg.setProperty("visible",true);},hide:function(){this.cfg.setProperty("visible",false);},configVisible:function(r,q,s){var t=q[0];if(t){if(this.beforeShowEvent.fire()){f.setStyle(this.element,"display","block");this.showEvent.fire();}}else{if(this.beforeHideEvent.fire()){f.setStyle(this.element,"display","none");this.hideEvent.fire();}}},configEffect:function(r,q,s){this._cachedEffects=(this.cacheEffects)?this._createEffects(q[0]):null;},cacheEffects:true,_createEffects:function(t){var q=null,u,r,s;if(t){if(t instanceof Array){q=[];u=t.length;for(r=0;r<u;r++){s=t[r];if(s.effect){q[q.length]=s.effect(this,s.duration);}}}else{if(t.effect){q=[t.effect(this,t.duration)];}}}return q;},configMonitorResize:function(s,r,t){var q=r[0];if(q){this.initResizeMonitor();}else{g.textResizeEvent.unsubscribe(this.onDomResize,this,true);this.resizeMonitor=null;}},_addToParent:function(q,r){if(!this.cfg.getProperty("appendtodocumentbody")&&q===document.body&&q.firstChild){q.insertBefore(r,q.firstChild);}else{q.appendChild(r);}},toString:function(){return"Module "+this.id;}};YAHOO.lang.augmentProto(g,YAHOO.util.EventProvider);}());(function(){YAHOO.widget.Overlay=function(p,o){YAHOO.widget.Overlay.superclass.constructor.call(this,p,o);};var i=YAHOO.lang,m=YAHOO.util.CustomEvent,g=YAHOO.widget.Module,n=YAHOO.util.Event,f=YAHOO.util.Dom,d=YAHOO.util.Config,k=YAHOO.env.ua,b=YAHOO.widget.Overlay,h="subscribe",e="unsubscribe",c="contained",j,a={"BEFORE_MOVE":"beforeMove","MOVE":"move"},l={"X":{key:"x",validator:i.isNumber,suppressEvent:true,supercedes:["iframe"]},"Y":{key:"y",validator:i.isNumber,suppressEvent:true,supercedes:["iframe"]},"XY":{key:"xy",suppressEvent:true,supercedes:["iframe"]},"CONTEXT":{key:"context",suppressEvent:true,supercedes:["iframe"]},"FIXED_CENTER":{key:"fixedcenter",value:false,supercedes:["iframe","visible"]},"WIDTH":{key:"width",suppressEvent:true,supercedes:["context","fixedcenter","iframe"]},"HEIGHT":{key:"height",suppressEvent:true,supercedes:["context","fixedcenter","iframe"]},"AUTO_FILL_HEIGHT":{key:"autofillheight",supercedes:["height"],value:"body"},"ZINDEX":{key:"zindex",value:null},"CONSTRAIN_TO_VIEWPORT":{key:"constraintoviewport",value:false,validator:i.isBoolean,supercedes:["iframe","x","y","xy"]},"IFRAME":{key:"iframe",value:(k.ie==6?true:false),validator:i.isBoolean,supercedes:["zindex"]},"PREVENT_CONTEXT_OVERLAP":{key:"preventcontextoverlap",value:false,validator:i.isBoolean,supercedes:["constraintoviewport"]}};b.IFRAME_SRC="javascript:false;";b.IFRAME_OFFSET=3;b.VIEWPORT_OFFSET=10;b.TOP_LEFT="tl";b.TOP_RIGHT="tr";b.BOTTOM_LEFT="bl";b.BOTTOM_RIGHT="br";b.PREVENT_OVERLAP_X={"tltr":true,"blbr":true,"brbl":true,"trtl":true};b.PREVENT_OVERLAP_Y={"trbr":true,"tlbl":true,"bltl":true,"brtr":true};b.CSS_OVERLAY="yui-overlay";b.CSS_HIDDEN="yui-overlay-hidden";b.CSS_IFRAME="yui-overlay-iframe";b.STD_MOD_RE=/^\s*?(body|footer|header)\s*?$/i;b.windowScrollEvent=new m("windowScroll");b.windowResizeEvent=new m("windowResize");b.windowScrollHandler=function(p){var o=n.getTarget(p);if(!o||o===window||o===window.document){if(k.ie){if(!window.scrollEnd){window.scrollEnd=-1;}clearTimeout(window.scrollEnd);window.scrollEnd=setTimeout(function(){b.windowScrollEvent.fire();},1);}else{b.windowScrollEvent.fire();}}};b.windowResizeHandler=function(o){if(k.ie){if(!window.resizeEnd){window.resizeEnd=-1;}clearTimeout(window.resizeEnd);window.resizeEnd=setTimeout(function(){b.windowResizeEvent.fire();},100);}else{b.windowResizeEvent.fire();}};b._initialized=null;if(b._initialized===null){n.on(window,"scroll",b.windowScrollHandler);n.on(window,"resize",b.windowResizeHandler);b._initialized=true;}b._TRIGGER_MAP={"windowScroll":b.windowScrollEvent,"windowResize":b.windowResizeEvent,"textResize":g.textResizeEvent};YAHOO.extend(b,g,{CONTEXT_TRIGGERS:[],init:function(p,o){b.superclass.init.call(this,p);this.beforeInitEvent.fire(b);f.addClass(this.element,b.CSS_OVERLAY);if(o){this.cfg.applyConfig(o,true);}if(this.platform=="mac"&&k.gecko){if(!d.alreadySubscribed(this.showEvent,this.showMacGeckoScrollbars,this)){this.showEvent.subscribe(this.showMacGeckoScrollbars,this,true);}if(!d.alreadySubscribed(this.hideEvent,this.hideMacGeckoScrollbars,this)){this.hideEvent.subscribe(this.hideMacGeckoScrollbars,this,true);}}this.initEvent.fire(b);},initEvents:function(){b.superclass.initEvents.call(this);var o=m.LIST;this.beforeMoveEvent=this.createEvent(a.BEFORE_MOVE);this.beforeMoveEvent.signature=o;this.moveEvent=this.createEvent(a.MOVE);this.moveEvent.signature=o;},initDefaultConfig:function(){b.superclass.initDefaultConfig.call(this);var o=this.cfg;o.addProperty(l.X.key,{handler:this.configX,validator:l.X.validator,suppressEvent:l.X.suppressEvent,supercedes:l.X.supercedes});o.addProperty(l.Y.key,{handler:this.configY,validator:l.Y.validator,suppressEvent:l.Y.suppressEvent,supercedes:l.Y.supercedes});
o.addProperty(l.XY.key,{handler:this.configXY,suppressEvent:l.XY.suppressEvent,supercedes:l.XY.supercedes});o.addProperty(l.CONTEXT.key,{handler:this.configContext,suppressEvent:l.CONTEXT.suppressEvent,supercedes:l.CONTEXT.supercedes});o.addProperty(l.FIXED_CENTER.key,{handler:this.configFixedCenter,value:l.FIXED_CENTER.value,validator:l.FIXED_CENTER.validator,supercedes:l.FIXED_CENTER.supercedes});o.addProperty(l.WIDTH.key,{handler:this.configWidth,suppressEvent:l.WIDTH.suppressEvent,supercedes:l.WIDTH.supercedes});o.addProperty(l.HEIGHT.key,{handler:this.configHeight,suppressEvent:l.HEIGHT.suppressEvent,supercedes:l.HEIGHT.supercedes});o.addProperty(l.AUTO_FILL_HEIGHT.key,{handler:this.configAutoFillHeight,value:l.AUTO_FILL_HEIGHT.value,validator:this._validateAutoFill,supercedes:l.AUTO_FILL_HEIGHT.supercedes});o.addProperty(l.ZINDEX.key,{handler:this.configzIndex,value:l.ZINDEX.value});o.addProperty(l.CONSTRAIN_TO_VIEWPORT.key,{handler:this.configConstrainToViewport,value:l.CONSTRAIN_TO_VIEWPORT.value,validator:l.CONSTRAIN_TO_VIEWPORT.validator,supercedes:l.CONSTRAIN_TO_VIEWPORT.supercedes});o.addProperty(l.IFRAME.key,{handler:this.configIframe,value:l.IFRAME.value,validator:l.IFRAME.validator,supercedes:l.IFRAME.supercedes});o.addProperty(l.PREVENT_CONTEXT_OVERLAP.key,{value:l.PREVENT_CONTEXT_OVERLAP.value,validator:l.PREVENT_CONTEXT_OVERLAP.validator,supercedes:l.PREVENT_CONTEXT_OVERLAP.supercedes});},moveTo:function(o,p){this.cfg.setProperty("xy",[o,p]);},hideMacGeckoScrollbars:function(){f.replaceClass(this.element,"show-scrollbars","hide-scrollbars");},showMacGeckoScrollbars:function(){f.replaceClass(this.element,"hide-scrollbars","show-scrollbars");},_setDomVisibility:function(o){f.setStyle(this.element,"visibility",(o)?"visible":"hidden");var p=b.CSS_HIDDEN;if(o){f.removeClass(this.element,p);}else{f.addClass(this.element,p);}},configVisible:function(x,w,t){var p=w[0],B=f.getStyle(this.element,"visibility"),o=this._cachedEffects||this._createEffects(this.cfg.getProperty("effect")),A=(this.platform=="mac"&&k.gecko),y=d.alreadySubscribed,q,v,s,r,u,z;if(B=="inherit"){v=this.element.parentNode;while(v.nodeType!=9&&v.nodeType!=11){B=f.getStyle(v,"visibility");if(B!="inherit"){break;}v=v.parentNode;}if(B=="inherit"){B="visible";}}if(p){if(A){this.showMacGeckoScrollbars();}if(o){if(p){if(B!="visible"||B===""||this._fadingOut){if(this.beforeShowEvent.fire()){z=o.length;for(s=0;s<z;s++){q=o[s];if(s===0&&!y(q.animateInCompleteEvent,this.showEvent.fire,this.showEvent)){q.animateInCompleteEvent.subscribe(this.showEvent.fire,this.showEvent,true);}q.animateIn();}}}}}else{if(B!="visible"||B===""){if(this.beforeShowEvent.fire()){this._setDomVisibility(true);this.cfg.refireEvent("iframe");this.showEvent.fire();}}else{this._setDomVisibility(true);}}}else{if(A){this.hideMacGeckoScrollbars();}if(o){if(B=="visible"||this._fadingIn){if(this.beforeHideEvent.fire()){z=o.length;for(r=0;r<z;r++){u=o[r];if(r===0&&!y(u.animateOutCompleteEvent,this.hideEvent.fire,this.hideEvent)){u.animateOutCompleteEvent.subscribe(this.hideEvent.fire,this.hideEvent,true);}u.animateOut();}}}else{if(B===""){this._setDomVisibility(false);}}}else{if(B=="visible"||B===""){if(this.beforeHideEvent.fire()){this._setDomVisibility(false);this.hideEvent.fire();}}else{this._setDomVisibility(false);}}}},doCenterOnDOMEvent:function(){var o=this.cfg,p=o.getProperty("fixedcenter");if(o.getProperty("visible")){if(p&&(p!==c||this.fitsInViewport())){this.center();}}},fitsInViewport:function(){var s=b.VIEWPORT_OFFSET,q=this.element,t=q.offsetWidth,r=q.offsetHeight,o=f.getViewportWidth(),p=f.getViewportHeight();return((t+s<o)&&(r+s<p));},configFixedCenter:function(s,q,t){var u=q[0],p=d.alreadySubscribed,r=b.windowResizeEvent,o=b.windowScrollEvent;if(u){this.center();if(!p(this.beforeShowEvent,this.center)){this.beforeShowEvent.subscribe(this.center);}if(!p(r,this.doCenterOnDOMEvent,this)){r.subscribe(this.doCenterOnDOMEvent,this,true);}if(!p(o,this.doCenterOnDOMEvent,this)){o.subscribe(this.doCenterOnDOMEvent,this,true);}}else{this.beforeShowEvent.unsubscribe(this.center);r.unsubscribe(this.doCenterOnDOMEvent,this);o.unsubscribe(this.doCenterOnDOMEvent,this);}},configHeight:function(r,p,s){var o=p[0],q=this.element;f.setStyle(q,"height",o);this.cfg.refireEvent("iframe");},configAutoFillHeight:function(t,s,p){var v=s[0],q=this.cfg,u="autofillheight",w="height",r=q.getProperty(u),o=this._autoFillOnHeightChange;q.unsubscribeFromConfigEvent(w,o);g.textResizeEvent.unsubscribe(o);this.changeContentEvent.unsubscribe(o);if(r&&v!==r&&this[r]){f.setStyle(this[r],w,"");}if(v){v=i.trim(v.toLowerCase());q.subscribeToConfigEvent(w,o,this[v],this);g.textResizeEvent.subscribe(o,this[v],this);this.changeContentEvent.subscribe(o,this[v],this);q.setProperty(u,v,true);}},configWidth:function(r,o,s){var q=o[0],p=this.element;f.setStyle(p,"width",q);this.cfg.refireEvent("iframe");},configzIndex:function(q,o,r){var s=o[0],p=this.element;if(!s){s=f.getStyle(p,"zIndex");if(!s||isNaN(s)){s=0;}}if(this.iframe||this.cfg.getProperty("iframe")===true){if(s<=0){s=1;}}f.setStyle(p,"zIndex",s);this.cfg.setProperty("zIndex",s,true);if(this.iframe){this.stackIframe();}},configXY:function(q,p,r){var t=p[0],o=t[0],s=t[1];this.cfg.setProperty("x",o);this.cfg.setProperty("y",s);this.beforeMoveEvent.fire([o,s]);o=this.cfg.getProperty("x");s=this.cfg.getProperty("y");this.cfg.refireEvent("iframe");this.moveEvent.fire([o,s]);},configX:function(q,p,r){var o=p[0],s=this.cfg.getProperty("y");this.cfg.setProperty("x",o,true);this.cfg.setProperty("y",s,true);this.beforeMoveEvent.fire([o,s]);o=this.cfg.getProperty("x");s=this.cfg.getProperty("y");f.setX(this.element,o,true);this.cfg.setProperty("xy",[o,s],true);this.cfg.refireEvent("iframe");this.moveEvent.fire([o,s]);},configY:function(q,p,r){var o=this.cfg.getProperty("x"),s=p[0];this.cfg.setProperty("x",o,true);this.cfg.setProperty("y",s,true);this.beforeMoveEvent.fire([o,s]);o=this.cfg.getProperty("x");s=this.cfg.getProperty("y");f.setY(this.element,s,true);
this.cfg.setProperty("xy",[o,s],true);this.cfg.refireEvent("iframe");this.moveEvent.fire([o,s]);},showIframe:function(){var p=this.iframe,o;if(p){o=this.element.parentNode;if(o!=p.parentNode){this._addToParent(o,p);}p.style.display="block";}},hideIframe:function(){if(this.iframe){this.iframe.style.display="none";}},syncIframe:function(){var o=this.iframe,q=this.element,s=b.IFRAME_OFFSET,p=(s*2),r;if(o){o.style.width=(q.offsetWidth+p+"px");o.style.height=(q.offsetHeight+p+"px");r=this.cfg.getProperty("xy");if(!i.isArray(r)||(isNaN(r[0])||isNaN(r[1]))){this.syncPosition();r=this.cfg.getProperty("xy");}f.setXY(o,[(r[0]-s),(r[1]-s)]);}},stackIframe:function(){if(this.iframe){var o=f.getStyle(this.element,"zIndex");if(!YAHOO.lang.isUndefined(o)&&!isNaN(o)){f.setStyle(this.iframe,"zIndex",(o-1));}}},configIframe:function(r,q,s){var o=q[0];function t(){var v=this.iframe,w=this.element,x;if(!v){if(!j){j=document.createElement("iframe");if(this.isSecure){j.src=b.IFRAME_SRC;}if(k.ie){j.style.filter="alpha(opacity=0)";j.frameBorder=0;}else{j.style.opacity="0";}j.style.position="absolute";j.style.border="none";j.style.margin="0";j.style.padding="0";j.style.display="none";j.tabIndex=-1;j.className=b.CSS_IFRAME;}v=j.cloneNode(false);v.id=this.id+"_f";x=w.parentNode;var u=x||document.body;this._addToParent(u,v);this.iframe=v;}this.showIframe();this.syncIframe();this.stackIframe();if(!this._hasIframeEventListeners){this.showEvent.subscribe(this.showIframe);this.hideEvent.subscribe(this.hideIframe);this.changeContentEvent.subscribe(this.syncIframe);this._hasIframeEventListeners=true;}}function p(){t.call(this);this.beforeShowEvent.unsubscribe(p);this._iframeDeferred=false;}if(o){if(this.cfg.getProperty("visible")){t.call(this);}else{if(!this._iframeDeferred){this.beforeShowEvent.subscribe(p);this._iframeDeferred=true;}}}else{this.hideIframe();if(this._hasIframeEventListeners){this.showEvent.unsubscribe(this.showIframe);this.hideEvent.unsubscribe(this.hideIframe);this.changeContentEvent.unsubscribe(this.syncIframe);this._hasIframeEventListeners=false;}}},_primeXYFromDOM:function(){if(YAHOO.lang.isUndefined(this.cfg.getProperty("xy"))){this.syncPosition();this.cfg.refireEvent("xy");this.beforeShowEvent.unsubscribe(this._primeXYFromDOM);}},configConstrainToViewport:function(p,o,q){var r=o[0];if(r){if(!d.alreadySubscribed(this.beforeMoveEvent,this.enforceConstraints,this)){this.beforeMoveEvent.subscribe(this.enforceConstraints,this,true);}if(!d.alreadySubscribed(this.beforeShowEvent,this._primeXYFromDOM)){this.beforeShowEvent.subscribe(this._primeXYFromDOM);}}else{this.beforeShowEvent.unsubscribe(this._primeXYFromDOM);this.beforeMoveEvent.unsubscribe(this.enforceConstraints,this);}},configContext:function(u,t,q){var x=t[0],r,o,v,s,p,w=this.CONTEXT_TRIGGERS;if(x){r=x[0];o=x[1];v=x[2];s=x[3];p=x[4];if(w&&w.length>0){s=(s||[]).concat(w);}if(r){if(typeof r=="string"){this.cfg.setProperty("context",[document.getElementById(r),o,v,s,p],true);}if(o&&v){this.align(o,v,p);}if(this._contextTriggers){this._processTriggers(this._contextTriggers,e,this._alignOnTrigger);}if(s){this._processTriggers(s,h,this._alignOnTrigger);this._contextTriggers=s;}}}},_alignOnTrigger:function(p,o){this.align();},_findTriggerCE:function(o){var p=null;if(o instanceof m){p=o;}else{if(b._TRIGGER_MAP[o]){p=b._TRIGGER_MAP[o];}}return p;},_processTriggers:function(s,v,r){var q,u;for(var p=0,o=s.length;p<o;++p){q=s[p];u=this._findTriggerCE(q);if(u){u[v](r,this,true);}else{this[v](q,r);}}},align:function(p,w,s){var v=this.cfg.getProperty("context"),t=this,o,q,u;function r(z,A){var y=null,x=null;switch(p){case b.TOP_LEFT:y=A;x=z;break;case b.TOP_RIGHT:y=A-q.offsetWidth;x=z;break;case b.BOTTOM_LEFT:y=A;x=z-q.offsetHeight;break;case b.BOTTOM_RIGHT:y=A-q.offsetWidth;x=z-q.offsetHeight;break;}if(y!==null&&x!==null){if(s){y+=s[0];x+=s[1];}t.moveTo(y,x);}}if(v){o=v[0];q=this.element;t=this;if(!p){p=v[1];}if(!w){w=v[2];}if(!s&&v[4]){s=v[4];}if(q&&o){u=f.getRegion(o);switch(w){case b.TOP_LEFT:r(u.top,u.left);break;case b.TOP_RIGHT:r(u.top,u.right);break;case b.BOTTOM_LEFT:r(u.bottom,u.left);break;case b.BOTTOM_RIGHT:r(u.bottom,u.right);break;}}}},enforceConstraints:function(p,o,q){var s=o[0];var r=this.getConstrainedXY(s[0],s[1]);this.cfg.setProperty("x",r[0],true);this.cfg.setProperty("y",r[1],true);this.cfg.setProperty("xy",r,true);},_getConstrainedPos:function(y,p){var t=this.element,r=b.VIEWPORT_OFFSET,A=(y=="x"),z=(A)?t.offsetWidth:t.offsetHeight,s=(A)?f.getViewportWidth():f.getViewportHeight(),D=(A)?f.getDocumentScrollLeft():f.getDocumentScrollTop(),C=(A)?b.PREVENT_OVERLAP_X:b.PREVENT_OVERLAP_Y,o=this.cfg.getProperty("context"),u=(z+r<s),w=this.cfg.getProperty("preventcontextoverlap")&&o&&C[(o[1]+o[2])],v=D+r,B=D+s-z-r,q=p;if(p<v||p>B){if(w){q=this._preventOverlap(y,o[0],z,s,D);}else{if(u){if(p<v){q=v;}else{if(p>B){q=B;}}}else{q=v;}}}return q;},_preventOverlap:function(y,w,z,u,C){var A=(y=="x"),t=b.VIEWPORT_OFFSET,s=this,q=((A)?f.getX(w):f.getY(w))-C,o=(A)?w.offsetWidth:w.offsetHeight,p=q-t,r=(u-(q+o))-t,D=false,v=function(){var x;if((s.cfg.getProperty(y)-C)>q){x=(q-z);}else{x=(q+o);}s.cfg.setProperty(y,(x+C),true);return x;},B=function(){var E=((s.cfg.getProperty(y)-C)>q)?r:p,x;if(z>E){if(D){v();}else{v();D=true;x=B();}}return x;};B();return this.cfg.getProperty(y);},getConstrainedX:function(o){return this._getConstrainedPos("x",o);},getConstrainedY:function(o){return this._getConstrainedPos("y",o);},getConstrainedXY:function(o,p){return[this.getConstrainedX(o),this.getConstrainedY(p)];},center:function(){var r=b.VIEWPORT_OFFSET,s=this.element.offsetWidth,q=this.element.offsetHeight,p=f.getViewportWidth(),t=f.getViewportHeight(),o,u;if(s<p){o=(p/2)-(s/2)+f.getDocumentScrollLeft();}else{o=r+f.getDocumentScrollLeft();}if(q<t){u=(t/2)-(q/2)+f.getDocumentScrollTop();}else{u=r+f.getDocumentScrollTop();}this.cfg.setProperty("xy",[parseInt(o,10),parseInt(u,10)]);this.cfg.refireEvent("iframe");if(k.webkit){this.forceContainerRedraw();}},syncPosition:function(){var o=f.getXY(this.element);
this.cfg.setProperty("x",o[0],true);this.cfg.setProperty("y",o[1],true);this.cfg.setProperty("xy",o,true);},onDomResize:function(q,p){var o=this;b.superclass.onDomResize.call(this,q,p);setTimeout(function(){if (!o.cfg){return}o.syncPosition();o.cfg.refireEvent("iframe");o.cfg.refireEvent("context");},0);},_getComputedHeight:(function(){if(document.defaultView&&document.defaultView.getComputedStyle){return function(p){var o=null;if(p.ownerDocument&&p.ownerDocument.defaultView){var q=p.ownerDocument.defaultView.getComputedStyle(p,"");if(q){o=parseInt(q.height,10);}}return(i.isNumber(o))?o:null;};}else{return function(p){var o=null;if(p.style.pixelHeight){o=p.style.pixelHeight;}return(i.isNumber(o))?o:null;};}})(),_validateAutoFillHeight:function(o){return(!o)||(i.isString(o)&&b.STD_MOD_RE.test(o));},_autoFillOnHeightChange:function(r,p,q){var o=this.cfg.getProperty("height");if((o&&o!=="auto")||(o===0)){this.fillHeight(q);}},_getPreciseHeight:function(p){var o=p.offsetHeight;if(p.getBoundingClientRect){var q=p.getBoundingClientRect();o=q.bottom-q.top;}return o;},fillHeight:function(r){if(r){var p=this.innerElement||this.element,o=[this.header,this.body,this.footer],v,w=0,x=0,t=0,q=false;for(var u=0,s=o.length;u<s;u++){v=o[u];if(v){if(r!==v){x+=this._getPreciseHeight(v);}else{q=true;}}}if(q){if(k.ie||k.opera){f.setStyle(r,"height",0+"px");}w=this._getComputedHeight(p);if(w===null){f.addClass(p,"yui-override-padding");w=p.clientHeight;f.removeClass(p,"yui-override-padding");}t=Math.max(w-x,0);f.setStyle(r,"height",t+"px");if(r.offsetHeight!=t){t=Math.max(t-(r.offsetHeight-t),0);}f.setStyle(r,"height",t+"px");}}},bringToTop:function(){var s=[],r=this.element;function v(z,y){var B=f.getStyle(z,"zIndex"),A=f.getStyle(y,"zIndex"),x=(!B||isNaN(B))?0:parseInt(B,10),w=(!A||isNaN(A))?0:parseInt(A,10);if(x>w){return -1;}else{if(x<w){return 1;}else{return 0;}}}function q(y){var x=f.hasClass(y,b.CSS_OVERLAY),w=YAHOO.widget.Panel;if(x&&!f.isAncestor(r,y)){if(w&&f.hasClass(y,w.CSS_PANEL)){s[s.length]=y.parentNode;}else{s[s.length]=y;}}}f.getElementsBy(q,"div",document.body);s.sort(v);var o=s[0],u;if(o){u=f.getStyle(o,"zIndex");if(!isNaN(u)){var t=false;if(o!=r){t=true;}else{if(s.length>1){var p=f.getStyle(s[1],"zIndex");if(!isNaN(p)&&(u==p)){t=true;}}}if(t){this.cfg.setProperty("zindex",(parseInt(u,10)+2));}}}},destroy:function(o){if(this.iframe){this.iframe.parentNode.removeChild(this.iframe);}this.iframe=null;b.windowResizeEvent.unsubscribe(this.doCenterOnDOMEvent,this);b.windowScrollEvent.unsubscribe(this.doCenterOnDOMEvent,this);g.textResizeEvent.unsubscribe(this._autoFillOnHeightChange);if(this._contextTriggers){this._processTriggers(this._contextTriggers,e,this._alignOnTrigger);}b.superclass.destroy.call(this,o);},forceContainerRedraw:function(){var o=this;f.addClass(o.element,"yui-force-redraw");setTimeout(function(){f.removeClass(o.element,"yui-force-redraw");},0);},toString:function(){return"Overlay "+this.id;}});}());(function(){YAHOO.widget.OverlayManager=function(g){this.init(g);};var d=YAHOO.widget.Overlay,c=YAHOO.util.Event,e=YAHOO.util.Dom,b=YAHOO.util.Config,f=YAHOO.util.CustomEvent,a=YAHOO.widget.OverlayManager;a.CSS_FOCUSED="focused";a.prototype={constructor:a,overlays:null,initDefaultConfig:function(){this.cfg.addProperty("overlays",{suppressEvent:true});this.cfg.addProperty("focusevent",{value:"mousedown"});},init:function(i){this.cfg=new b(this);this.initDefaultConfig();if(i){this.cfg.applyConfig(i,true);}this.cfg.fireQueue();var h=null;this.getActive=function(){return h;};this.focus=function(j){var k=this.find(j);if(k){k.focus();}};this.remove=function(k){var m=this.find(k),j;if(m){if(h==m){h=null;}var l=(m.element===null&&m.cfg===null)?true:false;if(!l){j=e.getStyle(m.element,"zIndex");m.cfg.setProperty("zIndex",-1000,true);}this.overlays.sort(this.compareZIndexDesc);this.overlays=this.overlays.slice(0,(this.overlays.length-1));m.hideEvent.unsubscribe(m.blur);m.destroyEvent.unsubscribe(this._onOverlayDestroy,m);m.focusEvent.unsubscribe(this._onOverlayFocusHandler,m);m.blurEvent.unsubscribe(this._onOverlayBlurHandler,m);if(!l){c.removeListener(m.element,this.cfg.getProperty("focusevent"),this._onOverlayElementFocus);m.cfg.setProperty("zIndex",j,true);m.cfg.setProperty("manager",null);}if(m.focusEvent._managed){m.focusEvent=null;}if(m.blurEvent._managed){m.blurEvent=null;}if(m.focus._managed){m.focus=null;}if(m.blur._managed){m.blur=null;}}};this.blurAll=function(){var k=this.overlays.length,j;if(k>0){j=k-1;do{this.overlays[j].blur();}while(j--);}};this._manageBlur=function(j){var k=false;if(h==j){e.removeClass(h.element,a.CSS_FOCUSED);h=null;k=true;}return k;};this._manageFocus=function(j){var k=false;if(h!=j){if(h){h.blur();}h=j;this.bringToTop(h);e.addClass(h.element,a.CSS_FOCUSED);k=true;}return k;};var g=this.cfg.getProperty("overlays");if(!this.overlays){this.overlays=[];}if(g){this.register(g);this.overlays.sort(this.compareZIndexDesc);}},_onOverlayElementFocus:function(i){var g=c.getTarget(i),h=this.close;if(h&&(g==h||e.isAncestor(h,g))){this.blur();}else{this.focus();}},_onOverlayDestroy:function(h,g,i){this.remove(i);},_onOverlayFocusHandler:function(h,g,i){this._manageFocus(i);},_onOverlayBlurHandler:function(h,g,i){this._manageBlur(i);},_bindFocus:function(g){var h=this;if(!g.focusEvent){g.focusEvent=g.createEvent("focus");g.focusEvent.signature=f.LIST;g.focusEvent._managed=true;}else{g.focusEvent.subscribe(h._onOverlayFocusHandler,g,h);}if(!g.focus){c.on(g.element,h.cfg.getProperty("focusevent"),h._onOverlayElementFocus,null,g);g.focus=function(){if(h._manageFocus(this)){if(this.cfg.getProperty("visible")&&this.focusFirst){this.focusFirst();}this.focusEvent.fire();}};g.focus._managed=true;}},_bindBlur:function(g){var h=this;if(!g.blurEvent){g.blurEvent=g.createEvent("blur");g.blurEvent.signature=f.LIST;g.focusEvent._managed=true;}else{g.blurEvent.subscribe(h._onOverlayBlurHandler,g,h);}if(!g.blur){g.blur=function(){if(h._manageBlur(this)){this.blurEvent.fire();}};g.blur._managed=true;}g.hideEvent.subscribe(g.blur);
},_bindDestroy:function(g){var h=this;g.destroyEvent.subscribe(h._onOverlayDestroy,g,h);},_syncZIndex:function(g){var h=e.getStyle(g.element,"zIndex");if(!isNaN(h)){g.cfg.setProperty("zIndex",parseInt(h,10));}else{g.cfg.setProperty("zIndex",0);}},register:function(g){var k=false,h,j;if(g instanceof d){g.cfg.addProperty("manager",{value:this});this._bindFocus(g);this._bindBlur(g);this._bindDestroy(g);this._syncZIndex(g);this.overlays.push(g);this.bringToTop(g);k=true;}else{if(g instanceof Array){for(h=0,j=g.length;h<j;h++){k=this.register(g[h])||k;}}}return k;},bringToTop:function(m){var i=this.find(m),l,g,j;if(i){j=this.overlays;j.sort(this.compareZIndexDesc);g=j[0];if(g){l=e.getStyle(g.element,"zIndex");if(!isNaN(l)){var k=false;if(g!==i){k=true;}else{if(j.length>1){var h=e.getStyle(j[1].element,"zIndex");if(!isNaN(h)&&(l==h)){k=true;}}}if(k){i.cfg.setProperty("zindex",(parseInt(l,10)+2));}}j.sort(this.compareZIndexDesc);}}},find:function(g){var l=g instanceof d,j=this.overlays,p=j.length,k=null,m,h;if(l||typeof g=="string"){for(h=p-1;h>=0;h--){m=j[h];if((l&&(m===g))||(m.id==g)){k=m;break;}}}return k;},compareZIndexDesc:function(j,i){var h=(j.cfg)?j.cfg.getProperty("zIndex"):null,g=(i.cfg)?i.cfg.getProperty("zIndex"):null;if(h===null&&g===null){return 0;}else{if(h===null){return 1;}else{if(g===null){return -1;}else{if(h>g){return -1;}else{if(h<g){return 1;}else{return 0;}}}}}},showAll:function(){var h=this.overlays,j=h.length,g;for(g=j-1;g>=0;g--){h[g].show();}},hideAll:function(){var h=this.overlays,j=h.length,g;for(g=j-1;g>=0;g--){h[g].hide();}},toString:function(){return"OverlayManager";}};}());(function(){YAHOO.widget.ContainerEffect=function(e,h,g,d,f){if(!f){f=YAHOO.util.Anim;}this.overlay=e;this.attrIn=h;this.attrOut=g;this.targetElement=d||e.element;this.animClass=f;};var b=YAHOO.util.Dom,c=YAHOO.util.CustomEvent,a=YAHOO.widget.ContainerEffect;a.FADE=function(d,f){var g=YAHOO.util.Easing,i={attributes:{opacity:{from:0,to:1}},duration:f,method:g.easeIn},e={attributes:{opacity:{to:0}},duration:f,method:g.easeOut},h=new a(d,i,e,d.element);h.handleUnderlayStart=function(){var k=this.overlay.underlay;if(k&&YAHOO.env.ua.ie){var j=(k.filters&&k.filters.length>0);if(j){b.addClass(d.element,"yui-effect-fade");}}};h.handleUnderlayComplete=function(){var j=this.overlay.underlay;if(j&&YAHOO.env.ua.ie){b.removeClass(d.element,"yui-effect-fade");}};h.handleStartAnimateIn=function(k,j,l){l.overlay._fadingIn=true;b.addClass(l.overlay.element,"hide-select");if(!l.overlay.underlay){l.overlay.cfg.refireEvent("underlay");}l.handleUnderlayStart();l.overlay._setDomVisibility(true);b.setStyle(l.overlay.element,"opacity",0);};h.handleCompleteAnimateIn=function(k,j,l){l.overlay._fadingIn=false;b.removeClass(l.overlay.element,"hide-select");if(l.overlay.element.style.filter){l.overlay.element.style.filter=null;}l.handleUnderlayComplete();l.overlay.cfg.refireEvent("iframe");l.animateInCompleteEvent.fire();};h.handleStartAnimateOut=function(k,j,l){l.overlay._fadingOut=true;b.addClass(l.overlay.element,"hide-select");l.handleUnderlayStart();};h.handleCompleteAnimateOut=function(k,j,l){l.overlay._fadingOut=false;b.removeClass(l.overlay.element,"hide-select");if(l.overlay.element.style.filter){l.overlay.element.style.filter=null;}l.overlay._setDomVisibility(false);b.setStyle(l.overlay.element,"opacity",1);l.handleUnderlayComplete();l.overlay.cfg.refireEvent("iframe");l.animateOutCompleteEvent.fire();};h.init();return h;};a.SLIDE=function(f,d){var i=YAHOO.util.Easing,l=f.cfg.getProperty("x")||b.getX(f.element),k=f.cfg.getProperty("y")||b.getY(f.element),m=b.getClientWidth(),h=f.element.offsetWidth,j={attributes:{points:{to:[l,k]}},duration:d,method:i.easeIn},e={attributes:{points:{to:[(m+25),k]}},duration:d,method:i.easeOut},g=new a(f,j,e,f.element,YAHOO.util.Motion);g.handleStartAnimateIn=function(o,n,p){p.overlay.element.style.left=((-25)-h)+"px";p.overlay.element.style.top=k+"px";};g.handleTweenAnimateIn=function(q,p,r){var s=b.getXY(r.overlay.element),o=s[0],n=s[1];if(b.getStyle(r.overlay.element,"visibility")=="hidden"&&o<l){r.overlay._setDomVisibility(true);}r.overlay.cfg.setProperty("xy",[o,n],true);r.overlay.cfg.refireEvent("iframe");};g.handleCompleteAnimateIn=function(o,n,p){p.overlay.cfg.setProperty("xy",[l,k],true);p.startX=l;p.startY=k;p.overlay.cfg.refireEvent("iframe");p.animateInCompleteEvent.fire();};g.handleStartAnimateOut=function(o,n,r){var p=b.getViewportWidth(),s=b.getXY(r.overlay.element),q=s[1];r.animOut.attributes.points.to=[(p+25),q];};g.handleTweenAnimateOut=function(p,o,q){var s=b.getXY(q.overlay.element),n=s[0],r=s[1];q.overlay.cfg.setProperty("xy",[n,r],true);q.overlay.cfg.refireEvent("iframe");};g.handleCompleteAnimateOut=function(o,n,p){p.overlay._setDomVisibility(false);p.overlay.cfg.setProperty("xy",[l,k]);p.animateOutCompleteEvent.fire();};g.init();return g;};a.prototype={init:function(){this.beforeAnimateInEvent=this.createEvent("beforeAnimateIn");this.beforeAnimateInEvent.signature=c.LIST;this.beforeAnimateOutEvent=this.createEvent("beforeAnimateOut");this.beforeAnimateOutEvent.signature=c.LIST;this.animateInCompleteEvent=this.createEvent("animateInComplete");this.animateInCompleteEvent.signature=c.LIST;this.animateOutCompleteEvent=this.createEvent("animateOutComplete");this.animateOutCompleteEvent.signature=c.LIST;this.animIn=new this.animClass(this.targetElement,this.attrIn.attributes,this.attrIn.duration,this.attrIn.method);this.animIn.onStart.subscribe(this.handleStartAnimateIn,this);this.animIn.onTween.subscribe(this.handleTweenAnimateIn,this);this.animIn.onComplete.subscribe(this.handleCompleteAnimateIn,this);this.animOut=new this.animClass(this.targetElement,this.attrOut.attributes,this.attrOut.duration,this.attrOut.method);this.animOut.onStart.subscribe(this.handleStartAnimateOut,this);this.animOut.onTween.subscribe(this.handleTweenAnimateOut,this);this.animOut.onComplete.subscribe(this.handleCompleteAnimateOut,this);},animateIn:function(){this._stopAnims(this.lastFrameOnStop);
this.beforeAnimateInEvent.fire();this.animIn.animate();},animateOut:function(){this._stopAnims(this.lastFrameOnStop);this.beforeAnimateOutEvent.fire();this.animOut.animate();},lastFrameOnStop:true,_stopAnims:function(d){if(this.animOut&&this.animOut.isAnimated()){this.animOut.stop(d);}if(this.animIn&&this.animIn.isAnimated()){this.animIn.stop(d);}},handleStartAnimateIn:function(e,d,f){},handleTweenAnimateIn:function(e,d,f){},handleCompleteAnimateIn:function(e,d,f){},handleStartAnimateOut:function(e,d,f){},handleTweenAnimateOut:function(e,d,f){},handleCompleteAnimateOut:function(e,d,f){},toString:function(){var d="ContainerEffect";if(this.overlay){d+=" ["+this.overlay.toString()+"]";}return d;}};YAHOO.lang.augmentProto(a,YAHOO.util.EventProvider);})();YAHOO.register("containercore",YAHOO.widget.Module,{version:"2.9.0",build:"2800"});
/*
Copyright (c) 2011, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.com/yui/license.html
version: 2.9.0
*/
(function(){var K=YAHOO.env.ua,C=YAHOO.util.Dom,Z=YAHOO.util.Event,H=YAHOO.lang,T="DIV",P="hd",M="bd",O="ft",X="LI",A="disabled",D="mouseover",F="mouseout",U="mousedown",G="mouseup",V="click",B="keydown",N="keyup",I="keypress",L="clicktohide",S="position",Q="dynamic",Y="showdelay",J="selected",E="visible",W="UL",R="MenuManager";YAHOO.widget.MenuManager=function(){var l=false,d={},o={},h={},c={"click":"clickEvent","mousedown":"mouseDownEvent","mouseup":"mouseUpEvent","mouseover":"mouseOverEvent","mouseout":"mouseOutEvent","keydown":"keyDownEvent","keyup":"keyUpEvent","keypress":"keyPressEvent","focus":"focusEvent","focusin":"focusEvent","blur":"blurEvent","focusout":"blurEvent"},i=null;function b(r){var p,q;if(r&&r.tagName){switch(r.tagName.toUpperCase()){case T:p=r.parentNode;if((C.hasClass(r,P)||C.hasClass(r,M)||C.hasClass(r,O))&&p&&p.tagName&&p.tagName.toUpperCase()==T){q=p;}else{q=r;}break;case X:q=r;break;default:p=r.parentNode;if(p){q=b(p);}break;}}return q;}function e(t){var p=Z.getTarget(t),q=b(p),u=true,w=t.type,x,r,s,z,y;if(q){r=q.tagName.toUpperCase();if(r==X){s=q.id;if(s&&h[s]){z=h[s];y=z.parent;}}else{if(r==T){if(q.id){y=d[q.id];}}}}if(y){x=c[w];if(w=="click"&&(K.gecko&&y.platform!="mac")&&t.button>0){u=false;}if(u&&z&&!z.cfg.getProperty(A)){z[x].fire(t);}if(u){y[x].fire(t,z);}}else{if(w==U){for(var v in o){if(H.hasOwnProperty(o,v)){y=o[v];if(y.cfg.getProperty(L)&&!(y instanceof YAHOO.widget.MenuBar)&&y.cfg.getProperty(S)==Q){y.hide();if(K.ie&&p.focus&&(K.ie<9)){p.setActive();}}else{if(y.cfg.getProperty(Y)>0){y._cancelShowDelay();}if(y.activeItem){y.activeItem.blur();y.activeItem.cfg.setProperty(J,false);y.activeItem=null;}}}}}}}function n(q,p,r){if(d[r.id]){this.removeMenu(r);}}function k(q,p){var r=p[1];if(r){i=r;}}function f(q,p){i=null;}function a(r,q){var p=q[0],s=this.id;if(p){o[s]=this;}else{if(o[s]){delete o[s];}}}function j(q,p){m(this);}function m(q){var p=q.id;if(p&&h[p]){if(i==q){i=null;}delete h[p];q.destroyEvent.unsubscribe(j);}}function g(q,p){var s=p[0],r;if(s instanceof YAHOO.widget.MenuItem){r=s.id;if(!h[r]){h[r]=s;s.destroyEvent.subscribe(j);}}}return{addMenu:function(q){var p;if(q instanceof YAHOO.widget.Menu&&q.id&&!d[q.id]){d[q.id]=q;if(!l){p=document;Z.on(p,D,e,this,true);Z.on(p,F,e,this,true);Z.on(p,U,e,this,true);Z.on(p,G,e,this,true);Z.on(p,V,e,this,true);Z.on(p,B,e,this,true);Z.on(p,N,e,this,true);Z.on(p,I,e,this,true);Z.onFocus(p,e,this,true);Z.onBlur(p,e,this,true);l=true;}q.cfg.subscribeToConfigEvent(E,a);q.destroyEvent.subscribe(n,q,this);q.itemAddedEvent.subscribe(g);q.focusEvent.subscribe(k);q.blurEvent.subscribe(f);}},removeMenu:function(s){var q,p,r;if(s){q=s.id;if((q in d)&&(d[q]==s)){p=s.getItems();if(p&&p.length>0){r=p.length-1;do{m(p[r]);}while(r--);}delete d[q];if((q in o)&&(o[q]==s)){delete o[q];}if(s.cfg){s.cfg.unsubscribeFromConfigEvent(E,a);}s.destroyEvent.unsubscribe(n,s);s.itemAddedEvent.unsubscribe(g);s.focusEvent.unsubscribe(k);s.blurEvent.unsubscribe(f);}}},hideVisible:function(){var p;for(var q in o){if(H.hasOwnProperty(o,q)){p=o[q];if(!(p instanceof YAHOO.widget.MenuBar)&&p.cfg.getProperty(S)==Q){p.hide();}}}},getVisible:function(){return o;},getMenus:function(){return d;},getMenu:function(q){var p;if(q in d){p=d[q];}return p;},getMenuItem:function(q){var p;if(q in h){p=h[q];}return p;},getMenuItemGroup:function(t){var q=C.get(t),p,v,u,r,s;if(q&&q.tagName&&q.tagName.toUpperCase()==W){v=q.firstChild;if(v){p=[];do{r=v.id;if(r){u=this.getMenuItem(r);if(u){p[p.length]=u;}}}while((v=v.nextSibling));if(p.length>0){s=p;}}}return s;},getFocusedMenuItem:function(){return i;},getFocusedMenu:function(){var p;if(i){p=i.parent.getRoot();}return p;},toString:function(){return R;}};}();})();(function(){var AM=YAHOO.lang,Aq="Menu",G="DIV",K="div",Am="id",AH="SELECT",e="xy",R="y",Ax="UL",L="ul",AJ="first-of-type",k="LI",h="OPTGROUP",Az="OPTION",Ah="disabled",AY="none",y="selected",At="groupindex",i="index",O="submenu",Au="visible",AX="hidedelay",Ac="position",AD="dynamic",C="static",An=AD+","+C,Q="url",M="#",V="target",AU="maxheight",T="topscrollbar",x="bottomscrollbar",d="_",P=T+d+Ah,E=x+d+Ah,b="mousemove",Av="showdelay",c="submenuhidedelay",AF="iframe",w="constraintoviewport",A4="preventcontextoverlap",AO="submenualignment",Z="autosubmenudisplay",AC="clicktohide",g="container",j="scrollincrement",Aj="minscrollheight",A2="classname",Ag="shadow",Ar="keepopen",A0="hd",D="hastitle",p="context",u="",Ak="mousedown",Ae="keydown",Ao="height",U="width",AQ="px",Ay="effect",AE="monitorresize",AW="display",AV="block",J="visibility",z="absolute",AS="zindex",l="yui-menu-body-scrolled",AK="&#32;",A1=" ",Ai="mouseover",H="mouseout",AR="itemAdded",n="itemRemoved",AL="hidden",s="yui-menu-shadow",AG=s+"-visible",m=s+A1+AG;YAHOO.widget.Menu=function(A6,A5){if(A5){this.parent=A5.parent;this.lazyLoad=A5.lazyLoad||A5.lazyload;this.itemData=A5.itemData||A5.itemdata;}YAHOO.widget.Menu.superclass.constructor.call(this,A6,A5);};function B(A6){var A5=false;if(AM.isString(A6)){A5=(An.indexOf((A6.toLowerCase()))!=-1);}return A5;}var f=YAHOO.util.Dom,AA=YAHOO.util.Event,Aw=YAHOO.widget.Module,AB=YAHOO.widget.Overlay,r=YAHOO.widget.Menu,A3=YAHOO.widget.MenuManager,F=YAHOO.util.CustomEvent,As=YAHOO.env.ua,Ap,AT=false,Ad,Ab=[["mouseOverEvent",Ai],["mouseOutEvent",H],["mouseDownEvent",Ak],["mouseUpEvent","mouseup"],["clickEvent","click"],["keyPressEvent","keypress"],["keyDownEvent",Ae],["keyUpEvent","keyup"],["focusEvent","focus"],["blurEvent","blur"],["itemAddedEvent",AR],["itemRemovedEvent",n]],AZ={key:Au,value:false,validator:AM.isBoolean},AP={key:w,value:true,validator:AM.isBoolean,supercedes:[AF,"x",R,e]},AI={key:A4,value:true,validator:AM.isBoolean,supercedes:[w]},S={key:Ac,value:AD,validator:B,supercedes:[Au,AF]},A={key:AO,value:["tl","tr"]},t={key:Z,value:true,validator:AM.isBoolean,suppressEvent:true},Y={key:Av,value:250,validator:AM.isNumber,suppressEvent:true},q={key:AX,value:0,validator:AM.isNumber,suppressEvent:true},v={key:c,value:250,validator:AM.isNumber,suppressEvent:true},o={key:AC,value:true,validator:AM.isBoolean,suppressEvent:true},AN={key:g,suppressEvent:true},Af={key:j,value:1,validator:AM.isNumber,supercedes:[AU],suppressEvent:true},N={key:Aj,value:90,validator:AM.isNumber,supercedes:[AU],suppressEvent:true},X={key:AU,value:0,validator:AM.isNumber,supercedes:[AF],suppressEvent:true},W={key:A2,value:null,validator:AM.isString,suppressEvent:true},a={key:Ah,value:false,validator:AM.isBoolean,suppressEvent:true},I={key:Ag,value:true,validator:AM.isBoolean,suppressEvent:true,supercedes:[Au]},Al={key:Ar,value:false,validator:AM.isBoolean};
function Aa(A5){Ad=AA.getTarget(A5);}YAHOO.lang.extend(r,AB,{CSS_CLASS_NAME:"yuimenu",ITEM_TYPE:null,GROUP_TITLE_TAG_NAME:"h6",OFF_SCREEN_POSITION:"-999em",_useHideDelay:false,_bHandledMouseOverEvent:false,_bHandledMouseOutEvent:false,_aGroupTitleElements:null,_aItemGroups:null,_aListElements:null,_nCurrentMouseX:0,_bStopMouseEventHandlers:false,_sClassName:null,lazyLoad:false,itemData:null,activeItem:null,parent:null,srcElement:null,init:function(A7,A6){this._aItemGroups=[];this._aListElements=[];this._aGroupTitleElements=[];if(!this.ITEM_TYPE){this.ITEM_TYPE=YAHOO.widget.MenuItem;}var A5;if(AM.isString(A7)){A5=f.get(A7);}else{if(A7.tagName){A5=A7;}}if(A5&&A5.tagName){switch(A5.tagName.toUpperCase()){case G:this.srcElement=A5;if(!A5.id){A5.setAttribute(Am,f.generateId());}r.superclass.init.call(this,A5);this.beforeInitEvent.fire(r);break;case AH:this.srcElement=A5;r.superclass.init.call(this,f.generateId());this.beforeInitEvent.fire(r);break;}}else{r.superclass.init.call(this,A7);this.beforeInitEvent.fire(r);}if(this.element){f.addClass(this.element,this.CSS_CLASS_NAME);this.initEvent.subscribe(this._onInit);this.beforeRenderEvent.subscribe(this._onBeforeRender);this.renderEvent.subscribe(this._onRender);this.beforeShowEvent.subscribe(this._onBeforeShow);this.hideEvent.subscribe(this._onHide);this.showEvent.subscribe(this._onShow);this.beforeHideEvent.subscribe(this._onBeforeHide);this.mouseOverEvent.subscribe(this._onMouseOver);this.mouseOutEvent.subscribe(this._onMouseOut);this.clickEvent.subscribe(this._onClick);this.keyDownEvent.subscribe(this._onKeyDown);this.keyPressEvent.subscribe(this._onKeyPress);this.blurEvent.subscribe(this._onBlur);if(!AT){AA.onFocus(document,Aa);AT=true;}if((As.gecko&&As.gecko<1.9)||(As.webkit&&As.webkit<523)){this.cfg.subscribeToConfigEvent(R,this._onYChange);}if(A6){this.cfg.applyConfig(A6,true);}A3.addMenu(this);this.initEvent.fire(r);}},_initSubTree:function(){var A6=this.srcElement,A5,A8,BB,BC,BA,A9,A7;if(A6){A5=(A6.tagName&&A6.tagName.toUpperCase());if(A5==G){BC=this.body&&this.body.firstChild;if(BC){A8=0;BB=this.GROUP_TITLE_TAG_NAME.toUpperCase();do{if(BC&&BC.tagName){switch(BC.tagName.toUpperCase()){case BB:this._aGroupTitleElements[A8]=BC;break;case Ax:this._aListElements[A8]=BC;this._aItemGroups[A8]=[];A8++;break;}}}while((BC=BC.nextSibling));if(this._aListElements[0]){f.addClass(this._aListElements[0],AJ);}}}BC=null;if(A5){switch(A5){case G:BA=this._aListElements;A9=BA.length;if(A9>0){A7=A9-1;do{BC=BA[A7].firstChild;if(BC){do{if(BC&&BC.tagName&&BC.tagName.toUpperCase()==k){this.addItem(new this.ITEM_TYPE(BC,{parent:this}),A7);}}while((BC=BC.nextSibling));}}while(A7--);}break;case AH:BC=A6.firstChild;do{if(BC&&BC.tagName){switch(BC.tagName.toUpperCase()){case h:case Az:this.addItem(new this.ITEM_TYPE(BC,{parent:this}));break;}}}while((BC=BC.nextSibling));break;}}}},_getFirstEnabledItem:function(){var A5=this.getItems(),A9=A5.length,A8,A7;for(var A6=0;A6<A9;A6++){A8=A5[A6];if(A8&&!A8.cfg.getProperty(Ah)&&A8.element.style.display!=AY){A7=A8;break;}}return A7;},_addItemToGroup:function(BA,BB,BF){var BD,BG,A8,BE,A9,A6,A7,BC;function A5(BH,BI){return(BH[BI]||A5(BH,(BI+1)));}if(BB instanceof this.ITEM_TYPE){BD=BB;BD.parent=this;}else{if(AM.isString(BB)){BD=new this.ITEM_TYPE(BB,{parent:this});}else{if(AM.isObject(BB)){BB.parent=this;BD=new this.ITEM_TYPE(BB.text,BB);}}}if(BD){if(BD.cfg.getProperty(y)){this.activeItem=BD;}BG=AM.isNumber(BA)?BA:0;A8=this._getItemGroup(BG);if(!A8){A8=this._createItemGroup(BG);}if(AM.isNumber(BF)){A9=(BF>=A8.length);if(A8[BF]){A8.splice(BF,0,BD);}else{A8[BF]=BD;}BE=A8[BF];if(BE){if(A9&&(!BE.element.parentNode||BE.element.parentNode.nodeType==11)){this._aListElements[BG].appendChild(BE.element);}else{A6=A5(A8,(BF+1));if(A6&&(!BE.element.parentNode||BE.element.parentNode.nodeType==11)){this._aListElements[BG].insertBefore(BE.element,A6.element);}}BE.parent=this;this._subscribeToItemEvents(BE);this._configureSubmenu(BE);this._updateItemProperties(BG);this.itemAddedEvent.fire(BE);this.changeContentEvent.fire();BC=BE;}}else{A7=A8.length;A8[A7]=BD;BE=A8[A7];if(BE){if(!f.isAncestor(this._aListElements[BG],BE.element)){this._aListElements[BG].appendChild(BE.element);}BE.element.setAttribute(At,BG);BE.element.setAttribute(i,A7);BE.parent=this;BE.index=A7;BE.groupIndex=BG;this._subscribeToItemEvents(BE);this._configureSubmenu(BE);if(A7===0){f.addClass(BE.element,AJ);}this.itemAddedEvent.fire(BE);this.changeContentEvent.fire();BC=BE;}}}return BC;},_removeItemFromGroupByIndex:function(A8,A6){var A7=AM.isNumber(A8)?A8:0,A9=this._getItemGroup(A7),BB,BA,A5;if(A9){BB=A9.splice(A6,1);BA=BB[0];if(BA){this._updateItemProperties(A7);if(A9.length===0){A5=this._aListElements[A7];if(A5&&A5.parentNode){A5.parentNode.removeChild(A5);}this._aItemGroups.splice(A7,1);this._aListElements.splice(A7,1);A5=this._aListElements[0];if(A5){f.addClass(A5,AJ);}}this.itemRemovedEvent.fire(BA);this.changeContentEvent.fire();}}return BA;},_removeItemFromGroupByValue:function(A8,A5){var BA=this._getItemGroup(A8),BB,A9,A7,A6;if(BA){BB=BA.length;A9=-1;if(BB>0){A6=BB-1;do{if(BA[A6]==A5){A9=A6;break;}}while(A6--);if(A9>-1){A7=this._removeItemFromGroupByIndex(A8,A9);}}}return A7;},_updateItemProperties:function(A6){var A7=this._getItemGroup(A6),BA=A7.length,A9,A8,A5;if(BA>0){A5=BA-1;do{A9=A7[A5];if(A9){A8=A9.element;A9.index=A5;A9.groupIndex=A6;A8.setAttribute(At,A6);A8.setAttribute(i,A5);f.removeClass(A8,AJ);}}while(A5--);if(A8){f.addClass(A8,AJ);}}},_createItemGroup:function(A7){var A5,A6;if(!this._aItemGroups[A7]){this._aItemGroups[A7]=[];A5=document.createElement(L);this._aListElements[A7]=A5;A6=this._aItemGroups[A7];}return A6;},_getItemGroup:function(A7){var A5=AM.isNumber(A7)?A7:0,A8=this._aItemGroups,A6;if(A5 in A8){A6=A8[A5];}return A6;},_configureSubmenu:function(A5){var A6=A5.cfg.getProperty(O);if(A6){this.cfg.configChangedEvent.subscribe(this._onParentMenuConfigChange,A6,true);this.renderEvent.subscribe(this._onParentMenuRender,A6,true);}},_subscribeToItemEvents:function(A5){A5.destroyEvent.subscribe(this._onMenuItemDestroy,A5,this);
A5.cfg.configChangedEvent.subscribe(this._onMenuItemConfigChange,A5,this);},_onVisibleChange:function(A7,A6){var A5=A6[0];if(A5){f.addClass(this.element,Au);}else{f.removeClass(this.element,Au);}},_cancelHideDelay:function(){var A5=this.getRoot()._hideDelayTimer;if(A5){A5.cancel();}},_execHideDelay:function(){this._cancelHideDelay();var A5=this.getRoot();A5._hideDelayTimer=AM.later(A5.cfg.getProperty(AX),this,function(){if(A5.activeItem){if(A5.hasFocus()){A5.activeItem.focus();}A5.clearActiveItem();}if(A5==this&&!(this instanceof YAHOO.widget.MenuBar)&&this.cfg.getProperty(Ac)==AD){this.hide();}});},_cancelShowDelay:function(){var A5=this.getRoot()._showDelayTimer;if(A5){A5.cancel();}},_execSubmenuHideDelay:function(A7,A6,A5){A7._submenuHideDelayTimer=AM.later(50,this,function(){if(this._nCurrentMouseX>(A6+10)){A7._submenuHideDelayTimer=AM.later(A5,A7,function(){this.hide();});}else{A7.hide();}});},_disableScrollHeader:function(){if(!this._bHeaderDisabled){f.addClass(this.header,P);this._bHeaderDisabled=true;}},_disableScrollFooter:function(){if(!this._bFooterDisabled){f.addClass(this.footer,E);this._bFooterDisabled=true;}},_enableScrollHeader:function(){if(this._bHeaderDisabled){f.removeClass(this.header,P);this._bHeaderDisabled=false;}},_enableScrollFooter:function(){if(this._bFooterDisabled){f.removeClass(this.footer,E);this._bFooterDisabled=false;}},_onMouseOver:function(BH,BA){var BI=BA[0],BE=BA[1],A5=AA.getTarget(BI),A9=this.getRoot(),BG=this._submenuHideDelayTimer,A6,A8,BD,A7,BC,BB;var BF=function(){if(this.parent.cfg.getProperty(y)){this.show();}};if(!this._bStopMouseEventHandlers){if(!this._bHandledMouseOverEvent&&(A5==this.element||f.isAncestor(this.element,A5))){if(this._useHideDelay){this._cancelHideDelay();}this._nCurrentMouseX=0;AA.on(this.element,b,this._onMouseMove,this,true);if(!(BE&&f.isAncestor(BE.element,AA.getRelatedTarget(BI)))){this.clearActiveItem();}if(this.parent&&BG){BG.cancel();this.parent.cfg.setProperty(y,true);A6=this.parent.parent;A6._bHandledMouseOutEvent=true;A6._bHandledMouseOverEvent=false;}this._bHandledMouseOverEvent=true;this._bHandledMouseOutEvent=false;}if(BE&&!BE.handledMouseOverEvent&&!BE.cfg.getProperty(Ah)&&(A5==BE.element||f.isAncestor(BE.element,A5))){A8=this.cfg.getProperty(Av);BD=(A8>0);if(BD){this._cancelShowDelay();}A7=this.activeItem;if(A7){A7.cfg.setProperty(y,false);}BC=BE.cfg;BC.setProperty(y,true);if(this.hasFocus()||A9._hasFocus){BE.focus();A9._hasFocus=false;}if(this.cfg.getProperty(Z)){BB=BC.getProperty(O);if(BB){if(BD){A9._showDelayTimer=AM.later(A9.cfg.getProperty(Av),BB,BF);}else{BB.show();}}}BE.handledMouseOverEvent=true;BE.handledMouseOutEvent=false;}}},_onMouseOut:function(BD,A7){var BE=A7[0],BB=A7[1],A8=AA.getRelatedTarget(BE),BC=false,BA,A9,A5,A6;if(!this._bStopMouseEventHandlers){if(BB&&!BB.cfg.getProperty(Ah)){BA=BB.cfg;A9=BA.getProperty(O);if(A9&&(A8==A9.element||f.isAncestor(A9.element,A8))){BC=true;}if(!BB.handledMouseOutEvent&&((A8!=BB.element&&!f.isAncestor(BB.element,A8))||BC)){if(!BC){BB.cfg.setProperty(y,false);if(A9){A5=this.cfg.getProperty(c);A6=this.cfg.getProperty(Av);if(!(this instanceof YAHOO.widget.MenuBar)&&A5>0&&A5>=A6){this._execSubmenuHideDelay(A9,AA.getPageX(BE),A5);}else{A9.hide();}}}BB.handledMouseOutEvent=true;BB.handledMouseOverEvent=false;}}if(!this._bHandledMouseOutEvent){if(this._didMouseLeave(A8)||BC){if(this._useHideDelay){this._execHideDelay();}AA.removeListener(this.element,b,this._onMouseMove);this._nCurrentMouseX=AA.getPageX(BE);this._bHandledMouseOutEvent=true;this._bHandledMouseOverEvent=false;}}}},_didMouseLeave:function(A5){return(A5===this._shadow||(A5!=this.element&&!f.isAncestor(this.element,A5)));},_onMouseMove:function(A6,A5){if(!this._bStopMouseEventHandlers){this._nCurrentMouseX=AA.getPageX(A6);}},_onClick:function(BG,A7){var BH=A7[0],BB=A7[1],BD=false,A9,BE,A6,A5,BA,BC,BF;var A8=function(){A6=this.getRoot();if(A6 instanceof YAHOO.widget.MenuBar||A6.cfg.getProperty(Ac)==C){A6.clearActiveItem();}else{A6.hide();}};if(BB){if(BB.cfg.getProperty(Ah)){AA.preventDefault(BH);A8.call(this);}else{A9=BB.cfg.getProperty(O);BA=BB.cfg.getProperty(Q);if(BA){BC=BA.indexOf(M);BF=BA.length;if(BC!=-1){BA=BA.substr(BC,BF);BF=BA.length;if(BF>1){A5=BA.substr(1,BF);BE=YAHOO.widget.MenuManager.getMenu(A5);if(BE){BD=(this.getRoot()===BE.getRoot());}}else{if(BF===1){BD=true;}}}}if(BD&&!BB.cfg.getProperty(V)){AA.preventDefault(BH);if(As.webkit){BB.focus();}else{BB.focusEvent.fire();}}if(!A9&&!this.cfg.getProperty(Ar)){A8.call(this);}}}},_stopMouseEventHandlers:function(){this._bStopMouseEventHandlers=true;AM.later(10,this,function(){this._bStopMouseEventHandlers=false;});},_onKeyDown:function(BJ,BD){var BG=BD[0],BF=BD[1],BC,BH,A6,A9,BK,A5,BN,A8,BI,A7,BE,BM,BA,BB;if(this._useHideDelay){this._cancelHideDelay();}if(BF&&!BF.cfg.getProperty(Ah)){BH=BF.cfg;A6=this.parent;switch(BG.keyCode){case 38:case 40:BK=(BG.keyCode==38)?BF.getPreviousEnabledSibling():BF.getNextEnabledSibling();if(BK){this.clearActiveItem();BK.cfg.setProperty(y,true);BK.focus();if(this.cfg.getProperty(AU)>0||f.hasClass(this.body,l)){A5=this.body;BN=A5.scrollTop;A8=A5.offsetHeight;BI=this.getItems();A7=BI.length-1;BE=BK.element.offsetTop;if(BG.keyCode==40){if(BE>=(A8+BN)){A5.scrollTop=BE-A8;}else{if(BE<=BN){A5.scrollTop=0;}}if(BK==BI[A7]){A5.scrollTop=BK.element.offsetTop;}}else{if(BE<=BN){A5.scrollTop=BE-BK.element.offsetHeight;}else{if(BE>=(BN+A8)){A5.scrollTop=BE;}}if(BK==BI[0]){A5.scrollTop=0;}}BN=A5.scrollTop;BM=A5.scrollHeight-A5.offsetHeight;if(BN===0){this._disableScrollHeader();this._enableScrollFooter();}else{if(BN==BM){this._enableScrollHeader();this._disableScrollFooter();}else{this._enableScrollHeader();this._enableScrollFooter();}}}}AA.preventDefault(BG);this._stopMouseEventHandlers();break;case 39:BC=BH.getProperty(O);if(BC){if(!BH.getProperty(y)){BH.setProperty(y,true);}BC.show();BC.setInitialFocus();BC.setInitialSelection();}else{A9=this.getRoot();if(A9 instanceof YAHOO.widget.MenuBar){BK=A9.activeItem.getNextEnabledSibling();
if(BK){A9.clearActiveItem();BK.cfg.setProperty(y,true);BC=BK.cfg.getProperty(O);if(BC){BC.show();BC.setInitialFocus();}else{BK.focus();}}}}AA.preventDefault(BG);this._stopMouseEventHandlers();break;case 37:if(A6){BA=A6.parent;if(BA instanceof YAHOO.widget.MenuBar){BK=BA.activeItem.getPreviousEnabledSibling();if(BK){BA.clearActiveItem();BK.cfg.setProperty(y,true);BC=BK.cfg.getProperty(O);if(BC){BC.show();BC.setInitialFocus();}else{BK.focus();}}}else{this.hide();A6.focus();}}AA.preventDefault(BG);this._stopMouseEventHandlers();break;}}if(BG.keyCode==27){if(this.cfg.getProperty(Ac)==AD){this.hide();if(this.parent){this.parent.focus();}else{BB=this._focusedElement;if(BB&&BB.focus){try{BB.focus();}catch(BL){}}}}else{if(this.activeItem){BC=this.activeItem.cfg.getProperty(O);if(BC&&BC.cfg.getProperty(Au)){BC.hide();this.activeItem.focus();}else{this.activeItem.blur();this.activeItem.cfg.setProperty(y,false);}}}AA.preventDefault(BG);}},_onKeyPress:function(A7,A6){var A5=A6[0];if(A5.keyCode==40||A5.keyCode==38){AA.preventDefault(A5);}},_onBlur:function(A6,A5){if(this._hasFocus){this._hasFocus=false;}},_onYChange:function(A6,A5){var A8=this.parent,BA,A7,A9;if(A8){BA=A8.parent.body.scrollTop;if(BA>0){A9=(this.cfg.getProperty(R)-BA);f.setY(this.element,A9);A7=this.iframe;if(A7){f.setY(A7,A9);}this.cfg.setProperty(R,A9,true);}}},_onScrollTargetMouseOver:function(BB,BE){var BD=this._bodyScrollTimer;if(BD){BD.cancel();}this._cancelHideDelay();var A7=AA.getTarget(BB),A9=this.body,A8=this.cfg.getProperty(j),A5,A6;function BC(){var BF=A9.scrollTop;if(BF<A5){A9.scrollTop=(BF+A8);this._enableScrollHeader();}else{A9.scrollTop=A5;this._bodyScrollTimer.cancel();this._disableScrollFooter();}}function BA(){var BF=A9.scrollTop;if(BF>0){A9.scrollTop=(BF-A8);this._enableScrollFooter();}else{A9.scrollTop=0;this._bodyScrollTimer.cancel();this._disableScrollHeader();}}if(f.hasClass(A7,A0)){A6=BA;}else{A5=A9.scrollHeight-A9.offsetHeight;A6=BC;}this._bodyScrollTimer=AM.later(10,this,A6,null,true);},_onScrollTargetMouseOut:function(A7,A5){var A6=this._bodyScrollTimer;if(A6){A6.cancel();}this._cancelHideDelay();},_onInit:function(A6,A5){this.cfg.subscribeToConfigEvent(Au,this._onVisibleChange);var A7=!this.parent,A8=this.lazyLoad;if(((A7&&!A8)||(A7&&(this.cfg.getProperty(Au)||this.cfg.getProperty(Ac)==C))||(!A7&&!A8))&&this.getItemGroups().length===0){if(this.srcElement){this._initSubTree();}if(this.itemData){this.addItems(this.itemData);}}else{if(A8){this.cfg.fireQueue();}}},_onBeforeRender:function(A8,A7){var A9=this.element,BC=this._aListElements.length,A6=true,BB=0,A5,BA;if(BC>0){do{A5=this._aListElements[BB];if(A5){if(A6){f.addClass(A5,AJ);A6=false;}if(!f.isAncestor(A9,A5)){this.appendToBody(A5);}BA=this._aGroupTitleElements[BB];if(BA){if(!f.isAncestor(A9,BA)){A5.parentNode.insertBefore(BA,A5);}f.addClass(A5,D);}}BB++;}while(BB<BC);}},_onRender:function(A6,A5){if(this.cfg.getProperty(Ac)==AD){if(!this.cfg.getProperty(Au)){this.positionOffScreen();}}},_onBeforeShow:function(A7,A6){var A9,BC,A8,BA=this.cfg.getProperty(g);if(this.lazyLoad&&this.getItemGroups().length===0){if(this.srcElement){this._initSubTree();}if(this.itemData){if(this.parent&&this.parent.parent&&this.parent.parent.srcElement&&this.parent.parent.srcElement.tagName.toUpperCase()==AH){A9=this.itemData.length;for(BC=0;BC<A9;BC++){if(this.itemData[BC].tagName){this.addItem((new this.ITEM_TYPE(this.itemData[BC])));}}}else{this.addItems(this.itemData);}}A8=this.srcElement;if(A8){if(A8.tagName.toUpperCase()==AH){if(f.inDocument(A8)){this.render(A8.parentNode);}else{this.render(BA);}}else{this.render();}}else{if(this.parent){this.render(this.parent.element);}else{this.render(BA);}}}var BB=this.parent,A5;if(!BB&&this.cfg.getProperty(Ac)==AD){this.cfg.refireEvent(e);}if(BB){A5=BB.parent.cfg.getProperty(AO);this.cfg.setProperty(p,[BB.element,A5[0],A5[1]]);this.align();}},getConstrainedY:function(BH){var BS=this,BO=BS.cfg.getProperty(p),BV=BS.cfg.getProperty(AU),BR,BG={"trbr":true,"tlbl":true,"bltl":true,"brtr":true},BA=(BO&&BG[BO[1]+BO[2]]),BC=BS.element,BW=BC.offsetHeight,BQ=AB.VIEWPORT_OFFSET,BL=f.getViewportHeight(),BP=f.getDocumentScrollTop(),BM=(BS.cfg.getProperty(Aj)+BQ<BL),BU,BD,BJ,BK,BF=false,BE,A7,BI=BP+BQ,A9=BP+BL-BW-BQ,A5=BH;var BB=function(){var BX;if((BS.cfg.getProperty(R)-BP)>BJ){BX=(BJ-BW);}else{BX=(BJ+BK);}BS.cfg.setProperty(R,(BX+BP),true);return BX;};var A8=function(){if((BS.cfg.getProperty(R)-BP)>BJ){return(A7-BQ);}else{return(BE-BQ);}};var BN=function(){var BX;if((BS.cfg.getProperty(R)-BP)>BJ){BX=(BJ+BK);}else{BX=(BJ-BC.offsetHeight);}BS.cfg.setProperty(R,(BX+BP),true);};var A6=function(){BS._setScrollHeight(this.cfg.getProperty(AU));BS.hideEvent.unsubscribe(A6);};var BT=function(){var Ba=A8(),BX=(BS.getItems().length>0),BZ,BY;if(BW>Ba){BZ=BX?BS.cfg.getProperty(Aj):BW;if((Ba>BZ)&&BX){BR=Ba;}else{BR=BV;}BS._setScrollHeight(BR);BS.hideEvent.subscribe(A6);BN();if(Ba<BZ){if(BF){BB();}else{BB();BF=true;BY=BT();}}}else{if(BR&&(BR!==BV)){BS._setScrollHeight(BV);BS.hideEvent.subscribe(A6);BN();}}return BY;};if(BH<BI||BH>A9){if(BM){if(BS.cfg.getProperty(A4)&&BA){BD=BO[0];BK=BD.offsetHeight;BJ=(f.getY(BD)-BP);BE=BJ;A7=(BL-(BJ+BK));BT();A5=BS.cfg.getProperty(R);}else{if(!(BS instanceof YAHOO.widget.MenuBar)&&BW>=BL){BU=(BL-(BQ*2));if(BU>BS.cfg.getProperty(Aj)){BS._setScrollHeight(BU);BS.hideEvent.subscribe(A6);BN();A5=BS.cfg.getProperty(R);}}else{if(BH<BI){A5=BI;}else{if(BH>A9){A5=A9;}}}}}else{A5=BQ+BP;}}return A5;},_onHide:function(A6,A5){if(this.cfg.getProperty(Ac)===AD){this.positionOffScreen();}},_onShow:function(BD,BB){var A5=this.parent,A7,A8,BA,A6;function A9(BF){var BE;if(BF.type==Ak||(BF.type==Ae&&BF.keyCode==27)){BE=AA.getTarget(BF);if(BE!=A7.element||!f.isAncestor(A7.element,BE)){A7.cfg.setProperty(Z,false);AA.removeListener(document,Ak,A9);AA.removeListener(document,Ae,A9);}}}function BC(BF,BE,BG){this.cfg.setProperty(U,u);this.hideEvent.unsubscribe(BC,BG);}if(A5){A7=A5.parent;if(!A7.cfg.getProperty(Z)&&(A7 instanceof YAHOO.widget.MenuBar||A7.cfg.getProperty(Ac)==C)){A7.cfg.setProperty(Z,true);
AA.on(document,Ak,A9);AA.on(document,Ae,A9);}if((this.cfg.getProperty("x")<A7.cfg.getProperty("x"))&&(As.gecko&&As.gecko<1.9)&&!this.cfg.getProperty(U)){A8=this.element;BA=A8.offsetWidth;A8.style.width=BA+AQ;A6=(BA-(A8.offsetWidth-BA))+AQ;this.cfg.setProperty(U,A6);this.hideEvent.subscribe(BC,A6);}}if(this===this.getRoot()&&this.cfg.getProperty(Ac)===AD){this._focusedElement=Ad;this.focus();}},_onBeforeHide:function(A7,A6){var A5=this.activeItem,A9=this.getRoot(),BA,A8;if(A5){BA=A5.cfg;BA.setProperty(y,false);A8=BA.getProperty(O);if(A8){A8.hide();}}if(As.ie&&this.cfg.getProperty(Ac)===AD&&this.parent){A9._hasFocus=this.hasFocus();}if(A9==this){A9.blur();}},_onParentMenuConfigChange:function(A6,A5,A9){var A7=A5[0][0],A8=A5[0][1];switch(A7){case AF:case w:case AX:case Av:case c:case AC:case Ay:case A2:case j:case AU:case Aj:case AE:case Ag:case A4:case Ar:A9.cfg.setProperty(A7,A8);break;case AO:if(!(this.parent.parent instanceof YAHOO.widget.MenuBar)){A9.cfg.setProperty(A7,A8);}break;}},_onParentMenuRender:function(A6,A5,BB){var A8=BB.parent.parent,A7=A8.cfg,A9={constraintoviewport:A7.getProperty(w),xy:[0,0],clicktohide:A7.getProperty(AC),effect:A7.getProperty(Ay),showdelay:A7.getProperty(Av),hidedelay:A7.getProperty(AX),submenuhidedelay:A7.getProperty(c),classname:A7.getProperty(A2),scrollincrement:A7.getProperty(j),maxheight:A7.getProperty(AU),minscrollheight:A7.getProperty(Aj),iframe:A7.getProperty(AF),shadow:A7.getProperty(Ag),preventcontextoverlap:A7.getProperty(A4),monitorresize:A7.getProperty(AE),keepopen:A7.getProperty(Ar)},BA;if(!(A8 instanceof YAHOO.widget.MenuBar)){A9[AO]=A7.getProperty(AO);}BB.cfg.applyConfig(A9);if(!this.lazyLoad){BA=this.parent.element;if(this.element.parentNode==BA){this.render();}else{this.render(BA);}}},_onMenuItemDestroy:function(A7,A6,A5){this._removeItemFromGroupByValue(A5.groupIndex,A5);},_onMenuItemConfigChange:function(A7,A6,A5){var A9=A6[0][0],BA=A6[0][1],A8;switch(A9){case y:if(BA===true){this.activeItem=A5;}break;case O:A8=A6[0][1];if(A8){this._configureSubmenu(A5);}break;}},configVisible:function(A7,A6,A8){var A5,A9;if(this.cfg.getProperty(Ac)==AD){r.superclass.configVisible.call(this,A7,A6,A8);}else{A5=A6[0];A9=f.getStyle(this.element,AW);f.setStyle(this.element,J,Au);if(A5){if(A9!=AV){this.beforeShowEvent.fire();f.setStyle(this.element,AW,AV);this.showEvent.fire();}}else{if(A9==AV){this.beforeHideEvent.fire();f.setStyle(this.element,AW,AY);this.hideEvent.fire();}}}},configPosition:function(A7,A6,BA){var A9=this.element,A8=A6[0]==C?C:z,BB=this.cfg,A5;f.setStyle(A9,Ac,A8);if(A8==C){f.setStyle(A9,AW,AV);BB.setProperty(Au,true);}else{f.setStyle(A9,J,AL);}if(A8==z){A5=BB.getProperty(AS);if(!A5||A5===0){BB.setProperty(AS,1);}}},configIframe:function(A6,A5,A7){if(this.cfg.getProperty(Ac)==AD){r.superclass.configIframe.call(this,A6,A5,A7);}},configHideDelay:function(A6,A5,A7){var A8=A5[0];this._useHideDelay=(A8>0);},configContainer:function(A6,A5,A8){var A7=A5[0];if(AM.isString(A7)){this.cfg.setProperty(g,f.get(A7),true);}},_clearSetWidthFlag:function(){this._widthSetForScroll=false;this.cfg.unsubscribeFromConfigEvent(U,this._clearSetWidthFlag);},_subscribeScrollHandlers:function(A6,A5){var A8=this._onScrollTargetMouseOver;var A7=this._onScrollTargetMouseOut;AA.on(A6,Ai,A8,this,true);AA.on(A6,H,A7,this,true);AA.on(A5,Ai,A8,this,true);AA.on(A5,H,A7,this,true);},_unsubscribeScrollHandlers:function(A6,A5){var A8=this._onScrollTargetMouseOver;var A7=this._onScrollTargetMouseOut;AA.removeListener(A6,Ai,A8);AA.removeListener(A6,H,A7);AA.removeListener(A5,Ai,A8);AA.removeListener(A5,H,A7);},_setScrollHeight:function(BF){var BC=BF,BB=false,BG=false,A8,A9,BE,A6,A5,BD,BA,A7;if(this.getItems().length>0){A8=this.element;A9=this.body;BE=this.header;A6=this.footer;A5=this.cfg.getProperty(Aj);if(BC>0&&BC<A5){BC=A5;}f.setStyle(A9,Ao,u);f.removeClass(A9,l);A9.scrollTop=0;BG=((As.gecko&&As.gecko<1.9)||As.ie);if(BC>0&&BG&&!this.cfg.getProperty(U)){BA=A8.offsetWidth;A8.style.width=BA+AQ;A7=(BA-(A8.offsetWidth-BA))+AQ;this.cfg.unsubscribeFromConfigEvent(U,this._clearSetWidthFlag);this.cfg.setProperty(U,A7);this._widthSetForScroll=true;this.cfg.subscribeToConfigEvent(U,this._clearSetWidthFlag);}if(BC>0&&(!BE&&!A6)){this.setHeader(AK);this.setFooter(AK);BE=this.header;A6=this.footer;f.addClass(BE,T);f.addClass(A6,x);A8.insertBefore(BE,A9);A8.appendChild(A6);}BD=BC;if(BE&&A6){BD=(BD-(BE.offsetHeight+A6.offsetHeight));}if((BD>0)&&(A9.offsetHeight>BC)){f.addClass(A9,l);f.setStyle(A9,Ao,(BD+AQ));if(!this._hasScrollEventHandlers){this._subscribeScrollHandlers(BE,A6);this._hasScrollEventHandlers=true;}this._disableScrollHeader();this._enableScrollFooter();BB=true;}else{if(BE&&A6){if(this._widthSetForScroll){this._widthSetForScroll=false;this.cfg.unsubscribeFromConfigEvent(U,this._clearSetWidthFlag);this.cfg.setProperty(U,u);}this._enableScrollHeader();this._enableScrollFooter();if(this._hasScrollEventHandlers){this._unsubscribeScrollHandlers(BE,A6);this._hasScrollEventHandlers=false;}A8.removeChild(BE);A8.removeChild(A6);this.header=null;this.footer=null;BB=true;}}if(BB){this.cfg.refireEvent(AF);this.cfg.refireEvent(Ag);}}},_setMaxHeight:function(A6,A5,A7){this._setScrollHeight(A7);this.renderEvent.unsubscribe(this._setMaxHeight);},configMaxHeight:function(A6,A5,A7){var A8=A5[0];if(this.lazyLoad&&!this.body&&A8>0){this.renderEvent.subscribe(this._setMaxHeight,A8,this);}else{this._setScrollHeight(A8);}},configClassName:function(A7,A6,A8){var A5=A6[0];if(this._sClassName){f.removeClass(this.element,this._sClassName);}f.addClass(this.element,A5);this._sClassName=A5;},_onItemAdded:function(A6,A5){var A7=A5[0];if(A7){A7.cfg.setProperty(Ah,true);}},configDisabled:function(A7,A6,BA){var A9=A6[0],A5=this.getItems(),BB,A8;if(AM.isArray(A5)){BB=A5.length;if(BB>0){A8=BB-1;do{A5[A8].cfg.setProperty(Ah,A9);}while(A8--);}if(A9){this.clearActiveItem(true);f.addClass(this.element,Ah);this.itemAddedEvent.subscribe(this._onItemAdded);}else{f.removeClass(this.element,Ah);this.itemAddedEvent.unsubscribe(this._onItemAdded);
}}},_sizeShadow:function(){var A6=this.element,A5=this._shadow;if(A5&&A6){if(A5.style.width&&A5.style.height){A5.style.width=u;A5.style.height=u;}A5.style.width=(A6.offsetWidth+6)+AQ;A5.style.height=(A6.offsetHeight+1)+AQ;}},_replaceShadow:function(){this.element.appendChild(this._shadow);},_addShadowVisibleClass:function(){f.addClass(this._shadow,AG);},_removeShadowVisibleClass:function(){f.removeClass(this._shadow,AG);},_removeShadow:function(){var A5=(this._shadow&&this._shadow.parentNode);if(A5){A5.removeChild(this._shadow);}this.beforeShowEvent.unsubscribe(this._addShadowVisibleClass);this.beforeHideEvent.unsubscribe(this._removeShadowVisibleClass);this.cfg.unsubscribeFromConfigEvent(U,this._sizeShadow);this.cfg.unsubscribeFromConfigEvent(Ao,this._sizeShadow);this.cfg.unsubscribeFromConfigEvent(AU,this._sizeShadow);this.cfg.unsubscribeFromConfigEvent(AU,this._replaceShadow);this.changeContentEvent.unsubscribe(this._sizeShadow);Aw.textResizeEvent.unsubscribe(this._sizeShadow);},_createShadow:function(){var A6=this._shadow,A5;if(!A6){A5=this.element;if(!Ap){Ap=document.createElement(K);Ap.className=m;}A6=Ap.cloneNode(false);A5.appendChild(A6);this._shadow=A6;this.beforeShowEvent.subscribe(this._addShadowVisibleClass);this.beforeHideEvent.subscribe(this._removeShadowVisibleClass);if(As.ie){AM.later(0,this,function(){this._sizeShadow();this.syncIframe();});this.cfg.subscribeToConfigEvent(U,this._sizeShadow);this.cfg.subscribeToConfigEvent(Ao,this._sizeShadow);this.cfg.subscribeToConfigEvent(AU,this._sizeShadow);this.changeContentEvent.subscribe(this._sizeShadow);Aw.textResizeEvent.subscribe(this._sizeShadow,this,true);this.destroyEvent.subscribe(function(){Aw.textResizeEvent.unsubscribe(this._sizeShadow,this);});}this.cfg.subscribeToConfigEvent(AU,this._replaceShadow);}},_shadowBeforeShow:function(){if(this._shadow){this._replaceShadow();if(As.ie){this._sizeShadow();}}else{this._createShadow();}this.beforeShowEvent.unsubscribe(this._shadowBeforeShow);},configShadow:function(A6,A5,A7){var A8=A5[0];if(A8&&this.cfg.getProperty(Ac)==AD){if(this.cfg.getProperty(Au)){if(this._shadow){this._replaceShadow();if(As.ie){this._sizeShadow();}}else{this._createShadow();}}else{this.beforeShowEvent.subscribe(this._shadowBeforeShow);}}else{if(!A8){this.beforeShowEvent.unsubscribe(this._shadowBeforeShow);this._removeShadow();}}},initEvents:function(){r.superclass.initEvents.call(this);var A6=Ab.length-1,A7,A5;do{A7=Ab[A6];A5=this.createEvent(A7[1]);A5.signature=F.LIST;this[A7[0]]=A5;}while(A6--);},positionOffScreen:function(){var A6=this.iframe,A7=this.element,A5=this.OFF_SCREEN_POSITION;A7.style.top=u;A7.style.left=u;if(A6){A6.style.top=A5;A6.style.left=A5;}},getRoot:function(){var A7=this.parent,A6,A5;if(A7){A6=A7.parent;A5=A6?A6.getRoot():this;}else{A5=this;}return A5;},toString:function(){var A6=Aq,A5=this.id;if(A5){A6+=(A1+A5);}return A6;},setItemGroupTitle:function(BA,A9){var A8,A7,A6,A5;if(AM.isString(BA)&&BA.length>0){A8=AM.isNumber(A9)?A9:0;A7=this._aGroupTitleElements[A8];if(A7){A7.innerHTML=BA;}else{A7=document.createElement(this.GROUP_TITLE_TAG_NAME);A7.innerHTML=BA;this._aGroupTitleElements[A8]=A7;}A6=this._aGroupTitleElements.length-1;do{if(this._aGroupTitleElements[A6]){f.removeClass(this._aGroupTitleElements[A6],AJ);A5=A6;}}while(A6--);if(A5!==null){f.addClass(this._aGroupTitleElements[A5],AJ);}this.changeContentEvent.fire();}},addItem:function(A5,A6){return this._addItemToGroup(A6,A5);},addItems:function(A9,A8){var BB,A5,BA,A6,A7;if(AM.isArray(A9)){BB=A9.length;A5=[];for(A6=0;A6<BB;A6++){BA=A9[A6];if(BA){if(AM.isArray(BA)){A5[A5.length]=this.addItems(BA,A6);}else{A5[A5.length]=this._addItemToGroup(A8,BA);}}}if(A5.length){A7=A5;}}return A7;},insertItem:function(A5,A6,A7){return this._addItemToGroup(A7,A5,A6);},removeItem:function(A5,A7){var A8,A6;if(!AM.isUndefined(A5)){if(A5 instanceof YAHOO.widget.MenuItem){A8=this._removeItemFromGroupByValue(A7,A5);}else{if(AM.isNumber(A5)){A8=this._removeItemFromGroupByIndex(A7,A5);}}if(A8){A8.destroy();A6=A8;}}return A6;},getItems:function(){var A8=this._aItemGroups,A6,A7,A5=[];if(AM.isArray(A8)){A6=A8.length;A7=((A6==1)?A8[0]:(Array.prototype.concat.apply(A5,A8)));}return A7;},getItemGroups:function(){return this._aItemGroups;},getItem:function(A6,A7){var A8,A5;if(AM.isNumber(A6)){A8=this._getItemGroup(A7);if(A8){A5=A8[A6];}}return A5;},getSubmenus:function(){var A6=this.getItems(),BA=A6.length,A5,A7,A9,A8;if(BA>0){A5=[];for(A8=0;A8<BA;A8++){A9=A6[A8];if(A9){A7=A9.cfg.getProperty(O);if(A7){A5[A5.length]=A7;}}}}return A5;},clearContent:function(){var A9=this.getItems(),A6=A9.length,A7=this.element,A8=this.body,BD=this.header,A5=this.footer,BC,BB,BA;if(A6>0){BA=A6-1;do{BC=A9[BA];if(BC){BB=BC.cfg.getProperty(O);if(BB){this.cfg.configChangedEvent.unsubscribe(this._onParentMenuConfigChange,BB);this.renderEvent.unsubscribe(this._onParentMenuRender,BB);}this.removeItem(BC,BC.groupIndex);}}while(BA--);}if(BD){AA.purgeElement(BD);A7.removeChild(BD);}if(A5){AA.purgeElement(A5);A7.removeChild(A5);}if(A8){AA.purgeElement(A8);A8.innerHTML=u;}this.activeItem=null;this._aItemGroups=[];this._aListElements=[];this._aGroupTitleElements=[];this.cfg.setProperty(U,null);},destroy:function(A5){this.clearContent();this._aItemGroups=null;this._aListElements=null;this._aGroupTitleElements=null;r.superclass.destroy.call(this,A5);},setInitialFocus:function(){var A5=this._getFirstEnabledItem();if(A5){A5.focus();}},setInitialSelection:function(){var A5=this._getFirstEnabledItem();if(A5){A5.cfg.setProperty(y,true);}},clearActiveItem:function(A7){if(this.cfg.getProperty(Av)>0){this._cancelShowDelay();}var A5=this.activeItem,A8,A6;if(A5){A8=A5.cfg;if(A7){A5.blur();this.getRoot()._hasFocus=true;}A8.setProperty(y,false);A6=A8.getProperty(O);if(A6){A6.hide();}this.activeItem=null;}},focus:function(){if(!this.hasFocus()){this.setInitialFocus();}},blur:function(){var A5;if(this.hasFocus()){A5=A3.getFocusedMenuItem();if(A5){A5.blur();}}},hasFocus:function(){return(A3.getFocusedMenu()==this.getRoot());
},_doItemSubmenuSubscribe:function(A6,A5,A8){var A9=A5[0],A7=A9.cfg.getProperty(O);if(A7){A7.subscribe.apply(A7,A8);}},_doSubmenuSubscribe:function(A6,A5,A8){var A7=this.cfg.getProperty(O);if(A7){A7.subscribe.apply(A7,A8);}},subscribe:function(){r.superclass.subscribe.apply(this,arguments);r.superclass.subscribe.call(this,AR,this._doItemSubmenuSubscribe,arguments);var A5=this.getItems(),A9,A8,A6,A7;if(A5){A9=A5.length;if(A9>0){A7=A9-1;do{A8=A5[A7];A6=A8.cfg.getProperty(O);if(A6){A6.subscribe.apply(A6,arguments);}else{A8.cfg.subscribeToConfigEvent(O,this._doSubmenuSubscribe,arguments);}}while(A7--);}}},unsubscribe:function(){r.superclass.unsubscribe.apply(this,arguments);r.superclass.unsubscribe.call(this,AR,this._doItemSubmenuSubscribe,arguments);var A5=this.getItems(),A9,A8,A6,A7;if(A5){A9=A5.length;if(A9>0){A7=A9-1;do{A8=A5[A7];A6=A8.cfg.getProperty(O);if(A6){A6.unsubscribe.apply(A6,arguments);}else{A8.cfg.unsubscribeFromConfigEvent(O,this._doSubmenuSubscribe,arguments);}}while(A7--);}}},initDefaultConfig:function(){r.superclass.initDefaultConfig.call(this);var A5=this.cfg;A5.addProperty(AZ.key,{handler:this.configVisible,value:AZ.value,validator:AZ.validator});A5.addProperty(AP.key,{handler:this.configConstrainToViewport,value:AP.value,validator:AP.validator,supercedes:AP.supercedes});A5.addProperty(AI.key,{value:AI.value,validator:AI.validator,supercedes:AI.supercedes});A5.addProperty(S.key,{handler:this.configPosition,value:S.value,validator:S.validator,supercedes:S.supercedes});A5.addProperty(A.key,{value:A.value,suppressEvent:A.suppressEvent});A5.addProperty(t.key,{value:t.value,validator:t.validator,suppressEvent:t.suppressEvent});A5.addProperty(Y.key,{value:Y.value,validator:Y.validator,suppressEvent:Y.suppressEvent});A5.addProperty(q.key,{handler:this.configHideDelay,value:q.value,validator:q.validator,suppressEvent:q.suppressEvent});A5.addProperty(v.key,{value:v.value,validator:v.validator,suppressEvent:v.suppressEvent});A5.addProperty(o.key,{value:o.value,validator:o.validator,suppressEvent:o.suppressEvent});A5.addProperty(AN.key,{handler:this.configContainer,value:document.body,suppressEvent:AN.suppressEvent});A5.addProperty(Af.key,{value:Af.value,validator:Af.validator,supercedes:Af.supercedes,suppressEvent:Af.suppressEvent});A5.addProperty(N.key,{value:N.value,validator:N.validator,supercedes:N.supercedes,suppressEvent:N.suppressEvent});A5.addProperty(X.key,{handler:this.configMaxHeight,value:X.value,validator:X.validator,suppressEvent:X.suppressEvent,supercedes:X.supercedes});A5.addProperty(W.key,{handler:this.configClassName,value:W.value,validator:W.validator,supercedes:W.supercedes});A5.addProperty(a.key,{handler:this.configDisabled,value:a.value,validator:a.validator,suppressEvent:a.suppressEvent});A5.addProperty(I.key,{handler:this.configShadow,value:I.value,validator:I.validator});A5.addProperty(Al.key,{value:Al.value,validator:Al.validator});}});})();(function(){YAHOO.widget.MenuItem=function(AS,AR){if(AS){if(AR){this.parent=AR.parent;this.value=AR.value;this.id=AR.id;}this.init(AS,AR);}};var x=YAHOO.util.Dom,j=YAHOO.widget.Module,AB=YAHOO.widget.Menu,c=YAHOO.widget.MenuItem,AK=YAHOO.util.CustomEvent,k=YAHOO.env.ua,AQ=YAHOO.lang,AL="text",O="#",Q="-",L="helptext",n="url",AH="target",A="emphasis",N="strongemphasis",b="checked",w="submenu",H="disabled",B="selected",P="hassubmenu",U="checked-disabled",AI="hassubmenu-disabled",AD="hassubmenu-selected",T="checked-selected",q="onclick",J="classname",AJ="",i="OPTION",v="OPTGROUP",K="LI",AE="href",r="SELECT",X="DIV",AN='<em class="helptext">',a="<em>",I="</em>",W="<strong>",y="</strong>",Y="preventcontextoverlap",h="obj",AG="scope",t="none",V="visible",E=" ",m="MenuItem",AA="click",D="show",M="hide",S="li",AF='<a href="#"></a>',p=[["mouseOverEvent","mouseover"],["mouseOutEvent","mouseout"],["mouseDownEvent","mousedown"],["mouseUpEvent","mouseup"],["clickEvent",AA],["keyPressEvent","keypress"],["keyDownEvent","keydown"],["keyUpEvent","keyup"],["focusEvent","focus"],["blurEvent","blur"],["destroyEvent","destroy"]],o={key:AL,value:AJ,validator:AQ.isString,suppressEvent:true},s={key:L,supercedes:[AL],suppressEvent:true},G={key:n,value:O,suppressEvent:true},AO={key:AH,suppressEvent:true},AP={key:A,value:false,validator:AQ.isBoolean,suppressEvent:true,supercedes:[AL]},d={key:N,value:false,validator:AQ.isBoolean,suppressEvent:true,supercedes:[AL]},l={key:b,value:false,validator:AQ.isBoolean,suppressEvent:true,supercedes:[H,B]},F={key:w,suppressEvent:true,supercedes:[H,B]},AM={key:H,value:false,validator:AQ.isBoolean,suppressEvent:true,supercedes:[AL,B]},f={key:B,value:false,validator:AQ.isBoolean,suppressEvent:true},u={key:q,suppressEvent:true},AC={key:J,value:null,validator:AQ.isString,suppressEvent:true},z={key:"keylistener",value:null,suppressEvent:true},C=null,e={};var Z=function(AU,AT){var AR=e[AU];if(!AR){e[AU]={};AR=e[AU];}var AS=AR[AT];if(!AS){AS=AU+Q+AT;AR[AT]=AS;}return AS;};var g=function(AR){x.addClass(this.element,Z(this.CSS_CLASS_NAME,AR));x.addClass(this._oAnchor,Z(this.CSS_LABEL_CLASS_NAME,AR));};var R=function(AR){x.removeClass(this.element,Z(this.CSS_CLASS_NAME,AR));x.removeClass(this._oAnchor,Z(this.CSS_LABEL_CLASS_NAME,AR));};c.prototype={CSS_CLASS_NAME:"yuimenuitem",CSS_LABEL_CLASS_NAME:"yuimenuitemlabel",SUBMENU_TYPE:null,_oAnchor:null,_oHelpTextEM:null,_oSubmenu:null,_oOnclickAttributeValue:null,_sClassName:null,constructor:c,index:null,groupIndex:null,parent:null,element:null,srcElement:null,value:null,browser:j.prototype.browser,id:null,init:function(AR,Ab){if(!this.SUBMENU_TYPE){this.SUBMENU_TYPE=AB;}this.cfg=new YAHOO.util.Config(this);this.initDefaultConfig();var AX=this.cfg,AY=O,AT,Aa,AZ,AS,AV,AU,AW;if(AQ.isString(AR)){this._createRootNodeStructure();AX.queueProperty(AL,AR);}else{if(AR&&AR.tagName){switch(AR.tagName.toUpperCase()){case i:this._createRootNodeStructure();AX.queueProperty(AL,AR.text);AX.queueProperty(H,AR.disabled);this.value=AR.value;this.srcElement=AR;break;case v:this._createRootNodeStructure();
AX.queueProperty(AL,AR.label);AX.queueProperty(H,AR.disabled);this.srcElement=AR;this._initSubTree();break;case K:AZ=x.getFirstChild(AR);if(AZ){AY=AZ.getAttribute(AE,2);AS=AZ.getAttribute(AH);AV=AZ.innerHTML;}this.srcElement=AR;this.element=AR;this._oAnchor=AZ;AX.setProperty(AL,AV,true);AX.setProperty(n,AY,true);AX.setProperty(AH,AS,true);this._initSubTree();break;}}}if(this.element){AU=(this.srcElement||this.element).id;if(!AU){AU=this.id||x.generateId();this.element.id=AU;}this.id=AU;x.addClass(this.element,this.CSS_CLASS_NAME);x.addClass(this._oAnchor,this.CSS_LABEL_CLASS_NAME);AW=p.length-1;do{Aa=p[AW];AT=this.createEvent(Aa[1]);AT.signature=AK.LIST;this[Aa[0]]=AT;}while(AW--);if(Ab){AX.applyConfig(Ab);}AX.fireQueue();}},_createRootNodeStructure:function(){var AR,AS;if(!C){C=document.createElement(S);C.innerHTML=AF;}AR=C.cloneNode(true);AR.className=this.CSS_CLASS_NAME;AS=AR.firstChild;AS.className=this.CSS_LABEL_CLASS_NAME;this.element=AR;this._oAnchor=AS;},_initSubTree:function(){var AX=this.srcElement,AT=this.cfg,AV,AU,AS,AR,AW;if(AX.childNodes.length>0){if(this.parent.lazyLoad&&this.parent.srcElement&&this.parent.srcElement.tagName.toUpperCase()==r){AT.setProperty(w,{id:x.generateId(),itemdata:AX.childNodes});}else{AV=AX.firstChild;AU=[];do{if(AV&&AV.tagName){switch(AV.tagName.toUpperCase()){case X:AT.setProperty(w,AV);break;case i:AU[AU.length]=AV;break;}}}while((AV=AV.nextSibling));AS=AU.length;if(AS>0){AR=new this.SUBMENU_TYPE(x.generateId());AT.setProperty(w,AR);for(AW=0;AW<AS;AW++){AR.addItem((new AR.ITEM_TYPE(AU[AW])));}}}}},configText:function(Aa,AT,AV){var AS=AT[0],AU=this.cfg,AY=this._oAnchor,AR=AU.getProperty(L),AZ=AJ,AW=AJ,AX=AJ;if(AS){if(AR){AZ=AN+AR+I;}if(AU.getProperty(A)){AW=a;AX=I;}if(AU.getProperty(N)){AW=W;AX=y;}AY.innerHTML=(AW+AS+AX+AZ);}},configHelpText:function(AT,AS,AR){this.cfg.refireEvent(AL);},configURL:function(AT,AS,AR){var AV=AS[0];if(!AV){AV=O;}var AU=this._oAnchor;if(k.opera){AU.removeAttribute(AE);}AU.setAttribute(AE,AV);},configTarget:function(AU,AT,AS){var AR=AT[0],AV=this._oAnchor;if(AR&&AR.length>0){AV.setAttribute(AH,AR);}else{AV.removeAttribute(AH);}},configEmphasis:function(AT,AS,AR){var AV=AS[0],AU=this.cfg;if(AV&&AU.getProperty(N)){AU.setProperty(N,false);}AU.refireEvent(AL);},configStrongEmphasis:function(AU,AT,AS){var AR=AT[0],AV=this.cfg;if(AR&&AV.getProperty(A)){AV.setProperty(A,false);}AV.refireEvent(AL);},configChecked:function(AT,AS,AR){var AV=AS[0],AU=this.cfg;if(AV){g.call(this,b);}else{R.call(this,b);}AU.refireEvent(AL);if(AU.getProperty(H)){AU.refireEvent(H);}if(AU.getProperty(B)){AU.refireEvent(B);}},configDisabled:function(AT,AS,AR){var AV=AS[0],AW=this.cfg,AU=AW.getProperty(w),AX=AW.getProperty(b);if(AV){if(AW.getProperty(B)){AW.setProperty(B,false);}g.call(this,H);if(AU){g.call(this,AI);}if(AX){g.call(this,U);}}else{R.call(this,H);if(AU){R.call(this,AI);}if(AX){R.call(this,U);}}},configSelected:function(AT,AS,AR){var AX=this.cfg,AW=this._oAnchor,AV=AS[0],AY=AX.getProperty(b),AU=AX.getProperty(w);if(k.opera){AW.blur();}if(AV&&!AX.getProperty(H)){g.call(this,B);if(AU){g.call(this,AD);}if(AY){g.call(this,T);}}else{R.call(this,B);if(AU){R.call(this,AD);}if(AY){R.call(this,T);}}if(this.hasFocus()&&k.opera){AW.focus();}},_onSubmenuBeforeHide:function(AU,AT){var AV=this.parent,AR;function AS(){AV._oAnchor.blur();AR.beforeHideEvent.unsubscribe(AS);}if(AV.hasFocus()){AR=AV.parent;AR.beforeHideEvent.subscribe(AS);}},configSubmenu:function(AY,AT,AW){var AV=AT[0],AU=this.cfg,AS=this.parent&&this.parent.lazyLoad,AX,AZ,AR;if(AV){if(AV instanceof AB){AX=AV;AX.parent=this;AX.lazyLoad=AS;}else{if(AQ.isObject(AV)&&AV.id&&!AV.nodeType){AZ=AV.id;AR=AV;AR.lazyload=AS;AR.parent=this;AX=new this.SUBMENU_TYPE(AZ,AR);AU.setProperty(w,AX,true);}else{AX=new this.SUBMENU_TYPE(AV,{lazyload:AS,parent:this});AU.setProperty(w,AX,true);}}if(AX){AX.cfg.setProperty(Y,true);g.call(this,P);if(AU.getProperty(n)===O){AU.setProperty(n,(O+AX.id));}this._oSubmenu=AX;if(k.opera){AX.beforeHideEvent.subscribe(this._onSubmenuBeforeHide);}}}else{R.call(this,P);if(this._oSubmenu){this._oSubmenu.destroy();}}if(AU.getProperty(H)){AU.refireEvent(H);}if(AU.getProperty(B)){AU.refireEvent(B);}},configOnClick:function(AT,AS,AR){var AU=AS[0];if(this._oOnclickAttributeValue&&(this._oOnclickAttributeValue!=AU)){this.clickEvent.unsubscribe(this._oOnclickAttributeValue.fn,this._oOnclickAttributeValue.obj);this._oOnclickAttributeValue=null;}if(!this._oOnclickAttributeValue&&AQ.isObject(AU)&&AQ.isFunction(AU.fn)){this.clickEvent.subscribe(AU.fn,((h in AU)?AU.obj:this),((AG in AU)?AU.scope:null));this._oOnclickAttributeValue=AU;}},configClassName:function(AU,AT,AS){var AR=AT[0];if(this._sClassName){x.removeClass(this.element,this._sClassName);}x.addClass(this.element,AR);this._sClassName=AR;},_dispatchClickEvent:function(){var AS=this,AR;if(!AS.cfg.getProperty(H)){AR=x.getFirstChild(AS.element);this._dispatchDOMClick(AR);}},_dispatchDOMClick:function(AS){var AR;if(k.ie&&k.ie<9){AS.fireEvent(q);}else{if((k.gecko&&k.gecko>=1.9)||k.opera||k.webkit){AR=document.createEvent("HTMLEvents");AR.initEvent(AA,true,true);}else{AR=document.createEvent("MouseEvents");AR.initMouseEvent(AA,true,true,window,0,0,0,0,0,false,false,false,false,0,null);}AS.dispatchEvent(AR);}},_createKeyListener:function(AU,AT,AW){var AV=this,AS=AV.parent;var AR=new YAHOO.util.KeyListener(AS.element.ownerDocument,AW,{fn:AV._dispatchClickEvent,scope:AV,correctScope:true});if(AS.cfg.getProperty(V)){AR.enable();}AS.subscribe(D,AR.enable,null,AR);AS.subscribe(M,AR.disable,null,AR);AV._keyListener=AR;AS.unsubscribe(D,AV._createKeyListener,AW);},configKeyListener:function(AT,AS){var AV=AS[0],AU=this,AR=AU.parent;if(AU._keyData){AR.unsubscribe(D,AU._createKeyListener,AU._keyData);AU._keyData=null;}if(AU._keyListener){AR.unsubscribe(D,AU._keyListener.enable);AR.unsubscribe(M,AU._keyListener.disable);AU._keyListener.disable();AU._keyListener=null;}if(AV){AU._keyData=AV;AR.subscribe(D,AU._createKeyListener,AV,AU);}},initDefaultConfig:function(){var AR=this.cfg;
AR.addProperty(o.key,{handler:this.configText,value:o.value,validator:o.validator,suppressEvent:o.suppressEvent});AR.addProperty(s.key,{handler:this.configHelpText,supercedes:s.supercedes,suppressEvent:s.suppressEvent});AR.addProperty(G.key,{handler:this.configURL,value:G.value,suppressEvent:G.suppressEvent});AR.addProperty(AO.key,{handler:this.configTarget,suppressEvent:AO.suppressEvent});AR.addProperty(AP.key,{handler:this.configEmphasis,value:AP.value,validator:AP.validator,suppressEvent:AP.suppressEvent,supercedes:AP.supercedes});AR.addProperty(d.key,{handler:this.configStrongEmphasis,value:d.value,validator:d.validator,suppressEvent:d.suppressEvent,supercedes:d.supercedes});AR.addProperty(l.key,{handler:this.configChecked,value:l.value,validator:l.validator,suppressEvent:l.suppressEvent,supercedes:l.supercedes});AR.addProperty(AM.key,{handler:this.configDisabled,value:AM.value,validator:AM.validator,suppressEvent:AM.suppressEvent});AR.addProperty(f.key,{handler:this.configSelected,value:f.value,validator:f.validator,suppressEvent:f.suppressEvent});AR.addProperty(F.key,{handler:this.configSubmenu,supercedes:F.supercedes,suppressEvent:F.suppressEvent});AR.addProperty(u.key,{handler:this.configOnClick,suppressEvent:u.suppressEvent});AR.addProperty(AC.key,{handler:this.configClassName,value:AC.value,validator:AC.validator,suppressEvent:AC.suppressEvent});AR.addProperty(z.key,{handler:this.configKeyListener,value:z.value,suppressEvent:z.suppressEvent});},getNextSibling:function(){var AR=function(AX){return(AX.nodeName.toLowerCase()==="ul");},AV=this.element,AU=x.getNextSibling(AV),AT,AS,AW;if(!AU){AT=AV.parentNode;AS=x.getNextSiblingBy(AT,AR);if(AS){AW=AS;}else{AW=x.getFirstChildBy(AT.parentNode,AR);}AU=x.getFirstChild(AW);}return YAHOO.widget.MenuManager.getMenuItem(AU.id);},getNextEnabledSibling:function(){var AR=this.getNextSibling();return(AR.cfg.getProperty(H)||AR.element.style.display==t)?AR.getNextEnabledSibling():AR;},getPreviousSibling:function(){var AR=function(AX){return(AX.nodeName.toLowerCase()==="ul");},AV=this.element,AU=x.getPreviousSibling(AV),AT,AS,AW;if(!AU){AT=AV.parentNode;AS=x.getPreviousSiblingBy(AT,AR);if(AS){AW=AS;}else{AW=x.getLastChildBy(AT.parentNode,AR);}AU=x.getLastChild(AW);}return YAHOO.widget.MenuManager.getMenuItem(AU.id);},getPreviousEnabledSibling:function(){var AR=this.getPreviousSibling();return(AR.cfg.getProperty(H)||AR.element.style.display==t)?AR.getPreviousEnabledSibling():AR;},focus:function(){var AU=this.parent,AT=this._oAnchor,AR=AU.activeItem;function AS(){try{if(!(k.ie&&!document.hasFocus())){if(AR){AR.blurEvent.fire();}AT.focus();this.focusEvent.fire();}}catch(AV){}}if(!this.cfg.getProperty(H)&&AU&&AU.cfg.getProperty(V)&&this.element.style.display!=t){AQ.later(0,this,AS);}},blur:function(){var AR=this.parent;if(!this.cfg.getProperty(H)&&AR&&AR.cfg.getProperty(V)){AQ.later(0,this,function(){try{this._oAnchor.blur();this.blurEvent.fire();}catch(AS){}},0);}},hasFocus:function(){return(YAHOO.widget.MenuManager.getFocusedMenuItem()==this);},destroy:function(){var AT=this.element,AS,AR,AV,AU;if(AT){AS=this.cfg.getProperty(w);if(AS){AS.destroy();}AR=AT.parentNode;if(AR){AR.removeChild(AT);this.destroyEvent.fire();}AU=p.length-1;do{AV=p[AU];this[AV[0]].unsubscribeAll();}while(AU--);this.cfg.configChangedEvent.unsubscribeAll();}},toString:function(){var AS=m,AR=this.id;if(AR){AS+=(E+AR);}return AS;}};AQ.augmentProto(c,YAHOO.util.EventProvider);})();(function(){var B="xy",C="mousedown",F="ContextMenu",J=" ";YAHOO.widget.ContextMenu=function(L,K){YAHOO.widget.ContextMenu.superclass.constructor.call(this,L,K);};var I=YAHOO.util.Event,E=YAHOO.env.ua,G=YAHOO.widget.ContextMenu,A={"TRIGGER_CONTEXT_MENU":"triggerContextMenu","CONTEXT_MENU":(E.opera?C:"contextmenu"),"CLICK":"click"},H={key:"trigger",suppressEvent:true};function D(L,K,M){this.cfg.setProperty(B,M);this.beforeShowEvent.unsubscribe(D,M);}YAHOO.lang.extend(G,YAHOO.widget.Menu,{_oTrigger:null,_bCancelled:false,contextEventTarget:null,triggerContextMenuEvent:null,init:function(L,K){G.superclass.init.call(this,L);this.beforeInitEvent.fire(G);if(K){this.cfg.applyConfig(K,true);}this.initEvent.fire(G);},initEvents:function(){G.superclass.initEvents.call(this);this.triggerContextMenuEvent=this.createEvent(A.TRIGGER_CONTEXT_MENU);this.triggerContextMenuEvent.signature=YAHOO.util.CustomEvent.LIST;},cancel:function(){this._bCancelled=true;},_removeEventHandlers:function(){var K=this._oTrigger;if(K){I.removeListener(K,A.CONTEXT_MENU,this._onTriggerContextMenu);if(E.opera){I.removeListener(K,A.CLICK,this._onTriggerClick);}}},_onTriggerClick:function(L,K){if(L.ctrlKey){I.stopEvent(L);}},_onTriggerContextMenu:function(M,K){var L;if(!(M.type==C&&!M.ctrlKey)){this.contextEventTarget=I.getTarget(M);this.triggerContextMenuEvent.fire(M);if(!this._bCancelled){I.stopEvent(M);YAHOO.widget.MenuManager.hideVisible();L=I.getXY(M);if(!YAHOO.util.Dom.inDocument(this.element)){this.beforeShowEvent.subscribe(D,L);}else{this.cfg.setProperty(B,L);}this.show();}this._bCancelled=false;}},toString:function(){var L=F,K=this.id;if(K){L+=(J+K);}return L;},initDefaultConfig:function(){G.superclass.initDefaultConfig.call(this);this.cfg.addProperty(H.key,{handler:this.configTrigger,suppressEvent:H.suppressEvent});},destroy:function(K){this._removeEventHandlers();G.superclass.destroy.call(this,K);},configTrigger:function(L,K,N){var M=K[0];if(M){if(this._oTrigger){this._removeEventHandlers();}this._oTrigger=M;I.on(M,A.CONTEXT_MENU,this._onTriggerContextMenu,this,true);if(E.opera){I.on(M,A.CLICK,this._onTriggerClick,this,true);}}else{this._removeEventHandlers();}}});}());YAHOO.widget.ContextMenuItem=YAHOO.widget.MenuItem;(function(){var D=YAHOO.lang,N="static",M="dynamic,"+N,A="disabled",F="selected",B="autosubmenudisplay",G="submenu",C="visible",Q=" ",H="submenutoggleregion",P="MenuBar";YAHOO.widget.MenuBar=function(T,S){YAHOO.widget.MenuBar.superclass.constructor.call(this,T,S);};function O(T){var S=false;if(D.isString(T)){S=(M.indexOf((T.toLowerCase()))!=-1);
}return S;}var R=YAHOO.util.Event,L=YAHOO.widget.MenuBar,K={key:"position",value:N,validator:O,supercedes:[C]},E={key:"submenualignment",value:["tl","bl"]},J={key:B,value:false,validator:D.isBoolean,suppressEvent:true},I={key:H,value:false,validator:D.isBoolean};D.extend(L,YAHOO.widget.Menu,{init:function(T,S){if(!this.ITEM_TYPE){this.ITEM_TYPE=YAHOO.widget.MenuBarItem;}L.superclass.init.call(this,T);this.beforeInitEvent.fire(L);if(S){this.cfg.applyConfig(S,true);}this.initEvent.fire(L);},CSS_CLASS_NAME:"yuimenubar",SUBMENU_TOGGLE_REGION_WIDTH:20,_onKeyDown:function(U,T,Y){var S=T[0],Z=T[1],W,X,V;if(Z&&!Z.cfg.getProperty(A)){X=Z.cfg;switch(S.keyCode){case 37:case 39:if(Z==this.activeItem&&!X.getProperty(F)){X.setProperty(F,true);}else{V=(S.keyCode==37)?Z.getPreviousEnabledSibling():Z.getNextEnabledSibling();if(V){this.clearActiveItem();V.cfg.setProperty(F,true);W=V.cfg.getProperty(G);if(W){W.show();W.setInitialFocus();}else{V.focus();}}}R.preventDefault(S);break;case 40:if(this.activeItem!=Z){this.clearActiveItem();X.setProperty(F,true);Z.focus();}W=X.getProperty(G);if(W){if(W.cfg.getProperty(C)){W.setInitialSelection();W.setInitialFocus();}else{W.show();W.setInitialFocus();}}R.preventDefault(S);break;}}if(S.keyCode==27&&this.activeItem){W=this.activeItem.cfg.getProperty(G);if(W&&W.cfg.getProperty(C)){W.hide();this.activeItem.focus();}else{this.activeItem.cfg.setProperty(F,false);this.activeItem.blur();}R.preventDefault(S);}},_onClick:function(e,Y,b){L.superclass._onClick.call(this,e,Y,b);var d=Y[1],T=true,S,f,U,W,Z,a,c,V;var X=function(){if(a.cfg.getProperty(C)){a.hide();}else{a.show();}};if(d&&!d.cfg.getProperty(A)){f=Y[0];U=R.getTarget(f);W=this.activeItem;Z=this.cfg;if(W&&W!=d){this.clearActiveItem();}d.cfg.setProperty(F,true);a=d.cfg.getProperty(G);if(a){S=d.element;c=YAHOO.util.Dom.getX(S);V=c+(S.offsetWidth-this.SUBMENU_TOGGLE_REGION_WIDTH);if(Z.getProperty(H)){if(R.getPageX(f)>V){X();R.preventDefault(f);T=false;}}else{X();}}}return T;},configSubmenuToggle:function(U,T){var S=T[0];if(S){this.cfg.setProperty(B,false);}},toString:function(){var T=P,S=this.id;if(S){T+=(Q+S);}return T;},initDefaultConfig:function(){L.superclass.initDefaultConfig.call(this);var S=this.cfg;S.addProperty(K.key,{handler:this.configPosition,value:K.value,validator:K.validator,supercedes:K.supercedes});S.addProperty(E.key,{value:E.value,suppressEvent:E.suppressEvent});S.addProperty(J.key,{value:J.value,validator:J.validator,suppressEvent:J.suppressEvent});S.addProperty(I.key,{value:I.value,validator:I.validator,handler:this.configSubmenuToggle});}});}());YAHOO.widget.MenuBarItem=function(B,A){YAHOO.widget.MenuBarItem.superclass.constructor.call(this,B,A);};YAHOO.lang.extend(YAHOO.widget.MenuBarItem,YAHOO.widget.MenuItem,{init:function(B,A){if(!this.SUBMENU_TYPE){this.SUBMENU_TYPE=YAHOO.widget.Menu;}YAHOO.widget.MenuBarItem.superclass.init.call(this,B);var C=this.cfg;if(A){C.applyConfig(A,true);}C.fireQueue();},CSS_CLASS_NAME:"yuimenubaritem",CSS_LABEL_CLASS_NAME:"yuimenubaritemlabel",toString:function(){var A="MenuBarItem";if(this.cfg&&this.cfg.getProperty("text")){A+=(": "+this.cfg.getProperty("text"));}return A;}});YAHOO.register("menu",YAHOO.widget.Menu,{version:"2.9.0",build:"2800"});
/*
Copyright (c) 2011, Yahoo! Inc. All rights reserved.
Code licensed under the BSD License:
http://developer.yahoo.com/yui/license.html
version: 2.9.0
*/
(function(){var d=YAHOO.util.Dom,b=YAHOO.util.Event,f=YAHOO.lang,e=YAHOO.widget;YAHOO.widget.TreeView=function(h,g){if(h){this.init(h);}if(g){this.buildTreeFromObject(g);}else{if(f.trim(this._el.innerHTML)){this.buildTreeFromMarkup(h);}}};var c=e.TreeView;c.prototype={id:null,_el:null,_nodes:null,locked:false,_expandAnim:null,_collapseAnim:null,_animCount:0,maxAnim:2,_hasDblClickSubscriber:false,_dblClickTimer:null,currentFocus:null,singleNodeHighlight:false,_currentlyHighlighted:null,setExpandAnim:function(g){this._expandAnim=(e.TVAnim.isValid(g))?g:null;},setCollapseAnim:function(g){this._collapseAnim=(e.TVAnim.isValid(g))?g:null;},animateExpand:function(i,j){if(this._expandAnim&&this._animCount<this.maxAnim){var g=this;var h=e.TVAnim.getAnim(this._expandAnim,i,function(){g.expandComplete(j);});if(h){++this._animCount;this.fireEvent("animStart",{"node":j,"type":"expand"});h.animate();}return true;}return false;},animateCollapse:function(i,j){if(this._collapseAnim&&this._animCount<this.maxAnim){var g=this;var h=e.TVAnim.getAnim(this._collapseAnim,i,function(){g.collapseComplete(j);});if(h){++this._animCount;this.fireEvent("animStart",{"node":j,"type":"collapse"});h.animate();}return true;}return false;},expandComplete:function(g){--this._animCount;this.fireEvent("animComplete",{"node":g,"type":"expand"});},collapseComplete:function(g){--this._animCount;this.fireEvent("animComplete",{"node":g,"type":"collapse"});},init:function(i){this._el=d.get(i);this.id=d.generateId(this._el,"yui-tv-auto-id-");this.createEvent("animStart",this);this.createEvent("animComplete",this);this.createEvent("collapse",this);this.createEvent("collapseComplete",this);this.createEvent("expand",this);this.createEvent("expandComplete",this);this.createEvent("enterKeyPressed",this);this.createEvent("clickEvent",this);this.createEvent("focusChanged",this);var g=this;this.createEvent("dblClickEvent",{scope:this,onSubscribeCallback:function(){g._hasDblClickSubscriber=true;}});this.createEvent("labelClick",this);this.createEvent("highlightEvent",this);this._nodes=[];c.trees[this.id]=this;this.root=new e.RootNode(this);var h=e.LogWriter;if(this._initEditor){this._initEditor();}},buildTreeFromObject:function(g){var h=function(q,n){var m,r,l,k,p,j,o;for(m=0;m<n.length;m++){r=n[m];if(f.isString(r)){l=new e.TextNode(r,q);}else{if(f.isObject(r)){k=r.children;delete r.children;p=r.type||"text";delete r.type;switch(f.isString(p)&&p.toLowerCase()){case"text":l=new e.TextNode(r,q);break;case"menu":l=new e.MenuNode(r,q);break;case"html":l=new e.HTMLNode(r,q);break;default:if(f.isString(p)){j=e[p];}else{j=p;}if(f.isObject(j)){for(o=j;o&&o!==e.Node;o=o.superclass.constructor){}if(o){l=new j(r,q);}else{}}else{}}if(k){h(l,k);}}else{}}}};if(!f.isArray(g)){g=[g];}h(this.root,g);},buildTreeFromMarkup:function(i){var h=function(j){var n,q,m=[],l={},k,o;for(n=d.getFirstChild(j);n;n=d.getNextSibling(n)){switch(n.tagName.toUpperCase()){case"LI":k="";l={expanded:d.hasClass(n,"expanded"),title:n.title||n.alt||null,className:f.trim(n.className.replace(/\bexpanded\b/,""))||null};q=n.firstChild;if(q.nodeType==3){k=f.trim(q.nodeValue.replace(/[\n\t\r]*/g,""));if(k){l.type="text";l.label=k;}else{q=d.getNextSibling(q);}}if(!k){if(q.tagName.toUpperCase()=="A"){l.type="text";l.label=q.innerHTML;l.href=q.href;l.target=q.target;l.title=q.title||q.alt||l.title;}else{l.type="html";var p=document.createElement("div");p.appendChild(q.cloneNode(true));l.html=p.innerHTML;l.hasIcon=true;}}q=d.getNextSibling(q);switch(q&&q.tagName.toUpperCase()){case"UL":case"OL":l.children=h(q);break;}if(YAHOO.lang.JSON){o=n.getAttribute("yuiConfig");if(o){o=YAHOO.lang.JSON.parse(o);l=YAHOO.lang.merge(l,o);}}m.push(l);break;case"UL":case"OL":l={type:"text",label:"",children:h(q)};m.push(l);break;}}return m;};var g=d.getChildrenBy(d.get(i),function(k){var j=k.tagName.toUpperCase();return j=="UL"||j=="OL";});if(g.length){this.buildTreeFromObject(h(g[0]));}else{}},_getEventTargetTdEl:function(h){var i=b.getTarget(h);while(i&&!(i.tagName.toUpperCase()=="TD"&&d.hasClass(i.parentNode,"ygtvrow"))){i=d.getAncestorByTagName(i,"td");}if(f.isNull(i)){return null;}if(/\bygtv(blank)?depthcell/.test(i.className)){return null;}if(i.id){var g=i.id.match(/\bygtv([^\d]*)(.*)/);if(g&&g[2]&&this._nodes[g[2]]){return i;}}return null;},_onClickEvent:function(j){var h=this,l=this._getEventTargetTdEl(j),i,k,g=function(m){i.focus();if(m||!i.href){i.toggle();try{b.preventDefault(j);}catch(n){}}};if(!l){return;}i=this.getNodeByElement(l);if(!i){return;}k=b.getTarget(j);if(d.hasClass(k,i.labelStyle)||d.getAncestorByClassName(k,i.labelStyle)){this.fireEvent("labelClick",i);}if(this._closeEditor){this._closeEditor(false);}if(/\bygtv[tl][mp]h?h?/.test(l.className)){g(true);}else{if(this._dblClickTimer){window.clearTimeout(this._dblClickTimer);this._dblClickTimer=null;}else{if(this._hasDblClickSubscriber){this._dblClickTimer=window.setTimeout(function(){h._dblClickTimer=null;if(h.fireEvent("clickEvent",{event:j,node:i})!==false){g();}},200);}else{if(h.fireEvent("clickEvent",{event:j,node:i})!==false){g();}}}}},_onDblClickEvent:function(g){if(!this._hasDblClickSubscriber){return;}var h=this._getEventTargetTdEl(g);if(!h){return;}if(!(/\bygtv[tl][mp]h?h?/.test(h.className))){this.fireEvent("dblClickEvent",{event:g,node:this.getNodeByElement(h)});if(this._dblClickTimer){window.clearTimeout(this._dblClickTimer);this._dblClickTimer=null;}}},_onMouseOverEvent:function(g){var h;if((h=this._getEventTargetTdEl(g))&&(h=this.getNodeByElement(h))&&(h=h.getToggleEl())){h.className=h.className.replace(/\bygtv([lt])([mp])\b/gi,"ygtv$1$2h");}},_onMouseOutEvent:function(g){var h;if((h=this._getEventTargetTdEl(g))&&(h=this.getNodeByElement(h))&&(h=h.getToggleEl())){h.className=h.className.replace(/\bygtv([lt])([mp])h\b/gi,"ygtv$1$2");}},_onKeyDownEvent:function(l){var n=b.getTarget(l),k=this.getNodeByElement(n),j=k,g=YAHOO.util.KeyListener.KEY;switch(l.keyCode){case g.UP:do{if(j.previousSibling){j=j.previousSibling;}else{j=j.parent;
}}while(j&&!j._canHaveFocus());if(j){j.focus();}b.preventDefault(l);break;case g.DOWN:do{if(j.nextSibling){j=j.nextSibling;}else{j.expand();j=(j.children.length||null)&&j.children[0];}}while(j&&!j._canHaveFocus);if(j){j.focus();}b.preventDefault(l);break;case g.LEFT:do{if(j.parent){j=j.parent;}else{j=j.previousSibling;}}while(j&&!j._canHaveFocus());if(j){j.focus();}b.preventDefault(l);break;case g.RIGHT:var i=this,m,h=function(o){i.unsubscribe("expandComplete",h);m(o);};m=function(o){do{if(o.isDynamic()&&!o.childrenRendered){i.subscribe("expandComplete",h);o.expand();o=null;break;}else{o.expand();if(o.children.length){o=o.children[0];}else{o=o.nextSibling;}}}while(o&&!o._canHaveFocus());if(o){o.focus();}};m(j);b.preventDefault(l);break;case g.ENTER:if(k.href){if(k.target){window.open(k.href,k.target);}else{window.location(k.href);}}else{k.toggle();}this.fireEvent("enterKeyPressed",k);b.preventDefault(l);break;case g.HOME:j=this.getRoot();if(j.children.length){j=j.children[0];}if(j._canHaveFocus()){j.focus();}b.preventDefault(l);break;case g.END:j=j.parent.children;j=j[j.length-1];if(j._canHaveFocus()){j.focus();}b.preventDefault(l);break;case 107:case 187:if(l.shiftKey){k.parent.expandAll();}else{k.expand();}break;case 109:case 189:if(l.shiftKey){k.parent.collapseAll();}else{k.collapse();}break;default:break;}},render:function(){var g=this.root.getHtml(),h=this.getEl();h.innerHTML=g;if(!this._hasEvents){b.on(h,"click",this._onClickEvent,this,true);b.on(h,"dblclick",this._onDblClickEvent,this,true);b.on(h,"mouseover",this._onMouseOverEvent,this,true);b.on(h,"mouseout",this._onMouseOutEvent,this,true);b.on(h,"keydown",this._onKeyDownEvent,this,true);}this._hasEvents=true;},getEl:function(){if(!this._el){this._el=d.get(this.id);}return this._el;},regNode:function(g){this._nodes[g.index]=g;},getRoot:function(){return this.root;},setDynamicLoad:function(g,h){this.root.setDynamicLoad(g,h);},expandAll:function(){if(!this.locked){this.root.expandAll();}},collapseAll:function(){if(!this.locked){this.root.collapseAll();}},getNodeByIndex:function(h){var g=this._nodes[h];return(g)?g:null;},getNodeByProperty:function(j,h){for(var g in this._nodes){if(this._nodes.hasOwnProperty(g)){var k=this._nodes[g];if((j in k&&k[j]==h)||(k.data&&h==k.data[j])){return k;}}}return null;},getNodesByProperty:function(k,j){var g=[];for(var h in this._nodes){if(this._nodes.hasOwnProperty(h)){var l=this._nodes[h];if((k in l&&l[k]==j)||(l.data&&j==l.data[k])){g.push(l);}}}return(g.length)?g:null;},getNodesBy:function(j){var g=[];for(var h in this._nodes){if(this._nodes.hasOwnProperty(h)){var k=this._nodes[h];if(j(k)){g.push(k);}}}return(g.length)?g:null;},getNodeByElement:function(i){var j=i,g,h=/ygtv([^\d]*)(.*)/;do{if(j&&j.id){g=j.id.match(h);if(g&&g[2]){return this.getNodeByIndex(g[2]);}}j=j.parentNode;if(!j||!j.tagName){break;}}while(j.id!==this.id&&j.tagName.toLowerCase()!=="body");return null;},getHighlightedNode:function(){return this._currentlyHighlighted;},removeNode:function(h,g){if(h.isRoot()){return false;}var i=h.parent;if(i.parent){i=i.parent;}this._deleteNode(h);if(g&&i&&i.childrenRendered){i.refresh();}return true;},_removeChildren_animComplete:function(g){this.unsubscribe(this._removeChildren_animComplete);this.removeChildren(g.node);},removeChildren:function(g){if(g.expanded){if(this._collapseAnim){this.subscribe("animComplete",this._removeChildren_animComplete,this,true);e.Node.prototype.collapse.call(g);return;}g.collapse();}while(g.children.length){this._deleteNode(g.children[0]);}if(g.isRoot()){e.Node.prototype.expand.call(g);}g.childrenRendered=false;g.dynamicLoadComplete=false;g.updateIcon();},_deleteNode:function(g){this.removeChildren(g);this.popNode(g);},popNode:function(k){var l=k.parent;var h=[];for(var j=0,g=l.children.length;j<g;++j){if(l.children[j]!=k){h[h.length]=l.children[j];}}l.children=h;l.childrenRendered=false;if(k.previousSibling){k.previousSibling.nextSibling=k.nextSibling;}if(k.nextSibling){k.nextSibling.previousSibling=k.previousSibling;}if(this.currentFocus==k){this.currentFocus=null;}if(this._currentlyHighlighted==k){this._currentlyHighlighted=null;}k.parent=null;k.previousSibling=null;k.nextSibling=null;k.tree=null;delete this._nodes[k.index];},destroy:function(){if(this._destroyEditor){this._destroyEditor();}var h=this.getEl();b.removeListener(h,"click");b.removeListener(h,"dblclick");b.removeListener(h,"mouseover");b.removeListener(h,"mouseout");b.removeListener(h,"keydown");for(var g=0;g<this._nodes.length;g++){var j=this._nodes[g];if(j&&j.destroy){j.destroy();}}h.innerHTML="";this._hasEvents=false;},toString:function(){return"TreeView "+this.id;},getNodeCount:function(){return this.getRoot().getNodeCount();},getTreeDefinition:function(){return this.getRoot().getNodeDefinition();},onExpand:function(g){},onCollapse:function(g){},setNodesProperty:function(g,i,h){this.root.setNodesProperty(g,i);if(h){this.root.refresh();}},onEventToggleHighlight:function(h){var g;if("node" in h&&h.node instanceof e.Node){g=h.node;}else{if(h instanceof e.Node){g=h;}else{return false;}}g.toggleHighlight();return false;}};var a=c.prototype;a.draw=a.render;YAHOO.augment(c,YAHOO.util.EventProvider);c.nodeCount=0;c.trees=[];c.getTree=function(h){var g=c.trees[h];return(g)?g:null;};c.getNode=function(h,i){var g=c.getTree(h);return(g)?g.getNodeByIndex(i):null;};c.FOCUS_CLASS_NAME="ygtvfocus";})();(function(){var b=YAHOO.util.Dom,c=YAHOO.lang,a=YAHOO.util.Event;YAHOO.widget.Node=function(f,e,d){if(f){this.init(f,e,d);}};YAHOO.widget.Node.prototype={index:0,children:null,tree:null,data:null,parent:null,depth:-1,expanded:false,multiExpand:true,renderHidden:false,childrenRendered:false,dynamicLoadComplete:false,previousSibling:null,nextSibling:null,_dynLoad:false,dataLoader:null,isLoading:false,hasIcon:true,iconMode:0,nowrap:false,isLeaf:false,contentStyle:"",contentElId:null,enableHighlight:true,highlightState:0,propagateHighlightUp:false,propagateHighlightDown:false,className:null,_type:"Node",init:function(g,f,d){this.data={};
this.children=[];this.index=YAHOO.widget.TreeView.nodeCount;++YAHOO.widget.TreeView.nodeCount;this.contentElId="ygtvcontentel"+this.index;if(c.isObject(g)){for(var e in g){if(g.hasOwnProperty(e)){if(e.charAt(0)!="_"&&!c.isUndefined(this[e])&&!c.isFunction(this[e])){this[e]=g[e];}else{this.data[e]=g[e];}}}}if(!c.isUndefined(d)){this.expanded=d;}this.createEvent("parentChange",this);if(f){f.appendChild(this);}},applyParent:function(e){if(!e){return false;}this.tree=e.tree;this.parent=e;this.depth=e.depth+1;this.tree.regNode(this);e.childrenRendered=false;for(var f=0,d=this.children.length;f<d;++f){this.children[f].applyParent(this);}this.fireEvent("parentChange");return true;},appendChild:function(e){if(this.hasChildren()){var d=this.children[this.children.length-1];d.nextSibling=e;e.previousSibling=d;}this.children[this.children.length]=e;e.applyParent(this);if(this.childrenRendered&&this.expanded){this.getChildrenEl().style.display="";}return e;},appendTo:function(d){return d.appendChild(this);},insertBefore:function(d){var f=d.parent;if(f){if(this.tree){this.tree.popNode(this);}var e=d.isChildOf(f);f.children.splice(e,0,this);if(d.previousSibling){d.previousSibling.nextSibling=this;}this.previousSibling=d.previousSibling;this.nextSibling=d;d.previousSibling=this;this.applyParent(f);}return this;},insertAfter:function(d){var f=d.parent;if(f){if(this.tree){this.tree.popNode(this);}var e=d.isChildOf(f);if(!d.nextSibling){this.nextSibling=null;return this.appendTo(f);}f.children.splice(e+1,0,this);d.nextSibling.previousSibling=this;this.previousSibling=d;this.nextSibling=d.nextSibling;d.nextSibling=this;this.applyParent(f);}return this;},isChildOf:function(e){if(e&&e.children){for(var f=0,d=e.children.length;f<d;++f){if(e.children[f]===this){return f;}}}return -1;},getSiblings:function(){var d=this.parent.children.slice(0);for(var e=0;e<d.length&&d[e]!=this;e++){}d.splice(e,1);if(d.length){return d;}return null;},showChildren:function(){if(!this.tree.animateExpand(this.getChildrenEl(),this)){if(this.hasChildren()){this.getChildrenEl().style.display="";}}},hideChildren:function(){if(!this.tree.animateCollapse(this.getChildrenEl(),this)){this.getChildrenEl().style.display="none";}},getElId:function(){return"ygtv"+this.index;},getChildrenElId:function(){return"ygtvc"+this.index;},getToggleElId:function(){return"ygtvt"+this.index;},getEl:function(){return b.get(this.getElId());},getChildrenEl:function(){return b.get(this.getChildrenElId());},getToggleEl:function(){return b.get(this.getToggleElId());},getContentEl:function(){return b.get(this.contentElId);},collapse:function(){if(!this.expanded){return;}var d=this.tree.onCollapse(this);if(false===d){return;}d=this.tree.fireEvent("collapse",this);if(false===d){return;}if(!this.getEl()){this.expanded=false;}else{this.hideChildren();this.expanded=false;this.updateIcon();}d=this.tree.fireEvent("collapseComplete",this);},expand:function(f){if(this.isLoading||(this.expanded&&!f)){return;}var d=true;if(!f){d=this.tree.onExpand(this);if(false===d){return;}d=this.tree.fireEvent("expand",this);}if(false===d){return;}if(!this.getEl()){this.expanded=true;return;}if(!this.childrenRendered){this.getChildrenEl().innerHTML=this.renderChildren();}else{}this.expanded=true;this.updateIcon();if(this.isLoading){this.expanded=false;return;}if(!this.multiExpand){var g=this.getSiblings();for(var e=0;g&&e<g.length;++e){if(g[e]!=this&&g[e].expanded){g[e].collapse();}}}this.showChildren();d=this.tree.fireEvent("expandComplete",this);},updateIcon:function(){if(this.hasIcon){var d=this.getToggleEl();if(d){d.className=d.className.replace(/\bygtv(([tl][pmn]h?)|(loading))\b/gi,this.getStyle());}}d=b.get("ygtvtableel"+this.index);if(d){if(this.expanded){b.replaceClass(d,"ygtv-collapsed","ygtv-expanded");}else{b.replaceClass(d,"ygtv-expanded","ygtv-collapsed");}}},getStyle:function(){if(this.isLoading){return"ygtvloading";}else{var e=(this.nextSibling)?"t":"l";var d="n";if(this.hasChildren(true)||(this.isDynamic()&&!this.getIconMode())){d=(this.expanded)?"m":"p";}return"ygtv"+e+d;}},getHoverStyle:function(){var d=this.getStyle();if(this.hasChildren(true)&&!this.isLoading){d+="h";}return d;},expandAll:function(){var d=this.children.length;for(var e=0;e<d;++e){var f=this.children[e];if(f.isDynamic()){break;}else{if(!f.multiExpand){break;}else{f.expand();f.expandAll();}}}},collapseAll:function(){for(var d=0;d<this.children.length;++d){this.children[d].collapse();this.children[d].collapseAll();}},setDynamicLoad:function(d,e){if(d){this.dataLoader=d;this._dynLoad=true;}else{this.dataLoader=null;this._dynLoad=false;}if(e){this.iconMode=e;}},isRoot:function(){return(this==this.tree.root);},isDynamic:function(){if(this.isLeaf){return false;}else{return(!this.isRoot()&&(this._dynLoad||this.tree.root._dynLoad));}},getIconMode:function(){return(this.iconMode||this.tree.root.iconMode);},hasChildren:function(d){if(this.isLeaf){return false;}else{return(this.children.length>0||(d&&this.isDynamic()&&!this.dynamicLoadComplete));}},toggle:function(){if(!this.tree.locked&&(this.hasChildren(true)||this.isDynamic())){if(this.expanded){this.collapse();}else{this.expand();}}},getHtml:function(){this.childrenRendered=false;return['<div class="ygtvitem" id="',this.getElId(),'">',this.getNodeHtml(),this.getChildrenHtml(),"</div>"].join("");},getChildrenHtml:function(){var d=[];d[d.length]='<div class="ygtvchildren" id="'+this.getChildrenElId()+'"';if(!this.expanded||!this.hasChildren()){d[d.length]=' style="display:none;"';}d[d.length]=">";if((this.hasChildren(true)&&this.expanded)||(this.renderHidden&&!this.isDynamic())){d[d.length]=this.renderChildren();}d[d.length]="</div>";return d.join("");},renderChildren:function(){var d=this;if(this.isDynamic()&&!this.dynamicLoadComplete){this.isLoading=true;this.tree.locked=true;if(this.dataLoader){setTimeout(function(){d.dataLoader(d,function(){d.loadComplete();});},10);}else{if(this.tree.root.dataLoader){setTimeout(function(){d.tree.root.dataLoader(d,function(){d.loadComplete();
});},10);}else{return"Error: data loader not found or not specified.";}}return"";}else{return this.completeRender();}},completeRender:function(){var e=[];for(var d=0;d<this.children.length;++d){e[e.length]=this.children[d].getHtml();}this.childrenRendered=true;return e.join("");},loadComplete:function(){this.getChildrenEl().innerHTML=this.completeRender();if(this.propagateHighlightDown){if(this.highlightState===1&&!this.tree.singleNodeHighlight){for(var d=0;d<this.children.length;d++){this.children[d].highlight(true);}}else{if(this.highlightState===0||this.tree.singleNodeHighlight){for(d=0;d<this.children.length;d++){this.children[d].unhighlight(true);}}}}this.dynamicLoadComplete=true;this.isLoading=false;this.expand(true);this.tree.locked=false;},getAncestor:function(e){if(e>=this.depth||e<0){return null;}var d=this.parent;while(d.depth>e){d=d.parent;}return d;},getDepthStyle:function(d){return(this.getAncestor(d).nextSibling)?"ygtvdepthcell":"ygtvblankdepthcell";},getNodeHtml:function(){var e=[];e[e.length]='<table id="ygtvtableel'+this.index+'" border="0" cellpadding="0" cellspacing="0" class="ygtvtable ygtvdepth'+this.depth;e[e.length]=" ygtv-"+(this.expanded?"expanded":"collapsed");if(this.enableHighlight){e[e.length]=" ygtv-highlight"+this.highlightState;}if(this.className){e[e.length]=" "+this.className;}e[e.length]='"><tr class="ygtvrow">';for(var d=0;d<this.depth;++d){e[e.length]='<td class="ygtvcell '+this.getDepthStyle(d)+'"><div class="ygtvspacer"></div></td>';}if(this.hasIcon){e[e.length]='<td id="'+this.getToggleElId();e[e.length]='" class="ygtvcell ';e[e.length]=this.getStyle();e[e.length]='"><a href="#" class="ygtvspacer">&#160;</a></td>';}e[e.length]='<td id="'+this.contentElId;e[e.length]='" class="ygtvcell ';e[e.length]=this.contentStyle+' ygtvcontent" ';e[e.length]=(this.nowrap)?' nowrap="nowrap" ':"";e[e.length]=" >";e[e.length]=this.getContentHtml();e[e.length]="</td></tr></table>";return e.join("");},getContentHtml:function(){return"";},refresh:function(){this.getChildrenEl().innerHTML=this.completeRender();if(this.hasIcon){var d=this.getToggleEl();if(d){d.className=d.className.replace(/\bygtv[lt][nmp]h*\b/gi,this.getStyle());}}},toString:function(){return this._type+" ("+this.index+")";},_focusHighlightedItems:[],_focusedItem:null,_canHaveFocus:function(){return this.getEl().getElementsByTagName("a").length>0;},_removeFocus:function(){if(this._focusedItem){a.removeListener(this._focusedItem,"blur");this._focusedItem=null;}var d;while((d=this._focusHighlightedItems.shift())){b.removeClass(d,YAHOO.widget.TreeView.FOCUS_CLASS_NAME);}},focus:function(){var f=false,d=this;if(this.tree.currentFocus){this.tree.currentFocus._removeFocus();}var e=function(g){if(g.parent){e(g.parent);g.parent.expand();}};e(this);b.getElementsBy(function(g){return(/ygtv(([tl][pmn]h?)|(content))/).test(g.className);},"td",d.getEl().firstChild,function(h){b.addClass(h,YAHOO.widget.TreeView.FOCUS_CLASS_NAME);if(!f){var g=h.getElementsByTagName("a");if(g.length){g=g[0];g.focus();d._focusedItem=g;a.on(g,"blur",function(){d.tree.fireEvent("focusChanged",{oldNode:d.tree.currentFocus,newNode:null});d.tree.currentFocus=null;d._removeFocus();});f=true;}}d._focusHighlightedItems.push(h);});if(f){this.tree.fireEvent("focusChanged",{oldNode:this.tree.currentFocus,newNode:this});this.tree.currentFocus=this;}else{this.tree.fireEvent("focusChanged",{oldNode:d.tree.currentFocus,newNode:null});this.tree.currentFocus=null;this._removeFocus();}return f;},getNodeCount:function(){for(var d=0,e=0;d<this.children.length;d++){e+=this.children[d].getNodeCount();}return e+1;},getNodeDefinition:function(){if(this.isDynamic()){return false;}var g,d=c.merge(this.data),f=[];if(this.expanded){d.expanded=this.expanded;}if(!this.multiExpand){d.multiExpand=this.multiExpand;}if(this.renderHidden){d.renderHidden=this.renderHidden;}if(!this.hasIcon){d.hasIcon=this.hasIcon;}if(this.nowrap){d.nowrap=this.nowrap;}if(this.className){d.className=this.className;}if(this.editable){d.editable=this.editable;}if(!this.enableHighlight){d.enableHighlight=this.enableHighlight;}if(this.highlightState){d.highlightState=this.highlightState;}if(this.propagateHighlightUp){d.propagateHighlightUp=this.propagateHighlightUp;}if(this.propagateHighlightDown){d.propagateHighlightDown=this.propagateHighlightDown;}d.type=this._type;for(var e=0;e<this.children.length;e++){g=this.children[e].getNodeDefinition();if(g===false){return false;}f.push(g);}if(f.length){d.children=f;}return d;},getToggleLink:function(){return"return false;";},setNodesProperty:function(d,g,f){if(d.charAt(0)!="_"&&!c.isUndefined(this[d])&&!c.isFunction(this[d])){this[d]=g;}else{this.data[d]=g;}for(var e=0;e<this.children.length;e++){this.children[e].setNodesProperty(d,g);}if(f){this.refresh();}},toggleHighlight:function(){if(this.enableHighlight){if(this.highlightState==1){this.unhighlight();}else{this.highlight();}}},highlight:function(e){if(this.enableHighlight){if(this.tree.singleNodeHighlight){if(this.tree._currentlyHighlighted){this.tree._currentlyHighlighted.unhighlight(e);}this.tree._currentlyHighlighted=this;}this.highlightState=1;this._setHighlightClassName();if(!this.tree.singleNodeHighlight){if(this.propagateHighlightDown){for(var d=0;d<this.children.length;d++){this.children[d].highlight(true);}}if(this.propagateHighlightUp){if(this.parent){this.parent._childrenHighlighted();}}}if(!e){this.tree.fireEvent("highlightEvent",this);}}},unhighlight:function(e){if(this.enableHighlight){this.tree._currentlyHighlighted=null;this.highlightState=0;this._setHighlightClassName();if(!this.tree.singleNodeHighlight){if(this.propagateHighlightDown){for(var d=0;d<this.children.length;d++){this.children[d].unhighlight(true);}}if(this.propagateHighlightUp){if(this.parent){this.parent._childrenHighlighted();}}}if(!e){this.tree.fireEvent("highlightEvent",this);}}},_childrenHighlighted:function(){var f=false,e=false;if(this.enableHighlight){for(var d=0;d<this.children.length;d++){switch(this.children[d].highlightState){case 0:e=true;
break;case 1:f=true;break;case 2:f=e=true;break;}}if(f&&e){this.highlightState=2;}else{if(f){this.highlightState=1;}else{this.highlightState=0;}}this._setHighlightClassName();if(this.propagateHighlightUp){if(this.parent){this.parent._childrenHighlighted();}}}},_setHighlightClassName:function(){var d=b.get("ygtvtableel"+this.index);if(d){d.className=d.className.replace(/\bygtv-highlight\d\b/gi,"ygtv-highlight"+this.highlightState);}}};YAHOO.augment(YAHOO.widget.Node,YAHOO.util.EventProvider);})();YAHOO.widget.RootNode=function(a){this.init(null,null,true);this.tree=a;};YAHOO.extend(YAHOO.widget.RootNode,YAHOO.widget.Node,{_type:"RootNode",getNodeHtml:function(){return"";},toString:function(){return this._type;},loadComplete:function(){this.tree.draw();},getNodeCount:function(){for(var a=0,b=0;a<this.children.length;a++){b+=this.children[a].getNodeCount();}return b;},getNodeDefinition:function(){for(var c,a=[],b=0;b<this.children.length;b++){c=this.children[b].getNodeDefinition();if(c===false){return false;}a.push(c);}return a;},collapse:function(){},expand:function(){},getSiblings:function(){return null;},focus:function(){}});(function(){var b=YAHOO.util.Dom,c=YAHOO.lang,a=YAHOO.util.Event;YAHOO.widget.TextNode=function(f,e,d){if(f){if(c.isString(f)){f={label:f};}this.init(f,e,d);this.setUpLabel(f);}};YAHOO.extend(YAHOO.widget.TextNode,YAHOO.widget.Node,{labelStyle:"ygtvlabel",labelElId:null,label:null,title:null,href:null,target:"_self",_type:"TextNode",setUpLabel:function(d){if(c.isString(d)){d={label:d};}else{if(d.style){this.labelStyle=d.style;}}this.label=d.label;this.labelElId="ygtvlabelel"+this.index;},getLabelEl:function(){return b.get(this.labelElId);},getContentHtml:function(){var d=[];d[d.length]=this.href?"<a":"<span";d[d.length]=' id="'+c.escapeHTML(this.labelElId)+'"';d[d.length]=' class="'+c.escapeHTML(this.labelStyle)+'"';if(this.href){d[d.length]=' href="'+c.escapeHTML(this.href)+'"';d[d.length]=' target="'+c.escapeHTML(this.target)+'"';}if(this.title){d[d.length]=' title="'+c.escapeHTML(this.title)+'"';}d[d.length]=" >";d[d.length]=c.escapeHTML(this.label);d[d.length]=this.href?"</a>":"</span>";return d.join("");},getNodeDefinition:function(){var d=YAHOO.widget.TextNode.superclass.getNodeDefinition.call(this);if(d===false){return false;}d.label=this.label;if(this.labelStyle!="ygtvlabel"){d.style=this.labelStyle;}if(this.title){d.title=this.title;}if(this.href){d.href=this.href;}if(this.target!="_self"){d.target=this.target;}return d;},toString:function(){return YAHOO.widget.TextNode.superclass.toString.call(this)+": "+this.label;},onLabelClick:function(){return false;},refresh:function(){YAHOO.widget.TextNode.superclass.refresh.call(this);var d=this.getLabelEl();d.innerHTML=this.label;if(d.tagName.toUpperCase()=="A"){d.href=this.href;d.target=this.target;}}});})();YAHOO.widget.MenuNode=function(c,b,a){YAHOO.widget.MenuNode.superclass.constructor.call(this,c,b,a);this.multiExpand=false;};YAHOO.extend(YAHOO.widget.MenuNode,YAHOO.widget.TextNode,{_type:"MenuNode"});(function(){var b=YAHOO.util.Dom,c=YAHOO.lang,a=YAHOO.util.Event;var d=function(h,g,f,e){if(h){this.init(h,g,f);this.initContent(h,e);}};YAHOO.widget.HTMLNode=d;YAHOO.extend(d,YAHOO.widget.Node,{contentStyle:"ygtvhtml",html:null,_type:"HTMLNode",initContent:function(f,e){this.setHtml(f);this.contentElId="ygtvcontentel"+this.index;if(!c.isUndefined(e)){this.hasIcon=e;}},setHtml:function(f){this.html=(c.isObject(f)&&"html" in f)?f.html:f;var e=this.getContentEl();if(e){if(f.nodeType&&f.nodeType==1&&f.tagName){e.innerHTML="";}else{e.innerHTML=this.html;}}},getContentHtml:function(){if(typeof this.html==="string"){return this.html;}else{d._deferredNodes.push(this);if(!d._timer){d._timer=window.setTimeout(function(){var e;while((e=d._deferredNodes.pop())){e.getContentEl().appendChild(e.html);}d._timer=null;},0);}return"";}},getNodeDefinition:function(){var e=d.superclass.getNodeDefinition.call(this);if(e===false){return false;}e.html=this.html;return e;}});d._deferredNodes=[];d._timer=null;})();(function(){var b=YAHOO.util.Dom,c=YAHOO.lang,a=YAHOO.util.Event,d=YAHOO.widget.Calendar;YAHOO.widget.DateNode=function(g,f,e){YAHOO.widget.DateNode.superclass.constructor.call(this,g,f,e);};YAHOO.extend(YAHOO.widget.DateNode,YAHOO.widget.TextNode,{_type:"DateNode",calendarConfig:null,fillEditorContainer:function(g){var h,f=g.inputContainer;if(c.isUndefined(d)){b.replaceClass(g.editorPanel,"ygtv-edit-DateNode","ygtv-edit-TextNode");YAHOO.widget.DateNode.superclass.fillEditorContainer.call(this,g);return;}if(g.nodeType!=this._type){g.nodeType=this._type;g.saveOnEnter=false;g.node.destroyEditorContents(g);g.inputObject=h=new d(f.appendChild(document.createElement("div")));if(this.calendarConfig){h.cfg.applyConfig(this.calendarConfig,true);h.cfg.fireQueue();}h.selectEvent.subscribe(function(){this.tree._closeEditor(true);},this,true);}else{h=g.inputObject;}g.oldValue=this.label;h.cfg.setProperty("selected",this.label,false);var i=h.cfg.getProperty("DATE_FIELD_DELIMITER");var e=this.label.split(i);h.cfg.setProperty("pagedate",e[h.cfg.getProperty("MDY_MONTH_POSITION")-1]+i+e[h.cfg.getProperty("MDY_YEAR_POSITION")-1]);h.cfg.fireQueue();h.render();h.oDomContainer.focus();},getEditorValue:function(f){if(c.isUndefined(d)){return f.inputElement.value;}else{var h=f.inputObject,g=h.getSelectedDates()[0],e=[];e[h.cfg.getProperty("MDY_DAY_POSITION")-1]=g.getDate();e[h.cfg.getProperty("MDY_MONTH_POSITION")-1]=g.getMonth()+1;e[h.cfg.getProperty("MDY_YEAR_POSITION")-1]=g.getFullYear();return e.join(h.cfg.getProperty("DATE_FIELD_DELIMITER"));}},displayEditedValue:function(g,e){var f=e.node;f.label=g;f.getLabelEl().innerHTML=g;},getNodeDefinition:function(){var e=YAHOO.widget.DateNode.superclass.getNodeDefinition.call(this);if(e===false){return false;}if(this.calendarConfig){e.calendarConfig=this.calendarConfig;}return e;}});})();(function(){var e=YAHOO.util.Dom,f=YAHOO.lang,b=YAHOO.util.Event,d=YAHOO.widget.TreeView,c=d.prototype;d.editorData={active:false,whoHasIt:null,nodeType:null,editorPanel:null,inputContainer:null,buttonsContainer:null,node:null,saveOnEnter:true,oldValue:undefined};
c.validator=null;c._initEditor=function(){this.createEvent("editorSaveEvent",this);this.createEvent("editorCancelEvent",this);};c._nodeEditing=function(m){if(m.fillEditorContainer&&m.editable){var i,k,l,j,h=d.editorData;h.active=true;h.whoHasIt=this;if(!h.nodeType){h.editorPanel=i=this.getEl().appendChild(document.createElement("div"));e.addClass(i,"ygtv-label-editor");i.tabIndex=0;l=h.buttonsContainer=i.appendChild(document.createElement("div"));e.addClass(l,"ygtv-button-container");j=l.appendChild(document.createElement("button"));e.addClass(j,"ygtvok");j.innerHTML=" ";j=l.appendChild(document.createElement("button"));e.addClass(j,"ygtvcancel");j.innerHTML=" ";b.on(l,"click",function(q){var r=b.getTarget(q),o=d.editorData,p=o.node,n=o.whoHasIt;if(e.hasClass(r,"ygtvok")){b.stopEvent(q);n._closeEditor(true);}if(e.hasClass(r,"ygtvcancel")){b.stopEvent(q);n._closeEditor(false);}});h.inputContainer=i.appendChild(document.createElement("div"));e.addClass(h.inputContainer,"ygtv-input");b.on(i,"keydown",function(q){var p=d.editorData,n=YAHOO.util.KeyListener.KEY,o=p.whoHasIt;switch(q.keyCode){case n.ENTER:b.stopEvent(q);if(p.saveOnEnter){o._closeEditor(true);}break;case n.ESCAPE:b.stopEvent(q);o._closeEditor(false);break;}});}else{i=h.editorPanel;}h.node=m;if(h.nodeType){e.removeClass(i,"ygtv-edit-"+h.nodeType);}e.addClass(i," ygtv-edit-"+m._type);e.setStyle(i,"display","block");e.setXY(i,e.getXY(m.getContentEl()));i.focus();m.fillEditorContainer(h);return true;}};c.onEventEditNode=function(h){if(h instanceof YAHOO.widget.Node){h.editNode();}else{if(h.node instanceof YAHOO.widget.Node){h.node.editNode();}}return false;};c._closeEditor=function(j){var h=d.editorData,i=h.node,k=true;if(!i||!h.active){return;}if(j){k=h.node.saveEditorValue(h)!==false;}else{this.fireEvent("editorCancelEvent",i);}if(k){e.setStyle(h.editorPanel,"display","none");h.active=false;i.focus();}};c._destroyEditor=function(){var h=d.editorData;if(h&&h.nodeType&&(!h.active||h.whoHasIt===this)){b.removeListener(h.editorPanel,"keydown");b.removeListener(h.buttonContainer,"click");h.node.destroyEditorContents(h);document.body.removeChild(h.editorPanel);h.nodeType=h.editorPanel=h.inputContainer=h.buttonsContainer=h.whoHasIt=h.node=null;h.active=false;}};var g=YAHOO.widget.Node.prototype;g.editable=false;g.editNode=function(){this.tree._nodeEditing(this);};g.fillEditorContainer=null;g.destroyEditorContents=function(h){b.purgeElement(h.inputContainer,true);h.inputContainer.innerHTML="";};g.saveEditorValue=function(h){var j=h.node,k,i=j.tree.validator;k=this.getEditorValue(h);if(f.isFunction(i)){k=i(k,h.oldValue,j);if(f.isUndefined(k)){return false;}}if(this.tree.fireEvent("editorSaveEvent",{newValue:k,oldValue:h.oldValue,node:j})!==false){this.displayEditedValue(k,h);}};g.getEditorValue=function(h){};g.displayEditedValue=function(i,h){};var a=YAHOO.widget.TextNode.prototype;a.fillEditorContainer=function(i){var h;if(i.nodeType!=this._type){i.nodeType=this._type;i.saveOnEnter=true;i.node.destroyEditorContents(i);i.inputElement=h=i.inputContainer.appendChild(document.createElement("input"));}else{h=i.inputElement;}i.oldValue=this.label;h.value=this.label;h.focus();h.select();};a.getEditorValue=function(h){return h.inputElement.value;};a.displayEditedValue=function(j,h){var i=h.node;i.label=j;i.getLabelEl().innerHTML=j;};a.destroyEditorContents=function(h){h.inputContainer.innerHTML="";};})();YAHOO.widget.TVAnim=function(){return{FADE_IN:"TVFadeIn",FADE_OUT:"TVFadeOut",getAnim:function(b,a,c){if(YAHOO.widget[b]){return new YAHOO.widget[b](a,c);}else{return null;}},isValid:function(a){return(YAHOO.widget[a]);}};}();YAHOO.widget.TVFadeIn=function(a,b){this.el=a;this.callback=b;};YAHOO.widget.TVFadeIn.prototype={animate:function(){var e=this;var d=this.el.style;d.opacity=0.1;d.filter="alpha(opacity=10)";d.display="";var c=0.4;var b=new YAHOO.util.Anim(this.el,{opacity:{from:0.1,to:1,unit:""}},c);b.onComplete.subscribe(function(){e.onComplete();});b.animate();},onComplete:function(){this.callback();},toString:function(){return"TVFadeIn";}};YAHOO.widget.TVFadeOut=function(a,b){this.el=a;this.callback=b;};YAHOO.widget.TVFadeOut.prototype={animate:function(){var d=this;var c=0.4;var b=new YAHOO.util.Anim(this.el,{opacity:{from:1,to:0.1,unit:""}},c);b.onComplete.subscribe(function(){d.onComplete();});b.animate();},onComplete:function(){var a=this.el.style;a.display="none";a.opacity=1;a.filter="alpha(opacity=100)";this.callback();},toString:function(){return"TVFadeOut";}};YAHOO.register("treeview",YAHOO.widget.TreeView,{version:"2.9.0",build:"2800"});
/*
    jQuery.qlist.js
    fixed header, column reorder/resize, row reorder, column filter
    category/section view, paging

    Partial documentation is available at
    http://wiki.fortinet.com/twiki/bin/view/Developers/QListjQueryPluginDocs
    Please update the documentation when you make a change to this file
 */
/*global qlist_obj,qlist_handle_selection_change, qlist_onclick_delete,
FIELD_TYPE, DISPLAY_FILTER_TYPE_SELECT_MULTIPLE,
CMDB,Notify*/
// from qed_menu.js
/*global qMenuClick, Page, qmenu_create_menubar, add_new_menu_items */
// from qlist_utils.js
/*global convert_button_to_droplist, fixup_droplist_alignment*/
// from qlist.cmdb.js
/*global QListSource, getQueryValue*/
// from Util.js, fweb.js
/*global setCookie,getCookie,removeCookie,fweb*/
// from Check_Input.js
/*global change_icon*/
//from module_js/filter.js
/*global filterLoadResource, setFilterDetails, filter_settings*/
//file-local globals
/*global get_new_display_master, sorting_cookie_data, _do_sort */
// from qlist.sort.js
/*global YAHOO, jQuery*/
/*global is_rw_admin:true*/
/*global gui_lines_per_page*/

/*jshint maxlen: 120*/
//max time per fragment instead of fixed count
//shaves off 500ms with 4096 rows on interface list
var MAX_FRAG_TIME = 150;

(function($) {
    'use strict';

    /*
     * for $.qlist extension & plug-in EXTEND ONLY, do not replacing it
     * e.g. $.extend($.qlist.format_fn, {...});
     */
    if (!$.qlist) {
        $.qlist = {
            'format_fn': {}
        };
    }

    // the first time this function is called, the param is returned;
    // on every consecutive call, nothing is returned
    var get_urlparam_once = fweb.util.dom.getUrlparamOnce,
        try_JSON_parse = fweb.util.dom.try_JSON_parse;

    var qlist;
    $.fn.qlist = function(parameters, value) {
        var that = this;

        // these menu items are handled specially,
        // since they are hard-coded into the qlist config
        var skip_menu_items = ['create_new', 'edit', 'delete'];

        // attributes append to each row
        var default_row_attr = [
            {'name': 'mkey', 'selector': 'name'},
            {'name': 'q_type', 'selector': 'q_type'},
            {'name': 'q_type_extra', 'selector': 'q_type_extra'},
            {'name': 'q_ref', 'selector': 'q_ref'},
            {'name': 'q_static', 'selector': 'q_static'}
        ];

        /** @typedef $.qlist~defaults */
        /*jshint unused: vars*/
        var defaults = {
            'source': [], // the data source for the list
            // columns with attrs:
            // - selector (attr name of the row)
            // - lang_key (key of the lang entries for the column name)
            // - fixed (if true, can't be hidden using Column Settings)
            // - hidden (if true, hidden from column context menu)
            'columns': [],
            // used to put html attributes on to individual rows.
            // name is the name of the attribute, selector is the key in the
            // object selector can also be '__index__', which will instead
            // use the index in the source array ideally, __index__ can be
            // the only row_attr you need
            'row_attr': [],
            'default_columns': [],      // default display columns

            // compare fn for sort data source
            'sort_compare': default_compare,

            'categories': [],           // data group by columns
            // sort function for categories display order, false/null to
            // disable sort
            'sort_categories_fn': function(a, b) {
                return a.localeCompare(b);
            },

            'sections': [],             // rows split by columns
            // sort function for sections display order, false/null to disable sort
            'sort_sections_fn': default_compare,

            // see qlist/qlist.sort.js for column sorting defaults

            // row_gen(rowIndex, entry) - the table row generator callback
            // apply customization to particular row
            'row_gen': function(rowIndex, entry) {},

            // 'sort_fn' - see qlist/qlist.sort.js

            // cell_gen function (td, selector, entry)
            'format_fn': $.extend({}, $.qlist.format_fn),

            // col_filter function (flt, entry)
            'filter_fn': {
                '*': default_filter_fn
            },
            // filter function used to hide specific elements when they are added

            // this option will replace the default qlist context behavior. Submenus
            // will not be 'flattened' as they are normally. Additionally, if the
            // 'menuitems' property of an item is a function, that function will be
            // called each time the menu is rendered allowing the contents of the
            // submenu to change dynamically based on the selection context.
            //
            // NOTE: default menu options like edit and delete are not currently
            // included in the menu. For these options, you'll need to add explicit
            // items for them to menu_items.
            'enhanced_context': false,

            // In many places, the filter function is being overridden in order to
            //  add data to entries before they are written. This behaviour should
            //  be preserved, but default_filter should still be able to operate
            //  when column filters are enabled.

            // so, column filtering should be moved out of this function to
            //  something defined in 'column_filters'

            'filter': function(entry) { return true; },

            'title': '',                // title show on menubar

            // DEPRECATED -- use categories/sections instead
            'category': {
                'sorted': true, // sort categories
                'collapsible': true, // categories can be collapsed/expanded by default
                'editable': false, // categories not editable by default
                'q_type': null
            },

            checkboxes: {
                enabled: true //show checkboxes by default
                                    // (or don't create if the option is false)
            },

            //WARNING: for correct paging controls positioning
            //the initial div for showing qlist should be included
            //in another div
            paging: {
                enabled: false, // paging is disabled by default
                server_side: false, // client side paging by default
                hybrid_server_paging: false, // server will return more than just
                                             // the lines needed (don't clear source
                                             // when loading a page)
                total_lines: 0, // total lines for server side paging
                // page_lines: rows per page, may have 3 values:
                // 1. 'AUTO_FIT' qlist will try to calculate
                // 2. undefined: gui_lines_per_page will be used
                // 3. a number: qlist will use that value
                page_lines: (typeof gui_lines_per_page === 'undefined') ? 0 : gui_lines_per_page,
                min_page_lines: 10, // minimum number of lines shown on a single page
                timeout: 500, //default timeout to navigate through pages
                fetch: function(page_num, cb) {}, // fetcher for server side
                show_all_button: false, // show option to show all entries on a single page
                // option to hide last page button and add '+' to total line number
                last_page_button: true
            },

            'empty_msg': $.getInfo('no_entries'), //message for empty source
            // a unique identifier used as a prefix (sometimes suffix)
            // for element ids, cookie names, and other unique tokens
            'prefix': 'qlist',
            // definition of menu_items (defaults in parenthesis):
            // {<string>:{handler:function(qlist_obj, jQuery('tr.selected')),
            //              skip:boolean(false),
            //              class:string, container_class:string,
            //              single_only:boolean(false), label:string,
            //              ctext:boolean(true), submenu:[<menu_items>]}...}
            'menu_items': {},
            'options': {
                'ref_column': false,
                'restful': false,
                'hide_checkboxes': true, // hide checkboxes
                'hide_default_buttons': false,
                'hide_create_button': false,
                'hide_edit_button': false,
                'hide_delete_button': false,
                'hide_menu': false, // hide menu toolbar
                //Show context menu clone option
                'show_clone_option': false,
                // Allow for columns to be resized?
                'resizable_columns': true,
                //bind listitem handlers even if hide_menu is true.
                //not sure why this is the default, or if it should be fixed
                'force_listitem_handlers': false,
                'disable_context_menu': false,
                // qlist body context menu will be preserved on each popup
                'static_context_menu': false,
                // in order to get fixed_header to actually work, you need to limit the
                // qlist's vertical size like so: $('#content').height($(window).height());
                'fixed_header': 'auto',
                'fixed_footer': true,
                'row_striping': true,
                // true/false: show/hide column context menu -- intended to be set by extensions
                'column_context_menu': undefined,
                'force_context_menu': false, // force the context menu on the _body_ to be shown
                // if row_attr_map.mkey is not in default columns, automatically prepend it to the
                // default columns
                'automatic_mkey_column': true,
                // These two settings can be used to disable collapsing of the sections/categories.
                // Currently, only the '*' setting should be used, as filtering on an individual
                // column is compared against the formatted value of that column, rather than the
                // column selector.
                'collapsible_sections': { '*': true },
                'collapsible_categories': { '*': true },
                // Treat sections like rows. Allow them to be selected/edited
                'editable_sections': false,
                // this enables displaying the table rows as single updates
                // if enabled, format_fn will get the row as the first param
                // not the td. It also requires that all format functions return
                // a string and not a jQuery collection.
                'atomic_render': false,
                'resize_to_parent': 'auto',
                'loading_threshold': 100,

                // Remove all layout functionality from this plugin.
                // Allow calling page to provide it's own layout using CSS
                // instead. The qlist css covers most styles with sane defaults
                // Some javascript layout is still used to sync fixed header.
                'css_layout': false,
                'sliderwidth':1000 //for slider width
            },
            'reordering': {
                enable: false,
                items: 'tr.qlist_row',
                drag: 'td:visible:first-child',
                refresh_on_drop: false,
                onDrop: default_ondrop
            },
            'column_filters': {
                'enabled': false,
                //specify the filter directly. Use this if you want to avoid filter cookies.
                'value': null,
                'exempts': ['#'],
                'log_type': 4,
                'filter_fn': default_filter,
                'server_side_reload': null,
                // use client side filters even when server side paging is on (fortiview)
                'force_client_side': false
            },
            'handle_selection_change': null,
            'cr_new_url': 'edit/',
            'cr_edit_url': 'edit/',
            'popup': false,
            'callbacks': {
                'load': null,
                'dblclick': null,
                // the callback used after navigating to any page
                'post_paging': null,
                // callback function called prior to sorting a column
                'pre_sort': null
            }
        };

        _ext_extend_defaults(defaults);

        // config for qlist
        var config = $(this).data('config') || defaults;

        if (config.options.fixed_header === 'auto') {
            config.options.fixed_header = !is_inline($(this));
        }

        if (config.options.resize_to_parent === 'auto') {
            config.options.resize_to_parent = !is_inline($(this));
        }

        if (typeof(qlist_obj) === 'undefined') {
            return this;
        }

        function refresh_qlist() {
            adjust_all_tables();
        }

        if (parameters === 'refresh') {
            refresh_qlist();
            return this;
        }

        function save_page() {
            if (config.paging.enabled) {
                var page_no = $(that).find('.page_current').val();
                if (localStorage && +page_no) {
                    localStorage.setItem(config.prefix + '/current_page', page_no);
                }
            }
        }

        if (parameters === 'reload') {
            save_page();
            // suppress the loading animation for reloads
            $(this).qlist({
                options: { loading_threshold: 0 }
            });
            return this;
        }

        if (parameters === 'config') {
            return value ? $(this).data('config', $.extend(true, config, value)) : config;
        }

        if (parameters === 'filter') {
            apply_filter(value);
            return;
        }

        // init qlist state
        var state = that.data('qlist_state');
        if (state == null) {
            that.data('qlist_state', state = {
                // mapping from display index -> source index
                // mainly used so that the source data's order isn't touched when doing
                // display sorting
                'display_master': []
            });
        }
        // remove all cache
        state.cache = {
            // source entires by entry._cache_id
            'source': {}
        };

        /** typedef $.qlist~_ext_internal_functions */
        var _ext_internal_functions = {
            adjust_all_tables: adjust_all_tables,
            qlistRefreshTable: qlist_refresh_table,
            get_column_value: get_column_value,
            get_filter_settings: get_filter_settings,
            get_filter_columns: get_filter_columns,
            add_filter: add_filter,
            apply_filter: apply_filter,
            get_filtered_lines: get_filtered_lines,
            get_complete_filter_fn: get_complete_filter_fn
        };

        var ext_command_return_value = _ext_handle_commands(parameters, that, {
            config: config,
            state: state,
            fn: _ext_internal_functions
        }, arguments);
        if (ext_command_return_value !== NOT_CALLED) {
            return ext_command_return_value;
        }

        // force array update instead of merge
        for (var x in parameters) {
            if (parameters.hasOwnProperty(x) && (x  === 'menu_items' || $.isArray(parameters[x]))) {
                delete config[x];
            }
        }

        //make sure we don't clone the source property.
        //cloning 7000 rows can take multiple seconds on slower machines
        var source;
        if ((parameters) && ('source' in parameters)) {
            source = parameters.source;
            delete parameters.source;
        }

        // Note that since Prototype extends Array.prototype, and $.extend
        // doesn't do 'hasOwnProperty' checks, all of the arrays have prototype
        // methods attached onto them.
        $(this).data('config', $.extend(true, config, parameters));
        if (source !== undefined) {
            config.source = parameters.source = source;
        }

        _ext_call('preconfigure', that, {config: config, fn: _ext_internal_functions});

        if (config.options.css_layout && !$.support.flexbox) {
            config.options.css_layout = false;
        }

        if (config.qsource instanceof QListSource) {
            config.columns = config.qsource.getColumns();
            config.row_gen = function(rowIndex, entry) {
                return config.qsource.buildRow(this, rowIndex, entry);
            };
            config.format_fn['*'] = function(td, column, entry) {
                return config.qsource.buildCell(td, column, entry);
            };
            config.source = config.qsource.getRows();
        }

        if (config.options.ref_column) {
            // set q_ref as default show column
            if (!config.column_map || !config.column_map.q_ref) {
                config.columns.push({selector: 'q_ref', lang_key: 'ref', fld_type: 'int'});
            }
            if (config.default_columns.length && config.default_columns.indexOf('q_ref') < 0) {
                config.default_columns.push('q_ref');
            }
        }

        // clear categories map cache
        delete config.categories_map;

        config.column_map = $.makeObject(config.columns, function() {
            return this.selector || (this.selector = 'id' + Math.random());
        });

        // merge default_row_attr into row_attr
        var row_attr_map = $.makeObject(config.row_attr, function() { return this.name; });

        for (var i = 0, attr; (attr = default_row_attr[i]); i++) {
            if (!row_attr_map[attr.name]) {
                config.row_attr.push(attr);
            } else {
                attr = row_attr_map[attr.name];
                if (!attr) {
                    continue;
                }
            }
            if (config.options.automatic_mkey_column &&
                    attr.name === 'mkey' && config.default_columns.length &&
                    $.inArray(attr.selector, config.default_columns) < 0) {
                var col = $.extend({ display: 1 }, config.column_map[attr.selector]);
                if (col.display) {
                    config.default_columns.unshift(attr.selector);
                }
            }
        }

        var filter = getQueryValue(window.location.href, 'filter');

        config.ck_name = {
            'column': filter ? config.prefix + '_column_settings_ext' :
                config.prefix + '_column_settings',
            'filter': filter ? config.prefix + '_filter_settings_ext' :
                config.prefix + '_filter_settings',
            'category': config.prefix + '_category_settings'
        };

        // the cookie is unique for each list,
        // so don't bother about the name
        var ck = getCookie(config.ck_name.column);
        var avail = [];
        var chosen = ck && ck.split(',') ||
            (config.default_columns.length ? config.default_columns : avail);

        $.each(config.columns, function(i, col_config) {
            if (col_config.hidden) {
                return;
            }

            avail.push(col_config.selector);

            if (!('lang_key' in col_config)) {
                col_config.lang_key = 'field_' + col_config.selector;
            }

            // old qlist config use lang_key as default_columns selector
            var n = $.inArray(col_config.lang_key, chosen);
            if (n >= 0 && col_config.selector) {
                chosen[n] = col_config.selector;
            }
            if (col_config.fixed &&
                    chosen.indexOf(col_config.selector) === -1) {
                chosen.unshift(col_config.selector);
            }
        });

        // Filter out columns which are not present in the available column list.
        // If our default column set changes, users may still have cookies with the old
        // set of columns and this causes the list page to not render at all.
        chosen = $.grep(chosen, function(column) {
            return ($.inArray(column, avail) !== -1);
        });
        config.chosen_columns = chosen;
        sort_columns(config.chosen_columns);

        //////
        // FILTER
        //////
        function add_filter(arr, flt, overwrite) {
            for (var i = 0, col; (col = arr[i]); i++) {
                if (col.id === flt.id) {
                    if (overwrite) {
                        arr[i] = flt;
                    }
                    return arr;
                }
            }
            arr.push(flt);
            return arr;
        }

        function filterSubmit(panel, event) {
            var err = false;
            var flt_arr = [],
                validateResult;
            // TODO: move all of this code into a function that can be called by an extension
            //       without having a panel
            //       see FilterContextMenu#set_qlist_filter

            panel.filterSection(function(oflt, flt) {
                // TODO: move validation into jquery.filterConsole and use jquery.validate
                // validateResult can be an array or object that contains extra information
                validateResult = flt.validate.call(this, oflt);
                err = !validateResult;
                if (err) {
                    return false;
                }
                oflt.logic.is = flt.is;
                if (oflt.value && oflt.value.join('')) {
                    flt_arr = add_filter(flt_arr, oflt);
                }
            });

            if (!err) {
                apply_filter(flt_arr);
            }

            return false;
        }

        function apply_filter(flt_arr) {
            config.column_filters.value = flt_arr;
            setCookie(config.ck_name.filter, flt_arr.length ? JSON.stringify(flt_arr) : '');
            // the cookie may have been changed by the server in an ajax call
            var filter_applied_event = $.Event('filter_applied');
            that.trigger(filter_applied_event, [flt_arr]);
            if (config.paging.server_side && !config.column_filters.force_client_side) {
                // we need load new data from server
                if ($.isFunction(config.column_filters.server_side_reload)) {
                    config.column_filters.server_side_reload();
                } else {
                    window.location.reload();
                }
            } else {
                $(that).qlist();
            }
        }

        function get_filter_settings() {
            if (config.column_filters.value) {
                return config.column_filters.value;
            }
            var paramFilter = get_urlparam_once('filter');
            var flt_arr = try_JSON_parse(getCookie(config.ck_name.filter) || '[]') || [];
            // get filter argument from urlparams
            if (typeof paramFilter !== 'undefined' &&
                typeof (paramFilter = try_JSON_parse(paramFilter)) !== 'undefined') {
                flt_arr = add_filter(flt_arr, $.extend({logic: {}, value: []}, paramFilter), true);
                setCookie(config.ck_name.filter, JSON.stringify(flt_arr));
            }
            return flt_arr;
        }

        function setup_filtering(table) {
            if (config.column_filters.enabled) {
                filterSetup(table);
            }
        }

        function filterSetup(tableId) {
            var dfd = new jQuery.Deferred();
            if (typeof filterLoadResource === 'undefined') {
                dfd = $.addScript({
                    'url': /*'/' + fweb.CONFIG_GUI_NO + */'/module_js/log/filter.js'
                });
            } else {
                dfd.resolve().promise();
            }
            dfd.done(function() {
                filterLoadResource();
                // set filter column
                $(tableId).filterConsole({
                    'columns': get_filter_columns(),
                    'filters': get_filter_settings(),
                    'action': filterSubmit,
                    'targetSelector': 'th span.filter'
                });
            });
        }
        //////

        function sort_columns(chosen) {
            //reorder columns
            config.columns.sort(function(a, b) {
                // according to chosen order
                var i = $.inArray(a.selector, chosen);
                var j = $.inArray(b.selector, chosen);
                if (i !== j) {
                    return i < 0 ? 1 : (j < 0 ? -1 : i - j);
                }
                // by display text
                return $.sortCompareText($.getInfo(a.lang_key), $.getInfo(b.lang_key));
            });
        }

        // render cell display if td != null, or get cell's value
        function get_column_value(td, selector, entry) {
            var fmt = config.format_fn[selector] || config.format_fn['*'] || entry[selector];

            if ($.isFunction(fmt)) {
                fmt = fmt(td, config.column_map[selector] || selector, entry, config.$scope);
            }

            return typeof fmt === 'undefined' ? entry[selector] : fmt;
        }

        /// snippet start default_filter_fn
        var _filter_digit_regex = /([+\-]?\d+(?:.\d+)?)/;
        function default_filter_fn(flt, entry) {
            var test = false;
            var val = get_column_value(null, flt.id, entry);
            var fld = config.column_map[flt.id];
            // invalid filter column (maybe a column was removed). Just return true.
            if (fld == null) { return true; }
            // TODO more complex compare support base on flt_type
            if (fld.fld_type === 'datetime' && flt.logic.RANGE && flt.value &&
                flt.value.length === 2) {
                // Replace dates in the format of 'yyyy-mm-dd' with 'yyyy/mm/dd' to
                // avoid browser compatibilty issues with Date.parse().
                // Reference:- http://stackoverflow.com/questions/7964922/
                var from_date = Date.parse(flt.value[0].replace(/-/g, '/')) / 1000;
                var to_date = Date.parse(flt.value[1].replace(/-/g, '/')) / 1000;
                var entry_date = entry[flt.id];

                return from_date <= entry_date &&
                       (!flt.value[1] || entry_date <= to_date);
            }
            var is_selection = !!fld.value;
            if (!$.isArray(val)) {
                test = __filter_inArray(val, flt, is_selection) >= 0;
            } else {
                // test = any(__filter_inArray(value, flt) for value in val)
                $(val).each(function(i, value) {
                    test = __filter_inArray(value, flt, is_selection) >= 0;
                    return !test;
                });
            }
            return test;
        }

        /* is_selection denotes when the filter is selected via a <select> menu */
        function __filter_inArray(value, flt, is_selection) {
            var arr = Array.isArray(flt.value) ? flt.value : [flt.value];
            // range support?
            if (flt.logic.RANGE && arr.length === 2) {
                if (config.column_map[flt.id].fld_type === 'int') {
                    if (value === '') {
                        return -1;
                    }

                    value = +(_filter_digit_regex.exec(value)[0]);
                    if (flt.logic.RANGE_EXCLUSIVE) {
                        return (value > (+arr[0]) && (arr[1] === '' || value < (+arr[1]))) - 1;
                    }
                    return (value >= (+arr[0]) && (arr[1] === '' || value <= (+arr[1]))) - 1;
                }
                if (flt.logic.RANGE_EXCLUSIVE) {
                    return value > arr[0] && (arr[1] === '' || value < arr[1]) ? 1 : -1;
                }
                return value >= arr[0] && (arr[1] === '' || value <= arr[1]) ? 1 : -1;
            }
            // if this is simple string filtering, check to see if value
            // contains one of the strings in `arr`, case insensitive
            var isString = !is_selection && $.type(value) === 'string';
            if (isString) {
                value = value.toLowerCase();
            }

            // default list compare
            for (var i = arr.length; i--;) {
                var item = arr[i];
                if (isString) {
                    // TODO: filtering should be refactored so that it doesn't filter on the html
                    // formatted string
                    if (fweb.util.htmlStringContains(value, item.toString().toLowerCase())) {
                        return i;
                    }
                } else {
                    if ($.isPlainObject(value)) {
                        for (var k in value) {
                            if (value.hasOwnProperty(k) && $.type(value[k]) === 'string' &&
                                value[k].toLowerCase().indexOf(
                                    item.toString().toLowerCase()) !== -1) {
                                return i;
                            }
                        }
                    }
                    if (String(value) === item) {
                        return i;
                    }
                }

            }
            return -1;
        }
        /// snippet end

        /// snippet start default_compare
        function default_filter(entry, filters) {
            var flt_arr = filters || get_filter_settings();
            for (var flt, i = 0; (flt = flt_arr[i]); i++) {
                var flt_fn = config.filter_fn[flt.id] || config.filter_fn['*'] || default_filter_fn;
                var ret = flt_fn(flt, entry);
                if (flt.logic.NOT === '0' &&
                    'console' in window && 'log' in console) {
                    console.log('flt.logic.NOT has invalid value \'0\', please check.');
                }
                if (ret === (!!flt.logic.NOT || false)) {
                    return false;
                }
            }
        }

        function default_compare(a, b) {
            /*jshint validthis: true */
            for (var selector, i = 0; (selector = this[i]); i++) {
                var va = get_column_value(null, selector, a);
                var vb = get_column_value(null, selector, b);
                if (va !== vb) {
                    return va > vb ? 1 : -1;
                }
            }
            return 0;
        }
        /// snippet end

        function default_ondrop(to, from, nearby) {
            var before, after;
            var qlist_source = config.source;
            var obj = qlist_source[to];

            if (to > from) {
                // move forward
                do {
                    after = qlist_source[--to].q_origin_key;
                } while (!after);
            } else {
                // move backward
                do {
                    before = qlist_source[++to].q_origin_key;
                } while (!before);
            }

            CMDB.move('', '', obj.q_origin_key, null, {
                'type': obj.q_type,
                'before': before,
                'after': after
            }).done(function(response) {
                if (response.status !== 'error') {
                    if (config.reordering.refresh_on_drop) {
                        window.location.reload();
                    }

                    Notify.post($.getInfo('changes_saved'));
                    $(config.reordering.items).each(function(i) {
                        var even = i % 2;
                        $(this).toggleClass('odd', !!even);
                    });
                } else {
                    Notify.post($.getInfo('error') + ': ' +
                        $.getInfo(response.error), 'error');
                }
            });
        }

        // sort the categories order and apply to categories cache object
        function sort_categories() {
            var sort_fn = config.sort_categories_fn;
            var implicit_category = $.getInfo('implicit');

            var map = config.categories.length ? config.categories_map : {};
            var category_list = (Object.keys || function(map) {
                    return $.map(map, function(val, key) { return key; });
                })(map);

            category_list.sort(function(a, b) {
                if (a === implicit_category) {
                    return 1;
                } else if (b === implicit_category) {
                    return -1;
                } else {
                    return sort_fn(a, b);
                }
            });

            // apply new order to categories
            var new_map = config.categories_map = {};
            $(category_list).each(function(i, x) { new_map[x] = map[x]; });

        }

        function sort_sections(source) {
            var sort_fn = config.sort_sections_fn;
            if (!$.isFunction(sort_fn)) {
                return;
            }

            source.sort(function(a, b) {
                if (a.implicit) {
                    return 1;
                } else if (b.implicit) {
                    return -1;
                }
                return sort_fn.call(config.sections, a, b);
            });
        }

        // get category label by source index
        function get_category(index) {
            var cat_name = null;

            $.each(config.categories_map || {}, function(key, arr) {
                if (index < arr.length) {
                    cat_name = key;
                    return false;
                }
                index -= arr.length;
            });

            return cat_name;
        }

        /*
           group source by categories, and sort each categories by sections(if applicable)
           1. group all the source by config.categories, and store the result in categories_map
              cache object data orders in each group are not changed (stable sort)
           2. re-construct the source array with new sorted categories/sections
         */
        function sort_source(source) {
            var sort_fn = config.sort_compare;
            var cats = config.categories;
            // map will always be a plain object, so a hasOwnProperty check isn't needed
            var map = config.categories_map = {};
            var owner = {};
            var k, entry;

            // build categories
            for (k = 0, entry; (entry = source[k]); k++) {
                var vals = [];

                if ('category' in entry) {
                    cat_add(entry.category, entry);
                    continue;
                }

                for (var i = 0; i < cats.length; i++) {
                    vals.push(get_column_value(null, cats[i], entry));
                }

                cat_add(cats_label(vals), entry);
            }

            // for entry might belong to multiple categories, and only one group return at a time.
            // it's possible this entry also belong to other group which created later,
            // if this is the case, we should do a loopback check and re-apply entry to other
            // suitable group. And should shift entry into top of missing group since entry is above
            // others on this group.
            for (k = source.length - 2; k >= 0; k--) {
                cat_add(null, source[k]);
            }

            // sort category display orders
            if ($.isFunction(config.sort_categories_fn)) {
                sort_categories();
            }

            // update source list
            source.length = 0;
            // use the sorted map cache instead of map to reflect new orders
            $.each(config.categories_map, function(key, arr) {
                // sort sections within display orders
                if (config.sections.length) {
                    sort_sections(arr);
                }
                $.merge(source, arr);
            });

            function cat_add(label, entry) {
                // existing category
                for (var x in map) {
                    if (map.hasOwnProperty(x)) {
                        // post update check for entry already exists
                        if (!label && $.inArray(entry, map[x]) >= 0) {
                            continue;
                        }

                        // check if belong to this category
                        if (sort_fn.call(cats, owner[x], entry) !== 0) {
                            continue;
                        }

                        // else post add, that means category create after entry, so this entry
                        // should above owner
                        if (label) {
                            map[x].push(entry);
                        } else {
                            map[x].unshift(entry);
                        }
                    }
                }
                // create new category if not exists
                if (label && !map[label]) {
                    owner[label] = entry;
                    map[label] = [entry];
                }
            }

            function cats_label(vals) {
                return vals.join(' - ');
            }
        }

        function get_filter_columns() {
            // convert type string to filter type
            var dict = {
                'int': FIELD_TYPE.INTEGER,
                'date': FIELD_TYPE.DATE,
                'datetime': FIELD_TYPE.DATE_TIME,
                'ip': FIELD_TYPE.IP_HOST
            };
            function default_fld_type(col) {
                // TODO get field type from qlist.cmdb
                // if (col.fld_type === FIELD_TYPE.DATE_TIME) {
                //     return FIELD_TYPE.DATE_TIME;
                // }
                if (typeof col.fld_type === 'number') {
                    return col.fld_type;
                }
                return col.values ? FIELD_TYPE.ENUM : FIELD_TYPE.STRING;
            }
            var column_objs = $.map(config.chosen_columns, function(selector) {
                var col = config.column_map[selector];
                if (col == null) { return setFilterDetails({ key: selector }); }
                var flt = {
                    key: selector,
                    label: $.getInfo(col.lang_key),
                    selection: col.values
                };
                if (col.filter) {
                    flt.validate = col.filter.validate;
                    flt.display = col.filter.display;
                    flt.support = col.filter.support;
                    flt.help = col.filter.help;
                }
                setFilterDetails(flt,
                    dict[col.fld_type] || default_fld_type(col),
                    col.fld_max || DISPLAY_FILTER_TYPE_SELECT_MULTIPLE);
                return flt;
            });
            // TODO: remove usage of this global variable, allow filterConsole
            //       to store the necessary data
            filter_settings[config.prefix] = column_objs;
            return column_objs;
        }

        function scrollbar_width() {
            // http://chris-spittles.co.uk/?p=531
            var $inner = $('<div style="width: 100%; ' +
                           'height:200px;">test</div>'),
                $outer = $('<div style="width:200px;height:150px; ' +
                           'position: absolute; top: 0; left: 0; ' +
                           'visibility: hidden; overflow:hidden;">' +
                           '</div>').append($inner),
                inner = $inner[0],
                outer = $outer[0];

            $('body').append(outer);
            var width1 = inner.offsetWidth;
            if (!config.options.css_layout) {
                $outer.css('overflow', 'scroll');
            }
            var width2 = outer.clientWidth;
            $outer.remove();

            return width1 - width2;
        }

        function get_computed_class_height(cls) {
            var div = $('<div class="' + cls + '" style="position:absolute; ' +
                        'top:-9999px;left:-9999px;">&nbsp;</div>');
            $('body').append(div);
            var h = div.outerHeight();
            div.remove();
            return h;
        }

        config.scrollbar_width = scrollbar_width();
        config.fixed_ftrbar_height = get_computed_class_height('qlist_fixed_ftrbar');
        config.hdrbar_id = config.prefix + '_qlist_hdrbar';
        config.ftrbar_id = config.prefix + '_qlist_ftrbar';
        config.hdrbar_height = get_computed_class_height('qlist_hdrbar');

        // toggle between the disabled and enabled css class of a sprite
        function _toggle_tool_sprite($el, spriteclass, enable) {
            var suffix = '0'; // could be customizable
            return $el
                .toggleClass(spriteclass, enable)
                .toggleClass(spriteclass + suffix, !enable);
        }

        // update the paging controls according to the current paging state
        function update_controls(current_page, total_pages) {
            /*jshint validthis:true*/
            var $this = $(this);
            if (current_page == null) { current_page = $this.find('.page_current').val(); }
            if (total_pages == null) { total_pages = $this.find('.page_total').text(); }

            // Normalize the values ('0' == null but a valid value too)
            current_page = +current_page;
            total_pages = +total_pages;

            var $first = $this.find('.page_first');
            var $prev = $this.find('.page_prev');
            var $next = $this.find('.page_next');
            var $last = $this.find('.page_last');

            var enable_back = current_page > 1;
            var enable_forward = current_page < total_pages;

            $first.add($prev).toggleClass('list_action', enable_back);
            $next.add($last).toggleClass('list_action', enable_forward);
            _toggle_tool_sprite($first, 'tool_first', enable_back);
            _toggle_tool_sprite($prev, 'tool_prev', enable_back);
            _toggle_tool_sprite($next, 'tool_next', enable_forward);
            _toggle_tool_sprite($last, 'tool_last', enable_forward);

            if (!config.paging.last_page_button) {
                $last.hide();
                $this.find('.more_lines').toggle(enable_forward);
            }

            $this.find('.page_current')
                .val(total_pages ? (current_page || 1) : 0)
                .enable(total_pages > 0);
        }

        function append_rows(tbody, begin, len) {
            load_rows(tbody, len, begin).done(function() {
                if (config.options.css_layout) {
                    body.loading(false);
                }
                if ($.isFunction(config.callbacks.post_paging)) {
                    config.callbacks.post_paging.call(that[0], that[0]);
                }
                // cached rows are rows for current page, should update them
                // otherwise any usage of get_all_rows() will refer to the
                // rows in the first page only
                config.update_cached_rows();
            });
        }

        // used to save the current page number other than
        // the value of '.page_current'
        var current_page_num = 1;
        // the variable name `one_page` commonly refers to the amount of
        // lines/entries per page. (It could be renamed at some point)
        function goto_page(page_num, total_pages, one_page, fetcher) {
            /*jshint validthis:true*/
            var $this = $(this);
            page_num = Number(page_num);
            if (page_num < 1 || page_num > total_pages) {
                return;
            }
            // update current page number
            current_page_num = page_num;
            total_pages = Number(total_pages);
            // this is actually the jquery encapsulated <td> elem containing paging ctrls.
            $this.find('.page_current').enable(total_pages > 0)
                .val(page_num <= total_pages ? page_num : total_pages);
            update_controls.call(this, page_num, total_pages);

            fetcher(page_num);
        }

        function get_complete_filter_fn(that, config, state) {
            var column_filter_fn, decorated_filter_fn, dummy_filter_fn;
            dummy_filter_fn = function() { return true; };
            column_filter_fn = config.column_filters.enabled ? config.column_filters.filter_fn :
                dummy_filter_fn;
            decorated_filter_fn = _ext_decorate_fn('get_filter_fn', that,
                {config: config, state: state, fn: _ext_internal_functions}, column_filter_fn);
            return decorated_filter_fn === dummy_filter_fn ? null : decorated_filter_fn;
        }

        function get_entry_cache(entry) {
            /*jshint bitwise:false*/
            var cid = entry._cache_id || (
                    // generate a cache uuid for this entry
                    entry._cache_id = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'
                        .replace(/[xy]/g, function(c) {
                            var r = Math.random() * 16 | 0,
                                v = c === 'x' ? r : (r & 0x3 | 0x8);
                            return v.toString(16);
                        }));
            return state.cache.source[cid] || (state.cache.source[cid] = {});
        }

        function is_filtered(entry, flt_fn, col_flt_fn, flt_arr) {
            var cache = get_entry_cache(entry);
            var filtered = cache.filtered;

            if (filtered !== undefined) {
                return filtered;
            }

            if ($.isPlainObject(entry.expansion)) {
                filtered = get_entry_cache(entry.expansion).filtered;
            } else {
                filtered = false;
                if (!filtered && $.isFunction(flt_fn)) {
                    filtered = flt_fn(entry, flt_arr) === false;
                }
                if (!filtered && $.isFunction(col_flt_fn)) {
                    filtered = col_flt_fn(entry, flt_arr) === false;
                }
            }

            return (cache.filtered = filtered);
        }

        function get_filtered_lines(col_flt_fn, filters) {
            if (state.cache.filtered_lines !== undefined) {
                return state.cache.filtered_lines;
            }
            var flt_fn = config.filter;
            if (!col_flt_fn && !flt_fn) {
                return (state.cache.filtered_lines = config.source.length);
            }
            var l = 0, entry, flt_arr = filters || get_filter_settings();
            for (var i = 0; (entry = config.source[i]); i++) {
                if (is_filtered(entry, flt_fn, col_flt_fn, flt_arr)) {
                    continue;
                }
                l++;
            }
            return (state.cache.filtered_lines = l);
        }

        // return real source index by sequence #
        function src_index(i) {
            return state.display_master.length > i ? state.display_master[i] : i;
        }

        function get_filtered_index(index, flt_fn, col_flt_fn, flt_arr) {
            var n = 0, entry;
            for (var i = 0; (entry = config.source[src_index(i)]); i++) {
                if (is_filtered(entry, flt_fn, col_flt_fn, flt_arr)) {
                    continue;
                }
                if (n === index) {
                    return i;
                }
                n++;
            }
            return n;
        }

        function client_paged_rows(tbody, $qlist_container) {
            var that = $qlist_container;
            var table = tbody.parent();

            var one_page = config.paging.page_lines;
            if (one_page === 'AUTO_FIT') {
                var thead_height = table.find('thead').outerHeight();
                var div = $qlist_container;
                var actual_table_height = table.height();
                var spacing = table.outerHeight() - actual_table_height;
                var hdrbar_height = config.options.hide_menu ? 0 :
                    config.hdrbar_height + 2 * spacing;
                var ftbar_height = config.fixed_ftrbar_height + 2 * spacing;
                var avail_table_height = div.height() - hdrbar_height - ftbar_height;
                var avail_tbody_height = avail_table_height - thead_height;

                var is_tbody_empty = tbody.children().length === 0;
                var cell_height = 0;
                if (is_tbody_empty) {
                    // the tbody containing data rows has no row. Let's try
                    // the the tbody contaning 'loading...'
                    var second_tbody = table.find('tbody:last');
                    if (second_tbody.children().length) {
                        cell_height = second_tbody.outerHeight();
                    } else {
                        cell_height = thead_height;
                    }
                } else {
                    var first_row = tbody.find('tr:first');
                    cell_height = first_row.height();
                }
                /* while the avail_table_height are the same on chrome/ff/ie,
                 * thead, cell height is 18px on chrome and 20px on ff/ie
                 * tbody is 1px on chrome while 0px on ff, ie. Here is an
                 * attempt to balance the cell height
                 */
                if (tbody.height() === 0) {
                    cell_height += 2;
                }
                one_page = Math.floor(avail_tbody_height / cell_height);
                var remainder = avail_tbody_height - cell_height * one_page;

                if (remainder < config.scrollbar_width) {
                    one_page -= 1; //additonal gap for the scrollbar
                }
                // fallback to make sure we're not going to divide by zero, etc.
                if (one_page < config.paging.min_page_lines) {
                    one_page = config.paging.min_page_lines;
                }
            }
            function fetcher(page_num, cb) {
                var begin = (page_num - 1) * one_page;
                tbody.empty();
                (cb || append_rows)(tbody, begin, one_page);
                adjust_table(table);
            }

            // If total lines & page lines are equal, then we shouldn't show paging
            // controls. In combination with sorting, allows for a top/bottom N
            // list
            if (config.paging.total_lines > 0 &&
                    config.paging.total_lines === config.paging.page_lines) {
                return load_rows(tbody, one_page, undefined, $qlist_container);
            } else {
                var total_lines = get_filtered_lines(get_complete_filter_fn(that, config, state));
                return paged_rows(tbody, total_lines, one_page, fetcher);
            }
        }

        function page_completed() {
            return typeof config.paging.completed === 'undefined' || config.paging.completed();
        }

        function server_paged_rows(tbody, $qlist_container) {
            // one page lines number should be the same until page reload
            var one_page = config.paging.page_lines || config.source.length;
            function fetcher(page_num, cb) {
                clearTimeout(config.timer);
                if ($(tbody).data('page_cur') !== page_num) {
                    $(tbody).data('page_cur', page_num);
                    if (!config.paging.hybrid_server_paging) {
                        config.source.length = 0;
                    }
                    tbody.empty();
                }
                config.paging.fetch(page_num, function(data, begin) {
                    var i;
                    if (begin == null) { begin = config.source.length; }
                    for (i = 0; data.source[i]; i++) {
                        config.source[begin + i] = data.source[i];
                    }
                    config.paging.total_lines = data.total_lines;
                    var total_lines = data.total_lines;

		    //Modify by shuyusun for wvs paging
		    var total_pages;
		    if(config.prefix === "qlist_wvs")
			    total_pages =  si_total_pages;
		    else
			    total_pages = Math.ceil(total_lines / one_page);
                    $qlist_container.find('.page_total').text(total_pages);
                    $qlist_container.find('.total_lines').text(total_lines);
                    update_controls.call($qlist_container, page_num, total_pages);
                    var render = cb || append_rows;
                    if (config.paging.hybrid_server_paging) {
                        render(tbody, (page_num - 1) * one_page, one_page);
                    } else {
                        render(tbody, begin, i);
                    }
                    that.trigger('qlist.update');
                    if (!page_completed()) {
                        config.timer = setTimeout(function() {
                            fetcher(page_num, cb);
                        }, config.paging.timeout);
                    }
                }, {
                    page_num: page_num,
                    source_length: config.source.length,
                    lines_per_page: one_page
                });
            }
            if (!page_completed()) {
                config.timer = setTimeout(fetcher, config.paging.timeout);
            }
            var total_lines = config.paging.total_lines;
            return paged_rows(tbody, total_lines, one_page, fetcher);
        }

        /**
         * @param  {jQuery} tbody
         * @param  {int} total_lines
         * @param  {int} one_page     the number of lines shown on a single page
         * @param  {function} fetcher the above fetcher function from server_paged_rows
         *                            it is not used directly in this function,
         *                            but only passed on to `goto_page` when needed
         * @return {$.Promise}        a promise that resolves when pages are loaded
         *                            (see `load_rows`)
         */
        function paged_rows(tbody, total_lines, one_page, fetcher) {
            var table = tbody.parent();
            var div = table.parent();

            function set_page_lines(mode) {
                if (mode === 'show_less') {
                    one_page = total_lines;
                }
            }

            if (config.paging.mode) {
                set_page_lines(config.paging.mode);
            }
	    
	    //Modify by shuyusun for wvs paging
	    //var total_pages = Math.ceil(total_lines / one_page);
	    var total_pages;
	    if(config.prefix === "qlist_wvs")
		    total_pages =  si_total_pages;
	    else
		    total_pages = Math.ceil(total_lines / one_page);
            var qlist_ftrbar = $($('#' + config.ftrbar_id).empty()[0] ||
                $('<div id="' + config.ftrbar_id + '"/>'));
            if (config.options.fixed_footer) {
                qlist_ftrbar.addClass('qlist_fixed_ftrbar');
            }

            var ftrtc = $('<table id="ftrtc" class="container"/>');
            ftrtc.attr({cellpadding: 0, cellspacing: 0});
            qlist_ftrbar.append(ftrtc);

            var paging_row = $('<tr class="dark" id="paging_row"/>');
            ftrtc.append(paging_row);

            var td = $('<td style="text-align: center"/>');
            paging_row.append(td);

            function is_page_button_disabled(page_button) {
                return !$(page_button).hasClass('list_action');
            }

            var $page_first = $('<a class="list_sprite tool_first0 paging_button page_first"/>');
            $page_first.attr({'title': $.getInfo('page_first')});
            $page_first.click(function() {
                var $parent = $(this).parent();
                var total = Number($parent.find('.page_total').text());
                if (is_page_button_disabled(this)) {
                    return false;
                }
                goto_page.call($parent[0], 1, total, one_page, fetcher);
            });
            td.append($page_first);

            var $page_prev = $('<a class="list_sprite tool_prev0 paging_button page_prev"/>');
            $page_prev.attr({'title': $.getInfo('page_prev')});
            $page_prev.click(function() {
                var $parent = $(this).parent();
                var total = Number($parent.find('.page_total').text());
                if (is_page_button_disabled(this)) {
                    return false;
                }
                goto_page.call($parent[0], Number($parent.find('.page_current').val()) - 1, total,
                    one_page, fetcher);
            });
            td.append($page_prev);

            var $page_current = $('<input class="page_current" type="text"/>');
            $page_current.attr({
                'style': 'vertical-align: middle',
                'value': total_lines ? 1 : 0,
                'autocomplete': 'off',
                'maxlength': '10',
                'size': '4',
                'name': 'page_current'
            }).enable(total_lines > 0);
            $.mask.definitions.x = '[0-9]';
            $page_current.mask('x?xxxxxxxxx', {
                'hide_mask': false,
                'placeholder': ' '
            });

            $page_current.on('keypress', function(e) {
                if (e.keyCode === 13) {
                    var $this = $(this);
                    var $parent = $this.parent();
                    var total = Number($parent.find('.page_total').text());
		    
		    //Add by shuyusun for wvs page
		    if(config.prefix === "qlist_wvs")
		    {
			    current_page_num = Number(si_current_page_num);
		    }
		    if (current_page_num === Number($this.val())) {
                        return false;
                    }
                    goto_page.call($parent[0], $this.val(), total, one_page,
                        fetcher);
                    return false;
                }
            });
            td.append($page_current);
            td.append('<span style="vertical-align: middle"> / </span>');

            var span_page = $('<span><span class="page_total"/></span>');
            span_page.attr('style', 'vertical-align:middle;margin-right:2px;');
            span_page.children().text(total_pages);
	    
	    //Modify my shuyusun for wvs paging
	    var next_button_disabled;
	    if(config.prefix == "qlist_wvs")
            	next_button_disabled = si_total_pages <= 1;
	    else
	    	next_button_disabled = total_lines <= one_page && page_completed();

            if (!config.paging.last_page_button && !next_button_disabled) {
                span_page.append($('<span class="more_lines">+</span>'));
            }
            td.append(span_page);

            var $page_next = $('<a class="list_sprite paging_button page_next"/>');
            $page_next.attr({'title': $.getInfo('page_next')});
            $page_next.addClass(next_button_disabled ? 'tool_next0' : 'list_action tool_next');
            $page_next.click(function() {
                var $parent = $(this).parent();
                var total = Number($parent.find('.page_total').text());
                if (is_page_button_disabled(this)) {
                    return false;
                }
                goto_page.call($parent[0], Number($parent.find('.page_current').val()) + 1,
                    total, one_page, fetcher);
            });
            td.append($page_next);

            var $page_last = $('<a class="list_sprite paging_button page_last"/>');
            $page_last.attr({'title': $.getInfo('page_last')});
            $page_last.addClass(next_button_disabled ? 'tool_last0' : 'list_action tool_last');
            $page_last.click(function() {
                var $parent = $(this).parent();
                var total = Number($parent.find('.page_total').text());
                if (is_page_button_disabled(this)) {
                    return false;
                }
                goto_page.call($parent[0], total, total, one_page, fetcher);
            });
            if (!config.paging.last_page_button) {
                $page_last.hide();
            }
            td.append($page_last);

            var middle_span = $('<span style="vertical-align:middle" />');
            middle_span.append(' [ ');

            var total_span = $('<span/>');
            total_span.html($.getInfo('total') + ': <span class="total_lines">' +
                            total_lines + '</span>');
            middle_span.append(total_span);
            if (!config.paging.last_page_button && !next_button_disabled) {
                middle_span.append($('<span class="more_lines">+</span>'));
            }

            // If show_all_button is set, a new button will be enabled on the pager
            // allowing the user to show all entries (disable paging), or only a
            // single page. This preference will be stored in a cookie.
            if ((total_pages > 1 || config.paging.mode) && config.paging.show_all_button) {
                config.paging.mode = config.paging.mode || 'show_more';

                // handle for the page all button
                var toggle_mode = function() {
                    var mode = config.paging.mode;
                    var next_mode = 'show_more';
                    var $this = $(this); // the page all button
                    var $parent = $this.parent();

                    if (mode === next_mode) {
                        $parent.find('.page_current').val(1);
                        next_mode = 'show_less';
                    }

                    config.paging.mode = next_mode;
                };

                var page_all = $('<a href="#"/>')
                    .text($.getInfo(config.paging.mode))
                    .click(function() {
                        toggle_mode();
                        $(that).qlist('reload');
                        return false;
                    })
                ;

                middle_span.append(' | ').append(page_all);
            }

            middle_span.append(' ] ');
            td.append(middle_span);
            div.parent().append(qlist_ftrbar);

            return load_rows(tbody, one_page);
        }

        function load_rows(tbody, len, from, $qlist_container) {
            var fr = from || 0;
	    // keep the var fr as 0 in our project, for mantis bug 383115.  tbody may has no element, so replace as tbody.parents() to update paging status
            if (!from && localStorage) {
                var num = +localStorage.getItem(config.prefix + '/current_page');
                if (num && $.isNumeric(len)) {
                    localStorage.setItem(config.prefix + '/current_page', '');
//                    fr = len * (num - 1);
                    update_controls.call(tbody.parents(), num);
                }
            }

            var tr, entry;
            var rowIndex = 0, catIndex = 0, secIndex = 0;
            var secExpand = true;
            var sort_fn = config.sort_compare;
            var flt_fn = config.filter;
            var flt_arr = get_filter_settings();
            var ck_cats = (getCookie(config.ck_name.category) || '').split(',');
            var col_len = config.chosen_columns.length;
            var cat_tbody, sec_row;
            var done = $.Deferred();
            var that = $qlist_container || $(tbody).closest('.qlist-container');

            // TODO: move into qlist.sort.js; emit an event that qlist.sort listens for
            //       OR just remove fast_sort.
            if (config.sort && config.sort.fast_update !== false && !config.paging.enabled &&
                    !(config.category.q_type !== null &&
                        config.column_map.category != null)) {
                state.fast_sort = [];
                state.fast_sort_target = tbody;
            } else {
                state.fast_sort = undefined;
            }

            var col_flt_fn = get_complete_filter_fn(that, config, state);

            var get_formatted_cell = _ext_decorate_fn('get_formatted_cell',
                that, { config: config, state: state, fn: _ext_internal_functions },
                get_column_value);

            var get_formatted_category_header = _ext_decorate_fn('get_formatted_category_header',
                that, { config: config, state: state },
                function(category_value) { return category_value; });

	    /*
            if (fr > 0) {
                fr = get_filtered_index(fr, flt_fn, col_flt_fn, flt_arr);
            }
	    */

            function get_labels(cols, entry) {
                var labels = [];
                for (var i = 0; i < cols.length; i++) {
                    var label = get_column_value(null, cols[i], entry);
                    if (label !== undefined) {
                        labels.push(label);
                    }
                }
                return labels;
            }

            /* same as above function, but formatted for display */
            function get_formatted_labels(cols, entry, td, opts) {
                opts = $.extend(opts || {}, { separator: ' - ', wrap_selector: false });
                var labels = config.options.atomic_render ? [] : $();
                for (var i = 0; i < cols.length; i++) {
                    var label = get_formatted_cell(td,
                        opts.wrap_selector ? { selector: cols[i] } : cols[i],
                        entry);
                    if (label !== undefined) {
                        if (config.options.atomic_render) {
                            // TODO: get the commented code below to work if needed
                            //       may throw a DOM exception
                            // if (label instanceof jQuery) {
                            //     label = $('<div>').append(label).html();
                            // }
                            labels.push(label);
                        } else {
                            if ($.type(label) === 'string') {
                                label = $.parseHTML(label);
                            }
                            labels = labels.add(label);
                        }
                    }
                }
                if (opts.separator !== false) {
                    if (config.options.atomic_render) {
                        labels = labels.join(opts.separator);
                    } else {
                        labels.not(':last').after(opts.separator);
                    }
                }
                return labels;
            }

            function add_category_num() {
                if (!cat_tbody) {
                    return;
                }
                var label = $('label', cat_tbody);
                if ($.inArray('#', config.chosen_columns) >= 0) {
                    $(label).append(' (' + (rowIndex - catIndex + 1) + ' - ' + rowIndex + ')');
                } else {
                    $(label).append(' (' + catIndex + ')');
                }
            }

            function add_section_num() {
                if (!sec_row) {
                    return;
                }
                var label = $('label', sec_row);
                if ($.inArray('#', config.chosen_columns) >= 0) {
                    $(label).append(' (' + (secIndex + 1) + ' - ' + rowIndex + ')');
                } else {
                    $(label).append(' (' + (rowIndex - secIndex) + ')');
                }
                sec_row = undefined;
            }

            var category, row, td;
            var i = fr;
            var loading = $('#loading_tbody');

            var load_row_frag = function(last_i) {
                /**
                * factored out 'gen_row' function to support load_row export
                */
                function gen_row(entry, i, rowIndex) {
                    var source_i = src_index(i);
                    // gen row
                    tr = document.createElement('tr');
                    var tr_class = 'qlist_row';
                    if (!secExpand) {
                        tr_class += ' hidden';
                    }
                    tbody.get(0).appendChild(tr);
                    // HTML5 converts data-a-b to data('aB')
                    tr.setAttribute('data-source-index', source_i);

                    // TODO: move into qlist.sort.js ?
                    if (state.fast_sort) {
                        state.fast_sort[source_i] = $(tr);
                    }

                    // this function can be used to regenerate and individual row if the data for
                    // it changes.
                    $(tr).data('regenerate', function(tr, data, context) {
                        var cls_name, new_context;
                        var new_tr = gen_row(data, i, source_i, rowIndex, context);
                        if (context) {
                            cls_name = $(context).closest('td').attr('class');
                            new_context = $(new_tr).find('.' + cls_name);
                        }
                        tr.replaceWith(new_tr);
                        return {
                            'row': new_tr,
                            'context': new_context
                        };
                    });

                    // apply row_attr
                    $.each(config.row_attr, function(i, attr) {
                        var _value = entry[attr.selector];
                        if (_value != null) {
                            // On IE setAttribute('a', null) will set it to ''
                            // so better skip setting to null value
                            tr.setAttribute(attr.name, attr.selector === '__index__' ?
                                source_i : _value);
                        }
                    });

                    if (config.options.row_striping && rowIndex % 2) {
                        tr_class += ' odd';
                    }
                    tr.setAttribute('class', tr_class);

                    // apply customization
                    config.row_gen.call($(tr), fr + rowIndex, entry);

                    var cb = false;

                    // checkbox cell
                    if (config.checkboxes.enabled) {
                        cb = '<input type="checkbox" class="qlist_cb" />';

                        if (!config.options.hide_checkboxes) {
                            $('<td></td>').append(cb).appendTo(tr);
                            cb = false;
                        }
                    }

                    var row_body = '', val;
                    var temp_td = document.createElement('td');

                    // generate cells
                    for (var selector, j = 0; (selector = config.chosen_columns[j]); j++) {
                        if (config.options.atomic_render) {
                            // For performance reasons use DOM API directly
                            temp_td.setAttribute('class', selector);
                            temp_td.setAttribute('atomicSourceIndex', i);
                            val = get_formatted_cell($(temp_td), selector, entry);
                            // WARNING: get_formatted_cell changes temp_td
                            var cell_body = '<td class="' + temp_td.getAttribute('class') + '">';

                            // because Webkit doesn't handle hiding table cells properly
                            // we need to append hidden checkboxes to the first non-hidden
                            // cell
                            if (cb && config.options.hide_checkboxes) {
                                // this avoid having to call getComputedStyle, and speeds things up
                                cell_body += '<input type="checkbox" style="display:none" ' +
                                   'class="qlist_cb" />';
                                cb = false;
                            }

                            row_body += cell_body + val + '</td>';
                        } else {
                            td = $('<td class="' + selector + '"/>').appendTo(tr);
                            val = get_formatted_cell(td, selector, entry);

                            if (cb && config.options.hide_checkboxes) {
                                // this avoid having to call getComputedStyle, and speeds things up
                                $(cb).attr('style', 'display:none').appendTo(td);
                                cb = false;
                            }

                            td.append(val);

                            // deprecated, backward compatible, use format_fn instead
                            if (config.custom_cols && config.custom_cols.indexOf(selector) !== -1) {
                                config.col_gen(td, entry, selector, rowIndex, tr);
                            }
                        }
                    }
                    if (config.options.atomic_render) {
                        tr.innerHTML = row_body;
                    }
                    return $(tr);
                }

                function load_row_fragment_event(source_i) {
                    return function() {
                        load_row_frag(source_i);
                    };
                }

                var source_i;
                var collapse_enabled, frag_start = Date.now();
                var filtered_lines = 0;

                _ext_call('load_row_frag', that, {
                    config: config,
                    state: state,
                    tbody: tbody,
                    fn: _ext_internal_functions
                });

                loading.remove();
                for (; (entry = config.source[source_i = src_index(i)]); i++) {
                    if (is_filtered(entry, flt_fn, col_flt_fn, flt_arr)) {
                        filtered_lines += 1;
                        continue;
                    }

                    // get current entry's category name
                    category = get_category(source_i);

                    // category specified, for first entry or different name with previous entry
                    if (category && (i === fr || category !== get_category(last_i))) {
                        // create new category (tbody)

                        // TODO: emit an event that qlist.sort listens to
                        state.fast_sort = undefined;
                        var tbody_parent = tbody.parent();
                        if (i !== fr) {
                            add_section_num();
                            add_category_num();
                            catIndex = 0;
                            cat_tbody = $('<tbody/>').appendTo(tbody_parent);
                        } else {
                            cat_tbody = tbody;
                        }
                        tbody = $('<tbody/>')
                            .appendTo(tbody_parent);
                        cat_tbody.addClass('category')
                            .data('category', category);
                        row = $('<tr class="qlist_category"/>')
                            .appendTo(cat_tbody);
                        td = $('<td class="left" colspan="' + col_len + '"/>')
                            .appendTo(row);

                        // the below statement should be turned into a reusable
                        // function of all types of configuration objects with a
                        // '*' default option
                        collapse_enabled = (typeof
                            config.options.collapsible_categories[category] !== undefined &&
                            config.options.collapsible_categories[category]) ||
                            config.options.collapsible_categories['*'];
                        var exp = !collapse_enabled || $.inArray(category, ck_cats) >= 0;
                        var formatted_category = get_formatted_category_header(category, source_i);
                        td.append('<label>' + (collapse_enabled ?
                            //'<input type="image" onclick="return false" value=""' +
                            //' src="'/*/' + fweb.CONFIG_GUI_NO*/ + '/theme/images/twistie_' +
                            //(exp ? 'expanded.gif' : 'collapsed.gif') +
                            //'"> ' : '') + formatted_category + '</label>');

                            '<button type="button" onclick="return false" value=""' +
                            ' class="'/*/' + fweb.CONFIG_GUI_NO*/ + 'compact-visual-toggle' +
                            (exp ? ' active' : '') +
                            '"></button> ' : '') + formatted_category + '</label>');
                        // apply cookie settings
                        if (config.options.css_layout) {
                            tbody.toggleClass('expand-hidden', !exp);
                        } else if (!exp) {
                            tbody.hide();
                        }
                        secExpand = true;
                    }

                    // section check
                    if (!catIndex || sort_fn.call(config.sections, entry,
                                                  config.source[last_i]) !== 0) {
                        // TODO: emit an event that qlist.sort listens to
                        state.fast_sort = undefined;
                        add_section_num();
                        var vals = get_labels(config.sections, entry);
                        var section = vals.join(' - ');
                        if (section) {
                            row = $('<tr class="qlist_section" />')
                                .data('section', section)
                                .data('sectionFirstIndex', i)
                                .appendTo(tbody);
                            if (config.options.editable_sections) {
                                row.attr('mkey', entry[config.sections[0]]);
                                row.attr('can_delete', 0);
                            }
                            td = $('<td class="left" colspan="' + col_len + '"/>')
                                .appendTo(row);
                            collapse_enabled = (typeof
                                config.options.collapsible_sections[section] !== undefined &&
                                config.options.collapsible_sections[category]) ||
                                config.options.collapsible_sections['*'];
                            secExpand = !collapse_enabled || $.inArray(section, ck_cats) >= 0;
                            var formatted_section = get_formatted_labels(config.sections, entry,
                                                                         td);
                            td.append($('<label>' + (
                                collapse_enabled ? '<input type="image" onclick="return false" ' +
                                'value="" src="'/*/' + fweb.CONFIG_GUI_NO */+ '/theme/images/twistie_' +
                                (secExpand ? 'expanded.gif' : 'collapsed.gif') + '"> ' : ''
                            ) + '</label>').append(formatted_section));
                            sec_row = row;
                            secIndex = rowIndex;
                        }
                    }
                    tr = gen_row(entry, i, rowIndex);
                    // check if this dependant row
                    if (!$(tr).hasClass('qlist_expansion_child')) {
                        catIndex++;
                        rowIndex++;
                    }

                    if (len && rowIndex >= len) {
                        break;
                    }

                    if (Date.now() - frag_start > MAX_FRAG_TIME) {
                        loading.appendTo(tbody.parent());
                        setTimeout(load_row_fragment_event(source_i), 0);
                        i++;
                        return;
                    }

                    last_i = source_i;
                }

                if (show_loading()) {
                    body.loading($.getInfo('loading'), false);
                }

                // show last section/category entries number
                add_category_num();
                add_section_num();

                setTimeout(function() {
                    if ((config.source.length <= filtered_lines) && page_completed()) {
                        // TODO: emit an event that qlist.sort listens to
                        state.fast_sort = undefined;
                        gen_empty_row($('<tr/>').appendTo(tbody), config.empty_msg);
                    }

                    gen_row_export = gen_row;
                    done.resolve();
                }, 0);
            };

            load_row_frag();

            return done.promise();
        }

        var gen_row_export;
        /**
        * Load a row after the table has already been created and append it
        * will only work for simple tables, ignores sections etc
        * (supports inline edit handlers in jquery_util.js).
        * @param {Object} entry source for row to load.
        * @return {jQuery(HTMLTRElement)} properly formatted row.
        */
        //todo: add insert_row if needed
        function append_row(entry) {
            var table = $('#' + config.prefix + '-qlist');
            var tbody = table.find('tbody').last();
            //remove loading row
            tbody.find('td.empty_row').parent().remove();
            var i = tbody.children('TR').length,
                result = gen_row_export(entry, i, i);
            if (!result.jquery) {
                result = $(result);
            }
            tbody.append(result);
            return result;
        }

        function show_loading() {
            var result = (config.source && config.options.loading_threshold > 0 &&
                          config.source.length > config.options.loading_threshold);
            if (!result && config.options.css_layout) {
                that.removeClass('ql-is-loading');
            }
            return result;
        }

        function load_all_rows(tbody, $qlist_container) {
            var rows_ready = $.Deferred();

            $.when(config.source).done(function(row_data) {
                var source = $.extend([], row_data);
                config.source = source;

                if (show_loading()) {
                    body.loading($.getInfo('loading'));
                }

                if (config.categories.length) {
                    sort_source(source);
                } else if (config.sections.length) {
                    sort_sections(source);
                }

                _ext_call('source_load_complete', that, {
                    config: config,
                    state: state,
                    tbody: tbody,
                    fn: _ext_internal_functions
                });

                if (config.paging.enabled) {
                    var paged_rows = config.paging.server_side ?
                        server_paged_rows(tbody, $qlist_container) :
                        client_paged_rows(tbody, $qlist_container);
                    paged_rows.then(function() {
                        rows_ready.resolve();
                    }, rows_ready.reject);
                } else {
                    load_rows(tbody).then(function() {
                        rows_ready.resolve();
                    }, rows_ready.reject);
                }
            });
            if (config.options.css_layout) {
                rows_ready.then(function() {
                    //no awkward table_adjust when css_layout is enabled
                    body.loading(false);
                });
            }
            return rows_ready.promise();
        }

        function init_qlist(table, init, $qlist_container) {
            // The target qlist object; this is a copy of the global qlist_obj
            //  with some properties replaced by qlist_overrides

            var my_qlist = {};
            var fix_drop_list = [];

            if (typeof(is_rw_admin) === 'undefined') {
                window.is_rw_admin = false;
            }

            config.qlist_overrides = get_qlist_overrides(config.qlist_overrides);
            $.extend(my_qlist, qlist_obj, config.qlist_overrides);

            config.update_cached_rows = function() {
                my_qlist.jc_update();
            };
            my_qlist.init();
            if (config.options.css_layout) {
                var fb = $.support.flexbox ? ' flexbox' : '';
                that.addClass('qlist-css-layout' + fb);
            }
            // Generate the main toolbar/button bar
            if (!config.options.hide_menu) {
                var container = $qlist_container || table.closest('.qlist-container');
                var menubar_id = config.prefix + '_qlist_yui_menubar';
                var menubar_container_id = config.prefix + '_qlist_yui_menubar_container';

                var hdrbar = $('<div id="' + config.hdrbar_id + '" class="qlist_hdrbar"/>')
                    .prependTo(container);

                var menubar_container = body.menuBar || $('<div id="' + menubar_container_id +
                        '" class="qlist_yui_menubar_container"/>')
                    .appendTo(hdrbar);
                var menubar = $('<div id="' + menubar_id + '"/>')
                    .appendTo(menubar_container);

                $('body').addClass('yui-skin-sam');

                var oMB = qmenu_create_menubar(menubar_id, my_qlist, is_rw_admin);
                oMB.render(menubar_container.get(0));

                // fix drop down list space
                $.each(fix_drop_list, function(i, id) {
                    fixup_droplist_alignment($('#' + id)[0]);
                });

                if (!menubar.children().length) {
                    $('<div/>').appendTo(menubar);
                }
                if (!config.options.css_layout) {
                    menubar.children(':first').css({'position': 'absolute'});
                }

                var titlebar = $('<div class="qlist_center_menubar"/>').hide()
                    .appendTo(menubar);

                if (config.title) {
                    $(titlebar).append('<b>' + config.title + '</b>').show();
                }

                // To separate the logic of the elements added by extension and
                // elements created by qlist core, now we have two place-holders
                // as the followings:
                //
                // <div class="qlist_right_menubar">
                //   <div id="prefixed_extra_hdr_items" class="extra_hdr_items">
                //       [HTML added by qlist core, usually from
                //        extra_hdr_items in HTML templates or from JavaScript]
                //   </div>
                //   <div id="prefixed_ext_hdr_items" class="ext_hdr_items">
                //       [HTML added by Extension]
                //   </div>
                // </div>
                //
                // Some important notes:
                // - Both extra_hdr_items and ext_hdr_items if exist will be
                // detached before qlist init and re-attached after qlist init
                //
                // - The contents in legacy extra_hdr_items in HTML templates
                // will be used once by the qlist core, then the wrapper div
                // will be removed. So if it is the same qlist (same prefix),
                // the extra_hdr_items will be detached/re-attached. If it is
                // used in two qlists (like policy list for two view types),
                // extra code would be needed to reset the id.
                //
                // - Similarly, extra_hdr_items added by JavaScript code will
                // also be used once (if put that code in qlist load callback,
                // should have some sort of checking to ensure it is used once)
                // Different custom extra header for more than two qlists on
                // the same page is doable either in HTML or JavaScript as long
                // as you ensure the uniqueness (by using prefix)
                //
                // - qlist shouldn't need to know the extension logic, it just
                // need to provide a place holder for the extension to put the
                // right content. Hence, must make sure the load order so that
                // the place holder is available before extension code is
                // running.
                var $right_menubar = $('<div class="qlist_right_menubar"></div>');
                var $core_right_menubar = $('#' + config.prefix + '-extra_hdr_items');
                if ($core_right_menubar.length) {
                    // it was created before, just put it back
                    $core_right_menubar.removeClass('hidden').appendTo($right_menubar);
                } else {
                    // it hasn't been created yet, create it
                    $core_right_menubar = $('<div></div>').attr({
                        'class': 'extra_hdr_items',
                        id: config.prefix + '-extra_hdr_items'
                    }).appendTo($right_menubar);
                    // then bring the legacy qlist__extra_hdr_items in template
                    // into this newly created div
                    var $html_extra_hdr_items = $('#qlist__extra_hdr_items');
                    if ($html_extra_hdr_items.length) {
                        $html_extra_hdr_items.children().appendTo($core_right_menubar);
                        $html_extra_hdr_items.remove();
                    }
                    $core_right_menubar.appendTo($right_menubar);
                }

                var $ext_right_menubar = $('#' + config.prefix + '-ext_hdr_items');
                if ($ext_right_menubar.length) {
                    $ext_right_menubar.removeClass('hidden').appendTo($right_menubar);
                } else {
                    // add placeholder for extension
                    $('<div></div>').attr({
                        'class': 'ext_hdr_items',
                        id: config.prefix + '-ext_hdr_items'
                    }).appendTo($right_menubar);
                }

                $right_menubar.appendTo(menubar);

                // Setup event handlers for the data table.
                my_qlist.setup_listitem_event_handlers();

                if (config.enhanced_context) {
                    my_qlist.enable_qlist_context_item = enable_qlist_context_item;
                }

                // Set the initial state of the button bar buttons.
                my_qlist.init_menubutton_state();
                my_qlist.build_context_menu();
                setup_dblclick_handler();
            } else if (config.options.force_context_menu ||
                    config.options.force_listitem_handlers) {
                my_qlist.setup_listitem_event_handlers();
                if (config.options.force_context_menu) {
                    that.addClass('yui-skin-sam');
                    // qmenu_create_menubar ALSO creates the context menu
                    qmenu_create_menubar(config.prefix + '_qlist_yui_menubar', my_qlist,
                                         is_rw_admin);
                    my_qlist.build_context_menu();
                }
            }

            function setup_dblclick_handler() {
                var cb;

                if (config.enhanced_context) {
                    my_qlist.enable_qlist_context_item = enable_qlist_context_item;
                    cb = get_enhanced_context_dblclick();
                } else {
                    cb = config.callbacks.dblclick;
                }

                if ($.isFunction(cb)) {
                    my_qlist.dblclick_fn = cb;
                }
            }

            function get_enhanced_context_dblclick() {
                var callback = null;

                if ($.isFunction(config.callbacks.dblclick)) {
                    callback = config.callbacks.dblclick;
                } else if (config.menu_items.hasOwnProperty('mi_edit')) {
                    callback = config.menu_items.mi_edit.handler;
                }
                return callback;
            }

            function enable_qlist_context_item(id, state) {
                var states = config.context_button_state = config.context_button_state || {};
                states[id + '_ctx'] = !!state;
            }

            function get_qlist_overrides(override_cache) {
                var qlist_overrides = {};

                qlist_overrides.customize_menu_fn = qlist_init_custom_menu;
                qlist_overrides.handle_selection_change_fn = qlist_handle_custom_selection_change;
                qlist_overrides.prefix = config.prefix;
                qlist_overrides.id = config.prefix + '-qlist';
                qlist_overrides.hdr_cb = config.prefix + '_qlist_hdr_cb';
                qlist_overrides.cr_new_url = config.cr_new_url;
                qlist_overrides.cr_edit_url = config.cr_edit_url;
                qlist_overrides.popup = config.options.popup;
                qlist_overrides.sliderwidth = config.options.sliderwidth;
                qlist_overrides.categories = config.category;
                qlist_overrides.editable_sections = config.options.editable_sections;
                qlist_overrides.disable_context_menu = config.options.disable_context_menu;

                for (var evt in config.callbacks) {
                    if (config.callbacks.hasOwnProperty(evt) &&
                            $.isFunction(config.callbacks[evt])) {
                        var key = evt + '_fn';

                        if (typeof qlist_obj[key] !== 'undefined') {
                            qlist_overrides[key] = config.callbacks[evt];
                        }
                    }
                }

                qlist_overrides.create_new = !config.options.hide_default_buttons &&
                    !config.options.hide_create_button;
                qlist_overrides.create_edit = !config.options.hide_default_buttons &&
                    !config.options.hide_edit_button;
                qlist_overrides.create_del = !config.options.hide_default_buttons &&
                    !config.options.hide_delete_button;

                if (config.options.show_clone_option) {
                    qlist_overrides.create_clone = true;
                }

                // if a cached object is passed in, then we should
                // return it with minimal modifications. However, some
                // attributes must be updated to ensure that the
                // context menu works correctly.
                if ($.isPlainObject(override_cache)) {
                    return $.extend(override_cache, qlist_overrides);
                }

                function apply_handler(obj, fn, handler) {
                    if (handler in config.menu_items) {
                        obj[fn] = config.menu_items[handler].handler;
                        if (handler === 'delete') {
                            config.menu_items[handler].handler = qlist_onclick_delete;
                        }
                    } else {
                        if (handler === 'edit' && config.options.restful) {
                            obj[fn] = function(q, elem) {
                                // Generally the edit URL is just the create new URL with the mkey
                                // tacked on.
                                var attr = elem.getAttribute('mkey');
                                var url = (q.cr_edit_url || q.cr_new_url) +
                                    encodeURIComponent(attr) + '/';
                                if (config.options.popup) {
                                    var ready = fweb.dialog(fweb.iframe(url));

                                    if ($.isFunction(config.options.popup)) {
                                        ready.done(config.options.popup);
                                    }

                                    return false;
                                } else {
                                    window.location.href = url;
                                }
                            };
                        }
                    }
                    // update the handler to support navigating back to the current page
                    var func = obj[fn];
                    if ($.isFunction(func)) {
                        obj[fn] = function(q, elem) {
                            save_page();
                            return func(q, elem);
                        };
                    }
                }

                apply_handler(qlist_overrides, 'create_elem_fn', 'create_new');
                apply_handler(qlist_overrides, 'edit_elem_fn', 'edit');
                apply_handler(qlist_overrides, 'delete_elems_fn', 'delete');

                if (config.qsource && $.isFunction(config.qsource.qlist_overrides)) {
                    config.qsource.qlist_overrides(qlist_overrides);
                }

                return qlist_overrides;
            }

            function create_menu_item(id, item_config) {
                return Page.createMenuItem({
                    'id': id + '_' + config.prefix,
                    'spriteClass': item_config['class'],
                    'classname': item_config.container_class,
                    'single_only': item_config.single_only,
                    'text': item_config.label,
                    'ctxt': item_config.ctxt,
                    'submenu': item_config.submenu,
                    'url': item_config.url,
                    'click': {
                        'handler': item_config.handler,
                        'fn': function() {
                            var elts = my_qlist.get_checked_rows();
                            return (this.handler || item_config.handler).call(item_config, my_qlist,
                                                                              elts);
                        }
                    }
                });
            }

            function qlist_init_custom_menu(item_list) {
                var item;
                var id;

                for (id in config.menu_items) {
                    if (config.menu_items.hasOwnProperty(id)) {
                        if (typeof(config.menu_items[id]) !== 'object') {
                            continue;
                        }

                        if ($.inArray(id, skip_menu_items) !== -1) {
                            continue;
                        }

                        var menu_config = config.menu_items[id];

                        // Primary menu can be explicitly skipped, ie: if only
                        // need to override the submenu for an existing item.
                        if (!menu_config.skip) {
                            item = create_menu_item(id, menu_config);
                            item_list.push(item);
                        }

                        var sub_menu = menu_config.submenu;

                        if (sub_menu) {
                            var subitems = [];
                            for (var x in sub_menu) {
                                if (sub_menu.hasOwnProperty(x)) {
                                    var menu = create_menu_item(x, sub_menu[x]);
                                    subitems.push(menu);
                                }
                            }
                            var parent_id = (id === 'create_new' ? 'mi_new' : id) + '_' +
                                config.prefix;
                            var force_drop_down = ('force_drop_down' in menu_config &&
                                                   menu_config.force_drop_down === true);
                            convert_button_to_droplist(id + '_drop_' + config.prefix,
                                    id + '_drop_menu_' + config.prefix,
                                    parent_id, item_list, subitems, force_drop_down, menu_config);
                            fix_drop_list.push(id + '_drop_' + config.prefix);
                        }
                    }
                }
            }

            function qlist_handle_custom_selection_change(q, rows) {
                qlist_handle_selection_change(my_qlist, rows);

                if ($.isFunction(config.handle_selection_change)) {
                    config.handle_selection_change(my_qlist, rows);
                }
            }

            my_qlist.append_row = append_row;
            return my_qlist;
        }

        function gen_empty_row(tr, msg, extra_class) {
            if (typeof extra_class === 'undefined') {
                extra_class = '';
            }
            $(tr).addClass('nodrag qlist_row qlist_skip_row unselectable').attr('can_edit', '0')
            .attr('can_delete', '0');
            var td = $('<td class="empty_row ' + extra_class + '" />').appendTo(tr);
            var tr_head = $('thead tr:first', tr.closest('table'))[0];
            if (!tr_head) {
                return;
            }
            td.attr('colspan', tr_head.cells.length);
            td.text(msg);
        }

        function render_filter_th(th, selector) {
            var enabled = 'disabled';
            var title = '';
            var flt_arr = get_filter_settings();
            var logic;
            for (var flt, i = 0; (flt = flt_arr[i]); ++i) {
                if (flt.id !== selector) {
                    continue;
                }
                logic = flt.logic || {};
                if (logic.NOT) {
                    title += 'NOT ';
                }
                title += $.getInfo('filter_contains') + ': ';
                if ($.isArray(flt.value)) {
                    title += flt.value.join(logic.RANGE ? ' - ' : ' OR ');
                } else {
                    title += flt.value;
                }
                enabled = 'enabled';
                break;
            }
            return $('<span class="filter filter_' + enabled + '" />')
                .attr('title', title);
        }

        function on_th_resize(event, ui) {
            var th = ui.element.closest('th');
            if (th.data('preset')) {
                th.data('preset').width = th.width();
            }
            adjust_table(th.closest('table'));
        }

        function render_th(th, column) {
            var th_div = $('<div/>').appendTo(th);
            if ('selector' in column) {
                // filter icon
                var filters = config.column_filters,
                    text;
                if (filters.enabled && $.inArray(column.selector, filters.exempts) === -1) {
                    text = render_filter_th(th, column.selector);
                    th_div.append(text);
                }
                // display text
                var lang_key = column.lang_key || 'field_' + column.selector;
                if(column.title_html) {
                    text = column.title_html; 
                } else {
                    text = $.getInfo(lang_key);
                }
                th_div.append(text);
            }

            if (config.options.resizable_columns && !config.options.fixed_header) {
                th_div.resizable({
                    handles: 'e',
                    alsoResize: th,
                    start: function() {
                        var table = th.closest('table.qlist');
                        // only on_th_resize can unlock & adjust table
                        table.data('adjust.locker', on_th_resize);
                    },
                    stop: on_th_resize
                });
            }
        }

        // this is prevent various events (such as resize and refresh), causing the
        // the table to adjust while operations such as column resizing are in
        // progress.
        function lock_adjust_table($qlist, lock_or_unlock) {
            if (arguments.length > 1) {
                $qlist.data('adjustLock', !!lock_or_unlock);
            } else {
                return $qlist.data('adjustLock') || false;
            }
        }

        // this is used to debounce the adjust table so that the loading
        // mask is displayed at the correct times.
        function adjust_count($qlist, modifier) {
            var current = $qlist.data('adjustCount') || 0;

            current += modifier;
            $qlist.data('adjustCount', current);

            return current;
        }

        function build_fixed_header($table) {
            var $fixed_header = $('<div class="qlist_fixed_column_header_container"></div>');
            var $cloned_thead = $table.find('thead').clone();

            $cloned_thead.appendTo($fixed_header);
            $cloned_thead.wrap('<table class="qlist qlist_fixed_column_header"></table>');

            return $fixed_header;
        }

        function require_fixed_header($table) {
            var $container = $table.closest('.ql-inner-container');
            var $fixed_thead = $container.find('.qlist_fixed_column_header_container');

            return $fixed_thead.length || (
                config.options.fixed_header && (
                   $table.outerHeight() > $container.innerHeight()
                )
            );
        }

        function setup_fixed_resize($qlist, $table, $fixed_thead) {
            if (!config.options.resizable_columns) {
                return;
            }

            $fixed_thead.find('th').each(function() {
                $(this).find('div:first').resizable({
                    alsoResize: this,
                    handles: 'e',
                    start: function() {
                        lock_adjust_table($qlist, true);
                    },
                    stop: function() {
                        sync_column_width($fixed_thead, $table);
                        sync_column_width($table, $fixed_thead);
                        lock_adjust_table($qlist, false);
                    }
                });
            });
        }

        function setup_fixed_column_reorder($qlist, $table, $fixed_thead) {
            // set up drag/drop to rearrange the columns
            var th_selector = 'th:not([fixed])';
            $fixed_thead.find(th_selector).addClass('sortable');
            $fixed_thead.sortable({
                items: 'th:not([fixed])',
                helper: 'clone',
                start: function(evt, ui) {
                    ui.item.data('start-pos', ui.item.index());
                },
                update: function(evt, ui) {
                    var chosen = config.chosen_columns;
                    var fr = Number(ui.item.data('start-pos'));
                    var to = ui.item.index();
                    var selector = ui.item.data('selector');
                    var swap = chosen.splice(fr, 1);
                    chosen.splice(to, 0, swap.pop());
                    var column_reorder_event = $.Event('column_reorder');
                    that.trigger(column_reorder_event, [selector, chosen]);
                    // TODO: if needed, check event.isDefaultPrevented() and act accordingly
                    setCookie(config.ck_name.column, chosen.join(','));
                    $(that).qlist('reload');
                },
                // doesn't start the 'sorting' until the user drags for some
                // distance. Needed so that the user can click on the header
                // as well as drag and drop.
                // http://api.jqueryui.com/sortable/#option-distance
                distance: 15
            }).disableSelection();
        }

        function setup_fixed_column_context($qlist, $table, $fixed_thead) {
            $fixed_thead
                .off('contextmenu.columnselect')
                .on('contextmenu.columnselect', function(evt) {
                    var ctxt_menu = $qlist.data('headContextMenu');

                    if (ctxt_menu != null) {
                        ctxt_menu.moveTo(evt.pageX, evt.pageY);
                        ctxt_menu.show();
                        return false;
                    }
                });
        }

        function setup_fixed_click($qlist, $table, $fixed_thead) {
            $fixed_thead
                .off('click.fixedclick')
                .on('click.fixedclick', 'th', function() {
                    var selector = 'th:nth-child(' + ($(this).index() + 1) + ')';
                    $table.find(selector).click();
                });
        }

        function get_fixed_thead($qlist, $table, $header) {
            var $fixed_thead = $header.find('.qlist_fixed_column_header');

            if ($fixed_thead.length < 1) {
                var $fixed_header = build_fixed_header($table);
                $header.prepend($fixed_header);
                $fixed_thead = $fixed_header.find('table');

                setup_filtering($fixed_thead);
                setup_fixed_resize($qlist, $table, $fixed_thead);
                setup_fixed_column_context($qlist, $table, $fixed_thead);
                setup_fixed_column_reorder($qlist, $table, $fixed_thead);
                setup_fixed_click($qlist, $table, $fixed_thead);

                // make the header follow the body when scrolling horizontally
                var $body = $qlist.find('.ql-body-container')
                                  .addClass('ql-body-container-fixed');
                $fixed_thead.css('margin-left', (0 - $body[0].scrollLeft) + 'px'); /*add this for bug 0385093*/
                $body.off('scroll.qlist-fixed-header')
                    .on('scroll.qlist-fixed-header', function() {
                        $fixed_thead.css('margin-left', (0 - $body[0].scrollLeft) + 'px');
                    });
            }

            return $fixed_thead;
        }

        function sync_column_width($ref_table, $set_table) {
            var $ref_th = $ref_table.find('th');
            var $set_th = $set_table.find('th');
            var length = Math.min($ref_th.length, $set_th.length);

            $set_table.width($ref_table.width());
            /* add fgt code for bug 0409563*/
            $set_table.css("max-width", $ref_table.width());
            for (var i = 0; length > i; ++i)
                $($set_th[i]).children("div:first").width(window.getComputedStyle($($ref_th[i]).children("div:first")[0]).width)

            for (var i = 0; i < length; ++i) {
                //$($set_th[i]).children('div:first').width(
                //    $($ref_th[i]).children('div:first').width()
                //);
                /* change here for bug 0377328*/
                $($set_th[i]).width(
                    $($ref_th[i]).width()
                );
            }
        }

        function adjust_fixed_header($qlist, $table, $fixed_thead) {
            sync_column_width($table, $fixed_thead);
            if (config.options.css_layout) {
                $table.addClass('has-fixed-header');
            } else {
                //$table.css('margin-top', '-23px');
                // to adapt new style of list, 2016-12-12
                $table.css('margin-top', '-27px');
            }
        }

        function adjust_header($qlist, $table, $header) {
            if (!config.options.css_layout) {
                $header.css({
                    'top': '0'
                });
            }
        }

        function require_fixed_footer($table) {
            return config.options.fixed_footer && config.paging.enabled;
        }

        function get_fixed_footer($qlist) {
            return $qlist.find('.qlist_fixed_ftrbar');
        }

        function adjust_fixed_footer($footer) {
            // default css for non-flex render
            if (!config.options.css_layout) {
                $footer.addClass('dyn_qlist_fixed_ftrbar');
            }
        }

        function is_inline($qlist) {
            // the list may not yet be attached to the DOM, so just look around
            // the page and see if there are dialog like elements.
            var $elem = $('div.dlg');
            return $elem.length > 0;
        }

        function adjust_fill_parent($qlist, $table) {
            if (config.options.css_layout) { return }
            var $inner = $qlist.find('.ql-inner-container');
            var $outer = $qlist.find('.ql-outer-container');
            var $body = $inner.find('.ql-body-container');

            $outer.height($outer.parent().innerHeight());

            var delta = $outer.innerHeight() - $inner.outerHeight();
            if (delta > 0) {
                $body.height($body.height() + delta);
            }

            var $footer = $qlist.find('.qlist_fixed_ftrbar');
            delta = ($inner.prop('scrollHeight') - $inner.outerHeight()) + $footer.outerHeight();

            if (delta > 0) {
                $body.height($body.height() - delta);
            }
        }

        function adjust_table(table_selector) {
            var $table = $(table_selector);

            // It's possible for the floading header table
            // to be confused as a secondary qlist, and passed
            // in. Skip it.
            if ($table.is('.qlist_fixed_column_header')) {
                return;
            }

            var $qlist = $table.closest('.qlist-container');

            if (lock_adjust_table($qlist)) {
                return;
            }

            // the table isn't fully setup yet, so just abort.
            if ($qlist.length < 1) {
                return;
            }

            var $header = $qlist.find('.ql-colhdr-container');

            adjust_header($qlist, $table, $header);

            if (require_fixed_footer($table)) {
                adjust_fixed_footer(get_fixed_footer($qlist));
            }

            if (!config.options.css_layout && config.options.resize_to_parent) {
                adjust_fill_parent($qlist, $table);
            }

            // adjust fixed_header only after all page adjustment done.
            if (require_fixed_header($table)) {
                adjust_fixed_header($qlist, $table, get_fixed_thead($qlist, $table, $header));
            }

            if (config.options.css_layout) {
                return;
            }

            adjust_table.show_count -= 1;

            var $cloak = $qlist.find('.ql-cloak');
            if (adjust_count($qlist, -1) < 0 && !$cloak.hasClass('ql-cloak-hidden')) {
                setTimeout(function() {
                    if (show_loading()) {
                        $cloak.fadeOut();
                    } else {
                        $cloak.hide();
                    }

                    $cloak.addClass('ql-cloak-hidden');
                    $qlist.resize();
                }, 250);
            }
        }

        function adjust_all_tables() {
            $('table.qlist', that).each(function(i, table) {
                adjust_table(table);
            });
        }

        function sortable_table(table) {
            if (!config.reordering.enable) {
                return;
            }

            var tbody = $('tbody:not(.category)', table)
                .addClass('sortable')
                .disableSelection();

            tbody.find(config.reordering.drag).addClass('sortable');

            var sortable_options = {
                items: '>' + config.reordering.items,
                handle: config.reordering.drag,
                helper: 'clone',
                start: function(evt, ui) {
                    var fr = ui.item.index();
                    // source position
                    ui.item.data('start-pos', fr);
                    if (ui.item.hasClass('qlist_expansion_child')) {
                        // tracking parent
                        ui.item.data('parent',
                            $(ui.placeholder).prevAll(':not(.qlist_expansion_child):first'));
                    } else {
                        // tracking dependants
                        ui.item.data('dependant',
                            $(ui.placeholder).nextUntil(':not(.qlist_expansion_child)').hide());
                    }
                    // set width prevent squash during drag
                    var row = $('tr.qlist_row:first', ui.item.parent())[0];
                    for (var i = 0, cell; (cell = ui.helper[0].cells[i]); i++) {
                        $(cell).width($(row.cells[i]).width());
                    }
                },
                update: function(evt, ui) {
                    var dstIndex, srcIndex = ui.item.data('sourceIndex');
                    var fr = ui.item.data('start-pos');
                    var to = ui.item.index();
                    var len = (ui.item.data('dependant') || []).length;
                    var i, tr, ref;

                    // need to decide which source row should be referenced, prev or next?
                    if (ui.item.prev().data('sourceIndex') != null) {
                        // use prev
                        ref = ui.item.prev();
                        if (srcIndex > ref.data('sourceIndex')) {
                            dstIndex = ref.data('sourceIndex') + 1;
                        } else {
                            dstIndex = ref.data('sourceIndex') - len;
                        }
                    } else {
                        // use next
                        ref = ui.item.next();
                        if (srcIndex > ref.data('sourceIndex')) {
                            dstIndex = ref.data('sourceIndex');
                        } else {
                            dstIndex = ref.data('sourceIndex') - 1 - len;
                        }
                        if (dstIndex < 0) {
                            dstIndex = 0;
                        }
                    }

                    if (ui.item.hasClass('qlist_expansion_child')) {
                        // dependant only can move within same parent
                        var newp = ui.item.prevAll(':not(.qlist_expansion_child):first');
                        if (newp[0] !== ui.item.data('parent')[0]) {
                            ui.item.parent().sortable('cancel');
                            return;
                        }
                    } else {
                        var nextTo = ui.item.nextUntil(':not(.qlist_expansion_child)');
                        // move should next to last dependant, not in the middle
                        if (nextTo[0]) {
                            ui.item.insertAfter(nextTo[nextTo.length - 1]);
                            to += nextTo.length;
                        }
                        // also move depentants
                        ui.item.data('dependant').insertAfter(ui.item);
                    }

                    // update new data source position
                    if (fr < to) {
                        // move forward
                        tr = ui.item;
                        // update row's sourceIndex in range
                        for (tr = item_seek(tr, 1); tr[0] && tr.index() >= fr;
                             tr = item_seek(tr, 1)) {
                            tr.data('sourceIndex', tr.data('sourceIndex') - (1 + len));
                        }
                    } else {
                        // move backward
                        tr = ui.item;
                        // skip self dependants
                        for (i = 0; i < len; i++) {
                            tr = tr.next();
                        }
                        // update row's sourceIndex in moving range
                        for (tr = item_seek(tr); tr[0] && tr.index() < fr + 1 + len;
                             tr = item_seek(tr)) {
                            tr.data('sourceIndex', tr.data('sourceIndex') + (1 + len));
                        }
                    }
                    // update drag item(s) index
                    ui.item.data('sourceIndex', dstIndex);
                    for (i = 0; i < len; i++) {
                        tr = ui.item.data('dependant')[i];
                        $(tr).data('sourceIndex', dstIndex + i);
                    }
                    // update drag item(s) data source
                    var block = config.source.splice(srcIndex, 1 + len);
                    while (block.length) {
                        config.source.splice(dstIndex, 0, block.pop());
                    }
                    // call back notify
                    config.reordering.onDrop.call(ui.item, dstIndex, srcIndex,
                                                  ref.data('sourceIndex'));

                    function item_seek(item, backward) {
                        do {
                            item = backward ? item.prev() : item.next();
                        } while (item[0] && item.data('sourceIndex') === undefined);
                        return item;
                    }
                }
            };

            // To improve performance, initialize drag & drop only when needed for
            // a particular section (when the users mouse enters the draggable area).
            tbody.on('mouseenter', 'tr.qlist_row', config.reordering.drag,
                function() {
                    $(this).addClass('draggable').parents('tbody')
                    .sortable(sortable_options);
                }
            );
        }

        function columnContextMenu() {
            var column, chosen = [], avail = [];

            for (var i = 0; (column = config.columns[i]); i++) {
                if (column.hidden) {
                    continue;
                }

                var checked = $.inArray(column.selector, config.chosen_columns) >= 0;
                (checked ? chosen : avail).push({
                    id: config.prefix + '-col-' + column.selector,
                    text: $.getInfo(column.lang_key),
                    url: VOID_URL, // required for angular // jshint ignore:line
                    //checked: checked,
                    disabled: column.fixed,
                    onclick: { fn: toggleColumnSettings }
                });
            }

            return [chosen, avail];

            function toggleColumnSettings() {
                /*jshint validthis:true*/
                //this.cfg.setProperty('checked', !this.cfg.getProperty('checked'));
            }
        }

        /*
         * Internal function to re-render the qlist. Use this function if you modify anything
         * that would affect the data displayed in the table (column settings, filtering, etc.)
         */
        function qlist_refresh_table() {
            $(that).qlist('reload');
        }

        _ext_call('postconfigure', that, { config: config, fn: _ext_internal_functions });

        var VOID_URL = 'javascript:void 0'; //jshint ignore: line
        var body;
        var _new_display_master;

        // generate the html table
        this.each(function() {
            var that = $(this);

            // save the hdr_items for later re-attach
            that.find('#' + config.prefix + '-extra_hdr_items').detach()
                .addClass('hidden').appendTo($('body'));
            that.find('#' + config.prefix + '-ext_hdr_items').detach()
                .addClass('hidden').appendTo($('body'));

            that.empty()
                .addClass('qlist-container');
            var $qlist_container = that;

            var state = that.data('qlist_state') || {};
            that.state = state; // convenience for event handlers that have this bound to that
            that.data('qlist_state', state);

            if (state.display_master && state.display_master.length !== config.source.length) {
                // (re)initialize display_master
                // NOTE: won't trigger in the unlikely case that the source has been changed
                // but it's the same length. In this case, the developer can force a sort.
                if (typeof get_new_display_master !== 'undefined') {
                    _new_display_master = state.display_master = get_new_display_master();
                }
            }
            // if we got a sort state saved in the cookie, presort the data.
            // it's placed down here since _do_sort needs that.state to be set.
            if (window._new_display_master && config.options.sorting &&
                    state.sorting.length > 0 &&
                    (sorting_cookie_data || !config.default_sort_is_serverside)) {
                _do_sort.call(that);
            }

            // NOTE: if sorting is stored in a cookie, we will sort the data before it is first
            // displayed. (see source_load_complete)

            function cleanup_old_headMenu() {
                if (that.data('headContextMenu')) {
                    var menu = that.data('headContextMenu');
                    // pospone destory wait all yui events triggered during finished.
                    // yui 2.9.0 onDomResize: setTimeout(function(){o.syncPosition();...,0);}
                    setTimeout(function() {
                        try {
                            menu.destroy();
                        } catch (e) {
                            if (window.console != null) {
                                window.console.info(e.stack);
                            }
                        }
                    }, 10);
                }
            }

            function apply_headMenu() {
                /*jshint -W107*/
                var ctx_foot_1 = [
                    {
                        id: config.prefix + '-removeFilters',
                        classname: 'removeFilters menu_sprite tool_filter',
                        text: $.getInfo('Remove All Filters'),
                        url: VOID_URL, // required for angular
                        onclick: {
                            fn: fweb.util.events.reportExceptions(function() {
                                var remove_filters_event = $.Event('remove_filters');
                                that.trigger(remove_filters_event);
                                // clear filter cookie settings
                                var filter = get_filter_settings();
                                var wasFiltered = filter && filter.length > 0;
                                config.column_filters.value = [];
                                removeCookie(config.ck_name.filter);
                                if (config.column_filters.enabled && wasFiltered &&
                                        $.isFunction(config.column_filters.server_side_reload)) {
                                    config.column_filters.server_side_reload();
                                } else {
                                    qlist_refresh_table();
                                }
                            })
                        }
                    }
                ];

                var ctx_foot_2 = [
                    {
                        id: config.prefix + '-applySettings',
                        classname: 'applySettings menu_sprite tool_enable',
                        text: $.getInfo('apply'),
                        url: VOID_URL, // required for angular
                        onclick: {
                            fn: function() {
                                head_ctx.hide();
                            }
                        }
                    }, {
                        id: config.prefix + '-cancelSettings',
                        classname: 'cancelSettings menu_sprite tool_close',
                        text: $.getInfo('cancel'),
                        url: VOID_URL, // required for angular
                        onclick: {
                            fn: function() {
                                // destroy & re-generate menu-dom since current one may have been
                                // changed.
                                apply_headMenu();
                            }
                        }
                    }
                ];

                // generate the context menu for the headers [[chosen],[avail],[footer]]
                var headMenus = [[], [], ctx_foot_1, ctx_foot_2];

                if (config.default_columns.length) {
                    headMenus = columnContextMenu();
                    headMenus.push([{
                        id: config.prefix + '-resetSettings',
                        classname: 'resetSettings menu_sprite tool_clear',
                        text: $.getInfo('col_rst'),
                        url: VOID_URL, // required for angular
                        onclick: {
                            fn: fweb.util.events.reportExceptions(function() {
                                var reset_columns_event = $.Event('reset_columns');
                                that.trigger(reset_columns_event);
                                // clear cookie settings
                                removeCookie(config.ck_name.column);
                                var filter = get_filter_settings();
                                var wasFiltered = filter && filter.length > 0;
                                removeCookie(config.ck_name.filter);
                                if (config.column_filters.enabled && wasFiltered &&
                                        $.isFunction(config.column_filters.server_side_reload)) {
                                    config.column_filters.server_side_reload();
                                } else {
                                    $(that).qlist('reload');
                                }
                            })
                        }
                    }].concat(ctx_foot_1));
                    headMenus.push(ctx_foot_2);
                }

                cleanup_old_headMenu();

                // required by yui menu
                $('body').addClass('yui-skin-sam');

                var head_ctx = new YAHOO.widget.ContextMenu('headContextMenu-' + Math.random(), {
                        classname: 'headContextMenu',
                        itemdata: headMenus,
                        zindex: 3,
                        trigger: head_row,
                        lazyload: true,
                        keepopen: true
                    });

                that.data('headContextMenu', head_ctx);

                _ext_call('before_header_context_menu_render', that,
                    {config: config, state: state, fn: _ext_internal_functions},
                    head_ctx, headMenus);

                head_ctx.subscribe('beforeRender', function() {
                    var groups = this.getItemGroups();
                    for (var i = 0; i < groups.length; i++) {
                        if(!this._getItemGroup(i))
                        {
                            this._createItemGroup(i);

                            if(i==0) {
                                this.body.insertBefore(this._aListElements[i], this.body.firstChild);
                            } else {
                                this.body.insertBefore(this._aListElements[i], this._aListElements[i-1].nextSibling);
                            }
                        }
                    }
                });

                head_ctx.subscribe('render', function() {
                    $('ul.first-of-type', this.element).before('<div class="heading">'+$.getInfo('selected_columns')+'</div>');
                    $('ul.first-of-type', this.element).after('<div class="heading">'+$.getInfo('available_columns')+'</div>');
                    $('ul.first-of-type', this.element).sortable();

                    // Fix bug: 0448411
                    for (var i = 0; i < 2; i++) {
                        if (head_ctx._aListElements[i].childNodes.length == 0) {
                            head_ctx._aListElements[i].innerHTML = '<div class="info-text">...</div>';
                        }
                    }
                });

                head_ctx.subscribe('click', function(p_sType, p_aArgs) {
                    var item = p_aArgs[1];
                    // move selected menu to chosen ul list
                    if (item.groupIndex === 1) {
                        head_ctx.addItem(item, 0);
                    } else if (item.groupIndex === 0) {
                        //if(head_ctx._aItemGroups[0].length<=1)
                        if(head_ctx._aListElements[0].childNodes.length<=1)
                            return;
                        head_ctx.addItem(item, 1);
                    }

                    // Fix bug: 0448411
                    for (var i = 0; i < 2; i++) {
                        if (head_ctx._aListElements[i].childNodes.length == 0) {
                            head_ctx._aListElements[i].innerHTML = '<div class="info-text">...</div>';
                        } else {
                            var e = head_ctx._aListElements[i].getElementsByTagName('div');
                            if(e.length && e[0])
                                head_ctx._aListElements[i].removeChild(e[0]);
                        }
                    }
                });
                head_ctx.subscribe('beforeShow', function() {
                    var tbl_zindex = table.zIndex();
                    if (this.element.style.zIndex <= tbl_zindex) {
                        this.element.style.zIndex = tbl_zindex + 1;
                    }
                });

                var _chosen_columns;
                head_ctx.subscribe('show', function() {
                    _chosen_columns = config.chosen_columns.join(',');
                });
                head_ctx.subscribe('hide', function() {
                    // YUI needs to do some cleanup when it closes, which will
                    // crash if DOM elements are removed, so this needs to be async.
                    window.setTimeout(function() {
                        applyColumnSettings(head_ctx.element);
                    }, 5);
                });

                head_ctx.render(ranger);

                // add column-settings icon to column container
                $qlist_container.find('.ql-colhdr-container')
                    .append($('<div class="ql-colhdr-settings"/>')
                            .append(
                                $('<div class="tool_sprite tool_column_settings' +
                                  ' ql-colhdr-settings-menu"/>')
                                .attr('title', $.getInfo('Click to select columns to display.'))
                                // trigger context menu when column-settings click
                                .on('click', function(e) {
                                    head_ctx.cfg.setProperty('xy', [e.pageX, e.pageY]);
                                    head_ctx.show();
                                })));
            }

            /**
             * Build the general HTML structure for the list, and load it into the DOM.
             * This layout should be styled using CSS classes, so that it can be displayed
             * immediately.
             */
            function build_qlist_scaffolding() {
                // TODO: this could be moved into an external file, maybe inlined during the
                // build process.
                /*jshint multistr: true */
                var html = $.validator.format(
                '<div class="ql-outer-container yui-skin-sam" id="{0}-outer-container">' +
                    '<div class="ql-cloak">' +
                        '<div class="ql-body-loading" id="{0}-loading" style="display:none">' +
                            '<div class="progress">' +
                                '<div class="message"></div>' +
                            '</div>' +
                        '</div>' +
                    '</div>' +
                    '<div class="ql-inner-container">' +
                        '<div class="ql-head-container qlist_hdrbar" id="{0}-head-container">' +
                            '<div class="ql-menu-container" id="{0}-menu-container"></div>' +
                            '<div class="ql-colhdr-container" id="{0}-colhdr-container"></div>' +
                        '</div>' +
                        '<div class="ql-body-container" id="{0}-body-container">' +
                            '<table class="ql-body-table" id="{0}-qlist"></table>' +
                        '</div>' +
                        '<div class="ql-footer-container" id="{0}-footer-container">' +
                        '</div>' +
                    '</div>' +
                '</div>', config.prefix);

                var $rootElem = $(html);

                var table = $rootElem.find('.ql-body-table')
                    .addClass('list qlist');

                var thead = $('<thead/>')
                    .appendTo(table);

                var head_row = $('<tr/>')
                    .appendTo(thead)
                    .addClass('heading');

                var loading = $rootElem.find('.ql-body-loading');
                if (config.options.css_layout) {
                    loading.css('display', '');
                }
                var progress = loading.find('.progress').progressbar();

                return {
                    rootElem: $rootElem[0],
                    menuBar: $rootElem.find('.ql-menu-container'),
                    table: table,
                    thead: thead,
                    headRow: head_row,
                    loading: function(str, percent) {
                        if (percent == null) {
                            percent = false;
                        }
                        if (config.options.css_layout) {
                            that.toggleClass('ql-is-loading', !!(str));
                        } else {
                            loading.toggle(!!(str));
                        }
                        loading.find('.message')
                            .text(str || '');
                        if (str !== false && percent && progress.is(':ui-progressbar')) {
                            progress.progressbar('option', 'value', percent);
                        }
                    }
                };
            }

            // setup the basic HTML for the list
            body = build_qlist_scaffolding();
            $(this).append(body.rootElem);

            // TODO: refactor to remove these
            var ranger = body.rootElem;
            var table = body.table;
            var thead = body.thead;
            var head_row = body.headRow;
            var tbody = $('<tbody/>')
                .appendTo(table);

            // call pre-loader hook for extensions
            _ext_call('preload', that, {
                config: config,
                state: state,
                table: table,
                thead: thead,
                head_row: head_row,
                tbody: tbody,
                fn: _ext_internal_functions
            });

            // send the request for the data
            load_all_rows(tbody, $qlist_container).done(function() {
                setup_table();
                setup_context_menu();
                setup_filtering(thead);
                that.qlist('refresh');
            });

            // populate the menu and column header
            setup_header();

            function setup_context_menu() {
                if (config.options.column_context_menu ||
                    (config.options.column_context_menu !== false &&
                     config.default_columns.length)) {
                    apply_headMenu();
                    if (typeof angular !== 'undefined') {
                        that.one('$destroy', cleanup_old_headMenu);
                    }
                }

                if (config.checkboxes.enabled && !config.options.hide_checkboxes) {
                    $('<th><input type="checkbox" id="' + config.prefix +
                      '_qlist_hdr_cb" class="qlist_cb_hdr" /></th>').appendTo(head_row);
                }
            }

            function setup_header() {
                setup_menu_header();
                setup_column_header();
            }

            function setup_menu_header() {
                $(qlist).find('.ql-head-container').toggle(
                    Boolean(config.options.hide_menu) === false);
            }

            function setup_column_header() {
                $(config.chosen_columns).each(function(i, selector) {
                    var th = $('<th/>').appendTo(head_row)
                            .data('selector', selector);
                    var column = config.column_map[selector] || {};
                    for (var attr in column) {
                        if (column.hasOwnProperty(attr) && attr !== 'selector' &&
                            attr !== 'lang_key') {
                            th.attr(attr, column[attr]);
                        }
                    }
                    var val = render_th(th, column);
                    if (val) {
                        th.append(val);
                    }
                });

                if (config.default_columns.length) {
                    var th_selector = 'th:not([fixed])';

                    // set up drag/drop to rearrange the columns
                    head_row.find(th_selector).addClass('sortable');
                    head_row.sortable({
                        items: th_selector,
                        helper: 'clone',
                        start: function(evt, ui) {
                            ui.item.data('start-pos', ui.item.index());
                        },
                        update: function(evt, ui) {
                            var chosen = config.chosen_columns;
                            var fr = ui.item.data('start-pos');
                            var to = ui.item.index();
                            var selector = ui.item.data('selector');
                            var i = $.inArray(selector, chosen);
                            var swap = chosen.splice(i, 1);
                            chosen.splice(i + (to - fr), 0, swap.pop());
                            var column_reorder_event = $.Event('column_reorder');
                            that.trigger(column_reorder_event, [selector, chosen]);
                            // TODO: if needed, check event.isDefaultPrevented() and act accordingly
                            setCookie(config.ck_name.column, chosen.join(','));
                            $(that).qlist('reload');
                        },
                        // doesn't start the 'sorting' until the user drags for some
                        // distance. Needed so that the user can click on the header
                        // as well as drag and drop.
                        // http://api.jqueryui.com/sortable/#option-distance
                        distance: 15
                    }).disableSelection();
                }
            }

            /*Used to have 'items' parameter but the only caller was
              passing in config.menu_items anyways*/
            function update_menu(target, menu) {
                var states = config.context_button_state = config.context_button_state || {};
                var items = [];

                // convert the menu config objects into YUI menu items, and filter out
                // any which shouldn't be displayed in the context menu.
                items = $.grep(
                    $.map(config.menu_items, convert_menu_item),
                    function(item) {
                        return item.ctxt !== false;
                    }
                );

                menu.clearContent();
                menu.addItems(items);
                menu.render();

                function convert_menu_item(item_config, id) {
                    if (item_config.skip) {
                        return null;
                    }
                    var item = $.extend({}, {
                        'id': [id, config.prefix, 'ctx'].join('_'),
                        'single_only': item_config.single_only,
                        'text': item_config.label || 'undefined',
                        'ctxt': item_config.ctxt,
                        'url': item_config.url
                    });

                    if (states.hasOwnProperty(item.id)) {
                        item.disabled = !(states[item.id]);
                    }

                    if (item_config.hasOwnProperty('class')) {
                        item.classname = ['tool_sprite', item_config['class']].join(' ');
                    }

                    if (item_config.hasOwnProperty('handler')) {
                        item.onclick = {
                            'fn': function(event_name, event_array) {
                                var elts = qlist.get_checked_rows();
                                return item_config.handler(qlist, elts, event_array[0]);
                            }
                        };
                    }

                    var menu_items = null;

                    if (item_config.hasOwnProperty('submenu_fn') &&
                        $.isFunction(item_config.submenu_fn)) {
                        menu_items = item_config.submenu_fn(qlist, qlist.get_checked_rows());
                    }

                    if (item_config.hasOwnProperty('submenu')) {
                        menu_items = item_config.submenu;
                    }

                    if (menu_items !== null) {
                        item.submenu = {
                            'id': ['submenu', item.id].join('_'),
                            'itemdata': $.map(menu_items, function(info, item_id) {
                                return convert_menu_item(
                                    info,
                                    [id, config.prefix, 'submenu', item_id].join('_')
                                );
                            })
                        };
                    }

                    return item;
                }
            }

            function setup_table() {
                _ext_call('preinit', that, {
                    config: config,
                    state: state,
                    fn: _ext_internal_functions
                });
                config.qlist = qlist = init_qlist(table, undefined, $qlist_container);

                var decorated_tbody_context =
                    _ext_decorate_fn('tbody_context', that,
                        {config: config, state: state, fn: _ext_internal_functions},
                        tbody_context);

                $('tbody', table).bind('contextmenu', decorated_tbody_context);

                // to prevent the left-click event from interfering the double-click to edit
                // create a small delay after clicking, and clear the popup event if a second
                // click occurs within that timeout.
                var click_bounce = null,
                    click_delay = 500;
                table.on('click', 'ul.qlist_obj_list li', function(evt) {
                    if (click_bounce === null) {
                        click_bounce = setTimeout(function() {
                            click_bounce = null;
                            decorated_tbody_context(evt);
                        }, click_delay);
                    } else {
                        clearTimeout(click_bounce);
                        click_bounce = null;
                    }
                });

                if (config.qsource && $.isFunction(config.qsource.ready)) {
                    config.qsource.ready(table);
                }

                /* table split header */
                setTimeout(function() {
                    sortable_table(table);
                    // important: make table's parent height known
                    // adjust_table(table);
                });

                if (config.options.ref_column) {
                    // default q_ref formatter will generate a.qlist_ref node
                    table.on('click', 'a.qlist_ref', function() {
                        var tr = $(this).closest('tr.qlist_row');
                        var mkey = tr.attr('mkey');
                        if (mkey != null) {
                            var q_type = tr.attr('q_type');
                            //TODO: merge q_type_extra into q_type?
                            var q_type_extra = tr.attr('q_type_extra');
                            var url = '/objusagedlg';
                            if (q_type_extra != null) {
                                q_type = [q_type].concat(q_type_extra.split(','));
                            }
                            url = url + '?' + $.param({'type': q_type, 'mkey': mkey}, true);
                            fweb.dialog(fweb.iframe(url, {resizeEvent: 'update.fweb'}));
                        }
                        return false;
                    });
                }

                if (config.categories.length) {
                    //table.delegate('.qlist_category input', 'click', function() {
                    table.delegate('.qlist_category button', 'click', function() {
                        //var bExpanded = change_icon(this);
                        var bExpanded = change_button_icon(this);
                        // can not use toggle to set display: table-row-group
                        var tbody = $(this).closest('tbody');
                        // toggle only inner tables (categorized rows)

                        if (!config.options.css_layout) {
                            tbody.nextAll('tbody:first').css('display', bExpanded ? '' : 'none');
                        } else {
                            tbody.nextAll('tbody:first').toggleClass('expand-hidden', !bExpanded);
                        }
                        adjust_table(table);
                        var cat = tbody.data('category');
                        set_category_cookie(cat, bExpanded);
                    });
                }

                if (config.sections.length) {
                    table.delegate('.qlist_section input', 'click', function() {
                        var bExpanded = change_icon(this);
                        var row = $(this).closest('tr');
                        row.nextUntil('.qlist_section').toggleClass('hidden', !bExpanded);
                        adjust_table(table);
                        var sec = row.data('section');
                        set_category_cookie(sec, bExpanded);
                    });
                }

                if ('menu_items_to_fix' in config) {
                    for (var i = 0; i < config.menu_items_to_fix.length; ++i) {
                        var menu = $('#' + config.menu_items_to_fix[i]).get(0);
                        fixup_droplist_alignment(menu);
                    }
                }

                _ext_call('postinit', that, {
                    config: config,
                    state: state,
                    table: table,
                    thead: thead,
                    head_row: head_row,
                    tbody: tbody,
                    qlist: qlist,
                    fn: _ext_internal_functions
                });

                that.trigger('qlist_load_that');
                var $window = $(window);
                $window.trigger('qlist_load');

                // make sure that the handler isn't bound multiple times.
                $window.off('resize.refresh_' + config.prefix);
                $window.on('resize.refresh_' + config.prefix,
                    // postpone adjust avoid frequently refresh
                    $.debounce(250, function() {
                        that.qlist('refresh');
                    }));

                that.on('qlist.update', function() {
                    that.qlist('refresh');
                });

                if ($.isFunction(config.callbacks.load)) {
                    config.callbacks.load.call(that[0], qlist);
                }

                _ext_call('postload', that, {
                    config: config,
                    state: state,
                    table: table,
                    thead: thead,
                    head_row: head_row,
                    tbody: tbody,
                    qlist: qlist,
                    fn: _ext_internal_functions
                });
            }

            function tbody_context(evt) {
                var target = evt.srcElement || evt.target;
                var elem = $(target).closest('tr.qlist_row:not(.unselectable),tr.qlist_category');

                if (!elem.length) {
                    return false;
                }

                var menu = qlist.ctxt_menu;

                if (!menu) {
                    return;
                }

                if (config.options.static_context_menu) {
                    menu.moveTo(evt.pageX, evt.pageY);
                    menu.show();
                    return;
                }

                menu.contextEventTarget = target;
                menu.preventContextDefault = false;

                if (config.enhanced_context) {

                    if (!(qlist.is_row_selected(elem))) {
                        qlist.clear_selection();
                        qlist.select_row(elem);
                    }

                    update_menu(target, menu);
                    menu.moveTo(evt.pageX, evt.pageY);
                    menu.show();
                } else {
                    var items = [];
                    items.addItem = items.push;
                    add_new_menu_items(items, qlist.ctxt_menu_items, qMenuClick);

                    if (config.qsource && elem.hasClass('qlist_cmdb_object')) {
                        config.qsource.buildMenu(target, menu, [items]).done(function() {
                            menu.moveTo(evt.pageX, evt.pageY);
                            menu.show();
                        });
                    } else {
                        menu.clearContent();
                        menu.addItems(items);
                        menu.render();
                        return true;
                    }
                }
                return false;
            }

            // head row context menu
            function applyColumnSettings(ctxMenu)
            {
                var pfx = config.prefix + '-col-';
                var items = $('ul.first-of-type', ctxMenu).children();
                var chosen = [];
                for (var item, i = 0; (item = items[i]); i++) {
                    chosen.push(item.id.substr(pfx.length));
                }
                // don't redraw unless settings have actually been changed.
                if (chosen.join(',') === config.chosen_columns.join(',')) {
                    return;
                }
                config.chosen_columns = chosen;
                // save settings to cookie
                if (chosen.length) {
                    setCookie(config.ck_name.column, chosen.join(','));
                }
                // also update the filter columns
                var fltarr = get_filter_settings();
                var newflt = $.grep(fltarr, function(flt) {
                        return $.inArray(flt.id, chosen) >= 0;
                    });
                /* Fix bug: 0435934 */
                // if (newflt.length !== fltarr.length) {
                //     apply_filter(newflt);
                // } else {
                    $(that).qlist('reload');
                // }
            }

            function set_category_cookie(cat, exp) {
                var ck_cats = (getCookie(config.ck_name.category) || '').split(',');
                var idx = $.inArray(cat, ck_cats);
                if (exp && idx < 0) {
                    ck_cats.push(cat);
                } else if (!exp && idx >= 0) {
                    ck_cats.splice(idx, 1);
                } else {
                    return;
                }
                setCookie(config.ck_name.category, ck_cats.join(','));
            }
        });
        return this.internationalizeLanguageEntries();
    };

    // code should slowly be moved from the above qlist to here, and to different files as well
    // in the future, use jquery widget factory, a similar library, or at least the same pattern
    // $.widget('fweb.fqlist', {..})
    // currently, fqlist only contains utility functions, that should be called on qlists,
    // for which invoking the main function is overly taxing

    // TODO: use jsperf to see how much of a performance hit a large closure qlist would cause,
    //       just to make sure that this is not in vain
    var utilFns = {
        visibleRows: function() {
            var $row = this.find('tr.qlist_row:first');
            var rowHeight = ($row.length > 0 ? $row.height() : 0) || 21;

            var $tbody = $row.length > 0 ?
                $row.closest('tbody') : this.find('table.qlist tbody:first');
            var tbodyHeight = $tbody.length > 0 ? $tbody.height() : window.outerHeight;

            return Math.max(Math.min(100, Math.floor(tbodyHeight / rowHeight)), 10);
        },
        // NOTE: this is a copy of the above save_page function.
        // TODO: remove one of them.
        save_page: function() {
            var $this = $(this);
            var config = $this.data('config');
            var page_no = $this.find('.page_current').val();
            if (localStorage && +page_no) {
                localStorage.setItem(config.prefix + '/current_page', page_no);
            }
        }
    };
    $.fn.fqlist = function(method/*, args...*/) {
        var args = Array.prototype.slice.call(arguments, 1);
        // with the current qlist, there are 3 ways of detecting a qlist
        var $this = this;
        if (!$this.hasClass('qlist-container') || !$this.data('config') ||
            !$this.data('qlist_state')) {
            return $.error('cannot call fqlist functions on non-qlist elements');
        }
        return utilFns[method].apply(this, args) || this;
    };

    function qlist_append_row(table, item, hide_cb) {
        var checkbox = $('<input type="checkbox" class="qlist_cb" />');

        if (typeof hide_cb === 'undefined') {
            hide_cb = false;
        }

        if (hide_cb === false) {
            $('<td></td>').prependTo(item);
        }

        $('td:first-child', item).prepend(checkbox);
        checkbox.toggle(hide_cb === false);

        $(item).addClass('qlist_row').appendTo(table);
    }

    // expose some utility functions
    window.qlist_append_row = qlist_append_row;

    // qlist modular extensions
    // TODO: refactor all major parts of qlist code into extensions
    // see qlist/qlist.examplePlugin.js for usage

    $.qlist.ext = {};

    /*const*/
    var NOT_CALLED = {};

    var ext_dependency_cache_keys = {},
        ext_dependency_cache_order = [];

    function _ext_resolve_config(parent, path) {
        // simple namespacing. This can easily be used as a helper for
        // creating global namspacing:
        // function namespace(path) { return _ext_resolve_config(window, path); }
        var parts = path.split('.'), _len = parts.length, current, i;
        for (i = 0; i < _len; i++) {
            current = parts[i];
            if (parent[current] == null) { parent[current] = {}; }
            parent = parent[current];
        }
        return parent;
    }
    // Utility functions for qlist extensions
    _ext_resolve_config($, 'qlist._ext').resolve_config = _ext_resolve_config;

    function _ext_calculate_dependancies() {
        var key, dirty = false, graph, visited;
        for (key in $.qlist.ext) {
            if ($.qlist.ext.hasOwnProperty(key)) {
                if (!ext_dependency_cache_keys.hasOwnProperty(key)) {
                    dirty = true;
                    break;
                }
            }
        }
        if (!dirty) { return ext_dependency_cache_order; }
        ext_dependency_cache_keys = {};
        ext_dependency_cache_order = [];
        graph = {};
        visited = {};
        for (key in $.qlist.ext) {
            if ($.qlist.ext.hasOwnProperty(key)) {
                graph[key] = [];
                if ($.qlist.ext[key].depends) {
                    $.merge(graph[key], $.qlist.ext[key].depends);
                }
            }
        }
        function visit(cur, dependents) {
            if (visited[cur]) { return; }
            dependents.push(cur);
            visited[cur] = true;
            // recursively traces up the dependancy tree until we find a plugin
            // that doesn't depend on anything else
            $.each(graph[cur], function(i, dependancy) {
                if ($.inArray(dependancy, dependents) >= 0) {
                    throw new Error('Circular dependancy found on ' + dependancy);
                }
                if (visited[dependancy]) { return; }
                visit(dependancy, dependents.slice(0));
            });
            ext_dependency_cache_order.push(cur);
            ext_dependency_cache_keys[cur] = true;
        }
        for (key in graph) {
            if (graph.hasOwnProperty(key)) {
                visit(key, []);
            }
        }
        return ext_dependency_cache_order;
    }
    // Double check our dependancies, that they all exist
    // TODO: check managed extensions - make sure that all managed dependancies
    //       are enabled, and possibly manually enable them if they're not enabled
    function _ext_check_dependancies() {
        var key, depends, i;
        for (key in $.qlist.ext) {
            if ($.qlist.ext.hasOwnProperty(key)) {
                depends = $.qlist.ext[key].depends || [];

                for (i = 0; i < depends.length; ++i) {
                    if (!$.qlist.ext.hasOwnProperty(depends[i])) {
                        throw new Error('Missing dependancy for ' + key + ': ' + depends[i]);
                    }
                }
            }
        }
    }
    function _ext_extend_defaults(defaults) {
        // This is the first extension function called in qlist, so it _should_
        // be safe to only check and resolve dependancies here.
        _ext_check_dependancies();
        _ext_calculate_dependancies();
        $.each(ext_dependency_cache_order, function(i, ext) {
            var _ref = $.qlist.ext[ext];
            if (_ref.defaults != null) {
                $.extend(_ext_resolve_config(defaults, _ref.config_path), _ref.defaults);
            }
            if (_ref.core_defaults != null) {
                // Not recursive merge, explicitly extending
                var options =
                    $.extend({}, defaults.options, _ref.core_defaults.options);
                $.extend(defaults, _ref.core_defaults);
                defaults.options = options;
            }
        });
    }
    function _ext_handle_commands(command_name, that, internal_core, args) {
        var rval = NOT_CALLED;
        var state = internal_core.state;
        $.each(ext_dependency_cache_order, function(i, ext) {
            var _ref = $.qlist.ext[ext], cmd_fn, local_internal_core;
            local_internal_core = $.extend({$self: state != null ? state[ext] : false},
                                           internal_core);
            if (_ref.commands != null && $.isFunction(cmd_fn = _ref.commands[command_name])) {
                rval = cmd_fn.apply(_ref, $.merge([that, local_internal_core || {}],
                                                  $.makeArray(args).slice(1)));
                return false;
            }
        });
        return rval;
    }
    function _ext_is_managed_enabled(ext, exts, config) {
        if (!ext.managed) { return true; }
        if (!(ext.enabled_config_path == null ?
                _ext_resolve_config(config, ext.config_path).enabled :
                _ext_resolve_config(config, ext.enabled_config_path)
            )) { return false; }
        var enabled = true;
        if (ext.managed === 'auto') {
            // TODO: use `_all` from ftoken_list.js when merged.
            $.each(ext.depends, function(i, dependancy) {
                // todo: cache to avoid recalculation
                if (!_ext_is_managed_enabled(exts[dependancy], exts, config)) {
                    enabled = false;
                    return false;
                }
            });
        }
        return enabled;
    }
    // `name` should be one of preconfigure, postconfigure,
    // preload, preinit, postinit, postload
    function _ext_call(name, that, internal) {
        var __slice = [].slice, _args = arguments;
        internal = { core: internal || {} };
        var state = internal.core.state;
        $.each(ext_dependency_cache_order, function(i, ext) {
            var _ref = $.qlist.ext[ext], result, local_internal;
            if (!_ext_is_managed_enabled(_ref, $.qlist.ext, internal.core.config)) {
                return; // continue
            }
            if ($.isFunction(_ref[name])) {
                // TODO: (refactor) proper dependancy injection
                // TODO: (refactor) make this instance injection apply to all _ext_ functions
                // inject the instance into the `internal` argument
                // $self = false indicates that the instance _cannot_ be permanently saved
                local_internal = $.extend({ $self: state != null ? state[ext] : false }, internal);
                // call the function
                result = internal[ext] = _ref[name].apply(
                    _ref, [that, local_internal].concat(__slice.call(_args, 3)));
                // if the call resulted in an instance of the constructor, automatically
                // save it on the state
                if (result instanceof _ref.constructor && state != null) {
                    state[ext] = result;
                }
            }
        });
    }
    // TODO: _ext_call_instance - use to support instances of plugins rather
    //       than the current static functions that are currently used
    // returns a decorated version of the original fn
    function _ext_decorate_fn(name, that, internal_core, fn/*, args...*/) {
        var __slice = [].slice, _args = arguments;
        $.each(ext_dependency_cache_order, function(i, ext) {
            var _ref = $.qlist.ext[ext];
            if (!_ext_is_managed_enabled(_ref, $.qlist.ext, internal_core.config)) {
                return; // continue
            }
            if ($.isFunction(_ref[name])) {
                fn = _ref[name].apply(_ref,
                    /* that, internal_core, fn, args... */ __slice.call(_args, 1));
                // Update the chained function
                _args[3] = fn;
            }
        });
        return fn;
    }

    /* returns a $.Callbacks object
     * TODO: this doesn't actually seem to be used anywhere, can we remove?
    function _ext_get_callback(name, that, internal_core) {
        var __slice = [].slice, _args = arguments;
        var callbacks = $.Callbacks();
        $.each(ext_dependency_cache_order, function(i, ext) {
            var _ref = $.qlist.ext[ext];
            if (!_ext_is_managed_enabled(_ref, $.qlist.ext, internal_core.config)) {
                return; // continue
            }
            if ($.isFunction(_ref[name])) {
                callbacks.add(_ref[name].apply(_ref, __slice.call(_args, 1)));
            }
        });
        return callbacks;
    }
    */
})(jQuery);
/*global CMDB,Notify,setQueryValue,getCookie,gui_settings,fweb,
  truncate_comment,cmdb_null_name, change_icon, is_rw_admin*/

// Dummy constructor so we have something to compare
// isinstance to.
function QListSource() { }


// Used for backwards compatibility.
var QListDefaultSource = (function($) {
    var config_defaults = {
        "mkey": "name"
    };
    var prototype = new QListSource();

    $.extend(prototype, {
        "getConfig": function() {
            return this.config;
        }
    });

    function Source(parameters) {
        this.config = $.extend({}, config_defaults, parameters);
    }

    Source.prototype = prototype;
    Source.prototype.constructor = Source;

    return Source;
})(jQuery);

function edit_cmdb_object(obj) {
    var cmdb_info = getCmdbInfo(obj.datasource);
    var mkey_name = cmdb_info["mkey"] || "name";
    var mkey = obj.mkey || obj[mkey_name] || obj.name;
    var type = obj.type;

    if ("getEditURL" in cmdb_info) {
        window.location.href = setQueryValue(cmdb_info.getEditURL(mkey || name, type), "redir", window.location.pathname);
    }
}

var cmdbManager = (function() {
    var config = { };
    var update_data = { };
    var append_data = [ ];
    var delete_data = [ ];
    var fetch_cache = {};
    var save_timer = null;
    var data_dirty = false;

    function init(path, name, mkey) {
        config.path = path;
        config.name = name;
        config.mkey = mkey;

        $j("#save_button").click(function() {
            cmdbManager.save();
            return false;
        });
    }

    function fetch(datasources) {
        var data_ready = $j.Deferred();
        var ready_list = [];
        var cmdb_data = {};
        var fetch_options = {
            "datasource": true,
            "skip": true
        };

        if (datasources && !($j.isArray(datasources))) {
            datasources = [ datasources ];
        }

        for (var idx=0, len=datasources.length; idx < len; ++idx) {
            var datasource = datasources[idx];

            if (!(datasource in fetch_cache)) {
                var parts = datasource.split(".");
                var name = parts.pop();
                var path = parts.join(".");

                fetch_cache[datasource] = CMDB.fetch(path, name, fetch_options);
            }

            ready_list.push(fetch_cache[datasource].done((function(datasource) {
                return function(response) {
                    if (response && "results" in response) {
                        cmdb_data[datasource] = response.results;
                    }
                };
            })(datasource)));
        }

        $j.when.apply(this, ready_list).done(function() {
            data_ready.resolve(cmdb_data);
        });

        return data_ready;
    }

    function update(mkey, data) {
        if (false === (mkey in update_data)) {
            update_data[mkey] = {};
        }

        $j.extend(update_data[mkey], data);

        toggle_is_dirty(true);
    }

    function append(mkey, data, before) {
        append_data.push({
            "mkey": mkey,
            "config": data,
            "before": before
        });

        toggle_is_dirty(true);
    }

    function cmdb_delete(mkey) {
        delete_data.push(mkey);
        toggle_is_dirty(true);
    }

    function dirty(value) {
        return value === undefined ? data_dirty : (data_dirty = value);
    }

    function toggle_mask(show) {
        var mask = $j("#save_mask");

        if (mask.length < 1) {
            mask = $j("<div id=\"save_mask\" />").appendTo("body");
        }

        mask.toggle(show);
    }

    function toggle_is_dirty(true_or_false) {
        var save_delay = 1000;

        if (!save_timer) {
            save_timer = window.setTimeout(do_save, save_delay);
        } else {
            clearTimeout(save_timer);
            save_timer = window.setTimeout(do_save, save_delay);
        }

        function do_save() {
            save().done(function() {
                var i, result;

                // normalize the arguments structure in the event that only a single
                // ajax event occured.
                if (arguments.length > 1 && typeof(arguments[1]) == 'string') {
                    arguments = [arguments[0]]
                }

                for (i = 0; result = arguments[i]; i++) {
                    if (result.error) break;
                }

                if (!result) {
                    Notify.post($j.getInfo("changes_saved"));
                } else {
                    $j.addLang("", "com_info");
                    Notify.post($j.getInfo(result.error), "error");
                }
            });
        }
    }

    function revert() {
        window.location.reload(true);
    }

    function save() {
        var ajax_events = [];

        $j.each(update_data, function(mkey, data) {
            var json = {};

            json[config.mkey] = mkey;
            $j.extend(json, data);

            ajax_events.push(
                CMDB.edit(config.path, config.name, mkey, json)
            );
        });
        update_data = {};

        $j.each(append_data, function(idx, info) {
            var json = $j.extend({}, info["config"]);
            json[config.mkey] = info["mkey"];
            var move_def = $j.Deferred();

            ajax_events.push(move_def.promise());
            ajax_events.push(
                CMDB.append(config.path, config.name, info["mkey"], json).done(function() {
                    CMDB.move(config.path, config.name, info["mkey"], null, { "before": info["before"] })
                        .fail(function(results) {
                            // It's possible for the append to return before the CMDB object is actually ready.
                            // This will re-try the CMDB move if the mkey doesn't exist on the first try.
                            window.setTimeout(function() {
                                CMDB.move(config.path, config.name, info["mkey"], null, { "before": info["before"] })
                                .then(function() {
                                    move_def.resolve();
                                });
                            }, 1000);
                        })
                        .done(function() {
                            move_def.resolve();
                        });
                })
            );
        });
        append_data = [];

        $j.each(delete_data, function(idx, mkey) {
            ajax_events.push(CMDB["delete"](config.path, config.name, mkey));
        });
        delete_data = [];

        data_dirty = ajax_events.length || data_dirty;

        toggle_mask(ajax_events.length > 0);

        var promise = $j.when.apply(this, ajax_events);
        promise.then(function() {
            toggle_mask(false);
        });
        return promise;
    }

    function save_complete() {
        $j(".qlist-container").qlist("reload");
    }

    return {
        "init": init,
        "dirty": dirty,
        "fetch": fetch,
        "update": update,
        "save": save,
        "append": append,
        "delete": cmdb_delete
    };
})();

var putCmdbInfo;
var cmdbFuncs;

/*
 * Manager for selecting objects inside of cells
 */
var objectSelector = {
    "selection_target": null,
    "setSelectionTarget": function(elem) {
        this.selection_target = elem;
    },
    "generateDisplayFunc": function(src_map) {
        var default_category = $j.getInfo("Uncategorized");

        return function(value) {
            var name, cls;

            if (typeof value !== "object" && value in src_map) {
                value = src_map[value];
            }

            name = value["label"] || value["name"] || value;
            cls = value["css-class"] || value["cls"] || "";

            var obj = {
                "label": "<span class='" + cls + "'></span>" + name
            };

            if (typeof value === "object" && "category" in value) {
                obj["category"] = value["category"]["name"] || default_category;
            }

            return obj;
        };
    },
    "setupMultiList": function(list, source, min, dlg, display_func) {
        var multilist_settings = {
            "min": min,
            "dialog": dlg,
            "floating": false,
            "max_height": 150,
            "source": source,
            "display": display_func
        };

        return $j(list).multiList(multilist_settings);
    },
    "buildSelector": function(src_map, source, current, min) {
        var list = $j("<input />")
            .css("width", "250px")
            .val(current);
        var dlg = $j("<div />")
            .append(list)
            .appendTo(document.body);

        var display_func = this.generateDisplayFunc(src_map);

        dlg.list = this.setupMultiList(list, source, min, dlg, display_func);

        return dlg;
    },
    "showSelector": function(params) {
        var src_map = {};
        var dfd = $j.Deferred();
        var selector_config = $j.extend({
            "current": null,
            "min": 1
        }, params);

        var list_source = $j.map(selector_config.source, function(object) {
            src_map[object.name] = object;
            return object.name;
        });

        var cancel_callback = function() {
            dfd.reject("cancel");
            selector.dialog("close");
        };

        var ok_callback = function() {
            var results = selector.list.val();
            var objects = [];

            $j.each(results.split(","), function(idx, id) {
                if (id !== "") {
                    objects.push(src_map[id]);
                }
            });

            dfd.resolve("ok", objects);
            selector.dialog("close");
        };

        var dialog_config = {
            "dialogClass": "inline-select",
            "resizable": false,
            "draggable": false,
            "modal": true,
            "buttons": [
                {"text": $j.getInfo("ok"), "click": ok_callback},
                {"text": $j.getInfo("cancel"), "click": cancel_callback}
            ],
            "position": {
                "my": "left top",
                "at": "left top",
                "of": this.selection_target
            },
            "open": function(event, ui) {
                $j('.ui-widget-overlay').on('click', cancel_callback)
                                        .css("opacity", "0");
            }
        };

        var selector = this.buildSelector(src_map,
                                          list_source,
                                          selector_config.current,
                                          selector_config.min);

        $j(selector).dialog(dialog_config);
        $j(selector).on("blur", cancel_callback);

        return dfd.promise();
    }
};



/*
 *  Central config for cmdb-source tables. The cmdb_info
 *  object here contains the type specific data for each
 *  cmdb object type
 */
var getCmdbInfo = (function() {
    /*
     * Wrapper function to create callbacks for the context menu. Figures out
     * which object the context should be applied to, and what CMDB type it
     * is.
     */
    function gen_qlist_menu_fn(fn, context) {
        var cmdb_info =  $j(context).data("cmdbInfo");
        var cmdb_type = cmdb_info["datasource"];

        if (!$j.isFunction(fn) || !context) {
            return function() { alert ("unsupported"); };
        }

        return function() {
            var row = $j(context).closest("tr.qlist_cmdb_object");
            var col = $j(context).closest("ul.qlist_cmdb_attr");

            return fn.call(this, cmdb_info, col, row);
        };
    }

    function clear_cached_context_fn() {
        if (cached_context) {
            cached_context = null;
        }
    }

    var cmdb_cache = {};
    var DEFAULT_SSL_SSH_PROFILE = 'certificate-inspection';

    function member_name(list, join_str) {
        return $j.map(list, function(member) { return member.name; }).join(join_str);
    }

    /*
     * Utility function for building select-type menus.
     *
     * submenu - array to append objects to
     * path - string with cmdb node path (eg: "antivirus")
     * name - string with cmdb node name (eg: "profile")
     * context - DOM object to which the CMDB info is attached
     *
     * returns  Promise that resolves with submenu object when
     *          ready.
     */
    function gen_qlist_submenu_select(menu, menu_items, path, name, context, included) {
        var data = $j(context).data("cmdbInfo");
        var formatter = getCmdbInfo(path + "." + name);
        var row_data = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
        var col_data = $j(context).closest("ul.qlist_cmdb_attr").data("cmdbInfo");
        var row_formatter = getCmdbInfo(row_data["datasource"]);
        var menu_ready = $j.Deferred();
        var format_fn = function(col_data, row_data) {
            return formatter.getFormatFunc(col_data, row_data);
        };

        if (row_formatter.attributes.hasOwnProperty(col_data.selector) &&
            $j.isFunction(row_formatter.attributes[col_data.selector].format_fn)) {
            format_fn = row_formatter.attributes[col_data.selector].format_fn;
        }

        function update_context_data(update) {
            data = $j(context).data("cmdbInfo");
            var parent_data = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
            var attribute = data["attribute"];
            var update_value =  {
                "name": update["name"]
            };
            var mkey = null,
                cmdb_update = {};
            var auto_set = false;

            if ("expansion" in parent_data && parent_data["expansion"] !== "parent") {
                var update_children = [];
                var children = parent_data["expansion"][parent_data["exp_attr"]];

                mkey = parent_data["expansion"]["mkey"];

                for (var i=0, l=children.length; i<l; ++i) {
                    if (children[i]["id"] === parent_data["id"]) {
                        children[i]["utm-status"] = "enable";

                        if (!(children[i]["profile-protocol-options"])) {
                            children[i]["profile-protocol-options"] = { "name": "default" };
                        }
                        if (!(children[i]["ssl-ssh-profile"])) {
                            children[i]["ssl-ssh-profile"] = { "name": DEFAULT_SSL_SSH_PROFILE };
                        }
                        children[i][attribute] = update_value;
                    }

                    update_children.push(clean_cmdb_config(children[i], false));
                }

                cmdb_update[parent_data["exp_attr"]] = update_children;
            } else {
                mkey = parent_data["mkey"];
                cmdb_update["utm-status"] = "enable";

                if (!(parent_data["profile-protocol-options"])) {
                    cmdb_update["profile-protocol-options"] = "default";
                    auto_set = true;
                }
                // the "default" value does not exist in ssl-ssh-profile anymore,
                // so the value sets "certificate-inspection" as its default.
                var parent_data_ssl_ssh_profile = parent_data["ssl-ssh-profile"];
                if (!parent_data_ssl_ssh_profile || !parent_data_ssl_ssh_profile.name) {
                    cmdb_update["ssl-ssh-profile"] = DEFAULT_SSL_SSH_PROFILE;
                    // auto update ssl inspection cell content only if the
                    // ssl-ssh-profile has never been set.
                    parent_data["ssl-ssh-profile"] = {
                        'attribute': "ssl-ssh-profile",
                        'css-class': "icon_fw ssl-ssh-profile",
                        'datasource': "firewall.ssl-ssh-profile",
                        'name': DEFAULT_SSL_SSH_PROFILE
                    };
                    auto_set = true;
                }

                cmdb_update[attribute] = update["name"];
            }

            $j.extend(data, update);
            cmdbManager.update(mkey, cmdb_update);
            if (auto_set) {
                cmdbManager.save();
                cmdbManager.update(mkey, cmdb_update);
            }

            var row = $j(context).closest("tr.qlist_cmdb_object");
            if (row != null) {
                var regen_row = row.data("regenerate");
                if ($j.isFunction(regen_row)) {
                    parent_data[attribute] = data;
                    var new_collection = regen_row(row, parent_data);
                    var new_row = new_collection.row;
                    new_row[0].className = row[0].className;
                }
            }
        }

        function generate_context_update(name) {
            return function() {
                update_context_data({ "name": name });
                return false;
            };
        }

        function check_utm_profile(datasource, path, name) {
            return datasource === 'firewall.explicit-proxy-policy' && (
                path === 'webfilter' && name === 'profile' ||
                path === 'dlp' && name === 'sensor' ||
                path === 'antivirus' && name === 'profile');
        }

        function utm_profile_proxy_filter(obj, index) {
            var is_proxy = true;
            if ('inspection-mode' in obj) {
                //av, webfilter
                is_proxy = obj['inspection-mode'] === 'proxy';
            } else if ('flow-based' in obj) {
                // dlp
                is_proxy = obj['flow-based'] === 'disable';
            }
            return is_proxy;
        }

        function handle_response(response) {
            var current = data["name"];
            var profile_name = "";
            var results = response.results;

            if ($j.inArray(data['attribute'], row_formatter['attributes']['profile']['can_not_be_empty']) == -1) {
                menu_items.push({
                    "text": $j.getInfo("none"),
                    "checked": (profile_name === current),
                    "onclick" : {
                        "fn": generate_context_update(profile_name)
                    }
                });
            }

            if (check_utm_profile(row_data.datasource, path, name)) {
                results = $j.grep(results, utm_profile_proxy_filter);
            }

            for (var idx=0, len=results.length; idx < len; ++idx) {
                profile_name = results[idx]["name"];

                menu_items.push({
                    "text": profile_name,
                    "checked": (profile_name === current),
                    "onclick" : {
                        "fn": generate_context_update(profile_name)
                    }
                });
            }

            menu_ready.resolve(menu);
        }

        var key = [path, name].join(".");

        if (false === (key in cmdb_cache)) {
            cmdb_cache[key] = CMDB.fetch(path, name);
        }

        cmdb_cache[key].done(handle_response);

        return menu_ready.promise();
    }

    function gen_select_menu_item(current, ready_list, menu_id, datasources, on_change, required) {
        var ready = $j.Deferred();
        var label = $j.getInfo(menu_id);

        ready_list.push(ready.promise());

        var select_menu = {
            "id": "sub_" + menu_id,
            "itemdata": []
        };

        var menu_item = {
            "id": "ctx_" + menu_id,
            "text": label,
            "submenu": select_menu
        };

        if (required === false) {
            select_menu["itemdata"].push({
                "text": $j.getInfo("none"),
                "checked": (current === ""),
                "onclick": {
                    "fn": on_change,
                    "obj": null
                }
            });
        }

        cmdbManager.fetch(datasources).done(function(objects) {
            for (var ds_idx=0, ds_len=datasources.length; ds_idx < ds_len; ++ds_idx) {
                var list = objects[datasources[ds_idx]];

                for (var mi_idx=0, mi_len=list.length; mi_idx < mi_len; ++mi_idx) {
                    var item = list[mi_idx];

                    item["datasource"] = datasources[ds_idx];

                    select_menu["itemdata"].push({
                        "text": item["name"],
                        "checked": (current === item["name"]),
                        "onclick": {
                            "fn": on_change,
                            "obj": item
                        }
                    });
                }
            }

            ready.resolve(menu_item);
        });

        return menu_item;
    }

    function check_explicit_proxy_support_utm(parent_info, datasource) {
            var support = true;
            var ftp_proxy_profiles = [
                'antivirus.profile', 'dlp.sensor', 'firewall.profile-protocol-options',
                'firewall.ssl-ssh-profile'
            ];
            var web_proxy_profiles = ['antivirus.profile', 'webfilter.profile',
                'application.list', 'ips.sensor', 'dlp.sensor',
                'icap.profile', 'firewall.profile-protocol-options',
                'firewall.ssl-ssh-profile'
            ];
            var proxy = '';
            if (!parent_info) {
                return false;
            }

            if(parent_info.proxy) {
                proxy = parent_info.proxy;
            } else if (parent_info.expansion) {
                proxy = parent_info.expansion.proxy;
            }
            if (proxy === 'web') {
                support = $j.inArray(datasource, web_proxy_profiles) > -1;
            }
            if (proxy === 'ftp') {
                support = $j.inArray(datasource, ftp_proxy_profiles) > -1;
            };
            return support;
    }

    function gen_utm_menu_fn(path, name) {
        var prefix = ["ctx", path, name].join("_");
        var lang_key = "select_" + name;
        var css_mapping = {
            "antivirus.profile": "av-profile",
            "spamfilter.profile": "spamfilter-profile",
            "webfilter.profile": "webfilter-profile",
            "application.list": "application-list",
            "ips.sensor": "ips-sensor",
            "dlp.sensor": "dlp-sensor",
            "voip.profile": "voip-profile",
            "icap.profile": "icap-profile",
            "firewall.profile-protocol-options": "profile-protocol-options",
            "firewall.ssl-ssh-profile": "ssl-ssh-profile"
        };

        return function(menu, context, included) {
            var cmdb_info = $j(context).data("cmdbInfo");
            var profile_menu = {
                "id": prefix + "_menu",
                "itemdata": []
            };
            var menu_items = [
                {
                    "id": prefix + "_edit",
                    "text" : $j.getInfo(["edit", path, name].join("_")),
                    "classname": "tool_sprite tool_edit",
                    "disabled": cmdb_info.name === "",
                    "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                },
                {
                    "text": $j.getInfo(lang_key),
                    "submenu": profile_menu,
                    "classname": "icon_fw " + css_mapping[[path, name].join(".")]
                }
            ];

            if (typeof included === "undefined") {
                included = false;
            }

            return gen_qlist_submenu_select(
                included ? profile_menu : menu_items, profile_menu["itemdata"], path, name, context, included
            );
        };
    }

    function boolean_attribute_menu(menu, context) {
        var formatter = this;

        var value_span = $j("span.qlist_cmdb_value", context);

        var parent_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
        var context_info = $j(context).data("cmdbInfo");
        var value_info = $j(value_span).data("cmdbInfo");
        var state;
        if (value_info) {
            state = value_info["value"];
        }
        var attribute = context_info["attribute"];

        var menu_items = [];

        $j.each(context_info.values, function(idx, value) {
            menu_items.push({
                "text": $j.getInfo(value),
                "checked": (state === value),
                "onclick": {
                    "fn": function() {
                        update_cmdb_info(context, "replace", attribute, value);

                        if (attribute === "status") {
                            $j(context).closest("tr.qlist_cmdb_object").toggleClass("disabled", value === "disable");
                        }
                    }
                }
            });
        });

        return menu_items;
    }

    function gen_add_objects_dialog(title, source, current, callbacks, min) {
        if (typeof min === "undefined") {
            min = 1;
        }

        var selector_options = {
            "source": source,
            "current": current,
            "min": min
        };

        return function() {
            var selector = objectSelector.showSelector(selector_options);

            selector.done(function(action, objects) {
                if (callbacks.hasOwnProperty(action) && $j.isFunction(callbacks[action])) {
                    callbacks[action](objects);
                }
            });
        };
    }

    var get_interface_addresses = (function() {
        var fw_policy_addr_map = {
            'v4': [],
            'v6': []
        };

        return function(src_intf, dst_intf, multicast, ipv6, always_update_cache) {
            if (typeof ipv6 === "undefined") {
                ipv6 = false;
            }

            var path = ipv6 ? "policy/6" : "policy";
            var cache_type = ipv6 ? "v6" : "v4";

            // any/all interfaces have the same name as any/all array object prototype
            var src_intf_exists = (src_intf in fw_policy_addr_map[cache_type]) &&
                fw_policy_addr_map[cache_type].hasOwnProperty(src_intf);
            if (!src_intf_exists) {
                fw_policy_addr_map[cache_type][src_intf] = [];
            }

            var dst_intf_exists = (dst_intf in fw_policy_addr_map[cache_type][src_intf]) &&
                fw_policy_addr_map[cache_type][src_intf].hasOwnProperty(dst_intf);

            if (!!always_update_cache || !dst_intf_exists) {
                var url = "/p/firewall/" + path + "/addresses/";

                if (multicast) {
                    url = setQueryValue(url, "multicast", 1);
                }

                if (typeof ipv6 === 'number') {
                    url = setQueryValue(url, "ipv6", ipv6);
                }

                var ajax_params = {
                    "url": url,
                    "data": {
                        "src": src_intf,
                        "dst": dst_intf
                    },
                    "dataType": "json"
                };

                fw_policy_addr_map[cache_type][src_intf][dst_intf] = $j.ajax(ajax_params);
            }

            return fw_policy_addr_map[cache_type][src_intf][dst_intf];
        };
    })();

    function is_device_policy(policy) {
        return policy.hasOwnProperty("devices");
    }

    function get_identity_policy_attr(policy, attribute) {
        var attr = null;

        if (policy.hasOwnProperty(attribute)) {
            attr = policy[attribute];
        } else if ($j.isPlainObject(policy.expansion) &&
                   policy.expansion.hasOwnProperty(attribute)) {
            attr = policy.expansion[attribute];
        }

        if ($j.isArray(attr) && attr.length > 0) {
            attr = attr[0];
        }

        return attr;
    }

    function id_get_groups(cmdb_info, datasources) {
        var policy_id = get_identity_policy_attr(cmdb_info, "policyid");
        var return_cache = id_get_groups.return_cache = (
            id_get_groups.return_cache || {}
        );
        var is_explicit_proxy_policy = cmdb_info.datasource ===
                                       'firewall.explicit-proxy-policy';
        // skip cache for explicit-proxy-policy, since the group list change with
        // Single Sign-On Method selected on GUI
        if (is_explicit_proxy_policy ||
            return_cache.hasOwnProperty(policy_id) === false) {
            var ipv6 = false;
            var url = "/p/firewall/policy/groups/" + policy_id + "/";
            if(is_explicit_proxy_policy) {
               url = setQueryValue(url, 'path', 'firewall.explicit-proxy-policy');
            }
            var ajax_params = {
                "url": url,
                "dataType": "json"
            };

            return_cache[policy_id] = $j.Deferred();

            $j.ajax(ajax_params).done(function(result) {
                if (result.hasOwnProperty("groups")) {
                    var dataset = {};
                    dataset[datasources[0]] = $j.map(result.groups, function(group) {
                        group['css-class'] = group['cls'];
                        return group;
                    });
                    return_cache[policy_id].resolve(dataset);
                } else {
                    return_cache[policy_id].reject();
                }
            });
        }

        return return_cache[policy_id];
    }

    function gen_source_menu_fn(attr, columns) {
        var options = []
        var i, column, option;
        for (i = 0; i < columns.length; i++) {
            option = null;
            column = columns[i];
            switch(column) {
                case 'srcaddr':
                    option = {
                        text: $j.getInfo("select_addresses"),
                        menuFunction: gen_addr_menu_fn("srcaddr", {"addr_type": "src"})
                    };
                    break;
                case 'dstaddr':
                    option = {
                        text: $j.getInfo("select_addresses"),
                        menuFunction: gen_addr_menu_fn("dstaddr", {"addr_type": "dst"})
                    };
                    break;
                case 'srcaddr6':
                    option = {
                        text: $j.getInfo("select_addresses6"),
                        menuFunction: gen_addr_menu_fn("srcaddr6", {"addr_type": "src"},
                                                       false, true, 'select_addresses6')
                    };
                    break;
                case 'dstaddr6':
                    option = {
                        text: $j.getInfo("select_addresses6"),
                        menuFunction: gen_addr_menu_fn("dstaddr6", {"addr_type": "dst"},
                                                       false, true, 'select_addresses6')
                     };
                    break;
                case 'devices':
                    option = {
                        text: $j.getInfo("select_devices"),
                        menuFunction: generate_select_item("devices", [
                            'user.device', 'user.device-category', 'user.device-group'
                        ], ['devices', 'users', 'groups'])
                    };
                    break;
               case 'users':
                   option = {
                        text: $j.getInfo("select_users"),
                        menuFunction: generate_select_item("users", ['user.local'],
                                                           ['devices', 'users', 'groups'])
                   };
                   break;
               case 'groups':
                   option = {
                        text: $j.getInfo("select_groups"),
                        sourceFunction: id_get_groups,
                        menuFunction: generate_select_item("groups", ['user.group'],
                                                           ['devices', 'users', 'groups'])
                   };
                   break;
            }
            if (option) {
                options.push(option);
            }
        }

        return function(menu, context) {
            var menu_ready = $j.Deferred();
            var wait_list = [];
            var menu_items = [];
            var cmdb_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");

            $j.each(options, function(id, option) {
                wait_list.push(
                    option.menuFunction(option.text, context, cmdb_info,
                                        option.filterFunction, option.sourceFunction)
                );
            });

            $j.when.apply(this, wait_list).done(function() {
                for (var idx = 0; idx < arguments.length; ++idx) {
                    menu_items = menu_items.concat(arguments[idx]);
                }

                menu_ready.resolve(menu_items);
            });

            return menu_ready.promise();
        };

        function get_device_name(device) {
            return (device.desc || device.alias || device.name);
        }

        function generate_select_item(prop, datasources, combine) {
            combine = combine || [];

            return function(title, context, cmdb_info, filter_fn, source_fn) {
                var ready = $j.Deferred();
                var wait = [];
                var source = [];
                var formatter = this;

                if (typeof cmdb_info === "undefined") {
                    return [];
                }

                var cmdb_val = cmdb_info[prop] || [];
                var current = member_name(cmdb_val);
                var extra_values = [];

                $j.each(combine, function(idx, item) {
                    if (item === prop) {
                        return true;
                    }

                    if (cmdb_info[item] != null) {
                        extra_values = extra_values.concat(cmdb_info[item]);
                    }
                });

                function ok_cb(values) {
                    update_cmdb_info(context, "replace", prop, values, true, attr, extra_values);
                }

                var dataset;

                if ($j.isFunction(source_fn)) {
                    dataset = source_fn(cmdb_info, datasources);
                } else {
                    dataset = cmdbManager.fetch(datasources);
                }

                $j.when(dataset).done(function(objects) {
                    for (var ds_idx=0, ds_len=datasources.length; ds_idx < ds_len; ++ds_idx) {
                        var list = objects[datasources[ds_idx]];

                        for (var mi_idx=0, mi_len=list.length; mi_idx < mi_len; ++mi_idx) {
                            var item = list[mi_idx];

                            if (!$j.isFunction(filter_fn) || filter_fn(cmdb_info, item)) {
                                // custom devices don't have a name property, so we have to insert
                                // one for the multilist.
                                item.name = item.name || item.alias;
                                item.label = get_device_name(item);
                                item["datasource"] = datasources[ds_idx];
                                source.push(item);
                            }
                        }
                    }

                    // TODO: the min value here needs to be set to one in some cases
                    var menu_items = [
                        {
                            "text": title,
                            "classname": "tool_sprite tool_select",
                            "onclick": {
                                "fn": gen_add_objects_dialog(title, source, current, {
                                    "ok": ok_cb
                                }, extra_values.length > 0 ? 0 : 1)
                            }
                        }
                    ];

                    ready.resolve(menu_items);
                });

                return ready;
            };
        }
    }

    function gen_addr_menu_fn(attr, filter, multicast, ipv6, text) {
        var title = text ? $j.getInfo(text) : $j.getInfo("select_addresses");

        return function(menu, context) {
            var ready = $j.Deferred();
            var wait = [];
            var source = [];
            var ajax_params = { };
            var formatter = this;
            var addr_type = 'addr_type' in filter ? filter['addr_type'] : null;
            var is_multicast = 'multicast' in filter ? filter['multicast']: false;

            var cmdb_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");

            if (typeof cmdb_info === "undefined") {
                return [];
            }

            var cmdb_val = cmdb_info[attr];

            if (typeof cmdb_val === "undefined") {
                return [];
            }

            if (typeof ipv6 === "undefined") {
                ipv6 = cmdb_info.datasource === 'firewall.policy6';
            }

            var always_update_cache = cmdb_info.datasource ===
                                       'firewall.explicit-proxy-policy';

            var current = member_name(cmdb_val);
            // explicit proxy policy has no srcintf attribute,
            var src_intf = member_name(cmdb_info.srcintf ||
                (cmdb_info.expansion ? cmdb_info.expansion.srcintf : '') || '');
            var dst_intf = member_name(cmdb_info["dstintf"] || cmdb_info["expansion"]["dstintf"]);

            var addr_data = get_interface_addresses(src_intf, dst_intf, is_multicast, ipv6, always_update_cache);

            function process_cmdb(response) {
                if ("addresses" in response) {
                    for (var i=0; i<response.addresses.length; ++i) {
                        if (!addr_type
                              || response.addresses[i].addr_type === addr_type) {
                            response.addresses[i]["css-class"] = response.addresses[i]["cls"];
                            source.push(response.addresses[i]);
                        }
                    }
                }
            }

            wait.push(addr_data.done(process_cmdb));

            function ok_cb(values) {
                update_cmdb_info(context, "replace", attr, values);
            }

            $j.when.apply(this, wait).done(function() {
                var menu_items = [
                    {
                        "text": title,
                        "classname": "tool_sprite tool_select",
                        "onclick": {
                            "fn": gen_add_objects_dialog(title, source, current, {
                                "ok": ok_cb
                            })
                        }
                    }
                ];

                ready.resolve(menu_items);
            });

            return ready;
        };
    }

    function gen_toggle_menu(mkey, attr, context) {
        var container = $j(context).closest(".qlist-container");
        var config = container.qlist("config");
        var source = config.qsource;
        var source_object = $j(context).data("cmdbInfo");
        var state = source_object[attr];

        var menu_items = [];

        $j.each(["enable", "disable"], function(idx, value) {
            menu_items.push({
                "text": $j.getInfo(value),
                "checked": (state === value),
                "onclick": {
                    "fn": function() {
                        var update_data = {};
                        var data = source.data;

                        update_data[attr] = value;
                        cmdbManager.update(source_object[mkey], update_data);
                        cmdbManager.save().then(function() {
                            container.qlist("reload");
                        });
                    }
                }
            });
        });

        return menu_items;
    }

    function status_fmt_fn(x) {
        return "<li class=\"centered\">"
            + "<span data-cmdb-info='" + JSON.stringify(x) + "' class='qlist_cmdb_value " + x["css-class"] + "'>" + x["name"] + "</span>"
            + "</li>";
    }

    function status_process_fn(x) {
        if (typeof x === "undefined") {
            return null;
        }

        return {
            "name": $j.getInfo(x),
            "value": x,
            "css-class": "icon_fw attr_" + (x === 'enable' ? 'all' : x)
        };
    }

    function negatable_format_fn(value, data) {
        var formatter = getCmdbInfo(value["datasource"]);
        var negate_attr = value["attribute"] + "-negate";

        if (data[negate_attr] === "enable") {
            value["css-class"] = "icon_fw negate";
        }

        return formatter.getFormatFunc(value, data);
    }

    function interface_format_fn(value, data) {
        var formatter = getCmdbInfo(value["datasource"]);

        if (typeof alias_map === 'object' && alias_map.hasOwnProperty(value.name)) {
            // clone interface object for display modification
            value = $j.extend({}, value);
            value.name = escapeHTML(alias_map[value.name]);
        }

        return formatter.getFormatFunc(value, data);
    }


    function check_gui_feature(datasource) {
        var key_map = {
            "spamfilter.profile": "spamfilter",
            "dlp.sensor": "dlp",
            "voip.profile": "voip-profile",
            "icap.profile": "icap",
            "antivirus.profile": "antivirus",
            "webfilter.profile": "webfilter",
            "ips.sensor": "ips",
            "application.list": "application-control"
        };

        var settings = gui_settings || {},
            key = key_map[datasource] || datasource;
        return !(key in settings) || (key in settings && settings[key] === "enable");
    }

    function is_forwarding_policy(policy) {
        return (policy['datasource'] === "firewall.policy" ||
            policy['datasource'] === "firewall.policy6");
    }

    function is_implicit_policy(policy) {
        return $j.isPlainObject(policy) && policy.implicit;
    }

    // get_possible_log_values -- Returns an array of possible values for the
    // "logtraffic" option on the current policy. This takes into account
    // the action of the policy, so that "Log Allowed Traffic" will be shown for
    // an ACCEPT policy and "Log Violation Traffic" will be shown for DENY.
    function get_possible_log_values(policy) {
        if (is_implicit_policy(policy)) {
            return ['enable', 'disable'];
        }

        var values = [];
        var enable_option = 'enable';
        var enable_text = (policy['action'] !== 'deny') ? 'allowed_traffic' : 'enable';

        if (is_forwarding_policy(policy)) {
            if (policy['action'] !== 'deny') {
                values.push('utm');
            }

            enable_option = 'all';
        }

        values.push([enable_option, enable_text]);
        values.push('disable');
        return values;
    }

    function utm_generate_icon(datasource) {
        var map = {
            "antivirus.profile": "AV",
            "webfilter.profile": "WEB",
            "spamfilter.profile": "EF",
            "application.list": "APP",
            "ips.sensor": "IPS",
            "dlp.sensor": "DLP",
            "voip.profile": "VOIP",
            "icap.profile": "ICAP",
            "firewall.profile-protocol-options": "PRX",
            "firewall.ssl-ssh-profile": "SSL",
            "firewall.profile-group": "GRP",
            "firewall.mms-profile": "MMS"
        };
        var _cls = function(datasource) {
            return "fw_icon_overlay";
        };
        var _txt = function(datasource) {
            return map[datasource];
        };

        return "<span class='" + _cls(datasource) + "'>" + _txt(datasource) + "</span>";
    }

    function utm_profile_formatter(data) {
        return utm_profile_formatter_generic(data, function(data, li_class, attr) {
            var bug = utm_generate_icon(data.datasource);
            var label = data.name || $j.getInfo("none");

            return "<li class='" + li_class + "' " + attr.join(" ") + ">"
                + "<div class='qlist_cmdb_object_container'>"
                + "<a " + attr.join(" ") + ">" + bug + label + "</a></div></li>";
        });
    }

    function utm_profile_compact_formatter(data) {
        return utm_profile_formatter_generic(data, function(data, li_class, attr) {
            var bug = utm_generate_icon(data.datasource);

            return "<li class='" + li_class + "' " + attr.join(" ") + ">"
                + "<div class='qlist_cmdb_object_container'>"
                + "<a " + attr.join(" ") + ">" + bug + "</a></div></li>";
        });
    }

    function utm_profile_formatter_generic(data, formatter) {
        var li_class = "qlist_inline_icon";
        var a_class = "qlist_cmdb_object";
        var attr = [];
        var title = $j.getInfo("none_selected");

        // in the event were are just passed a name, make an object out of it for processing
        if (typeof data !== 'object') {
            data = {
                name: data
            };
        }

        if (!check_gui_feature(data.datasource)) {
            return "";
        }

        if ("css-class" in data) {
            a_class += " " + data["css-class"];
        } else {
            return "";
        }

        if (data["name"] == null || data["name"] === "") {
            data["name"] = "";
            li_class += " qlist_inline_icon_disable";
        } else {
            a_class = a_class.replace('null', data['attribute']);
        }

        if ("" !== data["name"]) {
            title = $j.getInfo(data["datasource"]) + ": " + data["name"];
        }

        attr.push("title='" + title + "'");
        attr.push("class='" + a_class + "'");
        attr.push("data-cmdb-info='" + JSON.stringify(data) + "'");

        return formatter(data, li_class, attr);
    }

    function get_vip_url_ext(path) {
        var vip_map = {
            "firewall.vip": "",
            "firewall.vip6": "type=vip6",
            "firewall.vip46": "type=vip46",
            "firewall.vip64": "type=vip64"
        };

        return vip_map[path] || "";
    }

    function get_vip_formatter(cmdb_path, group) {
        var url_ext = get_vip_url_ext(cmdb_path);
        var path = group === true ? "virtualip/group" : "virtualip";

        return {
            "getEditURL": function(mkey, type) {
                if (type === 'server-load-balance') {
                    return "/firewall/ldb/vip/dlg?mkey=" + mkey;
                }
                return "/p/firewall/object/" + path + "/edit/" + mkey  + "/?" + url_ext;
            },
            "menu_fn": function(menu, context) {
                return [
                    {
                        "id": "firewall_vip_edit",
                        "text" : $j.getInfo("edit") + " " + $j.getInfo(cmdb_path),
                        "classname": "tool_sprite tool_edit",
                        "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                    }
                ];
            }
        };
    }

    function view_traffic_log(obj) {
        var mkey = obj.mkey,
            uuid = obj.uuid,
            log_policy_filter = [],
            log_uuid_opt = ['policy-only', 'extended'],
            is_uuid_enabled = log_uuid_opt.indexOf(uuid_in_traffic_log) !== -1,
            filter = is_uuid_enabled ? { "id": "poluuid", "logic": {}, "value": [uuid] } :
                                       { "id": "policyid", "logic": {}, "value": [mkey.toString()] };
        log_policy_filter.push(filter);
        // Redirect to the traffic log page and filter logs by policy uuid
        var view_log_url = "/p/logs/forward_traffic/?filter=" + encodeURIComponent(JSON.stringify(log_policy_filter));
        window.location.href = view_log_url;
    }

    function gen_generic_process_fn(def_datasource, def_css) {
        return function(obj) {
            var name = "",
                datasource = "",
                css_class = "";

            if (typeof obj === "undefined") {
                return null;
            }

            if (typeof obj === "object") {
                name = obj.name || "";
            } else {
                name = obj;
            }

            datasource = obj.datasource || def_datasource;
            css_class = obj["css-class"] || def_css;

            return {
                "name": name,
                "datasource": datasource,
                "css-class": css_class
            };
        }
    }

    /*
     * Enable/Disable RSSO or FSSO
     * Back import from fortiweb/packages/proj/firewall/policy/view.py
     * def update_sso
     * If local LDAP users or FSSO user groups are in policy, enable fsso,
     * disable otherwise.
     * If RSSO user groups are in policy, enable rsso, disable otherwise.
     */
    function update_sso(parent_info) {
        var groups = parent_info.groups || [];
        var users = parent_info.users || [];
        var types = {'rsso': false, 'fsso-service': false, 'ldap': false};
        $j.each(users, function(idx, user) {
            if (user['type'] === 'ldap') {
                types['ldap'] = true;
                return false;
            }
        })
        $j.each(groups, function(idx, group) {
            var group_type = group['group_type'];
            var css_class = group['css-class'];
            $j.each(['fsso-service', 'rsso'], function(idx, type) {
                if(!types[type]) {
                    if (group_type && group_type === type ||
                        css_class && css_class.indexOf(type) > -1) {
                        types[type] = true;
                    }
                }
            })
            if (types['rsso'] && types['fsso-service']) {
                return false;
            }
        })
        return {
            'rsso': types['rsso'] ? 'enable' : 'disable',
            'fsso': types['fsso-service'] || types['ldap'] ? 'enable' : 'disable'
        };
    }

    var cmdb_info = {
        "application": {
            "list": {
                "getEditURL": function(mkey) {
                    return "/p/utm/appctrl/sensor/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("application", "list"),
                "format_fn": utm_profile_formatter
            }
        },
        "ips": {
            "sensor": {
                "getEditURL": function(mkey) {
                    return "/p/utm/ips/sensor/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("ips", "sensor"),
                "format_fn": utm_profile_formatter
            }
        },
        "dlp": {
            "sensor": {
                "getEditURL": function(mkey) {
                    return "/p/utm/dlp/sensor/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("dlp", "sensor"),
                "format_fn": utm_profile_formatter
            }
        },
        "webfilter": {
            "profile": {
                "getEditURL": function(mkey) {
                    return "/p/utm/wf/profile/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("webfilter", "profile"),
                "format_fn": utm_profile_formatter
            }
        },
        "spamfilter": {
            "profile": {
                "getEditURL": function(mkey) {
                    return "/p/utm/email/profile/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("spamfilter", "profile"),
                "format_fn": utm_profile_formatter
            }
        },
        "antivirus": {
            "profile": {
                "getEditURL": function(mkey) {
                    return "/p/utm/antivirus/profile/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("antivirus", "profile"),
                "format_fn": utm_profile_formatter
            }
        },
        "system": {
            "interface": {
                "beforeContextShow": function(menu, context) {
                    var items = [
                        [
                           {
                                "id": "edit",
                                "text" : $j.getInfo("system/network/interfacedlg/title"),
                                "classname": "tool_sprite tool_edit",
                                "onclick": { "fn" : $j.noop }
                            }
                        ]
                    ];

                    menu.addItems(items);

                    return items.length > 0;
                }
            },
            "zone": {
            }
        },
        "voip": {
            "profile": {
                "getEditURL": function(mkey) {
                    return "/p/utm/voip/profile/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("voip", "profile"),
                "format_fn": utm_profile_formatter
            }
        },
        "icap": {
            "profile": {
                "getEditURL": function(mkey) {
                    return "/icap/profile/dlg?mkey=" + mkey;
                },
                "menu_fn": gen_utm_menu_fn("icap", "profile"),
                "format_fn": utm_profile_formatter
            }
        },
        "firewall": {
            "profile-protocol-options": {
                "getEditURL": function(mkey) {
                    return "/p/firewall/proxy_options/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("firewall", "profile-protocol-options"),
                "format_fn": utm_profile_formatter
            },
            "ssl-ssh-profile": {
                "getEditURL": function(mkey) {
                    return "/p/firewall/deep_inspection/edit/" + mkey + "/";
                },
                "menu_fn": gen_utm_menu_fn("firewall", "ssl-ssh-profile"),
                "format_fn": utm_profile_formatter
            },
            "address": {
                "ipv6": "",
                "multicast": "",
                "getEditURL": function(mkey) {
                    var uri = "/p/firewall/object/address/edit/" + mkey + "/";
                    if (this.ipv6) {
                        uri = setQueryValue(uri, "addr_cat", "addr_ipv6");
                    } else if (this.multicast) {
                        uri = setQueryValue(uri, "addr_cat", "multicast");
                    } else {
                        uri = setQueryValue(uri, "addr_cat", "addr");
                    }
                    return uri;
                },
                "menu_fn": function(menu, context) {
                    return [
                       {
                            "id": "firewall_address_edit",
                            "text" : $j.getInfo("edit") + " " + $j.getInfo("firewall.address"),
                            "classname": "tool_sprite tool_edit",
                            "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                        }
                    ];
                }
            },
            "addrgrp": {
            },
            "vip": get_vip_formatter("firewall.vip", false),
            "vip6": get_vip_formatter("firewall.vip6", false),
            "vip46": get_vip_formatter("firewall.vip46", false),
            "vip64": get_vip_formatter("firewall.vip64", false),
            "vipgrp": get_vip_formatter("firewall.vipgrp", true),
            "vipgrp6": get_vip_formatter("firewall.vipgrp6", true),
            "vipgrp46": get_vip_formatter("firewall.vipgrp46", true),
            "vipgrp64": get_vip_formatter("firewall.vipgrp64", true),
            "schedule": {
                "recurring": {
                    "getEditURL": function(mkey) {
                        return "/p/firewall/object/schedule/edit/" + mkey + "/";
                    },
                    "menu_fn": function(menu, context) {
                        return [
                           {
                                "id": "firewall_schedule_recurring_edit",
                                "text" : $j.getInfo("edit") + " " + $j.getInfo("firewall.schedule"),
                                "classname": "tool_sprite tool_edit",
                                "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                            }
                        ];
                    }
                },
                "onetime": {
                    "getEditURL": function(mkey) {
                        return "/p/firewall/object/schedule/edit/" + mkey + "/";
                    },
                    "menu_fn": function(menu, context) {
                        return [
                           {
                                "id": "firewall_schedule_onetime_edit",
                                "text" : $j.getInfo("edit") + " " + $j.getInfo("firewall.schedule"),
                                "classname": "tool_sprite tool_edit",
                                "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                            }
                        ];
                    }
                },
                "group": {
                    "getEditURL": function(mkey) {
                        return "/p/firewall/object/schedule/group/edit/" + mkey + "/";
                    },
                    "menu_fn": function(menu, context) {
                        return [
                           {
                                "id": "firewall_schedule_group_edit",
                                "text" : $j.getInfo("edit") + " " + $j.getInfo("firewall.schedule"),
                                "classname": "tool_sprite tool_edit",
                                "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                            }
                        ];
                    }
                }
            },
            "service": {
                "custom": {
                    "getEditURL": function(mkey) {
                        return "/p/firewall/object/service/edit/" + mkey + "/";
                    },
                    "menu_fn": function(menu, context) {
                        return [
                            {
                                "id": "edit_service",
                                "text" : $j.getInfo("edit") + " " + $j.getInfo("firewall.service.custom"),
                                "classname": "tool_sprite tool_edit",
                                "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                            }
                        ];
                    }
                },
                "group": { }
            },
            "policy": {
                "mkey": "policyid",
                "getEditURL": function(mkey) {
                    var edit_path = "edit/" + mkey;

                    if (typeof mkey === "string" && mkey.search(".") !== -1) {
                        edit_path = "rule/" + mkey.replace(".", "/") + "/";
                    }

                    return edit_path;
                },
                "menu_fn": function(menu, context) {
                    var policy_data = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");

                    if (policy_data.implicit) {
                        return false;
                    }

                    if (!("mkey" in policy_data) && policy_data["expansion"]["mkey"]) {
                        policy_data.mkey = [policy_data.expansion.mkey, policy_data.id].join('.');
                    }

                    var policyid = policy_data["mkey"];

                    function cloneArrayOrObject(item) {
                        if (Array.isArray(item)) {
                            return $j.extend(true, [], item);
                        }
                        if (typeof item === 'object') {
                            return $j.extend(true, {}, item);
                        }
                        return item;
                    }

                    function gen_empty_policy(base) {
                        return {
                            "srcintf": cloneArrayOrObject(base.srcintf),
                            "dstintf": cloneArrayOrObject(base.dstintf),
                            "srcaddr": [{"name": "all", "css-class": "icon_fw addr_0"}],
                            "dstaddr": [{"name": "all", "css-class": "icon_fw addr_0"}],
                            "schedule": {"name": "always", "css-class": "icon_fw sch_recur_0"},
                            "service": [{"name": "ALL", "css-class": "icon_fw srv_custom_0"}],
                            "action": "accept",
                            "status": "disable"
                        };
                    }

                    function gen_empty_explicit_proxy_policy(base) {
                        // ftp explicit proxy policy has no attribute 'service'
                        // but cmdb and cli will ignore it.
                        return {
                            "proxy": base.proxy,
                            "dstintf": cloneArrayOrObject(base.dstintf),
                            "srcaddr": [{"name": "all", "css-class": "icon_fw addr_0"}],
                            "dstaddr": [{"name": "all", "css-class": "icon_fw addr_0"}],
                            "schedule": {"name": "always", "css-class": "icon_fw sch_recur_0"},
                            "service": [{"name": "webproxy", "css-class": "icon_fw srv_custom_0"}],
                            "action": "accept",
                            "status": "disable"
                        };
                    }

                    function gen_insert_fn(position) {
                        var before = (position === "before");

                        return function(obj) {
                            var cmdb_info = getCmdbInfo(obj.datasource);
                            var scope = $j.extend({}, this, {"before": before});
                            var is_explicit_proxy_policy = !!policy_data &&
                                                           (policy_data.proxy === 'web' || policy_data.proxy === 'ftp');
                            if (is_explicit_proxy_policy) {
                                cmdb_info.paste_fn.call(scope, "paste", null, context, gen_empty_explicit_proxy_policy(policy_data));
                            } else {
                                cmdb_info.paste_fn.call(scope, "paste", null, context, gen_empty_policy(policy_data));
                            }

                        };
                    }

                    var translate = function(key) { return $j.getInfo(key); },
                        menu_edit = {
                            "classname": "tool_sprite " + (is_rw_admin ? "tool_edit" : "tool_search"),
                            "text": $j.getInfo(is_rw_admin ? "edit" : "view"),
                            "is_readonly": true,
                            "onclick": {
                                "fn": gen_qlist_menu_fn(edit_cmdb_object, context)
                            }
                        };

                    var menu_items = [
                            menu_edit,
                            {
                                "text": $j.map(["insert", "policy", "above"], translate).join(" "),
                                "classname": "tool_above",
                                "onclick": {
                                    "fn": gen_qlist_menu_fn(gen_insert_fn("before"), context),
                                    "scope": $j.extend({}, this, { "before": true }),
                                    "obj": context
                                }
                            },
                            {
                                "text": $j.map(["insert", "policy", "below"], translate).join(" "),
                                "classname": "tool_below",
                                "onclick": {
                                    "fn": gen_qlist_menu_fn(gen_insert_fn("after"), context),
                                    "scope": this,
                                    "obj": context
                                }
                            }
                        ];

                    if (policy_data.datasource !== 'firewall.multicast-policy') {
                        menu_items.push(
                            {
                                "text": $j.getInfo("view_log"),
                                "classname": "tool_sprite tool_view",
                                "onclick": {
                                    "fn": gen_qlist_menu_fn(view_traffic_log, context),
                                    "scope": this,
                                    "obj": context
                                }
                            }
                        );
                    }

                    if ($j.isPlainObject(policy_data.expansion)) {
                        return [menu_edit];
                    }

                    return [
                        menu_items,
                        gen_toggle_menu(this.mkey || "policyid", "status", context)
                    ];
                },
                "attributes": {
                    'source': {
                        'menu_fn': gen_source_menu_fn('source', ['srcaddr', 'devices', 'users', 'groups']),
                        'prev_save_fn': function(context, update_info, cmdb_manager) {
                            var parent_info = $j(context).closest("tr").data("cmdbInfo");
                            var datasource = parent_info.datasource;
                            var is_update_sso = (datasource === 'firewall.policy' ||
                                                 datasource === 'firewall.policy6') &&
                                                (update_info.hasOwnProperty('groups') ||
                                                 update_info.hasOwnProperty('users'));
                            var sso = null;
                            if (is_update_sso) {
                                sso = update_sso(parent_info);
                            }
                            return {
                                'update_info': sso ? $j.extend(true, update_info, sso) : update_info,
                                'mkey': parent_info.mkey,
                                'cmdb_manager': cmdb_manager
                            };
                        }
                    },
                    'groups': {
                        'menu_fn': gen_source_menu_fn('groups', ['groups']),
                        'prev_save_fn': function(context, update_info, cmdb_manager) {
                            var parent_info = $j(context).closest("tr").data("cmdbInfo");
                            var datasource = parent_info.datasource;
                            var is_update_sso = datasource === 'firewall.policy' ||
                                                datasource === 'firewall.policy6';
                            var sso = null;
                            if (is_update_sso) {
                                sso = update_sso(parent_info);
                            }
                            return {
                                'update_info': sso ? $j.extend(true, update_info, sso) : update_info,
                                'mkey': parent_info.mkey,
                                'cmdb_manager': cmdb_manager
                            };
                        }
                    },
                    'users': {
                        'menu_fn': gen_source_menu_fn('users', ['users']),
                        'prev_save_fn': function(context, update_info, cmdb_manager) {
                            var parent_info = $j(context).closest("tr").data("cmdbInfo");
                            var datasource = parent_info.datasource;
                            var is_update_sso = datasource === 'firewall.policy' ||
                                                datasource === 'firewall.policy6';
                            var sso = null;
                            if (is_update_sso) {
                                sso = update_sso(parent_info);
                            }
                            return {
                                'update_info': sso ? $j.extend(true, update_info, sso) : update_info,
                                'mkey': parent_info.mkey,
                                'cmdb_manager': cmdb_manager
                            };
                        }
                    },
                    'devices': {
                        'menu_fn': gen_source_menu_fn('devices', ['devices'])
                    },
                    "schedule": {
                        "menu_fn": function(menu, context, include) {
                            var parent_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
                            var current = parent_info["schedule"];
                            var ready_list = [];

                            if (typeof current === "undefined") {
                                return [];
                            }

                            gen_select_menu_item(
                                current.name,
                                ready_list,
                                "select_schedule",
                                [
                                    "firewall.schedule.recurring",
                                    "firewall.schedule.onetime",
                                    "firewall.schedule.group"
                                ],
                                function(event_type, event_info, arg) {
                                    return update_cmdb_info(context, "replace", "schedule", arg);
                                },
                                true
                            );

                            return $j.when.apply(this, ready_list);
                        }
                    },
                    "srcaddr": {
                        "menu_fn": gen_addr_menu_fn("srcaddr", {"addr_type": "src"}),
                        "format_fn": negatable_format_fn
                    },
                    "dstaddr": {
                        "menu_fn": gen_addr_menu_fn("dstaddr", {"addr_type": "dst"}),
                        "format_fn": negatable_format_fn
                    },
                    'srcintf': {
                        'format_fn': interface_format_fn
                    },
                    'dstintf': {
                        'format_fn': interface_format_fn
                    },
                    "action": {
                        "format_fn": function(x) {
                            return "<li>"
                                + "<span data-cmdb-info='" + JSON.stringify(x) + "' class='qlist_cmdb_value " + x["css-class"] + "'>" + x["name"] + "</span>"
                                + "</li>";
                        },
                        "process_fn": function(x, row_data) {
                            if (typeof x === "undefined") {
                                return "";
                            }

                            var cls = {
                                "accept": "act_accept",
                                "deny": "act_deny",
                                "ipsec": "act_ipsec",
                                "ssl-vpn": "act_sslvpn"
                            };

                            return {
                                "name": $j.getInfo(x),
                                "value": x,
                                "css-class": "icon_fw " + cls[x]
                            };
                        },
                        "menu_fn": function(menu, context) {
                            var formatter = this;
                            var value_span = $j("span.qlist_cmdb_value", context);

                            var parent_row = $j(context).closest("tr.qlist_cmdb_object");
                            var parent_info = parent_row.data("cmdbInfo");
                            var context_info = $j(context).data("cmdbInfo");
                            var value_info = $j(value_span).data("cmdbInfo");
                            var state = value_info ? value_info.value : null;
                            var attribute = context_info["attribute"];

                            var menu_items = [];

                            if (0 <= $j.inArray(state, ["accept", "deny"])) {
                                $j.each(["accept", "deny"], function(idx, value) {
                                        menu_items.push({
                                            "text": $j.getInfo(value),
                                            "checked": (state === value),
                                            "onclick": {
                                                "fn": function() {
                                                    update_cmdb_info(context, "replace", attribute, value);
                                                }
                                            }
                                        });
                                });
                            }

                            return menu_items;
                        }
                    },
                    "status": {
                        "format_fn": status_fmt_fn,
                        "process_fn": status_process_fn,
                        "menu_fn": boolean_attribute_menu
                    },
                    "endpoint-compliance": {
                        "format_fn": status_fmt_fn,
                        "process_fn": status_process_fn,
                        "menu_fn": boolean_attribute_menu
                    },
                    "nat": {
                        "format_fn": function(x) {
                            return "<li class=\"centered\">"
                                + "<span data-cmdb-info='" + JSON.stringify(x) + "' class='qlist_cmdb_value " + x["css-class"] + "'>" + x["name"] + "</span>"
                                + "</li>";
                        },
                        "process_fn": function(x) {
                            return status_process_fn(x);
                        },
                        "menu_fn": boolean_attribute_menu
                    },
                    "logtraffic": {
                        "format_fn": function(x) {
                            return "<li class=\"centered\">"
                                + "<span data-cmdb-info='" + JSON.stringify(x) + "' class='qlist_cmdb_value " + x["css-class"] + "'>" + x["name"] + "</span>"
                                + "</li>";
                        },
                        "process_fn": function(x) {
                            return status_process_fn(x);
                        },
                        "menu_fn": function(menu, context) {
                            var value_span = $j("span.qlist_cmdb_value", context);

                            var parent_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
                            var context_info = $j(context).data("cmdbInfo");
                            var value_info = $j(value_span).data("cmdbInfo");
                            var state = value_info["value"];
                            var attribute = context_info["attribute"];

                            var menu_items = [];
                            var values = get_possible_log_values(parent_info);

                            $j.each(values, function(idx, value) {
                                var val, lang_key;
                                if ($j.isArray(value)) {
                                    val = value[0];
                                    lang_key = value[1];
                                } else {
                                    val = lang_key = value;
                                }

                                lang_key = "log_" + lang_key;

                                menu_items.push({
                                    "text": $j.getInfo(lang_key),
                                    "checked": (state === val),
                                    "onclick": {
                                        "fn": function() {
                                            update_cmdb_info(context, "replace", attribute, val);
                                        }
                                    }
                                });
                            });

                           return menu_items;
                        },
                        "prev_save_fn": function(context, update_info, cm) {
                            var row_cmdb_info = $j(context).closest("tr").data("cmdbInfo"),
                                is_ipv6 = $j.isPlainObject(row_cmdb_info) && row_cmdb_info.datasource === "firewall.policy6",
                                implicit_attr = is_ipv6 ? "fwpolicy6-implicit-log" : "fwpolicy-implicit-log",
                                mkey = row_cmdb_info.mkey;

                            if (row_cmdb_info.implicit) {
                                var update_info_tmp = {};
                                update_info_tmp[implicit_attr] = update_info['logtraffic'];
                                update_info = update_info_tmp;
                                cm.init('log', 'setting', mkey);
                            } else {
                                var parts = row_cmdb_info.datasource.split("."),
                                    name = parts.pop(),
                                    path = parts.join(".");

                                cm.init(path, name, row_cmdb_info.mkey);
                            }

                            return {
                                'cmdb_manager': cm,
                                'update_info': update_info,
                                'mkey': mkey
                            };
                        }
                    },
                    "av-profile": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "spamfilter-profile": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "webfilter-profile": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "application-list": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "ips-sensor": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "dlp-sensor": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "voip-profile": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "icap-profile": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "profile-protocol-options": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "ssl-ssh-profile": {
                        "allow_set_when_skipped": true,
                        "format_fn": negatable_format_fn,
                        "get_none": function() { return ""; }
                    },
                    "mms-profile": {
                        "format_fn": utm_profile_formatter,
                        "process_fn": gen_generic_process_fn("firewall.mms-profile", "icon_fw mms-profile")
                    },
                    "profile-group": {
                        "format_fn": utm_profile_formatter,
                        "process_fn": gen_generic_process_fn("firewall.profile-group", "icon_fw profile-group")
                    },
                    "profile": {
                        "can_not_be_empty": ['profile-protocol-options'],
                        "list_class": "qlist_obj_list_centered",
                        "menu_fn": function(menu, context) {
                            var combine = [
                                    [ "antivirus.profile", "av-profile" ],
                                    [ "spamfilter.profile", "spamfilter-profile" ],
                                    [ "webfilter.profile", "webfilter-profile" ],
                                    [ "application.list", "application-list" ],
                                    [ "ips.sensor", "ips-sensor" ],
                                    [ "dlp.sensor", "dlp-sensor" ],
                                    [ "voip.profile", "voip-profile" ],
                                    [ "icap.profile", "icap-profile" ],
                                    [ "firewall.profile-protocol-options", "profile-protocol-options" ],
                                    [ "firewall.ssl-ssh-profile", "ssl-ssh-profile" ]
                                ];
                            var parent_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
                            var items = [];
                            var profile_promises = [];
                            var ret = $j.Deferred();
                            var refresh_required = false;

                            if (parent_info["action"] == "deny" || parent_info["expansion"] == "parent") {
                                return [];
                            }

                            combine = $j.grep(combine, function(item) {
                                          return check_gui_feature(item[0]) &&
                                                 check_explicit_proxy_support_utm(parent_info, item[0]);
                                      });

                            for (var idx=0, attr; idx < combine.length && (attr = combine[idx]); ++idx) {
                                var label = attr[0];
                                var profile_formatter = getCmdbInfo(label);
                                var profile_context = null;

                                $j("a.qlist_cmdb_object", context).each(function() {
                                    if ($j(this).data("cmdbInfo")["datasource"] === label) {
                                        profile_context = this;
                                        return false;
                                    }
                                });

                                if (null === profile_context) {
                                    profile_context = $j(this.getFormatFunc({
                                            "name": "",
                                            "datasource": attr[0],
                                            "attribute": attr[1],
                                            "css-class": "icon_fw " + attr[1]
                                        }, parent_info)).appendTo(context);

                                    refresh_required = true;
                                }

                                var menu_config = {
                                    "text" : $j.getInfo(label),
                                    "classname": "icon_fw " + attr[1],
                                    "submenu": {}
                                };

                                if ("getMenuItems" in profile_formatter) {
                                    var prof_wait = $j.when(
                                            profile_formatter.getMenuItems(menu, profile_context, true))
                                                .done((function(menu_config, label) {
                                                    return function(utm_menu) {
                                                        if ($j.isArray(utm_menu)) {
                                                            utm_menu = utm_menu[0];
                                                        }

                                                        menu_config["submenu"] = utm_menu;
                                                        menu_config["submenu"]["id"] = label + "_submenu";
                                                    };
                                                })(menu_config, label));

                                    items.push(menu_config);
                                    profile_promises.push(prof_wait);
                                }
                            }

                            $j.when.apply(this, profile_promises).done(function() {
                                ret.resolve(items);

                                if (refresh_required) {
                                    $j(context).closest(".qlist-container").qlist("refresh");
                                }
                            });

                            return ret.promise();
                        },
                        "format_fn": utm_profile_compact_formatter
                    },
                    "service": {
                        "format_fn": negatable_format_fn,
                        "menu_fn": function(menu, context) {
                            // TODO: refactor this function (it's way too long)
                            var ready = $j.Deferred();
                            var wait = [];
                            var title = $j.getInfo("select_services");
                            var source = [];
                            var ajax_params = {
                                "datasource": "true"
                            };
                            var formatter = this;

                            var cmdb_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
                            var attr_info = $j(context).data("cmdbInfo");
                            var cmdb_val = cmdb_info[attr_info["attribute"]];
                            var is_web_explicit_proxy_policy = !!cmdb_info && cmdb_info.proxy === 'web';
                            if (typeof cmdb_val === "undefined") {
                                return [];
                            }

                            var current = $j.map(cmdb_val, function(svr) { return svr.name; }).join(",");

                            if (!("firewall.service.custom" in cmdb_cache)) {
                                cmdb_cache["firewall.service.custom"] = CMDB.fetch("firewall.service", "custom", ajax_params);
                            }

                            if (!("firewall.service.group" in cmdb_cache)) {
                                cmdb_cache["firewall.service.group"] = CMDB.fetch("firewall.service", "group", ajax_params);
                            }

                            function process_cmdb(datasource) {
                                return function(response) {
                                    for (var i=response.results.length - 1; i>=0; --i) {
                                        response.results[i]["datasource"] = datasource;
                                        source.push(response.results[i]);
                                    }
                                };
                            }

                            wait.push(cmdb_cache["firewall.service.group"].done(
                                    process_cmdb("firewall.service.group")
                                )
                            );
                            wait.push(cmdb_cache["firewall.service.custom"].done(
                                    process_cmdb("firewall.service.custom")
                                )
                            );

                            var format_fn = function(data) {
                                var attr = [];
                                var a_class = "qlist_cmdb_object";

                                if (typeof data["name"] === "undefined") {
                                    return "";
                                }

                                if ("css-class" in data) {
                                    a_class += " " + data["css-class"];
                                }

                                attr.push("data-cmdb-info='" + JSON.stringify(data) + "'");

                                return "<li><a class=\"" + a_class + "\" " + attr.join(" ") + ">" + data["name"] + "</a></li>";
                            };

                            function ok_cb(value) {
                                for (var i=value.length-1; i >= 0; --i) {
                                    if (value[i].name === "ALL") {
                                        value = [value[i]];
                                        break;
                                    }
                                }

                                return update_cmdb_info(context, "replace", attr_info["attribute"], value);
                            }

                            $j.when.apply(this, wait).done(function() {
                                function normalize_service(svc) {
                                    if (!("category" in svc)) {
                                        svc["category"] = {
                                            "name": "Service Groups"
                                        };
                                    }

                                    if (svc["category"] === "") {
                                        svc["category"] = {
                                            "name": "Uncategorized"
                                        };
                                    }
                                }

                                function service_sort_fn(a, b) {
                                    normalize_service(a);
                                    normalize_service(b);

                                    if (a["category"]["name"] === b["category"]["name"]) {
                                        if (a["category"]["name"] < b["category"]["name"]) {
                                            return 1;
                                        } else if (a["category"]["name"] > b["category"]["name"]) {
                                            return -1;
                                        }
                                    } else if (a["category"]["name"] > b["category"]["name"]) {
                                        return 1;
                                    } else if (a["category"]["name"] < b["category"]["name"]) {
                                        return -1;
                                    }

                                    return 0;
                                }

                                source = $j.grep(source, function(elem, index) {
                                    if (is_web_explicit_proxy_policy) {
                                       return (elem["visibility"] !== 'disable' &&
                                               'explicit-proxy' in elem &&
                                               elem['explicit-proxy'] === 'enable');

                                    }
                                    return elem["visibility"] !== 'disable';

                                });

                                source.sort(service_sort_fn);

                                var menu_items = [
                                    {
                                        "text": title,
                                        "classname": "tool_sprite tool_select",
                                        "onclick": {
                                            "fn": gen_add_objects_dialog(title, source, current, {
                                                "ok": ok_cb
                                            })
                                        }
                                    }
                                ];

                                ready.resolve(menu_items);
                            });

                            return ready;
                        },
                        "get_none": function() { return "NONE"; }
                    },
                    "comments": {
                        "format_fn": function(data) {
                            if (data) {
                                return truncate_comment(data);
                            }
                            return "";
                        }
                    }
                }
            },
            "multicast-policy": {
            }, // to be generated by copying policy and updating relevant attributes,
            "explicit-proxy-policy": {
            } // to be generated by copying policy and updating relevant attributes,
        },
        "user": {
            "local": {
                "getEditURL": function(mkey) {
                    return "/user/local/dlg?mkey=" + mkey;
                },
                "menu_fn": function(menu, context) {
                    return [
                        {
                            "id": "edit_userlocal",
                            "text": $j.getInfo("edit") + " " + $j.getInfo("user.local"),
                            "classname": "tool_sprite tool_edit",
                            "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                        }
                    ];
                }
            },
            "device-category": {
                "getEditURL": function(mkey) {
                    return "/p/user/device_group/show/" + mkey + "/";
                },
                "menu_fn": function(menu, context) {
                    return [
                        {
                            "id": "edit_devicecat",
                            "text": $j.getInfo("show") + " " + $j.getInfo("user.device-category"),
                            "classname": "tool_sprite tool_edit",
                            "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                        }
                    ];
                },
                "format_fn": function(data, parent_data) {
                    var attr = [];
                    var a_class = "qlist_cmdb_object";
                    if (typeof data["name"] == "undefined") {
                        return "";
                    }

                    if ("css-class" in data) {
                        a_class += " " + data["css-class"];
                    }

                    attr.push("data-cmdb-info='" + JSON.stringify(data) + "'");

                    var devices_mapping = parent_data.all_devices;

                    return "<li><div class='qlist_cmdb_object_container'>"
                        + "<a class=\"" + a_class + "\" " + attr.join(" ") + ">" + devices_mapping[data["name"]] + "</a>"
                        + "</div></li>";
                }
            },
            "device": {
                "mkey": "alias",
                "getEditURL": function(mkey) {
                    return "/p/user/device/edit/" + mkey + "/";
                },
                "menu_fn": function(menu, context) {
                    return [
                        {
                            "id": "edit_device",
                            "text": $j.getInfo("edit") + " " + $j.getInfo("user.device"),
                            "classname": "tool_sprite tool_edit",
                            "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                        }
                    ];
                }
            },
            "device-group": {
                "getEditURL": function(mkey) {
                    return "/p/user/device_group/edit/" + mkey + "/";
                },
                "menu_fn": function(menu, context) {
                    return [
                        {
                            "id": "edit_devicegrp",
                            "text": $j.getInfo("edit") + " " + $j.getInfo("user.device-group"),
                            "classname": "tool_sprite tool_edit",
                            "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                        }
                    ];
                }
            },
            "group": {
                "getEditURL": function(mkey) {
                    return "/p/user/group/edit/" + mkey + "/";
                },
                "menu_fn": function(menu, context) {
                    return [
                        {
                            "id": "edit_usergrp",
                            "text": $j.getInfo("edit") + " " + $j.getInfo("user.group"),
                            "classname": "tool_sprite tool_edit",
                            "onclick": { "fn" : gen_qlist_menu_fn(edit_cmdb_object, context) }
                        }
                    ];
                }
            }
        }
    };

    cmdb_info["firewall"]["policy6"] = $j.extend(true, {}, cmdb_info["firewall"]["policy"]);
    $j.extend(cmdb_info["firewall"]["policy6"]["attributes"], {
        "srcaddr": {
            "menu_fn": gen_addr_menu_fn("srcaddr", {"addr_type": "src"}, false, true),
            "format_fn": negatable_format_fn
        },
        "dstaddr": {
            "menu_fn": gen_addr_menu_fn("dstaddr", {"addr_type": "dst"}, false, true),
            "format_fn": negatable_format_fn
        }
    });

    cmdb_info["firewall"]["explicit-proxy-policy"] = $j.extend(true, {}, cmdb_info["firewall"]["policy"]);
    $j.extend(cmdb_info["firewall"]["explicit-proxy-policy"]["attributes"], {
        "source": {
            "menu_fn": gen_source_menu_fn('source', ['srcaddr', 'srcaddr6']),
            "format_fn": negatable_format_fn
        },
        "destination": {
            "menu_fn": gen_source_menu_fn('destination', ['dstaddr', 'dstaddr6'])
        },
        "srcaddr6": {
            "menu_fn": gen_addr_menu_fn("srcaddr6", {"addr_type": "src"}, false, true),
            "format_fn": negatable_format_fn
        },
        "dstaddr6": {
            "menu_fn": gen_addr_menu_fn("dstaddr6", {"addr_type": "dst"}, false, true),
            "format_fn": negatable_format_fn
        }
    });

    cmdb_info["firewall"]["address6"] = $j.extend({}, cmdb_info["firewall"]["address"], {"ipv6": '6'});
    cmdb_info["firewall"]["multicast-address"] = $j.extend({}, cmdb_info["firewall"]["address"], {"multicast": true});
    cmdb_info["firewall"]["addrgrp6"] = $j.extend({}, cmdb_info["firewall"]["addrgrp"], {"ipv6": '6'});

    cmdb_info["firewall"]["multicast-policy"] = gen_multicast_policy_cmdb_info($j.extend({}, cmdb_info["firewall"]["policy"]));
    cmdb_info["firewall"]["policy64"] = gen_policy_64_46_cmdb_info(
        cmdb_info["firewall"]["policy6"], 64);
    cmdb_info["firewall"]["policy46"] = gen_policy_64_46_cmdb_info(
        cmdb_info["firewall"]["policy6"], 46);

    function gen_policy_64_46_cmdb_info(policy_entry, nat64) {
        var entry = {
            "attributes": {
                "srcaddr": {
                    "menu_fn": gen_addr_menu_fn(
                        "srcaddr", {"addr_type": "src"}, false, nat64)
                },
                "dstaddr": {
                    "menu_fn": gen_addr_menu_fn(
                        "dstaddr", {"addr_type": "dst"}, false, nat64)
                },
                "srcintf": {},
                "dstintf": {}
            }
        };

        var kept_attrs = ['status', 'logtraffic', 'action', 'comments',
                          'schedule', 'service'];
        var i = kept_attrs.length;

        while (i--) {
            var key = kept_attrs[i];
            entry['attributes'][key] = policy_entry['attributes'][key];
        }

        return entry;
    }


    function gen_multicast_policy_cmdb_info(policy_entry) {
        var entry = {
            "mkey": "id",
            "getEditURL": function(mkey) {
                return "/p/firewall/policy/firewall/multicast/" + mkey;
            },
            "menu_fn": function(menu, context) {
                var menu_fn_clone = policy_entry['menu_fn'](menu, context);

                $j.extend(menu_fn_clone[1], {
                    'submenu': {
                        'itemdata': gen_toggle_menu("id", "status", context)
                    }
                });

                return menu_fn_clone;
            },
            "attributes": {
                "srcaddr": {
                    "menu_fn": gen_addr_menu_fn("srcaddr", {"addr_type": "src", "multicast": true})
                },
                "dstaddr": {
                    "menu_fn": gen_addr_menu_fn("dstaddr", {"addr_type": "dst", "multicast": true})
                },
                "dnat": {},
                "snat": policy_entry['attributes']['nat'],
                "protocol": {},
                "srcintf": {},
                "dstintf": {}
            }
        };

        var kept_attrs = ['status', 'logtraffic', 'action', 'comments'];
        var i = kept_attrs.length;

        policy_entry.mkey = "id";

        while (i--) {
            var key = kept_attrs[i];
            entry['attributes'][key] = policy_entry['attributes'][key];
        }

        return entry;
    }

    function isContextRow(context) {
        return $j(context).is("tr.qlist_cmdb_object");
    }

    function countRowsByContext(context) {
        return $j(context).closest("table").find("tr.qlist_cmdb_object").length;
    }

    function canCutContext(context) {
        return !isContextRow(context) || countRowsByContext(context) > 1;
    }

    function getMenuItems(menu, context, included) {
        var parent_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
        var cmdb_info = JSON.parse($j(context).attr("data-cmdb-info") || "{}");
        var ret = $j.Deferred();
        var wait_list = [];
        var menu_items = [];

        if ($j.isPlainObject(parent_info.expansion) === false || cmdb_info.attribute != null) {
            if ("remove_fn" in this) {
                menu_items.push({
                    "text": $j.getInfo("remove") + " " + $j.getInfo(cmdb_info["datasource"] || parent_info["datasource"]),
                    "classname": "tool_sprite tool_delete",
                    "disabled": !!cmdb_info.placeholder,
                    "onclick": {
                        "fn": this.remove_fn,
                        "scope": this,
                        "obj": context
                    }
                });
            }

            if ("cut_fn" in this) {
                menu_items.push({
                    "text": $j.getInfo("cut") + " " + $j.getInfo(cmdb_info["datasource"] || parent_info["datasource"]),
                    "classname": "tool_sprite tool_cut",
                    "disabled": !canCutContext(context),
                    "onclick": {
                        "fn": this.cut_fn,
                        "scope": this,
                        "obj": context
                    }
                });
            }

            if ("copy_fn" in this) {
                menu_items.push({
                    "text": $j.getInfo("copy") + " " + $j.getInfo(cmdb_info["datasource"] || parent_info["datasource"]),
                    "classname": "tool_sprite tool_copy",
                    "disabled": !!cmdb_info.placeholder,
                    "onclick": {
                        "fn": this.copy_fn,
                        "scope": this,
                        "obj": context
                    }
                });
            }

            if ("paste_fn" in this) {
                var paste = {
                    "text": $j.getInfo("paste"),
                    "classname": "tool_sprite tool_paste",
                    "disabled": false
                };

                if (isContextRow(context)) {
                    paste["submenu"] = {
                        "id": "paste_submenu",
                        "itemdata": [
                            {
                                "text": $j.getInfo("paste_before"),
                                "classname": "tool_above",
                                "onclick": {
                                    "fn": this.paste_fn,
                                    "scope": $j.extend({}, this, { "before": true }),
                                    "obj": context
                                }
                            },
                            {
                                "text": $j.getInfo("paste_after"),
                                "classname": "tool_below",
                                "onclick": {
                                    "fn": this.paste_fn,
                                    "scope": this,
                                    "obj": context
                                }
                            }
                        ]
                    };

                    // flatten the paste options
                    paste = paste.submenu.itemdata;
                } else {
                    paste["onclick"] = {
                        "fn": this.paste_fn,
                        "scope": this,
                        "obj": context
                    };
                }

                var paste_allowed = this.paste_fn.test(context, clipboard[0], parent_info, paste);

                if (!$j.isArray(paste)) {
                    paste = [paste];
                }

                if (paste_allowed === true || paste_allowed === false) {
                    $j.each(paste, function(idx, item) {
                        item.disabled = paste_allowed === false;
                    });
                } else {
                    wait_list.push(paste_allowed);
                }

                menu_items.push(paste);
            }
        }

        if ("datasource" in cmdb_info && $j(context).hasClass("qlist_cmdb_object")) {
            var path = cmdb_info["datasource"];
            var mkey = cmdb_info["name"];
            var usage = {
                "text": $j.getInfo("usage"),
                "classname": "tool_sprite tool_view",
                "is_readonly": true,
                "disabled": mkey === "",
                "onclick": {
                    "fn": function() {
                        var url = "/objusagedlg?type=" + path + "&mkey=" + encodeURIComponent(mkey);
                        fweb.dialog(fweb.iframe(url, {resizeEvent: 'update.fweb'}));
                    }
                }
            };
            menu_items.push(usage);
        }

        if ("menu_fn" in this) {
            wait_list.push($j.when(this.menu_fn(menu, context, included)).done(function(menu_data) {
                if (menu_data === false) {
                    menu_items = [];
                } else if (menu_data.length && $j.isArray(menu_data)) {
                    menu_data.splice(menu_data.length, 0, menu_items);
                    menu_items = menu_data;
                } else {
                    menu_items = menu_data;
                }
            }));
        }

        $j.when.apply(this, wait_list).done(function() {
            ret.resolve(menu_items);
        });

        return ret;
    }

    function getFormatFunc(data, parent_data) {
        if ("process_fn" in this) {
            data = this.process_fn(data, parent_data);
        }

        if ("format_fn" in this) {
            return this.format_fn(data, parent_data);
        }

        var attr = [];
        var a_class = "qlist_cmdb_object";

        if (typeof data["name"] === "undefined") {
            return "";
        }

        if ("css-class" in data) {
            a_class += " " + data["css-class"];
        }

        attr.push("data-cmdb-info='" + JSON.stringify(data) + "'");

        return "<li><div class='qlist_cmdb_object_container'>"
            + "<a class=\"" + a_class + "\" " + attr.join(" ") + ">" + data["name"] + "</a>"
            + "</div></li>";
    }

    function getCmdbInfo(table, attribute) {
        var obj = cmdb_info,
            parts = [];

        if (table) {
            parts = table.split(".");
        }

        try {
            while (parts.length > 0) {
                obj = obj[parts.shift()];
            }

            if (typeof obj === "undefined") {
                obj = {};
            }

            if (typeof attribute !== "undefined" &&
                    "attributes" in obj) {
                obj = obj["attributes"][attribute] || {};
            }
        } catch (ex) {
            obj = {};
        }

        if (typeof obj === "object") {
            obj.getMenuItems = getMenuItems;
            obj.getFormatFunc = getFormatFunc;
        }

        if (obj.attributes) {
            $j.each(obj.attributes, function(name, attr) {
                if (typeof attr === "object") {
                    attr.getMenuItems = getMenuItems;
                    attr.getFormatFunc = getFormatFunc;
                }
            });
        }

        return obj;
    }

    function isNullObject(object) {
        return $j.isPlainObject(object) && object.name.toLowerCase() === cmdb_null_name;
    }

    function getNullObject(datasource, attribute, attr_formatter, row_data) {
        if ($j.isFunction(attr_formatter.show_none)) {
            return attr_formatter.show_none(attribute, row_data);
        }

        return {
            "name": cmdb_null_name,
            "datasource": datasource,
            "css-class": "icon_fw null"
        };
    }

    //unnecessarily complicated? should we just return cmdb_info for modification?
    function _putCmdbInfo(table, info) {

        var parts = table.split(".");
        var obj = cmdb_info;
        while (parts.length > 1) {
            if (!(parts[0] in obj)) {
                obj[parts[0]] = {};
            }
            obj = obj[parts.shift()];
        }
        obj[parts[0]] = info;
    }

    var cached_context = null;

    function update_cmdb_info(context, action, attribute, value, update_dom, format_attr, extra_values) {
        if (cached_context) {
            context = cached_context.find('ul')[0];
        }
        var row = $j(context).closest("tr.qlist_cmdb_object");
        var parent_info = $j(row).data("cmdbInfo");
        var col = $j(context).closest("ul.qlist_cmdb_attr");
        var attr_info = $j(col).data("cmdbInfo");
        var update_info = {};
        var updated = false;

        format_attr = format_attr || attribute;
        extra_values = extra_values || [];

        if (typeof update_dom === "undefined") {
            update_dom = true;
        }

        var actions = {};

        var regen_row = function() {
            var row = $j(context).closest("tr.qlist_cmdb_object");
            if (row != null) {
                var regen_row = row.data("regenerate");
                if ($j.isFunction(regen_row)) {
                    var row_collection = regen_row(row, parent_info, context);
                    var new_row = row_collection.row;
                    cached_context = row_collection.context;
                    new_row[0].className = row[0].className;
                }
                new_row.closest('.qlist-container').trigger('qlist.update');
            }
        };

        actions["append"] = function() {
            var formatter = getCmdbInfo(value["datasource"]);

            for (var i=0, l=parent_info[attribute].length; i < l; ++i) {
                if (parent_info[attribute][i]["name"] === value["name"]) {
                    return;
                }
            }

            parent_info[attribute].push(value);
            update_info[attribute] = parent_info[attribute];

            if (update_dom) {
                regen_row();
            }

            updated = true;
        };

        actions["replace"] = function() {
            var formatter;

            parent_info[attribute] = value;
            update_info[attribute] = parent_info[attribute];

            if (update_dom) {
                regen_row();
            }

            updated = true;
        };

        actions["remove"] = function() {
            var formatter = getCmdbInfo(value["datasource"]);
            var attributes = [ attribute ];
            var has_extra = ($j.isArray(extra_values) && extra_values.length > 0);
            var attr_prop, attr_formatter;

            if ("combine" in attr_info) {
                attributes = attr_info["combine"];
            }

            for (var ax=0; ax<attributes.length; ++ax) {
                if (!(attributes[ax] in parent_info)) {
                    continue;
                }

                attr_prop = parent_info[attributes[ax]];
                attr_formatter = getCmdbInfo(parent_info.datasource, attributes[ax]);

                if ($j.isArray(attr_prop)) {
                    for (var i=0; i < attr_prop.length; ++i) {
                        var attr_member = attr_prop[i];

                        if (attributes[ax] === attribute && attr_member["name"] === value["name"]) {
                            attr_prop.splice(i, 1);
                            i--;
                            updated = true;
                            continue;
                        }
                    }
                } else {
                    attr_prop = getNullObject(value.datasource, attributes[ax], attr_formatter, parent_info);
                    updated = true;
                }

                if (attr_formatter.allow_set_when_skipped) {
                    parent_info[attributes[ax]] = "";
                } else {
                    parent_info[attributes[ax]] = attr_prop;
                }
            }

            update_info[attribute] = parent_info[attribute];

            if (update_dom) {
                regen_row();
            }
        };

        if ("combine" in attr_info && typeof value === "object" && "attribute" in value) {
           attribute = value["attribute"];
        }

        if (action === "update") {
           if ($j.isArray(parent_info[attribute])) {
                action = "append";
            } else {
                action = "replace";
            }
        }

        actions[action]();
        if (updated) {
            if ("expansion" in parent_info && parent_info["expansion"] !== "parent") {
                var top_info = parent_info["expansion"];
                var table_update = {};
                table_update[parent_info["exp_attr"]] = [];

                $j.extend(parent_info, update_info);
                var child_objects = top_info[parent_info["exp_attr"]];

                // convert any grand child tables to list of keys so that
                // the CMDB API can handle them properly
                for (var i=0; i<child_objects.length; ++i) {
                    var child_info = child_objects[i];
                    var c_id = child_info["name"] || child_info["id"];
                    var t_id = parent_info["name"] || parent_info["id"];

                    if (c_id === t_id) {
                        top_info[parent_info["exp_attr"]][i] = parent_info;
                        child_info = child_objects[i];
                    }

                    table_update[parent_info["exp_attr"]].push(normalize_cmdb_object(child_info));
                }

                cmdbManager.update(top_info["mkey"], table_update);
            } else {
                var formatter = get_formatter();
                var none_value;
                if (action === "remove") {
                    none_value = "none";
                }
                if (none_value === "none" && formatter && $j.isFunction(formatter.get_none)) {
                    none_value = formatter.get_none();
                }
                if (formatter && $j.isFunction(formatter.prev_save_fn)) {
                    var cmdbManager_cpy = $j.extend({}, cmdbManager);
                    var save_settings = formatter.prev_save_fn(cached_context || context, update_info, cmdbManager_cpy);
                    save_settings["cmdb_manager"].update(
                        save_settings.mkey,
                        save_settings['update_info']
                    );
                } else {
                    cmdbManager.update(parent_info["mkey"], normalize_cmdb_object(update_info, none_value));
                }
            }
        }

        function get_formatter() {
            var parent_formatter = getCmdbInfo(parent_info["datasource"] || parent_info["expansion"]["datasource"]);
            var attr_formatter = parent_formatter["attributes"][format_attr];

            if (typeof value === "object" && "datasource" in value) {
                var obj_formatter = getCmdbInfo(value["datasource"]);

                return attr_formatter || obj_formatter;
            }

            return attr_formatter;
        }

        function skip_updating_cmdb_object(prop) {
            // the following specific attributes are skipped
            // because of the corresponding values type in cli
            // are not the same as the others.
            var skip_prop = ['groups', 'devices', 'users'];

            return (skip_prop.indexOf(prop) >= 0);
        }


        function normalize_cmdb_object(object, val) {
            var expansion = null;

            // we have to remove the expansion to avoid
            // infinite recursion when we do the deep copy
            if ("expansion" in object) {
                expansion = object["expansion"];
                delete object["expansion"];
            }

            var working = $j.extend(true, {}, object);

            for (var prop in working) {
                if ($j.isArray(working[prop])) {
                    working[prop] = $j.map(working[prop], function(x) {
                        var mkey_name = x.mkey_name || "name";
                        var obj = {"name": x[mkey_name]};

                        return obj;
                    });
                } else if (typeof working[prop] === "object") {
                    working[prop] = working[prop].name;
                }
            }

            if (expansion) {
                object["expansion"] = expansion;
            }

            if (typeof val !== "undefined") {
                if ($j.isArray(working[prop]) && !working[prop].length) {
                    if (!skip_updating_cmdb_object(prop)) {
                        working[prop].push({
                            "name": val
                        });
                    }
                } else if(typeof working[prop] === "string") {
                    working[prop] = val;
                }
            }

            return working;
        }
    }

    function clean_cmdb_config(object, child) {
        if (child && "name" in object) {
            return { "name": object["name"] };
        }

        var working = $j.extend(true, {}, object);

        for (var prop in working) {
            if ($j.isArray(working[prop])) {
                working[prop] = $j.map(working[prop], function(x) { return clean_cmdb_config(x, true); });
            } else if (typeof working[prop] === "object") {
                working[prop] = working[prop].name;
            }
        }

        return working;
    }

    function add_tip_support(datasource, format_fn) {
        extended_data_support(datasource, format_fn).add_tip_support();
    }
    /* the custom search parameter can be a function or an object
        when it is a function, it follows a similar specification to a
            standard search_fn -- the data that is passed is the datatype specified
            by the datasource (rather than a row or entry)
            - note that a defined search_fn may be called more than once per cell
        when it is an object, it follows the SearchObject format as specified
            in objectSearch/core.js
            the object will also have the following functions available:
            _get_mkey, _get_raw_data, _get_data
    example stubs:
    object_ = {
        search: function(data, query, i, selector) {
            console.log(data[this._get_mkey()], this); return [[-1, -1]];
        }
    }
    function_ = function(data, query, i, selector) {
        console.log(data); return [[-1, -1]];
    }
    */
    function add_tip_and_search_support(datasource, format_fn, custom_search) {
        extended_data_support(datasource, format_fn)
            .add_tip_support()
            .add_search_support(custom_search);
    }
    function extended_data_support(datasource, format_fn) {
        // set default format function
        if (format_fn == null) {
            format_fn = function(data) { return data[mkey]; };
        }
        var chain, _chain_func,
            custom_search_obj,
            custom_search_fn,
        // cmdb data
            cmdb_info = getCmdbInfo(datasource),
            parts = datasource.split("."),
            name = parts.pop(),
            path = parts.join("."),
            mkey,
        // caches and flags
            search_xhr,
            xhr_cache = {},
            data_cache = {},
            raw_data_cache = {},
            search_data_ready = {},
            search_function_ready = {};

        if (cmdb_info == null) {
            // nothing to do
            _chain_func = function() { return chain; };
            chain = {
                add_tip_support: _chain_func,
                add_search_support: _chain_func
            };
        }
        mkey = cmdb_info.mkey || "name";

        function add_tip(elem, content) {
            $j(elem).qtip({
                "show": {
                    "ready": true,
                    "solo": true
                },
                "hide": {
                    "when": "mouseout"
                },
                "content": content
            });
        }

        function tip_fn(evt, elem) {
            var obj_data = $j(elem).data("cmdbInfo"),
                params = {
                    "skip": true,
                    "key": mkey,
                    "pattern": obj_data[mkey]
                };

            // element already has a tooltip
            if ($j(elem).attr("aria-describedby")) {
                return true;
            }

            if (data_cache[obj_data[mkey]] != null) {
                add_tip(elem, data_cache[obj_data[mkey]]);
                return;
            }

            xhr_cache[obj_data[mkey]] = xhr_cache[obj_data[mkey]] || search_xhr ||
                CMDB.fetch(path, name, params);

            $j.when(xhr_cache[obj_data[mkey]]).done(function(response) {
                if (data_cache[obj_data[mkey]] != null) {
                    // data has already been fetched; just use the cache
                    add_tip(elem, data_cache[obj_data[mkey]]);
                    return;
                }
                var tip_obj = null;

                if (response["results"].length === 0) {
                    return false;
                } else {
                    for (var i = 0; i < response["results"].length; ++i) {
                        if (response["results"][i][mkey] === obj_data[mkey]) {
                            tip_obj = response["results"][i];
                            break;
                        }
                    }
                }

                if (tip_obj !== null) {
                    var fmt_value = format_fn($j.extend(obj_data, tip_obj));
                    $j.when(fmt_value).done(function(fmt_str){
                        data_cache[obj_data[mkey]] = fmt_str;
                        add_tip(elem, data_cache[obj_data[mkey]]);
                    });
                }
            });
        }

        function get_selector_from_el(el, columns) {
            var i, _len = columns.length, $td = el.closest('td');
            for (i = 0; i < _len; i++) {
                if ($td.hasClass(columns[i].selector)) {
                    return columns[i].selector;
                }
            }
        }
        function _setup_search_fn(selector, $container, qlist_config) {
            var column_obj = {};
            if ($j.isFunction(qlist_config.qsource.getColumnObject)) {
                column_obj = qlist_config.qsource.getColumnObject(selector);
            }
            // ensure that this function only runs once per selector
            if (search_function_ready[selector]) { return; }
            search_function_ready[selector] = true;

            var search_config, search_obj, customized_search_fn, column_custom_search_obj;
            search_config = qlist_config.search;
            if (search_config.search_obj[selector] == null) {
                search_config.search_obj[selector] = [];
            }

            // default search (basic text searching)
            search_obj = $j.qlist.ext.objectSearch.declare({
                preprocess_query: search_config.default_search_obj.preprocess_query,
                search: default_search_fn,
                search_value_type: 'row'
            });
            search_config.search_obj[selector].push(search_obj);

            function _each_obj_data(row_data, column_obj, callback) {
                if (row_data == null) { return; }
                // deal with combine columns
                var data = row_data[selector] || column_obj.combine != null &&
                    $j.map(column_obj.combine, function(combine_selector) {
                        return row_data[combine_selector];
                    });
                if (!data) { return; }
                if (!$j.isArray(data)) { data = [data]; }
                $j.each(data, function(i, obj_data) {
                    if (obj_data == null || obj_data.datasource !== datasource) { return; }
                    return callback(obj_data);
                });
            }

            function default_search_fn(row_data, query) {
                // skip special attributes
                if ($j.inArray(mkey, ['datasource', 'q_origin_key', 'css-class',
                        'attribute']) !== -1) {
                    return [];
                }
                var result = [];
                _each_obj_data(row_data, column_obj, function(obj_data) {
                    var val = data_cache[obj_data[mkey]],
                        search_result = qlist_config.search.default_search_obj.search(val, query);

                    $j.each(search_result, function(i, result) { result.source = obj_data; });
                    result = result.concat(search_result);
                });
                return result;
            }

            if (custom_search_fn != null) {
                if (!$j.isArray(search_config.search_row_fn[selector])) {
                    if (search_config.search_row_fn[selector] != null) {
                        search_config.search_row_fn[selector] = [];
                    } else {
                        search_config.search_row_fn[selector] = [search_config.search_row_fn[selector]];
                    }
                }

                customized_search_fn = function(row_data, query, i, selector) {
                    var result = [];
                    _each_obj_data(row_data, column_obj, function(obj_data) {
                        var val = raw_data_cache[obj_data[mkey]], search_result;
                        if (val == null) { return; /* continue $j.each */ }
                        search_result = custom_search_fn(val, query, i, selector);

                        $j.each(search_result, function(i, result) { result.source = obj_data; });
                        result = result.concat(search_result);
                    });
                    return result;
                };
                search_config.search_row_fn[selector].push(customized_search_fn);
            } else if (custom_search_obj != null) {
                column_custom_search_obj = $j.extend({
                    _get_mkey: function() { return mkey; },
                    _get_raw_data: function(mkey) { return raw_data_cache[mkey]; },
                    _get_data: function(mkey) { return data_cache[mkey]; }
                }, custom_search_obj);
                search_config.search_obj[selector].push(
                    $j.qlist.ext.objectSearch.declare(column_custom_search_obj));
            }

            // custom search object

        }
        function search_setup_fn(elem, $container) {
            var $el = $j(elem),
                obj_data = $el.data("cmdbInfo"),
                mkey_val = ('' + (obj_data != null ? obj_data[mkey] : '')),
                qlist_config = $container.qlist('config'),
                selector = get_selector_from_el($el, qlist_config.columns),
                params = {
                    "skip": true
                };

            // ensure that this function only executes once per element
            if (search_data_ready[selector] == null) { search_data_ready[selector] = {}; }
            else if (search_data_ready[selector][mkey_val]) { return; }
            search_data_ready[selector][mkey_val] = true;

            // this is a new mkey to retrieve, so retrieve the data
            if (search_xhr == null) {
                search_xhr = CMDB.fetch(path, name, params);
            }

            $j.when(search_xhr).done(function(response) {
                var entry_data;

                if (response["results"].length === 0) {
                    data_cache[mkey_val] = '';
                    return;
                }

                for (var i = 0; i < response["results"].length; ++i) {
                    entry_data = response["results"][i];
                    if (entry_data == null) { continue; }
                    // since the setup function is called once per individual
                    // item, we only set up one data cell per search_setup_fn call
                    if (('' + entry_data[mkey]) === mkey_val) {
                        $j.extend(obj_data, entry_data);
                        data_cache[mkey_val] = format_fn(obj_data);
                        if (custom_search_obj != null || custom_search_fn != null) {
                            obj_data.__formatted = data_cache[mkey_val];
                            raw_data_cache[mkey_val] = obj_data;
                        }
                        break;
                    }
                }

                _setup_search_fn(selector, $container, qlist_config);
            });
        }
        chain = {
            add_tip_support: function() {
                $j.extend(cmdb_info, { tip_fn: tip_fn }); return chain;
            },
            add_search_support: function(custom_search) {
                if ($j.isFunction(custom_search)) {
                    custom_search_fn = custom_search;
                } else {
                    custom_search_obj = custom_search;
                }

                $j.extend(cmdb_info, { search_setup_fn: search_setup_fn });
                return chain;
            }
        };
        return chain;
    }

    var clipboard = [];

    function add_copy_support(path, mkey) {
        var data = getCmdbInfo(path);
        var parts = path.split(".");
        var cmdb_name = parts.pop();
        var cmdb_path = parts.join(".");

        if (typeof mkey === "undefined") {
            mkey = "name";
        }

        if (data) {
            data.copy_fn = function(evt_type, evt_info, context) {
                var row_data = $j(context).data("cmdbInfo");
                var mkey_filter = {};
                var dfd = $j.Deferred();
                var params = {
                    "datasource": true,
                    "skip": true,
                    'key': mkey,
                    'pattern': row_data[mkey]
                };

                CMDB.fetch(cmdb_path, cmdb_name, params).done(function(response) {
                    if (response["results"].length !== 1) {
                        return false;
                    }
                    var copy_data = response["results"][0];
                    copy_data.datasource = path;
                    copy_data.mkey_name = mkey;
                    $j.extend(copy_data, row_data);
                    clipboard[0] = copy_data;

                    dfd.resolve(copy_data);
                });

                return dfd.promise();
            };
        }
    }

    function add_remove_support(path, mkey) {
        var data = getCmdbInfo(path);
        var parts = path.split(".");
        var cmdb_name = parts.pop();
        var cmdb_path = parts.join(".");

        if (typeof mkey === "undefined") {
            mkey = "name";
        }

        if (data) {
            data.remove_fn = function(evt_type, evt_info, context) {
                if ($j(context).is("a.qlist_cmdb_object")) {
                    var copy_data = $j(context).data("cmdbInfo");
                    var attr_info = $j(context).closest(".qlist_cmdb_attr").data("cmdbInfo");
                    var prop_name = attr_info["attribute"];

                    if ("attribute" in copy_data) {
                        prop_name = copy_data["attribute"];
                    }

                    update_cmdb_info(context, "remove", prop_name, copy_data);

                }
            };
        }
    }

    function add_cut_support(path, mkey) {
        var data = getCmdbInfo(path);
        var parts = path.split(".");
        var cmdb_name = parts.pop();
        var cmdb_path = parts.join(".");

        if (typeof mkey === "undefined") {
            mkey = "name";
        }

        if (data) {
            data.cut_fn = function(evt_type, evt_info, context) {
                var copy_data = $j(context).data("cmdbInfo");
                var dfd = $j.Deferred();

                copy_data.datasource = path;

                if ($j(context).is("a.qlist_cmdb_object")) {
                    var attr_info = $j(context).closest(".qlist_cmdb_attr").data("cmdbInfo");
                    var parent_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
                    var cmdb_info = getCmdbInfo(attr_info.datasource);
                    var prop_name = attr_info["attribute"];
                    var extra_info = [];

                    clipboard[0] = $j.extend({"mkey_name": mkey}, copy_data);

                    if ("attribute" in copy_data) {
                        prop_name = copy_data["attribute"];
                    }

                    if ($j.isArray(attr_info.combine)) {
                        $j.each(attr_info.combine, function(idx, item) {
                            if (item !== prop_name && $j.isArray(parent_info[item])) {
                                extra_info = extra_info.concat(parent_info[item]);
                            }
                        });
                    }

                    update_cmdb_info(context, "remove", prop_name, copy_data, true,
                                     attr_info.attribute, extra_info);
                    dfd.resolve(copy_data);
                } else if ($j(context).is("tr.qlist_cmdb_object")) {
                    var row_data = copy_data;
                    var mkey_filter = {};
                    var params = {
                        "datasource": true,
                        "skip": true,
                        'key': mkey,
                        'pattern': row_data[mkey]
                    };

                    CMDB.fetch(cmdb_path, cmdb_name, params).done(function(response) {
                        if (response["results"].length !== 1) {
                            return false;
                        }

                        copy_data = response["results"][0];
                        copy_data.datasource = path;
                        copy_data.mkey_name = mkey;
                        clipboard[0] = copy_data;

                        var ctx_mkey = row_data[mkey];
                        var container = $j(context).closest(".qlist-container");
                        var config = container.qlist("config");
                        var source = config.qsource;
                        var del_idx = -1;

                        for (var idx=0, len=source.raw_data.length; idx < len; ++idx) {
                            if (!(mkey in source.raw_data[idx])) {
                                continue;
                            }

                            if (source.raw_data[idx][mkey] === ctx_mkey) {
                                del_idx = idx;
                                break;
                            }
                        }

                        if (del_idx >= 0) {
                            source.raw_data.splice(del_idx, 1);
                            source.row_data = $j.Deferred();
                            source.handleExpansions();
                            container.qlist("reload");
                            cmdbManager["delete"](ctx_mkey);
                        }

                        dfd.resolve(copy_data);
                    });
                }

                return dfd.promise();
            };
        }
    }

    function add_paste_support(cmdb_data, attr, allowed_datasources, callback, extra_test) {
        var test_fn = function(context, info, parent_info, menu_item) {
            var ctx_info = $j(context).data("cmdbInfo");
            var row_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");

            if (typeof info === "undefined") {
                return false;
            }

            if (typeof info === "object" && "datasource" in info &&
                    $j.inArray(info.datasource, allowed_datasources) === -1) {
                return false;
            }

            if (attr !== false) {
                if (row_info[attr] === undefined && !cmdb_data.allow_set_when_skipped) {
                    return false;
                }
            }

            if ($j.isFunction(extra_test) &&
                    typeof parent_info !== "undefined" &&
                    typeof menu_item !== "undefined") {
                return extra_test(context, info, parent_info, menu_item);
            }

            return true;
        };

        cmdb_data.paste_fn = function(evt_type, evt_info, context, copy_data) {
            var before = this.before || false;
            copy_data = copy_data || clipboard[0];

            if (test_fn(context, copy_data)) {
                callback(context, copy_data, before);
            }
        };

        cmdb_data.paste_fn.test = test_fn;

        return true;
    }

    function add_paste_row_support(path, extra_test, mkey) {
        var data = getCmdbInfo(path);
        var callback = function(context, copy_data, before) {
            var ctx_data = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
            var ctx_mkey = ctx_data[mkey];
            var container = $j(context).closest(".qlist-container");
            var config = container.qlist("config");
            var source = config.qsource;
            var insert_idx = 0;
            var max_id = 0;

            copy_data = $j.extend({}, copy_data);

            for (var idx=0, len=source.raw_data.length; idx < len; ++idx) {
                if (!(mkey in source.raw_data[idx])) {
                    continue;
                }

                if (source.raw_data[idx][mkey] === ctx_mkey) {
                    insert_idx = idx + (before ? 0 : 1);
                }

                max_id = source.raw_data[idx][mkey] > max_id ? source.raw_data[idx][mkey] : max_id;
            }

            delete copy_data['expansion'];

            copy_data[mkey] = max_id + 1;
            copy_data.idx_pos = insert_idx;

            for(var i=0, len=config.sections.length; i < len; i++) {
                var section_property_name = config.sections[i];
                if (ctx_data.hasOwnProperty(section_property_name)) {
                    copy_data[section_property_name] = ctx_data[section_property_name];
                }
            }

            source.raw_data.splice(insert_idx, 0, copy_data);

            source.row_data = $j.Deferred();

            var before_mkey = null;

            for (idx=insert_idx + 1; idx < source.raw_data.length; ++idx) {
                var row = source.raw_data[idx];
                if (!before_mkey && mkey in row) {
                    before_mkey = row[mkey];
                }
                row.idx_pos++;
            }
            source.handleExpansions();

            cmdbManager.append(copy_data[mkey], clean_cmdb_config(copy_data), before_mkey);
            cmdbManager.dirty(false); // to avoid an ajax request, since we manually updated the source

            source.row_data.done(function() {
                container.qlist("reload");
            });
        };

        if (data) {
            return add_paste_support(getCmdbInfo(path), false, [ path ], callback, extra_test);
        }

        return false;
    }

    function add_paste_attr_support(path, attr, allowed_datasources, extra_test, process_data) {
        var data = getCmdbInfo(path);
        var callback = function(context, copy_data) {
            var extra = [];
            var info = {
                "action": "update",
                "data": copy_data
            };

            if ($j.isFunction(process_data)) {
                $j.extend(info, process_data(context, attr, copy_data, extra));
            }

            update_cmdb_info(context, info.action, info.attr || attr, info.data, true, attr, extra);
        };

        if (data && "attributes" in data && attr in data["attributes"]) {
            return add_paste_support(data["attributes"][attr], attr, allowed_datasources, callback, extra_test);
        }

        return false;
    }

    function find_combined_property_by_datasource(settings, datasource) {
        var properties = {
            "match": [],
            "combine": []
        };

        for (var prop in settings) {
            if (settings.hasOwnProperty(prop)) {
                if ($j.inArray(datasource, settings[prop].datasources) >= 0) {
                    properties.match.push(prop);

                    if ($j.isArray(settings[prop].combine)) {
                        properties.combine = properties.combine.concat(
                            settings[prop].combine
                        );
                    }
                }
            }
        }

        return properties;
    }

    function generate_combined_paste_fn(settings, attr) {
        return function(evt_type, evt_info, context) {
            var cmdb_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
            var copy_data = clipboard[0];
            var prop = find_combined_property_by_datasource(settings, copy_data.datasource);

            if (prop.match.length > 0) {
                var property = prop.match[0];
                var extra_values = [];
                var values = cmdb_info[property];
                var in_value_list = false;
                var mkey_name = copy_data.mkey_name;

                $j.each(values, function(idx, item) {
                    if (item[mkey_name] === copy_data[mkey_name]) {
                        in_value_list = true;
                        return false;
                    }
                });

                if (in_value_list === false) {
                    values = values.concat([copy_data]);
                }

                $j.each(prop.combine, function(idx, item) {
                    if (cmdb_info[item] != null) {
                        extra_values = extra_values.concat(cmdb_info[item]);
                    }
                });

                update_cmdb_info(context, "replace", property, values, true, attr, extra_values);
            }
        };
    }

    function generate_combined_test_fn(settings) {
        return function(context, info, parent_info, menu_item) {
            if (typeof info === "undefined") {
                return false;
            }

            var ctx_info = $j(context).data("cmdbInfo");
            var row_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
            var prop = find_combined_property_by_datasource(settings, info.datasource);

            if (prop.match.length && $j.isArray(parent_info[prop.match[0]])) {
                return true;
            }

            for (var idx=prop.combine.length; idx > 0; --idx) {
                if ($j.isArray(parent_info[prop.combine[idx - 1]])) {
                    return true;
                }
            }

            return false;
        };
    }

    function add_paste_attr_combined_support(path, attr, settings) {
        var data = getCmdbInfo(path);

        data.attributes[attr].paste_fn = generate_combined_paste_fn(settings, attr);
        data.attributes[attr].paste_fn.test = generate_combined_test_fn(settings);

        return false;
    }

    function gen_check_addr_interface(attr, ipv6) {
        return function (context, info, parent_info, menu_item) {
            var src_intf = member_name(parent_info["srcintf"] || parent_info["expansion"]["srcintf"]);
            var dst_intf = member_name(parent_info["dstintf"] || parent_info["expansion"]["dstintf"]);

            return get_interface_addresses(src_intf, dst_intf, null, ipv6).done(function(response) {
                var addresses = response.addresses;

                menu_item.disabled = true;

                for (var idx=0, len=addresses.length; idx < len; ++idx) {
                    var address = addresses[idx];

                    if (address["name"] === info["name"] && address["addr_type"] === attr) {
                        menu_item.disabled = false;
                        break;
                    }
                }
            });
        };
    }

    function val_in_attr(context, attr, data, values) {
        var parent_info = $j(context).closest("tr.qlist_cmdb_object").data("cmdbInfo");
        var attr_info = parent_info[attr];

        for (var i=attr_info.length-1; i>=0; --i) {
            if ($j.inArray(attr_info[i].name, values) >= 0) {
                return true;
            }
        }

        return false;
    }

    function gen_process_exclusive(values) {
        return function(context, attr, data) {
            var ret = {};

            if (typeof data === "object") {
                if ($j.inArray(data["name"], values) >= 0 ||
                        val_in_attr(context, attr, data, values)) {
                    ret["action"] = "replace";
                    ret["data"] = [data];
                }
            }

            return ret;
        };
    }

    function process_utm_profile(context, attr, data) {
        var parent_info = $j(context).closest('tr.qlist_cmdb_object').data('cmdbInfo');
        var protocol_options = parent_info['profile-protocol-options'] || {
            name: 'default',
            'css-class': 'icon_fw profile-protocol-options',
            datasource: 'firewall.profile-protocol-options'
        };

        update_cmdb_info(context, 'update', 'utm-status', 'enable', false, 'utm-status', null);

        if (!parent_info['ssl-ssh-profile']) {
            update_cmdb_info(context, 'update', 'ssl-ssh-profile', {
                name: DEFAULT_SSL_SSH_PROFILE,
                'css-class': 'icon_fw ssl-ssh-profile',
                datasource: 'firewall.ssl-ssh-profile'
            }, false, 'ssl-ssh-profile', null);
        }

        update_cmdb_info(context, 'update', 'profile-protocol-options', protocol_options, true,
                         'profile-protocol-options', null);
    }

    var process_all_addr = gen_process_exclusive(["all"]);
    var process_all_service = gen_process_exclusive(["ALL"]);

    function check_paste_firewall_policy(context, info, parent_info, menu_item) {
        var view_type = getCookie("view_type") || "";

        if (view_type !== "global") {
            var target_data = $j(context).data("cmdbInfo");
            var src_intf = member_name(target_data["srcintf"]);
            var dst_intf = member_name(target_data["dstintf"]);

            if (member_name(info["srcintf"]) !== src_intf || member_name(info["dstintf"]) !== dst_intf) {
                return false;
            }
        }

        return true;
    }

    function check_paste_firewall_explicit_proxy_policy(context, info, parent_info, menu_item) {
        var view_type = getCookie("view_type") || "";

        if (view_type !== "global") {
            var target_data = $j(context).data("cmdbInfo");
            var proxy = target_data["proxy"];
            if (info["proxy"] !== proxy) {
                return false;
            }
        }

        return true;
    }

    add_copy_support("firewall.policy", "policyid");
    add_cut_support("firewall.policy", "policyid");
    add_paste_row_support("firewall.policy", check_paste_firewall_policy, "policyid");

    add_copy_support("firewall.policy6", "policyid");
    add_cut_support("firewall.policy6", "policyid");
    add_paste_row_support("firewall.policy6", check_paste_firewall_policy, "policyid");

    add_copy_support("firewall.policy46", "policyid");
    add_cut_support("firewall.policy46", "policyid");
    add_paste_row_support("firewall.policy46", check_paste_firewall_policy, "policyid");

    add_copy_support("firewall.policy64", "policyid");
    add_cut_support("firewall.policy64", "policyid");
    add_paste_row_support("firewall.policy64", check_paste_firewall_policy, "policyid");

    add_copy_support("firewall.explicit-proxy-policy", "policyid");
    add_cut_support("firewall.explicit-proxy-policy", "policyid");
    add_paste_row_support("firewall.explicit-proxy-policy",
                          check_paste_firewall_explicit_proxy_policy, "policyid");

    add_copy_support("firewall.multicast-policy", "id");
    add_cut_support("firewall.multicast-policy", "id");
    add_paste_row_support("firewall.multicast-policy", function(context, info, parent_info, menu_item) {
        var target_data = $j(context).data("cmdbInfo");
        var src_intf = member_name(target_data["srcintf"]);
        var dst_intf = member_name(target_data["dstintf"]);

        if (member_name(info["srcintf"]) !== src_intf || member_name(info["dstintf"]) !== dst_intf) {
            return false;
        }

        return true;
    }, "id");

    function formatted_addr (data) {
        var dfd = $j.Deferred();
        var path = data.datasource.split('.')[1];
        fweb.util.address.format(path, data.name, function(details) {
            dfd.resolve(details);
        });
        return dfd.promise();
    };

    add_copy_support("firewall.address");
    add_cut_support("firewall.address");
    add_remove_support("firewall.address");
    add_tip_and_search_support("firewall.address", formatted_addr,
        function(data, query, i, selector) {
        // TODO: should 'any' match on IP's?
        return fweb.address_search.cmdb.firewall.address(data, query, i, selector);
    });

    add_copy_support("firewall.address6");
    add_cut_support("firewall.address6");
    add_remove_support("firewall.address6");
    add_tip_and_search_support("firewall.address6", formatted_addr,
        function(data, query, i, selector) {
        return fweb.address_search.ip6.search(data.ip6, query, i, selector);
    });

    add_copy_support("firewall.multicast-address");
    add_cut_support("firewall.multicast-address");
    add_remove_support("firewall.multicast-address");
    add_tip_and_search_support("firewall.multicast-address", formatted_addr,
        function(data, query, i, selector) {
            return fweb.address_search.ip4_basic_search(
                [fweb.address_search.ip4_range_calculate(data.__formatted)], query);
    });

    add_copy_support("firewall.addrgrp");
    add_cut_support("firewall.addrgrp");
    add_remove_support("firewall.addrgrp");
    add_tip_and_search_support("firewall.addrgrp", function(data) {
        return $j.getInfo("addresses") + ": " +
        $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    }/* TODO: address group ip searching (also needs to be done on address group list page)*/);

    add_copy_support("firewall.addrgrp6");
    add_cut_support("firewall.addrgrp6");
    add_remove_support("firewall.addrgrp6");
    add_tip_support("firewall.addrgrp6", function(data) {
        return $j.getInfo("addresses") + ": " +
        $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    });

    add_copy_support("firewall.vip");
    add_cut_support("firewall.vip");
    add_remove_support("firewall.vip");
    add_tip_and_search_support("firewall.vip", function(data) {
        if (data.type === "server-load-balance") {
            return $j.getInfo("server_load_balance") + ": " + data.extip;
        }
        return ($j.isArray(data.extip) ? data.extip[0]['range'] : data.extip) + " -> " +
                ($j.isArray(data.mappedip) ? data.mappedip[0]['range'] : data.mappedip);
    }/* TODO: are virtual ip's ranges or subnets? search for them if so */);

    add_copy_support("firewall.vip6");
    add_cut_support("firewall.vip6");
    add_remove_support("firewall.vip6");
    add_tip_support("firewall.vip6", function(data) {
        return data.extip + " -> " + data.mappedip;
    });

    add_copy_support("firewall.vip46");
    add_cut_support("firewall.vip46");
    add_remove_support("firewall.vip46");
    add_tip_support("firewall.vip46", function(data) {
        return data.extip + " -> " + data.mappedip;
    });

    add_copy_support("firewall.vip64");
    add_cut_support("firewall.vip64");
    add_remove_support("firewall.vip64");
    add_tip_support("firewall.vip64", function(data) {
        return data.extip + " -> " + data.mappedip;
    });

    add_copy_support("firewall.vipgrp");
    add_cut_support("firewall.vipgrp");
    add_remove_support("firewall.vipgrp");
    add_tip_and_search_support("firewall.vipgrp", function(data) {
        return $j.getInfo("addresses") + ": " + $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    });

    add_copy_support("firewall.vipgrp6");
    add_cut_support("firewall.vipgrp6");
    add_remove_support("firewall.vipgrp6");
    add_tip_support("firewall.vipgrp6", function(data) {
        return $j.getInfo("addresses") + ": " + $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    });

    add_copy_support("firewall.vipgrp46");
    add_cut_support("firewall.vipgrp46");
    add_remove_support("firewall.vipgrp46");
    add_tip_support("firewall.vipgrp46", function(data) {
        return $j.getInfo("addresses") + ": " + $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    });

    add_copy_support("firewall.vipgrp64");
    add_cut_support("firewall.vipgrp64");
    add_remove_support("firewall.vipgrp64");
    add_tip_support("firewall.vipgrp64", function(data) {
        return $j.getInfo("addresses") + ": " + $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    });

    add_copy_support("firewall.schedule.onetime");
    add_cut_support("firewall.schedule.onetime");
    add_remove_support("firewall.schedule.onetime");
    add_tip_and_search_support("firewall.schedule.onetime", function(data) {
        return data.start + " - " + data.end;
    });

    add_copy_support("firewall.schedule.recurring");
    add_cut_support("firewall.schedule.recurring");
    add_remove_support("firewall.schedule.recurring");
    add_copy_support("firewall.schedule.recurring");
    add_tip_and_search_support("firewall.schedule.recurring", function(data) {
        return data.start + " - " + data.end + " (" + data.day.split(" ").join(", ") + ")";
    });

    add_copy_support("firewall.schedule.group");
    add_cut_support("firewall.schedule.group");
    add_remove_support("firewall.schedule.group");
    add_copy_support("firewall.schedule.group");
    add_tip_and_search_support("firewall.schedule.group", function(data) {
        return $j.getInfo("schedules") + ": " + $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    });

    add_copy_support("firewall.service.custom");
    add_cut_support("firewall.service.custom");
    add_remove_support("firewall.service.custom");
    add_remove_support("firewall.service.custom");

    add_copy_support("firewall.service.group");
    add_cut_support("firewall.service.group");
    add_remove_support("firewall.service.group");
    add_tip_and_search_support("firewall.service.group", function(data) {
        return $j.getInfo("services") + ": " + $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    });
    /* TODO: ? search on service ports ? */

    add_cut_support("user.local");
    add_remove_support("user.local");
    add_copy_support("user.local");

    add_cut_support("user.group");
    add_remove_support("user.group");
    add_copy_support("user.group");
    add_tip_and_search_support("user.group", function(data) {
        var formatters = {
            "firewall": function(data) {
                return $j.getInfo("users") + ": " + $j.map(data.member, function(o) { return o["name"]; }).join(", ");
            },
            "guest": function(data) {
                return $j.getInfo("group_guest") + ": " + data.guest.length + " " + $j.getInfo("users");
            },
            "*": function(data) {
                return $j.getInfo("group_" + data['group-type']);
            }
        };

        var type = data['group-type'] || "*",
            fn = formatters[type] || formatters["*"];

        return fn(data);
    });

    add_tip_and_search_support("user.device", function(data) {
        return $j.getInfo("mac") + ": " + data.mac;
    });

    add_tip_and_search_support("user.device-group", function(data) {
        return $j.getInfo("devices") + ": " + $j.map(data.member, function(o) { return o["name"]; }).join(", ");
    });

    add_cut_support("user.device", "alias");
    add_remove_support("user.device", "alias");
    add_copy_support("user.device", "alias");

    add_cut_support("user.device-category");
    add_remove_support("user.device-category");
    add_copy_support("user.device-category");

    add_cut_support("user.device-group");
    add_remove_support("user.device-group");
    add_copy_support("user.device-group");

    $j.each([
        "antivirus.profile",
        "spamfilter.profile",
        "webfilter.profile",
        "application.list",
        "ips.sensor",
        "dlp.sensor",
        "voip.profile",
        "icap.profile",
        "firewall.ssl-ssh-profile"
    ], function(idx, datasource) {
        add_cut_support(datasource);
        add_remove_support(datasource);
        add_copy_support(datasource);
    });

    add_copy_support("firewall.profile-protocol-options");

    add_paste_attr_support("firewall.policy", "dstaddr", ["firewall.address", "firewall.addrgrp", "firewall.vip", "firewall.vipgrp"], gen_check_addr_interface("dst"), process_all_addr);
    add_paste_attr_support("firewall.policy", "srcaddr", ["firewall.address", "firewall.addrgrp", "firewall.vip", "firewall.vipgrp"], gen_check_addr_interface("src"), process_all_addr);
    add_paste_attr_support("firewall.policy", "schedule", ["firewall.schedule.recurring", "firewall.schedule.onetime", "firewall.schedule.group"]);
    add_paste_attr_support("firewall.policy", "service", ["firewall.service.custom", "firewall.service.group"], null, process_all_service);
    add_paste_attr_support("firewall.policy", "av-profile", ["antivirus.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "spamfilter-profile", ["spamfilter.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "webfilter-profile", ["webfilter.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "application-list", ["application.list"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "ips-sensor", ["ips.sensor"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "dlp-sensor", ["dlp.sensor"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "voip-profile", ["voip.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "icap-profile", ["icap.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "profile-protocol-options", ["firewall.profile-protocol-options"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy", "ssl-ssh-profile", ["firewall.ssl-ssh-profile"], null, process_utm_profile);

    add_paste_attr_support("firewall.policy6", "dstaddr", ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"], gen_check_addr_interface("dst"), process_all_addr);
    add_paste_attr_support("firewall.policy6", "srcaddr", ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"], gen_check_addr_interface("src"), process_all_addr);
    add_paste_attr_support("firewall.policy6", "schedule", ["firewall.schedule.recurring", "firewall.schedule.onetime", "firewall.schedule.group"]);
    add_paste_attr_support("firewall.policy6", "service", ["firewall.service.custom", "firewall.service.group"], null, process_all_service);
    add_paste_attr_support("firewall.policy6", "av-profile", ["antivirus.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "spamfilter-profile", ["spamfilter.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "webfilter-profile", ["webfilter.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "application-list", ["application.list"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "ips-sensor", ["ips.sensor"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "dlp-sensor", ["dlp.sensor"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "voip-profile", ["voip.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "icap-profile", ["icap.profile"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "profile-protocol-options", ["firewall.profile-protocol-options"], null, process_utm_profile);
    add_paste_attr_support("firewall.policy6", "ssl-ssh-profile", ["firewall.ssl-ssh-profile"], null, process_utm_profile);

    add_paste_attr_combined_support("firewall.policy", "source", {
        "srcaddr": {
            "datasources": ["firewall.address", "firewall.addrgrp", "firewall.vip", "firewall.vipgrp"],
            "combine": ["groups", "users", "devices"]
        },
        "users": {
            "datasources": ["user.local"],
            "combine": ["groups", "devices", "srcaddr"]
        },
        "groups": {
            "datasources": ["user.group"],
            "combine": ["users", "devices", "srcaddr"]
        },
        "devices": {
            "datasources": ["user.device", "user.device-category", "user.device-group"],
            "combine": ["users", "groups", "srcaddr"]
        }
    });

    add_paste_attr_combined_support("firewall.policy6", "source", {
        "srcaddr": {
            "datasources": ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"],
            "combine": ["groups", "users", "devices"]
        },
        "users": {
            "datasources": ["user.local"],
            "combine": ["groups", "devices", "srcaddr"]
        },
        "groups": {
            "datasources": ["user.group"],
            "combine": ["users", "devices", "srcaddr"]
        },
        "devices": {
            "datasources": ["user.device", "user.device-category", "user.device-group"],
            "combine": ["users", "groups", "srcaddr"]
        }
    });


    function gen_check_explicit_proxy_policy_service() {
        return function (context, info, parent_info, menu_item) {
            menu_item.disabled = !(!!parent_info && parent_info.proxy === 'web');
        };
    }

    function gen_check_explicit_proxy_policy_utm_profile() {
        return function (context, info, parent_info, menu_item) {
            var support = check_explicit_proxy_support_utm(
                parent_info, info.datasource);
            menu_item.disabled = !support;
        };
    }

    function gen_check_explicit_proxy_policy_addr_interface(attr, ipv6) {
        return function (context, info, parent_info, menu_item) {
            var proxy = '';
            if(parent_info.proxy) {
                proxy = parent_info.proxy;
            } else if (parent_info.expansion) {
                proxy = parent_info.expansion.proxy;
            }
            if (proxy === 'ftp' &&
                (info.datasource === 'dstaddr6' || info.datasource === 'srcaddr6')) {
                menu_item.disabled = true;
                return;
            }
            var src_intf = ''
            var dst_intf = member_name(parent_info["dstintf"] || parent_info["expansion"]["dstintf"]);
            // Import from function gen_check_addr_interface
            return get_interface_addresses(src_intf, dst_intf, null, ipv6).done(function(response) {
                var addresses = response.addresses;

                menu_item.disabled = true;

                for (var idx=0, len=addresses.length; idx < len; ++idx) {
                    var address = addresses[idx];

                    if (address["name"] == info["name"] && address["addr_type"] == attr) {
                        menu_item.disabled = false;
                        break;
                    }
                }
            });
        };
    }

    add_paste_attr_support("firewall.explicit-proxy-policy", "dstaddr", ["firewall.address", "firewall.addrgrp", "firewall.vip", "firewall.vipgrp"],
                           gen_check_explicit_proxy_policy_addr_interface("dst"), process_all_addr);
    add_paste_attr_support("firewall.explicit-proxy-policy", "srcaddr", ["firewall.address", "firewall.addrgrp", "firewall.vip", "firewall.vipgrp"],
                           gen_check_explicit_proxy_policy_addr_interface("src"), process_all_addr);
    add_paste_attr_support("firewall.explicit-proxy-policy", "dstaddr6", ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"],
                           gen_check_explicit_proxy_policy_addr_interface("dst", 66), process_all_addr);
    add_paste_attr_support("firewall.explicit-proxy-policy", "srcaddr6", ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"],
                           gen_check_explicit_proxy_policy_addr_interface("src", 66), process_all_addr);
    add_paste_attr_support("firewall.explicit-proxy-policy", "schedule", ["firewall.schedule.recurring", "firewall.schedule.onetime", "firewall.schedule.group"]);
    add_paste_attr_support("firewall.explicit-proxy-policy", "service", ["firewall.service.custom", "firewall.service.group"], gen_check_explicit_proxy_policy_service(), process_all_service);
    add_paste_attr_support("firewall.explicit-proxy-policy", "av-profile", ["antivirus.profile"],
                           gen_check_explicit_proxy_policy_utm_profile(), process_utm_profile);
    add_paste_attr_support("firewall.explicit-proxy-policy", "webfilter-profile", ["webfilter.profile"],
                           gen_check_explicit_proxy_policy_utm_profile(), process_utm_profile);
    add_paste_attr_support("firewall.explicit-proxy-policy", "application-list", ["application.list"],
                           gen_check_explicit_proxy_policy_utm_profile(), process_utm_profile);
    add_paste_attr_support("firewall.explicit-proxy-policy", "ips-sensor", ["ips.sensor"],
                           gen_check_explicit_proxy_policy_utm_profile(), process_utm_profile);
    add_paste_attr_support("firewall.explicit-proxy-policy", "dlp-sensor", ["dlp.sensor"],
                           gen_check_explicit_proxy_policy_utm_profile(), process_utm_profile);
    add_paste_attr_support("firewall.explicit-proxy-policy", "icap-profile", ["icap.profile"],
                           gen_check_explicit_proxy_policy_utm_profile(), process_utm_profile);
    add_paste_attr_support("firewall.explicit-proxy-policy", "profile-protocol-options", ["firewall.profile-protocol-options"],
                           gen_check_explicit_proxy_policy_utm_profile(), process_utm_profile);
    add_paste_attr_support("firewall.explicit-proxy-policy", "ssl-ssh-profile", ["firewall.ssl-ssh-profile"],
                           gen_check_explicit_proxy_policy_utm_profile(), process_utm_profile);

    add_paste_attr_combined_support("firewall.explicit-proxy-policy", "source", {
        "srcaddr": {
            "datasources": ["firewall.address", "firewall.addrgrp", "firewall.vip", "firewall.vipgrp"],
            "combine": ["srcaddr6"]
        },
        "srcaddr6": {
            "datasources": ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"],
            "combine": ["srcaddr"]
        },
    });

    add_paste_attr_combined_support("firewall.explicit-proxy-policy", "destination", {
        "dstaddr": {
            "datasources": ["firewall.address", "firewall.addrgrp", "firewall.vip", "firewall.vipgrp"],
            "combine": ["dstaddr6"]
        },
        "dstaddr6": {
            "datasources": ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"],
            "combine": ["dstaddr"]
        },
    });

    add_paste_attr_support("firewall.policy6", "dstaddr", ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"], gen_check_addr_interface("dst", 66), process_all_addr);
    add_paste_attr_support("firewall.policy6", "srcaddr", ["firewall.address6", "firewall.addrgrp6", "firewall.vip6", "firewall.vipgrp6"], gen_check_addr_interface("src", 66), process_all_addr);

    add_paste_attr_support("firewall.policy64", "dstaddr", ["firewall.address", "firewall.addrgrp", "firewall.vip64", "firewall.vipgrp64"], gen_check_addr_interface("dst", 64), process_all_addr);
    add_paste_attr_support("firewall.policy64", "srcaddr", ["firewall.address6", "firewall.addrgrp6", "firewall.vip64", "firewall.vipgrp64"], gen_check_addr_interface("src", 64), process_all_addr);
    add_paste_attr_support("firewall.policy64", "schedule", ["firewall.schedule.recurring", "firewall.schedule.onetime", "firewall.schedule.group"]);
    add_paste_attr_support("firewall.policy64", "service", ["firewall.service.custom", "firewall.service.group"], null, process_all_service);

    add_paste_attr_support("firewall.policy46", "dstaddr", ["firewall.vip46", "firewall.vipgrp46"], gen_check_addr_interface("dst", 46), process_all_addr);
    add_paste_attr_support("firewall.policy46", "srcaddr", ["firewall.address", "firewall.addrgrp", "firewall.vip46", "firewall.vipgrp46"], gen_check_addr_interface("src", 46), process_all_addr);
    add_paste_attr_support("firewall.policy46", "schedule", ["firewall.schedule.recurring", "firewall.schedule.onetime", "firewall.schedule.group"]);
    add_paste_attr_support("firewall.policy46", "service", ["firewall.service.custom", "firewall.service.group"], null, process_all_service);

    add_paste_attr_support("firewall.multicast-policy", "dstaddr", ["firewall.multicast-address"], gen_check_addr_interface("dst"), process_all_addr);
    add_paste_attr_support("firewall.multicast-policy", "srcaddr", ["firewall.address", "firewall.addrgrp"], gen_check_addr_interface("src"), process_all_addr);


    putCmdbInfo = _putCmdbInfo;

    function base_format_fn(data, label) {
        var attr = [];
        var a_class = "";

        if (typeof data === "object") {
            a_class = "qlist_cmdb_object";

            if ("css-class" in data) {
                a_class += " " + data["css-class"];
            }

            attr.push("data-cmdb-info='" + JSON.stringify(data) + "'");
        } else {
            a_class = "qlist_cmdb_value";
            label = data;
            data = {};
        }

        return "<li><div class='qlist_cmdb_object_container'>"
            + "<a class=\"" + a_class + "\" " + attr.join(" ") + ">" + label + "</a>"
            + "</div></li>";
    }

    function default_format_fn(data, mkey) {
        if (typeof mkey === 'undefined') {
            mkey = "name";
        }

        return cmdbFuncs.base_format_fn(data, data[mkey]);
    }

    //common functions used in external definitions of cmdb table configurations
    cmdbFuncs = {
        gen_qlist_menu_fn: gen_qlist_menu_fn,
        gen_toggle_menu: gen_toggle_menu,
        status_fmt_fn: status_fmt_fn,
        status_process_fn: status_process_fn,
        boolean_attribute_menu: boolean_attribute_menu,
        base_format_fn: base_format_fn,
        default_format_fn: default_format_fn,
        add_copy_support: add_copy_support,
        add_cut_support: add_cut_support,
        add_paste_row_support: add_paste_row_support,
        add_paste_attr_support: add_paste_attr_support,
        process_all_addr: process_all_addr,
        process_all_service: process_all_service,
        clear_cached_context_fn: clear_cached_context_fn
    };

    return getCmdbInfo;
})();

// For CMDB tables. Uses JSON API to cmdb.
var QListCmdbSource = (function($) {
    var config_defaults = { };

    var prototype = new QListSource();

    // hook into the extension system to decorate all of the format functions
    // for custom highlighting of search results
    $.qlist.ext.cmdbSourceSearchHelpers = {
        managed: true,
        config_path: 'cmdb_search_helpers',
        defaults: {
            enabled: false
        },
        depends: ['objectSearch'],
        get_formatted_cell: function(that, internal_core, get_column_value) {
            var current_search_results, highlighter;
            if (internal_core.state == null ||
                internal_core.state.search == null ||
                (current_search_results = internal_core.state.search.current_results) == null) {
                return get_column_value;
            }
            highlighter = $.qlist.ext.objectSearch.get_highlighter(that, internal_core, get_column_value);
            return function(td, selector, entry) {
                var source_index, $tr, search_result, col_search_result,
                    formatted_value, $formatted_value, highlight_occured = false;
                $tr = td.closest('tr');
                source_index = $tr.data('sourceIndex');
                search_result = current_search_results[source_index];
                if (search_result != null &&
                        (col_search_result = search_result[selector]) != null) {
                    formatted_value = get_column_value(td, selector, entry);

                    $formatted_value = $($.parseHTML(formatted_value));
                    $formatted_value.find('.qlist_cmdb_object').each(function(i, elem) {
                        var $elem = $(elem),
                            data = $elem.data("cmdbInfo"), cmdb_info, mkey,
                            j, _len;

                        // don't highlight if something is already highlighted
                        if ($elem.is('.' + internal_core.config.search.highlight_class) ||
                            $elem.has('.' + internal_core.config.search.highlight_class).length) {
                            return;
                        }

                        // check if a search matched, and highlight if so
                        if (data && "datasource" in data) {
                            cmdb_info = getCmdbInfo(data.datasource);
                            mkey = cmdb_info.mkey || "name";
                            _len = col_search_result.length;
                            for (j = 0; j < _len; j++) {
                                if (col_search_result[j].source != null &&
                                        data[mkey] === col_search_result[j].source[mkey]) {
                                    highlighter.highlight_jquery_el($elem);
                                    highlight_occured = true;
                                    return false;
                                }
                            }
                        }
                    });

                    if (highlight_occured) {
                        if (internal_core.config.options.atomic_render &&
                                $formatted_value.is('div.' + internal_core.config.search.highlight_class)) {
                            // assuming that a basic highlight div is the outer element
                            return $formatted_value.html();
                        }
                        $formatted_value
                            .find('div.' + internal_core.config.search.highlight_class)
                                .children().unwrap();
                        return internal_core.config.options.atomic_render ?
                            $('<div>').append($formatted_value).html() : $formatted_value;
                    }
                    return formatted_value;
                }
                return get_column_value(td, selector, entry);
            };
        }
    };

    $.extend(prototype, {
        "init": function() {
            this.raw_data = null;
            this.row_data = null;
            this.data = null;
            this.columns = null;
            this.filter = null;
            this.expansions = [];
            this.save_data = [];
            this.extra_data = [];
            this.type_formatter = getCmdbInfo(
                this.config.path + "." + this.config.name
            );

            cmdbManager.init(this.config.path, this.config.name, this.config.mkey);
        },
        "qlist_overrides": function(overrides) {
            $.extend(overrides, {
            });
        },
        "ready": function(list) {
            var $list = $(list), $container = $list.closest('.qlist-container');
            var ctrl = false;
            var drag_src = null;

            $(window).off('keydown.qlist-dragdrop, keyup.qlist-dragdrop');
            $(window).on('keydown.qlist-dragdrop, keyup.qlist-dragdrop', function(evt) {
                ctrl = evt.ctrlKey;
                update_cursor();
            });

            $list.off("mouseover.qlist-drag");
            $list.on("mouseover.qlist-drag", "a.qlist_cmdb_object", function(evt) {
                var elem = this,
                    data = $(this).data("cmdbInfo");

                // prevent dragging placeholder objects
                if (data !== undefined && data.placeholder === true) {
                    return;
                }

                if (data && "datasource" in data) {
                    var parts = data.datasource.split(".");
                    var cmdb_info = getCmdbInfo(data.datasource);

                    if ($.isFunction(cmdb_info.tip_fn)) {
                        cmdb_info.tip_fn(evt, elem);
                    }

                    $(elem).draggable({
                        "revert": true,
                        "helper": "clone",
                        "cursorAt": { top: -2, left: -2 },
                        "refreshPositions": true,
                        "start": function(drag_event, ui) {
                            var elem = drag_event.currentTarget;
                            var info = $(elem).data("cmdbInfo");
                            var formatter = getCmdbInfo(info.datasource);

                            drag_src = $(elem).closest(".qlist_cmdb_attr");
                            $helper = $(ui.helper);
                            $helper.append("<div class='qlist-drag-bug'></div>")
                                   .css("overflow", "visible");

                            $bug = $helper.find('.qlist-drag-bug');

                            if (!$.isFunction(formatter.copy_fn)) {
                                return false;
                            }
                        }
                    });
                }
            });

            $list.off("mouseover.qlist-drop-category");
            $list.on("mouseover.qlist-drop-category", "tr.qlist_category, tr.qlist_section", function(evt) {
                var timeout = null;
                var delay = 500;

                $(this).droppable({
                    "over": function(event, ui) {
                        var that = this;
                        if (timeout === null) {
                            timeout = setTimeout(function() {
                                var input = $(that).find("input")[0];

                                // pre-flip the icon, so that the conditional
                                // will resolve correctly.
                                change_icon(input);

                                if (change_icon(input) === false) {
                                    $(input).trigger("click");
                                }
                            }, delay);
                        }
                    },
                    "out": function(event, ui) {
                        clearTimeout(timeout);
                        timeout = null;
                    }
                });
            });

            var $helper, $bug, deny;
            var update_cursor = function() {
                if ($bug !== undefined) {
                    $bug.toggleClass("drag-deny", deny);
                    $bug.toggleClass("drag-copy", !deny && !ctrl);
                    $bug.toggleClass("drag-move", !deny && ctrl);
                }
            };

            $list.off("mouseover.qlist-drop-attr");
            $list.on("mouseover.qlist-drop-attr", "ul.qlist_obj_list", function(evt) {
                if ($(this).hasClass("ui-droppable")) {
                    return;
                }

                $(this).droppable({
                    "hoverClass": "qlist_cmdb_attr_accept",
                    "over": function(mouse_event, ui) {
                        var context = this;
                        var attr_info = $(this).data("cmdbInfo");
                        var parent_info = $(this).closest("tr.qlist_cmdb_object").data("cmdbInfo");
                        var row_formatter = getCmdbInfo(parent_info.datasource);
                        var attr_formatter = row_formatter.attributes[attr_info.attribute];
                        var drop_object = $(ui.draggable[0]).data("cmdbInfo");

                        deny = !(
                            attr_formatter &&
                            $.isFunction(attr_formatter.paste_fn) &&
                            attr_formatter.paste_fn.test(context, drop_object, parent_info)
                        );

                        update_cursor();
                    },
                    "out": function(mouse_event, ui) {
                        deny = true;
                        update_cursor();
                    },
                    "drop": function(drop_event, ui) {
                        var context = this;
                        var attr_info = $(this).data("cmdbInfo");
                        var parent_info = $(this).closest("tr.qlist_cmdb_object").data("cmdbInfo");
                        var row_formatter = getCmdbInfo(parent_info.datasource);
                        var attr_formatter = row_formatter.attributes[attr_info.attribute];
                        var drop_object = $(ui.draggable[0]).data("cmdbInfo");
                        var obj_formatter = getCmdbInfo(drop_object.datasource);
                        var dfd;

                        if (parent_info.implicit) {
                            return false;
                        }

                        if (drag_src[0] === context) {
                            return false;
                        }

                        if (!(attr_formatter && $.isFunction(attr_formatter.paste_fn) &&
                              attr_formatter.paste_fn.test(context, drop_object, parent_info))) {
                            return false;
                        }

                        if (!ctrl || !obj_formatter.cut_fn) {
                            dfd = obj_formatter.copy_fn(null, null, ui.draggable[0]);
                        } else {
                            dfd = obj_formatter.cut_fn(null, null, ui.draggable[0]);
                        }

                        dfd.done(function(copy_data) {
                            attr_formatter.paste_fn(null, null, context, copy_data);
                            $(ui.helper).remove();
                            cmdbFuncs.clear_cached_context_fn();
                        });

                        return true;
                    }
                });
            });

            // enable the search highlighting hook
            $container.qlist('config', { cmdb_search_helpers: { enabled: true }});
            $container.off('search.activated.qlist_cmdb')
            .one('search.activated.qlist_cmdb', function() {
                // Iterate over all elements that represent some bit of data
                // note that the search setup function could be changed to not
                // touch the DOM at all, but this is the simplest way to determine
                // what datasources actually need to be loaded
                $container.find('table .qlist_cmdb_object').each(function(i, elem) {
                    var data = $(elem).data("cmdbInfo");

                    if (data && "datasource" in data) {
                        var cmdb_info = getCmdbInfo(data.datasource);

                        if ($.isFunction(cmdb_info.search_setup_fn)) {
                            cmdb_info.search_setup_fn(elem, $container);
                        }
                    }
                });
            });

            $container.off('search_complete.qlist_cmdb')
            .on('search_complete.qlist_cmdb', function(event, search_results) {
                // modify the search results so that expansion parents are included
                var config = $container.qlist('config'), _len = config.source.length;
                if (config == null) { return; }
                $.each(config.source, function(i, entry) {
                    if (entry.expansion === 'parent') {
                        for (var j = i + 1; j < _len &&
                                config.source[j].expansion != null &&
                                +config.source[j].expansion.mkey === +entry.mkey; j++) {
                            if (j in search_results) {
                                if (search_results[i] == null) { search_results[i] = {}; }
                                search_results[i]['#'] = [0, null];
                                break;
                            }
                        }
                    }
                });
            });
        },
        "getData": function() {
            var that = this;
            this.row_data = $.Deferred();

            var format = {};

            $.each(this.columns, function(i, col) {
                format[col.selector] = "%" + col.selector;
                if ("combine" in col) {
                    $.each(col.combine, function(i, sel) {
                        format[sel] = "%" + sel;
                    });
                }
            });

            $.each(this.expansions, function(i, col) {
                format[col.selector] = "%" + col.selector;
            });

            format.uuid = "%uuid";

            var row_fetch = CMDB.fetch(this.config.path, this.config.name, {
                                "datasource": true,
                                "skip": true,
                                "with_meta": true,
                                "format": format
                            });
            var devices_fetch = CMDB.fetch('user', 'device-category');

            $.when(row_fetch, devices_fetch).done(function(response, all_devices) {
                var row_data = response[0].results;
                var devices_mapping = {};
                var i, idx = 0;
                // TODO: the following code that handles device
                // categories should be removed once promise is supported
                // in format function
                if ($.isArray(all_devices) && all_devices.length) {
                    var devices = all_devices[0];
                    if ($.isPlainObject(devices) && devices.hasOwnProperty('results')) {
                        var devices_results = devices.results;
                        for (i = 0; i < devices_results.length; i++) {
                            var d = devices_results[i];
                            devices_mapping[d.name] = d.desc;
                        }
                    }
                }

                if (response[0]["status"] === "success") {
                    for(i = 0; i < row_data.length; i++, idx++)
                    {
                        row_data[i]['idx_pos'] = idx;
                        row_data[i]['all_devices'] = devices_mapping;
                    }
                    for(i = 0; i < that.extra_data.length; i++, idx++)
                    {
                        that.extra_data[i]['idx_pos'] = idx;
                    }
                    that.raw_data = row_data.concat(that.extra_data);
                    cmdbManager.dirty(false);
                    that.handleExpansions();
                }
            });
        },
        "extendAttributes": function(config) {
            $.extend(true, this.type_formatter.attributes, config);
        },
        "extendMenu": function(callback) {
            var that = this;

            this.beforeMenuShow = function(menu, elems, curelem) {
                if (menu.menuAppended !== true) {
                    callback.call(that, menu, elems, curelem);
                    menu.menuAppended = true;
                }
            };
        },
        "extendObjMenu": function(callback) {
            var that = this;

            this.beforeObjMenuShow = function(menu, elems) {
                if (menu.menuAppended !== true) {
                    callback.call(that, menu, elems);
                    menu.menuAppended = true;
                }
            };
        },
        "handleExpansions": function() {
            var that = this;
            var source = null;

            if ($.isArray(this.expansions) && this.expansions.length) {
                source = [];

                $(this.raw_data).each(function(i, raw) {
                    var row_data = $.extend({}, raw);
                    source.push(row_data);
                    $(that.expansions).each(function(idx, expansion) {
                        var exp_selector = expansion["selector"];
                        if (exp_selector in row_data && $.isArray(row_data[exp_selector]) &&
                            row_data[exp_selector].length) {
                            if (row_data['expansion'] === 'parent') {
                                return true;
                            }

                            row_data['expansion'] = 'parent';
                            row_data['mkey'] = row_data["name"] || row_data["policyid"];

                            for (var exp_data, r=0; (exp_data = row_data[exp_selector][r]); ++r) {
                                source.push($.extend({
                                    expansion: row_data,
                                    exp_attr: exp_selector,
                                    sub_idx_pos: r + 1
                                }, exp_data));
                            }
                        }
                    });
                });
            } else {
                source = $.extend([], this.raw_data);
            }

            this.data = source;
            this.row_data.resolve(source);
        },
        "setColumns": function(columns) {
            if (typeof columns !== "undefined" && columns.length) {
                this.columns = [];

                for (var i = 0; i < columns.length; ++i) {
                    if ("selector" in columns[i]) {
                        if (!("lang_key" in columns[i])) {
                            columns[i].lang_key = "field_" + columns[i].selector;
                        }
                        this.columns.push($.extend({}, columns[i]));
                    }
                }
            }
        },
        "getColumns": function() {
            return this.columns;
        },
        "addExpansion": function(expansion) {
            this.expansions.push(expansion);
        },
        "appendData": function(data) {
            if (!($.isArray(data))) {
                data = [ data ];
            }

            $.extend(this.extra_data, data);
        },
        "getRows": function() {
            if (!this.row_data || cmdbManager.dirty()) {
                this.getData();
            }

            return this.row_data.promise();
        },
        "buildRow": function(row, row_idx, row_data) {
            var cmdb_data = $j.extend({}, row_data, {
                "datasource": this.config.path + "." + this.config.name,
                "mkey": row_data[this.config.mkey]
            });

            row.addClass("qlist_cmdb_object");
            row.data("cmdb-info", cmdb_data);

            // handle expansions
            if (row_data['expansion'] === 'parent') {
                row_data['#'] = row_idx + 1;
                $(row).delegate("a.ui-icon", "click", function() {
                    $("a.ui-icon", row).toggleClass("ui-icon-carat-1-se");
                    $(row).nextUntil(":not(.qlist_expansion_child)").toggle();
                    $(row).closest(".qlist-container").qlist("refresh");
                });
            } else if (row_data['expansion']) {
                // child row seq # should same as parent's
                row_data['#'] = row_idx;
                row.attr("mkey", row_data['expansion']["policyid"]);
                row.attr("ckey", row_data["id"]);
                // Don't hide when update cell context
                row.addClass("qlist_expansion_child");
                // TODO: don't hide if a search result is being displayed
            } else {
                row_data['#'] = row_idx + 1;
            }

            if ("add_class" in row_data) {
               row.addClass(row_data["add_class"]);
            }

            row.toggleClass("disabled", row_attr(row_data, "status", "enable") === "disable");

            if (row_data["implicit"]) {
                row.attr("can_delete", !row_data.implicit);
            }
            function row_attr(row_data, attr, default_value) {
                var old_row = null;

                while ($.isPlainObject(row_data) && row_data !== old_row) {
                    if (attr in row_data) {
                        return row_data[attr];
                    }

                    old_row = row_data;
                    row_data = row_data.expansion || null;
                }

                return default_value;
            }
        },
        "getColumnObject": function(selector) {
            var i, col;
            for (i = 0; (col = this.columns[i]); i++) {
                if (col.selector === selector) {
                    return col;
                }
            }
        },
        "buildCell": function(td, column, row_data) {
            var selectors = [];
            var list_objs = [];
            var base_format_fn = this.defaultFormat;
            var extra_class = "";
            var i, len, len1, s_idx = 0;
            var attr_formatter = null;
            var data;
            var row_expansion = row_data.expansion;
            var has_combined_formatter = false;

            if (typeof(column) === "string") {
                column = this.getColumnObject(column);
            }

            if ("combine" in column) {
                selectors = column.combine;

                if (column.selector in this.type_formatter.attributes) {
                    attr_formatter = this.type_formatter.attributes[column.selector];

                    if ("format_fn" in attr_formatter) {
                        base_format_fn = attr_formatter["format_fn"];
                        has_combined_formatter = true;
                    }

                    if ("list_class" in attr_formatter) {
                        extra_class = attr_formatter["list_class"];
                    }
                }
            } else {
                selectors.push(column.selector);
            }

            // Just return text if the td is falsey (non-html render).
            // For multiple values, return a comma separated list.
            if (!td) {

                data = [];

                if (column.selector === '#') {
                    return row_data['#'];
                }

                for (s_idx = 0, len = selectors.length; s_idx < len; ++s_idx) {
                    var s_data = row_data[selectors[s_idx]] || row_expansion && row_expansion[selectors[s_idx]];

                    if (!$.isArray(s_data)) {
                        s_data = [s_data];
                    }

                    for (i = 0, len1 = s_data.length; i < len1; ++i) {
                        var obj = s_data[i];
                        data.push(typeof obj === 'object' ? obj.name : obj);
                    }
                }

                return data.length > 1 ? data : data[0];
            }

            if (column.is_mkey === true || this.type_formatter.mkey && column.selector === this.type_formatter.mkey) {
                td.addClass("qlist-cmdb-mkey");
            }

            if (column.selector === '#') {
                var seq_no = '<span class="seq_no">' + (row_expansion && row_expansion !== 'parent' ?
                    row_data['#'] + "." + row_data.sub_idx_pos : row_data['#']) + '</span>';
                if (!row_expansion) {
                    td.addClass("seq");
                    return seq_no;
                }
                if (row_expansion === 'parent') {
                    td.addClass("exp_seq");
                    return '<a class="qlist_exp_toggle ui-icon ui-icon-carat-1-e ui-icon-circlesmall-plus"></a>' + seq_no;
                }
                td.addClass("sub_seq");
                return '<span class="ui-icon ui-icon-carat-1-se"></span>' + seq_no;
            }

            var show_none = false;
            if ($.isFunction(column.show_none)) {
                show_none = column.show_none;
            }

            var datasource = this.config.path + '.' + this.config.name;
            if (this.config.child) {
                datasource += '.' + this.config.child;
            }
            // for combined column/cell, as long as one of selector data is not empty
            // cell should not return "<a class='ui-icon ui-icon-carat-1-e'></a>"
            var all_data_empty = true;
            for (s_idx=0, len = selectors.length; s_idx < len; ++s_idx) {
                var selector = selectors[s_idx];
                var default_format_fn = base_format_fn;
                var process_fn = false;
                var pre_process_fn = false;

                attr_formatter = getCmdbInfo(datasource, selector);

                if (selector in this.type_formatter.attributes) {
                    if ($.isFunction(attr_formatter.process_fn)) {
                        process_fn = attr_formatter.process_fn;
                    }

                    if (!has_combined_formatter && $.isFunction(attr_formatter.format_fn)) {
                        default_format_fn = attr_formatter.format_fn;
                    }

                    if ($.isFunction(attr_formatter.pre_process_fn)) {
                        pre_process_fn = attr_formatter.pre_process_fn;
                    }
                }

                data = row_data[selector];

                if (show_none !== false) {
                    // copy the show none into the attr formatter, since
                    // we won't have access to the column config from the
                    // cmdb functions
                    attr_formatter.show_none = column.show_none;

                    if (!data) {
                        data = column.show_none(selector, row_data);
                    }
                }

                for (i = this.expansions.length; i > 0; --i) {
                    var expansion = this.expansions[i - 1];
                    var children = row_data[expansion.selector];

                    if ($.isArray(children) && children.length > 0) {
                        var child = children[0];
                        if (child.hasOwnProperty(selector) && (child[selector] === row_data[selector])) {
                            data = "";
                        }
                    }

                    if (selector === expansion.selector) {
                        break;
                    }
                }

                if (data) {
                    all_data_empty = false;

                    if (pre_process_fn !== false) {
                        data = pre_process_fn(data, row_data, selector);
                    }

                    if (!$.isArray(data)) {
                        data = [ data ];
                    }

                    for (i = 0, len1 = data.length; i < len1; ++i) {
                        var value = data[i];

                        if (typeof value === "undefined") {
                            continue;
                        }

                        if (process_fn !== false) {
                            value = process_fn(value, row_data);
                        }

                        var format_fn = default_format_fn;
                        if (typeof value === "object") {
                            value["attribute"] = selector;

                            if ("datasource" in value) {
                                var type_formatter = getCmdbInfo(data[i]["datasource"]);

                                if (!attr_formatter || !attr_formatter.hasOwnProperty("format_fn")) {
                                    format_fn = (function(type_formatter) {
                                        return function(data, parent_data) {
                                            return type_formatter.getFormatFunc(data, parent_data);
                                        };
                                    })(type_formatter);
                                }
                            }
                        }

                        if (format_fn !== false) {
                            list_objs.push(format_fn(value, row_data, selector));
                        }
                    }
                }
            }
            if (all_data_empty) {
                // handle expansions
                if (row_expansion === 'parent') {
                    return "<a class='ui-icon ui-icon-carat-1-e'></a>";
                }
            }

            if (!("datasource" in column)) {
                column["datasource"] = datasource;
                column["attribute"] = column.selector;
            }

            return "<ul class='qlist_obj_list qlist_cmdb_attr " + extra_class + "' data-cmdb-info='" +
                JSON.stringify(column) + "'>" + list_objs.join("") + "</ul>";
        },
        "aggregate_context_menu": true,
        "cache_context_menu": true,
        "buildMenu": function(elem, menu, defaults) {
            var data = [];
            var source_results = [];
            var skip_defaults = false;
            var cell = $(elem).closest("td");
            var cell_data = cell.data("cmdb-info");
            var row = $j(elem).closest("tr.qlist_cmdb_object")[0];
            var attr = $j(elem).closest("ul.qlist_cmdb_attr")[0] || $("ul.qlist_cmdb_attr", elem)[0];
            var extend_menu = null;
            var context_menu = $j.Deferred();
            var curelem = elem;

            objectSelector.setSelectionTarget($j(elem).closest("td"));

            if (cell_data && cell_data.hasOwnProperty("attribute")) {
                attr = cell;
            }

            // #224988 introduces the cached_context,
            // Fix issue that uncleared cached_context
            // causes that cmdb updates a wrong object.
            cmdbFuncs.clear_cached_context_fn();

            var obj = $j(elem).closest("a.qlist_cmdb_object")[0] || attr || row;

            /* skip context menu if same target has 2 benefits:
               1. all previous post update (handle_selection_change) on context menu will be keep,
                  if we regenerate, they'll lost.
               2. save time */
            if (this.cache_context_menu) {
                if (obj === this.contextObject) {
                    context_menu.resolve(menu);
                    return context_menu.promise();
                }
                this.contextObject = obj;
            }

            menu.clearContent();
            menu.addItems([
                {
                    "text": $j.getInfo("loading")
                }
            ]);
            menu.render();

            if (this.aggregate_context_menu === false) {
                skip_defaults = true;
            }

            if (obj != attr && obj != row) {
                push_menu(obj);
            }

            if (attr && (source_results.length < 1 || this.aggregate_context_menu)) {
                push_menu(attr);
            }

            if (row && (is_mkey_column(elem) && source_results.length < 1 || this.aggregate_context_menu)) {
                var row_data = $(row).data("cmdbInfo");

                if ("menu_fn" in row_data) {
                    source_results = [
                        $.when(row_data.menu_fn.apply(null, [menu, row])).done(function(items) {
                            data = items;
                        })
                    ];
                    skip_defaults = true;
                } else {
                    push_menu(row);
                }

                extend_menu = this.beforeMenuShow;
            } else {
                extend_menu = this.beforeObjMenuShow;
            }

            elem = obj;

            $.when.apply(this, source_results).done(function() {
                if (skip_defaults === false) {
                    $.merge(data, defaults);
                }

                menu.clearContent();
                menu.addItems(filter_readonly(data, is_rw_admin));
                menu.render();

                // deactivate the normal context menu enable/disable event
                // and setup hook for post selection event handling
                menu.preventContextDefault = true;
                menu.menuAppended = false;

                if ($j.isFunction(extend_menu)) {
                    menu.afterBeforeShow = (function(extend_menu, curelem) {
                        return function(menu, elems) {
                            extend_menu(menu, elems, curelem);
                            menu.render();
                        };
                    })(extend_menu, curelem);
                } else {
                    menu.afterBeforeShow = $.noop;
                }

                // fix to allow items with submenus to have icons
                $j.each(menu.getItems(), function() {
                    if (this.cfg && this.cfg.getProperty("submenu")) {
                        $j("a.yuimenuitemlabel", this.element).addClass(
                            this.cfg.getProperty("classname")
                        );
                    }
                });

                context_menu.resolve(menu);
            });

            function is_readonly_operation(data) {
                return (data.is_readonly || false);
            }

            function filter_readonly(data, is_rw_admin) {
                var filtered_items = [];
                var item, idx;

                if (typeof data === 'undefined') {
                    return false;
                }

                if ($j.isPlainObject(data)) {
                    if (is_readonly_operation(data) || is_rw_admin) {
                        return data;
                    }

                    return false;
                }

                for (idx = 0; idx < data.length; ++idx) {
                    item = filter_readonly(data[idx], is_rw_admin);

                    if (item !== false) {
                        filtered_items.push(item);
                    }
                }

                return filtered_items;
            }

            function is_mkey_column(elem) {
                return $(elem).closest("td").hasClass("qlist-cmdb-mkey");
            }

            function push_menu(obj) {
                if (!obj) return;

                var ctx_info = $(obj).data("cmdbInfo");
                if (!ctx_info) return;

                var type = ctx_info["datasource"];
                var cmdb_info = getCmdbInfo(type);

                var menu_fn;
                var menu_ctx = cmdb_info;

                if ($(obj).is(".qlist_cmdb_attr") && "attribute" in ctx_info) {
                    var selector = ctx_info["attribute"];
                    var attr_info = getCmdbInfo(type, selector);

                    if (attr_info && "getMenuItems" in attr_info) {
                        menu_fn = attr_info.getMenuItems;
                        menu_ctx = attr_info;
                    }
                } else if (cmdb_info && "getMenuItems" in cmdb_info) {
                    menu_fn = cmdb_info.getMenuItems;
                }

                if ($j.isFunction(menu_fn)) {
                    var that = [];
                    data.push(that);

                    var menu_items = menu_fn.apply(menu_ctx, [menu, obj]);

                    // when the menu item data is available, append it to the
                    // context menu
                    var menu_item_wait = $.when(menu_items).then(function(items) {
                            that.splice(that.length - 1, 0, items);
                        });

                    // cache the deferred so we can show the menu once all the menu
                    // callbacks are resolved.
                    source_results.push(menu_item_wait);
                }
            }

            return context_menu.promise();
        },
        "defaultFormat": function(data, label) {
            // support for cases where this is called like a normal qlist format_fn
            if (arguments.length > 2) {
                return cmdbFuncs.default_format_fn(data, data.mkey_name);
            }

            if (typeof label !== 'undefined') {
                return cmdbFuncs.base_format_fn(data, label);
            }

            return cmdbFuncs.default_format_fn(data, data.mkey_name);
        },
        "generateExpansionCallback": function(exp_class, collapse, twisties) {
            var show = false;
            var rows = $("tr." + exp_class);

            return function(show_or_hide) {
                if (show_or_hide === true || show_or_hide === false) {
                    show = show_or_hide;
                } else {
                    show = !show;
                }

                $(collapse)
                    .toggleClass("ui-icon-circlesmall-plus", !show)
                    .toggleClass("ui-icon-circlesmall-minus", show);

                $(twisties)
                    .toggleClass("ui-icon-carat-1-e", !show)
                    .toggleClass("ui-icon-carat-1-se", show);

                $(rows).toggle(show);
            };
        }
    });

    function Source(parameters) {
        this.config = $.extend({}, config_defaults, parameters);
        this.init.apply(this);
    }

    Source.prototype = prototype;
    Source.prototype.constructor = Source;

    return Source;
})(jQuery);

/**
* QListCmdbSource that uses a child (array property)
* of a single record to provide the list
* usage: new QListCmdbChildSource({child:'prop_name',
*                                   key:'search_key',
*                                   pattern:'value'})
* NOTE: so far this only works allows reading, more work would be
*       required to support child table editing with CMDB.edit
*/
var QListCmdbChildSource = (function($) {
    var prototype = new QListCmdbSource(),
        base = QListCmdbSource.prototype;

    $.extend(prototype, {
        'init': function() {
            base.init.call(this);
            this.datasource = [
                this.config.path,
                this.config.name,
                this.config.child
            ].join('.');
            this.base_datasource = [
                this.config.path, this.config.name
            ].join('.');
            this.type_formatter = getCmdbInfo(this.datasource);
        },
        'getData': function() {
            var that = this;
            this.row_data = $.Deferred();

            CMDB.fetch(this.config.path,
                this.config.name,
                {
                    'datasource': true,
                    'skip': true,
                    'key': this.config.key,
                    'pattern': this.config.pattern
                },
                function(response) {
                    if (response['status'] === 'success') {
                        var results = response.results,
                            path = that.config.child.split('.');
                        while ((path.length > 0) && (results.length > 0)) {
                            results = results[0][path.shift()];
                        }
                        that.raw_data = results.concat(that.extra_data);
                        cmdbManager.dirty(false);
                        that.handleExpansions();
                    }
                });
        },
        //todo: modify base class code to reduce potential breakage
        'buildRow': function(row, row_idx, row_data) {
            row_data.datasource = this.datasource;
            return base.buildRow.call(this, row, row_idx, row_data);
        },
        'buildCell': function(td, column, row_data) {
            var setAttribute = !('datasource' in column);
            row_data.datasource = row_data.datasource || this.datasource;
            column.datasource = column.datasource || this.datasource;
            column.attribute = column.selector;
            var result = base.buildCell.call(this, td, column, row_data);
            return result;
        },
        'buildMenu': function(elem, menu, defaults) {
            var cmdbInfo = $(elem).closest('tr.qlist_cmdb_object').first()
                .data('cmdbInfo');
            if (cmdbInfo) {
                cmdbInfo.datasource = this.datasource;
            }
            return base.buildMenu.call(this, elem, menu, defaults);
        }
    });

    function Source(parameters) {
        base.constructor.call(this, parameters);
    }

    Source.prototype = prototype;
    return Source;
})(jQuery);

/* global define */
/**
 * The contents of this file define qlist's column sorting feature
 * ANY other mention of sorting in jquery.qlist.js does not apply to this,
 * unless it explicitly says "qlist.sort.js". This composes a single, _cohesive_
 * feature that allows the user to click on a column header, and sort (usually
 * without hitting the server) the qlist according to that column. This does not
 * affect the order of the entries in `config.source`, and instead changes the
 * order of the `display_master`.
 *
 * This extension was not written from scratch, but rather refactored out of
 * jquery.qlist.js. So, there are some non-standard extension conventions:
 *
 * `enabled_config_path` is used, and should _only_ be used here, so that this
 * could still be a managed extension
 *
 * Some state data is stored directly on core.state, rather than independently here.
 * Some pages depend on reading that data.
 *
 * `display_master` could be managed by a different extension, although it originated with sorting.
 *
 * Lots of other configuration is not stored in the standard place. See the
 * extension definition's defaults for more info.
 */

(function(global, body) {
    'use strict';

    var exports;
    if (typeof define === 'function' && define.amd) {
        define('qlist.sort', [
            'jquery', 'fweb.util/dom', 'fweb.util/patterns', 'fweb.util/persist'
        ],
        function(jQuery, dom, patterns, persist) {
            exports = (exports || body(jQuery, dom, patterns, persist));
            return exports;
        });
    } else {
        var util = global.fweb.util;
        global.fweb = global.fweb || {};
        global.fweb.qlist = global.fweb.qlist || {};
        global.fweb.qlist.sort = exports = exports ||
            body(jQuery, util.dom, util.patterns, util.persist);
    }
})(this, function($, dom, patterns, persist) {
    'use strict';

    var try_JSON_parse = dom.try_JSON_parse;
    var RegExpCommon = patterns.commonRegExp;

    var $cookieStore = {
        remove: persist.removeCookie,
        get: function(n) { return try_JSON_parse(persist.getCookie(n)); },
        put: function(n, v) { return persist.setCookie(n, JSON.stringify(v)); }
    };

    var SortState = function() {};
    SortState.prototype.init = function() {
        this._sorting_cache = {};
    };
    SortState.prototype.preload = function(that, internal) {
        this.core_config = internal.core.config;
        this.config = this.core_config.sort;
        this.core_state = internal.core.state;
        this.el = $(that);

        this.internal_fns = {
            qlistRefreshTable: internal.core.fn.qlistRefreshTable
        };

        if (this.core_state.sorting == null) {
            var sorting_cookie_data;
            if (this.config.save_in_cookie) {
                sorting_cookie_data = clean_sorting_cookie_data(
                    $cookieStore.get(this.cookie_name), this.core_config);
            }

            // sorting is of type [{selector:string, direction:string}]
            this.core_state.sorting = sorting_cookie_data || this.core_config.default_sort;
        }

        this.resortIfNeeded();
    };
    SortState.prototype.postload = function(that, internal) {
        this.head_row = internal.core.head_row;
        this.add_sortable_indicators();
        this.renderInitialSortIndicator();

        this.head_row.off('click.sort');
        this.head_row.on('click.sort', $.proxy(this, 'onHeaderClick'));
        this.el.on('reset_columns.sort', $.proxy(this, 'reset_sorting'));
    };
    /**
     * @return {boolean} true if the display master was reset
     */
    SortState.prototype.resetDisplayMasterIfNeeded = function() {
        var source = this.getSource();
        var displayMaster = this.getDisplayMaster();
        if (displayMaster == null ||
            displayMaster.length !== source.length) {
            // (re)initialize display_master
            // NOTE: won't trigger in the unlikely case that the source has been changed
            // but it's the same length. In this case, the developer can force a sort.
            this.setDisplayMaster(get_new_display_master(source.length));
            return true;
        }
        return false;
    };
    SortState.prototype.destroy = function() {
        this.core_state = null;
        this.core_config = null;
        this.el = null;
        if (this.head_row != null) { this.head_row.off('click.sort'); }
        this.head_row = null;
        this.internal_fns = null;
    };
    SortState.prototype.onHeaderClick = function(event) {
        if (this.core_config.options.fixed_sort) { return; }
        var config = this.core_config;
        var sort_columns = config.options.sort_columns;
        var el = $(event.target).closest('th');
        var selector = el.data('selector');

        if ($.isFunction(config.callbacks.pre_sort)) {
            // call the pre-sort callback function
            config.callbacks.pre_sort(event, el, selector);
        }

        // Column Sorting
        if (config.checkboxes.enabled && !config.options.hide_checkboxes &&
           $('input:checkbox', el).length > 0) {
            return; // don't sort by checkboxes
        }
        if (this.el.find('td.empty_row').length > 0) {
            return; // disable sorting of empty qlists
        }
        if (!config.sort_fn['*'] && !(selector in config.sort_fn)) {
            // if the sort function isn't defined, don't try to sort by this column.
            return;
        }
        event.stopPropagation();
        if (!sort_columns || sort_columns[selector]) {
            this.do_sort_toggle(selector);
        }
    };
    SortState.prototype.prepareFastSort = function(target) {
        this.core_config.fast_sort = [];
        this.core_config.fast_sort_target = target;
    };
    SortState.prototype.disableFastSort = function() {
        this.core_config.fast_sort = undefined;
    };
    SortState.prototype.checkFastSort = function(target) {
        if (this.config.fast_update !== false && !this.core_config.paging.enabled &&
            !(this.core_config.category.q_type !== null &&
              this.core_config.column_map.category != null)) {
            this.prepareFastSort(target || this.el.find('tbody').eq(0));
        } else {
            this.disableFastSort();
        }
    };
    SortState.prototype.fastSortEnabled = function(check) {
        if (check) { this.checkFastSort(); }
        return this.core_config.fast_sort !== undefined;
    };
    SortState.prototype.clear_sorting_cache = function() {
        this.core_state.display_master = get_new_display_master(this.getSource().length);
        this._sorting_cache = {};
        this.checkFastSort();
    };
    SortState.prototype.reset_sorting = function() {
        this.clear_sorting_cache();
        this.source_order_indicator = false;
        this.setSortValue(this.getDefaultSort());

        $cookieStore.remove(this.cookie_name);

        var sortValue = this.getSortValue();
        if (sortValue != null && sortValue.length > 0) {
            this._do_sort();
        }
    };

    // normalize access of data stored in different locations
    SortState.prototype.getSortValue = function() { return this.core_state.sorting; };
    SortState.prototype.setSortValue = function(value) { this.core_state.sorting = value; };
    SortState.prototype.getDisplayMaster = function() { return this.core_state.display_master; };
    SortState.prototype.setDisplayMaster = function(value) {
        this.core_state.display_master = value;
    };
    SortState.prototype.getSource = function() { return this.core_config.source; };
    SortState.prototype.getDefaultSort = function() { return this.core_config.default_sort; };

    SortState.prototype.toggle_source_order_indicator = function() {
        var source_order = this.core_config.options.sort_source_order;
        if (source_order) {
            this.setSortValue([source_order]);
            this.renderInitialSortIndicator();
        }
    };

    SortState.prototype.source_load_complete = function() {
        this.resortIfNeeded();
    };


    SortState.prototype.resortIfNeeded = function() {
        // NOTE: the display master won't be reset in the unlikely case that the source
        // has been changed but it's the same length (server side paging, maybe).
        // In this case, the developer can force a sort.
        var sorting = this.getSortValue();
        if (this.resetDisplayMasterIfNeeded() &&
            sorting != null &&
                sorting.length > 0 && this.getSource() != null &&
                    (sorting !== this.getDefaultSort() ||
                     !this.config.default_sort_is_serverside)) {
            // if we have a sort state saved in the cookie, presort the data.
            // it's placed down here since _do_sort needs that.state to be set.
            this._do_sort();
        }
    };

    SortState.prototype.renderInitialSortIndicator = function() {
        var sortValue = this.getSortValue();
        var source = this.getSource();
        var source_order = this.core_config.options.sort_source_order;

        if ((!sortValue || !sortValue.length) && source_order) {
            sortValue = [source_order];
            this.setSortValue(sortValue);
        }

        // get the current sort to draw the sort indicator on the header.
        // don't get it if there's no data so sort, since clicking won't do anything then.
        // if it's a promise, just assume we'll get data
        var current_sort = (source.length > 0 || 'then' in source) &&
            sortValue != null ? sortValue[0] : undefined;

        // draw the sort indicator on the currently sorted row
        if (current_sort && !this.core_config.options.fixed_sort) {
            this.head_row.find('th').filter(function() {
                return $(this).data('selector') === current_sort.selector;
            }).addClass('sort-' + current_sort.direction);
        }
    };

    SortState.prototype.add_sortable_indicators = function() {
        var config = this.core_config;
        var sort_columns = config.options.sort_columns;

        if (this.el.find('td.empty_row').length) {
            return;
        }

        this.head_row.find('th').each(function() {
            var $this = $(this);
            var selector = $this.data('selector');
            if (config.checkboxes.enabled && !config.options.hide_checkboxes &&
                $this.find('input:checkbox')) {
                return;
            }
            if (!config.sort_fn['*'] && !(selector in config.sort_fn)) {
                return;
            }
            if (sort_columns && !sort_columns[selector]) {
                return;
            }

            $this.addClass('can_sort');
        });
    };

    /**
     * ----------------------------------------------------------------------------
     * The following code was originally generated by CoffeeScript
     * Please improve the readability of any lines you touch
     * ----------------------------------------------------------------------------

    /*
# creates a one-element array of sorting arguments to pass to do_sort
# selector: string
*/

    var argIndexOf, isServerSort, serverSortIndex,
        __indexOf = [].indexOf || function(item) {
            for (var i = 0, l = this.length; i < l; i++) {
                if (i in this && this[i] === item) {
                    return i;
                }
            }
            return -1;
        };

    SortState.prototype.do_sort_toggle = function(selector) {
        var config, current_direction, dirs, new_direction, state, _i, _len, _ref, _ref1;

        config = this.core_config;
        _ref = this.getSortValue();

        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            state = _ref[_i];
            if (state.selector === selector) {
                current_direction = state.direction;
                break;
            }
        }

        if (config.options.sort_columns &&
            typeof config.options.sort_columns[selector] === 'string') {
            if (_ref.length && _ref[0].selector === selector) {
                // Do nothing...were currently sorted in the only direction we allow
                return;
            } else {
                new_direction = config.options.sort_columns[selector];
            }
        } else {
            dirs = (_ref1 = config.sort_fn[selector]) != null ? _ref1.directions : void 0;
            if (dirs != null) {
                /* use the next direction in manually defined list of directions*/

                /* this is for complex sorts*/

                new_direction = dirs[($.inArray(current_direction, dirs) + 1) % dirs.length];
            } else {
                /* invert the current direction*/

                new_direction = current_direction === 'asc' ? 'desc' : 'asc';
            }
        }

        return this.do_sort([{
            selector: selector,
            direction: new_direction
        }]);
    };

    /*
# basically remove whatever sort_args are already in the sort_state
#    and add the sort_args onto the front.
# sort_args: [{selector:string, direction:<'asc'|'desc'>}]
*/


    SortState.prototype.do_sort = function(sort_args) {
        var config, defer, del_indicies, directionsNotRemoved, el, get_header, i, new_top_state,
            odd, old_sort_state, old_top_state, prevServerSortIndex, selectors, sortValue,
            sorting_event, _i, _j, _len, _len1, _ref, _ref1, _ref2, _ref3, _ref4,
            _this = this;

        config = this.core_config;
        old_sort_state = (_ref = this.getSortValue()) != null ? _ref.slice(0) : void 0;
        prevServerSortIndex = argIndexOf(old_sort_state, this.prevServerSort);

        if (sort_args != null) {
            old_top_state = this.getSortValue()[0];
            new_top_state = sort_args[0];
            /* Utility function to get the <th> for the current selector*/

            get_header = function(selector) {
                var ret;
                ret = null;
                _this.el.find('th').each(function(i, el) {
                    if ($.data(el, 'selector') === selector) {
                        ret = $(el);
                        return false;
                    }
                });
                return ret;
            };
            /* Apply the appropriate CSS class to the header*/

            if (!config.options.fixed_sort) {
                if (old_top_state != null) {
                    if ((_ref1 = get_header(old_top_state.selector)) != null) {
                        _ref1.removeClass('sort-' + old_top_state.direction);
                    }
                }
                if (new_top_state != null) {
                    if ((_ref2 = get_header(new_top_state.selector)) != null) {
                        _ref2.addClass('sort-' + new_top_state.direction);
                    }
                }
            }
            /* Process the sorting arguments*/

            /* Extract a list of just the selectors from the list of arguments*/
            selectors = $.map(sort_args, function(arg) {
                return arg.selector;
            });

            /* Create a list of the indicies that should be removed from the current state*/
            sortValue = this.getSortValue();
            directionsNotRemoved = {};
            del_indicies = $.grep(get_new_display_master(sortValue.length), function(i) {
                var duplicate, st, _ref3, sort_fn;
                st = sortValue[i];
                sort_fn = _this.core_config.sort_fn[st.selector];
                if (sort_fn && isServerSort(st, sort_fn)) {
                    /*
                     * server sorting combined with client side sorting is odd, so treat server
                     * side sorts differently here, only remove duplicates of server sorts and have
                     * both the same selector and direction
                     */
                    duplicate = (
                        _ref3 = st.direction,
                         __indexOf.call(directionsNotRemoved[st.selector] || [], _ref3) >= 0
                    );
                    if (!duplicate) {
                        (directionsNotRemoved[st.selector] ||
                         (directionsNotRemoved[st.selector] = [])).push(st.direction);
                    }
                    return duplicate;
                }
                return $.inArray(st.selector, selectors) >= 0;
            });

            /* Remove the indicies from the current state*/
            _ref3 = del_indicies.reverse();
            for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                i = _ref3[_i];
                sortValue.splice(i, 1);
            }

            /* Add the new sorting arguments to the current sorting state*/
            this.setSortValue(clean_sorting_cookie_data(
                sort_args.slice(0).concat(this.getSortValue()), this.core_config
            ));
        }

        /* Trigger an event for possible canceling & other notification*/
        sorting_event = $.Event('sorting');
        this.el.trigger(sorting_event, [old_sort_state]);
        if (this.config.save_in_cookie) {
            $cookieStore.put(config.ck_name.sorting, this.getSortValue());
        }
        if (sorting_event.isDefaultPrevented()) {
            return false;
        }
        /* Now that all the plumbing is done, call our actual sorting function,
           which will sort the display master according to the given sorting arguments
           */

        defer = this._do_sort(sort_args != null ? sort_args.length : void 0, prevServerSortIndex);
        if (defer) {
            return defer;
        }
        /* Reorder/render the html elements based on the new sorting order*/

        if (this.core_state.fast_sort != null) {
            /* if we can do a "fast sort", then do so. This just rearranges the <tr>s
               instead of completely redrawing the table
               */

            _ref4 = this.getDisplayMaster();
            for (_j = 0, _len1 = _ref4.length; _j < _len1; _j++) {
                i = _ref4[_j];
                if ((el = this.core_state.fast_sort[i]) != null) {
                    el.appendTo(this.core_state.fast_sort_target);
                    if (odd) {
                        el.addClass('odd');
                    } else {
                        el.removeClass('odd');
                    }
                    odd = !odd;
                }
            }
        } else {
            this.internal_fns.qlistRefreshTable();
        }
        this.el.trigger('sort', [old_sort_state]);
        return true;
    };

    isServerSort = function(arg, fn) {
        var sort_fn;
        var value = false;
        if (fn.kind === 'server' || (fn.kind === 'complex' && fn.server)) {
            value = true;
        } else if ((sort_fn = fn[arg.direction] || fn['*'])) {
            value = sort_fn.kind === 'server';
        }
        return value;
    };

    serverSortIndex = function(args) {
        var arg, i, r, _i, _len;
        r = -1;
        for (i = _i = 0, _len = args.length; _i < _len; i = ++_i) {
            arg = args[i];
            if (isServerSort(arg, arg.fn)) {
                r = i;
                break;
            }
        }
        return r;
    };

    argIndexOf = function(args, target) {
        var arg, i, r, _i, _len;
        r = -1;
        if (target == null) {
            return r;
        }
        for (i = _i = 0, _len = args.length; _i < _len; i = ++_i) {
            arg = args[i];
            if (target.selector === arg.selector && target.direction === arg.direction) {
                r = i;
                break;
            }
        }
        return r;
    };

    SortState.prototype.isNewServerSort = function(arg) {
        var p;
        p = this.prevServerSort;
        return ((arg != null) &&
                ((p == null) || arg.selector !== p.selector || arg.direction !== p.direction));
    };

    SortState.prototype.isGlobalServerSort = function() {
        return isServerSort({
            selector: '*',
            direction: '*'
        }, this.core_config.sort_fn['*']);
    };

    SortState.prototype._doServerSort = function(index) {
        var sortArg, sortFn, sortFns;
        if (index == null) {
            index = 0;
        }
        sortFns = this.core_config.sort_fn;
        sortArg = this.getSortValue()[index];
        /* TODO: handle a returned promise*/

        /* promise =*/

        sortFn = sortFns[sortArg.selector] || sortFns['*'];
        if (sortFn.kind === 'complex') {
            sortFn = sortFn[sortArg.direction] || sortFn['*'] || sortFn.server;
        }
        return sortFn({
            current_sort: this.getSortValue(),
            target_sort: sortArg,
            display_master: this.getDisplayMaster()
        });
    };

    /*
# compare to dataTables._fnSort
# count (optional): amount of properties in state.sorting to actually process
*/


    SortState.prototype._do_sort = function(count, prevServerSortIndex) {
        var arg, args, category_map, category_sort_fn, config, currentServerSort,
            currentServerSortIndex, defer, display_current, entry, get_complex_sort_child_test,
            get_simple_test, i, j, prevServerSort, source, tmp_obj, val, _i, _j, _k, _l, _len,
            _len1, _len2, _len3, _ref, _ref1, _ref2, _ref3, _s,
            _this = this;

        if (prevServerSortIndex == null) {
            prevServerSortIndex = -1;
        }

        config = this.core_config;
        if (this.getSortValue().length === 0) {
            /* reset the sort*/

            this.setDisplayMaster(get_new_display_master());
            return;
        }
        /* roughly adapted from jquery.dataTables._fnSort*/

        args = count ? this.getSortValue().slice(0, count) : this.getSortValue().slice(0);
        /*
           # add the sorting function to the arg list for convenience
           # this makes a copy of each so that we don't taint the state
           */

        for (i = _i = 0, _len = args.length; _i < _len; i = ++_i) {
            arg = args[i];
            tmp_obj = {
                fn: config.sort_fn[(_s = arg.selector) in config.sort_fn ? _s : '*']
            };
            args[i] = $.extend(tmp_obj, args[i]);
        }
        if (this.isGlobalServerSort(currentServerSort)) {
            return this._doServerSort() || true;
        }
        prevServerSort = this.prevServerSort;
        currentServerSortIndex = serverSortIndex(args);
        currentServerSort = this.getSortValue()[currentServerSortIndex];
        if ((currentServerSort != null) && (this.isNewServerSort(currentServerSort) ||
                prevServerSortIndex !== -1 && currentServerSortIndex !== prevServerSortIndex)) {
            this.prevServerSort = currentServerSort;
            defer = this._doServerSort(currentServerSortIndex);
            if (currentServerSortIndex === 0) {
                this.setDisplayMaster(get_new_display_master());
            }
            return defer || true;
        }
        if (currentServerSortIndex >= 0) {
            args = args.slice(0, currentServerSortIndex);
        }
        /* backwards compatibility for old style categories
           # this may need to be revised to accomodate new-style categories as well.
           # TODO (maybe): move this into a plugin-style framework (like with sort_fn)
           */

        if (config.category.q_type !== null && (config.column_map.category != null)) {
            category_map = {};
            _ref = this.getSource();
            for (i = _j = 0, _len1 = _ref.length; _j < _len1; i = ++_j) {
                entry = _ref[i];
                if (!(entry.category in category_map)) {
                    category_map[entry.category] = i;
                }
            }
            category_sort_fn = function(a, b) {
                return numeric_sort_fn(category_map[a], category_map[b]);
            };
            /* adds an extra argument to the front of the arguments to
               # maintain the current order of the categories
               */

            args.unshift({
                selector: 'category',
                direction: 'asc',
                fn: category_sort_fn
            });
        }
        /*
           # TODO: remove the above section
           # TODO: hidden sort (if needed):
           # args.unshift.apply(args, @config.hidden_sort) if @hidden_sort?
           */

        /*
           # if there's a 'key' or 'key_row' sort function for the column,
           # make a cache of the translated values
           */

        function gen_sort_cache() {
            var _l, _len3, _results;
            _results = [];
            for (_l = 0, _len3 = source.length; _l < _len3; _l++) {
                val = source[_l];
                _results.push(config.sort_fn[arg.selector](val[arg.selector]));
            }
            return _results;
        }

        function gen_key_cache() {
            var _l, _len3, _results;
            _results = [];
            for (_l = 0, _len3 = source.length; _l < _len3; _l++) {
                val = source[_l];
                _results.push(config.sort_fn[arg.selector](val));
            }
            return _results;
        }

        source = this.getSource();
        for (_k = 0, _len2 = args.length; _k < _len2; _k++) {
            arg = args[_k];
            if (((_ref1 = config.sort_fn[arg.selector]) != null ? _ref1.kind : void 0) === 'key' &&
                !(arg.selector in this._sorting_cache)) {
                this._sorting_cache[arg.selector] = gen_sort_cache(source, config);
            } else if (((_ref2 = config.sort_fn[arg.selector]) != null ? _ref2.kind : void 0) ===
                       'key_row' && !(arg.selector in this._sorting_cache)) {
                this._sorting_cache[arg.selector] = gen_key_cache(source, config);
            }
        }
        /* Set up an array of current positions so that we can do a stable sort if values match*/

        display_current = [];
        _ref3 = this.getDisplayMaster();
        for (i = _l = 0, _len3 = _ref3.length; _l < _len3; i = ++_l) {
            j = _ref3[i];
            display_current[j] = i;
        }
        get_simple_test = function(fn, arg, a, b) {
            if (fn.kind === 'comp_row') {
                return fn(source[a], source[b], default_clientside_sort_comp_fn);
            } else {
                return fn(source[a][arg.selector], source[b][arg.selector],
                          default_clientside_sort_comp_fn);
            }
        };
        get_complex_sort_child_test = function(fn, arg, a, b) {
            /* TODO: (performance) use _sorting_cache*/

            if (fn.kind === 'key') {
                return simple_sort_comp_fn(fn(source[a][arg.selector]),
                                           fn(source[b][arg.selector]));
            } else if (fn.kind === 'key_row') {
                return simple_sort_comp_fn(fn(source[a]), fn(source[b]));
            } else {
                return get_simple_test(fn, arg, a, b);
            }
        };
        /* Do the actual sorting!*/

        this.getDisplayMaster().sort(function(a, b) {
            var test, _len4, _m;
            if ((source[a] != null) && (source[b] != null)) {
                for (_m = 0, _len4 = args.length; _m < _len4; _m++) {
                    arg = args[_m];
                    /* TODO: (performance) move control flow (ifs) out of this
                       function and instead store control flow-less function in each arg
                       */

                    if (arg.fn.kind === 'key' || arg.fn.kind === 'key_row') {
                        test = simple_sort_comp_fn(_this._sorting_cache[arg.selector][a],
                                                   _this._sorting_cache[arg.selector][b]);
                    } else if (arg.fn.kind === 'complex') {
                        if ('asc' in arg.fn && arg.direction === 'asc') {
                            test = get_complex_sort_child_test(arg.fn.asc, arg, a, b);
                        } else if ('desc' in arg.fn && arg.direction === 'desc') {
                            test = get_complex_sort_child_test(arg.fn.desc, arg, a, b);
                        } else if ('ascdesc' in arg.fn && (arg.direction === 'asc' ||
                                                           arg.direction === 'desc')) {
                            test = get_complex_sort_child_test(arg.fn.ascdesc, arg, a, b);
                        } else {
                            return get_complex_sort_child_test(arg.fn[arg.direction], arg, a, b);
                        }
                    } else {
                        test = get_simple_test(arg.fn, arg, a, b);
                    }
                    if (test !== 0) {
                        return (arg.direction === 'asc' ? test : -test);
                    }
                }
            }
            return numeric_sort_fn(display_current[a], display_current[b]);
        });
    };
    /**
     * ----------------------------------------------------------------------------
     *  End CoffeeScript generated code (orginally)
     *  ---------------------------------------------------------------------------
     */

    // Utility functions

    function get_new_display_master(length) {
        var new_display_master = [];
        for (var _i = 0; _i < length; ++_i) {
            new_display_master.push(_i);
        }
        return new_display_master;
    }

    function get_cookie_name(prefix) {
        return prefix + '_sorting_settings';
    }

    function clean_sorting_cookie_data(sorting_cookie_data, config) {
        // checks the sorting_cookie_data so that it conforms to the
        //   [{selector:string, direction:string}] format and doesn't
        //   contain any selectors that aren't a column.
        // note that this function could be generalized somewhere else,
        //   and it could be simplified with some underscore functions.
        var sort_item_template = {
            selector: '',
            direction: ''
        };

        var i, l, p, x;
        if ($.isArray(sorting_cookie_data)) {
            l = sorting_cookie_data.length;
            for (i = 0; i < l; i++) {
                // _.pick(sorting_cookie_data[i], 'selector', 'direction');
                x = sorting_cookie_data[i];
                for (p in x) {
                    if (x.hasOwnProperty(p) && !sort_item_template.hasOwnProperty(p)) {
                        delete x[p];
                    }
                }
            }
            sorting_cookie_data = $.grep(sorting_cookie_data, function(x) {
                for (var p in sort_item_template) {
                    if (sort_item_template.hasOwnProperty(p) && !x.hasOwnProperty(p)) {
                        return false;
                    }
                }
                return config.column_map.hasOwnProperty(x.selector);
            });
        } else {
            sorting_cookie_data = undefined;
        }
        return sorting_cookie_data;

        //// for possible unit testing.
        // assert.deepEqual(clean_sorting_cookie_data([{selector:'device'}]), []);
        // assert.deepEqual(clean_sorting_cookie_data(
        //     [{selector:'device', direction:'asc'}]),
        //     [{selector:'device', direction:'asc'}]);
        // assert.deepEqual(clean_sorting_cookie_data(
        //     [{selector:'device', direction:'asc', fn: null}]),
        //     [{selector:'device', direction:'asc'}]);
        // assert.deepEqual(clean_sorting_cookie_data(
        //     [{selector:'device', direction:'asc', fn: null},
        //      {selector:'user', direction:'asc', fn: null}]),
        //     [{selector:'device', direction:'asc'},
        //      {selector:'user', direction:'asc'}]);
        // assert.deepEqual(clean_sorting_cookie_data(
        //     [{selector:'device', direction:'asc', fn: null},
        //      {selector:'user24', direction:'asc', fn: null}]),
        //     [{selector:'device', direction:'asc'}]);
        // assert.isUndefined(clean_sorting_cookie_data({foo:'bar'}));
    }

    //// SORTING FUNCTIONS ////

    function simple_sort_comp_fn(x, y) {
        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
    }
    simple_sort_comp_fn.kind = 'comp';

    // _digit_regex is limited to 15 digits to be safe: stackoverflow.com/q/307179
    var _digit_regex = /^(\D*)(\d{1,15})/;
    //optimize when comparing latin alphabet only strings
    //localeCompare is SLOW in chrome 26, 27.
    //see http://jsperf.com/operator-vs-localecompage/9
    //if chrome's localeCompare improves this test can be removed
    //add more non-locale specific characters here as needed

    var _no_locale_regex = /^[\w\-.\s]*$/;
    function default_clientside_sort_comp_fn(x, y) {
        function quick_type(obj) {
            var result = typeof obj;
            return result === 'object' ?
                $.type(obj) : result;
        }
        var xtype, x_reg_result, ytype, y_reg_result, ret;
        // if both of the objects are strings, sort them case insensitive
        xtype = quick_type(x);
        ytype = quick_type(y);
        if (xtype === ytype) {
            if (xtype === 'string') {
                x = x.toLowerCase();
                y = y.toLowerCase();
                if (x === y) {
                    return 0;
                }
                // if the string starts with numbers, sort numerically
                if ((x_reg_result = _digit_regex.exec(x)) !== null &&
                    (y_reg_result = _digit_regex.exec(y)) !== null &&
                        x_reg_result[1] === y_reg_result[1]) {
                    ret = parseInt(x_reg_result[2], 10) - parseInt(y_reg_result[2], 10);
                    if (ret !== 0) {
                        return ret;
                    }
                } else {
                    if (_no_locale_regex.test(x) && _no_locale_regex.test(y)) {
                        return x > y ? 1 : (x === y ? 0 : -1);
                    } else {
                        return x.localeCompare(y);
                    }
                }
            } else if (xtype === 'number') {
                return x - y;
            } else if (x == null) {
                return 0;
            }
        }
        if (y == null) { y = (xtype === 'number') ? Infinity : 'z' + y; }
        if (x == null) { x = (ytype === 'number') ? Infinity : 'z' + x; }
        return ((x < y) ? -1 : ((x > y) ? 1 : 0));
    }
    default_clientside_sort_comp_fn.kind = 'comp'; // comparison/comparator
    // alternative is `fn.kind = "key"` for user defined functions,
    //  which will return some kind of key from the data
    //  that can be sorted by this default sort function
    // also can be comp_row or key_row, which will pass the function the entire row to
    //  be compared (not just the value of the column)

    function numeric_sort_fn(x, y) {
        return x - y;
    }

    function ip4_addr_sort(x, skip_test) {
        if (!skip_test && !RegExpCommon.IP_HOST.test(x)) {
            return 0xFFFFFF;
        }

        x = x.split('.');
        return x.reduce(function(result, octet, i) {
            /* jshint bitwise: false */
            return (result | (parseInt(octet, 10) << ((3 - i) * 8))) >>> 0;
        }, 0);
    }

    ip4_addr_sort.kind = 'key';

    function ip6_addr_sort(x, skip_test) {
        if (!skip_test && !RegExpCommon.IP6_HOST.test(x)) { return x; }
        // based on https://github.com/beaugunderson/javascript-ipv6 (MIT license)
        var i, g = [];
        var halves = x.split('::');
        if (halves.length === 2) {
            var first = halves[0].split(':');
            var last = halves[1].split(':');
            if (first.length === 1 && first[0] === '') { first = []; }
            if (last.length === 1 && last[0] === '') { last = []; }
            var remaining = 8 - (first.length + last.length);
            for (i = 0; i < first.length; i++) { g.push(first[i]); }
            for (i = 0; i < remaining; i++) { g.push(0); }
            for (i = 0; i < last.length; i++) { g.push(last[i]); }
        } else if (halves.length === 1) {
            g = x.split(':');
        }
        var s;
        for (i = 0; i < g.length; i++) {
            s = g[i];
            g[i] = '0000'.substr(s.length) + s;
        }
        return g.join('').toLowerCase();
    }
    ip6_addr_sort.kind = 'key';
    function ip_addr_sort_compare(a, b) {
        a = ip_addr_sort(a);
        b = ip_addr_sort(b);
        if (typeof a === 'number' && typeof b === 'number') {
            return a - b;
        } else {
            return a > b ? 1 : (a === b ? 0 : -1);
        }
    }
    ip_addr_sort_compare.kind = 'comp';
    function ip_addr_sort(x) {
        if (RegExpCommon.IP_HOST.test(x)) {
            return ip4_addr_sort(x, true);
        }
        if (RegExpCommon.IP6_HOST.test(x)) {
            // the prepended '1' assures that an ip6 addr is always after a ip4 addr
            return '1' + ip6_addr_sort(x, true);
        }
        // this is 8 65535's with a 2 on the front, to guarantee that it's larger
        // than any ipv6 address string, as in
        // '2' + ip6_addr_sort('ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff')
        return '26553565535655356553565535655356553565535';
    }
    ip_addr_sort.kind = 'key';

    function ip_mask_sort(x) {
        return ip_addr_sort(x.split('/')[0]);
    }
    ip_mask_sort.kind = 'key';

    // legacy access of sort functions. New access should use the exports
    // values
    if (typeof $.qlist === 'undefined') { $.qlist = {}; }
    if (typeof $.qlist.sort_fns === 'undefined') { $.qlist.sort_fns = {}; }
    $.qlist.sort_fns.ip4_addr_sort = ip4_addr_sort;
    $.qlist.sort_fns.ip6_addr_sort = ip6_addr_sort;
    $.qlist.sort_fns.ip_addr_sort = ip_addr_sort;
    $.qlist.sort_fns.ip_mask_sort = ip_mask_sort;

    if (!$.qlist.ext) {
        $.qlist.ext = {};
    }
    var extension = $.qlist.ext.sort = {
        config_path: 'sort',
        managed: true,
        enabled_config_path: 'options.sorting',
        staticDepends: ['display_master'],

        // TODO: move all sorting settings, except sort_fn, to be under the 'sort' key
        defaults: {
            // enabled: false
            'fast_update': true,
            'save_in_cookie': true,
            // when performing a sort, 'pretend' like there are these sorts ahead of other sorts
            //  useful for categories, trees, etc
            // NOT IMPLEMENTED: see commented code in _do_sort
            // [{selector:string, direction:<'asc'|'desc'>, fn:default_clientside_sort_comp_fn?}]
            'hidden_sort': [],

            // enabling this will assume that the data from the server is already
            // sorted by the server, and not re-sort it according to the default sort
            'default_sort_is_serverside': false
        },
        core_defaults: {
            'default_sort': [],

            // 'sort': {...}, // see `defaults`, above
            options: {
                // Enable sorting?
                'sorting': false,
                // A mapping to enable sorting on specific columns only with the
                // option of enabling only a specific direction
                // Example:
                //   {
                //      column1: true,  // Supports sorting in both directions
                //      column2: 'asc', // Supports sorting in 'asc' direction only
                //      column3: 'desc'
                //   }
                // All columns left out of the map will have sorting disabled
                'sort_columns': null,
                // TODO: server-side sorting: for server side sorting, we will send
                //       the sort args and receive a new display_master array
                //       - a display_master is just an array of indicies in the data array
                //         in the order that it should be sorted, like [2, 1, 0]
                //         for a reversed list order.
                //       search for `if config.options.sorting_type == 'server'`
                //       and add new code there.

                // do sorting, but don't allow the user to manually sort
                // you should specify a default sort if you set this to true.
                // Also will hide the sort indicator.
                'fixed_sort': false
            },
            /* sorting functions -
             *  - '*' is the default sort.
             *      set it to null or undefined to restrict columns
             *  - for each function, you can set a .kind attribute that will
             *    define what arguments will be passed to the function and what
             *    the sorting function expects it to return.
             *   'comp' (default) - (x, y[, default_fn]): int -
             *                      x and y are the column values to be compared
             *   'comp_row' - (x, y[, default_fn]): int -
             *                x and y are the entire row values to be compared
             *   'key' - (a): any - returns a single value that will be used by a basic sort
             *   'key_row' - (a): any - a is the entire row, returns a single value
             *   'server' - (info): void|{ then: fn(success, fail) }
             *                  (promise or promise-like object)
             *              `info` is an object in the following format: {
             *                current_sort: [{selector:string, direction:<'asc'|'desc'>}, ...]
             *                  (the sort cookie),
             *                target_sort: {selector:string, direction:<'asc'|'desc'>}
             *                  (the top most sort argument),
             *                display_master: [int, ...] (the display master, described elsewhere),
             *                // more information can be added as needed.
             *              }
             *              If the function doesn't return a thenable, then it is
             *              assumed that the qlist will be reinitialized with the
             *              new source, already sorted. Otherwise, (NOT IMPLEMENTED!!!)
             *              the thenable should resolve with an object of the form {
             *                source: [] (new source)
             *                OR
             *                display_master: [] (new display master) // this form will probably
             *                                                        // never be used.
             *              }
             *   'complex' - rather than a function, an object is expected, with the
             *               form of the following:
             *               { kind: 'complex',
             *                 directions: ['asc', 'desc', 'foofirst', 'barfirst'],
             *                 server: true|false|function (default: false)
             *                         (defines a single server function for all directions)
             *                 foofirst: (a function in any of the above forms;
             *                            defines the sort function for a single direction)
             *                 ascdesc: (a normal sort function that will simply be reversed
             *                           for descending order, use this instead of defining
             *                           both asc and desc)
             *
             *                 IDEA (not implemented) - foolast: '!foofirst'
             *                     - like ascdesc, define a sort function as a
             *                       reversed version of another sort function
             *                 ...
             *               }
             */
            sort_fn: {
                '*': default_clientside_sort_comp_fn
            }
        },
        constructor: SortState,

        //// COMMANDS
        // various commands provided by this extension, like 'refresh' and 'config'
        // - remember to chain (return that) if your command doesn't return anything
        // - unlike _ext_call methods, `internal` is _not_ namespaced, it's the
        //   exact object that's passed from the _ext_handle_commands call
        // in jquery.qlist.js: _ext_handle_commands
        commands: {
            'sort': function(that, internal_core, command) {
                var self = internal_core.$self;
                if (self == null) { return; }
                if ($.type(command) === 'string') {
                    if (command === 'clear_cache') {
                        self.clear_sorting_cache();
                    } else if (command === 'reset') {
                        self.reset_sorting();
                    }
                } else {
                    self.do_sort(command);
                }
                return that;
            },
            'getSortValue': function(that, internal_core) {
                // TODO: if needed, create a simpler way to expose instance methods.
                var self = internal_core.$self;
                if (self != null) { return self.getSortValue(); }
            }
            // string: function(that, internal, ...args)
            // context (this) will be this extension (objectSearch), not the commands object
        },
        postconfigure: function(that, internal) {
            internal.core.config.ck_name.sorting = get_cookie_name(internal.core.config.prefix);
        },
        preload: function(that, internal) {
            var self = internal.$self;
            if (self == null) {
                self = new SortState();
                self.init();
            }
            self.cookie_name = get_cookie_name(internal.core.config.prefix);
            // assert(self.cookie_name === internal.core.config.ck_name.sorting)
            self.preload(that, internal);

            // angular defines a $destroy event; use it for better garbage collection
            if (typeof angular !== 'undefined') {
                $(that).one('$destroy', function() {
                    self.destroy();
                    internal.core.state.sort = null;
                });
            }

            return self;
        },
        postload: function(that, internal) {
            var self = internal.$self;
            if (self == null) {
                self = new SortState();
                self.init();
            }
            self.cookie_name = get_cookie_name(internal.core.config.prefix);
            // assert(self.cookie_name === internal.core.config.ck_name.sorting)
            self.postload(that, internal);

            // angular defines a $destroy event; use it for better garbage collection
            if (typeof angular !== 'undefined') {
                $(that).one('$destroy', function() {
                    self.destroy();
                    internal.core.state.sort = null;
                });
            }

            return self;
        },
        source_load_complete: function(that, internal) {
            if (internal.$self == null) { return; }
            internal.$self.source_load_complete();
        },

        load_row_frag: function(that, internal) {
            // TODO: move the contents of this function into $self
            // reload the display master as the length of the source may have changed
            var state = internal.core.state;
            var display_master = state.display_master;
            var len = internal.core.config.source.length;
            if (!display_master || display_master.length !== len) {
                // Nuke the current sorting. This should only happen with server
                // side sorting. Server side sorting should either be display master
                // aware or the display master should be initialized to the server-
                // side paging page length
                display_master = state.display_master = get_new_display_master(len);
                // OR
                // display_master = that.state.display_master = [];
            }
        }
    };

    // expose internal functions for possible testing, etc
    return {
        ext: extension,
        constructor: SortState,
        get_new_display_master: get_new_display_master,
        sort_fns: {
            ip4_addr_sort: ip4_addr_sort,
            ip6_addr_sort: ip6_addr_sort,
            ip_addr_sort: ip_addr_sort,
            ip_addr_sort_compare: ip_addr_sort_compare,
            ip_mask_sort: ip_mask_sort
        }
    };
});
/* globals fweb */
(function($/*=jQuery*/) {
'use strict';
/*const*/ var
    //https://developer.mozilla.org/en-US/docs/HTML/Content_categories
    /*
    FLOW_CONTENT_SELECTOR =
    'a,abbr,address,article,aside,audio,b,bdo,blockquote,br,button,' +
    'canvas,cite,code,command,datalist,del,details,dfn,div,dl,em,embed,' +
    'fieldset,figure,footer,form,h1,h2,h3,h4,h5,h6,header,hgroup,hr,i,' +
    'iframe,img,input,ins,kbd,keygen,label,map,mark,math,menu,meter,' +
    'nav,noscript,object,ol,output,p,pre,progress,q,ruby,samp,script,' +
    'section,select,small,span,strong,sub,sup,svg,table,textarea,time,' +
    'ul,var,video,wbr',
    PHRASING_CONTENT_STRICT_SELECTOR =
    'abbr,audio,b,bdo,br,button,canvas,cite,code,command,datalist,dfn,em,' +
    'embed,i,iframe,img,input,kbd,keygen,label,mark,math,meter,noscript,' +
    'object,output,progress,q,ruby,samp,script,select,small,span,strong,' +
    'sub,sup,svg,textarea,time,var,video,wbr',
    PHRASING_CONTENT_LOOSE_SELECTOR =
    'a,abbr,audio,b,bdo,br,button,canvas,cite,code,command,datalist,del,' +
    'dfn,em,embed,i,iframe,img,input,ins,kbd,keygen,label,map,map area,' +
    'mark,math,meter,noscript,object,output,progress,q,ruby,samp,script,' +
    'select,small,span,strong,sub,sup,svg,textarea,time,var,video,wbr',
    */
    PHRASING_FORBIDDEN_SELECTOR =
    'address,article,aside,blockquote,details,div,dl,fieldset,figure,' +
    'footer,form,h1,h2,h3,h4,h5,h6,header,hgroup,hr,map,menu,nav,ol,p,' +
    'pre,section,table,ul',
    INLINE_DISPLAY_FORBIDDEN_SELECTOR = '[display=none],[display=block]',
    SPAN_FORBIDDEN_SELECTOR = PHRASING_FORBIDDEN_SELECTOR + ',' +
        INLINE_DISPLAY_FORBIDDEN_SELECTOR;

function simplify_matches(matches) {
    return matches
        .sort(function(a, b) {
            var a_type = $.type(a), b_type = $.type(b);
            if (a_type === b_type && a_type === 'array') {
                return a[0] - b[0];
            }
            return a < b ? -1 : a > b ? 1 : 0;
        })
        .reduce(function(result, current) {
            if ($.type(current) !== 'array') { return result; }
            if (result.length === 0) {
                result.push(current);
                return result;
            }
            var last = result[result.length - 1];
            if (last[1] > current[1]) { return result; }
            if (last[1] > current[0]) {
                last[1] = current[1];
                return result;
            }
            result.push(current);
            return result;
        }, []);
}
// TODO: make the highlighting process more generic, rather than patching
//       this up to allow re-use
function get_highlighter(that, internal_core, get_column_value) {
    var self = {}, state, format_header;
    // this function can be overridden
    function set_config(config) {
        self._config = config;
        _recalc_highlight_html();
    } set_config(internal_core.config.search);

    var _ref, _ref2;
    state = (_ref = internal_core) == null ? {} : (_ref2 = _ref.state) == null ? {} : _ref2.search || {};
    // these functions are pretty much the same, the context is different
    format_header = get_column_value;

    // encapsulate what varies
    function highlight_dom_node(node) {
        if (self._config.highlight_color != null) {
            node.style.backgroundColor = self._config.highlight_color;
        }
        node.classList && node.classList.add(self._config.highlight_class);
    }
    function highlight_jquery_el($el, toggle) {
        if (toggle == null) { toggle = true; }
        if (self._config.highlight_color != null) {
            $el.css('background-color',
                toggle ? self._config.highlight_color : '');
        }
        $el.toggleClass(self._config.highlight_class, toggle);
    }
    function _recalc_highlight_html() {
        self._highlight_html =
            (self._config.highlight_color != null ?
            'style="background-color: ' + self._config.highlight_color + ';" ' : '') +
            'class="' + self._config.highlight_class + '"';
    }

    // TODO: refactor the highlighting process so that the .source attribute
    //       is on each individual match element rather than the entire match list
    // Explaination:
    // Currently, search functions will return a matchobject like this:
    // { 5: { selector: [ [0, 3], [6, null], source: '127.0.0.1' ] } }
    // It needs to be changed to the following format
    // { 5: { selector: [ [0, 3, source: '127.0.0.1'], [6, null, source: '127.0.0.1']] } }
    // this way, the `source` can differ based on where the match originates
    // Some search functions return [[true]] as well for a full column match.
    //     EG: fweb.address_search.cmdb.firewall.address

    // The search functions on the policy page (qlist.cmdb) already follow the second
    // format in order to provide cmdb-fetched search highlighting, but the mix of old
    // and new behaviour causes a few minor highlighting glitches
    // (for example, create a user identity policy with a group names
    // 'guest-group' that contains a user 'guest' and search for 'guest')
    self.insert_highlighting_spans = insert_highlighting_spans;
    function insert_highlighting_spans(match, value) {
        var simplified = simplify_matches(match);
        if (simplified.length < 1) {
            throw new Error('Match array is invalid');
        }
        // todo: highlight more than just the first match
        var span_begin = '<span ' + self._highlight_html + '>';
        $.each(simplified.reverse(), function(i, current_match) {
            var start = current_match[0];
            if (typeof start === 'boolean') {
                start = 0;
            }
            if (current_match[1] == null) { current_match = [start, value.length]; }
            value = value.slice(0, current_match[0]) +
            span_begin +
            String.prototype.slice.apply(value, current_match) +
            '</span>' +
            value.slice(current_match[1]);
        });
        return value;
    }
    self.robust_insert_highlighting_spans = robust_insert_highlighting_spans;
    function robust_insert_highlighting_spans(match, value, fallback_original_value) {
        var original_value, $inner, matched;

        original_value = match.source != null ? match.source : fallback_original_value;
        // if (value === original_value) {
        // Fix bug 0459213
        if (value === original_value || value === escapeHTML(original_value)) {
            // safe to do proper highlighting
            try {
                return insert_highlighting_spans(match, value);
            } catch (e) { /*fall through to do fallback highlighting*/}
        }
        var reduced_match = match,
            match_src = match.source;
        if ($.isArray(match)) {
            reduced_match = $.grep(match, function(submatch) {
                var submatch_src = submatch ? submatch.source || match_src : match_src;
                if (submatch) {
                    return typeof submatch_src === 'string' &&
                        fweb.util.htmlStringContains(value, submatch_src);
                }
                return false;
            });
            matched = reduced_match.length > 0;
        } else {
            matched = fweb.util.htmlStringContains(value, original_value);
        }
        if (matched) {
            var highlightedMatches = [];
            highlightedMatches.length = reduced_match.length;
            $inner = $('<div>');
            $inner.append(value);
            $inner.walkTextNodes(function() {
                var text = this.nodeValue;
                var original_index = text.indexOf(original_value);
                var everyMatchHighlighted = true;
                for (var i = 0, ii = reduced_match.length, submatch;
                        i < ii && (submatch = reduced_match[i], true); i++) {
                    if (highlightedMatches[i]) { continue; }
                    everyMatchHighlighted = false;
                    var source_value = submatch.source || original_value;
                    var index_of_source = source_value === original_value ? original_index : text.indexOf(source_value);
                    if (index_of_source >= 0) {
                        if (source_value === text && this.classList && this.classList.contains(self._config.highlight_class)) {
                            // already highlighted.
                            highlightedMatches[i] = true; continue;
                        }

                        try {
                            $(this).replaceWith(
                                text.slice(0, index_of_source) +
                                insert_highlighting_spans(reduced_match,
                                    source_value) +
                                text.slice(index_of_source + source_value.length)
                            );
                            highlightedMatches[i] = true; continue;
                        } catch (e) { continue; }
                    }
                }
                if (everyMatchHighlighted) { return false; } // break from walkTextNodes
            });
            return $inner.html();
        }
    }
    self.robust_highlight_cell = robust_highlight_cell;
    function robust_highlight_cell(match, value, fallback_original_value, td) {
        var formatted_value, $inner;
        if ($.type(value) === 'number') { value = '' + value; }
        if ($.type(value) === 'string') {
            formatted_value = robust_insert_highlighting_spans(match, value, fallback_original_value);
            if (formatted_value != null) { return formatted_value; }
        }

        $inner = $('<div>');
        $inner.append(value);
        // TODO: decide if there's no substring match,
        //       if div or span highlighting should be used.
        // NOTE: this check for .info_with_icon is a KLUDGE. Remove when possible.
        //       when check is removed, remove `td` argument.
        if (!(td != null && td.is('.info_with_icon')) &&
                $inner.has(SPAN_FORBIDDEN_SELECTOR).length === 0) {
            $inner = $('<span>');
            $inner.append(value);
        }
        highlight_jquery_el($inner);
        return $inner;
    }

    // TODO: this will need to be considered when designing an autoescaping feature
    function get_formatted_cell(td, selector, entry) {
        var source_index, $tr, search_matched, match, value, highlighted;
        if (state.current_results != null) {
            $tr = td.closest('tr');
            source_index = $tr.data('sourceIndex');
            if (source_index == null) {
                source_index = td.attr('atomicSourceIndex');
                if (source_index) {
                    source_index = +source_index;
                }
            }
            if (source_index == null) { source_index = $tr.data('sectionFirstIndex'); }
            search_matched = source_index in state.current_results;
            var search_selector = selector;
            if (search_matched) {
                var search_result = state.current_results[source_index];
                search_matched = selector in search_result;
                if (!search_matched && selector in internal_core.config.column_map) {
                    // try combined columns first
                    var column_map = internal_core.config.column_map[selector];
                    if ($.isArray(column_map.combine)) {
                        for (var i = 0, len = column_map.combine.length;
                                i < len; ++i) {
                            search_selector = column_map.combine[i];
                            search_matched = search_selector in search_result;
                            if (search_matched) {
                                break;
                            }
                        }
                    }
                }
            }
            // TODO: allow custom highlighting types
            // simple cell highlighting, for refrerence & possible fallback
            if (self._config.fast_update) {
                highlight_jquery_el(td, search_matched);
            } else {
                value = get_column_value(td, selector, entry);
                if (search_matched) {
                    match = state.current_results[source_index][search_selector];
                    highlighted = robust_highlight_cell(match, value, entry[selector], td);
                    if (highlighted instanceof jQuery && internal_core.config.options.atomic_render) {
                        return $('<div>').append(highlighted).html();
                    }
                    return highlighted;
                }
                return value;
            }
        }
        return get_column_value(td, selector, entry);
    }
    get_formatted_cell.__wrapped__ = get_column_value;
    function get_formatted_category_header(value, first_index) {
        if (state.current_results != null) {
            var match = state.current_results[first_index]['__category_header'];
            if (match != null) {
                return robust_insert_highlighting_spans(match, value);
            }
        }
        return value;
    }
    get_formatted_category_header.__wrapped__ = get_column_value;

    self.set_config = set_config;
    self.get_formatted_cell = get_formatted_cell;
    self.get_formatted_category_header = get_formatted_category_header;
    self.highlight_html = self._highlight_html;
    self.highlight_dom_node = highlight_dom_node;
    self.highlight_jquery_el = highlight_jquery_el;
    return self;
}

// Exports
if ($.qlist.ext.objectSearch == null) { $.qlist.ext.objectSearch = {}; }
$.qlist.ext.objectSearch.get_highlighter = get_highlighter;

})(jQuery);
/* global fweb */
(function($/*=jQuery*/) {
    'use strict';

    var extend_merge = window.fweb.util.extend_merge;

    /////////////////////////
    // The core search object prototype

    // kinda like Python's re.RegexObject

    function SearchObject() {
        SearchObject.prototype.__constructor__.apply(this, arguments);
    }
    /**
     * @typedef {[[number, number]] or boolean} MatchResult
     */
    SearchObject.prototype = {
        constructor: SearchObject,
        /** safe to be called multiple times in order to set options
         * available to decoration and other customization
         */
        __constructor__: function(/*options*/) {
            // if (options == null) { options = {}; }
        },
        /** @returns a modified version of `query` that will be passed to the other SearchObject
         *           functions
         */
        preprocess_query: function(query) { return query; },
        /** @returns {MatchResult} An object that represents if and possibly
         *           where the query was found in the value
         *  @returns {{string: MatchResult}} if selector === '__row__'
         */
        // search: function(value, query, row_index, selector) {},
        search: default_search_fn,
        /** can be 'value' (default), 'row' (implemented) or 'dom' (not implemented)
          * controls what 'value' is when `search()` is called */
        search_value_type: 'value',
        /** Rates how precisely the match_result matched the original query
         * @returns {number} Value from 0.0 to 1.0, 1.0 being an exact match, or null if unknown
         * @todo use NaN instead of null, if we can rely on a good isNaN implementation (underscore
         *       or ES6)
         * @param {object} value the object in which to search for the query
         * @param {object} query the object for which we are searching
         * @param {MatchResult} [match_result=this.match(value, query)] The output from `match`
         */
        rate: function(value, query, selector, match_result) {
            return +(match_result.length > 0);
        },
        /** @returns {string} An array of identifiers for the groups that the search result should
         *                    be under
         */
        group: function(row_value, query, selector, row_match_result) {
            var result = [];
            $.each(row_match_result, function(selector, value) {
                if ($.isArray(value) && value.length > 0) {
                    result.append(selector);
                }
            });
            return result;
        },
        /** Follows the signature for a function that would be provided to
         * jQuery.ui.autocomplete.source
         * @see http://api.jqueryui.com/autocomplete/#option-source
         * @param {object} request an object in the form of `{term: query}`
         * @param {function} response callback that expects an array of strings
         *        or an array of objects with `label` and `value` properties
         */
        autocomplete: function(request, response) {
            var query = request.term;
            response(this.autocomplete_sync(query));
        },
        /** Simplified, synchronous version of autocomplete
         * @param {string} query the string that is currently in the field
         * @returns an array of strings or an array of objects with `label` and `value` properties
        */
        autocomplete_sync: function(/*query*/) {
            return [];
        }
    };

    // NOTE: regarding the @todo on SearchObject.rate, a shim for ES6 Number.isNaN is
    // if (!Number.isNaN) { Number.isNaN = function(n){ return n !== n; }; }

    // a simple helper function for creating new searchobjects.
    // -- keeping a shallow prototype chain is good practice
    function declareSearchObject(spec, options) {
        return $.extend(new SearchObject(options), spec);
    }
    // if a deeper prototype chain is needed, use the following pattern
    // (or wrap this pattern in a utility function)
    //     function SubSearchObject() {
    //         SubSearchObject.prototype.__constructor__.apply(this, arguments);
    //     }
    //     SubSearchObject.prototype = declareSearchObject({...});

    var caseInsensitiveSearchObject = declareSearchObject({
        preprocess_query: function(query) { return ('' + query).toLowerCase(); },
        search: default_lowercase_search_fn
    });

    /*
     * Provided for future use
     *
     * var example_row_search_fn = function(row_value, query, row_index) {
     *     var result = {},  _this = this;
     *     $.each(row_value, function(key, value) {
     *         result[key] = _this._search(value, query, row_index, key);
     *     });
     *     return result;
     * };
     * var rowSearchObject = declareSearchObject({
     *     search: example_row_search_fn,
     *     search_value_type: 'row',
     *     _search: default_search_fn
     * });
     * var caseInsensitiveRowSearchObject = declareSearchObject({
     *     preprocess_query: caseInsensitiveSearchObject.preprocess_query,
     *     search: example_row_search_fn,
     *     search_value_type: 'row',
     *     _search: default_lowercase_search_fn
     * });
     */

    function defaultSearchObjectFactory(config) {
        return config.search.case_insensitive ? caseInsensitiveSearchObject : new SearchObject();
    }

    function domSearchObjectFactory(that, internal_core, tbody, inner_search_obj) {
        // TODO: store extra information in the object, rather than using closures
        return $.extend({}, inner_search_obj, {
            search_value_type: 'row',
            search: dom_search_fn_factory(that, internal_core, tbody,
                                          $.proxy(inner_search_obj, 'search'))
        });
    }

    function sectionHeaderSearchObjectFactory(format_fn, selector, default_search_obj) {
        var dummy_td = $('<td>');
        // var dummy_td = null;
        return declareSearchObject({
            preprocess_query: default_search_obj.preprocess_query,
            search: function(entry, query) {
                var formatted_value = format_fn(dummy_td, selector, entry);
                var match = default_search_obj.search(formatted_value, query);
                if (match) { match.source = formatted_value; }
                return match;
            },
            search_value_type: 'row'
        });
    }

    function categoryHeaderSearchObjectFactory(internal_core, default_search_obj) {
        var categories_map = internal_core.config.categories_map;
        return declareSearchObject({
            preprocess_query: default_search_obj.preprocess_query,
            search: function(entry, query) {
                var category, cur_category;
                for (cur_category in categories_map) {
                    if (categories_map.hasOwnProperty(cur_category)) {
                        if ($.inArray(entry, categories_map[cur_category]) >= 0) {
                            category = cur_category;
                            break;
                        }
                    }
                }
                var match = default_search_obj.search(category, query);
                if (match) { match.source = category; }
                return match;
            },
            search_value_type: 'row'
        });
    }

    // TODO: function construct_search_obj_from_config(config)
    //       if I use jquery event style specifications for search_obj

    function config_fn_to_obj(config, target, config_key, options) {
        if (config_key == null) { config_key = target + '_fn'; }
        var obj = extend_merge({}, config[config_key], true);

        var i, _len, selector, _ref, target_fn, spec;
        for (selector in obj) {
            if (obj.hasOwnProperty(selector)) {
                _ref = obj[selector];
                for (i = 0, _len = _ref.length; i < _len; i++) {
                    target_fn = _ref[i];
                    spec = {};
                    spec[target] = target_fn;
                    $.extend(spec, options);
                    _ref[i] = declareSearchObject(spec);
                }
            }
        }
        return obj;
    }

    /////////////////////////
    // Core search functions

    // these use the same level of delegation as the sorting functions -- one
    // to handle the event, one to handle settings and the current UI state,
    // and one to do the core data manipulation

    // handles event and passes off control to do_search
    function do_search_callback(that, internal/*, event*/) {
        if (internal.core.tbody == null) {
            internal.core.tbody = that.find('table.qlist tbody');
        }
        do_search(that, internal);
    }

    // gathers together arguments for _do_search, and then propagates
    // appropriate changes to the DOM when done.
    function do_search(that, internal) {
        var state, config, search_box, clear_button, search_val, tbody, indexed_rows,
            search_obj, searching_event, search_complete_event, old_query,
            args, i, _len, _ref;

        state = internal.core.state;
        config = internal.core.config;
        search_box = get_or_create_search_box(that, internal.core.config);
        clear_button = get_or_create_clear_button(that, internal.core.config);

        if (!search_box || !search_box.length || !clear_button || !clear_button.length) { return; }

        old_query = state.search.current_query;
        search_val = state.search.current_query = search_box.val();
        tbody = internal.core.tbody;

        searching_event = $.Event('searching');
        that.trigger(searching_event, search_val);
        if (searching_event.isDefaultPrevented()) {
            return;
        }

        // search cleared
        if (search_val.length < 1) {
            state.search.current_results = null;
            if (old_query !== search_val) {
                if (config.search.fast_update) {
                    indexed_rows = get_indexed_rows(tbody);
                    _fast_filter_reset_widths(indexed_rows);
                    indexed_rows.each(function(i, element) { $(element).show(); });
                } else {
                    redraw_table(that, internal, function() {
                        // keep focus on the search field on non-webkit browsers
                        // TODO: see if this (and similar calls) can be removed
                        //       safely, since the search box container was moved
                        //       so that it won't be removed (and therefore keep focus)
                        setTimeout(function() {
                            var sb = get_or_create_search_box(that, internal.core.config);
                            if (sb && sb.length) {
                                if (!sb.is(document.activeElement)) {
                                    sb.focus();
                                }
                            }
                        }, 5);
                    });
                }
            }
            // if the query hasn't changed, do nothing
            return;
        }

        if (old_query === search_val) {
            // if the query hasn't changed, do nothing
            return;
        }

        // TODO: move out of callback, store in state.
        var default_search_obj = defaultSearchObjectFactory(config);
        search_obj = config.search.disable_fallback_dom_search ? {} : {
            // '*': [default_search_obj]
            '__row__': [domSearchObjectFactory(that, internal.core, tbody, default_search_obj)]
        };

        // add a default search for all columns that are section headers
        if (config.search.search_categories) {
            // only old-style categories and sections
            _ref = get_category_selectors(config);
            for (i = 0; i < _ref.length; i++) {
                if (config.format_fn[_ref[i]] != null) {
                    search_obj[_ref[i]] = [
                        sectionHeaderSearchObjectFactory(config.format_fn[_ref[i]], _ref[i],
                                                         default_search_obj)
                    ];
                } else {
                    search_obj[_ref[i]] = [default_search_obj];
                }
            }
            // new-style categories have to be treated specially since their
            // logic is convoluted
            if (config.categories.length > 0) {
                search_obj.__category_header = [
                    categoryHeaderSearchObjectFactory(internal.core, default_search_obj)
                ];
            }
        }

        search_obj = extend_merge(search_obj, internal.core.config.search.search_obj, true);

        // construct search objects out of each standalone search function provider,
        // and add them to the core search object
        args = [
            ['search'], ['search', 'search_row_fn', { search_value_type: 'row' }], ['rate'],
            ['group'], ['autocomplete_sync', 'autocomplete_fn']
        ];
        for (i = 0, _len = args.length; i < _len; i++) {
            search_obj = extend_merge(
                search_obj, config_fn_to_obj.apply(null, [config.search].concat(args[i])), true
            );
        }

        // cancel the current search if it's still in progress
        if (state.search.current_search != null) {
            if (state.search.current_search.cancel) {
                state.search.current_search.cancel();
            }
            state.search.current_search = null;
        }

        state.search.current_results = {};
        state.search.current_search = _do_search_async(config.source, search_val, search_obj)
            .progress(function(search_results) {
                $.extend(state.search.current_results, search_results);
            })
            .then(function() {
                var search_results = state.search.current_results;

                state.search.current_search = null;
                search_complete_event = $.Event('search_complete');
                that.trigger(search_complete_event, search_results, search_val);

                // filter out HTMLTableRowElements that don't match the search
                if (config.search.fast_update) {
                    indexed_rows = get_indexed_rows(tbody);

                    _fast_filter_reset_widths(indexed_rows);

                    indexed_rows.each(function(i, element) {
                        var $element = $(element);
                        var index = $element.data('index');
                        if (index == null) {
                            index = $element.data('sourceIndex');
                        }
                        $element.toggle(index in search_results);
                    });

                    _fast_filter_set_widths(indexed_rows);
                    // TODO: do same even/odd fix that sorting does.
                } else {
                    that.one('qlist_load_that', function() {
                        // keep focus on the search field in non-webkit browsers
                        // TODO: properly fix by making an alternative to qlistRefreshTable
                        //       that only regenerates the rows and not the entire table
                        //       will need qlist to be heavily cleaned up
                        setTimeout(function() {
                            var sb = get_or_create_search_box(that, internal.core.config);
                            if (sb && sb.length) {
                                var sb_val = sb.val();
                                if (!sb.is(document.activeElement)) {
                                    sb.focus().val('').val(sb_val);
                                }
                            }
                        }, 5);
                    });
                    redraw_table(that, internal);
                }
            }, function(e) {
                search_complete_event = $.Event('search_complete');
                that.trigger(search_complete_event, state.search.current_results, search_val);
                throw e;
            });
    }

    // haystack - the source array of objects
    // needle - the search term - might be some kind of special object.
    // begin (optional) - index at which to start searching
    // end (optional) - index before which to stop searching
    // @return - an sparse array (object with integer keys)
    //           of `{ selector: [[begin, end]] }`, which is where the needle was found.
    function _do_search(haystack, raw_query, search_obj, kwargs) {
        if (kwargs == null) { kwargs = {}; }
        var begin, end, found;
        begin = kwargs.begin;
        end = kwargs.end;
        if (begin == null) { begin = 0; }
        if (end == null) { end = haystack.length; }

        var search_obj_array, search_obj_cur, query,
            i, _len, j, results, selector,
            current, currentresult, currentresult_obj, currentresult_count;

        var search_fn = function(key, value) {
            found = search_obj_cur.search(
                search_obj_cur.search_value_type === 'row' ? current : value,
                query, i, key
            );
            if (found === true || found.length > 0) {
                currentresult[key] = found;
                currentresult_count++;
            }
        };

        results = {};

        search_obj_array = search_obj['*'] || [];
        for (j = 0, _len = search_obj_array.length; j < _len; j++) {
            search_obj_cur = search_obj_array[j];
            query = search_obj_cur.preprocess_query(raw_query);

            for (i = begin; i < end; i++) {
                current = haystack[i];
                currentresult = {};
                currentresult_count = 0;
                $.each(current, search_fn);
                if (currentresult_count > 0) {
                    results[i] = extend_merge(results[i] || {}, currentresult);
                }
            }
        }

        search_obj_array = search_obj.__row__ || [];
        for (j = 0, _len = search_obj_array.length; j < _len; j++) {
            search_obj_cur = search_obj_array[j];
            query = search_obj_cur.preprocess_query(raw_query);

            if (search_obj_cur.search_value_type === 'value') {
                continue;
            }
            for (i = begin; i < end; i++) {
                current = haystack[i];
                currentresult = search_obj_cur.search(current,
                    query, i, '__row__');
                if ($.isArray(currentresult) && currentresult.length > 0) {
                    results[i] = extend_merge(results[i] || {}, {'__row__': currentresult});
                } else if (!$.isEmptyObject(currentresult)) {
                    results[i] = extend_merge(results[i] || {}, currentresult);
                }
                // TODO: handle currentresult being true
            }
        }

        for (selector in search_obj) {
            if (search_obj.hasOwnProperty(selector)) {
                if (selector === '*' || selector === '__row__') {
                    continue;
                }
                search_obj_array = search_obj[selector] || [];
                for (j = 0, _len = search_obj_array.length; j < _len; j++) {
                    search_obj_cur = search_obj_array[j];

                    query = search_obj_cur.preprocess_query(raw_query);

                    for (i = begin; i < end; i++) {
                        current = haystack[i];
                        currentresult = search_obj_cur.search(
                            (search_obj_cur.search_value_type === 'row' ?
                             current : current[selector]),
                            query, i, selector);
                        if (currentresult.length > 0) {
                            currentresult_obj = {};
                            currentresult_obj[selector] = currentresult;
                            results[i] = extend_merge(results[i] || {}, currentresult_obj);
                        }
                    }
                }
            }
        }

        return results;
    }

    // todo: make configurable
    var ASYNC_SEARCH_STEP_SIZE = 50;
    var ASYNC_SEARCH_STEP_INTERVAL = 10;
    // By default, we use this function instead of the synchronous version when
    //   the haystack length is > 500 (see do_search)
    // This function returns an augmented Promise that also includes `cancel()`
    //   which can be used to interrupt the search
    // @return - a Promise that will
    //           - notify(_do_search return format, progress %)
    //           - resolve(last index processed)
    //           - reject(Error, last index processed)
    // TODO: actually use this method
    function _do_search_async(haystack, needle, search_fn) {
        // this async for loop structure could be extracted out into a utility library
        // see http://erickrdch.com/2012/05/asynchronous-loop-with-jquery-deferred.html
        var _len = haystack.length;
        var deferred = $.Deferred();
        var current_timeout = null;
        var i = 0;

        function loop() {
            // TODO: use http://dbaron.org/log/20100309-faster-timeouts
            // instead of setTimeout
            try {
                var begin = i;
                i += ASYNC_SEARCH_STEP_SIZE;
                if (i < _len) {
                    deferred.notify(_do_search(haystack, needle, search_fn, {
                        begin: begin,
                        end: Math.min(i, _len)
                    }));
                    current_timeout = setTimeout(loop, ASYNC_SEARCH_STEP_INTERVAL);
                } else {
                    deferred.notify(_do_search(haystack, needle, search_fn, {
                        begin: begin
                    }));
                    deferred.resolve(_len);
                }
            } catch (e) {
                deferred.reject(e);
            }
        }
        current_timeout = setTimeout(loop, 0);

        return deferred.promise({
            cancel: function() {
                clearTimeout(current_timeout);
                deferred.reject(new Error('Search cancelled'));
            }
        });
    }

    /////////////////////////
    // Default searching functions

    // todo: refactor DOM searching facilities
    function dom_search_fn_factory(that, internal_core, tbody, inner_search_fn) {
        var jq_rows_by_index = [];
        tbody.find('tr').filter(function() {
            var $this = $(this);
            return $this.data('index') != null || $this.data('sourceIndex') != null;
        }).each(function(i, element) {
            var $element = $(element);
            var index = $element.data('index');
            if (index == null) {
                index = $element.data('sourceIndex');
            }
            jq_rows_by_index[index] = $element;
        });
        var row_frag = $('<tr>');
        var cell_frag_base = $('<td>');
        var get_column_value = internal_core.fn.get_column_value,
            _ref = internal_core.config.chosen_columns,
            _len = _ref.length;
        var internal_config = internal_core.config;
        var category_regexp = (/\bcategory\b/);
        // TODO: this function should be moved into core qlist as a utility function
        // see '// generate cells' section of load_rows
        function populate_row_frag(entry) {
            var cell_frag, i;
            row_frag.empty();
            for (i = 0; i < _len; i++) {
                cell_frag = cell_frag_base.clone();
                cell_frag.append(get_column_value(cell_frag, _ref[i], entry));
                row_frag.append(cell_frag);
            }
            return row_frag;
        }
        function dom_search_fn(entry, needle, index/*, selector*/) {
            var row = jq_rows_by_index[index], cells, cell, i, col_selector, result = {}, found,
                      cell_text;
            var walk_fn = function(text) {
                found = inner_search_fn(text, needle, index, col_selector);
                if ($.isArray(found) && found.length > 0) {
                    found.source = text;
                    result[col_selector] = found;
                    return false;
                }
            };

            if (row == null) {
                row = populate_row_frag(entry);
            }
            cells = row.children('td');
            for (i = 0; i < _len; i++) {
                col_selector = _ref[i];
                if (category_regexp.test('' +
                    internal_config.column_map[col_selector]['class'])) { continue; }
                cell = cells.eq(i);

                cell.find('.' + internal_config.search.highlight_class).contents().unwrap();
                cell.walkTextChunks(walk_fn);
                if ($.isArray(found) && found.length > 0) {
                    continue;
                }

                // fallback (text may be formatted oddly)
                cell_text = cell.text();
                found = inner_search_fn(cell_text, needle, index, col_selector);
                if ($.isArray(found) && found.length > 0) {
                    // TODO: decide if `source` is a good name for this
                    // TODO: document this part -- essential for substring highlighting
                    found.source = cell_text;
                    result[col_selector] = found;
                }
            }
            return result;
        }
        return dom_search_fn;
    }

    // default search function -
    // finds the first instance of the search term (needle) only.
    function default_search_fn(stringvalue, needle) {
        if (typeof stringvalue !== 'string') {
            return [];
        }
        var i = stringvalue.indexOf(needle);
        return i === -1 ? [] : [[i, i + needle.length]];
    }

    function default_lowercase_search_fn(stringvalue, needle) {
        if (typeof stringvalue !== 'string') {
            return [];
        }
        var lowerstring = stringvalue.toLowerCase();
        var i = lowerstring.indexOf(needle);
        return i === -1 ? [] : [[i, i + needle.length]];
    }

    //function _do_search_serverside(){}

    /////////////////////////
    // DOM management
    function toggle_events(that, internal, enable, search_box) {
        var event_name_bound, config, state;
        state = internal.core.state;
        config = internal.core.config;
        event_name_bound = state.search.event_name_bound;

        if (!search_box) {
            search_box = get_or_create_search_box(that, config);
            if (!search_box) { return; }
        }

        if (enable) {
            if (event_name_bound == null) {
                search_box.on(event_name_bound = _namespacify_events(config.search.trigger_event),
                    $.proxy(do_search_callback, ext_this, that, internal));
                if (config.search.focus_on_document_esc) {
                    $(document).on(_namespacify_events('keyup'), function(event) {
                        if (event.which === $.ui.keyCode.ESCAPE) {
                            search_box.focus();
                        }
                    });
                }
            }
        } else if (event_name_bound != null) {
            search_box.off(event_name_bound);
            if (config.search.focus_on_document_esc) {
                $(document).off(_namespacify_events('keyup'));
            }
            event_name_bound = undefined;
        }
        state.search.event_name_bound = event_name_bound;
    }

    function set_disabled(that, internal, setting, search_box) {
        if (search_box == null) {
            var container = that.find('.ext_hdr_items');
            if (container.length) {
                search_box = get_search_box(that, internal.core.config, container);
            }
            if (!search_box || search_box.length < 1) {
                return;
            }
        }

        // based on jquery.ui.widget:_setOption
        search_box
            // kludge to make .ui-state-disabled not hide the search icon
            .css('background-image', setting ?
                search_box.css('background-image') : '')
            .toggleClass('ui-state-disabled', !!setting)
            // FIXME: here, we don't actually disable the search box
            // because it will lose focus, and when it loses focus,
            // some browsers will interpret a 'backspace' as a command to
            // navigate backwards in their history
            // .prop("disabled", setting)
            ;
        // one possible workaround for the above problem is to just disable
        // keyboard events like so:
        // search_box.off('keydown.faux_disable');
        // if (setting) {
        //     search_box.on('keydown.faux_disable', function(event) {
        //         event.preventDefault();
        //     });
        // }

        toggle_events(that, internal, !setting, search_box);
    }

    function get_container(that, config) {
        // Insert search box into extension header container created by qlist core
        var container = $('#' + config.prefix + '-ext_hdr_items');
        return container;
    }

    function get_search_box(that, config, container) {
        if (!container || !container.length) { return; }
        return container.find('.search_box');
    }
    function get_or_create_search_box(that, config) {
        var container = get_container(that, config);
        if (!container || !container.length) { return; }
        var _search_text, search_box;
        // get
        search_box = get_search_box(that, config, container);
        if (search_box && search_box.length > 0) { return search_box; }
        // create
        _search_text = $.getInfo('search');
        search_box = $('<input name="search_txt" type="search" value="" ' +
                'autofocus=true ' +
                'id="' +
                config.prefix + '_search_txt" class="tool_sprite tool_search2 search_box">')
            .prop({ title: _search_text, placeholder: _search_text })
            .appendTo(container);

        that.on('searching', function(evt, search_string) {
            search_box.toggleClass('tool_active', search_string !== '');
        });

        that.on('search_complete', function() {
            search_box.toggleClass('tool_active', false);
        });

        return search_box;
    }

    function get_or_create_clear_button(that, config) {
        var container = get_container(that, config);
        if (!container || !container.length) { return; }
        var search_box = get_or_create_search_box(that, config, container),
            clear_button, clear_button_container;

        if (!search_box || !search_box.length) { return; }

        clear_button_container = container.find('.search-clear-container');
        if (clear_button_container.length < 1) {
            clear_button_container = $('<div class="search-clear-container" />')
                .insertAfter(search_box);
        }

        clear_button = clear_button_container.find('.search_clear');
        if (clear_button.length > 0) {
            return clear_button;
        }
        clear_button = $('<a class="tool_sprite tool_clear search_clear"' +
                'title="' + $.getInfo('search_clear') + '">&nbsp;</a>')
            .appendTo(clear_button_container)
            .toggle(search_box.val().length > 0);
        return clear_button;
    }

    function _fast_filter_reset_widths($indexed_rows) {
        var $first = $indexed_rows.first(),
            $firstvisible = $indexed_rows.filter(':visible:first'),
            $firstvisible_td = $firstvisible.find('td');
        if (!$firstvisible.is($first)) {
            $first.find('td').width(function(i) {
                return $firstvisible_td.eq(i).width();
            });
            $firstvisible.find('td').width('');
        }
    }

    function _fast_filter_set_widths($indexed_rows) {
        // TODO: add an indicator row if there are no visible elements
        var $first = $indexed_rows.first(),
            $firstvisible = $indexed_rows.filter(':visible:first');
        if (!$firstvisible.is($first)) {
            var $first_td = $first.find('td');
            $firstvisible.find('td').width(function(i) {
                return $first_td.eq(i).width();
            });
        }
    }

    function redraw_table(that, internal, callback) {
        // TODO: add an option to enable off-dom rendering (the below .detach())
        // it greatly speeds up re-render of the table, but doesn't work with
        // (old style?) section headers
        // var that_parent = that.parent();
        // that.detach();
        that.one('qlist_load_that', function() {
            // that.appendTo(that_parent);
            if ($.type(callback) === 'function') { callback(); }
        });
        // TODO: test to see if calling this async is better or worse
        // internal.core.fn.qlistRefreshTable(); // sync
        window.setTimeout(internal.core.fn.qlistRefreshTable, 5); // async
    }

    /////////////////////////
    // Utility functions

    var CONFIG_PATH = 'search';
    var _namespacify_events = fweb.util.namespacifyEvents(CONFIG_PATH);

    // todo: cache these filtered tr's in core state; put into a separate extension
    // that will make sure that 'index' exists on every row, make it a dependancy
    function get_indexed_rows(tbody) {
        return tbody.find('tr').filter(function() {
            var $this = $(this);
            return $this.data('index') != null || $this.data('sourceIndex') != null;
        });
    }

    function get_category_selectors(config) {
        var _ref = $.map(config.columns, function(column) {
                var classes = (column['class'] || '').split(/\s+/);
                if ($.inArray('category', classes) >= 0) {
                    return column.selector;
                }
            });
        return _ref.concat(config.sections);
    }

    ////////////////////////
    // Imports from other parts of objectSearch
    var get_highlighter = $.qlist.ext.objectSearch.get_highlighter;

    ////////////////////////
    // Extension object

    var ext_this;
    ext_this = $.qlist.ext.objectSearch = {
        depends: [],
        config_path: CONFIG_PATH,
        managed: true,
        defaults: {
            enabled: false,
            trigger_event: 'search.timeout.enterkey',
            change_timeout: 500, // milliseconds
            // TODO: split search categories/sections
            //       (because the code for categories is so convoluted that I can't generalize it.)
            // TODO: highlighting for category matches
            search_categories: true, // also search on the category/section headers
            highlight: true,      // PartiallyImplemented - always true
            highlight_color: 'yellow',
            highlight_class: 'search-highlight',
            fast_update: false, // can only be true if no paging or highlighting.
            case_insensitive: true,
            autocomplete: false, // NotImplemented
            auto_async: true,    // NotImplemented
            force_async: false,  // NotImplemented
            group_order: [],     // NotImplemented
            focus_on_document_esc: true,
            // TODO: add a setting so that these will combine with the default
            // results rather than just replace them.
            search_obj: {
                /// TODO: to define multiple search objects per selector, use
                ///       the same namespacing behaviour as jQuery.on event bindings
                ///       -- for now, just use arrays
                /// a `new SearchObject` or `caseInsensitiveSearchObject` will be implicitly
                //  prepended onto '*'
                // '*': [new SearchObject()],
                /// searches under selectors will automatically fall back to
                /// using '*', unless one of the objects has 'strict' set to true
                // <selector>: [{
                //     __constructor__: function(options) {
                //         this.constructor.prototype.__constructor__.apply(this, arguments);
                //     },
                //     preprocess_query: SearchObject.prototype.preprocess_query,
                //     search: SearchObject.prototype.search,
                //     search_value_type: SearchObject.prototype.search_value_type,
                //     rate: SearchObject.prototype.rate,
                //     group: SearchObject.prototype.group,
                //     autocomplete: SearchObject.prototype.autocomplete,
                //     autocomplete_sync: SearchObject.prototype.autocomplete_sync,
                // }]
            },
            search_obj_factory: {
                // __row__: domSearchObjectFactory
            },
            // the following functions correlate to their namesake in SearchObject
            // behind the scenes, a new SearchObject is created for each one.
            // NOTE: autocomplete_fn -> autocomplete_sync
            search_fn: {},
            search_row_fn: {},
            rate_fn: {},
            group_fn: {},
            autocomplete_fn: {},
            // strict is used to signify whether or not the search function will
            // 'fall through' to the default search function or not
            strict_columns: {/*<selector>: true/false*/}, // NotImplemented
            disable_fallback_dom_search: false
        },
        // preconfigure: function(that, internal) {},
        // postconfigure: function(that, internal) {},
        // preload: function(that, internal) {}, // in preload, ext_hdr_items placeholder is not
        //                                       // available yet
        // preinit: function(that, internal) {},
        postinit: function(that, internal) {
            var config, state, search_box, clear_button;
            //, t$ = $.proxy(that.find, that);
            config = internal.core.config;
            config.search.default_search_obj = defaultSearchObjectFactory(config);
            state = internal.core.state.search;
            if (state == null) { state = internal.core.state.search = {}; }

            search_box = get_or_create_search_box(that, config);
            clear_button = get_or_create_clear_button(that, config);
            if (!search_box || !search_box.length ||
                !clear_button || !clear_button.length) { return; }

            if (state.current_query != null && (state.current_query !== search_box.val() ||
                    !search_box.is(document.activeElement))) {
                search_box.val(state.current_query);
            }
            // originally, the search timeout was done manually, but the debounce
            // jQuery plugin has a better implementation. The naive
            // settimeout/cleartimeout implementation would result in freezes
            // (caused by inefficiencies in adjust_table), to compound, locking
            // the user interface in older browsers.
            var debounced_trigger_search_timeout = $.debounce(
                    config.search.change_timeout,
                    function(that) { that.trigger('search.timeout'); }),
                search_activate_focus_timeout,
                search_activate_handler = function(event) {
                    // note that most browsers will automatically focus on the first text input on
                    // the page upon page load; possibly add something to mitigate this effect
                    if (!event.isTrigger) {
                        window.clearTimeout(search_activate_focus_timeout);
                        search_box.off(_namespacify_events('focus click keydown', 'activate'));
                        // trigger the event asynchronously
                        window.setTimeout($.proxy(that, 'trigger', 'search.activated'), 5);
                    }
                };
            search_box
                // TODO: detect html5 support and use native support
                //       (incremental=incremental, ::search-cancel-button, etc instead
                //       of all of this wizardry)
                .off('keypress.' + ext_this.config_path)
                .off('keyup.' + ext_this.config_path)
                .off('keydown.' + ext_this.config_path)
                .off(_namespacify_events('focus click', 'activate'))
                .on('keypress.' + ext_this.config_path, function(event) {
                    if (event.which === $.ui.keyCode.ENTER) { return; }
                    var that = $(this);
                    if (event.which === $.ui.keyCode.ESCAPE ||
                        event.keyCode === $.ui.keyCode.ESCAPE) {
                        window.setTimeout(function() {
                            that.val('').trigger('search.enterkey');
                        }, 5);
                        return;
                    }
                    debounced_trigger_search_timeout.call(this, that);
                })
                // 'keypress' doesn't fire on backspace, so we use keyup to trigger it
                .on('keyup.' + ext_this.config_path, function(event) {
                    if (event.which === $.ui.keyCode.BACKSPACE ||
                        event.which === $.ui.keyCode.DELETE) {
                        search_box.triggerHandler('keypress', event);
                    }
                })
                .on('keydown.' + ext_this.config_path, function(event) {
                    window.setTimeout(function() {
                        clear_button.toggle(search_box.val().length > 0);
                    }, 5);
                    if (event.which !== $.ui.keyCode.ENTER) { return; }
                    // trigger search.enterkey, clear timeout so search.timeout doesn't fire
                    var that = $(this), timeout_id;
                    timeout_id = that.data('search.timeout');
                    if (timeout_id != null) { window.clearTimeout(timeout_id); }
                    that.data('search.timeout', undefined);
                    window.setTimeout($.proxy(that, 'trigger', 'search.enterkey'), 5);
                    // that.trigger('search.enterkey');
                })
            // set up the 'search.activated' event -- used as a trigger for pre-fetching data
            // for advanced searching
                .on(_namespacify_events('click keydown', 'activate'), search_activate_handler);
            // the browser will automatically focus the search box, but we don't want to activate
            // on that
            search_activate_focus_timeout = window.setTimeout(function() {
                search_box.on(_namespacify_events('focus', 'activate'), search_activate_handler);
            }, 200);

            clear_button.off('click.search')
            .on('click.search', function() {
                search_box.val('').trigger('search.enterkey');
                clear_button.hide();
            });

            set_disabled(that, internal, true, search_box);
            return { config: config.search, state: state, search_box: search_box };
        },
        postload: function(that, internal) {
            var config, container, search_box;
            config = internal.core.config;
            container = get_container(that, config);
            search_box = get_or_create_search_box(that, config, container);
            set_disabled(that, internal, false, search_box);
        },
        get_formatted_cell: function(that, internal_core, get_column_value) {
            var config = internal_core.config.search;

            if (config.highlight) {
                return get_highlighter(that, internal_core, get_column_value).get_formatted_cell;
            }
            return get_column_value;
        },
        get_formatted_category_header: function(that, internal_core, get_column_value) {
            var config = internal_core.config.search;

            if (config.highlight) {
                return get_highlighter(that, internal_core, get_column_value)
                    .get_formatted_category_header;
            }
            return get_column_value;
        },
        get_filter_fn: function(that, internal_core, filter_fn) {
            var source = internal_core.config.source;
            if (internal_core.state == null || internal_core.state.search == null) {
                // This shouldn't happen, but does on the policy page, likely due to bad
                // asynchronous control flow
                return filter_fn;
            }
            var current_results = internal_core.state.search.current_results;
            function search_filter_fn(entry, filters) {
                return ((current_results == null || $.inArray(entry, source) in current_results) &&
                        filter_fn(entry, filters));
            }
            return search_filter_fn;
        }
    };

    /////////////////////////
    // Exports
    // TODO: could be put on a different object
    $.extend($.qlist.ext.objectSearch, {
        SearchObject: SearchObject,
        declare: declareSearchObject,
        caseInsensitiveSearchObject: caseInsensitiveSearchObject,
        domSearchObjectFactory: domSearchObjectFactory,
        get_highlighter: get_highlighter
    });

})(jQuery);
// TODO: declare dependancies between modules if dependencies are used in module init code

// minimalist epeli.github.com/underscore.string, with wrapping
(function(fweb) {
    'use strict';

    function count(substr) {
        /* jshint validthis:true */
        return this._str.split(substr).length - 1;
    }
    function _s(str) {
        return { _str: str,
            count: count
        };
    }
    fweb._s = _s;
})(window.fweb || (window.fweb = {}));
;(function(module) {
    if (this.fweb == null) { this.fweb = {}; }
    if (this.fweb.address_search == null) { this.fweb.address_search = {}; }
    module(this, this.fweb.address_search);
}).call(this, function(global, exports) {
    'use strict';

    var $ = global.jQuery;
    var goog = global.goog;
    var RegExpCommon = global.RegExpCommon;

    var _s = global.fweb._s;

    // require('./understring.js')
    // goog.require('goog.math.Integer');
    // goog.require('goog.net.IpAddress');
    var subnet = (function() {

        function subnet_first(address, mask) {
            var mask_raw = mask.toNumber();
            var shift_amount = address.getVersion() === 6 ? 128 - mask_raw : 32 - mask_raw;
            return address.toInteger()
                    .shiftRight(shift_amount)
                    .shiftLeft(shift_amount);
        }

        function subnet_last(address, mask) {
            var mask_raw = mask.toNumber();
            var shift_amount = address.getVersion() === 6 ? 128 - mask_raw : 32 - mask_raw;
            return address.toInteger()
                    .shiftRight(shift_amount)
                    .add(goog.math.Integer.ONE)
                    .shiftLeft(shift_amount)
                    .subtract(goog.math.Integer.ONE);
        }
        function subnet_contains(subnet_address, mask, address) {
            var addr_int = address.toInteger();
            return addr_int.greaterThanOrEqual(subnet_first(subnet_address, mask)) &&
                    addr_int.lessThanOrEqual(subnet_last(subnet_address, mask));
        }

        function subnet_intersect(a_address, a_mask, b_address, b_mask) {
            return subnet_contains(a_address, a_mask, subnet_first(b_address, b_mask)) ||
                subnet_contains(a_address, a_mask, subnet_last(b_address, b_mask)) ||
                subnet_contains(b_address, b_mask, subnet_first(a_address, a_mask)) ||
                subnet_contains(b_address, b_mask, subnet_last(a_address, a_mask));
        }

        function between(start, end, value) {
            return value.greaterThanOrEqual(start) && value.lessThanOrEqual(end);
        }

        function range_contains(first, last, value) {
            if (goog.isFunction(first.toInteger)) { first = first.toInteger(); }
            if (goog.isFunction(last.toInteger)) { last = last.toInteger(); }
            if (goog.isFunction(value.toInteger)) { value = value.toInteger(); }
            return between(first, last, value);
        }

        function range_intersect(a_first, a_last, b_first, b_last) {
            if (goog.isFunction(a_first.toInteger)) { a_first = a_first.toInteger(); }
            if (goog.isFunction(a_last.toInteger)) { a_last = a_last.toInteger(); }
            if (goog.isFunction(b_first.toInteger)) { b_first = b_first.toInteger(); }
            if (goog.isFunction(b_last.toInteger)) { b_last = b_last.toInteger(); }
            return between(a_first, a_last, b_first) ||
                    between(a_first, a_last, b_last) ||
                    between(b_first, b_last, a_last) ||
                    between(b_first, b_last, a_last);
        }

        return {
            first: subnet_first,
            last: subnet_last,
            contains: subnet_contains,
            intersect: subnet_intersect,
            range_contains: range_contains,
            range_intersect: range_intersect
        };
    })();

    /////////////////////////
    // IPv6

    // this should be called _before_ being checked against the ipv6 regex
    function fudge_v6_partial(str) {
        if (RegExpCommon.IP6_HOST.test(str) ||
                RegExpCommon.IP6_SUBNET.test(str)) {
            return str;
        }
        // move around ":"'s to get it close to a ipv6 address
        if (str.indexOf('::') > -1) {
            if (str[str.length - 2] !== ':' && str[str.length - 1] === ':') {
                return str.substr(str.length - 1);
            }
            return str;
        }
        if (str[str.length - 1] === ':') {
            return str + ':';
        }
        return str + '::';
    }

    var ip6_object = {
        // preprocess_query: TODO
        search: function(entry, query) {
            var _ref, matches, address, mask, query_address, query_mask;
            query = fudge_v6_partial(query);
            _ref = entry.indexOf('/');
            address = goog.net.IpAddress.fromString(entry.substring(0, _ref));
            mask = goog.math.Integer.fromString(entry.substring(_ref + 1));

            if (RegExpCommon.IP6_HOST.test(query)) {
                // match if the entry-range contains the query-host
                matches = subnet.contains(address, mask, goog.net.IpAddress.fromString(query));
                return matches ? [true] : [];
            } else if (RegExpCommon.IP6_SUBNET.test(query)) {
                _ref = query.indexOf('/');
                query_address = goog.net.IpAddress.fromString(query.substring(0, _ref));
                query_mask = goog.math.Integer.fromString(query.substring(_ref + 1));
                // match if the entry-range intersects the query-range
                matches = subnet.intersects(address, mask, query_address, query_mask);
                return matches ? [true] : [];
            }
            return [];
        }
    };

    /////////////////////////
    // IPv4

    // this should be called _after_ being checked against IP_HOST_PARTIAL
    function ip_v4_partial_to_range(str) {
        // fudges a partial ipv4 address to a IP_RANGE
        var remaining = 3 - _s(str).count('.');
        var first = str, last = str;
        if ((str.length - str.lastIndexOf('.')) <= 1) {
            first += '0';
            last += '255';
        }
        for (; remaining > 0; remaining -= 1) {
            first += '.0';
            last += '.255';
        }
        return first + '-' + last;
    }

    // Handles ip ranges that match IP_SUBNET, IP_RANGE, IP_RANGE2, IP_WILDCARD
    function ip4_range_calculate(str) {
        var _ref, address, mask, mask_str, mask_int;
        // IP_SUBNET allows 3 different notations
        if (RegExpCommon.IP_SUBNET.test(str)) {
            _ref = str.indexOf('/');
            if (_ref < 0) { // x.x.x.x
                address = goog.net.IpAddress.fromString(str);
                return [address, address];
            }
            mask_str = str.substring(_ref + 1);
            if (RegExpCommon.IP_MASK.test(mask_str)) { // x.x.x.x/m.m.m.m
                mask_int = goog.net.IpAddress.fromString(mask_str).toInteger();
                // When the object is cloned (returned from IpAddress.toString),
                // IE8 doesn't include toString when the properties are
                // enumerated, so whenever we need to call toString, we have to
                // manually attach it back on (or use Function.call)
                // see http://docs.closure-library.googlecode.com/git/namespace_goog.html#goog.mixin
                mask_int.toString = goog.math.Integer.prototype.toString;
                mask = goog.math.Integer.fromNumber(mask_int.toString(2).lastIndexOf('1') + 1);
            }
            else { // x.x.x.x/n
                mask = goog.math.Integer.fromString(mask_str);
            }
            address = goog.net.IpAddress.fromString(str.substring(0, _ref));
            return [subnet.first(address, mask), subnet.last(address, mask)];
        }
        if (RegExpCommon.IP_RANGE.test(str) || RegExpCommon.IP_RANGE_SPACES.test(str)) {
            _ref = str.split('-');
            return [goog.net.IpAddress.fromString(_ref[0].trim()),
                    goog.net.IpAddress.fromString(_ref[1].trim())];
        }
        if (RegExpCommon.IP_RANGE2.test(str)) {
            _ref = IP_RANGE2_GROUPS.exec(str);
            return [goog.net.IpAddress.fromString(_ref[1] + _ref[2]),
                    goog.net.IpAddress.fromString(_ref[1] + _ref[3])];
        }
        if (RegExpCommon.IP_WILDCARD.test(str)) {
            return [goog.net.IpAddress.fromString(str.replace('*', '0')),
                    goog.net.IpAddress.fromString(str.replace('*', '255'))];
        }
    }

    // TODO: wrap with more intelligent logic for more general use
    var ip4_basic_search = function(entry_ranges, query) {
        var _ref, query_address, query_first, query_last, range, first, last, matches;
        if (RegExpCommon.IP_HOST.test(query)) {
            query_address = goog.net.IpAddress.fromString(query);
        } else if (IP_HOST_PARTIAL.test(query)) {
            query = ip_v4_partial_to_range(query);
        }
        if (query_address == null) {
            _ref = ip4_range_calculate(query);
            if (_ref == null) { // query is not a ip4 address
                return [];
            }
            query_first = _ref[0]; query_last = _ref[1];
        }

        // TODO: change this to only use one range, and wrap functionally
        //       for multiple ranges
        range = entry_ranges[0];
        first = range[0];
        last = range[1];

        if (query_address == null) {
            matches = subnet.range_intersect(first, last, query_first, query_last);
        } else {
            matches = subnet.range_contains(first, last, query_address);
        }
        return matches ? [[true]] : [];
    };

    var IP_HOST_PARTIAL = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){1,2}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])?\.?$/;

    var IP_RANGE2_GROUPS = /^([^\[]+)\[(\d+)-(\d+)\]/;

    var ip4_object = {
        // preprocess_query: TODO
    };

    // search functions for dealing directly with cmdb objects
    var cmdb = {
        firewall: {
            address: function(data, query) {
                var range, range_str;
                switch (data.type) {
                    case 'iprange':
                        range = [
                            goog.net.IpAddress.fromString(data['start-ip']),
                            goog.net.IpAddress.fromString(data['end-ip'])];
                        break;
                    case 'ipmask':
                        range_str = data.address ||
                            (data.subnet != null ? data.subnet.replace(' ', '/') : null);
                        if (range_str != null) { range = ip4_range_calculate(range_str); }
                        break;
                    case 'wildcard': //TODO -> Wildcard Addressing
                        // http://help.fortinet.com/fos50hlp/50/index.html#context/fgt/address
                        // FIXME: temporarily treating wildcard as a mask
                        range_str = data.address ||
                            (data.subnet != null ? data.subnet.replace(' ', '/') : null);
                        if (range_str != null) { range = ip4_range_calculate(range_str); }
                        break;
                    default: // 'geography', 'fqdn'
                        return [];
                }
                if (range == null || range[0] == null) { return []; }
                return ip4_basic_search([range], query);
            }
        }
    };

    $.extend(exports, {
        // const's
        IP_HOST_PARTIAL: IP_HOST_PARTIAL,
        IP_RANGE2_GROUPS: IP_RANGE2_GROUPS,
        // utilities
        subnet_util: subnet,
        ip6_partial_fudge: fudge_v6_partial,
        ip4_partial_to_range: ip_v4_partial_to_range,
        ip4_range_calculate: ip4_range_calculate,
        ip4_basic_search: ip4_basic_search,
        // search objects
        ip6: ip6_object,
        ip4: ip4_object,
        cmdb: cmdb
    });
});
/**
qlist extension for highlighting filter results
TODO: column header filters should be completely moved out of qlist core and
      moved into a plugin like this; this plugin should be integrated into that
      plugin
*/

(function($) { // $ = jQuery
    // can we have underscore/lodash yet? -- this implements _.findWhere
    var _findWhere = function(arr, attrs) {
        var result = null;
        arr.some(function(value) {
            for (var key in attrs) {
                if (attrs[key] !== value[key]) { return false; }
            }
            result = value;
            return true;
        });
        return result;
    };
    var CONFIG_PATH;
    var resolve_config = $.qlist._ext.resolve_config;
    $.qlist.ext.filterHighlight = {
        staticDepends: ['objectSearch'],
        depends: [],

        config_path: (CONFIG_PATH = 'column_filters.highlight'),
        managed: true,
        defaults: {
            enabled: false,
            highlight_color: null,
            highlight_class: 'filter-highlight'
        },
        core_defaults: {},

        get_formatted_cell: function(that, internal_core, get_column_value) {
            var filter_settings, get_highlighter, highlighter, search_obj;

            filter_settings = internal_core.fn.get_filter_settings();
            get_highlighter = $.qlist.ext.objectSearch.get_highlighter;
            highlighter = get_highlighter(that, internal_core, get_column_value);
            highlighter.set_config(resolve_config(internal_core.config, CONFIG_PATH));
            search_obj = $.qlist.ext.objectSearch.caseInsensitiveSearchObject;

            return function(td, selector, entry) {
                var rval = get_column_value(td, selector, entry),
                    origval = entry[selector],
                    flt, match, searchmatch;
                if ($.type(origval) === 'number') { origval = ''+origval; }

                flt = _findWhere(filter_settings, { id: selector });
                //if (flt != null) {
                if (flt != null && !flt.default_filter) {//support deault filter
                    match = [];
                    if(flt.logic.NOT) { // Fix bug: 0458850
                        searchmatch = [0, null];
                        match.push(searchmatch);
                    } else {
                        $.each(flt.value, function(i, rawvalue) {
                            // TODO: move this splitting function/regex to a common location
                            //       and ensure that it is synchronized with the
                            //       splitting regex in py:logs.views.FilterProcessor._process_filter
                            //       OR
                            //       if filter highlighting of server side filters is desired,
                            //       pass back pre-parsed filters in the ajax call
                            $.each(flt.logic.OR || flt.logic.search === 'string' ? [rawvalue] :
                                    rawvalue.split(/"([^\"]*)"|'([^']*)'|\s/).filter(
                                    function(val){ return val != null && val.trim(); }),
                                function(i, value) {
                                // $.merge(match,
                                //     search_obj.search(origval, search_obj.preprocess_query(value)));
                                // Fix bug 0459213
                                if(rval == escapeHTML(origval))
                                    $.merge(match, search_obj.search(rval, search_obj.preprocess_query(escapeHTML(value))));
                                else
                                    $.merge(match, search_obj.search(origval, search_obj.preprocess_query(value)));
                            });
                        });
                    }
                    if (match.length < 1) {
                        // the filter didn't match, yet it's in the results
                        // therefore, it's either an error or an advanced match
                        // (assume it's an advanced match)
                        if ($.type(origval) === 'string') {
                            searchmatch = [0, null];
                            searchmatch.source = origval;
                            match.push(searchmatch);
                        }
                    }
                    return highlighter.robust_highlight_cell(
                        match, rval, origval, td);
                }
                return rval;
            };
        }
    };
})(jQuery);
    /**
qlist extension to allow setting the right clicked item as the filter
*/

/*global FIELD_TYPE
Notify*/

/* TODO: monkey patch YAHOO.widget.MenuManager to add menuadded/removed events
and remove events from qed_menu:__init_qmenu_generic */

// language entries are in lang/en:filter

(function($) { // $ = jQuery
    'use strict';

    // TODO: codify this instance pattern into the core of qlist._ext

    function FilterContextMenu($ql, internal) {
        /** @type {jQuery} */
        this.$ql = $ql;
        /** @type {qlist_obj} */
        this.old_qlist = null;
        /** @type {$.qlist~defaults} */
        this.core_config = internal.core.config;
        /** @type {$.qlist.ext.filterContextMenu.defaults} */
        this.config = _resolve(internal.core.config, CONFIG_PATH);

        /** @type {$.qlist~_ext_internal_functions} */
        var internal_fns = internal.core.fn;
        this._get_filter_columns = internal_fns.get_filter_columns;
        this._get_filter_settings = internal_fns.get_filter_settings;
        this._add_filter = internal_fns.add_filter;
        this._apply_filter = internal_fns.apply_filter;
        this._get_column_value = internal_fns.get_column_value;

        /** @type {boolean|null} */
        this.owns_yui_contextmenu = null;
        /** @type {YAHOO.widget.ContextMenu} */
        this.yui_contextmenu = null;
        /** @type {YAHOO.widget.MenuItem} */
        this.yui_menu_item = null;

        this._bound_events = {};
    }

    // initialize our menus during the qlist postinit phase
    FilterContextMenu.prototype.postinit = function(internal) {
        this.old_qlist = internal.core.qlist;
        this.owns_yui_contextmenu = this.old_qlist.disable_context_menu;
        this.setup_contextmenu();
    };

    FilterContextMenu.prototype.setup_contextmenu = function() {
        // In order to reduce reliance on bad encapsulation code in qed_menu.js,
        // this manages its own YAHOO.MenuItem
        var tb_id = this.old_qlist.id;

        // TODO: idea: date/time columns could have
        //       "set day as filter", "set hour as filter", and "set minute as filter"
        this.yui_menu_item = new YAHOO.widget.MenuItem(
            $.getInfo("context_set_filter"), { lazyload: true });

        if (this.owns_yui_contextmenu) {
            this.yui_contextmenu = new YAHOO.widget.ContextMenu(
                'tbmenu_' + tb_id, {trigger: tb_id, lazyload: true});
            this.bind_menu_item_click_handler();
            this.yui_contextmenu.addItem(this.yui_menu_item);
            this.yui_contextmenu.render($j('#' + tb_id).parent()[0]);
            this.bind_contextmenu_beforeShow_handler();
        }
        // We don't add the menuitem to a pre-existing context menu since qlist
        // managed context menus are regenerated for each right click. So we
        // must add the menu_item for each "tbody_context" call
    };

    // TODO: refactor this function along with filterConsole and
    //       python:FilterProcessor, to unify the filter code
    // TODO: test this function. It covers a lot of edge cases.
    FilterContextMenu.prototype.set_qlist_filter = function(index, selector) {
        // get data and filter metadata
        var rawvalue = this.core_config.source[index][selector];
        var filter_columns = this._get_filter_columns();
        var flt = $._filterConsole.getFilterByField(selector, filter_columns);
        var value, value_end, datevalue, datestr, timestr;

        var oflt = {
            id: selector,
            value: null,
            logic: {}
        };

        // preprocess the data so that the filter won't choke
        // TODO: clean up duplicate code in filterConsole.js:getSecFilter,
        //       move this code to a common function

        if (flt._field_type === FIELD_TYPE.DATE ||
                flt._field_type === FIELD_TYPE.DATE_TIME ||
                flt.is.date) {
            if ($.type(rawvalue) === 'number') {
                datevalue = fweb.util.localDateSeconds(rawvalue);
            } else {
                try {
                    datevalue = $.datepicker.parseDate("yy-mm-dd", rawvalue);
                } catch (e) {
                    datevalue = new Date(rawvalue);
                }
            }

            datestr = $.datepicker.formatDate('yy-mm-dd', datevalue);
            // TODO: set the date in minutes if it's within the last hour,
            //       hours if it's the current day
            //       and days if longer than that.
            // timestr = moment(datevalue).format('hh:mm');
            timestr = $.pad(datevalue.getHours()) + ':' + $.pad(datevalue.getMinutes());
            value     = datestr + ' ' + timestr + ':00';
            value_end = datestr + ' ' + timestr + ':59';

            oflt.value = [value, value_end];
            oflt.logic.RANGE = 1;
            oflt.is = $.extend(oflt.is || {}, { date: 1 });
        } else {
            if ($.type(rawvalue) === 'number') {
                rawvalue = ''+rawvalue;
            }
            if ((flt._field_type === FIELD_TYPE.STRING ||
                // what other field types should be treated like this?
                flt._field_type === FIELD_TYPE.ENUM
                ) &&
                    $.type(rawvalue) === 'string') {
                if (rawvalue.indexOf(' ') > 0) {
                    value = '"' + rawvalue + '"';
                } else {
                    value = rawvalue;
                }
            } else {
                // TODO: if it's an object, call getValue or something
                value = this._get_column_value(null, selector, this.core_config.source[index]);
                if ($.type(value) !== 'string') { value = rawvalue; }
                else {
                    if (value.indexOf('<') >= 0) {
                        // get_column_value returned html
                        if ($.type(rawvalue) === 'string') {
                            value = rawvalue;
                        } else {
                            value = $(value).text();
                        }
                    }
                }
            }
            oflt.value = [value];
        }
        if (value === undefined) {
            Notify.post($.getInfo('context_no_value'));
            return;
        }
        // TODO: validate the value
        // if (value == null || !flt.validate(value)) {
        //     SHOW AN ERROR MESSAGE; return;
        // }

        // apply the filter to the actual qlist.
        var flt_arr = this._get_filter_settings();
        oflt.logic.is = flt.is;
        flt_arr = this._add_filter(flt_arr, oflt);
        this._apply_filter(flt_arr);
    };

    FilterContextMenu.prototype.get_preexisting_yui_contextmenu = function() {
        // TODO: it's possible to add 2 ... (see above)
        // return null;
        // another flag that could be used is `this.core_config.options.disable_context_menu`
        if (this.old_qlist.ctxt_menu instanceof YAHOO.widget.ContextMenu) {
            return this.old_qlist.ctxt_menu;
        }
        var window_ctxt_menus;
        if (window.PC != null && (window_ctxt_menus = window.PC.CtxtMenus) != null) {
            // TODO: don't hardcode the prefix if possible
            return window_ctxt_menus['tbmenu_' + this.old_qlist.id];
        }
    };

    // TODO: these two functions could be in a qlist util namespace
    FilterContextMenu.prototype._get_index = function($el) {
        var $tr = $el.closest('tr');
        if ($tr.length < 1) { return -1; }
        return $tr.data('sourceIndex');
    };

    FilterContextMenu.prototype._get_selector = function($el) {
        var $td = $el.closest('td');
        if ($td.length < 1) { return null; }
        // TODO: could also double check that this is the right column, since
        //       the selector is added to the cell as a css class.
        return this.core_config.chosen_columns[$td.index()];
    };

    FilterContextMenu.prototype._is_disabled_for = function($el) {
        var selector = this._get_selector($el);
        if (selector === null) { return true; }
        var index = this._get_index($el);
        if (index < 0) { return true; }
        // TODO: check if the column is disabled for filtering
        if ($.inArray(selector, this.core_config.column_filters.exempts) >= 0 ||
            $.inArray(selector, this.core_config.column_filters.context_menu.exempts) >= 0) {
            return true;
        }
        return false;
    };

    //// EVENT HANDLERS
    FilterContextMenu.prototype.bind_contextmenu_beforeShow_handler = function() {
        this._unsubscribe('beforeShow', '_contextmenu_beforeShow_handler', this.yui_contextmenu);
        // if there's no existing default beforeShow handler, add one to
        // select the element that's being right clicked.
        var that = this;

        this._contextmenu_beforeShow_handler = function(/*this=YUI MenuItem */) {
            var $el = $(this.contextEventTarget);
            var index = that._get_index($el);
            var selector = that._get_selector($el);
            var rawvalue = that.core_config.source[index][selector];

            that.yui_menu_item.cfg.setProperty("text", (
                $.getInfo("context_set_filter") + ": " + $.getInfo(selector) + "=" + rawvalue
            ));

            if (that._is_disabled_for($el)) {
                return false; // don't show the context menu at all
            }
            $el.closest('tr').trigger('click');
        };
        this._add_subscription('beforeShow', '_contextmenu_beforeShow_handler', this.yui_contextmenu);
    };

    FilterContextMenu.prototype.bind_menu_item_click_handler = function() {
        this._unsubscribe('click', '_menu_item_click_handler', this.yui_menu_item);
        var that = this;
        this._menu_item_click_handler = function() {
            // `this` is the YUI MenuItem
            var $contextEventTarget = $(this.parent.contextEventTarget);
            var sourceIndex = that._get_index($contextEventTarget);
            var selector = that._get_selector($contextEventTarget);
            if (sourceIndex != null && sourceIndex >= 0 && selector != null) {
                // setTimeout so that YUI doesn't swallow exceptions
                // eqivalent sync call: that.set_qlist_filter(sourceIndex, selector);
                window.setTimeout(
                    $.proxy(that, 'set_qlist_filter', sourceIndex, selector), 5);
            }
        };
        this._add_subscription('click', '_menu_item_click_handler', this.yui_menu_item);
    };

    // event handling utility functions; YUI event subscriptions are a bit of trouble sometimes
    FilterContextMenu.prototype._add_subscription = function(eventName, handlerName, target) {
        target.subscribe(eventName, this[handlerName]);
        this._bound_events[handlerName] = { target: target, eventName: eventName };
    };

    FilterContextMenu.prototype._unsubscribe = function(eventName, handlerName, target) {
        if (this[handlerName] != null) {
            target.unsubscribe(eventName, this[handlerName]);
        }
    };

    FilterContextMenu.prototype._unsubscribe_all = function() {
        var key, entry;
        for (key in this._bound_events) {
            entry = this._bound_events[key];
            this._unsubscribe(entry.eventName, key, entry.target);
        }
    };

    // proxy from jquery.qlist.js:tbody_context
    FilterContextMenu.prototype.tbody_context = function(evt) {
        if (!this.owns_yui_contextmenu) {
            var menu = this.yui_contextmenu = this.get_preexisting_yui_contextmenu();
            this.bind_menu_item_click_handler();
            this.yui_menu_item.cfg.setProperty("disabled",
                this._is_disabled_for($(menu.contextEventTarget)));
            menu.addItem(this.yui_menu_item);
        }
    };

    FilterContextMenu.prototype.destroy = function() {
        this._unsubscribe_all();

        if (this.yui_contextmenu != null) {
            if (this.owns_yui_contextmenu) {
                this.yui_contextmenu.destroy();
            } else if (this.yui_menu_item != null) {
                this.yui_menu_item.destroy();
            }
        }
        this._bound_events = {};

        // ensure any circular references are broken - not necessary, but worthwhile.
        this.$ql = null;
        this.old_qlist = null;
        this.core_config = null;
        this.config = null;
        this._get_filter_columns = null;
        this._get_filter_settings = null;
        this._add_filter = null;
        this._apply_filter = null;
        this._get_column_value = null;
        this.owns_yui_contextmenu = null;
        this.yui_contextmenu = null;
        this.yui_menu_item = null;
    };

    // TODO: move into a public spot
    function _resolve_set(parent, path, value) {
        var parts = path.split('.'), _len = parts.length, current, i;
        for (i = 0; i < _len - 1; i++) {
            current = parts[i];
            if (parent[current] == null) { parent[current] = {}; }
            parent = parent[current];
        }
        parent[parts[_len - 1]] = value;
        return value;
    }

    var CONFIG_PATH;
    var _resolve = $.qlist._ext.resolve_config;
    $.qlist.ext.filterContextMenu = {
        staticDepends: ['filterConsole'/*not a extension, I'm just declaring this*/],
        depends: [],
        config_path: (CONFIG_PATH = 'column_filters.context_menu'),
        managed: true,
        defaults: {
            enabled: false
        },
        preload: function(that, internal) {
            // load language resources
            $j.addLang("lang/", "filter");

            var old_state = _resolve(internal.core.state, CONFIG_PATH);
            if (old_state != null && old_state.destroy != null) { old_state.destroy(); }
            _resolve_set(internal.core.state, CONFIG_PATH, new FilterContextMenu(that, internal));
        },
        postinit: function(that, internal) {
            _resolve(internal.core.state, CONFIG_PATH).postinit(internal);
        },

        tbody_context: function(that, internal_core, tbody_context) {
            return function(evt) {
                var rval = tbody_context.call(this, evt);
                _resolve(internal_core.state, CONFIG_PATH).tbody_context(evt);
                return rval;
            };
        }
    };
})(jQuery);
/**
qlist-cell-collection

meta-formatting plugin

This plugin defines an extended model for formatting cells in a qlist, and uses
that model to provide a format function that allows rendering of a list of
items in a single cell

Usage:

{
    format_fn: {
        my_selector: {
            type: 'cell-collection',
            format_item: function(td, column, data) { return data.name; }, // or something like this.
            format_title: function(td, column, data) { return JSON.stringify(data); }, // the tooltip
            display_count: 'other_selector' // automatically add the count to this column.
                           // Adds the following to the formatter
                           // `$qlist.qlist('getCellCollectionFormatter', 'my_selector').formatCount(...)`
        }
    }

    For selective formatting (only apply formatting to a subset of rows):

    format_fn: {
        my_selector: {
            type: 'cell-collection',
            requires_key': 'some-key' // key that must exist in row in order to apply formatting
            format_item: function(td, column, data) { return data.name; },
            format_title: function(td, column, data) { return JSON.stringify(data); }
            format_fallback: function(td, column, row) {} // fallback function if key doesn't exist
        }
    }
}

This will be translated to
{
    format_fn: {
        my_selector: <bind>CellCollectionFormatter#format_fn,
        other_selector: format_fn.other_selector + CellCollectionFormatter#formatCount
    }
}
where CellCollectionFormatter#format_item = format_fn.my_selector.format_item

*/

/*global escapeHTML*/
;(function(module) {
    module(this);
}).call(this, function(global) {
'use strict';

var $ = global.jQuery;
var fweb = global.fweb;
var util = global.fweb.util;
var setCookie = global.setCookie;
var getCookie = global.getCookie;
var removeCookie = global.removeCookie;
var declareSearchObject = $.qlist.ext.objectSearch.declare;

/*const*/ var FORMAT_FN_ID = 'cell-collection';
var _resolve = $.qlist._ext.resolve_config;
var EVENT_NAMESPACE = 'qlistCellCollection';
var SETTINGS_COOKIE_NAME = 'qlist_cell_collection';
var namespaced = fweb.util.namespacifyEvents(EVENT_NAMESPACE);
var DEFAULT_ROWS, DEFAULT_COLUMNS;
var CSS_CLASS_PREFIX = 'qlist-cell-collection-';

var COLUMN_CSS_CLASSES = [
    null,
    CSS_CLASS_PREFIX + '1-col',
    CSS_CLASS_PREFIX + '2-col',
    CSS_CLASS_PREFIX + '3-col',
    CSS_CLASS_PREFIX + '4-col',
    CSS_CLASS_PREFIX + '5-col',
    CSS_CLASS_PREFIX + '6-col',
    CSS_CLASS_PREFIX + '7-col',
    CSS_CLASS_PREFIX + '8-col',
    CSS_CLASS_PREFIX + '9-col',
    CSS_CLASS_PREFIX + '10-col',
    CSS_CLASS_PREFIX + '11-col',
    CSS_CLASS_PREFIX + '12-col',
];

// Templates
var T = {};
T._item = $.validator.format(
    '<span class="qlist-cell-collection-item {2}"{1}>{0}</span>'
);
//'<span class="qlist-cell-collection-item {2}"{% if $1 != null %} title="{1}"{% endif %}>{0}</span>';
T.item = function(text, title /*, ...args*/) {
    var __slice = [].slice, _args = arguments;
    text = text || '';
    title = (title != null) ? $.validator.format(' title="{0}"', title) : '';
    return T._item.apply(this, [text, title].concat(__slice.call(_args, 2)));
};
var _is_nth_child_supported = null;

//'{% for i in range(start, stop) %}';
//'{{ T.item(..., list[i], COLUMN_CSS_CLASSES[that.columns]) }}';
//'{% endfor %}';
T.itemList = function(that, scope, list, start, stop) {
    if (_is_nth_child_supported === null) { _is_nth_child_supported = util.isNthChildSelectorAvailable(); }
    var i, _len, _maxlen, member, css_classes, _ref;
    var out = '';
    // for member in list.slice(start, stop)
    for (i = start, _len = list.length,
            _maxlen = stop != null ? Math.min(_len, stop) : _len;
            i < _maxlen && (member = list[i], true); ++i) {
        css_classes =
            // TODO: possibly set the column css class on the td rather than on every single item
            COLUMN_CSS_CLASSES[that.columns];
        if (!_is_nth_child_supported && (i % that.columns) === 0) {
            css_classes += ' qlist-cell-collection-first-item';
        }
        out += T.item(
            that.format_item_highlighted(scope.td, scope.col, member, scope.sourceIndex,
                (_ref = scope.filteredIndicies) == null ? i : _ref[i]),
            that.format_title != null ? that.format_title(scope.td, scope.col, member) : null,
            css_classes
        );
    }

    return out;
};
// TODO: find better looking sprites for this purpose.
T._anchor_display_more = '<img src="'/*/' + fweb.CONFIG_GUI_NO */+ '/theme/images/twistie_collapsed.gif" />' +
                         ' {% lang "display_more" %}';
T._anchor_display_less = '<img src="'/*/' + fweb.CONFIG_GUI_NO */+ '/theme/images/twistie_expanded.gif" />' +
                         ' {% lang "display_less" %}';
T.anchor_display_more = util.lazy(util.j2translate, T._anchor_display_more);
T.anchor_display_less = util.lazy(util.j2translate, T._anchor_display_less);
T.placeholder = util.lazylazy($.validator.format, util.lazy(util.j2translate,
    // <-- may need a column-count class
    '<span class="qlist-cell-collection-placeholder">' +
    '<a class="js-action qlist-cell-collection-morelink" data-qcc-selector="{2}">' +
    T._anchor_display_more +
    '</a> {% lang "cell_collection_amounts" %}' + // lang["cell_collection_amounts"] contains {0} and {1} placeholders
    '</span>'
));
T.placeholder_filtered = util.lazylazy($.validator.format, util.lazy(util.j2translate,
    '<span class="qlist-cell-collection-placeholder-filtered qlist-cell-collection-item">' +
    '{% lang "cell_collection_filtered" %}</span>'));
T.column_option_title = function(column) {
    return $.validator.format($.getInfo('col_options'), $.getInfo(column.lang_key)); };
T.menuDialog = util.lazylazy($.validator.format, util.lazy(util.j2translate,
'<form class="dlg qlist-cell-collection-dlg">' +
'    <div class="field">' +
'        <label for="qlist-cell-collection-dlg-columns">{% lang "number_of_sub_columns" %}</label>' +
'        <input type="number" name="columns" id="qlist-cell-collection-dlg-columns" ' +
'               class="required" min="1" max="12" value="{0}">' +
'    </div>' +
'    <div class="field">' +
'        <label for="qlist-cell-collection-dlg-rows">{% lang "number_of_sub_rows" %}</label>' +
'        <input type="number" name="rows" id="qlist-cell-collection-dlg-rows" ' +
'               class="required" min="1" max="100" value="{1}">' +
'    </div>' +
'</form>'));

/**
 * Class that manages the format function for _each_ column that is a member column
 * @param {jQuery} $ql
 * @param {$.qlist~_ext_internal} internal
 * @param {object} formatter_definition the object set as the format function (see file header)
 */
function CellCollectionFormatter($ql, internal, formatter_definition, my_selector) {
    // formatter_definition is the object stored under format_fn
    this.format_item = formatter_definition.format_item;
    // TODO: don't make tojson the default
    var _ref_ft;
    this.format_title = (_ref_ft = formatter_definition.format_title) !== undefined ? _ref_ft :
        function(td, col, member) { return escapeHTML(JSON.stringify(member)); };

    // selective formatting
    this.format_requires_key = formatter_definition.requires_key;
    this.format_fallback = formatter_definition.format_fallback;
    this.selective_formatting = (this.format_requires_key !== undefined) &&
        (typeof this.format_fallback === 'function');

    /** @type {$.qlist.ext.filterContextMenu.defaults} */
    this.config = _resolve(internal.core.config, CONFIG_PATH);
    this.core_config = internal.core.config;

    this.rows = this._default_rows = formatter_definition.rows || this.config.rows;
    this.columns = this._default_columns = formatter_definition.columns || this.config.columns;
    this.count_selector = formatter_definition.display_count;
    this.count_format_fn = null;
    this.count_template = $.validator.format(formatter_definition.count_template ||
        '<em>{0} {1}</em>');
    this.count_requires_key = formatter_definition.count_requires_key;
    this.allow_no_member = (formatter_definition.allow_no_member != null) ?
                           formatter_definition.allow_no_member : true;

    this._count = -1; this._update_count();
    this._selector = my_selector;

    var _ref;
    this.getCollection =
        (_ref = formatter_definition.source_fn) != null ? _ref :
        (_ref = this.data_selector = formatter_definition.selector) != null ?
        function(index, col, row) { return row[_ref]; } :
        function(index, col, row) { return row[col.selector]; };

    this.yui_header_context_menu = null;
    this.yui_header_menu_item = null;

    this.qtip_settings = formatter_definition.qtip;
}
CellCollectionFormatter.prototype.type = FORMAT_FN_ID;

// damn ie8
try {
    Object.defineProperty(CellCollectionFormatter.prototype, 'count', {
        get: function() { this._update_count(); return this._count; }
    });
} catch (e) {}

CellCollectionFormatter.prototype._update_count = function() { this._count = this.rows * this.columns; };

// TODO: if perf issues arise, don't filter the same collection twice; figure out a good way to cache the result

/**
 * Standard format function that wraps the format_item function defined in the page
 */
CellCollectionFormatter.prototype.format_fn = function(td, col, row) {
    var selector = col.selector;
    if (td === null) { return this.getCollection(null, col, row); }

    // selective formatting
    if (this.selective_formatting && row[this.format_requires_key] === undefined) {
        return this.format_fallback(td, col, row);
    }

    var $td = $(td);
    var sourceIndex = $td.closest('tr').data('sourceIndex');
    var collection = this.getCollection(sourceIndex, col, row);

    var _ref = this.filterCollection(collection, selector, sourceIndex);
    var filtered = _ref[0], filteredIndicies = _ref[1];

    var is_filtered = filtered !== collection && filtered.length != collection.length;
    $td.css('white-space', 'normal');

    var out = T.itemList(this, {td: td, col:col, row:row, sourceIndex: sourceIndex, filteredIndicies: filteredIndicies},
        filtered, 0, this._count);

    if (out === '' && !this.allow_no_member) {
        out = '<span class="a_sprite tool_warning">' +
              $.getInfo('Unexpected empty value') +
              '</span>';
        $td.addClass('left');
    }

    var _len = filtered.length;
    if (_len > this._count) {
        out += T.placeholder(/*lazy*/)(_len - this._count, _len, escapeHTML(selector));
    }
    if (is_filtered) {
        out += T.placeholder_filtered()(collection.length);
    }
    return out;
};

/** overridden below */
CellCollectionFormatter.format_item_highlighted = function(member, col, row, sourceIndex) {
    return this.format_item(member, col, row);
};

/**
 * Format function to display the hidden elements
 * @param  {jQuery} $a       jQuery wrapped anchor element
 * @param  {string} selector key of the column
 * @param  {object} row
 * @return {string}          formatted output
 */
CellCollectionFormatter.prototype.format_rest_fn = function($a, selector, row) {
    var $td = $a.closest('td');
    var sourceIndex = $td.closest('tr').data('sourceIndex');
    var collection = this.getCollection(sourceIndex, { selector: selector }, row);
    var _ref = this.filterCollection(collection, selector, sourceIndex);
    var filtered = _ref[0], filteredIndicies = _ref[1];
    var out = '<div>' +
        T.itemList(this, {
                td: $td, col: { selector: selector }, row: row,
                sourceIndex: sourceIndex, filteredIndicies: filteredIndicies
            }, filtered, this._count) +
        '</div>';
    return out;
};

/** overridden below */
CellCollectionFormatter.prototype.filterCollection = function(collection) { return [collection /*, indicies*/]; };

CellCollectionFormatter.prototype.applySettings = function(settings) {
    this.columns = settings.columns || DEFAULT_COLUMNS;
    this.rows = settings.rows || DEFAULT_ROWS;
    this._update_count();
};
CellCollectionFormatter.prototype.resetSettings = function() {
    this.applySettings({
        rows: this._default_rows,
        columns: this._default_columns
    });
};
// used for name columns of various lists with member columns
CellCollectionFormatter.prototype.getCollectionLength = function(td, col, row) {
    var sourceIndex = $(td).closest('tr').data('sourceIndex');
    var collection = this.getCollection(sourceIndex, { selector: this._selector }, row);
    if (collection != null) { return collection.length; }
};

CellCollectionFormatter.prototype.formatCount = function(td, col, row) {
    // TODO: bump this up to a proper template, as above (T.*)
    return this.count_template(this.getCollectionLength(td, col, row),
        $j.getInfo(this.core_config.column_map[this._selector].lang_key));
};

CellCollectionFormatter.prototype.transformCountFormatter =
function(source_format_fn_obj, target_format_fn_obj) {
    if ($.type(this.count_selector) !== 'string') { return false; }
    var this_ = this;
    var orig_format_fn = source_format_fn_obj[this.count_selector] || source_format_fn_obj['*'];
    // TODO: construction of this decorator could be generalized
    target_format_fn_obj[this.count_selector] = this.count_format_fn = function(td, col, row) {
        var value = orig_format_fn.apply(this, arguments);
        var exlude_row = (this_.selective_formatting && row[this_.format_requires_key] === undefined) ||
            (this_.count_requires_key !== undefined && row[this_.count_requires_key] === undefined);
        // TODO: support returned jquery objects, if needed
        if (!exlude_row) {
            value += this_.formatCount(td, col, row);
        }
        return value;
    };
    this.count_format_fn.__wraps__ = orig_format_fn;
    return true;
};

/** Class that manages all of the CellCollectionFormatter instances */
function CellCollectionExtension($ql, internal) {
    this.$ql = $ql;
    this.internal = internal;
    this.formatters = {};
    this.config = _resolve(internal.core.config, CONFIG_PATH);
}

/**
 * Manipulate the qlist's `format_fn` if the "function" is an object conforming
 * to our specification. See the file header comment for more details.
 *
 * If we need more meta-formatters, this function should be abstracted out, and moved
 * into a library extension (this is why dependancies can be defined for extensions)
 */
CellCollectionExtension.prototype.transformFormatters = function() {
    if (Object.keys(this.formatters).length > 0) {
        (window.console || { log: $.noop }).log('WARNING: reinitializing CellCollectionExtension formatters');
    }
    this.formatters = {};
    var new_format_fn = {};
    var this_ = this;
    // TODO: rather than manipulating the format_fn config variable, refactor
    //       jq.qlist.js so that the format functions are cached. It's more
    //       extensible and faster, and easier to write an extension hook.
    //       http://jsperf.com/control-flow-patterns
    $.each(this.internal.core.config.format_fn, function(key, value) {
        var formatter;
        if ($.isPlainObject(value)) {
            if (value.type === FORMAT_FN_ID) {
                formatter = this_.newFormatter(key, value);
                new_format_fn[key] = $.proxy(formatter, 'format_fn');
                new_format_fn[key].context = formatter;
                formatter.transformCountFormatter(
                    this_.internal.core.config.format_fn, new_format_fn);
            }
        }
    });
    $.extend(this.internal.core.config.format_fn, new_format_fn);
};

CellCollectionExtension.prototype.setupDisplayMoreQtips = function() {
    var this_ = this;
    var $link = this.$ql.find('a.qlist-cell-collection-morelink');

    $link
    .each(function(i, el) {
        // TODO: make sure that qtip doesn't re-initialize.
        var $el = $(el);
        var $td = $el.closest('td');
        var selector = $el.data('qcc-selector');

        // TODO: deepextend instead of the following, but make sure that critical parts don't get overridden
        var formatter_qtip_settings = this_.formatters[selector].qtip_settings;
        var _ref;
        var custom_show_handler, custom_render_handler;
        if (formatter_qtip_settings != null) {
            custom_show_handler = ((_ref = formatter_qtip_settings.events) != null ? _ref.show : null) || $.noop;
            custom_render_handler = ((_ref = formatter_qtip_settings.events) != null ? _ref.render : null) || $.noop;
        } else { custom_show_handler = custom_render_handler = $.noop; }

        $el.qtip({
            style: { classes: 'qlist-cell-collection-qtip', width: $td.width(), def: false,
                // hide the triangle tip callout as much as possible.
                // TODO: see if the qtip `tip` plugin can be selectively disabled.
                tip: {
                    corner: 'bottom left',
                    height: 1,
                    width: 1
                }
            },
            show: 'click',
            hide: 'click unfocus',

            content: {
                // TODO: see if this function can be evaluated on demand, rather than as an IIFE
                text: (function() {
                    // var $this = $(this); // use this as `this` if evaluated on demand.
                    // var selector = $this.data('qcc-selector');
                    var $this = $el;
                    var row = this_.internal.core.config.source[$this.closest('tr').data('sourceIndex')];
                    var formatted = $(this_.formatters[selector].format_rest_fn($this, selector, row));
                    return formatted;
                })(),
                button: 'Close'
            },
            position: {
                my: 'top left',
                at: 'bottom left',
                target: $td,
                adjust: { y: 1, x: -1 }
            },
            events: {
                render: custom_render_handler,
                show: custom_show_handler,
                toggle: function(event) {
                    var switch_ = event.type === 'tooltipshow';
                    // keep styling consistent when the "display more" dropdown is displayed
                    $el.closest('tr').toggleClass('fakehover', switch_);
                    $el.html(switch_ ? T.anchor_display_less() : T.anchor_display_more());
                    // this could be in a show handler, but was easier to add here
                    if (switch_) {
                        var $link = $(event.originalEvent.target);
                        resizeQtipTo($link, $link.closest('td'), true);
                    }
                }
            }
        });
    })
    // don't select the row when the "display more" link is displayed
    .off(EVENT_NAMESPACE)
    .on(namespaced('click'), function(event) { event.stopPropagation();});

    // set up resize handlers to keep the qtip the same as the column's width.
    // TODO: see if setting the qtip container to a child node of the cell
    //       and using CSS wizardry could remove the need for this.
    var resizeQtipTo = function($qtiphost, target, skipVisibleCheck) {
        var api = $qtiphost.qtip('api');
        if (api != null && api.rendered && (skipVisibleCheck || api.elements.tooltip.is(':visible'))) {
            api.set('style.width', target.outerWidth() - 1);
        }
    };

    $link.closest('td').add(window)
    .off(EVENT_NAMESPACE)
    // TODO: if performance becomes an issue, dynamically bind this handler when
    //       the qtip is shown / unbind when hidden
    .on(namespaced('resize'),
        function() { var $this;
            if ($.isWindow(this)) {
                $link.each(function(i, link) { var $link = $(link);
                    resizeQtipTo($link, $link.closest('td'));
                });
            } else { $this = $(this);
                resizeQtipTo($this.find('a.qlist-cell-collection-morelink'), $this);
            }
        }
    );
};

CellCollectionExtension.prototype.setupMenu = function(yui_header_context_menu, aMenuItems) {
    var formatters_keys = Object.keys(this.formatters);
    if (formatters_keys.length < 1) {
        // TODO: issue a warning.
        return;
    }
    var this_ = this;

    // TODO: this currently only supports one cell-collection column per qlist
    //       add a submenu if suppport is needed for multiple column options. YAGNI.
    this._primary_column_selector = formatters_keys[0];

    /** @type {CellCollectionFormatter} */
    var formatter = this.formatters[this._primary_column_selector];
    var column = this.internal.core.config.column_map[this._primary_column_selector];

    this.yui_header_context_menu = yui_header_context_menu;
    // var yui_header_menu_item = this.yui_header_menu_item = new YAHOO.widget.MenuItem(
    // yui_header_context_menu.addItem(
    aMenuItems[aMenuItems.length - 1].unshift({
        id: this.internal.core.config.prefix + '-' + this._primary_column_selector + '-columnOption',
        classname: 'columnSettings menu_sprite tool_column',
        text: T.column_option_title(column),
        onclick: {
            fn: fweb.util.reportExceptions(function(eventname, events, menuitem) {
                // TODO: since this option dialog may contain other options in the future, create and extension
                //       that controls an option dialog, and make this depend on it. See bottom comment for how to do this.
                var $dialog = fweb.dialog(T.menuDialog()(formatter.columns, formatter.rows), {
                    title: T.column_option_title(column),
                    buttons: fweb.util.templates.dlg_btn_ui(function() {
                        var $form = $dialog.find('form');
                        if ($form.valid()) {
                            this_.saveAndApplySettings(this_._primary_column_selector, this_.serializeSettings($form));
                            $dialog.dialog('close');
                        }
                    }),
                    chain: true
                });
                yui_header_context_menu.hide();
                // TODO: dialog setup and such.
                return false;
            }),
            scope: this
        }
    });
    // yui_header_context_menu.addItem(yui_header_menu_item);
};

/* TODO: write helpers to remove redundant/generalizable settings code */
CellCollectionExtension.prototype.serializeSettings = function($form) {
    return {
        columns: +$form.find('input[name=columns]').val(),
        rows: +$form.find('input[name=rows]').val()
    };
};
CellCollectionExtension.prototype.loadSettings = function() {
    var settingsObj = JSON.parse(getCookie(SETTINGS_COOKIE_NAME));
    var _ref;
    for (var selector in settingsObj) {
        if (settingsObj.hasOwnProperty(selector)) {
            _ref = this.formatters[selector];
            if (_ref != null) {
                /* ES6:
                let { rows: rows, columns: columns } = settingsObj[selector];
                _ref.applySettings({ rows, columns });
                */
                var $__0 = settingsObj[selector], rows = $__0.rows, columns = $__0.columns;
                _ref.applySettings({
                    rows: rows,
                    columns: columns
                });
            }
        }
    }
};
CellCollectionExtension.prototype.saveAndApplySettings = function(column_selector, settings) {
    this.formatters[column_selector].applySettings(settings);
    var settingsObj = {};
    for (var selector in this.formatters) {
        if (this.formatters.hasOwnProperty(selector)) {
            /* ES6:
            let { rows: rows, columns: columns } = formatters[selector];
            settingsObj[selector] = { rows, columns };
            */
            var $__0 = this.formatters[selector], rows = $__0.rows, columns = $__0.columns;
            settingsObj[selector] = {
                rows: rows,
                columns: columns
            };
        }
    }
    setCookie(SETTINGS_COOKIE_NAME, JSON.stringify(settingsObj));
    this.internal.core.fn.qlistRefreshTable();
};
CellCollectionExtension.prototype.resetSettings = function() {
    removeCookie(SETTINGS_COOKIE_NAME);
    var _ref;
    for (var selector in this.formatters) {
        if (this.formatters.hasOwnProperty(selector)) {
            _ref = this.formatters[selector];
            if (_ref != null) { _ref.resetSettings(); }
        }
    }
};

CellCollectionExtension.prototype.newFormatter = function(selector, defn) {
    var formatter = new CellCollectionFormatter(this.$ql, this.internal, defn, selector);
    this.formatters[selector] = formatter;
    return formatter;
};

// TODO: see if it's worthwhile to add destroy methods to clear circular references.

var CONFIG_PATH;
$.qlist.ext.cellCollection = {
    depends: [],

    config_path: (CONFIG_PATH = 'options.cell_collection_formatter'),
    managed: true,
    defaults: {
        _instance: null, // this should _not_ be set manually
        enabled: false,
        rows: (DEFAULT_ROWS = 6),
        // heavily dependant on CSS
        // TODO: create css rules supporting different amounts of columns, either set
        //       manually (cell-collection-n-col) or automatically (media/element queries)
        columns: (DEFAULT_COLUMNS = 4),
        show_options: true
    },
    commands: {
        getCellCollectionFormatter: function(that, internal_core, selector) {
            /** @type {CellCollectionExtension} */
            var instance = _resolve(internal_core.config, CONFIG_PATH)._instance;
            return instance.formatters[selector];
        }
    },

    preconfigure: function(that, internal) {
        $.addStyle(
            /*"/" + fweb["CONFIG_GUI_NO"] + */"/css/jquery.qtip.css");
        $.addStyle(
            /*"/" + fweb["CONFIG_GUI_NO"] + */"/css/dlg.css");

        var config = _resolve(internal.core.config, CONFIG_PATH);
        if (config.enabled && config.show_options) {
            internal.core.config.options.column_context_menu = true;
        }
    },
    postconfigure: function(that, internal) {
        // called after the config variable is modified for a whole bunch
        // of various reasons

        // TODO: create an extension that will manage this kind of format_fn
        //       customization for multiple sub-extensions.
        // IDEA: extensions that predefine format functions, and so the config
        //       can just use a string to use them.
        // TODO: implement a better, more extensible format_fn lookup in jq.qlist.js
        var config = _resolve(internal.core.config, CONFIG_PATH);
        var oldinstance = config._instance;

        if (oldinstance != null) { return oldinstance; }

        // TODO: support reconfiguration. This will require modification in qlist core

        config._instance = new CellCollectionExtension(that, internal);
        config._instance.transformFormatters();
        config._instance.loadSettings();

        // TODO: add a search function that will search within the hidden elements
        return config._instance;
    },
    preload: function(that, internal) {
        that.off(namespaced('reset_columns')).on(namespaced('reset_columns'), function() {
            _resolve(internal.core.config, CONFIG_PATH)._instance.resetSettings();
        });
    },
    postload: function(that, internal) {
        var instance = _resolve(internal.core.config, CONFIG_PATH)._instance;
        instance.setupDisplayMoreQtips();
        return instance;
    },
    before_header_context_menu_render: function(that, internal, yui_header_context_menu, headMenus) {
        var config = _resolve(internal.core.config, CONFIG_PATH);
        var instance = config._instance;
        if (config.show_options) {
            instance.setupMenu(yui_header_context_menu, headMenus);
        }
        return instance;
    }
};

// SEARCH SUPPORT -- could be moved to a different file

var SEARCH_CONFIG_PATH = $.qlist.ext.objectSearch.config_path;

CellCollectionFormatter.prototype.getSearchState = function() {
    var _ref = this.config._instance.$ql.data('qlist_state');
    if (_ref != null) { return _resolve(_ref, SEARCH_CONFIG_PATH); }
};

CellCollectionFormatter.prototype.getOwnSearchResults = function(selector, sourceIndex) {
    var searchState = this.getSearchState();
    if (searchState == null ||
            searchState.current_results == null ||
            searchState.current_results[sourceIndex] == null ||
            searchState.current_results[sourceIndex][selector] == null) {
        return null;
    }
    var collectionSearchResults;
    $.each(searchState.current_results[sourceIndex][selector], function(index, searchResult) {
        if (searchResult._is_collection_result) { collectionSearchResults = searchResult; return false; }
    });
    return collectionSearchResults || null;
};

CellCollectionFormatter.prototype.filterCollection = function(collection, selector, sourceIndex) {
    var collectionSearchResults = this.getOwnSearchResults(selector, sourceIndex);
    if (collectionSearchResults == null) { return [collection, null]; }
    var i = 0, filteredIndicies = [];
    var filtered = $.grep(collection, function(item, index) {
        var matches = index in collectionSearchResults;
        if (matches) {
            filteredIndicies[i] = index;
            i++;
        }
        return matches;
    });
    return [filtered, filteredIndicies];
};

CellCollectionFormatter.prototype.newSearchObject = function() {
    var this_ = this;
    var parentSearchObject = $.qlist.ext.objectSearch.caseInsensitiveSearchObject;
    var collectionSearchFunction = function(list, target, index, selector) {
        var i, _len, member, match, formatted;
        // rather than returning the standard match object format, this is a custom
        // format that stores the search results for each item in the collection
        var matchObject = { _is_collection_result: true };
        var foundSomething = false;

        _len = Array.isArray(list) ? list.length : 0;
        for (i = 0; i < _len; ++i) {
            member = list[i];
            formatted = this_.format_item(null, { selector: selector }, member);
            match = parentSearchObject.search(formatted, target, index, selector);
            if (match && match.length > 0) {
                foundSomething = true;
                match.source = formatted;
                // store the matched result based on the index of the item in the collection
                matchObject[i] = match;
            }
        }
        return foundSomething ? [matchObject] : [];
    };

    var collectionSearchObject = declareSearchObject({
        preprocess_query: parentSearchObject.preprocess_query,
        search: collectionSearchFunction
    });
    return collectionSearchObject;
};

CellCollectionExtension.prototype.extendSearchObject = function() {
    if (this._searchObj != null) { return; } // already initialized.
    var formatter, collectionSearchObject = {}, _ref;

    for (var selector in this.formatters) {
        if (this.formatters.hasOwnProperty(selector)) {
            formatter = this.formatters[selector];
            if ((_ref = collectionSearchObject[selector]) == null) {
                _ref = collectionSearchObject[selector] = [];
            }
            _ref.push(formatter.newSearchObject());
        }
    }
    this._searchObj = collectionSearchObject;
    util.extend_merge(
        _resolve(this.internal.core.config, SEARCH_CONFIG_PATH).search_obj,
        collectionSearchObject);
};

CellCollectionFormatter.prototype.isHighlightingEnabled = function() {
    // TODO: cache appropriately.
    return _resolve(this.config._instance.$ql.data('config'), SEARCH_CONFIG_PATH).highlight;
};

CellCollectionFormatter.prototype.format_item_highlighted = function(member, col, row, sourceIndex, memberIndex) {
    var formatted = this.format_item(member, col, row);
    if (!this.isHighlightingEnabled()) { return formatted; }
    var collectionSearchResults = this.getOwnSearchResults(col.selector, sourceIndex);
    if (collectionSearchResults == null) { return formatted; }
    return this.config._instance.highlighter.robust_insert_highlighting_spans(
        collectionSearchResults[memberIndex], formatted, formatted);
};

CellCollectionExtension.prototype.initHighlighter = function() {
    this.highlighter = $.qlist.ext.objectSearch.get_highlighter(this.$ql, this.internal.core, null);
};


$.qlist.ext.cellCollectionSearch = {
    depends: ['cellCollection', 'objectSearch'],
    config_path: CONFIG_PATH,
    // TODO: in qlist._ext core, automatically load/unload managed extensions if
    //       their dependancies are enabled/disabled
    managed: 'auto',
    // defaults: piggy-backs on cellCollection
    postconfigure: function(that, internal) {
        var cellCollection = internal.cellCollection;
        cellCollection.extendSearchObject();
        cellCollection.initHighlighter();
    }
};

});

/*
Instructions for abstracting out the option dialog

Change this extension's configuration like so:
depends: ['columnOption']

Create a new qlist.ext with the configuration of
$.qlist.ext.columnOption = {
    config_path: "column_option_dialog"
    postconfigure: function(...) {
        return new ColumnOption(...);
    }
}
function ColumnOption(...) {
    this.children = ...
    ...
}
ColumnOption.prototype.setupMenu = function(...) { ... } // see above setupMenu function
... callbacks, etc.

Then, CellCollectionExtension instances will have access to a ColumnOption
instance via this.internal.columnOption, and other extensions can access it via
internal.columnOption in the postconfigure callback (and other callbacks; just
make sure to return the columnOption instance in all of the columnOption extension's
callbacks)
*/
;(function(global, body) {
    body(jQuery);
})(this, function($) {

/**
 * Fires an event when the set of filtered results is empty.
 * Used so that external code can then retrieve more data from the server
 * in order to satisfy the filter.
 */
$.qlist.ext.emptyFilteredResultsEvent = {
    config_path: 'emptyFilteredResultsEvent',
    managed: true,
    defaults: { enabled: false },
    postload: function(that, internal) {
        var internal_core = internal.core;
        var filterSettings = internal_core.fn.get_filter_settings();
        if (filterSettings.length === 0) { return; }

        var complete_filter_fn = internal_core.fn.get_complete_filter_fn(
            that, internal_core.config, internal_core.state);

        if (internal_core.fn.get_filtered_lines(complete_filter_fn) === 0) {
            var emptyFilteredResultsEvent =
                $.Event('emptyFilteredResults');
            that.trigger(emptyFilteredResultsEvent, [filterSettings, {
                sourceLength: internal_core.config.source.length }]);
        }
    }
};

});
/*
 *  common cell formater plugin for qlist
 */
/* global jQuery,truncate_comment, escapeHTML */
(function($) {
    'use strict';

   /**
     * Creates a cached set of meta information about an interface,
     * including name, alias and type.
     */
    var interface_meta_lookup = (function() {
        var params = {
            'format': 'name|alias|description|type'
        };
        var base_url = '/api/v2/cmdb/system/interface/';
        var interfaces = {};

        function lookup_interface(intf_name) {
            return $.ajax({
                url: base_url + intf_name,
                cache: false,
                dataType: 'json',
                data: params
            });
        }

        return function(intf_name, callback) {
            if (!intf_name) {
                return;
            }

            if (!interfaces[intf_name]) {
                interfaces[intf_name] = lookup_interface(intf_name);
            }

            interfaces[intf_name].done(function(r) {
                interfaces[intf_name].result = r.results[0];
                callback(r.results[0]);
            });
            //return the interface name if available (for search)
            return interfaces[intf_name].result;
        };
    })();

    /**
     * Format the provided interface name, resolving the interface alias (if
     * available). Interface comments will be added as a tooltip if present in
     * the configuration.
     */
    var interface_format_fn = function(td, column, entry) {
        var intf_name = entry[column.selector];

        interface_meta_lookup(intf_name, function(intf) {
            var name = intf_name;
            var title = intf.description || name;
            var value;

            if (intf.alias) {
                name += ' (' + intf.alias + ')';
            }

            if (intf.type) {
                value = '<span class="tool_sprite interface_sprite tool_' +
                    intf.type + '" ' + 'title="' + title + '">' + name + '</span>';
            } else {
                value = name;
            }

            td.html(value);
        });

        return td ? '' : intf_name;
    };

    var format_fn = {

        /* truncate comment length > 28 and display '...' */
        'comment': function(td, col, entry) {
            var val = entry[col.selector];
            // origin val for filtering, or html for render
            return td ? truncate_comment(val) : val;
        },

        /* display cmdb ref number */
        'q_ref': function(td, column, entry) {
            var val = entry[column.selector];
            return td ? '<a class="qlist_ref" href="#">' + val + '</a>' : val;
        },

        /* status icon */
        'q_status': function(td, column, entry) {
            var val = entry[column.selector];
            if (!td) { return; }
            /* jshint -W116 */
            // force convert to boolean, '0' -> false
            var state = val == true ? 'up' : 'down';
            return '<a class="a_sprite tool_' + state + '"></a>';
        },

        /* generic formatters for source and destination interfaces */
        'srcintf': interface_format_fn,
        'dstintf': interface_format_fn,

        /*
         * This is the default format function for qlists
         * The HTML created here should focus on being semantic
         * without a lot of formatting. If you need specialized HTML, use a
         * custom formatting function in your qlist options.
         * output will be escaped unless override by format_fn[x] = $.noop
         */
        '*': function(td, column, element) {
            var selector = column.selector;
            var raw = element[selector];
            if (!td) { return raw; }
            // html render
            var render = escapeHTML;
            // array render
            if ($.isArray(raw) && raw.length > 0) {
                var _ul_str = '<ul class="qlist_obj_list"><li>';
                return _ul_str + $.map(raw, function(x) {
                    if ($.isPlainObject(x) && 'name' in x) {
                        var cls = x['css-class'] || '';
                        return '<span class="' + cls + '">' + render(x.name) + '</span>';
                    }
                    return '<span>' + render(x) + '</span>';
                }).join('</li><li>') + '</li></ul>';
            }
            // value render
            return render(raw);
        }
    };

    format_fn.comments = format_fn.description = format_fn.comment;

    $.extend($.qlist.format_fn, format_fn);

})(jQuery);
/* globals jQuery, fweb, require */
(function($, fweb) {
    'use strict';

    $.qlist.menu_items = {
        /**
        * Augments a qlist config object with menu items that navigate to a 'create policy' page
        * with a policy that will block the value of that column.
        * @param {Object} block_map map object where keys represent columns in the
        *   current qlist, values are the field which should be supplied to the. Each key
        *   will be added as menu item to block the value in that column of the selected row(s)
        * @param {Object} [config] Qlist config object to augment
        *   policy dialog.
        * @param {Object} [selector_map] (reverse) selector map (policy_selector -> entry_selector)
        *   - {dstintf: 'sel1', srcintf: 'sel2'}
        *   - A map of policy page properties -> properties of the entries from the qlist source
        *   that can be used to fill them. 'dstintf' and 'srcintf' will be used otherwise.
        * @returns config.menu_items or a new object with menu items
        */
        add_policy_block_items: function(block_map, config, selector_map, which) {
            var f_events = fweb.util.events;
            var menu_items = config && config.menu_items || {};
            var columns = Object.keys(block_map);
            //quarantine menu item(s) should go first
            if (!which || which === 'quarantine') {
                columns.forEach(add_quarantine);
            }
            if (!which || which === 'block') {
                //not supported in 5-2
                columns.forEach(add_menu_item);
            }
            return menu_items;

            function add_menu_item(column) {
                var block = block_map ? block_map[column] : column;
                var url = '/p/firewall/policy';
                /* jshint scripturl: true */
                menu_items['block_' + column] = {
                    url: 'javascript: void 0',
                    'class': 'tool_deny',
                    label: $.getInfo('Policy::Block::' + block),
                    handler: f_events.reportExceptions(function(q) {
                        //TODO: deal with policy6 46 46
                        var entries = get_entries(q, column);
                        var is_ipv6 = RegExp.prototype.test.bind(/:/);
                        if (entries.length > 0) {
                            var addresses = entries.map(pluck(column));
                            var six = is_ipv6(addresses[0]) ? '6' : '';
                            if (six && !addresses.every(is_ipv6) ||
                                    !six && addresses.some(is_ipv6)) {
                                require(['notify'], function(Notify) {
                                    Notify.post($.getInfo('Unable to create a policy with ' +
                                        'mixed ipv4 and ipv6 addresses'), 'error');
                                });
                                return;
                            }
                            var settings = [
                                {
                                    path: 'firewall', name: 'address' + six,
                                    selector: entries.length > 1 ? undefined : block,
                                    values: entries.map(make_address)
                                }, {
                                    selector: block === 'srcaddr' ? 'dstaddr' : 'srcaddr',
                                    values: ['all']
                                }, {
                                    selector:'service',
                                    value: 'ALL'
                                }, {
                                    selector: 'paction',
                                    value: 'deny'
                                }, {
                                    selector: 'srcintf',
                                    values: ['any']
                                }, {
                                    selector: 'dstintf',
                                    values: ['any']
                                }
                            ];
                            if (entries.length > 1) {
                                settings.push({
                                    path: 'firewall', name: 'addrgrp' + six,
                                    selector: block,
                                    values: [{
                                        cls: 'icon_fw addr_grp_0',
                                        //TODO: come up with a better name scheme?!
                                        name: $.getInfo('Policy::Block::addrgrp {ID}',
                                            [new Date().getTime()]
                                        ),
                                        member: entries.map(make_addrgrp_member)
                                    }]
                                });
                            }
                            selector_map = selector_map || {};
                            var param = 'block=' + encodeURIComponent(JSON.stringify(settings));
                            six = six ? '/' + six : '';
                            if (top.main) {
                                top.main.location.href =  url + six + '/edit/?' + param;
                            } else {
                                top.location.href = url + six + '/edit/?' + param;
                            }
                        }
                    })
                };

                function make_addrgrp_member(entry) {
                    return {
                        name: $.getInfo('Policy::Block::' + block + ' {ADDRESS}', [entry[column]])
                    };
                }
                function make_address(entry) {
                        //Technically this is neither a cmdb firewall.address object or a
                        //p/firewall/policy/addresses object but it duck types as both!
                    return {
                        cls: 'icon_fw addr_range_0',
                        type: 'iprange',
                        'start-ip': entry[column],
                        'end-ip': entry[column],
                        name: $.getInfo('Policy::Block::' + block + ' {ADDRESS}', [entry[column]])
                    };
                }
            }

            function add_quarantine(column) {
                var intervals = {
                        'seconds': 1,
                        'minutes': 60,
                        'hours': 60 * 60,
                        'days': 60 * 60 * 24
                    },
                    dependency = 'data-enable-if-checked="! [name=quarantine_permanent]"',
                    template = fweb.util.dom.renderTemplate(
                        [
                            '<form id="{{ id }}">',
                            '<style type="text/css" rel="stylesheet">',
                            '#{{ id }} div { margin: 0.5ex auto }',
                            '#{{ id }} { text-align: right }',
                            '#{{ id }} .quarantine_duration { width: 6em }',
                            '#{{ id }} .{{ perm }} label, #{{ id }} .{{ perm }} input {',
                            '    vertical-align: middle;',
                            '}',
                            '</style>',
                            '<div><input type="number" min="1" name="quarantine_duration" ',
                            'class="depends quarantine_duration number" {{ dep }} value="30">',
                            '<select name="multiplier" class="depends" {{ dep }}>',
                            '{{ opts }}',
                            '</select></div>',
                            '<div class="{{ perm }}"><label for="{{ perm }}">{{ ban }}</label>',
                            '<input type="checkbox" name="{{ perm }}" id="{{ perm }}">',
                            '</div>',
                            '</form>'
                        ].join('\n'),
                        {
                            ban: $.getInfo('Permanent Ban'),
                            dep: dependency,
                            opts: Object.keys(intervals).map(make_option('minutes')).join('\n'),
                            perm: 'quarantine_permanent',
                            id: 'quarantine_menu_dialog'
                        }
                    );
                function make_option(selected) {
                    return function(interval) {
                        var selected_attr = selected === interval ?
                            ' selected="selected"' : '';
                        return '<option value="' + intervals[interval] + '" ' +
                            selected_attr + '>' + $.getInfo(interval) + '</option>';
                    };
                }
                var block = block_map ? block_map[column] : column;
                if (block !== 'srcaddr') {
                    return;
                }
                /* jshint scripturl: true */
                menu_items['quarantine_' + column] = {
                    url: 'javascript: void 0',
                    'class': 'tool_quarantine',
                    label: $.getInfo('Quarantine Source'),
                    handler: f_events.reportExceptions(function(q) {
                        var entries = get_entries(q, column),
                            $dlg, json;
                        if (entries.length > 0) {
                            json = {
                                ip_addresses: entries.map(pluck(column))
                            };
                            $dlg = fweb.dialog(template, {
                                title: $.getInfo('Quarantine Duration'),
                                open: open_dlg,
                                buttons: [{
                                    text: $.getInfo('ok'),
                                    click: ban
                                }, {
                                    text: $.getInfo('cancel'),
                                    click: close_dlg
                                }]

                            });
                        }
                        function open_dlg(event) {
                            $(event.target).ui_dependencies();
                        }
                        function ban() {
                            var result = $dlg.find('form')
                                .serializeArray().reduce(to_object, {});
                            if (result.quarantine_duration) {
                                json.expiry = result.quarantine_duration * result.multiplier;
                            }
                            close_dlg();
                            $.ajax({
                                url: '/api/v2/monitor/user/banned/add_users/',
                                type: 'POST',
                                dataType: 'json',
                                data: JSON.stringify(json)
                            }).then(success, failure);

                            function to_object(obj, value) {
                                obj[value.name] = value.value;
                                return obj;
                            }
                        }

                        function close_dlg() {
                            //no destroy yet?
                            $dlg.dialog('close').remove();
                        }

                    })
                };

                function success(result, jqxhr) {
                    if (result.status === 'error') {
                        failure(jqxhr, result.error);
                    } else {
                        require(['notify'], function(Notify) {
                            Notify.post($.getInfo('Source has been quarantined'));
                        });
                    }
                }

                function failure(jqxhr, status) {
                    require(['notify'], function(Notify) {
                        Notify.post(status, 'error');
                    });
                }
            }

            function pluck(key) { return function(obj) { return obj[key] } }

            function get_entries(q, column) {
                var source = config && config.source ||
                    //ugh
                    $(q.cur_elem).closest('.qlist-container').data('config').source;

                return q.get_checked_rows().get().map(function(row) {
                    return source[$(row).data('sourceIndex')];
                }).filter(deduplicate(column));

                function deduplicate(key) {
                    var exists = {};
                    return function(entry) {
                        if (exists[entry[key]]) {
                            return false;
                        }
                        exists[entry[key]] = entry;
                        return true;
                    };
                }
            }
        }
    };
})(jQuery, fweb);
