//EXPORT_SYMBOL auto_resize_popup


// Popup window auto-resize functions.

//EXPORT_SYMBOL auto_resize_popup

// The scrollbar fuzz is initially added to the window size to prevent
// the scrollbars from appearing, and then subtracted later.

// Perfect popups uses 200px of scrollbar fuzz, but the animated effect 
// looks really bad. Maybe that's needed for low res screens or something.
// 50px works fine for me.
var scrollbar_fuzz = 50;

// The resize margin is *outside* the div (otherwise the container table will
// look bad), so we have to adjust for it.
var rsz_div_margin = 5;


// resizeWinTo & getRefToDivMod - auto-resize a popup window to match a div
// which defines the client area. (Adapted from "Perfect Popups" reference code.)
function getRefToDivMod( divID, oDoc ) {
  if( !oDoc ) { oDoc = document; }
  if( document.layers ) {
    if( oDoc.layers[divID] ) { return oDoc.layers[divID]; } else {
      for( var x = 0, y; !y && x < oDoc.layers.length; x++ ) {
        y = getRefToDivMod(divID,oDoc.layers[x].document); }
      return y; } }
  if( document.getElementById ) { return oDoc.getElementById(divID); }
  if( document.all ) { return oDoc.all[divID]; }
  return document[divID];
}

function resizeWinTo( idOfDiv ) {
  var odiv = getRefToDivMod( idOfDiv ); if( !odiv ) { return false; }
  var oW = odiv.clip ? odiv.clip.width : odiv.offsetWidth;
  
  // customization (ASK): account for the margin around the div.
//  oW += rsz_div_margin;
  
  var oH = odiv.clip ? odiv.clip.height : odiv.offsetHeight; if( !oH ) { return false; }
  var x = window; x.resizeTo( oW + scrollbar_fuzz, oH + scrollbar_fuzz );
  var myW = 0, myH = 0, d = x.document.documentElement, b = x.document.body;
  if( x.innerWidth ) { myW = x.innerWidth; myH = x.innerHeight; }
  else if( d && d.clientWidth ) { myW = d.clientWidth; myH = d.clientHeight; }
  else if( b && b.clientWidth ) { myW = b.clientWidth; myH = b.clientHeight; }
  if( window.opera && !document.childNodes ) { myW += 16; }
  x.resizeTo( oW + ( ( oW + scrollbar_fuzz ) - myW ), oH + ( (oH + scrollbar_fuzz ) - myH ) );
}


// addAutosizingDiv - set the div style at runtime.
function setAutosizingDivStyle(oDiv, div_margin)
{
	oDiv.style.position = "absolute";
	oDiv.style.left = "0px";
	oDiv.style.top = "0px";
	oDiv.style.width = "auto";
	oDiv.style.border = "none";
	
	// customization (ASK): add a margin around the div.
	// (only do this when the <div> is automatically added)
	if (div_margin)
	{
		// NOTE: padding seems to work better than margin on IE
		oDiv.style.marginLeft = "" + div_margin + "px";
		oDiv.style.marginRight = "" + div_margin + "px";
	}

	try
	{
		// Mozilla only - recommended by Perfect Popups.
		oDiv.style.display = "block";
	}
	catch (e)
	{
		oDiv.style.display = "inline";
	}
}

// addAutosizingDiv - add the div to a popup at runtime.
// Note: this function is not always used, since it caused problems when used with forms.
function addAutosizingDiv()
{
	// First, check if it already exists.
	var oDiv = document.getElementById('autosizing_div');
	
	// Allow the owner page to specify the div in its preferred location. Otherwise,
	// insert a new one as a direct child of the <body>.
	if (oDiv)
	{
		setAutosizingDivStyle(oDiv, 0);
		return;
	}

	oDiv = document.createElement("DIV");
	oDiv.id = "autosizing_div";
	setAutosizingDivStyle(oDiv, rsz_div_margin);
	
	// Insert the new DIV between the BODY and the 1st level children.
	// TODO: is there a better way to do this than by moving all the children in turn?
	// (IE has a function "applyElement", but it doesn't seem to work in Mozilla.)
	// Warning: this function still has some bugs. For example, it caused some hidden form elements on
	// the console customize page to be moved out of the form. That's why it's not currently used there.

	var oHtml = get_last_child_of_type(document, "HTML");
	var oBody = get_last_child_of_type(oHtml, "BODY");
	
	while (oBody.childNodes.length)
	{
		oElem = oBody.removeChild(oBody.childNodes[0]);
		oDiv.appendChild(oElem);
	}
	
	oBody.appendChild(oDiv);
}

function auto_resize_popup()
{
	addAutosizingDiv();
	resizeWinTo('autosizing_div');
}
