var validateOpts = {
        ignore: ":hidden:not('.multiList-container:visible>input, .multiList-container:visible>select')",
	onkeyup: false,
	onfocusout: false,
	submitHandler: function(form) {
		form.submit();
	}
};

// standard rules
var standardRules = {
    "name": {
        nameRequired: true,
        XSSChecker: true
    }
};

//ipv4: firewall address, group and VIP, VIP group
var ipv4Rules = {
    "name": {
        nameRequired: true,
        XSSChecker: true,
        IdentifierChecker: true,
        DuplicateEntryChecker: [{
            "path": "firewall",
            "name": "address"
        },
        {   "path": "firewall",
            "name": "addrgrp"
        },
        {   "path": "firewall",
            "name": "vip"
        },
        {   "path": "firewall",
            "name": "vipgrp"
        }]
    }
};

//ipv6: firewall address and group
var ipv6Rules = {
    "name": {
        nameRequired: true,
        XSSChecker: true,
        IdentifierChecker: true,
        DuplicateEntryChecker: [{
            "path": "firewall",
            "name": "address6"
        },
        {   "path": "firewall",
            "name": "addrgrp6"
        }]
    }
};

//firewall service
var fwServiceNGroupRules = {
    "name": {
        nameRequired: true,
        XSSChecker: true,
        DuplicateEntryChecker: [{
            "path": "firewall.service",
            "name": "custom"
        },
        {
            "path": "firewall.service",
            "name": "explicit-web"
        },
        {   "path": "firewall.service",
            "name": "group"
        },
        {
            "path": "firewall.service",
            "name": "group-explicit-web"
        },
        {
            "path": "firewall.service",
            "name": "category"
        }]
    }
};

//firewall schedule
var fwSchedRules5 = {
    "name": {
        nameRequired: true,
        XSSChecker: true,
        DuplicateEntryChecker: [
            {
                "path": "firewall.schedule",
                "name": "group"
            },
            {
                "path": "firewall.schedule",
                "name": "onetime"
            },
            {   "path": "firewall.schedule",
                "name": "recurring"
            }
        ]
    }
};

//local user
var userLocalRules = {
    "name": {
        nameRequired: true,
        XSSChecker: true,
        DuplicateEntryChecker: [
            {   "path": "user",
                "name": "local"
            }
        ]
    }
};

//user group
var userGroupRules = {
    "name": {
        nameRequired: true,
        XSSChecker: true,
        DuplicateEntryChecker: [
            {   "path": "user",
                "name": "group"
            }
        ]
    },
    "def_exp" : {
        required: true,
        RangeChecker: [1, 365]
    }
};

//interface
var interfaceRules = {
    "name": {
        nameRequired: true,
        XSSChecker: true,
        DuplicateEntryChecker: [
            {   "path": "system",
                "name": "interface"
            }
        ]
    }
};
