
/* Copyright (c) 2006 Yahoo! Inc. All rights reserved. */

/**
 * @class a YAHOO.util.DDProxy implementation that swaps positions with the 
 * target when dropped
 *
 * @extends YAHOO.util.DDProxy
 * @constructor
 * @param {String} id the id of the linked element
 * @param {String} sGroup the group of related DragDrop items
 */
YAHOO.fortinet.DDSwap = function(id, sGroup, config) {
    this.swapInit(id, sGroup, config);
};

YAHOO.extend(YAHOO.fortinet.DDSwap, YAHOO.util.DDProxy);

YAHOO.fortinet.DDSwap.prototype.swapInit = function(id, sGroup, config) {
    if (!id) { return; }

    this.init(id, sGroup, config);
    this.initFrame();
    this.logger = this.logger || YAHOO;

    /**
     * css style to use when items are not being hovered over.
     */
    this.offClass = "chart";

    /**
     * css style to use when hovered over
     */
    this.onClass = "chartOn";

    /**
     * cache of the elements we have changed the style so we can restore it
     * later
     */
    this.els = [];

};

YAHOO.fortinet.DDSwap.prototype.onDragDrop = function(e, id) {
    var dd = YAHOO.util.DDM.getDDById(id);
    this.swap(this.getEl(), dd.getEl());
    this.resetConstraints();
    dd.resetConstraints();
};

YAHOO.fortinet.DDSwap.prototype.swap = function(el1, el2) {
    this.logger.log(this.id + " onDragDrop swap");

    // Swap elements if it's the last one, so swap works correctly
    if (!el2.nextSibling) {
	var tmp = el2;
	el2 = el1;
	el1 = tmp;
    }

    // IE only
    if (el2.swapNode) {
        el2.swapNode(el1);
    }
    else if (el2.nextSibling) {
        var nextSibling = el2.nextSibling;

	if (nextSibling == el1)
            el2.parentNode.insertBefore(el1, el2);
	else {
            el2.parentNode.insertBefore(el2, el1);
            nextSibling.parentNode.insertBefore(el1, nextSibling);
        }
    }
};

YAHOO.fortinet.DDSwap.prototype.onDragEnter = function(e, id) {
    this.logger.log(this.id + " dragEnter " + id);

    // store a ref so we can restore the style later
    this.els[id] = true;

    // set the mouseover style
    var el = YAHOO.util.DDM.getElement(id);
    if (el.className != this.onClass) {
        el.className = this.onClass;
    }
};

YAHOO.fortinet.DDSwap.prototype.onDragOut = function(e, id) {
    this.logger.log(this.id + " dragOut " + id);

    // restore the style
    YAHOO.util.DDM.getElement(id).className = this.offClass;
};

YAHOO.fortinet.DDSwap.prototype.endDrag = function(e) {
    this.logger.log(this.id + " endDrag");
    this.resetStyles();

    /*
        var el = this.getDragEl();
    el.style.visibility = ""; // show the element first
    var position = [100, 100];
    var duration = 0.4;
    var oAnim = new YAHOO.util.Motion( 
           el, { points: { to: position } }, duration, YAHOO.util.Easing.easeOut );

    oAnim.onComplete.subscribe( function() { el.style.visibility = "hidden" } );
*/


};

YAHOO.fortinet.DDSwap.prototype.resetStyles = function() {
    // restore all element styles
    for (var i in this.els) {
        var el = YAHOO.util.DDM.getElement(i);
        if (el) { el.className = this.offClass; }
    }
};

YAHOO.fortinet.DDSwap.prototype.onDrag = function(e) { };

YAHOO.fortinet.DDSwap.prototype.onDragOver = function(e) { };


//-------------------------------------------------------------------------
// Intersect mode
//-------------------------------------------------------------------------



YAHOO.fortinet.DDSwap_i = function(id, sGroup) {
    this.swapInit(id, sGroup);
};

YAHOO.fortinet.DDSwap_i.prototype = new YAHOO.fortinet.DDSwap();

YAHOO.fortinet.DDSwap_i.prototype.onDragDrop = function(e, dds) {
    // this.logger.log(this.id + " onDragDrop swap");
    var dd = YAHOO.util.DDM.getBestMatch(dds);
    this.swap(this.getEl(), dd.getEl());

    this.resetConstraints();
    dd.resetConstraints();
};

YAHOO.fortinet.DDSwap_i.prototype.onDragEnter = function(e, dds) { 
  // this.logger.log(this.id + " dragEnter " + id);
};

YAHOO.fortinet.DDSwap_i.prototype.onDragOver = function(e, dds) {
 
    this.resetStyles();

    var dd = YAHOO.util.DDM.getBestMatch(dds);

    this.els[dd.id] = true;

    // set the mouseover style
    var el = dd.getEl();
    if (el.className != this.onClass) {
        el.className = this.onClass;
    }
 
};

YAHOO.fortinet.DDSwap_i.prototype.onDragOut = function(e, dds) {
    // this.logger.log(this.id + " dragOut " + id);

    // restore the style
    for (var i=0; i<dds.length; ++i) {
        dds[i].getEl().className = this.offClass;
    }
};

