#
# For :   Bot Detection of Machine Learning
# Author: J
# Date:   08/14/2018
#

delimiter //
#procedure: check database name for bot db
drop procedure if exists mysql.bot_check_dbname;
create procedure mysql.bot_check_dbname(IN db_name VARCHAR(256), OUT ret int)
begin
	#DECLARE row_count int;
	set @ret = 0;
	set @cnt = 0;
	set @db_name = db_name;
	#cant select dbname from ...; must use count(*) or select a into @global_varible;
	#otherwise there are more than 1 record set;
	set @execsql = concat('select count(*) into @cnt from ml_global.bot_db_map where db_name = @db_name');  
	#select @execsql;
	prepare s1 from @execsql;
	execute s1;
	#set @row_count = FOUND_ROWS();
	deallocate prepare s1;

	if (@cnt >= 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;
//
delimiter ;

delimiter //
#procedure: insert dbname into bot_db_map
drop procedure if exists mysql.bot_insert_dbname;
create procedure mysql.bot_insert_dbname(IN policy_id bigint unsigned, IN db_name VARCHAR(256), OUT ret int)
begin
	DECLARE row_count int;
	set @ret = 0;
	set @policy_id = policy_id;
	set @db_name = db_name;
	set @execsql = concat('insert into ml_global.bot_db_map(train_start_time, policy_id, db_name, status, events) values(FROM_UNIXTIME(UNIX_TIMESTAMP()), @policy_id, @db_name, 1, 0)');  
	#select @execsql;
	prepare s1 from @execsql;
	execute s1;
	set row_count = ROW_COUNT();
	deallocate prepare s1;

	if (row_count != 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;
end;
//
delimiter ;

# Destory DB
delimiter //
# create procedure for destroing bot detection databases;
drop procedure if exists mysql.bot_destroy_db;
create procedure mysql.bot_destroy_db(IN name VARCHAR(256))
begin
	# create db
	set @str1 = concat("drop database if exists ", name);
	prepare sql1 from @str1;
	execute sql1;

	deallocate prepare sql1;
end;
//
delimiter ;

# Delete DB , real
DELIMITER //
drop procedure if exists mysql.bot_delete_db;
CREATE PROCEDURE mysql.bot_delete_db(IN db_name varchar(256),OUT ret int ) 
big_label: begin 
	DECLARE sql_str varchar(512); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @db_name = db_name;
	set @del_task_err = 0;

START TRANSACTION;
	set sql_str = concat('drop database if exists ', db_name);
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

label1:begin
	set sql_str = "";
	set sql_str = 'delete from ml_global.bot_db_map where db_name=@db_name';
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (t_error = 1) then 
		ROLLBACK; 
		set ret = -1;
		leave label1;
	end if;

	call mysql.delete_bot_task_real(@db_name, @del_task_err);
	if (t_error != 0 or @del_task_err != 0) then
		ROLLBACK; 
		set ret = -1;
		leave label1;
	end if;

	set ret = 0;
	COMMIT; 

end label1;

end big_label;//
DELIMITER ;


# Create Bot DB
delimiter //
# create procedure for bot detection databases;
drop procedure if exists mysql.bot_create_db;
create procedure mysql.bot_create_db(IN name VARCHAR(256))
begin
	DECLARE i int;

    # delete old db if exists
	set @str1 = concat('drop database if exists ', name);
	prepare sql1 from @str1;
	execute sql1;

	# create db
	set @str1 = concat("create database ", name," CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
	prepare sql1 from @str1;
	execute sql1;

	# create table db.bot_sample
	set @str1 = concat("create table if not exists ", 
			name, ".", "bot_sample(", 
			"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
			"vector VARCHAR(512) NOT NULL, ",
			"type INT NOT NULL DEFAULT 0, ",
			"identification_method INT NOT NULL DEFAULT 0, ",
			"sampling_time INT NOT NULL DEFAULT 0",
			");");
	prepare sql1 from @str1;
	execute sql1;


	# create table db.bot_model_info
    # type =>  1: Strict 2: Loose
	set @str1 = concat("create table if not exists ", 
			name, ".", "bot_model_info(", 
			"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
			"type INT NOT NULL UNIQUE, ",
			"model_info MEDIUMTEXT NOT NULL, ",
			"train_pred_info TEXT NOT NULL, ",
			"train_sample_count INT NOT NULL DEFAULT 0, ",
			"train_anomaly_count INT NOT NULL DEFAULT 0, ",
			"test_pred_info TEXT NOT NULL, ",
			"test_sample_count INT NOT NULL DEFAULT 0, ",
			"test_anomaly_count INT NOT NULL DEFAULT 0, ",
			"cross_validation FLOAT NOT NULL DEFAULT 0, ",
			"scale_param TEXT DEFAULT NULL",
			");");
	prepare sql1 from @str1;
	execute sql1;


	# create table db.bot_traffic_anomaly
	#set @str1 = concat("create table if not exists ", 
	#		name, ".", "bot_traffic_anomaly(", 
	#		"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
	#		"stat_time DATETIME NOT NULL, ",
	#		"check_count INT NOT NULL DEFAULT 0, ",
	#		"anomaly_count INT NOT NULL DEFAULT 0",
	#		");");
	#prepare sql1 from @str1;
	#execute sql1;


	# create table db.bot_detection_accuracy
	set @str1 = concat("create table if not exists ", 
			name, ".", "bot_detection_accuracy(", 
			"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
			"stat_time DATETIME NOT NULL, ",
			"anomaly_count INT NOT NULL DEFAULT 0, ",
			"bot_count INT NOT NULL DEFAULT 0, ",
			"total_count INT NOT NULL DEFAULT 0",
			");");
	prepare sql1 from @str1;
	execute sql1;

	deallocate prepare sql1;
end;
//
delimiter ;

DELIMITER //
drop procedure if exists mysql.bot_create_db_info;
create procedure mysql.bot_create_db_info(IN policy_id bigint unsigned, IN db_name VARCHAR(256), OUT ret int)
begin 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @db_name = db_name;
	set @policy_id = policy_id;
	set ret = 0;
	set @insert_dbname_error = 0;

label1:begin 
	call mysql.bot_create_db(@db_name);
	if (t_error != 0) then
		set ret = -1;
		leave label1;
	end if;

	call mysql.bot_insert_dbname(@policy_id, @db_name, @insert_dbname_error); 
	if (@insert_dbname_error != 0 or t_error != 0) then
		call mysql.bot_destroy_db(@db_name);
		set ret = -3;
		leave label1;
	end if;
END label1;

end;//
DELIMITER ;

#delete db, only set delete events
DELIMITER //
drop procedure if exists mysql.bot_delete_db_by_name;
CREATE PROCEDURE mysql.bot_delete_db_by_name(IN db_name varchar(256), OUT ret int ) 
begin 
	DECLARE sql_str varchar(512);
	DECLARE row_count int;
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @del_task_error = 0;
	set @db_name = db_name;

label1:begin
	set sql_str = "";
	set sql_str = concat('update ml_global.bot_db_map set events=1, timestamp=CURRENT_TIMESTAMP() where db_name=@db_name');
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count < 1) then
		set ret = -1;
		leave label1;
	else
		set ret = 0;
	end if;

	call mysql.delete_bot_task_by_name(@db_name, @del_task_error); 
	if (@del_task_error != 0 or t_error != 0) then
		set ret = -2;
		leave label1;
	else
		set ret = 0;
	end if;
END label1;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.bot_update_model_status;
CREATE PROCEDURE mysql.bot_update_model_status(IN policy_id bigint unsigned, IN db_name varchar(256), IN status INT, OUT ret int ) 
begin 
	DECLARE row_count int;
	DECLARE sql_str varchar(512);
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	
	set @policy_id = policy_id;

	set sql_str = "";
	set sql_str = concat("update ml_global.bot_db_map set status=", status," where policy_id=", policy_id," and db_name='", db_name, "'");
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	#set row_count = ROW_COUNT();
	deallocate prepare stmt;

	#if (row_count < 1) then
	if (t_error != 0) then 
		set ret = -1;
	else
		set ret = 0;
	end if;
end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.bot_event_delete;
CREATE PROCEDURE mysql.bot_event_delete(IN policy_id bigint unsigned, OUT ret int ) 
begin 
	DECLARE sql_str varchar(512);
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @policy_id = policy_id;

	set sql_str = "";
	set sql_str = concat('delete from ml_global.bot_event where policy_id=@policy_id');
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (t_error != 0) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;
