
DELIMITER //
drop procedure if exists mysql.bot_get_task;
CREATE PROCEDURE mysql.bot_get_task( ) 
label9:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	
	START TRANSACTION;
	
		set sql_str="";
		set sql_str=concat( 'select count(*),id,policy_id,db_name,task_type,task_parameter into @cnt,@id,@policy_id,@db_name,@task_type,@task_parameter from ml_global.bot_task_table where id=( select min(id) from ml_global.bot_task_table where task_status=0 and task_type=1 and events=0)' );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		if( @cnt <> 1 ) then
			set @ret = -1;
			select @ret;
			ROLLBACK;			
			leave label9;
		end if;

		set sql_str="";
		set sql_str=concat( "update ml_global.bot_task_table set task_status=1 where id=",@id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

	IF t_error = 1 THEN
		set @ret = -1;
		select @ret;
        	ROLLBACK;
	ELSE
		set @ret = 0;
		select @ret,@id,@policy_id,@db_name,@task_type,@task_parameter;
		COMMIT;
	END IF;

end;//
DELIMITER ;

# only set delete flag
DELIMITER //
drop procedure if exists mysql.delete_bot_task_by_name;
CREATE PROCEDURE mysql.delete_bot_task_by_name(IN db_name varchar(256), OUT ret int ) 
begin 
	DECLARE sql_str varchar(512);
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @db_name = db_name;

	set sql_str = "";
	set sql_str = concat('update ml_global.bot_task_table set events=1, timestamp=CURRENT_TIMESTAMP() where db_name=@db_name');
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (t_error != 0) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;

# real delete
DELIMITER //
drop procedure if exists mysql.delete_bot_task_real;
CREATE PROCEDURE mysql.delete_bot_task_real(IN db_name varchar(256), OUT ret int ) 
begin 
	DECLARE sql_str varchar(512);
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @db_name = db_name;

	set sql_str = "";
	set sql_str = concat('delete from ml_global.bot_task_table where db_name=@db_name');
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (t_error != 0) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;


# real delete
DELIMITER //
drop procedure if exists mysql.delete_bot_task;
CREATE PROCEDURE mysql.delete_bot_task(IN id int,OUT ret int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set sql_str = concat('delete from ml_global.bot_task_table where id=', id);

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;
end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.reset_bot_task;

CREATE PROCEDURE mysql.reset_bot_task(OUT ret int) 
label1:begin 
	DECLARE sql_str varchar(512); 

	set sql_str = concat('update ml_global.bot_task_table set task_status=0;');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	set ret = 0;
end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.submit_bot_task;

#CREATE PROCEDURE mysql.submit_bot_task(IN policy_id BIGINT UNSIGNED, IN db_name varchar(256), IN status INT, IN arg_str varchar(256), OUT ret int, OUT dmsg varchar(256)) 
CREATE PROCEDURE mysql.submit_bot_task(IN policy_id BIGINT UNSIGNED, IN db_name varchar(256), IN status INT, IN arg_str varchar(256), OUT ret int) 
label8:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	
	#START TRANSACTION;
	
	set sql_str="";
	set sql_str=concat( "update ml_global.bot_db_map set status=",status," where policy_id=",policy_id," and db_name='",db_name,"'" );
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;
    #set dmsg = @v_sql;

	set sql_str="";
	set sql_str=concat( "select count(*) into @cnt from ml_global.bot_task_table where db_name='",db_name,"' and policy_id=",policy_id);
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;
	
	if( @cnt <> 0 ) then
		set ret = -1;
        #set dmsg = @v_sql;
		#ROLLBACK;			
		leave label8;
	end if;
	
	set sql_str="";
	set sql_str=concat( "insert into ml_global.bot_task_table( policy_id,db_name,task_type,task_parameter,task_status,events ) values(" );
	set sql_str=concat( sql_str,policy_id);
	set sql_str=concat( sql_str,",'",db_name,"'");
	set sql_str=concat( sql_str,",", 1);
	set sql_str=concat( sql_str,",'",arg_str,"'");
	set sql_str=concat( sql_str,",", 0);
	set sql_str=concat( sql_str,",0)");
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	IF t_error = 1 THEN
		set ret = -2;
        #set dmsg = @v_sql;
        #ROLLBACK;

	ELSE
		set ret = 0;
		#COMMIT;
	END IF;

end;//
DELIMITER ;


