#
#
#

#test = "create table if not exists test.site_info(id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, policy_id INT NOT NULL, domain_name VARCHAR(256) NOT NULL, domain_index INT NOT NULL, db_name VARCHAR(256) NOT NULL, events INT NOT NULL);"

delimiter //
#procedure: get database name for domain
drop procedure if exists mysql.get_dbname;
create procedure mysql.get_dbname(IN policy_id bigint unsigned, IN domain_index bigint unsigned, IN domain_name VARCHAR(256))
begin
	DECLARE row_count int;
	set @dbname1 = '';
	set @dbid = 0;
	set @policy_id = policy_id;
	set @domain_index = domain_index;
	set @execsql = concat("select id, db_name into @dbid, @dbname1 from ml_global.site_info where policy_id = @policy_id and  domain_index = @domain_index and events & 1 = 0 and domain_name = '");  
	set @execsql = concat(@execsql, domain_name);
	set @execsql = concat(@execsql, "'");

	prepare s1 from @execsql;
	execute s1;
	set row_count = FOUND_ROWS();
        deallocate prepare s1;

        if (row_count != 1) then
                set @ret = -1;
        else
                set @ret = 0;
        end if;
        select @ret, @dbname1, @dbid;
end;
//
delimiter ;

delimiter //
#procedure: get  domain by id
drop procedure if exists mysql.get_domainbyid;
create procedure mysql.get_domainbyid(IN dbid int)
begin
	DECLARE row_count int;
	set @dbid = dbid;
	set @policy_id = 0;
	set @domain_index = 0;
	set @domain_name = '';
	set @dbname1 = '';
	set @execsql = concat("select db_name , policy_id , domain_name, domain_index into @dbname1, @policy_id, @domain_name, @domain_index from ml_global.site_info where id = @dbid");  
	#select @execsql;

	prepare s1 from @execsql;
	execute s1;
	set row_count = FOUND_ROWS();
        deallocate prepare s1;

	set row_count = 1;

        if (row_count != 1) then
                set @ret = -1;
        else
                set @ret = 0;
        end if;
        select @ret, @dbname1, @policy_id, @domain_name, @domain_index;
end;
//
delimiter ;



delimiter //
#procedure: check database name for domain
drop procedure if exists mysql.check_dbname;
create procedure mysql.check_dbname(IN db_name VARCHAR(256), OUT ret int)
begin
	#DECLARE row_count int;
	set @ret = 0;
	set @cnt = 0;
	set @dbexist = 0;
	set @db_name = db_name;
	#cant select dbname from ...; must use count(*) or select a into @global_varible;
	#otherwise there are more than 1 record set;
	set @execsql = concat('select count(*) into @cnt from ml_global.site_info where db_name = @db_name');  
	#select @execsql;
	prepare s1 from @execsql;
	execute s1;
	#set @row_count = FOUND_ROWS();
	deallocate prepare s1;

	if (@cnt >= 1) then
		set ret = -1;
	else
		call mysql.check_db_exists(@db_name, @dbexist);
		if(@dbexist = 0) then
			set ret = -1;
		else
			set ret = 0;
		end if;
	end if;

end;
//
delimiter ;


