DELIMITER //
drop procedure if exists mysql.finish_collect_fulfill;

CREATE PROCEDURE mysql.finish_collect_fulfill( IN arg_id int,IN dbname varchar(64),IN first_sample_id int,IN target_size int,IN sample_table varchar(64),IN sample_temp_table varchar(64),OUT ret int ) 
label7:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set @arg_id = arg_id;
	set @first_sample_id = first_sample_id;
	set @target_size = target_size;
	set @sample_table = sample_table;
	set @sample_temp_table = sample_temp_table;
	
	START TRANSACTION;
	
		call mysql.fulfill_sample( @arg_id,dbname,@sample_table,@sample_temp_table,@first_sample_id,@target_size );		

	IF t_error = 1 THEN
		set ret = -1;
        	ROLLBACK;

	ELSE
		set ret = 0;
		COMMIT;
	END IF;

end;//
DELIMITER ;

