DELIMITER //
drop procedure if exists mysql.first_rnd_cp_temp;

CREATE PROCEDURE mysql.first_rnd_cp_temp( IN arg_id int,IN dbname varchar(64),IN sample_process_count int,IN sample_table varchar(64),IN sample_temp_table varchar(64),OUT ret int )
label5:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set @arg_id = arg_id;
	set @dbname = dbname;
	set @cnt = sample_process_count;
	set @sample_table = sample_table;
	set @sample_temp_table = sample_temp_table;
	
	START TRANSACTION;
	
		set @first_sample_id=0;
		call mysql.copy_temp_samples( @arg_id,@cnt,@dbname,@sample_table,@sample_temp_table,@first_sample_id );

		set sql_str="";
		set sql_str=concat( "update ",dbname,".url_args_sample_record set sample_collect_round=1,sample_new_type=0,start_sample_id=@first_sample_id where arg_id=",@arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

	IF t_error = 1 THEN
		set ret = -2;
        	ROLLBACK;

	ELSE
		set ret = 0;
		COMMIT;
	END IF;

end;//
DELIMITER ;

