DELIMITER //
drop procedure if exists mysql.first_rnd_remove_dup;

CREATE PROCEDURE mysql.first_rnd_remove_dup( IN arg_id int,IN dbname varchar(64),IN first_sample_temp int,IN sample_table varchar(64),IN sample_temp_table varchar(64),OUT ret int ) 
label5:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set @arg_id = arg_id;
	set @first_sample_temp = first_sample_temp;
	set @sample_table = sample_table;
	set @sample_temp_table = sample_temp_table;
	
	START TRANSACTION;
	
		set sql_str="";
		set sql_str=concat( "insert into ",dbname,".",@sample_table,"( arg_id,sample_str,sample_generic_type,generic_type_hash,arg_value_len,sample_probability,iforest_value,kmeans_index, kmeans_dist, ip_type, ip_address, ip_address_hash, session_hash ) " );
		set sql_str=concat( sql_str,"select arg_id,sample_str,sample_generic_type,generic_type_hash,arg_value_len,0,0,0,0, ip_type, ip_address, ip_address_hash, session_hash from ",dbname,".",@sample_temp_table," where id in " );
		set sql_str=concat( sql_str,"( select min(id) from ",dbname,".",@sample_temp_table," where arg_id=@arg_id and id>=@first_sample_temp group by generic_type_hash having count( generic_type_hash )>=1 )" );

		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		set sql_str="";
		set sql_str=concat( 'select min(id),count(*) into @first_sample,@cnt from ',dbname,'.',@sample_table,' where arg_id=',arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		
		set sql_str="";
		set sql_str=concat( "update ",dbname,".url_args_sample_record set sample_collect_round=1,valid_sample_count=@cnt,sample_new_type=0,start_sample_id=@first_sample where arg_id=",@arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

	IF t_error = 1 THEN
		set ret = -1;
        	ROLLBACK;

	ELSE
		set ret = 0;
		COMMIT;
	END IF;

end;//
DELIMITER ;

