DELIMITER //
drop procedure if exists mysql.insert_sample;

CREATE PROCEDURE mysql.insert_sample( IN dbname varchar(64), IN tablename varchar(64), IN argid int, IN sample_str varchar(1024) CHARACTER SET utf8, IN sample_generic_type varchar(256), IN generic_type_hash int, IN arg_value_len int, IN manual_flag int, OUT insert_id int ) 
label4:begin 
	DECLARE sql_str varchar(1024); 

	set @sample_str = sample_str;
	set @sample_generic_type = sample_generic_type;
	set @arg_id = argid;
	set @arg_value_len = arg_value_len;
	set @dbname = dbname;
	set @tablename = tablename;
	set @manual_flag = manual_flag;
	set @generic_type_hash = generic_type_hash;

	set sql_str=concat("insert into ", dbname, ".",tablename,"( arg_id,sample_str,sample_generic_type,arg_value_len,generic_type_hash,sample_probability,iforest_value,manual_flag) values(@arg_id, @sample_str, @sample_generic_type, @arg_value_len, @generic_type_hash, 0,0,@manual_flag)" );

	

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	/*
	set sql_str="";
	set sql_str=concat( 'select max(id) into @last_id from ',dbname,'.url_args_sample where arg_id=',arg_id );
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;*/

	set insert_id = LAST_INSERT_ID();

	set sql_str=concat("update ", dbname, ".url_args_sample_record set valid_sample_count = valid_sample_count + 1 where arg_id=@arg_id" );
	set @v_sql=sql_str;
        prepare stmt from @v_sql;
        EXECUTE stmt;
        deallocate prepare stmt;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.delete_sample;

CREATE PROCEDURE mysql.delete_sample( IN dbname varchar(64), IN tablename varchar(64), IN argid int, IN sample_id int, IN manual_flag int) 
label4:begin 
	DECLARE sql_str varchar(1024); 

	set @sample_id = sample_id;
	set @arg_id = argid;
	set @dbname = dbname;
	set @tablename = tablename;
	set @manual_flag = manual_flag;

	set sql_str=concat("delete from ", dbname, ".",tablename," where arg_id=@arg_id and id=@sample_id and manual_flag=@manual_flag" );

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	set sql_str=concat("update ", dbname, ".url_args_sample_record set valid_sample_count = valid_sample_count - 1 where arg_id=@arg_id" );
	set @v_sql=sql_str;
        prepare stmt from @v_sql;
        EXECUTE stmt;
        deallocate prepare stmt;

end;//
DELIMITER ;

