DELIMITER //
drop procedure if exists mysql.create_url_args_info;

CREATE PROCEDURE mysql.create_url_args_info(IN db_name varchar(256), IN url_id int, IN arg_name varchar(256) CHARACTER SET utf8, IN arg_learn_stat int, IN hmm_version int, IN refresh_cnt int, OUT ret int, OUT arg_id int) 
begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set @url_id = url_id;
	set @arg_name = arg_name;
	set @arg_learn_stat = arg_learn_stat;
	set @refresh_cnt = refresh_cnt;
	set @hmm_version = hmm_version;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.url_args_info (url_id, arg_name, arg_learn_stat, hmm_version, events, refresh_cnt, timestamp) values (@url_id, @arg_name, @arg_learn_stat, @hmm_version, 0, @refresh_cnt, 0)');

START TRANSACTION; 
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	set ret = 0;

	if (row_count != 1) then
		set ret = -1;
	else
		set @id = LAST_INSERT_ID();
		if (@id <= 0) then
			set ret = -2;
		else
			call_label: BEGIN

			/* Create records in the related DB tables. */
			set @db_name = db_name;

			call mysql.create_url_args_sample_record(@db_name, @id, 0, 0, 0, 0, 0, 0,0,@url_args_sample_record_error);
			if (@url_args_sample_record_error != 0) then
				set ret = -4;
				leave call_label;
			end if;

			call mysql.create_url_args_sample_stat(@db_name, @id,0, @url_args_sample_stat_error);
			if (@url_args_sample_stat_error != 0) then
				set ret = -5;
				leave call_label;
			end if;

			set ret = 0;

			END call_label;
		end if;
	end if;

	if (ret != 0) then
		ROLLBACK;
		set arg_id = 0;
	elseif (t_error = 1) then
		ROLLBACK;
		set ret = -6;
		set arg_id = 0;
	else
		COMMIT;
		set ret = 0;
		set arg_id = @id;
	end if;
end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.update_url_args_info_stat;

CREATE PROCEDURE mysql.update_url_args_info_stat(IN db_name varchar(256), IN arg_id int, IN arg_learn_stat int,OUT ret int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @arg_learn_stat = arg_learn_stat;

	set sql_str = "";
	set sql_str = concat('update ', db_name, '.url_args_info set arg_learn_stat=@arg_learn_stat where id=', arg_id);

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;

/*
DELIMITER //
drop procedure if exists mysql.create_url_args_sample;

CREATE PROCEDURE mysql.create_url_args_sample(IN db_name varchar(256), IN arg_id int, IN sample_str varchar(256), IN sample_generic_type int, IN arg_value_len int, IN sample_probability DOUBLE, IN iforest_value DOUBLE, OUT url_args_sample_error int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @arg_id = arg_id;
	set @sample_str = sample_str;
	set @sample_generic_type = sample_generic_type;
	set @arg_value_len = arg_value_len;
	set @sample_probability = sample_probability;
	set @iforest_value = iforest_value;

	set url_args_sample_error = 0;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.url_args_sample (arg_id, sample_str, sample_generic_type, arg_value_len, sample_probability, iforest_value) values (@arg_id, @sample_str, @sample_generic_type, @arg_value_len, @sample_probability, @iforest_value)');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set url_args_sample_error = -1;
	else
		set url_args_sample_error = 0;
	end if;

end;//
DELIMITER ;
*/

DELIMITER //
drop procedure if exists mysql.create_url_args_sample_record;

CREATE PROCEDURE mysql.create_url_args_sample_record(IN db_name varchar(256), IN arg_id int, IN total_process_sample_count int, IN valid_sample_count int,IN sample_collect_round int, IN sample_new_type int,  IN start_sample_id int, IN start_sample_temp_id int,IN len_exceed_count int,OUT url_args_sample_record_error int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @arg_id = arg_id;
	set @total_process_sample_count = total_process_sample_count;
	set @valid_sample_count = valid_sample_count;
	set @sample_collect_round = sample_collect_round;
	set @sample_new_type = sample_new_type;
	set @start_sample_id = start_sample_id;
	set @start_sample_temp_id = start_sample_temp_id;
	set @len_exceed_count = len_exceed_count;
	set url_args_sample_record_error = 0;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.url_args_sample_record (arg_id, total_process_sample_count, valid_sample_count,sample_collect_round, sample_new_type, start_sample_id, start_sample_temp_id,len_exceed_count) values (@arg_id, @total_process_sample_count, @valid_sample_count,@sample_collect_round, @sample_new_type, @start_sample_id, @start_sample_temp_id,@len_exceed_count )');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set url_args_sample_record_error = -1;
	else
		set url_args_sample_record_error = 0;
	end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.create_url_args_sample_stat;

CREATE PROCEDURE mysql.create_url_args_sample_stat(IN db_name varchar(256), IN arg_id int,IN sample_collecting_stat int, OUT url_args_sample_stat_error int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @arg_id = arg_id;
	set @sample_collecting_stat = sample_collecting_stat;
	set url_args_sample_stat_error = 0;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.url_args_sample_stat (arg_id,sample_collecting_stat) values (@arg_id,@sample_collecting_stat)');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set url_args_sample_stat_error = -1;
	else
		set url_args_sample_stat_error = 0;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.insert_args_quantile_record;

CREATE PROCEDURE mysql.insert_args_quantile_record(IN db_name varchar(256), IN arg_id int, IN quantile double, IN possibility_quantile double, IN length_quantile double, IN quantile_num double, OUT ret int)
label1:begin
        DECLARE sql_str varchar(1024);
        DECLARE row_count int;

	set @arg_id = arg_id;
        set @quantile = quantile;
        set @possibility_quantile = possibility_quantile;
        set @length_quantile = length_quantile;
        set @quantile_num = quantile_num;

        set sql_str = "";
        set sql_str = concat('insert into ', db_name, '.args_quantile_record(arg_id, quantile, possibility_quantile, length_quantile, quantile_num) values '
			'(@arg_id, @quantile, @possibility_quantile, @length_quantile, @quantile_num)');

        set @v_sql=sql_str;
        prepare stmt from @v_sql;
        EXECUTE stmt;
        set row_count = ROW_COUNT();
        deallocate prepare stmt;

        if (row_count != 1) then
                set ret = -1;
        else
                set ret = 0;
        end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.insert_hmm_model;

CREATE PROCEDURE mysql.insert_hmm_model(IN db_name varchar(256), IN arg_id int, IN hmm_pi varchar(512), IN hmm_a varchar(4096), IN hmm_b varchar(4096), IN time_stamp varchar(64), IN hmm_version int, IN len_mean double, IN prob_mean double, OUT ret int)
label1:begin
        DECLARE sql_str varchar(10240);
        DECLARE row_count int;

        set @arg_id = arg_id;
        set @time_stamp = time_stamp;
        set @hmm_version = hmm_version;
        set @len_mean = len_mean;
        set @prob_mean = prob_mean;
        set @hmm_pi = hmm_pi;
        set @hmm_a = hmm_a;
        set @hmm_b = hmm_b;

        set sql_str = "";
        set sql_str = concat('insert into ', db_name, '.args_math_model(arg_id, hmm_model_pi, hmm_model_a, hmm_model_b, '
                        'hmm_version_num, length_mean_value, prob_mean_value) values (@arg_id, @hmm_pi, @hmm_a, @hmm_b, @hmm_version, @len_mean, @prob_mean)');

        set @v_sql=sql_str;
        prepare stmt from @v_sql;
        EXECUTE stmt;
        set row_count = ROW_COUNT();
        deallocate prepare stmt;

        if (row_count != 1) then
                set ret = -1;
        else
                set ret = 0;
        end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.create_sample_box_plot;
CREATE PROCEDURE mysql.create_sample_box_plot(IN db_name varchar(256), IN arg_id int, IN time_stamp varchar(64), IN is_sample int, IN q1 double, IN q2 double, IN q3 double, IN q4 double, IN q5 double, IN q6 double, IN q7 double, IN notch_top double, IN notch_bottom double, IN sample_max double, IN sample_min double, IN sample_cnt int, IN potential_anomaly_cnt int, IN definate_anomaly_cnt int, OUT ret int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @arg_id = arg_id;
	set @time_stamp = time_stamp;
	set @is_sample = is_sample;
	set @q1 = q1;
	set @q2 = q2;
	set @q3 = q3;
	set @q4 = q4;
	set @q5 = q5;
	set @q6 = q6;
	set @q7 = q7;
	set @notch_top = notch_top;
	set @notch_bottom = notch_bottom;
	set @sample_cnt = sample_cnt;
	set @potential_anomaly_cnt = potential_anomaly_cnt;
	set @definate_anomaly_cnt = definate_anomaly_cnt;
	set @sample_max = sample_max;
	set @sample_min = sample_min;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.sample_box_plot (arg_id, time_stamp, is_sample, q1, q2, q3, q4, q5, q6, q7, notch_top, notch_bottom, sample_max, sample_min, sample_cnt, potential_anomaly_cnt, definite_anomaly_cnt) values (@arg_id, @time_stamp, @is_sample, @q1, @q2, @q3, @q4, @q5, @q6, @q7, @notch_top, @notch_bottom, @sample_max, @sample_min, @sample_cnt, @potential_anomaly_cnt, @definate_anomaly_cnt)');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.delete_oldest_sample_box_plot;

CREATE PROCEDURE mysql.delete_oldest_sample_box_plot(IN db_name varchar(256), IN arg_id int, OUT ret int) 
begin
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @arg_id = arg_id;

	set sql_str = "";
	set sql_str = concat('delete from ', db_name, '.sample_box_plot where is_sample != 1 and is_sample != 2 and arg_id = ', arg_id, '  order by time_stamp asc limit 1');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;



/*
DELIMITER //
drop procedure if exists mysql.create_args_quantile_setting;

CREATE PROCEDURE mysql.create_args_quantile_setting(IN db_name varchar(256), IN arg_id int, IN quantile_potential float, IN quantile_definitely float, OUT ret int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @arg_id = arg_id;
	set @quantile_potential = quantile_potential;
	set @quantile_definitely = quantile_definitely;
	set @args_quantile_setting_error = 0;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.args_quantile_setting (arg_id, quantile_potential, quantile_definitely) values (@arg_id, @quantile_potential, @quantile_definitely)');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
		set @args_quantile_setting_error = -1;
	else
		set ret = 0;
		set @args_quantile_setting_error = 0;
	end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.create_args_iforest_setting;

CREATE PROCEDURE mysql.create_args_iforest_setting(IN db_name varchar(256), IN arg_id int, IN potential_tolerance float, IN definitely_tolerance float, OUT ret int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @arg_id = arg_id;
	set @potential_tolerance = potential_tolerance;
	set @definitely_tolerance = definitely_tolerance;
	set @args_iforest_setting_error = 0;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.args_iforest_setting (arg_id, potential_tolerance, definitely_tolerance) values (@arg_id, @potential_tolerance, @definitely_tolerance)');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
		set @args_iforest_setting_error = -1;
	else
		set ret = 0;
		set @args_iforest_setting_error = 0;
	end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.read_args_quantile_setting;

CREATE PROCEDURE mysql.read_args_quantile_setting(IN db_name varchar(256), IN arg_id int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set sql_str = "";
	set sql_str = concat('select quantile_potential, quantile_definitely into @quantile_potential, @quantile_definitely from ', db_name, '.args_quantile_setting where arg_id=', arg_id);

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set @ret = -1;
		select @ret, 0, 0;
	else
		set @ret = 0;
		select @ret, @quantile_potential, @quantile_definitely;
	end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.read_args_iforest_setting;

CREATE PROCEDURE mysql.read_args_iforest_setting(IN db_name varchar(256), IN arg_id int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set sql_str = "";
	set sql_str = concat('select potential_tolerance, definitely_tolerance into @potential_tolerance, @definitely_tolerance from ', db_name, '.args_iforest_setting where arg_id=', arg_id);

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set @ret = -1;
		select @ret, 0, 0;
	else
		set @ret = 0;
		select @ret, @potential_tolerance, @definitely_tolerance;
	end if;

end;//
DELIMITER ;
*/
