DELIMITER //
drop procedure if exists mysql.update_arg_event;

CREATE PROCEDURE mysql.update_arg_event(IN db_name varchar(256), IN arg_id int, IN event_type int,OUT ret int) 
big_label: begin 
	DECLARE row_count int;
	DECLARE sql_str varchar(512); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set @db_name = db_name;
	set @arg_id = arg_id;
	set ret = 0;

	/* 1: need to refresh; 2: need to discard; 3: discarded */
	#if (event_type != 0 && event_type != 1 && event_type != 2 && event_type !=4) then
	#	set ret = -1;
	#	select @ret;
	#	leave big_label;	
	#end if;

	set @events = event_type;
	set sql_str = "";
	set sql_str = concat('update ', @db_name, '.url_args_info set events=@events, timestamp=CURRENT_TIMESTAMP() where id=', arg_id);
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -2;
	end if;

end big_label;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.delete_arg_related_record;

CREATE PROCEDURE mysql.delete_arg_related_record(IN db_name varchar(256), IN table_name varchar(64), IN field_name varchar(64), IN arg_id int) 
begin
	DECLARE sql_str varchar(512); 

	set sql_str = "";
	set sql_str = concat('delete from ', db_name, '.', table_name,  ' where ', field_name, '=', arg_id);
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;
end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.discard_arg;

CREATE PROCEDURE mysql.discard_arg(IN db_name varchar(256), IN arg_id int, IN url_args_sample varchar(256), \
	IN url_args_sample_temp varchar(256), OUT ret int ) 
big_label: begin 

	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	call mysql.delete_arg_related_record(db_name, url_args_sample, "arg_id", arg_id);
	call mysql.delete_arg_related_record(db_name, url_args_sample_temp, "arg_id", arg_id);

	if (t_error = 1) then 
		set ret = -1;
	else
		set ret = 0;
	end if;

end big_label; //
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.delete_args_mathmodel;

CREATE PROCEDURE mysql.delete_args_mathmodel(IN db_name varchar(256), IN arg_id int) 
big_label: begin 
	DECLARE sql_str varchar(512); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

START TRANSACTION;

	call mysql.delete_arg_related_record(db_name, "args_math_model", "arg_id", arg_id);
	call mysql.delete_arg_related_record(db_name, "args_kmeans_model", "arg_id", arg_id);
	call mysql.delete_arg_related_record(db_name, "args_quantile_record", "arg_id", arg_id);
	call mysql.delete_arg_related_record(db_name, "sample_box_plot", "arg_id", arg_id);
	call mysql.delete_arg_related_record(db_name, "sample_box_plot_temp", "arg_id", arg_id);

end big_label;//
DELIMITER ;




DELIMITER //
drop procedure if exists mysql.delete_domain_db;

CREATE PROCEDURE mysql.delete_domain_db(IN db_name varchar(256),OUT ret int ) 
big_label: begin 
	DECLARE sql_str varchar(512); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @db_name = db_name;

START TRANSACTION;
	set sql_str = concat('drop database ', db_name);
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	set sql_str = "";
	set sql_str = 'delete from ml_global.site_info where db_name=@db_name';
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (t_error = 1) then 
		ROLLBACK; 
		set ret = -1;
	else 
		COMMIT; 
		set ret = 0;
	end if;
end big_label;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.update_url_event;

CREATE PROCEDURE mysql.update_url_event(IN db_name varchar(256), IN url_id int, IN event_type int,OUT ret int) 
big_label: begin 
	DECLARE row_count int;
	DECLARE sql_str varchar(512); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set ret = 0;
	
	if (event_type != 1) then
		set ret = -1;
		leave big_label;
	end if;

	set @db_name = db_name;
	set @url_id = url_id;
	set @events = event_type;

	set sql_str = "";
	set sql_str = concat('update ', @db_name, '.site_tree_table set events=@events, timestamp=CURRENT_TIMESTAMP() where id=', url_id);
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -2;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.update_http_method_event;

CREATE PROCEDURE mysql.update_http_method_event(IN db_name varchar(256), IN url_id int, OUT ret int) 
big_label: begin 
	DECLARE row_count int;
	DECLARE sql_str varchar(512); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set ret = 0;
	
	set @db_name = db_name;
	set @url_id = url_id;

	set sql_str = "";
	set sql_str = concat('update ', @db_name, '.method_learning_stat set train_start_time=CURRENT_TIMESTAMP(), train_end_time = 0 where url_id=', url_id);
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
	end if;

	call mysql.update_url_allow_method(@db_name, @url_id, "{}", 1, @url_allow_method_error);
	if (@url_allow_method_error != 0) then
		set ret = -2;
	end if;

	set @access_stat = "{'1':0,'2':0,'3':0,'4':0,'5':0,'6':0,'7':0,'8':0,'9':0,'10':0,'11':0,'12':0 }";
	call mysql.update_url_method_stat(@db_name, @url_id, @access_stat, @url_method_stat_error);
	if (@url_method_stat_error != 0) then
		set ret = -3;
	end if;

end;//
DELIMITER ;



DELIMITER //
drop procedure if exists mysql.delete_domain_by_name;

CREATE PROCEDURE mysql.delete_domain_by_name(IN policy_id bigint unsigned, IN domain_name varchar(256),OUT ret int ) 
begin 
	DECLARE events int;
	DECLARE row_count int;
	DECLARE sql_str varchar(512);
	
	set @policy_id = policy_id;
	set @domain_name = domain_name;

	set sql_str = "";
	set sql_str = concat('update ml_global.site_info set events=1, timestamp=CURRENT_TIMESTAMP() where policy_id=@policy_id and domain_name=@domain_name');
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count < 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;
end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.delete_domain_by_db_id;

CREATE PROCEDURE mysql.delete_domain_by_db_id(IN db_id int,OUT ret int ) 
begin 
	DECLARE events int;
	DECLARE row_count int;
	DECLARE sql_str varchar(512);

	set sql_str = "";
	set sql_str = concat('update ml_global.site_info set events=1, timestamp=CURRENT_TIMESTAMP() where id=', db_id);
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count < 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.delete_domain_by_policy_id;

CREATE PROCEDURE mysql.delete_domain_by_policy_id(IN policy_id bigint unsigned,OUT ret int ) 
begin 
	DECLARE events int;
	DECLARE row_count int;
	DECLARE sql_str varchar(512);

	set sql_str = "";
	set sql_str = concat('update ml_global.site_info set events=1, timestamp=CURRENT_TIMESTAMP() where policy_id=', policy_id);
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count < 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.prepare_refresh_domain;

CREATE PROCEDURE mysql.prepare_refresh_domain( IN domain_id int ) 
label24:begin 
	DECLARE row_count int;
	DECLARE sql_str varchar(512);

	set sql_str = "";
	set sql_str = concat('update ml_global.site_info set events=1, timestamp=CURRENT_TIMESTAMP() where id=', domain_id," and events=0");
	set @v_sql=sql_str;

	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count < 1) then
		set @ret = 1;
		select @ret;
		leave label24;
	end if;

	set sql_str="";
	set sql_str=concat( "select count(*),policy_id,domain_name,db_name,domain_index into @cnt,@policy_id,@domain_name,@db_name,@domain_index from ml_global.site_info where id=",domain_id );
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if( @cnt <> 1 ) then
		set @ret = -1;
		select @ret;
		leave label24;
	end if;

	set @ret = 0;
	select @ret,@policy_id,@domain_name,@db_name,@domain_index;

end;//
DELIMITER ;


