DELIMITER //
drop procedure if exists mysql.insert_args_kmeans_model;

CREATE PROCEDURE mysql.insert_args_kmeans_model( IN db_name varchar(256), IN arg_id int, IN sample_cnt int, IN clusters varchar(3072)) 
begin 
	DECLARE sql_str varchar(4096); 
	DECLARE row_count int;

	set @arg_id = arg_id;
	set @sample_cnt = sample_cnt;
	set @clusters = clusters;
	set @insert_args_km_model_error = 0;

	set sql_str = "";
	set sql_str = concat( 'insert into ',db_name,'.args_kmeans_model( arg_id,sample_cnt,clusters) values( @arg_id, @sample_cnt, @clusters)' );

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set @ret = -1;
		set @insert_args_km_model_error = -1;
	else
		set @ret = 0;
	end if;


end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.delete_args_kmeans_model;

CREATE PROCEDURE mysql.delete_args_kmeans_model( IN db_name varchar(256), IN arg_id int) 
begin 
	DECLARE sql_str varchar(512); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set @arg_id = arg_id;


	set sql_str = "";
	set sql_str = concat( 'delete from ',db_name,'.args_kmeans_model where arg_id=@arg_id');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (t_error = 1) then
		set @ret = -1;
	else
		set @ret = 0;
	end if;


end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.get_args_kmeans_model;

CREATE PROCEDURE mysql.get_args_kmeans_model( IN db_name varchar(256), IN arg_id int) 
begin 
	DECLARE sql_str varchar(512); 

	set @arg_id = arg_id;


	set sql_str = "";
	set sql_str = concat( 'select arg_id, sample_cnt, clusters from ',db_name,'.args_kmeans_model where arg_id=@arg_id');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

end;//
DELIMITER ;

