
delimiter //
# create procedure for global database
drop procedure if exists mysql.ml_create_global;
create procedure mysql.ml_create_global()
begin
	# create global database
	create database if not exists ml_global CHARACTER SET utf8 COLLATE utf8_general_ci;

	# create version_table
	set @str1 = concat("create table if not exists ",  
		"ml_global.version(", 
		"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
		"ml_version VARCHAR(512) NOT NULL",
		");");
	prepare sql1 from @str1;
	execute sql1;
	deallocate prepare sql1;

	# create bot_db_map
	set @str1 = concat("create table if not exists ",  
		"ml_global.bot_db_map(", 
		"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
		"policy_id BIGINT UNSIGNED NOT NULL, ", 
		"train_start_time DATETIME NOT NULL, ", 	
		"db_name VARCHAR(256) NOT NULL, ", 
		"status INT NOT NULL, ",
		"events INT NOT NULL, ",
		"timestamp DATETIME NOT NULL DEFAULT 0",
		");");
	prepare sql1 from @str1;
	execute sql1;
	deallocate prepare sql1;

	# create bot_version_table
	set @str1 = concat("create table if not exists ",  
		"ml_global.bot_version(", 
		"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
		"version VARCHAR(512) NOT NULL",
		");");
	prepare sql1 from @str1;
	execute sql1;
	deallocate prepare sql1;

	# create bot_event
	set @str1 = concat("create table if not exists ",  
		"ml_global.bot_event(", 
		"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
		"policy_id BIGINT UNSIGNED NOT NULL, ", 
		"from_state INT NOT NULL, ",
		"to_state INT NOT NULL, ",
		"action_source VARCHAR(128) NOT NULL, ",
		"time_stamp DATETIME NOT NULL DEFAULT 0, ",
		"reason VARCHAR(1024) NOT NULL, ",
		"type INT NOT NULL DEFAULT 0, ",
		"have_read INT NOT NULL DEFAULT 0",
		");");
	prepare sql1 from @str1;
	execute sql1;
	deallocate prepare sql1;

	# create bot_task_table
	set @str1 = concat("create table if not exists ",  
		"ml_global.bot_task_table(", 
		"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
		"policy_id BIGINT UNSIGNED NOT NULL, ", 
		"db_name VARCHAR(512) NOT NULL, ",
		"task_type INT NOT NULL, ",
		"task_parameter VARCHAR(512) NOT NULL, ",
		"task_status INT NOT NULL, ",
		"progress FLOAT NOT NULL DEFAULT 0, ",
		"events INT NOT NULL, ",
		"timestamp DATETIME NOT NULL DEFAULT 0",
		");");
	prepare sql1 from @str1;
	execute sql1;
	deallocate prepare sql1;

end;
//
delimiter ;

delimiter //
# create procedure for domain databases;
drop procedure if exists mysql.ml_destroy_domain;
create procedure mysql.ml_destroy_domain(IN name VARCHAR(256))
begin
	# create db
	set @str1 = concat("drop database ", name);
	prepare sql1 from @str1;
	execute sql1;

	deallocate prepare sql1;
end;
//
delimiter ;




delimiter //
# create procedure for domain databases;
drop procedure if exists mysql.ml_create_domain;
create procedure mysql.ml_create_domain(IN name VARCHAR(256))
begin
	DECLARE i int;

	# create db
	set @str1 = concat("create database ", name," CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
	prepare sql1 from @str1;
	execute sql1;

	# create url_args_info 
	set @str1 = concat("create table if not exists ",  
		name, ".", "url_args_info", "(", 
		"arg_id INT NOT NULL, ", 
		"prob_mean_ex DOUBLE NOT NULL DEFAULT 0,", 
		"variance_ex DOUBLE NOT NULL DEFAULT 0,",
		"PRIMARY KEY (arg_id)",
		");");
	prepare sql1 from @str1;
	execute sql1;

	set i = 0;
	while i < 16  do
		# create table db.url_args_sample_0
		set @str1 = concat("create table if not exists ", 
			name, ".", "url_args_pattern_", i, "(",
			"arg_id INT NOT NULL, ",
			"sample_str VARCHAR(1024) NOT NULL, ",
			"pattern VARCHAR(256) NOT NULL, ",
			"pattern_count INT NOT NULL, ",
			"pattern_probability DOUBLE NOT NULL DEFAULT 0, ",
			"average_probability DOUBLE NOT NULL DEFAULT 0, ",
			"noise_flag INT NOT NULL DEFAULT 0, ",
			"PRIMARY KEY (arg_id, pattern)",
			");");
		prepare sql1 from @str1;
		execute sql1;	

		set @str1 = concat("create table if not exists ", 
			name, ".", "url_args_boxplot_", i, "(", 
			"id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, ", 
			"arg_id INT NOT NULL, ", 
			"sample_str VARCHAR(1024) NOT NULL, ", 
			"pattern VARCHAR(256) NOT NULL ",
			");");
		prepare sql1 from @str1;
		execute sql1;

		set i=i+1;
	end while;


	deallocate prepare sql1;
end;
//
delimiter ;



DELIMITER //
drop procedure if exists mysql.ml_set_domain_global_info;
create procedure mysql.ml_set_domain_global_info(IN db_name VARCHAR(256), IN charset VARCHAR(64), IN charset_status int, OUT ret int)
begin 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @db_name = db_name;
	set @charset = charset;
	set @charset_status = charset_status;
	set ret = 0;
	set @record_exist = 0;

label1:begin 
	set sql_str = "";
	set sql_str = concat('select count(*) into @record_exist from ', db_name, '.site_global_info');
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (@record_exist < 1) then
		set sql_str = concat('insert into ', db_name, '.site_global_info (charset_status, charset) values (@charset_status, @charset)');
	else
		set sql_str = concat('update ', db_name, '.site_global_info set charset_status = @charset_status, charset = @charset');
	end if;
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		#when update, if same, the row_count is 0;
		if (t_error != 0) then
			set ret = -1;
		else
			set ret = 0;
		end if;
	else
		set ret = 0;
	end if;

END label1;
end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.ml_create_domain_info;
create procedure mysql.ml_create_domain_info(IN db_name VARCHAR(256), OUT ret int)
begin 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE row_count int;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @db_name = db_name;
	set ret = 0;

label1:begin 
	call mysql.ml_create_domain(@db_name);
	if (t_error != 0) then
		set ret = -1;
		leave label1;
	end if;

END label1;

end;//
DELIMITER ;



call mysql.ml_create_global();










