DELIMITER //
drop procedure if exists mysql.create_url_tree_node;

CREATE PROCEDURE mysql.create_url_tree_node(IN db_name varchar(256), IN parent_id int, IN path varchar(256) CHARACTER SET utf8, IN is_leaf int, IN is_root int, OUT ret int, OUT url_id int) 
begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	set @parent_id = parent_id;
	set @path = path;
	set @is_leaf = is_leaf;
	set @is_root = is_root;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.site_tree_table (parent_id, path, is_leaf, is_root, events, train_start_time,timestamp) values (@parent_id, @path, @is_leaf, @is_root, 0,now(),0)');

START TRANSACTION; 
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	set ret = 0;

	if (row_count != 1) then
		set ret = -1;
	else
		set @id = LAST_INSERT_ID();
		if (@id <= 0) then
			set ret = -2;
		else
			call_label: BEGIN

			if (is_leaf = 1) then
				/* Create records in the related DB tables. */
				set @db_name = db_name;

				call mysql.create_url_stats_record(@db_name, @id, NOW(), 0, 0, 0, 0, 0, @url_stats_record_error);
				if (@url_stats_record_error != 0) then
					set ret = -3;
					leave call_label;
				end if;

				call mysql.create_url_allow_method(@db_name, @id, "{}", 1, 1, @url_allow_method_error);
				if (@url_allow_method_error != 0) then
					set ret = -4;
					leave call_label;
				end if;

				/* From HTTP_METHOD_NONE (0) to HTTP_METHOD_RPC (11) */
				set @access_stat = "{'1':0,'2':0,'3':0,'4':0,'5':0,'6':0,'7':0,'8':0,'9':0,'10':0,'11':0,'12':0 }";
				call mysql.create_url_method_stat(@db_name, @id,@access_stat,@url_method_stat_error);
				if (@url_method_stat_error != 0) then
					set ret = -5;
					leave call_label;
				end if;

				call mysql.create_method_learning_stat(@db_name, @id, @method_learning_stat_error);
				if (@method_learning_stat_error != 0) then
					set ret = -6;
					leave call_label;
				end if;

			end if;

			set ret = 0;

			END call_label;
		end if;
	end if;

	if (ret != 0 || t_error = 1) then
		ROLLBACK;
		set url_id = 0;
	else
		COMMIT;
		set url_id = @id;
	end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.update_url_tree_as_leaf;
CREATE PROCEDURE mysql.update_url_tree_as_leaf(IN db_name varchar(256), IN url_id int, OUT ret int ) 
begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;
	#DECLARE t_error INTEGER DEFAULT 0;
	#DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	set @db_name = db_name;
	set @url_id = url_id;
	set sql_str = "";
	set @is_valid = 0;

START TRANSACTION; 
label1:begin 
	#valid url here 
	call mysql.valid_url( db_name,url_id,@is_valid );
	if( @is_valie < 0 ) then 
		set ret = -1;
		leave label1;
	end if;

	set ret = 0;

	call mysql.create_url_stats_record(@db_name, @url_id, NOW(), 0, 0, 0, 0, 0, @url_stats_record_error);
	if (@url_stats_record_error != 0) then
		set ret = -3;
		leave label1;
	end if;

	call mysql.create_url_allow_method(@db_name, @url_id, "{}", 1, 1, @url_allow_method_error);
	if (@url_allow_method_error != 0) then
		set ret = -4;
		leave label1;
	end if;

	/* From HTTP_METHOD_NONE (0) to HTTP_METHOD_RPC (11) */
		set @access_stat = "{'1':0,'2':0,'3':0,'4':0,'5':0,'6':0,'7':0,'8':0,'9':0,'10':0,'11':0,'12':0 }";
		call mysql.create_url_method_stat(@db_name, @url_id, @access_stat , @url_method_stat_error);
		if (@url_method_stat_error != 0) then
			set ret = -5;
			leave label1;
		end if;

	call mysql.create_method_learning_stat(@db_name, @url_id, @method_learning_stat_error);
	if (@method_learning_stat_error != 0) then
		set ret = -6;
		leave label1;
	end if;

	set sql_str = concat('update ', db_name, '.site_tree_table set is_leaf=1 where id=', url_id);
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
		leave label1;
	else
		set ret = 0;
	end if;

END label1;
	if (ret != 0) then
		ROLLBACK;
	else
		COMMIT;
	end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.create_url_stats_record;

CREATE PROCEDURE mysql.create_url_stats_record(IN db_name varchar(256), IN url_id int, IN start_time varchar(64), IN request_count int, IN potential_anomalies int, IN definitely_anomalies int,IN blocked_requests int,IN alert_requests int, OUT url_stats_record_error int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @url_id = url_id;
	set @start_time = start_time;
	set @request_count = request_count;
	#set @anomalies_count = anomalies_count;
	set @potential_anomalies = potential_anomalies;
	set @definitely_anomalies = definitely_anomalies;
	set @blocked_requests = blocked_requests;
	set @alert_requests = alert_requests;

	set url_stats_record_error = 0;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.url_stats (url_id, stat_time, request_count, potential_anomalies,definitely_anomalies, blocked_requests,alert_requests) values (@url_id, DATE_FORMAT(@start_time,\'%y-%m-%d %H:00:00\'), @request_count, @potential_anomalies,@definitely_anomalies, @blocked_requests,@alert_requests)');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set url_stats_record_error = -1;
	else
		set url_stats_record_error = 0;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.update_url_stats_record;
CREATE PROCEDURE mysql.update_url_stats_record(IN db_name varchar(256), IN url_id int, IN start_time varchar(64), IN request_count int, IN potential_anomalies int, IN definitely_anomalies int, IN blocked_requests int, IN alert_requests int, OUT ret int ) 
label1:begin 
	DECLARE sql_str varchar(1024); 
	DECLARE row_count int;
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	#valid url here 
	set @is_valid = 0;
	call mysql.valid_url( db_name,url_id,@is_valid );
	if( @is_valie < 0 ) then 
		set ret = -1;
		leave label1;
	end if;

	set @start_time = start_time;
	set @request_count = request_count;
	set @definitely_anomalies = definitely_anomalies;
	set @potential_anomalies = potential_anomalies;
	set @blocked_requests = blocked_requests;
	set @alert_requests = alert_requests;
	set @url_id = url_id;
	set @record_exist = 0;

	set sql_str = "";
	set sql_str = concat('select count(*) into @record_exist from ', db_name, '.url_stats where url_id = ', url_id, ' and timestampdiff(hour, DATE_FORMAT(stat_time,\'%y-%m-%d %H:00:00\'), DATE_FORMAT(@start_time,\'%y-%m-%d %H:00:00\')) = 0 and datediff(stat_time, @start_time) = 0');
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (@record_exist < 1) then
		set sql_str = concat('insert into ', db_name, '.url_stats (url_id, stat_time, request_count, potential_anomalies,definitely_anomalies, blocked_requests,alert_requests) values (@url_id, DATE_FORMAT(@start_time,\'%y-%m-%d %H:00:00\'), @request_count, @potential_anomalies,@definitely_anomalies, @blocked_requests,@alert_requests)');
	else
		set sql_str = concat('update ', db_name, '.url_stats set request_count = request_count + @request_count, potential_anomalies = potential_anomalies + @potential_anomalies, definitely_anomalies = definitely_anomalies + @definitely_anomalies, blocked_requests=blocked_requests + @blocked_requests, alert_requests = alert_requests + @alert_requests where url_id=', url_id, ' and timestampdiff(hour, DATE_FORMAT(stat_time,\'%y-%m-%d %H:00:00\'), DATE_FORMAT(@start_time,\'%y-%m-%d %H:00:00\')) = 0 and datediff(stat_time, @start_time) = 0' );
	end if;

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		#when update, if same, the row_count is 0;
		if (t_error != 0) then
			set ret = -1;
		else
			set ret = 0;
		end if;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.create_url_allow_method;

CREATE PROCEDURE mysql.create_url_allow_method(IN db_name varchar(256), IN url_id int, IN allow_methods varchar(512), IN method_learning_stat int, IN allow_method_mode int, OUT url_allow_method_error int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @url_id = url_id;
	set @allow_methods = allow_methods;
	set @method_learning_stat = method_learning_stat;
	set @allow_method_mode = allow_method_mode;

	set url_allow_method_error = 0;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.url_allow_method (url_id, allow_method, method_learning_stat, allow_method_mode) values (@url_id, @allow_methods, @method_learning_stat, @allow_method_mode)');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set url_allow_method_error = -1;
	else
		set url_allow_method_error = 0;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.update_url_allow_method;

CREATE PROCEDURE mysql.update_url_allow_method(IN db_name varchar(256), IN url_id int, IN allow_methods varchar(512), IN method_learning_stat int, OUT url_allow_method_error int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @url_id = url_id;
	set @allow_methods = allow_methods;
	set @method_learning_stat = method_learning_stat;

	set url_allow_method_error = 0;

	set sql_str = "";
	set sql_str = concat('update ', @db_name, '.url_allow_method set method_learning_stat=@method_learning_stat where url_id=@url_id');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;

	set sql_str = concat('update ', @db_name, '.url_allow_method set allow_method=@allow_methods, method_learning_stat=@method_learning_stat where url_id=@url_id and allow_method_mode = 1');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;

end;//
DELIMITER ;



DELIMITER //
drop procedure if exists mysql.create_url_method_stat;

CREATE PROCEDURE mysql.create_url_method_stat(IN db_name varchar(256), IN url_id int,IN access_stat varchar(256), OUT url_method_stat_error int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @url_id = url_id;
	set @access_stat = access_stat;

	set url_method_stat_error = 0;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.url_method_stat (url_id,method_access_stat ) values (@url_id, @access_stat )');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set url_method_stat_error = -1;
	else
		set url_method_stat_error = 0;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.update_url_method_stat;

CREATE PROCEDURE mysql.update_url_method_stat(IN db_name varchar(256), IN url_id int, IN access_stat varchar(256), OUT ret int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @url_id = url_id;
	set @access_stat = access_stat;

	set sql_str = "";
	set sql_str = concat('update ', db_name, '.url_method_stat set method_access_stat = @access_stat where url_id = @url_id');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set ret = -1;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.create_method_learning_stat;

CREATE PROCEDURE mysql.create_method_learning_stat(IN db_name varchar(256), IN url_id int, OUT method_learning_stat_error int) 
label1:begin 
	DECLARE sql_str varchar(512); 
	DECLARE row_count int;

	set @url_id = url_id;

	set sql_str = "";
	set sql_str = concat('insert into ', db_name, '.method_learning_stat (url_id, content_type, train_start_time, train_end_time, train_min_cnt) values(@url_id,0,0,0,0)');

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		set method_learning_stat_error = -1;
	else
		set method_learning_stat_error = 0;
	end if;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.valid_url;

CREATE PROCEDURE mysql.valid_url( IN db_name varchar(64), IN url_id int,OUT ret int ) 
label16:begin 
	DECLARE sql_str varchar(1024); 

	set sql_str="";
	set @cnt = 0;
	set @events = 0;
	set sql_str=concat( "select count(*) ,events into @cnt, @events from ",db_name,".site_tree_table where id=",url_id );
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if( @cnt <> 1 ) then
                set ret = -1;
                leave label16;
        end if;

	if( @events <> 0 ) then
                set ret = -2;
		leave label16;
        end if;	
	
	set ret = 0;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.update_site_stats;
CREATE PROCEDURE mysql.update_site_stats(IN db_name varchar(256), IN start_time varchar(64), IN http_requests int, IN ssl_requests int, IN potential_anomalies int, IN definitely_anomalies int, IN blocked_requests int, IN alert_requests int, IN http_method_violation int, OUT ret int ) 
label1:begin 
	DECLARE sql_str varchar(1024); 
	DECLARE row_count int;
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;

	#check db valid in the caller

	set @start_time = start_time;
	set @http_requests = http_requests;
	set @ssl_requests = ssl_requests;
	set @definitely_anomalies = definitely_anomalies;
	set @potential_anomalies = potential_anomalies;
	set @blocked_requests = blocked_requests;
	set @alert_requests = alert_requests;
	set @http_method_violation = http_method_violation;
	set @record_exist = 0;

	set sql_str = "";
	set sql_str = concat('select count(*) into @record_exist from ', db_name, '.site_stats where timestampdiff(hour, DATE_FORMAT(stat_time,\'%y-%m-%d %H:00:00\'), DATE_FORMAT(@start_time,\'%y-%m-%d %H:00:00\')) = 0 and datediff(stat_time, @start_time) = 0');
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if (@record_exist < 1) then
		set sql_str = concat('insert into ', db_name, '.site_stats (stat_time, http_requests,ssl_requests, potential_anomalies,definitely_anomalies, blocked_requests,alert_requests, http_method_violation) values (DATE_FORMAT(@start_time,\'%y-%m-%d %H:00:00\'), @http_requests, @ssl_requests, @potential_anomalies,@definitely_anomalies, @blocked_requests,@alert_requests, @http_method_violation)');
	else
		set sql_str = concat('update ', db_name, '.site_stats set http_requests = http_requests + @http_requests, ssl_requests = ssl_requests + @ssl_requests, potential_anomalies = potential_anomalies + @potential_anomalies, definitely_anomalies = definitely_anomalies + @definitely_anomalies, blocked_requests=blocked_requests + @blocked_requests, alert_requests = alert_requests + @alert_requests, http_method_violation = http_method_violation + @http_method_violation where timestampdiff(hour, DATE_FORMAT(stat_time,\'%y-%m-%d %H:00:00\'), DATE_FORMAT(@start_time,\'%y-%m-%d %H:00:00\')) = 0 and datediff(stat_time, @start_time) = 0' );
	end if;

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	set row_count = ROW_COUNT();
	deallocate prepare stmt;

	if (row_count != 1) then
		#when update, if same, the row_count is 0;
		if (t_error != 0) then
			set ret = -1;
		else
			set ret = 0;
		end if;
	else
		set ret = 0;
	end if;

end;//
DELIMITER ;


