DELIMITER //
drop procedure if exists mysql.process_len_exceeds;

CREATE PROCEDURE mysql.process_len_exceeds( IN arg_id int,IN db_name varchar(64),OUT ret int )
label6:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	
	START TRANSACTION;

		set sql_str=concat( 'select count(*),len_exceed_count into @cnt,@len_exceed_count from ',db_name,'.url_args_sample_record where arg_id=',arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		if( @cnt <> 1 ) then
			set ret = -1;
			ROLLBACK;
			leave label6;		
		end if;

		set @cur_count = @len_exceed_count + 1;

		set sql_str="";
		set sql_str=concat( "update ",db_name,".url_args_sample_record set len_exceed_count=@cur_count where arg_id=",arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		set ret = @cur_count;

		IF t_error = 1 THEN
			set ret = -2;
        		ROLLBACK;

		ELSE
			COMMIT;
		END IF;

end;//
DELIMITER ;

