DELIMITER //
drop procedure if exists mysql.process_sub_round;

CREATE PROCEDURE mysql.process_sub_round( IN arg_id int,IN sample_str varchar(512) CHARACTER SET utf8,IN sample_generic_type varchar(256),IN arg_value_len int,IN db_name varchar(64),IN round_size int,IN round_num int,OUT ret int ) 
label6:begin 
	DECLARE sql_str varchar( 1024 ); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;
	
	START TRANSACTION;

		if( round_num <= 0 ) then
			set ret = -1;
			ROLLBACK;
			leave label6;
		end if;
	
		set sql_str="";
		set sql_str=concat( 'select count(*),start_sample_id,start_sample_temp_id,total_process_sample_count into @cnt,@start_sample_id,@start_sample_temp_id,@process_count from ',db_name,'.url_args_sample_record where arg_id=',arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;

		if( @cnt <> 1 ) then
			set ret = -2;
			ROLLBACK;
			leave label6;		
		end if;

		set @ins_id = 0;
		call mysql.insert_sample_temp( arg_id,sample_str,sample_generic_type,arg_value_len,db_name,@ins_id );
		
		/*
		set @total_count=@process_count + 1;
		set sql_str=concat( "update ",db_name,".url_args_sample_record set total_process_sample_count=",@total_count," where arg_id=",arg_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;*/


		set @dup_count = round_num;
		
		set sql_str="";
		set sql_str=concat( "select count(*) into @cnt from ",db_name,".url_args_sample where arg_id=",arg_id," and sample_generic_type='",sample_generic_type,"'" );
		set sql_str=concat( sql_str," and id>=",@start_sample_id );
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;
		
		if( @cnt > @dup_count ) then
			set ret = 1;
			COMMIT;
			leave label6;
		end if;

		if( @cnt = 0 ) then
			set sql_str="";
			set sql_str=concat( "update ",db_name,".url_args_sample_record set sample_new_type=1 where arg_id=",arg_id );
			set @v_sql=sql_str;
			prepare stmt from @v_sql;
			EXECUTE stmt;
			deallocate prepare stmt;
		end if;

		set  @ins_id = 0;
		call mysql.insert_sample( arg_id,sample_str,sample_generic_type,arg_value_len,db_name,@ins_id );

		IF t_error = 1 THEN
			set ret = -4;
        		ROLLBACK;

		ELSE
			set ret = 0;
			COMMIT;
		END IF;

end;//
DELIMITER ;

