DELIMITER //
drop procedure if exists mysql.get_db_name;

CREATE PROCEDURE mysql.get_db_name( IN domain_id int,OUT db_name varchar(64) ) 
label12:begin 
	DECLARE sql_str varchar(1024); 

	set sql_str="";
	set sql_str=concat( "select count(*),db_name,events into @cnt,@gname,@events from ml_global.site_info where id=",domain_id );
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if( @cnt <> 1 ) then
                set db_name = NULL;
                leave label12;
        end if;

	if( @events <> 0 ) then
                set db_name = NULL;
		leave label12;
        end if;	
	
	set db_name = @gname;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.check_url_arg_stat;

CREATE PROCEDURE mysql.check_url_arg_stat( IN db_name varchar(64), IN url_id int,IN arg_id int,OUT ret int ) 
label13:begin 
	DECLARE sql_str varchar(1024); 

	set sql_str="";
	set sql_str=concat( "select count(*),events into @cnt,@events from ",db_name,".site_tree_table where id=",url_id );
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if( @cnt <> 1 ) then
                set ret = -1;
                leave label13;
        end if;

	if( @events <> 0 ) then
                set ret = -2;
		leave label13;
        end if;	

	set sql_str="";
	set sql_str=concat( "select count(*),events into @cnt,@events from ",db_name,".url_args_info where id=",arg_id );
	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if( @cnt <> 1 ) then
                set ret = -3;
                leave label13;
        end if;

	if( @events <> 0  ) then
                set ret = -4;
		leave label13;
        end if;	

	set ret = 0;

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.check_arg_conf_change;

CREATE PROCEDURE mysql.check_arg_conf_change( IN domain_id int,IN url_id int,IN arg_id int,IN det_type int,IN pvalue float,IN dvalue float,OUT ret int ) 
label14:begin 
	DECLARE sql_str varchar(1024); 

	set @db_name = "";
	call mysql.get_db_name( domain_id,@db_name );

	if( @db_name is null ) then 
		set ret = -1;
		leave label14;
	end if;

	set @ck_rst = 0;
	call mysql.check_url_arg_stat( @db_name, url_id ,arg_id,@ck_rst );

	if( @ck_rst <> 0 ) then
		set ret = -2;
		leave label14;
	end if;
	
	set sql_str="";

	if( det_type = 1 ) then 
		set sql_str=concat( "select count(*),quantile_potential,quantile_definitely into @cnt,@pv,@dv from ",@db_name,".args_quantile_setting where arg_id=",arg_id );
	else
--		set sql_str=concat( "select count(*),potential_tolerance,definitely_tolerance into @cnt,@pv,@dv from ",@db_name,".args_iforest_setting where arg_id=",arg_id );
		set sql_str=concat( "select count(*),potential_tolerance,definitely_tolerance into @cnt,@pv,@dv from ",@db_name,".args_kmeans_setting where arg_id=",arg_id );
	end if;

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if( @pv=pvalue and @dv=dvalue ) then
		set ret = 1;
		leave label14;
	end if;

	set ret=0;

end;//
DELIMITER ;




DELIMITER //
drop procedure if exists mysql.update_arg_conf;

CREATE PROCEDURE mysql.update_arg_conf( IN domain_id int,IN url_id int,IN arg_id int,IN det_type int,IN pvalue float,IN dvalue float,OUT ret int ) 
label15:begin 
	DECLARE sql_str varchar(1024); 

	set @db_name = "";
	call mysql.get_db_name( domain_id,@db_name );

	if( @db_name is null ) then 
		set ret = -1;
		leave label15;
	end if;

	
	set sql_str="";
	
	if( det_type = 1 ) then 
		set sql_str=concat( "select count(*) into @cnt from ",@db_name,".args_quantile_setting where arg_id=",arg_id );
	else
--		set sql_str=concat( "select count(*) into @cnt from ",@db_name,".args_iforest_setting where arg_id=",arg_id );
		set sql_str=concat( "select count(*) into @cnt from ",@db_name,".args_kmeans_setting where arg_id=",arg_id );
	end if;

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	if( @cnt = 0 )	then 
		if( det_type = 1 ) then
			set sql_str=concat( "insert into ",@db_name,".args_quantile_setting( arg_id,quantile_potential,quantile_definitely) values (" );
			set sql_str=concat( sql_str,arg_id,"," );
			set sql_str=concat( sql_str,pvalue,"," );
			set sql_str=concat( sql_str,dvalue,")" );
		else
--			set sql_str=concat( "insert into ",@db_name,".args_iforest_setting( arg_id,potential_tolerance,definitely_tolerance) values (" );
			set sql_str=concat( "insert into ",@db_name,".args_kmeans_setting( arg_id,potential_tolerance,definitely_tolerance) values (" );
			set sql_str=concat( sql_str,arg_id,"," );
			set sql_str=concat( sql_str,pvalue,"," );
			set sql_str=concat( sql_str,dvalue,")" );
		end if;

		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;
	end if;

	if( @cnt <> 0 ) then
		if( det_type = 1 ) then
			set sql_str=concat( "update ",@db_name,".args_quantile_setting set quantile_potential=",pvalue,",quantile_definitely=",dvalue );
			set sql_str=concat( sql_str," where arg_id=",arg_id );
		else
--			set sql_str=concat( "update ",@db_name,".args_iforest_setting set potential_tolerance=",pvalue,",definitely_tolerance=",dvalue );
			set sql_str=concat( "update ",@db_name,".args_kmeans_setting set potential_tolerance=",pvalue,",definitely_tolerance=",dvalue );
			set sql_str=concat( sql_str," where arg_id=",arg_id );
		end if;
	
		set @v_sql=sql_str;
		prepare stmt from @v_sql;
		EXECUTE stmt;
		deallocate prepare stmt;
	
	end if;

	set ret=0;

end;//
DELIMITER ;


DELIMITER //
drop procedure if exists mysql.discard_argument;

CREATE PROCEDURE mysql.discard_argument( IN domain_id int,IN url_id int,IN arg_id int,OUT ret int ) 
label15:begin 
	DECLARE sql_str varchar(1024); 
	DECLARE t_error INTEGER DEFAULT 0;
	DECLARE CONTINUE HANDLER FOR SQLEXCEPTION SET t_error=1;


	set @db_name = "";
	call mysql.get_db_name( domain_id,@db_name );

	if( @db_name is null ) then 
		set ret = -1;
		leave label15;
	end if;

	set @ck_rst = 0;
	call mysql.check_url_arg_stat( @db_name, url_id ,arg_id,@ck_rst );

	if( @ck_rst <> 0 ) then
		set ret = -2;
		leave label15;
	end if;

	set @process_error = 0;
	set @result = 0;

	START TRANSACTION;
		call mysql.update_url_args_info_stat( @db_name,arg_id,5,@result );
		
		if( @result = 0 ) then 
			set @process_error = 0;
		end if;

		call mysql.update_arg_event( @db_name,arg_id,2,@result );
	
		if( @result = 0 ) then 
			set @process_error = 0;
		end if;

	if( @process_error > 0 ) then
		set ret = -4;
		ROLLBACK;
		leave label15;
	end if;

	IF t_error = 1 THEN
		set ret = -3;
		ROLLBACK;
	ELSE
		set ret = 0;
		COMMIT;
        END IF;	

end;//
DELIMITER ;

DELIMITER //
drop procedure if exists mysql.remove_arg_conf;

CREATE PROCEDURE mysql.remove_arg_conf( IN domain_id int,IN url_id int,IN arg_id int,IN det_type int,OUT ret int ) 
label15:begin 
	DECLARE sql_str varchar(1024); 

	set @db_name = "";
	call mysql.get_db_name( domain_id,@db_name );

	if( @db_name is null ) then 
		set ret = -1;
		leave label15;
	end if;

	
	set sql_str="";
	
	if( det_type = 1 ) then 
		set sql_str=concat( "delete from ",@db_name,".args_quantile_setting where arg_id=",arg_id );
	else
--		set sql_str=concat( "delete from ",@db_name,".args_iforest_setting where arg_id=",arg_id );
		set sql_str=concat( "delete from ",@db_name,".args_kmeans_setting where arg_id=",arg_id );
	end if;

	set @v_sql=sql_str;
	prepare stmt from @v_sql;
	EXECUTE stmt;
	deallocate prepare stmt;

	set ret=0;

end;//
DELIMITER ;



